<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Contabilidad_model extends CI_Model {
         
    private $TControles = array(
        array('ID' => 0, 'Name' => 'Ninguno'),
        array('ID' => 1, 'Name' => 'Banco'),
        array('ID' => 2, 'Name' => 'CxC/CxP'),
        array('ID' => 3, 'Name' => 'Impuesto'),
        array('ID' => 4, 'Name' => 'Inventario'),
        array('ID' => 5, 'Name' => 'Activo Fijo'),
        array('ID' => 6, 'Name' => 'Utilidades del Ejercicio'),
        array('ID' => 7, 'Name' => 'Pérdidas del Ejercicio'),
        array('ID' => 10, 'Name' => 'Ingresos de Operación'),
        array('ID' => 11, 'Name' => 'Rebaja y Devoluciones S/Ventas'),  
        array('ID' => 12, 'Name' => 'Otros Ingresos'),
        array('ID' => 20, 'Name' => 'Costos de Ventas'),
        array('ID' => 25, 'Name' => 'Gastos de Ventas'),
        array('ID' => 40, 'Name' => 'Gastos de Administración'),
        array('ID' => 41, 'Name' => 'Gastos No Operativos'),
        array('ID' => 30, 'Name' => 'Ingresos No Operativos'),
    );
    #private $db_b;
    public function __construct(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }
        
        $CI =& get_instance();
        $this->db_b = $CI->load->database('user_db', TRUE);

        $this->load->dbutil($this->db_b);
        if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
            echo 'Incorrect database information provided';
        }
    }
    private function validatePermiso() {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) redirect('CerrarSesion');
        else return true;
    }
    #   NOMBRE DE EMPRESA
    public function nombreEmpresa()
    {
        if($this->validatePermiso()) {
            return $this->db_b->where("valor_num", 1)->where("nombre", 'g_empdatos')->get("gvars")->row();
        }
    }
    #   NOMBRE DE REPORTES BALANCES
    public function Representantes()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            /*$this->db_b->select("valor_txt");
            $this->db_b->from("gvars");//*/
            $d1 = $this->db_b->where("nombre", 'conta_rlegal')->get("gvars")->row();
            $d2 = $this->db_b->where("nombre", 'conta_contador')->get("gvars")->row();
            $d3 = $this->db_b->where("nombre", 'conta_auditor')->get("gvars")->row();
            //return [$d1->valor_txt.'-'.$d1->nombre, $d2->valor_txt.'-'.$d2->nombre, $d3->valor_txt.'-'.$d3->nombre];
            return [$d1->valor_txt, $d2->valor_txt, $d3->valor_txt];
        }
    }
    #   GET CANTIDAD DE CARACTERES DE CUENTA PARA CREAR
    public function CantCaracteres()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            return $this->db_b->where("nombre", 'conta_maxcta')->get("gvars")->row();
        }
    }
    #   MULTIFUNCIONES DE CONTABILIDAD 
    public function multiplesContabilidad($opc, $extra = null) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $datos = [];
            switch ($opc) {
                case -1:#   GET VARIABLE
                    $datos = $this->db_b->where($extra['campo'], $extra['valor'])->get("gvars")->row();
                break;
                case 0:#   VARIABLE DE ASISTENTE CONTABLE
                    $config = $this->db_b->where("nombre", $extra['nombre'])->get("gvars")->row();
                    if (count((array)$config) > 0) $datos = $config;
                    else {
                        $data = array(
                            'nombre' => $extra['nombre'],
                            'descripcion' => $extra['descripcion'],
                            'valor_num' => 0,
                            'valor_txt' => '',
                            'valor_logico' => 0,
                            'valor_memo' => '',
                            'tipo_valor' => 2,
                            'filtro' => '',
                            'whodidit' => $this->session->userdata('iduser'),
                            'ingresa' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $this->db_b->insert('gvars', $data);
                        $data['idrnum'] = $this->db_b->insert_id();
                        $datos = (object)$datos;
                    }
                break;
                case 1:#  GET CUENTA SIMPLE x ID
                    $datos = $this->db_b->where("idrec", $extra)->get("ctcuenta")->row();
                break;
                case 2:#   SET
                    if ($this->db_b->insert($extra['tabla'], $extra['data'])) $datos =$this->db_b->insert_id();
                    else $datos = false;
                break;
                case 3:#   GET
                    $datos = $this->db_b->where($extra['campo'], $extra['valor'])->get($extra['tbl'])->row();
                break;
                case 4:#   UPDATE
                    $this->db_b->where($extra['campo'], $extra['valor']);
                    if ($this->db_b->update($extra['tabla'], $extra['data'])) $datos = true;
                    else $datos = false;
                break;
                case 5:#   DELETE
                    $this->db_b->where($extra['campo'], $extra['valor']);
                    $this->db_b->delete($extra['tabla']);
                    $datos = true;
                break;
                case 6:#   GET CENTROS ACTIVOS
                    $where = [
                        '(estatus = 1)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("idcentro, descrip, tipo");
                    $this->db_b->from("invsites");
                    $this->db_b->where($where);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                case 7:#   GET TIPOS AUXILIARES - TIPOS PRODUCTOS
                    $where = [
                        '(nombre = "'.$extra.'")',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("descripcion, valor_num");
                    $this->db_b->from("gvars");
                    $this->db_b->where($where);
                    $this->db_b->order_by("descripcion", "ASC");
                    $this->db_b->order_by("idrnum", "DESC");
                    $datos = $this->db_b->get();
                break;
                case 8:#  BORRAR REGISTROS DE TABLA
                    $this->db_b->truncate($extra);
                    $datos = true;
                break;
                case 9:#   GET TIPOS DE AUXILIARES
                    $this->db_b->select("descripcion, valor_num, filtro");
                    $this->db_b->from("gvars");
                    $this->db_b->where('nombre','auxi_def');
                    $this->db_b->order_by("descripcion", "ASC");
                    $datos = $this->db_b->get();
                break;
                case 10: #  GRUPOS - GIRO - LIMITE - DIAS
                    $this->db_b->select($extra['campo'].' as campo');
                    $this->db_b->from("ctauxi");
                    if (strlen($extra['where']) > 0) $this->db_b->where($extra['where']);
                    $this->db_b->group_by($extra['campo']);
                    $this->db_b->order_by($extra['campo'], "ASC");
                    $datos = $this->db_b->get();
                break;
                case 11: #  GESTORES ACTIVOS
                    $this->db_b->select("idauxi, descrip");
                    $this->db_b->from("ctauxi");
                    $this->db_b->where("idauxidef", $extra);
                    $this->db_b->where("estado", 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                case 12: #  DEPARTAMENTOS
                    $this->db_b->select("idzip, municipio, depto");
                    $this->db_b->from("gzips");
                    //$this->db_b->where("pais", "EL SALVADOR");
                    $this->db_b->order_by("depto", "ASC");
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CATALOGO DE CUENTAS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CATALOGO DE CUENTAS MEJORA --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET CUENTAS
    public function getCuentasN($grupo) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview, xpos");
            $this->db_b->from("ctcuenta");
            if($grupo != 9) $this->db_b->where('catgrupo',$grupo);
            $this->db_b->where('tipocuenta !=',3);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'cuenta' => $dato->idctcuenta,
                        'titulo' => $dato->descrip,
                        'tipoCuenta' => $dato->tipocuenta,
                        'permisoMov' => ($dato->tipocuenta == 1) ? false : ((strlen($dato->idctcuenta) >= (int)$this->CantCaracteres()->valor_num) ? true : false),
                        'mayoriza' => $dato->ctmayoriza,
                        'control' => $dato->ctcontrol,
                        'controlTx' => array_search($dato->ctcontrol, array_column($this->TControles,'ID', 'Name')),
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activa' : 'Inactiva',
                        'grupo' => $dato->catgrupo,
                        'xpos' => $dato->xpos,
                        'mostrarBG' => ($dato->balview == 1) ? true : false,
                        'idParent' => ($dato->ctmayoriza == "") ? -1 : $dato->ctmayoriza, 
                    );
                }
            }

            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, useauxi, askidcentro, estatus, balview, xpos");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('tipocuenta =', 3);
            if($grupo != 9) $this->db_b->where('catgrupo',$grupo);
            $this->db_b->order_by("idctcuenta", "ASC");

            $subcuentas = $this->db_b->get();

            if ($subcuentas->num_rows() > 0) {
                foreach ($subcuentas->result() as $subcuenta) {
                    $tauxiliar = '';
                    if (strlen(trim($subcuenta->useauxi)) > 0) {
                        $dauxiliar = $this->getDTCAuxiliar($subcuenta->useauxi);
                        $tauxiliar = (explode(',', $subcuenta->useauxi)[0] == 1) ? '(AUX) '.$dauxiliar->descripcion : '(PRO) '.$dauxiliar->descripcion;
                    }
                    if( $subcuenta->ctmayoriza != ""){
                        $idParent = explode(",", $subcuenta->ctmayoriza);
                        $idParent = $idParent[0];    
                    }else{
                        $arrayStr = str_split($subcuenta->idctcuenta);
                        $idParent = $arrayStr[0];
                    }
                   
                    $Datos[] = array(
                        'id' => $subcuenta->idrec,
                        'cuenta' => $subcuenta->idctcuenta,
                        'titulo' => $subcuenta->descrip,
                        'tipoCuenta' => $subcuenta->tipocuenta,
                        'mayoriza' => $subcuenta->ctmayoriza,
                        'control' => $subcuenta->ctcontrol,
                        'controlTx' => array_search($subcuenta->ctcontrol, array_column($this->TControles,'ID', 'Name')),
                        'tauxiliar' => $tauxiliar,
                        'hcentros' => (strlen(trim($subcuenta->askidcentro)) > 0) ? 'Si' : 'No',
                        'estado' => $subcuenta->estatus,
                        'estadoTx' => ($subcuenta->estatus == 1) ? 'Activa' : 'Inactiva',
                        'grupo' => $subcuenta->catgrupo,
                        'xpos' => $subcuenta->xpos,
                        'mostrarBG' => ($subcuenta->balview == 1) ? true : false,
                        'idParent' => $idParent, 
                    );
                }
            }
            
            $idcuentas = array_column($Datos, 'cuenta');
            array_multisort($idcuentas, SORT_ASC, $Datos);

            return $Datos;
        }
    }
    public function verificarCuentaExiste($cuenta){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('idctcuenta', $cuenta);
     
            $datos = $this->db_b->get()->num_rows();
            if($datos == 0){
                return false;
            }
            return true;
        }
    }
    /*
    public function getCuentasN($grupo) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            if($grupo != 9) $this->db_b->where('catgrupo',$grupo);
            $this->db_b->where('tipocuenta !=',3);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'cuenta' => $dato->idctcuenta,
                        'titulo' => $dato->descrip,
                        'tipoCuenta' => $dato->tipocuenta,
                        'permisoMov' => ($dato->tipocuenta == 1) ? false : ((strlen($dato->idctcuenta) >= (int)$this->CantCaracteres()->valor_num) ? true : false),
                        'mayoriza' => $dato->ctmayoriza,
                        'control' => $dato->ctcontrol,
                        'controlTx' => array_search($dato->ctcontrol, array_column($this->TControles,'ID', 'Name')),
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activa' : 'Inactiva',
                        'grupo' => $dato->catgrupo,
                        'mostrarBG' => ($dato->balview == 1) ? true : false,
                    );
                }
            }
            return $Datos;
        }
    }*/

    public function getCtCuentas($catgrupo, $tipocuenta){

        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, useauxi");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('catgrupo', $catgrupo);
            $this->db_b->where('tipocuenta', $tipocuenta);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get()->result_array();
           
            return $datos;
        }
    }
    #   GET CUENTAS DETALLE
    public function getCuentasDetalleN($padre)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, useauxi, askidcentro, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('POSITION("'.$padre.'," IN  ctmayoriza) =', 1);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $tauxiliar = '';
                    if (strlen(trim($dato->useauxi)) > 0) {
                        $dauxiliar = $this->getDTCAuxiliar($dato->useauxi);
                        $tauxiliar = (explode(',', $dato->useauxi)[0] == 1) ? '(AUX)'.$dauxiliar->descripcion : '(PRO)'.$dauxiliar->descripcion;
                    }
                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'cuenta' => $dato->idctcuenta,
                        'titulo' => $dato->descrip,
                        'tipoCuenta' => $dato->tipocuenta,
                        'mayoriza' => $dato->ctmayoriza,
                        'control' => $dato->ctcontrol,
                        'controlTx' => array_search($dato->ctcontrol, array_column($this->TControles,'ID', 'Name')),
                        'tauxiliar' => $tauxiliar,
                        'hcentros' => (strlen(trim($dato->askidcentro)) > 0) ? 'Si' : 'No',
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activa' : 'Inactiva',
                        'grupo' => $dato->catgrupo,
                        'mostrarBG' => ($dato->balview == 1) ? true : false,
                    );
                }
            }
            return $Datos;
        }
    }
    public function getDTCAuxiliar($dato)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $dato = explode(',', $dato);
            if ($dato[0] == "1") return $this->db_b->where("valor_num", $dato[1])->where("nombre", 'auxi_def')->get("gvars")->row();
            else return $this->db_b->where("valor_num", $dato[1])->where("nombre", 'gv_protipo')->get("gvars")->row();
        }
    }
    #   VALIDACION DE CODIGOS DE CUENTA
    public function ValidationCuenta($codigo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            return $this->db_b->where("idctcuenta", $codigo)->get("ctcuenta")->num_rows();
        }
    }
    public function ValidationCuenta2($codigo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            return $this->db_b->where("idctcuenta", $codigo)->where("(tipocuenta = 1 OR tipocuenta = 2)")->get("ctcuenta")->num_rows();
        }
    }
    #   GET DATA GENERAL
    public function getDataC($tipo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            switch ($tipo) {
                //  AUXILIARES
                case 0:
                    $this->db_b->select("descripcion, valor_num");
                    $this->db_b->from("gvars");
                    $this->db_b->where('nombre','auxi_def');
                    $this->db_b->order_by("descripcion", "ASC");
                    $data = $this->db_b->get();
                break;
                //  PRODUCTOS
                case 1:
                    $this->db_b->select("descripcion, valor_num");
                    $this->db_b->from("gvars");
                    $this->db_b->where('nombre','gv_protipo');
                    $this->db_b->order_by("descripcion", "ASC");
                    $data = $this->db_b->get();
                break;
                //  CENTROS DE COSTOS
                case 2:
                    $this->db_b->select("idcentro, descrip, tipo");
                    $this->db_b->from("invsites");
                    $this->db_b->where('estatus', 1);
                    $this->db_b->order_by("idcentro", "DESC");
                    
                    $data = $this->db_b->get();
                    //$this->db_b->group_by("tipo");
                break;
                //  USUARIOS
                case 3:
                    $this->db_b->select("iduser, descrip");
                    $this->db_b->from("gusers");
                    $this->db_b->where('estado', 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $data = $this->db_b->get();
                break;
                //  ETIQUETAS
                case 4:
                    $this->db_b->select("xpos");
                    $this->db_b->from("ctcuenta");
                    $this->db_b->group_by("xpos");
                    $this->db_b->order_by("xpos", "ASC");
                    $data = $this->db_b->get()->result_array();
                break;
                default:
                    $data = false;
                break;
            }
            return $data;
        }
    }
    # OPCIONES
    public function opcionesCuentasN($opc, $extra = null)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   VER SI LA CUENTA ESTA SIENDO USADA
                case 0:
                    $data = 0;
                    # 0 - NO usada
                    # 1 - (tipos de partidas) usada como asistente contable
                    # 2 - (0-1) en una partida detalle
                    # 3 - usada en el Asistente Contable
                    
                    #   ASISTENTE - solo cuando se cambie el estado
                    if (strpos($extra['cambios'], "1") !== false) {
                        $tpartidas = $this->db_b->where('(length(haber_ct) > 0) OR (length(debe_ct) > 0)')->get("ctpdef");
                        if ($tpartidas->num_rows() > 0) {
                            $cuentasUsadas = [];
                            foreach($tpartidas->result() as $tpartida) {
                                if (strlen($tpartida->debe_ct) > 0) $cuentasUsadas = array_merge($cuentasUsadas, explode(',', $tpartida->debe_ct));
                                if (strlen($tpartida->haber_ct) > 0) $cuentasUsadas = array_merge($cuentasUsadas, explode(',', $tpartida->haber_ct));
                            }
                            if (count($cuentasUsadas) > 0) {
                                $cfound = array_search($extra['cuenta'], $cuentasUsadas);
                                if ($cfound !== false) $data = 1;
                            }
                        }
                    }
                    #   PARTIDA DETALLE
                    if ($data == 0) {
                        $where = [
                            '(idctcuenta = "'.$extra['cuenta'].'")',
                            '((estatus = 0) OR (estatus = 1))'
                        ];
                        $where = implode(' AND ', $where);
                        $cuentasUsadas = $this->db_b->where($where)->get("ct_100d")->num_rows();
                        if ($cuentasUsadas > 0) $data = 2;
                    }
                    #   PARTIDA DE ASISTENTE CONTABLE
                    if ($data == 0) {
                        $where = [
                            '((estatus = 0) OR (estatus = 1))',
                            '('.implode(' OR ', [
                                '(origen like "AC_Pagos")',
                                '(origen like "AC_Abonos")'
                            ]).')'
                        ];
                        $where = implode(' AND ', $where);
                        $partidas = $this->db_b->where($where)->get("ct_100");
                        if ($partidas->num_rows() > 0) {
                            foreach($partidas->result() as $partida) {
                                $porigen = explode("/", $partida->origen);
                                if (trim($porigen[3]) == trim($extra['cuenta'])) {
                                    $data = 3;
                                    break;
                                }
                            }
                        }
                    }

                    #   SOLO SI LO UNICO QUE QUIERE CAMBIAR ES EL ESTAOD
                    if ($extra['cambios'] == '1') {
                        $saldoActual = 0;
                        $where = [
                            '(idctcuenta = "'.$extra['cuenta'].'")',
                            '((estatus = 0) OR (estatus = 1))'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select('SUM(debe) as debe, SUM(haber) as haber');
                        $this->db_b->from('ct_100d');
                        $this->db_b->where($where);
                        $this->db_b->group_by('idctcuenta');
                        $dato = $this->db_b->get()->row();

                        if (count((array)$dato) > 0) $saldoActual = $dato->debe - $dato->haber;

                        if ($saldoActual == 0) $data = 0;
                        else {
                            $data = 4;
                        }
                    }
                break;
                default:
                    $data = false;
                break;
            }
            return $data;
        }
    }

    public function verificarCuentaEsUsada($opc, $extra = null)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   VER SI LA CUENTA ESTA SIENDO USADA
                case 0:
                    $data = 0;
                    # 0 - NO usada
                    # 1 - (tipos de partidas) usada como asistente contable
                    # 2 - (0-1) en una partida detalle
                    # 3 - usada en el Asistente Contable
                    
                    #   ASISTENTE - solo cuando se cambie el estado
                    if (strpos($extra['cambios'], "1") !== false) {
                        $tpartidas = $this->db_b->where('(length(haber_ct) > 0) OR (length(debe_ct) > 0)')->get("ctpdef");
                        if ($tpartidas->num_rows() > 0) {
                            $cuentasUsadas = [];
                            foreach($tpartidas->result() as $tpartida) {
                                if (strlen($tpartida->debe_ct) > 0) $cuentasUsadas = array_merge($cuentasUsadas, explode(',', $tpartida->debe_ct));
                                if (strlen($tpartida->haber_ct) > 0) $cuentasUsadas = array_merge($cuentasUsadas, explode(',', $tpartida->haber_ct));
                            }
                            if (count($cuentasUsadas) > 0) {
                                $cfound = array_search($extra['cuenta'], $cuentasUsadas);
                                if ($cfound !== false) $data = 1;
                            }
                        }

                    }

                    #   PARTIDA DETALLE
                    if ($data == 0) {
                        $where = [
                            '(idctcuenta = "'.$extra['cuenta'].'")',
                            '((estatus = 0) OR (estatus = 1))'
                        ];
                        $where = implode(' AND ', $where);
                        $cuentasUsadas = $this->db_b->where($where)->get("ct_100d")->num_rows();
                        if ($cuentasUsadas > 0) $data = 2;
                    }
                    #   PARTIDA DE ASISTENTE CONTABLE
                    if ($data == 0) {
                        $where = [
                            '((estatus = 0) OR (estatus = 1))',
                            '('.implode(' OR ', [
                                '(origen like "AC_Pagos")',
                                '(origen like "AC_Abonos")'
                            ]).')'
                        ];
                        $where = implode(' AND ', $where);
                        $partidas = $this->db_b->where($where)->get("ct_100");
                        if ($partidas->num_rows() > 0) {
                            foreach($partidas->result() as $partida) {
                                $porigen = explode("/", $partida->origen);
                                if (trim($porigen[3]) == trim($extra['cuenta'])) {
                                    $data = 3;
                                    break;
                                }
                            }
                        }
                    }

                
                break;
                default:
                    $data = false;
                break;
            }
            return $data;
        }
    }
    #   GET CUENTA
    public function getCuentaN($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $dato = $this->db_b->where("idrec", $ID)->get("ctcuenta")->row();
            if (count((array)$dato) > 0) {
                $reto = array(
                    'ID' => $dato->idrec,
                    'cuenta' => $dato->idctcuenta,
                    'titulo' => $dato->descrip,
                    'tipo' => (int)$dato->tipocuenta,
                    'mayor' => $dato->ctmayoriza,
                    'grupo' => (int)$dato->catgrupo,
                    'tcontrol' => (int)$dato->ctcontrol,
                    'auxiliar' => $dato->useauxi,
                    'ccentros' => $dato->askidcentro,
                    'cproyecto' => (int)$dato->askidproyecto,
                    'mostrar' => ($dato->balview == 1) ? true : false,
                    'users' => $dato->allowed_users,
                    'xpos' => $dato->xpos,
                    'notas' => $dato->notas,
                    'estado' => ($dato->estatus == 1) ? true : false,
                );
            } else $reto = false;
            return $reto;
        }
    }

    #   SET CUENTA
    public function setCuenta($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ctcuenta', $data)) return true;
            else return false;
        }
    }
    #   UPDATE CUENTA
    public function updateCuenta($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idrec', $ID);
            if ($this->db_b->update('ctcuenta', $data)) return true;    
            else return false;
        }
    }

    public function updateMayoriza($id,$mayoriza){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->set('ctmayoriza', $mayoriza);

            $this->db_b->where('idrec', $id);
            if ($this->db_b->update('ctcuenta')) return true;    
            else return false;
        }
    }
    #   DELETE CUENTA
    public function delCuentaN($codigo, $tipo)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            # -1 -> Eliminado
            # 2 - Usada como asistente (tipos de partida)
            # 3 - Esta usada en una partida
            # 4 - Tiene hijos
            if ($tipo == 3) {
                $tpartidas = $this->db_b->where('(length(haber_ct) > 0) OR (length(debe_ct) > 0)')->get("ctpdef");
                $asistente = false;
                if ($tpartidas->num_rows() > 0) {
                    $conteo = 0;
                    foreach ($tpartidas->result() as $tpartida) {
                        if (strlen($tpartida->debe_ct) > 0) {
                            foreach (explode(',', $tpartida->debe_ct) as $cta) {
                                if ($cta == $codigo) {
                                    $conteo++;
                                    break;
                                }
                            }
                        }
                        if (strlen($tpartida->haber_ct) > 0) {
                            foreach (explode(',', $tpartida->haber_ct) as $cta) {
                                if ($cta == $codigo) {
                                    $conteo++;
                                    break;
                                }
                            }
                        }
                        if ($conteo > 0) {
                            $asistente = true;
                            break;
                        }
                    }
                }
                if (!$asistente) {
                    if ($this->db_b->where("idctcuenta", $codigo)->get("ct_100d")->num_rows() == 0) {
                        $this->db_b->where('idctcuenta', $codigo);
                        $this->db_b->delete('ctcuenta');//*/
                        //return true;
                        return -1;
                    } else return 3;
                } else return 2;
            } else {
                if($this->db_b->where('(ctmayoriza = '.$codigo.') OR (POSITION("'.$codigo.'," IN ctmayoriza) = 1)')->get("ctcuenta")->num_rows() == 0) {
                    $this->db_b->where('idctcuenta', $codigo);
                    $this->db_b->delete('ctcuenta');//*/
                    //return true;
                    return -1;
                } else return 4;
            }
        }
    }

    public function cuentaPoseeHijos($codigo){
        $this->db_b->select("idctcuenta");
        $this->db_b->from("ctcuenta");
        $this->db_b->where('(ctmayoriza = '.$codigo.') OR (POSITION("'.$codigo.'," IN ctmayoriza) = 1)');
        $this->db_b->where('idctcuenta !=', $codigo);
        $resultado = $this->db_b->get()->num_rows();
        if($resultado == 0) {
            return false;
        }
        return true;
    }
    #   GET CUENTAS REPORTE
    public function getCuentasNR($grupo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ctcuenta");
            if($grupo != 9) $this->db_b->where('catgrupo',$grupo);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'cuenta' => $dato->idctcuenta,
                        'titulo' => $dato->descrip,
                        'tipoCuenta' => $dato->tipocuenta,
                        'useauxi' => $dato->useauxi,
                        'mayoriza' => $dato->ctmayoriza,
                        'control' => $dato->ctcontrol,
                        'controlTx' => array_search($dato->ctcontrol, array_column($this->TControles,'ID', 'Name')),
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activa' : 'Inactiva',
                        'grupoX' => $dato->catgrupo,
                        'etiqueta' => $dato->xpos,
                        'mostrarBG' => ($dato->balview == 1) ? true : false,
                        'askcentro' => ($dato->askidcentro != "") ? true : false,
                        'askproyecto' => ($dato->askidproyecto != 0) ? true : false,

                    );
                }
            }
            return $Datos;
        }
    }
    #   GET CUENTA 3
    public function getCuenta3($codigo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else return $this->db_b->where("idctcuenta", $codigo)->where("tipocuenta", 3)->get("ctcuenta")->row();
    }
    #-------------------------------------------------------------- EXCEL MEJORA
        public function CatalogoHasCuentas()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                //return 0;
                return $this->db_b->get("ctcuenta")->num_rows();
            }
        }
    #-
    #------------------------------------------------------     FIN CATALOGO DE CUENTAS MEJORA ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function getCuentasG($grupo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus");
            $this->db_b->from("ctcuenta");
            //$this->db_b->where("tipocuenta", 3);
            $this->db_b->where('catgrupo',$grupo);
            $this->db_b->order_by("idctcuenta", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   GET CENTOS DE COSTOS
    public function getCentros()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idcentro, descrip, tipo");
            $this->db_b->from("invsites");
            $this->db_b->where('estatus', 1);
            //$this->db_b->group_by("tipo");
            $this->db_b->order_by("idcentro", "DESC");
                
            if ($datos = $this->db_b->get()->result()) return $datos;
            else return false;
        }
    }
    #   GET INFO PADRE
    public function getInfoPadre($mayor)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idctcuenta, tipocuenta, ctmayoriza");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('idctcuenta', $mayor);
            $dato = $this->db_b->get()->row();
            return $dato;
        }
    }
    #-------------------------------------------------------------- MIGRACION CUENTA
        public function multiOpcionesMigracionCC($opc, $extra = null)
        {
            if ($this->validatePermiso()) {
                switch ($opc) {
                    case -1:#   VER SI EXISTE TABLA
                        $query = 'select count(*) as conteo from information_schema.tables where table_schema = "'.$this->session->userdata('nameDB').'" and table_name = "'.$extra.'"';
                        $datos = $this->db_b->query($query)->row();
                        $datos = ($datos->conteo > 0) ? true : false;
                    break;
                    case 1:#   GET CUENTAS - TABLA
                        if ($extra['tipo'] == 1) $datos = $this->db_b->get($extra['tabla']);
                        else {
                            if ($this->multiOpcionesMigracionCC(-1, $extra['tabla'])) {
                                $query = trim('
                                    SELECT a.*,
                                        (CASE
                                            WHEN SUBSTRING_INDEX(a.useauxi, ",", 1) = "1" THEN CONCAT("(AUX) ", b.descripcion)
                                            WHEN SUBSTRING_INDEX(a.useauxi, ",", 1) = "2" THEN CONCAT("(PRO) ", c.descripcion)
                                            ELSE ""
                                        END) as auxi
                                    FROM '.$extra['tabla'].' a
                                    LEFT JOIN gvars b ON (SUBSTRING_INDEX(SUBSTRING_INDEX(a.useauxi, ",", 2), ",", -1) = b.valor_num) AND (b.nombre = "auxi_def")
                                    LEFT JOIN gvars c ON (SUBSTRING_INDEX(SUBSTRING_INDEX(a.useauxi, ",", 2), ",", -1) = c.valor_num) AND (c.nombre = "gv_protipo")
                                    ORDER BY a.idctcuenta
                                ');
                                $datos = $this->db_b->query($query);
                            } else $datos = true;
                        }
                    break;
                    case 2:#   CREACION DE TABLA MIGRACION
                        if (!$this->multiOpcionesMigracionCC(-1, $extra)) {
                            $this->db_b->query('CREATE TABLE '.$extra.' LIKE ctcuenta');
                            $datos = true;
                        } else $datos = false;
                    break;
                    case 3:#   ELIMINAR TABLA
                        $this->db_b->query('DROP TABLE IF EXISTS '.$extra);
                        $datos = true;
                    break;
                    case 4:#   GET CUENTAS
                        $datos = $this->db_b->where('estatus', 1)->get($extra);
                    break;
                    case 5:#   GET AUXS
                        $datos = $this->db_b->where('estatus', 3)->group_by('descrip')->group_by('useauxi')->get($extra);
                    break;
                    case 6:#   GET LAS ULTIMOS 2 REGISTROS AUX
                        $datos = $this->db_b->where('estatus', 3)->group_by('useauxi')->order_by('modifica', 'DESC')->limit(2)->get($extra);
                    break;
                    case 7:#   TRAER POR LONGITUD
                        $where = implode(' AND ', [
                            '(length(idctcuenta) = '.$extra['a'].')',
                            '(estatus = 0)'
                        ]);
                        $datos = $this->db_b->where($where)->get($extra['t']);
                    break;
                    case 8:#   EXISTE AUX
                        $where = implode(' AND ', [
                            '(descrip = "'.trim($extra['descrip']).'")',
                            '(idauxidef = '.$extra['idaux'].')'
                        ]);
                        $datos = $this->db_b->where($where)->get('ctauxi')->row();
                        $datos = (count((array)$datos) > 0) ? true : false;
                    break;
                }
                return $datos;
            }
        }
    #-
    #------------------------------------------------------     FIN CATALOGO DE CUENTAS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     TIPOS DE PARTIDAS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET TIPOS DE PARTIDAS
    public function getTPartidas()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idptipo, descrip, estatus");
            $this->db_b->from("ctpdef");
            $this->db_b->order_by("idptipo", "ASC");
            $datos = $this->db_b->get();
            $Datos = null;
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->idptipo,
                        'titulo' => $dato->descrip,
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo'
                    );
                }
            }
            return $Datos;
        }
    }
    #   FIN GET TIPO DE PARTIDAS
    #       VERIFICAR TIPOS DE PARTIDAS DE CIERRE Y APERTURA
    public function VTPartidasCA()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            date_default_timezone_set('America/El_Salvador');

            $this->db_b->select('descrip');
            $this->db_b->from('ctpdef');
            $this->db_b->where('(idptipo = 1) OR (idptipo = 2)');
            $this->db_b->order_by('descrip', 'ASC');
            $partidasca = $this->db_b->get();
            $valido = false;
            
            switch ($partidasca->num_rows()) {
                case 0:
                    $data = array(
                        'idptipo' => 1,
                        'descrip' => 'PARTIDA DE APERTURA',
                        'assisted_entry' => 0,
                        'debe_ct' => '',
                        'haber_ct' => '',
                        'periodos' => '00',
                        'allowed_users' => '',
                        'voiding_users' => '1',
                        'allowed_ctmulti' => '',
                        'xpos' => '',
                        'estatus' => 1,
                        'notas' => '',
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s')
                    );
                    $this->setTPartida($data);
                    $data = array(
                        'idptipo' => 2,
                        'descrip' => 'PARTIDA DE CIERRE',
                        'assisted_entry' => 0,
                        'debe_ct' => '',
                        'haber_ct' => '',
                        'periodos' => '13',
                        'allowed_users' => '',
                        'voiding_users' => '1',
                        'allowed_ctmulti' => '',
                        'xpos' => '',
                        'estatus' => 1,
                        'notas' => '',
                        'whodidit' => $this->session->userdata('iduser'),
                        'ingresa' => date_create()->format('Y-m-d H:i:s')
                    );
                    $this->setTPartida($data);
                    $valido = true;
                    //echo "-";
                break;
                case 1:
                    $cont = 0;
                    foreach ($partidasca->result() as $dato) {
                        if ($dato->descrip == 'PARTIDA DE APERTURA') $cont = 1;
                        else if ($dato->descrip == 'PARTIDA DE CIERRE') $cont = 2;
                    }
                    if ($cont == 1 || $cont == 2) {
                        if ($cont == 1) {
                            $data = array(
                                'idptipo' => 2,
                                'descrip' => 'PARTIDA DE CIERRE',
                                'assisted_entry' => 0,
                                'debe_ct' => '',
                                'haber_ct' => '',
                                'periodos' => '13',
                                'allowed_users' => '',
                                'voiding_users' => 1,
                                'allowed_ctmulti' => '',
                                'xpos' => '',
                                'estatus' => 1,
                                'notas' => '',
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s')
                            );
                            $this->setTPartida($data);
                        } else {
                            $data = array(
                                'idptipo' => 1,
                                'descrip' => 'PARTIDA DE APERTURA',
                                'assisted_entry' => 0,
                                'debe_ct' => '',
                                'haber_ct' => '',
                                'periodos' => '00',
                                'allowed_users' => '',
                                'voiding_users' => 1,
                                'allowed_ctmulti' => '',
                                'xpos' => '',
                                'estatus' => 1,
                                'notas' => '',
                                'whodidit' => $this->session->userdata('iduser'),
                                'ingresa' => date_create()->format('Y-m-d H:i:s')
                            );
                            $this->setTPartida($data);
                        }
                        $valido = true;
                    } else $valido = false;
                    //echo "--";
                break;
                case 2:
                    $cont = 0;
                    foreach ($partidasca->result() as $dato) {
                        if (($dato->descrip == 'PARTIDA DE APERTURA') || ($dato->descrip == 'PARTIDA DE CIERRE')) $cont++;
                    }
                    if ($cont != 2) $valido = false;
                    else $valido = true;
                    //echo "---".$cont;
                break;
            }
            return $valido;
        }
    }
    #   GET USUARIOS
    public function getUsuarios()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("iduser, descrip");
            $this->db_b->from("gusers");
            $this->db_b->where('estado', 1);
            $this->db_b->order_by("descrip", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN  GET USUARIOS
    #   GET CUENTAS TIPO 3
    public function getCuentas3()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, catgrupo, ctcontrol, useauxi, askidcentro, askidproyecto, allowed_users");
            $this->db_b->from("ctcuenta");
            $this->db_b->where('estatus', 1);
            $this->db_b->where('tipocuenta', 3);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET CUENTAS TIPO 3
    #   SET TIPO DE PARTIDA
    public function setTPartida($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ctpdef', $data)) return true;
            else return false;
        }
    }
    #   FIN SET TIPO DE PARTIDA
    #   GET TIPO DE PARTIDA
    public function getTPartida($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else return $this->db_b->where("idptipo", $ID)->get("ctpdef")->row();
    }
    #   FIN GET TIPO DE PARTIDA
    #   UPDATE TIPO DE PARTIDA
    public function updateTPartida($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idptipo', $ID);
            if ($this->db_b->update('ctpdef', $data)) return true;
            else return false;
        }
    }
    #   FIN UPDATE TIPO DE PARTIDA
    #   BORRAR TIPO DE PARTIDA
    public function eraseTPartida($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if($this->db_b->where("idptipo", $ID)->get("ct_100")->num_rows() == 0){
                $this->db_b->where('idptipo', $ID);
                $this->db_b->delete('ctpdef');//*/
                return true;
            } else return false;
        }
    }
    #   FIN BORRAR TIPO DE PARTIDA
    #------------------------------------------------------     FIN TIPOS DE PARTIDAS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     PERIODOS CONTABLES ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET PERIODOS
    public function getPeriodos()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idyear, descrip, fechaini, fechafin, meses");
            $this->db_b->from("ctyears");
            $this->db_b->order_by("idyear", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->idrec,
                        'idy' => $dato->idyear,
                        'titulo' => $dato->descrip,
                        'periodos' => $dato->meses." Meses",
                        'fecha_ini' => $dato->fechaini,
                        'fecha_fin' => $dato->fechafin,
                    );
                }
            }
            return $Datos;
        }
    }
    #   VALIDACION PERIODO
    public function ValidationPeriodo($dato)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            return $this->db_b->where("idyear", (int)$dato)->get("ctyears")->num_rows();
        }
    }
    #   VALIDACION PERIODO
    #   SET PERIODO
    public function setPeriodo($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ctyears', $data)) return true;
            else return false;
        }
    }
    #   FIN SET PERIODO
    #   GET PERIODO
    public function getPeriodo($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else return $this->db_b->where("idrec", $ID)->get("ctyears")->row();
    }
    public function getPeriodoM($IDyear)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else return $this->db_b->where("idyear", $IDyear)->get("ctyears")->row();
    }
    #   FIN GET PERIODO
    #   UPDATE PERIODO
    public function updatePeriodo($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idrec', $ID);
            if ($this->db_b->update('ctyears', $data)) return true;
            else return false;
        }
    }
    #   FIN UPDATE PERIODO
    #------------------------------------------------------     FIN PERIODOS CONTABLES ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CUENTAS AUXILIARES ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     CUENTAS AUXILIARES MEJORA
    public function getDataCAN($opcion, $extra = null){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            switch ($opcion) {
                #   GET TIPOS AUXILIARES
                case 0:
                    $this->db_b->select("descripcion, valor_num, filtro");
                    $this->db_b->from("gvars");
                    $this->db_b->where('nombre','auxi_def');
                    $this->db_b->order_by("descripcion", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET CUENTAS AUXILIARES
                case 1:
                    $this->db_b->select("*");
                    $this->db_b->from("ctauxi");
                    $this->db_b->where("idauxidef", $extra);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }
    #------------------------------------------------------     FIN CUENTAS AUXILIARES MEJORA
    #   LOAD LOS TIPOS AUXILIARES
    public function loadAuxis()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("descripcion, valor_num, filtro");
            $this->db_b->from("gvars");
            $this->db_b->where('nombre','auxi_def');
            $this->db_b->order_by("descripcion", "ASC");
            $datos = $this->db_b->get();
            $Datos = null;
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'ID' => (int)$dato->valor_num,
                        'Name' => ucfirst(strtolower($dato->descripcion)),
                        'filtro' => $dato->filtro,
                    );
                }
            }
            return $Datos;
        }
    }
    #   FIN LOAD LOS TIPOS AUXILIARES
    #   GET CUENTAS AUXILIARES
    public function getCAuxiliares($dato)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //print_r($this->db_b->list_fields('ctauxi'));
            $this->db_b->select("*");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxidef", $dato);
            $this->db_b->order_by("descrip", "ASC");
            $contribuyentes =  array(
                '' => '0',
                'Pequeño' => '1',
                'Mediano' => '2',
                'Grande' => '3',
                'Otro' => '4',
            );
            
            if ($datoS = $this->db_b->get()->result()) {
                $deptos = $this->getDataCA(3);
                //print_r($datoS);
                //die();
                foreach ($datoS as $dato) {
                    $departamento = "";
                    $municipio = "";
                    foreach ($deptos as $value) {
                        if ($value->idzip == $dato->idzip) {
                            $departamento = $value->depto;
                            $municipio = $value->municipio;
                        }
                    }

                    $imagen = '';
                    if (strlen(trim($dato->imagen)) > 0) {
                        $direccion = 'img_cuentas/'.$this->session->userdata('diraccount').'/';
                        if (!file_exists($direccion.trim($dato->imagen))) $imagen = '';
                        else $imagen = trim($dato->imagen);
                    }

                    $DatoS[] = array(
                        'id' => $dato->idauxi,
                        'titulo' => $dato->descrip,
                        'grupo' => $dato->grupo,
                        'nrc' => $dato->nrc,
                        'nit' => $dato->nit,
                        'estado' => $dato->estado,
                        'estadoTx' => ($dato->estado == 1) ? 'Activo' : 'Inactivo',
                        'xpos' => $dato->xpos,
                        'telefono' => $dato->telefono,
                        'correo' => $dato->correo,
                        'direccion' => $dato->direccion,
                        'departamento' => trim($departamento),
                        'municipio' => trim($municipio),
                        'giro' => $dato->giro,
                        'idtipo' => $dato->idtipo,
                        'tipo' => array_search($dato->idtipo, $contribuyentes),
                        'limite' => $dato->limite,
                        'dias' => $dato->dias,
                        'imagen' => $imagen
                    );
                }
                return $DatoS;
            } else return false;
        }
    }
    #   FIN GET CUENTAS AUXILIARES
    #----------------------------- GET DATA CA -----------------------
    public function getDataCA($tipo, $ID = null, $auxi = null)
    {
        switch ($tipo) {
            //  GRUPOS
            case 1:
                $this->db_b->select("grupo");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", $auxi);
                $this->db_b->group_by("grupo");
                $this->db_b->order_by("grupo", "ASC");
                $data = $this->db_b->get();
            break;
            //  VENDEDORES
            case 2:
                $this->db_b->select("idauxi, descrip");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", 3);
                $this->db_b->where("estado", 1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get()->result();
            break;
            //  DEPARTAMENTOS
            case 3:
                $this->db_b->select("idzip, municipio, depto");
                $this->db_b->from("gzips");
                //$this->db_b->where("pais", "EL SALVADOR");
                $this->db_b->order_by("depto", "ASC");
                $data = $this->db_b->get()->result();
            break;
            //  GIRO - ACTIVIDAD ECONOMICA
            case 4:
                $this->db_b->select("giro");
                $this->db_b->from("ctauxi");
                $this->db_b->group_by("giro");
                $this->db_b->order_by("giro", "ASC");
                $data = $this->db_b->get();
            break;
            //  LIMITES
            case 5:
                $this->db_b->select("limite");
                $this->db_b->from("ctauxi");
                $this->db_b->group_by("limite");
                $this->db_b->order_by("limite", "ASC");
                $data = $this->db_b->get();
            break;
            //  DIAS
            case 6:
                $this->db_b->select("dias");
                $this->db_b->from("ctauxi");
                $this->db_b->group_by("dias");
                $this->db_b->order_by("dias", "ASC");
                $data = $this->db_b->get();
            break;
            //  GET CUENTA AUXILIAR
            case 7: 
                $data = $this->db_b->where("idauxi", $ID)->get("ctauxi")->row();
            break;
            #   NUMERO DE AUXILIARES
            case 8:
                $this->db_b->select("*");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", $ID);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get()->num_rows();
            break;
            #   EXISTE IMAGEN-AUXILIAR CON ESE NOMBRE
            case 9:
                $this->db_b->select("*");
                $this->db_b->from("ctauxi");
                $this->db_b->where("imagen", $ID);
                $data = $this->db_b->get();
                $data = $data->num_rows();
                $data = ($data == 0) ? 1 : -1;
            break;
            default:
                $data = false;
            break;
        }
        //-----------------------------------------------
        
        return ($data) ? $data : false;
    }
    #-----------------------------FIN GET DATA CA ----------------
    #   SET CUENTA AUXILIADORA
    public function setCA($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ctauxi', $data)) return true;
            else return false;
        }
    }
    #   FIN SET CUENTA AUXILIADORA
    #   UPDATE CUENTA AUXILIADORA
    public function updateCA($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idauxi', $ID);
            if ($this->db_b->update('ctauxi', $data)) return true;
            else return false;
        }
    }
    #   FIN UPDATE CUENTA AUXILIADORA
    #-------------------------------------------------------------- TIPOS AUXILIAR
    public function loadTAuxis()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrnum, descripcion, valor_num, filtro");
            $this->db_b->from("gvars");
            $this->db_b->where('nombre','auxi_def');
            $this->db_b->order_by("descripcion", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function lastValor_num()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("valor_num");
            $this->db_b->from("gvars");
            $this->db_b->where('nombre','auxi_def');
            $this->db_b->order_by("valor_num", "ASC");
            $dato = $this->db_b->get();
            //print_r($dato->last_row()->valor_num);
            return $dato->last_row()->valor_num;
        }
    }
    public function setTAuxis($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $data['nombre'] = 'auxi_def';
            if ($this->db_b->insert('gvars', $data)) return true;
            else return false;
        }
    }
    public function getTAuxi($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrnum as id, descripcion, filtro");
            $this->db_b->from("gvars");
            $this->db_b->where('nombre','auxi_def');
            $this->db_b->where('idrnum',$ID);
            $dato = $this->db_b->get()->row();
            return $dato;
        }
    }
    public function updateTAuxis($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idrnum', $ID);
            $this->db_b->where('nombre', 'auxi_def');
            if ($this->db_b->update('gvars', $data)) return true;
            else return false;
        }
    }
    #-------------------------------------------------------------- FIN TIPOS AUXILIAR
    #------------------------------------------------------     FIN CUENTAS AUXILIARES ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     PROYECTOS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET PROYECTOS
    public function getProyectos()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as cliente");
            $this->db_b->from("ctproj a");
            $this->db_b->where('a.estatus',1);
            $this->db_b->join("ctauxi b", "a.idcps = b.idauxi");
            $this->db_b->order_by("a.idproject", "ASC");
            $datos = $this->db_b->get();
            $Datos = null;
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'id' => $dato->Idproject,
                        'titulo' => $dato->descrip,
                        'cliente' => $dato->cliente,
                        'inicia' => $dato->fechaini,
                        'finaliza' => $dato->fechafin,
                        'xpos' => $dato->xpos,
                        'estado' => $dato->estatus,
                        'estadoTx' => ($dato->estatus == 1) ? 'Activo' : 'Inactivo'
                    );
                }
            }
            return $Datos;
        }
    }

    public function getProyectoPredeterminado()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idproject");
            $this->db_b->from("ctproj");
            $this->db_b->where('xpos',1);
            $this->db_b->where('estatus',1);
            $this->db_b->limit(1);
            $datos = $this->db_b->get();
            if ($datos->num_rows() > 0) {
                $datos = $datos->row_array();
                return $datos['idproject'];
            }
            return 0; 
        }
    }
    #   FIN GET PROYECTOS
    #   GET VENDEDORES - CLIENTES
    public function getPClientes()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idauxi, descrip");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxidef", 2);
            $this->db_b->where("estado", 1);
            $this->db_b->order_by("descrip", "ASC");
            if ($data = $this->db_b->get()->result()) {
                foreach ($data as $dato) {
                    $Datos[] = array(
                        'ID' => $dato->idauxi,
                        'Name' => $dato->descrip
                    );
                }
                return $Datos;
            } else return false;
        }
    }
    #   GET VENDEDORES - CLIENTES
    #   SET PROYECTO
    public function setProyecto($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ctproj', $data)) return $this->db_b->insert_id();
            else return false;
        }
    }

    public function setProyectoPredeterminado($idproy)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $ahora = date_create()->format('Y-m-d H:i:s');
            $this->db_b->set('xpos', 0);
            $this->db_b->set('modifica', $ahora);
            $this->db_b->where('idproject !=', $idproy);

            $this->db_b->update('ctproj');
        }
    }
    #   FIN SET PROYECTO
    #   GET PROYECTO
    public function getProyecto($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else return $this->db_b->where("Idproject", $ID)->get("ctproj")->row();
    }
    #   FIN GET PROYECTO
    #   UPDATE PROYECTO
    public function updateProyecto($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('Idproject', $ID);
            if ($this->db_b->update('ctproj', $data)) return true;
            else return false;
            
        }
    }
    #   FIN UPDATE PROYECTO
    #------------------------------------------------------     FIN PROYECTOS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EDITOR DE PARTIDAS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   LOAD AÑOS
    public function loadYears()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idyear, mes00, mes01, mes02, mes03, mes04, mes05, mes06, mes07, mes08, mes09, mes10, mes11, mes12, mes13");
            $this->db_b->from("ctyears");
            $this->db_b->where('estatus', 1);
            $this->db_b->order_by("idyear", "DESC");
            $datos = $this->db_b->get();
            $Datos = null;
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $valor = implode(",", [$dato->mes00, $dato->mes01, $dato->mes02, $dato->mes03, $dato->mes04, $dato->mes05, $dato->mes06, $dato->mes07, $dato->mes08, $dato->mes09, $dato->mes10, $dato->mes11, $dato->mes12, $dato->mes13]);
                    $Datos[] = array(
                        'ID' => $dato->idrec,
                        'Name' => $dato->idyear,
                        'mesesv' => $valor,
                    );
                }
            }//*/
            return $Datos;
        }
    }
    #   GET EDITOR DE PARTIDAS
    public function getEPartidas($year, $month)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            /*$dia = ($month == "00") ? "01" : "31";
            $month = ($month != "00" && $month != "13") ? $month : ($month == "00") ? "01" : "12";
            if($month == "00" || $month == "13") $this->db_b->where("DAY(a.fecha)", $dia);
            */
            $this->db_b->select("a.*, b.descrip as tipoP, b.allowed_users as usuarios_malos");
            $this->db_b->from("ct_100 a");
            $this->db_b->join("ctpdef b", "a.idptipo = b.idptipo");
            $this->db_b->where("YEAR(a.fecha)", $year);
            if ($month == "00" || $month == "13") {
                $dia = ($month == "00") ? "01" : "31";
                $month = ($month == "00") ? "01" : "12";
                $this->db_b->where("MONTH(a.fecha)", $month);
                $this->db_b->where("DAY(a.fecha)", $dia);
            } else $this->db_b->where("MONTH(a.fecha)", $month);
            $this->db_b->order_by("a.pnumero", "ASC");
            if ($datos = $this->db_b->get()->result()) {
                //print_r($datos);
                //die();
                $status = array(
                    'En Elaboración' => 0,
                    'Actualizada' => 1,
                    'Anulada' => 9,
                );
                foreach ($datos as $dato) {
                    $permiso = true;
                    if (strlen(trim($dato->usuarios_malos)) > 0) {
                        foreach (explode(",", trim($dato->usuarios_malos)) as $malo) {
                            if ($malo == $this->session->userdata('iduser')) {
                                $permiso = false;
                                break;
                            }
                        }
                    } else $permiso = true;

                    $tipo = -1;
                    if ($permiso) {
                        $porigen = explode("/", $dato->origen);
                        if ((strpos($porigen[0], 'AC_') !== false) && ((int)$porigen[1] == 0)) {
                            $permiso = false;
                            $tipo = 1;
                        }
                    } else $tipo = 0;
                    
                    $DatoS[] = array(
                        'numero' => $dato->pnumero,
                        'num_mes' => $dato->num_mes,
                        'idyear' => $dato->idyear,
                        'idptipo' => $dato->idptipo,
                        'tipoP' => $dato->tipoP,
                        'idsite' => $dato->idsite,
                        'titulo' => $dato->descrip,
                        'fecha' => $dato->fecha,
                        'cierre' => $dato->fecact,
                        'fecvoid' => $dato->fecvoid,
                        'referencia' => $dato->referencia,
                        'origen' => $dato->origen,
                        'debe' => round($dato->debe, 2),
                        'haber' => round($dato->haber, 2),
                        'itemcount' => $dato->itemcount,
                        'estado' => array_search($dato->estatus, $status),
                        'estatus' => (int)$dato->estatus,
                        'historico' => $dato->chg_log,
                        'notas' => $dato->notas,
                        'permiso' => $permiso,
                        'tpermiso' => (int)$tipo
                    );
                }
                return $DatoS;
            } else return false;
        }
    }
    public function getEPartidasDate1($fecha){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as TPartida");
            $this->db_b->from("ct_100 a");
            $this->db_b->join("ctpdef b", "a.idptipo = b.idptipo");
            $this->db_b->where("a.fecha", $fecha);
            $this->db_b->where("a.estatus", 1);
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   GET TIPOS DE PARTIDAS EDIT
    public function getTPartidasEdit($month)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idptipo, descrip, periodos, allowed_users");
            $this->db_b->from("ctpdef");
            $this->db_b->where("estatus", 1);
            $this->db_b->order_by("idptipo", "ASC");
            $data = $this->db_b->get();
            
            /*if ($datos = $this->db_b->get()->result()) {
                //print_r($datos);
                //echo "**********************************";
                $cont = 0;
                foreach ($datos as $dato) {
                    if (strlen($dato->allowed_users) > 0) {
                        if (strpos($dato->allowed_users, $this->session->userdata("iduser")) === false) {
                            //$cont = ($cont == 0) ? 1 : $cont;
                            if (strpos($dato->periodos, $month) !== false) {
                                $cont = 2;
                                $datoS[] = array(
                                    'ID' => $dato->idptipo,
                                    'Name' => $dato->descrip,
                                );
                            }
                        }
                    } else {
                        if (strpos($dato->periodos, $month) !== false) {
                            $cont = 2;
                            $datoS[] = array(
                                'ID' => $dato->idptipo,
                                'Name' => $dato->descrip,
                            );
                        }
                    }
                }
                return ($cont == 2) ? $datoS : false;
            } else return false;//*/
            $Datos = [];
            if ($data->num_rows() > 0) {
                foreach ($data->result() as $dato) {
                    if (strlen(trim($dato->allowed_users)) > 0) {
                        $found = 0;
                        foreach (explode(',', $dato->allowed_users) as $iduser) {
                            if ($iduser == (string)$this->session->userdata('iduser')) {
                                $found = 1;
                                break;
                            }
                        }
                        if ($found == 0) {
                            if (strlen(trim($dato->periodos)) > 0) {
                                foreach (explode(',', $dato->periodos) as $periodo) {
                                    if ($periodo == $month) {
                                        $Datos[] = array(
                                            'ID' => $dato->idptipo,
                                            'Name' => $dato->descrip
                                        );
                                        break;
                                    }
                                }
                            }
                        }
                    } else {
                        if (strlen(trim($dato->periodos)) > 0) {
                            foreach (explode(',', $dato->periodos) as $periodo) {
                                if ($periodo == $month) {
                                    $Datos[] = array(
                                        'ID' => $dato->idptipo,
                                        'Name' => $dato->descrip
                                    );
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            return $Datos;
        }
    }
    #   SET EDITOR DE PARTIDAS
    public function setEPartidas($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ct_100', $data)) {
                return $this->db_b->insert_id();
            }
            return false;
        }
    }
    #   GET EDITOR DE PARTIDA
    public function getEPartida($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as Partida");
            $this->db_b->from("ct_100 a");
            $this->db_b->join("ctpdef b", "a.idptipo = b.idptipo");
            $this->db_b->where("a.pnumero", $ID);
            $dato = $this->db_b->get();
            if ($dato->num_rows() > 0) return $dato->row();
            else return false;
        }
    }
    #   GET HISTORICO EDITOR DE PARTIDA DETALLE
    public function getHistoricoEP($id)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            
            $this->db_b->select("chg_log");
            $this->db_b->from("ct_100");
            $this->db_b->where("pnumero", $id);
            $dato = $this->db_b->get();
            /*print_r($dato);
            print_r($dato->row());//*/
            return $dato->row()->chg_log;
        }
    }
    #   UPDATE EDITOR DE PARTIDA
    public function updateEPartida($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('pnumero', $ID);
            if ($this->db_b->update('ct_100', $data)) {
                return true;
            } else {
                return false;
            }
            
        }
    }
    #   MUILTI OPCIONES EDITOR PARTIDAS
    public function multiEPartida($opc, $extra = null)
    {
        if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   PARTIDAS FAVORITOS
                case 0:
                    $where = [
                        '(idsite = 0)'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('pnumero');
                    $this->db_b->from('ct_100');
                    $this->db_b->where($where);
                    //$this->db_b->order_by('cajclase', '');
                    $datos = $this->db_b->get();
                break;
                #   CUENTAS DE ACTIVAS DE UNA PARTIDA FAVORITA
                case 1:
                    $where = [
                        '(a.estatus = 1)',
                        '(a.pnumero = '.$extra.')'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.idctcuenta, b.idrec, b.descrip, b.catgrupo, b.allowed_users');
                    $this->db_b->select('b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->order_by('a.itemline', 'ASC');
                    $datos = $this->db_b->get();
                break;
                default:
                    $datos = false;
                break;
            }
            return $datos;
        }
    }
    #------------------------------------------------------     EDITOR DE PARTIDAS  DETALLE
    #   GET EPARTIDA DETALLE
    public function getEPDetalle($id)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.idptipo as IDTP, b.descrip as tipoP, b.debe_ct, b.haber_ct, b.assisted_entry, b.allowed_users");
            $this->db_b->from("ct_100 a");
            $this->db_b->join("ctpdef b", "a.idptipo = b.idptipo");
            $this->db_b->where("a.pnumero", $id);
            return $this->db_b->get()->row();
            //return $this->db_b->where("pnumero", $id)->get("ct_100")->row();
        }
    }
    #   GET EDITOR DE PARTIDA DETALLE
    public function getEPDS($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //print_r($pnumero);
            $this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto, c.estatus as estadoPartida");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ct_100 c", "a.pnumero = c.pnumero");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.pnumero", $pnumero);
            $this->db_b->where("b.estatus", 1);
            //$this->db_b->order_by("a.idrec", "ASC");
            $this->db_b->order_by("a.itemline", "ASC");
            $query = $this->db_b->get();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $dato) {
                    $valor = $dato->idtabla;//explode(",", $dato->idauxi);
                    switch ($valor) {
                        case '1':
                            $tabla = "ctauxi";
                            $id = "idauxi";
                            break;
                        case '2':
                            $tabla = "invproducts";
                            $id = "idproducto";
                            break;
                    }
                    $ida = $dato->idauxi;
                    if ($ida != "0") {
                        $this->db_b->select("descrip");
                        $this->db_b->from($tabla);
                        $this->db_b->where($id, $ida);
                        $consul = $this->db_b->get()->row();
                        $auxi = $ida."-".$consul->descrip;
                    } else {
                        $auxi = "";
                    }
                    
                    $valor1 = (strpos(round($dato->debe, 2), ".") !== false) ? (strlen(explode(".", round($dato->debe, 2))[1]) == 1) ? round($dato->debe, 2)."0" : round($dato->debe, 2) : round($dato->debe, 2).".00";
                    $valor2 = (strpos(round($dato->haber, 2), ".") !== false) ? (strlen(explode(".", round($dato->haber, 2))[1]) == 1) ? round($dato->haber, 2)."0" : round($dato->haber, 2) : round($dato->haber, 2).".00";
                    
                    /*if($dato->estadoPartida != 1){
                        if($dato->estatus != 9){
                            $datos[] = array(
                                'id' => $dato->idrec,
                                'linea' => $dato->itemline,
                                'idcuenta' => $dato->idctcuenta,
                                'cuenta' => $dato->cuenta,
                                'cuentaT' => $dato->idctcuenta."-".$dato->cuenta,
                                'titulo' => $dato->descrip,
                                'tipodoc' => $dato->doc_type,
                                'serie' => $dato->doc_serie,
                                'numero' => $dato->doc_numero,
                                'debe' => $valor1,
                                'haber' => $valor2,
                                'historico' => $this->getArrayChangeLog($dato->chg_log),
                                //'idauxi' => $dato->idauxi,
                                'auxi' => $auxi,
                                'Grupo' => $dato->catgrupo,
                                'Control' => $dato->ctcontrol,
                                'Auxi'=> $dato->useauxi,
                                'Centro' => $dato->askidcentro,
                                'Proyecto' => $dato->askidproyecto,
                                'fechai' => $dato->doc_emision,
                                'fechaf' => $dato->doc_vence,
                                'IDCentro' => $dato->idcentro,
                                'IDAuxi' => ($dato->idauxi != "0") ? $dato->idtabla.",".$dato->idauxi : "",
                                'IDProyecto' => $dato->idproject,
                                'IDWork' => $dato->doc_idworker,
                                'pnumero' => $pnumero,
                                'controlnum' => $dato->doc_controlnum,
                                'estado' => $dato->estatus,
                                'sidauxidef' => $dato->sidauxidef,
                            );
                        }
                    } else {*/
                    $datos[] = array(
                        'id' => $dato->idrec,
                        'linea' => $dato->itemline,
                        'idcuenta' => $dato->idctcuenta,
                        'cuenta' => $dato->cuenta,
                        'cuentaT' => $dato->idctcuenta."-".$dato->cuenta,
                        'titulo' => $dato->descrip,
                        'tipodoc' => $dato->doc_type,
                        'serie' => $dato->doc_serie,
                        'numero' => $dato->doc_numero,
                        'debe' => $valor1,
                        'haber' => $valor2,
                        'historico' => $this->getArrayChangeLog($dato->chg_log),
                        //'idauxi' => $dato->idauxi,
                        'auxi' => $auxi,
                        'Grupo' => $dato->catgrupo,
                        'Control' => $dato->ctcontrol,
                        'Auxi'=> $dato->useauxi,
                        'Centro' => $dato->askidcentro,
                        'Proyecto' => $dato->askidproyecto,
                        'fechai' => $dato->doc_emision,
                        'fechaf' => $dato->doc_vence,
                        'IDCentro' => $dato->idcentro,
                        'IDAuxi' => ($dato->idauxi != "0") ? $dato->idtabla.",".$dato->idauxi : "",
                        'IDProyecto' => $dato->idproject,
                        'IDWork' => $dato->doc_idworker,
                        'pnumero' => $pnumero,
                        'controlnum' => $dato->doc_controlnum,
                        'estado' => $dato->estatus,
                        'sidauxidef' => $dato->sidauxidef,
                    );
                    //}

                    //break;
                }
                return $datos;
            } else return null;
        }
    }

    #   GET EDITOR DE PARTIDA DETALLE SIN PARTIDAS ANULADAS
    public function getEPDSnoDatosAnulados($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //print_r($pnumero);
            $this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.pnumero", $pnumero);
            $this->db_b->where("b.estatus", 1);
            $this->db_b->where("a.estatus !=", 9);
            //$this->db_b->order_by("a.idrec", "ASC");
            $this->db_b->order_by("a.itemline", "ASC");
            $query = $this->db_b->get();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $dato) {
                    $valor = $dato->idtabla;//explode(",", $dato->idauxi);
                    switch ($valor) {
                        case '1':
                            $tabla = "ctauxi";
                            $id = "idauxi";
                            break;
                        case '2':
                            $tabla = "invproducts";
                            $id = "idproducto";
                            break;
                    }
                    $ida = $dato->idauxi;
                    if ($ida != "0") {
                        $this->db_b->select("descrip");
                        $this->db_b->from($tabla);
                        $this->db_b->where($id, $ida);
                        $consul = $this->db_b->get()->row();
                        $auxi = $ida."-".$consul->descrip;
                    } else {
                        $auxi = "";
                    }
                    
                    $valor1 = (strpos(round($dato->debe, 2), ".") !== false) ? (strlen(explode(".", round($dato->debe, 2))[1]) == 1) ? round($dato->debe, 2)."0" : round($dato->debe, 2) : round($dato->debe, 2).".00";
                    $valor2 = (strpos(round($dato->haber, 2), ".") !== false) ? (strlen(explode(".", round($dato->haber, 2))[1]) == 1) ? round($dato->haber, 2)."0" : round($dato->haber, 2) : round($dato->haber, 2).".00";
                    
                    $datos[] = array(
                        'id' => $dato->idrec,
                        'linea' => $dato->itemline,
                        'idcuenta' => $dato->idctcuenta,
                        'cuenta' => $dato->cuenta,
                        'cuentaT' => $dato->idctcuenta."-".$dato->cuenta,
                        'titulo' => $dato->descrip,
                        'tipodoc' => $dato->doc_type,
                        'serie' => $dato->doc_serie,
                        'numero' => $dato->doc_numero,
                        'debe' => $valor1,
                        'haber' => $valor2,
                        'historico' => $this->getArrayChangeLog($dato->chg_log),
                        //'idauxi' => $dato->idauxi,
                        'auxi' => $auxi,
                        'Grupo' => $dato->catgrupo,
                        'Control' => $dato->ctcontrol,
                        'Auxi'=> $dato->useauxi,
                        'Centro' => $dato->askidcentro,
                        'Proyecto' => $dato->askidproyecto,
                        'fechai' => $dato->doc_emision,
                        'fechaf' => $dato->doc_vence,
                        'IDCentro' => $dato->idcentro,
                        'IDAuxi' => ($dato->idauxi != "0") ? $dato->idtabla.",".$dato->idauxi : "",
                        'IDProyecto' => $dato->idproject,
                        'IDWork' => $dato->doc_idworker,
                        'pnumero' => $pnumero,
                        'controlnum' => $dato->doc_controlnum,
                        'estado' => $dato->estatus,
                        'sidauxidef' => $dato->sidauxidef,

                    );

                    //break;
                }
                return $datos;
            } else return null;
        }
    }

    function getArrayChangeLog($chg_log){
        $this->load->model('user_model');

        $chg_log = explode(";", $chg_log);
        $chg_log = array_filter($chg_log);

        $resultado = [];
        foreach($chg_log as $log){
            $dato = explode(",", $log);
            $usuario = $this->user_model->getDatosUsuario($dato[1])['descrip'];
            $resultado[] = ["fecha"=>$dato[0], "usuario"=>$usuario, "descrip"=>$dato[2]];
        }
        return $resultado;
    }

    #   GET PROYECTOS ACTIVOS
    public function getProyectosActivos()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("Idproject, descrip");
            $this->db_b->from("ctproj");
            $this->db_b->where("estatus", 1);
            $this->db_b->order_by("descrip", "ASC");
            $datos = $this->db_b->get();
            return $datos;
            /*if ($datos = $this->db_b->get()->result()) {
                return $datos;
            } else {
                return false;
            }//*/
        }
    }
    #   GET CUENTAS AUXILIARES Y PRODUCTOS
    public function getCtasAuxs($dato)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //print_r($dato);
            if ($dato[0] == "1") {
                $this->db_b->select("idauxi as id, descrip, sidauxidef as subauxi");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxidef", $dato[1]);
            }
            else if($dato[0] == "2"){
                $this->db_b->select("idproducto as id, descrip");
                $this->db_b->from("invproducts");
                $this->db_b->where("tipo", $dato[1]);
            }
            
            $this->db_b->where("estado", 1);
            $this->db_b->order_by("descrip", "ASC");
            //print_r($this->db_b->get());
            return $this->db_b->get()->result();
        }
    }
    #   GET 2 CUENTAS AUXILIARES Y PRODUCTOS
    public function getCtasAuxs2($dato)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //print_r($dato);
            if ($dato[0] == "1") {
                $this->db_b->select("idauxi as id, descrip, sidauxidef as subauxi");
                $this->db_b->from("ctauxi");
                $this->db_b->where("idauxi", $dato[1]);
            }
            else if($dato[0] == "2"){
                $this->db_b->select("idproducto as id, descrip");
                $this->db_b->from("invproducts");
                $this->db_b->where("idproducto", $dato[1]);
            }
            
            $this->db_b->where("estado", 1);
            $this->db_b->order_by("descrip", "ASC");
            //print_r($this->db_b->get());
            return $this->db_b->get()->result();
        }
    }
    #   GET GESTORES
    public function getGestores()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            
            $this->db_b->select("idauxi as id, descrip");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxidef", 3);
            $this->db_b->where("estado", 1);
            $this->db_b->order_by("descrip", "ASC");
            return $this->db_b->get()->result();
        }
    }
    #   FIN GET TIPO DOCS
    public function getTipoDocs($grupo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            switch($grupo){
                case 1:
                    $grupo = "VN";
                    break;
                case 2:
                    $grupo = "CO";
                    break;
                case 3:                
                    $grupo = "OT";
                    break;
                    
            }
            $this->db_b->select("invclase as id, descrip");
            //$this->db_b->select("*");
            $this->db_b->from("inv_def");
            //$this->db_b->where("inopera", -1);
            $this->db_b->where('agrupa', $grupo);
            $this->db_b->where('estatus', 1);
            $this->db_b->order_by("descrip", "ASC");
            //print_r($this->db_b->get()->result());
            return $this->db_b->get()->result();
        }   
    }
    #   GET MOVIMIENTOS DETALLE -    PPARA EL ITEMLINE
    public function getCountMov($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            
            $this->db_b->select("itemline");
            $this->db_b->from("ct_100d");
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->order_by("itemline", "ASC");
            $dato = $this->db_b->get();
            if ($dato->num_rows() > 0) return (int)$dato->last_row()->itemline;
            else return 0;
        }
    }
    #   SET EDITOR DE PARTIDA DETALLE
    public function setEPDetalle($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($this->db_b->insert('ct_100d', $data)) {
                return $this->db_b->insert_id();
            }
            return false;
        }
    }
    #   VALIDATE NUMERO
    public function validateNumero($idcuenta, $idauxi, $doc, $serie, $numero, $id)
    {
        $this->db_b->select("doc_numero");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $idcuenta);
            $this->db_b->where("idtabla", explode(",", $idauxi)[0]);
            $this->db_b->where("idauxi", explode(",", $idauxi)[1]);
            $this->db_b->where("doc_type", $doc);
            $this->db_b->where("doc_serie", $serie);
            $this->db_b->where("doc_numero", $numero);
            $this->db_b->where("((estatus = 0) OR (estatus = 1))");
            if($id != null) $this->db_b->where("idrec != ", $id);
            //print_r($this->db_b->get());
            return ($this->db_b->get()->num_rows() > 0) ? false : true;
    }
    #   GET SERIES
    public function getSeries($idauxi, $idcuenta, $tipodoc)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            
            $this->db_b->select("doc_serie as descrip");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $idcuenta);
            $this->db_b->where("idtabla", explode(",", $idauxi)[0]);
            $this->db_b->where("idauxi", explode(",", $idauxi)[1]);
            $this->db_b->where("doc_type", $tipodoc);
            $this->db_b->group_by("doc_serie");
            $this->db_b->order_by("doc_serie", "DESC");
            //echo "--";
            /*echo $idcuenta."-".$idauxi."-".$tipodoc;
            print_r($this->db_b->get()->result());
            print_r($this->db_b->get());//*/
            return $this->db_b->get()->result();
        }
    }
    #   GET DIAS AUXILIAR
    public function getEPDDias($idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //echo "-".$idauxi;
            return (int)$this->db_b->where("idauxi", $idauxi)->get("ctauxi")->row()->dias;
        }
    }
    #   GET HISTORICO EDITOR DE PARTIDA DETALLE
    public function getHistoricoEPD($id)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            
            $this->db_b->select("chg_log");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idrec", $id);
            $dato = $this->db_b->get();
            /*print_r($dato);
            print_r($dato->row());//*/
            return $dato->row()->chg_log;
        }
    }
    #   UPDATE EDITOR DE PARTIDA DETALLE
    public function updateEPDetalle($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idrec', $ID);
            if ($this->db_b->update('ct_100d', $data)) {
                return true;
            } else {
                return false;
            }
            
        }
    }
    #   GET AUXS - ABONOS Y CARGOS ------------------------------------------ ***
    public function getAuxsUse($cuentaID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idtabla, idauxi");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $cuentaID);
            $this->db_b->where("estatus", 1);
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");
            $dato = $this->db_b->get();
            if ($dato->num_rows() > 0) {
                return $dato->result();
            } else return false;
        }
    }
    #   GET AC - ABONOS Y CARGOS
    public function getAC($idcuenta, $auxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            
            $this->db_b->select("idrec, descrip, doc_type, doc_serie, doc_numero, doc_emision, doc_vence, doc_idworker");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $idcuenta);
            //$this->db_b->where("idauxi", $auxi);
            $this->db_b->where("idtabla", explode(",", $auxi)[0]);
            $this->db_b->where("idauxi", explode(",", $auxi)[1]);
            $this->db_b->where("estatus", 1);
            $this->db_b->group_by("doc_serie");//-
            $this->db_b->group_by("doc_numero");
            $this->db_b->order_by("doc_emision", "ASC");
            $dato = $this->db_b->get()->result();
            return $dato;
            /*print_r($dato);//*/
            //return $dato->row();
        }
    }
    #   BORRAR EDITOR DE PARTIDA DETALLE
    public function byeEPDetalle($ID, $IDTP, $pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("voiding_users as malos");
            $this->db_b->from("ctpdef");
            $this->db_b->where("idptipo", $IDTP);
            $dato = $this->db_b->get()->row();
            $hpermiso = false;
            $pnumero = 10000000 - $pnumero;
            foreach (explode(',', $dato->malos) as $malo) {
                if ($malo == $this->session->userdata('iduser')) {
                    $hpermiso = true;
                    break;
                }
            }
            if ($hpermiso) {
                date_default_timezone_set('America/El_Salvador');
                $update = date_create()->format('Y-m-d H:i:s');
                $histori = $this->getHistoricoEPD($ID).$update.",".$this->session->userdata('iduser').",Anulación;";
                $this->db_b->where('idrec', $ID);
                $this->db_b->update('ct_100d', array('estatus' => 9, 'chg_log' => $histori, 'pnumero' => $pnumero));
                return true;
            } else return false;
            /*if (strpos($dato->malos, $this->session->userdata('iduser')) !== false) {
                date_default_timezone_set('America/El_Salvador');
                $update = date_create()->format('Y-m-d H:i:s');
                $histori = $this->getHistoricoEPD($ID).$update.",".$this->session->userdata('iduser').",Anulación;";
                $this->db_b->where('idrec', $ID);
                $this->db_b->update('ct_100d', array('estatus' => 9, 'chg_log' => $histori));
                return true;
            }
            else return false;//*/
        }
    }
    #   CERRAR - ABRIR PARTIDA
    public function cerrarEPartida($pnumero, $old, $new, $user)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $proc ="CALL mayoriza100('$pnumero', '$old', '$new', '$user')";
            $query = $this->db_b->query($proc);
            return true;
        }
    }
    #   TIENE PERMISO
    public function havePermiso($IDTP)
    {
        if($this->validatePermiso()) {
            $this->db_b->select("voiding_users as malos");
            $this->db_b->from("ctpdef");
            $this->db_b->where("idptipo", $IDTP);
            $dato = $this->db_b->get()->row();
            $valor = false;
            foreach (explode(",", $dato->malos) as $malo) {
                if ($malo == $this->session->userdata('iduser')) {
                    $valor = true;
                    break;
                }
            }
            return $valor;
            /*if (strpos($dato->malos, $this->session->userdata('iduser')) !== false) return true;
            else return false;//*/
        }
    }
    #   ANULAR PARTIDA
    public function anularEPartida($pnumero, $user)
    {
        if($this->validatePermiso()) {
            $proc ="CALL anulact100('$pnumero', '$user')";
            $query = $this->db_b->query($proc);
            return true;
        }
    }
    #   GET INFO CUENTA ALL DETALLE
    public function getInfoCuentaAll($cuenta)
    {
        if($this->validatePermiso()) {
            $this->db_b->select("*");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->order_by("fecha", "ASC");
            $this->db_b->order_by("pnumero", "ASC");
            $this->db_b->order_by("itemline", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   MULTI OPCIONES EDITOR DETALLE
    public function multiEPDetalle($opc, $extra = null)
    {
        if($this->validatePermiso()) {
            switch ($opc) {
                case 1:#    GET AUXILIARES x TIPO AUXILIAR
                    $where = implode(' AND ', [
                        '(idauxidef = '.$extra.')',
                        '(estado = 1)'
                    ]);
                    $select = implode(', ', [
                        'idauxi, descrip, telefono, correo, direccion, idzip, fechain',
                        'nrc, nit, giro, grupo, limite, dias, xpos, idcps, idtipo, notas',
                    ]);
                    $this->db_b->select($select);
                    $this->db_b->from('ctauxi');
                    $this->db_b->where($where);
                    $this->db_b->order_by('descrip');
                    $datos = $this->db_b->get();
                break;
                case 2:#   
                    $having = implode(" AND ", [
                        '((SUM(a.debe) > 0) OR (SUM(a.haber) > 0))',
                        '(SUM(a.debe) > 0 != SUM(a.haber) > 0)'
                    ]);
                    $where = implode(' AND ', [
                        '((b.catgrupo = 4) OR (b.catgrupo = 5))',
                        '(YEAR(a.fecha) = '.$extra['idyear'].')',
                    ]);
                    $group = implode(', ', [
                        'a.idctcuenta, a.idtabla, a.idauxi',
                        'a.idcentro, a.idproject'
                    ]);
                    $order = implode(', ', [
                        'b.catgrupo ASC',
                        'b.idctcuenta ASC',
                        'c.idauxi ASC',
                        'd.idproducto ASC',
                    ]);
                    $select = implode(', ', [
                        'a.idctcuenta, b.descrip, SUM(a.debe) as debe, SUM(a.haber) as haber',
                        '(CASE
                            WHEN a.idtabla = 1 THEN TRIM(c.descrip)
                            WHEN a.idtabla = 2 THEN TRIM(d.descrip)
                            ELSE ""
                        END) as auxi',
                    ]);
                    $this->db_b->select($select);
                    $this->db_b->from('ct_100s a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->join('ctauxi c', 'a.idauxi = c.idauxi', 'left');
                    $this->db_b->join('invproducts d', 'a.idauxi = d.idproducto', 'left');
                    $this->db_b->where($where);
                    $this->db_b->having($having);
                    $this->db_b->group_by($group);
                    $this->db_b->order_by($order);
                    $datos = $this->db_b->get();
                break;
                default:
                    $datos = false;
                break;
            }
            return $datos;
        }
    }
    #-------------------------------------------------------------- RECONSTRUCCION DE SALDOS
        #   GET PARTIDAS ACTUALIZADAS
        public function getAPartidas($extra = null)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->select("a.*, b.descrip as dtpartida");
                $this->db_b->from("ct_100 a");
                $this->db_b->join("ctpdef b", "a.idptipo = b.idptipo");
                $this->db_b->where('a.estatus', 1);
                $this->db_b->order_by("a.pnumero", "ASC");
                $datos = $this->db_b->get();
                if ($extra != null) return $datos;
                $Datos = [];
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $Datos[] = array(
                            'pnumero' => $dato->pnumero,
                            'partida' => $dato->descrip,
                            //'referencia' => $dato->referencia,
                            'fecha' => $dato->fecha,
                            'dtpartida' => $dato->dtpartida,
                            'debe' => $dato->debe,
                            'haber' => $dato->haber,
                        );
                    }
                }
                return $Datos;
            }
        }
        #   LIMPIANDO SALDOS
        public function clearSaldos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->db_b->truncate('ct_100s');
            }
        }
    #-
    #------------------------------------------------------     REPORTE
    #-----  FORMATO 1 - SIMPLE
    public function getEPRegistroR($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as descripct, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.pnumero", $pnumero);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->order_by("a.idrec", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }

    public function getEPRegistroROrderByCtCuenta($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as descripct, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.pnumero", $pnumero);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->order_by("a.idctcuenta", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }

    public function getEPRegistroROrderByCtCuentaSumaTotal($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idctcuenta, SUM(debe) AS total_debe, SUM(haber) AS total_haber");
            $this->db_b->from("ct_100d ");
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->order_by("idctcuenta", "ASC");
            $this->db_b->group_by("idctcuenta");
            $dato = $this->db_b->get();
            return $dato;
        }
    }

    #-----  FORMATO 2
    public function getEPRegistroRG($pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as descripct, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.pnumero", $pnumero);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->group_by("a.idctcuenta");
            $this->db_b->order_by("a.itemline", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getEPDbyC($cuenta, $pnumero)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->where("estatus", 1);
            $this->db_b->order_by("itemline", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getCentro($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            return $this->db_b->where("idcentro", $ID)->get("invsites")->row();
        }
    }
    #------------------------------------------------------     FIN REPORTE
    #------------------------------------------------------     FIN EDITOR DE PARTIDAS  DETALLE
    #------------------------------------------------------     FIN EDITOR DE PARTIDAS ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EDITOR PARTIDAS DE CIERRE Y APERTURA ANUAL-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET PERIODOS CONTABLES A UTILIZAR
    public function getPeriodosSimple()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $this->db_b->select("idrec, idyear, descrip, fechaini, fechafin, meses");
            $this->db_b->from("ctyears");
            $this->db_b->order_by("idyear", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   PARTIDAS ACTUALIZADAS EN UN AÑO
    public function getPartidasAInY($IDyear)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            /*$this->db_b->where('pnumero', 1);
            $this->db_b->update('ct_100', array('fecha' => '2021-02-01'));//2021-02-01*/

            $this->db_b->select("pnumero, fecha");
            $this->db_b->from('ct_100');
            $this->db_b->where("YEAR(fecha)", $IDyear);
            $this->db_b->where('estatus', 1);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   GET PARTIDAS IN PROCESO en un Año específico
    public function getPartidasInP($IDYear)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $this->db_b->select('a.pnumero, b.descrip');
            $this->db_b->from('ct_100 a');
            $this->db_b->join('ctpdef b', 'a.idptipo = b.idptipo');
            $this->db_b->where("YEAR(a.fecha)", $IDYear);
            $this->db_b->where('a.estatus', 0);
            $this->db_b->order_by('a.pnumero', 'ASC');
            $this->db_b->order_by('a.fecha', 'ASC');
            $this->db_b->order_by('b.descrip', 'ASC');
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   GET PROCESOS
    public function getProcesos()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $this->db_b->select("idrec, idyear_cierre, idyear_apertura, descrip, fecha, fecact, pnumero0, pnumero1, pnumero2");
            $this->db_b->from("ctcierres");
            $this->db_b->order_by("idyear_cierre", "ASC");
            $datos = $this->db_b->get();
            $Datos = [];
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $Datos[] = array(
                        'ID' => (int)$dato->idrec,
                        'Name' => 'Proceso '.$dato->idyear_cierre.' / '.$dato->idyear_apertura,
                        'cierre' => $dato->idyear_cierre,
                        'apertura' => $dato->idyear_apertura,
                        'descripcion' => $dato->descrip,
                        'fecha' => date_create($dato->fecha)->format('d/m/Y'),
                        'fechaUpdate' => ($dato->fecact == '0000-00-00') ? '' : (date_create($dato->fecact)->format('d/m/Y')),
                        'partidas' => [
                            array(
                                'IDP' => (int)$dato->pnumero0,
                                'Descripcion' => 'Partida de Liquidación de Ingresos y Egresos',
                                'tipo' => 0,
                                'permiso' => ((int)$dato->pnumero0 != 0) ? true : false
                            ),
                            array(
                                'IDP' => (int)$dato->pnumero1,
                                'Descripcion' => 'Partida de Cierre',
                                'tipo' => 1,
                                'permiso' => ((int)$dato->pnumero0 != 0) ? true : false
                            ),
                            array(
                                'IDP' => (int)$dato->pnumero2,
                                'Descripcion' => 'Partida de Apertura',
                                'tipo' => 2,
                                'permiso' => ((int)$dato->pnumero1 != 0) ? true : false
                            )
                        ]
                    );
                }
            }
            return $Datos;
        }
    }
    #   VALIDAR SI YA EXISTE EL PROCESO
    public function procesoCAValido($PCierre)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $cierre = (array)$this->db_b->where("idyear_cierre", $PCierre)->get("ctcierres")->row();
            return ((count($cierre) > 0) ? false : true);
        }
    }
    #   SET PROCESO
    public function setProcesoPCA($data)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            //return true;
            if ($this->db_b->insert('ctcierres', $data)) return $this->db_b->insert_id();
            else return false;//*/
        }
    }
    #   UPDATE PROCESO
    public function updateProcesoPCA($data, $ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $this->db_b->where('trannum', $ID);
            if ($this->db_b->update('orders_100', $data)) return true;
            else return false;
        }
    }
    #   GET CUENTAS ACTUAILZADAS IN Y
    public function getRSCActualizadasInY($PCierre, $tipo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            switch ($tipo) {
                //  INGRESOS Y EGRESOS
                case 0:
                    $where = [
                        '((b.catgrupo = 4) OR (b.catgrupo = 5))',
                        '(YEAR(a.fecha) = '.$PCierre.')',
                        '(a.estatus = 1)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.idctcuenta as cuenta, b.descrip as ncuenta, b.catgrupo, b.ctcontrol');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.idctcuenta');
                    $this->db_b->order_by('a.idctcuenta', 'ASC');
                    $datos = $this->db_b->get();
                    return $datos;
                break;
                //  ACTIVO PASIVO CAPITAL
                case 1:
                    $where = [
                        '((b.catgrupo = 1) OR (b.catgrupo = 2) OR (b.catgrupo = 3))',
                        '(YEAR(a.fecha) = '.$PCierre.')',
                        '(a.estatus = 1)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.idctcuenta as cuenta, b.descrip as ncuenta, b.catgrupo, b.ctcontrol');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.idctcuenta');
                    $this->db_b->order_by('a.idctcuenta', 'ASC');
                    $datos = $this->db_b->get();
                    return $datos;
                break;
                case 2:
                break;
            }
        }
    }
    #   GET REGISTROS ACTUALIZADOS DE CUENTA IN AÑO
    public function getRegistrosACInY($PCierre, $cuenta, $TControles)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $where = [
                '(idctcuenta = '.$cuenta.')',
                '(YEAR(fecha) = '.$PCierre.')',
                '(estatus = 1)',
            ];
            $where = implode(' AND ', $where);
            switch ($TControles) {
                case 1:
                    $this->db_b->select('idtabla, idauxi, idcentro, idproject, doc_type, doc_serie, doc_numero');
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from('ct_100d');
                    $this->db_b->where($where);
                    $this->db_b->group_by('idtabla');
                    $this->db_b->group_by('idauxi');
                    $this->db_b->group_by('idcentro');
                    $this->db_b->group_by('idproject');
                    $datos = $this->db_b->get();
                break;
                case 2:
                    $this->db_b->select('idtabla, idauxi, idcentro, idproject, doc_type, doc_serie, doc_numero');
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from('ct_100d');
                    $this->db_b->where($where);
                    $this->db_b->group_by('idtabla');
                    $this->db_b->group_by('idauxi');
                    $this->db_b->group_by('idcentro');
                    $this->db_b->group_by('idproject');
                    $this->db_b->group_by('doc_type');
                    $this->db_b->group_by('doc_serie');
                    $this->db_b->group_by('doc_numero');
                    $datos = $this->db_b->get();
                break;
                default:
                    $this->db_b->select('idtabla, idauxi, idcentro, idproject, doc_type, doc_serie, doc_numero');
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from('ct_100d');
                    $this->db_b->where($where);
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }

    #------------------------------------------------------     FIN EDITOR DE PARTIDAS DE CIERRE Y APERTURA ANUAL ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     ASISTENTE CONTABLE ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET ASISTENTES CONTABLES
    public function getEAContable($Opcion)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            /*$this->db_b->where('pnumero', 56);
            $this->db_b->update('ct_100', array('origen' => 'AC_Abonos/0/185/11201'));//*/
            /*$this->db_b->where('pnumero', 49);
            $this->db_b->update('ct_100', array('origen' => 'AC_Quedan/0'));//*/

            #   VERIFICAR ACTUALIZACION DE CUENTA TIPO 3
            switch ($Opcion) {
                #   QUEDAN
                case 0:
                    $this->db_b->select('a.pnumero, a.fecha, a.idptipo as tpartida, a.origen, b.descrip as ntpartida, a.descrip');
                    $this->db_b->from('ct_100 a');
                    $this->db_b->join('ctpdef b', 'a.idptipo = b.idptipo');
                    $this->db_b->where('a.origen like "AC_Quedan%"');
                    $this->db_b->order_by('a.fecha', 'ASC');
                    $datos = $this->db_b->get();
                break;
                #   PAGOS
                case 1:
                    $this->db_b->select('a.pnumero, a.fecha, a.idptipo as tpartida, a.origen, b.descrip as ntpartida, a.descrip');
                    $this->db_b->from('ct_100 a');
                    $this->db_b->join('ctpdef b', 'a.idptipo = b.idptipo');
                    $this->db_b->where('a.origen like "AC_Pagos%"');
                    $this->db_b->order_by('a.fecha', 'ASC');
                    $datos = $this->db_b->get();
                break;
                #   ABONOS
                case 2:
                    $this->db_b->select('a.pnumero, a.fecha, a.idptipo as tpartida, a.origen, b.descrip as ntpartida, a.descrip');
                    $this->db_b->from('ct_100 a');
                    $this->db_b->join('ctpdef b', 'a.idptipo = b.idptipo');
                    $this->db_b->where('a.origen like "AC_Abonos%"');
                    $this->db_b->order_by('a.fecha', 'ASC');
                    $datos = $this->db_b->get();
                break;
                #   GASTOS
                case 3:
                break;
                #   DEPOSITOS
                case 4:
                break;
                #   TRANSFERENCIAS
                case 5:
                break;
            }
            return $datos;
        }
    }
    #   GET CONFIGURACION DE ASIST. CONTABLE
    public function getConfigAContable($variable)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            $config = $this->db_b->where("nombre", $variable)->get("gvars")->row();
            return $config;
        }
    }
    #   VALIDAR CONFIGURACION DE ASISTENTE CONTABLE
    public function validateVAC($Opcion, $variable)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            $valido = 0;
            $config = $this->getConfigAContable($variable);
            switch ($Opcion) {
                #   QUEDAN
                case 0:
                    if (count((array)$config) > 0) {
                        $tpartida = $this->getTPartida((int)$config->valor_txt);
                        if (count((array)$tpartida) > 0) {
                            if ($tpartida->estatus == 1) {
                                $valido = 7;
                                /*if (strlen(trim($tpartida->allowed_users)) > 0) {
                                    $found = 0;
                                    foreach (explode(',', $tpartida->allowed_users) as $iduser) {
                                        if ($iduser == (string)$this->session->userdata('iduser')) {
                                            $found = 1;
                                            break;
                                        }
                                    }
                                    if ($found == 1) $valido = -2;
                                    else $valido = 7;

                                } else $valido = 7;//*/
                            } else $valido = -1;
                        } else $valido = 0;
                    } else $valido = 0;
                break;
                #   PAGOS
                case 1:
                    if (count((array)$config) > 0) {
                        $tpartida = $this->getTPartida((int)$config->valor_txt);
                        if (count((array)$tpartida) > 0) {
                            if ($tpartida->estatus == 1) {
                                $valido = 7;
                            } else $valido = -1;
                        } else $valido = 0;
                    } else $valido = 0;
                break;
                #   ABONOS
                case 2:
                    if (count((array)$config) > 0) {
                        $tpartida = $this->getTPartida((int)$config->valor_txt);
                        if (count((array)$tpartida) > 0) {
                            if ($tpartida->estatus == 1) {
                                $valido = 7;
                            } else $valido = -1;
                        } else $valido = 0;
                    } else $valido = 0;
                break;
                #   GASTOS
                case 3:
                break;
                #   DEPOSITOS
                case 4:
                break;
                #   TRANSFERENCIAS
                case 5:
                break;
            }
            return $valido;
        }
    }
    #   GET DATA
    public function getDataAContable($opc, $extra)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   GET PARTIDAS - QUEDAN ACTIVAS
                case 0:
                    $this->db_b->select('pnumero');
                    $this->db_b->from('ct_100');
                    $this->db_b->where('origen like "AC_Quedan%"');
                    $this->db_b->where('estatus', 0);
                    $this->db_b->where('fecha', $extra);
                    $datos = $this->db_b->get();
                    $datos = $datos->num_rows();
                break;
                #   GET DOCUMENTOS PENDIENTES - PAGOS
                case 1:
                    $where = [
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '((estatus = 1) OR ((pnumero = '.$extra['pnumero'].') AND (estatus = 0 OR estatus = 1)))',
                    ];
                    $where = implode(" AND ", $where);
                    $this->db_b->select("idrec, descrip, doc_type, doc_serie, doc_numero, doc_emision, doc_vence, doc_idworker");
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->group_by("doc_serie");//-
                    $this->db_b->group_by("doc_numero");
                    $this->db_b->order_by("doc_emision", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET DOCUMENTOS PENDIENTES - ABONOS
                case 2:
                    $where = [
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '((estatus = 1) OR ((pnumero = '.$extra['pnumero'].') AND (estatus = 0 OR estatus = 1)))',
                    ];
                    $where = implode(" AND ", $where);
                    $this->db_b->select("idrec, descrip, doc_type, doc_serie, doc_numero");
                    $this->db_b->select("doc_emision, doc_vence, doc_idworker");
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->group_by("doc_serie");//-
                    $this->db_b->group_by("doc_numero");
                    $this->db_b->order_by("doc_emision", "ASC");
                    $datos = $this->db_b->get();
                break;
                case 3:
                break;
                case 4:
                break;
                case 5:
                break;
            }
            return $datos;
        }
    }
    #   GET DATA PARTIDA
    public function getDataPartida($opc, $extra)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   GET PARTIDA SIMPLE
                case 0:
                    $datos = $this->db_b->where("pnumero", $extra)->get("ct_100")->row();
                break;
                #   GET TOTAL DEBE - PAGOS
                case 1:
                    $where = [
                        '(pnumero = '.$extra['pnumero'].')',
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(doc_controlnum = "Abono")',
                        '((estatus = 0) OR (estatus = 1))',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select_sum("debe");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->group_by("pnumero");
                    $data = $this->db_b->get()->row();
                    $datos = (count((array)$data) > 0) ? $data->debe : 0;
                break;
                #   GET MOVIMEINTO DE PAGO FINAL - PAGOS
                case 2:
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.haber = '.(float)($extra['monto']).')',
                        '((a.estatus = 0) OR (a.estatus = 1))',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.*, b.ctcontrol, b.askidcentro, b.askidproyecto");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $datos = $this->db_b->get()->row();
                    //$datos = $this->db_b->where($where)->get("ct_100d")->row();
                break;
                #   CUADRE DE UNA PARTIDA DE QUEDAN
                case 3:
                    $where = [
                        '(a.pnumero = '.$extra.')',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.estatus != 9)',
                        '(a.doc_controlnum != "Cargo")',
                        '(a.doc_controlnum != "Abono")'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select_sum("a.haber");
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.pnumero');
                    $datos = $this->db_b->get()->row();
                    $Totalhaber = (count((array)$datos) > 0) ? $datos->haber : 0;

                    $where = [
                        '(a.pnumero = '.$extra.')',
                        '(a.estatus != 9)',
                        '(a.doc_controlnum != "Cargo")',
                        '(a.doc_controlnum != "Abono")',
                        '(length(a.doc_controlnum) > 0)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select_sum("a.debe");
                    $this->db_b->select_sum("a.haber");
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.pnumero');
                    $datos = $this->db_b->get()->row();
                    $Totaldebe = (count((array)$datos) > 0) ? ($datos->debe - $datos->haber) : 0;

                    $datos = $Totalhaber - $Totaldebe;
                break;
                #   GET TOTAL HABER - ABONOS DE CLIENTES
                case 4:
                    $where = [
                        '(pnumero = '.$extra['pnumero'].')',
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(doc_controlnum = "Abono")',
                        '((estatus = 0) OR (estatus = 1))',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select_sum("haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->group_by("pnumero");
                    $data = $this->db_b->get()->row();
                    $datos = (count((array)$data) > 0) ? $data->haber : 0;
                break;
                #   GET MOVIMEINTO DE PAGO FINAL - ABONOS
                case 5:
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.debe = '.(float)($extra['monto']).')',
                        '((a.estatus = 0) OR (a.estatus = 1))',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.*, b.ctcontrol, b.askidcentro, b.askidproyecto");
                    $this->db_b->select("c.descrip as centro, d.descrip as proyecto");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->join("invsites c", "a.idcentro = c.idcentro", 'left');
                    $this->db_b->join("ctproj d", "a.idproject = d.idproject", 'left');
                    $this->db_b->where($where);
                    $datos = $this->db_b->get()->row();
                break;
            }
            return $datos;
        }
    }
    #   MULTIPLES OPCIONES
    public function multiplesOpcionesAC($opc, $extra)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            $data = true;
            switch ($opc) {
                case 0:
                    $this->db_b->where('nombre', $extra['nombre']);
                    if ($this->db_b->update('gvars', $extra['data'])) return true;
                    else return false;
                break;
            }
            return $data;
        }
    }
    #------------------------------------------------------     ASIST. CONTABLE DETALLE
    #   GET ASISTENTE CONTABLE DETALLE
    public function getACDetalle($opc, $extra)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                case 0:
                    $where = [
                        '(a.pnumero = '.$extra.')',
                        '(a.estatus != 9)',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.doc_controlnum != "Abono")',
                        '(a.doc_controlnum != "Cargo")',
                        '(length(a.doc_controlnum) = 0)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.*, b.descrip as tcuenta, b.catgrupo, b.ctcontrol, c.descrip as proveedor");
                    $this->db_b->select("(SELECT COUNT(hijos.idrec) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as conteo");
                    $this->db_b->select("(SELECT SUM(hijos.debe) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as totaldebe");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->join('ctauxi c', 'a.idauxi = c.idauxi');
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                case 1:
                case 2:
                    $where = [
                        '(pnumero = '.$extra['pnumero'].')',
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(doc_controlnum = "Abono")',
                        '((estatus = 0) OR (estatus = 1))',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("idrec, itemline, idctcuenta, idauxi, idtabla, idcentro, idproject");
                    $this->db_b->select("descrip, doc_type, doc_serie, doc_numero, doc_emision, debe, haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->order_by("itemline", "ASC");
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }
    #   GET DETALLE DATA GENERAL
    public function getACDetalleData($opc, $extra = null)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   GET USUARIOS
                case -4:
                    $this->db_b->select("iduser, descrip");
                    $this->db_b->from("gusers");
                    $this->db_b->where('estado', 1);
                    $this->db_b->where('iduser != ', 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                # (MEJORA) GET MONTO DE DOCUMENTO PENDIENTE X CUENTA
                case -3.5:
                    $having = [
                        '((SUM(debe) > 0) OR (SUM(haber) > 0))',
                        '(SUM(debe) > 0 != SUM(haber) > 0)'
                    ];
                    $having = implode(" AND ", $having);
                    $where = [
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(estatus = 1)',
                    ];
                    $where = implode(" AND ", $where);
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->having($having);
                    $datos = $this->db_b->get()->row();
                break;
                #   GET DOCUMENTOS PENDIENTES DE CUENTA
                case -3:
                    $having = [
                        '((SUM(debe) > 0) OR (SUM(haber) > 0))',
                        '(SUM(debe) > 0 != SUM(haber) > 0)'
                    ];
                    $having = implode(" AND ", $having);
                    $where = [
                        '(idctcuenta = "'.$extra['idcuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(estatus = 1)',
                    ];
                    $where = implode(" AND ", $where);
                    $this->db_b->select_sum("debe");
                    $this->db_b->select_sum("haber");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->group_by("doc_serie");
                    $this->db_b->group_by("doc_numero");
                    $this->db_b->having($having);
                    $datos = $this->db_b->get();
                break;
                #   GET CUENTAS ACTIVAS X LISTA [a, b, c] CON DOCUMENTOS ACTIVOS y CON AUXI
                case -2:
                    foreach ($extra as $key => $dato) {
                        $extra[$key] = '(a.idctcuenta = "'.$dato.'")';
                    }
                    $where = [
                        '('.implode(' OR ', $extra).')',
                        '(a.estatus = 1)',
                        '(b.estatus = 1)',
                        '(length(a.doc_serie) > 0)',
                        '(length(a.doc_numero) > 0)',
                        '(length(b.useauxi) > 0)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('b.idrec, b.idctcuenta, b.descrip, b.catgrupo, b.useauxi, b.askidcentro');
                    $this->db_b->select('b.askidproyecto, b.ctcontrol, b.allowed_users as malos');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by("a.idctcuenta");
                    $datos = $this->db_b->get();
                break;
                #   GET CUENTAS ACTIVAS X IDCUENTA LISTA  [a, b, c]
                case -1:
                    foreach ($extra as $key => $dato) {
                        $extra[$key] = '(idctcuenta = "'.$dato.'")';
                    }
                    $where = [
                        '('.implode(' OR ', $extra).')',
                        '(estatus = 1)'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('idrec, idctcuenta, descrip, useauxi, askidcentro, askidproyecto, ctcontrol, allowed_users as malos');
                    $this->db_b->from('ctcuenta');
                    $this->db_b->where($where);
                    //$this->db_b->order_by('idctcuenta', 'ASC');
                    $datos = $this->db_b->get();
                break;
                #   GET CUENTAS ACTIVAS G2  -T2
                case 0:# 0
                    $this->db_b->select('idctcuenta, descrip, useauxi, askidcentro, askidproyecto, allowed_users as malos');
                    $this->db_b->from('ctcuenta');
                    $this->db_b->where('catgrupo', 2);
                    $this->db_b->where('ctcontrol', 2);
                    $this->db_b->where('estatus', 1);
                    $this->db_b->order_by('idctcuenta');
                    $datos = $this->db_b->get();
                break;
                #   GET CENTROS ACTIVOS X ID LISTA [1,2...]
                case 1:
                    $centros = explode(',', $extra);
                    foreach ($centros as $key => $dato) {
                        $centros[$key] = '(idcentro = '.$dato.')';
                    }
                    $where = [
                        '('.implode(' OR ', $centros).')',
                        '(estatus = 1)'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('idcentro, descrip');
                    $this->db_b->from('invsites');
                    $this->db_b->where($where);
                    $this->db_b->order_by('descrip');
                    $datos = $this->db_b->get();
                break;
                #   GET PROYECTOS ACTIVOS
                case 2:
                    $this->db_b->select("Idproject, descrip");
                    $this->db_b->from("ctproj");
                    $this->db_b->where("estatus", 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET TIPOS DE DOCUMENTOS
                case 3:
                    $where = [
                        '(agrupa = "VN")',
                        '(agrupa = "CO")',
                    ];
                    $where = implode(' OR ', $where);
                    $this->db_b->select("invclase as id, descrip, agrupa as grupo");
                    $this->db_b->from("inv_def");
                    $this->db_b->where($where);
                    $this->db_b->order_by("agrupa", "ASC");
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET AUXILIARES-PRODUCTOS ACTIVOS X USEAUXI
                case 4:
                    $dato = $extra;
                    if ($dato[0] == "1") {
                        $this->db_b->select("idauxi as id, descrip, dias, imagen");
                        $this->db_b->from("ctauxi");
                        $this->db_b->where("idauxidef", $dato[1]);
                    }
                    else if($dato[0] == "2"){
                        $this->db_b->select("idproducto as id, descrip, 0 as dias, imagen");
                        $this->db_b->from("invproducts");
                        $this->db_b->where("tipo", $dato[1]);
                    }
                    $this->db_b->where("estado", 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET GESTORES
                case 5:
                    $this->db_b->select("idauxi as id, descrip");
                    $this->db_b->from("ctauxi");
                    $this->db_b->where("idauxidef", 3);
                    $this->db_b->where("estado", 1);
                    $this->db_b->order_by("descrip", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET SERIES UTILIZADAS CON CUENTA - AUXILIAR - TIPO DOCUMENTO
                case 6:
                    $this->db_b->select("doc_serie as descrip");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where("idctcuenta", $extra['cuenta']);
                    $this->db_b->where("idtabla", $extra['idtabla']);
                    $this->db_b->where("idauxi", $extra['idauxi']);
                    $this->db_b->where("doc_type", $extra['tipodoc']);
                    $this->db_b->where("estatus != ", 9);
                    $this->db_b->group_by("doc_serie");
                    $this->db_b->order_by("doc_serie", "DESC");
                    $datos = $this->db_b->get();
                break;
                #   VALIDAR NUMERO (0 o 1) CUENTA - AUXILIAR - TIPO DOCUMENTO - SERIE Y NUMERO
                case 7:
                    $where = [
                        '(idctcuenta = "'.$extra['cuenta'].'")',
                        '(idtabla = '.$extra['idtabla'].')',
                        '(idauxi = '.$extra['idauxi'].')',
                        '(doc_type = "'.$extra['tipodoc'].'")',
                        '(doc_serie = "'.$extra['serie'].'")',
                        '(doc_numero = "'.$extra['numero'].'")',
                        '((estatus = 0) OR (estatus = 1))',
                    ];
                    if (isset($extra['ID'])) $where[] = '(idrec != '.$extra['ID'].')';
                    $where = implode(' AND ', $where);
                    $this->db_b->select("doc_numero");
                    $this->db_b->from("ct_100d");
                    /*$this->db_b->where("idctcuenta", $extra['cuenta']);
                    $this->db_b->where("idtabla", $extra['idtable']);
                    $this->db_b->where("idauxi", $extra['idauxi']);
                    $this->db_b->where("doc_type", $extra['tipodoc']);
                    $this->db_b->where("doc_serie", $extra['serie']);
                    $this->db_b->where("doc_numero", $extra['numero']);//*/
                    $this->db_b->where($where);
                    $datos = $this->db_b->get()->num_rows();
                break;
                #   GET TOTAL HABER QUEDAN DE DOCUMENTOS ACTIVOS G2 - T2 IN/ACTUALIZADA
                case 8:
                    $where = [
                        '(a.pnumero = '.$extra.')',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.estatus != 9)',
                        '(a.doc_controlnum != "Cargo")',
                        '(a.doc_controlnum != "Abono")'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select_sum("a.haber");
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.pnumero');
                    $datos = $this->db_b->get()->row();
                    $datos = (count((array)$datos) > 0) ? $datos->haber : 0;
                break;
                #   GET HIJOS DE QUEDAN CON ID Y PNUMERO QUEDAN
                case 9:
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.estatus != 9)',
                        '(a.doc_controlnum = "'.$extra['controlnum'].'")',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo, b.ctcontrol, b.askidcentro as usec, b.askidproyecto as usep");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET HISOTRICO-DESTINOS X ID CUENTAS
                case 10:
                    foreach ($extra['IDS'] as $key => $destino) {
                        $extra['IDS'][$key] = '(a.idctcuenta = '.$destino.')';
                    }
                    $where = [
                        '(a.estatus != 9)',
                        '(a.doc_controlnum != "'.$extra['IDQuedanA'].'")',
                        '(b.estatus != 9)',
                        '(length(b.doc_controlnum) = 0)',
                        '(b.idctcuenta = "'.$extra['cuenta'].'")',
                        '(b.idtabla = "'.$extra['idtabla'].'")',
                        '(b.idauxi = "'.$extra['idauxi'].'")',
                        '('.implode('OR', $extra['IDS']).')'
                    ];
                    //print_r($where);
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.idctcuenta, a.idtabla, a.idauxi, c.descrip as cuenta');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join("ct_100d b", "a.doc_controlnum = b.idrec");
                    $this->db_b->join("ctcuenta c", "a.idctcuenta = c.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.idctcuenta');
                    $this->db_b->group_by('a.idtabla');
                    $this->db_b->group_by('a.idauxi');//*/
                    $this->db_b->order_by("a.ingresa", "DESC");
                    $this->db_b->limit(10);
                    $datos = $this->db_b->get();//*/
                break;
                #   GET DESCRIP DE HISOTRICO-DESTINOS X CUENTA
                case 11:
                    $where = [
                        '(a.doc_controlnum != "'.$extra['IDQuedanA'].'")',
                        '(a.idctcuenta = "'.$extra['cuenta'].'")',
                        '(a.idtabla = "'.$extra['idtabla'].'")',
                        '(a.idauxi = "'.$extra['idauxi'].'")',
                        '(b.estatus != 9)',
                        '(length(b.doc_controlnum) = 0)',
                        '(b.idctcuenta = "'.$extra['cuentaPadre'].'")',
                        '(b.idtabla = "'.$extra['idtablaPadre'].'")',
                        '(b.idauxi = "'.$extra['idauxiPadre'].'")',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.descrip');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join("ct_100d b", "a.doc_controlnum = b.idrec");
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.ingresa", "DESC");
                    $datos = $this->db_b->get()->first_row();
                break;
                #   GET HIJOS DE QUEDAN SIMPLE - TO Copy Estruct
                case 12:
                    $where = [
                        '(estatus != 9)',
                        '(doc_controlnum = "'.$extra.'")',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("idrec, idctcuenta, descrip, idtabla, idauxi, idcentro, idproject");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where($where);
                    $this->db_b->order_by("idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET HIJOS DE QUEDAN - PRODUCTOS/GASTOS
                case 13:
                    foreach ($extra['IDS'] as $key => $destino) {
                        $extra['IDS'][$key] = '(a.idctcuenta = '.$destino.')';
                    }
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.estatus != 9)',
                        '(a.doc_controlnum = "'.$extra['controlnum'].'")',
                        '('.implode('OR', $extra['IDS']).')'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo, b.ctcontrol, b.askidcentro as usec, b.askidproyecto as usep");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET INFORMACION TOTAL DE 1 QUEDAN
                case 14:
                    $where = [
                        '(a.estatus != 9)',
                        '(a.idrec = '.$extra.')',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select('a.doc_type, a.doc_serie, a.doc_numero, a.haber, a.doc_datos');
                    $this->db_b->select('a.doc_emision, a.doc_vence, a.idtabla, a.idauxi');
                    $this->db_b->select('b.descrip as tauxi, b.direccion, b.telefono, b.dias');
                    $this->db_b->select('a.idcentro, d.descrip as centro, a.idproject, e.descrip as proyecto');
                    $this->db_b->select('a.doc_idworker, a.descrip, a.idctcuenta, c.askidcentro as usec, c.askidproyecto as usep');
                    $this->db_b->select("(SELECT SUM(hijos.debe) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as totaldebe");
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctauxi b', 'a.idauxi = b.idauxi');
                    $this->db_b->join('ctcuenta c', 'a.idctcuenta = c.idctcuenta');
                    $this->db_b->join('invsites d', 'a.idcentro = d.idcentro', 'left');
                    $this->db_b->join('ctproj e', 'a.idproject = e.idproject', 'left');
                    $this->db_b->where($where);
                    $datos = $this->db_b->get()->row();
                break;
                #   GET IMPUESTOS-IVA CON INFO X IDCUENTA LISTA  [a, b, c]
                case 15:
                    foreach ($extra['IDS'] as $key => $gasto) {
                        $extra['IDS'][$key] = '(a.idctcuenta = '.$gasto.')';
                    }
                    //print_r($extra['IDS']);
                    $where = [
                        //'(b.pnumero = '.$extra['pnumero'].')',
                        //'(b.estatus != 9)',
                        //'(b.doc_controlnum = "'.$extra['controlnum'].'")',
                        //'('.implode(' OR ', $extra['IDS']).')',
                        implode(' OR ', $extra['IDS']),
                    ];
                    $where = implode(' AND ', $where);
                    /*$this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo, b.ctcontrol, b.askidcentro as usec, b.askidproyecto as usep");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.idctcuenta", "ASC");//*/
                    $this->db_b->select("a.idctcuenta, a.descrip as cuenta, a.catgrupo, a.ctcontrol, a.askidcentro as usec, a.askidproyecto as usep, a.useauxi");
                    $this->db_b->select("b.idrec, b.idtabla, b.idauxi, b.idcentro, b.idproject, IFNULL(b.descrip, '') as descripcion, IFNULL(SUM(b.debe), 0) as debe, , IFNULL(SUM(b.haber), 0) as haber");
                    $this->db_b->from("ctcuenta a");
                    $this->db_b->join("ct_100d b", '(a.idctcuenta = b.idctcuenta) AND (b.estatus != 9) AND (b.pnumero = '.$extra['pnumero'].') AND (b.doc_controlnum = "'.$extra['controlnum'].'")', "left");
                    $this->db_b->where($where);
                    $this->db_b->group_by("a.idctcuenta");
                    $datos = $this->db_b->get();
                break;
                #   GET NRESOLUCIONES UTILIZADOS CON CUENTA - AUXILIAR - TIPO DOCUMENTO
                case 16:
                    $this->db_b->select("doc_datos as nresolucion");
                    $this->db_b->from("ct_100d");
                    $this->db_b->where("idctcuenta", $extra['cuenta']);
                    $this->db_b->where("idtabla", $extra['idtabla']);
                    $this->db_b->where("idauxi", $extra['idauxi']);
                    $this->db_b->where("doc_type", $extra['tipodoc']);
                    $this->db_b->where("length(doc_datos) >", 0);
                    $this->db_b->where("estatus != ", 9);
                    $this->db_b->group_by("doc_datos");
                    $this->db_b->order_by("ingresa", "DESC");
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }
    #   GET DATA PARA REPORTES
    public function getDataRAContable($opc, $extra = null)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('CerrarSesion');
        } else {
            switch ($opc) {
                #   GET DOCUMENTOS TODOS X PNUMERO AGRUPADO PROVEEDOR
                case 0:
                    $where = [
                        '(a.pnumero = '.$extra.')',
                        '(a.estatus != 9)',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.doc_controlnum != "Abono")',
                        '(a.doc_controlnum != "Cargo")',
                        '(length(a.doc_controlnum) = 0)',
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.idrec, a.idtabla, a.idauxi");
                    //$this->db_b->select("(SELECT COUNT(hijos.idrec) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as conteo");
                    //$this->db_b->select("(SELECT SUM(hijos.debe) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as totaldebe");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->group_by("a.idtabla");
                    $this->db_b->group_by("a.idauxi");
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET DOCUMENTOS LISTA X PNUMERO AGRUPADO PROVEEDOR
                case 1:
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.estatus != 9)',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.doc_controlnum != "Abono")',
                        '(a.doc_controlnum != "Cargo")',
                        '(length(a.doc_controlnum) = 0)',
                        '('.implode('OR', $extra['IDS']).')'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.idrec, a.idtabla, a.idauxi");
                    //$this->db_b->select("(SELECT COUNT(hijos.idrec) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as conteo");
                    //$this->db_b->select("(SELECT SUM(hijos.debe) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as totaldebe");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->group_by("a.idtabla");
                    $this->db_b->group_by("a.idauxi");
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
                #   GET INFORMACION DE EMPRESA
                case 3:
                    $dato = $this->db_b->where("valor_num", $extra)->where("nombre", 'g_empdatos')->get("gvars")->row();
                    $datos = (count((array)$dato) > 0) ? $dato->valor_memo : '';
                break;
                #   GET DOCUMENTOS DE PROVEEDOR ESPECIFICO
                case 4:
                    $where = [
                        '(a.pnumero = '.$extra['pnumero'].')',
                        '(a.estatus != 9)',
                        '(b.catgrupo = 2)',
                        '(b.ctcontrol = 2)',
                        '(a.doc_controlnum != "Abono")',
                        '(a.doc_controlnum != "Cargo")',
                        '(length(a.doc_controlnum) = 0)',
                        '(a.idtabla = '.$extra['idtabla'].')',
                        '(a.idauxi = '.$extra['idauxi'].')',
                        '('.implode('OR', $extra['IDS']).')'
                    ];
                    $where = implode(' AND ', $where);
                    $this->db_b->select("a.idrec, a.doc_type, a.doc_serie, a.doc_numero, a.haber");
                    //$this->db_b->select("(SELECT COUNT(hijos.idrec) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as conteo");
                    //$this->db_b->select("(SELECT SUM(hijos.debe) FROM ct_100d AS hijos WHERE hijos.doc_controlnum = a.idrec AND hijos.estatus != 9) as totaldebe");
                    $this->db_b->from("ct_100d a");
                    $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
                    $this->db_b->where($where);
                    $this->db_b->order_by("a.idrec", "ASC");
                    $datos = $this->db_b->get();
                break;
            }
            return $datos;
        }
    }
    #------------------------------------------------------      FIN ASIST. CONTABLE DETALLE
    #------------------------------------------------------     FIN ASISTENTE CONTABLE ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     EXPORTAR DE COMPRAS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function multiECompras($opc, $extra = null)
    {
        if($this->validatePermiso()) {
            switch ($opc) {
                case 1:#    GET CUENTAS CXC CON MOVIMIENTOS
                    $where = implode(' AND ', [
                        '(b.ctcontrol = 2)',
                        '(a.estatus = 1)',
                    ]);
                    $order = implode(', ', [
                        'a.idctcuenta ASC', 'b.descrip ASC'
                    ]);
                    $this->db_b->select('a.idctcuenta, TRIM(b.descrip) as descrip');
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->group_by('a.idctcuenta');
                    $this->db_b->order_by($order);
                    $datos = $this->db_b->get();
                break;
                /*case 2:#    GET CUENTAS DE IMPUESTO ACTIVAS
                    $where = implode(' AND ', [
                        //'(ctcontrol = 3)',
                        '(estatus = 1)',
                        '(tipocuenta = 3)',
                    ]);
                    $order = implode(', ', [
                        'idctcuenta ASC',
                    ]);
                    $this->db_b->select('idctcuenta, TRIM(descrip) as descrip');
                    $this->db_b->from('ctcuenta');
                    $this->db_b->where($where);
                    $this->db_b->order_by($order);
                    $datos = $this->db_b->get();
                break;//*/
                case 3:#    GET COMPRAS POR CUENTA
                    $where = implode(' AND ', [
                        '(a.idctcuenta = "'.$extra['cta'].'")',
                        '(b.ctcontrol = 2)',
                        '(a.estatus = 1)',
                        '(length(a.doc_controlnum) = 0)',
                        '(a.doc_emision BETWEEN "'.$extra['fi'].'" AND "'.$extra['ff'].'")',
                    ]);
                    $order = implode(', ', [
                        'a.fecha ASC',
                    ]);
                    $select = implode(', ', [
                        'a.pnumero, a.itemline, a.doc_emision, a.doc_serie, a.doc_numero, a.idauxi',
                        'TRIM(c.descrip) as proveedor, c.nrc, c.nit, TRIM(c.direccion) as direccion, TRIM(c.giro) as giro, c.idtipo',
                        'TRIM(IFNULL(e.municipio, "")) as municipio, TRIM(IFNULL(e.depto, "")) as departamento',
                        'IFNULL(d.xpos, "") as xposcentro, (CASE
                            WHEN a.debe = 0 THEN a.haber
                            WHEN a.haber = 0 THEN a.debe
                            ELSE 0
                        END) as vtotal',
                    ]);
                    $this->db_b->select($select);
                    $this->db_b->from('ct_100d a');
                    $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
                    $this->db_b->join('ctauxi c', 'a.idauxi = c.idauxi');
                    $this->db_b->join('invsites d', 'a.idcentro = d.idcentro', 'left');
                    $this->db_b->join('gzips e', 'c.idzip = e.idzip', 'left');
                    $this->db_b->where($where);
                    $this->db_b->order_by($order);
                    $datos = $this->db_b->get();
                break;
                /*case 4:#    GET IMPUESTOS DE COMPRAS
                    $where = implode(' AND ', [
                        '(idctcuenta = "'.$extra['cta'].'")',
                        '(estatus = 1)',
                        '(pnumero = '.$extra['pnum'].')'
                    ]);
                    $order = implode(', ', ['itemline ASC']);
                    $select = implode(', ', [
                        'idctcuenta, itemline, (CASE
                            WHEN a.debe = 0 THEN a.haber
                            WHEN a.haber = 0 THEN a.debe
                            ELSE 0
                        END) as vtotal'
                    ]);
                    $this->db_b->select($select);
                    $this->db_b->from('ct_100d');
                    $this->db_b->where($where);
                    $this->db_b->order_by($order);
                    $datos = $this->db_b->get();
                break;//*/
                default:
                    $datos = false;
                break;
            }
            return $datos;
        }
    }
    #----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function getListadoPartidas($tipo, $fechai, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.pnumero, a.descrip, a.referencia");
            $this->db_b->from("ct_100 a");
            $this->db_b->where("a.idptipo", $tipo);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->where("a.fecha >=", $fechai);
            $this->db_b->where("a.fecha <=", $fechaf);
            $this->db_b->order_by("a.pnumero", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }

    public function getListadoFuncionesExport($tipo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.posicion, a.funcion, a.descrip, a.idcentros, a.idcajas, a.idclases, a.cajclases, a.dh, a.idcuenta, a.idauxi");
            $this->db_b->from("conta_genfunc a");
            $this->db_b->where("a.estado", 1);
            $this->db_b->where("a.partipo", $tipo);
            $this->db_b->order_by("a.posicion", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }

    public function multiFuncionesExport($pnumero, $funcion, $dh, $idcuenta, $idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            switch ($funcion) {
                case 'getDatosCompra':
                    $this->db_b->select("b.doc_emision, b.doc_serie, b.doc_numero, c.descrip, c.nrc");
                    $this->db_b->from("ct_100 a");
                    $this->db_b->join("ct_100d b", "a.pnumero = b.pnumero");
                    $this->db_b->join("ctauxi c", "b.idauxi = c.idauxi");
                    $this->db_b->where("a.estatus", 1);
                    $this->db_b->where("b.pnumero", $pnumero);
                    $this->db_b->where("b.idctcuenta", $idcuenta);
                    $this->db_b->group_by("b.pnumero");
                    $data = $this->db_b->get();
                    if ($data->num_rows() > 0) {
                        $dato = $data->row();
                    } else $dato = false;
                    
                    return $dato;
                    break;
                case 'getComprasGravadas':
                    
                    $this->db_b->select("b.pnumero");
                    $this->db_b->select_sum("b.debe");
                    $this->db_b->select_sum("b.haber");
                    $this->db_b->from("ct_100 a");
                    $this->db_b->join("ct_100d b", "a.pnumero = b.pnumero");
                    $this->db_b->where("a.estatus", 1);
                    $this->db_b->where("b.pnumero", $pnumero);
                    $this->db_b->where("b.idctcuenta", $idcuenta);
                    $this->db_b->where("b.idauxi", $idauxi);
                    $this->db_b->group_by("b.pnumero");
                    $data = $this->db_b->get();

                    if($dh == 1){
                        if ($data->num_rows() > 0) {
                            $dato = $data->row()->debe;
                        } else $dato = 0;
                    }else{
                        if ($data->num_rows() > 0) {
                            $data->row()->haber;
                        } else $dato = 0;
                    }
                    

                    return $dato;
                    break;
                case 'getTotalCuenta':

                    $this->db_b->select("b.pnumero");
                    $this->db_b->select_sum("b.debe");
                    $this->db_b->select_sum("b.haber");
                    $this->db_b->from("ct_100 a");
                    $this->db_b->join("ct_100d b", "a.pnumero = b.pnumero");
                    $this->db_b->where("a.estatus", 1);
                    $this->db_b->where("b.pnumero", $pnumero);
                    $this->db_b->where("b.idctcuenta", $idcuenta);
                    //$this->db_b->where("b.idauxi", $idauxi);
                    $this->db_b->group_by("b.pnumero");
                    $data = $this->db_b->get();

                    if($dh == 1){
                        if ($data->num_rows() > 0) {
                            $dato = $data->row()->debe;
                        } else $dato = 0;
                    }else{
                        if ($data->num_rows() > 0) {
                            $dato = $data->row()->haber;
                        } else $dato = 0;
                    }

                    return $dato;
                    break;
                case 'getIvaCompras':
                    $this->db_b->select("b.pnumero");
                    $this->db_b->select_sum("b.debe");
                    $this->db_b->select_sum("b.haber");
                    $this->db_b->from("ct_100 a");
                    $this->db_b->join("ct_100d b", "a.pnumero = b.pnumero");
                    $this->db_b->where("a.estatus", 1);
                    $this->db_b->where("b.pnumero", $pnumero);
                    $this->db_b->where("b.idctcuenta", $idcuenta);
                    $this->db_b->where("b.idauxi", $idauxi);
                    $this->db_b->group_by("b.pnumero");
                    $data = $this->db_b->get();

                    if($dh == 1){
                        if ($data->num_rows() > 0) {
                            $dato = $data->row()->debe;
                        } else $dato = 0;
                    }else{
                        if ($data->num_rows() > 0) {
                            $dato = $data->row()->haber;
                        } else $dato = 0;
                    }

                    return $dato;
                    break;
                default:
                    return false;
                    break;
            }
        }
    }
    
    #------------------------------------------------------     FIN EXPORTAR DE COMPRAS ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------     ANALISIS DE CARTERA ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET CU8ENTAS  ------------------------------------------ ***
    public function getCtasA()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.idrec, a.idctcuenta, a.doc_emision, b.catgrupo, b.descrip");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.estatus", 1);
            $this->db_b->where("b.ctcontrol", 2);
            $this->db_b->group_by("a.idctcuenta");
            $this->db_b->order_by("b.descrip", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    //---------------------------------------------------------------GRAFICA
    public function getCtasA2($cuenta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //$this->db_b->select("idrec, pnumero, idctcuenta, itemline, debe, haber");
            //$this->db_b->select("idrec, debe, haber");
            $this->db_b->select("idrec, doc_emision, doc_type, doc_serie, doc_numero, idtabla, idauxi");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");//*/
            $this->db_b->from("ct_100d");
            $this->db_b->where("estatus", 1);
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->group_by("doc_type");
            $this->db_b->group_by("doc_serie");
            $this->db_b->group_by("doc_numero");
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");
            $this->db_b->order_by("doc_emision", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getCtasA3($cuenta, $doc, $serie, $numero, $idtabla, $idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //$this->db_b->select("idrec, pnumero, idctcuenta, itemline, debe, haber");
            //$this->db_b->select("idrec, debe, haber");
            $this->db_b->select("idrec, doc_emision, idtabla, idauxi");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");//*/
            $this->db_b->from("ct_100d");
            $this->db_b->where("estatus", 1);
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("doc_type", $doc);
            $this->db_b->where("doc_serie", $serie);
            $this->db_b->where("doc_numero", $numero);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);

            /*$this->db_b->group_by("doc_type");
            $this->db_b->group_by("doc_serie");
            $this->db_b->group_by("doc_numero");
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");//*/
            $this->db_b->order_by("doc_emision", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getResponsable($ID, $tabla)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            if ($tabla == "1") {
                return $this->db_b->where("idauxi", $ID)->get("ctauxi")->row();
            }
            else if($tabla == "2"){
                return $this->db_b->where("idproducto", $ID)->get("invproducts")->row();
            }
        }
    }
    #   FIN GET CUENTAS
    //---------------------------------------------------------------GRID
    #   GET REGISTROS-----*
    /*public function getRegistros($cuenta)//----------------quiza
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, pnumero, doc_serie, doc_numero, doc_emision, doc_vence, idtabla, idauxi, debe, haber");
            $this->db_b->from("ct_100d");
            $this->db_b->where("estatus", 1);
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->order_by("descrip", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }//*/
    public function getCtasB1($cuenta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, pnumero, doc_emision, doc_vence, doc_controlnum as control, doc_type, doc_serie, doc_numero, idtabla, idauxi");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");//*/
            $this->db_b->from("ct_100d");
            $this->db_b->where("estatus", 1);
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->group_by("doc_type");
            $this->db_b->group_by("doc_serie");
            $this->db_b->group_by("doc_numero");
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");
            $this->db_b->order_by("ingresa", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getCtasB2($ID, $cuenta, $doc, $serie, $numero, $idtabla, $idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            //$this->db_b->select("idrec, pnumero, idctcuenta, itemline, debe, haber");
            //$this->db_b->select("idrec, debe, haber");
            $this->db_b->select("idrec, pnumero, fecha, descrip, doc_emision, doc_controlnum, idtabla, idauxi, debe, haber, whodidit");
            $this->db_b->from("ct_100d");
            $this->db_b->where("estatus", 1);
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("doc_type", $doc);
            $this->db_b->where("doc_serie", $serie);
            $this->db_b->where("doc_numero", $numero);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);
            $this->db_b->where("idrec !=", $ID);

            /*$this->db_b->group_by("doc_type");
            $this->db_b->group_by("doc_serie");
            $this->db_b->group_by("doc_numero");
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");//*/
            //$this->db_b->order_by("doc_emision", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    public function getAutor($ID)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("descrip");
            $this->db_b->from("gusers");
            $this->db_b->where('iduser', $ID);
            $dato = $this->db_b->get()->row()->descrip;
            return $dato;
        }
    }
    #   FIN GET REGISTROS

    #------------------------------------------------------     FIN ANALISIS DE CARTERA ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------    CONSULTA GENERAL CUENTAS ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------   BALANCE DE COMPROBACION
    #   GET TODAS LAS CUENTAS
    public function getAllCuentas()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus");
            $this->db_b->from("ctcuenta");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }

    public function getAllCuentasReports($nivel)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("LENGTH(idctcuenta) <=", $nivel);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET TODAS LAS CUENTAS
    #   GET TODAS LAS CUENTAS3
    public function getAllCuentas3()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, askidcentro, askidproyecto, useauxi");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }

    public function getAllCuentas3Reports($nivel)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, askidcentro, askidproyecto, useauxi");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->where("LENGTH(idctcuenta) <=", $nivel);
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET TODAS LAS CUENTAS3
    #   GET TODAS LAS CUENTAS4
    public function getAllCuentas4($idCuenta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, askidcentro, askidproyecto, useauxi");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->where("idctcuenta", "".$idCuenta."");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET TODAS LAS CUENTAS4
    #   REGISTROS DE SALDO ?
    public function existensaldos()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $datos = $this->db_b->get()->num_rows();
            return $datos;
        }
    }
    #   REGISTROS DE SALDO ?
    #   CONSULTAR CUENTA S
    public function getSaldoCuenta($cuenta, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("fecha <=", $fechaf);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN CONSULTAR CUENTA S
    #------------------------------------------------- GRAFICO
    #   GET SALDOS CUENTA 3 POR MES
    public function getSaldoCuentabyM($cuenta, $fechai, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idctcuenta, idtabla, idauxi, idcentro, idproject, lastpnumero, fecha, MONTH(fecha) as idmes, YEAR(fecha) as idyear");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");//*/
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("fecha >=", $fechai);
            $this->db_b->where("fecha <=", $fechaf);
            $this->db_b->group_by("MONTH(fecha)");
            $this->db_b->group_by("YEAR(fecha)");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET SALDOS CUENTA 3 POR MES
    #   GET SALDOS AUXI POR MES
    public function getSaldoAuxibyM($cuenta, $idtabla, $idauxi, $fechai, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idctcuenta, idtabla, idauxi, idcentro, idproject, lastpnumero, fecha, MONTH(fecha) as idmes, YEAR(fecha) as idyear");
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");//*/
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);
            $this->db_b->where("fecha >=", $fechai);
            $this->db_b->where("fecha <=", $fechaf);
            $this->db_b->group_by("MONTH(fecha)");
            $this->db_b->group_by("YEAR(fecha)");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET SALDOS AUXI POR MES
    #-------------------------------------------------HIJOS
    #   GET AUXILIARES SALDOS
    public function getAllAuxs($cuenta, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("fecha <=", $fechaf);
            $this->db_b->group_by("idtabla");
            $this->db_b->group_by("idauxi");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET AUXILIARES SALDOS
    #   GET SALDO AUXI
    public function getSaldoAuxi($cuenta, $fechaf, $idtabla, $idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("fecha <=", $fechaf);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   GET SALDO AUXI
    #----------------------------------------------------- DETALLE
    #   GET CUENTA INFO
    public function getCuentaC($cuenta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            return $this->db_b->where("idctcuenta", $cuenta)->get("ctcuenta")->row();
        }
    }
    #   FIN GET CUENTA INFO
    #   GET HIJOS - REGISTROS   CUENTA
    public function getRegistrosGC($dato, $fechai, $fechaf, $tipo)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as cuentaD, b.ctmayoriza, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.estatus", 1);
            if($tipo != 3) $this->db_b->where("b.catgrupo", $dato);
            else $this->db_b->where('a.idctcuenta', $dato);
            $this->db_b->where("a.fecha >=", $fechai);
            $this->db_b->where("a.fecha <=", $fechaf);
            //$this->db_b->order_by("a.idctcuenta", "ASC");
            $this->db_b->order_by("a.fecha", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET HIJOS - REGISTROS   CUENTA
    #   GET HIJOS - REGISTROS   AUXILIAR
    public function getRegistrosGA($cuenta, $fechai, $fechaf, $idtabla, $idauxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as cuentaD, b.ctmayoriza, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.estatus", 1);
            
            $this->db_b->where('a.idctcuenta', $cuenta);
            $this->db_b->where('a.idtabla', $idtabla);
            $this->db_b->where('a.idauxi', $idauxi);

            $this->db_b->where("a.fecha >=", $fechai);
            $this->db_b->where("a.fecha <=", $fechaf);
            $this->db_b->order_by("a.idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET HIJOS - REGISTROS   AUXILIAR
    #---------------------------------------------------------------   FIN BALANCE DE COMPROBACION
    #---------------------------------------------------------------   BALANCE ESTADO DE RESULTAODS
    #   GET REGISTROS DE CUENTAS 4 Y 5
    public function getRCuentas45($fechai, $fechaf, $VMagia)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $where = [
                '(a.fecha BETWEEN "'.$fechai.'" AND "'.$fechaf.'")',
                '('.implode(' OR ', [
                    '(b.ctcontrol = 10)',
                    '(b.ctcontrol = 11)',
                    '(b.ctcontrol = 12)',
                    '(b.ctcontrol = 20)',
                    '(b.ctcontrol = 25)',
                    '(b.ctcontrol = 30)',
                    '(b.ctcontrol = 40)',
                    '(b.ctcontrol = 41)',
                ]).')'
            ];
            $where = implode(' AND ', $where);
            $where = ($VMagia) ? ($where.' AND (b.ctcontrol != 40)') : $where;

            $this->db_b->select('a.fecha, a.debe, a.haber, b.descrip as cuenta, b.catgrupo, b.ctcontrol, c.descrip as centro, d.descrip as proyecto, a.idtabla, a.idauxi');
            $this->db_b->from('ct_100s a');
            $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
            $this->db_b->join('invsites c', 'a.idcentro = c.idcentro', 'left');
            $this->db_b->join('ctproj d', 'a.idproject = d.Idproject', 'left');
            $this->db_b->where($where);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    public function getRCuentasT10($fechai, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $where = '(a.fecha BETWEEN "'.$fechai.'" AND "'.$fechaf.'") AND (b.catgrupo = 4 OR b.catgrupo = 5) AND (b.ctcontrol = 10)';

            $this->db_b->select('a.idcentro, b.catgrupo, MONTH(a.fecha) as idmes, YEAR(a.fecha) as idyear');
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");
            $this->db_b->from('ct_100s a');
            $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
            $this->db_b->where($where);
            $this->db_b->group_by("a.idcentro");
            $this->db_b->group_by("MONTH(a.fecha)");
            $this->db_b->group_by("YEAR(a.fecha)");
            $this->db_b->order_by("a.fecha");
            $this->db_b->order_by("a.idcentro");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    public function getRCuentasT40($fechai, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        } else {
            $where = '(a.fecha BETWEEN "'.$fechai.'" AND "'.$fechaf.'") AND (b.catgrupo = 4 OR b.catgrupo = 5) AND (b.ctcontrol = 40)';

            $this->db_b->select('b.descrip as cuenta, b.catgrupo, b.ctcontrol, MONTH(a.fecha) as idmes, YEAR(a.fecha) as idyear');
            $this->db_b->select_sum("debe");
            $this->db_b->select_sum("haber");
            $this->db_b->from('ct_100s a');
            $this->db_b->join('ctcuenta b', 'a.idctcuenta = b.idctcuenta');
            $this->db_b->where($where);
            $this->db_b->group_by("b.ctcontrol");
            $this->db_b->group_by("MONTH(a.fecha)");
            $this->db_b->group_by("YEAR(a.fecha)");
            $this->db_b->order_by("b.idctcuenta", "ASC");
            $this->db_b->order_by("a.fecha", "ASC");
            $this->db_b->order_by("a.idcentro", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #---------------------------------------------------------------   FIN ESTADO DE RESULTADOS
    #------------------------------------------------------------------------------------------ REPORTES
    #---------------------------------------------------------------   BALANCE COMPROBACION
    public function getCuentasRBG_G14()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("catgrupo = 1 OR catgrupo = 4");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    public function getCuentas3RBG_G14()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->where("catgrupo = 1 OR catgrupo = 4");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }

    public function getCuentasRBG_G235()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("catgrupo = 2 OR catgrupo = 3 OR catgrupo = 5");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    public function getCuentas3RBG_G235()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->where("catgrupo = 2 OR catgrupo = 3 OR catgrupo = 5");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   PARA BALANCE GENERAL
    public function getCuentasRBG_G12345()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("catgrupo = 1 OR catgrupo = 2 OR catgrupo = 3 OR catgrupo = 4 OR catgrupo = 5");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    public function getCuentas3RBG_G12345()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("tipocuenta", 3);
            $this->db_b->where("catgrupo = 1 OR catgrupo = 2 OR catgrupo = 3 OR catgrupo = 4 OR catgrupo = 5");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #---------------------------------------------------------------   BALANCE GENERAL
    #   GET TODAS LAS CUENTAS
    public function getAllCuentas12345()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("catgrupo = 1 OR catgrupo = 2 OR catgrupo = 3  OR catgrupo = 4 OR catgrupo = 5");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET TODAS LAS CUENTAS
    #   GET TODAS LAS CUENTAS3
    public function getAllCuentas3_12345()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus");
            $this->db_b->from("ctcuenta");
            $this->db_b->where("(tipocuenta = 3) AND (catgrupo = 1 OR catgrupo = 2 OR catgrupo = 3 OR catgrupo = 4 OR catgrupo = 5)");
            $this->db_b->order_by("idctcuenta", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET TODAS LAS CUENTAS3
    #   REGISTROS DE SALDO ?
    public function existensaldos_12345()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*");
            $this->db_b->from("ct_100s a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("b.catgrupo = 1 OR b.catgrupo = 2 OR b.catgrupo = 3 OR b.catgrupo = 4 OR b.catgrupo = 5");
            $datos = $this->db_b->get()->num_rows();
            return $datos;
        }
    }
    #   REGISTROS DE SALDO ?
    #   EXISTE PADRE-HIJO CARACTERISTICAS
    public function existe_padre_hijo_property($tipocuenta = null, $grupo = null, $control = null)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $texto = [];
            if ($tipocuenta != null) {$texto[] = 'tipocuenta = '.$tipocuenta;}
            if ($grupo != null) {$texto[] = 'catgrupo = '.$grupo;}
            if ($control != null) {$texto[] = 'ctcontrol = '.$control ;}
            $texto = implode(' AND ', $texto);

            $this->db_b->select("idrec, idctcuenta, descrip, tipocuenta, ctmayoriza, catgrupo, ctcontrol, estatus, balview");
            $this->db_b->from("ctcuenta");
            $this->db_b->where($texto);
            $datos = $this->db_b->get()->row();
            if (count((array)$datos) > 0) $dato = true;
            else $dato = false;
            return $dato;
        }
    }
    #   FIN EXISTE PADRE-HIO CARACTERISTICAS
    #---------------------------------------------------------------   BALANCE LIBRO DIARIO MAYOR Y AUXILIAR
    #   EXISTE SALDO
    public function existeSaldoCuenta($cuenta, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("fecha <=", $fechaf);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN EXISTE SALDO
    #   CONSULTAR CUENTA S
    public function getSaldoCuentas($consulta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where($consulta);
            $this->db_b->group_by("fecha");
            $this->db_b->order_by("fecha", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN CONSULTAR CUENTA S
    #   GET SALDOS ANTERIORES
    public function getSaldoOldNews($subconsulta)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100s");
            $this->db_b->where($subconsulta);
            $this->db_b->order_by("fecha", "ASC");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET SALDOS ANTERIORES
    #---------------------------------------------------------------   BALANCE LIBRO AUXILIAR
    #   GET AUXILIARES SALDOS
    public function getAllAuxsBL($cuenta, $fechaf, $idauxi = 0)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as cuenta, b.catgrupo");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.idctcuenta", $cuenta);
            if ( $idauxi != 0 ) $this->db_b->where("a.idauxi", $idauxi);
            $this->db_b->where("a.fecha <=", $fechaf);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->group_by("a.idtabla");
            $this->db_b->group_by("a.idauxi");
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET AUXILIARES SALDOS
    #   GET REGISTROS AUXILIAR
    public function getAllRAuxsBL($cuenta, $idtabla, $idauxi, $fechaf)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100d ");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);
            $this->db_b->where("fecha <=", $fechaf);
            $this->db_b->where("estatus", 1);
            $datos = $this->db_b->get();
            return $datos;
        }
    }
    #   FIN GET REGISTROS AUXILIAR
    #------------------------------------------------------------------------------------------ FIN REPORTES
    #------------------------------------------------------     FIN CONSULTA GENERAL CUENTAS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #------------------------------------------------------    CONTROL DE BANCOS -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    #   GET CUENTAS BANCOS
    public function getCtasB()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.idrec, a.idctcuenta, a.idtabla, a.idauxi, b.descrip, b.allowed_users");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "a.idctcuenta = b.idctcuenta");
            $this->db_b->where("a.estatus", 1);
            $this->db_b->where("b.ctcontrol", 1);
            //$this->db_b->group_by("a.idctcuenta");
            $this->db_b->group_by("a.idtabla");
            $this->db_b->group_by("a.idauxi");
            $this->db_b->order_by("b.descrip", "ASC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   FIN GET CUENTAS BANCOS
    #   GET TIPO DE DOCUMENTOS
    public function getDocsTipo($cuenta, $tabla, $auxi)
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("idrec, doc_type");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("idtabla", $tabla);
            $this->db_b->where("idauxi", $auxi);
            $this->db_b->where("estatus", 1);
            $this->db_b->group_by("doc_type");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   FIN GET TIPO DE DOCUMENTOS
    #   LOAD REGISTROS DE BANCOS
    public function loadRegistrosBancos($cuenta, $idauxi, $idtabla, $tipo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("*");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idctcuenta", $cuenta);
            $this->db_b->where("idtabla", $idtabla);
            $this->db_b->where("idauxi", $idauxi);
            $this->db_b->where("doc_type", $tipo);
            $this->db_b->where("estatus !=", 0);
            $this->db_b->order_by("fecha", "DESC");
            $dato = $this->db_b->get();
            return $dato;
        }
    }
    #   FIN LOAD REGISTROS DE BANCOS
    #------------------------------------------------------    FIN CONTROL DE BANCOS ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    # ------------- FUNCION SOLO PARA - DE AYUDA
    public function getayuda()
    {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else {

            /*
            $this->db_b->where('pnumero', 89);
            $this->db_b->update('ct_100', array('idptipo' => 9));
            $this->db_b->where('pnumero', 44);
            $this->db_b->update('ct_100', array('origen' => 'AC_Pagos/0/306/21101'));
            $this->db_b->where('pnumero', 46);
            $this->db_b->update('ct_100', array('origen' => 'AC_Pagos/0/310/21101'));

            $this->db_b->where('pnumero', 42);
            $this->db_b->update('ct_100', array('origen' => 'AC_Quedan/0'));
            
            $hola = [
                '(pnumero = 43)',
                '('.implode(' OR ', [
                    '(idrec = 147)',
                    '(idrec = 150)',
                    '(idrec = 152)',
                ]).')'
            ];
            $hola = implode(' AND ', $hola);
            $this->db_b->where($hola);
            $this->db_b->update('ct_100d', array('doc_controlnum' => ''));
            
            $this->db_b->where('pnumero', 42);
            $this->db_b->where('doc_controlnum', 7);
            $this->db_b->update('ct_100d', array('doc_controlnum' => 142));//*/

            /*$this->db_b->where('idyear', 2);
            $this->db_b->update('ct_100', array('idyear' => 2019));
            $this->db_b->where('idyear', 3);
            $this->db_b->update('ct_100', array('idyear' => 2021));//*/
            // BORRAR
            /*$this->db_b->where('idauxi', 493);
            $this->db_b->delete('ctauxi');
            //*/
            /*$this->db_b->where('pnumero', $pnumero);
            $this->db_b->where('itemline >=', 9);
            $this->db_b->delete('ct_100d');
            die();//*/

            /*$this->db_b->select("*");
            $this->db_b->from("ct_100d");
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->order_by("idrec", "ASC");
            if ($dato = $this->db_b->get()->result()) {
                return $dato;
            }
            else return false;//*/
        }
    }
    #

    public function renumeracionMensual($year, $month){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("num_mes");
            $this->db_b->from("ct_100");
            $this->db_b->where("YEAR(fecha)", $year);
            $this->db_b->where("MONTH(fecha)", $month);
            $this->db_b->order_by("num_mes", "DESC");
            $this->db_b->limit(1);
            $num_mes = $this->db_b->get()->row()->num_mes;

            $this->db_b->select("pnumero, fecha, num_mes");
            $this->db_b->from("ct_100");
            $this->db_b->where("YEAR(fecha)", $year);
            $this->db_b->where("MONTH(fecha)", $month);
            $this->db_b->order_by("fecha", "ASC");
            $this->db_b->order_by("pnumero", "ASC");
            $this->db_b->order_by("num_mes", "ASC");

            $resultado = $this->db_b->get()->result_array();
            if($resultado){
                $respuesta = true;
                $num = ($num_mes == 0) ? 1 : $num_mes + 1;
                foreach($resultado as $partida){
                    if ($partida['num_mes'] == 0) {
                        $this->db_b->set('num_mes',$num);
                        $this->db_b->where('pnumero',$partida['pnumero']);
                        $this->db_b->update('ct_100');
                        $num++;
                    }
                }
            }else{
                $respuesta = false;
            }
            
            return $respuesta;
        }
    }
    
    public function renumeracionAnual($year){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("num_mes");
            $this->db_b->from("ct_100");
            $this->db_b->where("YEAR(fecha)", $year);
            $this->db_b->order_by("num_mes", "DESC");
            $this->db_b->limit(1);
            $num_mes = $this->db_b->get()->row()->num_mes;

            $this->db_b->select("pnumero, fecha, num_mes");
            $this->db_b->from("ct_100");
            $this->db_b->where("YEAR(fecha)", $year);
            $this->db_b->order_by("fecha", "ASC");
            $this->db_b->order_by("pnumero", "ASC");
            $this->db_b->order_by("num_mes", "ASC");

            $resultado = $this->db_b->get()->result_array();
            if($resultado){
                $respuesta = true;
                $num = ($num_mes == 0) ? 1 : $num_mes + 1;
                foreach($resultado as $partida) {
                    if ($partida['num_mes'] == 0) {
                        $this->db_b->set('num_mes',$num);
                        $this->db_b->where('pnumero',$partida['pnumero']);
                        $this->db_b->update('ct_100');
                        $num++;
                    }
                }
            }else{
                $respuesta = false;
            }
            
            return $respuesta;
        }
    }

    //OBTIENE LOS MOVIMIENTOS DE UNA CUENTA DE TIPO 3 EN UN RANGO DE FECHAS
    public function getMovimientosCuenta($idctcuenta, $fechaini, $fechafin){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*, b.descrip as cuentaD, b.ctmayoriza, b.catgrupo, b.ctcontrol, b.useauxi, b.askidcentro, b.askidproyecto");
            $this->db_b->from("ct_100d a");
            $this->db_b->join("ctcuenta b", "b.idctcuenta = a.idctcuenta");
            $this->db_b->where("a.idctcuenta", $idctcuenta);
            $this->db_b->where("a.fecha >=", $fechaini);
            $this->db_b->where("a.fecha <=", $fechafin);
            $this->db_b->where("a.estatus", 1);
            $this->db_b->order_by("a.fecha", "ASC");

            $resultado = $this->db_b->get()->result_array();
            return $resultado;
        }
    }

    public function getCentrosCosto(){
        $this->db_b->select("idcentro, descrip");
        $this->db_b->from("invsites");
        $this->db_b->where('estatus', 1);
        $this->db_b->order_by("descrip", "ASC");
        
        $data = $this->db_b->get()->result_array();
        return $data;
    }

    public function reclasificarMovimiento($idrec, $idctcuenta, $idtabla, $idauxi, $idcentro, $idproject, $change_log){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d H:i:s');
            $whodidit = $this->session->userdata('iduser');
            
            $change_log = $change_log . $now.",".$whodidit.", Reclasificada;";
            $this->db_b->set('idctcuenta',$idctcuenta);
            $this->db_b->set('idtabla',$idtabla);
            $this->db_b->set('idauxi',$idauxi);
            $this->db_b->set('idcentro',$idcentro);
            $this->db_b->set('idproject',$idproject);
            $this->db_b->set('modifica',$now);
            $this->db_b->set('chg_log',$change_log);

            $this->db_b->where('idrec',$idrec);
            $resultado = $this->db_b->update('ct_100d');
            return $resultado;
        }
    }

    public function asignarTipoCuentas($idrec, $tipocuenta, $idgrupo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d H:i:s');
            
            $this->db_b->set('tipocuenta',$tipocuenta);
            $this->db_b->set('catgrupo',$idgrupo);
            $this->db_b->set('estatus',1);
            $this->db_b->set('modifica',$now);

            $this->db_b->where('idrec',$idrec);
            $resultado = $this->db_b->update('ctcuentamaster');
            return $resultado;
        }
    }

    #   CONTROL GENERACION CONTABLE

    public function getRegistrosGeneraCT(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d');

            $this->db_b->select("a.idgenera, a.fecha, a.agrupa, a.idcentro, a.idcaja, a.numz, a.estatus, a.ctfecha, a.ivfecha, a.partida, a.notas");
            $this->db_b->select("b.descrip as nombreCentro, c.descrip as nombreCaja");
            $this->db_b->from("conta_gencontrol a");
            $this->db_b->join("invsites b", "b.idcentro = a.idcentro", 'left');
            $this->db_b->join("ctcajas c", "c.idcaja = a.idcaja", 'left');

            $this->db_b->order_by("fecha", "DESC");

           // $resultado = $this->db_b->get()->result_array();
            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->result_array();
            }
            return false;
        }
    }

    public function validarRegistroGeneraCT($idsucursal, $idcaja, $fecha, $opc){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d');

            $this->db_b->select("idgenera");
            $this->db_b->from("conta_gencontrol");
            $this->db_b->where('idcentro',$idsucursal);
            $this->db_b->where('idcaja',$idcaja);
            $this->db_b->where('fecha',$fecha);
            $this->db_b->where('agrupa',$opc);

           // $resultado = $this->db_b->get()->result_array();
            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return true;
            }
            return false;
        }
    }

    public function adicionarRegistroGeneraCT($idsucursal, $idcaja, $fecha, $numz, $notas, $opc){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d H:i:s');

            $this->db_b->set('fecha', $fecha);
            $this->db_b->set('agrupa', $opc);
            $this->db_b->set('idcentro', $idsucursal);
            $this->db_b->set('idcaja',  $idcaja);
            $this->db_b->set('numz', $numz);
            $this->db_b->set('estatus', 0);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $now);
            $resultado = $this->db_b->insert('conta_gencontrol');

            return $resultado;
        }
    }

    public function modificatTipoCtCuenta($idrec, $tipocuenta, $mayoriza){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d H:i:s');
            $whodidit = $this->session->userdata('iduser');
            
            $this->db_b->set('ctmayoriza',$mayoriza);
            $this->db_b->set('tipocuenta',$tipocuenta);
            $this->db_b->set('modifica',$now);

            $this->db_b->where('idrec',$idrec);
            $resultado = $this->db_b->update('ctcuenta');
            return $resultado;
        }
    }

    // BUSQUEDA DE SUBAUXIS DE CUENTA AUXILIAR
    public function auxiPoseeSubauxis($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d');

            $this->db_b->select("sidauxidef");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxi", $idauxi);

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->row_array()['sidauxidef'];
            }
            return false;
        }
    }

    public function busquedaSubauxis($idauxidef){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $this->db_b->select("idauxi, descrip");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxidef", $idauxidef);
            $this->db_b->where("estado", 1);
            $this->db_b->order_by("descrip", "ASC");

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->result_array();
            }
            return false;
        }
    }

    public function getUltimoSubauxi($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $this->db_b->select("sidauxidef");
            $this->db_b->from("ct_100d");
            $this->db_b->where("idauxi", $idauxi);
            $this->db_b->where("sidauxidef !=", "");
            $this->db_b->where("estatus", 1);
            $this->db_b->order_by("modifica", "DESC");
            $this->db_b->limit(1);  

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->row_array();
            }
            return false;
        }
    }

    public function getTipoSubAuxi($idauxidef){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');

            $this->db_b->select("descripcion");
            $this->db_b->from("gvars");
            $this->db_b->where("valor_num", $idauxidef);
            $this->db_b->where("nombre", "auxi_def");

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->row_array()['descripcion'];
            }
            return false;
        }
    }

    public function obtenerMovimientosContables($fechaini, $fechafin){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion'); 
        }else{
            date_default_timezone_set('America/El_Salvador');

            $this->db_b->select("ct_100d.fecha, ctpdef.descrip as tipoDescrip, ct_100d.pnumero, ct_100d.itemline, ct_100d.descrip as movDescrip, ct_100d.chg_log");
            $this->db_b->select("ct_100d.idctcuenta as cuentaId, ctcuenta.descrip as cuentaDescrip, ct_100d.idauxi as auxiId, ctauxi.descrip as auxiDescrip");
            $this->db_b->select("ct_100d.sidauxidef as subauxiId, ct_100d.idcentro as centroId, invsites.descrip as centroDescrip, ct_100d.idproject as proyectoId, ctproj.descrip as proyectoDescrip");
            $this->db_b->select("ct_100d.doc_type, ct_100d.doc_serie, ct_100d.doc_numero, ct_100d.doc_emision, ct_100d.doc_vence, ct_100d.notas, ct_100d.debe, ct_100d.haber, ct_100d.ingresa, who.descrip as whodidit");
            $this->db_b->from("ct_100d");
            $this->db_b->join('ct_100', 'ct_100.pnumero = ct_100d.pnumero', 'inner');
            $this->db_b->join('ctpdef', 'ct_100.idptipo = ctpdef.idptipo', 'inner');
            $this->db_b->join('ctcuenta', 'ctcuenta.idctcuenta = ct_100d.idctcuenta', 'inner');
            $this->db_b->join('ctauxi', 'ctauxi.idauxi = ct_100d.idauxi', 'left');
            $this->db_b->join('invsites', 'invsites.idcentro = ct_100d.idcentro', 'left');
            $this->db_b->join('ctproj', 'ctproj.idproject = ct_100d.idproject', 'left');
            $this->db_b->join('gusers who', 'who.iduser = ct_100d.whodidit', 'inner');
            $this->db_b->where("ct_100d.fecha >=", $fechaini);
            $this->db_b->where("ct_100d.fecha <=", $fechafin);
            $this->db_b->where("ct_100d.estatus", 1);
            $this->db_b->order_by('ct_100d.fecha', 'ASC');
            $this->db_b->order_by('ct_100d.pnumero', 'ASC');
            $this->db_b->order_by('ct_100d.itemline', 'ASC');

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->result_array();
            }
            return false;
        }
    }

    public function movimientosLiquidacionCuentasResultado($tipocuenta, $fechaini, $fechafin){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion'); 
        }else{
            date_default_timezone_set('America/El_Salvador');

            $stringSaldo = "";
            if($tipocuenta == 4){
                $stringSaldo = "SUM(debe-haber) as saldo";
            }else{
                $stringSaldo = "SUM(haber-debe) as saldo";
            }

            $this->db_b->select("ct_100d.idctcuenta, ctcuenta.descrip, ct_100d.idauxi as auxiId, ctauxi.descrip as auxiDescrip, ct_100d.idcentro as centroId, invsites.descrip as centroDescrip");
            $this->db_b->select("ct_100d.idproject as proyectoId, ctproj.descrip as proyectoDescrip, 'Liquidación de cuentas de resultados' as movDescrip, $stringSaldo");
            $this->db_b->from("ct_100d");
            $this->db_b->join('ctcuenta', 'ctcuenta.idctcuenta = ct_100d.idctcuenta', 'left');
            $this->db_b->join('invsites', 'invsites.idcentro = ct_100d.idcentro', 'left');
            $this->db_b->join('ctproj', 'ctproj.idproject = ct_100d.idproject', 'left');
            $this->db_b->join('ctauxi', 'ctauxi.idauxi = ct_100d.idauxi', 'left');
            $this->db_b->where("ct_100d.fecha >=", $fechaini);
            $this->db_b->where("ct_100d.fecha <=", $fechafin);
            $this->db_b->where("ct_100d.estatus", 1);
            $this->db_b->where("ctcuenta.tipocuenta", 3);
            $this->db_b->where("ctcuenta.catgrupo", $tipocuenta);
            $this->db_b->order_by('ct_100d.idctcuenta', 'ASC');
            $this->db_b->order_by('ct_100d.idauxi', 'ASC');
            $this->db_b->order_by('ct_100d.idcentro', 'ASC');
            $this->db_b->order_by('ct_100d.idproject', 'ASC');
            $this->db_b->group_by(array("ct_100d.idctcuenta", "ct_100d.idauxi", "ct_100d.idcentro", "ct_100d.idproject"));

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->result_array();
            }
            return false;
        }
    }

    //Verifica si una partida ya contiene movimientos de liquidacion
    public function verificacionLiquidacionCuentas($pnumero, $tipocuenta, $idctcuenta, $idauxi,  $idcentro, $idproject){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion'); 
        }else{
         
            $this->db_b->select("*");
            $this->db_b->from("ct_100d");
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->where("notas", $tipocuenta);
            $this->db_b->where('idctcuenta', $idctcuenta);
            $this->db_b->where('idauxi', $idauxi);
            $this->db_b->where('idcentro', $idcentro);
            $this->db_b->where('idproject', $idproject);
            $this->db_b->where('estatus', 0);

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return true;
            } 
            return false;
        }
    }

    public function agregarLiquidacionCuentas($pnumero, $itemline, $fecha, $idctcuenta, $idauxi, $idtabla,  $idcentro, $idproject, $descrip, $tipocuenta, $saldo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $now = date_create()->format('Y-m-d H:i:s');
            $whodidit = $this->session->userdata('iduser');

            $debe = 0;
            $haber = 0;
            switch($tipocuenta){
                case 4:
                    $debe = 0;
                    $haber = $saldo;
                    break;
                case 5:
                    $debe = $saldo;
                    $haber = 0;
                    break;
            }
            $chg_log = $now.",".$whodidit.",Inserción;";
            $this->db_b->set('pnumero',$pnumero);
            $this->db_b->set('itemline',$itemline);
            $this->db_b->set('fecha',$fecha);
            $this->db_b->set('idctcuenta', $idctcuenta);
            $this->db_b->set('idtabla', $idtabla);
            $this->db_b->set('idauxi', $idauxi);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idproject', $idproject);
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('notas',$tipocuenta);
            $this->db_b->set('debe', $debe);
            $this->db_b->set('haber', $haber);
            $this->db_b->set('estatus', 0);
            $this->db_b->set('chg_log', $chg_log);
            $this->db_b->set('whodidit',$whodidit);
            $this->db_b->set('ingresa',$now);

            $resultado = $this->db_b->insert('ct_100d');
            return $resultado;
        }
    }

    public function getDescripSubauxis($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
          

            $this->db_b->select("descrip");
            $this->db_b->from("ctauxi");
            $this->db_b->where("idauxi", $idauxi);
            //$this->db_b->where("estatus", 1);

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->row_array();
            }
            return false;
        }
    }

    /*  IMPRESION CHEQUES */
    public function getInfoCheque($idrec){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("ct_100d.*, ct_100.descrip as partidaDescrip, ct_100.fecha as partidaFecha, ct_100.pnumero as partidaNumero, ctauxi.descrip as auxiDescrip");
            $this->db_b->from("ct_100d");
            $this->db_b->join('ct_100', 'ct_100.pnumero = ct_100d.pnumero', 'inner');
            $this->db_b->join('ctauxi', 'ctauxi.idauxi = ct_100d.idauxi', 'inner');

            $this->db_b->where("ct_100d.idrec", $idrec);
            //$this->db_b->where("estatus", 1);

            $resultado = $this->db_b->get();
            if ($resultado->num_rows() > 0) {
               return $resultado->row_array();
            }
            return false;
        }
    }

    /*  IMPORTACION ARRAY DE MOVIMIENTOS   */
    public function importarArrayMovimientos($arrayMovimientos, $pnumero){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $arrayErrores = [];
            $esValido = true;

            //Obtiene el itemline actual
            $itemline = 1;
            $this->db_b->select("itemline");
            $this->db_b->from("ct_100d");
            $this->db_b->where("pnumero", $pnumero);
            $this->db_b->order_by("itemline", "ASC");
            $dato = $this->db_b->get();

            if ($dato->num_rows() > 0){
                $itemline = $dato->last_row()->itemline + 1;
            } 

            //inicio de transaccion manual
            $this->db_b->trans_begin();

            //insercion de datos
            foreach($arrayMovimientos as $mov){
                $mov['itemline'] = $itemline;
                $itemline++;

                if(!$this->db_b->insert('ct_100d', $mov)){
                    //se sale del foreach en el primer movimiento que de error
                    $esValido = false;
                    $arrayErrores[] = $mov['idctcuenta'];

                    break;
                }
            }

            //tras finalizar los movimentos se verifica el estado de la transaccion
            //si todo esta bien, se insertan los datos, si no se revierten
            if ($this->db_b->trans_status() === FALSE){
                $esValido = false;
                $this->db_b->trans_rollback();
            }
            else{
                $this->db_b->trans_commit();
            }
            
            return ["arrayErrores"=>$arrayErrores, "esValido"=>$esValido];
        }
    }

    public function getInformacionSucursales() {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.xpos, a.descrip");
            $this->db_b->from("invsites a");
            $this->db_b->where("a.xpos !=", "");
            $this->db_b->where("a.estatus", 1);
            $this->db_b->where("a.tipo", 1);
            $datos = $this->db_b->get();
            return $datos;
        }
    }

    public function getInfoAplicacionCuentas($tipo, $idsite) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->select("a.*");
            $this->db_b->from("ct_api a");
            $this->db_b->where("a.tipo", $tipo);
            $this->db_b->where("a.idsite", $idsite);
            $datos = $this->db_b->get();
            return $datos;
        }
    }

    public function actualizarRegistroAplicacionCuentas($asksite, $estatus, $idauxi, $idcuenta, $idep1, $idep2, $idep3, $idep4, $idep5, $idmov, $idpais, $idproject, $idsite, $notas, $tipo, $idrec) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->set('asksite', $asksite);
            $this->db_b->set('estatus', $estatus);
            $this->db_b->set('idauxi', $idauxi);
            $this->db_b->set('idcuenta', $idcuenta);
            $this->db_b->set('idep1', $idep1);
            $this->db_b->set('idep2', $idep2);
            $this->db_b->set('idep3', $idep3);
            $this->db_b->set('idep4', $idep4);
            $this->db_b->set('idep5', $idep5);
            $this->db_b->set('idmov', $idmov);
            $this->db_b->set('idpais', $idpais);
            $this->db_b->set('idproject', $idproject);
            $this->db_b->set('idsite', $idsite);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('tipo', $tipo);
            $this->db_b->where('idrec', $idrec);
            $update = $this->db_b->update('ct_api');

            return $update;
        }
    }

    public function insertarRegistroAplicacionCuentas($asksite, $estatus, $idauxi, $idcuenta, $idep1, $idep2, $idep3, $idep4, $idep5, $idmov, $idpais, $idproject, $idsite, $notas, $tipo) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->set('idrec', 0);
            $this->db_b->set('asksite', $asksite);
            $this->db_b->set('estatus', $estatus);
            $this->db_b->set('idauxi', $idauxi);
            $this->db_b->set('idcuenta', $idcuenta);
            $this->db_b->set('idep1', $idep1);
            $this->db_b->set('idep2', $idep2);
            $this->db_b->set('idep3', $idep3);
            $this->db_b->set('idep4', $idep4);
            $this->db_b->set('idep5', $idep5);
            $this->db_b->set('idmov', $idmov);
            $this->db_b->set('idpais', $idpais);
            $this->db_b->set('idproject', $idproject);
            $this->db_b->set('idsite', $idsite);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('tipo', $tipo);
            $insert = $this->db_b->insert('ct_api');

            return $insert;
        }
    }

    public function eliminarRegistroAplicacionCuentas($idrec) {
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $this->db_b->where('idrec', $idrec);
            $delete = $this->db_b->delete('ct_api');

            return $delete;
        }
    }
}
?>