<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Conta_model extends CI_Model{

        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        function viewCuentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctcatalog ORDER BY ctcuenta ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function verificarCuenta($cuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idcuenta as existe FROM ctcatalog WHERE ctcuenta=$cuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                if($query->num_rows()>0){
                    return $resultado['existe'];
                }else{
                    return null; 
                }
            }
        }
        
        function getTotaliza($cuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $rest = substr($cuenta, 0, -1);
                $ultimo = substr($rest, -1);
                if($ultimo=="0"){
                    $rest = substr($rest, 0, -1);
                }
                $consulta = "SELECT ctcuenta FROM ctcatalog WHERE ctcuenta=$rest";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->row_array();
                    return $resultado['ctcuenta'];
                }else{
                    return  0;
                }
            }
        }
        
        function getData($idcuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctcatalog WHERE idcuenta= $idcuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertCuenta($grupo, $num_cuenta, $titulo_cuenta, $totalizara, $tipo_control, $auxi, $tipo_cuenta, $u_costos, $u_proyectos, $s_contrasena,$c_presupuesto,  $estado, $notas, $idfiltros){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
            
                if($u_costos == "true"){
                    $u_costos_ = "1";
                }else{
                    $u_costos_ = "0";
                }
                if($u_proyectos == "true"){
                    $u_proyectos_ = "1";
                }else{
                    $u_proyectos_ = "0";
                }
                if($s_contrasena == "true"){
                    $s_contrasena_ = "1";
                }else{
                    $s_contrasena_ = "0";
                }
                if($c_presupuesto == "true"){
                    $c_presupuesto_ = "1";
                }else{
                    $c_presupuesto_ = "0";
                }
                if($estado == "true"){
                    $estatus = "1";
                }else{
                    $estatus = "0";
                }  
                $whodidit = $this->session->userdata('iduser');
                
                $consulta = "SELECT idcuenta as existe FROM ctcatalog WHERE ctcuenta=$num_cuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                if($query->num_rows()>0){
                    return true;
                }else{
                    $this->db_b->set('idcuenta', 0);
                    $this->db_b->set('nivel', "0");
                    $this->db_b->set('ctgrupo', $grupo);
                    $this->db_b->set('tipocuenta', $tipo_cuenta);
                    $this->db_b->set('ctcuenta', $num_cuenta);
                    $this->db_b->set('descrip', $titulo_cuenta);
                    $this->db_b->set('total2', $totalizara);
                    $this->db_b->set('ctcontrol', $tipo_control);
                    $this->db_b->set('idauxidef', $auxi);
                    $this->db_b->set('filtro_sidauxi', $idfiltros);
                    $this->db_b->set('askidcentro', $u_costos_);
                    $this->db_b->set('askproyecto', $u_proyectos_);
                    $this->db_b->set('askpwd', $s_contrasena_);
                    $this->db_b->set('budgetcta', $c_presupuesto_);
                    $this->db_b->set('estado', $estatus);
                    $this->db_b->set('notas', $notas);
                    $this->db_b->set('whodidit', $whodidit);
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('ctcatalog');
                    return $query;
                }
            }
        }
        
        function updateCuenta($id_cuenta, $grupo, $num_cuenta, $titulo_cuenta, $totalizara, $tipo_control, $auxi, $tipo_cuenta, $u_costos, $u_proyectos, $s_contrasena,$c_presupuesto, $estado, $notas, $idfiltros){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                
                if($u_costos == "true"){
                    $u_costos_ = "1";
                }else{
                    $u_costos_ = "0";
                }
                if($u_proyectos == "true"){
                    $u_proyectos_ = "1";
                }else{
                    $u_proyectos_ = "0";
                }
                if($s_contrasena == "true"){
                    $s_contrasena_ = "1";
                }else{
                    $s_contrasena_ = "0";
                }
                if($c_presupuesto == "true"){
                    $c_presupuesto_ = "1";
                }else{
                    $c_presupuesto_ = "0";
                }  
                if($estado == "true"){
                    $estatus = "1";
                }else{
                    $estatus = "0";
                }  
                $whodidit = $this->session->userdata('iduser');
                $this->db_b->set('nivel', "0");
                $this->db_b->set('ctgrupo', $grupo);
                $this->db_b->set('ctcuenta', $num_cuenta);
                $this->db_b->set('descrip', $titulo_cuenta);
                $this->db_b->set('total2', $totalizara);
                $this->db_b->set('ctcontrol', $tipo_control);
                $this->db_b->set('idauxidef', $auxi);
                $this->db_b->set('filtro_sidauxi', $idfiltros);
                $this->db_b->set('tipocuenta', $tipo_cuenta);
                $this->db_b->set('askidcentro', $u_costos_);
                $this->db_b->set('askproyecto', $u_proyectos_);
                $this->db_b->set('askpwd', $s_contrasena_);
                $this->db_b->set('budgetcta', $c_presupuesto_);
                $this->db_b->set('estado', $estatus);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->where('idcuenta', $id_cuenta);
                $query = $this->db_b->update('ctcatalog');
                return $query;
            }   
        }
        
        function getPeriodos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctyears ORDER BY idano DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertPeriodo($anio, $descrip, $inicio, $fin, $meses, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $date = new DateTime($anio);
                
                $numanio = $date->format('Y');
                
                $this->db_b->set('idano', $date->format('Y'));
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('fechaini', $inicio);
                $this->db_b->set('fechafin', $fin);
                $this->db_b->set('meses', $meses);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctyears');
                
                if($query==1){
                    $SqlConsultaHD = "CREATE TABLE ct".$numanio."hd LIKE conta_100;";
                    $this->db_b->query($SqlConsultaHD);
                    $SqlConsultaDT = "CREATE TABLE ct".$numanio."dt LIKE conta_100d;";
                    $this->db_b->query($SqlConsultaDT);
                }
                
                return $query;
            }
        }
        
        function verificarPeriodo($year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            $consulta = "SELECT count(idano) as cant FROM ctyears WHERE idano=$year";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cant'];
            }
        }
        
        function getInfoPeriodo($year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            $consulta = "SELECT * FROM ctyears WHERE idano=$year";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function updatePeriodo($idanio, $anio, $descrip, $inicio, $fin, $meses, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                        
                $whodidit = $this->session->userdata('iduser');
                $date = new DateTime($anio);
                $this->db_b->set('idano', $date->format('Y'));
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('fechaini', $inicio);
                $this->db_b->set('fechafin', $fin);
                $this->db_b->set('meses', $meses);
                $this->db_b->set('estatus', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->where('idano', $idanio);
                $query = $this->db_b->update('ctyears');
                return $query;
            }
        }
        
        function getPartidas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            $consulta = "SELECT ctpdef.*, gforms.descrip as forma FROM ctpdef INNER JOIN gforms WHERE ctpdef.idform= gforms.idform ORDER BY ctpdef.idptipo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoPartidasMes($idmes,$year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctpdef.*, IFNULL((SELECT COUNT(ct".$year."hd.pnumero) FROM ct".$year."hd WHERE ct".$year."hd.idmes = $idmes AND ct".$year."hd.idptipo = ctpdef.idptipo ), 0) AS total FROM ctpdef WHERE mes_$idmes = 1 ORDER BY idptipo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getNextNumeroPartidas($idmes, $year, $idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $SQL1 = "SELECT tiponum FROM ctpdef WHERE idptipo = $idptipo";
                $Query1 = $this->db_b->query($SQL1);
                $Result1 = $Query1->row_array();
                $tipoNums = $Result1['tiponum'];
                
                if($tipoNums == 0){
                    $consulta = "SELECT numero FROM ctpnums WHERE idano = $year AND idmes = $idmes AND idptipo = $idptipo AND estado = 1";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $numero = $resultado['numero'] + 1;
                    }else{
                        $numero = false;
                    }
                }else{
                    $consulta = "SELECT numero FROM ctpnums WHERE idano = $year AND idmes = 0 AND idptipo = $idptipo";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $numero = $resultado['numero'] + 1;
                    }else{
                        $numero = false;
                    }
                }
                
                return $numero;
            }
        }
        
        function getFechasNumeroPartidas($idmes, $year, $idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT fechaini, fechafin FROM ctpnums WHERE idano = $year AND idmes = $idmes AND idptipo = $idptipo";
                $query = $this->db_b->query($consulta);

                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getctpnums($idptipo,$idano){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctpnums.*, ctpdef.tiponum FROM ctpnums INNER JOIN ctpdef ON ctpnums.idptipo = ctpdef.idptipo WHERE ctpnums.idptipo = $idptipo AND ctpnums.idano = $idano ORDER BY ctpnums.idano ASC, ctpnums.idmes ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInfoNum($anio, $mes, $num){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            $consulta = "SELECT * FROM ctpnums WHERE idano = $anio AND idmes= $mes AND numero=$num";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInformacionPartida($idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
            $consulta = "SELECT * FROM ctpdef WHERE idptipo = $idptipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getTipoDePartida($name_gvar){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_num, descripcion, IF(nombre = 'conta_exp', 'Exportación', 'Generación') AS nombre FROM gvars WHERE nombre = '$name_gvar' OR nombre = 'conta_exp' ORDER BY descripcion";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getTipoFiltroPartida(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT IF(filtro = '', 'SIN AGRUPACIÓN', filtro) AS descrip, filtro AS id FROM gvars WHERE nombre = 'conta_gen' ORDER BY filtro";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoMovimientosContables($tipo_partida){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT *, IF(dh=1, 'Debe', 'Haber') AS debehaber FROM conta_genfunc WHERE partipo = $tipo_partida ORDER BY posicion ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoTransacciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT invclase, descrip, agrupa FROM inv_def WHERE estatus = 1 ORDER BY agrupa, descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoFormasDePago(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT cajclase, descrip FROM caj_def WHERE agrupa = 'VN' OR agrupa = 'CC' AND estatus = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoCuentasDeBanco(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idauxi, descrip FROM ctauxi WHERE idauxidef = 10 AND estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoDepartamentos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.idcatalogo, a.descrip, b.descripcion AS tipoProducto FROM invcatalog a INNER JOIN gvars b ON b.valor_num = a.tipo AND b.nombre = 'gv_protipo' WHERE a.nivel = 1 AND a.estado = 1 ORDER BY b.valor_num, a.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getListadoLineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT a.idcatalogo, a.descrip, b.descripcion AS tipoProducto FROM invcatalog a INNER JOIN gvars b ON b.valor_num = a.tipo AND b.nombre = 'gv_protipo' WHERE a.nivel = 2 AND a.estado = 1 ORDER BY b.valor_num, a.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();

                return $resultado;
            }
        }

        function insertPartida($tipo, $formato, $s_contra, $correlativos, $inputMeses, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                if($s_contra == "true"){
                    $s_contra = "1";
                }else{
                    $s_contra = "0";
                }
                
                $valMes0 = 0; $valMes1 = 0; $valMes2 = 0; $valMes3 = 0; $valMes4 = 0; $valMes5 = 0; $valMes6 = 0;
                $valMes7 = 0; $valMes8 = 0; $valMes9 = 0; $valMes10 = 0; $valMes11 = 0; $valMes12 = 0; $valMes13 = 0;
                
                if($inputMeses != ""){
                    $arrayMeses = explode(",", $inputMeses);
                    $totArray = count($arrayMeses);

                    for($k=0; $k<$totArray; $k++){
                        switch($arrayMeses[$k]){
                            case 0:
                                $valMes0 = 1;
                                break;
                            case 1:
                                $valMes1 = 1;
                                break;
                            case 2:
                                $valMes2 = 1;
                                break;
                            case 3:
                                $valMes3 = 1;
                                break;
                            case 4:
                                $valMes4 = 1;
                                break;
                            case 5:
                                $valMes5 = 1;
                                break;
                            case 6:
                                $valMes6 = 1;
                                break;
                            case 7:
                                $valMes7 = 1;
                                break;
                            case 8:
                                $valMes8 = 1;
                                break;
                            case 9:
                                $valMes9 = 1;
                                break;
                            case 10:
                                $valMes10 = 1;
                                break;
                            case 11:
                                $valMes11 = 1;
                                break;
                            case 12:
                                $valMes12 = 1;
                                break;
                            case 13:
                                $valMes13 = 1;
                                break;
                        }
                    }
                }
                
                $this->db_b->set('idptipo', 0);
                $this->db_b->set('descrip', $tipo);
                $this->db_b->set('idform', $formato);
                $this->db_b->set('askpwd', $s_contra);
                $this->db_b->set('tiponum', $correlativos);
                $this->db_b->set('mes_0', $valMes0);
                $this->db_b->set('mes_1', $valMes1);
                $this->db_b->set('mes_2', $valMes2);
                $this->db_b->set('mes_3', $valMes3);
                $this->db_b->set('mes_4', $valMes4);
                $this->db_b->set('mes_5', $valMes5);
                $this->db_b->set('mes_6', $valMes6);
                $this->db_b->set('mes_7', $valMes7);
                $this->db_b->set('mes_8', $valMes8);
                $this->db_b->set('mes_9', $valMes9);
                $this->db_b->set('mes_10', $valMes10);
                $this->db_b->set('mes_11', $valMes11);
                $this->db_b->set('mes_12', $valMes12);
                $this->db_b->set('mes_13', $valMes13);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctpdef');
                $idptipo = $this->db->insert_id();
                
                if($query == 1){
                    $consulta1 = "SELECT * FROM ctyears ORDER BY idano ASC";
                    $query1 = $this->db_b->query($consulta1);
                    $resultado1 = $query1->result();
                    
                    if($query1->num_rows() >= 1){
                        foreach($resultado1 as $year){
                            $idano = $year->idano;
                            $meses = $year->meses;
                            
                            $month = $idano.'-'. '01';
                            $aux = date('Y-m-d', strtotime("{$month} + 1 month"));
                            $last_day = date('Y-m-d', strtotime("{$aux} - 1 day"));
                            $primero = date('Y-m-d', strtotime("{$month}"));
                            $this->db_b->set('idano', $idano);
                            $this->db_b->set('idmes', 0);
                            $this->db_b->set('idptipo', $idptipo);
                            $this->db_b->set('fechaini', $primero);
                            $this->db_b->set('fechafin', $last_day);
                            $this->db_b->set('numero', 0);
                            $this->db_b->set('estado', 1);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $fecha_actual);
                            $query = $this->db_b->insert('ctpnums');
                                
                            for($i=1; $i<=12;$i++){
                                $month = $idano.'-'.$i;
                                $aux = date('Y-m-d', strtotime("{$month} + 1 month"));
                                $last_day = date('Y-m-d', strtotime("{$aux} - 1 day"));
                                $primero = date('Y-m-d', strtotime("{$month}"));
                                $this->db_b->set('idano', $idano);
                                $this->db_b->set('idmes', $i);
                                $this->db_b->set('idptipo', $idptipo);
                                $this->db_b->set('fechaini', $primero);
                                $this->db_b->set('fechafin', $last_day);
                                $this->db_b->set('numero', 0);
                                $this->db_b->set('estado', 1);
                                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                                $this->db_b->set('ingresa', $fecha_actual);
                                $query = $this->db_b->insert('ctpnums');
                            }
                                
                            $month = $idano.'-'.'12';
                            $aux = date('Y-m-d', strtotime("{$month} + 1 month"));
                            $last_day = date('Y-m-d', strtotime("{$aux} - 1 day"));
                            $primero = date('Y-m-d', strtotime("{$month}"));
                            $this->db_b->set('idano', $idano);
                            $this->db_b->set('idmes', 13);
                            $this->db_b->set('idptipo', $idptipo);
                            $this->db_b->set('fechaini', $primero);
                            $this->db_b->set('fechafin', $last_day);
                            $this->db_b->set('numero', 0);
                            $this->db_b->set('estado', 1);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $fecha_actual);
                            $query = $this->db_b->insert('ctpnums');
                            
                        }
                    }
                }
                
                return $query;
            }
        }
        
        function updatePartida($idptipo, $tipo, $formato, $s_contra, $correlativos, $inputMeses, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                if($s_contra == "true"){
                    $s_contra = "1";
                }else{
                    $s_contra = "0";
                }
                
                $valMes0 = 0; $valMes1 = 0; $valMes2 = 0; $valMes3 = 0; $valMes4 = 0; $valMes5 = 0; $valMes6 = 0;
                $valMes7 = 0; $valMes8 = 0; $valMes9 = 0; $valMes10 = 0; $valMes11 = 0; $valMes12 = 0; $valMes13 = 0;
                
                if($inputMeses != ""){
                    $arrayMeses = explode(",", $inputMeses);
                    $totArray = count($arrayMeses);

                    for($k=0; $k<$totArray; $k++){
                        switch($arrayMeses[$k]){
                            case 0:
                                $valMes0 = 1;
                                break;
                            case 1:
                                $valMes1 = 1;
                                break;
                            case 2:
                                $valMes2 = 1;
                                break;
                            case 3:
                                $valMes3 = 1;
                                break;
                            case 4:
                                $valMes4 = 1;
                                break;
                            case 5:
                                $valMes5 = 1;
                                break;
                            case 6:
                                $valMes6 = 1;
                                break;
                            case 7:
                                $valMes7 = 1;
                                break;
                            case 8:
                                $valMes8 = 1;
                                break;
                            case 9:
                                $valMes9 = 1;
                                break;
                            case 10:
                                $valMes10 = 1;
                                break;
                            case 11:
                                $valMes11 = 1;
                                break;
                            case 12:
                                $valMes12 = 1;
                                break;
                            case 13:
                                $valMes13 = 1;
                                break;
                        }
                    }	
                }
                
                $this->db_b->set('descrip', $tipo);
                $this->db_b->set('idform', $formato);
                $this->db_b->set('askpwd', $s_contra);
                $this->db_b->set('tiponum', $correlativos);
                $this->db_b->set('mes_0', $valMes0);
                $this->db_b->set('mes_1', $valMes1);
                $this->db_b->set('mes_2', $valMes2);
                $this->db_b->set('mes_3', $valMes3);
                $this->db_b->set('mes_4', $valMes4);
                $this->db_b->set('mes_5', $valMes5);
                $this->db_b->set('mes_6', $valMes6);
                $this->db_b->set('mes_7', $valMes7);
                $this->db_b->set('mes_8', $valMes8);
                $this->db_b->set('mes_9', $valMes9);
                $this->db_b->set('mes_10', $valMes10);
                $this->db_b->set('mes_11', $valMes11);
                $this->db_b->set('mes_12', $valMes12);
                $this->db_b->set('mes_13', $valMes13);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idptipo', $idptipo);
                $query = $this->db_b->update('ctpdef');
                
                return $query;
            }
        }
        
        function updateNum($last_num, $anio, $mes, $numero, $estado, $notas,$idptipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                        
                $whodidit = $this->session->userdata('iduser');
                $date = new DateTime($anio);
                $this->db_b->set('numero', $numero);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->where('numero', $last_num);
                $this->db_b->where('idptipo', $idptipo);
                $this->db_b->where('idano', $date->format('Y'));
                $query = $this->db_b->update('ctpnums');
                return $query;
            }
        }
        
        function updateNumerosPartidas($idptipo,$idano,$idmes,$numero,$estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $date = new DateTime($idano);
                
                $this->db_b->set('numero', $numero);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idmes', $idmes);
                $this->db_b->where('idptipo', $idptipo);
                $this->db_b->where('idano', $date->format('Y'));
                $query = $this->db_b->update('ctpnums');
                
                return $query;
            }
        }
        
        function insertRegistroConta100($idptipo, $numero, $fecha, $referencia, $descripcion, $estado, $notas, $year, $idmes, $idcentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $this->db_b->set('pnumero', 0);
                $this->db_b->set('idmes', $idmes);
                $this->db_b->set('idsite', $idcentro);
                $this->db_b->set('idptipo', $idptipo);
                $this->db_b->set('numero', $numero);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('descrip', $descripcion);
                $this->db_b->set('origen', 'conta/epartidas');
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('ingresa', $fecha_actual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->insert('ct'.$year.'hd');
                
                $SQL1 = "SELECT tiponum FROM ctpdef WHERE idptipo = $idptipo";
                $Query1 = $this->db_b->query($SQL1);
                $Result1 = $Query1->row_array();
                $tipoNums = $Result1['tiponum'];
                
                if($tipoNums == 0){
                    $consulta = "SELECT numero FROM ctpnums WHERE idano = $year AND idmes = $idmes AND idptipo = $idptipo AND estado = 1";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $numero = $resultado['numero'] + 1;
                    }else{
                        $numero = false;
                    }
                    
                    $date = new DateTime($year);
                    
                    $this->db_b->set('numero', $numero);
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('idmes', $idmes);
                    $this->db_b->where('idptipo', $idptipo);
                    $this->db_b->where('idano', $date->format('Y'));
                    $query = $this->db_b->update('ctpnums');
                }else{
                    $consulta = "SELECT numero FROM ctpnums WHERE idano = $year AND idmes = 0 AND idptipo = $idptipo";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() > 0){
                        $resultado = $query->row_array();
                        $numero = $resultado['numero'] + 1;
                    }else{
                        $numero = false;
                    }
                    
                    $date = new DateTime($year);
                    
                    $this->db_b->set('numero', $numero);
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('idmes', 0);
                    $this->db_b->where('idptipo', $idptipo);
                    $this->db_b->where('idano', $date->format('Y'));
                    $query = $this->db_b->update('ctpnums');
                }
                
                return $query;
            }
        }
            
        function getRegistrosConta100($idptipo, $year, $idmes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ct".$year."hd WHERE ct".$year."hd.idmes = $idmes AND ct".$year."hd.idptipo = $idptipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewProyectos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctproj ORDER BY idproject ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertProyecto($desc, $cliente, $fechain, $fechafin, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
            
                
                $this->db_b->set('idproject', 0);
                $this->db_b->set('descrip', $desc);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('fechaini', $fechain);
                $this->db_b->set('fechafin', $fechafin);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctproj');
                return $query;
            }
        }
        
        function updateProyecto($id, $desc, $cliente, $fechain, $fechafin, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                        
                $whodidit = $this->session->userdata('iduser');
                $this->db_b->set('descrip', $desc);
                $this->db_b->set('idcps', $cliente);
                $this->db_b->set('fechaini', $fechain);
                $this->db_b->set('fechafin', $fechafin);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idproject', $id);
                $query = $this->db_b->update('ctproj');
                return $query;
                //redirect('conta/listacatalogo/'.$this->session->userdata('iddApp'));
            }
        }
        
        function getAuxiliares($nombre, $num){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idrnum,descripcion,valor_num,valor_txt,valor_memo,  (SELECT COUNT(idauxi) FROM ctauxi WHERE ctauxi.idauxidef= gvars.valor_num) as cant FROM gvars where nombre='$nombre' and valor_num>=$num ORDER BY descripcion ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getImgAuxi($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT imagen FROM ctauxi WHERE  idauxi='$idauxi'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['imagen'];
            }
        }
        
        function addNewAuxi($nombre, $descrip,$valor_logico,$img,$whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
            
                $consulta = "SELECT valor_num FROM gvars where nombre LIKE'$nombre' order by valor_num DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $num = $resultado['valor_num'];
                $valor_num = $num+1;
                $img = str_replace(" ", "_", $img);
                $this->db_b->set('idrnum', 0);
                $this->db_b->set('nombre', $nombre);
                $this->db_b->set('descripcion', $descrip);
                $this->db_b->set('valor_num', $valor_num);
                $this->db_b->set('valor_logico', $valor_logico);
                $this->db_b->set('valor_txt', $img);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('gvars');
                $id = $this->db_b->insert_id();
                return $id;
            }
        }
        
        function updateImgAuxi($idauxi,$nombreimagen2){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
                $this->db_b->set('valor_txt', $nombreimagen2);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrnum', $idauxi);
                $query = $this->db_b->update('gvars');
                return $query;
            }
        }
            
        function updateAuxi($idrnum,$descrip,$valor_logico,$img){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
            
                
                $img = str_replace(" ", "_", $img);
                if($img!=""){
                    $this->db_b->set('valor_txt', $img);
                }
                
                $this->db_b->set('descripcion', $descrip);
                $this->db_b->set('valor_logico', $valor_logico);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gvars');
                return $query;
            }
        }
    
        function getInfoAuxi($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idrnum,descripcion,valor_num,valor_txt,valor_memo, valor_logico, valor_logico as id_tipo, (SELECT valor_num FROM gvars where idrnum=id_tipo) as idrnum_tipo, (SELECT COUNT(idauxi) FROM ctauxi WHERE ctauxi.idauxidef= gvars.valor_num) as cant FROM gvars where idrnum='$idrnum'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }
        
        function getauxilist($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_num FROM gvars where idrnum='$idrnum'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $valor_num =  $resultado['valor_num'];
                
                $consulta = "SELECT * FROM ctauxi WHERE idauxidef='$valor_num'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getauxilist2($valor_num){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $consulta = "SELECT * FROM ctauxi WHERE idauxidef='$valor_num'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function deletePhoto($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
                
                $this->db_b->set('valor_txt', "");
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gvars');
                
                
                $consulta = "SELECT valor_txt FROM gvars where idrnum='$idrnum'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['valor_txt'];
            }
        }
        
        function deletePhotoAuxi($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
                
                $consulta = "SELECT imagen FROM ctauxi where idauxi='$idauxi'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $name_imglast =  $resultado['imagen'];
                
                $this->db_b->set('imagen', "");
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idauxi', $idauxi);
                $query = $this->db_b->update('ctauxi');
                return $name_imglast;
            }
        }
        
        function viewGrupo($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_memo FROM gvars where idrnum='$idrnum' AND nombre='auxi_def'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['valor_memo'];
            }
        }
        
        function getIdrnum($valor_num){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idrnum FROM gvars where valor_num='$valor_num' AND nombre='auxi_def'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['idrnum'];
            }
        }
        
        function viewGrupo2($valor_num){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT valor_memo FROM gvars where valor_num='$valor_num' AND nombre='auxi_def'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['valor_memo'];
            }
        }
        
        function updateGrupo($idrnum, $grupos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser');
                
                $this->db_b->set('valor_memo', $grupos);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrnum', $idrnum);
                $query = $this->db_b->update('gvars');
                return $query;
            }
        }
        
        function viewAplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctaplica_100.idaplica AS id, ctaplica_100.descrip, ctpdef.descrip AS descripcion  FROM ctaplica_100 INNER JOIN ctpdef ON ctpdef.idptipo = ctaplica_100.idptipo ORDER BY ctaplica_100.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewAplicacion($idaplica){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctaplica_100.idaplica AS id, ctaplica_100.descrip, ctpdef.descrip AS descripcion  FROM ctaplica_100 INNER JOIN ctpdef ON ctpdef.idptipo = ctaplica_100.idptipo WHERE ctaplica_100.idaplica = $idaplica";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDataAplica_100d($idaplica){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctaplica_100d.idrec, ctaplica_100d.idaplica AS id, ctaplica_100d.grupoap AS grupo, ctaplica_100d.descrip  AS titulo, ctaplica_100d.dh, ctcatalog.ctcuenta AS cuenta, ctcatalog.descrip AS descripcion FROM ctaplica_100d INNER JOIN ctcatalog ON ctaplica_100d.idcuenta = ctcatalog.idcuenta WHERE ctaplica_100d.idaplica = $idaplica ORDER BY ctaplica_100d.grupoap ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewTiposDef(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idptipo, descrip FROM ctpdef";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewDatosAplica($id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctaplica_100 WHERE ctaplica_100.idaplica = $id";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function deleteDataAplica_100d($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM ctaplica_100d WHERE idrec = $idrec";
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function insertApp($descrip,$idptipo,$notas,$whodidit,$estado,$iva){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                        
                $this->db_b->set('idaplica', 0);
                $this->db_b->set('idptipo', $idptipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('savetoiva', $iva);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctaplica_100');
                redirect('conta/listaaplica/'.$this->session->userdata('iddApp'));
            }
        }
        
        function updateApp($descrip,$idptipo,$notas,$whodidit,$estado,$iva, $id){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $this->db_b->set('idptipo', $idptipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('savetoiva', $iva);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idaplica', $id);
                $query = $this->db_b->update('ctaplica_100');
                redirect('conta/listaaplica/'.$this->session->userdata('iddApp'));
            }
        }
        
        function insertCtauxi($descrip,$idauxidef, $telefono,$correo,$direccion,$idzip,$fechain,$dui,$nit,$giro,$grupo,$estado,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
            
                if($estado == "true"){
                    $estado = "1";
                }else{
                    $estado = "0";
                }
                
                $consulta = "SELECT valor_num FROM gvars where idrnum='$idauxidef'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $valor_num =  $resultado['valor_num'];
                
                $whodidit = $this->session->userdata('iduser');
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idauxidef', $valor_num);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('fechain', $fechain);
                $this->db_b->set('nrc', $dui);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('giro', $giro);
                $this->db_b->set('grupo', $grupo);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctauxi');
                $id = $this->db_b->insert_id();
                return $id;
            }
        }
        
        function updatePhotoName($idauxi, $photoName){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                $whodidit = $this->session->userdata('iduser'); 
                $this->db_b->set('imagen', $photoName);    
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idauxi', $idauxi);
                $query = $this->db_b->update('ctauxi');
                return $query;
            }
        }
        
        function updateCtauxi($idauxi,$descrip,$telefono,$correo,$direccion,$idzip,$fechain,$dui,$nit,$giro,$grupo,$estado,$notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
            
                if($estado == "true"){
                    $estado = "1";
                }else{
                    $estado = "0";
                }
                $whodidit = $this->session->userdata('iduser');
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('direccion', $direccion);
                $this->db_b->set('idzip', $idzip);
                $this->db_b->set('fechain', $fechain);
                $this->db_b->set('nrc', $dui);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('giro', $giro);
                $this->db_b->set('grupo', $grupo);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idauxi', $idauxi);
                $query = $this->db_b->update('ctauxi');
                return $query;
            }
        }
        
        function getAuxiliaresCuenta($idcuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idauxidef FROM ctcatalog WHERE  idcuenta='$idcuenta'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $idauxidef =  $resultado['idauxidef'];
                
                $consulta = "SELECT * FROM ctauxi where idauxidef=$idauxidef";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertCorrelativo($idauxi, $idcuenta, $tipoDoc, $serie, $desde, $hasta, $actual, $reserva, $form, $aplica, $bdate, $edate, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whodidit = $this->session->userdata('iduser');
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
            
                if($estado == "true"){
                    $estado = "1";
                }else{
                    $estado = "0";
                }
                
                $this->db_b->set('idbtipo', 0);
                $this->db_b->set('idcuenta', $idcuenta);
                $this->db_b->set('idauxi', $idauxi);
                $this->db_b->set('descrip', $tipoDoc);
                $this->db_b->set('serie', $serie);
                $this->db_b->set('desde', $desde);
                $this->db_b->set('hasta', $hasta);
                $this->db_b->set('actual', $actual);
                $this->db_b->set('reserva', $reserva);
                $this->db_b->set('bfecha', $bdate);
                $this->db_b->set('efecha', $edate);
                $this->db_b->set('tdh', $aplica);
                $this->db_b->set('idform', $form);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('ctbtipos');
                return $query;
                
            }
        }
        
        function updateCorrelativo($idbtipo, $tipoDoc, $serie, $desde, $hasta, $actual, $reserva, $form, $aplica, $bdate, $edate, $estado, $notas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whodidit = $this->session->userdata('iduser');
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
            
                if($estado == "true"){
                    $estado = "1";
                }else{
                    $estado = "0";
                }
                
                $this->db_b->set('descrip', $tipoDoc);
                $this->db_b->set('serie', $serie);
                $this->db_b->set('desde', $desde);
                $this->db_b->set('hasta', $hasta);
                $this->db_b->set('actual', $actual);
                $this->db_b->set('reserva', $reserva);
                $this->db_b->set('bfecha', $bdate);
                $this->db_b->set('efecha', $edate);
                $this->db_b->set('tdh', $aplica);
                $this->db_b->set('idform', $form);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idbtipo', $idbtipo);
                $query = $this->db_b->update('ctbtipos');
                return $query;
            }
        }
        
        function getCorrelativos($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctbtipos where idauxi=$idauxi";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getDetailPartida($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ct".$year."hd.*, ctpdef.descrip AS tipoPartida FROM ct".$year."hd INNER JOIN ctpdef ON ct".$year."hd.idptipo = ctpdef.idptipo WHERE ct".$year."hd.pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoCatalogoPartida14(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tipocuenta, descrip, ctcuenta FROM ctcatalog WHERE (ctgrupo = 1 OR ctgrupo = 4) AND tipocuenta < 3";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoCatalogoPartida235(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT tipocuenta, descrip, ctcuenta FROM ctcatalog WHERE (ctgrupo = 2 OR ctgrupo = 3 OR ctgrupo = 5) AND tipocuenta < 3";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCatalogoCuentasByCodigo($idcuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT * FROM ctcatalog WHERE total2 = $idcuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getAuxiliaresByAuxidef($idauxidef){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idauxi, descrip, imagen FROM ctauxi WHERE idauxidef = $idauxidef ORDER BY descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getAuxiliaresByUso($idauxidef, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, ctauxi.imagen, COUNT(ct".$year."dt.idauxi) AS total FROM ctauxi LEFT JOIN ct".$year."dt ON ctauxi.idauxi = ct".$year."dt.idauxi WHERE ctauxi.idauxidef = $idauxidef GROUP BY ctauxi.idauxi ORDER BY total DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getMovimientosByAuxiCuenta($idauxi, $idcuenta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idbtipo, descrip FROM ctbtipos WHERE idauxi = $idauxi AND idcuenta = $idcuenta AND (tdh = 1 OR tdh = 2) AND estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCorrelativosMovimiento($idbtipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT serie, desde, hasta, actual FROM ctbtipos WHERE idbtipo = $idbtipo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInformacionContaDT($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLConsulta = "SELECT contadt.movnum, contadt.pnumero, contadt.idcentro, contadt.idproject, contadt.idauxi, contadt.idbtipo, contadt.notas, contadt.descrip AS descripcion, CONCAT(ctcatalog.ctcuenta,' ',ctcatalog.descrip,'|',IFNULL(ctauxi.idauxi, ''),' ',IFNULL(ctauxi.descrip, ''),'|',contadt.descrip) AS descripcuenta, IFNULL(CONCAT(ctbtipos.descrip,'|',contadt.doc_serie,'-',contadt.doc_numero), '') AS docreferencia, IFNULL(CONCAT(contadt.doc_serie,'/',contadt.doc_numero), '') AS serienumero, contadt.doc_line, contadt.debe, contadt.haber, ctcatalog.ctcontrol, ctcatalog.idcuenta, ctcatalog.ctgrupo, ctcatalog.idauxidef, ctcatalog.ctcuenta, ctcatalog.descrip, ctcatalog.askproyecto, ctcatalog.askidcentro FROM ct".$year."dt AS contadt INNER JOIN ctcatalog ON contadt.idcuenta = ctcatalog.idcuenta LEFT JOIN ctbtipos ON contadt.idbtipo = ctbtipos.idbtipo LEFT JOIN ctauxi ON contadt.idauxi = ctauxi.idauxi WHERE contadt.pnumero = $pnumero";
                $Query = $this->db_b->query($SQLConsulta);
                $resultado = $Query->result();
                
                return $resultado;
            }
        }
        
        function insertarRegistroContaDT($pnumero, $idcuenta, $idauxi, $descrip, $idbtipo, $serienumero, $valor, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaInsert = date("Y-m-d H:i:s");
                $fechaMod = date("Y-m-d H:i:s");
                
                $consulta = "SELECT fecha, estado FROM ct".$year."hd WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $SQLCbtipo = "SELECT tdh FROM ctbtipos WHERE idbtipo = $idbtipo";
                $QueryCb = $this->db_b->query($SQLCbtipo);
                $informacion = $QueryCb->row_array();
                
                $SQLineas = "SELECT COUNT(movnum) AS total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $QueryLine = $this->db_b->query($SQLineas);
                $infoLine = $QueryLine->row_array();
                
                $numLinea = $infoLine['total'] + 1;
                
                $fecha = $resultado['fecha'];
                $fechavence = strtotime('+365 day', strtotime($fecha));
                $fechavence = date('Y-m-j', $fechavence);
                
                $estado = $resultado['estado'];
                $tdh = $informacion['tdh'];
                
                $datosSerie = explode("/", $serienumero);
                
                $this->db_b->set('movnum', 0);
                $this->db_b->set('pnumero', $pnumero);
                $this->db_b->set('idcuenta', $idcuenta);
                $this->db_b->set('idauxi', $idauxi);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idbtipo', $idbtipo);
                $this->db_b->set('doc_line', $numLinea);
                $this->db_b->set('doc_serie', $datosSerie[0]);
                $this->db_b->set('doc_numero', $datosSerie[1]);
                $this->db_b->set('doc_emision', $fecha);
                $this->db_b->set('doc_vence', $fechavence);
                $this->db_b->set('doc_estado', 1);
                if($tdh == 1){
                    $this->db_b->set('debe', $valor);
                }elseif($tdh == 2){
                    $this->db_b->set('haber', $valor);
                }
                $this->db_b->set('estado', $estado);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fechaInsert);
                $this->db_b->insert('ct'.$year.'dt');
                
                $SQLNumero = "SELECT actual FROM ctbtipos WHERE idbtipo = $idbtipo";
                $QueryNumero = $this->db_b->query($SQLNumero);
                $infoNum = $QueryNumero->row_array();
                $numActual = $infoNum['actual'] + 1;
                
                $this->db_b->set('actual', $numActual);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fechaMod);
                $this->db_b->where('idbtipo', $idbtipo);
                $query = $this->db_b->update('ctbtipos');
                
                return $query;
            }
        }
        
        function updateRegistroContaDT($movnum, $idauxi, $descrip, $idbtipo, $serienumero, $valor, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaMod = date("Y-m-d H:i:s");
                
                $SQLCbtipo = "SELECT tdh FROM ctbtipos WHERE idbtipo = $idbtipo";
                $QueryCb = $this->db_b->query($SQLCbtipo);
                $informacion = $QueryCb->row_array();
                
                $tdh = $informacion['tdh'];
                $datosSerie = explode("/", $serienumero);
                
                $this->db_b->set('idauxi', $idauxi);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idbtipo', $idbtipo);
                $this->db_b->set('doc_serie', $datosSerie[0]);
                $this->db_b->set('doc_numero', $datosSerie[1]);
                if($tdh == 1){
                    $this->db_b->set('debe', $valor);
                }elseif($tdh == 2){
                    $this->db_b->set('haber', $valor);
                }
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fechaMod);
                $this->db_b->where('movnum', $movnum);
                $query = $this->db_b->update('ct'.$year.'dt');
                
                return $query;
            }
        }
        
        function insertarRegistroControl0($pnumero, $idcuenta, $idauxi, $descrip, $idproyecto, $idcentro, $notas, $debe, $haber, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaInsert = date("Y-m-d H:i:s");
                
                $consulta = "SELECT estado FROM ct".$year."hd WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $SQLineas = "SELECT COUNT(movnum) AS total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $QueryLine = $this->db_b->query($SQLineas);
                $infoLine = $QueryLine->row_array();
                
                $numLinea = $infoLine['total'] + 1;
                $estado = $resultado['estado'];
                
                $this->db_b->set('movnum', 0);
                $this->db_b->set('pnumero', $pnumero);
                $this->db_b->set('idcuenta', $idcuenta);
                $this->db_b->set('idauxi', $idauxi);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproject', $idproyecto);
                $this->db_b->set('doc_line', $numLinea);
                if($debe == 0 || $debe == ""){
                    $this->db_b->set('haber', $haber);
                }elseif($haber == 0 || $haber == ""){
                    $this->db_b->set('debe', $debe);
                }
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fechaInsert);
                $query = $this->db_b->insert('ct'.$year.'dt');
                
                return $query;
            }
        }
        
        function insertarRegistroControl0ConAuxi($pnumero, $idcuenta, $idauxi, $sidauxi, $descrip, $idproyecto, $idcentro, $notas, $debe, $haber, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaInsert = date("Y-m-d H:i:s");
                
                $consulta = "SELECT estado FROM ct".$year."hd WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $SQLineas = "SELECT COUNT(movnum) AS total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $QueryLine = $this->db_b->query($SQLineas);
                $infoLine = $QueryLine->row_array();
                
                $numLinea = $infoLine['total'] + 1;
                $estado = $resultado['estado'];
                
                $this->db_b->set('movnum', 0);
                $this->db_b->set('pnumero', $pnumero);
                $this->db_b->set('idcuenta', $idcuenta);
                $this->db_b->set('idauxi', $idauxi);
                $this->db_b->set('sidauxi', $sidauxi);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('idproject', $idproyecto);
                $this->db_b->set('doc_line', $numLinea);
                if($debe == 0 || $debe == ""){
                    $this->db_b->set('haber', $haber);
                }elseif($haber == 0 || $haber == ""){
                    $this->db_b->set('debe', $debe);
                }
                $this->db_b->set('estado', $estado);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fechaInsert);
                $query = $this->db_b->insert('ct'.$year.'dt');
                
                return $query;
            }
        }
        
        function getTotalDebePartida($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(debe) AS Total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['Total'];
            }
        }
        
        function getTotalHaberPartida($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT SUM(haber) AS Total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['Total'];
            }
        }
        
        function getTotalLineasPartida($pnumero, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT COUNT(movnum) AS Total FROM ct".$year."dt WHERE pnumero = $pnumero";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                return $resultado['Total'];
            }
        }
        
        function getInformacionAutocomplete($idcuenta, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT descrip FROM ct".$year."dt WHERE idcuenta = $idcuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getInformacionAutocompleteFiltrada($idcuenta, $sidauxi, $year, $idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT descrip FROM ct".$year."dt WHERE idcuenta = $idcuenta AND sidauxi = $sidauxi AND idauxi = $idauxi";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getListadoProyectos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT idproject, descrip FROM ctproj WHERE estado = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getResultadoAutocomplete($textComplete, $idcuenta, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT ctdt.descrip, ctdt.idauxi, ctdt.idcentro, ctdt.idproject, ctdt.debe, ctdt.haber, IFNULL(ctauxi.descrip, '') AS nameAuxiliar, IFNULL(invsites.descrip, '') AS nameCentro FROM ct".$year."dt AS ctdt LEFT JOIN ctauxi ON ctdt.idauxi = ctauxi.idauxi LEFT JOIN invsites ON ctdt.idcentro = invsites.idcentro WHERE ctdt.descrip = '$textComplete' AND ctdt.idcuenta = $idcuenta";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function deleteRegistroContadt($movnum, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "DELETE FROM ct".$year."dt WHERE movnum = $movnum";
                $query = $this->db_b->query($consulta);
                
                return $query;
            }
        }
        
        function getCatalogoMasUsado($year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT ctcatalog.*, COUNT(ct".$year."dt.idcuenta) AS total FROM ct".$year."dt INNER JOIN ctcatalog ON ct".$year."dt.idcuenta = ctcatalog.idcuenta GROUP BY ct".$year."dt.idcuenta ORDER BY total DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getDatosContactosAuxiliaresCuenta($filtros, $year){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $where_txt = str_replace(","," OR idauxidef = ", $filtros);
                
                $consulta = "SELECT ctauxi.idauxi, ctauxi.descrip, (SELECT COUNT(contadt.movnum) FROM ct".$year."dt AS contadt WHERE contadt.sidauxi = ctauxi.idauxi) AS total FROM ctauxi WHERE ctauxi.idauxidef = " . $where_txt . " ORDER BY total DESC, ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getInformacionAuxiliarDef($idauxidef){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT descripcion FROM gvars WHERE nombre = 'auxi_def' AND valor_num = $idauxidef";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $descrip = $resultado['descripcion'];
                
                return $descrip;
            }
        }
        
        function insertContactoAuxiliar($idauxidef, $descrip, $duinrc, $nit, $telefono, $correo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaInsert = date("Y-m-d H:i:s");
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('idauxidef', $idauxidef);
                $this->db_b->set('nrc', $duinrc);
                $this->db_b->set('nit', $nit);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('estado', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $fechaInsert);
                $this->db_b->insert('ctauxi');
                
                $idauxi = $this->db_b->insert_id();
                return $idauxi;
            }
        }
        
        function getFrecuentesContacto($idcuenta, $year, $idauxidef, $sidauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT ctauxi.idauxi, ctauxi.descrip, IFNULL(contadt.debe, 0) AS debe, IFNULL(contadt.haber, 0) AS haber, invsites.idcentro, IFNULL(invsites.descrip, '') AS centrocostos, ctproj.idproject, IFNULL(ctproj.descrip, '') AS proyecto, (SELECT COUNT(contadt2.movnum) FROM ct".$year."dt AS contadt2 WHERE contadt2.idcuenta = $idcuenta AND contadt2.sidauxi = $sidauxi AND contadt2.idauxi = ctauxi.idauxi) AS totMov FROM ctauxi LEFT JOIN ct".$year."dt AS contadt ON ctauxi.idauxi = contadt.idauxi AND contadt.idcuenta = $idcuenta AND sidauxi = $sidauxi LEFT JOIN invsites ON contadt.idcentro = invsites.idcentro LEFT JOIN ctproj ON contadt.idproject = ctproj.idproject WHERE ctauxi.idauxidef = $idauxidef ORDER BY totMov DESC, ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getLastPosicionTipoPartida($tipo_partida){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT DISTINCT posicion FROM conta_genfunc WHERE partipo = $tipo_partida ORDER BY posicion DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() > 0){
                    $resultado = $query->row_array();
                    $numero = $resultado['posicion'] + 1;
                }else{
                    $numero = 1;
                }

                return $numero;
            }
        }
        
        function getMovimientosContables($filtro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $consulta = "SELECT conta_genfunc.*, gvars.descripcion, gvars.valor_memo AS tipoPartida FROM conta_genfunc INNER JOIN gvars ON conta_genfunc.partipo = gvars.valor_num AND gvars.nombre = 'conta_gen' AND gvars.filtro = '$filtro' WHERE conta_genfunc.estado = 1 ORDER BY conta_genfunc.posicion ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        /*
        function getPagos($fechaini, $fechafin, $idclases, $cajclases, $invcatalogs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $usingWhere = 0;
                $whereIdclase = ""; $whereCajclase = ""; $whereInvcatalog = "";
                
                if($idclases != ""){
                    $usingWhere = 1;
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($cajclases != ""){
                    $usingWhere = 1;
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "(tran_100c.cajclase = " . $caj_clases[$i] . " OR tran_100.numy = ". $caj_clases[$i] . ") OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($invcatalogs != ""){
                    $usingWhere = 1;
                    $inv_catalog = explode(",", $invcatalogs);
                    
                    $whereInvcatalog .= "(";
                    for($i=0; $i<count($inv_catalog); $i++){
                        $whereInvcatalog .= "invcatalog2.idcatalogo = " . $inv_catalog[$i] . " OR ";
                    }
                    
                    $whereInvcatalog = substr($whereInvcatalog, 0, -4);
                    $whereInvcatalog .= ")"; 
                }
                
                $SQLConsulta = "SELECT tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(IF(IFNULL(tran_100c.trannum, 0) = 0, (tran_100.valventan + tran_100.valtax1), (tran_100c.valor * -1) - (tran_100c.vuelto * -1))) AS valorTotal FROM tran_100 LEFT JOIN tran_100c ON tran_100c.trannum = tran_100.trannum INNER JOIN tran_100k ON tran_100.trannum = tran_100k.trannum INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCajclase != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajclase . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                    }
                }
                
                if($whereInvcatalog != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereInvcatalog . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereInvcatalog . "     ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        */
        function getPagos($idcentros, $idcajas, $fechaini, $fechafin, $idclases, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCajclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100c.cajclase = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ABS(ROUND(tran_100c.valor, 4)) - ABS(ROUND(tran_100c.vuelto, 4))) AS valorTotal FROM tran_100c INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCajclase != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajclase . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getPagoscxc($idcentros, $idcajas, $fechaini, $fechafin, $idclases, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCajclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100.numy = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ROUND(tran_100.valventan, 4) + ROUND(tran_100.valtax1, 4)) AS valorTotal FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCajclase != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajclase . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getIvaVentas($idcentros, $idcajas, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ABS(ROUND(tran_100.valtax1, 4))) AS valorTotal FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getVentasDpto($idcentros, $idcajas, $fechaini, $fechafin, $idclases,  $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($iddptos != ""){
                    $inv_departamentos = explode(",", $iddptos);
                    
                    $whereDepartamentos .= "(";
                    for($i=0; $i<count($inv_departamentos); $i++){
                        $whereDepartamentos .= "invcatalog2.idcatalogo = " . $inv_departamentos[$i] . " OR ";
                    }
                    
                    $whereDepartamentos = substr($whereDepartamentos, 0, -4);
                    $whereDepartamentos .= ")";
                }
                
                if($idlineas != ""){
                    $inv_lineas = explode(",", $idlineas);
                    
                    $whereLineas .= "(";
                    for($i=0; $i<count($inv_lineas); $i++){
                        $whereLineas .= "invcatalog.idcatalogo = " . $inv_lineas[$i] . " OR ";
                    }
                    
                    $whereLineas = substr($whereLineas, 0, -4);
                    $whereLineas .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM((ABS(Round(tran_100k.precioneto, 6)) * ABS(tran_100k.cantidad))) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereDepartamentos != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereDepartamentos . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereDepartamentos . " AND ";
                    }
                }
                
                if($whereLineas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereLineas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereLineas . " AND ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getCostoVentas($idcentros, $idcajas, $fechaini, $fechafin, $idclases,  $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($iddptos != ""){
                    $inv_departamentos = explode(",", $iddptos);
                    
                    $whereDepartamentos .= "(";
                    for($i=0; $i<count($inv_departamentos); $i++){
                        $whereDepartamentos .= "invcatalog2.idcatalogo = " . $inv_departamentos[$i] . " OR ";
                    }
                    
                    $whereDepartamentos = substr($whereDepartamentos, 0, -4);
                    $whereDepartamentos .= ")";
                }
                
                if($idlineas != ""){
                    $inv_lineas = explode(",", $idlineas);
                    
                    $whereLineas .= "(";
                    for($i=0; $i<count($inv_lineas); $i++){
                        $whereLineas .= "invcatalog.idcatalogo = " . $inv_lineas[$i] . " OR ";
                    }
                    
                    $whereLineas = substr($whereLineas, 0, -4);
                    $whereLineas .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(((Round(tran_100k.costounitario,6) * tran_100k.cantidad * tran_100k.uniconv  ) * -1)) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereDepartamentos != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereDepartamentos . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereDepartamentos . "     ";
                    }
                }
                
                if($whereLineas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereLineas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereLineas . "     ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        function getCostoVentasMensual($idcentros, $idcajas, $fechaini, $fechafin, $idclases,  $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($iddptos != ""){
                    $inv_departamentos = explode(",", $iddptos);
                    
                    $whereDepartamentos .= "(";
                    for($i=0; $i<count($inv_departamentos); $i++){
                        $whereDepartamentos .= "invcatalog2.idcatalogo = " . $inv_departamentos[$i] . " OR ";
                    }
                    
                    $whereDepartamentos = substr($whereDepartamentos, 0, -4);
                    $whereDepartamentos .= ")";
                }
                
                if($idlineas != ""){
                    $inv_lineas = explode(",", $idlineas);
                    
                    $whereLineas .= "(";
                    for($i=0; $i<count($inv_lineas); $i++){
                        $whereLineas .= "invcatalog.idcatalogo = " . $inv_lineas[$i] . " OR ";
                    }
                    
                    $whereLineas = substr($whereLineas, 0, -4);
                    $whereLineas .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, ('$fechafin') AS fecha, SUM(((Round(tran_100k.costounitario,6) * tran_100k.cantidad * tran_100k.uniconv  ) * -1)) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                // $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(((Round(tran_100k.costounitario,6) * tran_100k.cantidad * tran_100k.uniconv  ) * -1)) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereDepartamentos != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereDepartamentos . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereDepartamentos . "     ";
                    }
                }
                
                if($whereLineas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereLineas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereLineas . "     ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, MONTH(tran_100.fecha)";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getAbonosCxc($idcentros, $idcajas, $fechaini, $fechafin, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCajclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100c.cajclase = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100c.fecha, SUM(ROUND((tran_100c.valor * -1), 4)) AS valorTotal FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100c.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereCajclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100c.fecha";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getRemesasCxc($idcentros, $idcajas, $fechaini, $fechafin, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCajclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "ctauxi.idauxi = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, orders_100.fecha, SUM(ROUND((tran_100c.valor * -1), 4)) AS valorTotal FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN orders_100 ON tran_100c.idctcuenta = orders_100.trannum INNER JOIN ctauxi ON orders_100.idcps = ctauxi.idauxi INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE orders_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereCajclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, orders_100.fecha";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getRetencion($idcentros, $idcajas, $fechaini, $fechafin, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCajclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100c.cajclase = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100c.fecha, SUM(ROUND((tran_100c.valor * -1), 4)) AS valorTotal FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100c.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereCajclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100c.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        #Modificar Compras para Calculo de Retención o Percepción
        function getComprasCxp($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, ctauxi.descrip AS namecliente, tran_100.serie, tran_100.numero AS docnum, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, (SUM(ROUND( tran_100.valcosto, 6 ) + ROUND( tran_100.valtax1, 6 )) + IF(SUM(tran_100.valtax5) > 0, (SUM(ROUND( tran_100.valcosto, 6 )) * 0.01), 0) + IF(SUM(tran_100.valtax5) < 0, (SUM(ROUND( tran_100.valcosto, 6 )) * -0.01), 0)) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero";
                # 20210331:
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        #Compras Sin Impuestos
        function getComprasProv($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, ctauxi.descrip AS namecliente, tran_100.serie, tran_100.numero AS docnum, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND( tran_100.valcosto, 6 )) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero";
                # 20210331:
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        #Modificar Compras para Calculo de Retención o Percepción
        function getGastosCxp($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, ctauxi.descrip AS namecliente, tran_100.serie, tran_100.numero AS docnum, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, (SUM(ROUND( tran_100.valcosto, 6 ) + ROUND( tran_100.valtax1, 6 )) + IF(SUM(tran_100.valtax5) > 0, (SUM(ROUND( tran_100.valcosto, 6 )) * 0.01), 0) + IF(SUM(tran_100.valtax5) < 0, (SUM(ROUND( tran_100.valcosto, 6 )) * -0.01), 0)) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'GA' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero";
                # 20210331:
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        # Funcion para compras a Sujetos Excluidos 2021-10-04
        function getComprasCxpE($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, ctauxi.descrip AS namecliente, tran_100.serie, tran_100.numero AS docnum, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND( tran_100.valcosto, 6 )) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero";
                # 20210331:
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        # Funcion para compras a Sujetos Excluidos 2021-10-04
        function getGastosCxpE($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, ctauxi.descrip AS namecliente, tran_100.serie, tran_100.numero AS docnum, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND( tran_100.valcosto, 6 )) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'GA' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero";
                # 20210331:
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        function getComprasRet($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                //$SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, ROUND((tran_100.valtax5), 6) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND((tran_100.valcosto * 0.01), 6)) AS valorTotal, SUM(tran_100.valcosto) AS sumGroup, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' AND ctauxi.idtipo = 3 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum HAVING valorTotal != 0";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero HAVING sumGroup >= 100";
                # 20200115:    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getGastosRet($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                //$SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, ROUND((tran_100.valtax5), 6) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctauxi.xpos AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND((tran_100.valcosto * 0.01), 6)) AS valorTotal, SUM(tran_100.valcosto) AS sumGroup, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' AND ctauxi.idtipo = 3 INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'GA' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                            
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                //$SQLConsulta .= "GROUP BY tran_100.trannum HAVING valorTotal != 0";
                $SQLConsulta .= "GROUP BY tran_100.serie, tran_100.numero HAVING sumGroup >= 100";
                # 20200115:    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getIvaCompras($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                ##$SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ROUND(tran_100.valtax1, 4)) AS valorTotal FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro LEFT JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                ## 20200115-10:51 Added Joint to ctauxi
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ROUND(tran_100.valtax1, 6)) AS valorTotal FROM tran_100 INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro LEFT JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                                        
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.fecha";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getIvaGastos($idcentros, $fechaini, $fechafin, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                ##$SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ROUND(tran_100.valtax1, 4)) AS valorTotal FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro LEFT JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'CO' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                ## 20200115-10:51 Added Joint to ctauxi
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, invsites.descrip AS namecentro, ctcajas.descrip AS namecaja, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM(ROUND(tran_100.valtax1, 6)) AS valorTotal FROM tran_100 INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi AND ctauxi.nrc != '' INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro LEFT JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'GA' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                                        
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.fecha";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
            
        function getComprasDpto($idcentros, $fechaini, $fechafin, $idclases, $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($iddptos != ""){
                    $inv_departamentos = explode(",", $iddptos);
                    
                    $whereDepartamentos .= "(";
                    for($i=0; $i<count($inv_departamentos); $i++){
                        $whereDepartamentos .= "invcatalog2.idcatalogo = " . $inv_departamentos[$i] . " OR ";
                    }
                    
                    $whereDepartamentos = substr($whereDepartamentos, 0, -4);
                    $whereDepartamentos .= ")";
                }
                
                if($idlineas != ""){
                    $inv_lineas = explode(",", $idlineas);
                    
                    $whereLineas .= "(";
                    for($i=0; $i<count($inv_lineas); $i++){
                        $whereLineas .= "invcatalog.idcatalogo = " . $inv_lineas[$i] . " OR ";
                    }
                    
                    $whereLineas = substr($whereLineas, 0, -4);
                    $whereLineas .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                            
                ##$SQLConsulta = "SELECT invsites.xpos AS centroxpos, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM((Round(tran_100k.preciotran, 6) * tran_100k.uniconv) * tran_100k.cantidad) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo  WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM((Round(tran_100k.preciotran, 6) * tran_100k.uniconv) * tran_100k.cantidad) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi  AND ctauxi.nrc != '' INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo  WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereDepartamentos != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereDepartamentos . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereDepartamentos . "     ";
                    }
                }
                
                if($whereLineas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereLineas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereLineas . "     ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.fecha";
                        
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getGastosDpto($idcentros, $fechaini, $fechafin, $idclases, $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($iddptos != ""){
                    $inv_departamentos = explode(",", $iddptos);
                    
                    $whereDepartamentos .= "(";
                    for($i=0; $i<count($inv_departamentos); $i++){
                        $whereDepartamentos .= "invcatalog2.idcatalogo = " . $inv_departamentos[$i] . " OR ";
                    }
                    
                    $whereDepartamentos = substr($whereDepartamentos, 0, -4);
                    $whereDepartamentos .= ")";
                }
                
                if($idlineas != ""){
                    $inv_lineas = explode(",", $idlineas);
                    
                    $whereLineas .= "(";
                    for($i=0; $i<count($inv_lineas); $i++){
                        $whereLineas .= "invcatalog.idcatalogo = " . $inv_lineas[$i] . " OR ";
                    }
                    
                    $whereLineas = substr($whereLineas, 0, -4);
                    $whereLineas .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                            
                ##$SQLConsulta = "SELECT invsites.xpos AS centroxpos, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM((Round(tran_100k.preciotran, 6) * tran_100k.uniconv) * tran_100k.cantidad) AS valorTotal FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo  WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja, tran_100.fecha, SUM((Round(tran_100k.preciotran, 6) * tran_100k.uniconv) * tran_100k.cantidad) AS valorTotal, invproducts.idprovee, invproducts.xpos, tran_100k.notas AS descripcion FROM tran_100k INNER JOIN tran_100 ON tran_100k.trannum = tran_100.trannum INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi  AND ctauxi.nrc != '' INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo INNER JOIN invcatalog AS invcatalog2 ON invcatalog.idnivel1 = invcatalog2.idcatalogo  WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 AND tran_100.idcaja = 0 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereDepartamentos != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereDepartamentos . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereDepartamentos . "     ";
                    }
                }
                
                if($whereLineas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereLineas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereLineas . "     ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.fecha, tran_100k.idproducto";
                        
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getVentasCxc($idcentros, $idcajas, $fechaini, $fechafin, $idclases, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereCentros = ""; $whereCajas = "";
                $whereCajclase = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100.numy = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }

                if($idcajas != ""){
                    $id_cajas = explode(",", $idcajas);
                    
                    $whereCajas .= "(";
                    for($i=0; $i<count($id_cajas); $i++){
                        $whereCajas .= "tran_100.idcaja = ". $id_cajas[$i] . " OR ";
                    }
                    
                    $whereCajas = substr($whereCajas, 0, -4);
                    $whereCajas .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, ctcajas.descrip AS namecaja, tran_100.idcps AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND(tran_100.valventan, 4) + ROUND(tran_100.valtax1, 4)) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100 INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != "") {
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCajclase != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajclase . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }

                if($whereCajas != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajas . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajas . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.trannum";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        function getDetAbonosCxc($idcentros, $fechaini, $fechafin, $idclases, $cajclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereIdclase = ""; $whereDepartamentos = ""; $whereLineas = ""; $whereCentros = ""; $whereCajas = "";
                $whereCajclase = "";
                
                if($idclases != ""){
                    $id_clases = explode(",", $idclases);
                    
                    $whereIdclase .= "(";
                    for($i=0; $i<count($id_clases); $i++){
                        $whereIdclase .= "tran_100.idclase = " . $id_clases[$i] . " OR ";
                    }
                    
                    $whereIdclase = substr($whereIdclase, 0, -4);
                    $whereIdclase .= ")";
                }
                
                if($cajclases != ""){
                    $caj_clases = explode(",", $cajclases);
                    
                    $whereCajclase .= "(";
                    for($i=0; $i<count($caj_clases); $i++){
                        $whereCajclase .= "tran_100c.cajclase = ". $caj_clases[$i] . " OR ";
                    }
                    
                    $whereCajclase = substr($whereCajclase, 0, -4);
                    $whereCajclase .= ")";
                }
                
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT invsites.xpos AS centroxpos, ctcajas.xpos AS cajaxpos, ctcajas.descrip AS namecaja, tran_100.idcps AS clientexpos, inv_def.descrip AS namedocumento, tran_100.serie, tran_100.numero AS docnum, ctauxi.descrip AS namecliente, CONCAT(tran_100.serie, tran_100.numero) AS numero, tran_100.fecvence, tran_100c.fecha, tran_100.idcps, ctauxi.nrc, ctauxi.descrip, SUM(ROUND((tran_100c.valor * -1), 4)) AS valorTotal, invsites.descrip AS namecentro, tran_100.idcentro, tran_100.idcaja FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND inv_def.agrupa = 'VN' WHERE tran_100c.fecha BETWEEN CAST('$fechaini' AS DATE) AND CAST('$fechafin' AS DATE) AND tran_100.estatus = 1 ";
                
                $addWhere = 0;
                if($whereIdclase != ""){
                    $addWhere = 1;
                    $SQLConsulta .= "AND " . $whereIdclase . " AND ";
                }
                
                if($whereCajclase != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCajclase . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCajclase . " AND ";
                    }
                }
                
                if($whereCentros != ""){
                    if($addWhere == 1){
                        $SQLConsulta .= $whereCentros . " AND ";
                    }else{
                        $addWhere = 1;
                        $SQLConsulta .= "AND " . $whereCentros . " AND ";
                    }
                }
                
                $SQLConsulta = substr($SQLConsulta, 0, -4);
                $SQLConsulta .= "GROUP BY tran_100.idcentro, tran_100.idcaja, tran_100c.fecha";
                    
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function adicionarMovimientoContable($partipo, $posicion, $idcuenta, $idauxi, $descrip, $funcion, $tipo, $dh, $estado, $notas, $idcentros, $idcajas, $idclases, $cajclases, $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaingresa = date("Y-m-d H:i:s");

                $estadoMov = ($estado    == true) ?  1 : 0;
                $idcentros = ($idcentros == NULL) ? '' : $idcentros;
                $idcajas   = ($idcajas   == NULL) ? '' : $idcajas;
                $idclases  = ($idclases  == NULL) ? '' : $idclases;
                $cajclases = ($cajclases == NULL) ? '' : $cajclases;
                $iddptos   = ($iddptos   == NULL) ? '' : $iddptos;
                $idlineas  = ($idlineas  == NULL) ? '' : $idlineas;

                $this->db_b->set('idrec',     0);
                $this->db_b->set('partipo',   $partipo);
                $this->db_b->set('posicion',  $posicion);
                $this->db_b->set('idcuenta',  $idcuenta);
                $this->db_b->set('idauxi',    $idauxi);
                $this->db_b->set('descrip',   $descrip);
                $this->db_b->set('funcion',   $funcion);
                $this->db_b->set('tipo',      $tipo);
                $this->db_b->set('dh',        $dh);
                $this->db_b->set('estado',    $estadoMov);
                $this->db_b->set('notas',     $notas);
                $this->db_b->set('idcentros', $idcentros);
                $this->db_b->set('idcajas',   $idcajas);
                $this->db_b->set('idclases',  $idclases);
                $this->db_b->set('cajclases', $cajclases);
                $this->db_b->set('iddptos',   $iddptos);
                $this->db_b->set('idlineas',  $idlineas);
                $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                $this->db_b->set('ingresa',   $fechaingresa);
                $query = $this->db_b->insert('conta_genfunc');
                
                return $query;
            }
        }

        function modificarMovimientoContable($idrec, $partipo, $posicion, $idcuenta, $idauxi, $descrip, $funcion, $tipo, $dh, $estado, $notas, $idcentros, $idcajas, $idclases, $cajclases, $iddptos, $idlineas){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechamodifica = date("Y-m-d H:i:s");
                
                $estadoMov = ($estado    == true) ?  1 : 0;
                $idcentros = ($idcentros == NULL) ? '' : $idcentros;
                $idcajas   = ($idcajas   == NULL) ? '' : $idcajas;
                $idclases  = ($idclases  == NULL) ? '' : $idclases;
                $cajclases = ($cajclases == NULL) ? '' : $cajclases;
                $iddptos   = ($iddptos   == NULL) ? '' : $iddptos;
                $idlineas  = ($idlineas  == NULL) ? '' : $idlineas;

                $this->db_b->set('partipo',   $partipo);
                $this->db_b->set('posicion',  $posicion);
                $this->db_b->set('idcuenta',  $idcuenta);
                $this->db_b->set('idauxi',    $idauxi);
                $this->db_b->set('descrip',   $descrip);
                $this->db_b->set('funcion',   $funcion);
                $this->db_b->set('tipo',      $tipo);
                $this->db_b->set('dh',        $dh);
                $this->db_b->set('estado',    $estadoMov);
                $this->db_b->set('notas',     $notas);
                $this->db_b->set('idcentros', $idcentros);
                $this->db_b->set('idcajas',   $idcajas);
                $this->db_b->set('idclases',  $idclases);
                $this->db_b->set('cajclases', $cajclases);
                $this->db_b->set('iddptos',   $iddptos);
                $this->db_b->set('idlineas',  $idlineas);
                $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                $this->db_b->set('modifica',  $fechamodifica);
                $this->db_b->where('idrec',   $idrec);
                $query = $this->db_b->update('conta_genfunc');
                
                return $query;
            }
        }

        function eliminarGeneracionContable($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLEliminar = "DELETE FROM conta_genfunc WHERE idrec = $idrec";
                $Query = $this->db_b->query($SQLEliminar);
                
                return $Query;
            }
        }

        function limpiarGeneracionContable($partipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $SQLEliminar = "DELETE FROM conta_genfunc WHERE partipo = $partipo";
                $Query = $this->db_b->query($SQLEliminar);
                
                return $Query;
            }
        }

        function copiarRegistroMovimientosContables($idrec, $partipo, $cantidad) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $Query = $this->db_b->query("SELECT * FROM conta_genfunc WHERE idrec = $idrec");
                $informacion = $Query->result();
                
                $SQLPos  = $this->db_b->query("SELECT posicion FROM conta_genfunc WHERE partipo = $partipo ORDER BY posicion DESC LIMIT 1");
                $infoPos = $SQLPos->row_array();
                
                $i=0;
                do {
                    foreach ($informacion as $info) {
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('partipo', $partipo);
                        $this->db_b->set('posicion', ($infoPos['posicion'] + 1));
                        $this->db_b->set('idcuenta', $info->idcuenta);
                        $this->db_b->set('idauxi', $info->idauxi);
                        $this->db_b->set('descrip', $info->descrip);
                        $this->db_b->set('funcion', $info->funcion);
                        $this->db_b->set('tipo', $info->tipo);
                        $this->db_b->set('dh', $info->dh);
                        $this->db_b->set('estado', $info->estado);
                        $this->db_b->set('notas', $info->notas);
                        $this->db_b->set('idcentros', $info->idcentros);
                        $this->db_b->set('idcajas', $info->idcajas);
                        $this->db_b->set('idclases', $info->idclases);
                        $this->db_b->set('cajclases', $info->cajclases);
                        $this->db_b->set('iddptos', $info->iddptos);
                        $this->db_b->set('idlineas', $info->idlineas);
                        $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', date("Y-m-d H:i:s"));
                        $query = $this->db_b->insert('conta_genfunc');
                    }
                    $i++;
                } while($i < $cantidad);    

                return $query;
            }
        }
        
        function copiarMovimientosContables($partipo, $copiapartida, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fechaingresa = date("Y-m-d H:i:s");

                $consulta = "SELECT * FROM conta_genfunc WHERE partipo = $copiapartida";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                foreach ($resultado as $info){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('partipo', $partipo);
                    $this->db_b->set('posicion', $info->posicion);
                    $this->db_b->set('idcuenta', $info->idcuenta);
                    $this->db_b->set('idauxi', $info->idauxi);
                    $this->db_b->set('descrip', $info->descrip);
                    $this->db_b->set('funcion', $info->funcion);
                    $this->db_b->set('tipo', $info->tipo);
                    $this->db_b->set('dh', $info->dh);
                    $this->db_b->set('estado', $info->estado);
                    $this->db_b->set('notas', $info->notas);
                    $this->db_b->set('idcentros', $idcentro);
                    $this->db_b->set('idcajas', $idcaja);
                    $this->db_b->set('idclases', $info->idclases);
                    $this->db_b->set('cajclases', $info->cajclases);
                    $this->db_b->set('iddptos', $info->iddptos);
                    $this->db_b->set('idlineas', $info->idlineas);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fechaingresa);
                    $query = $this->db_b->insert('conta_genfunc');
                }

                return $query;
            }
        }
        
        function getDetalleCajasFiltradas($idcentros){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereCentros = "";
                if($idcentros != ""){
                    $id_centros = explode(",", $idcentros);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
                
                $SQLConsulta = "SELECT idcaja, descrip FROM ctcajas WHERE estatus = 1 ";
                if($whereCentros != ""){
                    $SQLConsulta .= "AND " . $whereCentros;
                }
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }
        
        function getDetalleLineasFiltradas($iddepartamentos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $whereDptos = "";
                if($iddepartamentos != ""){
                    $whereDptos = str_replace(',', ' OR a.idnivel1 = ', $iddepartamentos);
                }
                
                if ($whereDptos != "") {
                    $SQLConsulta = "SELECT a.idcatalogo, a.descrip, b.descripcion AS tipoProducto FROM invcatalog a INNER JOIN gvars b ON b.valor_num = a.tipo AND b.nombre = 'gv_protipo' WHERE a.nivel = 2 AND a.estado = 1 AND (a.idnivel1 = $whereDptos) ORDER BY b.valor_num, a.descrip";
                } else $SQLConsulta = "SELECT a.idcatalogo, a.descrip, b.descripcion AS tipoProducto FROM invcatalog a INNER JOIN gvars b ON b.valor_num = a.tipo AND b.nombre = 'gv_protipo' WHERE a.nivel = 2 AND a.estado = 1 ORDER BY b.valor_num, a.descrip";
                
                $query = $this->db_b->query($SQLConsulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                }else{
                    $resultado = false;
                }
                
                return $resultado;
            }
        }

        function sendMovimientosGoXpress($infoSource){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $ct_idtipo = ''; $ct_fecha = ''; $ct_idcaja = ''; $itemcount = 0;
                
                $fechas  = array_column($infoSource, 'fecha');
                $tipos   = array_column($infoSource, 'tipo');
                $cajas   = array_column($infoSource, 'idcaja');

                array_multisort($fechas, SORT_ASC, $tipos, SORT_ASC, $cajas, SORT_ASC, $infoSource);

                foreach($infoSource as $info => $value){
                    $val_idcaja = (trim($value['idcaja']) == "") ? 0 : trim($value['idcaja']);
                    
                    if($value['tipo'] != $ct_idtipo || $value['fecha'] != $ct_fecha || $ct_idcaja != $val_idcaja){

                        if($itemcount != 0){
                            $this->db_b->set('itemcount', $itemcount);
                            $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                            $this->db_b->set('modifica',  date("Y-m-d H:i:s"));
                            $this->db_b->where('pnumero', $pnumero);
                            $this->db_b->update('ct_100');
                        }

                        $SQLCT = "SELECT pnumero FROM ct_100 WHERE idptipo = ".$value['tipo']." AND idsite = ".$value['idcentro']." AND auxref = ".$val_idcaja." AND fecha = '".$value['fecha']."' AND origen = 'GOXPOS GENERADOR CONTABLE' AND estatus != 9";
                        $QueryHD = $this->db_b->query($SQLCT);
                        if($QueryHD->num_rows() > 0){
                            $infoHD    = $QueryHD->row_array();
                            $pnumero   = $infoHD['pnumero'];
                            $ct_idtipo = $value['tipo']; $ct_fecha = $value['fecha']; $ct_idcaja = $val_idcaja;
                            $itemcount = 0;
                            $insertDT  = 0;
                        }else{
                            $datefec = date_create($value['fecha']);
                            $idyear  = date_format($datefec,"Y");
                            
                            $this->db_b->set('pnumero',  0);
                            $this->db_b->set('idyear',   $idyear);
                            $this->db_b->set('idptipo',  $value['tipo']);
                            $this->db_b->set('idsite',   $value['idcentro']);
                            $this->db_b->set('auxref',   $val_idcaja);
                            $this->db_b->set('descrip',  $value['descripcion']);
                            $this->db_b->set('fecha',    $value['fecha']);
                            $this->db_b->set('origen',   'GOXPOS GENERADOR CONTABLE');
                            $this->db_b->set('estatus',  0);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa',  date("Y-m-d H:i:s"));
                            $this->db_b->insert('ct_100');
                            
                            $pnumero = $this->db_b->insert_id();
                            
                            $ct_idtipo = $value['tipo']; $ct_fecha = $value['fecha']; $ct_idcaja = $val_idcaja;
                            $itemcount = 0;
                            $insertDT  = 1;
                        }
                    }
                    
                    if($insertDT == 1){
                        $itemcount++; $idtabla = ''; $idauxi = '';

                        $SQLCT = "SELECT useauxi, askidcentro FROM ctcuenta WHERE idctcuenta = ".$value['idcuenta']."";
                        $Query = $this->db_b->query($SQLCT);
                        if($Query->num_rows() > 0){
                            $infoRe  = $Query->row_array();

                            if($infoRe['useauxi'] != ''){
                                $infoCT  = explode(",", $infoRe['useauxi']);
                                $idtabla = $infoCT[0];
                                $idauxi  = $value['idauxi'];
                            }
                        }

                        $this->db_b->set('pnumero',     $pnumero);
                        $this->db_b->set('itemline',    $itemcount);
                        $this->db_b->set('fecha',       $value['fecha']);
                        $this->db_b->set('idctcuenta',  $value['idcuenta']);
                        $this->db_b->set('idtabla',     $idtabla);
                        $this->db_b->set('idauxi',      $idauxi);
                        $this->db_b->set('idcentro',    ($infoRe['askidcentro'] != '') ? $value['idcentro'] : 0);
                        $this->db_b->set('descrip',     $value['descrip']);
                        $this->db_b->set('doc_type',    $value['namedocumento']);
                        $this->db_b->set('doc_serie',   $value['serie']);
                        $this->db_b->set('doc_numero',  $value['numero']);
                        $this->db_b->set('doc_emision', $value['docfecha']);
                        $this->db_b->set('doc_vence',   $value['docvence']);
                        $this->db_b->set('debe',        $value['debe']);
                        $this->db_b->set('haber',       $value['haber']);
                        $this->db_b->set('estatus',     0);
                        $this->db_b->set('whodidit',    $this->session->userdata('iduser'));
                        $this->db_b->set('ingresa',     date("Y-m-d H:i:s"));
                        $this->db_b->insert('ct_100d');
                    }
                }
                
                if($insertDT == 1){
                    $this->db_b->set('itemcount', $itemcount);
                    $this->db_b->set('whodidit',  $this->session->userdata('iduser'));
                    $this->db_b->set('modifica',  date("Y-m-d H:i:s"));
                    $this->db_b->where('pnumero', $pnumero);
                    $result = $this->db_b->update('ct_100');
                }else{
                    $result = true;
                }
                
                return $result;
            }
        }

        function getctsaldos($fecha_ini, $fecha_fin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
               /* 
               // $consulta = "SELECT ct_100d.pnumero,ct_100.fecha,ct_100d.idctcuenta,ct_100d.idauxi,ct_100d.idcentro,ct_100d.descrip,ct_100d.doc_type,ct_100d.doc_serie,ct_100d.doc_numero,ct_100d.debe,ct_100d.haber FROM ct_100d
               // INNER JOIN ct_100 ON ct_100d.pnumero=ct_100.pnumero WHERE ct_100.estatus=1 and ct_100.fecha BETWEEN ".$fecha_ini." AND ".$fecha_fin." ";
                */
                
        		$consulta = "SELECT DATE_FORMAT(ct_100.fecha, '%Y/%m') AS fechaG,ct_100d.idctcuenta as id_cuenta,ct_100d.idauxi as id_auxi,ct_100d.idcentro as id_centro,ctcuenta.descrip as titulocuenta,invsites.descrip As nombrecc,ctauxi.descrip AS auxiname,sum(ct_100d.debe) as totdebe,sum(ct_100d.haber) as tothaber,ctcuenta.catgrupo,ctcuenta.ctmayoriza FROM ct_100d
	        	INNER JOIN ct_100 ON ct_100d.pnumero=ct_100.pnumero
	        	INNER JOIN ctcuenta ON ct_100d.idctcuenta=ctcuenta.idctcuenta
	        	LEFT JOIN invsites ON ct_100d.idcentro=invsites.idcentro
                LEFT JOIN ctauxi ON ct_100d.idauxi=ctauxi.idauxi
	        	WHERE ct_100.estatus=1 and ct_100.fecha BETWEEN '2000-01-01' AND '".$fecha_fin. "'
	        	GROUP BY fechaG,ct_100d.idctcuenta,ct_100d.idauxi,ct_100d.idcentro";

                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getCxCndata($fecha_fin, $idctcuenta, $cancelado = 0){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
        		$consulta = "SELECT ct_100d.idctcuenta AS id_cuenta,ctcuenta.descrip As titulocuenta,ctcuenta.catgrupo, ct_100d.idauxi as codigo,ctauxi.descrip AS nombre, ct_100d.doc_type AS doc_tipo, ct_100d.doc_serie,ct_100d.doc_numero,ct_100d.doc_emision,ct_100d.doc_vence,IF(ctcuenta.catgrupo=1,sum(ct_100d.debe)-sum(ct_100d.haber),sum(ct_100d.haber)-sum(ct_100d.debe)) AS saldo FROM ct_100d 
                INNER JOIN ctauxi on ct_100d.idauxi=ctauxi.idauxi
                INNER JOIN ctcuenta ON ct_100d.idctcuenta=ctcuenta.idctcuenta
                WHERE ct_100d.estatus=1 AND ctcuenta.idctcuenta = '$idctcuenta'
                AND ct_100d.fecha <= '$fecha_fin'
                GROUP BY id_cuenta,codigo,doc_tipo,doc_serie,doc_numero " . (($cancelado == 0 ) ? "HAVING Saldo !=0" : "" ) . " ORDER BY id_cuenta, nombre ASC ";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }  

        function getMovimientosCliente($idctcuenta, $idauxi, $doc_type, $doc_serie, $doc_numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
        		$consulta = "SELECT a.descrip, a.fecha, a.pnumero, b.descrip AS ingresado, a.debe, a.haber FROM ct_100d a
                INNER JOIN gusers b ON a.whodidit = b.iduser
                WHERE a.idctcuenta = '$idctcuenta' AND a.idauxi = '$idauxi' AND a.doc_type = '$doc_type' AND a.doc_serie = '$doc_serie' AND a.doc_numero = '$doc_numero'
                ORDER BY a.fecha";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
        function getTodasLasCuentasHastaFecha() {
            $consulta = "SELECT idctcuenta, descrip FROM ctcuenta WHERE ctcontrol = 2 AND estatus = 1";
        
            $query = $this->db_b->query($consulta);
        
            $cuentasUnicas = [];
        
            foreach ($query->result() as $fila) {
                $cuentasUnicas[] = [
                    "ID" => $fila->idctcuenta,
                    "Name" => $fila->descrip
                ];
            }
        
            return $cuentasUnicas;
        }

    }
?>