<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
class Consigna_model extends CI_Model{
    #private $db_b;
         
    public function __construct(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }
        
        $CI =& get_instance();
        $this->db_b = $CI->load->database('user_db', TRUE);

        $this->load->dbutil($this->db_b);
        if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
            echo 'Incorrect database information provided';
        }
    }
    
    function getClientesTipo($tipo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT ctauxi.*, (SELECT IF(EXISTS( SELECT tran_100.trannum FROM tran_100 WHERE tran_100.idcps = ctauxi.idauxi), 1, 0)) AS existe FROM ctauxi WHERE idauxidef = $tipo ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }  
    
    function getSucCliente($idauxi){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT ctauximulti.idrec, ctauximulti.idauxi, ctauximulti.descrip, ctauxi.descrip as nameCliente  FROM ctauximulti INNER JOIN ctauxi ON ctauxi.idauxi = ctauximulti.idauxi WHERE ctauximulti.idauxi = $idauxi AND ctauximulti.idgvar = 2 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                return $query->result();
            }else{
                return false;
            }
        }
    }   
    
    function getUbicacionesCliente($idauxi){
        if($this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT ctauximulti.idrec, ctauximulti.idauxi, ctauximulti.descrip, ctauxi.descrip as nameCliente  FROM ctauximulti INNER JOIN ctauxi ON ctauxi.idauxi = ctauximulti.idauxi WHERE ctauximulti.idauxi = $idauxi AND ctauximulti.idgvar = 2 AND ctauximulti.estatus=1 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                return $query->result();
            }else{
                return false;
            }
        }
    }   
    
    function insertCliente($idauxi, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nrc, $nit, $actividad, $contribuyente, $vendedor, $limite, $dias, $img, $estado, $notas, $xpos, $whodidit){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s"); 
            $this->db_b->set('idauxi', 0);
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('idauxidef', $idauxi);
            $this->db_b->set('telefono', $telefono);
            $this->db_b->set('correo', $correo);
            $this->db_b->set('direccion', $direccion);
            $this->db_b->set('idzip', $departamento);
            $this->db_b->set('fechain', $ingreso);
            $this->db_b->set('nrc', $nrc);
            $this->db_b->set('nit', $nit);
            $this->db_b->set('giro', $actividad);
            $this->db_b->set('idtipo', $contribuyente);
            $this->db_b->set('idcps', $vendedor);
            $this->db_b->set('grupo', $grupo);
            $this->db_b->set('limite', $limite);
            $this->db_b->set('dias', $dias);
            $this->db_b->set('xpos', $xpos);
            $this->db_b->set('estado', $estado);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('whodidit', $whodidit);
            $this->db_b->set('ingresa', $fecha_actual);
            $query = $this->db_b->insert('ctauxi');
            $idcliente = $this->db_b->insert_id();

            if($img == "" || $img == null){
                 return 0;
            }else{
                $imgSplit = explode(".", $img);
                $nameImg = "imgCliente_".$idcliente.".".$imgSplit[1];
                $this->db_b->set('imagen', $nameImg);
                $this->db_b->where('idauxi', $idcliente);
                $this->db_b->update('ctauxi');
                return $idcliente;
            }
        }
    }
    
    function updateCliente($idcliente, $idauxidef, $descrip, $grupo, $telefono, $correo, $direccion, $departamento, $ingreso, $nrc, $nit, $actividad, $contribuyente, $vendedor, $limite, $dias, $img, $estado, $notas, $xpos, $whodidit){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s"); 

            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('idauxidef', $idauxidef);
            $this->db_b->set('telefono', $telefono);
            $this->db_b->set('correo', $correo);
            $this->db_b->set('direccion', $direccion);
            $this->db_b->set('idzip', $departamento);
            $this->db_b->set('fechain', $ingreso);
            $this->db_b->set('nrc', $nrc);
            $this->db_b->set('nit', $nit);
            $this->db_b->set('giro', $actividad);
            $this->db_b->set('idtipo', $contribuyente);
            $this->db_b->set('idcps', $vendedor);
            $this->db_b->set('grupo', $grupo);
            $this->db_b->set('limite', $limite);
            $this->db_b->set('dias', $dias);
            $this->db_b->set('xpos', $xpos);
            $this->db_b->set('estado', $estado);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('whodidit', $whodidit);
            $this->db_b->set('modifica', $fecha_actual);
            $this->db_b->where('idauxi', $idcliente);
            $this->db_b->update('ctauxi');

            if($img == "" || $img == null){
                 return 0;
            }else{
                $imgSplit = explode(".", $img);
                $nameImg = "imgCliente_".$idcliente.".".$imgSplit[1];
                $this->db_b->set('imagen', $nameImg);
                $this->db_b->where('idauxi', $idcliente);
                $this->db_b->update('ctauxi');
                return $idcliente;
            }
        }
    }
    
    function getConsignacionesCliente($idcentro, $idcps, $idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('global_model');
            $con_denvios = $this->global_model->getValorNumVariable('con_denvios');
            $con_renvios = $this->global_model->getValorNumVariable('con_renvios');
            $consulta = "SELECT tran_100.trannum, tran_100.idclase, tran_100.tranref,invsites.descrip as origen, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha1, tran_100.estatus, tran_100.lines100k, (SELECT SUM(tran_100k.cantidad) FROM tran_100k WHERE tran_100k.trannum = tran_100.trannum) AS cantidad FROM tran_100  INNER JOIN invsites ON invsites.idcentro = tran_100.idcentro WHERE tran_100.idcentrod = $idcentro AND tran_100.idcps=$idcps AND tran_100.idcps_branch = $idcps_branch AND tran_100.estatus = 1 AND (tran_100.idclase = $con_denvios OR tran_100.idclase=$con_renvios) ORDER BY tran_100.fecha DESC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function getConsignacionesRecibidas($idcentro, $idcps, $idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT IF(SUM(tran_100.valventan + tran_100.valtax1) > 0, SUM(tran_100.valventan + tran_100.valtax1), tran_100.valcosto) AS valor, IF(tran_100.referencia = '', CONCAT(tran_100.serie, tran_100.numero), tran_100.tranref) AS referencia, tran_100.tranref, tran_100.trannum, tran_100.idclase, inv_def.descrip AS tipoMov, tran_100.tranref, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha1, tran_100.estatus, tran_100.lines100k, (SELECT SUM(tran_100k.cantidad * tran_100k.uniconv) FROM tran_100k WHERE tran_100k.trannum = tran_100.trannum) AS cantidad FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE tran_100.idcentro = $idcentro AND tran_100.idcps = $idcps AND tran_100.idcps_branch = $idcps_branch GROUP BY tran_100.trannum ORDER BY tran_100.trannum DESC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function getInventarioCliente($idcentro, $idcps,$idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT invproducts.tipo, tran_100k.idrec, IFNULL(tran_100k.barcode, 0) AS barcode, tran_100k.itemline, invproducts.descrip, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.notas, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum=tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto WHERE tran_100.idcentro = $idcentro AND tran_100.idcps = $idcps AND tran_100.idcps_branch = $idcps_branch GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function getCantInv($idcentro, $idcps, $idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT IFNULL(SUM(tran_100k.cantidad * tran_100k.uniconv),0) AS cantidad FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum WHERE tran_100.idcentro = $idcentro AND tran_100.idcps = $idcps AND tran_100.idcps_branch = $idcps_branch";
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            return $resultado['cantidad'];
        }
    }
    
    function getCantPendCliente($idcentro, $idcps, $idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->load->model('global_model');
            $con_denvios = $this->global_model->getValorNumVariable('con_denvios');
            $consulta = "SELECT tran_100.trannum FROM tran_100 WHERE tran_100.idcentrod = $idcentro AND tran_100.idcps=$idcps AND tran_100.idclase= $con_denvios AND tran_100.idcps_branch = $idcps_branch AND tran_100.estatus = 1";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                return $query->num_rows();
            }else{
                return 0;
            }
        }
    } 
    
    function getDatosConsignacion($idcentro, $idcps, $trannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT * FROM tran_100 WHERE tran_100.idcentrod = $idcentro AND tran_100.idcps=$idcps AND tran_100.trannum=$trannum";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                return $query->result();
            }else{
                return false;
            }
        }
    }
    
    function setRecepcionHD($idtrannum, $idclase, $idcliente){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $consulta = "SELECT trannum, idcentro, fecha, fecact, idcps, idcentrod, lines100k, notas,idcps_branch FROM tran_100 WHERE trannum = $idtrannum";
            $query = $this->db_b->query($consulta);
            $datos = $query->row_array();

            $this->db_b->set('estatus', 2);
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('trannum', $idtrannum);
            $query = $this->db_b->update('tran_100');

            $consulta = "SELECT idcps FROM invsites WHERE idcentro = ".$datos['idcentro'];
            $query = $this->db_b->query($consulta);
            $encargado = $query->row_array();

            $this->db_b->set('trannum', 0);
            $this->db_b->set('idcentro', $datos['idcentrod']);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('fecha', $datos['fecact']);
            $this->db_b->set('fecact', $date->format('Y-m-d H:i:s'));
            $this->db_b->set('idcps', $idcliente);
            $this->db_b->set('idcps_branch', $datos['idcps_branch']);
            $this->db_b->set('referencia', $idtrannum);
            $this->db_b->set('idworker', $encargado['idcps']);
            $this->db_b->set('idcentrod', $datos['idcentro']);
            $this->db_b->set('tranref', $datos['trannum']);
            $this->db_b->set('lines100k', $datos['lines100k']);
            $this->db_b->set('estatus', 2);
            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('tran_100');

            $idcode = $this->db_b->insert_id();

            $this->db_b->set('tranref', $idcode);
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('trannum', $idtrannum);
            $query = $this->db_b->update('tran_100');

            return $idcode;
        }
    }
    
    function setRecepcionDT($idtrannum, $idcode, $inopera, $idclase, $idbin){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $consulta = "SELECT idcentro FROM tran_100 WHERE trannum = $idcode";
            $query = $this->db_b->query($consulta);
            $info = $query->row_array();

            $this->load->model('global_model');
            $invcontrol = $this->global_model->getInvControlSite($info['idcentro']);

            $consulta = "SELECT * FROM tran_100k WHERE trannum = $idtrannum ORDER BY itemline ASC";
            $query = $this->db_b->query($consulta);
            $datos = $query->result();

            foreach($datos as $key){
                $cant_inopera = abs($key->cantidad) * $inopera;

                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $idcode);
                $this->db_b->set('itemline', $key->itemline);
                $this->db_b->set('idcentro', $info['idcentro']);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('invcontrol', $invcontrol);
                $this->db_b->set('idproducto', $key->idproducto);
                $this->db_b->set('idbatch', $key->idbatch);
                $this->db_b->set('idbin', $idbin);
                $this->db_b->set('cantidad', $cant_inopera);
                $this->db_b->set('costounitario', $key->costounitario);
                $this->db_b->set('uniconv', 1);
                $this->db_b->set('um', $key->um);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100k');    
            }        

            return $query;
        }
    }
    
    function getDevCliente($idcentro, $idcps,$idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT  invproducts.tipo, invproducts.precioventa, invproducts.tipotax, tran_100k.idrec, tran_100k.idbatch,tran_100k.idbin, IFNULL(tran_100k.barcode, 0) AS barcode, tran_100k.itemline, invproducts.descrip, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto, invproducts.notas, SUM(tran_100k.cantidad*tran_100k.uniconv) AS cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum=tran_100k.trannum INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto WHERE tran_100.idcentro = $idcentro AND tran_100.idcps = $idcps AND tran_100.idcps_branch = $idcps_branch GROUP BY invproducts.idproducto ORDER BY invproducts.descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function insertEnvio($idcentro, $idclase, $idcps, $idcentrod,$idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
                    
            $this->db_b->set('trannum', 0);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('fecha', $date->format('Y-m-d'));
            $this->db_b->set('fecact', $date->format('Y-m-d'));
            $this->db_b->set('idcps', $idcps);
            $this->db_b->set('idcps_branch', $idcps_branch);
            $this->db_b->set('idcentrod', $idcentrod);
            $this->db_b->set('estatus', 1);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('tran_100');
            $id = $this->db_b->insert_id();
            return $id;
        }  
    }
    
    function insertProducts($trannum, $idcentro, $idclase, $inopera, $idbin, $idcliente, $idcentrod, $dataProductos){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $invcontrol = $this->global_model->getInvControlSite($idcentro); 
            $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
            $query = $this->db_b->query($consulta);
                    
            if($query->num_rows() > 0){
                $resultado = $query->row_array();
                $itemLine = $resultado['itemline'] + 1;
            }else{
                $itemLine = 1;
            }
            $cant_ing = 0;
            $cont = count($dataProductos);
            for($i=0; $i<$cont; $i++){
                if($dataProductos[$i]['dev']>0){
                    $idproducto = round($dataProductos[$i]['idproducto']);
                    $cantidad = round($dataProductos[$i]['dev']);
                    $um = $dataProductos[$i]['um'];
				    		
                    $SQLProducto = "SELECT idbatch,costounitario FROM inv_batch WHERE idproducto = $idproducto AND estado=1";
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $ResultProducto = $QueryProducto->row_array();
				    		
                    $precio = $ResultProducto['costounitario'];
                    $idbatch = $ResultProducto['idbatch'];
				    		
                    $cant_inopera = $cantidad * $inopera;
				    		
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('invcontrol', $invcontrol);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('cantidad', $cant_inopera);
                    $this->db_b->set('costounitario', $precio);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
					   	
                    $query = $this->db_b->insert('tran_100k');
                    $cant_ing++;$itemLine++;
                }
            }
            return $cant_ing; 
        }
    }
    
    function getProducts($idtrannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT invproducts.tipo, tran_100k.idrec, IFNULL(tran_100k.barcode,0) AS barcode, tran_100k.itemline, invproducts.descrip, invproducts.modelo, invproducts.um, invproducts.marca, invproducts.idproducto,invproducts.notas, invlocations.descrip AS ubicacion, inv_batch.descrip AS lote, ABS(tran_100k.cantidad) as cantidad, tran_100k.precioneto, tran_100k.preciotran, tran_100k.costounitario, tran_100k.descuento, tran_100k.notas, tran_100k.notas AS modNotas FROM tran_100k INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto LEFT JOIN invlocations ON invlocations.idbin = tran_100k.idbin LEFT JOIN inv_batch ON inv_batch.idbatch = tran_100k.idbatch LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100k.idworker WHERE tran_100k.trannum = $idtrannum ORDER BY tran_100k.itemline ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function insertFactura($fecha, $idcentro, $idcajaserie, $idworker, $idclase, $cajclase, $idcliente, $idcps_branch, $notas){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
              
            $sqlcon = "SELECT numgrupo, numtipo FROM inv_def WHERE invclase = $idclase";
            $sqlqu = $this->db_b->query($sqlcon);
            $res = $sqlqu->row_array();
            $numgrupo = $res['numgrupo'];
            $numTipo = $res['numtipo'];
                     
            $sqlcon = "SELECT idcaja, numx, numz FROM ctcajas WHERE idcentro = $idcentro";
            $sqlqu = $this->db_b->query($sqlcon);
            $res = $sqlqu->row_array();
            $idcaja = $res['idcaja'];
            $numx = $res['numx'];            
            $numz = $res['numz'];  
            $numy = 0;
                      
            $sqlcon = "SELECT creditchk FROM caj_def WHERE cajclase = $cajclase";
            $sqlqu = $this->db_b->query($sqlcon);
            $res = $sqlqu->row_array();
            $creditchk = $res['creditchk'];
            
            if($creditchk == 1){
                $numy = $cajclase;
            }
            
            if ($idcajaserie == 0) {
                $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND idcaja = $idcaja AND estatus = 1";
            } else {
                $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND idcaja = $idcajaserie AND estatus = 1";
            }
            
            $sqlQuery = $this->db_b->query($consulta);
            if($sqlQuery->num_rows()> 0){
                $resSQl = $sqlQuery->row_array();
                $serie = $resSQl['serie'];
            }else{
                $serie = "";    
            }
            
            if ($idcajaserie == 0) {
                if($numTipo == 1){
                    $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND estatus = 1";
                }else if($numTipo == 2){
                    $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND estatus = 1";
                }else if($numTipo == 3){
                    $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcentro = $idcentro AND idcaja = $idcaja AND estatus = 1";
                }
            } else {
                $consulta = "SELECT idrnum, actual, hasta FROM gnums WHERE numgrupo = $numgrupo AND idcaja = $idcajaserie AND estatus = 1";
            }
            
            $sqlQuery = $this->db_b->query($consulta);
            $resSQl = $sqlQuery->row_array();
            $actual = $resSQl['actual'];
            $idrnum = $resSQl['idrnum'];
            $actual = $actual + 1;        
            
            $this->db_b->set('trannum', 0);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idcaja', $idcaja);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('serie', $serie);
            $this->db_b->set('numero', $actual);
            $this->db_b->set('numx', $numx);
            $this->db_b->set('numz', $numz);
            $this->db_b->set('numy', $numy);
            $this->db_b->set('idcentrod', 0);
            $this->db_b->set('fecha', $fecha);
            $this->db_b->set('fecact', $date->format('Y-m-d'));
            $this->db_b->set('idcps', $idcliente);
            $this->db_b->set('idcps_branch', $idcps_branch);
            $this->db_b->set('idworker', $idworker);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('estatus', 1);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('tran_100');
            $trannum = $this->db_b->insert_id();
            
            $this->db_b->set('actual', $actual);
            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('idrnum', $idrnum);
            $QueryUpdate = $this->db_b->update('gnums');
            
            return $trannum;
        }  
    }

    function getSerieDocumentoConsigna($idclase, $idcaja){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }else{
            $sqlcon = "SELECT numgrupo FROM inv_def WHERE invclase = $idclase";
            $sqlqu = $this->db_b->query($sqlcon);
            $res = $sqlqu->row_array();
            
            $numgrupo = $res['numgrupo'];
            
            $consulta = "SELECT serie FROM gnums WHERE numgrupo = $numgrupo AND idcaja = $idcaja AND estatus = 1 LIMIT 1";
            $sqlQuery = $this->db_b->query($consulta);
            if($sqlQuery->num_rows()> 0){
                $resSQl = $sqlQuery->row_array();
                $serie = $resSQl['serie'];
                return $serie;
            }else{
                return "";    
            }
        }
    }
    
    function insertProductsFact($trannum, $fecha, $idcentro, $idclase, $cajclase, $inopera, $idbin, $idcliente, $idworker, $dataProductos, $descuento){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $consulta = "SELECT invcontrol FROM invsites WHERE idcentro = $idcentro";               
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            $invcontrol = $resultado['invcontrol'];
            
            $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
            $query = $this->db_b->query($consulta);
            if($query->num_rows() > 0){
                $resultado = $query->row_array();
                $itemLine = $resultado['itemline'] + 1;
            }else{
                $itemLine = 1;
            }
            $cant_ing = 0;
            $cont = count($dataProductos);
            $totalPago = 0;
            for($i=0; $i<$cont; $i++){
                if($dataProductos[$i]['dev']>0){
                    $idproducto = round($dataProductos[$i]['idproducto']);
                    $cantidad = round($dataProductos[$i]['dev']);
                    $um = $dataProductos[$i]['um'];
                    $precioventa = $dataProductos[$i]['precioventa'];
                    $tipotax = $dataProductos[$i]['tipotax'];
                    
                    $precioneto = $precioventa;
                    $precioneto = (1 - ($descuento / 100)) * $precioventa;
                    
                    if($tipotax!=0){
                        $taxdes = ($tipotax / 100) + 1;
                        $precioneto = $precioneto / $taxdes;
                    }
                                        
                    $SQLProducto = "SELECT idbatch,costounitario FROM inv_batch WHERE idproducto = $idproducto AND estado=1";
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $ResultProducto = $QueryProducto->row_array();
				    $costounitario = $ResultProducto['costounitario'];
                    $idbatch = $ResultProducto['idbatch'];
                                        
				    $cant_inopera = $cantidad * $inopera;
                    if($descuento == 0){
                        $totalPago = $totalPago + ($cant_inopera * $precioventa);
                    }else{
                        $totalDescuento = $precioventa * ($descuento / 100);
                        $precioventa = $precioventa - $totalDescuento;
                        
                        $totalPago = $totalPago + ($cant_inopera * $precioventa);
                    }
                    
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('invcontrol', $invcontrol);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('cantidad', $cant_inopera);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('idworker', $idworker);
                    $this->db_b->set('costounitario', $costounitario);
                    $this->db_b->set('preciotran', $precioventa);
                    $this->db_b->set('descuento', $descuento);
                    $this->db_b->set('precioneto', $precioneto);
                    $this->db_b->set('tax1', $tipotax);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('tran_100k');
                    $cant_ing++;$itemLine++;
                }
            }
            
            $sqlcon = "SELECT creditchk FROM caj_def WHERE cajclase =$cajclase";
            $sqlqu = $this->db_b->query($sqlcon);
            $res = $sqlqu->row_array();
            $creditchk = $res['creditchk'];
            
            if($creditchk!=1){  
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('itemline', 1);
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('valor', $totalPago);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100c');
            }
            return $cant_ing; 
        }
    }
    
    function viewGrupo($tipo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'auxi_def' AND valor_num =$tipo";
            $query = $this->db_b->query($consulta);
            $resultado = $query->row_array();
            return $resultado['valor_memo'];
        }
    }
    
    function updateGrupos($resultado, $tipo){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $this->db_b->set('valor_memo', $resultado);
            $this->db_b->where('nombre', 'auxi_def');
            $this->db_b->where('valor_num', $tipo);
            $query = $this->db_b->update('gvars');
        }
    }
        
    function insertAjusteFavorContra($idcentro,$idcliente,$idworker,$idclase,$idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $this->db_b->set('trannum', 0);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idcps', $idcliente);
            $this->db_b->set('idcps_branch', $idcps_branch);
            $this->db_b->set('idworker', $idworker);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('fecha', $date->format('Y-m-d'));
            $this->db_b->set('fecact', $date->format('Y-m-d'));
            $this->db_b->set('estatus', 1);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('tran_100');
            $idtrannum = $this->db_b->insert_id();
            return $idtrannum;
        }
    }
    
    function insertDetalleAjusteFavor($trannum, $datos, $idcentro, $idclase){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
            $query = $this->db_b->query($consulta);
            $res = $query->row_array();
            $agrupa = $res['agrupa'];
            $inopera = $res['inopera'];
            $cont = count($datos);
            
            
            $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
            $query = $this->db_b->query($consulta);
                    
            if($query->num_rows() > 0){
                $resultado = $query->row_array();
                $itemLine = $resultado['itemline'] + 1;
            }else{
                $itemLine = 1;
            }
            
            for($i=0; $i<$cont; $i++){
                $idproducto = round($datos[$i]['idproducto']);
                $idbin = round($datos[$i]['idbin']);
                $idbatch = round($datos[$i]['idbatch']);
                $um = round($datos[$i]['um']);
                $cantAjuste = $datos[$i]['dev'] - $datos[$i]['cantidad'];
                if($cantAjuste > 0){
                    $nuevacantidad = $inopera * abs($cantAjuste);
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('cantidad', $nuevacantidad);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('costounitario', $datos[$i]['costounitario']);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('tran_100k');
                    $itemLine++;
                }
                
                
            }
            return $query;
        }
    }

    function insertDetalleAjusteContra($trannum, $datos, $idcentro, $idclase){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $consulta = "SELECT agrupa, inopera FROM inv_def WHERE invclase = $idclase";
            $query = $this->db_b->query($consulta);
            $res = $query->row_array();
            $agrupa = $res['agrupa'];
            $inopera = $res['inopera'];

            
            $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
            $query = $this->db_b->query($consulta);
                    
            if($query->num_rows() > 0){
                $resultado = $query->row_array();
                $itemLine = $resultado['itemline'] + 1;
            }else{
                $itemLine = 1;
            }
            
            $cont = count($datos);
            for($i=0; $i<$cont; $i++){
                $idproducto = round($datos[$i]['idproducto']);
                $idbin = round($datos[$i]['idbin']);
                $idbatch = round($datos[$i]['idbatch']);
                $um = round($datos[$i]['um']);
                $cantAjuste = $datos[$i]['dev'] - $datos[$i]['cantidad'];
                if($cantAjuste < 0){
                    $nuevacantidad = $inopera * abs($cantAjuste);
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idclase', $idclase);
                    $this->db_b->set('itemline', $itemLine);
                    $this->db_b->set('idcentro', $idcentro);
                    $this->db_b->set('idproducto', $idproducto);
                    $this->db_b->set('idbatch', $idbatch);
                    $this->db_b->set('idbin', $idbin);
                    $this->db_b->set('cantidad', $nuevacantidad);
                    $this->db_b->set('um', $um);
                    $this->db_b->set('uniconv', 1);
                    $this->db_b->set('costounitario', $datos[$i]['costounitario']);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('tran_100k');
                    $itemLine++;
                }
            }
            return $query;
        }
    }
    
    function getInformacionTraslados($idcentro, $con_idcentro, $idclase){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT tran_100.trannum,tran_100.tranref, tran_100.idcentro, ctauxi.descrip AS nameCliente,ctauximulti.descrip as lugar_entrega, tran_100.fecha,  DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha1, DATE_FORMAT(tran_100.fecact, '%Y/%m/%d') AS fecha2, tran_100.fecact, tran_100.estatus, invsites.descrip AS idcentrod, tran_100.referencia, tran_100.lines100k FROM tran_100 INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN ctauximulti ON tran_100.idcps_branch = ctauximulti.idrec INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod WHERE tran_100.idclase = $idclase AND tran_100.idcentro = $idcentro AND tran_100.idcentrod = $con_idcentro ORDER BY tran_100.trannum DESC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function getListadoConsignacionesClientes($idauxidef){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT idauxi, descrip, (SELECT COUNT(idrec) FROM ctauximulti WHERE ctauximulti.idauxi=ctauxi.idauxi AND ctauximulti.idgvar=2) as cant FROM ctauxi WHERE idauxidef = $idauxidef AND estado = 1 ORDER BY descrip";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function insertNuevoTraslado($idcentro, $fecha, $idclase, $descuento, $notas, $idcentrod, $referencia, $idcps, $idcps_branch){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            $this->db_b->set('trannum', 0);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('fecha', $fecha);
            $this->db_b->set('idcps', $idcps);
            $this->db_b->set('idcps_branch', $idcps_branch);
            $this->db_b->set('idcentrod', $idcentrod);
            $this->db_b->set('estatus', 0);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('ovnumero', $descuento);
            $this->db_b->set('referencia', $referencia);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $this->db_b->insert('tran_100');

            $query = $this->db_b->insert_id();

            return $query;
        }  
    }

    function cerrarConsignacion($trannum, $notas){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $this->db_b->set('notas', $notas);
            $this->db_b->set('fecact', $date->format('Y-m-d'));
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('trannum', $trannum);
            $query = $this->db_b->update('tran_100');
            return $query;
        }
    }
    
    function getDetallePedido($idtrannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT tran_100.trannum, tran_100.tranref, tran_100.idcentro, tran_100.notas, tran_100.referencia, invsites2.descrip AS centrocd, tran_100.fecha, tran_100.fecact, DATE_FORMAT(tran_100.fecact, '%d/%m/%Y') AS fecha2, tran_100.estatus, invsites.descrip AS idcentrod, tran_100.lines100k, (SELECT SUM(ABS(cantidad)) FROM tran_100k where trannum= tran_100.trannum) as cantidad, ctauxi.descrip AS encargadod, gusers.descrip AS encargadoinv,  inv_def.descrip as tipoTran,ctauximulti.descrip AS lugar_entregaCliente FROM tran_100 INNER JOIN invsites ON invsites.idcentro = tran_100.idcentrod INNER JOIN invsites AS invsites2 ON invsites2.idcentro = tran_100.idcentro LEFT JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps INNER JOIN gusers ON gusers.iduser = tran_100.whodidit INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase LEFT JOIN ctauximulti ON ctauximulti.idrec = tran_100.idcps_branch WHERE tran_100.trannum = $idtrannum";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
    
    function getInventarioClientes($idcentro){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.modelo, invproducts.um,
                invproducts.marca, tran_100k.costounitario, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
                ctauxi.descrip AS cliente, ctauxi2.descrip AS vendedor, ctauximulti.descrip AS lugar_entrega
            FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
            INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
            INNER JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps
            LEFT JOIN ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi 
            INNER JOIN ctauximulti ON tran_100.idcps_branch = ctauximulti.idrec
            WHERE tran_100.idcentro = $idcentro
            GROUP BY invproducts.idproducto, tran_100.idcps, tran_100.idcps_branch
            HAVING cantidad > 0
            ORDER BY invproducts.descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();

            return $resultado;
        }
    }
    
    function getDetalleByEstatusCompraLocal($idtrannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $SQLDatos = "SELECT  tran_100k.idproducto, invproducts.precioventa, (SELECT idcps FROM tran_100 WHERE tran_100.trannum=tran_100k.trannum) as idcps, (SELECT COUNT(idrec) FROM invpromulti WHERE invpromulti.idproducto=tran_100k.idproducto AND invpromulti.idgvar=77 AND invpromulti.lowrange = $idtrannum)  AS existe FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE  tran_100k.trannum = $idtrannum";
            $SQLDQuery = $this->db_b->query($SQLDatos);
            $SQLResult = $SQLDQuery->result();
            
            if($SQLResult!=false){
                foreach($SQLResult as $item){
                    if($item->existe == 0){
                        date_default_timezone_set('America/El_Salvador');
                        $date = new DateTime();
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('idproducto', $item->idproducto);
                        $this->db_b->set('estatus', 1);
                        $this->db_b->set('idgvar', 77);
                        $this->db_b->set('descrip', "PRECIOS DE COMPRA " . $idtrannum);
                        $this->db_b->set('lowrange', $idtrannum);
                        $this->db_b->set('uniconv', $item->precioventa);    
                        $this->db_b->set('idcps', $item->idcps);    
                        $this->db_b->set('precioventa', $item->precioventa);    
                        $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                        $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                        $this->db_b->insert('invpromulti');    
                        $query = $this->db_b->insert_id();
                    }
                }
            }
            $SQLDatos = "SELECT tran_100k.itemline, tran_100k.idproducto, invproducts.modelo,  invproducts.costounitario, invproducts.precioventa, tran_100k.tax1, invproducts.descrip, tran_100k.um, tran_100k.cantidad, tran_100k.preciotran, (SELECT precioventa FROM invpromulti WHERE invpromulti.idproducto=tran_100k.idproducto AND invpromulti.idgvar=77 AND invpromulti.lowrange=tran_100k.trannum LIMIT 1)  AS precioventaMulti, (SELECT IFNULL(idrec,0) FROM invpromulti WHERE invpromulti.idproducto=tran_100k.idproducto AND invpromulti.idgvar=77 AND invpromulti.lowrange=tran_100k.trannum LIMIT 1)  AS idrec FROM tran_100k INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto WHERE  tran_100k.trannum = $idtrannum";
            $SQLDQuery = $this->db_b->query($SQLDatos);
            $SQLResult = $SQLDQuery->result();
            return $SQLResult;
        }
    }
    
    function getStatusFolder($idtrannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            
            $SQLDatos = "SELECT numx FROM tran_100 WHERE  tran_100.trannum = $idtrannum";
            $SQLDQuery = $this->db_b->query($SQLDatos);
            $SQLResult = $SQLDQuery->row_array();
            return $SQLResult['numx'];
        }
    }
    
    function updatePrecioMultiple($idrec,$precioventa){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $this->db_b->set('precioventa', $precioventa);
            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('idrec', $idrec);
            $QueryUpdate = $this->db_b->update('invpromulti');
            return $QueryUpdate;
        }
    }
    
    function updateMultiplesPrecios($trannum, $productos, $nuevoprecio){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $idrecs = explode(",", $productos);
            $totalItems = count($idrecs);
            for($i=0; $i<$totalItems; $i++){
                $this->db_b->set('precioventa', $nuevoprecio);
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('lowrange', $trannum);
                $this->db_b->where('idrec',  $idrecs[$i]);
                $query = $this->db_b->update('invpromulti');
            }
            return $query;
        }
    }
    
    function incrementarPorcentaje($trannum, $tipo, $productos, $porcentaje){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $idrecs = explode(",", $productos);
            $totalItems = count($idrecs);
            $per = $porcentaje/100;
            if($tipo==1){
                for($i=0; $i<$totalItems; $i++){
                    $SQLPrecios = "SELECT idproducto FROM invpromulti WHERE idrec = " . trim($idrecs[$i]) . " AND lowrange = $trannum";
                    $QueryPrecios = $this->db_b->query($SQLPrecios);
                    $infoPrecios = $QueryPrecios->row_array();
                            
                    $SQLProducto = "SELECT precioventa FROM invproducts WHERE idproducto = " . $infoPrecios['idproducto'];
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $infoProducto = $QueryProducto->row_array();
                    $n_precio  = ($infoProducto['precioventa'] *  $per) + $infoProducto['precioventa'] ;
                    $this->db_b->set('precioventa', $n_precio);
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('lowrange', $trannum);
                    $this->db_b->where('idrec',  trim($idrecs[$i]));
                    $query = $this->db_b->update('invpromulti');
                }
            }else{
                for($i=0; $i<$totalItems; $i++){
                    $SQLPrecios = "SELECT idproducto FROM invpromulti WHERE idrec = " . trim($idrecs[$i]);
                    $QueryPrecios = $this->db_b->query($SQLPrecios);
                    $infoPrecios = $QueryPrecios->row_array();
                            
                    $SQLProducto = "SELECT costounitario FROM invproducts WHERE idproducto = " . $infoPrecios['idproducto'];
                    $QueryProducto = $this->db_b->query($SQLProducto);
                    $infoProducto = $QueryProducto->row_array();
                    $n_precio  = ($infoProducto['costounitario'] *  $per) + $infoProducto['costounitario'];
                    $this->db_b->set('precioventa', $n_precio);
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->where('lowrange', $trannum);
                    $this->db_b->where('idrec',  trim($idrecs[$i]));
                    $query = $this->db_b->update('invpromulti');
                }
            }
                    
            return $query;
        }
    }
    
    function cerrarFolder($idtrannum){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $SQLDatos = "SELECT  idproducto, precioventa FROM invpromulti WHERE lowrange = $idtrannum";
            $SQLDQuery = $this->db_b->query($SQLDatos);
            $SQLResult = $SQLDQuery->result();
            $changes = 0 ;
            if($SQLResult!=false){
                foreach($SQLResult as $item){
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    $this->db_b->set('precioventa', $item->precioventa);     
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('idproducto', $item->idproducto);   
                    $this->db_b->update('invproducts');    
                    $changes++;
                }
            }
            if($changes>0){
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('numx', "1");     
                $this->db_b->where('trannum', $idtrannum);   
                $this->db_b->update('tran_100');    
            }
            return $changes;
        }
    }

    function insertTraslado100k($cantidad, $idbatch, $idbin, $idproducto, $um, $idcentro, $invcontrol, $inopera, $trannum, $idclase, $precio, $precioventa){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $consulta = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC Limit 1";
            $query = $this->db_b->query($consulta);
            
            if($query->num_rows() > 0){
                $resultado = $query->row_array();
                $itemLine = $resultado['itemline'] + 1;
            }else{
                $itemLine = 1;
            }
            $cant_inopera = $cantidad * $inopera;
            
            $this->db_b->set('idrec', 0);
            $this->db_b->set('trannum', $trannum);
            $this->db_b->set('itemline', $itemLine);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('invcontrol', $invcontrol);
            $this->db_b->set('idproducto', $idproducto);
            $this->db_b->set('idbatch', $idbatch);
            $this->db_b->set('idbin', $idbin);
            $this->db_b->set('cantidad', $cant_inopera);
            $this->db_b->set('costounitario', $precio);
            $this->db_b->set('preciotran', $precioventa);
            $this->db_b->set('uniconv', 1);
            $this->db_b->set('um', $um);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('tran_100k');
            return $query;
        }
    }

    function updateTraslado100k($idrec, $cantidad, $precioventa){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $cantidad = $cantidad * -1;
            
            $this->db_b->set('cantidad', $cantidad);
            $this->db_b->set('preciotran', $precioventa);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('idrec', $idrec);
            $query = $this->db_b->update('tran_100k');
            return $query;
        }
    }

    #   REPORTE INVENTARIO A LA FECHA CONSIGNACION
    function getDatosInventarioConsigna($idcentro, $fechaini, $fechafin, $idclientes){ 
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
            redirect('login/cerrar_sesion');
        }else{
            $where = str_replace('-', ' OR tran_100.idcps = ', $idclientes);

            $consulta = "SELECT invproducts.idproducto, invproducts.descrip, invproducts.modelo, invproducts.um,
                invproducts.marca, tran_100k.costounitario, SUM(tran_100k.cantidad * tran_100k.uniconv) AS cantidad,
                ctauxi.descrip AS cliente, ctauxi2.descrip AS vendedor, ctauximulti.descrip AS lugar_entrega
            FROM tran_100k INNER JOIN tran_100 ON tran_100.trannum = tran_100k.trannum
            INNER JOIN invproducts ON invproducts.idproducto = tran_100k.idproducto 
            INNER JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps
            LEFT JOIN ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi 
            INNER JOIN ctauximulti ON tran_100.idcps_branch = ctauximulti.idrec
            WHERE tran_100.idcentro = $idcentro AND tran_100.fecha >= '$fechaini' AND tran_100.fecha <= '$fechafin' AND (tran_100.idcps = $where)
            GROUP BY invproducts.idproducto, tran_100.idcps, tran_100.idcps_branch
            HAVING cantidad > 0
            ORDER BY invproducts.descrip ASC";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();

            return $resultado;
        }
    }

    
}
?>