<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Configuracion_model extends CI_Model{
         
        public function __construct() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            // $dsn = 'mysqli://'.$this->session->userdata('userDB').':'.$this->session->userdata('passDB').'@'.$this->session->userdata('serverDB').'/'.$this->session->userdata('nameDB');
            // $this->db_b = $this->load->database($dsn, true);
            
            // $this->load->dbutil($this->db_b);
            
            // if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
            //     echo 'Incorrect database information provided';
            // }

            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);

            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){ 
                echo 'Incorrect database information provided Config';
                die();
            }
        }
        
        function getMenu($user, $tipouser = 0){
            if($tipouser == 0){
                $Consulta = "SELECT gvars.*, IF(EXISTS(SELECT * FROM grights INNER JOIN gapps ON gapps.idapp = grights.idapp WHERE (gapps.menuname = gvars.descripcion) AND grights.iduser = $user), 1, 0) AS accesoMenu FROM gvars WHERE nombre = 'g_menumain' ORDER BY valor_num";
            }else{
                $Consulta = "SELECT gvars.*, CONCAT(1) AS accesoMenu FROM gvars WHERE nombre = 'g_menumain' ORDER BY valor_num";
            }
            $query = $this->db_b->query($Consulta);
            $menu = $query->result();
            return $menu;
        }
        
        function getAplicaciones($id, $tipouser = 0){
            if($tipouser == 0){
                $Consulta = "SELECT * FROM gapps INNER JOIN grights ON gapps.idapp = grights.idapp WHERE grights.iduser = $id AND gapps.estado = 1 AND gapps.menutype != 2 ORDER BY menuorder";
            }else{
                $Consulta = "SELECT * FROM gapps WHERE gapps.estado = 1 AND gapps.menutype != 2 ORDER BY menuorder";
            }
            $query = $this->db_b->query($Consulta);
            $apps = $query->result();
            return $apps;
        }
        
        function getListadoAplicaciones($id, $tipouser = 0){
            if($tipouser == 0){
                $consulta = "SELECT LOWER(appname) AS appname FROM gapps INNER JOIN grights ON gapps.idapp = grights.idapp WHERE grights.iduser = $id AND gapps.estado = 1 AND gapps.menutype != 2 ORDER BY menuorder";
            }else{
                $consulta = "SELECT LOWER(appname) AS appname FROM gapps WHERE gapps.estado = 1 AND gapps.menutype != 2 ORDER BY menuorder";
            }
            $query = $this->db_b->query($consulta);
            $apps = $query->result();
            return $apps;
        }
        
        function getPermisos($id){
            $consulta = "SELECT * FROM gusers WHERE iduser = $id";
            $query = $this->db_b->query($consulta);
            $permisos = $query->result();
            return $permisos;
        }

        function getPermisosApp($idApp = 0){
            if ($idApp != 0 && $idApp != '' && is_numeric($idApp) && (int)$idApp > 0) {
                $SQLColumns = "SHOW COLUMNS FROM grights";
                $SQLQuery   = $this->db_b->query($SQLColumns);
                $informacion = $SQLQuery->result();

                $info_permisos = '';
                foreach ($informacion as $info) {
                    if ( $info->Field == 'permisos' ) {
                        $data = $this->db_b->where("idapp", $idApp)->where("iduser", $this->session->userdata('iduser'))->get("grights");
                        if ($data->num_rows() > 0) {
                            $info_permisos = $data->row()->permisos;
                        }
                    }
                }

                return $info_permisos;
            } else return '';
        }
        #-----------    GET Apps
        public function getApps($idApp)
        {
            $app = $this->db_b->where("idapp", $idApp)->get("gapps")->row();
            $AModulos = [];
            if (count((array)$app) > 0) {
                $padre = $app->menuname;
                if (count((array)$this->session->userdata('appsSite')) > 0) {
                    foreach ($this->session->userdata('appsSite') as $dapp) {
                        if ($dapp->menuname == $padre) {
                            $AModulos[] = array(
                                'ID' => $dapp->idapp,
                                'Name' => $dapp->descrip,
                                'appname' => $dapp->appname,
                                'appoptions' => $dapp->appoptions,
                                'fin' => false,
                                'disabled' => ($dapp->idapp == $idApp) ? true : false,
                            );
                        }
                    }
                }
            }
            if(count($AModulos) > 0) usort($AModulos, function($a, $b) {return strcmp($a['Name'], $b['Name']);});
            $AModulos[] = array(
                'ID' => 0,
                'Name' => 'Salir',
                'appname' => 'Inicio',
                'appoptions' => '',
                'fin' => true,
                'disabled' => false
            );
            return $AModulos;
        }
        #-
        
        function getAppName($idApp){
            $consulta = "SELECT descrip FROM gapps WHERE idapp = $idApp";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $appName = $query->row_array();
                return $appName['descrip'];
            }else{
                return "";
            }
        }
        
        function getEmpleadoId($id){
            $consulta = "SELECT descrip, idcps, imagen, derechos, correo1 FROM gusers WHERE iduser=$id";
            $query = $this->db_b->query($consulta);
            
            //print("<br><br>");
            //print_r($query);
            //print("<br><br>");

            if($query->num_rows() > 0){
                $info = $query->row_array();
                return $info;
            }else{
                return "";
            }
        }
        
        function getNameCentroPasteles($id){
            $consulta = "SELECT descrip FROM invsites WHERE idcentro = $id";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $appName = $query->row_array();
                return $appName['descrip'];
            }else{
                return "";
            }
        }
		
		function getImagenLogoEmpresa($nameVar){
            $consulta = "SELECT valor_txt FROM gvars WHERE nombre = '$nameVar'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $appName = $query->row_array();
                return $appName['valor_txt'];
            }else{
                return "";
            }
        }
        
        function getNameCajaUser($id){
            $consulta = "SELECT ctcajas.descrip FROM ctcajas INNER JOIN gusers ON gusers.idcaja = ctcajas.idcaja WHERE iduser=$id";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $nameCaja = $query->row_array();
                return $nameCaja['descrip'];
            }else{
                return "";
            }
        }
        
        function getNameCajaByIdcentro($idcentro){
            $consulta = "SELECT ctcajas.descrip FROM ctcajas INNER JOIN invsites ON invsites.idcentro = ctcajas.idcentro WHERE ctcajas.idcentro = $idcentro";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $nameCaja = $query->row_array();
                return $nameCaja['descrip'];
            }else{
                return "";
            }
        }
        
        function getIdCajaUser($id){
            $consulta = "SELECT idcaja FROM gusers WHERE iduser = $id";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $nameCaja = $query->row_array();
                return $nameCaja['idcaja'];
            }else{
                return "";
            }
        }
        
        function getIdCajaByIdcentroUser($idcentro){
            $consulta = "SELECT ctcajas.idcaja FROM ctcajas INNER JOIN invsites ON invsites.idcentro = ctcajas.idcentro WHERE ctcajas.idcentro = $idcentro";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $nameCaja = $query->row_array();
                return $nameCaja['idcaja'];
            }else{
                return "";
            }
        }
        
        function getCentrosDelPerfil($perfilUsuario){
            $consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'gv_profile' AND valor_num = $perfilUsuario";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $nameCaja = $query->row_array();
                return $nameCaja['valor_memo'];
            }else{
                return "";
            }
        }

        function getListadoSucursalesGrupoPerfil($centros_profile){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                if($centros_profile == ""){
                    $consulta = "SELECT invsites.*, gvars.descripcion as grupo, IFNULL(ctcajas.idcaja, 0) AS idcaja, IFNULL(ctcajas.descrip, '') AS namecaja FROM invsites INNER JOIN gvars ON nombre = 'gv_tipo' AND invsites.tipo = gvars.valor_num
                    LEFT JOIN ctcajas ON ctcajas.idcentro = invsites.idcentro AND ctcajas.estatus = 1 
                    WHERE invsites.estatus = 1 ORDER BY grupo, descrip ASC";
                }else{
                    $idcentros = explode(",", $centros_profile);
                    $whereCentros = "(";
                    for($i=0; $i<count($idcentros); $i++){
                        $whereCentros .= "invsites.idcentro = ".$idcentros[$i]." OR ";
                    }
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros = $whereCentros .= ")";

                    $consulta = "SELECT invsites.*, gvars.descripcion as grupo, IFNULL(ctcajas.idcaja, 0) AS idcaja, IFNULL(ctcajas.descrip, '') AS namecaja FROM invsites INNER JOIN gvars ON gvars.nombre = 'gv_tipo' AND invsites.tipo = gvars.valor_num
                    LEFT JOIN ctcajas ON ctcajas.idcentro = invsites.idcentro AND ctcajas.estatus = 1 
                    WHERE invsites.estatus = 1 AND " . $whereCentros . " ORDER BY grupo, descrip ASC";
                }

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getListadoPermisosFiltro($perfilUsuario){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSql = "SELECT filtro FROM gvars WHERE nombre = 'gv_profile' AND valor_num = $perfilUsuario";
                $Query = $this->db_b->query($ConsultaSql);
                $informacion = $Query->row_array();
                return $informacion['filtro'];
            }
        }
        
        function getIDCPSCenter($id){
            $consulta = "SELECT idcps FROM invsites WHERE idcentro = $id";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $appName = $query->row_array();
                return $appName['idcps'];
            }else{
                return "";
            }
        }
        
        function getOptionsByidapp($idApp){
			$consulta = "SELECT appoptions FROM gapps WHERE idapp = $idApp";
            $query = $this->db_b->query($consulta);
            $appOpt = $query->row_array();
            return $appOpt['appoptions'];
        }
        
        function getProCentro($idApp){
            $consulta = "SELECT IFNULL(appoptions, '') AS appoptions FROM gapps WHERE idapp = $idApp";
            $query = $this->db_b->query($consulta);
            $appOpt = $query->row_array();
            return $appOpt['appoptions'];
        }
        
        function getTipoMenu($user, $tipouser = 0){
            if($tipouser == 0){
                $consulta = "SELECT menug FROM gusers WHERE iduser = $user";
                $query = $this->db_b->query($consulta);
                $menug = $query->row_array();

                $infoMenu = $menug['menug'];
            }else{
                $infoMenu = 0;
            }
            
            return $infoMenu;
        }
        
        //Modificacion Notas I.C. 2020-08-19
		function initGvarsNum($name, $descrip, $valor, $notas = ''){
			$consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
				return true;
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$this->db_b->set('idrnum', 0);
				$this->db_b->set('nombre', $name);
				$this->db_b->set('descripcion', $descrip);
				$this->db_b->set('valor_num', $valor);
				$this->db_b->set('tipo_valor', 1);
				$this->db_b->set('valor_memo', $notas);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
				return $query;
			}
        }

        function initGvarsNumEmp($name, $descrip, $valor, $notas = ''){
			$consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name' AND valor_num = '$valor'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
				return true;
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$this->db_b->set('idrnum', 0);
				$this->db_b->set('nombre', $name);
				$this->db_b->set('descripcion', $descrip);
				$this->db_b->set('valor_num', $valor);
				$this->db_b->set('tipo_valor', 1);
				$this->db_b->set('valor_memo', $notas);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
				return $query;
			}
        }
        
        function initGvarsNumEmpNew($name, $descrip, $valor, $notas, $filtro){
			$consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name' AND valor_num = '$valor'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
				return true;
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$this->db_b->set('idrnum', 0);
				$this->db_b->set('nombre', $name);
				$this->db_b->set('descripcion', $descrip);
				$this->db_b->set('valor_num', $valor);
				$this->db_b->set('tipo_valor', 1);
				$this->db_b->set('valor_memo', $notas);
                $this->db_b->set('filtro', $filtro);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
				return $query;
			}
        }
        
        function initGvarsPass($name, $descrip, $valor){
			$consulta = "SELECT valor_num FROM gvars WHERE nombre = '$name' AND valor_num = $valor";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
				return true;
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$this->db_b->set('idrnum', 0);
				$this->db_b->set('nombre', $name);
				$this->db_b->set('descripcion', $descrip);
				$this->db_b->set('valor_num', $valor);
				$this->db_b->set('tipo_valor', 1);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
				return $query;
			}
		}
        
        //Modificacion Notas I.C. 2020-08-19
		function initGvarsText($name, $descrip, $valor, $notas = ""){
			$consulta = "SELECT valor_txt FROM gvars WHERE nombre = '$name'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
				return true;
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$this->db_b->set('idrnum', 0);
				$this->db_b->set('nombre', $name);
				$this->db_b->set('descripcion', $descrip);
				$this->db_b->set('valor_txt', $valor);
                $this->db_b->set('tipo_valor', 2);
                $this->db_b->set('valor_memo', $notas);
				$this->db_b->set('whodidit',$this->session->userdata('iduser'));
				$this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
				$query = $this->db_b->insert('gvars');
				return $query;
			}
		}
        
        function detectarDispositivo(){
            $tablet_browser = 0;
            $mobile_browser = 0;
            $body_class = 'desktop';

            if(preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))){
                $tablet_browser++;
                $body_class = "tablet";
            }

            if(preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))){
                $mobile_browser++;
                $body_class = "mobile";
            }

            if((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))){
                $mobile_browser++;
                $body_class = "mobile";
            }

            $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
            $mobile_agents = array(
                'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
                'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
                'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
                'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
                'newt','noki','palm','pana','pant','phil','play','port','prox',
                'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
                'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
                'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
                'wapr','webc','winw','winw','xda ','xda-');

            if(in_array($mobile_ua,$mobile_agents)){
                $mobile_browser++;
            }

            if(strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0){
                $mobile_browser++;
                //Check for tablets on opera mini alternative headers
                $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
                if(preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)){
                    $tablet_browser++;
                }
            }

            if($tablet_browser > 0){
                //Retorna cuando sea table....
                return 1;
            }else if ($mobile_browser > 0){
                //Retorna cuando sea celular....
                return 2;
            }else{
                //Retorna cuando sea computadora....
                return 3;
            }
        }
        
        function getColorGvar($name){
            $consulta = "SELECT valor_txt FROM gvars WHERE nombre = '$name'";
            $query = $this->db_b->query($consulta);
            if($query->num_rows()>0){
                $menug = $query->row_array();
                return $menug['valor_txt'];
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($name == 'sy_hdcolor'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', '#2780E3');
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#2780E3";
                }elseif($name == 'sy_hdtittle'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', '#FFFFFF');
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#FFFFFF";
                }elseif($name == 'sy_formtf'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', "#000000");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#000000";
                }elseif($name == 'sy_formtb'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', "#FFFFFF");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#FFFFFF";
                }elseif($name == 'sy_formbk'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', "#FFFFFF");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#FFFFFF";
                }elseif($name == 'sy_formhbk'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', "#2780E3");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#2780E3";
                }elseif($name == 'sy_formhtf'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', "#FFFFFF");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return "#FFFFFF";
                }elseif($name == 'sy_mainwt'){
                    $this->db_b->set('idrnum', 0);
                    $this->db_b->set('nombre', $name);
                    $this->db_b->set('valor_txt', " ");
                    $this->db_b->set('tipo_valor', 2);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('gvars');
                    return " ";
                }
            }
        }
        
        function updateConfiguracionApp($navBackground, $navFontColor, $formHeadBackground, $formHeadFontColor, $formLabelFontColor, $formLabelBackground, $formBackground, $nameArchive){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
               
                $this->db_b->set('valor_txt', $navBackground);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_hdcolor');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $navFontColor);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_hdtittle');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $formHeadBackground);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_formhbk');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $formHeadFontColor);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_formhtf');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $formLabelFontColor);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_formtf');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $formBackground);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_formbk');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $formLabelBackground);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_formtb');
                $query = $this->db_b->update('gvars');
                
                $this->db_b->set('valor_txt', $nameArchive);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('nombre', 'sy_mainwt');
                $query = $this->db_b->update('gvars');
                
                return $query;
            }
        }
        
        function getHeaderDocs(){
            $consulta = "SELECT * FROM oldocs WHERE nivel = 0 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            $permisos = $query->result();
            return $permisos;
        }
        
        function getCategoriasDocs(){
            $consulta = "SELECT * FROM oldocs WHERE nivel = 1 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            $permisos = $query->result();
            return $permisos;
        }

        function getDocsByCategoria($idnivel1){
            $consulta = "SELECT * FROM oldocs WHERE nivel = 1 AND idnivel1 = $idnivel1 ORDER BY descrip ASC";
            $query = $this->db_b->query($consulta);
            $permisos = $query->result();
            return $permisos;
        }
        
        function insertHeaderDocs($categoria){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $this->db_b->set('iddoc', 0);
            $this->db_b->set('fecha', $date->format('Y-m-d'));
            $this->db_b->set('nivel', 0);
            $this->db_b->set('descrip', $categoria);
            $this->db_b->set('idcreator',$this->session->userdata('iduser'));
            $this->db_b->set('estatus',1);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('oldocs');
            return $query;
        }
        
        function updateCatDocs($iddoc,$descrip){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->where('iddoc',$iddoc);
            $query = $this->db_b->update('oldocs');
            return $query;
        }
        
        function insertDoc($iddoc, $fecha, $descrip, $doctype, $version, $profiles_allowed, $users_allowed, $writeusers, $doc,$ext, $estatus){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $this->db_b->set('iddoc', 0);
            $this->db_b->set('fecha',$date->format('Y-m-d'));
            $this->db_b->set('nivel', 1);
            $this->db_b->set('idnivel1', $iddoc);
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('version', $version);
            $this->db_b->set('doctipo', $doctype);
            if($doctype==7 || $doctype==8){
                $this->db_b->set('archivo', $doc);
            }
            $this->db_b->set('perfiles', $profiles_allowed);
            $this->db_b->set('usuarios', $users_allowed);
            $this->db_b->set('writeusers', $writeusers);
            $this->db_b->set('idcreator',$this->session->userdata('iduser'));
            $this->db_b->set('estatus',$estatus);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $query = $this->db_b->insert('oldocs');
            $id = $this->db_b->insert_id();
            if($doctype<=6 || $doctype==9){
                $this->db_b->set('archivo', "oldocs_".$id.$ext);
                $query = $this->db_b->where('iddoc',$id);
                $query = $this->db_b->update('oldocs');
            }
            return $id;
        }   
        
        function updateDoc($iddoc, $descrip, $profiles_allowed, $users_allowed, $writeusers, $doc, $estado, $idnivel1){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('idnivel1', $idnivel1);
            $this->db_b->set('perfiles', $profiles_allowed);
            $this->db_b->set('usuarios', $users_allowed);
            $this->db_b->set('writeusers', $writeusers);
            $this->db_b->set('archivo', $doc);
            $this->db_b->set('estatus',$estado);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('iddoc', $iddoc);
            $query = $this->db_b->update('oldocs');
            return $query;
        }
        
        function deleteDoc($iddoc){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{    
                $consulta2 = "DELETE FROM oldocs WHERE iddoc=$iddoc";
                $query = $this->db_b->query($consulta2);
                return $query;
            }
        }
        
        function getListadoQuerys(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select("a.idrec, a.descrip, a.allowedusers");
                $this->db_b->from("gquery a");
                $this->db_b->where("a.estado", 1);
                $this->db_b->order_by("a.descrip", "ASC");

                $informacion = false;
                if ($datos = $this->db_b->get()->result()) {
                    foreach ($datos as $dato) {
                        if (strlen(trim($dato->allowedusers)) > 0) {
                            foreach (explode(",", trim($dato->allowedusers)) as $user) {
                                if ($user == $this->session->userdata('iduser') || $this->session->userdata('iduser') == 1 || $this->session->userdata('opcionAdministrador') == 1) {
                                    $informacion[] = array(
                                        'id' => $dato->idrec,
                                        'descrip' => $dato->descrip,
                                        'allowedusers' => $dato->allowedusers
                                    );

                                    break;
                                }
                            }
                        }
                    }
                    return $informacion;
                    
                } else return false;
            }
        }

        function updateUsuariosSQL($idrec, $usuarios){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set('allowedusers', $usuarios);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('gquery');
                return $query;
            }
        }
        
        function getInformacionConsultaSQL($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "SELECT allowedusers, askdaterange, askcentro, askcaja FROM gquery WHERE idrec = $idrec";
                $Query = $this->db_b->query($ConsultaSQL);
                
                if($Query->num_rows()>0){
                    $informacion = $Query->row_array();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function ejecutarConsultaSQL($idrec, $idcentro, $idcaja, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "SELECT consulta_sql FROM gquery WHERE idrec = $idrec";
                $Query = $this->db_b->query($ConsultaSQL);
                $informacion = $Query->row_array();
                
                $infoSQL = $informacion['consulta_sql'];
                
                $infoSQL = str_replace("id_centro", $idcentro, $infoSQL);
                $infoSQL = str_replace("id_caja",   $idcaja, $infoSQL);
                $infoSQL = str_replace("fecha_ini", $fechaini, $infoSQL);
                $infoSQL = str_replace("fecha_fin", $fechafin, $infoSQL);
                $ConsultaSQL2 = $infoSQL;
                
                $Query = $this->db_b->query($ConsultaSQL2);
                
                $dataSource = array();

                if ($Query->num_rows() > 0) {
                    foreach($Query->result() as $i => $info_element){
                        $array = array();
                        foreach($info_element as $a => $b){
                            $array[$a] = (is_numeric($b)) ? $b * 1 : $b;
                        }

                        $dataSource[$i] = $array;
                    }
                }

                //print_r($dataSource);

                return $dataSource;
            }
        }
        
        function ejecutarConsultaSQLSimple($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit', '512M');

                $ConsultaSQL = "SELECT consulta_sql FROM gquery WHERE idrec = $idrec";
                $Query = $this->db_b->query($ConsultaSQL);
                $informacion = $Query->row_array();
                
                $infoSQL = $informacion['consulta_sql'];
                $ConsultaSQL2 = $infoSQL;
                
                $Query = $this->db_b->query($ConsultaSQL2);

                $dataSource = array();

                if ($Query->num_rows() > 0) {
                    foreach($Query->result() as $i => $info_element){
                        $array = array();
                        foreach($info_element as $a => $b){
                            $array[$a] = (is_numeric($b)) ? $b * 1 : $b;
                        }

                        $dataSource[$i] = $array;
                    }
                }
                //$dataSource = $Query->result();
                
                return $dataSource;
            }
        }
        
        function getInformacionColumn($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "SELECT column_type FROM gquery WHERE idrec = $idrec";
                $Query = $this->db_b->query($ConsultaSQL);
                $informacion = $Query->row_array();
                
                $infoSQL = $informacion['column_type'];
                
                return $infoSQL;
            }
        }
        
        function getDataSourceConsultasSQL($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "SELECT * FROM gquery WHERE tipo = $tipo";
                $Query = $this->db_b->query($ConsultaSQL);
                
                if($Query->num_rows()>0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }
        
        function adicionarRegistroSQL($descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios, $consulta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($centro == "true"){ $value_centro = 1; }else{ $value_centro = 0; }
                if($caja == "true"){ $value_caja = 1; }else{ $value_caja = 0; }
                if($periodo == "true"){ $value_periodo = 1; }else{ $value_periodo = 0; }
                if($estado == "true"){ $value_estado = 1; }else{ $value_estado = 0; }
                
                $this->db_b->set('idrec', 0);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('consulta_sql', $consulta);
                $this->db_b->set('askdaterange', $value_periodo);
                $this->db_b->set('askcentro', $value_centro);
                $this->db_b->set('askcaja', $value_caja);
                $this->db_b->set('allowedusers', $usuarios);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estado', $value_estado);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('gquery');
                
                return $query;
            }
        }
        
        function actualizarRegistroSQL($idrec, $descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($centro == "true"){ $value_centro = 1; }else{ $value_centro = 0; }
                if($caja == "true"){ $value_caja = 1; }else{ $value_caja = 0; }
                if($periodo == "true"){ $value_periodo = 1; }else{ $value_periodo = 0; }
                if($estado == "true"){ $value_estado = 1; }else{ $value_estado = 0; }
                
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('askdaterange', $value_periodo);
                $this->db_b->set('askcentro', $value_centro);
                $this->db_b->set('askcaja', $value_caja);
                $this->db_b->set('allowedusers', $usuarios);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estado', $value_estado);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('gquery');
                
                return $query;
            }
        }
        
        function actualizarRegistroSQLConsulta($idrec, $descrip, $tipo, $centro, $caja, $periodo, $notas, $estado, $usuarios, $consulta){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                if($centro == "true"){ $value_centro = 1; }else{ $value_centro = 0; }
                if($caja == "true"){ $value_caja = 1; }else{ $value_caja = 0; }
                if($periodo == "true"){ $value_periodo = 1; }else{ $value_periodo = 0; }
                if($estado == "true"){ $value_estado = 1; }else{ $value_estado = 0; }
                
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('consulta_sql', $consulta);
                $this->db_b->set('askdaterange', $value_periodo);
                $this->db_b->set('askcentro', $value_centro);
                $this->db_b->set('askcaja', $value_caja);
                $this->db_b->set('allowedusers', $usuarios);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estado', $value_estado);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('gquery');
                
                return $query;
            }
        }
        
        function eliminarRegistroSQL($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "DELETE FROM gquery WHERE idrec = $idrec";
                $query = $this->db_b->query($ConsultaSQL);
                
                return $query;
            }
        }

        function updateInvRecepciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $SQL   = "SELECT invclase FROM inv_def WHERE agrupa = 'IN' AND inopera = 1 AND descrip LIKE '%traslado%'";
                $Query = $this->db_b->query($SQL);
                
                $update = false;
                if($Query->num_rows()>0){
                    $info  = $Query->row_array();

                    $this->db_b->set('xpos', $info['invclase']);
                    $this->db_b->where('agrupa', 'IN');
                    $this->db_b->where('inopera', -1);
                    $this->db_b->where('descrip LIKE "%traslado%"');
                    $update = $this->db_b->update('inv_def');
                }

                return $update;
            }
        }

        function getInformacionCamposTablaSQL($nameTable){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $ConsultaSQL = "SELECT COLUMN_NAME AS columna, COLUMN_TYPE AS tipo 
                FROM INFORMATION_SCHEMA.COLUMNS 
                WHERE table_schema = '".$this->session->userdata('nameDB')."' AND table_name = '$nameTable'";
                $Query = $this->db_b->query($ConsultaSQL);
                
                if($Query->num_rows()>0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }

        function getListadoAlertasDeCuentas($idaccount){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                // $dsn = 'mysqli://goxposco_crm:egga84662@162.144.96.187/goxposco_crm';
                // $this->db_b = $this->load->database($dsn, true);
                // $this->load->dbutil();
                // $this->dbforge->db = $this->db_b;
                // if(!$this->dbutil->database_exists('goxposco_crm')){
                //     echo 'Incorrect database information provided';
                // }
                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                // $this->load->dbutil($this->db_b);
                // if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                //     echo 'Incorrect database information provided';
                //     die();
                // }

                $datoFilter = trim($this->session->userdata('idaccount')).",".$this->session->userdata('iduser');
                $ConsultaSQL = "SELECT * FROM wpos_msg WHERE (cuentas LIKE '%$idaccount%' OR cuentas = '*') AND estado = 1 AND leido NOT LIKE '%$datoFilter%'";
                $Query = $this->db_b->query($ConsultaSQL);
                
                if($Query->num_rows() > 0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }

                // $dsn = 'mysqli://'.$this->session->userdata('userDB').':'.$this->session->userdata('passDB').'@'.$this->session->userdata('serverDB').'/'.$this->session->userdata('nameDB');
                // $this->db_b = $this->load->database($dsn, true);
                // $this->load->dbutil();
                // $this->dbforge->db = $this->db_b;

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                $this->load->dbutil($this->db_b);
                if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                    echo 'Incorrect database information provided';
                    die();
                }
                
                return $informacion;
            }
        }

        function ejecutarBusquedaDatosSQL($nameSearch, $nameTable, $nameCampo, $valorFiltro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if($valorFiltro == "%%"){
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo LIKE '%$nameSearch%'";
                }else if($valorFiltro == "_%"){
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo LIKE '$nameSearch%'";
                }else if($valorFiltro == "%_"){
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo LIKE '%$nameSearch'";
                }else if($valorFiltro == "null"){
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo IS NULL";
                }else if($valorFiltro == "notnull"){
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo IS NOT NULL";
                }else{
                    $ConsultaSQL = "SELECT * FROM $nameTable WHERE $nameCampo $valorFiltro '$nameSearch'";
                }
                
                $Query = $this->db_b->query($ConsultaSQL);
                
                if($Query->num_rows()>0){
                    $informacion = $Query->result();
                }else{
                    $informacion = false;
                }
                
                return $informacion;
            }
        }

        function verificarContraCambiosSql($password){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            if (strval($password) == '3GG4@#'.str_pad($date->format('i'), 2, "0", STR_PAD_LEFT)) {
                return true;
            }
            return false;
        }

        function ejecutarCambiosDatosSQL($idCambio, $nameTable, $columnaCod, $nameColumna, $valorColumna, $valorAntColumna, $motivo, $solicita, $password){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->set($nameColumna, $valorColumna);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where($columnaCod, $idCambio);
                $this->db_b->update($nameTable);
                
                $CI =& get_instance();
                $this->db = $CI->load->database('default', TRUE);

                $this->db->set('idrec', 0);
                $this->db->set('idaccount', trim($this->session->userdata('idaccount')));
                $this->db->set('name_table', $nameTable);
                $this->db->set('name_column', $nameColumna);
                $this->db->set('motivo', $motivo);
                $this->db->set('solicita', $solicita);
                $this->db->set('old_value', $valorAntColumna);
                $this->db->set('new_value', $valorColumna);
                $this->db->set('whodidit', $this->session->userdata('iduser'));
                $this->db->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db->insert('wpos_cambios');
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $query;
            }
        }

        function getListadoAgentes() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                $this->db_b->distinct();
                $this->db_b->select('a.agente');
                $this->db_b->from('g_users_log a');
                $this->db_b->where('a.estado',  1);
                $this->db_b->order_by("a.agente", "ASC");
                $informacion = $this->db_b->get();
                
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = $info->agente;
                    }
                }
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $array;
            }
        }

        function getListadoGestiones() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                $this->db_b->distinct();
                $this->db_b->select('a.solicitud');
                $this->db_b->from('g_users_log a');
                $this->db_b->where('a.estado',  1);
                $this->db_b->order_by("a.solicitud", "ASC");
                $informacion = $this->db_b->get();
                
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = $info->solicitud;
                    }
                }
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $array;
            }
        }

        function insertDatosVerificacion($agente, $solicitud, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $this->db_b->set('idrec', 0);
                $this->db_b->set('iduser', $this->session->userdata('iduser'));
                $this->db_b->set('idaccount', trim($this->session->userdata('idaccount')));
                $this->db_b->set('date', $date->format('Y-m-d'));
                $this->db_b->set('time', $date->format('H:i:s'));
                $this->db_b->set('agente', $agente);
                $this->db_b->set('solicitud', $solicitud);
                $this->db_b->set('ip_address', $ip);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('estado', 1);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('g_users_log');
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $query;
            }
        }
        
        function updateDatosVerificacion($idrec, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('g_users_log');
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $query;
            }
        }

        function getValidatePrimerIngreso($iduser) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $this->db_b->select('idrec, idaccount, solicitud, notas, agente, DATE_FORMAT(ingresa, "%d/%m%Y %l:%i:%s %p") AS horaAcceso');
                $this->db_b->from('g_users_log');
                $this->db_b->where('iduser', $this->session->userdata('iduser'));
                $this->db_b->where('idaccount', trim($this->session->userdata('idaccount')));
                $this->db_b->where('ip_address', $ip);
                $this->db_b->where('agente !=', '');
                $this->db_b->where('date', $date->format('Y-m-d'));
                $this->db_b->order_by("time", "DESC");
                $this->db_b->limit(1);
                $informacion = $this->db_b->get();
                
                $array = [];
                if ($informacion->num_rows() > 0) {
                    foreach ($informacion->result() as $info) {
                        $array[] = array(
                            'idrec'     => $info->idrec,
                            'idaccount' => $info->idaccount,
                            'solicitud' => $info->solicitud,
                            'notas'     => $info->notas,
                            'agente'    => $info->agente,
                            'hora_acc'  => $info->horaAcceso,
                        );
                    }
                }
                
                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $array;
            }
        }

        function confirmarLecturaNoticia($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                // $dsn = 'mysqli://goxposco_crm:egga84662@162.144.96.187/goxposco_crm';
                // $this->db_b = $this->load->database($dsn, true);
                // $this->load->dbutil();
                // $this->dbforge->db = $this->db_b;
                // if(!$this->dbutil->database_exists('goxposco_crm')){
                //     echo 'Incorrect database information provided';
                // }

                $CI =& get_instance();
                $this->db_b = $CI->load->database('default', TRUE);

                $ConsultaSQL = "SELECT leido FROM wpos_msg WHERE idrec = $idrec";
                $Query = $this->db_b->query($ConsultaSQL);
                $informacion = $Query->row_array();
                $infoUpdate = $informacion['leido'];

                if($infoUpdate == ""){
                    $infoUpdate = "[".trim($this->session->userdata('idaccount')).",".$this->session->userdata('iduser').",".$date->format('Y-m-d H:i:s')."]";
                }else{
                    $infoUpdate = $infoUpdate.";[".trim($this->session->userdata('idaccount')).",".$this->session->userdata('iduser').",".$date->format('Y-m-d H:i:s')."]";
                }
                
                $this->db->set('leido', $infoUpdate);
                $this->db->where('idrec', $idrec);
                $query = $this->db->update('wpos_msg');

                // $dsn = 'mysqli://'.$this->session->userdata('userDB').':'.$this->session->userdata('passDB').'@'.$this->session->userdata('serverDB').'/'.$this->session->userdata('nameDB');
                // $this->db_b = $this->load->database($dsn, true);
                // $this->load->dbutil();
                // $this->dbforge->db = $this->db_b;

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

                return $query;

            }
        }

        function confirmarAccesoApp($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $result = false;
                foreach($_SESSION['appsSite'] as $info){
                    if($info->idapp == $idApp){
                        $result = true;
                    }
                }

                return $result;
            }
        }

        function getValidacionCorreoEmail(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                if($this->session->userdata('emailUser') == ''){
                    $resultado = false;
                }else{
                    $Consulta = "SELECT valor_memo FROM gvars WHERE nombre = 'g_empdatos' AND valor_num = 3";
                    $query = $this->db_b->query($Consulta);
                    if($query->num_rows() == 0){
                        $resultado = false;
                    }else{
                        $informacion = $query->row_array();
                        $NRC = $informacion['valor_memo'];

                        // $dsn = 'mysqli://goxposco_egga:Egga$84662@162.144.96.187/goxposco_84662';
                        // $this->db_b = $this->load->database($dsn, true);
                        // $this->load->dbutil();
                        // $this->dbforge->db = $this->db_b;

                        $CI =& get_instance();
                        $this->db_b = $CI->load->database('database_gx', TRUE);

                        $SQLCliente = "SELECT idauxi FROM ctauxi WHERE nrc = '$NRC'";
                        $iQuery = $this->db_b->query($SQLCliente);
                        if($iQuery->num_rows() == 0){
                            $resultado = false;
                        }else{
                            $infoCliente = $iQuery->row_array();
                            $idauxi = $infoCliente['idauxi'];

                            $resultado = $idauxi;
                        }
                    }

                }

                return $resultado;
            }
        }
 
        function camposPrimeraVez(){
            //CAMPO DE DUI
            $consultaVerificacion = "SHOW COLUMNS FROM `ctauxi` LIKE 'dui'";
            $queryVerificacion = $this->db_b->query($consultaVerificacion);
            $resultVerificacion = $queryVerificacion->row_array();

            if(!$resultVerificacion){
                $consultaColumnaDui = "ALTER TABLE ctauxi ADD dui varchar(15) not null AFTER nrc";
                $this->db_b->query($consultaColumnaDui);
            }

            //CAMPO DE COLOR DE PRODUCTO
            $consultaVerificacion = "SHOW COLUMNS FROM `invproducts` LIKE 'pro_color'";
            $queryVerificacion = $this->db_b->query($consultaVerificacion);
            $resultVerificacion = $queryVerificacion->row_array();

            if(!$resultVerificacion){
                $consultaColumnaDui = "ALTER TABLE invproducts ADD pro_color varchar(30) not null AFTER descuento";
                $this->db_b->query($consultaColumnaDui);
            }
           
            //CAMPO DE NUMERO MENSUAL DE PARTIDA
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ct_100'");
            if($infoResult->num_rows() > 0){
                $consultaVerificacion = "SHOW COLUMNS FROM `ct_100` LIKE 'num_mes'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consultaColumnaDui = "ALTER TABLE ct_100 ADD num_mes int(5) not null AFTER pnumero";
                    $this->db_b->query($consultaColumnaDui);
                }
            }

            //CAMPO DE UPP
            $infoResult = $this->db_b->query("SHOW COLUMNS FROM `invproducts` LIKE 'upp'");
            $resultVerificacion = $infoResult->row_array();
            if($resultVerificacion['Type'] != 'double(14,6)'){
                $consultaColumnaUpp = "ALTER TABLE invproducts MODIFY upp double(14,6) not null ";
                $this->db_b->query($consultaColumnaUpp);
            }

            //TABLA MINIMOS Y MAXIMOS
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'inv_minmax' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){
                
                $this->db_b->query("CREATE TABLE `inv_minmax`  (
                    `idrec` int(4) NOT NULL AUTO_INCREMENT,
                    `idproducto` int(6) NOT NULL,
                    `idcentro` int(4) NOT NULL,
                    `last_review` datetime NOT NULL,
                    `reorder_point` double(10, 4) NOT NULL COMMENT 'Punto de Reorden',
                    `reorder_type` int(2) NOT NULL COMMENT 'Tipo de Reorden 1= Fix Qty, 2=Calculated',
                    `reorder_qty` double(10, 4) NOT NULL COMMENT 'Cantidad a reodenar',
                    `reorder_stat` int(2) NOT NULL COMMENT 'Reorder Status, Not Reviewed, Item on order',
                    `usage_calc` int(2) NOT NULL COMMENT 'Consumo Calculado por dia semana o mes',
                    `usage_qty` double(10, 4) NOT NULL,
                    `review_cycle` int(4) NOT NULL COMMENT 'Ciclo de revision',
                    `safety_stock` double(10, 4) NOT NULL COMMENT 'Stock de seguridad',
                    `rating` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Product Rating',
                    `estado` int(2) NOT NULL COMMENT '0= Not Available,1=Available',
                    `notas` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
                    `whodidit` int(4) NOT NULL,
                    `ingresa` datetime NOT NULL,
                    `modifica` datetime NOT NULL,
                    PRIMARY KEY (`idrec`) USING BTREE,
                    INDEX `codigo`(`idproducto`) USING BTREE
                  )");
            }

            //CAMPO DE XPOS -> ETIQUETAS
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ctcuenta'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `ctcuenta` LIKE 'xpos'");
                $resultVerificacion = $infoResult->row_array();
                if($resultVerificacion['Type'] != 'varchar(255)'){
                    $consultaColumnaUpp = "ALTER TABLE ctcuenta MODIFY xpos varchar(255) not null ";
                    $this->db_b->query($consultaColumnaUpp);
                }
            }
           
            //TABLA AUDITORIA USUARIOS
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'gusers_log' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){
                
                $this->db_b->query("CREATE TABLE `gusers_log`  (
                    `idrec` int(4) NOT NULL AUTO_INCREMENT,
                    `iduser` int(4) NOT NULL,
                    `action` varchar(255) NOT NULL,
                    `values` text NOT NULL,
                    `whodidit` int(4) NOT NULL,
                    `ingresa` datetime NOT NULL,
                    PRIMARY KEY (`idrec`) USING BTREE,
                    INDEX `iduser`(`iduser`) USING BTREE
                  )");
            }

            //TABLA AUDITORIA
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'glogs' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){                
                $this->db_b->query("CREATE TABLE `glogs`  (
                    `idrec` int(11) NOT NULL AUTO_INCREMENT,
                    `idtabla` varchar(40) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT 'Tabla que se modifica',
                    `idregistro` int(11) NULL DEFAULT NULL COMMENT 'numero del registro del idtabla',
                    `valores` longtext CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL COMMENT 'Valores anteriores y nuevos',
                    `tipo` varchar(40) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT 'Accion realizada',
                    `userip` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
                    `whodidit` int(11) NULL DEFAULT NULL COMMENT 'Usuario que hizo el cambio',
                    `ingresa` datetime NULL DEFAULT NULL,
                    PRIMARY KEY (`idrec`) USING BTREE
                  ) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Bitacora de cambio de registros' ROW_FORMAT = Dynamic;");
            }

            //HEADER Y FOOTER WO DEF
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'wo_def' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){

                $consultaVerificacion = "SHOW COLUMNS FROM `wo_def` LIKE 'headername'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE wo_def ADD headername varchar(100) not null AFTER notas";
                    $this->db_b->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `wo_def` LIKE 'footername'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE wo_def ADD footername varchar(100) not null AFTER headername";
                    $this->db_b->query($consulta);
                }
            }

            //HEADER Y FOOTER WO ANEXOS
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'wo_anexos' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){

                $consultaVerificacion = "SHOW COLUMNS FROM `wo_anexos` LIKE 'headername'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE wo_anexos ADD headername varchar(100) not null AFTER imagen";
                    $this->db_b->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `wo_anexos` LIKE 'footername'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE wo_anexos ADD footername varchar(100) not null AFTER headername";
                    $this->db_b->query($consulta);
                }
            }

            //CAMPOS INV_DEF
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'inv_def' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){

                $consultaVerificacion = "SHOW COLUMNS FROM `inv_def` LIKE 'facturakey'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();
                
                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE inv_def ADD facturakey int(4) not null AFTER esticket";
                    $this->db_b->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `inv_def` LIKE 'reqflds'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE inv_def ADD reqflds varchar(40) not null AFTER facturakey";
                    $this->db_b->query($consulta);
                }
            }

            //ADICIOn CAMPOS DEFAULT FIELD IVA DEF
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'iva_def' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){

                $consultaVerificacion = "SHOW COLUMNS FROM `iva_def` LIKE 'defaultfld'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE iva_def ADD defaultfld varchar(4) not null AFTER adays";
                    $this->db_b->query($consulta);
                }
            }

            //TABLA GEN CONTA
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'conta_gencontrol' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){
                
                $this->db_b->query("CREATE TABLE `conta_gencontrol`  (
                    `idgenera` int(11) NOT NULL AUTO_INCREMENT,
                    `fecha` date NOT NULL,
                    `agrupa` varchar(6) NOT NULL COMMENT 'VN, CO, IN003',
                    `idcentro` int(11) NOT NULL,
                    `idcaja` int(11) NOT NULL,
                    `numz` int(11) NOT NULL,
                    `estatus` int(1) NOT NULL,
                    `ctfecha` datetime NOT NULL COMMENT 'Fecha de contabilizacion',
                    `ivfecha` datetime NOT NULL COMMENT 'Fecha de traslado a IVA',
                    `partida` int(11) NOT NULL COMMENT 'Numero de partida',
                    `notas` text NOT NULL,
                    `whodidit` int(4) NOT NULL,
                    `ingresa` datetime NOT NULL,
                    `modifica` datetime NOT NULL,

                    PRIMARY KEY (`idgenera`) USING BTREE,
                    INDEX `idcentro`(`idcentro`) USING BTREE,
                    INDEX `idcaja`(`idcaja`) USING BTREE


                  )");
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'conta_gencontrol' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `conta_gencontrol` LIKE 'idenera'");
                if($infoResult->num_rows() > 0){

                    $consultaColumnaUpp = "ALTER TABLE conta_gencontrol CHANGE idenera idgenera int(11) not null AUTO_INCREMENT";
                    $this->db_b->query($consultaColumnaUpp);
                }
            }

            //TABLA IMS
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ims_100' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){
                $this->db_b->query("CREATE TABLE `ims_100`  (
                    `idproceso` int(11) NOT NULL AUTO_INCREMENT,
                    `tipo` int(2) NOT NULL COMMENT 'gvars.ims_modulos -> valor_num',
                    `modulo` varchar(60) NOT NULL COMMENT 'gvars.ims_modulos',
                    `fase` varchar(60) NOT NULL COMMENT 'gvars.ims_fases',
                    `descrip` varchar(255) NOT NULL,
                    `enlaces` longtext NOT NULL COMMENT 'enlaces a material de apoyo',
                    `deptos` longtext NOT NULL COMMENT 'gvars.ims_deptos',
                    `gohtml` longtext NOT NULL COMMENT 'contenido html',
                    `estado` int(2) NOT NULL COMMENT '0=inactivo, 1=activo, 9=anulado',
                    `whodidit` int(4) NOT NULL,
                    `ingresa` datetime NOT NULL,
                    `modifica` datetime NOT NULL,

                    PRIMARY KEY (`idproceso`) USING BTREE
                  )");
            }

            //ADICION CAMPOS SUB IDAUXIDEF
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ctauxi' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $consultaVerificacion = "SHOW COLUMNS FROM `ctauxi` LIKE 'sidauxidef'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE ctauxi ADD sidauxidef varchar(20) not null AFTER idtipo";
                    $this->db_b->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `ctauxi` LIKE 'correo'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if($resultVerificacion['Type'] != 'varchar(100)'){
                    $consultaColumnaCorreo = "ALTER TABLE ctauxi MODIFY correo varchar(100) not null";
                    $this->db_b->query($consultaColumnaCorreo);
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ct_100d' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $consultaVerificacion = "SHOW COLUMNS FROM `ct_100d` LIKE 'sidauxidef'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE ct_100d ADD sidauxidef varchar(20) not null AFTER idauxi";
                    $this->db_b->query($consulta);
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ct_100d' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `ct_100d` LIKE 'sidauxidef'");
                $resultVerificacion = $infoResult->row_array();
                if($resultVerificacion['Type'] != 'varchar(50)'){
                    $consultaColumnaUpp = "ALTER TABLE ct_100d MODIFY sidauxidef varchar(50) not null ";
                    $this->db_b->query($consultaColumnaUpp);
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `tran_100` LIKE 'numero'");
                $resultVerificacion = $infoResult->row_array();
                if($resultVerificacion['Type'] != 'bigint(15)'){
                    $consultaNumero = "ALTER TABLE tran_100 MODIFY numero bigint(15) not null ";
                    $this->db_b->query($consultaNumero);
                }
            }

            //CAMPO DE iddte EN INV_DEF
            $consultaVerificacion = "SHOW COLUMNS FROM `inv_def` LIKE 'iddte'";
            $queryVerificacion = $this->db_b->query($consultaVerificacion);
            $resultVerificacion = $queryVerificacion->row_array();

            if(!$resultVerificacion){
                $consultaColumnaDui = "ALTER TABLE inv_def ADD iddte varchar(2) NOT NULL AFTER ivaopera";
                $this->db_b->query($consultaColumnaDui);
            }
            
            //CAMPO DE idpagodte EN INV_DEF
            $consultaVerificacion = "SHOW COLUMNS FROM `caj_def` LIKE 'idpagodte'";
            $queryVerificacion = $this->db_b->query($consultaVerificacion);
            $resultVerificacion = $queryVerificacion->row_array();

            if(!$resultVerificacion){
                $consultaColumnaDui = "ALTER TABLE caj_def ADD idpagodte varchar(4) NOT NULL AFTER tasa";
                $this->db_b->query($consultaColumnaDui);
            }

            //campos tabla crm
            $CI =& get_instance();
            $this->db = $CI->load->database('default', TRUE);

            $infoResult = $this->db->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'g_users_log'");
            if($infoResult->num_rows() > 0){
                $consultaVerificacion = "SHOW COLUMNS FROM `g_users_log` LIKE 'ip_address'";
                $queryVerificacion = $this->db->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE g_users_log ADD ip_address varchar(20) not null AFTER time";
                    $this->db->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `g_users_log` LIKE 'solicitud'";
                $queryVerificacion = $this->db->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE g_users_log ADD solicitud text not null AFTER time";
                    $this->db->query($consulta);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `g_users_log` LIKE 'agente'";
                $queryVerificacion = $this->db->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE g_users_log ADD agente varchar(60) not null AFTER time";
                    $this->db->query($consulta);
                }
            }

            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
            
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'g_tokens' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() == 0){              
                $this->db_b->query("CREATE TABLE `g_tokens`  (
                    `idrec` int(11) NOT NULL AUTO_INCREMENT,
                    `tipo_proceso` int(4) NOT NULL,
                    `idcuenta` int(11) NOT NULL,
                    `idcentro` int(11) NOT NULL,
                    `idcaja` int(11) NOT NULL,
                    `iduser` int(11) NOT NULL,
                    `trannum` int(11) NOT NULL,
                    `fecha_emision` datetime NOT NULL,
                    `fecha_expiracion` datetime NOT NULL,
                    `mac` varchar(255) NOT NULL COMMENT 'mac del dispositivo que activa el token',
                    `token` text NOT NULL,
                    `estado` int(2) NOT NULL COMMENT '0=inactivo, 1=activo, 9=anulado',
                    `whodidit` int(4) NOT NULL,
                    `ingresa` datetime NOT NULL,
                    `modifica` datetime NOT NULL,
                    PRIMARY KEY (`idrec`) USING BTREE
                )");
            }
            
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'iva_table' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if ($infoResult->num_rows() > 0) {
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_table` LIKE 'doc_numero'");
                $resultVerificacion = $infoResult->row_array();
                if ($resultVerificacion['Type'] != 'varchar(100)') {
                    $this->db_b->query("ALTER TABLE iva_table MODIFY doc_numero varchar(100) not null");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_table` LIKE 'doc_serie'");
                $resultVerificacion = $infoResult->row_array();
                if ($resultVerificacion['Type'] != 'varchar(100)') {
                    $this->db_b->query("ALTER TABLE iva_table MODIFY doc_serie varchar(100) not null");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_table` LIKE 'doc_tipo'"); // Original 
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE iva_table ADD doc_tipo int(2) not null AFTER doc_clase");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_table` LIKE 'doc_clase'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE iva_table ADD doc_clase varchar(20) not null AFTER doc_fecha");
                }

                $infoResult = $this->db_b->query("SHOW INDEX FROM iva_table WHERE key_name = 'idanomes'");
                if ($infoResult->num_rows() == 0) {
                    $this->db_b->query("ALTER TABLE iva_table ADD INDEX `idanomes` (`idanomes`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_table ADD INDEX `idlibro` (`idlibro`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_table ADD INDEX `idrec` (`idrec`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_table ADD INDEX `ivclase` (`ivclase`) USING BTREE");
                }
            }
            
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'iva_2024' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if ($infoResult->num_rows() > 0) {
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_2024` LIKE 'doc_numero'");
                $resultVerificacion = $infoResult->row_array();
                if ($resultVerificacion['Type'] != 'varchar(100)') {
                    $this->db_b->query("ALTER TABLE iva_2024 MODIFY doc_numero varchar(100) not null");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_2024` LIKE 'doc_serie'");
                $resultVerificacion = $infoResult->row_array();
                if ($resultVerificacion['Type'] != 'varchar(100)') {
                    $this->db_b->query("ALTER TABLE iva_2024 MODIFY doc_serie varchar(100) not null");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_2024` LIKE 'doc_tipo'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE iva_2024 ADD doc_tipo int(2) not null AFTER doc_clase");
                }

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM `iva_2024` LIKE 'doc_clase'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE iva_2024 ADD doc_clase varchar(20) not null AFTER doc_fecha");
                }

                $infoResult = $this->db_b->query("SHOW INDEX FROM iva_2024 WHERE key_name = 'idanomes'");
                if ($infoResult->num_rows() == 0) {
                    $this->db_b->query("ALTER TABLE iva_2024 ADD INDEX `idanomes` (`idanomes`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_2024 ADD INDEX `idlibro` (`idlibro`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_2024 ADD INDEX `idrec` (`idrec`) USING BTREE");
                    $this->db_b->query("ALTER TABLE iva_2024 ADD INDEX `ivclase` (`ivclase`) USING BTREE");
                }
            }
            
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'iva_def' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if ($infoResult->num_rows() > 0) {
                $infoResult = $this->db_b->query("SHOW INDEX FROM iva_def WHERE key_name = 'ivclase'");
                if ($infoResult->num_rows() == 0) {
                    $this->db_b->query("ALTER TABLE iva_def ADD INDEX `ivclase` (`ivclase`) USING BTREE");
                }
            }
            
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100dte' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if ($infoResult->num_rows() > 0) {
                $infoResult = $this->db_b->query("SHOW INDEX FROM tran_100dte WHERE key_name = 'type'");
                if ($infoResult->num_rows() == 0) {
                    $this->db_b->query("ALTER TABLE tran_100dte ADD INDEX `type` (`type`) USING BTREE");
                    $this->db_b->query("ALTER TABLE tran_100dte ADD INDEX `trannum` (`trannum`) USING BTREE");
                    $this->db_b->query("ALTER TABLE tran_100dte ADD INDEX `estatus` (`estatus`) USING BTREE");
                    $this->db_b->query("ALTER TABLE tran_100dte ADD INDEX `o_table` (`o_table`) USING BTREE");
                }
            }

            $infoResult = $this->db_b->query("SHOW COLUMNS FROM `invpromulti` LIKE 'grupo'");
            $resultVerificacion = $infoResult->row_array();
            if (!$resultVerificacion) {
                $this->db_b->query("ALTER TABLE invpromulti ADD grupo varchar(100) not null AFTER descrip");
            }

            ////// RM ////////////
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'gzips' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                /* $consultaVerificacion = "SHOW COLUMNS FROM gzips  LIKE 'sidauxidef'";
                 $queryVerificacion = $this->db_b->query($consultaVerificacion);
                 $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE gzips ADD sidauxidef varchar(20) not null AFTER idauxi";
                    $this->db_b->query($consulta);
                }*/

                $fieldExist = $this->db_b->field_exists('idpaisdte', 'gzips');

                if ($fieldExist) {
                    $infoResult = $this->db_b->query("SHOW COLUMNS FROM gzips LIKE 'distrito'");
                    $resultVerificacion = $infoResult->row_array();
                    if (!$resultVerificacion) {
                        $this->db_b->query("ALTER TABLE gzips ADD distrito varchar(125) not null AFTER depto");
                        $distritoExist = $this->db_b->field_exists('distrito', 'gzips');
                        if ($distritoExist) {
                            $updateResult = $this->db_b->query("UPDATE gzips SET distrito = municipio");
                            if ($updateResult) {
                                $query = $this->db_b->get('gzips');
                                if($query->num_rows() > 0){
                                    $infoQuery = $query->result();
                                    foreach($infoQuery as $info){
                                        $resp = gzipsArray($info->iddeptodte, $info->distrito);
                                        if($resp['result']) {
                                            $this->db_b->set('municipio', $resp['municipio']);
                                            $this->db_b->set('idmunidte', $resp['idmunidte']);
                                            $this->db_b->where('idzip', $info->idzip);
                                            $this->db_b->update('gzips');
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                 
            }
            /////////////////////////

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ctauxi' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                /* $consultaVerificacion = "SHOW COLUMNS FROM gzips  LIKE 'sidauxidef'";
                 $queryVerificacion = $this->db_b->query($consultaVerificacion);
                 $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $consulta = "ALTER TABLE gzips ADD sidauxidef varchar(20) not null AFTER idauxi";
                    $this->db_b->query($consulta);
                }*/

                $infoResult = $this->db_b->query("SHOW COLUMNS FROM ctauxi LIKE 'lprecio'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE ctauxi ADD lprecio varchar(125) not null AFTER sidauxidef");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invproducts' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invproducts LIKE 'nosujeta'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invproducts ADD nosujeta int(2) not null AFTER tipotax");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100k' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM tran_100k LIKE 'lote'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE tran_100k ADD lote varchar(20) not null AFTER idbin");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100kt' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM tran_100kt LIKE 'lote'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE tran_100kt ADD lote varchar(20) not null AFTER idbin");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'orders_100k' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM orders_100k LIKE 'lote'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE orders_100k ADD lote varchar(20) not null AFTER idbin");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100k' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM tran_100k LIKE 'fechacp'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE tran_100k ADD fechacp date not null AFTER lote");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100kt' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM tran_100kt LIKE 'fechacp'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE tran_100kt ADD fechacp date not null AFTER lote");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'orders_100k' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM orders_100k LIKE 'fechacp'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE orders_100k ADD fechacp date not null AFTER lote");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'grights' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM grights LIKE 'permisos'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE grights ADD permisos text not null AFTER lastuse");
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'direccion'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD direccion text not null AFTER descrip");
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'idzip'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD idzip int(11) not null AFTER direccion");
                }
            }

            /*$infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'imagen'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD imagen varchar(240) AFTER idcps");
                }
            }*/

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
            if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'telefono'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD telefono varchar(40) not null AFTER direccion");
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'tran_100' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM tran_100 LIKE 'origen'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE tran_100 ADD origen int(4) not null AFTER referencia");
                }
                 
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'codigomh'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD codigomh varchar(4) not null AFTER descrip");
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ctcajas' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM ctcajas LIKE 'codigomh'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE ctcajas ADD codigomh varchar(4) not null AFTER descrip");
                }
            }
        }

        function createCamposMH() {
            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'invsites' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM invsites LIKE 'codigomh'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE invsites ADD codigomh varchar(4) not null AFTER descrip");
                }
            }

            $infoResult = $this->db_b->query("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_name = 'ctcajas' AND table_schema = '".$this->session->userdata('nameDB')."'");
             if($infoResult->num_rows() > 0){
                $infoResult = $this->db_b->query("SHOW COLUMNS FROM ctcajas LIKE 'codigomh'");
                $resultVerificacion = $infoResult->row_array();
                if (!$resultVerificacion) {
                    $this->db_b->query("ALTER TABLE ctcajas ADD codigomh varchar(4) not null AFTER descrip");
                }
            }
        }

        function modifyTablecaj_def(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consultaVerificacion = "SHOW COLUMNS FROM `caj_def` LIKE 'idpagodte'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $fields = array(
                        'idpagodte' => array('type' => 'VARCHAR', 'constraint' => '4', 'null' => FALSE, 'comment' => 'Codigo pago DTE', 'after' => 'tasa')
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->add_column('caj_def', $fields);
                }
            }
        }

        function modifyTablegzips(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consultaVerificacion = "SHOW COLUMNS FROM `gzips` LIKE 'iddeptodte'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $fields = array(
                        'iddeptodte' => array('type' => 'VARCHAR', 'constraint' => '4', 'null' => FALSE, 'comment' => 'Codigo departamento DTE', 'after' => 'pais')
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->add_column('gzips', $fields);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `gzips` LIKE 'idmunidte'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $fields = array(
                        'idmunidte' => array('type' => 'VARCHAR', 'constraint' => '4', 'null' => FALSE, 'comment' => 'Codigo municipio DTE', 'after' => 'iddeptodte')
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->add_column('gzips', $fields);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `gzips` LIKE 'idpaisdte'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();

                if(!$resultVerificacion){
                    $fields = array(
                        'idpaisdte' => array('type' => 'VARCHAR', 'constraint' => '6', 'null' => FALSE, 'comment' => 'Codigo pais DTE', 'after' => 'idmunidte')
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->add_column('gzips', $fields);
                }
            }
        }

        function modifyFormatosImpresion() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = new DateTime();

                $this->db_b->set('appname', 'Facturacion/pprint');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('appname', 'ventas/facturaz/pprint');
                $this->db_b->update('gforms');

                $this->db_b->set('appname', 'Facturacion');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('appname', 'ventas/facturaz');
                $this->db_b->update('gforms');
                
                $this->db_b->set('appname', 'Detalle_Facturacion');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('appname', 'ventas/detallefacturazion');
                $this->db_b->update('gforms');
                
                $this->db_b->set('appname', 'Facturacion');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
                $this->db_b->where('appname', 'ventas/facturaz');
                $info = $this->db_b->update('gapps');

                return $info;
            }
        }

        function modifyTableconta_genfunc(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $consultaVerificacion = "SHOW COLUMNS FROM `conta_genfunc` LIKE 'iddptos'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();
                $arr = explode('(',$resultVerificacion['Type']);

                if($arr[0] != 'varchar'){
                    $fields = array(
                        'iddptos' => array('name' => 'iddptos', 'type' => 'VARCHAR', 'constraint' => '4', 'null' => FALSE)
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->modify_column('conta_genfunc', $fields);
                }

                $consultaVerificacion = "SHOW COLUMNS FROM `conta_genfunc` LIKE 'idlineas'";
                $queryVerificacion = $this->db_b->query($consultaVerificacion);
                $resultVerificacion = $queryVerificacion->row_array();
                $arr1 = explode('(',$resultVerificacion['Type']);

                if($arr1[0] != 'varchar'){
                    $fields = array(
                        'idlineas' => array('name' => 'idlineas','type' => 'VARCHAR', 'constraint' => '4', 'null' => FALSE)
                    );
                    $this->myForge = $this->load->dbforge($this->db_b, TRUE);
                    $this->myForge->modify_column('conta_genfunc', $fields);
                }
            }
        }

        function createTableFacturacionElectronica() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                if ( !$this->db_b->table_exists('tran_100dte') ) {
                    $informacion = $this->db_b->query("CREATE TABLE `tran_100dte` (
                        `idrec` int(11) NOT NULL AUTO_INCREMENT,
                        `trannum` int(11) NOT NULL,
                        `fechahora` datetime NOT NULL,
                        `ncontrol` text NOT NULL,
                        `cgeneracion` text NOT NULL,
                        `srecepcion` text NOT NULL,
                        `firma_json` longtext NOT NULL,
                        `json_doc` longtext NOT NULL,
                        `resp_mh` longtext NOT NULL,
                        `email_send` int(2) NOT NULL,
                        `type` varchar(10) NOT NULL,
                        `o_table` varchar(20) NOT NULL,
                        `notas` text NOT NULL,
                        `estatus` int(2) NOT NULL,
                        `whodidit` int(4) NOT NULL,
                        `ingresa` datetime NOT NULL,
                        `modifica` datetime NOT NULL,
                        PRIMARY KEY (`idrec`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=latin1;");
                } else $informacion = true;

                return $informacion;
            }
        }

        function validateCorrelativosDTE() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

                $this->db_b->select('valor_num');
                $this->db_b->from('gvars');
                $this->db_b->where('nombre', 'gSerieYear');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    $gYear = intval($datos->row()->valor_num);
                } else {
                    $gYear = 2024;
                }

                if ($date->format('Y-m-d H:i') >= $gYear.'-12-31 23:59') {
                    $nYear = $gYear + 1;
                    
                    $this->db_b->select('a.*');
                    $this->db_b->from('gnums a');
                    $this->db_b->like('a.serie', 'DTE');
                    $this->db_b->where('estatus', 1);
                    $informacion = $this->db_b->get();
                    
                    if ($informacion->num_rows() > 0) {
                        foreach ($informacion->result() as $info) {
                            $this->db_b->set('idrnum', 0);
                            $this->db_b->set('numgrupo', $info->numgrupo);
                            $this->db_b->set('idcentro', $info->idcentro);
                            $this->db_b->set('idcaja', $info->idcaja);
                            $this->db_b->set('serie', str_replace(substr($gYear, -2), substr($nYear, -2), $info->serie));
                            $this->db_b->set('desde', $info->desde);
                            $this->db_b->set('hasta', $info->hasta);
                            $this->db_b->set('actual', 0);
                            $this->db_b->set('resolucion', $nYear.'0101');
                            $this->db_b->set('fresolucion', $nYear.'-01-01');
                            $this->db_b->set('reserva', $info->reserva);
                            $this->db_b->set('bfecha', $nYear.'-01-01');
                            $this->db_b->set('efecha', $nYear.'-12-31');
                            $this->db_b->set('manual', $info->manual);
                            $this->db_b->set('estatus', 1);
                            $this->db_b->set('whodidit', 1);
                            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                            $query = $this->db_b->insert('gnums');

                            $this->db_b->set('estatus', 0);
                            $this->db_b->set('whodidit', 1);
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->where('idrnum', $info->idrnum);
                            $this->db_b->update('gnums');
                        }

                        $this->db_b->set('valor_num', $nYear);
                        $this->db_b->set('whodidit', 1);
                        $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                        $this->db_b->where('nombre', 'gSerieYear');
                        $this->db_b->update('gvars');

                        return true;
                    } else return false;
                } else return false;
            }
        }

        function modifyIvaTables() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            } else {
                // Tablas que vas a modificar
                $tablas = ['iva_table', 'iva_2025'];

                // Campos valor0 - valor20
                $campos = [];
                for ($i = 0; $i <= 20; $i++) {
                    $campos[] = "valor{$i}";
                }

                foreach ($tablas as $tabla) {

                    // Verificar si la tabla existe
                    $existe_tabla = $this->db_b->query("SHOW TABLES LIKE '{$tabla}'")->num_rows();
                    if (!$existe_tabla) {
                        continue; // saltar si no existe
                    }

                    foreach ($campos as $campo) {

                        // Verificar si el campo existe
                        $existe_campo = $this->db_b->query("
                            SHOW COLUMNS FROM {$tabla} LIKE '{$campo}'
                        ")->num_rows();

                        if (!$existe_campo) {
                            continue; // saltar si no existe
                        }

                        // Obtener información del campo
                        $info = $this->db_b->query("
                            SHOW COLUMNS FROM {$tabla} LIKE '{$campo}'
                        ")->row();

                        $tipo_actual = strtolower($info->Type);
                        $nulo = $info->Null;  // YES | NO

                        // Verificar si ya es DOUBLE(10,4) y NOT NULL
                        if ($tipo_actual === 'double(10,4)' && $nulo === 'NO') {
                            continue; // no necesita cambios
                        }

                        // Modificar el campo
                        $sql = "ALTER TABLE {$tabla} MODIFY {$campo} DOUBLE(10,4) NOT NULL DEFAULT 0;";
                        $this->db_b->query($sql);
                    }
                }

                return true;
            }
        }
    }
?>