<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
    class Catalog_model extends CI_Model
    {
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }
        
        function viewCatalogL1(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invcatalog WHERE nivel = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function viewCatalogL2(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM invcatalog WHERE nivel = 2 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function listProcentro(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invsites.*, gvars.descripcion AS nombreTipo FROM invsites INNER JOIN gvars ON gvars.valor_num = invsites.tipo WHERE gvars.nombre = 'gv_tipo'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function list_lineas_productos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else 
                $consulta = "SELECT invcatalog.idcatalogo, invcatalog.descrip as subdepartamento, invcatalog.idnivel1, invsites.descrip as centro, IFNULL(count(invproducts.idproducto),0) as cant FROM invcatalog LEFT JOIN invsites ON invsites.idcentro = invcatalog.procentro LEFT JOIN invproducts ON invproducts.idcatalogo= invcatalog.idcatalogo WHERE invcatalog.nivel = 2 GROUP BY invcatalog.idcatalogo ORDER BY invcatalog.descrip asc";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        
        function viewGvars(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT nombre, filtro, COUNT(nombre), descripcion FROM gvars WHERE filtro = 'invpromulti' GROUP BY nombre HAVING COUNT(nombre) = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getGvarsProductos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idrnum, descripcion, valor_num FROM gvars WHERE nombre = 'prod_multi'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertCatalog($tipo,$descrip, $nivel, $posicion, $img, $estado, $notas, $whodidit, $xpos, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 
                
                $this->db_b->set('idcatalogo', 0);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('nivel', $nivel);
                $this->db_b->set('posicion', $posicion);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('invcatalog');
                
                if($img == "" || $img == null){
                    return false;
                }else{
                    $iddepto = $this->db_b->insert_id();
                    $imgSplit = explode(".", $img);
                    $nameImg = "imgDepto_".$iddepto.".".$imgSplit[1];
                    $this->db_b->set('imagen', $nameImg);
                    $this->db_b->where('idcatalogo', $iddepto);
                    $this->db_b->update('invcatalog');
                    return $nameImg;
                }
            }
        }
        
        function updateCatalog($tipo,$idcatalog, $descrip, $nivel, $posicion, $img, $estado, $notas, $whodidit, $xpos, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{     
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s"); 
                
                if($img != "" || $img != null){
                    $imgSplit = explode(".", $img);
                    $nameImg = "imgDepto_".$idcatalog.".".$imgSplit[1];
                }else{
                    $nameImg = "";
                }
                
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('nivel', $nivel);
                $this->db_b->set('posicion', $posicion);
                $this->db_b->set('imagen', $nameImg);
                $this->db_b->set('estado', $estado);
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('xpos', $xpos);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_mod);
                $this->db_b->where('idcatalogo', $idcatalog);
                $query = $this->db_b->update('invcatalog');

                return $query;
            }
        }
        
        function deleteCatalog($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $linea = "SELECT * FROM invcatalog WHERE idnivel1 = $idcatalogo";
                $query = $this->db_b->query($linea);
				if($query->num_rows() >= 1){
					$query = false;
                }else{
                    $this->db_b->where('idcatalogo', $idcatalogo);
                    $this->db_b->delete('invcatalog');
					$query = true;
                }
				
				return $query;
            }
        }
        
        function callRegistro($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function listDepartamentos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcatalogo, descrip FROM invcatalog WHERE nivel = 1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListLineasDepartamento($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT inv.idcatalogo, inv.descrip, inv.procentro, site.descrip as nameSucursal FROM invcatalog AS inv LEFT JOIN invsites AS site ON site.idcentro = inv.procentro WHERE inv.idnivel1 = $idcatalogo ORDER BY inv.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function listadoLineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT inv.idcatalogo, inv.descrip, inv.posicion, inv.procentro, inv.xpos, inv.idnivel1, site.descrip as nameSucursal FROM invcatalog AS inv LEFT JOIN invsites AS site ON site.idcentro = inv.procentro ORDER BY inv.descrip";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function updateProcentroLineas($listLineas, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s");
                
                $array = explode(',', $listLineas);
                $total = count($array);
                $totalR = $total - 1;
                
                for($i=0; $i<=$totalR; $i++){
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('procentro', $procentro);
                    $this->db_b->set('modifica', $fecha_mod);
                    $this->db_b->where('idcatalogo', $array[$i]);
                    $query = $this->db_b->update('invcatalog');
                }
                
                return $query;
            }
        }
        
        function updateProcentroLineasCero($listcero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s");
                
                $array = explode(',', $listcero);
                $total = count($array);
                $totalR = $total - 1;
                
                for($i=0; $i<=$totalR; $i++){
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('procentro', 0);
                    $this->db_b->set('modifica', $fecha_mod);
                    $this->db_b->where('idcatalogo', $array[$i]);
                    $query = $this->db_b->update('invcatalog');
                }
                
                return $query;
            }
        }
        
        function updateProcentroCatalogo($idcatalogo, $procentro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s");
                
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('procentro', $procentro);
                $this->db_b->set('modifica', $fecha_mod);
                $this->db_b->where('idcatalogo', $idcatalogo);
                $query = $this->db_b->update('invcatalog');
                
                return $query;
            }
        }
        
        
        function getTipoCateg($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT tipo FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['tipo'];
            }
        }
        function getNameCatalog($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT descrip FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['descrip'];
            }
        }
        function getCentroCateg($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT procentro FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['procentro'];
            }
        }
        function getDepartamentosTipoPro($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invcatalog WHERE tipo = $tipo and nivel=1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getLineasCatalogo($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT * FROM invcatalog WHERE idnivel1=$idcatalogo  ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListadoLineasByDepartment($idcatalogo, $noidcatalogo, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT idcatalogo, descrip FROM invcatalog WHERE idnivel1=$idcatalogo AND idcatalogo != $noidcatalogo AND tipo = $tipopro ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function insertMuliLineas($idcatalogo, $lineas,$tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                            
                $consulta = "SELECT procentro FROM invcatalog WHERE idcatalogo=$idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $procentro = $resultado['procentro'];
                
                
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s"); 

                $consulta = "SELECT posicion FROM invcatalog WHERE idnivel1=$idcatalogo ORDER BY idcatalogo DESC LIMIT 1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows()>0){
                    $resultado = $query->row_array();
                    $last_pos = $resultado['posicion'];
                    if($last_pos!=false && $last_pos!=null){
                        $last_pos++;
                    }else{
                        $last_pos = 1;
                    }
                }else{
                    $last_pos = 1;
                }
                
                $array = explode('_', $lineas);
                $total = count($array);
                if($total==0 && $total!=""){
                    $this->db_b->set('idcatalogo', 0);
                    $this->db_b->set('descrip', trim($lineas));
                    $this->db_b->set('tipo', $tipo);
                    $this->db_b->set('nivel', 2);
                    $this->db_b->set('idnivel1', $idcatalogo);
                    $this->db_b->set('posicion', $last_pos);
                    $this->db_b->set('estado', 1);
                    $this->db_b->set('procentro', $procentro);
                    $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $fecha_actual);
                    $query = $this->db_b->insert('invcatalog');
                }else{
                    $totalR = $total - 1;
                    for($i=0; $i<=$totalR; $i++){
                        if(trim($array[$i])!=""){
                             $this->db_b->set('idcatalogo', 0);
                            $this->db_b->set('descrip', trim($array[$i]));
                            $this->db_b->set('tipo', $tipo);
                            $this->db_b->set('nivel', 2);
                            $this->db_b->set('idnivel1', $idcatalogo);
                            $this->db_b->set('posicion', $last_pos);
                            $this->db_b->set('estado', 1);
                            $this->db_b->set('procentro', $procentro);
                            $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                            $this->db_b->set('ingresa', $fecha_actual);
                            $query = $this->db_b->insert('invcatalog');
                            $last_pos++;    
                        }                       
                    }
                }
                
                return true;
            }
        }
        
        
        function getDepartamentosAgrupados($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcatalogo, descrip,concat( ROUND(gvars.valor_num), '-', gvars.descripcion) AS tipo  FROM  invcatalog INNER JOIN gvars ON gvars.valor_num=invcatalog.tipo AND gvars.nombre='gv_protipo'  WHERE  nivel = 1 AND idcatalogo!=$idcatalogo ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getDepartamentosToCanje($iddepartamento, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcatalogo, descrip, tipo FROM invcatalog WHERE idcatalogo != $iddepartamento AND nivel = 1 AND tipo = $tipopro ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function recategorizarLinea($idlinea, $id_newpadre){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_mod = date("Y-m-d H:i:s");
                
                $consulta = "SELECT tipo FROM invcatalog WHERE idcatalogo=$id_newpadre";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $tipo = $resultado['tipo'];
                
                
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('idnivel1', $id_newpadre);
                $this->db_b->set('modifica', $fecha_mod);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idcatalogo', $idlinea);
                $query = $this->db_b->update('invcatalog');
                
                $this->db_b->set('tipo', $tipo);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $fecha_mod);
                $this->db_b->where('idcatalogo', $idlinea);
                $query = $this->db_b->update('invproducts');
                
                return $query;
            }
        }
        
        function updateDatosDeCanje($idcatalogo, $idcanjes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha = date("Y-m-d H:i:s");
                
                
                $this->db_b->set('canjes_ids', $idcanjes);
                $this->db_b->set('modifica', $fecha);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->where('idcatalogo', $idcatalogo);
                $query = $this->db_b->update('invcatalog');
                
                return $query;
            }
        }
                
        function getDepartamentosTipo($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invcatalog.*, (SELECT IFNULL(COUNT(idcatalogo),0) FROM invcatalog as invcat WHERE invcat.idnivel1 = invcatalog.idcatalogo) as cantidad FROM invcatalog WHERE tipo = $tipo and nivel=1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
                
        function getCanjesIds($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT canjes_ids FROM invcatalog WHERE idcatalogo = $idcatalogo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                
                $informacion = $resultado['canjes_ids'];
                return $informacion;
            }
        }
        
        function getLineasTipo($idcatalogo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT invcatalog.*, (SELECT IFNULL(COUNT(idproducto),0) FROM invproducts WHERE invproducts.idcatalogo = invcatalog.idcatalogo) as cantidad  FROM invcatalog WHERE idnivel1=$idcatalogo  ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
        function getLineasAgrupadas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT  invcatalog.idcatalogo as idPadre, invcatalog.descrip as descripPadre, hijos.descrip as descripHijo, hijos.idcatalogo as idHijo FROM invcatalog INNER JOIN invcatalog as hijos ON invcatalog.idcatalogo=hijos.idnivel1 ORDER BY hijos.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        } 
        
        function getValidateCanjesDeProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLQuery  = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".$this->session->userdata('nameDB')."' AND TABLE_NAME = 'invcatalog';";
                $InfoQuery = $this->db_b->query($SQLQuery);
                $informacion = $InfoQuery->result();
                
                $infoResultado = 0;
                foreach($informacion as $info){
                    if($info->COLUMN_NAME == 'canjes_ids'){
                        $infoResultado = 1;
                    }
                }
                
                return $infoResultado;
            }
        }

        function getListadoVariantes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $SQLQuery  = "SELECT DISTINCT IFNULL(multiaux, '') AS descrip FROM invcatalog WHERE nivel = 2";
                $InfoQuery = $this->db_b->query($SQLQuery);
                $informacion = $InfoQuery->result();

                return $informacion;
            }
        }
        //------------------------------------------------------------------------  AGRUPACION DE PRODUCTOS ----------------------------------------------------------------------------------
        #   GET TIPOS DE DEPARTAMENTOS
        public function getTiposProductos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("valor_num, descripcion");
                $this->db_b->from("gvars");
                $this->db_b->where("nombre", 'gv_protipo');
                $this->db_b->order_by("valor_num", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->valor_num,
                            'Name' => $dato->descripcion
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET DEPARTAMENTOS LINEAS
        public function getDepartamentosLineas($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                /*$this->db_b->select("a.idcatalogo, a.descrip, a.procentro, a.idnivel1, b.descrip as depto");
                $this->db_b->from("invcatalog a");
                $this->db_b->join("invcatalog b", "a.idnivel1 = b.idcatalogo");
                $this->db_b->where("b.tipo", $Tipo);
                $this->db_b->where("b.nivel", 1);
                $this->db_b->order_by("b.descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $DataCentro = $this->getCentro($dato->procentro);
                        $Datos[] = array(
                            'codigo' => (int)$dato->idcatalogo,
                            'linea' => $dato->descrip,
                            'idcentro' => (int)$dato->procentro,
                            'centro' => (count($DataCentro) > 0) ? $DataCentro->descrip : '',
                            'iddepto' => (int)$dato->idnivel1,
                            'depto' => $dato->depto
                        );
                    }
                }
                return $Datos;//*/
                $this->db_b->select("idcatalogo, descrip, procentro");
                $this->db_b->from("invcatalog");
                $this->db_b->where("tipo", $Tipo);
                $this->db_b->where("nivel", 1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $this->db_b->select("idcatalogo, descrip, procentro");
                        $this->db_b->from("invcatalog");
                        $this->db_b->where("idnivel1", $dato->idcatalogo);
                        $this->db_b->order_by("descrip", "ASC");
                        $data2 = $this->db_b->get();
                        if ($data2->num_rows() > 0) {
                            foreach ($data2->result() as $dato2) {
                                $DataCentro = $this->getCentro(255);
                                $Datos[] = array(
                                    'codigo' => (int)$dato2->idcatalogo,
                                    'linea' => $dato2->descrip,
                                    'idcentro' => (int)$dato2->procentro,
                                    //'centro' => $DataCentro,
                                    'centro' => (count((array)$DataCentro) > 0) ? $DataCentro->descrip : '',
                                    'iddepto' => (int)$dato->idcatalogo,
                                    'depto' => $dato->descrip,
                                    'iddepto' => $dato->idcatalogo,
                                    'idcdepto' => (int)$dato->procentro,
                                    'tipo' => 0
                                );
                            }
                        } else {
                            $Datos[] = array(
                                'codigo' => null,
                                'linea' => null,
                                'idcentro' => null,
                                'centro' => null,
                                'iddepto' => (int)$dato->idcatalogo,
                                'depto' => $dato->descrip,
                                'iddepto' => $dato->idcatalogo,
                                'idcdepto' => (int)$dato->procentro,
                                'tipo' => 1
                            );
                        }
                        
                    }
                }
                return $Datos;//*/
            }
        }
        #   GET CENTRO
        public function getCentro($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                return $this->db_b->where("idcentro", $ID)->get("invsites")->row();
                /*$this->db_b->from('invsites');
                $this->db_b->where("idcentro", $ID);
                $data = $this->db_b->get();
                return $descrip = ($data->num_rows() > 0) ? $data->row()->descrip : '';//*/
            }
        }
        #   GET DATA
        public function getData($tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                switch ($tipo) {
                    //  CENTROS
                    case 1:
                        $this->db_b->select("a.idcentro, a.descrip, a.tipo, b.descripcion as nombreTipo");
                        $this->db_b->from("invsites a");
                        $this->db_b->join("gvars b", "a.tipo = b.valor_num");
                        $this->db_b->where('a.estatus', 1);
                        $this->db_b->where('b.nombre', 'gv_tipo');
                        $this->db_b->order_by("a.descrip", "ASC");
                        $data = $this->db_b->get();
                    break;
                    //  VARIANTES
                    case 2:
                        $this->db_b->select("multiaux");
                        $this->db_b->from("invcatalog");
                        $this->db_b->where("nivel", 2);
                        $this->db_b->group_by("multiaux");
                        $this->db_b->order_by("multiaux", "ASC");
                        $data = $this->db_b->get();
                    break;
                    //  OPCIONES
                    case 3:
                        $this->db_b->select("idrnum, descripcion, valor_num");
                        $this->db_b->from("gvars");
                        $this->db_b->where("nombre", 'prod_multi');
                        $this->db_b->order_by("idrnum", "ASC");
                        $data = $this->db_b->get();
                    break;
                    default:
                        $data = false;
                    break;
                }
                return $data;
            }
        }
        #   SET DEPARTAMENTO - LINEAS DE
        public function setCatalogo($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('invcatalog', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   GET CATALOGO
        public function getCatalogo($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else return $this->db_b->where("idcatalogo", $ID)->get("invcatalog")->row();
        }
        #   UPDATE DEPARTAMENTO
        public function updateCatologo($data, $ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idcatalogo', $ID);
                if ($this->db_b->update('invcatalog', $data)) return true;    
                else return false;
            }
        }
        #   CONTEO DE IMAGENS REGISTRO
        public function getContImage()
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invcatalog");
                $this->db_b->where("nivel", 2);
                $this->db_b->order_by("idcatalogo", "ASC");
                $data = $this->db_b->get();
                if ($data->num_rows() > 0) $dato = ($data->last_row()->idcatalogo + 1);
                else $dato = 1;
                return $dato;
            }
        }
        #   VALIDAR SI YA EXISTE UN IMAGEN CON EL MISMO NOMBRE
        public function validateNameImage($nombre)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invcatalog");
                $this->db_b->where("nivel", 2);
                $this->db_b->where("imagen", $nombre);
                $data = $this->db_b->get();
                if ($data->num_rows() > 0) $dato = false;
                else $dato = true;
                return $dato;
            }
        }
        #   GET LAST LINEA POSIICION
        public function getLastLinePosicion($ID)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invcatalog");
                $this->db_b->where("idnivel1", $ID);
                $this->db_b->order_by("posicion", "ASC");
                $data = $this->db_b->get();
                if ($data->num_rows() > 0) $dato = $data->last_row()->posicion;
                else $dato = 0;
                return $dato;
            }
        }
        #   VERIFICAR SI DEPTO TIENE LINEAS
        public function hasLine($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invcatalog");
                $this->db_b->where("idnivel1", $ID);
                $data = $this->db_b->get();
                return ($data->num_rows() > 0) ? true : false;
            }
        }
        #   VERIFICAR SI LINEA TIENE DEPTOS
        public function hasProducto($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("*");
                $this->db_b->from("invproducts");
                $this->db_b->where("idcatalogo", $ID);
                $data = $this->db_b->get();
                return ($data->num_rows() > 0) ? true : false;
            }
        }
        #   ELIMINAR CATALOGO
        public function delCatalogo($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idcatalogo', $ID);
                $this->db_b->delete('invcatalog');//*/
                return true;
            }
        }
        //------------------------------------------------------------------------  FIN AGRUPACION DE PRODUCTOS ------------------------------------------------------------------------------
        public function insertarImportarCatalogo($descrip, $tipo, $procentro, $nivel, $idnivel1){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s"); 
            
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('tipo', $tipo);
            $this->db_b->set('procentro', $procentro);
            $this->db_b->set('nivel', $nivel);
            $this->db_b->set('idnivel1', $idnivel1);
            $this->db_b->set('estado', 1);
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $fecha_actual);
            
            if($this->db_b->insert('invcatalog')){
                $id = $this->db_b->insert_id();
            }else{
                $id = false;
            }
            
            return $id;
        }

        public function existeDepartamentoLinea($departamento, $linea){
           
            $this->db_b->select("lin.descrip");
            $this->db_b->from("invcatalog lin");
            $this->db_b->join('invcatalog dep', 'dep.idcatalogo = lin.idnivel1', 'inner');
            $this->db_b->where("lin.descrip", $linea);
            $this->db_b->where("dep.descrip", $departamento);

            $data = $this->db_b->get();

            if ($data->num_rows() > 0) {
                $existe = true;
            }else{
                $existe = false;
            }
            
            return $existe;
        }

        //--------------------------------------------------------- IMPORTAR DESCUENTOS POR CATALOGOS -----------------------------------------
        #   GET DEPARTAMENTOS LINEAS
        public function getDepartamentosLineasDesc($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select("idcatalogo, descrip, procentro");
                $this->db_b->from("invcatalog");
                $this->db_b->where("tipo", $Tipo);
                $this->db_b->where("nivel", 1);
                $this->db_b->order_by("descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $this->db_b->select("idcatalogo, descrip, procentro, notas");
                        $this->db_b->from("invcatalog");
                        $this->db_b->where("idnivel1", $dato->idcatalogo);
                        $this->db_b->order_by("descrip", "ASC");
                        $data2 = $this->db_b->get();
                        if ($data2->num_rows() > 0) {
                            foreach ($data2->result() as $dato2) {
                                $DataCentro = $this->getCentro(255);
                                $Datos[] = array(
                                    'codigo' => (int)$dato2->idcatalogo,
                                    'linea' => $dato2->descrip,
                                    'idcentro' => (int)$dato2->procentro,
                                    //'centro' => $DataCentro,
                                    'centro' => (count((array)$DataCentro) > 0) ? $DataCentro->descrip : '',
                                    'iddepto' => (int)$dato->idcatalogo,
                                    'depto' => $dato->descrip,
                                    'iddepto' => $dato->idcatalogo,
                                    'idcdepto' => (int)$dato->procentro,
                                    'tipo' => 0,
                                    'descuentos' =>$dato2->notas
                                );
                            }
                        } else {
                            $Datos[] = array(
                                'codigo' => null,
                                'linea' => null,
                                'idcentro' => null,
                                'centro' => null,
                                'iddepto' => (int)$dato->idcatalogo,
                                'depto' => $dato->descrip,
                                'iddepto' => $dato->idcatalogo,
                                'idcdepto' => (int)$dato->procentro,
                                'tipo' => 1
                            );
                        }
                        
                    }
                }
                return $Datos;//*/
            }
        }

        public function importDescCat($descuentos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {

                //$this->db_b->where('idrec', $idrec);
                $resultado = $this->db_b->update_batch('invcatalog', $descuentos, 'idcatalogo');
                return $resultado;
            }
        }
    }
?>