<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Caja_model extends CI_Model {
         
    #private $db_b;
         
    public function __construct(){
        if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
            redirect('CerrarSesion');
        }
        
        $CI =& get_instance();
        $this->db_b = $CI->load->database('user_db', TRUE);

        $this->load->dbutil($this->db_b);
        if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
            echo 'Incorrect database information provided';
        }
    }
         
    function viewCajas(){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{  
            $consulta = "SELECT * FROM ctcajas";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
         
    function viewCajasCentros(){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{  
            $consulta = "SELECT ctcajas.idcaja, ctcajas.descrip, invsites.descrip as sucursal FROM ctcajas INNER JOIN invsites ON invsites.idcentro=ctcajas.idcentro";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
	
	function getNameCaja($idcaja){
		if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
			redirect('login/cerrar_sesion');
		}else{
			$consulta = "SELECT * FROM ctcajas WHERE idcaja = $idcaja";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
		}
	}
         
    function getCajasByCentro($idcentro){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{  
            $consulta = "SELECT idcaja, descrip FROM ctcajas WHERE idcentro = $idcentro";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
         
    function insertCaja($idcentro, $descrip, $bfecha, $efecha, $cajafondo, $resolucion, $fresolucion, $equipo, $whodidit, $xpos, $notas, $estatus,$ucajera){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{  
                    
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s"); 
            
            if($ucajera=="true"){
                $ucajera = 1;
            }else{
                $ucajera = 0;
            }
            
            $this->db_b->set('idcaja', 0);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('bfecha', $bfecha);
            $this->db_b->set('ucajera', $ucajera);
            $this->db_b->set('efecha', $efecha);
            //$this->db_b->set('cajaopen', 2);
            $this->db_b->set('cajafondo', $cajafondo);
            $this->db_b->set('resolucion', $resolucion);
            $this->db_b->set('fresolucion', $fresolucion);
            $this->db_b->set('equipo', $equipo);
            $this->db_b->set('xpos', $xpos);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('estatus', $estatus);
            $this->db_b->set('whodidit', $whodidit);
            $this->db_b->set('ingresa', $fecha_actual);
            $query = $this->db_b->insert('ctcajas');
                
            return $query;
        }    
    }
         
    function updateCaja($idcaja, $descrip, $bfecha, $efecha, $cajafondo, $resolucion, $fresolucion, $equipo, $whodidit, $xpos, $notas, $estatus,$ucajera){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{ 
            date_default_timezone_set('America/El_Salvador');
            $fecha_mod = date("Y-m-d H:i:s"); 
                  
            if($ucajera=="true"){
                $ucajera = 1;
            }else{
                $ucajera = 0;
            }
            
            $this->db_b->set('descrip', $descrip);
            $this->db_b->set('bfecha', $bfecha);
            $this->db_b->set('efecha', $efecha);
            //$this->db_b->set('cajaopen', 2);
            $this->db_b->set('cajafondo', $cajafondo);
            $this->db_b->set('ucajera', $ucajera);
            $this->db_b->set('resolucion', $resolucion);
            $this->db_b->set('fresolucion', $fresolucion);
            $this->db_b->set('equipo', $equipo);
            $this->db_b->set('xpos', $xpos);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('estatus', $estatus);
            $this->db_b->set('whodidit', $whodidit);
            $this->db_b->set('modifica', $fecha_mod);
            $this->db_b->where('idcaja', $idcaja);
            $query = $this->db_b->update('ctcajas');
            return $query;
        }
    }
         
    function callRegistro($id){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{ 
            $consulta = "SELECT * FROM ctcajas WHERE idcaja = $id";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();
            return $resultado;
        }
    }
         
    function deleteCaja($id){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{
            $consulta = "SELECT trannum FROM tran_100 WHERE idcaja = $id";
            $query = $this->db_b->query($consulta);
            if($query->num_rows() > 0){
                return false;
            }else{
                $consulta = "DELETE FROM ctcajas WHERE idcaja = $id";
                $query = $this->db_b->query($consulta);
                return true;
            }
        }
    }
         
    function getListCaja($sucursales){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{ 
            $nameCenters = explode(", ", $sucursales);
            $totCenters = count($nameCenters);
            $realCenters = $totCenters - 1;
                        
            $SQLCajas = "SELECT ctcajas.idcaja, ctcajas.idcentro, ctcajas.descrip, invsites.descrip as Sucursal FROM ctcajas INNER JOIN invsites ON invsites.idcentro = ctcajas.idcentro WHERE ";
                    
            for($i=0; $i<$realCenters; $i++){
                $consulta = "SELECT idcentro FROM invsites WHERE descrip LIKE '%$nameCenters[$i]%'";
                $query = $this->db_b->query($consulta);
                $result = $query->row_array();
                $SQLCajas .= "ctcajas.idcentro = ".$result['idcentro']." OR ";
            }
                    
            $SQLfinal = substr($SQLCajas, 0, -3);
            $SQLQuery = $this->db_b->query($SQLfinal);
            $SQLResult = $SQLQuery->result();
            return $SQLResult;
        }
    }

    function getListadoCajas(){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{ 
            $consulta = "SELECT * FROM ctcajas WHERE estatus = 1";
            $query = $this->db_b->query($consulta);
            $resultado = $query->result();

            return $resultado;
        }
    }

    function getInformacionGvar($nombre, $tipoValor){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{
            if($tipoValor == 1){
                $nameCampo = 'valor_num';
            }else if($tipoValor == 2){
                $nameCampo = 'valor_txt';
            }

            $Consulta = "SELECT idrnum, $nameCampo AS valor FROM gvars WHERE nombre = '$nombre'";
            $query = $this->db_b->query($Consulta);

            if($query->num_rows() > 0){
                $resultado = $query->row_array();
            }else{
                $resultado = false;
            }

            return $resultado;
        }
    }

    function getListadoCajasSucursal($idcentro){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{
            $Consulta = "SELECT ctcajas.idcaja, ctcajas.idcentro, ctcajas.descrip AS nameCaja FROM ctcajas WHERE ctcajas.idcentro = $idcentro";
            $query = $this->db_b->query($Consulta);

            if($query->num_rows() > 0){
                $resultado = $query->result();
            }else{
                $resultado = false;
            }

            return $resultado;
        }
    }

    function initGvarsCajas($name, $descrip, $tipo, $valor){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $this->db_b->set('idrnum', 0);
            $this->db_b->set('nombre', $name);
            $this->db_b->set('descripcion', $descrip);
            $this->db_b->set('tipo_valor', $tipo);
            if($tipo == 1){
                $this->db_b->set('valor_num', $valor);
            }else if($tipo == 2){
                $this->db_b->set('valor_txt', $valor);
            }
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
            $this->db_b->insert('gvars');
            
            $idrnum = $this->db_b->insert_id();
            
            return $idrnum;
        }
    }

    function updateInformacionVariable($idrnum, $tipo, $descrip, $valor){
        if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
        }else{
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
            
            $this->db_b->set('descripcion', $descrip);
            if($tipo == 1){
                $this->db_b->set('valor_num', $valor);
            }else if($tipo == 2){
                $this->db_b->set('valor_txt', $valor);
            }
            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
            $this->db_b->where('idrnum', $idrnum);
            $query = $this->db_b->update('gvars');
                        
            return $query;
        }
    }
    #-------------------------------------------------------------- CONTROL DE CAJAS
        #   GET CAJAS UTILIZADAS
        public function getCCajas($TCaja, $fecha)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {

                $this->db_b->select('a.numz as tnumz, b.*, c.descrip as nsucursal, d.descrip as menu');
                $this->db_b->from("tran_100 a");
                $this->db_b->join("ctcajas b", "a.idcaja = b.idcaja");
                $this->db_b->join("invsites c", "b.idcentro = c.idcentro");
                $this->db_b->join("posm_100 d", "b.idmenu = d.idmenu", 'left');
                $this->db_b->where("a.fecha", $fecha);
                $this->db_b->where("b.ucajera", $TCaja);
                $this->db_b->group_by('a.idcentro');
                $this->db_b->group_by('a.idcaja');
                $this->db_b->order_by("b.descrip", "ASC");
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $conteotr = $this->getcountRCCajas($dato->idcentro, $dato->idcaja, $dato->tnumz);
                        //$Menu = 
                        $Datos[] = array(
                            'caja' => $dato->descrip,
                            'idcaja' => (int)$dato->idcaja,
                            'sucursal' => $dato->nsucursal,
                            'valz' => (int)$dato->tnumz,
                            'idmenu' => (int)$dato->idmenu,
                            'menu' => $dato->menu,
                            'conteo' => (count((array)$conteotr) > 0) ? $conteotr->conteo : '',
                            'cajero' => (count((array)$conteotr) > 0) ? $conteotr->cajero : '',
                            'ext' => $dato->ucajera
                        );
                    }
                }
                return $Datos;
            }
        }
        #   CONTEO DE TRANSACCIONES
        public function getcountRCCajas($idcentro, $idcaja, $idz)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('count(a.idcaja) as conteo, b.descrip as cajero');
                $this->db_b->from("tran_100 a");
                $this->db_b->join("gusers b", "a.whodidit = b.iduser", 'left');
                $this->db_b->where("a.idcentro", $idcentro);
                $this->db_b->where("a.idcaja", $idcaja);
                $this->db_b->where("a.numz", $idz);
                $this->db_b->group_by("a.idcaja");
                $data = $this->db_b->get()->row();
                return $data;
            }
        }
        #-
    #-------------------------------------------------------------- GOXCAJA MENUS
        #   TIPOS DE MENUS ALL
        public function TMenus()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('idmenu, descrip, submenus, estado, notas');
                $this->db_b->from('posm_100');
                $this->db_b->order_by('descrip', 'ASC');
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->idmenu,
                            'Name' => $dato->descrip,
                            'opciones' => $dato->submenus,
                            'estado' => (int)$dato->estado,
                            'notas' => $dato->notas,
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET DEPTOS
        public function getDeptos14()
        {
            $this->db_b->select('idcatalogo, descrip');
            $this->db_b->from('invcatalog');
            $this->db_b->where('(tipo = 1 OR tipo = 4) AND (nivel = 1) AND (estado = 1)');
            $this->db_b->order_by('tipo', 'ASC');
            $this->db_b->order_by('descrip', 'ASC');
            $data = $this->db_b->get();
            $Datos = [];
            if ($data->num_rows() > 0) {
                foreach ($data->result() as $dato) {
                    $Datos[] = array(
                        'ID' => $dato->idcatalogo,
                        'Name' => strtoupper($dato->descrip)
                    );
                }
            }
            return $Datos;
        }
        #   AGREGAR MENU
        public function setMenu($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('posm_100', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   GET MENU
        public function getMenu($IDM)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else return $this->db_b->where("idmenu", $IDM)->get("posm_100")->row();
        }
        #   UPDATE MENU
        public function updateMenu($data, $IDR)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idmenu', $IDR);
                if ($this->db_b->update('posm_100', $data)) return true;
                else return false;
            }
        }
        #   GET DATA MENU
        public function getDataMenu($IDM)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('a.idrec, a.smenu_name, a.smenu_pos, a.boton_id, a.boton_code, a.boton_tit, a.boton_pm, a.boton_pv, b.precioventa, b.tipo');
                $this->db_b->from('posm_100b a');
                $this->db_b->join('invproducts b', 'a.boton_code = b.idproducto');
                $this->db_b->where('a.idmenu', $IDM);
                $this->db_b->where('a.estado', 1);
                $this->db_b->order_by('a.smenu_pos', 'ASC');
                $this->db_b->order_by('a.boton_id', 'ASC');
                $datos = $this->db_b->get();
                return $datos;
            }
        }
        
        #------------SUB MENUS
        #   GET SUBS MENUS CONFIG
        public function getSubsMenusC($ID)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $Menu = $this->getMenu($ID);
                $Datos = [];
                if (count((array)$Menu) > 0) {
                    if (strlen(trim($Menu->submenus)) > 0) {
                        foreach (explode(',', $Menu->submenus) as $submenu) {
                            $conteo = $this->getConteoSubmenu($ID, $submenu);
                            $Datos[] = array(
                                'nombre' => $submenu,
                                'valor' => $conteo
                            );
                        }
                    }
                    $datA[] = array('valido' => true, 'datos' => $Datos);
                } else $datA[] = array('valido' => false, 'tipo' => -7);
                return $datA;
            }
        }
        #   GET CONTEO DE SUB MENU
        public function getConteoSubmenu($ID, $submenu)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('*');
                $this->db_b->from('posm_100b');
                $this->db_b->where('idmenu', $ID);
                $this->db_b->where('smenu_name', $submenu);
                $this->db_b->where('estado', 1);
                $data = $this->db_b->get();
                return $data->num_rows();
            }
        }
        #   UPDATE SUB MENU ALL
        public function updateSubMenuAll($ID, $old, $nn)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {

                date_default_timezone_set('America/El_Salvador');
                $Menu = $this->getMenu($ID);
                $refact = [];
                $pos = -1;
                if (strlen(trim($Menu->submenus)) > 0) {
                    $refact = explode(',', $Menu->submenus);
                    foreach (explode(',', $Menu->submenus) as $key => $submenu) {
                        if ($old == $submenu) {
                            $pos = $key;
                            break;
                        }
                    }
                    if ($pos != -1) {
                        $refact[$pos] = $nn;
                        $data = array(
                            'submenus' => implode(',', $refact),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $this->updateMenu($data, $ID);
                        if ($this->getConteoSubmenu($ID, $old) > 0) {
                            $data = array(
                                'smenu_name' => $nn,
                                'whodidit' => $this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            $this->updateNBtn($data, $ID, $old);
                        }
                        return 7;
                    } else return 1;
                } else return 0;
            }
        }
        #   DELETE SUB MENU ALL
        public function deleteSubMenuAll($ID, $old)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                date_default_timezone_set('America/El_Salvador');
                $Menu = $this->getMenu($ID);
                $refact = [];
                $pos = -1;
                if (strlen(trim($Menu->submenus)) > 0) {
                    $refact = explode(',', $Menu->submenus);
                    foreach (explode(',', $Menu->submenus) as $key => $submenu) {
                        if ($old == $submenu) {
                            $pos = $key;
                            break;
                        }
                    }
                    if ($pos != -1) {
                        unset($refact[$pos]);
                        $data = array(
                            'submenus' => implode(',', $refact),
                            'whodidit' => $this->session->userdata('iduser'),
                            'modifica' => date_create()->format('Y-m-d H:i:s'),
                        );
                        $this->updateMenu($data, $ID);
                        if ($this->getConteoSubmenu($ID, $old) > 0) {
                            $this->deleteNBtn($ID, $old);
                        }
                        return 7;
                    } else return 1;
                } else return 0;
            }
        }


        #------- DETALLE
        #   GET ALL PRODUCTOS
        public function getAllProductosT($Tipo)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('idproducto, descrip');
                $this->db_b->from('invproducts');
                $this->db_b->where('tipo', $Tipo);
                $this->db_b->where('estado', 1);
                $this->db_b->order_by('descrip', 'ASC');
                $data = $this->db_b->get();
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $Datos[] = array(
                            'ID' => (int)$dato->idproducto,
                            'Name' => $dato->descrip,
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET BOTONES
        public function getDBtns($IDM, $submenu)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $Datos = [];
                for ($i=0; $i < 64; $i++) { 
                    $Datos[] = array(
                        'idr' => 0,
                        'id' => $i + 1,
                        'idp' => 0,
                        'opp' => 0,
                        'pp' => 0,
                        'nboton' => '',
                        'notas' => '',
                        'ocupado' => false,
                    );
                }

                $this->db_b->select('a.idrec, a.boton_id, a.boton_code, a.boton_tit, a.boton_pm, a.boton_pv, a.notas');
                $this->db_b->from('posm_100b a');
                $this->db_b->join('invproducts b', 'a.boton_code = b.idproducto');
                $this->db_b->where('a.idmenu', $IDM);
                $this->db_b->where('a.smenu_name', $submenu);
                $this->db_b->where('a.estado', 1);
                $this->db_b->order_by('a.boton_id', 'ASC');
                $datosc = $this->db_b->get();
                if ($datosc->num_rows() > 0) {
                    foreach ($datosc->result() as $datoc) {
                        //print_r($datoc);
                        $Datos[$datoc->boton_id - 1] = array(
                            'idr' => (int)$datoc->idrec,
                            'id' => (int)$datoc->boton_id,
                            'idp' => (int)$datoc->boton_code,
                            'opp' => (int)$datoc->boton_pm,
                            'pp' => $datoc->boton_pv,
                            'nboton' => $datoc->boton_tit,
                            'notas' => $datoc->notas,
                            'ocupado' => true,
                        );
                    }
                }
                return $Datos;
            }
        }
        #   GET POS SUB MENU
        public function getPosSubMenu($IDM, $submenu)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->select('smenu_pos');
                $this->db_b->from('posm_100b');
                $this->db_b->where('idmenu', $IDM);
                //$this->db_b->where('smenu_name', $submenu);
                $this->db_b->group_by('smenu_name');
                $this->db_b->order_by('smenu_pos', 'ASC');
                $data = $this->db_b->get();
                if ($data->num_rows() > 0) {
                    if ($this->getConteoSubmenu($IDM, $submenu) > 0) {
                        $this->db_b->select('smenu_pos');
                        $this->db_b->from('posm_100b');
                        $this->db_b->where('idmenu', $IDM);
                        $this->db_b->where('smenu_name', $submenu);
                        $this->db_b->order_by('smenu_pos', 'ASC');
                        $datab = $this->db_b->get();
                        return (int)$datab->last_row()->smenu_pos;

                    } else return (int)$data->last_row()->smenu_pos + 1;
                } else return 1;
            }
        }
        #   AGREGAR SUB MENU-BOTON
        public function setSubMenuBtn($data)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                if ($this->db_b->insert('posm_100b', $data)) return $this->db_b->insert_id();
                else return false;
            }
        }
        #   UPDATE SUB MENU-BOTON
        public function updateSubMenuBtn($data, $IDR)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idrec', $IDR);
                if ($this->db_b->update('posm_100b', $data)) return true;
                else return false;
            }
        }
        #   UPDATE NOMBRE ALL BTNS
        public function updateNBtn($data, $IDM, $old)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idmenu', $IDM);
                $this->db_b->where('smenu_name', $old);
                if ($this->db_b->update('posm_100b', $data)) return true;
                else return false;
            }
        }
        #   DELETE NOMBRE ALL BTNS
        public function deleteNBtn($IDM, $old)
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            } else {
                $this->db_b->where('idmenu', $IDM);
                $this->db_b->where('smenu_name', $old);
                $this->db_b->delete('posm_100b');
            }
        }
    #-
}
?>