<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

    class arap_model extends CI_Model{
        #private $db_b;
         
        public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            } 
        }

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
         
        function getCuentas_ar($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.ccestatus, tran_100.trannum as trannum,inv_def.inopera, inv_def.descrip as tipoDoc, tran_100.numero, date_format(tran_100.fecha, '%Y/%m/%d') AS fecha , date_format(tran_100.fecha, '%d/%m/%Y') AS fecha_format , DATEDIFF(now(),tran_100.fecha) as dias,ctauxi.idauxi as idcliente,  ctauxi.descrip as cliente, (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as cargos, ABS(tran_100.valdh) as abonos, (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+ tran_100.valdh ) as saldo
                            FROM tran_100
                            INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                            INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                            WHERE tran_100.idworker=$idvendedor AND inv_def.agrupa='VN' AND tran_100.estatus>=1 GROUP BY tran_100.trannum ORDER BY tran_100.fecha, tran_100.numero ASC";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function getCuentas_ar_todos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT worker.descrip as nameVendedor, tran_100.ccestatus, tran_100.trannum as trannum,inv_def.inopera, inv_def.descrip as tipoDoc, tran_100.numero, date_format(tran_100.fecha, '%Y/%m/%d') AS fecha , date_format(tran_100.fecha, '%d/%m/%Y') AS fecha_format , DATEDIFF(now(),tran_100.fecha) as dias,ctauxi.idauxi as idcliente,  ctauxi.descrip as cliente,ctauxi.grupo as grupoCliente, (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as cargos, ABS(tran_100.valdh) as abonos, (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+ tran_100.valdh ) as saldo
                            FROM tran_100
                            INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                            INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                            INNER JOIN ctauxi as worker ON tran_100.idworker= worker.idauxi
                            WHERE  inv_def.agrupa='VN' AND tran_100.estatus>=1 GROUP BY tran_100.trannum ORDER BY tran_100.fecha, tran_100.numero ASC";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }  
        
        function get_facturas_cliente($idcps, $idempleado){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT tran_100.trannum, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) as saldo, tran_100.numero, tran_100.fecha,  concat(tran_100.numero,' , ',DATE_FORMAT(tran_100.fecha, '%d/%m/%Y'),' , $',truncate(ABS((SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh)),2)) as detalle FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE (ccestatus = 0 OR ccestatus = 1) AND  idcps = $idcps  AND inopera=-1 GROUP BY trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_facturas_pendientes_cliente($idcps,$valor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.trannum, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) as saldo, tran_100.numero, tran_100.fecha,  concat(tran_100.numero,' , ',DATE_FORMAT(tran_100.fecha, '%d/%m/%Y'),' , $',truncate(ABS((SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh)),2)) as detalle FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase WHERE ccestatus = 0 AND  idcps = $idcps  AND inopera=-1 AND tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 + tran_100.valdh>=$valor GROUP BY trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function getClientes_ar($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "
                SELECT distinct ctauxi.idauxi as ID, ctauxi.descrip as Name FROM tran_100
                INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                WHERE tran_100.idworker=$idvendedor AND inv_def.agrupa='VN' 
                GROUP BY tran_100.trannum ORDER BY ctauxi.idauxi ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function getDetalleCuenta_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.trannum,tran_100.ccestatus, tran_100.estatus, tran_100k.tax1, CONCAT(tran_100.serie,tran_100.numero) AS s_n, tran_100.referencia, tran_100.idcps as codigo, ctauxi.descrip as cliente, ctauxi.telefono as telefono,  tran_100.idworker as worker,
                (SELECT ctauxi.descrip FROM ctauxi WHERE idauxi=worker) as workername,  tran_100.valcosto,tran_100.valtax1,tran_100.valdh,
                inv_def.descrip as tipoDoc, tran_100.numero, date_format(tran_100.fecha, '%d/%m/%Y') AS fechaEmision,tran_100.fecha, date_format(tran_100.fecvence, '%d/%m/%Y') AS fechaVencimiento,DATEDIFF(now(),tran_100.fecha) as dias, (SUM(CONVERT(tran_100.valventan, DECIMAL(12,4))+CONVERT(tran_100.valcosto, DECIMAL(12,4))+CONVERT(tran_100.valtax1, DECIMAL(12,4))+CONVERT(tran_100.valtax2, DECIMAL(12,4))+CONVERT(tran_100.valtax3, DECIMAL(12,4))+CONVERT(tran_100.valtax4, DECIMAL(12,4))+CONVERT(tran_100.valtax5, DECIMAL(12,4))) + CONVERT(tran_100.valdh, DECIMAL(12, 4))) as saldoPendiente
                FROM tran_100
                INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                INNER JOIN tran_100k ON tran_100k.trannum = tran_100.trannum
                WHERE tran_100.trannum=$trannum";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function detailsCuenta_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.trannum, tran_100.referencia, tran_100.idclase,  inv_def.descrip AS tipoDoc, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                SUM(CONVERT(tran_100.valventan, DECIMAL(12,4))+CONVERT(tran_100.valtax1, DECIMAL(12,4))+CONVERT(tran_100.valtax2, DECIMAL(12,4))+CONVERT(tran_100.valtax3, DECIMAL(12,4))+CONVERT(tran_100.valtax4, DECIMAL(12,4))+CONVERT(tran_100.valtax5, DECIMAL(12,4))) as cargos, SUM(CONVERT(tran_100.valventan, DECIMAL(12,4))+CONVERT(tran_100.valtax1, DECIMAL(12,4))+CONVERT(tran_100.valtax2, DECIMAL(12,4))+CONVERT(tran_100.valtax3, DECIMAL(12,4))+CONVERT(tran_100.valtax4, DECIMAL(12,4))+CONVERT(tran_100.valtax5, DECIMAL(12,4)) + CONVERT(tran_100.valdh, DECIMAL(12,4)) ) as saldo
                FROM  tran_100  INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase  WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function detailsTrans_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100c.telefono as grupoMultiples, gusers.descrip as user_tran, tran_100c.idrec, tran_100c.idworker, ctauxi.descrip AS namevendedor, tran_100c.cajclase, tran_100.trannum, tran_100c.itemline, DATE_FORMAT(tran_100c.fecha, '%m/%d/%Y') AS fecha, tran_100c.referencia, tran_100c.ingresa,tran_100c.modifica, caj_def.descrip as formaPago,  tran_100c.descrip, (CONVERT(tran_100c.valor, DECIMAL(12,4)) - CONVERT(tran_100c.vuelto, DECIMAL(12,4))) as valor, SUM(CONVERT(tran_100.valventan, DECIMAL(12,4))+CONVERT(tran_100.valtax1, DECIMAL(12,4))+CONVERT(tran_100.valtax2, DECIMAL(12,4))+CONVERT(tran_100.valtax3, DECIMAL(12,4))+CONVERT(tran_100.valtax4, DECIMAL(12,4))+CONVERT(tran_100.valtax5, DECIMAL(12,4))) as saldo
                FROM  tran_100c
                INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum
                INNER JOIN  caj_def ON caj_def.cajclase = tran_100c.cajclase 
                INNER JOIN  ctauxi ON tran_100c.idworker = ctauxi.idauxi 
                INNER JOIN  gusers ON tran_100c.whodidit = gusers.iduser 
                WHERE tran_100c.trannum = $trannum GROUP BY tran_100c.idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
        function allTrans_ar($idworker){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100c.idrec, tran_100c.idworker, tran_100c.cajclase, tran_100.trannum, tran_100c.itemline, DATE_FORMAT(tran_100c.fecha, '%m/%d/%Y') AS fecha, tran_100c.referencia, caj_def.descrip as formaPago,  tran_100c.descrip, tran_100c.valor, (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as saldo
                            FROM  tran_100c
                            INNER JOIN tran_100 ON tran_100.trannum= tran_100c.trannum
                            INNER JOIN  caj_def ON caj_def.cajclase= tran_100c.cajclase 
                            WHERE tran_100c.idworker = $idworker GROUP BY tran_100c.idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function formasPago_ar($mult){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT cajclase, descrip FROM caj_def WHERE agrupa='CC'  AND alcuadre='$mult' AND estatus=1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function formasPagoCargoDefault(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT cajclase, descrip FROM caj_def WHERE cajclase = 26";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getFechaEmision_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  DATE_FORMAT(tran_100.fecha, '%Y,%m,%d') as fecha FROM  tran_100   WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $fecha  = $resultado['fecha'];
                return $fecha;
            }
        }
        
        function getMonto_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT (SUM(tran_100.valventan+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+valdh) as monto FROM  tran_100   WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $fecha  = $resultado['monto'];
                return $fecha;
            }
        }
        
        function getMonto_ap($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+valdh) as monto FROM  tran_100   WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $fecha  = $resultado['monto'];
                return $fecha;
            }
        }
         
        function insertCuenta_ar($trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
             
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $consulta1 = "SELECT lines100c, idclase, estatus FROM tran_100  WHERE tran_100.trannum = $trannum";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->row_array();
                $lines100c  = $resultado1['lines100c'];
                $idclase  = $resultado1['idclase'];
                $estatus  = $resultado1['estatus'];
                $itemline = $lines100c+1;
                
                $consulta2 = "SELECT alcuadre FROM caj_def WHERE cajclase=$cajclase";
                $query2 = $this->db_b->query($consulta2);
                $resultado2 = $query2->row_array();
                $alcuadre  = $resultado2['alcuadre'];
                $valor = $alcuadre * $valor;
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idclase', $idclase);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('idworker', $idworker); 
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('valor', $valor);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('ingresa', $fecha_actual);
                $query = $this->db_b->insert('tran_100c');
                $consulta = "CALL totaliza100 ($trannum, $estatus)";
                $query = $this->db_b->query($consulta);
                return $itemline;
            }
        }
         
         
        function insertAbonoMultiple($x, $fecha, $cajclase, $idworker, $descrip, $datasource, $referencia, $whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                $aleatorio = rand(10000, 99999);
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                for($i=0; $i<count($datasource); $i++){
                    $trannum =  $datasource[$i]['trannum'];
                    $valor = $datasource[$i]['abono'];
                    if(round($valor,2)>0){
                        $consulta1 = "SELECT lines100c, idclase, estatus FROM tran_100  WHERE tran_100.trannum = $trannum";
                        $query1 = $this->db_b->query($consulta1);
                        $resultado1 = $query1->row_array();
                        $lines100c  = $resultado1['lines100c'];
                        $idclase  = $resultado1['idclase'];
                        $estatus  = $resultado1['estatus'];
                        $itemline = $lines100c+1;

                        $consulta2 = "SELECT alcuadre FROM caj_def WHERE cajclase=$cajclase";
                        $query2 = $this->db_b->query($consulta2);
                        $resultado2 = $query2->row_array();
                        $alcuadre  = $resultado2['alcuadre'];
                        $valor = $alcuadre * $valor;
                        $this->db_b->set('idrec', 0);
                        $this->db_b->set('trannum', $trannum);
                        $this->db_b->set('idclase', $idclase);
                        $this->db_b->set('fecha', $fecha);
                        $this->db_b->set('itemline', $itemline);
                        $this->db_b->set('cajclase', $cajclase);
                        $this->db_b->set('idworker', $idworker); 
                        $this->db_b->set('telefono', $aleatorio); 
                        $this->db_b->set('descrip', $descrip);
                        $this->db_b->set('valor', $valor);
                        $this->db_b->set('referencia', $referencia);
                        $this->db_b->set('whodidit', $whodidit);
                        $this->db_b->set('ingresa', $fecha_actual);
                        $query = $this->db_b->insert('tran_100c');
                        $consulta = "CALL totaliza100 ($trannum, $estatus)";
                        $query = $this->db_b->query($consulta);

                        $this->db_b->set('lines100c', $itemline);
                        $this->db_b->set('whodidit', $whodidit);
                        $this->db_b->set('modifica', $fecha_actual);
                        $this->db_b->where('trannum', $trannum);
                        $query = $this->db_b->update('tran_100');

                        $consulta = "SELECT trannum, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo FROM tran_100 WHERE trannum=$trannum";
                        $query = $this->db_b->query($consulta);
                        $resultado = $query->row_array();
                        $saldo = $resultado['saldo'];
                        $saldo =  round($saldo, 2);
                        if($saldo==0){
                            $estado= 1;//cancelado
                        }else if($saldo>0){
                            $estado=0;//pendiente
                        }else if($saldo<0){
                            $estado=2;//sobrepagado
                        }
                        $this->db_b->set('ccestatus', $estado);
                        $this->db_b->set('modifica', $fecha_actual);
                        $this->db_b->where('trannum', $trannum);
                        $query = $this->db_b->update('tran_100');
                        $query = $this->db_b->query($consulta);   
                    }
                }
                return $i;
                
            }
        }
         
        function actualizaItemLine_ar($trannum, $itemline,$whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('lines100c', $itemline);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                return $query;
            }
        }
        
        function updateCuenta_ar($idrec,$trannum, $fecha, $cajclase, $idworker, $descrip, $valor, $referencia, $whodidit){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $consulta1 = "SELECT lines100c, idclase, estatus  FROM  tran_100   WHERE tran_100.trannum = $trannum";
                $query1 = $this->db_b->query($consulta1);
                $resultado1 = $query1->row_array();
                $lines100c  = $resultado1['lines100c'];
                $idclase  = $resultado1['idclase'];
                $estatus  = $resultado1['estatus'];
                $this->db_b->set('idclase', $idclase);
                //$this->db_b->set('fecha', $fecha);
                $this->db_b->set('cajclase', $cajclase);
            // $this->db_b->set('idworker', $idworker); 
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('whodidit', $whodidit);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100c');
                $consulta = "CALL totaliza100 ($trannum, $estatus)";
                $query = $this->db_b->query($consulta);
                return $query;
        }
        }
        
        function update_cc_cp($idrec, $trannum, $cajclase, $descrip, $referencia){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('descrip', $descrip);
                $this->db_b->set('referencia', $referencia);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->update('tran_100c');
                return $query;
        }
        }
        
        function deleteCuenta_ar($idrec, $trannum, $whodidit, $notas){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");
            
            $this->db_b->set('valor', 0);
            $this->db_b->set('notas', $notas);
            $this->db_b->set('whodidit', $whodidit);
            $this->db_b->set('modifica', $fecha_actual);
            $this->db_b->where('idrec', $idrec);
            $query = $this->db_b->update('tran_100c');
            $consulta = "CALL totaliza100 ($trannum, 1)";
            $query = $this->db_b->query($consulta);
            return $query;
        }
        
        function getCuentas_ap(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.ccestatus, tran_100.trannum AS trannum, inv_def.descrip AS tipoDoc, CONCAT(tran_100.serie,tran_100.numero) AS s_n, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%Y/%m/%d') AS fecha, DATEDIFF(NOW(), tran_100.fecha) AS dias, ctauxi.idauxi AS idcliente, ctauxi.descrip AS cliente, ABS((SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5))) AS cargos, ABS(tran_100.valdh) AS abonos, (SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'CO' AND tran_100.estatus = 1 GROUP BY tran_100.trannum ORDER BY tran_100.fecha , tran_100.numero ASC";
                
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detailsCuenta_ap($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  tran_100.trannum, tran_100.referencia, tran_100.idclase,  inv_def.descrip AS tipoDoc, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as cargos, (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+ tran_100.valdh ) as saldo
                FROM  tran_100  INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase  WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detailsTrans_ap($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100c.idrec, tran_100c.idworker, tran_100c.cajclase, tran_100.trannum, tran_100c.itemline, DATE_FORMAT(tran_100c.fecha, '%m/%d/%Y') AS fecha, tran_100c.referencia, caj_def.descrip as formaPago,  tran_100c.descrip, tran_100c.valor, (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as saldo
                            FROM  tran_100c
                            INNER JOIN tran_100 ON tran_100.trannum= tran_100c.trannum
                            INNER JOIN  caj_def ON caj_def.cajclase= tran_100c.cajclase 
                            WHERE tran_100c.trannum = $trannum GROUP BY tran_100c.idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function formasPago_ap($mult){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT cajclase,descrip FROM caj_def WHERE agrupa='CP'  AND alcuadre='$mult' AND estatus=1";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function updateccestatus_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                
                $consulta = "SELECT trannum, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo FROM tran_100 WHERE trannum=$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $saldo = $resultado['saldo'];
                $saldo =  round($saldo, 2);
                if($saldo==0){
                    $estado= 1;//cancelado
                }else if($saldo>0){
                    $estado=0;//pendiente
                }else if($saldo<0){
                    $estado=2;//sobrepagado
                }
                $this->db_b->set('ccestatus', $estado);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        function updateccestatus_ap($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d H:i:s");
                $consulta = "SELECT trannum, (SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo
                        FROM
                            tran_100 WHERE trannum=$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                $saldo = $resultado['saldo'];
                $saldo =  round($saldo, 2);
                if($saldo=="0"){
                    $estado= 1;//cancelado
                }else if($saldo>"0"){
                    $estado=0;//pendiente
                }else if($saldo<"0"){
                    $estado=2;//sobrepagado
                }
                $this->db_b->set('ccestatus', $estado);
                $this->db_b->set('modifica', $fecha_actual);
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100');
                $query = $this->db_b->query($consulta);
                return $query;
            }
        }
        
        
        //REPORTE ANTIGUEDAD CUENTAS POR PAGAR
        function getGrupos_ap(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT ctauxi.grupo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'CO' AND tran_100.estatus>=1 GROUP BY ctauxi.grupo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getProveedores_ap(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT ctauxi.nrc, ctauxi.descrip as provee, ctauxi.grupo, DATEDIFF(now(),tran_100.fecha) as dias, (SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) as saldo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'CO' AND tran_100.estatus>=1 GROUP BY tran_100.trannum ORDER BY  provee, dias";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        //REPORTE ANTIGUEDAD CUENTAS POR COBRAR
        function getGrupos_ar(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.idworker,  ctauxi.idcps as vendedorAsignado, (SELECT descrip from ctauxi where idauxi= idworker) as workername, (SELECT descrip from ctauxi where idauxi= vendedorAsignado) as vendedor FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus>=1 GROUP BY tran_100.idworker";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListClientes_ar(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.idworker, ctauxi.idcps as vendedorAsignado, ctauxi.limite,ctauxi.descrip as workername, ctauxi.descrip as vendedor, ctauxi.nrc, ctauxi.descrip as provee, ctauxi.grupo, DATEDIFF(now(),tran_100.fecha) as dias, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) as saldo, ctauxi.direccion, ctauxi.telefono, CONCAT(' ', TRIM(gzips.municipio),', ',TRIM(gzips.depto)) AS depto FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN gzips ON ctauxi.idzip = gzips.idzip WHERE inv_def.agrupa = 'VN' AND tran_100.estatus>=1 GROUP BY tran_100.trannum ORDER BY  provee, dias";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getGrupos_ar_vende($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT ctauxi.grupo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus>=1 AND tran_100.idworker=$idvendedor GROUP BY ctauxi.grupo";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getListClientes_ar_vende($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT ctauxi.nrc, ctauxi.descrip as provee,ctauxi.direccion, ctauxi.telefono, concat(' ', trim(gzips.municipio), ', ', trim(gzips.depto)) as depto, ctauxi.limite, ctauxi.grupo, DATEDIFF(now(),tran_100.fecha) as dias, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) as saldo FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN gzips ON ctauxi.idzip= gzips.idzip WHERE inv_def.agrupa = 'VN' AND tran_100.estatus>=1 AND tran_100.idworker=$idvendedor GROUP BY tran_100.trannum ORDER BY  provee, dias";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        //REPORTE CARTERA DE CLIENTES
        function getClientes_ar_cartera($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT distinct ctauxi.idauxi as ID, ctauxi.descrip as Name
                                FROM tran_100
                                INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                                INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                                WHERE ctauxi.idcps=$idvendedor AND inv_def.agrupa='VN' AND tran_100.ccestatus!=1 
                                GROUP BY tran_100.trannum ORDER BY ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCuentas_ar_cartera($idvendedor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100.trannum, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fecha, DATE_FORMAT(tran_100.fecvence, '%d/%m/%Y') as fechavence, DATEDIFF(now(),tran_100.fecha) as dias, ctauxi.idauxi, inv_def.descrip as tipoDoc, (SUM( CONVERT(tran_100.valventan, DECIMAL(12,2)) + CONVERT(tran_100.valtax1, DECIMAL(12,2)) + CONVERT(tran_100.valtax2, DECIMAL(12,2)) + CONVERT(tran_100.valtax3, DECIMAL(12,2)) + CONVERT(tran_100.valtax4, DECIMAL(12,2)) + CONVERT(tran_100.valtax5, DECIMAL(12,2))) + CONVERT(tran_100.valdh, DECIMAL(12,2)) ) AS saldo, SUM( CONVERT(tran_100.valventan, DECIMAL(12,2)) + CONVERT(tran_100.valtax1, DECIMAL(12,2)) + CONVERT(tran_100.valtax2,DECIMAL(12,2)) + CONVERT(tran_100.valtax3, DECIMAL(12,2)) + CONVERT(tran_100.valtax4, DECIMAL(12,2)) + CONVERT(tran_100.valtax5, DECIMAL(12,2))) AS saldoInicial FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 AND ctauxi.idcps = $idvendedor AND tran_100.ccestatus!=1 GROUP BY tran_100.trannum HAVING ( saldo != 0 AND saldoInicial != 0 ) ORDER BY ctauxi.descrip, tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_dev_fact($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta =" select (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo FROM tran_100 WHERE tran_100.trannum=$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['saldo'];
            }
        }
        
        function getGrupos_ar2(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100.idworker, ctauxi.idcps AS vendedorAsignado, ctauxi.descrip AS vendedor, ctauxi2.descrip AS workername FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS ctauxi2 ON tran_100.idworker = ctauxi2.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 GROUP BY tran_100.idworker";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        //REPORTE CARTERA POR ZONA
        function getClientes_ar_zona($zona){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT distinct ctauxi.idauxi as ID, ctauxi.descrip as Name, ctauxi.direccion,ctauxi.telefono
                                FROM tran_100
                                INNER JOIN inv_def ON inv_def.invclase= tran_100.idclase
                                INNER JOIN ctauxi ON tran_100.idcps= ctauxi.idauxi
                                WHERE ctauxi.grupo='$zona' AND inv_def.agrupa='VN' AND tran_100.ccestatus!=1 
                                GROUP BY tran_100.trannum ORDER BY ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCuentas_ar_zona($zona){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100.trannum, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fecha, ctauxi.idauxi, inv_def.descrip as tipoDoc, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo, vendedor.descrip as vendedorName FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN ctauxi as vendedor ON tran_100.idworker=vendedor.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 AND ctauxi.grupo = '$zona' AND tran_100.ccestatus!=1 GROUP BY tran_100.trannum ORDER BY  ctauxi.descrip, tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCuentas_ar_zona_fechas($zona, $fechaini, $fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100.trannum, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fecha, ctauxi.idauxi, inv_def.descrip as tipoDoc, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo, vendedor.descrip as vendedorName FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN ctauxi as vendedor ON tran_100.idworker=vendedor.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 AND ctauxi.grupo = '$zona' AND tran_100.ccestatus!=1 AND tran_100.fecha BETWEEN '$fechaini' and '$fechafin' GROUP BY tran_100.trannum ORDER BY  ctauxi.descrip, tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getZonasPeriodo($fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT DISTINCT ctauxi.grupo AS zona FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi INNER JOIN ctauxi AS worker ON tran_100.idworker = worker.idauxi  WHERE  inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin' ORDER BY ctauxi.grupo";
                $query = $this->db_b->query($consulta);
                $result = $query->result();
                return $result;
            }
        }
        
        function getDatosVentasyCobros($zona,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                                ctauxi.grupo AS zona,
                                inv_def.inopera,
                                COUNT(tran_100.trannum) AS num_facturas,
                                IF(inv_def.inopera = - 1, SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5), 0) AS ventaneta,
                                IF(inv_def.inopera = 1, SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5),0) AS devoluciones
                            FROM
                                tran_100
                                    INNER JOIN
                                ctauxi ON tran_100.idcps = ctauxi.idauxi
                                    INNER JOIN
                                inv_def ON inv_def.invclase = tran_100.idclase
                            WHERE
                                tran_100.estatus >= 1
                                    AND inv_def.agrupa = 'VN'
                                    AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                                    AND ctauxi.grupo = '$zona'
                            GROUP BY ctauxi.grupo,inv_def.inopera
                            ORDER BY ctauxi.grupo ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getCobradoZona($zona,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                        SUM(tran_100c.valor -tran_100c.vuelto) as cobrado
                    FROM
                        tran_100
                        INNER JOIN tran_100c ON tran_100.trannum=tran_100c.trannum
                            INNER JOIN
                        ctauxi ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                    WHERE
                        tran_100.estatus >= 1
                            AND inv_def.agrupa = 'VN'
                            AND tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin'
                            AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                            AND ctauxi.grupo = '$zona'";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado['cobrado'];
            }
        }
        
        function detailTranZona($zona,$fechaini,$fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                            worker.descrip AS nameVendedor,
                            tran_100.trannum AS trannum,
                            inv_def.inopera,
                            inv_def.descrip AS tipoDoc,
                            tran_100.numero,
                            tran_100.fecha,
                            ctauxi.descrip AS cliente,
                            SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS valor
                        FROM
                            tran_100
                                INNER JOIN
                            inv_def ON inv_def.invclase = tran_100.idclase
                                INNER JOIN
                            ctauxi ON tran_100.idcps = ctauxi.idauxi
                                INNER JOIN
                            ctauxi AS worker ON tran_100.idworker = worker.idauxi
                        WHERE
                            inv_def.agrupa = 'VN'
                                AND tran_100.estatus >= 1
                                AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'
                                AND ctauxi.grupo='$zona'
                        GROUP BY tran_100.trannum
                        ORDER BY tran_100.fecha , tran_100.numero ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        /*
        function getInfoCliente($idauxi){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                        tran_100.fecvence,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        ROUND(( FORMAT(SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5), 2) + FORMAT(tran_100.valdh, 2)),2) AS saldo,
                        ROUND(( FORMAT(SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5), 2) + FORMAT(tran_100.valdh, 2)),2) AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor,
                        invsites.descrip as Sucursal,
                        (
                            CASE
                                WHEN ((inv_def.inopera = 1) AND (inv_def.agrupa = 'VN')) THEN 1
                                ELSE 0
                            END
                        ) as isnotacredito
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            INNER JOIN 
                        invsites ON invsites.idcentro = tran_100.idcentro
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'VN'
                            AND tran_100.estatus = 1
                            GROUP BY trannum
                            ORDER BY tran_100.fecha,tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        */
        
        function getInfoCliente($idauxi){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias as auxiDias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                        tran_100.fecvence,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        SUM( CONVERT(tran_100.valventan, DECIMAL(12,4)) + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + CONVERT(tran_100.valtax2, DECIMAL(12,4)) + CONVERT(tran_100.valtax3, DECIMAL(12,4)) + CONVERT(tran_100.valtax4, DECIMAL(12,4)) + CONVERT(tran_100.valtax5, DECIMAL(12,4)) ) + CONVERT(tran_100.valdh, DECIMAL(12,4)) AS saldo,
                        SUM( CONVERT(tran_100.valventan, DECIMAL(12,4)) + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + CONVERT(tran_100.valtax2, DECIMAL(12,4)) + CONVERT(tran_100.valtax3, DECIMAL(12,4)) + CONVERT(tran_100.valtax4, DECIMAL(12,4)) + CONVERT(tran_100.valtax5, DECIMAL(12,4) ) + CONVERT(tran_100.valdh, DECIMAL(12,4))) AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor,
                        invsites.descrip as Sucursal,
                        (
                            CASE
                                WHEN ((inv_def.inopera = 1) AND (inv_def.agrupa = 'VN')) THEN 1
                                ELSE 0
                            END
                        ) as isnotacredito
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            INNER JOIN 
                        invsites ON invsites.idcentro = tran_100.idcentro
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'VN'
                            AND tran_100.estatus = 1
                            GROUP BY trannum
                            ORDER BY tran_100.fecha,tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getInfoClientePorPagar($idauxi){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                        tran_100.fecvence,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        SUM( CONVERT(tran_100.valcosto, DECIMAL(12,4)) + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + CONVERT(tran_100.valtax2, DECIMAL(12,4)) + CONVERT(tran_100.valtax3, DECIMAL(12,4)) + CONVERT(tran_100.valtax4, DECIMAL(12,4)) + CONVERT(tran_100.valtax5, DECIMAL(12,4)) ) + CONVERT(tran_100.valdh, DECIMAL(12,4)) AS saldo,
                        SUM( CONVERT(tran_100.valcosto, DECIMAL(12,4)) + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + CONVERT(tran_100.valtax2, DECIMAL(12,4)) + CONVERT(tran_100.valtax3, DECIMAL(12,4)) + CONVERT(tran_100.valtax4, DECIMAL(12,4)) + CONVERT(tran_100.valtax5, DECIMAL(12,4) ) + CONVERT(tran_100.valdh, DECIMAL(12,4))) AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor,
                        invsites.descrip as Sucursal,
                        (
                            CASE
                                WHEN ((inv_def.inopera = 1) AND (inv_def.agrupa = 'CO')) THEN 1
                                ELSE 0
                            END
                        ) as isnotacredito
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            INNER JOIN 
                        invsites ON invsites.idcentro = tran_100.idcentro
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'CO'
                            AND tran_100.estatus = 1
                            GROUP BY trannum
                            ORDER BY tran_100.fecha,tran_100.trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getInfoClienteCredito($idauxi, $idcredito, $ccestatus, $fechaini = 0, $fechafin = 0){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $whereFecha = "";
                if($fechaini != 0 && $fechafin != 0){
                    $whereFecha = " AND tran_100.fecha BETWEEN '$fechaini' AND '$fechafin'";
                }

                if($ccestatus == 1){
                    $ccestatus = '1 OR tran_100.ccestatus = 2';
                }
                
                $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                        tran_100.fecvence,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        SUM( tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 ) + tran_100.valdh AS saldo,
                        SUM( tran_100.valventan + CONVERT(CONVERT(tran_100.valtax1, DECIMAL(12,3)), DECIMAL(12,2)) + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 ) + tran_100.valdh AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor,
                        invsites.descrip as Sucursal,
                        (
                            CASE
                                WHEN ((inv_def.inopera = 1) AND (inv_def.agrupa = 'VN')) THEN 1
                                ELSE 0
                            END
                        ) as isnotacredito
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            INNER JOIN 
                        invsites ON invsites.idcentro = tran_100.idcentro
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'VN'
                            AND tran_100.estatus = 1
                            AND tran_100.numy = $idcredito
                            AND (tran_100.ccestatus = $ccestatus)
                            $whereFecha

                            GROUP BY trannum
                            ORDER BY tran_100.fecha,tran_100.trannum ASC";

               /* $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                        tran_100.fecvence,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        REPLACE( FORMAT( ROUND( SUM( tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 ) + tran_100.valdh, 2) ,2),',','') AS saldo,
                        REPLACE( FORMAT( ROUND( SUM( tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5 ) + tran_100.valdh, 2) ,2),',','') AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor,
                        invsites.descrip as Sucursal,
                        (
                            CASE
                                WHEN ((inv_def.inopera = 1) AND (inv_def.agrupa = 'VN')) THEN 1
                                ELSE 0
                            END
                        ) as isnotacredito
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                            INNER JOIN 
                        invsites ON invsites.idcentro = tran_100.idcentro
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'VN'
                            AND tran_100.estatus = 1
                            AND tran_100.numy = $idcredito
                            AND (tran_100.ccestatus = $ccestatus)
                            $whereFecha

                            GROUP BY trannum
                            ORDER BY tran_100.fecha,tran_100.trannum ASC";*/
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        
        #   GET DATA CXC
        public function getDataCxC($opc, $extra = null)
        {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            } else {
                /*$this->db_b->where('trannum', 2342);
                $this->db_b->update('tran_100', array('ccestatus' => 0));//*/
                switch ($opc) {
                    #   GET NOTAS DE CREDITOS ACTIVOS DE UN CLIENTE
                    case 0:
                        $where = [
                            '(a.estatus = 1)',
                            '(a.ccestatus = 0)',
                            '(b.agrupa = "VN")',
                            '(b.inopera = 1)',
                            '(a.idcps = '.$extra.')'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select("a.trannum, a.serie, a.numero, fecha");
                        $this->db_b->select("(a.valventan + a.valtax1 + a.valtax2 + a.valtax3 + a.valtax4 + a.valtax5 + a.valdh) as monto");
                        $this->db_b->from("tran_100 a");
                        $this->db_b->join("inv_def b", "a.idclase = b.invclase");
                        $this->db_b->where($where);
                        $this->db_b->order_by("a.fecha");
                        $datos = $this->db_b->get();
                    break;
                    #   GET FORMAS DE PAGO ABONO - CARGO
                    case 1:
                        $where = [
                            '(estatus = 1)',
                            '(agrupa = "CC")',
                            '((alcuadre = 1) OR (alcuadre = -1))'
                        ];
                        $where = implode(' AND ', $where);
                        $this->db_b->select("cajclase, descrip, alcuadre");
                        $this->db_b->from("caj_def");
                        $this->db_b->where($where);
                        $this->db_b->order_by("descrip");
                        $datos = $this->db_b->get();
                    break;
                    #   GET TRANSACCION SIMPLE
                    case 3:
                        $datos = $this->db_b->where("trannum", $extra)->get("tran_100")->row();
                    break;
                    #   GET FORMA DE PAGO SIMPLE
                    case 4:
                        $datos = $this->db_b->where("cajclase", $extra)->get("caj_def")->row();
                    break;
                    default:
                        $datos = false;
                    break;
                }
                return $datos;
            }
        }
        #   MULTIPLES OPCIONES CxC
        public function multiplesOpcionesCxC($opc, $extra = null)
        {
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            } else {
                switch ($opc) {
                    case 0:
                        $documento = $extra['documento'];
                        if ($this->db_b->insert('tran_100c', $extra['data'])) {
                            $consulta = "CALL totaliza100 (".$documento->trannum.", ".$documento->estatus.")";
                            $this->db_b->query($consulta);

                            $documentoupdate = $this->arap_model->getDataCxC(3, $documento->trannum);
                            $saldo = round($documentoupdate->valventan + $documentoupdate->valtax1 + $documentoupdate->valtax2 + $documentoupdate->valtax3 + $documentoupdate->valtax4 + $documentoupdate->valtax5 + $documentoupdate->valdh, 2);

                            if($saldo > 0) $estado = 0; # pendiente
                            else if($saldo == 0) $estado = 1; # cancelado
                            else $estado=2; # sobrepagado
                            $data = array(
                                'lines100c' => $documento->lines100c + 1,
                                'ccestatus' => $estado,
                                'whodidit' => (int)$this->session->userdata('iduser'),
                                'modifica' => date_create()->format('Y-m-d H:i:s'),
                            );
                            $this->db_b->where('trannum', $documento->trannum);
                            $this->db_b->update('tran_100', $data);

                            $dato = true;
                        } else $dato = false;
                    break;
                    case 1:#    BUSCAR TRANSACCION POR TRANNUM VN
                        $where = implode(' AND ', [
                            '(a.estatus = 1)',
                            '(c.agrupa = "VN")',
                            '(a.trannum = '.$extra.')',
                        ]);
                        $this->db_b->select('a.idcps');
                        $this->db_b->from('tran_100 a');
                        $this->db_b->join('ctauxi b', 'a.idcps = b.idauxi');
                        $this->db_b->join('inv_def c', 'a.idclase = c.invclase');
                        $this->db_b->where($where);
                        $dato = $this->db_b->get()->row();
                    break;
                    default:$dato = false;break;
                }
                return $dato;
            }
        }
        //20230620 EMGG se elimino el Where AND tran_100.ccestatus = 0 para que muestre las cuentas aun con saldo=0
        function getListProveedores(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('c.idauxi AS idproveedor, c.descrip AS proveedor, c.grupo, c.telefono, c.correo, c.nrc, c.nit');
                $this->db_b->select('c.estado, SUM((CONVERT(a.valcosto, DECIMAL(12,4)) + CONVERT(a.valtax1, DECIMAL(12, 4)) + CONVERT(a.valtax2, DECIMAL(12, 4)) + CONVERT(a.valtax3, DECIMAL(12, 4)) + CONVERT(a.valtax4, DECIMAL(12, 4)) + CONVERT(a.valtax5, DECIMAL(12, 4))) + CONVERT(a.valdh, DECIMAL(12,4))) AS saldo');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def b', 'b.invclase = a.idclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->where('agrupa', 'CO');
                $this->db_b->group_by('c.idauxi');
                $this->db_b->order_by('c.descrip', 'ASC');
                $query = $this->db_b->get();
                $resultado = $query->result();
                
                return $resultado;
            }
        }
        
        function getInfoProveedor($idauxi){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT 
                        ctauxi.idauxi,
                        ctauxi.descrip,
                        ctauxi.grupo,
                        ctauxi.dias,
                        ctauxi.limite,
                        tran_100.trannum,
                        tran_100.fecha,
                            DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fechaFormat,
                        tran_100.serie,
                        tran_100.numero,
                        tran_100.ccestatus,
                        DATEDIFF(NOW(), tran_100.fecha) AS dias,
                        (SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo,
                        (SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS val_fact,
                        IFNULL(ctauxi2.descrip, '') AS vendedor,
                        ctauxi.idcps as idvendedor
                    FROM
                        ctauxi
                            LEFT JOIN
                        ctauxi AS ctauxi2 ON ctauxi.idcps = ctauxi2.idauxi
                            INNER JOIN
                        tran_100 ON tran_100.idcps = ctauxi.idauxi
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                    WHERE
                        ctauxi.idauxi = $idauxi AND inv_def.agrupa = 'CO'
                            AND tran_100.estatus = 1
                            GROUP BY trannum
                            ORDER BY trannum ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detalle_cuenta_ar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  tran_100.trannum, tran_100.referencia, tran_100.idclase,  inv_def.descrip AS tipoDoc, tran_100.numero, tran_100.fecha AS fecha2,DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as cargos, (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+ tran_100.valdh ) as saldo
                FROM  tran_100  INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase  WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detailsTrans_ar2($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT tran_100c.idrec, tran_100c.idworker, tran_100c.cajclase, tran_100.trannum, tran_100c.itemline, DATE_FORMAT(tran_100c.fecha, '%m/%d/%Y') AS fecha, tran_100c.referencia, caj_def.descrip as formaPago,  tran_100c.descrip, (tran_100c.valor - tran_100c.vuelto) as valor, (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as saldo
                            FROM  tran_100c
                            INNER JOIN tran_100 ON tran_100.trannum= tran_100c.trannum
                            INNER JOIN  caj_def ON caj_def.cajclase= tran_100c.cajclase 
                            WHERE tran_100c.trannum = $trannum GROUP BY tran_100c.idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function detailsCuenta_ar2($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  tran_100.trannum, tran_100.referencia, tran_100.idclase,  inv_def.descrip AS tipoDoc, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as cargos, (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)+ tran_100.valdh ) as saldo
                FROM  tran_100  INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase  WHERE tran_100.trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function grupos_report(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  tran_100.idworker, ctauxi.descrip AS vendedor, (SELECT COUNT(aux.idauxi) FROM ctauxi AS aux  WHERE aux.idcps = ctauxi.idauxi) AS cant_cli FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi  ON tran_100.idworker = ctauxi.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus >= 1 GROUP BY tran_100.idworker ORDER BY cant_cli ASC limit 16";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        
        function getCant_Trans($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT 
                        tran_100.idcps,
                            SUM(IF((((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) >= 0) AND ((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) <= 30)),1,0)) AS tran_1_30,
                            SUM(IF((((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) >= 31) AND ((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) <= 60)),1,0)) AS tran_31_60,
                            SUM(IF((((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) >= 61) AND ((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) <= 90)),1,0)) AS tran_61_90,
                            SUM(IF((((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) >= 91) AND ((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) <= 120)),1,0)) AS tran_91_120,
                            SUM(IF(((TO_DAYS(NOW()) - TO_DAYS(tran_100.fecha)) >= 121),1,0)) AS tran_121
                        FROM
                            (((tran_100
                            JOIN inv_def ON ((inv_def.invclase = tran_100.idclase)))
                            JOIN ctauxi cliente ON ((tran_100.idcps = cliente.idauxi)))
                            JOIN ctauxi vendedor ON ((tran_100.idworker = vendedor.idauxi)))
                        WHERE
                            ((inv_def.agrupa = 'VN')
                                AND (tran_100.estatus = 1)
                                AND (tran_100.ccestatus <> 1)) AND tran_100.idcps = $idcps";
                $query = $this->db_b->query($consulta);
                $resultado = $query->row_array();
                return $resultado;
            }
        }
        
        function clientes_report(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idworker, vendedor,  idcliente, limite, cliente, nrc, SUM(sum_1_30) as 'sum_1_30',SUM(sum_31_60) as 'sum_31_60',SUM(sum_61_90) as 'sum_61_90',SUM(sum_91_120) as 'sum_91_120',SUM(sum_121) as 'sum_121'
                            FROM analisis_antiguedad 
                            GROUP BY idcliente,idworker ORDER BY vendedor, cliente ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function clientes_report_detallado(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM analisis_antiguedad ORDER BY vendedor, cliente ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_analisis_cxc(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcliente, cliente, SUM(round(sum_1_30,2)) as 'sum_1_30',SUM(round(sum_31_60,2)) as 'sum_31_60',SUM(round(sum_61_90,2)) as 'sum_61_90',SUM(round(sum_91_120,2)) as 'sum_91_120',SUM(round(sum_121,2)) as 'sum_121' FROM analisis_antiguedad GROUP BY idcliente;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function get_analisis_cxc_cliente($idcliente){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcliente, cliente, SUM(round(sum_1_30,2)) as 'sum_1_30',SUM(round(sum_31_60,2)) as 'sum_31_60',SUM(round(sum_61_90,2)) as 'sum_61_90',SUM(round(sum_91_120,2)) as 'sum_91_120',SUM(round(sum_121,2)) as 'sum_121' FROM analisis_antiguedad WHERE idcliente = $idcliente GROUP BY idcliente;";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function clientes_report_all(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcliente, limite, cliente, nrc, SUM(sum_1_30) as 'sum_1_30',SUM(sum_31_60) as 'sum_31_60',SUM(sum_61_90) as 'sum_61_90',SUM(sum_91_120) as 'sum_91_120',SUM(sum_121) as 'sum_121'
                            FROM analisis_antiguedad 
                            GROUP BY idcliente ORDER BY cliente ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function clientes_report_grupos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idcliente, limite, vendedor, cliente, nrc, grupo, SUM(sum_1_30) as 'sum_1_30',SUM(sum_31_60) as 'sum_31_60',SUM(sum_61_90) as 'sum_61_90',SUM(sum_91_120) as 'sum_91_120',SUM(sum_121) as 'sum_121'
                            FROM analisis_antiguedad 
                            GROUP BY idcliente ORDER BY cliente ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getListaPagos(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT orders_100.val_tot, orders_100.val_pro, orders_100.val_anti, orders_100.estatus,  orders_100.trannum, orders_100.agrupa,orders_100.fecha,orders_100.idcps, if(orders_100.fecact='0000-00-00', '-', orders_100.fecact) as fecact,orders_100.notas, ctauxi.descrip as banco, (SELECT IFNULL(SUM(precioneto),0) FROM orders_100k WHERE orders_100k.trannum=orders_100.trannum) AS valor FROM orders_100 INNER JOIN ctauxi ON ctauxi.idauxi=orders_100.idcps WHERE agrupa = 'CP' ORDER BY orders_100.trannum DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function actualiza_todos_trannum(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                
                $consulta = "SELECT trannum FROM  tran_100 WHERE (ccestatus=0 OR ccestatus=2) AND (idclase=5 OR idclase=2 OR idclase=3 OR idclase=30) group by trannum";
                $query = $this->db_b->query($consulta);
                $trannums = $query->result();
                $cant = 0;
                foreach($trannums as $tran){
                    $trannum = $tran->trannum;
            
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d H:i:s");
                    $consulta = "SELECT trannum, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo
                            FROM
                            tran_100 WHERE trannum=$trannum";
                    $query = $this->db_b->query($consulta);
                    $resultado = $query->row_array();
                    $saldo = $resultado['saldo'];
                    $saldo =  round($saldo, 2);
                    if($saldo==0){
                        $estado= 1;//cancelado
                        $cant++;
                    }else if($saldo>0){
                        $estado=0;//pendiente
                    }else if($saldo<0){
                        $estado=2;//sobrepagado
                    }
                    $this->db_b->set('ccestatus', $estado);
                    $this->db_b->set('modifica', $fecha_actual);
                    $this->db_b->where('trannum', $trannum);
                    $query = $this->db_b->update('tran_100');
                    $query = $this->db_b->query($consulta);
                }
                return $cant;

            }
        }
    
        function getBancosAgrupados(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT caj_def.cajclase,caj_def.descrip as forma_pago, ctauxi.idauxi, ctauxi.descrip, CONCAT(caj_def.cajclase,'_', ctauxi.idauxi) AS caj_idauxi, ctauxi.xpos AS auxi_xpos, caj_def.xpos AS caj_xpos FROM caj_def INNER JOIN ctauxi ON ctauxi.idauxidef = caj_def.xpos where caj_def.agrupa = 'CP' ORDER BY caj_def.cajclase asc";
                $query = $this->db_b->query($consulta);
                
                if($query->num_rows() >0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
                
            }
        }
        function getCuentasBancarias(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM ctauxi WHERE idauxidef=10";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function get_Bancos_Cheques(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT caj_def.cajclase,caj_def.descrip as forma_pago, ctauxi.idauxi, ctauxi.descrip, (SELECT count(orders_100.trannum) FROM orders_100 WHERE orders_100.agrupa='CP' AND orders_100.idcps=ctauxi.idauxi AND orders_100.estatus=1 ) as cantidad FROM caj_def INNER JOIN ctauxi ON ctauxi.idauxidef = caj_def.xpos where caj_def.agrupa = 'CP' ORDER BY caj_def.cajclase asc";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getChequesporBanco($num_cuenta){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                
                $consulta = "SELECT orders_100.trannum, orders_100.fecha,orders_100.fecact, orders_100a.descrip provee, orders_100a.tipo AS impreso, orders_100a.valor, orders_100a.notas FROM orders_100a INNER JOIN orders_100 ON orders_100.trannum = orders_100a.trannum WHERE orders_100a.agrupa = 'CP' AND orders_100.idcps = $num_cuenta ORDER BY orders_100a.idrec ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function getProveedores($idauxidef){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                
                $idauxiliares = str_replace(',', ' OR idauxidef =', $idauxidef);

                $consulta = "SELECT idauxi, descrip FROM ctauxi WHERE ( idauxidef = $idauxiliares ) AND estado = 1 ORDER BY descrip ASC";
                $query = $this->db_b->query($consulta);
                
                if ($query->num_rows() > 0) {
                    return $query->result();
                } else return false;
            }
        }
        
        function insert_Pago($fecha, $caj_cuenta, $formaPago, $inicial, /*$limite,*/ $notas, $estatus){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $idcentro = $this->session->userdata('idcentrouser');

                $div = explode("_", $caj_cuenta);
                $cajclase = $div[0];
                $num_cuenta = $div[1];
                
                $this->db_b->set('trannum', 0);
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('cajclase', $cajclase);
                $this->db_b->set('idcps', $num_cuenta);
                $this->db_b->set('agrupa', "CP");
                $this->db_b->set('val_anti', $inicial);
                //$this->db_b->set('val_pro', $limite);
                $this->db_b->set('dev_place', $formaPago);
                $this->db_b->set('estatus', $estatus);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');
                return $query;
            }  
        }

        //--------------------------------------------------
        function getListProveedoresNew(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('c.idauxi AS idproveedor, c.descrip AS proveedor, c.grupo, c.telefono, c.correo, c.nrc, c.nit');
                $this->db_b->select('c.estado, SUM(CONVERT(a.valventan, DECIMAL(12,4)) + (CONVERT(a.valcosto, DECIMAL(12,4)) + CONVERT(a.valtax1, DECIMAL(12, 4)) + CONVERT(a.valtax2, DECIMAL(12, 4)) + CONVERT(a.valtax3, DECIMAL(12, 4)) + CONVERT(a.valtax4, DECIMAL(12, 4)) + CONVERT(a.valtax5, DECIMAL(12, 4))) + CONVERT(a.valdh, DECIMAL(12,4))) AS saldo');
                $this->db_b->from('tran_100 a');
                $this->db_b->join('inv_def b', 'b.invclase = a.idclase');
                $this->db_b->join('ctauxi  c', 'a.idcps = c.idauxi');
                $this->db_b->where('agrupa', 'CO');
                $this->db_b->where('a.estatus !=', ' 9');
                $this->db_b->where('a.ccestatus !=', ' 1');
                $this->db_b->group_by('c.descrip');
                $this->db_b->order_by('c.descrip', 'ASC');
                $this->db_b->having('saldo >', 0);
                $query = $this->db_b->get();
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getDocsProveedor($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('tran_100.trannum, tran_100.ccestatus, tran_100.estatus, CONCAT(tran_100.serie, tran_100.numero) AS s_n, tran_100.referencia, tran_100.idcps AS codigo, ctauxi.descrip AS cliente, ctauxi.nit, ctauxi.dui, ctauxi.nrc, tran_100.valcosto,
                tran_100.valtax1, tran_100.valdh, inv_def.descrip AS tipoDoc, tran_100.numero, DATE_FORMAT(tran_100.fecha, "%d/%m/%Y") AS fecha,
                (SUM(CONVERT(tran_100.valventan, DECIMAL(12,4)) + CONVERT(tran_100.valcosto, DECIMAL(12,4)) + CONVERT(tran_100.valtax1, DECIMAL(12,4)) + CONVERT(tran_100.valtax2, DECIMAL(12,4)) + CONVERT(tran_100.valtax3, DECIMAL(12,4)) + CONVERT(tran_100.valtax4, DECIMAL(12,4)) + CONVERT(tran_100.valtax5, DECIMAL(12,4))) + CONVERT(tran_100.valdh, DECIMAL(12, 4))) AS saldoPendiente,
                IF(EXISTS (SELECT 1 FROM orders_100k WHERE orders_100k.idbatch = tran_100.trannum LIMIT 1), 1, 0) AS existe');
                $this->db_b->from('tran_100');
                $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase');
                $this->db_b->join('ctauxi', 'tran_100.idcps = ctauxi.idauxi');
                $this->db_b->where('inv_def.agrupa', 'CO');
                $this->db_b->where('tran_100.estatus !=', 9);
                $this->db_b->where('tran_100.idcps', $idcps);
                $this->db_b->where('tran_100.ccestatus !=', 1);
                $this->db_b->group_by('tran_100.trannum');
                $this->db_b->having('existe', 0);
                $this->db_b->having('saldoPendiente >', 0);

                $query = $this->db_b->get();
                $result = $query->result();

                return $result;
            }
        }

        function getDocsInPaymentProcess ($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->query('SET @rowNumb = 0');
                $this->db_b->select('orders_100k.idrec, orders_100k.trannum, orders_100k.idbatch, orders_100k.descrip, orders_100k.precioneto, orders_100k.notas, CONCAT(tran_100.serie,tran_100.numero) AS s_n, ctauxi.idauxi, ctauxi.descrip, ctauxi.nit, ctauxi.dui, ctauxi.nrc, DATE_FORMAT(tran_100.fecha, "%d/%m/%Y") AS fechaEmi, DATE_FORMAT(tran_100.fecvence, "%d/%m/%Y") AS fechaVence, (@rowNumb:=@rowNumb + 1) AS numLinea', FALSE);
                $this->db_b->from('orders_100k');
                $this->db_b->join('tran_100', 'orders_100k.idbatch = tran_100.trannum');
                $this->db_b->join('ctauxi', 'tran_100.idcps = ctauxi.idauxi');
                $this->db_b->where('orders_100k.trannum', $trannum);
                $this->db_b->order_by('orders_100k.idrec', 'ASC');

                $query = $this->db_b->get();
                $resultado = $query->result();

                return $resultado;
            }
        }

        function getSpecificDoc($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $consulta = "SELECT tran_100.trannum,tran_100.ccestatus, tran_100.estatus, tran_100k.tax1, CONCAT(tran_100.serie,tran_100.numero) AS s_n, tran_100.referencia, tran_100.idcps AS codigo, 
                ctauxi.descrip AS cliente, ctauxi.nit, ctauxi.dui, ctauxi.nrc, tran_100.valcosto,tran_100.valtax1,tran_100.valdh, inv_def.descrip AS tipoDoc, tran_100.numero, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                (SUM(CONVERT(tran_100.valventan, DECIMAL(12,4))+CONVERT(tran_100.valcosto, DECIMAL(12,4))+CONVERT(tran_100.valtax1, DECIMAL(12,4))+ CONVERT(tran_100.valtax2, DECIMAL(12,4))+CONVERT(tran_100.valtax3, DECIMAL(12,4))+CONVERT(tran_100.valtax4, DECIMAL(12,4))+ CONVERT(tran_100.valtax5, DECIMAL(12,4))) + CONVERT(tran_100.valdh, DECIMAL(12, 4))) AS saldoPendiente,
                IF((SELECT idbatch FROM orders_100k WHERE orders_100k.idbatch = tran_100.trannum), 1, 0) AS existe
                FROM tran_100
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi
                INNER JOIN tran_100k ON tran_100k.trannum = tran_100.trannum
                WHERE inv_def.agrupa = 'CO' AND tran_100.estatus != 9 and tran_100.ccestatus != 1 AND tran_100.trannum = $trannum
                GROUP BY tran_100.trannum
                HAVING existe = 0";

                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }

        function setDocumentInPaymentProcess($docTrannum, $orderTrannum, $descrip, $precioN, $notas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $data = array(
                    'trannum' => $orderTrannum,
                    'idbatch' => $docTrannum,
                    'descrip' => $descrip,
                    'precioneto' => $precioN,
                    'notas' => $notas
                );

                $this->db_b->set($data);
                $query = $this->db_b->insert('orders_100k');
                return $query;
            }
        }

        function deleteDocInPaymentProcess($idrec){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->where('idrec', $idrec);
                $query = $this->db_b->delete('orders_100k');

                return $query;
            }
        }

        function changeOrderStatus($trannum, $status){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->set('estatus', $status);
                $this->db_b->where('trannum', $trannum);
                $resultado = $this->db_b->update('orders_100');

                return $resultado;
            }
        }
        //--------------------------------------------------

        function getInfoOrdenNew($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT orders_100.estatus, orders_100.trannum, orders_100.agrupa, orders_100.fecha, orders_100.idcps, if(orders_100.fecact='0000-00-00', '-', orders_100.fecact) as fecact, orders_100.notas, ctauxi.descrip as banco, ctauxi.xpos, orders_100.dev_place as formaPago FROM orders_100 INNER JOIN ctauxi ON ctauxi.idauxi=orders_100.idcps WHERE agrupa = 'CP' AND trannum = $trannum";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() > 0){
                    $resultado = $query->result();
                    $estatus = "";
                    $formaPago = "";
                    foreach($resultado as $res){
                        if($res->estatus == 0){
                            $estatus = 'En Elaboracion';
                        }else if($res->estatus == 1){
                            $estatus = 'En Autorización';
                        }else if($res->estatus == 2){
                            $estatus = 'Autorizado';
                        }else if($res->estatus == 9){
                            $estatus = 'Anulada';
                        }

                        if($res->formaPago == 0 ){
                            $formaPago = 'Cheque';
                        }else{
                            $formaPago = 'Transferencia Bancaria';
                        }

                        $info = new stdClass();
                        $info->trannum = $res->trannum;
                        $info->agrupa = $res->agrupa;
                        $info->fecha = $res->fecha;
                        $info->idcps = $res->idcps;
                        $info->fecact = $res->fecact;
                        $info->estatus = $estatus;
                        $info->status = $res->estatus;
                        $info->banco = $res->banco;
                        $info->formaPago = $formaPago;
                        $info->notas = $res->notas;
                        $info->xpos = $res->xpos;
                    }
                    return $info;
                }else{
                    return $resultado;
                }
            }
        }
        
        function getInfoOrden($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT  orders_100.trannum,orders_100.estatus, orders_100.agrupa,date_format(orders_100.fecha, '%d/%m/%Y') as fecha, orders_100.idcps, if(orders_100.fecact='0000-00-00', '-', date_format(orders_100.fecact, '%d/%m/%Y')) as fecact,orders_100.notas, ctauxi.descrip as banco, orders_100.val_tot, orders_100.val_pro, orders_100.val_anti FROM orders_100 INNER JOIN ctauxi ON ctauxi.idauxi=orders_100.idcps WHERE agrupa = 'CP' AND trannum =$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getEstatusOrden($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM tran_100 WHERE tran_100.trannum=$trannum";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function insertOrdenPago($trannum, $orden, $valor){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $consulta = "SELECT idrec, precioneto FROM orders_100k WHERE trannum=$trannum AND idbatch=$orden and um!=1";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->row_array();
                    $idrec = $resultado['idrec'];
                    $precioneto = $resultado['precioneto'];
                    $valor_save = $valor+$precioneto;
                    $this->db_b->set('precioneto', $valor_save);
                    $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->where('idrec', $idrec);
                    $query = $this->db_b->update('orders_100k');
                    return $query;
                }else{
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('idbatch', $orden);
                    $this->db_b->set('precioneto', $valor);
                    $this->db_b->set('descrip', "CP");
                    $this->db_b->set('notas', "PAGO A PROVEEDORES");
                    $this->db_b->set('um', "0");
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('orders_100k');
                    return $query;
            }
            }
        }
        
        function getPagosProveedores($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT SUM(orders_100k.precioneto) AS valor,  orders_100.val_pro as limite, COUNT(orders_100k.idrec) as cantidad, tran_100.idcps, ctauxi.descrip as proveedor FROM orders_100k inner join orders_100 ON orders_100.trannum=orders_100k.trannum inner join tran_100 ON tran_100.trannum = orders_100k.idbatch INNER JOIN ctauxi ON ctauxi.idauxi= tran_100.idcps where orders_100k.trannum=$trannum GROUP By tran_100.idcps ORDER BY ctauxi.descrip ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getPagosxProveedor($trannum, $idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT orders_100k.idrec, orders_100k.precioneto as abono,(SUM(tran_100.valventan+tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5) + tran_100.valdh) as saldo, tran_100.trannum, CONCAT (tran_100.serie,tran_100.numero) AS numero_serie, tran_100.fecha, DATEDIFF(now(),tran_100.fecha) as dias FROM orders_100k INNER JOIN tran_100 ON tran_100.trannum = orders_100k.idbatch WHERE orders_100k.trannum = $trannum AND idcps = $idcps GROUP BY orders_100k.idrec ORDER BY orders_100k.idrec ASC";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->result();
                    return $resultado;
                }else{
                    return false;
                }
            }
        }
        
        function getpagosAbiertos($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT IFNULL(SUM(precioneto),0) as pendiente FROM orders_100k INNER JOIN orders_100 ON orders_100.trannum=orders_100k.trannum where orders_100k.idbatch=$trannum AND orders_100.estatus=0";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->row_array();
                    return $resultado['pendiente'];
                }else{
                    return 0;
                }
            }
        }
        function deletePagoProveedor($idrec){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
                }else{ 
                    $consulta = "DELETE FROM orders_100k WHERE idrec = $idrec";
                    $query = $this->db_b->query($consulta);
                    return $query;
            }
        }
        function insert_cheques($trannum,$array_cheques){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $cadena_proveedores =array();
                foreach($array_cheques as $array){
                    $cadena_proveedores[$array->num_provee]  = $array->idproveedor. "-";
                }
                foreach($array_cheques as $array){
                    $this->db_b->set('idrec', 0);
                    $this->db_b->set('trannum', $trannum);
                    $this->db_b->set('descrip', $array->proveedor);
                    $this->db_b->set('agrupa', 'CP');
                    $this->db_b->set('tipo', 0);
                    $this->db_b->set('valor', round($array->valor,2));
                    $this->db_b->set('notas', $array->num_cheque);
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $query = $this->db_b->insert('orders_100a');
                    $cadena_proveedores[$array->num_provee]  =  $cadena_proveedores[$array->num_provee] . $array->num_cheque.",";
                }
                $last = -1;
                foreach($array_cheques as $array){
                    if($last!=$array->num_provee){
                        $cadena_proveedores[$array->num_provee]  = substr($cadena_proveedores[$array->num_provee] , 0,-1);
                    }
                    $last = $array->num_provee;
                }
                $ingresa = 0;
                $consulta = "SELECT orders_100k.idrec,orders_100k.precioneto, tran_100.trannum,tran_100.idcps,orders_100.cajclase,orders_100.idcps as num_cuenta FROM orders_100k inner join orders_100 on orders_100.trannum=orders_100k.trannum inner join tran_100 on tran_100.trannum = orders_100k.idbatch WHERE orders_100k.trannum=$trannum AND orders_100k.descrip='CP'";
                $query = $this->db_b->query($consulta);
                if($query->num_rows() >0){
                    $resultado = $query->result();
                    foreach($resultado as $result){
                        foreach($cadena_proveedores as $item){
                            $div = explode("-", $item);
                            $idprovee = $div[0];
                            $lista_cheques = $div[1];
                            if($idprovee == $result->idcps){
                                
                                $consulta2 = "SELECT alcuadre FROM caj_def WHERE cajclase=$result->cajclase";
                                $query2 = $this->db_b->query($consulta2);
                                $resultado2 = $query2->row_array();
                                $alcuadre  = $resultado2['alcuadre'];
                                $valor = $alcuadre * $result->precioneto;
                                
                                $this->db_b->set('idrec', 0);
                                $this->db_b->set('trannum', $result->trannum);
                                $this->db_b->set('cajclase', $result->cajclase);
                                $this->db_b->set('idctcuenta', $result->num_cuenta);
                                $this->db_b->set('fecha', $date->format('Y-m-d'));
                                $this->db_b->set('descrip', 'Pago a proveedores');
                                $this->db_b->set('referencia',$lista_cheques);
                                $this->db_b->set('valor', round($valor,2));
                                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                                $query = $this->db_b->insert('tran_100c');
                                $ingresa++;
                                $consulta = "CALL totaliza100 ($result->trannum, 1)";
                                $query = $this->db_b->query($consulta);
                            }
                        }
                    }
                    
                }
                if($ingresa>0){
                    //ACTUALIZA CADA ORDERS_100K
                    $consulta = "SELECT idrec FROM orders_100k WHERE trannum=$trannum";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        foreach($resultado as $act){
                            $this->db_b->set('um', "1");
                            $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                            $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                            $this->db_b->where('idrec', $act->idrec);
                            $query = $this->db_b->update('orders_100k');
                        }
                    }
                    //ACTUALIZA LOTE DE PAGO
                    
                    $this->db_b->set('estatus', "1");
                    $this->db_b->set('fecact', $date->format('Y-m-d'));
                    $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                    $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                    $this->db_b->where('trannum', $trannum);
                    $query = $this->db_b->update('orders_100');
                    return $query;
                }else{
                return $cadena_proveedores;
                }
            }
        }
        
        function getBalanceCartera($fechaini, $fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);
                $data = $this->db_b->get();
                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;
                    //$this->highlight_array(["ini"=>$fechaini, "fin"=>$fechafin, "clase"=>$cajclase]);
                    $consulta = "SELECT tran_100_principal.idcps, ctauxi.descrip,
                    IFNULL((SELECT SUM(t100.valventan + t100.valtax1) FROM tran_100 as t100 WHERE t100.fecha < '$fechaini' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS saldo_anterior,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN tran_100 as t100 ON t100.trannum=tran_100c.trannum WHERE tran_100c.fecha < '$fechaini' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS pagosFacturas,
                    IFNULL((SELECT SUM(t100.valventan + t100.valtax1) FROM tran_100 AS t100 INNER JOIN inv_def as invdef ON invdef.invclase = t100.idclase WHERE t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase AND invdef.agrupa='VN' AND  t100.estatus=1), 0) AS ventas_periodo,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS abonos, 
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha<'$fechaini' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS last_abono,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS actual_abono,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha<'$fechaini'  AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS last_cargo,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS actual_cargo, 
                    (SELECT COUNT(t.trannum) FROM tran_100 t WHERE t.idcps=ctauxi.idauxi AND t.numy = $cajclase) AS Hits
                    FROM tran_100 AS tran_100_principal
                    INNER JOIN ctauxi ON ctauxi.idauxi = tran_100_principal.idcps INNER JOIN inv_def ON inv_def.invclase = tran_100_principal.idclase
                    WHERE inv_def.agrupa='VN' GROUP BY tran_100_principal.idcps HAVING Hits > 0 ORDER BY ctauxi.descrip";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return false;
                    }
                } else return false;
            }
        }
    
        function getMovCliente($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);
                $data = $this->db_b->get();
                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;
                    $consulta = "
                    SELECT  CONCAT(tran_100.serie,tran_100.numero) AS numeroserie, tran_100.fecha,tran_100.trannum, tran_100.referencia, inv_def.descrip as descrip, SUM(tran_100.valventan+tran_100.valtax1) as valor, tran_100.ingresa
                    FROM tran_100
                    INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                    WHERE inv_def.agrupa='VN' AND tran_100.idcps = $idcps AND tran_100.numy = $cajclase GROUP BY tran_100.trannum ORDER BY tran_100.fecha, tran_100.ingresa ASC";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return false;
                    }
                } else return false;                
            }
        }
        function getAbonosCargosCliente($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);
                $data = $this->db_b->get();
                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;
                    $consulta = "
                    SELECT  CONCAT(tran_100.serie,tran_100.numero) AS numeroserie, tran_100c.ingresa,  tran_100c.trannum, SUM(tran_100c.valor - tran_100c.vuelto) AS valor, tran_100c.descrip, tran_100c.fecha, tran_100c.referencia FROM tran_100c
                    INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum
                    INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase 
                    WHERE tran_100.estatus != 9 AND tran_100.idcps = $idcps AND tran_100.numy = $cajclase 
                    GROUP BY tran_100c.idrec ORDER BY tran_100c.fecha,tran_100c.ingresa ASC";
                    $query = $this->db_b->query($consulta);
                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return false;
                    }
                } else return false;
            }
        }
        
        
        function getEstadoCuenta($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100.trannum, tran_100.numero, tran_100.serie, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fecha, DATEDIFF(NOW(), tran_100.fecha) AS dias, inv_def.descrip as tipoDoc, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo,(SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5)) AS saldoInicial FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'VN' AND tran_100.estatus != 9 AND tran_100.idcps = $idcps AND tran_100.ccestatus!=1 GROUP BY tran_100.trannum ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getPagosSucursal($idcentro, $formas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $where = "";
                if($formas!=""){
                    $array = explode(",", $formas);  
                    $cant = count($array);
                    for($i=0; $i<$cant; $i++){
                        $caj_clase = $array[$i];
                        $where.=" tran_100c.cajclase = ".$caj_clase." OR ";
                    }
                    
                    $where = substr($where, 0, -3);
                }else{
                    $where = "1=1";
                }
                
                
                $consulta ="SELECT tran_100c.idrec, tran_100.trannum, date_format(tran_100c.fecha, '%d/%m/%Y') as fechaFormat, tran_100c.fecha, ABS(tran_100c.valor) AS valor, CONCAT(date_format(tran_100c.fecha, '%d/%m/%Y'), ' ', ABS(tran_100c.valor), ' ', ctauxi.descrip) AS fechaMontoCliente, caj_def.descrip as tipoTran, ctauxi.descrip as cliente, tran_100c.descrip as descripAbono  FROM tran_100c INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum INNER JOIN ctauxi ON ctauxi.idauxi = tran_100.idcps INNER JOIN caj_def ON caj_def.cajclase = tran_100c.cajclase WHERE tran_100c.idctcuenta = 0 AND tran_100.idcentro =$idcentro AND($where) ORDER BY tran_100c.fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getDepositos($idcentro){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT orders_100.trannum, orders_100.notas, orders_100.idcentro,if(orders_100.fecha='0000-00-00', '-', orders_100.fecha) as fecha,if(orders_100.fecact='0000-00-00', '-', orders_100.fecact) as fecact,orders_100.descrip,orders_100.idcps,orders_100.estatus, abs(orders_100.val_tot) as val_tot , abs(orders_100.val_anti) as val_anti  FROM orders_100  WHERE  orders_100.idcentro =$idcentro AND agrupa = 'DB' ORDER BY fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function insertDepositoBancario($idsucursal,$fecha,$banco,$notas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idsucursal);
                $this->db_b->set('agrupa', "DB");
                $this->db_b->set('fecha', $fecha);
                $this->db_b->set('descrip', $notas);
                $this->db_b->set('idcps', $banco);
                $this->db_b->set('estatus', 0);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');
                $trannum = $this->db_b->insert_id();
                return $trannum;
            }
        }

        function getEstadoCuentaPorPagar($idcps){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100.trannum, tran_100.numero, tran_100.serie, DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') as fecha, DATEDIFF(NOW(), tran_100.fecha) AS dias, inv_def.descrip as tipoDoc, (SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo,(SUM(tran_100.valcosto + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5)) AS saldoInicial FROM tran_100 INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi WHERE inv_def.agrupa = 'CO' AND tran_100.estatus = 1 AND tran_100.idcps = $idcps AND tran_100.ccestatus!=1 GROUP BY tran_100.trannum ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        
        }
        function getAbonosCunetasPorPagar($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100c.idrec, tran_100c.idworker, tran_100c.cajclase, tran_100.trannum, tran_100c.itemline,
                            DATE_FORMAT(tran_100c.fecha, '%m/%d/%Y') AS fecha, tran_100c.referencia, caj_def.descrip as formaPago, 
                            tran_100c.descrip, (tran_100c.valor - tran_100c.vuelto) as valor, 
                            (SUM(tran_100.valcosto+tran_100.valtax1+tran_100.valtax2+tran_100.valtax3+tran_100.valtax4+tran_100.valtax5)) as saldo
                            FROM  tran_100c
                            INNER JOIN tran_100 ON tran_100.trannum= tran_100c.trannum
                            INNER JOIN  caj_def ON caj_def.cajclase= tran_100c.cajclase 
                            WHERE tran_100c.trannum = $trannum GROUP BY tran_100c.idrec";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getInfoDeposito($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT orders_100.trannum, orders_100.idcentro,if(orders_100.fecha='0000-00-00', '-', date_format(orders_100.fecha, '%d/%m/%Y')) as fecha,if(orders_100.fecact='0000-00-00', '-', date_format(orders_100.fecact, '%d/%m/%Y')) as fecact, orders_100.descrip, orders_100.idcps, orders_100.estatus, orders_100.val_tot, orders_100.val_tot, orders_100.val_anti,ctauxi.descrip as banco FROM orders_100 INNER JOIN ctauxi ON ctauxi.idauxi=orders_100.idcps WHERE  orders_100.trannum =$trannum";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        
        function getFacturasDeposito($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT tran_100c.idrec, inv_def.descrip AS tipoDocumento, tran_100.trannum, tran_100.serie, tran_100.numero, tran_100c.fecha as fechatran, date_format(tran_100c.fecha, '%d/%m/%Y') as fecha, ABS(tran_100c.valor) AS valor, caj_def.cajclase, caj_def.descrip as tipoTran, ctauxi.descrip as cliente, tran_100c.descrip as descripAbono 
                FROM tran_100c 
                INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum 
                INNER JOIN inv_def  ON tran_100.idclase = inv_def.invclase
                INNER JOIN ctauxi   ON ctauxi.idauxi = tran_100.idcps 
                INNER JOIN caj_def  ON caj_def.cajclase = tran_100c.cajclase 
                WHERE tran_100c.idctcuenta = $trannum 
                ORDER BY tran_100c.fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }

        function getTiposFacturasDeposito($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta ="SELECT DISTINCT caj_def.cajclase, caj_def.descrip as tipoTran 
                FROM tran_100c 
                INNER JOIN caj_def  ON caj_def.cajclase = tran_100c.cajclase 
                WHERE tran_100c.idctcuenta = $trannum 
                ORDER BY tran_100c.fecha DESC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                
                return $resultado;
            }
        }
         
         function getSaldoDeposito($trannum){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{ 
                 $consulta ="SELECT  val_tot, val_anti  FROM orders_100 WHERE trannum=$trannum";
                 $query = $this->db_b->query($consulta);
                 $result = $query->row_array();
                 $saldo = abs($result['val_tot'])-abs($result['val_anti']);
                 return $saldo;
             }
         }
         
         function insertPagoToDeposito($idrec, $trannum){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{
                 
                 date_default_timezone_set('America/El_Salvador');
                 $date = new DateTime();
                 $this->db_b->set('idctcuenta', $trannum);
                 $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                 $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                 $this->db_b->where('idrec', $idrec);
                 $query = $this->db_b->update('tran_100c');
                 $consulta ="SELECT  notas  FROM orders_100 WHERE orders_100.trannum =$trannum";
                 $query = $this->db_b->query($consulta);
                 $cadena_ingresados = $query->row_array();
                 $idrecs  = $cadena_ingresados['notas']. $idrec . ",";
                 
                 $consulta ="SELECT  SUM(valor)  AS suma FROM tran_100c WHERE idctcuenta =$trannum";
                 $query = $this->db_b->query($consulta);
                 $result = $query->row_array();
                 $suma  = $result['suma'];
                 
                 $this->db_b->set('notas', $idrecs);
                 $this->db_b->set('val_tot', $suma);
                 $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                 $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                 $this->db_b->where('trannum', $trannum);
                 $query = $this->db_b->update('orders_100');
             }
         }
         
         function all_fact($idsucursal, $trannum,$formas){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{
                 
                 
                 $where = "";
                if($formas!=""){
                    $array = explode(",", $formas);  
                    $cant = count($array);
                    for($i=0; $i<$cant; $i++){
                        $caj_clase = $array[$i];
                        $where.=" tran_100c.cajclase = ".$caj_clase." OR ";
                    }
                    
                    $where = substr($where, 0, -3);
                }else{
                    $where = "1=1";
                }
                
                 
                 
                 date_default_timezone_set('America/El_Salvador');
                 $date = new DateTime();
                 $consulta ="SELECT tran_100c.idrec  FROM tran_100c INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum WHERE tran_100c.idctcuenta = 0 AND tran_100.idcentro =$idsucursal AND ($where) ORDER BY tran_100c.fecha DESC";
                 $query = $this->db_b->query($consulta);
                 if($query->num_rows()>0){
                     $facturas = $query->result();
                     foreach($facturas as $fact){
                         $idrec  = $fact->idrec;
                         $this->db_b->set('idctcuenta', $trannum);
                         $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                         $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                         $this->db_b->where('idrec', $idrec);
                         $query = $this->db_b->update('tran_100c');
                         $consulta ="SELECT  notas  FROM orders_100 WHERE orders_100.trannum =$trannum";
                         $query = $this->db_b->query($consulta);
                         $cadena_ingresados = $query->row_array();
                         $idrecs  = $cadena_ingresados['notas']. $idrec . ",";

                         $consulta ="SELECT  SUM(valor)  AS suma FROM tran_100c WHERE idctcuenta =$trannum";
                         $query = $this->db_b->query($consulta);
                         $result = $query->row_array();
                         $suma  = $result['suma'];

                         $this->db_b->set('notas', $idrecs);
                         $this->db_b->set('val_tot', $suma);
                         $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                         $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                         $this->db_b->where('trannum', $trannum);
                         $query = $this->db_b->update('orders_100');
                     }
                 }
                 return 1;    
             }
         }
         
         function regresar_all_fact($idsucursal, $trannum,$formas){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{
                 date_default_timezone_set('America/El_Salvador');
                 $date = new DateTime();
                 $consulta ="SELECT tran_100c.idrec  FROM tran_100c WHERE tran_100c.idctcuenta = $trannum";
                 $query = $this->db_b->query($consulta);
                 if($query->num_rows()>0){
                     $facturas = $query->result();
                     foreach($facturas as $fact){
                         $idrec  = $fact->idrec;
                         $this->db_b->set('idctcuenta', 0);
                         $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                         $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                         $this->db_b->where('idrec', $idrec);
                         $query = $this->db_b->update('tran_100c');
                     }
                     $consulta ="SELECT  SUM(valor)  AS suma FROM tran_100c WHERE idctcuenta =$trannum";
                     $query = $this->db_b->query($consulta);
                     $result = $query->row_array();
                     $suma  = $result['suma'];      

                     $this->db_b->set('notas', "");
                     $this->db_b->set('val_tot', $suma);
                     $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                     $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                     $this->db_b->where('trannum', $trannum);
                     $query = $this->db_b->update('orders_100');
                 }
                 return 1;    
             }
         }
         
         function removePagoToDeposito($idrec, $trannum){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{
                 
                 date_default_timezone_set('America/El_Salvador');
                 $date = new DateTime();
                 $this->db_b->set('idctcuenta', 0);
                 $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                 $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                 $this->db_b->where('idrec', $idrec);
                 $query = $this->db_b->update('tran_100c');
                 
                 $consulta ="SELECT  notas  FROM orders_100 WHERE orders_100.trannum =$trannum";
                 $query = $this->db_b->query($consulta);
                 $cadena_ingresados = $query->row_array();
                 $idrecs  = $cadena_ingresados['notas'];
                 
                 $consulta ="SELECT  SUM(valor)  AS suma FROM tran_100c WHERE idctcuenta =$trannum";
                 $query = $this->db_b->query($consulta);
                 $result = $query->row_array();
                 $suma  = $result['suma'];
                 
                 $idrecs = str_replace($idrec.",", "", $idrecs);
                 $this->db_b->set('notas', $idrecs);
                 $this->db_b->set('val_tot', $suma);
                 $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                 $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                 $this->db_b->where('trannum', $trannum);
                 $query = $this->db_b->update('orders_100');
             }
         }
         function close_deposito($trannum, $gastos, $notas){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{
                 
                 date_default_timezone_set('America/El_Salvador');
                 $date = new DateTime();
                 
                 $this->db_b->set('estatus', 1);
                 $this->db_b->set('val_anti', $gastos);
                 $this->db_b->set('descrip', $notas);
                 $this->db_b->set('fecact', $date->format('Y-m-d'));
                 $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                 $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                 $this->db_b->where('trannum', $trannum);
                 $query = $this->db_b->update('orders_100');
             }
         }
         
         function checkAbonoDeposito($idrec){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{ 
                 $consulta ="SELECT idctcuenta  FROM tran_100c  WHERE tran_100c.idrec=$idrec";
                 $query = $this->db_b->query($consulta);
                 $resultado = $query->row_array();
                 return $resultado['idctcuenta'];
             }
         }
         
         function getFormatoComprobante($idrec){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                 redirect('login/cerrar_sesion');
             }else{ 
                 $SQLCajclase = "SELECT cajclase FROM tran_100c WHERE idrec = $idrec";
                 $Querycaj = $this->db_b->query($SQLCajclase);
                 $info = $Querycaj->row_array();
                 $cajclase = $info['cajclase'];
                 
                 $SQLFormn = "SELECT formname FROM gforms WHERE notas = 'CC$cajclase'";
                 $Queryform = $this->db_b->query($SQLFormn);
                 
                 if($Queryform->num_rows()> 0){
                     $infoForm = $Queryform->row_array();
                     $nameFormato = $infoForm['formname'];
                 }else{
                     $nameFormato = 'impresionComprobanteAbono';
                 }
                 
                 return $nameFormato;
             }
         }
         
         
         function deleteAbonoTran100c($idrec,$trannum){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
             }else{ 
                 $consulta = "DELETE FROM tran_100c WHERE idrec = $idrec";
                 $query = $this->db_b->query($consulta);
                 
                 $consulta = "CALL totaliza100 ($trannum, 1)";
                 $query = $this->db_b->query($consulta);
                 return $query;
            }
         }
         function getPagosRecuperacion($sucursal, $fechaini, $fechafin){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
             }else{ 
                 $consulta = "SELECT ctauxi.descrip as cliente, tran_100c.valor,  tran_100c.fecha, tran_100c.descrip as banco, tran_100c.referencia, tran_100.numero,tran_100.serie, tran_100c.cajclase FROM tran_100c INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum INNER JOIN ctauxi ON ctauxi.idauxi =  tran_100.idcps WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND tran_100.idcentro=$sucursal AND tran_100.estatus=1";
                 $query = $this->db_b->query($consulta);
                 $resultado = $query->result();
                 return $resultado;
            }
         }
         function getFormasPagosRecuperacion($sucursal, $fechaini, $fechafin){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
             }else{ 
                 $consulta = "SELECT  caj_def.descrip, caj_def.cajclase FROM  tran_100c INNER JOIN  tran_100 ON tran_100.trannum = tran_100c.trannum INNER JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND tran_100.idcentro=$sucursal AND tran_100.estatus=1 AND caj_def.agrupa='CC' GROUP BY tran_100c.cajclase ORDER BY caj_def.descrip ASC";
                 $query = $this->db_b->query($consulta);
                 $resultado = $query->result();
                 return $resultado;
            }
         }
         function getRemesasInfo($sucursal, $fechaini, $fechafin){
             if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
             }else{ 
                 $consulta = "SELECT 
                        caj_def.descrip AS formaPago,
                        Bank.descrip AS bancoName,
                        tran_100c.referencia AS referenciaTran,
                        tran_100c.descrip AS descripTran,
                        tran_100c.fecha AS fechaCobro,
                        inv_def.descrip AS tipoDoc,
                        CONCAT(tran_100.serie, tran_100.numero) AS numeroDoc,
                        tran_100.fecha AS fechaDoc,
                        tran_100.idcps AS idcliente,
                        ctauxi2.descrip AS cliente,
                        orders_100.trannum AS trannum_remesa,
                        ctauxi.descrip AS nameBancoRemesa,
                        tran_100c.valor as montoDoc
                    FROM
                        orders_100
                        INNER JOIN 
                        ctauxi as Bank ON Bank.idauxi = orders_100.idcps
                            INNER JOIN
                        tran_100c ON tran_100c.idctcuenta = orders_100.trannum
                            INNER JOIN
                        tran_100 ON tran_100.trannum = tran_100c.trannum
                            INNER JOIN
                        caj_def ON caj_def.cajclase = tran_100c.cajclase
                            INNER JOIN
                        inv_def ON inv_def.invclase = tran_100.idclase
                          INNER JOIN
                        ctauxi ON orders_100.idcps = ctauxi.idauxi
                          INNER JOIN
                        ctauxi as ctauxi2 ON tran_100.idcps = ctauxi2.idauxi
                    WHERE 
                    orders_100.agrupa = 'DB' AND orders_100.idcentro = '$sucursal' AND orders_100.fecha BETWEEN '$fechaini' AND '$fechafin' AND orders_100.estatus = 1 ORDER BY orders_100.fecha ASC";
                 $query = $this->db_b->query($consulta);
                 $resultado = $query->result();
                 return $resultado;
            }
         }
         
         
        
        function reporteExportacionCC($idcentros, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$datosCentros = explode(",", $idcentros);
				$totalCentros = count($datosCentros);
				
				$ConsultaWhere = "(";
				
				for($i=0; $i<$totalCentros; $i++){
					$ConsultaWhere .= "tran_100.idcentro = ".$datosCentros[$i]." OR ";
				}
				
				$ConsultaWhere = substr($ConsultaWhere, 0, -3);
				$ConsultaWhere = $ConsultaWhere . ")";
				
                $ConsultaVN = "
                SELECT tran_100.trannum, invsites.descrip AS nameSucursal, ctcajas.descrip AS nameCaja, tran_100.fecha, tran_100.fecvence, DATEDIFF(now(),tran_100.fecha) as dias, inv_def.descrip AS nameDocumento, CONCAT(tran_100.serie, tran_100.numero) AS serienumero, cliente.descrip as ClienteName, vendedor.descrip as VendedorTran, vendedorasignado.descrip as VendedorAsignado, SUM(tran_100.valventan+valtax1) as valor
                FROM tran_100 
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND (inv_def.agrupa = 'VN' OR  inv_def.agrupa = 'CC')
				LEFT JOIN ctauxi as cliente ON tran_100.idcps= cliente.idauxi
				LEFT JOIN ctauxi as vendedor ON tran_100.idworker= vendedor.idauxi
				LEFT JOIN ctauxi as vendedorasignado ON cliente.idcps= vendedorasignado.idauxi
				WHERE (".$ConsultaWhere.") AND (tran_100.estatus = 1) AND fecha BETWEEN '$fechaini' AND '$fechafin' GROUP BY tran_100.trannum ORDER BY tran_100.trannum ASC";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }
         
        function reporteExportacionPagosCC($idcentros, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
				ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
				
				$datosCentros = explode(",", $idcentros);
				$totalCentros = count($datosCentros);
				
				$ConsultaWhere = "(";
				
				for($i=0; $i<$totalCentros; $i++){
					$ConsultaWhere .= "tran_100.idcentro = ".$datosCentros[$i]." OR ";
				}
				
				$ConsultaWhere = substr($ConsultaWhere, 0, -3);
				$ConsultaWhere = $ConsultaWhere . ")";
				
                $ConsultaVN = "
                SELECT tran_100.trannum, invsites.descrip AS nameSucursal, ctcajas.descrip AS nameCaja, tran_100c.fecha, tran_100.fecvence, DATEDIFF(now(),tran_100.fecha) as dias, inv_def.descrip AS nameDocumento, CONCAT(tran_100.serie, tran_100.numero) AS serienumero, cliente.descrip as ClienteName, vendedor.descrip as VendedorTran, vendedorasignado.descrip as VendedorAsignado, SUM(tran_100.valventan+valtax1) as valor, tran_100c.descrip as descripAbonoCargo,tran_100c.referencia,tran_100c.valor as valorAbonoCargo, caj_def.descrip as formaPago
                FROM tran_100 
                INNER JOIN tran_100c ON tran_100c.trannum=tran_100.trannum
                INNER JOIN invsites ON tran_100.idcentro = invsites.idcentro 
                INNER JOIN ctcajas ON tran_100.idcaja = ctcajas.idcaja 
                INNER JOIN inv_def ON tran_100.idclase = inv_def.invclase AND (inv_def.agrupa = 'VN' OR  inv_def.agrupa = 'CC')
				LEFT JOIN ctauxi as cliente ON tran_100.idcps= cliente.idauxi
				LEFT JOIN ctauxi as vendedor ON tran_100.idworker= vendedor.idauxi
				LEFT JOIN ctauxi as vendedorasignado ON cliente.idcps= vendedorasignado.idauxi
                LEFT JOIN caj_def ON caj_def.cajclase=tran_100c.cajclase
				WHERE (".$ConsultaWhere.")  AND (tran_100.estatus = 1) AND tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin'
                GROUP BY tran_100c.idrec
                ORDER BY tran_100c.idrec";
                $QueryVN = $this->db_b->query($ConsultaVN);
				
				if($QueryVN->num_rows() > 0){
					$infoVentas = $QueryVN->result();
				}else{
					$infoVentas = false;
				}
				
				return $infoVentas;
            }
        }
         
        function getlastdescrip($idauxi, $cajclase){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT DISTINCT(tran_100c.descrip) as descrip FROM tran_100c INNER JOIN tran_100 ON tran_100c.trannum = tran_100.trannum  WHERE tran_100c.cajclase=$cajclase AND tran_100.idcps = $idauxi ORDER BY tran_100c.ingresa, tran_100c.descrip ASC LIMIT 50 ";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
         
		 
         
        function getAbonosGroup($num_group){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT inv_def.descrip as tipoDoc, CONCAT(tran_100.serie, ',', tran_100.numero) as numDoc, caj_def.descrip as formaPago,tran_100c.descrip, tran_100c.valor  FROM tran_100c INNER JOIN tran_100 ON tran_100.trannum = tran_100c.trannum inner join caj_def on caj_def.cajclase=tran_100c.cajclase INNER JOIN inv_def ON inv_def.invclase = tran_100c.idclase where tran_100c.telefono = '$num_group' GROUP BY tran_100c.idrec ORDER BY tran_100c.idrec ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getListadoDocs(){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT 
					tran_100.trannum,
                    DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
                    DATE_FORMAT(tran_100.fecvence, '%d/%m/%Y') AS fechaVence,
					tran_100.fecha AS fechasinformato,
					tran_100.fecvence AS fecvencesinformato,
					DATEDIFF(NOW(), tran_100.fecha) AS dias,
					ctauxi.descrip as cliente,
					ctauxi2.descrip as vendedor,
                    IFNULL(ctauximulti.descrip, 'No Asignado') AS lugar_entrega,
					CONCAT(tran_100.serie,tran_100.numero) AS serienumero,
					inv_def.descrip AS tipoDoc,
					(SUM(CONVERT(tran_100.valventan, DECIMAL(12,6)) + CONVERT(tran_100.valtax1, DECIMAL(12,6)) + CONVERT(tran_100.valtax2, DECIMAL(12,6)) + CONVERT(tran_100.valtax3, DECIMAL(12,6)) + CONVERT(tran_100.valtax4, DECIMAL(12,6)) + CONVERT(tran_100.valtax5, DECIMAL(12,6))) + CONVERT(tran_100.valdh, DECIMAL(12,6))) AS saldo,
					SUM(CONVERT(tran_100.valventan, DECIMAL(12,6)) + CONVERT(tran_100.valtax1, DECIMAL(12,6)) + CONVERT(tran_100.valtax2, DECIMAL(12,6)) + CONVERT(tran_100.valtax3, DECIMAL(12,6)) + CONVERT(tran_100.valtax4, DECIMAL(12,6)) + CONVERT(tran_100.valtax5, DECIMAL(12,6))) AS saldoInicial,
					IFNULL((SELECT IFNULL(tran_100kt.idbatch,0) FROM tran_100kt WHERE tran_100kt.trannum=tran_100.trannum ORDER BY tran_100kt.idrec DESC LIMIT 1),0) AS ultima_gestion,
					IFNULL((SELECT IFNULL(tran_100kt.um,'-') FROM tran_100kt WHERE tran_100kt.trannum=tran_100.trannum ORDER BY tran_100kt.idrec DESC LIMIT 1),'-') AS last_fecha
				FROM tran_100
                INNER JOIN inv_def ON inv_def.invclase = tran_100.idclase
                INNER JOIN ctauxi ON tran_100.idcps = ctauxi.idauxi 
                INNER JOIN ctauxi as ctauxi2  ON tran_100.idworker = ctauxi2.idauxi
                LEFT JOIN ctauximulti ON tran_100.idcps_branch = ctauximulti.idrec
				WHERE inv_def.agrupa = 'VN' AND tran_100.estatus = 1 AND tran_100.ccestatus != 1
				GROUP BY tran_100.trannum
				ORDER BY tran_100.fecha ASC";
                $query = $this->db_b->query($consulta);
                $resultado = $query->result();
                return $resultado;
            }
        }
        function getListadoDocs2($filtros){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
				$where = "";
				if($filtros!=null){
					
					foreach($filtros as $fil){
						if(count($fil)>1){
							$where .= $fil[0]. " ".$fil[1]. " ". $fil[2]. " AND ";
						}
					}
					$where = substr($where, 0, -4);
					$where ="AND (".$where.")";
				}	
                $consulta = "SELECT 
					tran_100.trannum,
					DATE_FORMAT(tran_100.fecha, '%d/%m/%Y') AS fecha,
					DATEDIFF(NOW(), tran_100.fecha) AS dias,
					ctauxi.descrip as cliente,
					ctauxi2.descrip as vendedor,
					CONCAT(tran_100.serie,tran_100.numero) AS serienumero,
					inv_def.descrip AS tipoDoc,
					(SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) + tran_100.valdh) AS saldo,
					SUM(tran_100.valventan + tran_100.valtax1 + tran_100.valtax2 + tran_100.valtax3 + tran_100.valtax4 + tran_100.valtax5) AS saldoInicial,
					IFNULL((SELECT IFNULL(tran_100kt.idbatch,0) FROM tran_100kt WHERE tran_100kt.trannum=tran_100.trannum ORDER BY tran_100kt.idrec DESC LIMIT 1),0) AS ultima_gestion,
					IFNULL((SELECT IFNULL(tran_100kt.um,'-') FROM tran_100kt WHERE tran_100kt.trannum=tran_100.trannum ORDER BY tran_100kt.idrec DESC LIMIT 1),'-') AS last_fecha
				FROM
					tran_100
						INNER JOIN
					inv_def ON inv_def.invclase = tran_100.idclase
						INNER JOIN
					ctauxi ON tran_100.idcps = ctauxi.idauxi 
					INNER JOIN
					ctauxi as ctauxi2  ON tran_100.idworker = ctauxi2.idauxi
				WHERE
					inv_def.agrupa = 'VN'
						AND tran_100.estatus = 1
						AND tran_100.ccestatus != 1 $where
				GROUP BY tran_100.trannum
				ORDER BY ctauxi.descrip , tran_100.fecha ASC";
                //$query = $this->db_b->query($consulta);
                //$resultado = $query->result();
                return $consulta;
            }
        }
		function getListadoGestiones($trannum){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT idrec, trannum, idbatch, itemline, um, notas FROM tran_100kt WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
				$resultado = $query->result();
                return $resultado;
            }
        }
        function insertGestion($trannum,$gestion,$fecha,$notas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
            }else{ 
                $consulta = "SELECT * FROM tran_100kt WHERE trannum = $trannum";
                $query = $this->db_b->query($consulta);
                $itemline = $query->num_rows() + 1 ;
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('idrec', 0);
                $this->db_b->set('trannum', $trannum);
                $this->db_b->set('idbatch', $gestion);
                $this->db_b->set('itemline', $itemline);
                $this->db_b->set('um', $fecha);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('tran_100kt');		 
            }
        }
        function updateGestion($idrec, $trannum,$gestion,$fecha,$notas){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
            redirect('login/cerrar_sesion');
            }else{ 
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $this->db_b->set('idbatch', $gestion);
                $this->db_b->set('um', $fecha);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit',$this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idrec', $idrec);
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('tran_100kt');		 
            }
        }
        function deleteGestion($idrec){
            $consulta = "DELETE FROM tran_100kt WHERE idrec = $idrec";
            $query = $this->db_b->query($consulta);
        }

        #   PRUEBAS OPTIMIZACION BALANCE CARTERA

        function getBalanceCarteraTest($fechaini, $fechafin){
            if($this->session->userdata('logueado') == 'FALSE' || $this->session->userdata('logueado' == "") || !$this->session->userdata('logueado')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db_b->select('cajclase');
                $this->db_b->from('caj_def');
                $this->db_b->where('creditchk', 1);
                $data = $this->db_b->get();
                if($data->num_rows() > 0) {
                    $cajclase = $data->row()->cajclase;
                    //$this->highlight_array(["ini"=>$fechaini, "fin"=>$fechafin, "clase"=>$cajclase]);
                    $consulta = "SELECT tran_100_principal.idcps, ctauxi.descrip,
                    IFNULL((SELECT SUM(t100.valventan + t100.valtax1) FROM tran_100 as t100 WHERE t100.fecha < '$fechaini' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS saldo_anterior,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN tran_100 as t100 ON t100.trannum=tran_100c.trannum WHERE tran_100c.fecha < '$fechaini' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS pagosFacturas,
                    IFNULL((SELECT SUM(t100.valventan + t100.valtax1) FROM tran_100 AS t100 INNER JOIN inv_def as invdef ON invdef.invclase = t100.idclase WHERE t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase AND invdef.agrupa='VN' AND  t100.estatus=1), 0) AS ventas_periodo,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS abonos, 
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha<'$fechaini' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS last_abono,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS actual_abono,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha<'$fechaini'  AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS last_cargo,
                    IFNULL((SELECT SUM(valor - vuelto) FROM tran_100c INNER JOIN caj_def ON tran_100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 INNER JOIN inv_def AS invdef ON invdef.invclase = tran_100c.idclase INNER JOIN tran_100 AS t100 ON t100.trannum = tran_100c.trannum WHERE tran_100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND invdef.agrupa='VN' AND t100.idcps = tran_100_principal.idcps AND t100.numy = $cajclase), 0) AS actual_cargo, 
                    (SELECT COUNT(t.trannum) FROM tran_100 t WHERE t.idcps=ctauxi.idauxi AND t.numy = $cajclase) AS Hits
                    FROM tran_100 AS tran_100_principal
                    INNER JOIN ctauxi ON ctauxi.idauxi = tran_100_principal.idcps INNER JOIN inv_def ON inv_def.invclase = tran_100_principal.idclase
                    WHERE inv_def.agrupa='VN' GROUP BY tran_100_principal.idcps HAVING Hits > 0 ORDER BY ctauxi.descrip";
                    $query = $this->db_b->query($consulta);

                    if($query->num_rows() >0){
                        $resultado = $query->result();
                        return $resultado;
                    }else{
                        return false;
                    }
                } else return false;
            }
        }

        //obtiene el id del tipo de transaccion de creditos
        function getBalanceCarteraCreditchk(){
            $this->db_b->select('cajclase');
            $this->db_b->from('caj_def');
            $this->db_b->where('creditchk', 1);
            $data = $this->db_b->get();
            if($data->num_rows() > 0) {
                $cajclase = $data->row()->cajclase;
                return $cajclase;
            }else{
                return false;
            }
        }

        //obtiene los auxis con hits mayores a cero
        function getBalanceCarteraAuxis($cajclase){
            $consulta = "SELECT tran_100_principal.idcps, ctauxi.descrip,
                    EXISTS(SELECT 1 FROM tran_100 t WHERE t.idcps=ctauxi.idauxi AND t.numy = $cajclase) AS Hits
            FROM tran_100 AS tran_100_principal
            INNER JOIN ctauxi ON ctauxi.idauxi = tran_100_principal.idcps 
            INNER JOIN inv_def ON inv_def.invclase = tran_100_principal.idclase
            WHERE inv_def.agrupa='VN' AND ctauxi.limite > 0
            GROUP BY tran_100_principal.idcps 
            HAVING Hits > 0 
            ORDER BY ctauxi.descrip";
            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

        function getBalanceCarteraSaldoAnterior($cajclase, $fechaini, $idcps){
            $consulta = "SELECT t100.valventan, t100.valtax1 
            FROM tran_100 as t100 
            INNER JOIN inv_def ON inv_def.invclase = t100.idclase

            WHERE t100.fecha < '$fechaini' AND t100.idcps = $idcps AND t100.numy = $cajclase AND inv_def.agrupa='VN'";
            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }
      
        function getBalanceCarteraPagosFacturas($cajclase, $fechaini, $idcps){
            $consulta = "SELECT t100c.valor, t100c.vuelto 
            FROM tran_100c as t100c
            INNER JOIN tran_100 t100 ON t100.trannum = t100c.trannum

            WHERE t100c.fecha < '$fechaini' AND t100.idcps = $idcps AND t100.numy = $cajclase";
            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

        function getBalanceCarteraVentasPeriodo($cajclase, $fechaini, $fechafin, $idcps){
            $consulta = "SELECT t100.valventan, t100.valtax1 
            FROM tran_100 as t100
            INNER JOIN inv_def ON inv_def.invclase = t100.idclase
            WHERE t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.idcps = $idcps AND t100.numy = $cajclase AND inv_def.agrupa='VN' AND t100.estatus = 1";

            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }
        
        function getBalanceCarteraLastAbono($cajclase, $fechaini, $fechafin, $idcps){
            $consulta = "SELECT t100c.valor, t100c.vuelto 
            FROM tran_100c as t100c
            INNER JOIN caj_def ON t100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 
            INNER JOIN inv_def AS invdef ON invdef.invclase = t100c.idclase 
            INNER JOIN tran_100 AS t100 ON t100.trannum = t100c.trannum 

            WHERE t100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha < '$fechaini' AND t100.idcps = $idcps AND t100.numy = $cajclase AND invdef.agrupa='VN'";

            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

        function getBalanceCarteraActualAbono($cajclase, $fechaini, $fechafin, $idcps){
            $consulta = "SELECT t100c.valor, t100c.vuelto 
            FROM tran_100c as t100c
            INNER JOIN caj_def ON t100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=-1 
            INNER JOIN inv_def AS invdef ON invdef.invclase = t100c.idclase 
            INNER JOIN tran_100 AS t100 ON t100.trannum = t100c.trannum 

            WHERE t100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.idcps = $idcps AND t100.numy = $cajclase AND invdef.agrupa='VN'";

            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

      
        function getBalanceCarteraLastCargo($cajclase, $fechaini, $fechafin, $idcps){
            $consulta = "SELECT t100c.valor, t100c.vuelto 
            FROM tran_100c as t100c
            INNER JOIN caj_def ON t100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 
            INNER JOIN inv_def AS invdef ON invdef.invclase = t100c.idclase 
            INNER JOIN tran_100 AS t100 ON t100.trannum = t100c.trannum 

            WHERE t100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha < '$fechaini' AND t100.idcps = $idcps AND t100.numy = $cajclase AND invdef.agrupa='VN'";

            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

        function getBalanceCarteraActualCargo($cajclase, $fechaini, $fechafin, $idcps){
            $consulta = "SELECT t100c.valor, t100c.vuelto 
            FROM tran_100c as t100c
            INNER JOIN caj_def ON t100c.cajclase= caj_def.cajclase AND caj_def.alcuadre=1 
            INNER JOIN inv_def AS invdef ON invdef.invclase = t100c.idclase 
            INNER JOIN tran_100 AS t100 ON t100.trannum = t100c.trannum 

            WHERE t100c.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.fecha BETWEEN '$fechaini' AND '$fechafin' AND t100.idcps = $idcps AND t100.numy = $cajclase AND invdef.agrupa='VN'";

            $query = $this->db_b->query($consulta);

            if($query->num_rows() >0){
                $resultado = $query->result();
                return $resultado;
            }else{
                return false;
            }
        }

        #   FIN PRUEBAS OPTIMIZACION BALANCE CARTERA

        function buscarDocumentoNumero($numero, $idcredito){
            $this->db_b->select('tran_100.trannum, tran_100.serie, tran_100.numero, inv_def.descrip, tran_100.idclase, tran_100.idcps, ctauxi.descrip as nombreCliente');
            $this->db_b->from('tran_100');
            $this->db_b->join('inv_def', 'inv_def.invclase = tran_100.idclase', 'inner');
            $this->db_b->join('ctauxi', 'ctauxi.idauxi = tran_100.idcps', 'inner');

            $this->db_b->where('tran_100.numero', $numero);
            $this->db_b->where('tran_100.numy', $idcredito);
            $this->db_b->where('tran_100.ccestatus', 0);
            $this->db_b->where('tran_100.estatus !=', 9);


            $data = $this->db_b->get();

            if($data->num_rows() > 0) {
                $resultados = $data->result_array();
                return $resultados;
            }else{
                return false;
            }
        }

     }

?>