<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Apiorden_model extends CI_Model {
		
        public function __construct() {
        }

        function setParamsDB($idaccount) {
            $this->db->select('dbp1, dbp2, dbp3, dbp4');
            $this->db->from('wpos_cuentas');
            $this->db->where('idaccount', $idaccount);
            $this->db->limit(1);
            $QueryCuenta = $this->db->get();
            $infoCuenta = $QueryCuenta->row_array();

            $CuentaArray = array(
                'serverDB' => $infoCuenta['dbp1'],
                'nameDB'   => $infoCuenta['dbp2'],
                'userDB'   => $infoCuenta['dbp3'],
                'passDB'   => $infoCuenta['dbp4'],
            );
            $this->session->set_userdata($CuentaArray);
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
        }

        function getValorNumVariable($nameGvar) {
            $this->db_b->select('a.valor_num');
            $this->db_b->from('gvars a');
            $this->db_b->where('a.nombre', $nameGvar);
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() == 0) return 0;
            
            return $datos->row()->valor_num;
        }

        function getVendedores($idaccount) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.idauxi, a.descrip');
            $this->db_b->from("ctauxi a");
            $this->db_b->where("a.idauxidef", 3);
            $this->db_b->where("a.estado", 1);
            $this->db_b->order_by('a.descrip', 'ASC');
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $info) {
                    $vendedores[] = array(
                        'idauxi'  => (int) $info->idauxi,
                        'descrip' => $info->descrip,
                    );
                }
                
                return $vendedores;
            } else {
                return [];
            }
        }

        function getDocumentos($idaccount) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.invclase, a.descrip, a.exento, a.askregiva');
            $this->db_b->from('inv_def a');
            $this->db_b->where('a.agrupa', 'VN');
            $this->db_b->where('a.inopera', -1);
            $this->db_b->where('a.estatus', 1);
            $this->db_b->order_by('a.descrip', 'ASC');
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $info) {
                    $documentos[] = array(
                        'idclase' => (int) $info->invclase,
                        'descrip' => $info->descrip,
                        'exento'  => (int) $info->exento,
                        'askreg'  => (int) $info->askregiva,
                    );
                }
                
                return $documentos;
            } else {
                return [];
            }
        }

        function getSucursales($idaccount) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.idcentro, a.descrip');
            $this->db_b->from('invsites a');
            $this->db_b->where('a.estatus', 1);
            $this->db_b->order_by('a.descrip', 'ASC');
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $info) {
                    $sucursales[] = array(
                        'idcentro' => (int) $info->idcentro,
                        'descrip'  => $info->descrip,
                    );
                }
                
                return $sucursales;
            } else {
                return [];
            }
        }
        
        function getPagos($idaccount) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.cajclase, a.descrip');
            $this->db_b->from('caj_def a');
            $this->db_b->where('a.estatus', 1);
            $this->db_b->where('a.agrupa', 'VN');
            $this->db_b->order_by('a.descrip', 'ASC');
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $info) {
                    $pagos[] = array(
                        'cajclase' => (int) $info->cajclase,
                        'descrip'  => $info->descrip,
                    );
                }
                
                return $pagos;
            } else {
                return [];
            }
        }

        function adicionarOrden($idaccount, $iduser, $idcentro, $idworker, $idclase, $fechadoc) {
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            $this->setParamsDB($idaccount);

            $idcps = $this->getValorNumVariable('pos_cliente0'.$idcentro);

            $this->db_b->set('trannum', 0);
            $this->db_b->set('fecha',    $fechadoc);
            $this->db_b->set('idcps',    $idcps);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idclase',  $idclase);
            $this->db_b->set('idworker', $idworker);
            $this->db_b->set('whodidit', $iduser);
            $this->db_b->set('ingresa',  $fecha->format('Y-m-d H:i:s'));
            $this->db_b->insert('tran_100');
            return $this->db_b->insert_id();
        }

        function enviarOrdenCaja($idaccount, $trannum, $iduser, $cajclase) {
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            $this->setParamsDB($idaccount);

            $this->db_b->set('numy', $cajclase);
            $this->db_b->set('estatus', 8);
            $this->db_b->set('whodidit', $iduser);
            $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
            $this->db_b->where('trannum', $trannum);
            $query = $this->db_b->update('tran_100');
            
            return $query;
        }

        function getInforCierreOrden($idaccount, $trannum) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.trannum, a.fecha, a.idcentro, a.idworker');
            $this->db_b->from("tran_100 a");
            $this->db_b->where("a.trannum",  $trannum);
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    
                    $this->db_b->select('a.tax1, a.cantidad, a.precioneto');
                    $this->db_b->from("tran_100k a");
                    $this->db_b->where("a.trannum",  $dato->trannum);
                    $this->db_b->order_by('a.itemline', 'DESC');
                    $datos = $this->db_b->get();

                    if ($datos->num_rows() > 0) {
                        $info = $datos->result();
                    } else $info = false;

                
                    $totalVenta = 0; $nLineas=0; $nUnidades=0;
                    if ($info != false) {
                        foreach($info as $inf) {
                            $nLineas++;
                            $nUnidades = $nUnidades + abs($inf->cantidad);
                            $totalVenta = $totalVenta + (($inf->precioneto + ($inf->precioneto * ($inf->tax1 / 100))) * abs($inf->cantidad));
                        }
                    }

                    $orden[] = array(
                        'trannum'  => (int) $dato->trannum,
                        'fecha'    => $dato->fecha,
                        'idcentro' => (int) $dato->idcentro,
                        'idworker' => (int) $dato->idworker,
                        'lineas'   => (int) $nLineas,
                        'unidades' => (int) $nUnidades,
                        'total'    => number_format($totalVenta, 2, '.', ''),
                    );
                }
                
                return $orden;
            } else {
                return [];
            }
        }

        function getListadoOrdenesGeneradas($idaccount, $idcentro, $idworker) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.trannum, DATE_FORMAT(a.fecha, "%d/%m/%Y") AS fecha, a.estatus, a.serie, a.numero, b.exento, b.descrip AS tipodoc, IFNULL(c.descrip, "SIN ASIGNAR") AS namecliente, a.valventan, a.valtax1');
            $this->db_b->from("tran_100 a");
            $this->db_b->join("inv_def b", "a.idclase = b.invclase");
            $this->db_b->join("ctauxi c", "a.idcps = c.idauxi", "left");
            $this->db_b->where("b.agrupa",  'VN');
            $this->db_b->where("a.idcentro",  $idcentro);
            $this->db_b->where("a.idworker",  $idworker);
            $this->db_b->where("a.estatus",  0);
            $this->db_b->where("(b.caopera = 1 OR b.caopera = -1)");
            $this->db_b->order_by('a.trannum', 'DESC');
            // $this->db_b->limit(20);
            $datos = $this->db_b->get();

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    
                    // $this->db_b->select('a.tax1, a.cantidad, a.precioneto');
                    // $this->db_b->from("tran_100k a");
                    // $this->db_b->where("a.trannum",  $dato->trannum);
                    // $this->db_b->order_by('a.itemline', 'DESC');
                    // $datos = $this->db_b->get();

                    // if ($datos->num_rows() > 0) {
                    //     $info = $datos->result();
                    // } else $info = false;

                
                    $totalVenta = 0;
                    // if ($info != false) {
                    //     foreach($info as $inf) {
                    //         $totalVenta = $totalVenta + (($inf->precioneto + ($inf->precioneto * ($inf->tax1 / 100))) * abs($inf->cantidad));
                    //     }
                    // }

                    $ordenes[] = array(
                        'trannum'   => (int) $dato->trannum,
                        'fecha'     => $dato->fecha,
                        'documento' => $dato->tipodoc,
                        'numdoc'    => $dato->serie.$dato->numero,
                        'cliente'   => $dato->namecliente,
                        'valor'     => number_format($totalVenta, 2, '.', '') * 1,
                        'estatus'   => (int) $dato->estatus
                    );
                }
                
                return array_merge([
                    'status'  => 0,
                    'ordenes' => $ordenes,
                ]);
            } else {
                return array_merge([
                    'status'  => 0,
                    'ordenes' => [],
                ]);
            }
        }
        
        function getDetalleProductosOrden($idaccount, $trannum, $idcentro) {
            $this->setParamsDB($idaccount);

            $this->db_b->select('a.idrec, a.trannum, b.idproducto, b.descrip, b.xpos, b.barcode, b.precioventa, b.tipotax, b.tipo, b.upp, a.tax1, a.itemline, a.um AS umVenta, a.uniconv');
            $this->db_b->select('b.imagen, b.modelo, b.um, b.marca, b.notas AS nproducto, a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, a.notas, a.idbatch, a.idbin');
            $this->db_b->select('IF(b.tipo = 4, 999999, (SELECT SUM(x.cantidad * x.uniconv) FROM tran_100k x WHERE a.idproducto = x.idproducto AND x.idcentro = '.$idcentro.')) AS disponible');
            $this->db_b->from("tran_100k a");
            $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
            $this->db_b->join("inv_batch c", "a.idbatch = c.idbatch");
            $this->db_b->where("a.trannum",  $trannum);
            $this->db_b->order_by('a.itemline', 'DESC');
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $productos[] = array(
                        'idrec'         => (int) $dato->idrec,
                        'trannum'       => (int) $dato->trannum,
                        'idproducto'    => (int) $dato->idproducto,
                        'descrip'       => $dato->descrip,
                        'marca'         => $dato->marca,
                        'modelo'        => $dato->modelo,
                        'um'            => $dato->um,
                        'barcode'       => $dato->barcode,
                        'notas'         => $dato->nproducto,
                        'idbatch'       => (int) $dato->idbatch,
                        'idbin'         => (int) $dato->idbin,
                        'tax1'          => number_format($dato->tax1, 2, '.', '') * 1,
                        'cantidad'      => number_format(abs($dato->cantidad), 2, '.', '') * 1,
                        'disponible'    => number_format(abs($dato->disponible) + abs($dato->cantidad), 2, '.', '') * 1,
                        'precioneto'    => number_format($dato->precioneto, 2, '.', '') * 1,
                        'preciotran'    => number_format($dato->preciotran, 2, '.', '') * 1,
                        'costounitario' => number_format($dato->costounitario, 2, '.', '') * 1,
                        'descuento'     => number_format($dato->descuento, 2, '.', '') * 1,
                    );
                }
                
                return array_merge([
                    'status'    => 0,
                    'productos' => $productos,
                ]);
            } else {
                return array_merge([
                    'status'    => 0,
                    'productos' => [],
                ]);
            }
        }

        function getProductoSearch($idaccount, $trannum, $tipo, $search, $idcentro) {
            $this->setParamsDB($idaccount);

            switch ($tipo) {
                case 1:
                    $nameFilter = 'idproducto';
                    break;
                case 2:
                    $nameFilter = 'modelo';
                    break;
                case 3:
                    $nameFilter = 'barcode';
                    break;
                case 4:
                    $nameFilter = 'xpos';
                    break;
                case 5:
                    $nameFilter = 'descrip';
                    break;
            }

            if ( $tipo == 3 ) {
                $this->db_b->select('a.idcatalogo, a.presenta, a.upp, a.tipo, a.tipotax, a.idproducto, a.descrip, a.marca, a.um');
                $this->db_b->select('a.imagen, a.modelo, a.barcode, a.precioventa, a.notas, b.costounitario, b.idbatch, c.idbin');
                $this->db_b->select('(SELECT SUM(x.cantidad * x.uniconv) FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.idcentro = '.$idcentro.') AS cantidad');
                // $this->db_b->select('(SELECT IF(EXISTS(SELECT x.trannum FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.trannum = '.$trannum.'), 1, 0)) AS existe');
                $this->db_b->from("invproducts a");
                $this->db_b->join("inv_batch b", "a.idproducto = b.idproducto");
                $this->db_b->join("invlocations c", "c.idcentro = $idcentro");
                $this->db_b->where("a.estado", 1);
                $this->db_b->where("a.$nameFilter", $search);
                $this->db_b->having('cantidad >', 0);
                $datos = $this->db_b->get();

                if ( $datos->num_rows() > 0 ) {
                    $resultado = $datos->result();
                } else {
                    $this->db_b->select('a.idcatalogo, a.presenta, a.upp, a.tipo, a.tipotax, a.idproducto, a.descrip, a.marca, a.um');
                    $this->db_b->select('a.imagen, a.modelo, a.barcode, a.precioventa, a.notas, b.costounitario, b.idbatch, c.idbin');
                    $this->db_b->select('(SELECT SUM(x.cantidad * x.uniconv) FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.idcentro = '.$idcentro.') AS cantidad');
                    // $this->db_b->select('(SELECT IF(EXISTS(SELECT x.trannum FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.trannum = '.$trannum.'), 1, 0)) AS existe');
                    $this->db_b->from("invproducts a");
                    $this->db_b->join("inv_batch b", "a.idproducto = b.idproducto");
                    $this->db_b->join("invlocations c", "c.idcentro = $idcentro");
                    $this->db_b->join("invpromulti d", "a.idproducto = d.idproducto AND d.idgvar = 2 AND d.estatus = 1");
                    $this->db_b->where("a.estado", 1);
                    $this->db_b->where("d.descrip", $search);
                    $this->db_b->having('cantidad >', 0);
                    $datos = $this->db_b->get();

                    if ( $datos->num_rows() > 0 ) {
                        $resultado = $datos->result();
                    } else $resultado = false;
                }
            } else {
                $this->db_b->select('a.idcatalogo, a.presenta, a.upp, a.tipo, a.tipotax, a.idproducto, a.descrip, a.marca, a.um');
                $this->db_b->select('a.imagen, a.modelo, a.barcode, a.precioventa, a.notas, b.costounitario, b.idbatch, c.idbin');
                $this->db_b->select('(SELECT SUM(x.cantidad * x.uniconv) FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.idcentro = '.$idcentro.') AS cantidad');
                // $this->db_b->select('(SELECT IF(EXISTS(SELECT x.trannum FROM tran_100k x WHERE x.idproducto = a.idproducto AND x.trannum = '.$trannum.'), 1, 0)) AS existe');
                $this->db_b->from("invproducts a");
                $this->db_b->join("inv_batch b", "a.idproducto = b.idproducto");
                $this->db_b->join("invlocations c", "c.idcentro = $idcentro");
                $this->db_b->where("a.estado", 1);

                if ( $tipo == 5 || $tipo == 2 ) {
                    $this->db_b->like("a.$nameFilter", $search);
                } else {
                    $this->db_b->where("a.$nameFilter", $search);
                }
                
                $this->db_b->having('cantidad >', 0);
                $datos = $this->db_b->get();

                if ( $datos->num_rows() > 0 ) {
                    $resultado = $datos->result();
                } else $resultado = false;
            }
            
            if ( $resultado ) {
                foreach ($resultado as $dato) {
                    $productos[] = array(
                        'idrec'         => (int) 0,
                        'idproducto'    => (int) $dato->idproducto,
                        'descrip'       => $dato->descrip,
                        'marca'         => $dato->marca,
                        'modelo'        => $dato->modelo,
                        'um'            => $dato->um,
                        'barcode'       => $dato->barcode,
                        'notas'         => $dato->notas,
                        'idbatch'       => (int) $dato->idbatch,
                        'idbin'         => (int) $dato->idbin,
                        'tax1'          => number_format($dato->tipotax, 2, '.', '') * 1,
                        'cantidad'      => 1,
                        'disponible'    => number_format($dato->cantidad, 2, '.', '') * 1,
                        'precioneto'    => number_format(0, 2, '.', '') * 1,
                        'preciotran'    => number_format($dato->precioventa, 2, '.', '') * 1,
                        'costounitario' => number_format($dato->costounitario, 4, '.', '') * 1,
                        'descuento'     => number_format(0, 2, '.', '') * 1,
                    );
                }
                
                return array_merge([
                    'status'    => 0,
                    'productos' => $productos,
                ]);
            } else {
                return array_merge([
                    'status'    => 1,
                    'productos' => [],
                ]);
            }
        }

        function adicionarProducto($idaccount, $trannum, $idcentro, $idworker, $tipotax, $iduser, $idproducto, $um, $barcode, $cantidad, $precio, $descuento) {
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            $this->setParamsDB($idaccount);
    
            $ConsuSQL = "SELECT itemline FROM tran_100k WHERE trannum = $trannum ORDER BY itemline DESC LIMIT 1";
            $QuerySQL = $this->db_b->query($ConsuSQL);

            if ( $QuerySQL->num_rows() > 0 ) {
                $SQLResult = $QuerySQL->row_array();
                $itemLine  = $SQLResult['itemline'] + 1;
            } else {
                $itemLine = 1;
            }

            $ConSQL = "SELECT costounitario, idbatch FROM inv_batch WHERE idproducto = '$idproducto'";
            $SQuery = $this->db_b->query($ConSQL);
            
            if ( $SQuery->num_rows() > 0 ) {
                $SQResult = $SQuery->row_array();
                $costounitario = $SQResult['costounitario'];
                $idbatch       = $SQResult['idbatch'];
            } 
            // else {
            //     $ConSQLCosto = "SELECT IFNULL(costounitario, 0) AS costounitario FROM invproducts WHERE idproducto = $idproducto";
            //     $SQueryCosto = $this->db_b->query($ConSQLCosto);
            //     $SQResultCos = $SQueryCosto->row_array();
            //     $costounitario = $SQResultCos['costounitario'];
            // }

            $ConBin = "SELECT idbin FROM invlocations WHERE idcentro = '$idcentro'";
            $BQuery = $this->db_b->query($ConBin);
            
            if ( $BQuery->num_rows() > 0 ) {
                $BResult = $BQuery->row_array();
                $idbin   = $BResult['idbin'];
            }

            $nDescuento = str_replace("%", "", $descuento);
            $precioneto = ( 1 - ( $nDescuento / 100 ) ) * $precio;
            
            if ($tipotax != 0) {
                $taxDes = ( $tipotax / 100 ) + 1;
                $precioneto = $precioneto / $taxDes;
            }
            
            $ConSQL  = "SELECT idclase FROM tran_100 WHERE trannum = $trannum";
            $QSQL    = $this->db_b->query($ConSQL);
            $Res     = $QSQL->row_array();
            $idclase = $Res['idclase'];

            $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
            $QSQL2   = $this->db_b->query($ConSQL2);
            $Res2    = $QSQL2->row_array();
            $inopera = $Res2['inopera'];
            $exento  = $Res2['exento'];

            $nCantidad = $cantidad * $inopera;
            
            if ($exento == 1) $tipotax = 0;
            
            $this->db_b->set('idrec', 0);
            $this->db_b->set('trannum', $trannum);
            $this->db_b->set('itemline', $itemLine);
            $this->db_b->set('idclase', $idclase);
            $this->db_b->set('idcentro', $idcentro);
            $this->db_b->set('idproducto', $idproducto);
            $this->db_b->set('idbatch', $idbatch);
            $this->db_b->set('idbin', $idbin);
            $this->db_b->set('barcode', $barcode);
            $this->db_b->set('cantidad', $nCantidad);
            $this->db_b->set('idworker', $idworker);
            $this->db_b->set('um', $um);
            // $this->db_b->set('uniconv', $uniconv); //TODO:
            $this->db_b->set('uniconv', 1);
            $this->db_b->set('costounitario', $costounitario);
            $this->db_b->set('preciotran', $precio);
            $this->db_b->set('descuento', $nDescuento);
            $this->db_b->set('precioneto', $precioneto);
            $this->db_b->set('tax1', $tipotax);
            $this->db_b->set('notas', 'Ingresado desde App');
            $this->db_b->set('whodidit', $iduser);
            $this->db_b->set('ingresa', $fecha->format('Y-m-d H:i:s'));
            $this->db_b->insert('tran_100k');

            $this->db_b->select('a.idrec, a.trannum, b.idproducto, b.descrip, b.xpos, b.barcode, b.precioventa, b.tipotax, b.tipo, b.upp, a.tax1, a.itemline, a.um AS umVenta, a.uniconv');
            $this->db_b->select('b.imagen, b.modelo, b.um, b.marca, b.notas AS nproducto, a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, a.notas, a.idbatch, a.idbin');
            $this->db_b->from("tran_100k a");
            $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
            $this->db_b->join("inv_batch c", "a.idbatch = c.idbatch");
            $this->db_b->where("a.trannum",  $trannum);
            $this->db_b->order_by('a.itemline', 'DESC');
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $productos[] = array(
                        'idrec'         => (int) $dato->idrec,
                        'trannum'       => (int) $dato->trannum,
                        'idproducto'    => (int) $dato->idproducto,
                        'descrip'       => $dato->descrip,
                        'marca'         => $dato->marca,
                        'modelo'        => $dato->modelo,
                        'um'            => $dato->um,
                        'barcode'       => $dato->barcode,
                        'notas'         => $dato->nproducto,
                        'idbatch'       => (int) $dato->idbatch,
                        'idbin'         => (int) $dato->idbin,
                        'tax1'          => number_format($dato->tax1, 2, '.', '') * 1,
                        'cantidad'      => number_format(abs($dato->cantidad), 2, '.', '') * 1,
                        'precioneto'    => number_format($dato->precioneto, 2, '.', '') * 1,
                        'preciotran'    => number_format($dato->preciotran, 2, '.', '') * 1,
                        'costounitario' => number_format($dato->costounitario, 2, '.', '') * 1,
                        'descuento'     => number_format($dato->descuento, 2, '.', '') * 1,
                    );
                }
                
                return array_merge([
                    'status'    => 0,
                    'productos' => $productos,
                ]);
            } else {
                return array_merge([
                    'status'    => 0,
                    'productos' => [],
                ]);
            }
        }

        function modificarProducto($idaccount, $trannum, $iduser, $idrec, $tipotax, $um, $cantidad, $precio, $descuento) {
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            $this->setParamsDB($idaccount);

            $nDescuento = str_replace("%", "", $descuento);
            $precioneto = ( 1 - ( $nDescuento / 100 ) ) * $precio;
            
            if ($tipotax != 0) {
                $taxDes = ( $tipotax / 100 ) + 1;
                $precioneto = $precioneto / $taxDes;
            }

            $ConSQL  = "SELECT idclase FROM tran_100 WHERE trannum = $trannum";
            $QSQL    = $this->db_b->query($ConSQL);
            $Res     = $QSQL->row_array();
            $idclase = $Res['idclase'];

            $ConSQL2 = "SELECT inopera, exento FROM inv_def WHERE invclase = ".$idclase;
            $QSQL2   = $this->db_b->query($ConSQL2);
            $Res2    = $QSQL2->row_array();
            $inopera = $Res2['inopera'];
            $exento  = $Res2['exento'];

            $nCantidad = $cantidad * $inopera;
            
            if ($exento == 1) $tipotax = 0;

            $this->db_b->set('cantidad', $nCantidad);
            $this->db_b->set('preciotran', $precio);
            $this->db_b->set('precioneto', $precioneto);
            $this->db_b->set('descuento', $nDescuento);
            $this->db_b->set('um', $um);
            // $this->db_b->set('uniconv', $uniconv); //TODO:
            $this->db_b->set('uniconv', 1);
            $this->db_b->set('notas', 'Modificado desde App');
            $this->db_b->set('whodidit', $iduser);
            $this->db_b->set('modifica', $fecha->format('Y-m-d H:i:s'));
            $this->db_b->where('idrec', $idrec);
            $this->db_b->update('tran_100k');

            $this->db_b->select('a.idrec, a.trannum, b.idproducto, b.descrip, b.xpos, b.barcode, b.precioventa, b.tipotax, b.tipo, b.upp, a.tax1, a.itemline, a.um AS umVenta, a.uniconv');
            $this->db_b->select('b.imagen, b.modelo, b.um, b.marca, b.notas AS nproducto, a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, a.notas, a.idbatch, a.idbin');
            $this->db_b->from("tran_100k a");
            $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
            $this->db_b->join("inv_batch c", "a.idbatch = c.idbatch");
            $this->db_b->where("a.trannum",  $trannum);
            $this->db_b->order_by('a.itemline', 'DESC');
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $productos[] = array(
                        'idrec'         => (int) $dato->idrec,
                        'trannum'       => (int) $dato->trannum,
                        'idproducto'    => (int) $dato->idproducto,
                        'descrip'       => $dato->descrip,
                        'marca'         => $dato->marca,
                        'modelo'        => $dato->modelo,
                        'um'            => $dato->um,
                        'barcode'       => $dato->barcode,
                        'notas'         => $dato->nproducto,
                        'idbatch'       => (int) $dato->idbatch,
                        'idbin'         => (int) $dato->idbin,
                        'tax1'          => number_format($dato->tax1, 2, '.', '') * 1,
                        'cantidad'      => number_format(abs($dato->cantidad), 2, '.', '') * 1,
                        'precioneto'    => number_format($dato->precioneto, 2, '.', '') * 1,
                        'preciotran'    => number_format($dato->preciotran, 2, '.', '') * 1,
                        'costounitario' => number_format($dato->costounitario, 2, '.', '') * 1,
                        'descuento'     => number_format($dato->descuento, 2, '.', '') * 1,
                    );
                }
                
                return array_merge([
                    'status'    => 0,
                    'productos' => $productos,
                ]);
            } else {
                return array_merge([
                    'status'    => 0,
                    'productos' => [],
                ]);
            }
        }

        function eliminarProducto($idaccount, $trannum, $idrec) {
            $this->setParamsDB($idaccount);

            $this->db_b->delete('tran_100k', array('idrec' => $idrec));

            $this->db_b->select('a.idrec, a.trannum, b.idproducto, b.descrip, b.xpos, b.barcode, b.precioventa, b.tipotax, b.tipo, b.upp, a.tax1, a.itemline, a.um AS umVenta, a.uniconv');
            $this->db_b->select('b.imagen, b.modelo, b.um, b.marca, b.notas AS nproducto, a.cantidad, a.precioneto, a.preciotran, a.costounitario, a.descuento, a.notas, a.idbatch, a.idbin');
            $this->db_b->from("tran_100k a");
            $this->db_b->join("invproducts b", "a.idproducto = b.idproducto");
            $this->db_b->join("inv_batch c", "a.idbatch = c.idbatch");
            $this->db_b->where("a.trannum",  $trannum);
            $this->db_b->order_by('a.itemline', 'DESC');
            $datos = $this->db_b->get();
            
            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $dato) {
                    $productos[] = array(
                        'idrec'         => (int) $dato->idrec,
                        'trannum'       => (int) $dato->trannum,
                        'idproducto'    => (int) $dato->idproducto,
                        'descrip'       => $dato->descrip,
                        'marca'         => $dato->marca,
                        'modelo'        => $dato->modelo,
                        'um'            => $dato->um,
                        'barcode'       => $dato->barcode,
                        'notas'         => $dato->nproducto,
                        'idbatch'       => (int) $dato->idbatch,
                        'idbin'         => (int) $dato->idbin,
                        'tax1'          => number_format($dato->tax1, 2, '.', '') * 1,
                        'cantidad'      => number_format(abs($dato->cantidad), 2, '.', '') * 1,
                        'precioneto'    => number_format($dato->precioneto, 2, '.', '') * 1,
                        'preciotran'    => number_format($dato->preciotran, 2, '.', '') * 1,
                        'costounitario' => number_format($dato->costounitario, 2, '.', '') * 1,
                        'descuento'     => number_format($dato->descuento, 2, '.', '') * 1,
                    );
                }
                
                return array_merge([
                    'status'    => 0,
                    'productos' => $productos,
                ]);
            } else {
                return array_merge([
                    'status'    => 0,
                    'productos' => [],
                ]);
            }
        }
    }
?>