<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Api_model extends CI_Model{
		
        public function __construct() {
            date_default_timezone_set('America/El_Salvador');

            $CI =& get_instance();
            $this->db_b = $CI->load->database('default', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
            }
        }
        
        public function validacionUsuarios($nameUser, $infoPassword){
            $whereArray = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword);
            
            $this->db_b->select('idrec, idcentro, idcaja, api_rights');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereArray);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $infoQuery = $QuerySQL->row_array();
            }else{
                $infoQuery = false;
            }
                
            return $infoQuery;
        }

        public function validateTokenUser($nameUser, $infoPassword, $infoToken) {
            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => date("Y-m-d H:i:s"));
            
            $this->db_b->select('idaccount, api_user, idcentro, idcaja, descrip');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $infoUser = $QuerySQL->row_array();
                $idaccount = $infoUser['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'iduser_api'    => $infoUser['api_user'],
                    'idcentro_api'  => $infoUser['idcentro'],
                    'idcaja_api'    => $infoUser['idcaja'],
                    'api_caller'    => $infoUser['descrip'],                
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                
                return true;
            } else return false;
        }

        public function actualizacionTokenUser($idrec, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");
            $fecha_vence = strtotime('+10 minute', strtotime($fecha_actual));
            $fecha_vence = date("Y-m-d H:i:s", $fecha_vence);

            $this->db_b->set('token', $infoToken);
            $this->db_b->set('last_token', $fecha_actual);
            $this->db_b->set('vence_token', $fecha_vence);
            $this->db_b->set('modifica', $fecha_actual);
            $this->db_b->set('whodidit', 1);
            $this->db_b->where('idrec', $idrec);
            $query = $this->db_b->update('wpos_api');

            return $query;
        }

        public function getInformacionProductos($nameUser, $infoPassword, $infoToken, $infoTiendas){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

            
                $whereCentros = "";
                
                if($infoTiendas != ""){
                    $id_centros = explode("_", $infoTiendas);
                    
                    $whereCentros .= "(";
                    for($i=0; $i<count($id_centros); $i++){
                        $whereCentros .= "tran_100k.idcentro = ". $id_centros[$i] . " OR ";
                    }
                    
                    $whereCentros = substr($whereCentros, 0, -4);
                    $whereCentros .= ")";
                }
            

                $SQLConsulta = "SELECT invproducts.idproducto, invproducts.marca, invproducts.um, invproducts.descrip, invproducts.ingresa,
                invproducts.modifica, invproducts.precioventa, invproducts.imagen, invproducts.tipotax, invproducts.barcode, invproducts.idcatalogo,  invproducts.modelo, SUM(tran_100k.cantidad * tran_100k.uniconv) AS stock, 
                invcatalog.descrip AS nameLinea FROM tran_100k 
                INNER JOIN invproducts ON tran_100k.idproducto = invproducts.idproducto INNER JOIN invcatalog ON invproducts.idcatalogo = invcatalog.idcatalogo ";

                if($whereCentros != ""){
                    $SQLConsulta .= "WHERE invproducts.estado = 1 AND ".$whereCentros." GROUP BY tran_100k.idproducto"; #HAVING stock > 0
                }else{
                    $SQLConsulta .= "WHERE invproducts.estado = 1 GROUP BY tran_100k.idproducto"; #HAVING stock > 0
                }

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }

        public function getProductos($nameUser, $infoPassword, $infoToken, $infoTiendas){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);

               if($infoTiendas !=0){
                    $SQLConsulta = "SELECT a.barcode, a.idproducto, a.descrip, a.um, a.precioventa, Sum(b.cantidad*b.uniconv) As stock, a.tipo FROM invproducts a INNER JOIN tran_100k b ON a.idproducto = b.idproducto WHERE b.idcentro =".$infoTiendas." AND a.tipo <=2 GROUP BY a.idproducto
                    UNION SELECT c.descrip AS barcode, c.idproducto, d.descrip,d.um,d.precioventa, Sum(e.cantidad*e.uniconv) AS stock, d.tipo FROM invpromulti c INNER JOIN invproducts d ON c.idproducto = d.idproducto AND c.idgvar = 2 INNER JOIN tran_100k e ON d.idproducto = e.idproducto WHERE e.idcentro =".$infoTiendas." AND d.tipo<=2 GROUP BY c.descrip
                    ORDER BY idproducto,barcode";
               }else{
                    $SQLConsulta = "SELECT a.barcode, a.idproducto, a.descrip, a.um, a.precioventa, a.descuento As stock, a.tipo FROM invproducts a  WHERE a.tipo <=2 GROUP BY a.idproducto
                    UNION SELECT c.descrip AS barcode, c.idproducto, d.descrip,d.um,d.precioventa, d.descuento AS stock, d.tipo FROM invpromulti c INNER JOIN invproducts d ON c.idproducto = d.idproducto AND c.idgvar = 2 WHERE d.tipo<=2 GROUP BY c.descrip
                    ORDER BY idproducto,barcode";           
               }   
  
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }

        public function getClientes($nameUser, $infoPassword, $infoToken, $infotipo){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                If($infotipo !=0){
                    $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef FROM ctauxi WHERE estado=1 AND idauxidef=".$infotipo." ORDER by descrip";    
                }else{
                    $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef FROM ctauxi WHERE estado=1";    
                }                              
                 
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }        
        
        public function getTest($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT tipo,archivo,contenido FROM test_db";
                                              
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }        

        public function getInformacionCategorias($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                
                $this->db_b->select('idcatalogo, idnivel1, posicion, descrip, nivel');
                $this->db_b->from('invcatalog');
                $this->db_b->where('estado', 1);
                $infoResultado = $this->db_b->get()->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }

        public function generacionDeOrden($infoItems) {
            
            $infoHeader = array(
                'trannum'  => 0,
                'fecha'    => date("Y-m-d"),
                'idcentro' => $this->session->userdata('idcentro_api'),
                'agrupa'   => 'SJ',
                'descrip'  => 'Generación de Orden por usuario API ('.$this->session->userdata('api_caller').')',
                'estatus'  => 0,
                'notas'    => 'Registros importado desde WebApi/Ordenes >',
                'whodidit' => $this->session->userdata('iduser_api'),
                'ingresa'  => date('Y-m-d H:m:i')
            );
            $this->db_b->insert('orders_100', $infoHeader);
            $trannum = $this->db_b->insert_id();

            $i=0;
            foreach($infoItems as $item) {
                $i++;

                $infoLines = array(
                    'idrec'       => 0,
                    'trannum'     => $trannum,
                    'itemline'    => $i,
                    'idproducto'  => $item->prod_id,
                    'cantidad'    => $item->prod_qty,
                    'uniconv'     => 1,
                    'precioneto'  => $item->prod_price,
                    'notas'       => 'Registro importado desde WebApi/Ordenes',
                    'whodidit'    => $this->session->userdata('iduser_api'),
                    'ingresa'     => date('Y-m-d H:m:i')
                );

                $this->db_b->insert('orders_100k', $infoLines);
            }
            
            return $i;
        }

        public function getListaEnvios($nameUser, $infoPassword, $infoToken, $idcentrod){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT tran_100.trannum,tran_100.fecha,invsites.descrip AS notas,tran_100.lines100k FROM tran_100 INNER JOIN invsites ON tran_100.idcentro=invsites.idcentro WHERE tran_100.idcentrod=".$idcentrod." AND tran_100.estatus=1";
                                              
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }   
        public function getListaDetalleEnvio($nameUser, $infoPassword, $infoToken, $trannum){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                //$SQLConsulta = "SELECT tran_100.trannum,tran_100.fecha,invsites.descrip AS notas,tran_100.lines100k FROM tran_100 INNER JOIN invsites ON tran_100.idcentro=invsites.idcentro WHERE tran_100.idcentrod=".$idcentrod." AND tran_100.estatus=1";
                $SQLConsulta = "SELECT tran_100k.idrec,tran_100k.idclase,tran_100k.itemline,tran_100k.idproducto,invproducts.descrip,tran_100k.idbatch,invlocations.idbin,ABS(tran_100k.cantidad) AS cantidad,tran_100k.um,tran_100k.uniconv,tran_100k.costounitario FROM tran_100k
                INNER JOIN tran_100 ON tran_100k.trannum=tran_100.trannum INNER JOIN invlocations ON invlocations.idcentro=tran_100.idcentrod INNER JOIN invproducts ON tran_100k.idproducto=invproducts.idproducto  WHERE tran_100k.trannum=".$trannum." ORDER BY tran_100k.itemline";                
                
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }    
        
        public function generaEnvios($infoItems) {
            
            $infoHeader = array(
                'trannum'  => 0,
                'idcentro' => $this->session->userdata('idcentro_api'),
                'idclase'  => 4,
                'fecha'    => date("Y-m-d"),
                'estatus'  => 1,
                'idcentrod'=> 0,
                'tranref'  => '1234',
                'descrip'  => 'Generación de Orden por usuario API ('.$this->session->userdata('api_caller').')',
                'estatus'  => 0,
                'notas'    => 'Registros importados desde WebApi/Enviosr >',
                'whodidit' => $this->session->userdata('iduser_api'),
                'ingresa'  => date('Y-m-d H:m:i')
            );
            $this->db_b->insert('tran_100', $infoHeader);
            $trannum = $this->db_b->insert_id();

            $i=0;
            foreach($infoItems as $item) {
                $i++;

                $infoLines = array(
                    'idrec'       => 0,
                    'trannum'     => $trannum,
                    'idclase'     => 4,
                    'itemline'    => $item->itemline,
                    'idcentro'    => $this->session->userdata('idcentro_api'),
                    'idproducto'  => $item->idproducto,
                    'idbatch'     => $item->idbatch,
                    'idbin'       => $item->idbin,
                    'cantidad'    => $item->cantrec,
                    'um'          => $item->um,
                    'uniconv'     => 1,
                    'costounitaio'=> $item->costounit,
                    'notas'       => 'Registro importado desde WebApi/Enviosr',
                    'whodidit'    => $this->session->userdata('iduser_api'),
                    'ingresa'     => date('Y-m-d H:m:i')
                );

                $this->db_b->insert('tran_100k', $infoLines);
            }
            
            return $i;
        }
        
        public function getVars($nameUser, $infoPassword, $infoToken, $vnombre){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                             
                $SQLConsulta = "SELECT nombre,descripcion,valor_num,valor_txt,valor_memo FROM gvars WHERE nombre=$vnombre";                              

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }      
        
        public function getivadef($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT ivclase,descrip,idlibro,xpos,notas FROM iva_def WHERE estatus=1";                              

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }   

        public function getCtSites($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT idcentro,descrip,xpos,idbin FROM invsites WHERE estatus=1";                              

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }        

        public function getCtcuentas($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT idctcuenta,descrip,tipocuenta,ctcontrol,useauxi,askidcentro,askidproyecto,xpos FROM ctcuenta WHERE estatus=1 ORDER BY idctcuenta ";    
                
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }    
        
        public function validaPartida($nameUser, $infoPassword, $infoToken, $auxref){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT pnumero,estatus FROM ct_100 WHERE auxref=$auxref";                         

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }      

        public function generaPartida($infoItems) {
                     
            $i=0;
            foreach($infoItems as $item) {
                if ( $i == 0 ) {
                    $infoHeader = array(
                        'pnumero'    => 0,
                        'idyear'     => $item->idyear,
                        'idptipo'    => $item->idptipo,
                        'idsite'     => $item->idsite,
                        'descrip'    => $item->descriph,
                        'fecha'      => $item->fecha,
                        'referencia' => $item->referencia,      
                        'auxref'     => $item->auxref,                      
                        'origen'     => 'Goxpos.app',
                        'itemcount'  => $item->itemcount,      
                        'estatus'    => 0,
                        'chg_log'    => date('Y-m-d H:m:i').','.$this->session->userdata('iduser_api').',Inserción',
                        'whodidit'   => $this->session->userdata('iduser_api'),
                        'ingresa'    => date('Y-m-d H:m:i')
                    );
                    $this->db_b->insert('ct_100', $infoHeader);
                    $trannum = $this->db_b->insert_id();
                }

                $i++;

                $infoLines = array(
                    'idrec'       => 0,
                    'pnumero'     => $trannum,
                    'itemline'    => $item->itemline,
                    'fecha'       => $item->fecha,
                    'idctcuenta'  => $item->idctcuenta,
                    'idtabla'     => $item->idtabla,
                    'idauxi'      => $item->idauxi,
                    'sidauxidef'  => $item->sidauxidef,
                    'idcentro'    => $item->idcentro,
                    'idproject'   => $item->idproject,
                    'descrip'     => $item->descrip,
                    'doc_type'    => $item->doc_type, 
                    'doc_serie'   => $item->doc_serie,
                    'doc_numero'  => $item->doc_numero,         
                    'doc_emision' => $item->fecha,             // Added 20240422                            
                    'doc_vence'   => $item->fecha,             // Added 20240422                                                
                    'debe'        => $item->debe, 
                    'haber'       => $item->haber, 
                    'estatus'     => 0,
                    'notas'       => 'Registro importado desde WebApi generaPartida',
                    'chg_log'     => date('Y-m-d H:m:i').','.$this->session->userdata('iduser_api').',Inserción',                    
                    'whodidit'    => $this->session->userdata('iduser_api'),
                    'ingresa'     => date('Y-m-d H:m:i')
                );

                $this->db_b->insert('ct_100d', $infoLines);
            }
            
            return $trannum;
        }

        public function getGenfunc($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                              
                $SQLConsulta = "SELECT partipo,tipo,posicion,funcion,descrip,idcentros,idcajas,idclases,cajclases,invcatalogs,iddptos,idlineas,dh,idcuenta,idauxi,notas FROM conta_genfunc WHERE estado=1 ORDER BY partipo ";    

                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }     
        
        public function getCtauxi($nameUser, $infoPassword, $infoToken, $infotipo){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                If($infotipo !=0){
                    $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef,xpos FROM ctauxi WHERE idauxidef=".$infotipo." ORDER by descrip";    
                    // $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef,xpos FROM ctauxi WHERE estado=1 AND idauxidef=".$infotipo." ORDER by descrip";    
                }else{
                    $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef,xpos FROM ctauxi";    
                    // $SQLConsulta = "SELECT idauxi,descrip,telefono,nit,nrc,dui,idauxidef,xpos FROM ctauxi WHERE estado=1";    
                }                              
                 
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }        
        public function getCtpdef($nameUser, $infoPassword, $infoToken){
            date_default_timezone_set('America/El_Salvador');
            $fecha_actual = date("Y-m-d H:i:s");

            $whereValidate = array('estado' => 1, 'iduser' => $nameUser, 'clave' => $infoPassword, 'token' => $infoToken, 'vence_token >' => $fecha_actual);
            
            $this->db_b->select('idaccount');
            $this->db_b->from('wpos_api');
            $this->db_b->where($whereValidate);
            $this->db_b->limit(1);
            $QuerySQL = $this->db_b->get();
            
            if($QuerySQL->num_rows() > 0){
                $informacion = $QuerySQL->row_array();
                $idaccount = $informacion['idaccount'];
                
                $this->db_b->select('idaccount, descrip, dbp1, dbp2, dbp3, dbp4, server_name, moneda');
                $this->db_b->from('wpos_cuentas');
                $this->db_b->where('idaccount', $idaccount);
                $this->db_b->limit(1);
                $AcQuery = $this->db_b->get();
                $infoCuenta = $AcQuery->row_array();

                $CuentaArray = array(
                    'idaccount'     => $infoCuenta['idaccount'],
                    'descrip'       => $infoCuenta['descrip'],
                    'server_name'   => $infoCuenta['server_name'],
                    'serverDB'      => $infoCuenta['dbp1'],
                    'nameDB'        => $infoCuenta['dbp2'],
                    'userDB'        => $infoCuenta['dbp3'],
                    'passDB'        => $infoCuenta['dbp4'],
                    'simboloMoneda' => $infoCuenta['moneda']
                );
                $this->session->set_userdata($CuentaArray);

                $CI =& get_instance();
                $this->db_b = $CI->load->database('user_db', TRUE);
                $SQLConsulta = "SELECT idptipo,descrip,xpos FROM ctpdef WHERE estatus=1 And idptipo > 2";    
                                 
                $query = $this->db_b->query($SQLConsulta);
                $infoResultado = $query->result();
            }else{
                $infoResultado = false;
            }

            return $infoResultado;
        }        

        public function writeCtauxi($infoItems) {                   
            $i=0;
            foreach($infoItems as $item) {
                if ( $i == 0 ) {
                    $infoHeader = array(
                        'idauxi'      => 0,
                        'descrip'     => $item->descrip,
                        'idauxidef'   => $item->idauxidef,
                        'telefono'    => $item->telefono,
                        'correo'      => $item->correo,
                        'idzip'       => $item->idzip,
                        'fechain'     => $item->fechain,      
                        'nrc'         => $item->nrc,                      
                        'dui'         => $item->dui,
                        'nit'         => $item->nit,                      
                        'giro'        => $item->giro,                      
                        'dte_giro'    => $item->dte_giro,                                              
                        'grupo'       => $item->grupo,                                              
                        'limite'      => $item->limite,                     
                        'dias'        => $item->dias,                      
                        'xpos'        => $item->xpos,                                                                                               
                        'idcps'       => $item->idcps,                      
                        'idtipo'      => $item->idtipo,                                              
                        'sidauxidef'  => $item->sidauxidef,                                              
                        'estado'      => 1, 
                        'notas'       => $item->notas,                         
                        'whodidit'    => $this->session->userdata('iduser_api'),
                        'ingresa'     => date('Y-m-d H:m:i')
                    );
                    $this->db_b->insert('ctauxi', $infoHeader);
                    $idauxi = $this->db_b->insert_id();
                }
                $i++;
            }
            return $idauxi;
        }       
        

    }

?>