<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	class Agenda_model extends CI_Model {

		public function __construct(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        }

        function getInfoServicios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('a.idproducto, a.descrip, b.descrip AS categoria');
                $this->db_b->from("invproducts a");
                $this->db_b->join("invcatalog b", 'a.idcatalogo = b.idcatalogo');
                $this->db_b->where('a.tipo', 4);
                $this->db_b->where('a.estado', 1);
                $this->db_b->order_by('b.descrip, a.descrip');
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->idproducto,
                            'descrip' => $dato->descrip,
                            'categoria' => $dato->categoria
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getInfoClientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip, telefono, correo, fechain');
                $this->db_b->from("ctauxi");
                $this->db_b->where('idauxidef', 2);
                $this->db_b->where('estado', 1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'       => (int) $dato->idauxi,
                            'descrip'  => $dato->descrip,
                            'telefono' => $dato->telefono,
                            'correo'   => $dato->correo,
                            'fecha'   => $dato->fechain
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function getInfoAsesores(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db_b->select('idauxi, descrip');
                $this->db_b->from("ctauxi");
                $this->db_b->where('idauxidef', 3);
                $this->db_b->where('estado', 1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $array[] = array(
                            'id'      => (int) $dato->idauxi,
                            'descrip' => $dato->descrip
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function adicionarCliente($nombre, $telefono, $correo, $fechanac) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('idauxi', 0);
                $this->db_b->set('descrip', $nombre);
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo', $correo);
                $this->db_b->set('fechain', $fechanac);
                $this->db_b->set('idauxidef', 2);
                $this->db_b->set('estado', 1);
                $this->db_b->set('notas', 'Creado desde Calendario de Citas');
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('ctauxi');

                return $query;
            }
        }

        function getInformacionCalendario($idcentro) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');

                $this->db_b->select('a.trannum, a.dev_date, a.dev_time, a.descrip, b.descrip AS nameService, a.cli_phone, a.cli_email');
                $this->db_b->select('a.idcps, a.idworker, a.notas, a.dev_date, a.dev_time, c.descrip AS nCliente, c.fechain');
                $this->db_b->from('orders_100 a');
                $this->db_b->join('invproducts b', 'a.descrip = b.idproducto');
                $this->db_b->join('ctauxi c', 'a.idcps = c.idauxi');
                $this->db_b->where('a.idcentro', $idcentro);
                $this->db_b->where('a.estatus', 1);
                $datos = $this->db_b->get();

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $dato) {
                        $pHoras = explode(':', $dato->dev_time);

                        if ($pHoras[1] == 30) {
                            $endDate = strtotime($dato->dev_date.str_pad($pHoras[0] + 1, 2, '0', STR_PAD_LEFT).':00:00');
                        } else $endDate = strtotime($dato->dev_date.str_pad($pHoras[0], 2, '0', STR_PAD_LEFT).':30:00');

                        $array[] = array(
                            'trannum'   => $dato->trannum,
                            'text'      => $dato->nameService,
                            'idservice' => (int) $dato->descrip,
                            'telefono'  => $dato->cli_phone,
                            'correo'    => $dato->cli_email,
                            'idcps'     => (int) $dato->idcps,
                            'nCliente'  => $dato->nCliente,
                            'idworker'  => (int) $dato->idworker,
                            'notas'     => $dato->notas,
                            'dev_date'  => $dato->dev_date,
                            'dev_time'  => $dato->dev_time,
                            'fechain'   => $dato->fechain,
                            'startDate' => date("Y-m-d H:i:s", strtotime($dato->dev_date.$dato->dev_time)),
                            'endDate'   => date("Y-m-d H:i:s", $endDate)
                        );
                    }
                    return $array;
                } else return false;
            }
        }

        function insertAppointment($idcentro, $fecha, $hora, $service, $idauxi, $telefono, $correo, $fechanac, $idworker, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo',   $correo);
                $this->db_b->set('fechain',  $fechanac);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idauxi);
                $this->db_b->update('ctauxi');

                $this->db_b->set('trannum', 0);
                $this->db_b->set('idcentro', $idcentro);
                $this->db_b->set('agrupa', 'CL');
                $this->db_b->set('fecha', $date->format('Y-m-d'));
                $this->db_b->set('descrip', $service);
                $this->db_b->set('cli_phone', $telefono);
                $this->db_b->set('cli_email', $correo);
                $this->db_b->set('dev_date', $fecha);
                $this->db_b->set('dev_time', $hora);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('ingresa', $date->format('Y-m-d H:i:s'));
                $query = $this->db_b->insert('orders_100');

                return $query;
            }
        }
        
        function modificarAppointment($trannum, $hora, $service, $idauxi, $telefono, $correo, $fechanac, $idworker, $notas) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->db_b->set('telefono', $telefono);
                $this->db_b->set('correo',   $correo);
                $this->db_b->set('fechain',  $fechanac);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('idauxi', $idauxi);
                $this->db_b->update('ctauxi');

                $this->db_b->set('descrip', $service);
                $this->db_b->set('cli_phone', $telefono);
                $this->db_b->set('cli_email', $correo);
                $this->db_b->set('dev_time', $hora);
                $this->db_b->set('idcps', $idauxi);
                $this->db_b->set('idworker', $idworker);
                $this->db_b->set('estatus', 1);
                $this->db_b->set('notas', $notas);
                $this->db_b->set('whodidit', $this->session->userdata('iduser'));
                $this->db_b->set('modifica', $date->format('Y-m-d H:i:s'));
                $this->db_b->where('trannum', $trannum);
                $query = $this->db_b->update('orders_100');

                return $query;
            }
        }
        
        function eliminarAppointment($trannum) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                return $this->db_b->query('DELETE FROM orders_100 WHERE trannum = ' . $trannum);
            }
        }
	}
?>