<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    class comandosTM{
        //Inicializa la impresora, reiniciando los datos de impresion guardados
        const Initialize = '0x1B'.'@';
        
        #       Seleccion de bandeja

        //Impresion en journal
        const PrintJournal = '0x1B'.'c0'.'0x1 ';
        
        //Impresion de ticket
        const PrintTicket = '0x1B'.'c0'.'0x2 '; 
        
        //Impresion de ticket y journal
        const PrintBoth = '0x1B'.'z'.'0x1 '.'0x1B'.'c0'.'0x2 '.'0x1B'.'c0'.'0x3 ';

        //Impresion de slip
        const PrintSlip = '0x1B'.'c0'.'0x4 ';
        
        #       Varios

        //Salto de linea
        const LineFeed = '0x0A';
        
        //Alimentacion de papel tras impresion
        const FormFeed = '0x0C';
        
        //Abrir cajon 
        const OpenDrawer = '0x1B'.'0x70'.'0x00'.'0x19'.'0xFA';

        //Corte de pagina a la mitad
        const HalfCut = '0x1D'.'0x56'.'0x0';
        
        //Corte de pagina completo
        const FullCut = '0x1D'.'0x56'.'0x1';  

        //Corte de pagina completo para TM950
        const FullCut950 = '0x1B'.'i'; 
        
        #       Tamaño de fuente

        //Fuente tamaño pequeño
        const FontSmall = '0x1B'.'0x21'.'0x01';

        const FontSmallFX890 = '0x0F'; //Font Samll for FX-890 printer
        
        //Fuente tamaño pequeño
        const FontNormal = '0x1B'.'0x21'.'0x00';
        
        //Fuente tamaño grande
        const FontBig = '0x1B'.'0x21'.'0x30';
        
        //Fuente doble ancho
        const FontDoubleWidth = '0x1B'.'0x21'.'0x20';
        
        //Fuente doble alto
        const FontDoubleHeight = '0x1B'.'0x21'.'0x10';

        #       Caracteres especiales Ñ - ñ

        //Letra Ñ Mayuscula 
        const NtildeMayuscula = '0xA5';

        //Letra ñ Minuscula 
        const NtildeMinuscula = '0xA4';

        #       Caracteres especiales Epson TM-m30

        //Simbolo de grado °
        const Grades = '0xF8';
        
        #       Diseño de fuente

        //Habilitar subrayado
        const FontUnderlineEnable = '0x1B'.'0x2D'.'0x1 ';
        
        //Deshabilitar subrayado
        const FontUnderlineDisable = '0x1B'.'0x2D'.'0x0 ';
        
        //Habilitar negrita
        const FontBoldEnable = '0x1B'.'0x45'.'0x01';
        
        //Deshabilitar negrita
        const FontBoldDisable = '0x1B'.'0x45'.'0x00';
        
        #       Alineacion de texto

        //Alinear a la izquierda
        const TextAlignLeft = '0x1B'.'0x61'.'0x00';
        
        //Alinear al centro
        const TextAlignCenter = '0x1B'.'0x61'.'0x01';
        
        //Alinear a la derecha
        const TextAlignRight = '0x1B'.'0x61'.'0x02';

        const LocaleSpanish = '0x1B'.'0x74'.'0x3';  

        #       Comandos Impresion Imagen Codigo QR
        
        function generarQRCode($urlCode, $sizeQR) {
            // QR Model...
            $cmds = "0x1D"."0x28"."0x6B"."0x04"."0x00"."0x31"."0x41"."0x50"."0x00";
            
            // QR Size... 
            $cmds .= "0x1D"."0x28"."0x6B"."0x03"."0x00"."0x31"."0x43"."0x".str_pad(strtoupper(dechex($sizeQR)), 2, "0", STR_PAD_LEFT);

            // QR Error...
            $cmds .= "0x1D"."0x28"."0x6B"."0x03"."0x00"."0x31"."0x45"."0x31";

            // Almacenar datos
            $dataLen = strlen($urlCode) + 3;
            $pL      = chr($dataLen % 256);
            $pH      = chr(floor($dataLen / 256));
            $cmds   .= "0x1D"."0x28"."0x6B" . $pL . $pH . "0x31"."0x50"."0x30" . $urlCode;
            
            // QR Print...
            $cmds .= "0x1D"."0x28"."0x6B"."0x03"."0x00"."0x31"."0x51"."0x30";

            return $cmds;
        }

        #       FUNCIONES

        //Añade la cantidad indicada de espacios en blanco
        function pad($padLength){
            return str_pad("", $padLength);
        }

        //Añade la cantidad indicada de espacios en blanco a un texto, indicandole la direccion donde se insertaran los espacios
        function padText($text, $padLength, $padDirection){
            if($padDirection === "LEFT")
                return str_pad($text, $padLength, " ", STR_PAD_LEFT);
            if($padDirection === "RIGHT")
                return str_pad($text, $padLength, " ", STR_PAD_RIGHT);
            if($padDirection === "BOTH")
                return str_pad($text, $padLength, " ", STR_PAD_BOTH);
        }

        //Añade una imagen a partir de su codigo almacenado en la memoria NV, los parametros tienen que ser en codigo hexadecimal
        function insertarImagenNV($codigoA, $codigoB){
            return '0x1D'.'0x28'.'0x4C'.'0x06'.'0x00'.'0x30'.'0x45'.'0x'.$codigoA.'0x'.$codigoB.'0x01'.'0x01';
        }



        /*  COMANDOS BLUETOOTH */

        //Establece los parametros iniciales de impresion
        //Debe ser siempre el primer comando dentro del script del formato a imprimir
        function initializeBt($printerMac, $urlPlugin = 'http://localhost:8000'){
            $comando = "
                <script src='".base_url()."assets/js/js_devexpress/jquery-3.1.0.min.js'></script>
                <script src='".base_url()."assets/js/ConectorEscposAndroid.js'></script>
                <script src='".base_url()."assets/js/barcode.js'></script>

                <script type='text/javascript'>
                    var mac = '".$printerMac."';
                    var urlplugin = '".$urlPlugin."';
                    const conector = new ConectorEscposAndroid(null, urlplugin);
                    
                    conector
                    .Iniciar()
            ";

            return $comando;
        }
        
        //Alineacion de texto
        function textAlignBt($align){
            if($align === "LEFT")
                return ".EstablecerAlineacion(ConectorEscposAndroid.ALINEACION_IZQUIERDA)";
            if($align === "CENTER")
                return ".EstablecerAlineacion(ConectorEscposAndroid.ALINEACION_CENTRO)";
            if($align === "RIGHT")
                return ".EstablecerAlineacion(ConectorEscposAndroid.ALINEACION_DERECHA)";
        }

        //Impresion de texto
        function textBt($text){
            return ".EscribirTexto('".$text."')";
        }

        function fontBold($bool){
            return ".EstablecerEnfatizado(!!".$bool.")";
        }

        //Salto de linea
        function lineFeedBt($cant){
            return ".Feed(".$cant.")";
        }

        //Corte de la impresora
        function fullCutBt(){
            return ".Corte(1)";
        }

        //Finaliza el script y manda a imprimir
        //Siempre debe ir de ultimo
        function finalizeBt(){
            return "
                const respuesta = conector.imprimirEn(mac);
                </script>
            ";
        }
        
    }

?>