<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
    class Webtoken extends CI_Controller{
        
        function __construct(){
            if(session_status() == PHP_SESSION_NONE){
                session_start();
            }
            
            parent::__construct();
            $this->load->model('api_model');
        }

        public function index(){
            if(!isset($_GET['user_name'])){
                //header("WWW-Authenticate: Basic realm=\"Private Area\"");
                //header("HTTP/1.0 401 Unauthorized");

                //echo print_r($_SERVER);
                //echo "Usuario: " . $_SERVER['PHP_AUTH_USER'];
                echo json_encode($array = array("message" => "Error. No posees las credenciales para accesar"));
            }else{
                $infoCodigo = $this->api_model->validacionUsuarios($_GET['user_name'], $_GET['password']);
                
                if($infoCodigo != false){
                    $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
                    $payload = json_encode(['user_id' => $_GET['user_name']]);
                    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
                    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
                    
                    // Create Signature Hash
                    $codeRandom = rand(1000, 9999);
                    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, 'Egga$2019' . $codeRandom, true);
                    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
                    
                    // Create JWT
                    $infoKeyJWT = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
                    
                    $this->api_model->actualizacionTokenUser($infoCodigo, $infoKeyJWT);

                    echo json_encode($array = array("acces_token" => $infoKeyJWT));
                }else{
                    //header("WWW-Authenticate: Basic realm=\"Private Area\"");
                    //header("HTTP/1.0 401 Unauthorized");

                    echo json_encode($array = array("message" => "Error. Datos de credenciales invalidos."));
                }
            }
        }
    }
?>