<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{

        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
		}

		function centimos(){
			global $importe_parcial;

			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";

				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";

				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}

			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;

			$numero = trim($numero);

			$importe_parcial = $numero;

			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}

		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LEGAL', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 0, 0, 0);
                $pdf->SetAutoPageBreak(FALSE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LEGAL' );
				$this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');

				$informacion = $this->ventas_model->getDatosFactura($trannum);

				foreach($informacion as $info){
					$numeroRecibo = $info->numero;
					$fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
					$cliente = $info->idcps.'-'.$info->nameCliente;
					$nrc = $info->nrc;
					$direccion = $info->direccion;
				}

				$productos = $this->invtran_model->getDataTran100k($trannum);

				$estructura = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';

                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                $productos = $this->acs_model->getDataVenta100k($trannum);

				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';

				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;

                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}

						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';

						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';

						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }

				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}

                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);

                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';

                //SEGUNDA COPIA
                $estructura.= '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';


                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
				$productos = $this->invtran_model->getDataTran100k($trannum);

				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';

				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;

                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}

						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';

						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';

						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }

				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}

                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);

                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';

                //TERCERA COPIA
				$estructura .= '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';

				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
				$productos = $this->invtran_model->getDataTran100k($trannum);

				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';

				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;

                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}

						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';

						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';

						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }

				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}

                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);

                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';

				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Factura.pdf");

				$js = "print(true);";
				/*$js = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					var datos = {trannum: ".$trannum."}
					$.ajax({
						type:'POST',
						url: '".base_url()."compras/imprimirTicketEposFinal',
						dataType: 'json',
						data: datos,
						success: function(data){
							window.blur();
							var datosprinter = data.datos_print.split('/');
							var ipaddr = '192.168.1.55';
							var devid = datosprinter[1];
							var timeout = '60000';
							var grayscale = false;
							var layout = false;
							var efectivopago = data.efectivo;

							var ticketObj = new epson.ePOSBuilder();
							ticketObj.addPulse();
                            var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);
							epos.send(ticketObj.toString());
						}
					});
				</script>";*/
				$pdf->IncludeJS($js);
				$pdf->Output($nombre_archivo, 'I');
			}
		}

        function printDevolucion($trannum){
			date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;

								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText('DEVOLUCIÓN' + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento;
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();

										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}

										if(numCantidad == 1){
											var strCantidad = '       -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '      -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '     -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '    -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '   -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '  -' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '   ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '      -' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     -' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '    -' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '   -' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '      -' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '     -' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '    -' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '   -' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								totalSumas = parseFloat(totalSumas) * -1;

								if(totalExento != 0){
									totalExento = parseFloat(totalExento) * -1;
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);
								if(grantotal != 0){
									grantotal = parseFloat(grantotal) * -1;
								}

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}


								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								total = parseFloat(total) * -1;

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}


								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								if(totalDesc != 0){
									ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								}
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '       -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '      -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '     -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '    -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}

									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}

								total = parseFloat(total) * -1;
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								if(totalVuelto != 0){
									ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								}
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();

                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }

								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}

        function print_etiquetas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 16, 0);
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
                $cant = 0;

				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $productos = $this->compras_model->getProductosCompra($trannum);
                $marcas = $this->compras_model->getMarcasCompra($trannum);

                $estructura = '<table style="width:100%;">';
                $num_rows=0;
                $alto = 10.5;
                foreach($marcas as $mar){
                    $primera = true;
                    foreach($productos as $pro){

                        if($mar->marca==$pro->marca){
                            $actual=0;
                            $cant_etiquetas= $pro->cantidad;
                            if($primera == true){
                                $primera=false;
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }
                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }
                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                            }

                            do{
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;margin:0px;width:25%;">
                                            <table style="padding:0px;margin:0px;">
                                            <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                    <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                </td>
                                            </tr>
                                            </table>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }

                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }

                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                                $actual++;
                            }while($cant_etiquetas!=$actual);
                        }
                    }

                    if($cant==0){
                        if($num_rows==20){
                            $estructura .= '
                            <tr style="padding:0px;margin:0px;" nobr="true">
                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                            </td>';
                            $num_rows=0;
                        }else{
                            if($num_rows>10){
                                $alto=9.7;
                            }else{
                                $alto=10.5;
                            }
                            if($num_rows==0){
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }else{
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }
                        }
                        $cant++;
                    }else if($cant==1){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==2){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==3){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td></tr>';
                        $cant=0;
                        $num_rows++;
                    }
                }

                if($cant!=0){
                    while($cant<=3){
                        $estructura .= '<td style="text-align:left;width:25%;"></td>';
                        $cant++;
                    }
                    $estructura .= '</tr>';
                }

                $estructura .= '</table>';
                //echo $estructura;
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //$pdf->writeHTMLCell(0, 0, '', '', $estructura, 0, 1, 0, true, '', true);

                $nombre_archivo = utf8_decode("Factura.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }

		function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 23%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}

				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';

				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }

                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){

                            $valtax_product = 0;


                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }

                            $valtot=$ven->valventan + $valtax_product;

                            $subtotal= $subtotal+$valtot;

							$date = date_format(date_create($ven->fecha),'d/m/Y');

							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);

							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }

								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }

								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }

								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }

								}
							}

							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;

							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}

							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}

							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 23%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }

							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;

                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';

                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';

                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';



                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}

		function ventaTicketFinal($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;

								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addLogo(34, 34);
								ticketObj.addFeedLine(1);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento;
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();

										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}

									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}

								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();

                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }

								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}

		function ventaTicketElectronico($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');

                $this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				$this->load->model('empleado_model');
                $this->load->model('sucursal_model');
				$this->load->model('caja_model');

                $informacion = $this->ventas_model->getDatosFactura($trannum);

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $info->nameCliente;
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $info->direccion;
                    $giro = $info->giro;
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                }
                
                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

                foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}

                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$correoelectronico = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;

                $partFechaName = explode("/", $fechaRecibo);
                $archivoXML = fopen("doc_cuentas/".$this->session->userdata('dirDocuments')."/Tiquete".$trannum.".xml",'w+');

                $contenidoXML = '<?xml version="1.0" encoding="UTF-8"?>';
				fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            //Apertura de Tiquete Electronico......
				$contenidoXML = '<TiqueteElectronico xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="https://www.hacienda.go.cr/ATV/docs/esquemas/2017/v4.2/tiqueteElectronico">';
				fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $numeroConsecutivo = ''; $claveNumerica = '';

	            $formatSucursal = str_pad($idcentro, 3, 0, STR_PAD_LEFT);
	            $numeroConsecutivo .= $formatSucursal;

	            $identTerminal = '00001';
				$numeroConsecutivo .= $identTerminal;

				$tipoComprobante = '04';
				$numeroConsecutivo .= $tipoComprobante;

				$formatNumero = str_pad($numeroRecibo, 10, 0, STR_PAD_LEFT);
				$numeroConsecutivo .= $formatNumero;

	            $contenidoXML = '<Clave>' . $numeroConsecutivo . '</Clave>';
				fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $claveNumerica .= '506';

	            $partesFechaClave = explode("/", $fechaRecibo);
	            $claveNumerica .= $partesFechaClave[0] . $partesFechaClave[1] . substr($partesFechaClave[2], 2, 4);

	            $claveNumerica .= str_pad('3101729200', 11, 0, STR_PAD_LEFT);
	            $claveNumerica .= $numeroConsecutivo;

	            $claveNumerica .= '1';

	            //Codigo de Seguridad Sistema....
	            $codigoSeguridad = str_pad($trannum, 9, 0, STR_PAD_LEFT);
	            $claveNumerica .= $codigoSeguridad;

	            $contenidoXML = '<NumeroConsecutivo>'.$numeroConsecutivo.'</NumeroConsecutivo>';
				fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $contenidoXML = '<FechaEmision>'.$fechaRecibo.'</FechaEmision>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            //Apertura de Emisor...
	            $contenidoXML = '<Emisor>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<Nombre>'.$RazonSocial.'</Nombre>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<Identificacion>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

			            $contenidoXML = '<Tipo>01</Tipo>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            $contenidoXML = '<Numero>'.$NIT.'</Numero>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '</Identificacion>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");
		            
		            $contenidoXML = '<Ubicacion>'.$direccion.'</Ubicacion>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");
		            
		            $contenidoXML = '<CorreoElectronico>'.$correoelectronico.'</CorreoElectronico>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

	            //Cierre de Emisor...
	            $contenidoXML = '</Emisor>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $contenidoXML = '<Receptor>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            	$contenidoXML = '<Nombre>'.strtoupper($cliente).'</Nombre>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

	            $contenidoXML = '</Receptor>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $contenidoXML = '<CondicionVenta>01</CondicionVenta>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
				foreach($detailPagos as $infoPago){
					$contenidoXML = '<MedioPago>'.str_pad($infoPago->cajclase, 2, 0, STR_PAD_LEFT).'</MedioPago>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");
				}

	            $contenidoXML = '<DetalleServicio>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

				$productos = $this->invtran_model->getDataTran100k($trannum);

				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento;
				$vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
				$cantidades = 0; $totalSumas = 0;

                foreach($productos as $pro){
                	$contenidoXML = '<LineaDetalle>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

	            	$contenidoXML = '<NumeroLinea>'.($numProd + 1).'</NumeroLinea>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<Codigo>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            	$contenidoXML = '<Tipo>01</Tipo>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            $contenidoXML = '<Codigo>'.$pro->idproducto.'</Codigo>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '</Codigo>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<Cantidad>'.abs($pro->cantidad).'</Cantidad>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<UnidadMedida>'.$pro->um.'</UnidadMedida>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<Detalle>'.$pro->descrip.'</Detalle>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");
		            
		            if($pro->descuento != 0){
		            	if($pro->tipotax != 0 && $invexento == 0){
		            		$precioUnita = $pro->preciotran / (1 + ($pro->tipotax / 100));
		            	}else{
		            		$precioUnita = $pro->preciotran;
		            	}

		            	$precioUnita = number_format($precioUnita, 6, '.', '');
			            $contenidoXML = '<PrecioUnitario>'.$precioUnita.'</PrecioUnitario>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            $montoTotal = abs($pro->cantidad) * $precioUnita;
			            $contenidoXML = '<MontoTotal>'.$montoTotal.'</MontoTotal>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");
			        }else{
			        	$contenidoXML = '<PrecioUnitario>'.$pro->precioneto.'</PrecioUnitario>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            $montoTotal = abs($pro->cantidad) * $pro->precioneto;
			            $contenidoXML = '<MontoTotal>'.$montoTotal.'</MontoTotal>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");
			        }

		            if($pro->descuento != 0){
                    	//PRODUCTO CON DESCUENTO!!!!!!!!
                    	$absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalSumas = $totalSumas + $absTotal;

						$descuento = $pro->descuento / 100;
						$cantdes = number_format(round($precioUnita, 2), 6 ,'.','') * $descuento;
						$totdsc = $cantdes * abs($pro->cantidad);
						$totalDesc = $totalDesc + $cantdes;

						$contenidoXML = '<MontoDescuento>'.number_format($totdsc, 2, '.', '').'</MontoDescuento>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            $contenidoXML = '<NaturalezaDescuento>DESCUENTO PRODUCTO</NaturalezaDescuento>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

						$subTotalMonto = $montoTotal - $totdsc;
			            $contenidoXML = '<SubTotal>'.$subTotalMonto.'</SubTotal>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");
					}else{
                        //PRODUCTO SIN DESCUENTOOOOOOOOOOOO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}else{
							$absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}
						
						$subTotalMonto = $montoTotal;
						$contenidoXML = '<SubTotal>'.$subTotalMonto.'</SubTotal>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");
					}

					$montoImpuesto = 0;
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
						
						if($pro->descuento != 0){
							$totalGravado = $totalGravado + $precioUnita * abs($pro->cantidad);
						}else{
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
						}

						$contenidoXML = '<Impuesto>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

			            	$contenidoXML = '<Codigo>01</Codigo>';
				            fwrite($archivoXML, $contenidoXML);
				            fwrite($archivoXML, "\r\n");

				            $contenidoXML = '<Tarifa>'.$pro->tipotax.'</Tarifa>';
				            fwrite($archivoXML, $contenidoXML);
				            fwrite($archivoXML, "\r\n");
				            if($pro->descuento != 0){
					            $montoImpuesto = (($subTotalMonto * ($pro->tipotax / 100)) * abs($pro->cantidad));
					            $contenidoXML = '<Monto>'.number_format($montoImpuesto, 4, '.', '').'</Monto>';
					            fwrite($archivoXML, $contenidoXML);
					            fwrite($archivoXML, "\r\n");
					         }else{
					         	$montoImpuesto = (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
					            $contenidoXML = '<Monto>'.number_format($montoImpuesto, 4, '.', '').'</Monto>';
					            fwrite($archivoXML, $contenidoXML);
					            fwrite($archivoXML, "\r\n");
					         }
			            $contenidoXML = '</Impuesto>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");

						$vnExenta = "";
						$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}

					$montoLinea = $subTotalMonto + number_format($montoImpuesto, 2, '.', '');
		            $contenidoXML = '<MontoTotalLinea>'.number_format($montoLinea, 2, '.', '').'</MontoTotalLinea>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

					$contenidoXML = '</LineaDetalle>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $numProd++;
				}

				$contenidoXML = '</DetalleServicio>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            $grantotal = $totalIVA + $totalGravado;

	            $contenidoXML = '<ResumenFactura>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<TotalMercanciasGravadas>'.number_format($totalGravado, 2 ,'.','').'</TotalMercanciasGravadas>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<TotalMercanciasExentas>'.number_format($totalExento, 2 ,'.','').'</TotalMercanciasExentas>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<TotalGravado>'.number_format($totalGravado, 2 ,'.','').'</TotalGravado>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<TotalExento>'.number_format($totalExento, 2 ,'.','').'</TotalExento>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $totalVentaXML = number_format((number_format($totalGravado, 2 ,'.','') + number_format($totalExento, 2 ,'.','')), 2, '.', '');
		            $contenidoXML = '<TotalVenta>'.$totalVentaXML.'</TotalVenta>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");
		            
		            if($totalDesc != 0){
			            $contenidoXML = '<TotalDescuentos>'.number_format($totalDesc, 2 ,'.','').'</TotalDescuentos>';
			            fwrite($archivoXML, $contenidoXML);
			            fwrite($archivoXML, "\r\n");
			        }

			        $totalVentaNeta = (number_format($totalVentaXML, 2 ,'.','')) - number_format($totalDesc, 2 ,'.','');
		            $contenidoXML = '<TotalVentaNeta>'.number_format($totalVentaNeta, 2, '.', '').'</TotalVentaNeta>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $contenidoXML = '<TotalImpuesto>'.number_format($totalIVA, 2, '.', '').'</TotalImpuesto>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $totalComprobante = number_format($totalVentaNeta, 2, '.', '') + number_format($totalIVA, 2, '.', '');
		            $contenidoXML = '<TotalComprobante>'.number_format($totalComprobante, 2, '.', '').'</TotalComprobante>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

                $contenidoXML = '</ResumenFactura>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

                $contenidoXML = '<Normativa>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            	$contenidoXML = '<NumeroResolucion>DGT-R-48-2016</NumeroResolucion>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

		            $dateRes = new DateTime('2016-10-07 08:00:00');
					$contenidoXML = '<FechaResolucion>'.$dateRes->format('Y-m-d H:i:s').'</FechaResolucion>';
		            fwrite($archivoXML, $contenidoXML);
		            fwrite($archivoXML, "\r\n");

	            $contenidoXML = '</Normativa>';
	            fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

				//Cierre de Tiquete Electronico......
	            $contenidoXML = '</TiqueteElectronico>';
				fwrite($archivoXML, $contenidoXML);
	            fwrite($archivoXML, "\r\n");

	            fclose($archivoXML);

	           	##Obtener Token Para el envió del archivo...
	            $usernameAPI = "nite-3120166641@prod.comprobanteselectronicos.go.cr";
	            $passwordAPI = "!-1D>;Lg)qEu@k;#XB.>";
	            $grantType = "password";
	            $clientID = "api-prod";
	            $tokenUrl = "https://idp.comprobanteselectronicos.go.cr/auth/realms/rut/protocol/openid-connect/token";

	            $headers = array(
				    'Content-type: application/x-www-form-urlencoded; charset=UTF-8',
				);
				
				$ObjToken = curl_init();
				curl_setopt($ObjToken, CURLOPT_URL, $tokenUrl);
				curl_setopt($ObjToken, CURLOPT_POST, true);
				curl_setopt($ObjToken, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ObjToken, CURLOPT_POSTFIELDS, "grant_type=".$grantType."&username=".$usernameAPI."&password=".$passwordAPI."&client_id=".$clientID."");
				curl_setopt($ObjToken, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
				curl_setopt($ObjToken, CURLOPT_RETURNTRANSFER, true);

				$response = json_decode(curl_exec($ObjToken));
				$errorToken = curl_error($ObjToken);
				curl_close($ObjToken);

				if($errorToken){
					echo "cURL Error #:".$errorToken;
				}else{
					$accessToken = $response->access_token;
					echo "Token: " . $accessToken;
				}

				##Firma de XML...
	        	shell_exec("java -jar xadessignercr/release/xadessignercr.jar sign doc_cuentas/".$this->session->userdata('dirDocuments')."/312016664113.p12 8462 doc_cuentas/".$this->session->userdata('dirDocuments')."/Tiquete".$trannum.".xml doc_cuentas/".$this->session->userdata('dirDocuments')."/Tiquete".$trannum."-firmada.xml");

	        	##Envio de Archivo XML...
	        	$fechaXML = new DateTime();
	        	$emisorXML = array(
					"tipoIdentificacion" => "01",
					"numeroIdentificacion" => $NIT
				);

				$receptorXML = array(
					"tipoIdentificacion" => "01",
					"numeroIdentificacion" => $NIT
				);

				$comprobanteXMLFinal = fopen("doc_cuentas/".$this->session->userdata('dirDocuments')."/Tiquete".$trannum."-firmada.xml",'r');
				
				$contenidoXMLTxt = "";
				while (!feof($comprobanteXMLFinal)){
				    $contenidoXMLTxt .= fgets($comprobanteXMLFinal);
				}
				fclose($comprobanteXMLFinal);
				
				$contenidoXMLTxt = utf8_encode($contenidoXMLTxt);
				$contenidoXMLTxt = base64_encode($contenidoXMLTxt);

				echo "<br>". $fechaXML->format("Y-m-d")."T".$fechaXML->format("H:i:sZ");

	        	$itemsXML = array(
	        		"clave" => $claveNumerica,
	        		"fecha" => $fechaXML->format("Y-m-d")."T".$fechaXML->format("H:i:sZ"),
	        		"emisor" => $emisorXML,
	        		"receptor" => $receptorXML,
	        		##"callbackUrl" => "http://www.goxpos.com/tiquete_e"
	        		"comprobanteXml"=> $contenidoXMLTxt
	        	);
	        	$itemsXMLJson = json_encode($itemsXML);

	        	echo "<br>JSON: ".$itemsXMLJson;

	        	$facturaUrl = "https://api.comprobanteselectronicos.go.cr/recepcion/v1/recepcion";
	        	$headersFactura = array(
				    'Content-type: application/json; charset=UTF-8',
				    'Authorization: Bearer ' . $accessToken
				);

	        	$ObjFacturaElec = curl_init();
	        	curl_setopt($ObjFacturaElec, CURLOPT_URL, $facturaUrl);
				curl_setopt($ObjFacturaElec, CURLOPT_POST, true);
				curl_setopt($ObjFacturaElec, CURLOPT_HTTPHEADER, $headersFactura);
				curl_setopt($ObjFacturaElec, CURLOPT_HEADER, true);
				curl_setopt($ObjFacturaElec, CURLINFO_HEADER_OUT, true);
				curl_setopt($ObjFacturaElec, CURLOPT_POSTFIELDS, $itemsXMLJson);
				curl_setopt($ObjFacturaElec, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
				curl_setopt($ObjFacturaElec, CURLOPT_RETURNTRANSFER, true);
				$respuestaEnvio = curl_exec($ObjFacturaElec);

				$errorEnvio = curl_error($ObjFacturaElec);
				
				if($errorEnvio){
					echo "<br> cURL Error #:".$errorEnvio;
				}else{
					$httpCode = curl_getinfo($ObjFacturaElec, CURLINFO_HTTP_CODE);
					echo "<br> ". $httpCode;

					echo "<br> ". $respuestaEnvio;
				}

				curl_close($ObjFacturaElec);
			}
        }

        function validateAceptacionTikete($trannum){
        	if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            	date_default_timezone_set('America/El_Salvador');

                $this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				$this->load->model('empleado_model');
                $this->load->model('sucursal_model');
				$this->load->model('caja_model');

                $informacion = $this->ventas_model->getDatosFactura($trannum);

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $info->nameCliente;
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $info->direccion;
                    $giro = $info->giro;
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

                foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}

                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$correoelectronico = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;

	            $numeroConsecutivo = ''; $claveNumerica = '';

	            $formatSucursal = str_pad($idcentro, 3, 0, STR_PAD_LEFT);
	            $numeroConsecutivo .= $formatSucursal;

	            $identTerminal = '00001';
				$numeroConsecutivo .= $identTerminal;

				$tipoComprobante = '04';
				$numeroConsecutivo .= $tipoComprobante;

				$formatNumero = str_pad($numeroRecibo, 10, 0, STR_PAD_LEFT);
				$numeroConsecutivo .= $formatNumero;

	            $claveNumerica .= '506';

	            $partesFechaClave = explode("/", $fechaRecibo);
	            $claveNumerica .= $partesFechaClave[0] . $partesFechaClave[1] . substr($partesFechaClave[2], 2, 4);

	            $claveNumerica .= str_pad('3101729200', 11, 0, STR_PAD_LEFT);
	            $claveNumerica .= $numeroConsecutivo;

	            $claveNumerica .= '1';

	            //Codigo de Seguridad Sistema....
	            $codigoSeguridad = str_pad($trannum, 9, 0, STR_PAD_LEFT);
	            $claveNumerica .= $codigoSeguridad;

	           	##Obtener Token Para el envió del archivo...
	            $usernameAPI = "nite-3120166641@prod.comprobanteselectronicos.go.cr";
	            $passwordAPI = "!-1D>;Lg)qEu@k;#XB.>";
	            $grantType = "password";
	            $clientID = "api-prod";
	            $tokenUrl = "https://idp.comprobanteselectronicos.go.cr/auth/realms/rut/protocol/openid-connect/token";

	            $headers = array(
				    'Content-type: application/x-www-form-urlencoded; charset=UTF-8',
				);
				
				$ObjToken = curl_init();
				curl_setopt($ObjToken, CURLOPT_URL, $tokenUrl);
				curl_setopt($ObjToken, CURLOPT_POST, true);
				curl_setopt($ObjToken, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ObjToken, CURLOPT_POSTFIELDS, "grant_type=".$grantType."&username=".$usernameAPI."&password=".$passwordAPI."&client_id=".$clientID."");
				curl_setopt($ObjToken, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
				curl_setopt($ObjToken, CURLOPT_RETURNTRANSFER, true);

				$response = json_decode(curl_exec($ObjToken));
				$errorToken = curl_error($ObjToken);
				curl_close($ObjToken);

				if($errorToken){
					echo "cURL Error #:".$errorToken;
				}else{
					$accessToken = $response->access_token;
				}

	        	$facturaUrl = "https://api.comprobanteselectronicos.go.cr/recepcion/v1/recepcion/".$claveNumerica;
	        	
	        	$opciones = array(
					'http'=>array(
						'method'=> "GET",
				    	'header'=> 'Authorization: Bearer '.$accessToken
				  	)
				);

				$contexto = stream_context_create($opciones);
				$fichero = file_get_contents($facturaUrl, false, $contexto);

				$json = json_decode($fichero, true);
				$str = $json['respuesta-xml'];
				
				echo base64_decode($str);

			}
        }

		function ventaTicketPrueba($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();

            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = '192.168.1.78';
								var devid = 'local_printer';
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;

								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento;
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();

										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}

									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}

								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();

                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }

								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}

		function reporteCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);

				$cnt = 0;
				$valpag = array();

				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;

					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();

					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";

					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;

					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";

						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}

				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";

				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);

				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}

					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}

									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";

						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}

					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;

							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}

										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}

										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";

							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}

				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";

				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);

				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}

					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}

									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";

						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}

					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;

							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}

										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}

										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";

							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}

				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";

				echo $script;
			}
		}

		function reporteCorteX($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

				$cnt = 0;
				$valpag = array();

				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;

					var ticketObj = new epson.ePOSBuilder();

					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}

					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";

				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";

					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;

							$productos = $this->invtran_model->getDataTran100k($ven->trannum);

							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}

							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;

							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){

										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}

					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";

					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}

								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;

								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";

					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}

					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";

				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);

				$totalSistema = 0;
				$totalCaja = 0;

				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";

					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";


					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";

					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);

					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;


					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}

					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;


							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";

					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";

					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";

					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}

				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;

							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";

				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;

							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";

				$totalDiferencia = $totalCaja - $totalSistema;

				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;

							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";

				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";

				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);


					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;

								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}

								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}

								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}

								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";

					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}

				$script .= "ticketObj.addFeed();";
				$nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);

							ticketObj.addCut();
							ticketObj.addPulse();

							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";

				echo $script;
			}
		}

		function reporteCorteZFacturaz($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$cnt = 0;
				$valpag = array();

				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;

					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();

					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";

				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;

				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";

					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);

							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}

							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;

							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}

					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2)."';
						}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";

					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;

				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";

				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;

				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}

								var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;

								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";

					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}

					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = ".number_format(round($total_ing_sum, 2),2).";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";

				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);

				$totalSistema = 0;
				$totalCaja = 0;

				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";

					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";


					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";

					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);

					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;


					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}

					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;


							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";

					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";

					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";

					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}

				$this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;

							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";

				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;

							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";

				$totalDiferencia = $totalCaja - $totalSistema;

				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;

							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";


				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";

				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";

				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);

				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);


					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;

								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}

								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}

								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}

								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";

					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}

				$script .= "ticketObj.addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);

					ticketObj.addCut();
					ticketObj.addPulse();

					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";

				echo $script;
			}
		}

		function imprimirApertura($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$script = "
					<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
					<script src='".base_url()."js/epos-print-5.0.0.js'></script>
					<script src='".base_url()."js/barcode.js'></script>

					<script type='text/javascript'>
						//var datosprinter = data.datos_print.split('/');
						var ipaddr = '".$datospr[0]."';
						var devid = '".$datospr[1]."';
						var timeout = '60000';
						var grayscale = false;
						var layout = false;

						var fecha = new Date();
						var anio = fecha.getFullYear();
						var mes = fecha.getMonth() + 1;
						var dia = fecha.getDate();

						var hours = fecha.getHours();
						var minutes = fecha.getMinutes();
						var seconds = fecha.getSeconds();
						var ampm = hours >= 12 ? 'PM' : 'AM';

						hours = hours % 12;
						hours = hours ? hours : 12; // the hour '0' should be '12'
						minutes = minutes < 10 ? '0'+minutes : minutes;
						var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

						var ticketObj = new epson.ePOSBuilder();
						if(layout){
							ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
						}

						ticketObj.addTextLang('es').addTextSmooth(true);
						ticketObj.addFeedLine(1);
						ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
						ticketObj.addTextSize(1, 2);
						ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
						ticketObj.addTextSize(1, 1);
						ticketObj.addFeed();
						ticketObj.addText('".$namecaja."');
						ticketObj.addFeed();
						ticketObj.addText('".$namecentro."');
						ticketObj.addFeed();
						ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
						ticketObj.addFeed();
						ticketObj.addText('Giro: ".$GIRO."');
						ticketObj.addFeed();
						ticketObj.addText('IVA D.L. N° 296');
						ticketObj.addFeed().addFeed();
						ticketObj.addTextSize(1, 2).addText('APERTURA DE CAJA').addFeed();
						ticketObj.addText('".$fechaCorte." ' + strTime).addTextSize(1, 1);
						ticketObj.addFeed().addFeed();
						ticketObj.addText('CAJERO: ".$this->session->userdata('userLog')."').addFeed();
						ticketObj.addText('FONDO: $".number_format($fondocaja, 2, '.', '')."').addFeed().addFeed();
						ticketObj.addText('SE APERTURO CAJA').addFeed();
						ticketObj.addFeedLine(4);

						ticketObj.addCut();
						ticketObj.addPulse();

						var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
						var epos = new epson.ePOSPrint(url);
						epos.send(ticketObj.toString());

						setTimeout(function(){ window.close();}, 1500);
					</script>";

				echo $script;
			}
		}

		function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

				$cnt = 0;
				$valpag = array();

				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;

					var ticketObj = new epson.ePOSBuilder();

					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}

					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";

				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";

					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;

							$productos = $this->invtran_model->getDataTran100k($ven->trannum);

							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}

							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;

							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){

										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}

					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";

					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}

								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;

								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";

					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}

					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";

				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);

				$totalSistema = 0;
				$totalCaja = 0;

				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";

					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";


					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";

					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);

					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;


					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}

					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;


							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";

					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";

					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";

					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}

				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;

							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";

				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;

							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";

				$totalDiferencia = $totalCaja - $totalSistema;

				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;

							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";

				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";

				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);


					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;

								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}

								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}

								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}

								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";

					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}

				$script .= "ticketObj.addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);

							ticketObj.addCut();

							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";

				echo $script;
			}
		}

		function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');

				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual,$numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual,$numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual,$numero_z);

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

				$cnt = 0;
				$valpag = array();

				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>

				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;

					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();

					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";

				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;

				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";

					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);

							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}

							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;

							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}

					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2)."';
						}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";

					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;

						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;

				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";

				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;

				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}

								var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;

								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";

					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}

					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";

				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);

				$totalSistema = 0;
				$totalCaja = 0;

				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";

					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";


					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";

					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);

					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;


					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}

					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;


							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";

					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";

					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";

					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}

				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;

							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";

				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;

							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";

				$totalDiferencia = $totalCaja - $totalSistema;

				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;

							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";


				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";

				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";

				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);

				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);


					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;

								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}

								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}

								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}

								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";

					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}

				$script .= "ticketObj.addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);

					ticketObj.addCut();

					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";

				echo $script;
			}
		}

        function print_etiquetas2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                // Load library

                $this->load->library('fpdf');

                # Contenido HTML del documento que queremos generar en PDF.
                $this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $cant = 0;

                $productos = $this->compras_model->getProductosCompra($trannum);
                $marcas = $this->compras_model->getMarcasCompra($trannum);


                $pdf = new fpdf('P','mm','A4');

                // Títulos de las columnas
                // Carga de datos
                $pdf->SetFont('Arial','B',11);
                $pdf->SetMargins(10, 10, 10);
                $pdf->AddPage();
                $pdf->SetAutoPageBreak(true, 10);
                $pdf->setXY(10,10);
                $y = $pdf->getY();
                $cant=0;
                foreach($marcas as $mar){
                    $primera = true;
                    foreach($productos as $pro){
                        if($mar->marca==$pro->marca){
                            $actual=0;
                            $cant_etiquetas= $pro->cantidad;
                            if($primera == true){
                                $primera=false;
                                if($cant==0){
                                    $pdf->setXY(10,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==1){
                                    $pdf->setXY(56,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==2){
                                    $pdf->setXY(102,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==3){
                                    $pdf->setXY(148,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant=0;
                                    $y +=10;
                                }
                            }


                            do{

                                if($cant==0){
                                    $pdf->setXY(10,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==1){
                                    $pdf->setXY(56,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==2){
                                    $pdf->setXY(102,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==3){
                                    $pdf->setXY(148,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant=0;
                                    $y +=10;
                                }
                                $actual++;
                            }while($cant_etiquetas!=$actual);


                            if($cant==0){
                                $pdf->setXY(10,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==1){
                                $pdf->setXY(56,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==2){
                                $pdf->setXY(102,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==3){
                                $pdf->setXY(148,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant=0;
                                $y +=10;
                            }



                        }
                    }
                }

                $pdf->Output();

            }
        }

        function cuadre_existencias($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('CUADRE DE EXISTENCIAS');
                $pdf->SetSubject('CUADRE DE EXISTENCIAS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));

                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.


                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporte($trannum);


                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$center_name.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                <thead>
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Precio</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';

                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;

                $sum_invsistema_noinventariado=0;
                $uni_invsistema_noinventariado=0;
                $cantinvsistema_noinventariado=0;

                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td><td colspan="2"> </td></tr>';

                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste++;
                        }
                    }
                }
                if($cantsinajuste>0){
                    $titulo.=$sinajuste;
                }

                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad > 0){
                            $sum_ajusteafavor+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteafavor.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteafavor++;
                        }
                    }
                }
                if($cantajusteafavor>0){
                    $titulo.=$ajusteafavor;
                }


                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra++;
                        }
                    }

                }
                if($cantajusteencontra>0){
                    $titulo.=$ajusteencontra;
                }



                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;


                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';


                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra2 = 0;
                $sum_ajusteencontra2 = 0;
                $uni_ajusteencontra2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra2++;
                        }
                    }

                }
                if($cantajusteencontra2>0){
                    $titulo.=$ajusteencontra;
                }



                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                $cantsinajuste2= 0;
                $sum_sinajuste2 = 0;
                $uni_sinajuste2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste2++;
                        }
                    }
                }
                if($cantsinajuste2>0){
                    $titulo.=$sinajuste;
                }

                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;

                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;

                $titulo.='</tbody>
                </table>
                <table>
                    <tr><td colspan="4"><br><br><br></td></tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:40%;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;width:30%;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:11px;width:10%;">Precio</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Productos</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Sistema</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">$'.number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$uni_invsistema.'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteencontra.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteencontra2.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteafavor.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteafavor.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">$'.number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:center; font-weight:bold;width:10%;">'.($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor).'</td>
                        <td style="text-align:center; font-weight:bold;width:10%;"></td>
                    </tr>
                    <tr><td colspan="5"><br></td></tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_sinajuste2.'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste2.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_sinajuste.'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste.'</td>
                    </tr>
                    </table>
                ';


                $pdf->writeHTML($titulo, true, false, true, false, '');


                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("CuadreExistencias.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

		function impresionReporteKardex142($fechaini, $fechafin, $idcentro, $idproducto){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte Kardex 142');
                $pdf->SetSubject('Reporte Kardex 142');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(10, 15, 10, PDF_MARGIN_BOTTOM); // set the margins
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

				$pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');

                $pdf->SetFont('Helvetica', '', 7, '', true);

                $this->load->model('invtran_model');
                $this->load->model('producto_model');

                $nombre_doc = "Reporte Kardex 142";

                $header = '<center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$this->session->userdata('nameCentroUser').'</label></center>';
                $pdf->setHtmlHeader($header);
				$pdf->setPrintHeader(false);

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
				<table style="padding:0px; margin:0px;">
					<tbody style="padding:0px; margin:0px;">
						<tr style="padding:0px; margin:0px;">
							<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
							<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
							<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
						</tr>
					</tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                $pdf->addPage('L', 'LETTER');

				$partesFecha1 = explode("-", $fechaini);
				$mes_ini = trim($partesFecha1[1]);

				if($mes_ini == 1){
					$mes_ini_p = "ENERO";
				}else if($mes_ini == 2){
					$mes_ini_p = "FEBRERO";
				}else if($mes_ini == 3){
					$mes_ini_p = "MARZO";
				}else if($mes_ini == 4){
					$mes_ini_p = "ABRIL";
				}else if($mes_ini == 5){
					$mes_ini_p = "MAYO";
				}else if($mes_ini == 6){
					$mes_ini_p = "JUNIO";
				}else if($mes_ini == 7){
					$mes_ini_p = "JULIO";
				}else if($mes_ini == 8){
					$mes_ini_p = "AGOSTO";
				}else if($mes_ini == 9){
					$mes_ini_p = "SEPTIEMBRE";
				}else if($mes_ini == 10){
					$mes_ini_p = "OCTUBRE";
				}else if($mes_ini == 11){
					$mes_ini_p = "NOVIEMBRE";
				}else if($mes_ini == 12){
					$mes_ini_p = "DICIEMBRE";
				}

				$partesFecha2 = explode("-", $fechafin);
				$mes_fin = trim($partesFecha2[1]);

				if($mes_fin == 1){
					$mes_fin_p = "ENERO";
				}else if($mes_fin == 2){
					$mes_fin_p = "FEBRERO";
				}else if($mes_fin == 3){
					$mes_fin_p = "MARZO";
				}else if($mes_fin == 4){
					$mes_fin_p = "ABRIL";
				}else if($mes_fin == 5){
					$mes_fin_p = "MAYO";
				}else if($mes_fin == 6){
					$mes_fin_p = "JUNIO";
				}else if($mes_fin == 7){
					$mes_fin_p = "JULIO";
				}else if($mes_fin == 8){
					$mes_fin_p = "AGOSTO";
				}else if($mes_fin == 9){
					$mes_fin_p = "SEPTIEMBRE";
				}else if($mes_fin == 10){
					$mes_fin_p = "OCTUBRE";
				}else if($mes_fin == 11){
					$mes_fin_p = "NOVIEMBRE";
				}else if($mes_fin == 12){
					$mes_fin_p = "DICIEMBRE";
				}

				$infoProducto = $this->producto_model->callRegistro($idproducto);
				foreach($infoProducto as $infoP){
					$nameProducto = $infoP->descrip;
					$unidadMedida = $infoP->um;
				}

				$informacion_txt = '
				<table>
					<tbody style="padding:0px; margin:0px;">
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000; text-align:left; width: 100%"></td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-left:1px solid #000; text-align:left; width: 80%">   <strong>REGISTRO DE CONTROL DE INVENTARIO</strong></td>
							<td style="font-size:10px; border-right:1px solid #000; text-align:left; width: 20%" rowspan="5"></td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-left:1px solid #000; text-align:left; width: 80%">   <strong>PARA EL PERIODO ' . $partesFecha1[2] . ' DE ' . $mes_ini_p . ' DEL ' . $partesFecha1[0] . ' AL '.$partesFecha2[2].' DE '.$mes_fin_p.' DEL '.$partesFecha2[0].'</strong></td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-left:1px solid #000; text-align:left; width: 80%">   <strong>NOMBRE:</strong> '.$this->session->userdata('descrip').'</td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-left:1px solid #000; text-align:left; width: 80%">   <strong>UNIDAD DE MEDIDA:</strong> '.strtoupper($unidadMedida).'</td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-left:1px solid #000; text-align:left; width: 80%">   <strong>ARTICULO:</strong> '.strtoupper($nameProducto).'</td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size:10px; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000; text-align:left; width: 100%"></td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 5%; font-weight:bold;" rowspan="2"><br><br><br><br>FECHA</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%; font-weight:bold;" rowspan="2"><br><br><br><br>No. DOCTO</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%; font-weight:bold;" rowspan="2"><br><br><br><br>TIPO DE DOCTO</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%; font-weight:bold;" rowspan="2"><br><br><br>TIPO DE TRANSACCION</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%; font-weight:bold;" rowspan="2"><br><br><br><br>PROVEEDOR/CLIENTE</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%; font-weight:bold;" colspan="3"><br><br>ENTRADA<br></td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%; font-weight:bold;" colspan="3"><br><br>SALIDA<br></td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; border-right:1px solid #000; width: 15%; font-weight:bold;" colspan="3"><br><br>EXISTENCIA<br></td>
						</tr>
						<tr style="padding:0px; margin:0px;">
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>CANTIDAD UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>COSTO UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>COSTO TOTAL</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>CANTIDAD UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>COSTO UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>COSTO TOTAL</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>CANTIDAD UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; font-weight:bold;"><br><br>COSTO UNIDAD<br></td>
							<td style="font-size: 7px;  border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000; text-align:center; font-weight:bold;"><br><br>COSTO TOTAL</td>
						</tr>';

				$idano = $partesFecha1[0];
				$idmes = $partesFecha1[1];

				$inventarioInicial = $this->invtran_model->getInventarioInicialProductoKardex($idproducto, $idcentro, $idano, $idmes);
				$informacion = $this->invtran_model->getDetalleKardexByProducto($idproducto, $fechaini, $fechafin, $idcentro);

				foreach($inventarioInicial as $info){
					$costounitario = 0;
					$cantidadinicial = number_format($info->cantidad);
					$costoinicial = number_format($info->costo, 2);

					if($cantidadinicial != 0){
						$costounitario = number_format($info->costo, 2, '.', '')/number_format($info->cantidad);
					}

					$informacion_txt .= '
						<tr style="padding:0px; margin:0px;">
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%;"></td>
							<td style="font-size: 8px; text-align:left; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%;">INICIAL</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%;"></td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;"></td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">$'.number_format($cantidadinicial, 2, '.', '').'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">$'.number_format($costounitario, 2, '.', '').'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000; text-align:center; width: 5%;">$'.number_format($costoinicial, 2, '.', '').'</td>
						</tr>';
				}

				$cantidad_existencia = number_format($info->cantidad);
				$costo_existencia = number_format($costounitario, 2);
				$total_existencia = number_format($info->costo, 2);

				foreach($informacion as $info){
					$costounitario = 0;

					if($info->agrupa == 'VN'){
						$valAgrupa = 'VENTA';
					}else if($info->agrupa == 'IN'){
						$valAgrupa = 'INVENTARIO';
					}else if($info->agrupa == 'CO'){
						$valAgrupa = 'COMPRA';
					}

					$cantidad_entrada = '';
					$costo_entrada = '';
					$total_entrada = '';
					$cantidad_salida = '';
					$costo_salida = '';
					$total_salida = '';


					if($info->inopera == 1){
						$totalEntrada = number_format(abs($info->cantidad)) * number_format($info->costounitario, 2);

						$cantidad_entrada = number_format(abs($info->cantidad));
						$costo_entrada = number_format($info->costounitario, 2) * 1;
						$costo_entrada = '$'.$costo_entrada;
						$total_entrada = '$'.$totalEntrada;

						$cantidad_existencia = $cantidad_existencia + $cantidad_entrada;
						$total_existencia = $total_existencia + $total_entrada;
						$costo_existencia = $total_existencia / $cantidad_existencia;
					}else if($info->inopera == -1){
						$totalSalida = number_format(abs($info->cantidad)) * number_format($info->costounitario, 2);

						$cantidad_salida = number_format(abs($info->cantidad));
						$costo_salida = number_format($info->costounitario, 2) * 1;
						$costo_salida = '$'.$costo_salida;
						$total_salida = '$'.$totalSalida;

						$cantidad_existencia = $cantidad_existencia - $cantidad_salida;
						$costo_existencia = $costo_existencia;
						$total_existencia = $total_existencia - $total_salida;
					}

					$informacion_txt .= '
						<tr style="padding:0px; margin:0px;">
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 5%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%;">'.$info->numerodoc.'</td>
							<td style="font-size: 8px; text-align:left; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%;">'.$info->descrip.'</td>
							<td style="font-size: 8px; text-align:center; border-left:1px solid #000; border-bottom:1px solid #000; width: 10%;">'.$valAgrupa.'</td>
							<td style="font-size: 8px; text-align:left; border-left:1px solid #000; border-bottom:1px solid #000; width: 15%;">'.strtoupper($info->proveedorcliente).'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$cantidad_entrada.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$costo_entrada.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$total_entrada.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$cantidad_salida.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$costo_salida.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$total_salida.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">'.$cantidad_existencia.'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; text-align:center; border-bottom:1px solid #000; width: 5%;">$'.number_format($costo_existencia, 2, '.', '').'</td>
							<td style="font-size: 7px;  border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000; text-align:center; width: 5%;">$'.number_format($total_existencia, 2, '.', '').'</td>
						</tr>';
					/*$dataSource[$i] = array(
						"fecha" => $info->fecha,
						"numero" => $info->numerodoc,
						"documento" => $info->descrip,
						"transaccion" => $valAgrupa,
						"proveedorcliente" => $info->proveedorcliente,
						"cantidad_entrada" => $cantidad_entrada,
						"costo_entrada" => $costo_entrada,
						"total_entrada" => $total_entrada,
						"cantidad_salida" => $cantidad_salida,
						"costo_salida" => $costo_salida,
						"total_salida" => $total_salida,
						"cantidad_existencia" => $cantidad_existencia,
						"costo_existencia" => $costo_existencia,
						"total_existencia" => $total_existencia,
					);

					$i++;*/
				}

				$informacion_txt .= '
					</tbody>
				</table>';

				$pdf->writeHTML($informacion_txt, true, false, true, false, '');
                $nameArchivo = utf8_decode("ReporteKardex142.pdf");

                $pdf->Output($nameArchivo, 'I');
			}
		}

        function multi_mail($trannum){
            $this->db->query('SET SQL_BIG_SELECTS=1');
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);
            set_time_limit(0);
            $this->load->model('pedclientes_model');
            $this->load->model("global_model");
            $this->load->model("ventas_model");
            $this->load->model('producto_model');
            $this->load->model('fabrica_model');
            $this->load->model('compras_model');
            $function = $this->uri->segment(3);
            $nombre_doc="";
            $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
            $fecha = new DateTime();

            $html_code = '<table style="width:100%;">
                <tr>
                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                    <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                </tr></table>';
            $html_code .= '<table style="width:100%;">
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                </tr>

                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                    <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                </tr>
            </table>';

            $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
            $encabezado = $this->ventas_model->getAnexosHijos($trannum);
            if($encabezado!=false){
                foreach($encabezado as $enc){
                    $tabla_presentacion .= '<tr>
                        <td style="width:100%;padding:2px;">'.$enc->notas.'</td>
                    </tr>';
                }
                $tabla_presentacion.='</table>';
                $html_code.= $tabla_presentacion;
            }


            $html_code .='<br><table style="width:100%;"><tr>
                                    <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                    <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                </tr>';
            if($list_producto!=false){
                foreach($list_producto as $pro){
                    $html_code .='<tr>
                        <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                        </tr>';
                }
            }

            $html_code .='</table>';

            echo json_encode($html_code);
        }

        function send_email_orden_venta($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1');
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model("ventas_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('compras_model');
                $function = $this->uri->segment(3);
                $nombre_doc="";
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();

                $html_code = '<table style="width:100%;">
                    <tr>
                        <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                        <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                    </tr></table>';
                $html_code .= '<table style="width:100%;">
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                    </tr>

                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                    </tr>
                </table>';

                $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                if($encabezado!=false){
                    foreach($encabezado as $enc){
                        $tabla_presentacion .= '<tr>
                            <td style="width:100%;padding:2px;">'.$enc->notas.'</td>
                        </tr>';
                    }
                    $tabla_presentacion.='</table>';
                    $html_code.= $tabla_presentacion;
                }


                $html_code .='<br><table style="width:100%;"><tr>
                                        <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                        <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                    </tr>';
                if($list_producto!=false){
                    foreach($list_producto as $pro){
                        $html_code .='<tr>
                            <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                            </tr>';
                    }
                }

                $html_code .='</table>';

                return($html_code);
            }
        }

        function enviar_correo_orden_venta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                if($de!=""){
                    $this->load->model('global_model');
                    $email_empr = $this->global_model->getDatosGeneralesEmp('g_empdatos', 11);

                    $tabla = $this->send_email_orden_venta($trannum);
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);

                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;


                    $this->load->library('My_PHPMailer');
                    $mail = new PHPMailer();
                    $mail->IsSMTP(); // establecemos que utilizaremos SMTP
                    $mail->SMTPAuth   = true; // habilitamos la autenticación SMTP
                    $mail->SMTPSecure = "tls";
                    $mail->Host       = "smtp.gmail.com";      // establecemos GMail como nuestro servidor SMTP
                    $mail->Port       = 587;                   // establecemos el puerto SMTP en el servidor de GMail
                    $mail->Username   = "versanetsasv@gmail.com";  // la cuenta de correo GMail
                    $mail->Password   = "Egga#94662";            // password de la cuenta GMail
                    $mail->IsHTML(true);
                    $mail->SetFrom($de, $nombre_comercial);  //Quien envía el correo
                    $mail->addAddress($de);
                    $mail->Subject = $asunto;  //Asunto del mensaje
                    $mail->Body = $body;
                    $destino = $para;
                    $arreglo_para = explode(",", $para);
                    $cant = count($arreglo_para);
                    for($m = 0; $m<$cant; $m++){
                        $mail->AddAddress($arreglo_para[$m]);
                    }
                    $mail->CharSet = 'UTF-8';


                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Cotización');
                    $pdf->SetSubject('Cotización');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetAutoPageBreak(TRUE,10);
                    $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                    $pdf->SetHeaderMargin(0,0,0,0);
                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                    $this->load->model('pedclientes_model');
                    $this->load->model("global_model");
                    $this->load->model("ventas_model");
                    $this->load->model('producto_model');
                    $this->load->model('fabrica_model');
                    $this->load->model('compras_model');
                    $function = $this->uri->segment(3);
                    $nombre_doc="";
                    $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                    $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                    $name = $this->pedclientes_model->getnameImg();
                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                        </table>';

                    $pdf->setHtmlFooter($footer);
                    $pdf->setPrintFooter(true);

                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                        </tr></table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                        </tr>

                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                        </tr>
                    </table>';

                    $pdf->setHtmlHeader($header);
                    $pdf->setPrintFooter(true);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('Portrait');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', 'LETTER');
                    $estructura ='';
                    $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                    $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                    if($encabezado!=false){
                        foreach($encabezado as $enc){
                            $tabla_presentacion .= '<tr>
                                <td style="width:100%;padding:10px;">'.$enc->notas.'</td>
                            </tr>';
                        }
                        $tabla_presentacion.='</table>';
                        $estructura.= $tabla_presentacion;
                    }


                    $estructura .='<br><br><table><tr>
                                            <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                            <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                        </tr>';
                    if($list_producto!=false){
                        foreach($list_producto as $pro){
                            $estructura .='<tr>
                                <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                                <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                                </tr>';
                        }
                    }

                    $estructura .='</table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "cotizacion_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo.".pdf";
                    $pdf->Output($fullpath,'F');
                    //$this->email->message($body);
                    if($nombre_archivo!=''){
                        $mail->AddAttachment($fullpath, $name = $nombre_archivo.".pdf",  $encoding = 'base64', $type = 'application/pdf');
                    }

                    if(!$mail->Send()) {
                        unlink($fullpath);
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    } else {
                        unlink($fullpath);
                        $notas_correo = "Correo enviado de: ". $de . " a: ". $para;
                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",
                        );
                        echo json_encode($array_result);
                    }
                    }else{
                    $array_result = array(
                        "mensaje" =>"El empleado no tiene correo",
                        "type" =>"warning",
                    );
                    echo json_encode($array_result);
                }
            }
        }

		function comprobanteCanjeDeProductos($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				$fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comproban de Canje');
                $pdf->SetSubject('Comproban de Canje');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(10, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);

				$this->load->model('ventas_model');
				$this->load->model('pedclientes_model');

				$nameLogo = $this->pedclientes_model->getnameImg();
				$header = '
				<table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%"><img style="width:200px; height:70px; min-width: 25%; float:left; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameLogo.'"></th>
                            <th style="font-size:10px; text-align:center; width: 40%"><br><br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">COMPROBANTE DE CANJE</label></center></th>
                            <th style="font-size:10px; text-align:right; width: 30%"></th>
                        </tr>
                    </tbody>
				</table>';
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);

                $footer =  '<br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:left; width: 18%;">ENTREGADO POR</th>
                            <th style="font-size:12px; text-align:center; width: 30%; border-bottom:1px solid #000;"></th>
                            <th style="font-size:12px; text-align:center; width: 4%;"></th>
                            <th style="font-size:12px; text-align:left; width: 16%;">RECIBIDO POR</th>
                            <th style="font-size:12px; text-align:right; width: 30%; border-bottom:1px solid #000;"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:center; width: 100%;"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:left; width: 18%;">APLICADO POR</th>
                            <th style="font-size:12px; text-align:center; width: 30%; border-bottom:1px solid #000;"></th>
                            <th style="font-size:12px; text-align:center; width: 4%;"></th>
                            <th style="font-size:12px; text-align:left; width: 18%;"></th>
                            <th style="font-size:12px; text-align:right; width: 28%;"></th>
                        </tr>
                    </tbody>
				</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

				$numero_factura = "";
				$fecha_factura = "";
				$informacion = $this->ventas_model->getInformacionDetalleCanje($trannum);

				foreach($informacion as $info){

					if($info->cli_email != ""){
						$codigosCargosAbonos = explode(",", $info->cli_email);
						$idrec_cargo = $codigosCargosAbonos[0];

						$info_factura = $this->ventas_model->getInformacionTrannumCargoAbono($idrec_cargo);

						$numero_factura = $info_factura['trannum'];
						$fecha_factura = date_format(date_create($info_factura['fecha']), 'd/m/Y');
					}

					$titulo = '
					<table>
						<tbody>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; text-align: left; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"> </td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Fecha:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.date_format(date_create($info->fecha), 'd/m/Y').'</strong></td>
								<td style="width: 20%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Zona:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->zonaCliente.'</strong></td>
								<td style="width: 10%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Número:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 10%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.$info->trannum.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"> </td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Nombre:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 85%; font-size:12px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->nameCliente.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;"></td>
								<td style="width: 50%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Factura:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.$numero_factura.'</strong></td>
								<td style="width: 20%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Fecha de Factura:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 50%; font-size:12px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"> &nbsp;&nbsp;&nbsp;<strong>'.$fecha_factura.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 50%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Observaciones:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 85%; font-size:12px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->notas.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
						</tbody>
					</table>';
				}

				$idcentro = $info->idcentro;
				$datos_canjeados = $this->ventas_model->getListadoProductosCanjeados($trannum);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);

				$titulo .= '<br><br><br>
				<table>
					<tbody>
						<tr>
							<td style="width: 100%; font-size:5px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:12px; text-align: center; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"><strong>ENTRADA</strong></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:5px;background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">DESCRIPCIÓN</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">CANTIDAD</td>
							<td style="width: 15%; font-size:12px; text-align:  right; background-color:#ECF0F1; border-right:1px solid #000;">PRECIO&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';

				$total_cant_entradas = 0;
				$total_prec_entradas = 0;

				foreach($datos_canjeados as $info_can){
					$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: left; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$info_can->descrip.'</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">'.abs($info_can->cantidad).'</td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;">$'.number_format($info_can->precioneto, 2, '.', ',').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';

					$total_cant_entradas =  $total_cant_entradas + abs($info_can->cantidad);
					$total_prec_entradas =  $total_prec_entradas + $info_can->precioneto;
				}

				$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; border-right:1px solid #000;"><strong>TOTAL</strong></td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"><strong>'.$total_cant_entradas.'</strong></td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;"><strong>$'.number_format($total_prec_entradas, 2, '.', ',').'</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
					</tbody>
				</table>';

				$titulo .= '<br><br><br>
				<table>
					<tbody>
						<tr>
							<td style="width: 100%; font-size:5px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:12px; text-align: center; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"><strong>SALIDA</strong></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:5px;background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">DESCRIPCIÓN</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">CANTIDAD</td>
							<td style="width: 15%; font-size:12px; text-align:  right; background-color:#ECF0F1; border-right:1px solid #000;">PRECIO&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';

				$total_cant_salidas = 0;
				$total_prec_salidas = 0;

				foreach($datos_entregados as $info_ent){
					$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: left; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$info_ent->descrip.'</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">'.abs($info_ent->cantidad).'</td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;">$'.number_format($info_ent->precioneto, 2, '.', ',').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';

					$total_cant_salidas =  $total_cant_salidas + abs($info_ent->cantidad);
					$total_prec_salidas =  $total_prec_salidas + $info_ent->precioneto;
				}

				$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; border-right:1px solid #000;"><strong>TOTAL</strong></td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"><strong>'.$total_cant_salidas.'</strong></td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;"><strong>$'.number_format($total_prec_salidas, 2, '.', ',').'</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
					</tbody>
				</table>';

				if($info->cli_email != ""){
					$codigosCargosAbonos = explode(",", $info->cli_email);
					$idrec_cargo = $codigosCargosAbonos[0];
					$idrec_abono = $codigosCargosAbonos[1];

					$valor_cargo = ""; $valor_abono = "";
					$forma_cargo = ""; $forma_abono = "";
					$notas_cargo = ""; $notas_abono = "";

					if($idrec_cargo != ""){
						$info_cargo = $this->ventas_model->getInformacionCargoCanje($idrec_cargo);

						$valor_cargo = number_format(abs($info_cargo['valor']), 2, '.', ',');
						$forma_cargo = $info_cargo['forma_pago'];
						$notas_cargo = $info_cargo['notas'];
					}
					if($idrec_abono != ""){
						$info_abono = $this->ventas_model->getInformacionAbonoCanje($idrec_abono);

						$valor_abono = number_format(abs($info_abono['valor']), 2, '.', ',');
						$forma_abono = $info_abono['forma_pago'];
						$notas_abono = $info_abono['notas'];
					}

					$titulo .= '<br><br><br>
					<table>
						<tbody>
							<tr>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 49%; font-size:12px; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; text-align:center;"><strong>DETALLE CARGO</strong></td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 49%; font-size:12px; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; text-align:center;"><strong>DETALLE ABONO</strong></td>
							</tr>
							<tr>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Valor:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;$'.$valor_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Valor:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;$'.$valor_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Forma de Pago:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$forma_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Forma de Pago:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$forma_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Notas:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$notas_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Notas:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$notas_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
						</tbody>
					</table>';
				}

                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Comprobante_Canje.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}

        function comprobanteQuedan($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');

			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');

			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);

			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
			$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
			$direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);
			$municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);
			$telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);
			$correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);

			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;
			foreach($infoProductos as $infoProd){
				if(number_format($infoProd->tax1) == 0){
					$totExento = $totExento + ($infoProd->cantidad * $infoProd->preciotran);
                    $totExento = round($totExento,2);

				}

				if(number_format($infoProd->tax1) != 0){
					$totGravado = $totGravado + (($infoProd->cantidad) * ($infoProd->preciotran  * (1 + ($infoProd->tax1 / 100))));
                    $totGravado = $totGravado;
					$totsinIva = $totsinIva + ($infoProd->cantidad * $infoProd->preciotran);
                    $totsinIva = $totsinIva;
				}
			}

			$totIva = $totGravado - $totsinIva;
			$totSumas = $totsinIva + $totExento;
			$totSumas = $totSumas;
			$percepcion = 0; $permitePercepcion = 0;

			if($provee_tipo != 3 && $empper == 1){
				$permiteRetencion = 1;
				if($totsinIva > 100){
					$percepcion = $totsinIva * 0.01;
					$percepcion = number_format(round($percepcion,2), 2 , '.', ',');
				}
			}

			$totalFinal = $totSumas + $totIva - $percepcion;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){

                $forma_pago= $info->numx;
                $fecha_pago_ref= $info->referencia;

                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }


                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }

                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }

                    $fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }

                $estructura .= '<br><br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								';

                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }


				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format($totalFinal, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>

                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día  <strong>'.$fecha_pago_ref.'</strong>.</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';

				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}

				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totalFinal, 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';

                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #6E6E6E;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';

                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";
                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';

				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format($totalFinal, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>

                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';

				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}

				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totalFinal, 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
			}

			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}

        function valueinv($sucursal, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1');
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);

                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';

                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);

                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';

                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% Prom.</td>
                   </tr>';

                $titulo.='</tbody></table>';

                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function recepcionDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);

            $return = '';

            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }


            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);

            $fichero = "Recepcion_".$trannum.".txt";

            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
        }

        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U');
            $objPHPExcel->setActiveSheetIndex(0);


            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }

            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        }

        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");

                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }

                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }

                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];
                $telefono = $det['telefono'];

                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }


                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){

                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }


                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';

                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }



                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:8%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:12px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um_orden.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';

                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }



                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>

                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }

        function send_email($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");

                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];

                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }

                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }

                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];
                $telefono = $det['telefono'];

                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }


                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){

                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }


                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';

                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }



                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';

                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }



                    $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>

                                </table>';
                echo json_encode($estructura);
            }
        }

        function send_email2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");

                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];

                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }

                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }

                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];
                $telefono = $det['telefono'];

                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }


                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){

                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }


                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';

                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }



                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';

                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', ',');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }



                    $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>

                                </table>';
                return($estructura);
            }
        }

        function enviar_correo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $cc = $this->input->post('cc');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                if($de!=""){

                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $tabla = $this->send_email2($trannum);
                    //$this->load->library('My_PHPMailer');

                    //$this->email->subject($asunto);
                    //$this->email->set_mailtype("html");
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;



                    $this->load->library('My_PHPMailer');
                    $mail = new PHPMailer();
                    $mail->IsSMTP(); // establecemos que utilizaremos SMTP
                    $mail->SMTPAuth   = true; // habilitamos la autenticación SMTP
                    $mail->SMTPSecure = "tls";
                    $mail->Host       = "smtp.gmail.com";      // establecemos GMail como nuestro servidor SMTP
                    $mail->Port       = 587;                   // establecemos el puerto SMTP en el servidor de GMail
                    $mail->Username   = "versanetsasv@gmail.com";  // la cuenta de correo GMail
                    $mail->Password   = "Egga#94662";            // password de la cuenta GMail
                    $mail->IsHTML(true);
                    $mail->SetFrom($de, $nombre_comercial);  //Quien envía el correo
                    $mail->addAddress($de);
                    $mail->Subject = $asunto;  //Asunto del mensaje
                    $mail->Body = $body;
                    $destino = $para;
                    //$arreglo_para = explode(",", $para);
                    // $cant = count($arreglo_para);
                    //for($m = 0; $m<$cant; $m++){
                    $mail->AddAddress($para);
                    if($cc!=""){
                        $mail->AddAddress($cc);

                    }else{
                        $mail->AddAddress($cc);
                    }
                    $mail->CharSet = 'UTF-8';

                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden de Compra');
                    $pdf->SetSubject('Orden de Compra');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetMargins(5, 5, 5);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetAutoPageBreak(TRUE, 5);
                    //relación utilizada para ajustar la conversión de los píxeles
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    //---------------------------------------------------------
                    //establecer el modo de fuente por defecto
                    $pdf->setFontSubsetting(true);
                    //$pdf->setPageOrientation('Portrait');
                    $pdf->setPageOrientation('P');

                    // Establecer el tipo de letra
                    //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                    // Helvetica para reducir el tamaño del archivo.
                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    // Añadir una página
                    // Este método tiene varias opciones, consulta la documentación para más información.
                    // set auto page breaks
                    //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                    //$pdf->SetAutoPageBreak(TRUE, 1);

                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage( 'P', 'LETTER' );

                   $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");

                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];

                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }

                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }

                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];
                $telefono = $det['telefono'];

                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }


                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){

                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', '');
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }


                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';

                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }



                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';

                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }



                    $estructura .= '</table><table style="border: 1px solid #6E6E6E;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>

                                </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "orden_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo.".pdf";
                    $pdf->Output($fullpath,'F');
                    //$this->email->message($body);
                    if($nombre_archivo!=''){
                        $mail->AddAttachment($fullpath, $name = $nombre_archivo.".pdf",  $encoding = 'base64', $type = 'application/pdf');
                    }

                    if(!$mail->Send()) {
                        unlink($fullpath);
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    } else {
                        unlink($fullpath);
                        $notas_correo = "Correo enviado de: ". $de . " a: ". $para . ','.$cc;
                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",
                        );
                        $sent_suc = $this->compras_model->insertOrders_100a($trannum,3,$notas_correo);
                        echo json_encode($array_result);
                    }
                }else{
                    $array_result = array(
                        "mensaje" =>"El empleado no tiene correo",
                        "type" =>"warning",
                    );
                    echo json_encode($array_result);
                }
            }
        }

        function comprobanteRetencion($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante de Retención');
            $pdf->SetSubject('Comprobante de Retención');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');

            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');

			$this->load->model('compras_model');

			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);

			foreach($datos as $info){
				//$totalVenta = $info->valcosto + $info->valtax1+$info->valtax5;
				$totalVenta = $info->valcosto;

				$numero = number_format(abs($info->valtax5), 2, '.', ',');
				$TotalLetras = $this->convertir_a_letras($numero);

				$estructura = '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
				</table>';

				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
				</table>';

				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
				</table>';
			}

			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante de Retención.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}

		function impresionCorteXHTML($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                    redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                
                $nombreFormato = 'Reimpresion Corte X'; 
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg(); 
                
                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                	$cnt = 0;        
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);

                $valpag = array();
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
                
                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }
            
                $titulo = '
				<table style="width:100%;">
					<thead style="width:100%;">
						<tr style="width:100%;">
	                        <th style="padding:0px; margin:0px; width:30%;">
	                        	<img style="text-align:center; width:210px; height:95px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'">
	                        </th>
	                        <th style="padding:0px; margin:0px; width:70%; padding:0px; margin:0px;">
	                            <label style="font-size:18px; font-weight:bold; text-align:right; margin:0px; padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
	                            <br><label style="text-align:right; font-size:15px; margin:0px; padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> FECHA: '.$fechaCorte.'<br> Z:'.$numero_z.' X:'.$numero_x.'</label>        
	                        </th>
	                    </tr>
	                    <tr style="width:100%;">
	                        <th style="width:50%; border:1px solid black; font-size:14px; text-align:center; font-weight: bold; background-color:lightblue;">TRANSACCIONES</th>
	                        <th style="width:50%; border:1px solid black; font-size:14px; text-align:center; font-weight: bold; background-color:lightblue;">CUADRE DE CAJA</th>
	                    </tr>
	                </thead>
	                <tbody>';
                
                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
                               
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;
                    
                    $titulo .='
                    <tr style="width:100%;">
                        <td style="font-weight:bold;"><u>'.$docs->descrip.'</u></td>
                    </tr>';
                    
                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;

                            if($t == 0){
                                $numInicial = $ven->numero;
                            }

                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }

                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;

                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                    }
                                }
                            }

                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }    
                	/*
                    $titulo .='
                    <tr style="width:100%;">
                        <td style="font-size:10px; width:100%;"></td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">Del:</td>
                        <td style="width:25%; text-align:right;">'.$numInicial.'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">Al:</td>
                        <td style="width:25%; text-align:right;">'.$numFinal.'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">Operaciones:</td>
                        <td style="width:25%; text-align:right;">'.$numdoc.'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">Ventas Exentas:</td>
                        <td style="width:25%; text-align:right;">'.number_format(round($subtotalex, 2),2).'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">Ventas Gravadas:</td>
                        <td style="width:25%; text-align:right;">'.number_format(round($subtotalgr, 2),2).'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right;">IVA:</td>
                        <td style="width:25%; text-align:right;">'.number_format(round($subtotaliv, 2),2).'</td>
                    </tr>
                    <tr style="width:100%;">
                        <td style="width:40%; text-align:right; font-weight:bold;">Sumas:</td>
                        <td style="width:25%; text-align:right; font-weight:bold; border-top: 1px solid black;">'.number_format(round($subtotal, 2),2).'</td>
                    </tr>';
                    */
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                
                /*
                $titulo .= '
                <tr>
                    <td style="font-size:10px; width:100%"></td>
                </tr>
                <tr>
                    <td style="font-weight: bold"><u>Totales</u></td>
                </tr>
                <tr>
                    <td style="font-size:10px; width:100%"></td>
                </tr>
                <tr>
                    <td style="width:40%; text-align:right">Operaciones:</td>
                    <td style="width:25%; text-align:right">'.$numdoc.'</td>
                </tr>
                <tr>
                    <td style="width:40%; text-align:right">Ventas Exentas:</td>
                    <td style="width:25%; text-align:right">'.number_format(round($totalexglobal, 2),2).'</td>
                </tr>
                <tr>
                    <td style="width:40%; text-align:right">Ventas Gravadas:</td>
                    <td style="width:25%; text-align:right">'.number_format(round($totalgrglobal, 2),2).'</td>
                </tr>
                <tr>
                    <td style="width:40%; text-align:right">IVA:</td>
                    <td style="width:25%; text-align:right">'.number_format(round($totalivglobal, 2),2).'</td>
                </tr>
                <tr>
                    <td style="width:40%; text-align:right; font-weight:bold">Sumas:</td>
                    <td style="width:25%; text-align:right; font-weight:bold; border-top: 1px solid black">'.number_format(round($totalglobal, 2),2).'</td>
                </tr>';
                            
                //Fin transacciones.
            	//Inicio cuadre de caja.
            	$titulo .=' <tr>
                                <td style="font-size:10px; width:100%"></td>
                            </tr>
                            
                            <tr>
                                <td style="width:35%; text-align:right; font-weight:bold"><u>INGRESOS</u></td>
                           </tr>
                            
                            <tr>
                                <td style="font-size:10px; width:100%"></td>
                            </tr>';
                            $total_ing_sum=0;
                            $l=0;
                            foreach($tipospagos as $tip){
                            $l++;
                            }
                            $p=0;
                            foreach($tipospagos as $tip){
                                
                                $titulo .='<tr>
                                            <td style="width:35%; text-align:right">'.substr($tip->descrip, 0, 20).':</td>
                                            <td style="width:20%; text-align:right">'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>
                                           </tr>';        
                                
                                
                            
			                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);
			                    $p++;
                       		}   
                $titulo .='<tr>
                                <td style="width:35%; text-align:right; font-weight:bold">Sumas:</td>
                                <td style="width:20%; text-align:right; font-weight:bold; border-top: 1px solid black">'.number_format(round($total_ing_sum, 2),2).'</td>
                           </tr>
                           <tr>
                                <td style="font-size:10px; width:100%"></td>
                           </tr>';
                
                
                                        
                $titulo .='<tr>
                                <td style="width:35%; text-align:right; font-weight:bold"><u>Forma de pago</u></td>
                                <td style="width:20%; text-align:right; font-weight:bold"><u>Sistema</u></td>
                                <td style="width:20%; text-align:right; font-weight:bold"><u>Caja</u></td>
                                <td style="width:23%; text-align:right; font-weight:bold"><u>Diferencia</u></td>
                           </tr>';
                //Cambia en el Z

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);

                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;
                
                                         
                foreach($infoCuadre as $info){
                    $valorSistema = number_format(round($info->valorsys, 2),2);
                    $valorCaja = number_format(round($info->valorusr, 2),2);
                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;
            
                    if($valorSistema == 0){
                            $diferencia = $valorCaja;
                    }else{
                            $diferencia = $valorCaja - $valorSistema;
                    }
                    $titulo .='
                            <tr>
                                <td style="width:35%; text-align:right">'.substr($info->formapago, 0, 30).'</td>
                                <td style="width:20%; text-align:right">'.number_format(round($info->valorsys, 2),2).'</td>
                                <td style="width:20%; text-align:right"> '.number_format(round($info->valorusr, 2),2).'</td>
                                <td style="width:23%; text-align:right">'.number_format(round($diferencia, 2),2).'</td>
                            </tr>';
                }
            
                $titulo .=' 
                        <tr>
                                <td style="font-size:10px; width:100%"></td>
                        </tr>
                        <tr>
                                <td style="width:35%; text-align:right; font-weight:bold"><u>RESUMEN</u></td>
                        </tr>
                         <tr>
                                <td style="width:35%; text-align:right">Sistema:</td>
                                <td style="width:20%; text-align:right">'.number_format(round($totalSistema, 2),2).'</td>
                        </tr>
                        
                        <tr>
                                <td style="width:35%; text-align:right">Caja:</td>
                                <td style="width:20%; text-align:right">'.number_format(round($totalCaja, 2),2).'</td>
                        </tr>';        
            
                        $totalDiferencia = $totalCaja - $totalSistema;
            
                        if($totalDiferencia > 0){
                        $titulo .='<tr>
                                   <td style="width:35%; text-align:right; font-weight:bold">Sobrante:</td>
                                   <td style="width:20%; text-align:right; border-top:1px solid black; font-weight:bold">'.number_format(round($totalDiferencia, 2),2).'</td>
                                   </tr>';
                        }else if($totalDiferencia < 0){
                        $titulo .='<tr>
                                   <td style="width:35%; text-align:right; font-weight:bold">Faltante:</td>
                                   <td style="width:20%; text-align:right; border-top:1px solid black; font-weight:bold">'.number_format(round($totalDiferencia, 2),2).'</td>
                                   </tr>';    
                        }else if($totalDiferencia == 0){
                        $titulo .='<tr>
                                   <td style="width:35%; text-align:right; font-weight:bold">Diferencia:</td>
                                   <td style="width:20%; text-align:right; border-top:1px solid black; font-weight:bold">'.number_format(round($totalDiferencia, 2),2).'</td>
                                   </tr>';    
                        }
            
                        //Cambia en el Z    
                        //$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);
            
            */
            $titulo .= '</tbody>';
            $titulo .= '</table>';

            $titulo .= '<h1 style="text-align:center"></h1>';            
            $titulo .= '<h1 style="text-align:center"></h1>';            
            $titulo .= '<h1 style="text-align:center">FIRMA:______________________</h1><br><h2 style="text-align:center; font-weight: normal">'.$this->session->userdata('userLog').'</h2>';
        	
        	/*
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                        </tr>
                    </tbody>
                </table>';
             */

                echo $titulo;
	        }    
	    }
	}
?>
