<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct(){
            parent::__construct();
		}

        function eliminarTildes($cadena){

            $cadena = str_replace(

                array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),

                array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),

                $cadena

            );

            

            $cadena = str_replace(

                array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),

                array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),

                $cadena

            );

            

            $cadena = str_replace(

                array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),

                array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),

                $cadena

            );

            

            $cadena = str_replace(

                array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),

                array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),

                $cadena

            );

            

            $cadena = str_replace(

                array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),

                array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),

                $cadena

            );

            

            $cadena = str_replace(

                array('ñ', 'Ñ', 'ç', 'Ç'),

                array('n', 'N', 'c', 'C'),

                $cadena

            );

            

            return $cadena;

        }


        # TICKETS
        function ventaTicketFinalNoAutorizado($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                }

                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                if($this->session->userdata('idcentrouser') == 2){
                    $NombreComercial = $NombreComercial.' Casa Matriz';
                }
                if($this->session->userdata('idcentrouser') == 5){
                    $NombreComercial = $NombreComercial.' Plaza Don Yon';
                }

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                //$cmds .= comandosTM::FontBoldEnable;
                //$cmds .= wordwrap(trim(strtoupper($RazonSocial)), 36, comandosTM::LineFeed);
                //$cmds .= comandosTM::FontBoldDisable;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= strtoupper($info->descrip).' N. '.$info->numero;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                        $tipoP = 'G';
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("LINEAS/UNIDADES:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;

                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }

                if($tipoPago == 10){
                    $cmds = $cmds.' '.$cmds;
                }
                
                //$printerName = "TMU950";//BORRAR
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.ngoxpos.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function ventaTicketNoAutorizado($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                }

                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                if($this->session->userdata('idcentrouser') == 2){
                    $NombreComercial = $NombreComercial.' Casa Matriz';
                }
                if($this->session->userdata('idcentrouser') == 5){
                    $NombreComercial = $NombreComercial.' Plaza Don Yon';
                }

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                //$cmds .= comandosTM::FontBoldEnable;
                //$cmds .= wordwrap(trim(strtoupper($RazonSocial)), 36, comandosTM::LineFeed);
                //$cmds .= comandosTM::FontBoldDisable;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= 'REIMPRESION '.strtoupper($info->descrip).' N. '.$info->numero;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                        $tipoP = 'G';
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("LINEAS/UNIDADES:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }

                if($tipoPago == 10){
                    $cmds = $cmds.' '.$cmds;
                }
                //$printerName = "TMU950";//BORRAR
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.ngoxpos.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function printDevolucionNoAutorizado($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
               

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                }

                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim(strtoupper($RazonSocial)), 39, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= strtoupper($info->descrip).' N. '.$info->numero;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                        $tipoP = 'G';
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                        $tipoP = 'E';
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(8);
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT").' '.$tipoP;
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("LINEAS/UNIDADES:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 50);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                //$printerName = "TMU950";//BORRAR
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.ngoxpos.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function ventaTicketFinal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{


                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $this->eliminarTildes($info->direccioncentro);
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
            
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= wordwrap(trim($direccionSuc), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper($namecentro)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($namecaja)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($GIRO)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper("CLIENTE: ".$cliente)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($cliente)>45){
                    $cmds .= substr($cliente, 45, 90);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;

                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;
                
                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= $comandosTM->pad(10);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;

                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($this->eliminarTildes($info->nameVendedor));
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'Siguenos en Instagram';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->insertarImagenNV('2D','2D');
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'Gracias por su compra';
                $cmds .= comandosTM::LineFeed;
                $cmds .= 'No se aceptan cambios ni devoluciones';
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::FullCut;
                
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function ventaTicket($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $this->eliminarTildes($info->direccioncentro);
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
            
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);
                
                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= wordwrap(trim($direccionSuc), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper($namecentro)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($namecaja)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($GIRO)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "REIMPRESION ".strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper("CLIENTE: ".$cliente)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($cliente)>45){
                    $cmds .= substr($cliente, 45, 90);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;

                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;
                
                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= $comandosTM->pad(10);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;

                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($this->eliminarTildes($info->nameVendedor));
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'Siguenos en Instagram';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->insertarImagenNV('2D','2D');
                //$cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'Gracias por su compra';
                $cmds .= comandosTM::LineFeed;
                $cmds .= 'No se aceptan cambios ni devoluciones';
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::FullCut;
                
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function printDevolucion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $this->eliminarTildes($info->direccioncentro);
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $printerName = $caja->notas;
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NombreComercial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 2));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                //$archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= wordwrap(trim($NombreComercial), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= wordwrap(trim($direccionSuc), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper($namecentro)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($namecaja)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= wordwrap(trim(strtoupper($GIRO)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= wordwrap(trim(strtoupper("CLIENTE: ".$cliente)), 48, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($cliente)>45){
                    $cmds .= substr($cliente, 45, 90);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;

                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($pro->descrip);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 13, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;
                
                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= $comandosTM->pad(10);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);

                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText($nameForma.":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }
                                  
                $cmds .= str_repeat("-", 48);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::FullCut;

                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function ventaNotaEnvio($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
               

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($namecentro), 0, 57);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
            

                $cmds .= substr(strtoupper($namecaja), 0, 57);
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 57);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip." [".trim($pro->modelo)."]";
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(10);
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(11);
                $cmds .= $comandosTM->padText("LINEAS/UNIDADES:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(11);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(11);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(11);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= comandosTM::FontUnderlineEnable;
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 12, "LEFT");  
                $cmds .= comandosTM::FontUnderlineDisable;
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);

                    $cmds .= $comandosTM->pad(11);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(11);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 57);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::FullCut;
                $printerName = explode(',', $printerName);
                $printerName = $printerName[0];
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));

                //header('Location: webclientprintvi:http://www.ngoxpos.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=3&printerIp='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        // Cortes de Caja---------------------------------------------------------------------------------------------------------------------
        function imprimirApertura($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				//$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$direccion = $this->sucursal_model->getDireccionCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText(substr(trim($RazonSocial), 0, 42), 42, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>42){
                    $cmds .= $comandosTM->padText(substr(trim($RazonSocial), 42, 42), 42, "BOTH");
                    $cmds .= comandosTM::LineFeed;
                }
                
                $cmds .= $comandosTM->padText(substr(trim($this->eliminarTildes($direccion)), 0, 42), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($direccion)>42){
                    $cmds .= $comandosTM->padText(substr(trim($direccion), 42, 42), 42, "BOTH");
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>84){
                    $cmds .= $comandosTM->padText(substr(trim($direccion), 84, 42), 42, "BOTH");
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= $comandosTM->padText(substr(trim($depto), 0, 42), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText(substr(trim($namecaja), 0, 42), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText('NRC: '.$NRF.' NIT: '.$NIT, 42, "BOTH");
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText("GIRO: ".substr($GIRO, 0, 36), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= $comandosTM->padText(substr($GIRO, 36, 42), 42, "BOTH");
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= $comandosTM->padText('IVA D.L. N#296', 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= $comandosTM->padText('APERTURA DE CAJA', 34, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText($fechaCorte, 34, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= $comandosTM->padText("CAJERO: " .$this->session->userdata('userLog'), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText("FONDO: " .number_format($fondocaja, 2, '.', ''), 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText("SE APERTURO CAJA", 42, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText(date_create()->format('d/m/Y H:i:s'), 42, "BOTH");                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function reporteCorteX($fechaactual, $idcentro, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('caja_model');
            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
                
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF         = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT         = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO        = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto       = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono    = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint  = $this->ventas_model->getDatosPrinter($idcaja);

                $namecentro  = $this->sucursal_model->getNameCentro($idcentro);
                $direccionSuc = $this->sucursal_model->getDireccionCentro($idcentro);
                $datoscaja   = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja) {
                    $namecaja    = $caja->descrip;
                    $numcaja     = $caja->resolucion;    
                    $numero_x    = $caja->numx;
					$numero_z    = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos   = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas     = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos   = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteXCredito('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI);
                $tipospagos = array_merge($tipospagos, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase]  = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;                               

                $cmds .= substr($direccionSuc ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccionSuc)>35){
                    $cmds .= substr($direccionSuc ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }

                //$cmds .= $namecaja;
                //$cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }
            
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(4);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal    = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal    = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal    = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                                                
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;
                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){
                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);
                    $p++;
                }

                if ($pagos_credito!=false) {
                    foreach ($pagos_credito as $pag) {
                        $nameFormaCr    = 'Credito';
                        $totalStringCr  = strlen($nameFormaCr);
                        $newCoordenada  = 0;  

                        $numPrecioCr    = number_format(round($pag->valor, 2), 2, '.', '');
                        $valorStringCr  = strval($numPrecio);
                        $numTotalCr     = strlen($valorString);
                        
                        $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        $total_cre_sum+=round($pag->valor, 2);

                        $total_ing_sum = $total_ing_sum +  $total_cre_sum;
                    }
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZOI($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }

                //ACTUALIZA X
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }    

        function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z) {

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);

                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $direccionSuc = $this->sucursal_model->getDireccionCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);


                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteXCredito('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI);
                $tipospagos = array_merge($tipospagos, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

                //$this->highlight_array(array_unique($tipospagos, SORT_REGULAR));

                $cnt = 0;
                $valpag = array();
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;                               

                $cmds .= substr($direccionSuc ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccionSuc)>35){
                    $cmds .= substr($direccionSuc ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }


                //$cmds .= $namecaja;
                //$cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>39){
                    $cmds .= substr($GIRO ,39,78);
                    $cmds .= comandosTM::LineFeed;
                }
            
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(4);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);
                foreach($tipospagos as $tip){

                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;                       
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2);
                    $p++;
                }

                if($pagos_credito!=false){

                    foreach($pagos_credito as $pag){

                        $nameFormaCr = 'Credito';
                        $totalStringCr = strlen($nameFormaCr);
                        $newCoordenada=0;  

                        $numPrecioCr = number_format(round($pag->valor, 2),2, '.', '');
                        $valorStringCr = strval($numPrecio);
                        $numTotalCr = strlen($valorString);
                        
                        $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        $total_cre_sum+=round($pag->valor, 2);
                    }

                    $total_ing_sum = $total_ing_sum + $total_cre_sum;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZOI($idcentro, $idcaja, $numero_x, $numero_z);
                //$this->highlight_array($infoCuadre);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
               
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;


                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function reporteCorteZFacturaz($fechaactual, $idcentro, $idcaja) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $direccionSuc = $this->sucursal_model->getDireccionCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }				

				$datosprint   = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr      = explode("/", $datosprint);
				$documentos   = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas     = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos   = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2Credito('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI);
                $tipospagos = array_merge($tipospagos, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip) {
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;         
                
                $cmds .= substr($direccionSuc ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccionSuc)>35){
                    $cmds .= substr($direccionSuc ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }
                
                //$cmds .= $namecaja;
                //$cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal   = $totalglobal   + $subtotal;
                    $totalexglobal = $totalexglobal + (($docs->inopera == 1) ? $subtotalex * -1 : $subtotalex);
                    $totalgrglobal = $totalgrglobal + (($docs->inopera == 1) ? $subtotalgr * -1 : $subtotalgr);
                    $totalivglobal = $totalivglobal + (($docs->inopera == 1) ? $subtotaliv * -1 : $subtotaliv);
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= $comandosTM->pad(4);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $l=0;
                $total_ing_sum=0;
                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteZ($idcentro, $idcaja, $numero_z, $fechaactual);
                foreach($tipospagos as $tip){

                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }

                if ($pagos_credito!=false) {
                    foreach($pagos_credito as $pag) {
                        $nameFormaCr   = 'Credito';
                        $totalStringCr = strlen($nameFormaCr);
                        $newCoordenada = 0;  

                        $numPrecioCr   = number_format(round($pag->valor, 2),2, '.', '');
                        $valorStringCr = strval($numPrecio);
                        $numTotalCr    = strlen($valorString);
                        
                        $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        $total_cre_sum+=round($pag->valor, 2);
                    }

                    $total_ing_sum = $total_ing_sum + $total_cre_sum;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZOI($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $direccionSuc = $this->sucursal_model->getDireccionCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}				

				$datosprint   = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr      = explode("/", $datosprint);
				$documentos   = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas     = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos   = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               
				$tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2Credito('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI);
                $tipospagos = array_merge($tipospagos, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;         
                
                $cmds .= substr($direccionSuc ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccionSuc)>35){
                    $cmds .= substr($direccionSuc ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }

                //$cmds .= $namecaja;
                //$cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal   = $totalglobal   + $subtotal;
                    $totalexglobal = $totalexglobal + (($docs->inopera == 1) ? $subtotalex * -1 : $subtotalex);
                    $totalgrglobal = $totalgrglobal + (($docs->inopera == 1) ? $subtotalgr * -1 : $subtotalgr);
                    $totalivglobal = $totalivglobal + (($docs->inopera == 1) ? $subtotaliv * -1 : $subtotaliv);   
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= $comandosTM->pad(4);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $l=0;
                $total_ing_sum=0;
                foreach($tipospagos as $tip){
                    $l++;
                }

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteZ($idcentro, $idcaja, $numero_z, $fechaactual);
                foreach($tipospagos as $tip){
                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  
                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }

                if ($pagos_credito!=false) {
                    foreach($pagos_credito as $pag) {
                        $nameFormaCr   = 'Credito';
                        $totalStringCr = strlen($nameFormaCr);
                        $newCoordenada = 0;  

                        $numPrecioCr   = number_format(round($pag->valor, 2),2, '.', '');
                        $valorStringCr = strval($numPrecio);
                        $numTotalCr    = strlen($valorString);
                        
                        $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        $total_cre_sum+=round($pag->valor, 2);
                    }

                    $total_ing_sum = $total_ing_sum + $total_cre_sum;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZOI($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZMensual($idanio, $idmes, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                $direccionSuc = $this->sucursal_model->getDireccionCentro($idcentro);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;

                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                switch ($idmes) {
                    case 1:
                        $nameMes = 'ENERO';
                        break;
                    case 2:
                        $nameMes = 'FEBRERO';
                        break;
                    case 3:
                        $nameMes = 'MARZO';
                        break;
                    case 4:
                        $nameMes = 'ABRIL';
                        break;
                    case 5:
                        $nameMes = 'MAYO';
                        break;
                    case 6:
                        $nameMes = 'JUNIO';
                        break;
                    case 7:
                        $nameMes = 'JULIO';
                        break;
                    case 8:
                        $nameMes = 'AGOSTO';
                        break;
                    case 9:
                        $nameMes = 'SEPTIEMBRe';
                        break;
                    case 10:
                        $nameMes = 'OCTUBRE';
                        break;
                    case 11:
                        $nameMes = 'NOVIEMBRE';
                        break;
                    case 12:
                        $nameMes = 'DICIEMBRE';
                        break;
                    default:
                        break;
                }

                $infoCortes = $this->ventas_model->getNumeroZCorteMensual($idcentro, $idcaja, $idanio, $idmes);
                $documentos = $this->ventas_model->tipos_doc_ventas_cortez_mensual($idcentro, $idcaja, $idanio, $idmes);
                $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZMensual($idcentro, $idcaja, $idanio, $idmes);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= wordwrap(trim($direccionSuc), 39, comandosTM::LineFeed);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 78);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 117);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z MENSUAL";
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= $nameMes." ".$idanio;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "IMPRESO ".$date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Zeta #", 7, "BOTH");
                $cmds .= $comandosTM->padText("Dia", 4, "BOTH");
                $cmds .= $comandosTM->padText("Gravadas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Exentas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Total", 10, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $totalglobal=0; $totalexglobal=0; $totalgrglobal=0; $totalivglobal=0;
                foreach($infoCortes as $info){
                    $subtotal = 0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    
                    $infoDocumentos = $this->ventas_model->getDocumentosVentasCorteZMensual($idcentro, $idcaja, $info->numz);
                    foreach($infoDocumentos as $ven){
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $ven->exento;
                        $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }
                        
                        $subtotalex = $subtotalex + $totalExento;
                        $subtotalgr = $subtotalgr + $totalGravado + $totalIVA;
                        $subtotaliv = $subtotaliv + $totalIVA;
                        $totalNumeroZ = $subtotalex + $subtotalgr;
                    }
                    $cmds .= $comandosTM->padText($info->numz, 7, "BOTH");
                    $cmds .= $comandosTM->padText($info->dia, 4, "BOTH");
                    $cmds .= $comandosTM->padText(number_format($subtotalgr, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($subtotalex, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalNumeroZ, 2, '.', ''), 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;

                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                    $totalglobal   = $totalgrglobal + $totalexglobal;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 11, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalgrglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalexglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "RESUMEN DE DOCUMENTOS";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Desde", 9, "BOTH");
                $cmds .= $comandosTM->padText("Hasta", 9, "BOTH");
                $cmds .= $comandosTM->padText("#", 9, "BOTH");
                $cmds .= $comandosTM->padText("Valor", 12, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                $numdocg = 0; $j=0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    $t = 0;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(3);
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                            $invexento = $ven->exento;
                            $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                            
                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            $numdoc++; $numdocg++; $numFinal = $ven->numero;
                            $t++;
                        }
                        $j++;
                    }
                    $cmds .= $comandosTM->padText($numInicial, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numFinal, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numdoc, 9, "BOTH");
                    $cmds .= $comandosTM->padText(number_format(round($subtotal, 2), 2, '.', ''), 12, "LEFT");
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal   = $totalglobal + $subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 18, "LEFT");
                $cmds .= $comandosTM->padText($j, 9, "BOTH");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 12, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'F.________________________________________';
                $cmds .= comandosTM::LineFeed;

                $cmds .= trim($this->session->userdata('userLog'));
                $cmds .= comandosTM::LineFeed;

                $cmds .= $date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'CZM'.$idanio. $idmes. $idcentro. $idcaja;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes //1 -> facturas 2->cortes
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        // FORMATOS IMPRESION------------------------------------------------------------------------------------------------------------------------------

        function ingresoCaja($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $detalleOI = $this->ventas_model->getDetalleOI($idrec);

                $datoscaja = $this->caja_model->getNameCaja($detalleOI["idcaja"]);
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->xpos;
                    $printerName = $caja->notas;
                }

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;
                
                $cmds .= substr(trim($RazonSocial), 0, 42);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::FontNormal;
                $cmds .= substr(strtoupper($namecaja), 0, 42);
                $cmds .= comandosTM::LineFeed;   
                
                $cmds .= substr($GIRO, 0, 42);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText("Caja #: ".$numcaja, 12, "RIGHT");
                $cmds .= $comandosTM->padText("Z: ".$detalleOI["numz"], 12, "BOTH");
                $cmds .= $comandosTM->padText("X: ".$detalleOI["numx"], 12, "LEFT");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "INGRESOS DE CAJA"; 
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= $detalleOI["nameIngreso"];
                $cmds .= comandosTM::LineFeed;
                $cmds .= str_repeat("-", 40);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= $comandosTM->padText("NUMERO: ". $idrec, 20, "RIGHT");
                $cmds .= $comandosTM->padText("FECHA: ".date_format(date_create($detalleOI["ingresa"]), 'd/m/Y'), 20, "LEFT");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= $comandosTM->pad(3);
                $cmds .= comandosTM::FontUnderlineEnable;
                $cmds .= "FORMA DE PAGO:";
                $cmds .= comandosTM::FontUnderlineDisable;
                $cmds .= substr($detalleOI["namePago"], 0, 30);
                $cmds .= comandosTM::LineFeed;

                if(strlen($detalleOI["namePago"]) > 30){
                    $cmds .= $comandosTM->pad(20);
                    $cmds .= substr($detalleOI["namePago"], 30, 30);
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(3);
                $cmds .= comandosTM::FontUnderlineEnable;
                $cmds .= "CONCEPTO:";
                $cmds .= comandosTM::FontUnderlineDisable;
                $cmds .= comandosTM::LineFeed;

                $detalleOI["concepto"] =  trim(preg_replace('/\s+/', ' ',$detalleOI["concepto"]));
                $detalleOI["concepto"] = wordwrap($detalleOI["concepto"], 40,  "\n". $comandosTM->pad(4), 1);
                $cmds .= $comandosTM->pad(4).$detalleOI["concepto"];
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "POR: $". number_format(round(abs($detalleOI["valor"]),2), 2 ,'.','');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;               
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontNormal;
                $cmds .= str_repeat("-", 40);
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= $comandosTM->padText(" Firma Autorizada ", 25, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $date_utc = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
                $date_utc = date_format($date_utc, "d/m/Y h:i A");
                $cmds .= $date_utc;
                $cmds .= comandosTM::LineFeed;
                if($detalleOI->estatus == 9){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "COMPROBANTE ANULADO";
                    $cmds .= comandosTM::FontBoldDisable;
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $trannum = 'OI'.$idrec;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        
        function egresoCaja($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $detalleOI = $this->ventas_model->getDetalleOI($idrec);

                $datoscaja = $this->caja_model->getNameCaja($detalleOI["idcaja"]);
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->xpos;
                    $printerName = $caja->notas;
                }

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontDoubleHeight;
                
                $cmds .= substr(trim($RazonSocial), 0, 42);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::FontNormal;
                $cmds .= substr(strtoupper($namecaja), 0, 42);
                $cmds .= comandosTM::LineFeed;   
                
                $cmds .= substr($GIRO, 0, 42);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText("Caja #: ".$numcaja, 12, "RIGHT");
                $cmds .= $comandosTM->padText("Z: ".$detalleOI["numz"], 12, "BOTH");
                $cmds .= $comandosTM->padText("X: ".$detalleOI["numx"], 12, "LEFT");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "EGRESOS DE CAJA"; 
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontNormal;
                $cmds .= $detalleOI["nameIngreso"];
                $cmds .= comandosTM::LineFeed;
                $cmds .= str_repeat("-", 40);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= $comandosTM->padText("NUMERO: ". $idrec, 20, "RIGHT");
                $cmds .= $comandosTM->padText("FECHA: ".date_format(date_create($detalleOI["ingresa"]), 'd/m/Y'), 20, "LEFT");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
               
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= $comandosTM->pad(3);
                $cmds .= comandosTM::FontUnderlineEnable;
                $cmds .= "FORMA DE PAGO:";
                $cmds .= comandosTM::FontUnderlineDisable;
                $cmds .= substr($detalleOI["namePago"], 0, 30);
                $cmds .= comandosTM::LineFeed;

                if(strlen($detalleOI["namePago"]) > 30){
                    $cmds .= $comandosTM->pad(20);
                    $cmds .= substr($detalleOI["namePago"], 30, 30);
                    $cmds .= comandosTM::LineFeed;
                }
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(3);
                $cmds .= comandosTM::FontUnderlineEnable;
                $cmds .= "CONCEPTO:";
                $cmds .= comandosTM::FontUnderlineDisable;
                $cmds .= comandosTM::LineFeed;

                $detalleOI["concepto"] = trim(preg_replace('/\s\s+/', ' ', $detalleOI["concepto"]));
                $detalleOI["concepto"] = wordwrap($detalleOI["concepto"], 40,  "\n". $comandosTM->pad(4), 1);
                $cmds .= $comandosTM->pad(4).$detalleOI["concepto"];
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "POR: $". number_format(round(abs($detalleOI["valor"]),2), 2 ,'.','');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontNormal;
                $cmds .= str_repeat("-", 40);
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= $comandosTM->padText(" Firma Autorizada ", 25, "BOTH");
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $date_utc = new \DateTime("now", new \DateTimeZone("America/El_Salvador"));
                $date_utc = date_format($date_utc, "d/m/Y h:i A");
                $cmds .= $date_utc;
                $cmds .= comandosTM::LineFeed;
                if($detalleOI["estatus"] == 9){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "COMPROBANTE ANULADO";
                    $cmds .= comandosTM::FontBoldDisable;
                }
                $cmds .= comandosTM::LineFeed;                                                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $trannum = 'OI'.$idrec;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                
                header('Location: webclientprintvi:http://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = $funcion;
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				foreach($tipospagos as $tip){
					$valpag_retencion[$tip->cajclase] = 0;
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 13%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Retención</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 12%">Forma de Pago</th></tr>
                            </thead>';
                $titulo .='<tbody>';
                $totalGeneral = 0;
                $totalExento = 0;
                $totalGravado = 0;
                $totalRetencion = 0;
                $totalIva = 0;
                $totalDocs = 0;
				$total_remesar = 0;
                foreach($documentos as $docs){
                    
					$numdoc = 0;
					$subtotal=0;
					$subtotalexento = 0;
					$subtotalgravado = 0;
					$subtotalretencion = 0;
					$subtotaliva = 0;
                    $titulo .= '<tr><th colspan="11"><br></th></tr><tr><th colspan="11" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++;
                            $totalDocs++;
                            $exento = 0;
                            $gravado = 0;
                            $iva = 0;
                            $retencion = 0;
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                if($fact->tipoCliente == 3 && abs($fact->valventan) >= 100){
                                    if($fact->valventan >= 100){
										$retencion = ($fact->valventan*0.01)*-1;
									}else{
										$retencion = ($fact->valventan*0.01);
									}
                                    $gravado = $fact->valventan;
                                }else{
                                    $gravado = ($fact->valtax1 / 0.13);
                                    $exento = $fact->valventan-$gravado;
                                }
                            }
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva+$retencion;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotalretencion += $retencion;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($fact->namecliente, 0, 22);
                            $nameVendedor = substr($fact->namevendedor, 0, 20);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                            
                            if($pagos!=false){
                                if($cadena_pago!=""){
                                    $cadena_pago.=',';
                                }
                                foreach($pagos as $money){
                                    $cadena_pago .= $money->descrip.",";
                                }
                                $cadena_pago = substr($cadena_pago, 0, -1);
                            }
                            $cadena_pago = substr($cadena_pago, 0, 25);
                           
							
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
										
										if($money->formaPag=="Efectivo" ||$money->formaPag=="Cheques"){
											if($fact->inopera==1){
												$total_remesar -= (abs($money->valor) - abs($money->vuelto));
											}else{
												$total_remesar += (abs($money->valor) - abs($money->vuelto));
											}
										}
										
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $fontColor = ( $fact->estatus == 9 ) ? '#EF1839' : 'black';

                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:  left; font-weight:normal; width:10%; color:'.$fontColor.';">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight:normal; width: 6%; color:'.$fontColor.';">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight:normal; width: 5%; color:'.$fontColor.';">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:  left; font-weight:normal; width:18%; color:'.$fontColor.';">'.(($fact->estatus == 9) ? 'ANULADO ANULADO' : $nameCliente).'</td>
                                <td style="font-size:8px; text-align:  left; font-weight:normal; width:13%; color:'.$fontColor.';">'.(($fact->estatus == 9) ? 'ANULADO ANULADO' : $nameVendedor).'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width: 7%; color:'.$fontColor.';">'.$this->session->userdata("simboloMoneda").number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width: 7%; color:'.$fontColor.';">'.$this->session->userdata("simboloMoneda").number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width: 7%; color:'.$fontColor.';">'.$this->session->userdata("simboloMoneda").number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width: 7%; color:'.$fontColor.';">'.$this->session->userdata("simboloMoneda").number_format(round($retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width: 8%; color:'.$fontColor.';">'.$this->session->userdata("simboloMoneda").number_format(round($gravado+$iva+$exento+$retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align: right; font-weight:normal; width:12%; color:'.$fontColor.';">'.$cadena_pago.'</td>
                            </tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:42%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalretencion, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:12%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalRetencion += $subtotalretencion;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '</tbody></table>';
                $titulo .= '<br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Retención</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:10%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalIva, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalRetencion, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGeneral, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><table>
                <thead>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">INGRESOS</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo_Retencion('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $cant_fp++;
                        }
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                        }
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      

                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                $total_ing_sum=0;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                           $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                                $total_ing_sum+=$valpagG[$tip->cajclase];
                        }
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_ing_sum, 2),2).'</td></tr>
				
				</tbody></table>';
				
				
				$titulo .='<br><br><table>
                <thead>
				<tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:20%;background-color:gray; color:white;">REMESA</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
				</thead>
				<tbody>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:20%;background-color:#C2CBCE;">Efectivo + Cheques&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Fecha&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;background-color:#C2CBCE;">Hora&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;background-color:#C2CBCE;">Cuenta&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Valor Remesado&nbsp;&nbsp;</td>
				</tr>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:20%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
				</tr>
				
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:left; font-weight: bold; width:100%;">&nbsp;Observaciones:<br><br></td>

				</tr>
				
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-top: 1px solid black;"><td style="border-top: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:30%;">Elaborado por</td></tr>
				</tbody></table>';
				

				/*
				
				<tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">Total a Remesar</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
				*/
				
					
                
               
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
    }
?>