<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    require 'vendor/autoload.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception; 

    class Reports extends CI_Controller {
        
        function __construct() {
            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}
        
		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}
        
		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}
        
		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}
        
		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}
        
		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}
        
		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}
        
		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}
		
		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}
		
		function convertir_a_letras($numero){
            global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
        
        function valorEnLetras($x){ 
            $I7 = " ";
            $I9 = " ";
            if ($x<0) { $signo = "menos ";} 
            else      { $signo = "";} 
            $x = abs ($x); 
            $C1 = $x; 

            $G6 = floor($x/(1000000));  // 7 y mas 

            $E7 = floor($x/(100000)); 
            $G7 = $E7-$G6*10;   // 6 

            $E8 = floor($x/1000); 
            $G8 = $E8-$E7*100;   // 5 y 4 

            $E9 = floor($x/100); 
            $G9 = $E9-$E8*10;  //  3 

            $E10 = floor($x); 
            $G10 = $E10-$E9*100;  // 2 y 1 


            $G11 = round(($x-$E10)*100,0);  // Decimales 
            ////////////////////// 

            $H6 = $this->unidades($G6); 

            if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
            else {    $H7 = $this->decenas($G7); } 

            $H8 = $this->unidades($G8); 

            if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
            else {    $H9 = $this->decenas($G9); } 

            $H10 = $this->unidades($G10); 

            if($G11 < 10) { $H11 = "0".$G11; } 
            else { $H11 = $G11; } 

            ///////////////////////////// 
                if($G6==0) { $I6=" "; } 
            elseif($G6==1) { $I6="Millón "; } 
                     else { $I6="Millones "; } 

            if ($G8==0 AND $G7==0) { $I8=" "; } 
                     else { $I8="Mil "; } 

            $I10 = ""; 
            $I11 = "/100 US DOLARES ";

            $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

            return $C3; //Retornar el resultado 
        } 
        
        public function unidades($u){ 
            if ($u==0)  {$ru = " ";} 
            elseif ($u==1)  {$ru = "Un ";} 
            elseif ($u==2)  {$ru = "Dos ";} 
            elseif ($u==3)  {$ru = "Tres ";} 
            elseif ($u==4)  {$ru = "Cuatro ";} 
            elseif ($u==5)  {$ru = "Cinco ";} 
            elseif ($u==6)  {$ru = "Seis ";} 
            elseif ($u==7)  {$ru = "Siete ";} 
            elseif ($u==8)  {$ru = "Ocho ";} 
            elseif ($u==9)  {$ru = "Nueve ";} 
            elseif ($u==10) {$ru = "Diez ";} 

            elseif ($u==11) {$ru = "Once ";} 
            elseif ($u==12) {$ru = "Doce ";} 
            elseif ($u==13) {$ru = "Trece ";} 
            elseif ($u==14) {$ru = "Catorce ";} 
            elseif ($u==15) {$ru = "Quince ";} 
            elseif ($u==16) {$ru = "Dieciseis ";} 
            elseif ($u==17) {$ru = "Decisiete ";} 
            elseif ($u==18) {$ru = "Dieciocho ";} 
            elseif ($u==19) {$ru = "Diecinueve ";} 
            elseif ($u==20) {$ru = "Veinte ";} 

            elseif ($u==21) {$ru = "Veintiun ";} 
            elseif ($u==22) {$ru = "Veintidos ";} 
            elseif ($u==23) {$ru = "Veintitres ";} 
            elseif ($u==24) {$ru = "Veinticuatro ";} 
            elseif ($u==25) {$ru = "Veinticinco ";} 
            elseif ($u==26) {$ru = "Veintiseis ";} 
            elseif ($u==27) {$ru = "Veintisiente ";} 
            elseif ($u==28) {$ru = "Veintiocho ";} 
            elseif ($u==29) {$ru = "Veintinueve ";} 
            elseif ($u==30) {$ru = "Treinta ";} 

            elseif ($u==31) {$ru = "Treinta y un ";} 
            elseif ($u==32) {$ru = "Treinta y dos ";} 
            elseif ($u==33) {$ru = "Treinta y tres ";} 
            elseif ($u==34) {$ru = "Treinta y cuatro ";} 
            elseif ($u==35) {$ru = "Treinta y cinco ";} 
            elseif ($u==36) {$ru = "Treinta y seis ";} 
            elseif ($u==37) {$ru = "Treinta y siete ";} 
            elseif ($u==38) {$ru = "Treinta y ocho  ";} 
            elseif ($u==39) {$ru = "Treinta y nueve ";} 
            elseif ($u==40) {$ru = "Cuarenta ";} 

            elseif ($u==41) {$ru = "Cuarenta y un ";} 
            elseif ($u==42) {$ru = "Cuarenta y dos ";} 
            elseif ($u==43) {$ru = "Cuarenta y tres ";} 
            elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
            elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
            elseif ($u==46) {$ru = "Cuarenta y seis ";} 
            elseif ($u==47) {$ru = "Cuarenta y siete ";} 
            elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
            elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
            elseif ($u==50) {$ru = "Cincuenta ";} 

            elseif ($u==51) {$ru = "Cincuenta y un ";} 
            elseif ($u==52) {$ru = "Cincuenta y dos ";} 
            elseif ($u==53) {$ru = "Cincuenta y tres ";} 
            elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
            elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
            elseif ($u==56) {$ru = "Cincuenta y seis ";} 
            elseif ($u==57) {$ru = "Cincuenta y siete ";} 
            elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
            elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
            elseif ($u==60) {$ru = "Sesenta ";} 

            elseif ($u==61) {$ru = "Sesenta y un ";} 
            elseif ($u==62) {$ru = "Sesenta y dos ";} 
            elseif ($u==63) {$ru = "Sesenta y tres ";} 
            elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
            elseif ($u==65) {$ru = "Sesenta y cinco ";} 
            elseif ($u==66) {$ru = "Sesenta y seis ";} 
            elseif ($u==67) {$ru = "Sesenta y siete ";} 
            elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
            elseif ($u==69) {$ru = "Sesenta y nueve ";} 
            elseif ($u==70) {$ru = "Setenta ";} 

            elseif ($u==71) {$ru = "Setenta y un ";} 
            elseif ($u==72) {$ru = "Setenta y dos ";} 
            elseif ($u==73) {$ru = "Setenta y tres ";} 
            elseif ($u==74) {$ru = "Setenta y cuatro ";} 
            elseif ($u==75) {$ru = "Setenta y cinco ";} 
            elseif ($u==76) {$ru = "Setenta y seis ";} 
            elseif ($u==77) {$ru = "Setenta y siete ";} 
            elseif ($u==78) {$ru = "Setenta y ocho  ";} 
            elseif ($u==79) {$ru = "Setenta y nueve ";} 
            elseif ($u==80) {$ru = "Ochenta ";} 

            elseif ($u==81) {$ru = "Ochenta y un ";} 
            elseif ($u==82) {$ru = "Ochenta y dos ";} 
            elseif ($u==83) {$ru = "Ochenta y tres ";} 
            elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
            elseif ($u==85) {$ru = "Ochenta y cinco ";} 
            elseif ($u==86) {$ru = "Ochenta y seis ";} 
            elseif ($u==87) {$ru = "Ochenta y siete ";} 
            elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
            elseif ($u==89) {$ru = "Ochenta y nueve ";} 
            elseif ($u==90) {$ru = "Noventa ";} 

            elseif ($u==91) {$ru = "Noventa y un ";} 
            elseif ($u==92) {$ru = "Noventa y dos ";} 
            elseif ($u==93) {$ru = "Noventa y tres ";} 
            elseif ($u==94) {$ru = "Noventa y cuatro ";} 
            elseif ($u==95) {$ru = "Noventa y cinco ";} 
            elseif ($u==96) {$ru = "Noventa y seis ";} 
            elseif ($u==97) {$ru = "Noventa y siete ";} 
            elseif ($u==98) {$ru = "Noventa y ocho  ";} 
            else            {$ru = "Noventa y nueve ";} 
            return $ru; //Retornar el resultado 
        } 

        public function decenas($d){ 
            if ($d==0)  {$rd = "";} 
            elseif ($d==1)  {$rd = "Ciento ";} 
            elseif ($d==2)  {$rd = "Doscientos ";} 
            elseif ($d==3)  {$rd = "Trescientos ";} 
            elseif ($d==4)  {$rd = "Cuatrocientos ";} 
            elseif ($d==5)  {$rd = "Quinientos ";} 
            elseif ($d==6)  {$rd = "Seiscientos ";} 
            elseif ($d==7)  {$rd = "Setecientos ";} 
            elseif ($d==8)  {$rd = "Ochocientos ";} 
            else            {$rd = "Novecientos ";} 
            return $rd; //Retornar el resultado 
        }
        
        function imprimirAperturaOld($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = strtoupper($this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5)));
				$direccion = strtoupper($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

                $fechaImpre = new DateTime();
                $fechaImpre = $fechaImpre->format('d/m/Y');

                $horaCorte = date_format(date_create($fechaactual), 'H:i');
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);

				$cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($RazonSocial)>39){
					$cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::LineFeed;
					$cmds .= comandosTM::FontBoldDisable;
                }

                $cmds .= substr(strtoupper($namecaja), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 39, 78);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($depto), 0, 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }
               
                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText(substr("CAJA #".$idcaja, 0, 13), 13, 'RIGHT');
                $cmds .= $comandosTM->padText(substr("Z: ".$numero_z, 0, 13), 13, 'BOTH');
                $cmds .= $comandosTM->padText(substr($fechaImpre, 0, 13), 13, 'LEFT');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "APERTURA DE CAJA";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');
                //$printerName = "TMU950";

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function reporteCorteZFacturazOld($fechaactual, $idcentro, $idcaja){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz; 
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
      
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }

        function impresionCorteZOld($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }

        function reporteCorteXOld($fechaactual, $idcentro, $idcaja){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "GTO";

                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteXOld($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        
        function eliminarTildes($cadena){
            $cadena = str_replace(
                array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
                array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
                $cadena
            );
            
            $cadena = str_replace(
                array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
                array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
                $cadena
            );
            
            $cadena = str_replace(
                array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
                array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
                array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
                array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ñ', 'Ñ', 'ç', 'Ç'),
                array('n', 'N', 'c', 'C'),
                $cadena
            );
            
            return $cadena;
        }

        //------------------------------------------------------------
        
        function imprimirAperturaOld1($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = strtoupper($this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5)));
				$direccion = strtoupper($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

                $fechaImpre = new DateTime();
                $fechaImpre = $fechaImpre->format('d/m/Y');

                $horaCorte = date_format(date_create($fechaactual), 'H:i');
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);

				$cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($RazonSocial)>39){
					$cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::LineFeed;
					$cmds .= comandosTM::FontBoldDisable;
                }

                $cmds .= substr(strtoupper($namecaja), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 39, 78);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($depto), 0, 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }
               
                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->padText(substr("CAJA #".$idcaja, 0, 13), 13, 'RIGHT');
                $cmds .= $comandosTM->padText(substr("Z: ".$numero_z, 0, 13), 13, 'BOTH');
                $cmds .= $comandosTM->padText(substr($fechaImpre, 0, 13), 13, 'LEFT');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "APERTURA DE CAJA";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');
                //$printerName = "TMU950";

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function reporteCorteZFacturazOld1($fechaactual, $idcentro, $idcaja){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz; 
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
      
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }

        function impresionCorteZOld1($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }

        function reporteCorteXOld1($fechaactual, $idcentro, $idcaja){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "GTO";

                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteXOld1($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 36);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 36) {
                    $cmds .= substr($GIRO, 36, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 72) {
                    $cmds .= substr($GIRO, 72, 36);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "GTO";
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        //--------------------------------------------------------------

        function imprimirApertura($fechaactual, $idcentro, $idcaja) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::FontSmall;
                $address = substr($direccion, 0, 35);
                $cmds .= $address;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $depto;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .=  "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr('GIRO: '.$GIRO, 0, 64);
                $cmds .= comandosTM::LineFeed;

                if(strlen($GIRO)>64){
                    $cmds .= substr($GIRO ,64,128);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "APERTURA DE CAJA";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= "CAJERO: " .$this->session->userdata('userLog');
                $cmds .= comandosTM::LineFeed;
            
                $cmds .= "FONDO: " .number_format($fondocaja, 2, '.', '');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "SE APERTURO CAJA";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= date_create()->format('d/m/Y H:i:s A');
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        
        function reporteCorteX($fechaactual, $idcentro, $idcaja) {

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteXCredito('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;                               

                $cmds .= substr($direccion ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccion)>35){
                    $cmds .= substr($direccion ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }
            
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(4);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){
                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2);
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZOI($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }

                //ACTUALIZA X
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }    

        function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z) {

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteXCredito('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

                //$this->highlight_array(array_unique($tipospagos, SORT_REGULAR));

                $cnt = 0;
                $valpag = array();
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;                               

                $cmds .= substr($direccion ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccion)>35){
                    $cmds .= substr($direccion ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }


                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>39){
                    $cmds .= substr($GIRO ,39,78);
                    $cmds .= comandosTM::LineFeed;
                }
            
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(4);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOI(0, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOI(1, $idcentro, $idcaja, $numero_x, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);
                foreach($tipospagos as $tip){

                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2);
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 24, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZOI($idcentro, $idcaja, $numero_x, $numero_z);
                //$this->highlight_array($infoCuadre);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
               
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function reporteCorteZFacturaz($fechaactual, $idcentro, $idcaja) {
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2Credito('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip) {
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;         
                
                $cmds .= substr($direccion ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccion)>35){
                    $cmds .= substr($direccion ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }

                
                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;
                $subtotalreten = 0;
                $totalglobalreten = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $subtotalreten = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }

                            if($ven->idtipo == 3 && $totalGravado >= 100){
                                $subtotalreten = $totalGravado * 0.01;
                                $subtotal = $subtotal - $subtotalreten;
                            }


                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    //------------------------------------------
                    $numCantidad = number_format(round($subtotalreten, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                    if($subtotalreten != 0){
                        $cmds .= $comandosTM->padText('- $'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                    }else{
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                    }
                    $cmds .= comandosTM::LineFeed;
                    //------------------------------------------

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobalreten += $subtotalreten;
                    $totalglobal   = $totalglobal   + $subtotal;
                    $totalexglobal = $totalexglobal + (($docs->inopera == 1) ? $subtotalex * -1 : $subtotalex);
                    $totalgrglobal = $totalgrglobal + (($docs->inopera == 1) ? $subtotalgr * -1 : $subtotalgr);
                    $totalivglobal = $totalivglobal + (($docs->inopera == 1) ? $subtotaliv * -1 : $subtotaliv);
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= $comandosTM->pad(4);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                //-----------------------------------
                $numCantidad = number_format(round($totalglobalreten, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                if($totalglobalreten != 0){
                    $cmds .= $comandosTM->padText('- $'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                }else{
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                }
                $cmds .= comandosTM::LineFeed;
                //-----------------------------------

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZOI($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z) {

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}	

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagosCR = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2Credito('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
                $tipospagosOI = $this->ventas_model->getFormasPagoCorteXOI($idcentro, $idcaja, $numero_x, $numero_z);

                $tipospagos = array_merge($tipospagos, $tipospagosOI, $tipospagosCR);
                $tipospagos = array_unique($tipospagos, SORT_REGULAR);

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 
                $cmds .= comandosTM::LineFeed;         
                
                $cmds .= substr($direccion ,0,35);
                $cmds .= comandosTM::LineFeed; 

                if(strlen($direccion)>35){
                    $cmds .= substr($direccion ,35,35);
                    $cmds .= comandosTM::LineFeed;
                }


                
                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 
            
                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO ,0,30);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>30){
                    $cmds .= substr($GIRO ,30,30);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 30);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;
                $subtotalreten = 0;
                $totalglobalreten = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $subtotalreten = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($docs->descrip);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }

                            if($ven->idtipo == 3 && $totalGravado >= 100){
                                $subtotalreten = $totalGravado * 0.01;
                                $subtotal = $subtotal - $subtotalreten;
                            }

                            $subtotalex = $subtotalex + $totalExento;

                            $subtotalgr = $subtotalgr + $totalGravado;

                            $subtotaliv = $subtotaliv + $totalIVA;

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalex, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotalgr, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotaliv, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    //------------------------------------------
                    $numCantidad = number_format(round($subtotalreten, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                    if($subtotalreten != 0){
                        $cmds .= $comandosTM->padText('- $'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                    }else{
                        $cmds .= $comandosTM->padText('$'.number_format(round($subtotalreten, 2),2), 11, 'LEFT');
                    }
                    $cmds .= comandosTM::LineFeed;
                    //------------------------------------------

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobalreten += $subtotalreten;
                    $totalglobal   = $totalglobal   + $subtotal;
                    $totalexglobal = $totalexglobal + (($docs->inopera == 1) ? $subtotalex * -1 : $subtotalex);
                    $totalgrglobal = $totalgrglobal + (($docs->inopera == 1) ? $subtotalgr * -1 : $subtotalgr);
                    $totalivglobal = $totalivglobal + (($docs->inopera == 1) ? $subtotaliv * -1 : $subtotaliv);   
                }

                $cmds .= comandosTM::LineFeed;
                $cmds .= $comandosTM->pad(4);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 24, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                //-----------------------------------
                $numCantidad = number_format(round($totalglobalreten, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Retencion: ", 24, 'LEFT');
                if($totalglobalreten != 0){
                    $cmds .= $comandosTM->padText('- $'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                }else{
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalglobalreten, 2),2), 11, 'LEFT');
                }
                $cmds .= comandosTM::LineFeed;
                //-----------------------------------

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //SECCION OTROS INGRESOS Y EGRESOS
                $sumasOI = 0;
                $infoIngresos = $this->ventas_model->getDetalleCorteOICorteZ(0, $idcentro, $idcaja, $numero_z);
                if(count($infoIngresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS INGRESOS A CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    
                    foreach($infoIngresos as $in){
                        $sumasOI += $in->valorusr;

                        $cmds .= $comandosTM->padText(substr($in->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($in->valorusr, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        
                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $in->cajclase){
                                if($in->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($in->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($in->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                $sumasOI = 0;
                $infoEgresos  = $this->ventas_model->getDetalleCorteOICorteZ(1, $idcentro, $idcaja, $numero_z);
                if(count($infoEgresos)>0){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "OTROS EGRESOS DE CAJA:";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    
                    foreach($infoEgresos as $eg){
                        $sumasOI += $eg->valorusr;

                        $cmds .= $comandosTM->padText(substr($eg->nameIngreso,0,20).": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($eg->valorusr*-1, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        
                        foreach ($tipospagos as $tip) {
                            if($tip->cajclase == $eg->cajclase){
                                if($eg->valorusr <= 0){
                                    $moneyvalor = abs(number_format(round($eg->valorusr, 2), 2, '.', ''));
                                }else{
                                    $moneyvalor = number_format(round($eg->valorusr, 2), 2, '.', '');
                                }
                                
                                $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - $moneyvalor;
                                $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - $moneyvalor;
                            }
                        }
                        
                    }
                    
                    $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($sumasOI*-1, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                ///////////////////////////////////////////

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = $this->eliminarTildes(substr($tip->descrip, 0, 20));
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2);
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 24, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZOI($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($tipospagos as $tip){
                    $totalUser = 0;
                    $totalSys = 0;
                    $countUser = 0;
                    $countSys = 0;

                    foreach($infoCuadre as $info){
                        $fechaImpre = $info->ingresa;

                        if($info->cajclase == $tip->cajclase){
                            if($info->tipo == 11 || $info->tipo == 12){
                                $totalUser += $info->valorsys;
                                $totalSys += $info->valorusr;
                            }else{
                                $totalUser += $info->valorusr;
                                $totalSys += $info->valorsys;
                            }
                            
                            $countUser += $info->countuser;
                            $countSys += $info->countsys;

                            $numerotransacc = $numerotransacc + 1;
                        }    
                    }

                    $numCantidad2 = number_format(round($totalSys, 2),2);
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 =  number_format(round($totalUser, 2),2);
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = $totalSys;
                    $valorCaja = $totalUser;

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = abs($valorCaja) - abs($valorSistema);

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2);
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$countSys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$countUser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $this->eliminarTildes($tip->descrip); 
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= '$'.$numCantidad4;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = abs($totalCaja) - abs($totalSistema);
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(4);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 24, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 24, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(4);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(4);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                //echo $cmds;
                //$printerName = "EPSON TM-H6000IV Slip"; //BORRAR
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZMensual($idanio, $idmes, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;

                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                switch ($idmes) {
                    case 1:
                        $nameMes = 'ENERO';
                        break;
                    case 2:
                        $nameMes = 'FEBRERO';
                        break;
                    case 3:
                        $nameMes = 'MARZO';
                        break;
                    case 4:
                        $nameMes = 'ABRIL';
                        break;
                    case 5:
                        $nameMes = 'MAYO';
                        break;
                    case 6:
                        $nameMes = 'JUNIO';
                        break;
                    case 7:
                        $nameMes = 'JULIO';
                        break;
                    case 8:
                        $nameMes = 'AGOSTO';
                        break;
                    case 9:
                        $nameMes = 'SEPTIEMBRe';
                        break;
                    case 10:
                        $nameMes = 'OCTUBRE';
                        break;
                    case 11:
                        $nameMes = 'NOVIEMBRE';
                        break;
                    case 12:
                        $nameMes = 'DICIEMBRE';
                        break;
                    default:
                        break;
                }

                $infoCortes = $this->ventas_model->getNumeroZCorteMensual($idcentro, $idcaja, $idanio, $idmes);
                $documentos = $this->ventas_model->tipos_doc_ventas_cortez_mensual($idcentro, $idcaja, $idanio, $idmes);
                $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZMensual($idcentro, $idcaja, $idanio, $idmes);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= $namecentro;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr('GIRO: '.$GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>39){
                    $cmds .= substr($GIRO ,33,72);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z MENSUAL";
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= $nameMes." ".$idanio;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "IMPRESO ".$date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Zeta #", 6, "BOTH");
                $cmds .= $comandosTM->padText("Dia", 7, "BOTH");
                $cmds .= $comandosTM->padText("Gravadas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Exentas", 8, "BOTH");
                $cmds .= $comandosTM->padText("Total", 9, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $totalglobal=0; $totalexglobal=0; $totalgrglobal=0; $totalivglobal=0;
                foreach($infoCortes as $info){
                    $subtotal = 0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    
                    $infoDocumentos = $this->ventas_model->getDocumentosVentasCorteZMensual($idcentro, $idcaja, $info->numz);
                    foreach($infoDocumentos as $ven){
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $ven->exento;
                        $productos = $this->ventas_model->getDataTran100kCorteZMensual($ven->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }
                        
                        $subtotalex = $subtotalex + $totalExento;
                        $subtotalgr = $subtotalgr + $totalGravado + $totalIVA;
                        $subtotaliv = $subtotaliv + $totalIVA;
                        $totalNumeroZ = $subtotalex + $subtotalgr;
                    }
                    $cmds .= $comandosTM->padText($info->numz, 6, "BOTH");
                    $cmds .= $comandosTM->padText($info->dia, 7, "BOTH");
                    $cmds .= $comandosTM->padText(number_format($subtotalgr, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($subtotalex, 2, '.', ''), 8, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalNumeroZ, 2, '.', ''), 9, "LEFT");
                    $cmds .= comandosTM::LineFeed;

                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                    $totalglobal   = $totalgrglobal + $totalexglobal;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalgrglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalexglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "RESUMEN DE DOCUMENTOS";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Desde", 9, "BOTH");
                $cmds .= $comandosTM->padText("Hasta", 9, "BOTH");
                $cmds .= $comandosTM->padText("#", 9, "BOTH");
                $cmds .= $comandosTM->padText("Valor", 12, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                $numdocg = 0; $j=0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    $t = 0;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(3);
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                            $invexento = $ven->exento;
                            $productos = $this->ventas_model->getDataTran100kCorteZMensual($ven->trannum);
                            
                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            $numdoc++; $numdocg++; $numFinal = $ven->numero;
                            $t++;
                        }
                        $j++;
                    }
                    $cmds .= $comandosTM->padText($numInicial, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numFinal, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numdoc, 9, "BOTH");
                    $cmds .= $comandosTM->padText(number_format(round($subtotal, 2), 2, '.', ''), 12, "LEFT");
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal   = $totalglobal + $subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 9, "LEFT");
                $cmds .= $comandosTM->padText($j, 13, "BOTH");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 17, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'F.________________________________________';
                $cmds .= comandosTM::LineFeed;

                $cmds .= trim($this->session->userdata('userLog'));
                $cmds .= comandosTM::LineFeed;

                $cmds .= $date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;

                $cmds .= '_________________________________________';
                $cmds .= comandosTM::LineFeed;

                $cmds .= '_________________________________________';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'CZM'.$idanio. $idmes. $idcentro. $idcaja;
                //$printerName ="TMU950";
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        #############################################################################

        
        function printDevolucion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
               

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                //$cmds .= "0x1B"."i";

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FullCut950;

                //$printerName = explode(',', $printerName);
                //$printerName = $printerName[1];
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        
        function notaDeEntrega($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($departamentoMunicipio as $info_dm){
						$departamento = trim($info_dm->depto);
						$municipio = trim($info_dm->municipio);
					}
                    
	                $archivoTxt = fopen($info->descrip.$info->numero.".gox",'w+');
	                
	               $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");                    
	                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");                    
	                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");                    
	                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");                    
	                $contenidoHeader = '@ 0,0 SAY CHR(27)+"c0"+CHR(4)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                
	                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                $contenidoHeader = '@ Prow () , Pcol () SAY CHR(27)+"!"+CHR(1)';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n"); 
					
	                $contenidoHeader = '@ 07,59 Say "'.date_format(date_create($info->fecha), 'd/m/Y').'"';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                    
	                $contenidoHeader = '@ 09,16 Say "'.substr($info->nameCliente, 0, 35).'"';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
	                    
	                $contenidoHeader = '@ 10,16 Say "'.substr($info->direccion, 0, 60).'"';
	                fwrite($archivoTxt, $contenidoHeader);
	                fwrite($archivoTxt, "\r\n");
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $CooNum=13;
                
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = 0;
							$vnGravada = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = 0;
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = 0;
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = 0;
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 30);
						
                        $CooNum++;
                        $contenidoHeader = '@ '.$CooNum.',09 Say "'.abs($pro->cantidad).'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    
                        $contenidoHeader = '@ Prow(),15 Say "'.substr($pro->um, 0, 7).'-'.$nombrepro.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    
                        $contenidoHeader = '@ Prow(),53 Say "$'.number_format(round($preciouni, 2), 2 ,'.','').'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    
                        $contenidoHeader = '@ Prow(),68 Say "'.$vnExenta.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    
                        $contenidoHeader = '@ Prow(),75 Say "$'.$vnGravada.'"';
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
					}
					$numProd++;
                }
            	
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->valorEnLetras(trim($numero));
				$contenidoHeader = '@ 38,13 Say "'.strtoupper($TotalLetras).'/DOLARES"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
            
                $contenidoHeader = '@ 38,76 Say "'.number_format(round($total, 2), 2 ,'.','').'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 42,76 Say "'.number_format(round($total, 2), 2 ,'.','').'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 46,76 Say "'.number_format(round($total, 2), 2 ,'.','').'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");                
	            $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");                
	            $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");
	            $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");
	            $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");
                $contenidoHeader = '@ 55,76 Say " "';
	            fwrite($archivoTxt, $contenidoHeader);
	            fwrite($archivoTxt, "\r\n");
            
            	
                $docTxt = $info->descrip.$info->numero.".gox";
                if(file_exists($docTxt)){
	                header('Content-Description: File Transfer');
	                header('Content-Type: application/octet-stream');
	                header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
	                header('Expires: 0');
	                header('Cache-Control: must-revalidate');
	                header('Pragma: public');
	                header('Content-Length: ' . filesize($docTxt));
	                readfile($docTxt);                    
	                unlink($docTxt);
	                exit;
				}
        	}
        }      
   
        function comprobanteQuedanOld($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			$pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');
			
			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
            $empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
            $razonSocial =  $this->variable_model->getInfoVar('g_empdatos', 1);
            if($this->session->userdata('idcentrouser') == 4){
                $direccion_emp = "75 AV. NORTE, COL ESCALON RES.CLAUDIA , #2-B, SAN SALVADOR, SAN SALVADOR";  
                $NRC = "224547-7";
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11); 
            }else{
                $direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);  
                $NRC = $this->variable_model->getInfoVar('g_empdatos', 3);  
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);    
            }
			
			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;
			/*foreach($infoProductos as $infoProd){
				if(number_format($infoProd->tax1) == 0){
					$totExento = $totExento + ($infoProd->cantidad * $infoProd->preciotran);
                    $totExento = round($totExento,2);
                    
				}
				if(number_format($infoProd->tax1) != 0){
					$totGravado = $totGravado + (($infoProd->cantidad) * ($infoProd->preciotran  * (1 + ($infoProd->tax1 / 100))));
					$totsinIva = $totsinIva + ($infoProd->cantidad * $infoProd->preciotran);
                    $totsinIva = $totsinIva;
				}
			}
			
            $totIva = $totGravado - $totsinIva;
			$totSumas = $totsinIva + $totExento;
			$totSumas = $totSumas;
			
			
			
			
			$totalFinal = $totSumas + $totIva - $percepcion;*/
            $percepcion = 0; $permitePercepcion = 0;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){
                
            $totExento =0;
                $totGravado = $info->valcosto;
                $totsinIva = $info->valcosto;
                $totIva =  $info->valtax1;
                $totSumas = $totsinIva + $totExento;
                
                /*if($provee_tipo != 3 && $empper == 1){
                    $permiteRetencion = 1;
                    if($totsinIva >= 100){
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,2), 2 , '.', ',');
                    }
                }*/

                if($info->valtax5>0){
                    if($totsinIva >= 100){
                        $permiteRetencion = 1;
                        $permitePercepcion = 1;
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,4), 4 , '.', ',');
                    }
                }

                $totalFinal = $totGravado+$totIva+$percepcion;

                $forma_pago= $info->numx;
                
                $fecha_pago_ref= $info->referencia;
                
                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }
                
                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }
                
                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                    $fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }
                
                $estructura .= '<br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.$razonSocial.'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }
                $cadena_texto = "";
                if($forma_pago==11 || $forma_pago==15){
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong>.<br>';
                }else{
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.';
                }
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,2), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totsinIva,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totExento,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totIva,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($permitePercepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Percepcion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($percepcion,4), 4, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,4), 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
                
                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #6E6E6E;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
							
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";
                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,2), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totsinIva,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totExento,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totIva,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($permitePercepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Percepcion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($percepcion,4), 4, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,2), 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="3">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="3"><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
        }

        function comprobanteQuedan($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			$pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');
			
			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
            $empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);
            $razonSocial =  $this->variable_model->getInfoVar('g_empdatos', 1);
            if($this->session->userdata('idcentrouser') == 4){
                $direccion_emp = "75 AV. NORTE, COL ESCALON RES.CLAUDIA , #2-B, SAN SALVADOR, SAN SALVADOR";  
                $NRC = "224547-7";
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11); 
            }else{
                $direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);  
                $NRC = $this->variable_model->getInfoVar('g_empdatos', 3);  
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);    
            }
			
			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;

            $percepcion = 0; $permitePercepcion = 0;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){
                
                $totExento = 0;
                $totGravado = $info->valcosto;
                $totsinIva = $info->valcosto;
                $totIva =  $info->valtax1;
                $totSumas = $totsinIva + $totExento;
                
                /*if($provee_tipo != 3 && $empper == 1){
                    $permiteRetencion = 1;
                    if($totsinIva >= 100){
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,2), 2 , '.', ',');
                    }
                }*/

                if($info->valtax5>0){
                    if($totsinIva >= 100){
                        $permiteRetencion = 1;
                        $permitePercepcion = 1;
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,4), 4 , '.', ',');
                    }
                }

                $totalFinal = $totGravado+$totIva+$percepcion;

                if($info->exento == 1){
                    $totalFinal = $totGravado+$percepcion;
                    $totIva = 0;
                }

                $forma_pago= $info->numx;
                
                $fecha_pago_ref= $info->referencia;
                
                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }
                
                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }
                
                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                    //$fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                    $fecha_quedan = date_format(date_create($info->fecact),'d/m/Y');
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }
                
                $estructura .= '<br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:66.6%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:15px; text-align:left; font-weight: bold; color:#B03A2E;"><strong>'.$razonSocial.'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
                                <tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
                                <tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
                                <tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:left; font-weight: bold; width:95%; color:#000;">COMPROBANTE DE PAGO '.$trannum.'</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:15px; text-align:left; font-weight: bold; width:75%; color:#000;">QUEDAN '.$trannum.'</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
                                <tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
                                <tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }
                $cadena_texto = "";
                if($forma_pago==11 || $forma_pago==15){
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong>.<br>';
                    $cadena_texto2 = '';
                }else{
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su';
                    $cadena_texto2 = 'revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.';
                }
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:Center; color: #000; width:40%; font-weight: bold; border: 1px solid #6E6E6E;">Proveedor</td>
						<td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles de Entrega</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;" ><strong>'.substr($info->descrip, 0, 42).'</strong></td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;" ><strong>Tel: </strong> '.$info->telefono.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>NRC: </strong>'.$info->nrc.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>DUI: </strong>'.$info->dui.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>NIT: </strong> '.$info->nit.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">$'.number_format(round($totGravado+$percepcion,2), 2, '.', ',').'</td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:center; color: #000; width:61%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:59%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Total Exento:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totExento,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:56%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Total Gravado:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totsinIva,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:56%; border-right:1px solid #6E6E6E;">'.$cadena_texto2.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">IVA:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totIva,4), 4, '.', ',').'</td>
					</tr>';
				
				if($permitePercepcion != 0){
					$estructura .= '
						<tr>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Percepcion 1%</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($percepcion,4), 4, '.', ',').'</td>
						</tr>';
				}
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
                        <td style="font-size:1px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:35%; border:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
                        <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
                        <td style="font-size:1px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:12%; border:1px solid #6E6E6E;"><strong>Total a Pagar</strong></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totalFinal,4), 2, '.', ',').'</td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:center; color: #000; width:61%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:61%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:4%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:35%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
                
                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #6E6E6E;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
                    <tr>
                        <td style="padding:0px;margin:0px;width:66.6%;" rowspan="2">
                            <table style="padding:0px;margin:0px;">
                                <tr style="padding:0px; margin:0px;">
                                    <td style="padding:0px; margin:0px; font-size:15px; text-align:left; font-weight: bold; color:#B03A2E;"><strong>'.$razonSocial.'</strong></td>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
                                </tr>
                                <tr style="padding:0px; margin:0px;">
                                    <td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
                                </tr>
                                <tr style="margin:0px;padding:-5px;">
                                    <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                </tr>
                                <tr style="margin:0px;padding:-5px;">
                                    <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                </tr>
                                <tr style="margin:0px;padding:-5px;">
                                    <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                </tr>
                            </table>
                        </td>
                        <td style="padding:0px;margin:0px;width:33.3%;">
                            <table style="padding:0px;margin:0px;">';
                
                            if($forma_pago==11 || $forma_pago==15){
                                $estructura .= '<tr style="margin:0px;padding:0px;">
                                                <td style="font-size:10px; text-align:center;width:5%;"></td>
                                                <td style="font-size:15px; text-align:left; font-weight: bold; width:95%; color:#000;">COMPROBANTE DE PAGO '.$trannum.'</td>
                                            </tr>';
                                $frase_quedan = "";

                            }else{
                                $estructura .= '<tr style="margin:0px;padding:0px;">
                                                <td style="font-size:10px; text-align:center;width:25%;"></td>
                                                <td style="font-size:15px; text-align:left; font-weight: bold; width:75%; color:#000;">QUEDAN '.$trannum.'</td>
                                            </tr>';
                                $frase_quedan = "Quedan en nuestro poder:";
                            }
                            $estructura .= '
                                    <tr style="margin:0px;padding:-5px;">
                                        <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                    </tr>
                                    <tr style="margin:0px;padding:-5px;">
                                        <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                    </tr>
                                    <tr style="margin:0px;padding:-5px;">
                                        <td style="margin:0px;padding:0px;font-size:15px;width:100%;"></td>
                                    </tr>
                            </table>
                        </td>
                    </tr>
            </table>';
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
                        <td style="font-size:12px; text-align:Center; color: #000; width:40%; font-weight: bold; border: 1px solid #6E6E6E;">Proveedor</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles de Entrega</td>
                    </tr>
                    <tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;" ><strong>'.substr($info->descrip, 0, 42).'</strong></td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
                    </tr>
                    <tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;" ><strong>Tel: </strong> '.$info->telefono.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
                    </tr>
                    <tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>NRC: </strong>'.$info->nrc.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
                    </tr>
                    <tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>DUI: </strong>'.$info->dui.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
                    </tr>
                    <tr>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:40%;"><strong>NIT: </strong> '.$info->nit.'</td>
                        <td style="font-size:12px; text-align:Center; width:25%;"></td>
                        <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:10px; width:12%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
                        <td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:23%; border: 1px solid #6E6E6E;">$'.number_format(round($totGravado+$percepcion,2), 2, '.', ',').'</td>
                    </tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:center; color: #000; width:61%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:59%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Total Exento:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totExento,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:56%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Total Gravado:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totsinIva,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:56%; border-right:1px solid #6E6E6E;">'.$cadena_texto2.'</td>
                        <td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">IVA:</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totIva,4), 4, '.', ',').'</td>
					</tr>';
				
				if($permitePercepcion != 0){
					$estructura .= '
						<tr>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:11px; width:12%; border:1px solid #6E6E6E;">Percepcion 1%</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($percepcion,4), 4, '.', ',').'</td>
						</tr>';
				}
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
                        <td style="font-size:1px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:35%; border:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
                        <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 1.5px; width:61%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
                        <td style="font-size:1px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:12%; border:1px solid #6E6E6E;"><strong>Total a Pagar</strong></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:23%; border:1px solid #6E6E6E;">$'.number_format(round($totalFinal,4), 2, '.', ',').'</td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:center; color: #000; width:61%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:4%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; color: #000; width:35%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:61%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:4%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:35%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
        }
        
        function comprobanteQuedanAnteriorSinModificacion($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			$pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');
			
			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
			$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);  
            if($this->session->userdata('idcentrouser') == 4){
                $direccion_emp = "75 AV. NORTE, COL ESCALON RES.CLAUDIA , #2-B, SAN SALVADOR, SAN SALVADOR";  
                $NRC = "224547-7";
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11); 
            }else{
                $direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);  
                $NRC = $this->variable_model->getInfoVar('g_empdatos', 3);  
                $municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
                $telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
                $correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);    
            }
			
			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;
			/*foreach($infoProductos as $infoProd){
				if(number_format($infoProd->tax1) == 0){
					$totExento = $totExento + ($infoProd->cantidad * $infoProd->preciotran);
                    $totExento = round($totExento,2);
                    
				}
				if(number_format($infoProd->tax1) != 0){
					$totGravado = $totGravado + (($infoProd->cantidad) * ($infoProd->preciotran  * (1 + ($infoProd->tax1 / 100))));
					$totsinIva = $totsinIva + ($infoProd->cantidad * $infoProd->preciotran);
                    $totsinIva = $totsinIva;
				}
			}
			
            $totIva = $totGravado - $totsinIva;
			$totSumas = $totsinIva + $totExento;
			$totSumas = $totSumas;
			
			
			
			
			$totalFinal = $totSumas + $totIva - $percepcion;*/
            $percepcion = 0; $permitePercepcion = 0;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){
                
            $totExento =0;
                $totGravado = $info->valcosto;
                $totsinIva = $info->valcosto;
                $totIva =  $info->valtax1;
                $totSumas = $totsinIva + $totExento;
                
                if($provee_tipo != 3 && $empper == 1){
                    $permiteRetencion = 1;
                    if($totsinIva >= 100){
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,2), 2 , '.', ',');
                    }
                }

                $totalFinal = $totGravado+$totIva+$percepcion;

                $forma_pago= $info->numx;
                
                $fecha_pago_ref= $info->referencia;
                
                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }
                
                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }
                
                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                    $fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }
                
                $estructura .= '<br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }
                $cadena_texto = "";
                if($forma_pago==11 || $forma_pago==15){
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong>.<br>';
                }else{
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.';
                }
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,2), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,2), 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
                
                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #6E6E6E;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
							
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$NRC.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";
                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,2), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,2), 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#5ac8fa; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#5ac8fa; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="3">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="3"><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}
        
        function comprobanteQuedan4Decimals($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			$pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');
			
			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
			$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);  
			$direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);  
			$municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
			$telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
			$correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);  
			
			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;
			/*foreach($infoProductos as $infoProd){
				if(number_format($infoProd->tax1) == 0){
					$totExento = $totExento + ($infoProd->cantidad * $infoProd->preciotran);
                    $totExento = round($totExento,2);
                    
				}
				if(number_format($infoProd->tax1) != 0){
					$totGravado = $totGravado + (($infoProd->cantidad) * ($infoProd->preciotran  * (1 + ($infoProd->tax1 / 100))));
					$totsinIva = $totsinIva + ($infoProd->cantidad * $infoProd->preciotran);
                    $totsinIva = $totsinIva;
				}
			}
			
            $totIva = $totGravado - $totsinIva;
			$totSumas = $totsinIva + $totExento;
			$totSumas = $totSumas;
			
			
			
			
			$totalFinal = $totSumas + $totIva - $percepcion;*/
            $percepcion = 0; $permitePercepcion = 0;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){
                
            $totExento =0;
                $totGravado = $info->valcosto;
                $totsinIva = $info->valcosto;
                $totIva =  $info->valtax1;
                $totSumas = $totsinIva + $totExento;
                
                /* if($provee_tipo != 3 && $empper == 1){
                    $permiteRetencion = 1;
                    if($totsinIva >= 100){
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,4), 4 , '.', ',');
                    }
                } */

                if($info->valtax5>0){
                    if($totsinIva >= 100){
                        $permitePercepcion=1;
                        $percepcion = $info->valtax5;
                        $percepcion = number_format(round($percepcion,4), 4 , '.', ',');
                    }
                }

                $totalFinal = $totGravado+$totIva-$percepcion;

                $forma_pago= $info->numx;
                
                $fecha_pago_ref= $info->referencia;
                
                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }
                
                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }
                
                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                    $fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }
                
                $estructura .= '<br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }
                $cadena_texto = "";
                if($forma_pago==11 || $forma_pago==15){
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong>.<br>';
                }else{
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.';
                }
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($permitePercepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format(round($percepcion,4), 4, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
                
                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #6E6E6E;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
							
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";
                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #6E6E6E;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #6E6E6E;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #6E6E6E;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #6E6E6E;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #6E6E6E;">$'.number_format(round($totalFinal,4), 4, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:80%; font-weight: bold; border: 1px solid #6E6E6E;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:20%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #6E6E6E;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #6E6E6E;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 4, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>';
				
				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 4, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #6E6E6E;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #6E6E6E; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #6E6E6E; border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #6E6E6E;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format(round($totalFinal,4), 4, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #6E6E6E;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:38%; font-weight: bold; border: 1px solid #6E6E6E;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #6E6E6E;height:50px;" rowspan="3">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #6E6E6E;height:50px;" rowspan="3"><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}

        function compras_por_proveedor($tipo, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $this->load->model("producto_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $tipo_producto = $this->producto_model->getDescripTipo($tipo);
                
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombre_doc);
                $pdf->SetSubject($nombre_doc);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('variable_model');
                $center_name= "";
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$tipo_producto.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>';
                $titulo.='<thead>
                        <tr>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Proveedor</td>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:20%;">Transacción</td>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Número de Documento</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Lineas</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Unidades Compradas</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Costo</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Participación</td>
                        </tr></thead>
                        ';
                $this->load->model('invtran_model');
                
                $total_compras = 0;
                $total_und = 0;
                $total_costo = 0;
                $informacion = $this->invtran_model->getComprasProveedorDistinct($tipo, $fechaini, $fechafin);
                if($informacion!=false){
                    $sum_total = 0;
                    foreach($informacion as $inf){
                        $sum_total += $inf->costoTotal;
                    }
                    //departamento
                    foreach($informacion as $inf){
                        $sum_uni = 0;
                        if($inf->costoTotal>0){
                            $part = $inf->costoTotal / $sum_total;
                        }else{
                            $part = 0;
                        }
                        $subtitulo = "";
                        $informacion_provee = $this->invtran_model->getComprasProvee($inf->idproveedor, $tipo, $fechaini, $fechafin);
                        if($informacion_provee!=false){
                            $sum_total_provee = $inf->costoTotal;
                            foreach($informacion_provee as $inf_provee){
                                if($sum_total_provee>0){
                                    $part_pro = $inf_provee->costoTotal / $sum_total_provee;
                                }else{
                                    $part_pro = 0;
                                }
                                $subtitulo.='
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:15%;">'.$inf_provee->fecha.'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:20%;">'.$inf_provee->transaccion.'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:15%;">'.$inf_provee->serie.$inf_provee->numero.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.$inf_provee->cantidadTotal.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.number_format(round($inf_provee->unidadesTotal, 0),0).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">$'.number_format(round($inf_provee->costoTotal, 2),2).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">'.round((($part_pro)* 100),2).'% </td>
                                </tr>
                                ';
                                $sum_uni += round($inf_provee->unidadesTotal, 0);
                            }
                        }
                        
                        $titulo.='
                         <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-bottom: 1px solid #0B486B;">'.$inf->proveedor.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.$inf->cantidadTotal.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.number_format(round($inf->unidadesTotal, 0),0).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">$'.number_format(round($inf->costoTotal, 2),2).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">'.round((($part)* 100),2).'% </td>
                        </tr>
                        ';
                        $total_compras +=$inf->cantidadTotal;
                        $total_und +=round($inf->unidadesTotal, 0);
                        $total_costo +=round($inf->costoTotal, 2);
                        $titulo.=$subtitulo;
                        
                    }
                }
                $titulo.='
                <tr>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                </tr>
                <tr>
                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-top: 1px solid #0B486B;">TOTALES:</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_compras, 0),0).'</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_und, 0),0).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;">$'.number_format(round($total_costo, 2),2).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;"></td>
                </tr>
                ';
                
                $titulo.='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Compras_Por_Linea.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function orden_printOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				
				$pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                
				$name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['creditdays'];
                $provee_tipo = $det['provee_tipo'];
                $val_pro = $det['val_pro'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
				switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                
                $exento = 0; $gravado = 0; $iva = 0; $sub_total = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
                    	if($key->tipotax==0){
							$subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo == 3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:15px; text-align:center;width:75%;">ORDEN DE COMPRA</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
				
                $estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#0bbede; width:60%; font-weight: bold; border: 1px solid #6E6E6E;">  Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#0bbede; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
				</table>';
				
                $estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;border-left: 1px solid #6E6E6E;"> '.$proveedor.'</td>
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:60%;border-left: 1px solid #6E6E6E;"> '.$direccion.'</td>  
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
						<td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:60%;border-left: 1px solid #6E6E6E;"> '.$muni_dep.'</td>
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
						<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
					</tr>';
                
				if($caj_clase == 12){
					$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%;border-left: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:15%;border-left: 1px solid #6E6E6E;"> TEL: '.$tel_pro.'</td>
							<td style="font-size:12px; text-align:left; width:25%;"> NIT: '.$nit_pro.'</td>
							<td style="font-size:12px; text-align:left; width:20%;"> NRC: '.$nrc_pro.'</td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>
					</table>';
				}else{
					$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:15%;border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"> TEL: '.$tel_pro.'</td>
							<td style="font-size:12px; text-align:left; width:25%;border-bottom: 1px solid #6E6E6E;"> NIT: '.$nit_pro.'</td>
							<td style="font-size:12px; text-align:left; width:20%;border-bottom: 1px solid #6E6E6E;"> NRC: '.$nrc_pro.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>
					</table>';
				}
				
				$estructura .= '<br><br>
				<table style="width:100%;" class="fondo">
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#0bbede; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
						<td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
						<td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
						<td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
						<td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
						<td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#0bbede; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
					</tr>
					<tr>
						<td style="font-size:10px; text-align:center; width:5%; font-weight: bold; border-left: 1px solid #6E6E6E;">Item</td>
						<td style="font-size:10px; text-align:center; width:5%; font-weight: bold;">Cant.</td>
						<td style="font-size:10px; text-align:center; width:5%; font-weight: bold;">Cod.</td>
						<td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
						<td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
						<td style="font-size:10px; text-align:left; width:25%; font-weight: bold;">Notas</td>
						<td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
						<td style="font-size:10px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
					</tr>';
				
				if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
						$estructura .= '
						<tr>
							<td style="font-size:10px; text-align:center; width:5%; border-left: 1px solid #6E6E6E;">'.round($key->itemline).'</td>
							<td style="font-size:10px; text-align:center; width:5%; ">'.round($key->cantidad).'</td>
							<td style="font-size:10px; text-align:center; width:5%;">'.$key->idproducto.'</td>
							<td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
							<td style="font-size:9px; text-align:center; width:10%;">'.$key->um_orden.'</td>
							<td style="font-size:10px; text-align:left; width:25%;">'.$key->notas.'</td>
							<td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
							<td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
						</tr>';
					}
				}
				
                $estructura .= '
				<tr>
					<td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:9px; text-align:left; width:70%;"></td>
					<td style="font-size:12px; text-align:center; width:10%;"></td>
					<td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
				</tr>';
                
				if($provee_tipo == 3){
					if($gravado > 100){
						$percepcion = number_format($gravado, 2, '.', '') * 0.01;
						$sub_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
						
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Percepción 1%</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($percepcion, 2, '.', '').'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;border-bottom: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;border-bottom: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}
				}else{
					$estructura .= '
					<tr>
						<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"></td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;border-bottom: 1px solid #6E6E6E;">Total</td>
						<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
					</tr>';
				}
				
                $estructura .= '
                    <tr>
				        <td style="width:100%;"></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#0bbede; width:70%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Observaciones</td>
						<td style="font-size:12px; text-align:left; width:5%; font-weight: bold; "></td>
						<td style="font-size:12px; text-align:left; background-color:#0bbede; width:25%; font-weight: bold; border: 1px solid #6E6E6E;"></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:70%; border: 1px solid #6E6E6E;" colspan="2" rowspan="5">'.$notas_orden.'</td>
						<td style="font-size:12px; text-align:left; width:5%;"></td>
						<td style="font-size:10px; text-align:left; width:25%; border-right: 1px solid #6E6E6E; border-left: 1px solid #6E6E6E;" rowspan="4"></td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
						<td style="font-size:10px;width:25%; border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E; border-left: 1px solid #6E6E6E;">Autorizado por</td>
					</tr>
				</table><br><br><br>';
				
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }

        function orden_printOld2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 20);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(100);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				
				$pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                
				$name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['creditdays'];
                $provee_tipo = $det['provee_tipo'];
                $val_pro = $det['val_pro'];
                $documentoExento = $det['exento'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
				switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                //if($inv_notas!=""){
                   // $dev_place .= ",".$inv_notas;
                //}
                
                $exento = 0; $gravado = 0; $iva = 0; $sub_total = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
                    	if ( $key->tipotax==0 || $documentoExento == 1 ) {
							$subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo == 3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                        case 9:
                            $telephone = $emp->valor_memo;
                            break;
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:66.6%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:15px; text-align:left; font-weight: bold; color:#B03A2E;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.'  <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>TEL:</b>'.$telephone.'</td>
								</tr>
                                <tr>
									<td style="font-size:15px;"></td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; font-weight: bold;">PROVEEDOR</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> '.$det['idcps'].' '.$proveedor.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> '.$muni_dep.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> TEL: '.$tel_pro.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> NRC: '.$nrc_pro.'</td>
                                </tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
                                <tr>
                                    <td style="font-size:15px;"></td>
                                </tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:15px; text-align:center;width:75%; font-weight: bold; color:#2E86C1;">ORDEN DE COMPRA</td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Fecha.</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">N° de orden</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:55%;">'.$orden.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Forma de Pago</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$formaPago.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Total:</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">$'.number_format($val_pro, 2, '.', '').'</td>
                                </tr>
                                <tr>
									<td style="font-size:15px;"></td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; font-weight: bold;" colspan="4">Detalles de Entrega:</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.date_format(date_create($det["fecha_entrega2"]),"d/m/Y").'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:55%;" colspan="3">'.$dev_place.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Solicitado por:</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$cliente.'</td>
                                </tr>
							</table>
						</td>
                    </tr>
				</table>';
				
				$estructura .= '<br><br><br>
				<table style="width:100%;" class="fondo">
					<tr>
						<td style="font-size:12px; text-align:center; width:5%; font-weight: bold; border: 1px solid #000;">Item</td>
						<td style="font-size:12px; text-align:center; width:7%; font-weight: bold; border: 1px solid #000;">Código</td>
						<td style="font-size:12px; text-align:left; width:39%; font-weight: bold; border: 1px solid #000;">Descripción del Producto</td>
						<td style="font-size:12px; text-align:left; width:20%; font-weight: bold; border: 1px solid #000;">Notas</td>
						<td style="font-size:12px; text-align:center; width:9%; font-weight: bold; border: 1px solid #000;">Cantidad</td>
						<td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #000;">Precio</td>
						<td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #000;">Sub-total</td>
					</tr>';
				
				if(is_array($list_productos) and $list_productos!=false){
                    $aux = 0;
                    $maxLines = 38;
                    $newArray = array();
                    //for($i = 0; $i < 67; $i++){
                        //if(isset($list_productos[0])){
                            //array_push($newArray, $list_productos[0]);
                        //}
                    //}
                    //var_dump($newArray);
					foreach($list_productos as $key){
					//foreach($newArray as $key){
						$estructura .= '
						<tr>
							<td style="font-size:10px; text-align:center; width:5%; border-right: 1px solid #000; border-left: 1px solid #000;">'.round($key->itemline).'</td>
							<td style="font-size:10px; text-align:center; width:7%; border-right: 1px solid #000; border-left: 1px solid #000;">'.$key->idproducto.'</td>
							<td style="font-size:10px; text-align:left; width:39%; border-right: 1px solid #000; border-left: 1px solid #000;">'.$key->descrip.'</td>
							<td style="font-size:10px; text-align:left; width:20%; border-right: 1px solid #000; border-left: 1px solid #000;">'.$key->notas.'</td>
							<td style="font-size:10px; text-align:center; width:9%; border-right: 1px solid #000; border-left: 1px solid #000;">'.round($key->cantidad).'</td>
							<td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #000; border-left: 1px solid #000;">$'.number_format($key->precioneto, 4, '.', '').'</td>
							<td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #000;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
						</tr>';
                        if($aux == 55){
                            $estructura .= '
                            <tr>
                                <td style="font-size:10px; text-align:center; width:5%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">'.round($key->itemline).'</td>
                                <td style="font-size:10px; text-align:center; width:7%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">'.$key->idproducto.'</td>
                                <td style="font-size:10px; text-align:left; width:39%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">'.$key->descrip.'</td>
                                <td style="font-size:10px; text-align:left; width:20%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">'.$key->notas.'</td>
                                <td style="font-size:10px; text-align:center; width:9%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">'.round($key->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #000; border-left: 1px solid #000; border-bottom: 1px solid #000;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                <td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #000; border-bottom: 1px solid #000;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                            </tr>';

                            $estructura .= '
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:5%; font-weight: bold; border: 1px solid #000;">Item</td>
                                    <td style="font-size:12px; text-align:center; width:7%; font-weight: bold; border: 1px solid #000;">Código</td>
                                    <td style="font-size:12px; text-align:left; width:39%; font-weight: bold; border: 1px solid #000;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:20%; font-weight: bold; border: 1px solid #000;">Notas</td>
                                    <td style="font-size:12px; text-align:center; width:9%; font-weight: bold; border: 1px solid #000;">Cantidad</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #000;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #000;">Sub-total</td>
                                </tr>';
                            $aux = 0;
                            $maxLines = 55;
                        }
                        $aux++;
					}
				}

                $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%; border-top: 1px solid #000;"></td>
                    </tr>';
                
                for($i = $aux; $i < $maxLines; $i++){
                    $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%;"></td>
                    </tr>';
                }

                $estructura .= '</table>';
				
                $estructura .= '
				<table style="width:100%;">
				<tr>
					<td style="font-size:12px; text-align:left; font-weight: bold; text-decoration: underline; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;">Observaciones:</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total Exento: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 0, 54).'</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total Gravado: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 54, 54).'</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">IVA: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
				</tr>';
                
				if($provee_tipo == 3){
					if($gravado > 100){
						$percepcion = number_format($gravado, 2, '.', '') * 0.01;
						$sub_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
						
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Percepción 1% </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($percepcion, 2, '.', '').'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 162, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}
				}else{
					$estructura .= '
					<tr>
						<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
						<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
					</tr>';
				}
				
                $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%;"></td>
                    </tr>
                    <tr>
                        <td style="margin:0; padding:0; width: 100%; text-align: center; font-size: 11px;">*Para dudas en relación al pedido, contactarnos al 2260-3603<br>*Para agendar fecha de entrega, contactarnos al 2260-3980</td>
                    </tr>
                </table>';
                //$pdf->setHtmlFooter($footer);
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }
        
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 20);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(100);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				
				$pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                
				$name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['creditdays'];
                $provee_tipo = $det['provee_tipo'];
                $val_pro = $det['val_pro'];
                $documentoExento = $det['exento'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
				switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                //if($inv_notas!=""){
                   // $dev_place .= ",".$inv_notas;
                //}
                
                $exento = 0; $gravado = 0; $iva = 0; $sub_total = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
                    	if ( $key->tipotax==0 || $documentoExento == 1 ) {
							$subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo == 3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                        case 9:
                            $telephone = $emp->valor_memo;
                            break;
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:66.6%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:15px; text-align:left; font-weight: bold; color:#B03A2E;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.'  <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>TEL:</b>'.$telephone.'</td>
								</tr>
                                <tr>
									<td style="font-size:15px;"></td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; font-weight: bold;">PROVEEDOR</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> '.$det['idcps'].' '.$proveedor.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> '.$muni_dep.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> TEL: '.$tel_pro.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%;"> NRC: '.$nrc_pro.'</td>
                                </tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
                                <tr>
                                    <td style="font-size:15px;"></td>
                                </tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:15px; text-align:center;width:75%; font-weight: bold; color:#2E86C1;">ORDEN DE COMPRA</td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Fecha.</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">N° de orden</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:55%;">'.$orden.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Forma de Pago</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$formaPago.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:45%;">Total:</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">$'.number_format($val_pro, 2, '.', '').'</td>
                                </tr>
                                <tr>
									<td style="font-size:15px;"></td>
								</tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; font-weight: bold;" colspan="4">Detalles de Entrega:</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.date_format(date_create($det["fecha_entrega2"]),"d/m/Y").'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:55%;" colspan="3">'.$dev_place.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:45%; font-weight: bold;">Solicitado por:</td>
                                    <td style="font-size:12px; text-align:left; width:55%;">'.$cliente.'</td>
                                </tr>
							</table>
						</td>
                    </tr>
				</table>';
				
				$estructura .= '<br><br><br>
				<table style="width:100%;" class="fondo">
					<tr>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:center; width:5%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Item</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:center; width:7%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Código</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:left; width:39%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Descripción del Producto</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:left; width:20%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Notas</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:center; width:9%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Cantidad</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Precio</td>
						<td style="background-color: red; color:#fff; font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Sub-total</td>
					</tr>';
				
				if(is_array($list_productos) and $list_productos!=false){
                    $aux = 0;
                    $maxLines = 38;
                    $newArray = array();
                    //for($i = 0; $i < 67; $i++){
                        //if(isset($list_productos[0])){
                            //array_push($newArray, $list_productos[0]);
                        //}
                    //}
                    //var_dump($newArray);
					foreach($list_productos as $key){
					//foreach($newArray as $key){
						$estructura .= '
						<tr>
							<td style="font-size:10px; text-align:center; width:5%; border: 1px solid #CFCCCC; line-height: 5mm;">'.round($key->itemline).'</td>
							<td style="font-size:10px; text-align:center; width:7%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->idproducto.'</td>
							<td style="font-size:10px; text-align:left; width:39%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->descrip.'</td>
							<td style="font-size:10px; text-align:left; width:20%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->notas.'</td>
							<td style="font-size:10px; text-align:center; width:9%; border: 1px solid #CFCCCC; line-height: 5mm;">'.round($key->cantidad).'</td>
							<td style="font-size:10px; text-align:right; width:10%; border: 1px solid #CFCCCC; line-height: 5mm;">$'.number_format($key->precioneto, 4, '.', '').'</td>
							<td style="font-size:10px; text-align:right; width:10%; border: 1px solid #CFCCCC; line-height: 5mm;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
						</tr>';
                        if($aux == 55){
                            $estructura .= '
                            <tr>
                                <td style="font-size:10px; text-align:center; width:5%; border: 1px solid #CFCCCC; line-height: 5mm;">'.round($key->itemline).'</td>
                                <td style="font-size:10px; text-align:center; width:7%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->idproducto.'</td>
                                <td style="font-size:10px; text-align:left; width:39%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->descrip.'</td>
                                <td style="font-size:10px; text-align:left; width:20%; border: 1px solid #CFCCCC; line-height: 5mm;">'.$key->notas.'</td>
                                <td style="font-size:10px; text-align:center; width:9%; border: 1px solid #CFCCCC; line-height: 5mm;">'.round($key->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%; border: 1px solid #CFCCCC; line-height: 5mm;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                <td style="font-size:10px; text-align:right; width:10%; border: 1px solid #CFCCCC; line-height: 5mm;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                            </tr>';

                            $estructura .= '
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:5%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Item</td>
                                    <td style="font-size:12px; text-align:center; width:7%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Código</td>
                                    <td style="font-size:12px; text-align:left; width:39%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:20%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Notas</td>
                                    <td style="font-size:12px; text-align:center; width:9%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Cantidad</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border: 1px solid #CFCCCC; line-height: 5mm;">Sub-total</td>
                                </tr>';
                            $aux = 0;
                            $maxLines = 55;
                        }
                        $aux++;
					}
				}

                $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%; border-top: 1px solid #CFCCCC;"></td>
                    </tr>';
                
                for($i = $aux; $i < $maxLines; $i++){
                    $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%;"></td>
                    </tr>';
                }

                $estructura .= '</table>';
				
                $estructura .= '
				<table style="width:100%;">
				<tr>
					<td style="font-size:12px; text-align:left; font-weight: bold; text-decoration: underline; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;">Observaciones:</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total Exento: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 0, 54).'</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total Gravado: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 54, 54).'</td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">IVA: </td>
					<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
				</tr>';
                
				if($provee_tipo == 3){
					if($gravado > 100){
						$percepcion = number_format($gravado, 2, '.', '') * 0.01;
						$sub_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
						
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Percepción 1% </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($percepcion, 2, '.', '').'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 162, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
							<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
						</tr>';
					}
				}else{
					$estructura .= '
					<tr>
						<td style="font-size:12px; text-align:left; width:71%; border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">'.substr($notas_orden, 108, 54).'</td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:19%;">Total: </td>
						<td style="font-size:12px; text-align:right; width:10%; border: 1px solid #6E6E6E;">$'.number_format($val_pro, 2, '.', '').'</td>
					</tr>';
				}
				
                $estructura .= '<tr>
                        <td style="font-size:12px; text-align:center; width:100%;"></td>
                    </tr>
                    <tr>
                        <td style="margin:0; padding:0; width: 100%; text-align: center; font-size: 11px;">*Para dudas en relación al pedido, contactarnos al 2260-3603<br>*Para agendar fecha de entrega, contactarnos al 2260-3980</td>
                    </tr>
                </table>';
                //$pdf->setHtmlFooter($footer);
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }

        function lista_ordenes($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Listado de Ordenes de compra Recibidas');
                $pdf->SetSubject('Listado de Ordenes de compra Recibidas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $formas_pago = $this->compras_model->formasPago();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $idcentro = $this->session->userdata('idcentrouser');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $nombreSucursal = $this->sucursal_model->getNameCentro($idcentro);
                   
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:18px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">'.$nombreSucursal.'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br><label style="text-align:center; font-size:14px;">Periodo del: '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                    
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                $cant_formaspago = 0;
                foreach($formas_pago as $fp){
                    $cant_formaspago++;
                }
                $width = 18.5/$cant_formaspago;
                $estructura='<table>
                <thead>
                    <tr style="vertical-align:middle; background-color:#0bbede;">
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        $col_act = 0;
                        foreach($formas_pago as $fp){
                            $col_act++;
                            $estructura.='<th style="background-color:#0bbede;border-top: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        }
                        $estructura.='
                        </tr>
                
                    <tr style="vertical-align:middle; background-color:#0bbede;">
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Estado</th>
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° Recepción</th>
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° <br>Orden</th>
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Fecha de Recepción</th>
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° <br> Documento</th>
                        <th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Proveedor</th>';
                $col_act = 0;
                foreach($formas_pago as $fp){
                    $col_act++;
                    $estructura.='<th style="background-color:#0bbede;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.$fp->descrip.'</th>';
                }
                $estructura.='
                </tr>
                 <tr style="vertical-align:middle; background-color:#0bbede;">
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E;  width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        $col_act = 0;
                        foreach($formas_pago as $fp){
                            $col_act++;
                            $estructura.='<th style="background-color:#0bbede;border-bottom: 1px solid #6E6E6E;border-right: 1px solid #6E6E6E;border-left: 1px solid #6E6E6E; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        }
                        $estructura.='
                        </tr>
                </thead>
                <tbody>';
                
                $listOrdenes = $this->compras_model->getListaRecepcionesIngresadasFechas($idcentro, $fechaini, $fechafin);
                $suma=0;
                
                
                $tot_gravadas=0;
                $tot_exentas=0;
                $tot_iva=0;
                $tot_retencion=0;
            
                $array_gravadas = [];
                $array_exentas = [];
                $array_iva = [];
                $array_retencion = [];
                $cont_array=0;
                $array_cant =[];
                foreach($formas_pago as $fp){
                    $array_gravadas[$cont_array] = 0;
                    $array_exentas[$cont_array] = 0;
                    $array_iva[$cont_array] = 0;
                    $array_retencion[$cont_array] = 0;    
                    $array_cant[$cont_array] = 0;
                    $cont_array++;
                }
                     
                    
                
                foreach($listOrdenes as $info){
                    $valorcosto = $info->valcosto + $info->valtax1 + $info->valtax5;
                    $recibidos = $this->compras_model->getDetalleProductosRecibidos($info->trannum);
                    
                    $cont_array=0;
                    foreach($formas_pago as $fp){
                        if($info->cajclase == $fp->cajclase){
                            if(round($info->valtax1,2)==0){
                                $array_exentas[$cont_array]+= $info->valcosto;
                            }else{
                                $array_gravadas[$cont_array] += $info->valcosto;
                                $array_iva[$cont_array] += $info->valtax1;
                            }
                            $array_retencion[$cont_array]+=$info->valtax5;
                            $array_cant[$cont_array]++;
                         }
                        $cont_array++;
                    }
                    
                    if(round($info->valtax1,2)==0){
                        $tot_exentas+= $info->valcosto;
                    }else{
                        $tot_gravadas += $info->valcosto;
                        $tot_iva += $info->valtax1;
                    }
                    $tot_retencion+=$info->valtax5;
                    
                    $k=0;
                    $unidades = 0;
                    foreach($recibidos as $rec){
                        $unidades = $unidades + $rec->cantidad;
                        $k++;
                    }
                    $esta = "";
                    if($info->estado_recepcion==1){
                        $esta = "Cerrado";
                    }else{
                        $esta = "En Proceso";
                    }
                    $suma += round($valorcosto,2);
                    $estructura.='<tr style="vertical-align:middle; border: 1px solid #6E6E6E;">
                        <td style="border: 0.5px solid #6E6E6E; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$esta.'</td>
                        <td style="border: 0.5px solid #6E6E6E; padding:5px; width:7%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->trannum.'</td>
                        <td style="border: 0.5px solid #6E6E6E; padding:5px; width:6%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->ordtrannum.'</td>
                        <td style="border: 0.5px solid #6E6E6E; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->fecact.'</td>
                        <td style="border: 0.5px solid #6E6E6E; padding:5px; width:15%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->serie.$info->numero.'</td>
                        <td style="border-top: 0.5px solid #6E6E6E; border-bottom: 0.5px solid #6E6E6E; padding:5px; width:0.5%; text-align:center; vertical-align:middle; font-size:10px;"></td>
                        <td style="border-top: 0.5px solid #6E6E6E; border-bottom: 0.5px solid #6E6E6E; padding:5px; width:33%; text-align:left; vertical-align:middle; font-size:10px;">'.$info->proveedor.'</td>';
                    $col_act = 0;
                    foreach($formas_pago as $fp){
                        $col_act++;
                        if($info->cajclase == $fp->cajclase){
                            $estructura.=' <td style="border: 0.5px solid #6E6E6E;padding:5px; width:'.$width.'%; text-align:right; vertical-align:middle; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($valorcosto,2),2).'&nbsp;</td>';
                        }else{
                            $estructura.=' <td style="border: 0.5px solid #6E6E6E;padding:5px; width:'.$width.'%; text-align:right; vertical-align:middle; font-size:10px;"></td>';
                        }
                    }
                    
                    $estructura.='</tr>';
                }
                $estructura.='</tbody></table>';
                $estructura.='<table><tr><td><br><br><br></td></tr>
                        <tr>
                            <td style="width:50%;"></td>
                            <td style="background-color:#0bbede;width:20%;border: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">Resumen</td>';
                
                $width_totals =20/$cant_formaspago;
                foreach($formas_pago as $fp){
                    $estructura.='<td style="background-color:#0bbede;width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">'.$fp->descrip.'</td>';
                }
                        
                        
                $estructura.='<td style="background-color:#0bbede;width:10%;border: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">Totales</td>

                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Compras Gravadas </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_gravadas[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($array_gravadas[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Compras Exentas </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_exentas[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($array_exentas[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> IVA </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_iva[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($array_iva[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Retención -1% </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_retencion[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($array_retencion[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Total Compras </td>';
                $inc_array =0;
                foreach($formas_pago as $fp){
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format( (round($array_gravadas[$inc_array],2) + round($array_exentas[$inc_array],2) + round($array_iva[$inc_array],2) + round($array_retencion[$inc_array],2))  ,2).'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$this->session->userdata("simboloMoneda").number_format(round($tot_gravadas+$tot_exentas+$tot_iva+$tot_retencion,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #6E6E6E; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Número de Compras </td>';
                $inc_array =0;
                $sum_compras = 0;
                foreach($formas_pago as $fp){
                    $sum_compras +=$array_cant[$inc_array];
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$array_cant[$inc_array].'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #6E6E6E; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$sum_compras.'</td>
                </tr>
                </table>';
                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                     
                $nombre_archivo = utf8_decode("Listado_Ordenes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function report_envios_consolidado($idcentro,$fechaini, $fechafin){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','3200M');
            ini_set('max_allowed_packet', '3200M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Consolidado de Envios") // Titulo
                ->setSubject("Consolidado de Envios") //Asunto
                ->setDescription("Consolidado de Envios") //Descripción
                ->setKeywords("Consolidado de Envios") //Etiquetas
                ->setCategory("Consolidado de Envios"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            $this->load->model('global_model');
            $funcion = $this->uri->segment(3);
            $this->load->model('invtran_model');
            $this->load->model('global_model');
            $this->load->model('variable_model');
            $this->load->model('sucursal_model');
            $nombreSucursal = $this->sucursal_model->getNameCentro($idcentro);
            $centros = $this->invtran_model->getCentrosEnviados($idcentro,$fechaini,$fechafin);
            
            $style_titulo = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                ),
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'size'  => 13,
                    'name'  => 'Verdana'
                )
            );
            $style_headers = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                ),
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'A8A39D'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                )
            );
            $style_totals = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                ),
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'size'  => 12,
                    'name'  => 'Verdana'
                )
            );
            $style_caja = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                ),
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '766f6e'),
                    'size'  => 13,
                    'name'  => 'Verdana'
                )
            );
            $style_caja2 = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                ),
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '766f6e'),
                    'size'  => 13,
                    'name'  => 'Verdana'
                )
            );
            $indiceNumero=1;
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, $this->session->userdata('descrip'));
            $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero,$this->session->userdata('descrip'))->applyFromArray($style_titulo);
            $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':I'.$indiceNumero); 
            
            $indiceNumero++;
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, $nombreSucursal);
            $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero,$nombreSucursal)->applyFromArray($style_titulo);
            $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':I'.$indiceNumero); 
            $indiceNumero++;
            
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, " Período  ".date_format(date_create($fechaini),'d/m/Y')." - ".date_format(date_create($fechafin),'d/m/Y'));
            $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero," Período  ".date_format(date_create($fechaini),'d/m/Y')." - ".date_format(date_create($fechafin),'d/m/Y'))->applyFromArray($style_titulo);
            $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':I'.$indiceNumero); 
            $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
            $indiceNumero++;
            $sum_unidades_tot = 0;
            $sum_costo_tot = 0;
            $sum_envios_tot = 0;
            if($centros!=false){
                $info = $this->invtran_model->getProductosEnviados2($idcentro,$fechaini,$fechafin);
                foreach($centros as $center){
                    $indiceNumero++;
                    $indiceNumero++;
                    $indiceLetra = 1;
                    $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, $center->descrip);
                    $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero,$center->descrip)->applyFromArray($style_caja);
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':I'.$indiceNumero); 
                    $indiceNumero++; $indiceNumero++;
                    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);

                    $sum_unidades = 0;
                    $sum_costo = 0;
                    $sum_envios = 0;
                    $indiceLetra = 1;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero  , 'Codigo');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero , 'Codigo')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero  , 'Modelo');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero , 'Modelo')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero  , 'Descripción');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero , 'Descripción')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero, 'Unidad de Medida');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, 'Unidad de Medida')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero,  'Unidades');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, 'Unidades')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero,  'Costo Unitario');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,'Costo Unitario')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero,  'Costo Total');
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,'Costo Total')->applyFromArray($style_headers);
                    $indiceLetra++;
                    $indiceNumero++;


                    $encontro =false;
                    foreach($info as $data){
                        if($center->idcentrod == $data->idcentrod){
                            $sum_unidades += $data->unidades;
                            $sum_costo += $data->costototal;
                            $sum_envios += $data->num_envios;
                            $indiceLetra =1;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $data->idproducto);
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, trim($data->modelo));
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, trim($data->descrip));
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $data->um);
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, number_format($data->unidades, 2, '.', ','));
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, number_format($data->costounitario, 2, '.', ','));
                            $indiceLetra++;
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, number_format($data->costototal, 2, '.', ','));
                            $indiceLetra++;
                            $encontro = true;
                            $indiceNumero++;
                        }else{
                            if($encontro==true){
                                break;
                            }
                        }
                    } 
                    $sum_unidades_tot += $sum_unidades;
                    $sum_costo_tot += $sum_costo;
                    $sum_envios_tot += $sum_envios;
                    $indiceLetra = 1;
                    
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero, 'SUB-TOTAL '.$center->descrip);
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,'SUB-TOTAL '.$center->descrip)->applyFromArray($style_caja2);
                    $objPHPExcel->getActiveSheet()->mergeCells($celdas[$indiceLetra].$indiceNumero.':E'.$indiceNumero); 
                    $indiceLetra = 5;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero,  number_format($sum_unidades, 2, '.', ','));
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, number_format($sum_unidades, 2, '.', ','))->applyFromArray($style_caja2);
                    $indiceLetra = 7;
                    $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero, "$".number_format($sum_costo, 2, '.', ','));
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, "$".number_format($sum_costo, 2, '.', ','))->applyFromArray($style_caja2);
                }
            }
            
            $indiceNumero++;
            $indiceNumero++;
            $indiceLetra = 1;
            $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero, 'TOTAL');
            $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,'TOTAL')->applyFromArray($style_totals);
            $objPHPExcel->getActiveSheet()->mergeCells($celdas[$indiceLetra].$indiceNumero.':E'.$indiceNumero); 
            $indiceLetra = 5;
            $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero,  number_format($sum_unidades_tot, 2, '.', ','));
            $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, number_format($sum_unidades_tot, 2, '.', ','))->applyFromArray($style_totals);
            $indiceLetra = 7;
            $objPHPExcel->getActiveSheet()->setCellValue($celdas[$indiceLetra].$indiceNumero, "$".number_format($sum_costo_tot, 2, '.', ','));
            $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero, "$".number_format($sum_costo_tot, 2, '.', ','))->applyFromArray($style_totals);
                
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="ConsolidadoTraslados.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
                
		function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 55, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('variable_model');
                $name = $this->variable_model->getIconCuenta();

                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                   $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#0bbede; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#0bbede; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#0bbede;">
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:35%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:15%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                
              
                
                
                 $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>RECIBIDA</strong></label></td>
                                    </tr>
                                </table></center><br><br>';
                
                foreach($informacion as $inf){
                
                $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#0bbede; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$idrec.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#0bbede; font-size:12px; text-align:right;" width="50%"><strong>Fecha Ingreso: '.date_format(date_create($inf->fecha), 'd/m/Y').' </strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Referencia Interna:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->descrip.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->referencia.'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Numero de Documento:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Solicitado Por:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->serie.''.$inf->numero.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->solicita.'</td>
                                    </tr>
                                    
                                </tbody>
                    </table><br><br>
                     ';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#0bbede;">
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#0bbede; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round(abs($pro->cantidad), 4), 2 ,'.','').'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->preciotran.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">$'.($pro->cantidad * $pro->preciotran ).'</td></tr>';
                           
                    
                }
                
                 $titulo.='
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function recuperacion_diaria($idcentro, $fechaini,$fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Recuperación Diaria');
                $pdf->SetSubject('Recuperación Diaria');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                $this->load->model('arap_model');   
                $funcion = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $pagos = $this->arap_model->getPagosRecuperacion($idcentro, $fechaini,$fechafin);
                $formaspagos = $this->arap_model->getFormasPagosRecuperacion($idcentro, $fechaini,$fechafin);
                $fecha = new DateTime();

                $estructura="";
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'<br>'.$nombreFormato.'<br>Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').' </label></center>';
               $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $estructura .='<table style="width:100%;"><thead style="border: 1px solid black;">
                <tr>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:8%;">Fecha</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:35%;">Cliente</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:10%;">Doc</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:12%;">Referencia</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:20%;">Descripción</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:7.5%;">Abonos</th>
                    <th style="border-top:1px solid gray;border-bottom:1px solid gray;font-weight:bold;background-color:#1248a1; color:white;font-size:12px; text-align:center;width:7.5%;">Cargos</th>
                </tr>
                </thead><tbody>';
                
                $array_totalizador = array();
                $count_totalizador = 0;
                foreach($formaspagos as $forms){
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:12px; text-align:left;width:100%;border-bottom:1px solid black;">'.strtoupper($forms->descrip).'</td>
                    </tr>';
                    $sum_abonos = 0;
                    $sum_cargos = 0;
                    foreach($pagos as $detalle){
                        if($forms->cajclase==$detalle->cajclase){
                            $cargo = 0;
                            $abono = 0;
                            if($detalle->valor<0){
                                $abono = abs($detalle->valor); 
                            }else{
                                $cargo = abs($detalle->valor); 
                            }
                            $sum_abonos += $abono;
                            $sum_cargos += $cargo;
                            $estructura .='
                            <tr>
                                <td style="font-weight:normal;font-size:9px; text-align:center;width:8%;">'.date_format(date_create($detalle->fecha), 'd/m/Y').'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:35%;">'.$detalle->cliente.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:10%;">'.$detalle->serie.$detalle->numero.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:12%;">'.$detalle->referencia.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:left;width:20%;">'.$detalle->banco.'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:right;width:7.5%;">'.number_format(round($abono, 2), 2 ,'.',',').'</td>
                                <td style="font-weight:normal;font-size:9px; text-align:right;width:7.5%;">'.number_format(round($cargo, 2), 2 ,'.',',').'</td>
                            </tr>';
                        }
                    }
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:85%;">Subtotal</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:7.5%;">'.number_format(round($sum_abonos, 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:7.5%;">'.number_format(round($sum_cargos, 2), 2 ,'.',',').'</td>
                    </tr>';
                    
                    $array_totalizador[$count_totalizador] = array(
                        "descrip" =>  strtoupper($forms->descrip),
                        "abonos" =>  $sum_abonos,
                        "cargos" =>  $sum_cargos,
                    );
                    $count_totalizador++;
                }
                $estructura .='
                    <tr><td><br><br></td></tr>
                    <tr>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:80%;"></td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:10%;border-bottom:1px solid black;">Abonos</td>
                    <td style="font-weight:bold;font-size:10px; text-align:right;width:10%;border-bottom:1px solid black;">Cargos</td>
                    </tr>';
                $grandtotal_abono = 0;
                $grandtotal_cargos = 0;
                for($i = 0; $i<$count_totalizador;$i++){
                    $dat = $array_totalizador[$i];
                    $estructura .='
                    <tr>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:80%;">'.$dat['descrip'].'</td>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:10%;">'.number_format(round($dat['abonos'], 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:10%;">'.number_format(round($dat['cargos'], 2), 2 ,'.',',').'</td>
                    </tr>'; 
                    $grandtotal_abono+=$dat['abonos'];
                    $grandtotal_cargos+=$dat['cargos'];
                }
                
                $estructura .='
                <tr>
                    <td style="font-weight:bold;font-size:11px; text-align:right;width:80%;"></td>
                    <td style="font-weight:bold;font-size:12px; text-align:right;width:10%;border-top:1px solid black;">'.number_format(round($grandtotal_abono, 2), 2 ,'.',',').'</td>
                    <td style="font-weight:bold;font-size:12px; text-align:right;width:10%;border-top:1px solid black;">'.number_format(round($grandtotal_cargos, 2), 2 ,'.',',').'</td>
                </tr>'; 
                
                $estructura.='</tbody></table>';
                $pdf->writeHTML($estructura, true, false, true, false, '');
				$nombre_archivo = utf8_decode("RecuperacionDiaria.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                        <thead>
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:right;">Disponible</th>
                            </tr></thead>';
                //$grupos = $this->arap_model->grupos_report();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $sum_subtotal=0;
                $sub_cadena = "";
                $info = $this->arap_model->clientes_report();
                
                $vendedor_actual = 0;
                foreach($info as $i){
                    if($vendedor_actual!=$i->idworker){
                        $sum_vendedor = $subtot_dias1+ $subtot_dias2+ $subtot_dias3+ $subtot_dias4+ $subtot_dias5;
                        $sub_cadena .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_vendedor, 2),2).'</th></tr>';
                        $sum_tot_dias1+= $subtot_dias1;
                        $sum_tot_dias2+= $subtot_dias2;
                        $sum_tot_dias3+= $subtot_dias3;
                        $sum_tot_dias4+= $subtot_dias4;
                        $sum_tot_dias5+= $subtot_dias5;
                        if(round($sum_vendedor,2)>0){
                            $titulo.=$sub_cadena;
                        }
                        $subtot_dias1=0;
                        $subtot_dias2=0;
                        $subtot_dias3=0;
                        $subtot_dias4=0;
                        $subtot_dias5=0;
                        $sub_cadena = '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($i->vendedor).'<br></th></tr>';
                        $sum_cliente=0;
                        $sum_vendedor = 0;
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_120+ $sum_121;
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $dispo = $i->limite-$sum_cliente;
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        $subtot_dias1+= $sum_1_30;
                        $subtot_dias2+= $sum_31_60;
                        $subtot_dias3+= $sum_61_90;
                        $subtot_dias4+= $sum_91_120;
                        $subtot_dias5+= $sum_121; 
                        $vendedor_actual = $i->idworker;
                    }else{
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_120+ $sum_121;
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            $dispo = $i->limite-$sum_cliente;
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        $subtot_dias1+= $sum_1_30;
                        $subtot_dias2+= $sum_31_60;
                        $subtot_dias3+= $sum_61_90;
                        $subtot_dias4+= $sum_91_120;
                        $subtot_dias5+= $sum_121; 
                        $vendedor_actual = $i->idworker;
                    }
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                if($gran_total==0){
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }else{
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_limit= 0;
                $dispo = 0;
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';
                   
                    
                    $titulo .= '<tr><th></th><th style="font-size:11px;width:20%;"></th><th  style="text-align:right;width:10%;color:gray;">1-30</th><th  style="text-align:right;width:10%;color:gray;">31-60</th><th  style="text-align:right;width:10%;color:gray;">61-90</th><th  style="text-align:right;width:10%;color:gray;">91-120</th><th  style="text-align:right;width:10%;color:gray;">121+</th></tr>';
                    $titulo .= '<tr><th></th><th style="font-size:11px; text-align:right;font-weight:bold;width:20%;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;width:10%;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $per1=0;
                $per2=0;
                $per3=0;
                $per4=0;
                $per5=0;
                if($gran_total>0){
                    $per1=$sum_tot_dias1/$gran_total;
                    $per2=$sum_tot_dias2/$gran_total;
                    $per3=$sum_tot_dias3/$gran_total;
                    $per4=$sum_tot_dias4/$gran_total;
                    $per5=$sum_tot_dias5/$gran_total;
                }
                
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th style="font-size:11px; text-align:right;font-weight:bold;width:20%;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;width:10%;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;width:10%;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;width:10%;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;width:10%;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; width:10%;text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;width:10%;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th style="font-size:11px; text-align:right;width:30%;"> </th><th  style="text-align:center; color: #031634;width:10%;">'.number_format(round((($per1)*100), 2),2).'%</th><th  style="text-align:center;color: #031634;width:10%;">'.number_format(round((($per2)*100), 2),2).'%</th><th  style="text-align:center;color: #031634;width:10%;">'.number_format(round((($per3)*100), 2),2).'%</th><th  style="text-align:center;color: #031634;width:10%;">'.number_format(round((($per4)*100), 2),2).'%</th><th  style="text-align:center;color: #031634;width:10%;">'.number_format(round((($per5)*100), 2),2).'%</th><th  style="text-align:center;color: #031634;width:10%;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(10, PDF_MARGIN_TOP, 15, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->ID.'</td>
                                <td style="width:90%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                            </tr>
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; font-weight:bold; text-align:center; font-size:10px;">Fecha de Emisión</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; font-weight:bold; text-align:center; font-size:10px;">Fecha de Vencimiento</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; font-weight:bold; text-align:center; font-size:10px;">Días de Mora</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:30%; font-weight:bold; text-align:left; font-size:10px;">Tipo de Documento</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; font-weight:bold; text-align:left; font-size:10px;">Referencia</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12.5%; font-weight:bold; text-align:right; font-size:10px;">Importe Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12.5%; font-weight:bold; text-align:right; font-size:10px;">Saldo Total</th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->fechavence.'</td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->dias.'</td>
                                <td style="width:30%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:15%; text-align:left;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:12.5%; text-align:right;font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($inf->saldoInicial,2).'</td>
                                <td style="width:12.5%; text-align:right;font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($inf->saldo,2).'</td>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th style="width:100%; text-align:right;font-size:11px; font-weight:bold;">'.$this->session->userdata("simboloMoneda").number_format($sum,2).'</th>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th style="width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="width:20%; text-align:right;font-size:11px; font-weight:bold;">'.$this->session->userdata("simboloMoneda").number_format($total_clientes,2).'</th>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function Estado_CuentaAnterior($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Estado de Cuenta');
                $pdf->SetSubject('Estado de Cuenta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 25, 5);
                $pdf->SetHeaderMargin(50);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $this->load->model('auxi_model');
                $this->load->model('arap_model');
                $nombreFormato = strtoupper($this->global_model->getFormatosNombre($funcion));
                $info_cliente = $this->auxi_model->getInfoAuxi($idauxi);

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'<br>'.$nombreFormato.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );
                
                $fecha = new DateTime();


                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $dias ="";
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $dias = $in->dias;
                    $limite = $in->limite;
                }
                $departamento="";
                $municipio="";
                $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idauxi);
                foreach($infoGzips as $infg){
                    $departamento = trim($infg->depto);
                    $municipio = trim($infg->municipio);
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                
				$estructura= '<table>';
				$estructura.='
                    <tr>
                        <th style="background-color:#2780e3; color:white;border:0.5px solid #111000;font-size:13px; font-weight:bold;width: 100%;text-align:left;">DATOS DEL CLIENTE</th>
                    </tr>
                    <tr>
                        <th style="border:0.5px solid #111000;font-size:13px;width: 100%;text-align:left;"><strong>Código:'.$idauxi.'<br>'.strtoupper($info_cliente['descrip']).'</strong><br>'. $info_cliente['direccion'].' '.$municipio.','.$departamento.'<br>Tel. '.$info_cliente['telefono'].'</th>
                    </tr>
                    <tr>
                        <th style="font-size:2px;"></th>
                    </tr>
                    <tr>
                        <th style="background-color:#2780e3; color:white;border-left:0.5px solid #111000;  border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Fecha de Emisión:</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Días de Crédito:</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Límite de Crédito:</th>
                        <th style="background-color:#2780e3; color:white; border-right:0.5px solid #111000;  border-left:0.5px solid #111000; font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Disponible:</th>
                    </tr>
                    <tr>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">  '.$fecha->format('d/m/Y').'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">'.$dias.'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">$'.$info_cliente['limite'].'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">$'.number_format($disponible,2).'</th>
                    </tr>';

				$estructura.="</table>";
                
                $facturas = $this->arap_model->getEstadoCuenta($idauxi);
                $cargos_abonos = $this->arap_model->getAbonosCargosCliente($idauxi);

                
                $estructura .= '<br><br><br><table>';
                $estructura .= '<thead><tr>
                        <th style="background-color:#2780e3; color:white;  border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 15%;text-align:center;">Documento N°</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Fecha de Emisión</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Días</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 45%;text-align:center;">Tipo de Documento</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Valor</th>
                        <th style="background-color:#2780e3; color:white;  border-left:0.5px solid #111000; font-size:12px; font-weight:bold;width: 10%;text-align:center;">Saldo</th>
                    </tr></thead><tbody>';
                $tot_dias1 = 0;
                $tot_dias2 = 0;
                $tot_dias3 = 0;
                $tot_dias4 = 0;
                $tot_dias5 = 0;
                if($facturas!=false){
                    foreach($facturas as $fact){
                        $saldo = $fact->saldo;
                        if($cargos_abonos!=false){
                            foreach($cargos_abonos as $ab){
                                if($fact->trannum== $ab->trannum){
                                    $saldo += $ab->valor;
                                }
                            }
                        }
                        $estructura .= '<tr>
                            <td style="font-size:12px;width: 15%;text-align:center;">'.$fact->serie.$fact->numero.'</td>
                            <td style="font-size:12px;width: 10%;text-align:center;">'.$fact->fecha.'</td>
                            <td style="font-size:12px;width: 10%;text-align:center;">'.$fact->dias.'</td>
                            <td style="font-size:12px;width: 45%;text-align:left;">'.$fact->tipoDoc.'</td>
                            <td style="font-size:12px;width: 10%;text-align:right;">$'.number_format($fact->saldo,2).'</td>
                            <td style="font-size:12px;width: 10%;text-align:right;">$'.number_format($saldo,2).'</td>
                        </tr>';
                        if($fact->dias >=0 && $fact->dias<=30){
                            $tot_dias1 += $saldo;
                        }else if($fact->dias >=31 && $fact->dias<=60){
                            $tot_dias2 += $saldo;
                        }else if($fact->dias >=61 && $fact->dias<=90){
                            $tot_dias3 += $saldo;
                        }else if($fact->dias >=91 && $fact->dias<=120){
                            $tot_dias4 += $saldo;
                        }else if($fact->dias >=121){
                            $tot_dias5 += $saldo;
                        }
                    }
                
                }
                $estructura .= '</tbody></table>';
                $subtotal = $tot_dias1+$tot_dias2+$tot_dias3+$tot_dias4+$tot_dias5;
                
                
                $percent1=0;
                $percent2=0;
                $percent3=0;
                $percent4=0;
                $percent5=0;
                if($sum!=0){
                    $percent1 = ($tot_dias1/$sum)*100;
                    $percent2 = ($tot_dias2/$sum)*100;
                    $percent3 = ($tot_dias3/$sum)*100;
                    $percent4 = ($tot_dias4/$sum)*100;
                    $percent5 = ($tot_dias5/$sum)*100;
                    
                }
                $estructura .= '<br><br><br>';
                $estructura .= '<table><tr>
                        <td style="background-color:#2780e3; color:white; border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:center;">1-30</td>
                        <td style="background-color:#2780e3; color:white; border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:center;">31-60</td>
                        <td style="background-color:#2780e3; color:white; border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:center;">61-90</td>
                        <td style="background-color:#2780e3; color:white; border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:center;">91-120</td>
                        <td style="background-color:#2780e3; color:white; border-left:0.5px solid #111000; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.6%;text-align:center;">121-Más</td>
                        <td style="background-color:#2780e3; color:white; border-left:0.5px solid #111000; border-right:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.516%;text-align:center;">Saldo Total</td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($tot_dias1,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($tot_dias2,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($tot_dias3,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($tot_dias4,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($tot_dias5,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.6%;text-align:right;">$'.number_format($subtotal,2).' </td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;">'.number_format($percent1, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;">'.number_format($percent2, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;">'.number_format($percent3, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;">'.number_format($percent4, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;">'.number_format($percent5, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.6%;text-align:center;"></td>
                    </tr>
                    <tr>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.6%;text-align:right;"></td>
                    </tr>
                    </table>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("EstadoCuenta".$idauxi.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }

        function Estado_Cuenta($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Estado de Cuenta');
                $pdf->SetSubject('Estado de Cuenta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 25, 5);
                $pdf->SetHeaderMargin(50);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $this->load->model('auxi_model');
                $this->load->model('arap_model');
                $nombreFormato = strtoupper($this->global_model->getFormatosNombre($funcion));
                $info_cliente = $this->auxi_model->getInfoAuxi($idauxi);

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'<br>'.$nombreFormato.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );
                
                $fecha = new DateTime();


                $info= $this->arap_model->getInfoCliente($idauxi);
                $sum_1_30 = 0;
                $sum_31_60 = 0;
                $sum_61_90 = 0;
                $sum_91_99 = 0;
                $dias ="";
                $limite ="";
                $disponible ="";
                foreach($info as $in){
                    if($in->dias>=0 && $in->dias<=30){
                        $sum_1_30+= $in->saldo;
                    }else if($in->dias >=31 && $in->dias<=60){
                        $sum_31_60+= $in->saldo;
                    }else if($in->dias >=61 && $in->dias<=90){
                        $sum_61_90+= $in->saldo;
                    }else if($in->dias >=91){
                        $sum_91_99+= $in->saldo;
                    }
                    $dias = $in->dias;
                    $limite = $in->limite;
                }
                $departamento="";
                $municipio="";
                $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idauxi);
                foreach($infoGzips as $infg){
                    $departamento = trim($infg->depto);
                    $municipio = trim($infg->municipio);
                }
                $sum = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_99;
				$disponible = $limite-$sum;
                
				$estructura= '<table>';
				$estructura.='
                    <tr>
                        <th style="background-color:#060c36; color:white;border:0.5px solid #111000;font-size:13px; font-weight:bold;width: 100%;text-align:left;">DATOS DEL CLIENTE</th>
                    </tr>
                    <tr>
                        <th style="border:0.5px solid #111000;font-size:13px;width: 100%;text-align:left;"><strong>Código:'.$idauxi.'<br>'.strtoupper($info_cliente['descrip']).'</strong><br>'. $info_cliente['direccion'].' '.$municipio.','.$departamento.'<br>Tel. '.$info_cliente['telefono'].'</th>
                    </tr>
                    <tr>
                        <th style="font-size:2px;"></th>
                    </tr>
                    <tr>
                        <th style="background-color:#060c36; color:white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Fecha de Emisión:</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Días de Crédito:</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Límite de Crédito:</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; font-size:12px; font-weight:bold;width: 25%;text-aling:right;">Disponible:</th>
                    </tr>
                    <tr>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">  '.$fecha->format('d/m/Y').'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">'.$dias.'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">$'.number_format($info_cliente['limite'],2).'</th>
                        <th style="border:0.5px solid #111000;font-size:12px; font-weight:bold;width: 25%;text-align:center;">$'.number_format($disponible,2).'</th>
                    </tr>';

				$estructura.="</table>";
                
                $facturas = $this->arap_model->getEstadoCuenta($idauxi);
                $cargos_abonos = $this->arap_model->getAbonosCargosCliente($idauxi);

                
                $estructura .= '<br><br><br><table>';
                $estructura .= '<thead><tr>
                        <th style="background-color:#060c36; color:white;  border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 15%;text-align:center;">Documento N°</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Fecha de Emisión</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Días</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 45%;text-align:center;">Tipo de Documento</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 10%;text-align:center;">Valor</th>
                        <th style="background-color:#060c36; color:white;  border-left:0.5px solid white; font-size:12px; font-weight:bold;width: 10%;text-align:center;">Saldo Acumulado</th>
                    </tr></thead><tbody>';
                $tot_dias1 = 0;
                $tot_dias2 = 0;
                $tot_dias3 = 0;
                $tot_dias4 = 0;
                $tot_dias5 = 0;
                $saldo_Acumulado = 0;
                if($facturas!=false){
                    foreach($facturas as $fact){
                        $saldo = $fact->saldoInicial;
                        if($cargos_abonos!=false){
                            foreach($cargos_abonos as $ab){
                                if($fact->trannum === $ab->trannum){
                                    $saldo += $ab->valor;
                                }
                            }
                        }
                        $saldo_Acumulado = $saldo_Acumulado+$saldo;
                        $estructura .= '<tr>
                            <td style="font-size:12px;width: 15%;text-align:center;">'.$fact->serie.$fact->numero.'</td>
                            <td style="font-size:12px;width: 10%;text-align:center;">'.$fact->fecha.'</td>
                            <td style="font-size:12px;width: 10%;text-align:center;">'.$fact->dias.'</td>
                            <td style="font-size:12px;width: 45%;text-align:left;">'.$fact->tipoDoc.'</td>
                            <td style="font-size:12px;width: 10%;text-align:right;">$'.number_format($saldo,2).'</td>
                            <td style="font-size:12px;width: 10%;text-align:right;">$'.number_format($saldo_Acumulado,2).'</td>
                        </tr>';
                        if($fact->dias >=0 && $fact->dias<=30){
                            $tot_dias1 += $saldo;
                        }else if($fact->dias >=31 && $fact->dias<=60){
                            $tot_dias2 += $saldo;
                        }else if($fact->dias >=61 && $fact->dias<=90){
                            $tot_dias3 += $saldo;
                        }else if($fact->dias >=91 && $fact->dias<=120){
                            $tot_dias4 += $saldo;
                        }else if($fact->dias >=121){
                            $tot_dias5 += $saldo;
                        }
                    }
                
                }
                $estructura .= '</tbody></table>';
                $subtotal = $tot_dias1+$tot_dias2+$tot_dias3+$tot_dias4+$tot_dias5;
                $estructura .= '<br><br><br>';
                $estructura .= '<table><tr>
                        <td style="background-color:#060c36; color:white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">1-30</td>
                        <td style="background-color:#060c36; color:white; border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">31-60</td>
                        <td style="background-color:#060c36; color:white; border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">61-90</td>
                        <td style="background-color:#060c36; color:white; border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">91-120</td>
                        <td style="background-color:#060c36; color:white; border-left:0.5px solid white; border-right:0.5px solid white;font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">121-Más</td>
                        <td style="background-color:#060c36; color:white; border-left:0.5px solid white; font-size:12px; font-weight:bold;width: 16.5%;text-align:center;">Saldo Total</td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($tot_dias1,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($tot_dias2,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($tot_dias3,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($tot_dias4,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($tot_dias5,2).' </td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px; font-weight:bold;width: 16.5%;text-align:right;">$'.number_format($subtotal,2).' </td>
                    </tr>
                    <tr>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;">'.number_format(($tot_dias1/$subtotal)*100, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;">'.number_format(($tot_dias2/$subtotal)*100, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;">'.number_format(($tot_dias3/$subtotal)*100, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;">'.number_format(($tot_dias4/$subtotal)*100, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;">'.number_format(($tot_dias5/$subtotal)*100, 2).'%</td>
                        <td style="border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:12px;width: 16.5%;text-align:center;"></td>
                    </tr>
                    <tr>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                        <td style="border-bottom:0.5px solid #111000;border-right:0.5px solid #111000;border-left:0.5px solid #111000;font-size:6px;width: 16.5%;text-align:right;"></td>
                    </tr>
                    </table>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("EstadoCuenta".$idauxi.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }

        function reporteLiquidacionComision($fechaini, $fechafin, $idcentro, $proveedores){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle("Reporte de Liquidación por Emprendedor");
                $pdf->SetSubject("Reporte de Liquidación por Emprendedor");
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 8, '', true);
                $arrayProveedores = explode('-', $proveedores);
                $idcentro = explode('-', $idcentro);
                $idcentro = implode(',', $idcentro);
                date_default_timezone_set('America/El_Salvador');
                $now = new DateTime();


                $inicioY = 32;
                $pdf->SetPrintHeader(true);
                $pdf->SetMargins(10, $inicioY, 10, true);

                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('variable_model');
                $name = $this->variable_model->getIconCuenta();

                $footer = '
                <table style="width:100%; padding-bottom: 5px; font-size: 11px;">

                    <tr style="width: 100%">
                        <td style="width: 50%; text-align: left"><strong>Fecha de Impresión</strong><br>'.date_format($now, 'd/m/Y h:i A').'</td>
                        <td style="width: 50%; text-align: right"><strong>Impreso por</strong><br>'.trim($this->session->userdata('userLog')).'</td>
                    </tr>
                </table>';
                $pdf->setHtmlFooter($footer);


                //Informacion de la venta por producto
                $information = $this->invtran_model->get_repedido_list($fechaini, $fechafin, $idcentro);
               
                foreach($arrayProveedores as $pro){
                    $lineas = 0;
                    $unidades = 0;
                    
                    //Obteniendo la info del proveedor
                    $infoPro = isset($this->cliente_model->callRegistro2Nahache($pro)[0]) ? $this->cliente_model->callRegistro2Nahache($pro)[0] : '';
                    //var_dump($infoPro);

                    if($infoPro != ''){

                        ////$this->highlight_array($infoPro);

                        //Se filtra el array de info de venta para obtener los productos de un proveedor especifico
                        //y cuya venta sea mayor a cero
                        $infoVentas = array_filter($information, function ($var)  use ($pro)  {
                            return ($var->idproveedor == $pro && abs($var->Total) > 0);
                        });
                        //var_dump($infoVentas);

                        $descrips = array_column($infoVentas, 'descrip');
                        array_multisort($descrips, SORT_ASC, $infoVentas);

                        //$this->highlight_array($infoVentas);

                        //Header con la info del proveedor
                        $nit = "";
                        if($infoPro->nit != ""){
                            $nit = '<strong>NIT: </strong>'.$infoPro->nit;
                        }

                        $nrc = "";
                        if($infoPro->nrc != ""){
                            $nrc = '<strong>NRC: </strong>'.$infoPro->nrc;
                        }
                        $header = '
                        <table style="width:100%; padding-bottom: 5px; font-size: 11px;">
                            <tr style=" width: 100%"><td></td></tr>

                            <tr style="width: 100%">
                                <td style="width: 52%">
                                    <table style="width:100%;">
                                        <tr><td style="width: 100%; text-align: left; font-size: 15px; font-weight: bold">'.$infoPro->descrip.'</td></tr>
                                        <tr><td style="width: 100%; text-align: left;">'.$infoPro->direccion.'</td></tr>
                                        <tr><td style="width: 100%; text-align: left;">'.$infoPro->giro.'</td></tr>
                                        <tr><td style="width: 100%; text-align: left;">'.$nit.' '.$nrc.'</td></tr>
                                    </table>    
                                </td>
                                <td style="width:24%; text-align: left;">
                                    <img style="width:195px; height:63px; text-align:left; float: left;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                </td>
                                <td style="width: 22%">
                                    <table style="width:100%;">
                                        <tr><td style="width: 100%; text-align: right;"><strong>Fecha de Liquidación</strong></td></tr>
                                        <tr><td style="width: 100%; text-align: right;">'.date_format($now, 'd/m/Y').'</td></tr>
                                        <tr><td style="width: 100%; text-align: right;"><strong>Periodo</strong></td></tr>
                                        <tr><td style="width: 100%; text-align: right;">'.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</td></tr>
                                    </table> 
                                </td>
                            </tr>
                        </table>';

                        $pdf->setHtmlHeader($header);

                        $pdf->addPage('P', 'LETTER');
                        $pdf->setPageMark();

                        $tablaProductos = '<table style="width: 100%; font-size: 11px; border: 1px solid black; padding-top: 5px; padding-bottom: 5px;">';
                        $tablaProductos .= '<tr style="width: 100%; font-weight: bold; border: 1px solid black;; padding: 0">';
                        $tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black; line-height: 7mm; padding: 0">Código</td>';
                        //$tablaProductos .= '<td style="width: 13%; text-align: center; border: 1px solid black; line-height: 7mm; padding: 0">Modelo</td>';
                        $tablaProductos .= '<td style="width: 50%; text-align: center; border: 1px solid black; line-height: 7mm; padding: 0">Descripción</td>';
                        $tablaProductos .= '<td style="width: 8%; text-align: center; border: 1px solid black; font-size: 9px; padding: 0">Unidades Vendidas</td>';
                        $tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black; font-size: 9px; padding: 0">Costo <br> Unitario</td>';
                        //$tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black; line-height: 7mm;font-size: 9px; padding: 0">% Descuento</td>';
                        $tablaProductos .= '<td style="width: 22%; text-align: center; border: 1px solid black; line-height: 7mm; padding: 0">Total</td>';
                        $tablaProductos .= '</tr>';

                        $total = 0;
                        if($infoPro->limite != 0){
                            $comision = ($infoPro->limite/100);
                        }else{
                            $comision = 0;
                        }

                        foreach($infoVentas as $venta){
                            $tablaProductos .= '<tr style="width: 100%;">';
                            $tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black;">'.$venta->idproducto.'</td>';
                            //$tablaProductos .= '<td style="width: 13%; text-align: center; border: 1px solid black;">'.$venta->modelo.'</td>';
                            $tablaProductos .= '<td style="width: 50%; text-align: left; border: 1px solid black;">'.strtoupper($venta->descrip).'</td>';
                            $tablaProductos .= '<td style="width: 8%; text-align: center; border: 1px solid black;">'.abs($venta->Total).'</td>';
                            $tablaProductos .= '<td style="width: 10%; text-align: right; border: 1px solid black;">$'.number_format(abs($venta->costounitario), 2, '.', '').'</td>';
                            //if($venta->descuento != 0){
                                //$tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black;">'.number_format(abs($venta->descuento), 2, '.', '').'</td>';
                            //}else{
                                //$tablaProductos .= '<td style="width: 10%; text-align: center; border: 1px solid black;"></td>';

                            //}
                            //$tablaProductos .= '<td style="width: 22%; text-align: right; border: 1px solid black;">$'.number_format(abs($venta->totalvn), 2, '.', '').'</td>';
                            $tablaProductos .= '<td style="width: 22%; text-align: right; border: 1px solid black;">$'.number_format(abs($venta->costounitario * $venta->Total), 2, '.', '').'</td>';
                            $tablaProductos .= '</tr>';

                            //$total += abs($venta->totalvn);
                            $total += abs($venta->costounitario * $venta->Total);
                            $lineas += 1;
                            $unidades += abs($venta->Total);
                        }
                        $tablaProductos .= '</table>';
                        $tablaProductos .= '<table style="width: 100%; font-size: 11px; line-height: 6mm;">';
                        $tablaProductos .= '<tr style="width: 100%;">';
                        $tablaProductos .= '<td style="width: 60%; font-weight: bold; text-align: right; border: 1px solid black;">Total de Unidades Vendidas</td>';
                        $tablaProductos .= '<td style="width: 8%; font-weight: bold; text-align: center;  border: 1px solid black;">'.$unidades.' </td>';
                        //$tablaProductos .= '<td style="width: 20%;font-weight: bold; text-align: right;  border: 1px solid black;">Total Ventas </td>';
                        //$tablaProductos .= '<td style="width: 12%; text-align: right;  border: 1px solid black;">$ '.number_format($total, 2, '.', '').'</td>';
                        //$tablaProductos .= '</tr>';

                        //$totalcomision = $total * $comision * -1;
                        //$totalcomision = $totalcomision * 1.13;

                        //$tablaProductos .= '<tr style="width: 100%;">';
                        //$tablaProductos .= '<td style="width: 68%; text-align: center"></td>';
                        //$tablaProductos .= '<td style="width: 20%;font-weight: bold; text-align: right;  border: 1px solid black;">Comisión ('.$infoPro->limite.'%) + IVA </td>';
                        //$tablaProductos .= '<td style="width: 12%; text-align: right;  border: 1px solid black;">$ '.number_format($totalcomision, 2, '.', '').'</td>';
                        //$tablaProductos .= '</tr>';

                        //$grantotal = $total + $totalcomision;
                        //$tablaProductos .= '<tr style="width: 100%;">';
                        //$tablaProductos .= '<td style="width: 68%; text-align: center"></td>';
                        $tablaProductos .= '<td style="width: 20%;font-weight: bold; text-align: right;  border: 1px solid black;">Sumas</td>';
                        //$tablaProductos .= '<td style="width: 12%;font-weight: bold; text-align: right;  border: 1px solid black;">$ '.number_format($grantotal, 2, '.', '').'</td>';
                        $tablaProductos .= '<td style="width: 12%;font-weight: bold; text-align: right;  border: 1px solid black;">$ '.number_format($total, 2, '.', '').'</td>';
                        $tablaProductos .= '</tr>';

                        $tablaProductos .= '</table>';

                        //  DESGLOSE DE TOTAL
                        /*
                        $tablaTotales = '<table style="width: 100%; font-size: 11px; border-collapse: collapse; line-height: 6mm;">';


                    
                        $tablaTotales .= '<tr style="width: 100%;">';
                        $tablaTotales .= '<td style="width: 60%; text-align: center"></td>';
                        $tablaTotales .= '<td style="width: 28%;font-weight: bold; text-align: right;  border: 1px solid black;">Comisión ('.$infoPro->limite.'%) + IVA </td>';
                        $tablaTotales .= '<td style="width: 12%; text-align: right;  border: 1px solid black;">$ '.number_format($totalcomision, 2, '.', '').'</td>';
                        $tablaTotales .= '</tr>';

                        $grantotal = $total + $totalcomision;
                        $tablaTotales .= '<tr style="width: 100%;">';
                        $tablaTotales .= '<td style="width: 60%; text-align: center"></td>';
                        $tablaTotales .= '<td style="width: 28%;font-weight: bold; text-align: right;  border: 1px solid black;">Total a Pagar</td>';
                        $tablaTotales .= '<td style="width: 12%;font-weight: bold; text-align: right;  border: 1px solid black;">$ '.number_format($grantotal, 2, '.', '').'</td>';
                        $tablaTotales .= '</tr>';

                        $tablaTotales .= '</table>';
                        */
                        $pdf->writeHTML($tablaProductos, true, false, true, false, ''); 
                        //$pdf->writeHTML($tablaTotales, true, false, true, false, ''); 

                    }
                }

                $nombre_archivo = utf8_decode("Reporte_Liquidacion_Emprendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');            
            }
        }

        //--------------------------------------------------------------------------------------

        function reporteVentasDiariasOld($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				foreach($tipospagos as $tip){
					$valpag_retencion[$tip->cajclase] = 0;
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 13%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Retención</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 12%">Forma de Pago</th></tr>
                            </thead>';
                $titulo .='<tbody>';
                $totalGeneral = 0;
                $totalExento = 0;
                $totalGravado = 0;
                $totalRetencion = 0;
                $totalIva = 0;
                $totalDocs = 0;
				$total_remesar = 0;
                foreach($documentos as $docs){
                    
					$numdoc = 0;
					$subtotal=0;
					$subtotalexento = 0;
					$subtotalgravado = 0;
					$subtotalretencion = 0;
					$subtotaliva = 0;
                    $titulo .= '<tr><th colspan="11"><br></th></tr><tr><th colspan="11" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++;
                            $totalDocs++;
                            $exento = 0;
                            $gravado = 0;
                            $iva = 0;
                            $retencion = 0;
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                if($fact->tipoCliente == 3 && abs($fact->valventan) >= 100){
                                    if($fact->valventan >= 100){
										$retencion = ($fact->valventan*0.01)*-1;
									}else{
										$retencion = ($fact->valventan*0.01);
									}
                                    $gravado = $fact->valventan;
                                }else{
                                    $gravado = ($fact->valtax1 / 0.13);
                                    $exento = $fact->valventan-$gravado;
                                }
                            }
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva+$retencion;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotalretencion += $retencion;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($fact->namecliente, 0, 22);
                            $nameVendedor = substr($fact->namevendedor, 0, 20);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                            
                            if($pagos!=false){
                                if($cadena_pago!=""){
                                    $cadena_pago.=',';
                                }
                                foreach($pagos as $money){
                                    $cadena_pago .= $money->descrip.",";
                                }
                                $cadena_pago = substr($cadena_pago, 0, -1);
                            }
                            $cadena_pago = substr($cadena_pago, 0, 25);
                           
							
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
										
										if($money->formaPag=="Efectivo" ||$money->formaPag=="Cheques"){
											if($fact->inopera==1){
												$total_remesar -= (abs($money->valor) - abs($money->vuelto));
											}else{
												$total_remesar += (abs($money->valor) - abs($money->vuelto));
											}
										}
										
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:left; font-weight: normal; width: 10%">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.mb_convert_encoding($this->eliminarTildes($nameCliente), 'ISO-8859-15', 'UTF-8').'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 13%">'.mb_convert_encoding($this->eliminarTildes($nameVendedor), 'ISO-8859-15', 'UTF-8').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado+$iva+$exento+$retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 12%">'.$cadena_pago.'</td></tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:42%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalretencion, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:12%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalRetencion += $subtotalretencion;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '</tbody></table>';
                $titulo .= '<br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Retención</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:10%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalIva, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalRetencion, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGeneral, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><table>
                <thead>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">INGRESOS</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo_Retencion('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $cant_fp++;
                        }
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                        }
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      

                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                $total_ing_sum=0;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                           $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                                $total_ing_sum+=$valpagG[$tip->cajclase];
                        }
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_ing_sum, 2),2).'</td></tr>
				
				</tbody></table>';
				
				
				$titulo .='<br><br><table>
                <thead>
				<tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:20%;background-color:gray; color:white;">REMESA</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
				</thead>
				<tbody>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:20%;background-color:#C2CBCE;">Efectivo + Cheques&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Fecha&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;background-color:#C2CBCE;">Hora&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;background-color:#C2CBCE;">Cuenta&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Valor Remesado&nbsp;&nbsp;</td>
				</tr>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:20%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
				</tr>
				
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:left; font-weight: bold; width:100%;">&nbsp;Observaciones:<br><br></td>

				</tr>
				
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-top: 1px solid black;"><td style="border-top: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:30%;">Elaborado por</td></tr>
				</tbody></table>';
				

				/*
				
				<tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">Total a Remesar</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
				*/
				
					
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}

        function reporteVentasDiarias($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas_gt('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				foreach($tipospagos as $tip){
					$valpag_retencion[$tip->cajclase] = 0;
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 13%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Retención</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 12%">Forma de Pago</th></tr>
                            </thead>';
                $titulo .='<tbody>';
                $totalGeneral = 0;
                $totalExento = 0;
                $totalGravado = 0;
                $totalRetencion = 0;
                $totalIva = 0;
                $totalDocs = 0;
				$total_remesar = 0;
                foreach($documentos as $docs){
                    
					$numdoc = 0;
					$subtotal=0;
					$subtotalexento = 0;
					$subtotalgravado = 0;
					$subtotalretencion = 0;
					$subtotaliva = 0;
                    $titulo .= '<tr><th colspan="11"><br></th></tr><tr><th colspan="11" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++;
                            $totalDocs++;
                            $exento = 0;
                            $gravado = 0;
                            $iva = 0;
                            $retencion = 0;
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                if($fact->tipoCliente == 3 && abs($fact->valventan) >= 100){
                                    if($fact->valventan >= 100){
										$retencion = ($fact->valventan*0.01)*-1;
									}else{
										$retencion = ($fact->valventan*0.01);
									}
                                    $gravado = $fact->valventan;
                                }else{
                                    $gravado = ($fact->valtax1 / 0.13);
                                    $exento = $fact->valventan-$gravado;
                                }
                            }
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva+$retencion;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotalretencion += $retencion;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($fact->namecliente, 0, 22);
                            $nameVendedor = substr($fact->namevendedor, 0, 20);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                            
                            if($pagos!=false){
                                if($cadena_pago!=""){
                                    $cadena_pago.=',';
                                }
                                foreach($pagos as $money){
                                    $cadena_pago .= $money->descrip.",";
                                }
                                $cadena_pago = substr($cadena_pago, 0, -1);
                            }
                            $cadena_pago = substr($cadena_pago, 0, 25);
                           
							
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
										
										if($money->formaPag=="Efectivo" ||$money->formaPag=="Cheques"){
											if($fact->inopera==1){
												$total_remesar -= (abs($money->valor) - abs($money->vuelto));
											}else{
												$total_remesar += (abs($money->valor) - abs($money->vuelto));
											}
										}
										
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:left; font-weight: normal; width: 10%">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.mb_convert_encoding($this->eliminarTildes($nameCliente), 'ISO-8859-15', 'UTF-8').'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 13%">'.mb_convert_encoding($this->eliminarTildes($nameVendedor), 'ISO-8859-15', 'UTF-8').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado+$iva+$exento+$retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 12%">'.$cadena_pago.'</td></tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:42%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalretencion, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:12%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalRetencion += $subtotalretencion;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '</tbody></table>';
                $titulo .= '<br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Retención</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:10%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalIva, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalRetencion, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGeneral, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><table>
                <thead>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">INGRESOS</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo_Retencion('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $cant_fp++;
                        }
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                        }
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      

                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                $total_ing_sum=0;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                        //$total_ing_sum+=$pag->valor;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                           $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                                $total_ing_sum+=$valpagG[$tip->cajclase];
                        }
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_ing_sum, 2),2).'</td></tr>
				
				</tbody></table>';
				
				
				$titulo .='<br><br><table>
                <thead>
				<tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:20%;background-color:gray; color:white;">REMESA</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
				</thead>
				<tbody>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:20%;background-color:#C2CBCE;">Efectivo + Cheques&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Fecha&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;background-color:#C2CBCE;">Hora&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;background-color:#C2CBCE;">Cuenta&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Valor Remesado&nbsp;&nbsp;</td>
				</tr>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:20%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
				</tr>
				
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:left; font-weight: bold; width:100%;">&nbsp;Observaciones:<br><br></td>

				</tr>
				
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-top: 1px solid black;"><td style="border-top: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:30%;">Elaborado por</td></tr>
				</tbody></table>';
				

				/*
				
				<tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">Total a Remesar</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
				*/
				
					
                
               
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}

        function ventaTicketFinal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numZ = $caja->numz;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($namecentro)>39){
                    $cmds .= substr(strtoupper($namecentro), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecaja), 0, 39);
                $cmds .= comandosTM::LineFeed;
                //$cmds .= comandosTM::LineFeed;

                $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($direccion)>39){
                    $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= trim($depto_municipio);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'Caja #: '.$idcaja.'  Z: '.$numZ;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $pro->idproducto;
                        $cmds .= comandosTM::LineFeed;
                        
                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $pro->idproducto;
                        $cmds .= comandosTM::LineFeed;

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->pad(4);
                        $cmds .= $comandosTM->padText(number_format(abs($pro->cantidad), 2, '.', '')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL EXENTO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $tipoPago = $dtpagos->cajclase;
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                //$cmds .= "No. ".$serieDocumento.$numeroRecibo;
                //$cmds .= comandosTM::LineFeed;

                $cmds .= $numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "Del ".$fecres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "DE:".$desder." AL ".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= $comandosTM->padText('DATOS DEL CLIENTE', 39, 'BOTH');
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= $comandosTM->padText('CLIENTE: '.substr(trim($cliente), 0, 30), 39, 'RIGHT');
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->padText('DUI/NIT: '.str_repeat("_", 30), 39, 'BOTH');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::FullCut950;
                $cmds = $cmds;
                //$printerName = explode(',', $printerName);
                //$printerName = $printerName[1];
                //$printerName = 'TM-950';
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function comprobanteRegalo($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                //var_dump($informacion);

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numZ = $caja->numz;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($namecentro)>39){
                    $cmds .= substr(strtoupper($namecentro), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecaja), 0, 39);
                $cmds .= comandosTM::LineFeed;
                //$cmds .= comandosTM::LineFeed;

                $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 0, 39);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($direccion)>39){
                    $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim(str_replace('º',comandosTM::Grades,$direccion)), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= trim($depto_municipio);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NIT: '.$NIT.' NRC: '.$NRF;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "IVA D.L. N 296";
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'Caja #: '.$idcaja.'  Z: '.$numZ;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= 'COMPROBANTE DE REGALO';
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $hora_actual = date("H:i:s A");
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= 'Fecha: '.date_format(date_create($info->fecha), 'd/m/Y').' '.$hora_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'Cod. Vendedor: '.$info->idworker;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);

                //var_dump($productos);
                foreach($productos as $pro){
                    $proname   = trim($pro->descrip);
                    
                    $cmds .= $comandosTM->padText($pro->idproducto, 9, 'BOTH');
                    $cmds .= $comandosTM->padText(substr($this->eliminarTildes($proname), 0, 24), 24, 'LEFT');
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $comandosTM->padText(number_format(abs($pro->cantidad), 0), 4, "BOTH");
                    $cmds .= comandosTM::LineFeed;

                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(1);
                $cmds .= "Nota:";
                $cmds .= $comandosTM->pad(1);
                $cmds .= "Favor presentar este comprobante";
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(7);
                $cmds .= "para realizar cualquier cambio.";
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::FullCut950;
                $cmds = $cmds;
                //$printerName = explode(',', $printerName);
                //$printerName = $printerName[1];
                //$printerName = 'TMU950';
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function printDevolucionDivesaTMU($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
               

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                  
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
        