<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    require 'vendor/autoload.php';

    use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception; 

    class Reports extends CI_Controller{

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }

        function __construct(){
            // if(session_status() == PHP_SESSION_NONE){
            //     session_start();
            // }

            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial *1;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
				case 0:{
					$num_letra = "0";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
            $numero = $numero*1; 
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero); 
            $num = "cero";
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
            $importe_parcial = $importe_parcial*1;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;
			$importe_parcial = $importe_parcial*1;
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function eliminarTildes($cadena){
			$cadena = str_replace(
				array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
				array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
				$cadena
			);
			
			$cadena = str_replace(
				array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
				array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
				$cadena
			);
			
			$cadena = str_replace(
				array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
				array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
				array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
				array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
				$cadena
			);
			
			$cadena = str_replace(
				array('ñ', 'Ñ', 'ç', 'Ç'),
				array('n', 'N', 'c', 'C'),
				$cadena
			);
			
			return $cadena;
		}

        #   VALOR EN LETRAS
        function valorEnLetras($x){ 
            $I7 = " ";
            $I9 = " ";
            if ($x<0) { $signo = "menos ";} 
            else      { $signo = "";} 
            $x = abs ($x); 
            $C1 = $x; 

            $G6 = floor($x/(1000000));  // 7 y mas 

            $E7 = floor($x/(100000)); 
            $G7 = $E7-$G6*10;   // 6 

            $E8 = floor($x/1000); 
            $G8 = $E8-$E7*100;   // 5 y 4 

            $E9 = floor($x/100); 
            $G9 = $E9-$E8*10;  //  3 

            $E10 = floor($x); 
            $G10 = $E10-$E9*100;  // 2 y 1 


            $G11 = round(($x-$E10)*100,0);  // Decimales 
            ////////////////////// 

            $H6 = $this->unidades($G6); 

            if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
            else {    $H7 = $this->decenas($G7); } 

            $H8 = $this->unidades($G8); 

            if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
            else {    $H9 = $this->decenas($G9); } 

            $H10 = $this->unidades($G10); 

            if($G11 < 10) { $H11 = "0".$G11; } 
            else { $H11 = $G11; } 

            ///////////////////////////// 
                if($G6==0) { $I6=" "; } 
            elseif($G6==1) { $I6="Millón "; } 
                    else { $I6="Millones "; } 

            if ($G8==0 AND $G7==0) { $I8=" "; } 
                    else { $I8="Mil "; } 

            $I10 = ""; 
            $I11 = "/100 US DOLARES ";

            $C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

            return $C3; //Retornar el resultado 
        }
        function unidades($u){ 
            if ($u==0)  {$ru = " ";} 
            elseif ($u==1)  {$ru = "Un ";} 
            elseif ($u==2)  {$ru = "Dos ";} 
            elseif ($u==3)  {$ru = "Tres ";} 
            elseif ($u==4)  {$ru = "Cuatro ";} 
            elseif ($u==5)  {$ru = "Cinco ";} 
            elseif ($u==6)  {$ru = "Seis ";} 
            elseif ($u==7)  {$ru = "Siete ";} 
            elseif ($u==8)  {$ru = "Ocho ";} 
            elseif ($u==9)  {$ru = "Nueve ";} 
            elseif ($u==10) {$ru = "Diez ";} 

            elseif ($u==11) {$ru = "Once ";} 
            elseif ($u==12) {$ru = "Doce ";} 
            elseif ($u==13) {$ru = "Trece ";} 
            elseif ($u==14) {$ru = "Catorce ";} 
            elseif ($u==15) {$ru = "Quince ";} 
            elseif ($u==16) {$ru = "Dieciseis ";} 
            elseif ($u==17) {$ru = "Decisiete ";} 
            elseif ($u==18) {$ru = "Dieciocho ";} 
            elseif ($u==19) {$ru = "Diecinueve ";} 
            elseif ($u==20) {$ru = "Veinte ";} 

            elseif ($u==21) {$ru = "Veintiun ";} 
            elseif ($u==22) {$ru = "Veintidos ";} 
            elseif ($u==23) {$ru = "Veintitres ";} 
            elseif ($u==24) {$ru = "Veinticuatro ";} 
            elseif ($u==25) {$ru = "Veinticinco ";} 
            elseif ($u==26) {$ru = "Veintiseis ";} 
            elseif ($u==27) {$ru = "Veintisiente ";} 
            elseif ($u==28) {$ru = "Veintiocho ";} 
            elseif ($u==29) {$ru = "Veintinueve ";} 
            elseif ($u==30) {$ru = "Treinta ";} 

            elseif ($u==31) {$ru = "Treinta y un ";} 
            elseif ($u==32) {$ru = "Treinta y dos ";} 
            elseif ($u==33) {$ru = "Treinta y tres ";} 
            elseif ($u==34) {$ru = "Treinta y cuatro ";} 
            elseif ($u==35) {$ru = "Treinta y cinco ";} 
            elseif ($u==36) {$ru = "Treinta y seis ";} 
            elseif ($u==37) {$ru = "Treinta y siete ";} 
            elseif ($u==38) {$ru = "Treinta y ocho  ";} 
            elseif ($u==39) {$ru = "Treinta y nueve ";} 
            elseif ($u==40) {$ru = "Cuarenta ";} 

            elseif ($u==41) {$ru = "Cuarenta y un ";} 
            elseif ($u==42) {$ru = "Cuarenta y dos ";} 
            elseif ($u==43) {$ru = "Cuarenta y tres ";} 
            elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
            elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
            elseif ($u==46) {$ru = "Cuarenta y seis ";} 
            elseif ($u==47) {$ru = "Cuarenta y siete ";} 
            elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
            elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
            elseif ($u==50) {$ru = "Cincuenta ";} 

            elseif ($u==51) {$ru = "Cincuenta y un ";} 
            elseif ($u==52) {$ru = "Cincuenta y dos ";} 
            elseif ($u==53) {$ru = "Cincuenta y tres ";} 
            elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
            elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
            elseif ($u==56) {$ru = "Cincuenta y seis ";} 
            elseif ($u==57) {$ru = "Cincuenta y siete ";} 
            elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
            elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
            elseif ($u==60) {$ru = "Sesenta ";} 

            elseif ($u==61) {$ru = "Sesenta y un ";} 
            elseif ($u==62) {$ru = "Sesenta y dos ";} 
            elseif ($u==63) {$ru = "Sesenta y tres ";} 
            elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
            elseif ($u==65) {$ru = "Sesenta y cinco ";} 
            elseif ($u==66) {$ru = "Sesenta y seis ";} 
            elseif ($u==67) {$ru = "Sesenta y siete ";} 
            elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
            elseif ($u==69) {$ru = "Sesenta y nueve ";} 
            elseif ($u==70) {$ru = "Setenta ";} 

            elseif ($u==71) {$ru = "Setenta y un ";} 
            elseif ($u==72) {$ru = "Setenta y dos ";} 
            elseif ($u==73) {$ru = "Setenta y tres ";} 
            elseif ($u==74) {$ru = "Setenta y cuatro ";} 
            elseif ($u==75) {$ru = "Setenta y cinco ";} 
            elseif ($u==76) {$ru = "Setenta y seis ";} 
            elseif ($u==77) {$ru = "Setenta y siete ";} 
            elseif ($u==78) {$ru = "Setenta y ocho  ";} 
            elseif ($u==79) {$ru = "Setenta y nueve ";} 
            elseif ($u==80) {$ru = "Ochenta ";} 

            elseif ($u==81) {$ru = "Ochenta y un ";} 
            elseif ($u==82) {$ru = "Ochenta y dos ";} 
            elseif ($u==83) {$ru = "Ochenta y tres ";} 
            elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
            elseif ($u==85) {$ru = "Ochenta y cinco ";} 
            elseif ($u==86) {$ru = "Ochenta y seis ";} 
            elseif ($u==87) {$ru = "Ochenta y siete ";} 
            elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
            elseif ($u==89) {$ru = "Ochenta y nueve ";} 
            elseif ($u==90) {$ru = "Noventa ";} 

            elseif ($u==91) {$ru = "Noventa y un ";} 
            elseif ($u==92) {$ru = "Noventa y dos ";} 
            elseif ($u==93) {$ru = "Noventa y tres ";} 
            elseif ($u==94) {$ru = "Noventa y cuatro ";} 
            elseif ($u==95) {$ru = "Noventa y cinco ";} 
            elseif ($u==96) {$ru = "Noventa y seis ";} 
            elseif ($u==97) {$ru = "Noventa y siete ";} 
            elseif ($u==98) {$ru = "Noventa y ocho  ";} 
            else            {$ru = "Noventa y nueve ";} 
            return $ru; //Retornar el resultado 
        } 
        function decenas($d){ 
            if ($d==0)  {$rd = "";} 
            elseif ($d==1)  {$rd = "Ciento ";} 
            elseif ($d==2)  {$rd = "Doscientos ";} 
            elseif ($d==3)  {$rd = "Trescientos ";} 
            elseif ($d==4)  {$rd = "Cuatrocientos ";} 
            elseif ($d==5)  {$rd = "Quinientos ";} 
            elseif ($d==6)  {$rd = "Seiscientos ";} 
            elseif ($d==7)  {$rd = "Setecientos ";} 
            elseif ($d==8)  {$rd = "Ochocientos ";} 
            else            {$rd = "Novecientos ";} 
            return $rd; //Retornar el resultado 
        }

    	//Cortes De Caja-------------------------------------------------------------------------------------------------------------------
		function imprimirApertura($fechaactual, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{
                date_default_timezone_set('America/El_Salvador');

				$this->load->model('ventas_model'); $this->load->model('global_model');
				$this->load->model('sucursal_model'); $this->load->model('caja_model');	
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = strtoupper($this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5)));
				$direccion = strtoupper($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);

                $fechaImpre = new DateTime();
                $fechaImpre = $fechaImpre->format('d/m/Y');

                $horaCorte = date_format(date_create($fechaactual), 'H:i');
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				$partesFecha = explode("/", $fechaCorte);

				$cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "APERTURA DE CAJA";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::Initialize;
                $cmds .= comandosTM::PrintTicket;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $fechaCorte = date_format(date_create($fechaactual), 'dmY');

                $trannum = 'A'.$idcentro.$idcaja.$fechaCorte;
                $this->ventas_model->setCommandsPrint($trannum, $cmds,2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function reporteCorteX($fechaactual, $idcentro, $idcaja){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;    
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz;    
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "RESUMEN: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= $date->format('d/m/Y H:i:s A');

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;


                $trannum = 'CX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes

                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

            	$this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();


                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
            
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);

                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;        
                    $printerName = $caja->notas;
                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
 
                $documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);

                $cnt = 0;
                $valpag = array();

                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';

                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;
                
                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($tipospagos as $tip){
                    $valpag[$tip->cajclase] = 0;
                    $valpagG[$tip->cajclase] = 0;
                    $cnt++;
                }

                $fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE X N ".$numero_x;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;

                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0;
                    $subtotalex = 0; $subtotalgr = 0;
                    $subtotaliv = 0; $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            
                            $total = 0; $totalGravado = 0; $totalExento = 0;
                            $totalIVA = 0; $invexento = $ven->exento;
                            
                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);
                            
                            foreach ($tipospagos as $tip) {
                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
                                foreach($pagos as $money){
                                    if($tip->cajclase == $money->cajclase){
                                        if($money->valor <= 0){
                                            $moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));
                                        }else{
                                            $moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;
                                        }
                                        
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
                                    }
                                }
                            }
                            
                            $numdoc++; $numdocg++;
                            $numFinal = $ven->numero;
                            $t++;
                        }else{
                            foreach($tipospagos as $tip){
                                $valpag[$tip->cajclase] = 0;
                            }
                        }
                    }

                    $numCantidad = $numInicial;

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numFinal;
                    
                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                   
                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(2);
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;  
                $cmds .= comandosTM::TextAlignLeft;

                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);
                
                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){
                    $l++;
                } 

                $p=0;
                $total_cre_sum=0;
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoCorteX($idcentro, $idcaja, $numero_x, $numero_z, $fechaactual);

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else{
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                        if($pagos_credito!=false){

                            foreach($pagos_credito as $pag){

                                $nameFormaCr = 'Credito';
                                $totalStringCr = strlen($nameFormaCr);
                                $newCoordenada=0;  

                                $numPrecioCr = number_format(round($pag->valor, 2),2, ".","");
                                $valorStringCr = strval($numPrecio);
                                $numTotalCr = strlen($valorString);
                                
                                $cmds .= $comandosTM->padText($nameFormaCr.": ", 17, 'LEFT');
                                $cmds .= $comandosTM->padText('$'.$numPrecioCr, 11, 'LEFT');
                                $cmds .= comandosTM::LineFeed;

                                $total_cre_sum+=round($pag->valor, 2);
                            }
                        }
                    }

                    $total_ing_sum = $total_ing_sum + round($valpagG[$tip->cajclase], 2) + $total_cre_sum;
                    $p++;
                }

                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($total_ing_sum, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;


                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;



                    if($valorSistema == 0){
                        $diferencia = $valorCaja;
                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);
                    
                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
              
                //FIN FOR CUADRE DE CAJA
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);        

                if($numerotransacc > 1){
                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    //$cmds .= $comandosTM->pad(28);
                    //$cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;
    

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                }    

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }



                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;

                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));
                
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'ICX'.$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function reporteCorteZFacturaz($fechaactual, $idcentro, $idcaja){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                    $numero_x = $caja->numx;
					$numero_z = $caja->numz; 
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               

				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);

                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
                $this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);

                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
      
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "CZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }
        function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){

			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){

                redirect('login/cerrar_sesion');

            }else{

				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

				$RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);

				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);				

				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
				}				

				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);               
                
				$cnt = 0;
				$valpag = array();	

				foreach($tipospagos as $tip){

					$valpag[$tip->cajclase] = 0;

					$valpagG[$tip->cajclase] = 0;

					$cnt++;

				}

				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccion), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccion)>39){
                    $cmds .= substr(trim($direccion), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccion)>78){
                    $cmds .= substr(trim($direccion), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
               
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "REIMPRESION CORTE Z N ".$numero_z;
                $cmds .= comandosTM::LineFeed;
                    
                $cmds .= $fechaCorte;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "TRANSACCIONES:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');

                $date = new DateTime();
                $anio = $date->format("Y");
                $mes = $date->format("m");
                $dia = $date->format("d");
                $hours = $date->format("h");
                $minutes = $date->format("i");
                $seconds = $date->format("s");
                $ampm = $hours >= 12 ? 'PM' : 'AM';
                $hours = $hours % 12;
                $hours = $hours ? $hours : 12; // the hour '0' should be '12'
                $minutes = $minutes < 10 ? '0'.$minutes : $minutes;
                $strTime = $hours.':'.$minutes.':'.$seconds.' '.$ampm;

                $subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
                $subtotalex = 0;
                $subtotalgr = 0;
                $subtotaliv = 0;
                $numdoc = 0;
                $numdocg = 0;

                foreach($documentos as $docs){

                    $numdoc = 0;

                    $subtotal=0;

                    $subtotalex = 0;

                    $subtotalgr = 0;

                    $subtotaliv = 0;

                    $t = 0;

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){

                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){

                            $valtot = $ven->valventan + $ven->valtax1;

                            $subtotal= $subtotal+$valtot;

                            if($t == 0){

                                $numInicial = $ven->numero;

                            }

                            $total = 0;

                            $totalGravado = 0;

                            $totalExento = 0;

                            $totalIVA = 0;

                            $invexento = $ven->exento;

                            $productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                          
                            foreach($productos as $pro){

                                if($pro->tax1 != 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));

                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));

                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 != 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1== 0 && $invexento == 0){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }else if($pro->tax1 == 0 && $invexento == 1){

                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));

                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                                }

                            }



                            $subtotalex = $subtotalex + (($ven->caopera == -1) ? $totalExento * -1 : $totalExento);
                            $subtotalgr = $subtotalgr + (($ven->caopera == -1) ? $totalGravado * -1 : $totalGravado);
                            $subtotaliv = $subtotaliv + (($ven->caopera == -1) ? $totalIVA * -1 : $totalIVA);

                           

                            foreach($tipospagos as $tip){

                                $pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);

                                foreach($pagos as $money){

                                    if($tip->cajclase == $money->cajclase){

                                        if($money->valor <= 0){

											$moneyvalor = abs(number_format(round($money->valor, 2), 2, '.', ''));

										}else{

											$moneyvalor = number_format(round($money->valor, 2), 2, '.', '') * -1;

										}

										

										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));

                                    }

                                }

                            }

                            $numdoc++;

                            $numdocg++;

                            $numFinal = $ven->numero;

                            $t++;

                        }else{

                            foreach($tipospagos as $tip){

                                $valpag[$tip->cajclase] = 0;

                            }

                        }

                    }
                            
                    $numCantidad = $numInicial;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Del: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numInicial, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;   

                    $numCantidad = $numFinal;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Al: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numFinal, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = $numdoc;
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText($numdoc, 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotalex, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalex, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad =number_format(round($subtotalgr, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotalgr, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotaliv, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);
                    
                    $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.(($ven->caopera == -1) ? '-' : '').number_format(round($subtotaliv, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $numCantidad = number_format(round($subtotal, 2),2);
                    $totalString = strval($numCantidad);
                    $numTotal = strlen($totalString);

                    $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->padText('$'.number_format(round($subtotal, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
            
                    $totalglobal = $totalglobal+$subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;      
                }

                $cmds .= $comandosTM->pad(2);
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "Totales";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $numCantidad = $numdoc;
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Operaciones: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText($numdocg, 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalexglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Exentas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalexglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalgrglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("Ventas Gravadas: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalgrglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalivglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText("IVA: ", 17, 'LEFT');
                $cmds .= $comandosTM->padText('$'.number_format(round($totalivglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $numCantidad = number_format(round($totalglobal, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.number_format(round($totalglobal, 2),2, ".",""), 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "INGRESOS:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed; 

                $total_ing_sum=0;

                $l=0;

                foreach($tipospagos as $tip){

                    $l++;

                }

                $p=0;

                foreach($tipospagos as $tip){

                    $nameForma = substr($tip->descrip, 0, 13);
                    $totalString = strlen($nameForma);
                    $newCoordenada=0;

                    $numPrecio = number_format(round($valpagG[$tip->cajclase], 2),2, ".","");
                    $valorString = strval($numPrecio);
                    $numTotal = strlen($valorString);       

                    if($p == $l - 1){
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;  

                    }else{ 
                        $cmds .= $comandosTM->padText($nameForma.": ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.$numPrecio, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                    }

                    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    $p++;
                }
                $numCantidad = number_format(round($total_ing_sum, 2),2);
                $totalString = strval($numCantidad);
                $numTotal = strlen($totalString);

                $cmds .= $comandosTM->padText(" Sumas: ", 17, 'LEFT');
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText('$'.$numCantidad, 11, 'LEFT');
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "CUADRE DE CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
                $totalSistema = 0;
                $totalCaja = 0;
                $numerotransacc = 0;

                foreach($infoCuadre as $info){
                    $fechaImpre = $info->ingresa;

                    $numCantidad = substr($info->formapago, 0, 4);
                    $totalString = strval($numCantidad);

                    $numCantidad2 = number_format(round($info->valorsys, 2),2, ".","");
                    $totalString2 = strval($numCantidad2);
                    $numTotal2 = strlen($totalString2);

                    $numCantidad3 = number_format(round($info->valorusr, 2),2, ".","");
                    $totalString3 = strval($numCantidad3);
                    $numTotal3 = strlen($totalString3);

                    $valorSistema = round($info->valorsys, 2);
                    $valorCaja = round($info->valorusr, 2);

                    $totalSistema = $totalSistema + $valorSistema;
                    $totalCaja = $totalCaja + $valorCaja;

                    if($valorSistema == 0){

                        $diferencia = $valorCaja;

                    }else{

                        $diferencia = $valorCaja - $valorSistema;

                    }

                    $numCantidad4 = number_format(round($diferencia, 2),2, ".","");
                    $totalString4 = strval($numCantidad4);
                    $numTotal4 = strlen($totalString4);

                    $countSys = '('.$info->countsys.')';
                    $stringCount = strval($countSys);
                    $totalString = strlen($stringCount);

                    $countUser = '('.$info->countuser.')';
                    $stringCountUser = strval($countUser);
                    $totalString = strlen($stringCountUser);
                    
                   

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $info->formapago;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad2, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countSys, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.$numCantidad3, 11, 'LEFT');
                    $cmds .= $comandosTM->padText($countUser, 5, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($numCantidad4 > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
    

                    }else if($numCantidad4 < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;

                    }else if($numCantidad4 == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= comandosTM::FontBoldEnable;
                        $cmds .= $comandosTM->padText('$'.$numCantidad4, 11, 'LEFT');
                        $cmds .= comandosTM::FontBoldDisable;
                        $cmds .= comandosTM::LineFeed;
                    }
                    $cmds .= comandosTM::LineFeed;

                    $numerotransacc = $numerotransacc + 1;
                }
                //FINAL FOR CUADRE.
            
                $numTotSistema = number_format(round($totalSistema, 2),2);
                $countString = strval($numTotSistema);
                $numSistema = strlen($countString);

                $numTotCaja = number_format(round($totalCaja, 2),2);
                $countString = strval($numTotCaja);
                $numCaja = strlen($countString);

                $totalDiferencia = $totalCaja - $totalSistema;
                $numTotDif = number_format(round($totalDiferencia, 2),2);
                $countString = strval($numTotDif);
                $numDif = strlen($countString);

                if($numerotransacc > 1){

                    $cmds .= comandosTM::TextAlignLeft;
                    $cmds .= $comandosTM->pad(2);

                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= "Resumen: ";
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                    
                    $cmds .= $comandosTM->padText("Sistema: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalSistema, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->padText("Caja: ", 17, 'LEFT');
                    $cmds .= $comandosTM->padText('$'.number_format(round($totalCaja, 2),2, ".",""), 11, 'LEFT');
                    $cmds .= comandosTM::LineFeed;

                    if($totalDiferencia > 0){
                        $cmds .= $comandosTM->padText("Sobrante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia < 0){
                        $cmds .= $comandosTM->padText("Faltante: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }else if($totalDiferencia == 0){
                        $cmds .= $comandosTM->padText("Diferencia: ", 17, 'LEFT');
                        $cmds .= $comandosTM->padText('$'.number_format(round($totalDiferencia, 2),2, ".",""), 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;

                    }
                }
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "ACTIVIDAD EN CAJA:";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
              
                $cmds .= $comandosTM->pad(2);
                $cmds .= "APERTURA DE GAVETA: ";

                $informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja,$numero_z);

                foreach($informacion as $info){

                    $fechahora = explode(" ", $info->ingresa);

                    $hora = explode(":", $fechahora[1]);

                    $hours = $hora[0];

                    $minutes = $hora[1];

                    $seconds = $hora[2];

                    $ampm = $hours >= 12 ? 'PM' : 'AM';

                    $hours = $hours % 12;

                    $hours = $hours ? $hours : 12;

                    $minutes = $minutes < 10 ? 0 + $minutes : $minutes;

                    $counthours = $hours;

                    $stringhours = $counthours;

                    

                    while(strlen($stringhours) < 2){

                        $stringhours = ' '.$stringhours;

                    }



                    $countmin = $minutes;

                    $stringmin = $countmin;

                    

                    while(strlen($stringmin) < 2){

                        $stringmin = ' '.$stringmin;

                    }



                    $countsec = $seconds;

                    $stringsec = $countsec;

                    

                    while(strlen($stringsec) < 2){

                        $stringsec = ' '.$stringsec;

                    }

                    $hora_apertura = $stringhours.':'.$stringmin.':'.$stringsec.' '.$ampm;

                    $cmds .= comandosTM::LineFeed;
    
                    $cmds .= $comandosTM->pad(2);
                    $cmds .= $hora_apertura.' '.$info->nameuser;
                }                            

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= "F.___________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .= trim($this->session->userdata('userLog'));

                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "Hora de Corte";
                $cmds .= comandosTM::LineFeed;
                $fechaImpre = new DateTime($fechaImpre);
                $cmds .= $fechaImpre->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $fechaActual = new DateTime();
                $cmds .= "Hora de Impresion";
                $cmds .= comandosTM::LineFeed;
                $cmds .= $fechaActual->format('d/m/Y h:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum= "ICZ".$idcentro.$idcaja.$numero_z.$numero_x;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }

        }
        function impresionCorteZMensual($idanio, $idmes, $idcentro, $idcaja){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $comandosTM = new comandosTM();

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $namecaja = $caja->descrip;
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;

                }
                
                $datosprint = $this->ventas_model->getDatosPrinter($idcaja);
                $datospr = explode("/", $datosprint);
                
                switch ($idmes) {
                    case 1:
                        $nameMes = 'ENERO';
                        break;
                    case 2:
                        $nameMes = 'FEBRERO';
                        break;
                    case 3:
                        $nameMes = 'MARZO';
                        break;
                    case 4:
                        $nameMes = 'ABRIL';
                        break;
                    case 5:
                        $nameMes = 'MAYO';
                        break;
                    case 6:
                        $nameMes = 'JUNIO';
                        break;
                    case 7:
                        $nameMes = 'JULIO';
                        break;
                    case 8:
                        $nameMes = 'AGOSTO';
                        break;
                    case 9:
                        $nameMes = 'SEPTIEMBRe';
                        break;
                    case 10:
                        $nameMes = 'OCTUBRE';
                        break;
                    case 11:
                        $nameMes = 'NOVIEMBRE';
                        break;
                    case 12:
                        $nameMes = 'DICIEMBRE';
                        break;
                    default:
                        break;
                }

                $infoCortes = $this->ventas_model->getNumeroZCorteMensual($idcentro, $idcaja, $idanio, $idmes);
                $documentos = $this->ventas_model->tipos_doc_ventas_cortez_mensual($idcentro, $idcaja, $idanio, $idmes);
                $facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZMensual($idcentro, $idcaja, $idanio, $idmes);
                
                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::FontSmall;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $RazonSocial;
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $namecaja;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= $namecentro;
                $cmds .= comandosTM::LineFeed; 

                $cmds .= "NRC:".$NRF." NIT: ".$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr('GIRO: '.$GIRO, 0, 64);
                $cmds .= comandosTM::LineFeed;
                
                if(strlen($GIRO)>64){
                    $cmds .= substr($GIRO ,39,78);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontDoubleHeight;
                $cmds .= "CORTE Z MENSUAL";
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 56);
                $cmds .= comandosTM::LineFeed;

                $cmds .= $nameMes." ".$idanio;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "IMPRESO ".$date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Zeta #", 7, "BOTH");
                $cmds .= $comandosTM->padText("Dia", 4, "BOTH");
                $cmds .= $comandosTM->padText("Gravadas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Exentas", 9, "BOTH");
                $cmds .= $comandosTM->padText("Total", 10, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                
                $totalglobal=0; $totalexglobal=0; $totalgrglobal=0; $totalivglobal=0;
                foreach($infoCortes as $info){
                    $subtotal = 0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    
                    $infoDocumentos = $this->ventas_model->getDocumentosVentasCorteZMensual($idcentro, $idcaja, $info->numz);
                    foreach($infoDocumentos as $ven){
                        $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                        $invexento = $ven->exento;
                        $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }
                        
                        $subtotalex = $subtotalex + $totalExento;
                        $subtotalgr = $subtotalgr + $totalGravado + $totalIVA;
                        $subtotaliv = $subtotaliv + $totalIVA;
                        $totalNumeroZ = $subtotalex + $subtotalgr;
                    }
                    $cmds .= $comandosTM->padText($info->numz, 7, "BOTH");
                    $cmds .= $comandosTM->padText($info->dia, 4, "BOTH");
                    $cmds .= $comandosTM->padText(number_format($subtotalgr, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($subtotalex, 2, '.', ''), 9, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalNumeroZ, 2, '.', ''), 10, "LEFT");
                    $cmds .= comandosTM::LineFeed;

                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                    $totalglobal   = $totalgrglobal + $totalexglobal;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 11, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalgrglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalexglobal, 2, '.', ''), 9, "LEFT");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 10, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= "RESUMEN DE DOCUMENTOS";
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("Desde", 9, "BOTH");
                $cmds .= $comandosTM->padText("Hasta", 9, "BOTH");
                $cmds .= $comandosTM->padText("#", 9, "BOTH");
                $cmds .= $comandosTM->padText("Valor", 12, "BOTH");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                $subtotal=0; $totalglobal=0; $totalexglobal=0;
                $totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
                $subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
                $numdocg = 0; $j=0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalex = 0; $subtotalgr = 0; $subtotaliv = 0;
                    $t = 0;
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= $comandosTM->pad(3);
                    $cmds .= $docs->descrip;
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    foreach($facturas as $ven){
                        if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
                            $valtot = $ven->valventan + $ven->valtax1;
                            $subtotal= $subtotal+$valtot;
                            if($t == 0){
                                $numInicial = $ven->numero;
                            }
                            $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                            $invexento = $ven->exento;
                            $productos = $this->invtran_model->getDataTran100k($ven->trannum);
                            
                            foreach($productos as $pro){
                                if($pro->tipotax != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tipotax == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
                            
                            $subtotalex = $subtotalex + $totalExento;
                            $subtotalgr = $subtotalgr + $totalGravado;
                            $subtotaliv = $subtotaliv + $totalIVA;
                            
                            $numdoc++; $numdocg++; $numFinal = $ven->numero;
                            $t++;
                        }
                        $j++;
                    }
                    $cmds .= $comandosTM->padText($numInicial, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numFinal, 9, "BOTH");
                    $cmds .= $comandosTM->padText($numdoc, 9, "BOTH");
                    $cmds .= $comandosTM->padText(number_format(round($subtotal, 2), 2, '.', ''), 12, "LEFT");
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;

                    $totalglobal   = $totalglobal + $subtotal;
                    $totalexglobal = $totalexglobal + $subtotalex;
                    $totalgrglobal = $totalgrglobal + $subtotalgr;
                    $totalivglobal = $totalivglobal + $subtotaliv;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->padText("TOTALES", 18, "LEFT");
                $cmds .= $comandosTM->padText($j, 9, "BOTH");
                $cmds .= $comandosTM->padText(number_format($totalglobal, 2, '.', ''), 12, "LEFT");
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'F.________________________________________';
                $cmds .= comandosTM::LineFeed;

                $cmds .= trim($this->session->userdata('userLog'));
                $cmds .= comandosTM::LineFeed;

                $cmds .= $date->format('d/m/Y H:i:s A');
                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";

                $cmds .= comandosTM::LineFeed;
                $cmds .=  "_____________________________________";
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::FullCut950;

                $trannum = 'CZM'.$idanio. $idmes. $idcentro. $idcaja;
                $this->ventas_model->setCommandsPrint($trannum, $cmds, 2); //1 -> facturas 2->cortes //1 -> facturas 2->cortes
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function impresionCorteZP($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);   
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."assets/js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."assets/js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."assets/js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.20';
					var devid = 'local_printer';
					var timeout = '600000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
                            
							$productos = $this->ventas_model->getDataProductosVenta($ven->trannum);
                            foreach($productos as $pro){
                                if($pro->tax1 != 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                                    $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                                    $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 != 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1== 0 && $invexento == 0){
                                    $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }else if($pro->tax1 == 0 && $invexento == 1){
                                    $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                    $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                }
                            }
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
			
				/*
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				*/
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2), 2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2), 2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
										
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();

				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText('".$date->format('d/m/Y H:i:s A')."').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					//setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}

	    //Facturacion-----------------------------------------------------------------------------------------------------------------------------------
		function ventaTicketFinal($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    //$zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    //var_dump($info->idzip);
                    //$depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
            
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= strtoupper($info->descrip).' #'.$info->numero;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'GRACIAS POR SU COMPRA';
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= "0x1B"."i";


                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }

                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        function printDevolucion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
            

                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $comandosTM = new comandosTM();

                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
                    $idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $this->eliminarTildes($info->nameCliente);
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $this->eliminarTildes($info->direccion);
                    $giro = $this->eliminarTildes($info->giro);
                    //$zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    //$depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                    $direccionSuc = $info->direccioncentro;
                
                }

                $infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
                
                foreach($datoscaja as $caja){
                    $this->eliminarTildes($namecaja = $caja->descrip);
                    $numcaja = $caja->resolucion;
                    $printerName = $caja->notas;
                }
                
                foreach($infoRes as $infres){
                    $numres = $infres->resolucion;
                    $fecres = $infres->fresolucion;
                    $desder = $infres->serie.$infres->desde;
                    $hastar = $infres->serie.$infres->hasta;
                }

                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));
                $NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 5));
                $direccion = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 6));
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                $partFechaName = explode("/", $fechaRecibo);

                $cmds = comandosTM::Initialize;
                $cmds .= comandosTM::PrintBoth;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= comandosTM::FontSmall;

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= substr(trim($RazonSocial), 0, 39);
                $cmds .= comandosTM::FontBoldDisable;
                $cmds .= comandosTM::LineFeed;

                if(strlen($RazonSocial)>39){
                    $cmds .= comandosTM::FontBoldEnable;
                    $cmds .= substr(trim($RazonSocial), 39, 39);
                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(trim($direccionSuc), 0, 39);
                $cmds .= comandosTM::LineFeed;

                if(strlen($direccionSuc)>39){
                    $cmds .= substr(trim($direccionSuc), 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if(strlen($direccionSuc)>78){
                    $cmds .= substr(trim($direccionSuc), 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= substr(strtoupper($namecentro), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr(strtoupper($namecaja), 0, 64);
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'NRC: '.$NRF.' NIT: '.$NIT;
                $cmds .= comandosTM::LineFeed;

                $cmds .= substr($GIRO, 0, 39);
                $cmds .= comandosTM::LineFeed;
            
                if (strlen($GIRO) > 39) {
                    $cmds .= substr($GIRO, 39, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                if (strlen($GIRO) > 78) {
                    $cmds .= substr($GIRO, 78, 39);
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= 'IVA D.L. N#296';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= 'AUTORIZADO SEGUN RESOLUCION';
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= "NUMERO: ".$numres;
                $cmds .= comandosTM::LineFeed;

                $cmds .= 'DEL: '.date_format(date_create($fecres), 'd/m/Y');
                $cmds .= comandosTM::LineFeed;

                $cmds .= "TIRAJE: ".$desder."-".$hastar;
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FontSmall;
                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;
                
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
                $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
                $cantidades = 0; $totalSumas = 0; $CooNum = 13;
                $ivaCesc = 0; $cesc = 0;
                //var_dump($productos);
                foreach($productos as $pro){
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "";
                        $vnGravada = "".number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "".number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta  = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }

                    $preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
                    $proname   = $pro->descrip;
                    
                    if($pro->descuento != 0){
                        //PRODUCTO CON DESCUENTO
                        $totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . "";
                        $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalSumas = $totalSumas + $absTotal;
                        $totalsindesc = number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        
                        $StringToCantidad = str_pad($pro->cantidad, 7, " ", STR_PAD_LEFT);
                        $StringToCantidad = str_pad(number_format(round(abs($pro->cantidad), 4), 2 ,'.',''), 4, " ", STR_PAD_LEFT);                

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(number_format(round(abs($pro->cantidad), 4), 2 ,'.','')." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$totalsindesc, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        $descuento = $pro->descuento / 100;
                        $cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
                        $totdsc = $cantdes * abs($pro->cantidad);
                        $totalDesc = $totalDesc + $totdsc;
                        
                        $cmds .= $comandosTM->padText('-'.number_format($pro->descuento, 2 ,'.','').'% =', 20, "LEFT");
                        $cmds .= $comandosTM->padText('-'.number_format($totdsc, 2 ,'.',''), 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                
                        
                    }else{
                        //PRODUCTO SIN DESCUENTO
                        if(strlen($vnExenta) != 0){
                            $absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }else{
                            $absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $totalSumas = $totalSumas + $absTotal;
                        }

                        $cmds .= comandosTM::TextAlignLeft;
                        $cmds .= $this->eliminarTildes($proname);
                        $cmds .= comandosTM::LineFeed;

                        $preciouni = $pro->precioneto;
                        $cmds .= $comandosTM->padText(abs($pro->cantidad)." @", 10, "RIGHT");
                        $cmds .= $comandosTM->padText(number_format(round($pro->preciotran, 4), 2 ,'.','')." =", 10, "LEFT");
                        $cmds .= $comandosTM->padText($vnExenta.''.$vnGravada, 14, "LEFT");
                        $cmds .= comandosTM::LineFeed;
                    }

                    if($pro->tax1 == 18){
                        $cesc = $cesc + (number_format(round($pro->precioneto * abs($pro->cantidad), 4), 2 ,'.','') * 0.05);
                        $ivaCesc++;
                    }

                    $numProd++;
                    $cantidades = $cantidades + abs($pro->cantidad);
                }

                $cmds .= comandosTM::TextAlignLeft;
                $cmds .= comandosTM::LineFeed;
                
                $grantotal = $totalIVA + $totalGravado;

                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("L/U:   ", 20, "LEFT");
                $cmds .= $comandosTM->padText($numProd.'/'.$cantidades, 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL GRAVADO:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($grantotal, 2 ,'.',''), 13, "LEFT");                
                $cmds .= comandosTM::LineFeed;

                if($totalExento != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("TOTAL EXENTO: $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalExento, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                if($totalDesc != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("DESCUENTO: -$", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalDesc, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= comandosTM::FontBoldEnable;
                $cmds .= $comandosTM->pad(1);
                $cmds .= $comandosTM->padText("TOTAL:  $", 20, "LEFT");
                $cmds .= $comandosTM->padText(number_format($total, 2 ,'.',''), 13, "LEFT");  
                $cmds .= comandosTM::FontBoldDisable;              
                $cmds .= comandosTM::LineFeed;
                

                $totalPagado = 0;
                $detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);

                foreach($detailPagos as $dtpagos){
                    $notasPago = $dtpagos->notas;
                    $nameForma = substr($dtpagos->namePago, 0, 13);
                    $totalString = strlen($nameForma);
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText(strtoupper($nameForma).":  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format(abs($dtpagos->valor), 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;

                    $totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
                }

                $totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');

                if($totalVuelto != 0){
                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText("CAMBIO:  $", 20, "LEFT");
                    $cmds .= $comandosTM->padText(number_format($totalVuelto, 2 ,'.',''), 13, "LEFT");                
                    $cmds .= comandosTM::LineFeed;
                }

                $cmds .= str_repeat("-", 39);
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::TextAlignCenter;
                $cmds .= 'ATENDIDO POR: '.strtoupper($info->nameVendedor);
                $cmds .= comandosTM::LineFeed;

                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("d/m/Y H:i:s A");

                $cmds .= $fecha_actual;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= "0x1B"."i";

                if($efectivo == 1){
                    $cmds .= comandosTM::OpenDrawer;   
                    $cmds .= comandosTM::LineFeed;
                }
               
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function facturaConsumidorFinal($trannum){
            if($this->session->userdata('idcentrouser') == 1 ){
                redirect($this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalDivesaLX/' . $trannum);
            }else if($this->session->userdata('idcentrouser') == 3 ){
                redirect($this->session->userdata('dirReports') . '/reports/facturaConsumidorFinalDivesaTMU/' . $trannum);
            }
        }

        function creditoFiscal($trannum){
            if($this->session->userdata('idcentrouser') == 1 ){
                redirect($this->session->userdata('dirReports') . '/reports/creditoFiscalDivesaLX/' . $trannum);
            }else if($this->session->userdata('idcentrouser') == 3 ){
                redirect($this->session->userdata('dirReports') . '/reports/creditoFiscalDivesaTMU/' . $trannum);
            }
        }

        function notaDeCredito($trannum){
            if($this->session->userdata('idcentrouser') == 1 ){
                redirect($this->session->userdata('dirReports') . '/reports/notaCreditoDivesaLX/' . $trannum);
            }else if($this->session->userdata('idcentrouser') == 3 ){
                redirect($this->session->userdata('dirReports') . '/reports/notaCreditoDivesaTMU/' . $trannum);
            }
        }

        function facturaExportacion($trannum){
            if($this->session->userdata('idcentrouser') == 1 ){
                redirect($this->session->userdata('dirReports') . '/reports/facturaExportacionDivesaLX/' . $trannum);
            }else if($this->session->userdata('idcentrouser') == 3 ){
                redirect($this->session->userdata('dirReports') . '/reports/facturaExportacionDivesaTMU/' . $trannum);
            }
        }

        //      TUM950
        function facturaConsumidorFinalDivesaTMU($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

                    ##

                    $cmds .= $comandosTM->pad(62);
                    $cmds .= $comandosTM->padText(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, 25, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $clienteTXT = substr($this->eliminarTildes($info->nameCliente),0,40);
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= $comandosTM->padText($clienteTXT, 40, 'RIGHT');
                    $cmds .= $comandosTM->pad(16);
                    $cmds .= substr($this->eliminarTildes($payment),0,16);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(16);
                    $direccion = substr($this->eliminarTildes($info->direccion),0,38);
                    $cmds .= $comandosTM->padText($direccion, 38, 'RIGHT');
                    $cmds .= $comandosTM->pad(12);
                    $cmds .= substr($this->eliminarTildes($info->nameVendedor),0,19);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(16);
                    $direccion = substr($this->eliminarTildes($info->direccion),38,38);
                    $cmds .= $comandosTM->padText($direccion, 38, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                #   PRODUCTOS
                            
                $maxlines = 23;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($productos);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;

                        if($vnExenta != 0 && $vnExenta != ""){
                            $preciouni = $pro->precioneto;
                        }
                        
                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,35);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,9);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $cmds .= $comandosTM->pad(3);
                        $cmds .= $comandosTM->padText($cantidadPro, 11, 'BOTH');
                        $cmds .= $comandosTM->padText($pro->idproducto, 9, 'BOTH');
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($nombrepro, 35, 'RIGHT');
                        $cmds .= $comandosTM->padText(number_format($preciouni, 2 ,'.',''), 9, 'LEFT');
                        $cmds .= $comandosTM->padText($vnExenta, 8, 'LEFT');
                        $cmds .= $comandosTM->padText($vnGravada, 8, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;

                        if($vnGravada != "" && $vnGravada != 0 && $pro->descuento != 0 && $numProd < $maxlines){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                            $cmds .= $comandosTM->pad(25);
                            $cmds .= $comandosTM->padText("Descuento ".number_format(abs($pro->descuento), 2 ,'.','').'%', 35, 'RIGHT');
                            $cmds .= $comandosTM->padText('-'.number_format($discount, 2 ,'.',''), 9, 'LEFT');
                            $cmds .= $comandosTM->pad(8);
                            $cmds .= $comandosTM->padText(number_format($vnGravada-$discount, 2 ,'.',''), 8, 'LEFT');
                            $cmds .= comandosTM::LineFeed;

                            $numProd++;
                        }

                        if($vnExenta != "" && $vnExenta != 0 && $pro->descuento != 0 && $numProd < $maxlines){
                            $discount =  ($pro->descuento/100) * $vnExenta;

                            $cmds .= $comandosTM->pad(25);
                            $cmds .= $comandosTM->padText("Descuento ".number_format(abs($pro->descuento), 2 ,'.','').'%', 35, 'RIGHT');
                            $cmds .= $comandosTM->padText('-'.number_format($discount, 2 ,'.',''), 9, 'LEFT');
                            $cmds .= $comandosTM->pad(8);
                            $cmds .= $comandosTM->padText(number_format($vnExenta-$discount, 2 ,'.',''), 8, 'LEFT');
                            $cmds .= comandosTM::LineFeed;

                            $numProd++;
                        }
                    }
                }
            
                //TOTALES
                $subtotalventas = $totalExento + $totalGravado + $totalIVA;
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');
                $subtotalventas = number_format(round($subtotalventas, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));
                
                while($numProd < $maxlines){
                    $cmds .= comandosTM::LineFeed;

                    $numProd++;
                }

                $cmds .= $comandosTM->pad(3);
                $cmds .= $comandosTM->padText("SON: ".substr($TotalLetras,0,49), 54, 'RIGHT');
                $cmds .= $comandosTM->pad(16);
                $cmds .= '$'.$comandosTM->padText($totalGravIva, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText(substr($TotalLetras,49,54), 54, 'RIGHT');
                $cmds .= comandosTM::LineFeed;

                if($totalExento != ""){
                    $cmds .= $comandosTM->pad(73);
                    $cmds .= '$'.$comandosTM->padText($totalExento, 12, 'LEFT');
                }
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73);
                $cmds .= '$'.$comandosTM->padText($total, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FormFeed;
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function creditoFiscalDivesaTMU($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;$cmds .= comandosTM::LineFeed;

                    ##

                    $cmds .= $comandosTM->pad(60 + 2);
                    $cmds .= $comandosTM->padText($info->nit, 25, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(60 + 2);
                    $cmds .= $comandosTM->padText(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, 25, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $clienteTXT = substr($this->eliminarTildes($info->nameCliente),0,42);
                    $cmds .= $comandosTM->pad(11 + 2);
                    $cmds .= $comandosTM->padText($clienteTXT, 41, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(13 + 2);
                    $direccion = substr($this->eliminarTildes($info->direccion),0,38);
                    $cmds .= $comandosTM->padText($direccion, 38, 'RIGHT');
                    $cmds .= $comandosTM->pad(15);
                    $cmds .= substr($this->eliminarTildes($payment),0,18);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(17 + 2);
                    $direccion = substr($this->eliminarTildes($departamento),0,32);
                    $cmds .= $comandosTM->padText($direccion, 32, 'RIGHT');
                    $cmds .= $comandosTM->pad(14);
                    $cmds .= substr($this->eliminarTildes($info->nameVendedor),0,18);
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(11 + 2);
                    $cmds .= $comandosTM->padText($info->nrc, 29, 'RIGHT');
                    $cmds .= substr($this->eliminarTildes($info->giro),0,40);

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                }

                #   PRODUCTOS
                            
                $maxlines = 21;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;

                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,35);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $cmds .= $comandosTM->pad(3+2);
                        $cmds .= $comandosTM->padText($cantidadPro, 11, 'BOTH');
                        $cmds .= $comandosTM->padText($pro->idproducto, 9, 'BOTH');
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($nombrepro, 35, 'RIGHT');
                        $cmds .= $comandosTM->padText(number_format($preciouni, 4 ,'.',''), 12, 'LEFT');
                        $cmds .= $comandosTM->padText($vnGravada.$vnExenta, 12, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;

                        if($vnGravada != "" && $vnGravada != 0 && $pro->descuento != 0 && $numProd < $maxlines){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                            $cmds .= $comandosTM->pad(25+2);
                            $cmds .= $comandosTM->padText("Descuento ".number_format(abs($pro->descuento), 2 ,'.','').'%', 35, 'RIGHT');
                            $cmds .= $comandosTM->padText('-'.number_format($discount, 4 ,'.',''), 12, 'LEFT');
                            $cmds .= $comandosTM->padText(number_format($vnGravada-$discount, 4 ,'.',''), 12, 'LEFT');
                            $cmds .= comandosTM::LineFeed;

                            $numProd++;
                        }
                    }
                }
            
                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 4), 4 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                
                while($numProd < $maxlines){
                    $cmds .= comandosTM::LineFeed;

                    $numProd++;
                }
                $cmds .= $comandosTM->pad(3+2);
                $cmds .= $comandosTM->padText("SON: ".substr($TotalLetras,0,49), 54, 'RIGHT');
                $cmds .= $comandosTM->pad(16);
                $cmds .= '$'.$comandosTM->padText($totalGravado, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(8+2);
                $cmds .= $comandosTM->padText(substr($TotalLetras,49,49), 49, 'RIGHT');
                $cmds .= $comandosTM->pad(16);
                $cmds .= '$'.$comandosTM->padText($totalIVA, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;
                
                $cmds .= $comandosTM->pad(73+2);
                $cmds .= '$'.$comandosTM->padText($totalGravIva, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                if($totalExento != ""){
                    $cmds .= $comandosTM->pad(73+2);
                    $cmds .= '$'.$comandosTM->padText($totalExento, 12, 'LEFT');
                }
                $cmds .= comandosTM::LineFeed;

                if($retencion != ""){
                    $cmds .= $comandosTM->pad(60);
                    $cmds.= $comandosTM->padText("(-) 1% RET.", 15, 'RIGHT');
                    $cmds .= '$'.$comandosTM->padText($retencion, 12, 'LEFT');
                }
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73+2);
                $cmds .= '$'.$comandosTM->padText($total, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FormFeed;
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function notaCreditoDivesaTMU($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 25));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(53);
                    $cmds .= substr('No. '.$info->numero,0,35);
                    $cmds .= comandosTM::LineFeed;

                    ##

                    $cmds .= $comandosTM->padText(date_format(date_create($info->fecha), 'd/m/Y'), 45, 'RIGHT');
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= substr($this->eliminarTildes($info->giro),0,35);
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    //
                    $clienteTXT = substr($this->eliminarTildes($info->nameCliente),0,45);

                    $cmds .= $comandosTM->padText($clienteTXT, 45, 'RIGHT');
                    $cmds .= $comandosTM->pad(8);
                    $cmds .= substr($this->eliminarTildes($info->nit),0,35);
                    $cmds .= comandosTM::LineFeed;
                    //
                    $clienteTXT = substr($this->eliminarTildes($info->nameCliente),45,45);

                    $cmds .= $comandosTM->padText($clienteTXT, 45, 'RIGHT');
                    $cmds .= $comandosTM->pad(11);
                    $cmds .= substr($this->eliminarTildes($info->nrc),0,35);
                    $cmds .= comandosTM::LineFeed;
                    //
                    $direccion = substr($this->eliminarTildes($info->direccion),0,44);

                    $cmds .= $comandosTM->pad(1);
                    $cmds .= $comandosTM->padText($direccion, 44, 'RIGHT');
                    $cmds .= $comandosTM->pad(15);
                    $cmds .= substr($this->eliminarTildes($departamento),0,31);
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    //
                    $cmds .= $comandosTM->pad(20);
                    $cmds .= $comandosTM->padText($payment, 25, 'RIGHT');

                
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::LineFeed;

                }

                #   PRODUCTOS
                            
                $maxlines = 17;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;

                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,40);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $cmds .= $comandosTM->padText($cantidadPro, 9, 'BOTH');
                        $cmds .= $comandosTM->padText($nombrepro, 40, 'RIGHT');
                        $cmds .= $comandosTM->padText(number_format($preciouni, 4 ,'.',''), 12, 'LEFT');
                        $cmds .= $comandosTM->padText($vnExenta, 12, 'LEFT');
                        $cmds .= $comandosTM->padText($vnGravada, 12, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;

                        if($vnGravada != "" && $vnGravada != 0 && $pro->descuento != 0 && $numProd < $maxlines){
                            $discount =  ($pro->descuento/100) * $vnGravada;

                            $cmds .= $comandosTM->pad(25);
                            $cmds .= $comandosTM->padText("Descuento ".number_format(abs($pro->descuento), 2 ,'.','').'%', 35, 'RIGHT');
                            $cmds .= $comandosTM->padText('-'.number_format($discount, 4 ,'.',''), 9, 'LEFT');
                            $cmds .= $comandosTM->pad(8);
                            $cmds .= $comandosTM->padText(number_format($vnGravada-$discount, 4 ,'.',''), 8, 'LEFT');
                            $cmds .= comandosTM::LineFeed;

                            $numProd++;
                        }
                    }
                }
            
                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 4), 4 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                
                while($numProd < $maxlines){
                    $cmds .= comandosTM::LineFeed;

                    $numProd++;
                }
                $cmds .= $comandosTM->padText(substr($TotalLetras,0,48), 48, 'RIGHT');
                $cmds .= $comandosTM->pad(25);
                $cmds .= '$'.$comandosTM->padText($totalGravado, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;
                $cmds .= $comandosTM->padText(substr($TotalLetras,48,48), 48, 'RIGHT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73);
                $cmds .= '$'.$comandosTM->padText($totalIVA, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73);
                $cmds .= '$'.$comandosTM->padText($totalGravIva, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                if($totalExento != ""){
                    $cmds .= $comandosTM->pad(73);
                    $cmds .= '$'.$comandosTM->padText($totalExento, 12, 'LEFT');
                }
                
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73);
                $cmds .= '$'.$comandosTM->padText($total, 12, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= comandosTM::FormFeed;
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }

        function facturaExportacionDivesaTMU($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    $cmds = comandosTM::Initialize;
                    $cmds .= comandosTM::FontSmall;
                    $cmds .= comandosTM::PrintSlip;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

                    ##
                    $clienteTXT = substr($this->eliminarTildes($info->nameCliente),0,48);
                    $cmds .= $comandosTM->pad(12);
                    $cmds .= $comandosTM->padText($clienteTXT, 48, 'RIGHT');
                    $cmds .= $comandosTM->pad(10);
                    $cmds .= date_format(date_create($info->fecha), 'd/m/Y');
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(14);
                    $direccion = substr($this->eliminarTildes($info->direccion),0,46);
                    $cmds .= $comandosTM->padText($direccion, 46, 'RIGHT');
                    $cmds .= $comandosTM->pad(7);
                    $cmds .= $info->nit;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(14);
                    $direccion = substr($this->eliminarTildes($info->direccion),46,46);
                    $cmds .= $comandosTM->padText($direccion, 46, 'RIGHT');
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                    $cmds .= $comandosTM->pad(63);
                    $cmds .= substr($this->eliminarTildes($payment),0,18);

                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;

                }

                #   PRODUCTOS
                            
                $maxlines = 21;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;

                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,42);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $cmds .= $comandosTM->pad(3);
                        $cmds .= $comandosTM->padText($cantidadPro, 11, 'BOTH');
                        $cmds .= $comandosTM->padText($pro->idproducto, 9, 'BOTH');
                        $cmds .= $comandosTM->pad(2);
                        $cmds .= $comandosTM->padText($nombrepro, 42, 'RIGHT');
                        $cmds .= $comandosTM->padText(number_format($preciouni, 4 ,'.',''), 10, 'LEFT');
                        $cmds .= $comandosTM->padText($vnExenta, 11, 'LEFT');
                        $cmds .= comandosTM::LineFeed;
                        $numProd++;

                        if($vnExenta != "" && $vnExenta != 0 && $pro->descuento != 0 && $numProd < $maxlines){
                            $discount =  ($pro->descuento/100) * $vnExenta;

                            $cmds .= $comandosTM->pad(25);
                            $cmds .= $comandosTM->padText("Descuento ".number_format(abs($pro->descuento), 2 ,'.','').'%', 42, 'RIGHT');
                            $cmds .= $comandosTM->padText('-'.number_format($discount, 4 ,'.',''), 10, 'LEFT');
                            $cmds .= $comandosTM->padText(number_format($vnExenta-$discount, 4 ,'.',''), 11, 'LEFT');
                            $cmds .= comandosTM::LineFeed;

                            $numProd++;
                        }
                    }
                }
            
                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                
                while($numProd < $maxlines){
                    $cmds .= comandosTM::LineFeed;

                    $numProd++;
                }
                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText(substr($TotalLetras,0,46), 46, 'RIGHT');
                $cmds .= $comandosTM->pad(19);
                $cmds .= $comandosTM->padText($total, 14, 'LEFT');
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(8);
                $cmds .= $comandosTM->padText(substr($TotalLetras,46,46), 46, 'RIGHT');
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;
                $cmds .= comandosTM::LineFeed;

                $cmds .= $comandosTM->pad(73);
                $cmds .= $comandosTM->padText($total, 14, 'LEFT');

                $cmds .= comandosTM::FormFeed;
                $this->ventas_model->setCommandsPrint($trannum, $cmds);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=1&tipoImpresion=2&printerName='.$printerName.'&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
            }
        }
        

        //      LX300
        function facturaConsumidorFinalDivesaLXOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 15));
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Factura');
                $pdf->SetMargins(4, 10, 84, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $pdf->SetXY( 92, 43);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    //
                    $pdf->SetXY( 17, 56 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 104, 57 );
                    $pdf->writeHTML($payment, true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,36), true, false, true, false, '');

                    $pdf->SetXY( 97, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->nameVendedor),0,20), true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 66 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),36,36), true, false, true, false, '');
                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%;">';      
                            
                $maxlines = 18;
                $maxcaracteres = 30;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   
                        $nombrepro = strtoupper(trim($pro->descrip))." ".$notas;

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        //PRODUCTO EXENTO CON DESCUENTO
                        if($pro->descuento  != 0 && $vnExenta != 0 && $vnExenta != ""){
                            $preciouni = $pro->preciotran;
                            $vnExenta = $preciouni * abs($pro->cantidad);
                            $discount =  ($pro->descuento/100) * $vnExenta;

                            $vnExenta = number_format($vnExenta, 2, '.', '');
                            $preciouni = number_format(abs($preciouni), 2 ,'.','');
                        }

                        $tablaProductos .= '<tr style="line-height: 5mm">';
                        $tablaProductos .= '<td style="width:14%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: center;">'.$pro->idproducto.'</td>';
                        $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right; font-size: 8px;">'.number_format($preciouni, 2 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:8%; text-align: right; font-size: 8px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                $numProd++;
                            }  
                        }
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 6, 78 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != "") {
                    $subtotal = $subtotal + $totalExento;
                }

                $total = $subtotal;

                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 10, 175 );
                $pdf->writeHTML('SON: '.substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 10, 178 );
                $pdf->writeHTML(substr($TotalLetras,40,43), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 4.5mm; " ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 4.5mm; "';

                $tablaTotales ='<table style="width: 100%">';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                if($totalExento != ""){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }

                
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 106, 175 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        function facturaConsumidorFinalDivesaLX($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 15));
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Factura');
                $pdf->SetMargins(4, 10, 84, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $pdf->SetXY( 92, 43);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    //
                    $pdf->SetXY( 17, 56 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 104, 57 );
                    $pdf->writeHTML($payment, true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,36), true, false, true, false, '');

                    $pdf->SetXY( 97, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->nameVendedor),0,20), true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 66 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),36,36), true, false, true, false, '');
                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%;">';      
                            
                $maxlines = 18;
                $maxcaracteres = 30;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   
                        $nombrepro = strtoupper(trim($pro->descrip))." ".$notas;

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $preciouni = $pro->preciotran;

                        //PRODUCTO EXENTO
                        if($vnExenta != 0 && $vnExenta != ""){
                            $preciouni = $pro->precioneto;
                        }

                        //PRODUCTO EXENTO CON DESCUENTO
                        if($pro->descuento  != 0 && $vnExenta != 0 && $vnExenta != ""){
                            $preciouni = $pro->preciotran;
                            $vnExenta = $preciouni * abs($pro->cantidad);
                            $discount =  ($pro->descuento/100) * $vnExenta;

                            $vnExenta = number_format($vnExenta, 2, '.', '');
                            $preciouni = number_format(abs($preciouni), 2 ,'.','');
                        }

                        $tablaProductos .= '<tr style="line-height: 5mm">';
                        $tablaProductos .= '<td style="width:14%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: center;">'.$pro->idproducto.'</td>';
                        $tablaProductos .= '<td style="width:43.5%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10.5%; text-align: right; font-size: 8px;">'.number_format($preciouni, 2 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:8%; text-align: right; font-size: 8px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: right; font-size: 8px;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 43.5%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10.5%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%; font-size: 8px;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 43.5%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10.5%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%; font-size: 8px;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                $numProd++;
                            }  
                        }
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 6, 78 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != "") {
                    $subtotal = $subtotal + $totalExento;
                }

                $total = $subtotal;

                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 10, 175 );
                $pdf->writeHTML('SON: '.substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 10, 178 );
                $pdf->writeHTML(substr($TotalLetras,40,43), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 4.5mm; " ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 4.5mm; "';

                $tablaTotales ='<table style="width: 100%">';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                if($totalExento != ""){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }

                
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 106, 175 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        function facturaNoSujeta($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');                
                $comandosTM = new comandosTM();

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 15));
                }

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Factura');
                $pdf->SetMargins(4, 10, 84, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                #   INFORMACION
                foreach($informacion as $info){
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }
                    $pdf->SetXY( 92, 43);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    //
                    $pdf->SetXY( 17, 56 );
                    $pdf->writeHTML(substr(strtoupper($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 104, 57 );
                    $pdf->writeHTML($payment, true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),0,36), true, false, true, false, '');

                    $pdf->SetXY( 97, 61 );
                    $pdf->writeHTML(substr(strtoupper($info->nameVendedor),0,20), true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 66 );
                    $pdf->writeHTML(substr(strtoupper($info->direccion),36,36), true, false, true, false, '');
                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%;">';      
                            
                $maxlines = 18;
                $maxcaracteres = 30;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->preciotran * abs($pro->cantidad), 2), 2 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->preciotran;

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   
                        $nombrepro = strtoupper(trim($pro->descrip))." ".$notas;

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        //PRODUCTO EXENTO CON DESCUENTO
                        if($pro->descuento  != 0 && $vnExenta != 0 && $vnExenta != ""){
                            $preciouni = $pro->preciotran;
                            $vnExenta = $preciouni * abs($pro->cantidad);
                            $discount =  ($pro->descuento/100) * $vnExenta;

                            $vnExenta = number_format($vnExenta, 2, '.', '');
                            $preciouni = number_format(abs($preciouni), 2 ,'.','');
                        }

                        $tablaProductos .= '<tr style="line-height: 5mm">';
                        $tablaProductos .= '<td style="width:14%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: center;">'.$pro->idproducto.'</td>';
                        $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right; font-size: 8px;">'.number_format($preciouni, 2 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:8%; text-align: right; font-size: 8px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%;font-size: 8px;">-'.number_format(abs($discount), 2 , '.','').'</td>
                                        <td style="text-align: right; width: 8%;"></td>
                                        <td style="text-align: rignt; width: 12%;">'.number_format(abs($gravadoDescuento), 2 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                $numProd++;
                            }  
                        }
                    }
                }

                $tablaProductos .= '</table>';

                $pdf->SetXY( 6, 78 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 2), 2,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 2), 2 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;

                if($totalExento != "") {
                    $subtotal = $subtotal + $totalExento;
                }

                $total = $subtotal;

                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                $total = number_format(round($total, 2), 2 ,'.','');
                $subtotal = number_format(round($subtotal, 2), 2 ,'.','');

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 2), 2 ,'.','');
                $totalIVA= number_format(round($totalIVA, 2), 2 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 2), 2 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 10, 175 );
                $pdf->writeHTML('SON: '.substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 10, 178 );
                $pdf->writeHTML(substr($TotalLetras,40,43), true, false, true, false, '');

                $estiloTotal = 'style="width: 75%; text-align: right; line-height: 4.5mm; " ';
                $estiloDolar = 'style="width: 25%; text-align: right; line-height: 4.5mm; "';

                $tablaTotales ='<table style="width: 100%">';
                if($totalGravIva != "0.00"){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }

                if($totalExento != ""){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 106, 175 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function creditoFiscalDivesaLX($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Crédito Fiscal');
                $pdf->SetMargins(6, 10, 84, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    ##
                    $pdf->SetXY( 94, 33);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y').' No. '.$info->numero, true, false, true, false, '');

                    $pdf->SetXY( 90, 38);
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    $pdf->SetXY( 20, 47);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nameCliente),0,42), true, false, true, false, '');

                    $pdf->SetXY( 21, 50);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->direccion),0,38), true, false, true, false, '');
                    
                    $pdf->SetXY( 105, 50);
                    $pdf->writeHTML(substr($this->eliminarTildes($payment),0,18), true, false, true, false, '');

                    $pdf->SetXY( 32, 55);
                    $pdf->writeHTML(substr($this->eliminarTildes($departamento),0,32), true, false, true, false, '');

                    $pdf->SetXY( 98, 55);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nameVendedor),0,18), true, false, true, false, '');

                    $pdf->SetXY( 20, 59);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nrc),0,40), true, false, true, false, '');

                    $pdf->SetXY( 63, 59);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->giro),0,40), true, false, true, false, '');

                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%; padding: 0">';      

                $maxlines = 18;                 $maxcaracteres = 32;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                //var_dump($productos);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;


                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        if($pro->notas != ""){
                            $notas = strtoupper(trim($pro->notas));
                        }else{
                            $notas = "";
                        }   


                        if($pro->tipo == "4"){
                            $idpro = "";                       

                            $nombrepro = strtoupper(trim($notas));                       

                        }else{
                            $idpro = $pro->idproducto;   
                            $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                    
                        } 
                          

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 5mm">';
                        $tablaProductos .= '<td style="width:13%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: center;">'.$idpro.'</td>';
                        $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;">'.number_format($preciouni, 4 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if((strlen($nombrepro) > $maxcaracteres) && ($numProd < $maxlines)){
                            $tablaProductos .= '<tr style="line-height: 5mm">';
                            $tablaProductos .= '<td style="width:13%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:12%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,$maxcaracteres,$maxcaracteres).'</td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '</tr>';

                            $numProd++;
                        }

                        if((strlen($nombrepro) > $maxcaracteres * 2) && ($numProd < $maxlines)){
                            $tablaProductos .= '<tr style="line-height: 5mm">';
                            $tablaProductos .= '<td style="width:13%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:12%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,$maxcaracteres*2,$maxcaracteres).'</td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '</tr>';

                            $numProd++;
                        }

                        if((strlen($nombrepro) > $maxcaracteres * 3) && ($numProd < $maxlines)){
                            $tablaProductos .= '<tr style="line-height: 5mm">';
                            $tablaProductos .= '<td style="width:13%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:12%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,$maxcaracteres*3,$maxcaracteres).'</td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '</tr>';

                            $numProd++;
                        }

                        if((strlen($nombrepro) > $maxcaracteres * 4) && ($numProd < $maxlines)){
                            $tablaProductos .= '<tr style="line-height: 5mm">';
                            $tablaProductos .= '<td style="width:13%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:12%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,$maxcaracteres*4,$maxcaracteres).'</td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '</tr>';

                            $numProd++;
                        }

                        if((strlen($nombrepro) > $maxcaracteres * 5) && ($numProd < $maxlines)){
                            $tablaProductos .= '<tr style="line-height: 5mm">';
                            $tablaProductos .= '<td style="width:13%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:12%; text-align: center;"></td>';
                            $tablaProductos .= '<td style="width:44%; text-align: left;">'.substr($nombrepro,$maxcaracteres*5,$maxcaracteres).'</td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:9%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '<td style="width:11%; text-align: right; font-size: 8px;"></td>';
                            $tablaProductos .= '</tr>';

                            $numProd++;
                        }

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 13%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 11%;font-size: 8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: right; width: 9%;"></td>
                                        <td style="text-align: rignt; width: 11%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 13%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 11%;font-size: 8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: right; width: 9%;"></td>
                                        <td style="text-align: rignt; width: 11%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                $numProd++;
                            }  
                        }
                    }
                }
            
                $tablaProductos .= '</table>';

                $pdf->SetXY( 8, 67 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 4), 4 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 10, 160 );
                $pdf->writeHTML('SON: '.substr($TotalLetras,0,40), true, false, true, false, '');

                $pdf->SetXY( 10, 164 );
                $pdf->writeHTML(substr($TotalLetras,40,43), true, false, true, false, '');

                $pdf->SetXY( 10, 168 );
                $pdf->writeHTML(substr($TotalLetras,83,43), true, false, true, false, '');

                $estiloTotal = 'style="width: 80%; text-align: right; line-height: 4mm; " ';
                $estiloDolar = 'style="width: 20%; text-align: right; line-height: 4mm; "';

                $tablaTotales ='<table style="width: 100%; padding: 0">';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                if($totalExento != ""){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }

                if($retencion != ""){
                    $pdf->SetXY( 103, 180 );
                    $pdf->writeHTML("RET", true, false, true, false, '');
                    $tablaTotales .= '<tr><td '.$estiloDolar.'>-$</td><td '.$estiloTotal.'>'.$retencion.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }
                $estiloTotal = 'style="width: 80%; text-align: right; line-height: 4.2mm; " ';
                $estiloDolar = 'style="width: 20%; text-align: right; line-height: 4.2mm; "';
                $tablaTotales .= '<tr><td '.$estiloDolar.'>$</td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 108, 159.5 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Credito_Fiscal_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function notaCreditoDivesaLX($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Nota de Crédito');
                $pdf->SetMargins(7, 10, 65, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 20));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    ##
                    $pdf->SetXY( 100, 49);
                    $pdf->writeHTML('No. '.$info->numero, true, false, true, false, '');

                    $pdf->SetXY( 18, 55);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');

                    $pdf->SetXY( 100, 55);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->giro),0,30), true, false, true, false, '');

                    //
                    $pdf->SetXY( 19, 61);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 100, 61);
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //
                    $pdf->SetXY( 19, 67);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nameCliente),40,40), true, false, true, false, '');

                    $pdf->SetXY( 101, 67);
                    $pdf->writeHTML($info->nrc, true, false, true, false, '');

                    //
                    $pdf->SetXY( 23, 72);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->direccion),0,38), true, false, true, false, '');
                    
                    $pdf->SetXY( 114, 72);
                    $pdf->writeHTML(substr($this->eliminarTildes($departamento),0,32), true, false, true, false, '');

                    //
                    $pdf->SetXY( 48, 78);
                    $pdf->writeHTML(substr($this->eliminarTildes($payment),0,20), true, false, true, false, '');

                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%; padding: 0px; padding-right: 3px;">';      

                $maxlines = 13;                 
                $maxcaracteres = 50;

                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;

                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,35);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 5.5mm">';
                        $tablaProductos .= '<td style="width:9%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:52%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right;">'.number_format($preciouni, 4 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: right;">'.$vnExenta.'</td>';
                        $tablaProductos .= '<td style="width:14%; text-align: right;">'.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5.5mm">
                                        <td style="width: 13%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 11%;font-size: 8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: right; width: 9%;"></td>
                                        <td style="text-align: rignt; width: 11%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5.5mm">
                                        <td style="width: 13%;"></td>
                                        <td style="width: 44%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 11%;font-size: 8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: right; width: 9%;"></td>
                                        <td style="text-align: rignt; width: 11%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';

                                }
                                $numProd++;
                            }  
                        }
                    }
                }
            
                $tablaProductos .= '</table>';

                $pdf->SetXY( 7, 99 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                $pdf->SetXY( 17, 172 );
                $pdf->writeHTML(substr($TotalLetras,0,45), true, false, true, false, '');

                $pdf->SetXY( 17, 177 );
                $pdf->writeHTML(substr($TotalLetras,45,45), true, false, true, false, '');

                $estiloTotal = 'style="width: 80%; text-align: right; line-height: 6mm; " ';
                $estiloDolar = 'style="width: 20%; text-align: right; line-height: 6mm; "';

                $tablaTotales ='<table style="width: 100%; padding: 0; padding-right: 3px;">';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$totalGravado.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$totalIVA.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$totalGravIva.'</td></tr>';
                if($totalExento != ""){
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$totalExento.'</td></tr>';
                }else{
                    $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                }
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 108, 172 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('Factura_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaExportacionDivesaLX($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('global_model');   $this->load->model('ventas_model');
                $this->load->model('invtran_model');  $this->load->model('acs_model');
                $this->load->model('empleado_model'); $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model'); $this->load->model('caja_model');               

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('DIVESA');
                $pdf->SetSubject('Factura de Exportación');
                $pdf->SetMargins(6, 10, 84, true);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 8, '', true);
                $pdf->addPage('P', 'LETTER');

                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $efectivo = $this->ventas_model->verificaPagoEfectivo($trannum);
                $detailPagos = $this->ventas_model->getTipoPagoRealiVentaCredito($trannum);
                foreach($detailPagos as $dtpagos){
                    $payment = strtoupper(substr($dtpagos->descrip, 0, 18));
                }

                foreach($informacion as $info){  
                    $departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
                    $idClase = $info->idclase;
                    $tipocliente = $info->idtipo;
                    $idcaja = $info->idcaja;
                    $datoscaja = $this->caja_model->getNameCaja($idcaja);
                    $idcentro = $info->idcentro;
                    $namecentro = $this->sucursal_model->getNameCentro($idcentro);

                    foreach($datoscaja as $caja){    
                        $printerName = $caja->notas;
                    }

                    foreach($departamentoMunicipio as $info_dm){
                        $departamento = trim($info_dm->depto);
                        $municipio = trim($info_dm->municipio);
                    }

                    ##
                    
                    //

                    $pdf->SetXY( 18, 45);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->nameCliente),0,40), true, false, true, false, '');

                    $pdf->SetXY( 108, 45);
                    $pdf->writeHTML(date_format(date_create($info->fecha), 'd/m/Y'), true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 50);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->direccion),0,40), true, false, true, false, '');

                    $pdf->SetXY( 100, 50);
                    $pdf->writeHTML($info->nit, true, false, true, false, '');

                    //
                    $pdf->SetXY( 21, 55);
                    $pdf->writeHTML(substr($this->eliminarTildes($info->direccion),40,40), true, false, true, false, '');

                    //
                    $pdf->SetXY( 95, 62);
                    $pdf->writeHTML(substr($this->eliminarTildes($payment),0,18), true, false, true, false, '');

                }

                #   PRODUCTOS
                $tablaProductos = '<table style="width: 100%; padding: 0">';      

                $maxlines = 18;
                $maxcaracteres = 37;
                $productos = $this->invtran_model->getDataTran100k($trannum);
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $ivaCesc = 0; $cesc = 0; 
                $lineasOcupa = 0;
                //$this->highlight_array($informacion);
                foreach($productos as $pro){
                    if($numProd < $maxlines){
                        if($pro->tax1 != 0 && $invexento == 0){

                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            
                            $vnExenta = "";
                            //$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
                            $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        }else if($pro->tax1 != 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1== 0 && $invexento == 0){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }else if($pro->tax1 == 0 && $invexento == 1){
                            
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

                            $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                            $vnGravada = "";
                            
                        }
                        $ivaSepa = 1+($pro->tax1/100);
                        $preciouni = $pro->precioneto;

                        $nombrepro = strtoupper(trim($this->eliminarTildes($pro->descrip)));
                        $nombrepro = substr($nombrepro,0,42);

                        $modelopro = strtoupper(trim($this->eliminarTildes($pro->modelo)));
                        $modelopro = substr($modelopro,0,8);

                        $sumacantidad = (number_format(abs($pro->cantidad), 2 ,'.','') - number_format(abs($pro->cantidad), 0 ,'.',''));
                        if($sumacantidad>0) $cantidadPro = number_format(abs($pro->cantidad), 2 ,'.','');    
                        else $cantidadPro = number_format(abs($pro->cantidad), 0 ,'.','');

                        $tablaProductos .= '<tr style="line-height: 5mm">';
                        $tablaProductos .= '<td style="width:14%; text-align: center;">'.$cantidadPro.'</td>';
                        $tablaProductos .= '<td style="width:12%; text-align: center;">'.$pro->idproducto.'</td>';
                        $tablaProductos .= '<td style="width:51%; text-align: left;">'.substr($nombrepro,0,$maxcaracteres).'</td>';
                        $tablaProductos .= '<td style="width:10%; text-align: right;  font-size:8px;">'.number_format($preciouni, 4 ,'.','').'</td>';
                        $tablaProductos .= '<td style="width:13%; text-align: right; ">'.$vnExenta.$vnGravada.'</td>';
                        $tablaProductos .= '</tr>';
                    
                        $numProd++;

                        if($pro->descuento != 0){
                            if($numProd < $maxlines){
                                if($vnGravada != 0 && $vnGravada != ""){
                                    $discount =  ($pro->descuento/100) * $vnGravada;
                                    $gravadoDescuento = $vnGravada - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 51%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%; font-size:8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: rignt; width: 13%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';
                                }
                                if($vnExenta != 0 && $vnExenta != ""){
                                    $discount =  ($pro->descuento/100) * $vnExenta;
                                    $gravadoDescuento = $vnExenta - $discount;

                                    //$totalDescuento += $discount;
                                    $tablaProductos .= '
                                    <tr style="line-height: 5mm">
                                        <td style="width: 14%;"></td>
                                        <td style="width: 12%;"></td>
                                        <td style="width: 51%; text-align: right;">Descuento '.number_format($pro->descuento, 0 ,'','').'%</td>
                                        <td style="text-align: right; width: 10%; font-size:8px;">-'.number_format(abs($discount), 4 , '.','').'</td>
                                        <td style="text-align: rignt; width: 13%;">'.number_format(abs($gravadoDescuento), 4 , '.','').'</td>
                                    </tr>
                                    ';
                                }
                                $numProd++;
                            }  
                        }
                    }
                }
                $tablaProductos .= '</table>';

                $pdf->SetXY( 3, 82 );
                $pdf->writeHTML($tablaProductos, true, false, true, false, '');

                //TOTALES
                if($totalExento == 0) $totalExento = "";	
                else $totalExento = number_format(round($totalExento, 4), 4,'.','');
                
                if(($tipocliente==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                } else $retencion = 0;
                    
                if($retencion == 0) $retencion = "";    
                else { 
                    $retencion = abs(number_format(round($retencion, 4), 4 ,'.',''));
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = strtoupper(trim($this->valorEnLetras($numero)))/*.'/DOLARES'*/;
                $totalGravIva = $totalGravado + $totalIVA;

                $subtotal = $totalGravado + $totalIVA;
                $total = $subtotal;
                if($retencion != "") {
                    $total = $subtotal - $retencion;
                    $retencion= number_format(round($retencion, 2), 2 ,'.','');
                }

                if($totalExento != "") {
                    $total = $total + $totalExento;
                }
                
                $total = number_format(round($total, 4), 4 ,'.','');
                $subtotal = number_format(round($subtotal, 4), 4 ,'.','');

                $numero = number_format(round($total, 4), 4 ,'.','');
                $TotalLetras = trim($this->valorEnLetras($numero));
                $totalGravado= number_format(round($totalGravado, 4), 4 ,'.','');
                $totalIVA= number_format(round($totalIVA, 4), 4 ,'.','');
                $totalGravIva = number_format(round($totalGravIva, 4), 4 ,'.','');


                $total = number_format($total, 2 ,'.','');	
                $TotalLetras = strtoupper(trim($this->valorEnLetras($total)));

                
                $pdf->SetXY( 10, 172 );
                $pdf->writeHTML(substr($TotalLetras,0,43), true, false, true, false, '');

                $pdf->SetXY( 10, 178 );
                $pdf->writeHTML(substr($TotalLetras,43,43), true, false, true, false, '');

                $estiloTotal = 'style="width: 80%; text-align: right; line-height: 4.2mm; " ';
                $estiloDolar = 'style="width: 20%; text-align: right; line-height: 4.2mm; "';

                $tablaTotales ='<table style="width: 100%; padding: 0">';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$total.'</td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'></td></tr>';
                $tablaTotales .= '<tr><td '.$estiloDolar.'></td><td '.$estiloTotal.'>'.$total.'</td></tr>';

                $tablaTotales .='</table>';
                $pdf->SetXY( 108, 172 );
                $pdf->writeHTML($tablaTotales, true, false, true, false, '');


                // --- GENERACION DE PDF --- //

                $nombre_archivo = utf8_decode('FacturaExportacion_'.$trannum.'.pdf');
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function facturaConsumidorFinalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaConsumidorFinalDTE/' . $trannum);
            }
        }

        function comprobanteCreditoFiscalDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/comprobanteCreditoFiscalDTE/' . $trannum);
            }
        }

        function facturaDeExportacionDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/facturaDeExportacionDTE/' . $trannum);
            }
        }

        function notaDeCreditoDTE($trannum)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/notaDeCreditoDTE/' . $trannum);
            }
        }

        function notaDeRemisionDTE($trannum, $opcion = 0)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/notaDeRemisionDTE/' . $trannum .'/'. $opcion);
            }
        }

        function notaDeRemisionDTETraslados($trannum, $opcion = 1)
        {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) {
                redirect('login/cerrar_sesion');
            } else {
                redirect(base_url() . 'dte/notaDeRemisionDTE/' . $trannum .'/'. $opcion);
            }
        }

        

		//Reportes----------------------------------------------------------------------------------------------------------------------------

		function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
				}
				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:20%;"></td>
									<td style="font-size:15px; text-align:center;width:80%;">'.strtoupper($nombreFormato).'</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
                    
                $header .= '
                <table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:'.$background_color.'; width:37.5%; font-weight: bold; border: 1px solid '.$background_color.';" > Origen</td>
						<td style="font-size:12px; text-align:left; background-color:'.$background_color.'; width:37.5%; font-weight: bold; border: 1px solid '.$background_color.';" > Destino</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:25%; font-weight: bold; border: 1px solid '.$background_color.';" colspan="2"> Datos de Orden</td>
					</tr>
				</table>';
                $header .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-top: 1px solid '.$background_color.';" rowspan="2"> '.$data->centrocd.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-top: 1px solid '.$background_color.';" rowspan="2"> '.$data->idcentrod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> N°:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$data->trannum.'</td>
					</tr>
                    <tr>
						<td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> Fecha:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$date_emision.'</td>
					</tr>
                    <tr>
                        <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-bottom: 1px solid '.$background_color.';"> '.$data->encargadoinv.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid '.$background_color.';border-bottom: 1px solid '.$background_color.';"> '.$data->encargadod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid '.$background_color.'; background-color:'.$background_color.';"> Estado:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid '.$background_color.';"> '.$estado.'</td>
					</tr>
                    </table>';
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#2675a3;">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #2675a3; border-top: 1px solid #2675a3;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:'.$background_color.';">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #2675a3;  width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:'.$background_color.'; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:'.$background_color.'; width:59%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:'.$background_color.'; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                                        <th style="background-color:'.$background_color.'; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:'.$background_color.'; width:9%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                        <th style="background-color:'.$background_color.';border-right: 1px solid #2675a3; width:1%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:'.$background_color.';">
                                        <th style="background-color:'.$background_color.';border-left: 1px solid #6E6E6E; border-bottom: 1px solid #2675a3;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  1px solid '.$background_color.'; ">
                                <td style="width:5%; border-left: 1px solid '.$background_color.';  text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:6%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:59%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:9%; text-align:center; font-size:10px;  border-bottom:solid 1px black;"></td>
                                <td style="width:1%;border-right: 1px solid #2675a3;  text-align:center; font-size:10px;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='
                    <tr><td style="font-size:5px; width:100%;border-left:1px solid #2675a3;border-right:1px solid #2675a3;"></td></tr>
                    
                    <tr style="border:1px solid #2675a3; font-size:12px;">
                        <td style="width:5%;border-top:1px solid #2675a3;border-bottom:1px solid '.$background_color.';border-left:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="width:75%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(number_format(round($totalcant, 2),2)).'</strong></td>
                        <td style="width:10%;border-top:1px solid '.$background_color.';border-bottom:1px solid '.$background_color.';border-right:1px solid '.$background_color.';text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                     $titulo .= '
                      <table>
                    <tr>
				        <td style="width:100%;"><br><br></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Entregado por</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Recibido por</td>
						<td style="font-size:12px; text-align:center; background-color:'.$background_color.'; width:33.3%;bold; border: 1px solid '.$background_color.';">Fecha y hora</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid '.$background_color.';"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function reporteDetalleComponentes(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Detalle de Componentes');
                $pdf->SetSubject('Detalle de Componentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('produccion_model'); $this->load->model('global_model');
				$this->load->model('variable_model'); $this->load->model('pedclientes_model');
				
                $funcion = $this->uri->segment(3);
				$info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $name = $this->pedclientes_model->getnameImg();
				$nombreFormato = $this->global_model->getFormatosNombre($funcion);
				
				$infoLineas = $this->produccion_model->getListadoLineasCombos(4);
				
				foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
				}

				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
				
				$estructura = '<style> .fondo{ background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center; } </style>';
				
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px; margin:0px; width:80%;">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>'.strtoupper($nombreFormato).'</b></td>
								</tr>
							</table>
						</td>
						<td style="padding:0px; margin:0px; width:20%;">
							<img style="text-align:right; width:200px; height:90px;margin-top:-20px; margin-bottom:0px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
						</td>
                    </tr>
				</table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
				$pdf->addPage('P', 'LETTER');
				
				foreach($infoLineas as $infLin){
					$infoProductos = $this->produccion_model->getListadoProductosConComponentes($infLin->idcatalogo);
					$estructura .= '
					<table style="width:100%;">
						<tr>
							<td style="border:1px solid #000; background-color:#000; color:#FFF; font-weight:bold; padding:0px; margin:0px; width:100%; font-size:14px;">'.strtoupper($infLin->descrip).'</td>
						</tr>
					</table>';
					
					foreach($infoProductos as $infPro){
						$estructura .= '
						<table style="width:100%;">
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; padding:0px; margin:0px; width:10%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->idproducto.'</td>
								<td style="padding:0px; margin:0px; width:50%; font-size:11px; font-weight:bold;">'.$infPro->descrip.'</td>
								<td style="padding:0px; margin:0px; width:15%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->um.'</td>
								<td style="padding:0px; margin:0px; width:15%; font-size:12px; font-weight:bold; text-align:center;">'.$infPro->modelo.'</td>
								<td style="border-right:1px solid #000; padding:0px; margin:0px; width:10%; font-size:12px; font-weight:bold; text-align:center;">$'.number_format($infPro->precioventa, 2, '.', '').'</td>
							</tr>
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
						</table>';

						$infoCProductos = $this->produccion_model->getListadoCProductos($infPro->idproducto);

						foreach($infoCProductos as $infCP){
							if($infCP->ptipo == 4){
								$comentTipo = '<b style="color:red; font-size:12px;">*</b>';
							}else{
								$comentTipo = '';
							}
							$estructura .= '
							<table style="width:100%;">
								<tr style="width:100%;">
									<td style="border-left:1px solid #000; padding:0px; margin:0px; width:10%; font-size:11px; text-align:center;">'.$infCP->idproducto.'</td>
									<td style="padding:0px; margin:0px; width:35%; font-size:10px;">'.$infCP->descrip.' '.$comentTipo.'</td>
									<td style="padding:0px; margin:0px; width: 5%; font-size:10px; text-align:center;">'.number_format($infCP->uniconv, 2, '.', '').'</td>
									<td style="padding:0px; margin:0px; width:10%; font-size:11px; text-align:center;">'.$infCP->um.'</td>
									<td style="padding:0px; margin:0px; width:15%; font-size:11px; text-align:center;">'.$infCP->modelo.'</td>
									<td style="border-right:1px solid #000; padding:0px; margin:0px; width:25%; font-size:11px; text-align:center;">'.$infCP->tipo.'</td>
								</tr>
							</table>';
						}

						$estructura .= '
						<table style="width:100%;">
							<tr style="width:100%;">
								<td style="border-left:1px solid #000; border-bottom:1px solid #000; border-right:1px solid #000; padding:0px; margin:0px; width:100%; font-size:5px; text-align:center;"></td>
							</tr>
						</table>';
					}

					$estructura .= '<br><br>';
				}
                                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("ReporteComponentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function reporteDetalleComponentes2(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Detalle de Componentes');
                $pdf->SetSubject('Detalle de Componentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('produccion_model'); $this->load->model('global_model');
				$this->load->model('variable_model'); $this->load->model('pedclientes_model');
				
                $funcion = $this->uri->segment(3);
				$info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $name = $this->pedclientes_model->getnameImg();
				$nombreFormato = $this->global_model->getFormatosNombre($funcion);
												
				foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
				}

				$background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
				
				$estructura = '<style> .fondo{ background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center; } </style>';
				
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px; margin:0px; width:80%;">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold;">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>'.strtoupper($nombreFormato).'</b></td>
								</tr>
							</table>
						</td>
						<td style="padding:0px; margin:0px; width:20%;">
							<img style="text-align:right; width:200px; height:90px;margin-top:-20px; margin-bottom:0px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
						</td>
                    </tr>
				</table>';

				$estructura .= '<table id="ContentPlaceHolder1_TPensum" class="table table-bordered">
				<tbody><tr>
					<td class="otra">Nivel</td>
					<td colspan="6" class="PCell"></td>
				</tr>
				<tr>
					<td align="center">1</td>
					<td align="center"><table id="ContentPlaceHolder1_CAD501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">CAD501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Diferencial</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_COE201" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">COE201</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Comunicación Oral y Escrita</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PRE104" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">PRE104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación Estructurada</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_QUG501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">QUG501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Química General</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">2</td>
					<td align="center"><table id="ContentPlaceHolder1_AVM501" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">AVM501</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Álgebra Vectorial y Matrices</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CAI501" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">CAI501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Integral</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAD501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CDP501" name="N" class="PD" >
						<tbody><tr>
							<td class="PCell">CDP501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cinemática y Dinámica de Partículas</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAD501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_MDB104" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">MDB104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Modelamiento y Diseño de Base de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_POO104" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">POO104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación Orientada a Objetos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">3</td>
					<td align="center"><table id="ContentPlaceHolder1_ADS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ADS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis y Diseño de Sistemas Informáticos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104, POO104</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_CVV501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">CVV501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo de Varias Variables</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AVM501, CAI501</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ESA501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ESA501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Estadística Aplicada</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_EYM501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">EYM501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Electricidad y Magnetismo</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501, CDP501, QUG501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PED104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">PED104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Programación con Estructuras de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">POO104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">4</td>
					<td align="center"><table id="ContentPlaceHolder1_CAA501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">CAA501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Cálculo Avanzado</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CVV501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DMD104" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">DMD104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Datawarehouse y Minería de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_EDI501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">EDI501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Ecuaciones Diferenciales</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CVV501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_LIC104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">LIC104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Lenguajes Interpretados en el Cliente</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">MDB104, POO104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_OFC501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">OFC501</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Oscilaciones, Fluidos y Calor</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">CAI501, CDP501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">5</td>
					<td align="center"><table id="ContentPlaceHolder1_ACE102" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ACE102</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis de Circuitos Eléctricos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">EYM501</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ACO101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ACO101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Arquitectura de Computadoras</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">EYM501, PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_AEE106" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AEE106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Análisis y Evaluación Económica</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ESA501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ANF231" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">ANF231</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Antropología Filosófica</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_GEA106" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">GEA106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Gestión Ambiental</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">QUG501</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">6</td>
					<td align="center"><table id="ContentPlaceHolder1_DDP106" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DDP106</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Dirección de Proyectos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AEE106, GEA106</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DRD101" name="N" class="PD">
						<tbody><tr>
							<td class="PCell">DRD101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño de Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_PSC231" name="N" class="PA">
						<tbody><tr>
							<td class="PCell">PSC231</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Pensamiento Social y Cristiano</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">Bachillerato</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SIO104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">SIO104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Sistemas Operativos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ACO101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">7</td>
					<td align="center"><table id="ContentPlaceHolder1_AMN501" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AMN501</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Aplicación de Métodos Numéricos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ACE102, EDI501, PRE104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_IRD101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">IRD101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Interconexión de Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_ISO104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ISO104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Ingeniería de Software</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ADS104, DDP106</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_LIS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">LIS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Lenguajes Interpretados en el Servidor</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">LIC104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">8</td>
					<td align="center"><table id="ContentPlaceHolder1_AYC104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AYC104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Autómatas y Compiladores</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">AMN501, PED104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DPS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DPS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño y Programación de Software Multiplataforma</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DMD104, PED104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSS101" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSS101</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Diseño de Sist. de Seg. p/ Redes de Datos</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_GCS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">GCS104</td>
							<td class="PCell">3</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Gestión de la Calidad del Software</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">9</td>
					<td align="center"><table id="ContentPlaceHolder1_ASR104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ASR104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Adm. e Implem. de Serv. de Red con Sist. Oper. Propietarios</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSM104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSM104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Desarrollo de Software para Móviles</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DPS104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_NTI104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">NTI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Normalización de Tecnologías de la Información</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SGC104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">SGC104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Sem de Gestión del Conoc. /Ing. en CC de Comput.</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SSI104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">SSI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Seguridad Informática</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_STI104" name="TEC01" class="PP">
						<tbody><tr>
							<td class="PCell">STI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Gobierno de TI</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">UV</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
				<tr>
					<td align="center">10</td>
					<td align="center"><table id="ContentPlaceHolder1_ASI104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">ASI104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Admin. e Impl. Serv. de Red con Sist. Operativos Libres</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DRD101, IRD101</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_AUS104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">AUS104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Auditoría de Sistemas</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">ISO104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_DSE104" name="N" class="PP">
						<tbody><tr>
							<td class="PCell">DSE104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Desarrollo de Software Empresarial</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">DMD104, LIS104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table>
					</table>
					</td>
					<td align="center"><table id="ContentPlaceHolder1_SCN104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SCN104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Gestión de la Continuidad del Negocio</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">STI104</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SGA104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SGA104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Aplicación del Conocimiento para Ingeniería en CC de la Computación</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">SGC104</td>
						</tr>
						<tr>
							<td colspan="2" class="PLab">Laboratorio: $47.00</td>
						</tr>
					</tbody></table>
					<table id="ContentPlaceHolder1_SIN104" name="TEC02" class="PP">
						<tbody><tr>
							<td class="PCell">SIN104</td>
							<td class="PCell">4</td>
						</tr>
						<tr>
							<td colspan="2" class="PCell"><strong>Seminario de Inteligencia de Negocios</strong></td>
						</tr>
						<tr>
							<td colspan="2" class="PCell">SSI104</td>
						</tr>
					</tbody></table>
					</td>
					<td align="center"></td>
					<td align="center"></td>
				</tr>
			</tbody></table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage('P', 'LETTER');
                                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("ReporteComponentes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}

        function registroControlInventariosExcelOld($idproducto, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$objPHPExcel = new Spreadsheet();
				$objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Reporte de Kardex") // Titulo
                ->setSubject("Reporte de Kardex") //Asunto
                ->setDescription("Reporte de Kardex") //Descripción
                ->setKeywords("Reporte de Kardex") //Etiquetas
                ->setCategory("Reporte de Kardex"); //Categorias
				$objPHPExcel->setActiveSheetIndex(0);

				/* Estilos */
                    $style_titulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 20,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_subtitulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => '000000'),
                            'size'  => 15,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_header_tabla = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'fill' => [
                            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'startColor' => [
                                'rgb' => str_replace('#', '', $this->session->userdata('hdBackground')),
                            ],
                        ],
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))],
                            ],
                        ],
                    );

                    $style_categoria = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 12,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_num = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold' => false,
                            'size'  => 11,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER
                        ]
                    );

                    $style_num_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE
                        ]
                    );

                    $style_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        )
                    );

                    $style_bordes = array(
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_bordes_all = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_num_porcentaje = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'size'  => 11,
                            'bold' => false,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Verdana'
                        ),
                        'numberFormat' => [
                            'code' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                        ]
                    );

                    $style_align_center = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                    );

                    $style_text_bold = array(
                        'font'  => array(
                            'bold' => true,
                        ),
                    );

                    $style_subtitulo_color = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 15,
                            'name'  => 'Calibri'
                        )
                    );
                /* */
               
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('auxi_model');
                $this->load->model('producto_model');
                $this->load->model('global_model');

                $function = $this->uri->segment(3);

                $nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $nrc = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                $nombre_doc = "Reporte de Kardex";

                $arrayIdProducto = explode("-", $idproducto);
                $hojaTrabajoActual = 0;

                foreach($arrayIdProducto as $idproducto){
                    //SI HAY MÁS DE UN PRODUCTO
                    //CREA UNA NUEVA HOJA DE TRABAJO
                    if($hojaTrabajoActual>0){
                        $objPHPExcel->createSheet();
                        $objPHPExcel->setActiveSheetIndex($hojaTrabajoActual);
                    }

                    //DATOS DEL PRODUCTO
                    $fichaProducto = $this->producto_model->getProducto($idproducto);

                    /* ENCABEZADOS */
                        $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);
                        $objPHPExcel->getActiveSheet()->setCellValue('A1', $nombre_doc);
                        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($style_titulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');


                        $objPHPExcel->getActiveSheet()->setCellValue('A2', $this->session->userdata('descrip'));
                        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_subtitulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
                    /* */

                    /*  DATOS DEL PRODUCTO  */
                        $objPHPExcel->getActiveSheet()->setTitle('Reporte de Kardex');

                        $objPHPExcel->getActiveSheet()->setCellValue('A4', "UNIDAD DE MEDIDA: ".strtoupper($fichaProducto->um));
                        $objPHPExcel->getActiveSheet()->mergeCells('A4:D4');

                        $objPHPExcel->getActiveSheet()->setCellValue('E4', "NIT: ".$nit);
                        $objPHPExcel->getActiveSheet()->mergeCells('E4:F4');

                        $objPHPExcel->getActiveSheet()->setCellValue('G4', "NRC: ".$nrc);
                        $objPHPExcel->getActiveSheet()->mergeCells('G4:H4');

                        $objPHPExcel->getActiveSheet()->setCellValue('I4', "PERIODO: ". date_format(date_create($fechaini),'d/m/Y')." - ".  date_format(date_create($fechafin),'d/m/Y') );
                        $objPHPExcel->getActiveSheet()->mergeCells('I4:K4');

                        $objPHPExcel->getActiveSheet()->setCellValue('L4', "CÓDIGO: ".strtoupper($fichaProducto->modelo));
                        $objPHPExcel->getActiveSheet()->mergeCells('L4:N4');
                        $objPHPExcel->getActiveSheet()->getStyle('A4:N4')->applyFromArray($style_header_tabla);

                        $objPHPExcel->getActiveSheet()->setCellValue('A5', strtoupper($fichaProducto->descrip));
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_header_tabla);
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_subtitulo_color);

                        $objPHPExcel->getActiveSheet()->mergeCells('A5:N5');

                        //NOMBRE DE LA HOJA DE TRABAJO
                        $objPHPExcel->getActiveSheet()->setTitle(substr(strtoupper($fichaProducto->descrip),0,31));

                    /* */

                    /*  ANCHOS DE COLUMNAS   */
                        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(27);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12);
                    /* */

                    /*  ENCABEZADOS TABLA DE MOVIMIENTOS */
                        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'NO.');
                        $objPHPExcel->getActiveSheet()->mergeCells('A6:A7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('B6', 'FECHA');
                        $objPHPExcel->getActiveSheet()->mergeCells('B6:B7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('C6', 'NO. DOC.');
                        $objPHPExcel->getActiveSheet()->mergeCells('C6:C7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('D6', 'DESCRIPCIÓN');
                        $objPHPExcel->getActiveSheet()->mergeCells('D6:D7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('E6', 'PROVEEDOR');
                        $objPHPExcel->getActiveSheet()->mergeCells('E6:E7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('F6', 'NACIONALIDAD');
                        $objPHPExcel->getActiveSheet()->mergeCells('F6:F7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G6', 'DESCRIPCIÓN DEL PRODUCTO');
                        $objPHPExcel->getActiveSheet()->mergeCells('G6:H6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G7', 'PRECIO UNITARIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('H7', 'COSTO PROMEDIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I6', 'UNIDADES');
                        $objPHPExcel->getActiveSheet()->mergeCells('I6:K6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I7', 'ENTRADAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('J7', 'SALIDAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('K7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L6', 'VALORES');
                        $objPHPExcel->getActiveSheet()->mergeCells('L6:N6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L7', 'DEBE');

                        $objPHPExcel->getActiveSheet()->SetCellValue('M7', 'HABER');

                        $objPHPExcel->getActiveSheet()->SetCellValue('N7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->getStyle('A6:N7')->applyFromArray($style_bordes_all);
                    /* */

                    
                    //DATOS INICIALES
                    $resultado = [];
                    $i = 1;
                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $filaActual = 8;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;                
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini); 

                    //$this->highlight_array($transaccionesIniciales);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    $fecha = date_format(date_create($fechaini),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO INICIAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual, $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);
                    
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;
                    
                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    foreach($transacciones as $tran){
                        $i++;
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                        $nacionalidad = '';
                        $descripProveedor = '';

                        //calculo del costo promedio 
                        //se toman los saldos del registro anterior
                        if($saldoInicialUnidades != 0){
                            $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                        }

                        //SALIDA
                        if($tran['inopera'] == -1){ 
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            $totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                            $saldoInicialValores += $valorHaber;
                            $totalHaber += $valorHaber;

                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            $totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            $totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                //DATOS DEL PROVEEDOR SI ES COMPRA
                                if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                                }
        
                                if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                                }
                            }
                        }
                        $fecha = date_format(date_create($tran['fecha']),'d/m/Y');

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, $tran['serie'].$tran['numero']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, $tran['descripDoc']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, $descripProveedor);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, $nacionalidad);
                        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, $precioUnitario);
                        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($unidadEntrada));
                        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($unidadSalida));
                        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($valorDebe));
                        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($valorHaber));
                        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                        $objPHPExcel->getActiveSheet()->getStyle('G'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.000000_-;-* #,##0.000000_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);

                        
                        $filaActual++;
                    }

                    //SALDO FINAL
                    $i++;
                
                    $fecha = date_format(date_create($fechafin),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO FINAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($totalEntradas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($totalSalidas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($totalDebe));
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($totalHaber));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual +=5;

                    //FIRMAS 
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;

                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'Representante Legal y/o Propietario');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'Encargado de Bodega');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    //AUMENTA EL NUMERO DE HOJAS DE TRABAJO
                    $hojaTrabajoActual++;
                }

				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Reporte de Kardex.xlsx"');
				header('Cache-Control: max-age=0');
				$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
				$objWriter->save('php://output'); 
				exit;
            }
        }

        function ordenventaOld($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->setPrintHeader(false);
                
                $pdf->addPage('P', 'LETTER');
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model');
                
                $background_color = $this->session->userdata('FHBackground');
                //$background_color = '#A5A5A5';
                $color = $this->session->userdata('FHFontColor');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $tipocliente = $dataPedido["idtipo"];
                $notastran100 = $dataPedido["notas"];
                $notasNameCliente = explode("\n", $notastran100);
                $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);
    
                if($dataPedido["idcps"] != 325){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else{
                    $nombreCliente = $dataPedido["dev_contact"];
                }
                
                if($formapago == ''){
                    $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                }
                $estructura = '
                    <table style="width:100%; padding-top:0px;">
                        <tr>
                            <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                    </table>';
                $estructura .= '
                    <table style="width:100%; border:1px solid black;">
    
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                            <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                        </tr>
                    </table>';
                
                $estructura .= '
                    <table style="width:100%;">
                        <thead>
                            <tr style="text-align:center;" >
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:40%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>PRECIO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>DESC.</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>SUB TOTAL</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>TOTAL</strong></th>
                            </tr>
                        </thead>';
                
                $productos = $this->pedclientes_model->getDataProduct($trannum);
                $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0; $line=1;
                
                foreach($productos as $pro){
                    
                    if($pro->cantrp == 0){
                        $precioneto = $pro->precioneto;
                    }else{
                        $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }   
                    
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                        
                        $vnExenta = "";
                        $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }
                    
                    if($pro->cantrp == 0){
                        $preciouni = $pro->precioneto;                        
                    }else{
                        $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }
                    
                    $precioOrg = $pro->precioventa;
                    
                    if($pro->tipo != 4){
                        $nombrepro = $pro->descrip;
                    }else{
                        $nombrepro = $pro->notas;
                    }
                    
                    //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                    $descuento = number_format($pro->cantrp, 0 ,'.','');
                    // VALOR DE DESCUENTO
                    $valorDescuento = abs($preciouni - $pro->precioventa);
                    
                    $estructura .= '
                        <tr>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->idproducto.'</td>
                            <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:40%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:8%;">'.number_format($pro->precioventa, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">-'.number_format($valorDescuento, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 2 ,'.','').'</td>                            
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
                        </tr>';
                    $m = ( strlen($nombrepro) > 45 ) ? $m + 2 : $m + 1;
                    
                    if($descuento>0){
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                            </tr>';
                        $d = $d + 1;
                    }
                }
                
                $lineasproduct = ($m + $d);
               
                if($lineasproduct >= 1 && $lineasproduct <= 45){
                    $contFinal = 45;
                }else if($lineasproduct > 45 && $lineasproduct <= 90){
                    $contFinal = 90;
                }else if($lineasproduct > 90 && $lineasproduct <= 135){
                    $contFinal = 135;
                }else{
                    $contFinal = 141;
                }
                
                for($i=$lineasproduct; $i<=$contFinal; $i++){
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                }
                
                $estructura .= '</table>';
                
                if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = $this->convertir_a_letras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                
                if($invexento==1){
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <br>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                            </tr>
                            ';  
                }else{
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                            </tr>
                            ';
                }
                
                $estructura .=  '
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:5px; text-align:left; width:100%"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                        </tr>
                    </table>';
                
                $pdf->setPrintFooter(false);
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function ordenventaOld1($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->setPrintHeader(false);
                
                $pdf->addPage('P', 'LETTER');
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model');
                
                $background_color = $this->session->userdata('FHBackground');
                //$background_color = '#A5A5A5';
                $color = $this->session->userdata('FHFontColor');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $tipocliente = $dataPedido["idtipo"];
                $notastran100 = $dataPedido["notas"];
                $notasNameCliente = explode("\n", $notastran100);
                $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);
    
                if($dataPedido["idcps"] != 325){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else{
                    $nombreCliente = $dataPedido["dev_contact"];
                }
                
                if($formapago == ''){
                    $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                }
                $estructura = '
                    <table style="width:100%; padding-top:0px;">
                        <tr>
                            <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                    </table>';
                $estructura .= '
                    <table style="width:100%; border:1px solid black;">
    
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                            <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                        </tr>
                    </table>';
                
                $estructura .= '
                    <table style="width:100%;">
                        <thead>
                            <tr style="text-align:center;" >
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:40%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>PRECIO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>DESC.</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>SUB TOTAL</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>TOTAL</strong></th>
                            </tr>
                        </thead>';
                
                $productos = $this->pedclientes_model->getDataProduct($trannum);
                $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0; $line=1;
                
                foreach($productos as $pro){
                    
                    if($pro->cantrp == 0){
                        $precioneto = $pro->precioneto;
                    }else{
                        $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }   
                    
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                        
                        $vnExenta = "";
                        $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }
                    
                    if($pro->cantrp == 0){
                        $preciouni = $pro->precioneto;                        
                    }else{
                        $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }
                    
                    $precioOrg = $pro->precioventa;
                    
                    if($pro->tipo != 4){
                        $nombrepro = $pro->descrip;
                    }else{
                        $nombrepro = $pro->notas;
                    }
                    
                    //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                    $descuento = number_format($pro->cantrp, 0 ,'.','');
                    // VALOR DE DESCUENTO
                    $valorDescuento = abs($preciouni - $pro->precioventa);
                    
                    $estructura .= '
                        <tr>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->idproducto.'</td>
                            <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:40%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:8%;">'.number_format($pro->precioventa, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">-'.number_format($valorDescuento, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 2 ,'.','').'</td>                            
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
                        </tr>';
                    $m = ( strlen($nombrepro) > 45 ) ? $m + 2 : $m + 1;
                    
                    if($descuento>0){
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                            </tr>';
                        $d = $d + 1;
                    }
                }
                
                $lineasproduct = ($m + $d);
               
                if($lineasproduct >= 1 && $lineasproduct <= 44){
                    $contFinal = 44;
                }else if($lineasproduct > 44 && $lineasproduct <= 90){
                    $contFinal = 90;
                }else if($lineasproduct > 90 && $lineasproduct <= 135){
                    $contFinal = 135;
                }else{
                    $contFinal = 141;
                }
                
                for($i=$lineasproduct; $i<=$contFinal; $i++){
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                }
                
                $estructura .= '</table>';
                
                if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = $this->convertir_a_letras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                
                if($invexento==1){
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <br>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                            </tr>
                            ';  
                }else{
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                            </tr>
                            ';
                }
                
                $estructura .=  '
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:5px; text-align:left; width:100%"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                        </tr>
                    </table>';
                
                $pdf->setPrintFooter(false);
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function ordenventaOld2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->setPrintHeader(false);
                
                $pdf->addPage('P', 'LETTER');
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model');
                
                $background_color = $this->session->userdata('FHBackground');
                //$background_color = '#A5A5A5';
                $color = $this->session->userdata('FHFontColor');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $tipocliente = $dataPedido["idtipo"];
                $notastran100 = $dataPedido["notas"];
                $notasNameCliente = explode("\n", $notastran100);
                $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);
    
                if($dataPedido["idcps"] != 325){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else{
                    $nombreCliente = $dataPedido["dev_contact"];
                }
                
                if($formapago == ''){
                    $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                }
                $estructura = '
                    <table style="width:100%; padding-top:0px;">
                        <tr>
                            <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                    </table>';
                $estructura .= '
                    <table style="width:100%; border:1px solid black;">
    
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                            <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                        </tr>
                    </table>';
                
                $estructura .= '
                    <table style="width:100%;">
                        <thead>
                            <tr style="text-align:center;" >
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:40%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>PRECIO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>DESC.</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>SUB TOTAL</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>TOTAL</strong></th>
                            </tr>
                        </thead>';
                
                $productos = $this->pedclientes_model->getDataProduct($trannum);
                $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0; $line=1;
                
                foreach($productos as $pro){
                    
                    if($pro->cantrp == 0){
                        $precioneto = $pro->precioneto;
                    }else{
                        $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }   
                    
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                        
                        $vnExenta = "";
                        $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }
                    
                    if($pro->cantrp == 0){
                        $preciouni = $pro->precioneto;                        
                    }else{
                        $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }
                    
                    $precioOrg = $pro->precioventa;
                    
                    if($pro->tipo != 4){
                        $nombrepro = $pro->descrip;
                    }else{
                        $nombrepro = $pro->notas;
                    }
                    
                    //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                    $descuento = number_format($pro->cantrp, 1 ,'.','');
                    // VALOR DE DESCUENTO
                    $valorDescuento = abs($preciouni - $pro->precioventa);
                    
                    $estructura .= '
                        <tr>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->idproducto.'</td>
                            <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:40%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:8%;">'.number_format($pro->precioventa, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">-'.number_format($valorDescuento, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 2 ,'.','').'</td>                            
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
                        </tr>';
                    $m = ( strlen($nombrepro) > 45 ) ? $m + 2 : $m + 1;

                    if($descuento>0){
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                            </tr>';
                        $d = $d + 1;
                    }
                }
                
                $lineasproduct = ($m + $d);
               
                if($lineasproduct >= 1 && $lineasproduct <= 44){
                    $contFinal = 44;
                }else if($lineasproduct > 44 && $lineasproduct <= 90){
                    $contFinal = 90;
                }else if($lineasproduct > 90 && $lineasproduct <= 135){
                    $contFinal = 135;
                }else{
                    $contFinal = 141;
                }
                
                for($i=$lineasproduct; $i<=$contFinal; $i++){
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                }
                
                $estructura .= '</table>';
                
                if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
                
                //$numero = number_format(round($total, 2), 2 ,'.','');
                $numero = floatval($total);
                $TotalLetras = $this->convertir_a_letras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                
                if($invexento==1){
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <br>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                            </tr>
                            ';  
                }else{
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                            </tr>
                            ';
                }
                
                $estructura .=  '
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:5px; text-align:left; width:100%"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                        </tr>
                    </table>';
                
                $pdf->setPrintFooter(false);
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function ordenventa($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->setPrintHeader(false);
                
                $pdf->addPage('P', 'LETTER');
                
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model');
                
                $background_color = $this->session->userdata('FHBackground');
                //$background_color = '#A5A5A5';
                $color = $this->session->userdata('FHFontColor');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $tipocliente = $dataPedido["idtipo"];
                $notastran100 = $dataPedido["notas"];
                $notasNameCliente = explode("\n", $notastran100);
                $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);
    
                if($dataPedido["idcps"] != 325){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else{
                    $nombreCliente = $dataPedido["dev_contact"];
                }
                
                if($formapago == ''){
                    $formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
                }
                $estructura = '
                    <table style="width:100%; padding-top:0px;">
                        <tr>
                            <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                    </table>';
                $estructura .= '
                    <table style="width:100%; border:1px solid black;">
    
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                            <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                        </tr>
                    </table>';
                
                $estructura .= '
                    <table style="width:100%;">
                        <thead>
                            <tr style="text-align:center;" >
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:40%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>PRECIO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>DESC.</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>SUB TOTAL</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:7%;"><strong><br>TOTAL</strong></th>
                            </tr>
                        </thead>';
                
                $productos = $this->pedclientes_model->getDataProduct($trannum);
                $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0; $line=1;
                
                foreach($productos as $pro){
                    
                    if($pro->cantrp == 0){
                        $precioneto = $pro->precioneto;
                    }else{
                        $precioneto = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }   
                    
                    if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                        
                        $vnExenta = "";
                        $vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                    }else if($pro->tipotax != 0 && $invexento == 1){
                        $total = $total + (($precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax== 0 && $invexento == 0){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tipotax == 0 && $invexento == 1){
                        $total = $total + (($precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $precioneto * abs($pro->cantidad);
                            
                        $vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
                        $vnGravada = "";
                    }
                    
                    if($pro->cantrp == 0){
                        $preciouni = $pro->precioneto;                        
                    }else{
                        $preciouni = $pro->precioneto - ($pro->precioneto * ($pro->cantrp / 100));
                    }
                    
                    $precioOrg = $pro->precioventa;
                    
                    if($pro->tipo != 4){
                        $nombrepro = $pro->descrip;
                    }else{
                        $nombrepro = $pro->notas == '' ? $pro->descrip : $pro->notas;
                    }
                    
                    //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                    $descuento = number_format($pro->cantrp, 1 ,'.','');
                    // VALOR DE DESCUENTO
                    $valorDescuento = abs($preciouni - $pro->precioventa);
                    
                    $estructura .= '
                        <tr>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->idproducto.'</td>
                            <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:40%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:8%;">'.number_format($pro->precioventa, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">-'.number_format($valorDescuento, 2 ,'.','').'</td>
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 2 ,'.','').'</td>                            
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
                        </tr>';
                    $m = ( strlen($nombrepro) > 45 ) ? $m + 2 : $m + 1;

                    if($descuento>0){
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                            </tr>';
                        $d = $d + 1;
                    }
                }
                
                $lineasproduct = ($m + $d);
               
                if($lineasproduct >= 1 && $lineasproduct <= 44){
                    $contFinal = 44;
                }else if($lineasproduct > 44 && $lineasproduct <= 90){
                    $contFinal = 90;
                }else if($lineasproduct > 90 && $lineasproduct <= 135){
                    $contFinal = 135;
                }else{
                    $contFinal = 141;
                }
                
                for($i=$lineasproduct; $i<=$contFinal; $i++){
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                }
                
                $estructura .= '</table>';
                
                if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 2), 2 ,'.','');
                }
                
                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = $this->valorEnLetras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 2), 2 ,'.',''); 
                
                if($invexento==1){
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%" rowspan="2"><strong>SON: '.strtoupper($TotalLetras).'</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <br>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: ESTRATEGIA COMERCIAL INTERNACIONAL S.A. DE C.V.</strong></th>
                            </tr>
                            ';  
                }else{
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong>SON: '.strtoupper($TotalLetras).'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>SUB-TOTAL</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>IVA</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>RETENCIÓN</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Precios Incluyen IVA<br><br></strong></th>
                            </tr>
                            ';
                }
                
                $estructura .=  '
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:5px; text-align:left; width:100%"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                        </tr>
                    </table>';
                
                $pdf->setPrintFooter(false);
                $pdf->writeHTML($estructura, true, false, true, false, '');
                $nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function formatoCotizacionSinIva($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden De Venta');
                $pdf->SetSubject('Orden De Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
				
                $pdf->addPage('P', 'LETTER');
				
                $this->load->model('global_model');
				$this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $this->load->model('pedclientes_model');
                $this->load->model('sucursal_model');
                
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $tipocliente = $dataPedido["idtipo"];
                $notastran100 = $dataPedido["notas"];
                $notasNameCliente = explode("\n", $notastran100);
                $direccionSuc = $this->pedclientes_model->getLocationCotizacion($dataPedido["idcentro"]);
                $namecentro = $this->sucursal_model->getNameCentro($dataPedido["idcentro"]);
                $RazonSocial = $this->eliminarTildes($this->global_model->getDatosGeneralesEmp('g_empdatos', 1));

                if($dataPedido["idcps"] != 325){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else if(($dataPedido["idcps"] == 325) && (empty($dataPedido["dev_contact"]))){
                    $nombreCliente = strtoupper(substr($dataPedido["clientename"], 0, 49));
                }else{
                    $nombreCliente = $dataPedido["dev_contact"];
                }
                
				if($formapago == ''){
					$formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
				}
                $estructura = '
                    <table style="width:100%; padding-top:0px;">
                        <tr>
                            <td style="width:25%;"><img style="height:80px;" src="'.FCPATH.'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"><strong>'.trim($this->session->userdata('descrip')).'<br>'.$namecentro.'<br>'.$direccionSuc['notas'].'</strong></td>
                            <td style="text-align:center; border: 1px solid black; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" ><br><br><strong>COTIZACION</strong><br>N°<br><strong style="font-size:14px;">'.$trannum.'</strong><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
                        </tr>
                    </table>';
                $estructura .= '
                    <table style="width:100%; border:1px solid black;">

                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["idcps"].' - '.$nombreCliente.'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Fecha:</strong> '.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Direccion:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["direccion"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nrc:</strong>'.$dataPedido["NRC"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;" colspan = "2">Correo:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;" colspan = "2">'.$dataPedido["correo"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Nit:</strong>'.$dataPedido["NIT"].'</td>
                        </tr>
                        
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Tipo Documento:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["tipodoc"].'</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>Vendedor: </strong></td>
                        </tr>
                        <tr>
                            <td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
                            <td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$dataPedido["formaPago"].'</td>
                            <td style="border-right:1px solid black; text-align:LEFT; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">'.$dataPedido["workername"].'</td>
                        </tr>
                    </table>';
				
				$estructura .= '
                    <table style="width:110%;">
                        <thead>
                            <tr style="text-align:center;" >
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:4%;"><strong><br>No.<br></strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CODIGO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:43%;"><strong><br>DESCRIPCION DEL PRODUCTO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:6%;"><strong><br>UM</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>CANTIDAD</strong></th>
                        <!--   <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>PRECIO</strong></th> -->
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:11%;"><strong><br>PRECIO</strong></th>
                                <th style="background-color:'.$background_color.'; color:'.$color.'; border:1px solid black; vertical-align: auto; font-weight:normal; font-size:11px; width:9%;"><strong><br>SUBTOTAL</strong></th>
                            </tr>
                        </thead>';
				
                $productos = $this->pedclientes_model->getDataProduct($trannum);
                $cotExenta = $this->ventas_model->validateDocumentoExento($trannum);
                				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $cotExenta; $vnExenta = 0; $vnGravada = 0;
                $m = 0; $i = 0; $d = 0; $line=1;
                
                $cantPages = (ceil(count($productos) / 43));

                $numProd = 0;

                $maxlines = 43;
                
                $docLines = count($productos);
				if ($docLines <= 43) {
						$maxlines = 43;
				} else {
						if ($docLines > 43 && $docLines <= 120) {
								if ($docLines <= 53) {
										$maxlines = 43;
								} else {
										$maxlines = 53;
								}
						} else if ($docLines > 120) {
								$maxlines = 53;
						}
				}
    
                $stop_index = $maxlines;
				$aux2 = 1;
				
				foreach($productos as $pro){
                    
                    if($pro->cantrp == 0){
                        $precioneto = round($pro->precioneto / 1.13, 4);
                    }else{
                        $precioneto = round($pro->precioneto / 1.13 - ($pro->precioneto/ 1.13 * ($pro->cantrp / 100)), 4);
                    }   
                    
					if($pro->tipotax != 0 && $invexento == 0){
                        $total = $total + number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalGravado = $totalGravado + number_format(round((($precioneto * abs($pro->cantidad))/(1+($pro->tipotax / 100))),4), 2 ,'.','');
                        
						$vnExenta = "";
						$vnGravada = "" . number_format(round($precioneto * abs($pro->cantidad), 2), 2 ,'.','');
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						$vnGravada = "";
					}
					
                    if($pro->cantrp == 0){
                        $preciouni = round($pro->precioneto / 1.13, 4);                        
                    }else{
                        
                        $preciouni = round($pro->precioneto / 1.13 - ($pro->precioneto * ($pro->cantrp / 100)), 4);
                    }
                    
                    $precioOrg = $pro->precioventa;
                    
                    if($pro->tipo != 4){
                        $nombrepro = $pro->descrip;
                    }else{
                         $nombrepro = $pro->notas == '' ? $pro->descrip : $pro->notas;
                    }
                    
                    //$descuento = (((number_format($preciouni, 2 ,'.','') - number_format($precioOrg, 2 ,'.','')) / $precioOrg)*100);
                    $descuento = number_format($pro->cantrp, 0 ,'.','');
                    // VALOR DE DESCUENTO
                    $valorDescuento = abs($preciouni - $pro->precioventa);
                    
                    if ($numProd === $stop_index) {
                        $breakValue = 'always';
                        $numProd = 0;
                        $aux2++;
                    } else {
                            $breakValue = 'avoid';
                    }

                    $estructura .= '
                        <tr style="page-break-before: ' . $breakValue . ';">
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:4%;">'.$line++.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$pro->idproducto.'</td>
                            <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:43%;">'.$nombrepro.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:6%;">'.$pro->um.'</td>
                            <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.abs($pro->cantidad).'</td>
                         <!-- <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.number_format($pro->precioventa, 2 ,'.','').'</td> -->
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:11%;">'.number_format($preciouni, 4 ,'.','').'</td>                            
                            <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:9%;">'.$vnExenta.''.$vnGravada.'</td>
                        </tr>';
                    $m = ( strlen($nombrepro) > 45 ) ? $m + 2 : $m + 1;
                    
                    if($descuento>0){
                        $estructura .= '
                            <tr>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:6%;"></td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:14%;"></td>
                                <td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:50%;">DESCUENTO</td>
                                <td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$descuento.'%</td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                                <td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"></td>
                            </tr>';
                        $d = $d + 1;
                    }

                    if ($aux2 > 1 && $aux2 < $cantPages) {
                        $stop_index = 67;
                    }

                    $numProd = ( strlen($nombrepro) > 45 ) ? $numProd + 2 : $numProd + 1;

				}
                
                $lineasproduct = ($m + $d);
               /*
				if($lineasproduct >= 1 && $lineasproduct <= 45){
                    $contFinal = 45;
                }else if($lineasproduct > 45 && $lineasproduct <= 90){
                    $contFinal = 90;
                }else if($lineasproduct > 90 && $lineasproduct <= 135){
                    $contFinal = 135;
                }else{
                    $contFinal = 141;
                }
                
                for($i=$lineasproduct; $i<=$contFinal; $i++){
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                } */

                //var_dump($cantPages);
                if ($cantPages > 1) {
                    $maxlines = 55;
                }

                for ($i = $numProd; $i < $maxlines; $i++) {
                    $estructura .= '<tr><td style="font-size:11px; width:100%;" colspan="6"></td></tr>';
                }
                
                $estructura .= '</table>';
                
                if(($dataPedido["idtipo"]==3) && ($totalGravado>=100)){
                    $reten = $totalGravado * 0.01;
                    $retencion = '-'.$reten;
                    $total= $total-$reten;
                }else{
                    $retencion = 0;
                }
                    
                if($retencion == 0){
                    $retencion = "";
                }else{
                    $retencion = "$".number_format(round($retencion, 4), 4 ,'.','');
                }
				
				$numero = number_format($total, 3 ,'.','');
				$TotalLetras = $this->valorEnLetras($numero);
                
                $totalIVA = number_format(round(($totalGravado * ($pro->tipotax/100)), 4), 4 ,'.',''); 
                
                if($invexento==1){
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:75%; color:white;" rowspan="2"><strong style="color:white;">SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong style="color:white;">TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <br>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Pago con cheque a nombre de: '. $RazonSocial .'</strong></th>
                            </tr>
                            ';  
                }else{
                    $estructura .=  '
                        <table style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:13px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:100%"><strong style="color:white;">SON: '.strtoupper($TotalLetras).'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px; background-color:'.$background_color.';">
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong style="color:white;">SUB-TOTAL</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong style="color:white;">IVA</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong style="color:white;">RETENCIÓN</strong></th>
                                <th style="font-size:10px; text-align:center; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong style="color:white;">TOTAL</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($totalGravado, 2), 2 ,'.',',').'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.$totalIVA.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>'.$retencion.'</strong></th>
                                <th style="font-size:10px; text-align:right; border-right: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; border-bottom: 1px solid black; width:25%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                            </tr>
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width:100%"><strong>Precios unitarios incluyen IVA. Esta cotización tiene una validez de 15 días. Mientras duren existencias y precios sujetos a cambio sin previo aviso<br><br></strong></th>
                            </tr>
                            ';
                }
                
				$estructura .=  '
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:10px; text-align:left; width:100%"><strong>'.$dataPedido["notas"].'</strong></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:5px; text-align:left; width:100%"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
							<th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Autorizado por</strong></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; text-align:center; width:30%"></th>
                            <th style="font-size:13px; text-align:center; width:5%"></th>
                            <th style="font-size:13px; border-top: 1px solid black; text-align:center; width:30%"><strong>Aceptado Cliente</strong></th>
                        </tr>
                    </table>';
                    
                
                $pdf->setPrintFooter(false);
				$pdf->writeHTML($estructura, true, false, true, false, '');
            	$nombre_archivo = utf8_decode("OrdenDeVenta$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }

        //Cheques----------------------------------------------------------------------------------------------------------------------------------
        function formatoCheque($idrecs, $idbanco = null){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				switch($idbanco){
					case 2419:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeAgricola/' . $idrecs);
					break;

                    case 2421:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeCusca/' . $idrecs);
					break;

                    case 2422:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeBac/' . $idrecs);
					break;

                    case 2423:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeDavivienda/' . $idrecs);
					break;

                    case 2427:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeIndustrial/' . $idrecs);
					break;

					default:
						redirect($this->session->userdata('dirReports') . '/reports/formatoChequeVoucher/' . $idrecs);

					break;
				}
			}
		}
		
		function formatoChequeVoucher($idrecs, $idbanco = null){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$this->load->library('Pdf');
				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');

				$pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cheque');
                $pdf->SetSubject('Cheque');
				$pdf->SetMargins(5, 10, 5);// left top right
                $pdf->SetAutoPageBreak(TRUE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('monospace1', '', 9, '', true);

				$arrayIds = explode("-", $idrecs);

				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);

					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "Ene.";
							break;
						case 2:
							$mes_name = "Feb.";
							break;
						case 3:
							$mes_name = "Mar.";
							break;
						case 4:
							$mes_name = "Abr.";
							break;
						case 5:
							$mes_name = "Mayo";
							break;
						case 6:
							$mes_name = "Jun.";
							break;
						case 7:
							$mes_name = "Jul.";
							break;
						case 8:
							$mes_name = "Ago.";
							break;
						case 9:
							$mes_name = "Sep.";
							break;
						case 10:
							$mes_name = "Oct.";
							break;
						case 11:
							$mes_name = "Nov.";
							break;
						case 12:
							$mes_name = "Dic.";
							break;
						default:
							$mes_name="";
							break;
					}
	
					$fecha = $fechaPartes[0]." de ".$mes_name." de ".$fechaPartes[2];
					$fecha = strtoupper($fecha);
	
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$pdf->addPage('P', 'LETTER');
	
					$tablaHeader = '
						<table style="width=100%; padding: 0;">
							<tr>
								<td style="width: 100%; text-align: center;"><strong>'.$infoDoc["partidaDescrip"].'</strong></td>
							</tr>
							<tr>
								<td style="width: 100%; text-align: center;"><strong>'.$infoDoc["auxiDescrip"].'</strong></td>
							</tr>
						</table>';
					
					$pdf->SetFont('monospace1', '',11, '', true);
					$pdf->SetXY( 10, 10 );
					$pdf->writeHTML($tablaHeader, true, false, true, false, '');
	
					$pdf->SetFont('monospace1', '', 8.5, '', true);
					$pdf->SetXY( 153, 23 );
					$pdf->writeHTML("No. ". $infoDoc["doc_serie"]."-".$infoDoc["doc_numero"], true, false, true, false, '');
	
					$pdf->SetXY( 10, 35 );
					$pdf->writeHTML("Lugar y fecha de emisión: ". $depto.", ".$fecha, true, false, true, false, '');
					
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$pdf->SetXY( 153, 35 );
					$pdf->writeHTML($this->session->userdata("simboloMoneda")." ".number_format($total, 2, ".", ""), true, false, true, false, '');
	
					$pdf->SetXY( 10, 41 );
					$pdf->writeHTML("Portador: ". $infoDoc["descrip"], true, false, true, false, '');
	
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					$totalLetra = strtoupper($totalLetra);
					$pdf->SetXY( 10, 47 );
					$pdf->writeHTML("La suma de: ". $totalLetra, true, false, true, false, '');
	
					$pdf->SetXY( 10, 58 );
					$pdf->writeHTML(date_format(date_create($infoDoc["partidaFecha"]), "d/m/Y"), true, false, true, false, '');
	
					$pdf->SetXY( 153, 58 );
					$pdf->writeHTML("Partida No.: ". $infoDoc["partidaNumero"], true, false, true, false, '');
					
					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
	
					$tablaProductos = '<table style="width: 100%;">';      
					$tablaProductos .= '
						<tr style="line-height: 15px">
							<td style="width: 16%; text-align: center; border: 1px solid black;">Cuenta</td>
							<td style="width: 56%; text-align: center; border: 1px solid black;">Titulo de la Cuenta / Descripción del Movimiento</td>
							<td style="width: 13%; text-align: center; border: 1px solid black;">Debe</td>
							<td style="width: 13%; text-align: center; border: 1px solid black;">Haber</td>
						</tr>
					';
	
					if ($registros->num_rows() > 0) {
						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';
								if ($valor->idcentro != 0) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
									$extra2 = '
										<tr>
											<td style="width: 16%; text-align: right;">'.$valor->idcentro.'</td>
											<td style="width: 84%;">'.$centro->descrip.'</td>
										</tr>
									';
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', '');
								$vhaber = number_format((float)$valor->haber, 2, '.', '');
								$tablaProductos .= '
									<tr>
										<td style="width: 16%;">'.$valor->idctcuenta.'</td>
										<td style="width: 84%;">'.$valor->descripct.'</td>
										
									</tr>
									<tr>
										<td style="width: 16%; text-align: right;">'.$extra['idauxi'].'</td>
										<td style="width: 56%;">'.$valor->descrip.'</td>
										<td style="width: 13%; text-align: right;">'.( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda")." ".$vdebe : '' ).'</td>
										<td style="width: 13%; text-align: right;">'.( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda")." ". $vhaber : '' ).'</td>
									</tr>
								';
								$tablaProductos .= $extra2;
								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					}
					$tablaProductos .= '</table>';
	
					$tablaProductos .= '<br><br><table style="width: 100%; ">';      
					$tablaProductos .= '
						<tr style="line-height: 25px;   vertical-align: middle;">
							<td style="width: 57%; text-align: right;"></td>
							<td style="width: 15%; text-align: right; border: 1px solid black; font-size: 12px">Sumas</td>
							<td style="width: 13%; text-align: right; border: 1px solid black;">'.$this->session->userdata("simboloMoneda")." ".number_format($debe, 2, '.', '').'</td>
							<td style="width: 13%; text-align: right; border: 1px solid black;">'.$this->session->userdata("simboloMoneda")." ".number_format($haber, 2, '.', '').'</td>
						</tr>
					';
					$tablaProductos .= '</table>';
	
					$pdf->SetXY( 5, 64 );
					$pdf->writeHTML($tablaProductos, true, false, true, false, '');
				}

				$nombre_archivo = utf8_decode('Cheque_Voucher.pdf');
				$pdf->Output($nombre_archivo, 'I');
			}
		}

		function formatoChequeAgricola($idrecs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$comandosTM = new comandosTM();

				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');
				$this->load->model('ventas_model');

				$arrayIds = explode("-", $idrecs);
				$cmds = "";
				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);
					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "ENE.";
							break;
						case 2:
							$mes_name = "FEB.";
							break;
						case 3:
							$mes_name = "MAR.";
							break;
						case 4:
							$mes_name = "ABR.";
							break;
						case 5:
							$mes_name = "MAYO";
							break;
						case 6:
							$mes_name = "JUN.";
							break;
						case 7:
							$mes_name = "JUL.";
							break;
						case 8:
							$mes_name = "AGO.";
							break;
						case 9:
							$mes_name = "SEP.";
							break;
						case 10:
							$mes_name = "OCT.";
							break;
						case 11:
							$mes_name = "NOV.";
							break;
						case 12:
							$mes_name = "DIC.";
							break;
						default:
							$mes_name="";
							break;
					}
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$cmds .= comandosTM::Initialize;
					$cmds .= comandosTM::FontSmall;
					$cmds .= comandosTM::FontBoldEnable;
					//$cmds .= comandosTM::PrintSlip;//para imprimir en la bandeja
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(22);
					$cmds .= $comandosTM->padText("ANTIGUO CUSCATLAN, ".$fechaPartes[0]." DE ".$mes_name, /*44*/30, 'RIGHT');
					$cmds .= $comandosTM->pad(3);
					$cmds .= $comandosTM->padText($fechaPartes[2], /*9*/8, 'RIGHT');
					$cmds .= $comandosTM->pad(5);
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$cmds .= str_pad(number_format($total, 2, ".", ","),/*20*/15,"*",STR_PAD_LEFT);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(22);
					$cmds .= $comandosTM->padText($infoDoc['partidaDescrip'], 60, 'RIGHT');
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(22);
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					$totalLetra = strtoupper($totalLetra);
					$cmds .= substr($totalLetra, 0, 60);
					$cmds .= comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(13);
					$cmds .= substr($totalLetra, 60, 24);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					
					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
					$maxcaracteres = 39;
					$maxlineas = 13; // 13 + linea de sumas
					$lineaactual = 0;
					if ($registros->num_rows() > 0) {
						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';

								if ($valor->idcentro != 0 && $lineaactual < $maxlineas) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
								
									$cmds .= $comandosTM->pad(7);
									$cmds .= $comandosTM->padText($valor->idcentro, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($centro->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', ',');
								$vhaber = number_format((float)$valor->haber, 2, '.', ',');

								if($lineaactual < $maxlineas){									
									$cmds .= $comandosTM->pad(9);
									$cmds .= $comandosTM->padText($valor->idctcuenta, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descripct), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								if($lineaactual < $maxlineas){								
									$valor->descrip = substr($valor->descrip, 0, $maxcaracteres);
									$cmds .= $comandosTM->pad(9);
									$cmds .= $comandosTM->padText($extra['idauxi'], 11, 'LEFT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText(( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda").$vdebe : '' ), 12, 'LEFT');
									$cmds .= $comandosTM->padText(( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda").$vhaber : '' ), 12, 'LEFT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					} 
					
					//SUMAS
					$cmds .= $comandosTM->pad(21);
					$cmds .= $comandosTM->padText("SUMAS",$maxcaracteres, 'LEFT');
					$cmds .= $comandosTM->pad(1);
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($debe, 2, '.', ','), 12, 'LEFT');
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($haber, 2, '.', ','), 12, 'LEFT');
					$cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::FormFeed;
				}
				

				$trannum = 'CH'. $idrecs;
				$this->ventas_model->setCommandsPrint($trannum, $cmds, 2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=1&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
			}
		}

		function formatoChequeBac($idrecs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$comandosTM = new comandosTM();

				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');
				$this->load->model('ventas_model');

				$arrayIds = explode("-", $idrecs);
				$cmds = "";

				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);

					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "ENE.";
							break;
						case 2:
							$mes_name = "FEB.";
							break;
						case 3:
							$mes_name = "MAR.";
							break;
						case 4:
							$mes_name = "ABR.";
							break;
						case 5:
							$mes_name = "MAYO";
							break;
						case 6:
							$mes_name = "JUN.";
							break;
						case 7:
							$mes_name = "JUL.";
							break;
						case 8:
							$mes_name = "AGO.";
							break;
						case 9:
							$mes_name = "SEP.";
							break;
						case 10:
							$mes_name = "OCT.";
							break;
						case 11:
							$mes_name = "NOV.";
							break;
						case 12:
							$mes_name = "DIC.";
							break;
						default:
							$mes_name="";
							break;
					}
	
					$fecha = $fechaPartes[0]." de ".$mes_name." de ".$fechaPartes[2];
					$fecha = strtoupper($fecha);
	
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$cmds .= comandosTM::Initialize;
					$cmds .= comandosTM::FontSmall;
					$cmds .= comandosTM::FontBoldEnable;
					//$cmds .= comandosTM::PrintSlip;//para imprimir en la bandeja
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(26);
					$cmds .= $comandosTM->padText("ANTIGUO CUSCATLAN, ".$fechaPartes[0]." DE ".$mes_name, /*44*/29, 'BOTH');
					$cmds .= $comandosTM->pad(3);
					$cmds .= $comandosTM->padText($fechaPartes[2], /*9*/8, 'RIGHT');
					$cmds .= $comandosTM->pad(3);
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$cmds .= str_pad(number_format($total, 2, ".", ","),/*20*/15,"*",STR_PAD_LEFT);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(20);
					$cmds .= $comandosTM->padText($infoDoc['partidaDescrip'], 60, 'RIGHT');
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(20);
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					//$totalLetra = "123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*";
					$totalLetra = strtoupper($totalLetra);
					$cmds .= substr($totalLetra, 0, 64);
					$cmds .= comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(10);
					$cmds .= substr($totalLetra, 64, 26);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;
					
					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
					$maxlineas = 22; // 13 + linea de sumas
					$maxcaracteres = 39;
					$lineaactual = 0;
					if ($registros->num_rows() > 0) {
						$cmds .= $comandosTM->pad(9);
						$cmds .= $comandosTM->padText('CUENTA', 11, 'BOTH');
						$cmds .= $comandosTM->pad(1);
						$cmds .= $comandosTM->padText("DESCRIPCION", $maxcaracteres, 'BOTH');
						$cmds .= $comandosTM->pad(1);
						$cmds .= $comandosTM->padText( "DEBE", 12, 'BOTH');
						$cmds .= $comandosTM->padText( "HABER", 12, 'BOTH');
						$cmds .= comandosTM::LineFeed;

						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';
								if ($valor->idcentro != 0 && $lineaactual < $maxlineas) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
								
									$cmds .= $comandosTM->pad(7);
									$cmds .= $comandosTM->padText($valor->idcentro, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($centro->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', ',');
								$vhaber = number_format((float)$valor->haber, 2, '.', ',');

								if($lineaactual < $maxlineas){										
									$cmds .= $comandosTM->pad(9);
									$cmds .= $comandosTM->padText($valor->idctcuenta, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descripct), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								if($lineaactual < $maxlineas){									
									$valor->descrip = substr($valor->descrip, 0, $maxcaracteres);
									$cmds .= $comandosTM->pad(9);
									$cmds .= $comandosTM->padText($extra['idauxi'], 11, 'LEFT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText(( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda").$vdebe : '' ), 11, 'LEFT');
									$cmds .= $comandosTM->padText(( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda").$vhaber : '' ), 11, 'LEFT');
									$cmds .= comandosTM::LineFeed;

									$lineaactual++;
								}

								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					} 
					
					//SUMAS
					$cmds .= $comandosTM->pad(21);
					$cmds .= $comandosTM->padText("SUMAS",$maxcaracteres, 'LEFT');
					$cmds .= $comandosTM->pad(1);
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($debe, 2, '.', ','), 11, 'LEFT');
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($haber, 2, '.', ','), 11, 'LEFT');
					$cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::FormFeed;
				}
				

				$trannum = 'CH'. $idrecs;
				$this->ventas_model->setCommandsPrint($trannum, $cmds, 2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=1&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
			}
		}

		function formatoChequeDavivienda($idrecs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$comandosTM = new comandosTM();

				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');
				$this->load->model('ventas_model');

				$arrayIds = explode("-", $idrecs);
				$cmds = "";

				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);

					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "ENE.";
							break;
						case 2:
							$mes_name = "FEB.";
							break;
						case 3:
							$mes_name = "MAR.";
							break;
						case 4:
							$mes_name = "ABR.";
							break;
						case 5:
							$mes_name = "MAYO";
							break;
						case 6:
							$mes_name = "JUN.";
							break;
						case 7:
							$mes_name = "JUL.";
							break;
						case 8:
							$mes_name = "AGO.";
							break;
						case 9:
							$mes_name = "SEP.";
							break;
						case 10:
							$mes_name = "OCT.";
							break;
						case 11:
							$mes_name = "NOV.";
							break;
						case 12:
							$mes_name = "DIC.";
							break;
						default:
							$mes_name="";
							break;
					}
	
					$fecha = $fechaPartes[0]." de ".$mes_name." de ".$fechaPartes[2];
					$fecha = strtoupper($fecha);
	
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$cmds .= comandosTM::Initialize;
					$cmds .= comandosTM::FontSmall;
					$cmds .= comandosTM::FontBoldEnable;
					//$cmds .= comandosTM::PrintSlip;//para imprimir en la bandeja
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(26);
					$cmds .= $comandosTM->padText("ANTIGUO CUSCATLAN, ".$fechaPartes[0]." DE ".$mes_name. " DE ". $fechaPartes[2], /*44*/37, 'BOTH');
					
					$cmds .= $comandosTM->pad(8);
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$cmds .= str_pad(number_format($total, 2, ".", ","),/*20*/14,"*",STR_PAD_LEFT);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(19);
					$cmds .= $comandosTM->padText($infoDoc['partidaDescrip'], 60, 'RIGHT');
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(18);
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					//$totalLetra = "123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*";
					$totalLetra = strtoupper($totalLetra);
					$cmds .= substr($totalLetra, 0, 64);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(10);
					$cmds .= substr($totalLetra, 64, 26);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
                    $cmds .= comandosTM::LineFeed;
					
					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
					$maxlineas = 23; // 23 + linea de sumas
					$maxcaracteres = 38;
					$lineaactual = 0;
					if ($registros->num_rows() > 0) {
						$cmds .= $comandosTM->pad(10);
						$cmds .= $comandosTM->padText('CUENTA', 11, 'BOTH');
						$cmds .= $comandosTM->pad(1);
						$cmds .= $comandosTM->padText("DESCRIPCION", $maxcaracteres, 'BOTH');
						$cmds .= $comandosTM->pad(1);
						$cmds .= $comandosTM->padText( "DEBE", 12, 'BOTH');
						$cmds .= $comandosTM->padText( "HABER", 12, 'BOTH');
						$cmds .= comandosTM::LineFeed;

						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';
								if ($valor->idcentro != 0 && $lineaactual < $maxlineas) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
								
									$cmds .= $comandosTM->pad(10);
									$cmds .= $comandosTM->padText($valor->idcentro, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($centro->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', ',');
								$vhaber = number_format((float)$valor->haber, 2, '.', ',');
								
								if($lineaactual < $maxlineas){
									$cmds .= $comandosTM->pad(10);
									$cmds .= $comandosTM->padText($valor->idctcuenta, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descripct), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								
								if($lineaactual < $maxlineas){
									$valor->descrip = substr($valor->descrip, 0, $maxcaracteres);
									$cmds .= $comandosTM->pad(10);
									$cmds .= $comandosTM->padText($extra['idauxi'], 11, 'LEFT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText(( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda").$vdebe : '' ), 11, 'LEFT');
									$cmds .= $comandosTM->padText(( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda").$vhaber : '' ), 11, 'LEFT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					} 
					
					//SUMAS
					$cmds .= $comandosTM->pad(22);
					$cmds .= $comandosTM->padText("SUMAS",$maxcaracteres, 'LEFT');
					$cmds .= $comandosTM->pad(1);
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($debe, 2, '.', ','), 11, 'LEFT');
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($haber, 2, '.', ','), 11, 'LEFT');
					$cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::FormFeed;
				}
				

				$trannum = 'CH'. $idrecs;
				$this->ventas_model->setCommandsPrint($trannum, $cmds, 2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=1&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
			}
		}

		function formatoChequeIndustrial($idrecs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$comandosTM = new comandosTM();

				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');
				$this->load->model('ventas_model');

				$arrayIds = explode("-", $idrecs);
				$cmds = "";

				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);

					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "ENE.";
							break;
						case 2:
							$mes_name = "FEB.";
							break;
						case 3:
							$mes_name = "MAR.";
							break;
						case 4:
							$mes_name = "ABR.";
							break;
						case 5:
							$mes_name = "MAYO";
							break;
						case 6:
							$mes_name = "JUN.";
							break;
						case 7:
							$mes_name = "JUL.";
							break;
						case 8:
							$mes_name = "AGO.";
							break;
						case 9:
							$mes_name = "SEP.";
							break;
						case 10:
							$mes_name = "OCT.";
							break;
						case 11:
							$mes_name = "NOV.";
							break;
						case 12:
							$mes_name = "DIC.";
							break;
						default:
							$mes_name="";
							break;
					}
	
					$fecha = $fechaPartes[0]." de ".$mes_name." de ".$fechaPartes[2];
					$fecha = strtoupper($fecha);
	
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$cmds .= comandosTM::Initialize;
					$cmds .= comandosTM::FontSmall;
					$cmds .= comandosTM::FontBoldEnable;
					//$cmds .= comandosTM::PrintSlip;//para imprimir en la bandeja
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(13);
					$cmds .= $comandosTM->padText("ANTIGUO CUSCATLAN, ".$fechaPartes[0]." DE ".$mes_name. " DE ". $fechaPartes[2], /*44*/45, 'BOTH');
					
					$cmds .= $comandosTM->pad(2);
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$cmds .= str_pad(number_format($total, 2, ".", ","),/*20*/15,"*",STR_PAD_LEFT);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(23);
					$cmds .= $comandosTM->padText($infoDoc['partidaDescrip'], 60, 'RIGHT');
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(21);
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					//$totalLetra = "123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*";
					$totalLetra = strtoupper($totalLetra);
					
					$cmds .= substr($totalLetra, 0, 60);
					$cmds .= comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(21);
					$cmds .= substr($totalLetra, 60, 60);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					
					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
					$maxlineas = 18; // 18 + linea de sumas
					$maxcaracteres = 36;
					$lineaactual = 0;
					if ($registros->num_rows() > 0) {
						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';
								if ($valor->idcentro != 0 && $lineaactual < $maxlineas) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
								
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($valor->idcentro, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($centro->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', ',');
								$vhaber = number_format((float)$valor->haber, 2, '.', ',');
								
								if($lineaactual < $maxlineas){
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($valor->idctcuenta, 11, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descripct), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								
								if($lineaactual < $maxlineas){
									$valor->descrip = substr($valor->descrip, 0, $maxcaracteres);
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($extra['idauxi'], 11, 'LEFT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText(( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda").$vdebe : '' ), 12, 'LEFT');
									$cmds .= $comandosTM->padText(( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda").$vhaber : '' ), 13, 'LEFT');
									$cmds .= comandosTM::LineFeed;
									$lineaactual++;
								}

								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					} 
					
					//SUMAS
					$cmds .= $comandosTM->pad(20);
					$cmds .= $comandosTM->padText("SUMAS",$maxcaracteres, 'LEFT');
					$cmds .= $comandosTM->pad(1);
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($debe, 2, '.', ','), 12, 'LEFT');
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($haber, 2, '.', ','), 13, 'LEFT');
					$cmds .= comandosTM::LineFeed;

                    $cmds .= comandosTM::FontBoldDisable;
                    $cmds .= comandosTM::FormFeed;
				}
				

				$trannum = 'CH'. $idrecs;
				$this->ventas_model->setCommandsPrint($trannum, $cmds, 2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=1&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
			}
		}

		function formatoChequeCusca($idrecs){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');

			}else{
				$comandosTM = new comandosTM();

				$this->load->model('contabilidad_model');
				$this->load->model('auxi_model');
				$this->load->model('global_model');
				$this->load->model('ventas_model');

				$arrayIds = explode("-", $idrecs);
				$cmds = "";
				foreach($arrayIds as $idrecs){
					$infoDoc = $this->contabilidad_model->getInfoCheque($idrecs);

					$fecha = date_format(date_create($infoDoc["fecha"]), "d/m/Y");
					$fechaPartes = explode("/", $fecha);
					$mes = $fechaPartes[1];
					$mes_name = "";
					switch($mes){
						case 1:
							$mes_name = "ENE.";
							break;
						case 2:
							$mes_name = "FEB.";
							break;
						case 3:
							$mes_name = "MAR.";
							break;
						case 4:
							$mes_name = "ABR.";
							break;
						case 5:
							$mes_name = "MAYO";
							break;
						case 6:
							$mes_name = "JUN.";
							break;
						case 7:
							$mes_name = "JUL.";
							break;
						case 8:
							$mes_name = "AGO.";
							break;
						case 9:
							$mes_name = "SEP.";
							break;
						case 10:
							$mes_name = "OCT.";
							break;
						case 11:
							$mes_name = "NOV.";
							break;
						case 12:
							$mes_name = "DIC.";
							break;
						default:
							$mes_name="";
							break;
					}
	
					$fecha = $fechaPartes[0]." de ".$mes_name." de ".$fechaPartes[2];
					$fecha = strtoupper($fecha);
	
					$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
	
					//$this->highlight_array($infoDoc);
					$cmds .= comandosTM::Initialize;
					$cmds .= comandosTM::FontSmall;
					$cmds .= comandosTM::FontBoldEnable;
					//$cmds .= comandosTM::PrintSlip;//para imprimir en la bandeja
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(26);
					$cmds .= $comandosTM->padText("ANTIGUO CUSCATLAN, ".$fechaPartes[0]." DE ".$mes_name. " DE ". $fechaPartes[2], /*44*/37, 'BOTH');
					
					$cmds .= $comandosTM->pad(8);
					$total = $infoDoc["debe"] + $infoDoc["haber"];
					$cmds .= str_pad(number_format($total, 2, ".", ","),/*20*/14,"*",STR_PAD_LEFT);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(22);
					$cmds .= $comandosTM->padText($infoDoc['partidaDescrip'], 60, 'RIGHT');
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(16);
					$totalLetra = trim($this->valorEnLetras(number_format($total, 2, ".", "")));
					//$totalLetra = "123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*123456789*";
					$totalLetra = strtoupper($totalLetra);
					$cmds .= substr($totalLetra, 0, 67);
					$cmds .= comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed;

					$cmds .= $comandosTM->pad(10);
					$cmds .= substr($totalLetra, 64, 26);
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed.comandosTM::LineFeed;
					$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;

					//datos
					$debe = 0;
					$haber = 0;
					$registros = $this->contabilidad_model->getEPRegistroR($infoDoc["partidaNumero"]);
					$maxlineas = 17; // 23 + linea de sumas
					$maxcaracteres = 33;
					$lineaactual = 0;
					if ($registros->num_rows() > 0) {
						
						foreach ($registros->result() as $valor) {
							if ($valor->estatus == 1) {
								$extra = array(
									'idauxi' => '',
									'auxi' => '',
									'idcentro' => '',
									'centro' => '',
								);
								if ($valor->idtabla != 0) {
									$auxi = $this->contabilidad_model->getResponsable($valor->idauxi, $valor->idtabla);
									$extra['idauxi'] = $valor->idauxi;
									$extra['auxi'] = $auxi->descrip;
								}
								$extra2 = '';
								if ($valor->idcentro != 0 && $lineaactual < $maxlineas) {
									$centro = $this->contabilidad_model->getCentro($valor->idcentro);
								
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($valor->idcentro, 18, 'RIGHT');
									$cmds .= $comandosTM->pad(2);
									$cmds .= $comandosTM->padText($this->eliminarTildes($centro->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;
									$lineaactual++;
								}
								$vdebe = number_format((float)$valor->debe, 2, '.', ',');
								$vhaber = number_format((float)$valor->haber, 2, '.', ',');
								
								if($lineaactual < $maxlineas){
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($valor->idctcuenta, 18, 'RIGHT');
									$cmds .= $comandosTM->pad(2);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descripct), $maxcaracteres, 'RIGHT');
									$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;
									$lineaactual++;
								}

								
								if($lineaactual < $maxlineas){
									$valor->descrip = substr($valor->descrip, 0, $maxcaracteres);
									$cmds .= $comandosTM->pad(8);
									$cmds .= $comandosTM->padText($extra['idauxi'], 18, 'LEFT');
									$cmds .= $comandosTM->pad(2);
									$cmds .= $comandosTM->padText($this->eliminarTildes($valor->descrip), $maxcaracteres, 'RIGHT');
									$cmds .= $comandosTM->pad(1);
									$cmds .= $comandosTM->padText(( ( $valor->debe > 0) ? $this->session->userdata("simboloMoneda").$vdebe : '' ), 9, 'LEFT');
									$cmds .= $comandosTM->padText(( ( $valor->haber > 0) ? $this->session->userdata("simboloMoneda").$vhaber : '' ), 12, 'LEFT');
									$cmds .= comandosTM::LineFeed.comandosTM::LineFeed;
									$lineaactual++;
								}

								$debe += $valor->debe;
								$haber += $valor->haber;
							}
						}
					} 
					
					//SUMAS
					$cmds .= $comandosTM->pad(28);
					$cmds .= $comandosTM->padText("SUMAS",$maxcaracteres, 'LEFT');
					$cmds .= $comandosTM->pad(1);
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($debe, 2, '.', ','), 9, 'LEFT');
					$cmds .= $comandosTM->padText( $this->session->userdata("simboloMoneda").number_format($haber, 2, '.', ','), 12, 'LEFT');
					$cmds .= comandosTM::LineFeed;

					$cmds .= comandosTM::FontBoldDisable;
	                $cmds .= comandosTM::FormFeed;
				}
				
				$trannum = 'CH'. $idrecs;
				$this->ventas_model->setCommandsPrint($trannum, $cmds, 2);
                header('Location: webclientprintvi:https://www.goxpos1.com/WebClientPrint/impresion.php?docType=2&tipoImpresion=1&trannum='.$trannum.'&idaccount='.$this->session->userdata('idaccount'));
                exit;
			}
		}

        function registroControlInventariosExcel($idproducto, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$objPHPExcel = new Spreadsheet();
				$objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Reporte de Kardex") // Titulo
                ->setSubject("Reporte de Kardex") //Asunto
                ->setDescription("Reporte de Kardex") //Descripción
                ->setKeywords("Reporte de Kardex") //Etiquetas
                ->setCategory("Reporte de Kardex"); //Categorias
				$objPHPExcel->setActiveSheetIndex(0);

				/* Estilos */
                    $style_titulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 20,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_subtitulo = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => '000000'),
                            'size'  => 15,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_header_tabla = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'fill' => [
                            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'startColor' => [
                                'rgb' => str_replace('#', '', $this->session->userdata('hdBackground')),
                            ],
                        ],
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))],
                            ],
                        ],
                    );

                    $style_categoria = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 12,
                            'name'  => 'Verdana'
                        )
                    );

                    $style_num = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold' => false,
                            'size'  => 11,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER
                        ]
                    );

                    $style_num_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'numberFormat' => [
                            'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE
                        ]
                    );

                    $style_total = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'bold'  => true,
                            'color' => array('rgb' => '000000'),
                            'size'  => 11,
                            'name'  => 'Calibri'
                        )
                    );

                    $style_bordes = array(
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_bordes_all = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'bold' => true,
                            'size'  => 11,
                            'name'  => 'Calibri'
                        ),
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    );

                    $style_num_porcentaje = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                        ),
                        'font'  => array(
                            'size'  => 11,
                            'bold' => false,
                            'color' => array('rgb' => '000000'),
                            'name'  => 'Verdana'
                        ),
                        'numberFormat' => [
                            'code' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                        ]
                    );

                    $style_align_center = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                    );

                    $style_text_bold = array(
                        'font'  => array(
                            'bold' => true,
                        ),
                    );

                    $style_subtitulo_color = array(
                        'alignment' => array(
                            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        ),
                        'font'  => array(
                            'color' => array('rgb' => str_replace('#', '', $this->session->userdata('hdFontcolor'))),
                            'size'  => 15,
                            'name'  => 'Calibri'
                        )
                    );
                /* */
               
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('auxi_model');
                $this->load->model('producto_model');
                $this->load->model('global_model');

                $function = $this->uri->segment(3);

                $nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $nrc = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                $nombre_doc = "Reporte de Kardex";

                $arrayIdProducto = explode("-", $idproducto);
                $hojaTrabajoActual = 0;

                foreach($arrayIdProducto as $idproducto){
                    //SI HAY MÁS DE UN PRODUCTO
                    //CREA UNA NUEVA HOJA DE TRABAJO
                    if($hojaTrabajoActual>0){
                        $objPHPExcel->createSheet();
                        $objPHPExcel->setActiveSheetIndex($hojaTrabajoActual);
                    }

                    //DATOS DEL PRODUCTO
                    $fichaProducto = $this->producto_model->getProducto($idproducto);

                    /* ENCABEZADOS */
                        $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);
                        $objPHPExcel->getActiveSheet()->setCellValue('A1', $nombre_doc);
                        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($style_titulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');


                        $objPHPExcel->getActiveSheet()->setCellValue('A2', $this->session->userdata('descrip'));
                        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_subtitulo);
                        $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
                    /* */

                    /*  DATOS DEL PRODUCTO  */
                        $objPHPExcel->getActiveSheet()->setTitle('Reporte de Kardex');

                        $objPHPExcel->getActiveSheet()->setCellValue('A4', "UNIDAD DE MEDIDA: ".strtoupper($fichaProducto->um));
                        $objPHPExcel->getActiveSheet()->mergeCells('A4:D4');

                        $objPHPExcel->getActiveSheet()->setCellValue('E4', "NIT: ".$nit);
                        $objPHPExcel->getActiveSheet()->mergeCells('E4:F4');

                        $objPHPExcel->getActiveSheet()->setCellValue('G4', "NRC: ".$nrc);
                        $objPHPExcel->getActiveSheet()->mergeCells('G4:H4');

                        $objPHPExcel->getActiveSheet()->setCellValue('I4', "PERIODO: ". date_format(date_create($fechaini),'d/m/Y')." - ".  date_format(date_create($fechafin),'d/m/Y') );
                        $objPHPExcel->getActiveSheet()->mergeCells('I4:K4');

                        $objPHPExcel->getActiveSheet()->setCellValue('L4', "CÓDIGO: ".strtoupper($fichaProducto->modelo));
                        $objPHPExcel->getActiveSheet()->mergeCells('L4:N4');
                        $objPHPExcel->getActiveSheet()->getStyle('A4:N4')->applyFromArray($style_header_tabla);

                        $objPHPExcel->getActiveSheet()->setCellValue('A5', strtoupper($fichaProducto->descrip));
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_header_tabla);
                        $objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_subtitulo_color);

                        $objPHPExcel->getActiveSheet()->mergeCells('A5:N5');

                        //NOMBRE DE LA HOJA DE TRABAJO
                        $invalidCharacters = array('*', ':', '/', '\\', '?', '[', ']');
                        $title = str_replace($invalidCharacters, '', $fichaProducto->descrip);
                        $objPHPExcel->getActiveSheet()->setTitle(substr(strtoupper($title),0,31));

                    /* */

                    /*  ANCHOS DE COLUMNAS   */
                        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(27);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(17);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12);
                    /* */

                    /*  ENCABEZADOS TABLA DE MOVIMIENTOS */
                        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'NO.');
                        $objPHPExcel->getActiveSheet()->mergeCells('A6:A7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('B6', 'FECHA');
                        $objPHPExcel->getActiveSheet()->mergeCells('B6:B7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('C6', 'NO. DOC.');
                        $objPHPExcel->getActiveSheet()->mergeCells('C6:C7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('D6', 'DESCRIPCIÓN');
                        $objPHPExcel->getActiveSheet()->mergeCells('D6:D7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('E6', 'PROVEEDOR');
                        $objPHPExcel->getActiveSheet()->mergeCells('E6:E7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('F6', 'NACIONALIDAD');
                        $objPHPExcel->getActiveSheet()->mergeCells('F6:F7');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G6', 'DESCRIPCIÓN DEL PRODUCTO');
                        $objPHPExcel->getActiveSheet()->mergeCells('G6:H6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('G7', 'PRECIO UNITARIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('H7', 'COSTO PROMEDIO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I6', 'UNIDADES');
                        $objPHPExcel->getActiveSheet()->mergeCells('I6:K6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('I7', 'ENTRADAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('J7', 'SALIDAS');

                        $objPHPExcel->getActiveSheet()->SetCellValue('K7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L6', 'VALORES');
                        $objPHPExcel->getActiveSheet()->mergeCells('L6:N6');

                        $objPHPExcel->getActiveSheet()->SetCellValue('L7', 'DEBE');

                        $objPHPExcel->getActiveSheet()->SetCellValue('M7', 'HABER');

                        $objPHPExcel->getActiveSheet()->SetCellValue('N7', 'SALDO');

                        $objPHPExcel->getActiveSheet()->getStyle('A6:N7')->applyFromArray($style_bordes_all);
                    /* */

                    
                    //DATOS INICIALES
                    $resultado = [];
                    $i = 1;
                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $filaActual = 8;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;                
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini); 

                    //$this->highlight_array($transaccionesIniciales);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    $fecha = date_format(date_create($fechaini),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO INICIAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual, $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);
                    
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;
                    
                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    if($transacciones == false){
                        $transacciones = [];
                    }

                    foreach($transacciones as $tran){
                        $i++;
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                        $nacionalidad = '';
                        $descripProveedor = '';

                        //calculo del costo promedio 
                        //se toman los saldos del registro anterior
                        if($saldoInicialUnidades != 0){
                            $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                        }

                        //SALIDA
                        if($tran['inopera'] == -1){ 
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            $totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                            $saldoInicialValores += $valorHaber;
                            $totalHaber += $valorHaber;

                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            $totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            $totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                //DATOS DEL PROVEEDOR SI ES COMPRA
                                if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                                }
        
                                if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                                }
                            }
                        }
                        $fecha = date_format(date_create($tran['fecha']),'d/m/Y');

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, $tran['serie'].$tran['numero']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, $tran['descripDoc']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, $descripProveedor);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, $nacionalidad);
                        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, $precioUnitario);
                        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($unidadEntrada));
                        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($unidadSalida));
                        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($valorDebe));
                        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($valorHaber));
                        $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                        $objPHPExcel->getActiveSheet()->getStyle('G'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.000000_-;-* #,##0.000000_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                        $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);

                        
                        $filaActual++;
                    }

                    //SALDO FINAL
                    $i++;
                
                    $fecha = date_format(date_create($fechafin),'d/m/Y');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$filaActual, $i);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, $fecha);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$filaActual, 'SALDO FINAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$filaActual, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$filaActual,  $costopromedio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$filaActual, abs($totalEntradas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$filaActual, abs($totalSalidas));
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, $saldoInicialUnidades);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$filaActual,  abs($totalDebe));
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$filaActual, abs($totalHaber));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$filaActual, $saldoInicialValores);

                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':C'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('I'.$filaActual.':N'.$filaActual)->getNumberFormat()->setFormatCode('_-* #,##0.00_-;-* #,##0.00_-;_-* "-"??_-;_-@_-');
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_bordes);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual +=5;

                    //FIRMAS 
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'F. __________________________________');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    $filaActual++;

                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$filaActual, 'Representante Legal y/o Propietario');
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$filaActual.':D'.$filaActual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$filaActual, 'Encargado de Bodega');
                    $objPHPExcel->getActiveSheet()->mergeCells('K'.$filaActual.':M'.$filaActual);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_align_center);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$filaActual.':N'.$filaActual)->applyFromArray($style_text_bold);

                    //AUMENTA EL NUMERO DE HOJAS DE TRABAJO
                    $hojaTrabajoActual++;
                }

				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Reporte de Kardex.xlsx"');
				header('Cache-Control: max-age=0');
				$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
				$objWriter->save('php://output'); 
				exit;
            }
        }

		function registroControlInventariosPdf($idproducto, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle("Reporte de Kardex");
                $pdf->SetSubject("Reporte de Kardex");

                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 8, '', true);
                $pdf->SetAutoPageBreak(TRUE, 10);
                $function = $this->uri->segment(3);

                $inicioY = 38;
                $nombre_doc = "Reporte de Kardex";

                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('auxi_model');
                $this->load->model('producto_model');
                $this->load->model('global_model');

                $arrayIdProducto = explode("-", $idproducto);

                foreach($arrayIdProducto as $idproducto){
                    $pdf->resetHeaderTemplate();
                    $fichaProducto = $this->producto_model->getProducto($idproducto);
                    $nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                    $nrc = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);

                    $header = '<table style="width:100%; padding:0;">';
                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.$this->session->userdata('descrip').'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.strtoupper($nombre_doc).'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 15px">';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; font-weight: bold"></td>';
                        $header .= '<td style="text-align: center; width: 60%; padding: 0; font-weight: bold">'.strtoupper($fichaProducto->descrip).'</td>';
                        $header .= '<td style="text-align: right; width: 20%; padding: 0; font-weight: bold; "></td>';
                        $header .= '</tr>';

                        $header .= '<tr>';
                        $header .= '<td style="text-align: center; width: 100%; padding: 0; font-weight: bold"></td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 12px">';
                        $header .= '<td style="text-align: center; width: 30%; padding: 0; border: 1px solid black; font-weight: bold">UNIDAD DE MEDIDAS</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">NIT</td>';
                        $header .= '<td style="text-align: center; width: 10%; padding: 0; border: 1px solid black; font-weight: bold">NRC</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">PERIODO</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black; font-weight: bold">CÓDIGO</td>';
                        $header .= '</tr>';

                        $header .= '<tr style="font-size: 12px">';
                        $header .= '<td style="text-align: center; width: 30%; padding: 0; border: 1px solid black;">'.strtoupper($fichaProducto->um).'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.$nit.'</td>';
                        $header .= '<td style="text-align: center; width: 10%; padding: 0; border: 1px solid black;">'.$nrc.'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.date_format(date_create($fechaini),'d/m/Y').' - '.date_format(date_create($fechafin),'d/m/Y').'</td>';
                        $header .= '<td style="text-align: center; width: 20%; padding: 0; border: 1px solid black;">'.strtoupper($fichaProducto->modelo).'</td>';
                        $header .= '</tr>';
                    $header .= '</table>';
                    $pdf->setHtmlHeader($header);
                    
                    $pdf->SetPrintHeader(true);
                    $pdf->SetMargins(8, $inicioY, 8, true);

                    //  FOOTER
                    date_default_timezone_set('America/El_Salvador');
                    $date = new DateTime();
                    $footer = '<br><br><br><br><table style="width:100%;font-size: 12px;">';
                    $footer .= '<tr>';
                    $footer .= '<td style="text-align: left; width: 50%; padding: 0; ">'.date_format($date, 'd/m/Y h:i a').'</td>';
                    $footer .= '<td style="text-align: right; width: 50%; padding: 0; ">PÁG. '.trim($pdf->getAliasNumPage()).'/'.trim($pdf->getAliasNbPages()).'</td>';

                    $footer .= '</tr>';
                    $footer .= '</table>';
                    $pdf->SetFooterMargin(0, 0, 0, 0);
                    $pdf->setHtmlFooter($footer);
                    $pdf->SetPrintFooter(true);

                    //DATOS INICIALES
                    $resultado = [];

                    $costopromedio = 0;
                    $saldoInicialValores = 0;
                    $saldoInicialUnidades = 0;
                    $filaActual = 8;
                    $i = 1;

                    //TOTALES
                    $totalEntradas = 0;
                    $totalSalidas = 0;
                    $totalDebe = 0;
                    $totalHaber = 0;                
                    $transaccionesIniciales = $this->invtran_model->getDatosPreviosF142($idcentro, $idproducto, $fechaini);

                    $tabla = '<table style="width:100%; padding:0;">';
                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="width: 3%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NO.</td>';
                    $tabla .= '<td style="width: 5%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">FECHA</td>';
                    $tabla .= '<td style="width: 11%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NO. DOC.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">DESCRIPCIÓN</td>';
                    $tabla .= '<td style="width: 11%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">PROVEEDOR</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">NACIONALIDAD</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">PRE. UNI.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">CTO. PROM.</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">ENTRADAS</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALIDAS</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALDO</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">DEBE</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">HABER</td>';
                    $tabla .= '<td style="width: 7%; text-align: center; padding: 0; border: 1px solid black; font-weight: bold">SALDO</td>';
                    $tabla .= '</tr>';
                    //$this->highlight_array($transaccionesIniciales);
                    foreach($transaccionesIniciales as $tran){
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                    

                        //SALIDA
                        if($tran['inopera'] == -1){
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            //$totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorHaber;
                            //$totalHaber += $valorHaber;

                        
                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            //$totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            //$totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];
                        }
                    }

                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    $fecha = date_format(date_create($fechaini),'d/m/Y');

                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$i.'</td>';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$fecha.'</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold">SALDO INICIAL</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($costopromedio, 6, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialValores, 2, '.','').'</td>';
                    $tabla .= '</tr>';
                
                    
                    //DATOS DE LAS TRANSACCIONES
                    $transacciones = $this->invtran_model->getDatosF142($idcentro, $idproducto, $fechaini, $fechafin);

                    if($transacciones == false){
                        $transacciones = [];
                    }

                    foreach($transacciones as $tran){
                        $i++;
                        $unidadEntrada = 0;
                        $unidadSalida = 0;

                        $valorDebe = 0;
                        $valorHaber = 0;
                        $precioUnitario = 0;
                        $nacionalidad = '';
                        $descripProveedor = '';

                        //calculo del costo promedio 
                        //se toman los saldos del registro anterior
                        if($saldoInicialUnidades != 0){
                            $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                        }

                        //SALIDA
                        if($tran['inopera'] == -1){ 
                            //Unidades
                            $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadSalida;
                            $totalSalidas += $unidadSalida;

                            //Valores
                            $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                            $saldoInicialValores += $valorHaber;
                            $totalHaber += $valorHaber;

                        //ENTRADA
                        }else{  
                            //Unidades
                            $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                            $saldoInicialUnidades += $unidadEntrada;
                            $totalEntradas += $unidadEntrada;

                            //Valores
                            $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                            $saldoInicialValores += $valorDebe; 
                            $totalDebe += $valorDebe;

                            $precioUnitario = $tran['costounitario'];

                            if($tran['agrupa'] == 'CO'){
                                //DATOS DEL PROVEEDOR SI ES COMPRA
                                if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                                }
        
                                if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                    $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                                }
                            }
                        }
                        $fecha = date_format(date_create($tran['fecha']),'d/m/Y');

                        $tabla .= '<tr style="font-size: 8px">';
                        $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; ">'.$i.'</td>';
                        $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; ">'.$fecha.'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$tran['serie'].$tran['numero'].'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$tran['descripDoc'].'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$descripProveedor.'</td>';
                        $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; ">'.$nacionalidad.'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($precioUnitario, 6, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($costopromedio, 6, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($unidadEntrada), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($unidadSalida), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($valorDebe), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format(abs($valorHaber), 2, '.','').'</td>';
                        $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; ">'.number_format($saldoInicialValores, 2, '.','').'</td>';
                        $tabla .= '</tr>';

                    }

                    $i++;
                    $tabla .= '<tr style="font-size: 8px">';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$i.'</td>';
                    $tabla .= '<td style="text-align: center; padding: 0; border: 1px solid black; font-weight: bold">'.$fecha.'</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold">SALDO FINAL</td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: left; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold"></td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($costopromedio, 6, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format(abs($totalEntradas), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format(abs($totalSalidas), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'.number_format($saldoInicialUnidades, 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format(abs($totalDebe), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format(abs($totalHaber), 2, '.','').'</td>';
                    $tabla .= '<td style="text-align: right; padding: 0; border: 1px solid black; font-weight: bold">'. number_format($saldoInicialValores, 2, '.','').'</td>';
                    $tabla .= '</tr>';

                    $tabla .= '</table>';
                    $pdf->addPage('L', 'LETTER');
                    $pdf->SetY( $inicioY );            
                    $pdf->writeHTML($tabla, true, false, true, false, ''); 
                }

				//var_dump($info);
                $nombre_archivo = utf8_decode("Reporte_Kardex.pdf");
                $pdf->Output($nombre_archivo, 'I');
				exit;
            }
        }

        function registroControlInventariosAllExcel($idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
				$objPHPExcel = new Spreadsheet();
				$objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Registro de Control de Inventario") // Titulo
                ->setSubject("Registro de Control de Inventario") //Asunto
                ->setDescription("Registro de Control de Inventario") //Descripción
                ->setKeywords("Registro de Control de Inventario") //Etiquetas
                ->setCategory("Registro de Control de Inventario"); //Categorias
				$objPHPExcel->setActiveSheetIndex(0);

				/* Estilos */
				$style_titulo = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					),
					'font'  => array(
						'bold'  => true,
						'color' => array('rgb' => '000000'),
						'size'  => 20,
						'name'  => 'Verdana'
					)
				);

				$style_subtitulo = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					),
					'font'  => array(
						'color' => array('rgb' => '000000'),
						'size'  => 15,
						'name'  => 'Verdana'
					)
				);

                $style_header_tabla = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
					),
					'font'  => array(
						'bold' => true,
						'color' => array('rgb' => 'FFFFFF'),
						'size'  => 11,
						'name'  => 'Calibri'
					),
					'fill' => [
						'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
						'startColor' => [
							'rgb' => '336699',
						],
					],
				);

				$style_categoria = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
					),
					'font'  => array(
						'bold'  => true,
						'color' => array('rgb' => '000000'),
						'size'  => 12,
						'name'  => 'Verdana'
					)
				);

				$style_num = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					),
					'font'  => array(
						'bold' => false,
						'size'  => 11,
						'color' => array('rgb' => '000000'),
						'name'  => 'Calibri'
					),
					'numberFormat' => [
						'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE
					]
				);

				$style_num_total = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					),
					'font'  => array(
						'bold'  => true,
						'color' => array('rgb' => '000000'),
						'size'  => 11,
						'name'  => 'Calibri'
					),
					'numberFormat' => [
						'formatCode' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE
					]
				);

				$style_total = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					),
					'font'  => array(
						'bold'  => true,
						'color' => array('rgb' => '000000'),
						'size'  => 11,
						'name'  => 'Calibri'
					)
				);

				$style_bordes = array(
					'borders' => [
						'allBorders' => [
							'color' => ['argb' => '000000'],
						],
					],
				);

                $style_bordes_all = array(
					'borders' => [
						'allBorders' => [
							'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
							'color' => ['argb' => '000000'],
						],
					],
				);

				$style_num_porcentaje = array(
					'alignment' => array(
						'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					),
					'font'  => array(
						'size'  => 11,
						'bold' => false,
						'color' => array('rgb' => '000000'),
						'name'  => 'Verdana'
					),
					'numberFormat' => [
						'code' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
					]
				);

                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
            
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('auxi_model');
                $function = $this->uri->segment(3);
                $nombre_doc = "Registro de Control de Inventario";

				/* Encabezado */
				$objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);
				$objPHPExcel->getActiveSheet()->setCellValue('A1', $nombre_doc);
				$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($style_titulo);
				$objPHPExcel->getActiveSheet()->mergeCells('A1:M1');


				$objPHPExcel->getActiveSheet()->setCellValue('A2', $this->session->userdata('descrip'));
				$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_subtitulo);
				$objPHPExcel->getActiveSheet()->mergeCells('A2:M2');

                //
                $objPHPExcel->getActiveSheet()->setCellValue('A4', "UNIDAD DE MEDIDAS: ");
				$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($style_header_tabla);
				$objPHPExcel->getActiveSheet()->mergeCells('A4:D4');

                $objPHPExcel->getActiveSheet()->setCellValue('E4', "PERIODO: ");
				$objPHPExcel->getActiveSheet()->getStyle('E4')->applyFromArray($style_header_tabla);
				$objPHPExcel->getActiveSheet()->mergeCells('E4:K4');

                $objPHPExcel->getActiveSheet()->setCellValue('E4', "CÓDIGO: ");
				$objPHPExcel->getActiveSheet()->getStyle('E4')->applyFromArray($style_header_tabla);
				$objPHPExcel->getActiveSheet()->mergeCells('L4:M4');

                $objPHPExcel->getActiveSheet()->setCellValue('A5', "PRODUCTO");
				$objPHPExcel->getActiveSheet()->getStyle('A5')->applyFromArray($style_header_tabla);
				$objPHPExcel->getActiveSheet()->mergeCells('A5:M5');
                //

				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
				$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
				$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
				$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);

                //
				$objPHPExcel->getActiveSheet()->SetCellValue('A6', 'NO.');
                $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('A6:A7');

				$objPHPExcel->getActiveSheet()->SetCellValue('B6', 'FECHA');
                $objPHPExcel->getActiveSheet()->getStyle('B6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('B6:B7');

				$objPHPExcel->getActiveSheet()->SetCellValue('C6', 'NO. DOC.');
                $objPHPExcel->getActiveSheet()->getStyle('C6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('C6:C7');

				$objPHPExcel->getActiveSheet()->SetCellValue('D6', 'DESCRIPCIÓN');
                $objPHPExcel->getActiveSheet()->getStyle('D6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('D6:D7');

				$objPHPExcel->getActiveSheet()->SetCellValue('E6', 'NACIONALIDAD');
                $objPHPExcel->getActiveSheet()->getStyle('E6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('E6:E7');

                $objPHPExcel->getActiveSheet()->SetCellValue('F6', 'DESCRIPCIÓN DEL PRODUCTO');
                $objPHPExcel->getActiveSheet()->getStyle('F6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('F6:G6');

                $objPHPExcel->getActiveSheet()->SetCellValue('F7', 'PRECIO UNITARIO');
                $objPHPExcel->getActiveSheet()->getStyle('F7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('G7', 'COSTO PROMEDIO');
                $objPHPExcel->getActiveSheet()->getStyle('G7')->applyFromArray($style_bordes);

				$objPHPExcel->getActiveSheet()->SetCellValue('H6', 'UNIDADES');
                $objPHPExcel->getActiveSheet()->getStyle('H6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('H6:J6');

                $objPHPExcel->getActiveSheet()->SetCellValue('H7', 'ENTRADAS');
                $objPHPExcel->getActiveSheet()->getStyle('H7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('I7', 'SALIDAS');
                $objPHPExcel->getActiveSheet()->getStyle('I7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('J7', 'SALDO');
                $objPHPExcel->getActiveSheet()->getStyle('J7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('K6', 'VALORES');
                $objPHPExcel->getActiveSheet()->getStyle('K6')->applyFromArray($style_bordes);
				$objPHPExcel->getActiveSheet()->mergeCells('K6:M6');

                $objPHPExcel->getActiveSheet()->SetCellValue('K7', 'DEBE');
                $objPHPExcel->getActiveSheet()->getStyle('K7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('L7', 'HABER');
                $objPHPExcel->getActiveSheet()->getStyle('L7')->applyFromArray($style_bordes);

                $objPHPExcel->getActiveSheet()->SetCellValue('M7', 'SALDO');
                $objPHPExcel->getActiveSheet()->getStyle('M7')->applyFromArray($style_bordes);
                //

				
                //DATOS INICIALES
                $resultado = [];

                $costopromedio = 0;
                $saldoInicialValores = 0;
                $saldoInicialUnidades = 0;
                $i = 1;

                //TOTALES
                $totalEntradas = 0;
                $totalSalidas = 0;
                $totalDebe = 0;
                $totalHaber = 0;                
                $transaccionesIniciales = $this->invtran_model->getDatosPreviosAllF142($idcentro, $fechaini);

                /*
                    // Desglose de cuentas 
                    foreach($info as $i){

                        // Verifica que haya un cambio de vendedor en el listado
                        if($ultimo_vendedor != $i->idworker){
                            // Verifica que el subtotal del vendedor no sea cero
                            if($subtotal_categoria != 0){
                                $ultimo_vendedor = $i->idworker;
                                $objPHPExcel->getActiveSheet()->SetCellValue('A'. $fila_actual, 'SUBTOTAL');
                                $objPHPExcel->getActiveSheet()->getStyle('A'. $fila_actual)->applyFromArray($style_total);
                                $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila_actual.':'.'B'.$fila_actual);

                                $objPHPExcel->getActiveSheet()->SetCellValue('C'. $fila_actual, $subtotal_1_30);
                                $objPHPExcel->getActiveSheet()->SetCellValue('D'. $fila_actual, $subtotal_31_60);
                                $objPHPExcel->getActiveSheet()->SetCellValue('E'. $fila_actual, $subtotal_61_90);
                                $objPHPExcel->getActiveSheet()->SetCellValue('F'. $fila_actual, $subtotal_91_120);
                                $objPHPExcel->getActiveSheet()->SetCellValue('G'. $fila_actual, $subtotal_121);
                                $objPHPExcel->getActiveSheet()->SetCellValue('H'. $fila_actual, $subtotal_categoria);
                                $objPHPExcel->getActiveSheet()->getRowDimension($fila_actual)->setRowHeight(25);
                                $objPHPExcel->getActiveSheet()->getStyle('C'. $fila_actual.':'.'H'.$fila_actual)->applyFromArray($style_num_total);

                                $total_1_30 += $subtotal_1_30;
                                $total_31_60 += $subtotal_31_60;
                                $total_61_90 += $subtotal_61_90;
                                $total_91_120 += $subtotal_91_120;
                                $total_121 += $subtotal_121;

                                $total += $subtotal_categoria;
                                $subtotal_1_30 = 0;
                                $subtotal_31_60 = 0;
                                $subtotal_61_90 = 0;
                                $subtotal_91_120 = 0;
                                $subtotal_121 = 0;
                                $subtotal_categoria  = 0;

                                $fila_actual++;
                            }
                            // Muestra el nombre del nuevo vendedor
                            $ultimo_vendedor = $i->idworker;
                            $objPHPExcel->getActiveSheet()->SetCellValue('A'. $fila_actual, trim(strtoupper($i->vendedor)));
                            $objPHPExcel->getActiveSheet()->getStyle('A'. $fila_actual)->applyFromArray($style_categoria);
                            $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila_actual.':'.'J'.$fila_actual);
                            $objPHPExcel->getActiveSheet()->getRowDimension($fila_actual)->setRowHeight(25);

                            $fila_actual++;
                        }

                        $saldo_total = (float)$i->sum_1_30 + (float)$i->sum_31_60 + (float)$i->sum_61_90 + (float)$i->sum_91_120 + (float)$i->sum_121;
                        $disponible = (float)$i->limite - (float)$saldo_total;
                        $subtotal_categoria += (float)$saldo_total;

                        $objPHPExcel->getActiveSheet()->SetCellValue('A'. $fila_actual, $i->nrc);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'. $fila_actual, trim($i->cliente));

                        if(round($i->sum_1_30, 2) != 0){
                            $subtotal_1_30 += (float)$i->sum_1_30; //$i->sum_1_30
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'. $fila_actual, $i->sum_1_30);
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'. $fila_actual, "");
                        }

                        if(round($i->sum_31_60, 2) != 0){
                            $subtotal_31_60 += (float)$i->sum_31_60;
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'. $fila_actual, $i->sum_31_60);
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'. $fila_actual, "");
                        }

                        if(round($i->sum_61_90, 2) != 0){
                            $subtotal_61_90 += (float)$i->sum_61_90;
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'. $fila_actual, $i->sum_61_90);
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'. $fila_actual, "");
                        }

                        if(round($i->sum_91_120, 2) != 0){
                            $subtotal_91_120 += (float)$i->sum_91_120;
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'. $fila_actual, $i->sum_91_120);
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'. $fila_actual, "");
                        }

                        if(round($i->sum_121, 2) != 0){
                            $subtotal_121 += (float)$i->sum_121;
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'. $fila_actual, $i->sum_121);
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'. $fila_actual, "");
                        }

                        $objPHPExcel->getActiveSheet()->SetCellValue('H'. $fila_actual, $saldo_total);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I'. $fila_actual, $i->limite);
                        $objPHPExcel->getActiveSheet()->SetCellValue('J'. $fila_actual, $disponible);
                        $objPHPExcel->getActiveSheet()->getStyle('C'. $fila_actual.':'.'J'.$fila_actual)->applyFromArray($style_num);


                        $fila_actual++;
                        
                    }
                    //	Subtotales de ultimo vendedor 
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'. $fila_actual, 'SUBTOTAL');
                    $objPHPExcel->getActiveSheet()->getStyle('A'. $fila_actual)->applyFromArray($style_total);
                    $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila_actual.':'.'B'.$fila_actual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C'. $fila_actual, $subtotal_1_30);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'. $fila_actual, $subtotal_31_60);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'. $fila_actual, $subtotal_61_90);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'. $fila_actual, $subtotal_91_120);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'. $fila_actual, $subtotal_121);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'. $fila_actual, $subtotal_categoria);
                    $objPHPExcel->getActiveSheet()->getRowDimension($fila_actual)->setRowHeight(25);
                    $objPHPExcel->getActiveSheet()->getStyle('C'. $fila_actual.':'.'H'.$fila_actual)->applyFromArray($style_num_total);

                    $total_1_30 += $subtotal_1_30;
                    $total_31_60 += $subtotal_31_60;
                    $total_61_90 += $subtotal_61_90;
                    $total_91_120 += $subtotal_91_120;
                    $total_121 += $subtotal_121;
                    $total += $subtotal_categoria;
                    $fila_actual++;

                    //	Totales del reporte
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'. $fila_actual, 'TOTAL');
                    $objPHPExcel->getActiveSheet()->getStyle('A'. $fila_actual)->applyFromArray($style_total);
                    $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila_actual.':'.'B'.$fila_actual);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C'. $fila_actual, $total_1_30);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'. $fila_actual, $total_31_60);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'. $fila_actual, $total_61_90);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'. $fila_actual, $total_91_120);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'. $fila_actual, $total_121);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'. $fila_actual, $total);
                    $objPHPExcel->getActiveSheet()->getRowDimension($fila_actual)->setRowHeight(25);
                    $objPHPExcel->getActiveSheet()->getStyle('C'. $fila_actual.':'.'H'.$fila_actual)->applyFromArray($style_num_total);

                    $fila_actual++;
                */

				//$this->highlight_array($transaccionesIniciales);
                foreach($transaccionesIniciales as $tran){
                    $unidadEntrada = 0;
                    $unidadSalida = 0;

                    $valorDebe = 0;
                    $valorHaber = 0;
                    $precioUnitario = 0;
                  

                    //SALIDA
                    if($tran['inopera'] == -1){
                        //Unidades
                        $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                        $saldoInicialUnidades += $unidadSalida;
                        $totalSalidas += $unidadSalida;

                        //Valores
                        $valorHaber = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                        $saldoInicialValores += $valorHaber;
                        $totalHaber += $valorHaber;

                      
                    //ENTRADA
                    }else{  
                        //Unidades
                        $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                        $saldoInicialUnidades += $unidadEntrada;
                        $totalEntradas += $unidadEntrada;

                        //Valores
                        $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                        $saldoInicialValores += $valorDebe; 
                        $totalDebe += $valorDebe;

                        $precioUnitario = $tran['costounitario'];

                        if($tran['agrupa'] == 'CO'){
                            if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                            }
    
                            if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                            }
                        }
                    }
                }

                if($saldoInicialUnidades != 0){
                    $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                }

                //SALDO INICIAL
                $resultado[] = array(
                    "no" => $i,
                    "trannum" =>  '',
                    "fecha" =>'',
                    "numDoc" => '',
                    "tipoDoc" => 'Saldo Inicial',
                    "descripProveedor" => '',
                    "nacionalidad" => '',
                    "precioUnitario" => '',
                    "costoUnitario" => $costopromedio,
                    "unidadEntrada" => '',
                    "unidadSalida" => '',
                    "unidadSaldo" => $saldoInicialUnidades,
                    "valorEntrada" => '',
                    "valorSalida" => '',
                    "valorSaldo" => $saldoInicialValores,
                    "agrupa" => '',

                );
                
                //DATOS DE LAS TRANSACCIONES
                $transacciones = $this->invtran_model->getDatosAllF142($idcentro, $fechaini, $fechafin);

                if($transacciones == false){
                    $transacciones = [];
                }

                foreach($transacciones as $tran){
                    $i++;
                    $unidadEntrada = 0;
                    $unidadSalida = 0;

                    $valorDebe = 0;
                    $valorHaber = 0;
                    $precioUnitario = 0;
                    $nacionalidad = '';
                    $descripProveedor = '';

                    //calculo del costo promedio 
                    //se toman los saldos del registro anterior
                    if($saldoInicialUnidades != 0){
                        $costopromedio = $saldoInicialValores / $saldoInicialUnidades;
                    }

                    //SALIDA
                    if($tran['inopera'] == -1){ 
                        //Unidades
                        $unidadSalida = $tran['cantidad']*$tran['uniconv'];
                        $saldoInicialUnidades += $unidadSalida;
                        $totalSalidas += $unidadSalida;

                        //Valores
                        $valorHaber = $tran['cantidad']*$tran['uniconv']*$costopromedio;
                        $saldoInicialValores += $valorHaber;
                        $totalHaber += $valorHaber;

                    //ENTRADA
                    }else{  
                        //Unidades
                        $unidadEntrada = $tran['cantidad']*$tran['uniconv'];
                        $saldoInicialUnidades += $unidadEntrada;
                        $totalEntradas += $unidadEntrada;

                        //Valores
                        $valorDebe = $tran['cantidad']*$tran['uniconv']*$tran['costounitario'];
                        $saldoInicialValores += $valorDebe; 
                        $totalDebe += $valorDebe;

                        $precioUnitario = $tran['costounitario'];

                        if($tran['agrupa'] == 'CO'){
                            //DATOS DEL PROVEEDOR SI ES COMPRA
                            if(array_key_exists('pais',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                $nacionalidad = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['pais'];
                            }
    
                            if(array_key_exists('descrip',$this->auxi_model->getNacionalidadAuxi($tran['idcps']))){
                                $descripProveedor = $this->auxi_model->getNacionalidadAuxi($tran['idcps'])['descrip'];
                            }
                        }
                    }

                    $resultado[] = array(
                        "no" => $i,
                        "trannum" =>  $tran['trannum'],
                        "fecha" => $tran['fecha'],
                        "numDoc" => $tran['serie'].$tran['numero'],
                        "tipoDoc" => $tran['descripDoc'],
                        "descripProveedor" => $descripProveedor,
                        "nacionalidad" => $nacionalidad,
                        "precioUnitario" => $precioUnitario,
                        "costoUnitario" => $costopromedio,
                        "unidadEntrada" => abs($unidadEntrada),
                        "unidadSalida" => abs($unidadSalida),
                        "unidadSaldo" => $saldoInicialUnidades,
                        "valorEntrada" => abs($valorDebe),
                        "valorSalida" => abs($valorHaber),
                        "valorSaldo" => $saldoInicialValores,
                        "agrupa" => $tran['agrupa'],

                    );
                }

                //SALDO FINAL
                $i++;
                $resultado[] = array(
                    "no" => $i,
                    "trannum" =>  '',
                    "fecha" => $fechafin,
                    "numDoc" => '',
                    "tipoDoc" => 'Saldo Final',
                    "descripProveedor" => '',
                    "nacionalidad" => '',
                    "precioUnitario" => 0,
                    "costoUnitario" => 0,
                    "unidadEntrada" => abs($totalEntradas),
                    "unidadSalida" => abs($totalSalidas),
                    "unidadSaldo" => 0,
                    "valorEntrada" => abs($totalDebe),
                    "valorSalida" => abs($totalHaber),
                    "valorSaldo" => 0,
                    "agrupa" => '',

                );

				//var_dump($info);

				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="Registro de Control de Inventarios.xlsx"');
				header('Cache-Control: max-age=0');
				$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
				$objWriter->save('php://output'); 
				exit;
            }
        }
	}
?>