<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
        
        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}
		
		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
        
        function impresionTicketTxt($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $archivoTxt = fopen('DocumentoImpresion.txt','w+');
                
                $this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				$this->load->model('empleado_model');
                $this->load->model('sucursal_model');
				$this->load->model('caja_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);                
				$infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
                
                
                foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}
                
                foreach($informacion as $info){
                    $idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
                    $serieDocumento = $info->serie;
                    $numeroRecibo = $info->numero;
                    $fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
                    $cliente = $info->nameCliente;
                    $clienteTipo = $info->idtipo;
                    $nrc = $info->nrc;
                    $nit = $info->nit;
                    $direccion = $info->direccion;
                    $giro = $info->giro;
                    $zip_info = $this->empleado_model->getDeptoMunicipio($info->idzip);
                    $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                }
                
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);

                $productos = $this->acs_model->getDataVenta100k($trannum);
                $pagosCredito = $this->ventas_model->getDetallePagosVentas($trannum);

                $findRetencion = 0; $valRetencion = 0;
                
                
                $contenidoHeader = '@ 10,00 Say "'.$RazonSocial.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 11,00 Say "N°'.$serieDocumento.$numeroRecibo.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 12,00 Say "Cliente: '.strtoupper($cliente).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 13,00 Say "Dirección: '.$direccion.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 14,00 Say "Departamento y Municipio: '.$depto_municipio.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 15,00 Say "NRC: '.$nrc.' NIT: '.$nit.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 16,00 Say "Fecha: '.$fechaRecibo.'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                
                $contenidoHeader = '@ 17,00 Say "Giro: '.strtoupper($giro).'"';
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");
                fwrite($archivoTxt, "\r\n");
                
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
                $total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                $CooNum = 17;
                foreach($productos as $pro){
                    if($pro->tax1 != 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta = "";
                        $vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                    }else if($pro->tax1 != 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tax1== 0 && $invexento == 0){
                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        $vnGravada = "";
                    }else if($pro->tax1 == 0 && $invexento == 1){
                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        
                        $vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
                        $vnGravada = "";
                    }
                    
                    $preciouni = $pro->precioneto;
                    $descripProducto = $pro->notas;
                    $totalLetras = strlen($descripProducto);
                    $CooNum= +1;
                    $contenidoProductos ='@'.$CooNum.',00 Say "Giro: '. $pro->idproducto.'"'.$descripProducto.' '.abs($pro->cantidad). ' $'.number_format(round($preciouni, 2), 2 ,'.','').' $'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoProductos);
                    fwrite($archivoTxt, "\r\n");
                }
                
                fwrite($archivoTxt, "\r\n");
                $totalGravIva = $totalGravado + $totalIVA;

                if($clienteTipo == 3){
                    if($totalGravado >= 100){
                        $findRetencion = 1;
                        $valRetencion = $totalGravado * 0.01;
                    }
                }

                if($valRetencion != 0){
                    $total = $total - $valRetencion;
                }

                $numero = number_format(round($total, 2), 2 ,'.','');
                $TotalLetras = $this->convertir_a_letras($numero);

                if($findRetencion == 0){
                    $contenidoTotales = 'SON: '.strtoupper($TotalLetras).'/100 US DOLARES';
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Vta Exentas: $'.number_format(round($totalExento, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Vta Gravadas: $'.number_format(round($totalGravado, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'IVA 13%: $'.number_format(round($totalIVA, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Total: $'.number_format(round($total, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                }else{
                    $contenidoTotales = 'SON: '.strtoupper($TotalLetras).'/100 US DOLARES';
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Vta Exentas: $'.number_format(round($totalExento, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Vta Gravadas: $'.number_format(round($totalGravado, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'IVA 13%: $'.number_format(round($totalIVA, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Ret 1%: -$'.number_format(round($valRetencion, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                    
                    $contenidoTotales = 'Total: $'.number_format(round($total, 2), 2 ,'.','');
                    fwrite($archivoTxt, $contenidoTotales);
                    fwrite($archivoTxt, "\r\n");
                }
                
                fclose($archivoTxt);
                
                $docTxt = "DocumentoImpresion.txt";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink('DocumentoImpresion.txt');
                    exit;
                }
            }
        }
    }
?>