<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {

        function __construct() {
            parent::__construct();
            //$this->load->model('pdfs_model');
        }

        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
    
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
 
            # devolvemos el array de valores
            return $info;
        }

        function factura_pdf_nuevo($numero){
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/

            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                            /*if(isset($imagen) and $imagen!=""){
                                $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                            }*/

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ticket_nuevo($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage( 'P',$pagelayout);

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

                if(is_array($products) && $products!=false){
                    $sucursal = strtoupper($products['descrip']);
                    $pedido = $products['numero'];
                    $cli_name = $products['cli_name'];
                    $cli_phone = $products['cli_phone'];
                    $date = date_format(date_create($products['date']),'d/m/Y');
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_refund = $products['val_refund'];
                    $tpastel = $products['val_pastel'];
                    $taccesorios = $products['val_acc'];
                    $tbases = $products['val_bases'];
                    $tenvio = $products['val_envio'];

                    $cli_email = $products['cli_email'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $imagen = $products['pastel_fotos'];
                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $dev_contact = $products['dev_contact'];
                    $dev_phone = $products['dev_phone'];

                    $lugar = "";
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3) {
                        $lugar = "Recoger en Producción";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];

                    $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                }else{
                    redirect('pedidos_clientes/pasteles_al_gusto/');
                }

        
                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE PASTELES</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date2.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';

                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                        
                     $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pastel</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Tortas:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cktortas.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Porciones:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$ckslices.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Referencia:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$catreference.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Dedicatoria:</td>
                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';
                    
                    $i = 1;
                    foreach($arrayPasteles as $key => $value){

                        $estructura .= '<table style="width:100%;">
                                            <tr>
                                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Torta '.$i.' </td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Posición:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_position'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Forma:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_shape'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Relleno:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_filling'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Sabor:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_flavor'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Baño:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_bath'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Cobertura:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_covering'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Color:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_color'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px;font-weight: bold; width:30%;">Notas:</td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.ucwords($value['notas']).'</td>
                                            </tr>
                                        </table>';
                        $i++;
                    }
                }

                if($accesorios!=false){

                    $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>ACCESORIOS </td>
                            </tr>';
        
                    foreach($accesorios as $key => $value){
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                       </tr>';
                    }

                    $estructura .= '</table>';
                }

                if($bases!=false){

                    $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>BASES </td>
                                </tr>';
        
                    foreach ($bases as $key => $value) {
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                        </tr>';
                    }
                    
                    $estructura .= '</table>';
                }

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline;"><br><br>OBSERVACIONES </td>
                            </tr>
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-size: 28px;">'.$dev_notes.'</td>
                            </tr></table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PASTEL $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tpastel, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ACCESORIOS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($taccesorios, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">BASES $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tbases, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tenvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">REEMBOLSABLE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function ordenes_pdf($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }

                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    /*if(isset($imagen) and $imagen!=""){
                        $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                    }*/
                    $estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function lista_pdf_nuevo_todo($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS');
                $pdf->SetSubject('LISTADO DE PEDIDOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(1, 2, 1);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 2);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', 'LETTER' );
                
                $fechai = $fecha;
                $fechaf = $fecha;
                if($fechai=="" || $fechaf=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
        
                $sucursales = $this->produccion_model->getPedidosClientes_by_Sucursal(1,$fechai,$fechaf,$estado,1);
                $tdomicilio = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,2);
                $tproduccion = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,3);
                $pedidos_sucursal = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,1);
                $pedidos_domicilio = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,2);
                $pedidos_produccion = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,3);

                $estructura = '';

                $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px;">'.$titulo.'</td>
                                </tr>
                            </table><br><br><br>';

                if($pedidos_sucursal!=false || $pedidos_domicilio!=false || $pedidos_produccion!=false){

                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:18%;">Cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Referencia</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:51%;">Detalles</td>
                                </tr>
                                <tr><td colspan="6"><hr></td></tr>
                            </table>';
                    
                    if(is_array($sucursales) && $sucursales!=false){                
                        foreach ($sucursales as $key => $value) {
                            $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">'.$value['devdirec2'].' ('.$value['totalpedidos'].')</td>
                                </tr>';
                            
                            foreach ($pedidos_sucursal as $key2 => $value2) {
                                
                                if($value['dev_direc']==$value2['dev_direc']){
                                    $cktortas = $value2['ck_tortas'];
                                    $ckslices = $value2['porciones'];
                                    
                                    if($value['dev_direc']==$value2['dev_direc']){
                                        $estructura.= '<tr>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                                        $i=0;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }

                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                                        $i2 = 1;

                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }
                                        
                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb) {
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                $i3++;  
                                            }
                                        }
                                        $estructura.= '</td>
                                            </tr>
                                            <tr><td colspan="6"><hr></td></tr>'; 
                                    }
                                }
                            }
                            $estructura.= '</table>';
                        }
                    }
                    /****************************/
                    if(is_array($pedidos_domicilio) && $pedidos_domicilio!=false){                
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';

                        foreach ($pedidos_domicilio as $key2 => $value2) {
                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                            
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                            
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep){
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                           }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea){
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                
                                foreach ($arrayBases as $keyb => $valueb){
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                    
                        }

                        $estructura.= '</table>';
            
                    }
                    /****************************/
                    
                    /****************************/
                    if(is_array($pedidos_produccion) && $pedidos_produccion!=false){                
                     
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">PRODUCCIÓN ('.$tproduccion.')</td>
                                </tr>';
                        
                        foreach ($pedidos_produccion as $key2 => $value2) {

                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                   
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).','. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }
                            
                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }
                            
                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                        }
                    
                        $estructura.= '</table>';
            
                    }
                  
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
                $nombre_archivo = utf8_decode("listado_pedidos.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function reporte_por_hora($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetSubject('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $fechai = $fecha;
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');

                $horas = $this->produccion_model->get_horas_por_pedido($fechai,$estado);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS POR HORA</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';

                $estructura2.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">Porciones</td>
                                </tr>
                            </table>';                            
                
                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );


                if($horas!=false){
                    if(is_array($horas) && $horas!=false){                
                        foreach ($horas as $key_horas => $value_horas){
                            $estructura.= '<table style="width:100%;">
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_horas['hora'].' ('.$value_horas['npedidosporhora'].')</td>
                                            </tr>';

                            $sucursales = $this->produccion_model->get_sucursales_por_hora_por_pedido($fechai,$estado,$value_horas['dev_time'],1);

                            if(is_array($sucursales) and $sucursales!=false){
                                foreach ($sucursales as $key_sucursales => $value_sucursales) {
                                    $estructura.= '<tr>
                                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                                   </tr>';

                                    $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],1,$value_sucursales['dev_direc']);

                                    if(is_array($pedido) and $pedido!=false){
                                        foreach ($pedido as $key_pedido => $value_pedido) {
                                            $estructura.= '<tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                           </tr>
                                                           <tr>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                           </tr>
                                                           <tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                            $i=1;
                                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                                //$i = count($arrayPasteles);
                                                foreach ($arrayPasteles as $keyp => $valuep) {
                                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                    $i++;  
                                                }
                                            }

                                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                            $i2 = 1;

                                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                                $estructura.= '<b>ACCESORIOS:</b> ';
                                                foreach ($arrayAccesorios as $keya => $valuea) {
                                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                    $i2++;  
                                                }
                                            }

                                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                            $i3 = 1;
                                            
                                            if(is_array($arrayBases) and $arrayBases!=false){
                                                //$i3 = count($arrayBases);
                                                $estructura.= '<b>Bases:</b> ';
                                                foreach ($arrayBases as $keyb => $valueb) {
                                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                    $i3++;  
                                                }
                                            }
                                            $estructura.='</td>
                                            </tr>';
                                        }
                                    }
                                }
                            }

                            $tdomicilio = $this->produccion_model->getCount_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2);

                            if($tdomicilio!=false){
                                $estructura.= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';
                                
                                $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2,'');

                                if(is_array($pedido) and $pedido!=false){
                                    foreach ($pedido as $key_pedido => $value_pedido) {
                                        $estructura.= '<tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                       </tr>
                                                       <tr>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                       </tr>
                                                       <tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                            <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                        $i=1;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            //$i = count($arrayPasteles);
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }
                                        
                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                        $i2 = 1;
                                        
                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }

                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb){
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']);
                                                $i3++;  
                                            }
                                       }

                                        $estructura.='</td>
                                        </tr>';
                                    }
                                }
                            }
                            
                            $estructura.= '</table>';
                        }
                    }
           
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("listado_pedidos_por_hora.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        public function reporte_de_despacho($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE DE DESPACHO');
                $pdf->SetSubject('REPORTE DE DESPACHO');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $fechai = $fecha;
                
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
                
                $sucursales = $this->produccion_model->get_sucursales_reporte_de_despacho($fechai,$estado,1);
                $domicilio = $this->produccion_model->get_total_pedidos_por_dev_place($fechai,$estado,2);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE DE DESPACHO</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';
                     
                $estructura2.= '<table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Hora</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Porciones</td>
                    </tr>
                </table>';                            

                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

            
                if(is_array($sucursales) && $sucursales!=false){    
                    foreach ($sucursales as $key_sucursales => $value_sucursales){
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                </tr>';
                 
                        $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,1,$value_sucursales['dev_direc']);
                 
                        if(is_array($pedidos) and $pedidos!=false){
                            foreach($pedidos as $key_pedido => $value_pedido){
                                $estructura.= '<tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                               </tr>
                                               <tr>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                               </tr>
                                               <tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                    <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                $i=1;
                                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                    //$i = count($arrayPasteles);
                                    foreach ($arrayPasteles as $keyp => $valuep){

                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';

                                      $i++;  
                                    }
                                }

                                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                $i2 = 1;
                                
                                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                    //$i2 = count($arrayAccesorios);
                                    $estructura.= '<b>ACCESORIOS:</b> ';
                                    foreach ($arrayAccesorios as $keya => $valuea){
                                        $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                        $i2++;  
                                    }
                                }

                                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                $i3 = 1;

                                if(is_array($arrayBases) and $arrayBases!=false){
                                    //$i3 = count($arrayBases);
                                    $estructura.= '<b>Bases:</b> ';
                                    foreach ($arrayBases as $keyb => $valueb){
                                        $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                        $i3++;  
                                    }
                                }

                                $estructura.='</td>
                                </tr>';
                            }
                        }
                
                        $estructura.= '</table>';
                    }
                }
                
                if($domicilio!=0){
                       
                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>DOMICILIO ('.$domicilio.')</td>
                                </tr>';
                    
                    $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,2,"");
                 
                    if(is_array($pedidos) and $pedidos!=false){
                        foreach ($pedidos as $key_pedido => $value_pedido){
                            $estructura.= ' <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;"><b>DIRECCIÓN:</b> '.trim($value_pedido['dev_direc']).', <b>PREGUNTAR POR:</b> '.trim($value_pedido['dev_contact']).', <b>TELÉFONO:</b> '.trim($value_pedido['dev_phone']).'
                                                </td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                            $i=1;
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                //$i2 = count($arrayAccesorios);
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }

                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                //$i3 = count($arrayBases);
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.='</td>
                            </tr>';
                        }
                    }
                    $estructura.= '</table>';
                }
                
           
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
    }

?>