<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {

        function __construct(){
			if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
            //$this->load->model('pdfs_model');
        }
		
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
    
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
 
            # devolvemos el array de valores
            return $info;
        }
		
        function factura_pdf_nuevo($numero){
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/
			
			if($catreference != ""){
				$fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
			}
			
            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';
							
			if(isset($fotoCatalogo) and $fotoCatalogo!=""){
				$estructura .= '<img style="min-width: 25%; max-height: 300px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'">';
			}

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';
			
			$estructura .= '<table style="width:100%; border-collapse: separate;">';
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 1);
			
			$trcreado = 0;
			if($datosimagen != false){
				$trcreado = 1;
				$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;"><img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</td>';	
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 2);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 3);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}
			}
			
			$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($numero, 4);
			
			if($datosimagen != false){
				if($trcreado == 0){
					$trcreado = 1;
					$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';	
				}else{
					$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 14px; width:25%;">
									<br>
									<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
									'.$datosimagen['notas'].'</td>';
				}	
			}
			if($trcreado == 1){
            	$estructura .= '</tr></table>';
			}else{
            	$estructura .= '</table>';
			}

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ordenventa($trannum){
            $this->db->query('SET SQL_BIG_SELECTS=1'); 
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);
            set_time_limit(0);
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);      
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Cotización');
            $pdf->SetSubject('Cotización');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetAutoPageBreak(TRUE,10);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
            $pdf->SetHeaderMargin(0,0,0,0);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
            $this->load->model('pedclientes_model');
            $this->load->model("global_model");
            $this->load->model("ventas_model");
            $this->load->model('producto_model');
            $this->load->model('fabrica_model');
            $this->load->model('compras_model');
            $function = $this->uri->segment(3);
            $nombre_doc="";
            $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
            $fecha = new DateTime();

            $footer =  '<br><br><br><br><br><br>
            <table style="padding:0px; margin:0px;">
                <tbody style="padding:0px; margin:0px;">
                    <tr style="padding:0px; margin:0px;">
                        <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                        <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                        <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                    </tr>
                </tbody>
                </table>';

            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            
            $header = '<table style="width:100%;">
                <tr>
                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                    <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                </tr></table>';
            $header .= '<table style="width:100%;">
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                </tr>
                
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                    <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                </tr>
            </table>';

            $pdf->setHtmlHeader($header);
            $pdf->setPrintFooter(true);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Portrait');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            $pdf->addPage('P', 'LETTER');
            $estructura ='';
            $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
            $encabezado = $this->ventas_model->getAnexosHijos($trannum);
            if($encabezado!=false){
                foreach($encabezado as $enc){
                    $tabla_presentacion .= '<tr>
                        <td style="width:100%;padding:10px;">'.$enc->notas.'</td>
                    </tr>';
                }
                $tabla_presentacion.='</table>';
                $estructura.= $tabla_presentacion;
            }
            
            
            $estructura .='<br><br><table><tr>
                                    <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                    <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                </tr>';
            if($list_producto!=false){
                foreach($list_producto as $pro){
                    $estructura .='<tr>
                        <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                        </tr>';
                }
            }
            
            $estructura .='</table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        
        function ordenes_pdf($fecha, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }
					
					if($catreference != ""){
						$fotoCatalogo = $this->mantenimiento_model->getNameImagenPastelCatalogo($catreference);
					}
					
                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    if(isset($fotoCatalogo) and $fotoCatalogo!=""){
						$estructura .= '<img style="min-width: 25%; max-height: 300px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$fotoCatalogo.'">';
					}
					
					$estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.</td>
                                </tr>
                            </table>';
					
					$estructura .= '<table style="width:100%; border-collapse: separate;">';
			
					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 1);

					$trcreado = 0;
					if($datosimagen != false){
						$trcreado = 1;
						$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;"><img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">'.$datosimagen['notas'].'</td>';	
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 2);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 3);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}
					}

					$datosimagen = $this->mantenimiento_model->getInformacionImagenesExtras($pedido, 4);

					if($datosimagen != false){
						if($trcreado == 0){
							$trcreado = 1;
							$estructura .= '<tr><td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';	
						}else{
							$estructura .= '<td style="text-align:center; vertical-align:middle; font-size: 10px; width:25%;">
											<br>
											<img style="min-width: 23%; max-width:23%; width:200px; height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$datosimagen['imagen'].'">
											'.$datosimagen['notas'].'</td>';
						}	
					}
					if($trcreado == 1){
						$estructura .= '</tr></table>';
					}else{
						$estructura .= '</table>';
					}
					
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                
              
                
                
                 $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>RECIBIDA</strong></label></td>
                                    </tr>
                                </table></center><br><br>';
                
                foreach($informacion as $inf){
                
                $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$idrec.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha Ingreso: '.date_format(date_create($inf->fecha), 'd/m/Y').' </strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Referencia Interna:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->descrip.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->referencia.'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Numero de Documento:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Solicitado Por:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->serie.''.$inf->numero.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->solicita.'</td>
                                    </tr>
                                    
                                </tbody>
                    </table><br><br>
                     ';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->preciotran.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">$'.($pro->cantidad * $pro->preciotran ).'</td></tr>';
                           
                    
                }
                
                 $titulo.='
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				
				$pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                
				$name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
				switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                
                $exento = 0; $gravado = 0; $iva = 0; $sub_total = 0;
				
                if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
                    	if($key->tipotax==0){
							$subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo == 3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr>
									<td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
				
                $estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:12px; text-align:left; width:60%;"></td>
						<td style="font-size:12px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
					</tr>
				</table>';
				
                $estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
						<td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:60%;"> '.$muni_dep.'</td>
						<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
						<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
					</tr>';
                
				if($caj_clase == 12){
					$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:60%;"></td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
						</tr>
					</table>';
				}else{
					$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
						</tr>
					</table>';
				}
				
				$estructura .= '<br><br>
				<table style="width:100%;" class="fondo">
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
						<td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
						<td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
						<td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
						<td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
						<td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
					</tr>
					<tr>
						<td style="font-size:10px; text-align:center; width:5%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
						<td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">Código</td>
						<td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
						<td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
						<td style="font-size:10px; text-align:left; width:25%; font-weight: bold;">Notas</td>
						<td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
						<td style="font-size:10px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
					</tr>';
				
				if(is_array($list_productos) and $list_productos!=false){
					foreach($list_productos as $key){
						$estructura .= '
						<tr>
							<td style="font-size:10px; text-align:center; width:5%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
							<td style="font-size:10px; text-align:center; width:10%;">'.$key->idproducto.'</td>
							<td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
							<td style="font-size:10px; text-align:center; width:10%;">'.$key->um_orden.'</td>
							<td style="font-size:10px; text-align:left; width:25%;">'.$key->notas.'</td>
							<td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
							<td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
						</tr>';
					}
				}
				
                $estructura .= '
				<tr>
					<td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:9px; text-align:left; width:70%;"></td>
					<td style="font-size:12px; text-align:center; width:10%;"></td>
					<td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
				</tr>
				<tr>
					<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
					<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
					<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
				</tr>';
                
				if($provee_tipo == 3){
					if($gravado > 100){
						$percepcion = number_format($gravado, 2, '.', '') * 0.01;
						$sub_total = number_format($sub_total, 2, '.', '') + number_format($percepcion, 2, '.', '');
						
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Percepción 1%</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($percepcion, 2, '.', '').'</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
							<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
						</tr>';
					}
				}else{
					$estructura .= '
					<tr>
						<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
						<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
						<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
					</tr>';
				}
				
				$estructura .= '
					<tr>
						<td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_cond.'</td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
					</tr>
					<tr>
						<td></td>
					</tr>
				</table><br><br><br>';
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td><br><br><br></td>
					</tr>
					<tr>
						<td style="width:35%;"></td>
						<td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
						<td style="width:35%;"></td>
					</tr>
				</table>';
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
				$nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
        }
        
        function send_email($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                                        <table style="padding:0px;margin:0px;">
                                            <tr><td style="font-size:15px;"></td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left;">'.$direccion.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:10px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                                        </table></td>
                                        <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td style="padding:0px;margin:0px;width:33.3%;">
                                        <table style="padding:0px;margin:0px;">
                                            <tr><td style="font-size:15px;"></td></tr>
                                            <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                                        </table></td>
                                        
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Detalles de entrega</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;" class="fondo" style="border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:11px; text-align:center; width:10%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:11px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:11px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:11px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:11px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table>
                                    <table style="width:100%;" style="border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total Exento</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($exento, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total Gravado</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($gravado, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">IVA</td>
                                        <td style="font-size:10px; text-align:right; width:20%;">$'.number_format($iva, 2, '.', '').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Retención 1%</td>
											<td style="font-size:10px; text-align:right; width:20%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', '').'</td>
										</tr>
										<tr>
											<td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
											<td style="font-size:10px; text-align:right; width:20%; border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:20%;border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:80%;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:20%; border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table>
                                    <table style="width:100%;" >
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                echo json_encode($estructura);
            }
        }
        
        function send_email2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $correo_pro = $det['pro_correo'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                if($correo_pro==""){
                    $correo_pro="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                $estructura ='
                <style>
                .fondo{
                    background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                }
                </style>';
                
                $estructura .= '<br><br><table style="width:100%;">
                <tr>
                    <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                        <table style="padding:0px;margin:0px;">
                            <tr><td style="font-size:15px;"></td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                            <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                        </table></td>
                        <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                        <td style="padding:0px;margin:0px;width:33.3%;">
                        <table style="padding:0px;margin:0px;">
                            <tr><td style="font-size:15px;"></td></tr>
                            <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                        </table></td>
                </tr>
                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';
                }
                
                $estructura .= '<br><br><table style="width:100%;border: 1px solid #6E6E6E;" class="fondo">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; ">Detalles de entrega</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E; font-weight: bold;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%;border: 1px solid #6E6E6E; ">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%;border: 1px solid #6E6E6E; font-weight: bold;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%;border: 1px solid #6E6E6E; ">'.$dev_time.'</td>
                                    </tr>
                                    </table>
                                    <table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E;  font-weight: bold;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%;border: 1px solid #6E6E6E; ">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%;border: 1px solid #6E6E6E; font-weight: bold;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%;border: 1px solid #6E6E6E; ">'.$cliente.'</td>
                                    </tr>
                                    </table><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;">Detalle del Pedido</td>
                                    </tr>
                                    </table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($exento, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($gravado, 2, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:15%;">$'.number_format($iva, 2, '.', '').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:15%;">- $'.number_format($percepcion, 2, '.', '').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
											<td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:85%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:15%;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                    </tr>
                                    </table><table style="width:100%;border: 1px solid #6E6E6E;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                return($estructura);
            }
        }
        
        function enviar_correo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $cc = $this->input->post('cc');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                    
                if($de!=null){
                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $tabla = $this->send_email2($trannum);  

                    $this->load->library('email');
                    //$this->load->library('My_PHPMailer');
                    $this->email->from($de, $nombre_comercial);
                    if($cc!=""){
                        $this->email->to($para.",".$cc);
                    }else{
                        $this->email->to($para);
                    }
                    $this->email->subject($asunto);
                    $this->email->set_mailtype("html");
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;

                        $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden de Compra');
                    $pdf->SetSubject('Orden de Compra');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetMargins(5, 5, 5);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetAutoPageBreak(TRUE, 5);
                    //relación utilizada para ajustar la conversión de los píxeles
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('P');
                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    $pdf->setPrintHeader(true);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage( 'P', 'LETTER' );

                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $this->load->model('pedclientes_model');
                    $this->load->model('compras_model');
                    $this->load->model('variable_model');
                    $name = $this->pedclientes_model->getnameImg();
                    $list_productos = $this->compras_model->getDetail_products($trannum);
                    $det = $this->compras_model->detalleOrdenCompra2($trannum);
                    $vars = $this->variable_model->getTextVar("po_notas");
                    $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                    $notas_cond = $vars['valor_memo'];
                    $proveedor = $det['proveedor'];
                    $cliente = $det['workername'];
                    $formaPago = $det['formaPago'];
                    $orden = $det['trannum'];
                    $cli_phone = $det['trannum'];
                    $cli_email = $det['trannum'];
                    $valVenta = $det['trannum'];
                    $direccion = $det['direccion'];
                    $tel_pro = $det['tel_pro'];
                    $correo_pro = $det['pro_correo'];
                    $notas_orden = $det['notas'];
                    $caj_clase = $det['cajclase'];
                    $provee_dias = $det['provee_dias'];
                    $provee_tipo = $det['provee_tipo'];

                    if($tel_pro==""){
                        $tel_pro="N/A";
                    }
                    if($direccion==""){
                        $direccion="N/A";
                    }
                    if($correo_pro==""){
                        $correo_pro="N/A";
                    }
                    $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                    if($muni_dep==""){
                        $muni_dep="N/A";
                    }
                    $notas = "";
                    $date = date_format(date_create($det['fecha']),'d/m/Y');
                    $dia = date_format(date_create($det['fecha_entrega2']),'d');
                    $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                    $mes = date_format(date_create($det['fecha_entrega2']),'m');
                    $anio = date_format(date_create($det['fecha_entrega2']),'Y');

                    switch($dia_n){
                        case 0:
                            $dia_semana = "Domingo";
                            break;
                        case 1:
                            $dia_semana = "Lunes";
                            break;
                        case 2:
                            $dia_semana = "Martes";
                            break;
                        case 3:
                            $dia_semana = "Miércoles";
                            break;
                        case 4:
                            $dia_semana = "Jueves";
                            break;
                        case 5:
                            $dia_semana = "Viernes";
                            break;
                        case 6:
                            $dia_semana = "Sábado";
                            break;
                        default:
                            $dia_semana="";
                            break;
                    }

                    switch($mes){
                        case 1:
                            $mes_name = "Enero";
                            break;
                        case 2:
                            $mes_name = "Febrero";
                            break;
                        case 3:
                            $mes_name = "Marzo";
                            break;
                        case 4:
                            $mes_name = "Abril";
                            break;
                        case 5:
                            $mes_name = "Mayo";
                            break;
                        case 6:
                            $mes_name = "Junio";
                            break;
                        case 7:
                            $mes_name = "Julio";
                            break;
                        case 8:
                            $mes_name = "Agosto";
                            break;
                        case 9:
                            $mes_name = "Septiembre";
                            break;
                        case 10:
                            $mes_name = "Octubre";
                            break;
                        case 11:
                            $mes_name = "Noviembre";
                            break;
                        case 12:
                            $mes_name = "Diciembre";
                            break;
                        default:
                            $mes_name="";
                            break;
                    }

                    $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;


                    $dev_time = date("g:i a", strtotime($det['dev_time']));
                    $dev_place = $det['lugar_entrega'];    
                    $telefono = $det['telefono'];    

                    $inv_notas = $det['inv_notas'];
                    if($inv_notas!=""){
                        $dev_place .= ",".$inv_notas;
                    }


                    $exento = 0;
                    $gravado = 0;
                    $iva = 0;
                    $sub_total = 0;


                    if(is_array($list_productos) and $list_productos!=false){
                        foreach($list_productos as $key){

                            if($key->tipotax==0){
                                $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                                $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                            }else if($key->tipotax==13){
                                $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                                $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                                $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                            }
                            $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                        }
                    }

                    if($provee_tipo!=3){
                        if($gravado > 100){
                                $percepcion = number_format($gravado, 2, '.', '') * 0.01;
                                $en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                        }else{
                            $en_total = number_format($sub_total, 2, '.', '');
                        }
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }

                    foreach($info_empresa as $emp){
                        switch(round($emp->valor_num)){
                            case 1:
                                $razon = $emp->valor_memo;
                                break;
                            case 3:
                                $nrc = $emp->valor_memo;
                                break;
                            case 4:
                                $nit = $emp->valor_memo;
                                break;
                            case 5:
                                $giro = $emp->valor_memo;
                                break;
                            case 6: 
                                $direccion = $emp->valor_memo;
                                break;
                            case 7:
                                $depto_municipio = $emp->valor_memo;
                                break;

                        }
                    }

                    $estructura ='
                    <style>
                        .fondo{
                            background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                        }
                    </style>';

                    $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
                                            <table style="padding:0px;margin:0px;">
                                                <tr><td style="font-size:15px;"></td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; font-weight: bold; ">'.$razon.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;">'.$direccion.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left;"><b>NIT:</b>'.$nit.' / <b>NRC:</b>'.$nrc.'</td></tr>
                                                <tr style="padding:0px; margin:0px;"><td style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>GIRO:</b>'.$giro.'</td></tr>
                                            </table></td>
                                            <td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                            <td style="padding:0px;margin:0px;width:33.3%;">
                                            <table style="padding:0px;margin:0px;">
                                                <tr><td style="font-size:15px;"></td></tr>
                                                <tr><td style="font-size:25px; text-align:center;width:100%;">ORDEN DE COMPRA</td></tr>    
                                            </table></td>

                                        </tr>
                                    </table>';

                    $estructura .= '<table style="width:100%;">
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"></td>
                                            <td style="font-size:12px; text-align:center; background-color:#FF9900; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                        </tr>
                                    </table>';

                    $estructura .= '<table style="width:100%;">
                                        <tr>
                                            <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;"> '.$proveedor.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; fwidth:60%;"> '.$direccion.'</td>  
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                            <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"> '.$muni_dep.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                        </tr>';

                    if($caj_clase==12){
                        $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"> Tel.: '.$tel_pro.' / Correo: '.$correo_pro.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Días</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$provee_dias.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;"></td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                        </tr>
                                    </table>';
                    }else{
                        $estructura .= '
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                            <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($en_total, 2, '.', '').'</td>
                                        </tr>
                                    </table>';
                    }



                     $estructura .= '<br><br><table style="width:100%;" class="fondo">
                                        <tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                            <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                            <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                            <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                            <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                            <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                            <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                            <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                            <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                            <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                        </tr>';
                                    if(is_array($list_productos) and $list_productos!=false){
                                        foreach($list_productos as $key){
                                            //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                            $estructura .= '<tr>
                                                                <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                                <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                                <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                                <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>
                                                            </tr>';
                                                    }
                                    }

                    $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:9px; text-align:left; width:70%;"></td>
                                            <td style="font-size:12px; text-align:center; width:10%;"></td>
                                            <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 2, '.', '').'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 2, '.', '').'</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 2, '.', '').'</td>
                                        </tr>';

                        if($provee_tipo!=3){
                            if($gravado > 100){
                                $percepcion = number_format($gravado, 2, '.', '') * 0.01;
                                $sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                                $estructura .= '
                                            <tr>
                                                <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                                <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Retención 1%</td>
                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">- $'.number_format($percepcion, 2, '.', '').'</td>
                                            </tr>
                                            <tr>
                                                <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                                <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                                <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                            </tr>';
                            }else{
                                $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                        </tr>';
                            }
                        }else{
                            $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                            <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                        </tr>';
                        }



                        $estructura .= '<tr>
                                            <td style="font-size:12px; text-align:left; background-color:#FF9900; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Condiciones</td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_cond.'</td>
                                        </tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                        <tr><td></td></tr>
                                    </table><br><br><br>';
                        $estructura .= '<table style="width:100%;">
                                        <tr><td><br><br><br></td></tr>
                                        <tr>
                                            <td style="width:35%;"></td>
                                            <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #6E6E6E;">Autorizado por</td>
                                            <td style="width:35%;"></td>
                                        </tr>

                                    </table>';
                    
                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "orden_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo;
                    $pdf->Output($fullpath.".pdf",'F');


                    $this->email->message($body);
                    if($nombre_archivo!=''){
                        $this->email->attach($fullpath.".pdf");
                    }
                    if($this->email->send()){
                        unlink($fullpath.".pdf");

                        if($cc!=""){
                            $notas_correo = "Correo enviado de: ". $de . " a: ". $para . ','.$cc;
                        }else{
                            $notas_correo = "Correo enviado de: ". $de . " a: ". $para;
                        }


                        $sent_suc = $this->compras_model->insertOrders_100a($trannum,3,$notas_correo);

                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",

                        );
                        echo json_encode($array_result);
                    }else{
                        unlink($fullpath.".pdf");
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    }

                    }else{
                        $array_result = array(
                            "mensaje" =>"El empleado no tiene correo",
                            "type" =>"warning",

                        );
                    echo json_encode($array_result);
                }
            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                 $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                       // if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                       // }
                       
                        foreach($lineas_list as $lin){
                            //&& $lin->cant!=0
                            if($lin->idnivel1==$dep->idcatalogo){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    $titulo .= '<tbody></table><br><br>';
                }
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                
                $apps = $this->apps_model->verApps();
                
               // $this->load->model('variable_model');
              //  $nombres = $this->variable_model->verNombres();
              //  $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                            
                            
                            
                            if($key2->menutype == 1){
                            
                            $titulo .= '<tr>
                                            <td width="3%"></td>
                                            <td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
                                        </tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}
		
		function unidad_centimos($numero){
			$numero = trim($numero);
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}
		
		function decena_centimos($numero){
			$numero = trim($numero);
			
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}
		
		function unidad($numero){
			$numero = trim($numero);
			
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}
		
		function decena($numero){
			$numero = trim($numero);
			
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}
		
		function centena($numero){
			$numero = trim($numero);
			
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}
		
		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}
		
		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}
		
		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;

			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function comprobanteQuedan($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
				$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetAuthor('Versanet Sistemas');
				$pdf->SetTitle('Comprobante Quedan');
				$pdf->SetSubject('Comprobante Quedan');
				$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
				$pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
				$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				$pdf->SetMargins(8, 5, 8);
				$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				$pdf->SetAutoPageBreak(TRUE, 5);
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				$pdf->setFontSubsetting(true);
				$pdf->setPageOrientation('P');
				$pdf->SetFont('Helvetica', '', 7, '', true);
				
				$pdf->setPrintHeader(false);
				$pdf->setPrintFooter(false);
				$pdf->addPage( 'P', 'LETTER');
				
				$this->load->model('compras_model');
				$this->load->model('pedclientes_model');
				
				$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
				$name = $this->pedclientes_model->getnameImg();
				
				foreach($datos as $info){
					$dia = date_format(date_create($info->fecact),'d');
					$mes = date_format(date_create($info->fecact),'m');
					$anio = date_format(date_create($info->fecact),'Y');
					
					switch($mes){
						case 1:
							$mes_name = "Enero";
							break;
						case 2:
							$mes_name = "Febrero";
							break;
						case 3:
							$mes_name = "Marzo";
							break;
						case 4:
							$mes_name = "Abril";
							break;
						case 5:
							$mes_name = "Mayo";
							break;
						case 6:
							$mes_name = "Junio";
							break;
						case 7:
							$mes_name = "Julio";
							break;
						case 8:
							$mes_name = "Agosto";
							break;
						case 9:
							$mes_name = "Septiembre";
							break;
						case 10:
							$mes_name = "Octubre";
							break;
						case 11:
							$mes_name = "Noviembre";
							break;
						case 12:
							$mes_name = "Diciembre";
							break;
						default:
							$mes_name="";
							break;
					}

					$fecha_quedan = $dia." DE ".strtoupper($mes_name)." DE ".$anio;
					$totalVenta = $info->valcosto + $info->valtax1 - abs($info->valtax5);

					$estructura = '
					<table style="width:100%;">
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:20%;" rowspan="8"><img style="text-align:center; width:500px; height:300px; margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:60%;"><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:18px; width:20%;" rowspan="8"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:60%;"><strong>'.strtoupper($info->sucursal).'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:60%;">5a Avenida Sur, Barrio El Carmen, Nueva Concepción</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:60%;">Teléfonos: 2335-7082  Correo: gerente.compras@panlilian.com</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:16px; width:60%;"><strong>COMPROBANTE DE QUEDAN</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:60%;"></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:85%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:15%; border:solid 1px black;"><strong>N°: '.$info->trannum.'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;">NUEVA CONCEPCIÓN, '.$fecha_quedan.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Señores: <strong>'.$info->descrip.'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Gravadas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$'.number_format($info->valcosto, 2, '.', '').'</strong></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Queda en nuestro poder el comprobante N°: <strong>'.$info->serie.''.$info->numero.'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">13% IVA:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$'.number_format($info->valtax1, 2, '.', '').'</strong></td>
						</tr>';
					
					if($info->valtax5 != 0){
						$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Por un monto de: <strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Exentas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;"><strong>$00.00</strong></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Percepción 1%:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border-bottom:solid 1px black;"><strong>$'.number_format($info->valtax5, 2, '.', '').'</strong></td>
						</tr>';
					}else{
						$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Por un monto de: <strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;">Compras Exentas:</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;  border-bottom:solid 1px black;"><strong>$00.00</strong></td>
						</tr>';
					}
					
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Con fecha de emisión: <strong>'.date_format(date_create($info->fecvence), 'd/m/Y').'</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:25%;"><strong>TOTAL:</strong></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:14px; width:25%;"><strong>$'.number_format($totalVenta, 2, '.', '').'</strong></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:30%;"><strong>'.date_format(date_create($info->fecact), 'd/m/Y').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:14px; width:30%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:30%; border-top:solid 1px black;"><strong>Fecha de Proceso</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:30%; border-top:solid 1px black;"><strong>Elaborado Por.</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						</tr>
					</table>';
				}

				$pdf->writeHTML($estructura, true, 0, false, false, 0);
				$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
				$pdf->Output($nombreArchivo, 'I');
			}
		}
        
        
        
        function multi_mail($trannum){
            $this->db->query('SET SQL_BIG_SELECTS=1'); 
            ini_set('memory_limit', '9999M');
            ini_set('max_allowed_packet', '9999M');
            ini_set('max_execution_time', 0);
            set_time_limit(0);
            $this->load->model('pedclientes_model');
            $this->load->model("global_model");
            $this->load->model("ventas_model");
            $this->load->model('producto_model');
            $this->load->model('fabrica_model');
            $this->load->model('compras_model');
            $function = $this->uri->segment(3);
            $nombre_doc="";
            $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
            $fecha = new DateTime();

            $html_code = '<table style="width:100%;">
                <tr>
                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                    <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                </tr></table>';
            $html_code .= '<table style="width:100%;">
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                </tr>
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                    <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                </tr>
                
                <tr>
                    <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                    <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                    <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                </tr>
            </table>';

            $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
            $encabezado = $this->ventas_model->getAnexosHijos($trannum);
            if($encabezado!=false){
                foreach($encabezado as $enc){
                    $tabla_presentacion .= '<tr>
                        <td style="width:100%;padding:2px;">'.$enc->notas.'</td>
                    </tr>';
                }
                $tabla_presentacion.='</table>';
                $html_code.= $tabla_presentacion;
            }
            
            
            $html_code .='<br><table style="width:100%;"><tr>
                                    <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                    <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                </tr>';
            if($list_producto!=false){
                foreach($list_producto as $pro){
                    $html_code .='<tr>
                        <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                        </tr>';
                }
            }
            
            $html_code .='</table>';

            echo json_encode($html_code);

        }
        
        
        function send_email_orden_venta($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model("ventas_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('compras_model');
                $function = $this->uri->segment(3);
                $nombre_doc="";
                $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();

                $html_code = '<table style="width:100%;">
                    <tr>
                        <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                        <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                    </tr></table>';
                $html_code .= '<table style="width:100%;">
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                    </tr>
                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                        <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                    </tr>

                    <tr>
                        <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                        <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                        <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                    </tr>
                </table>';

                $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                if($encabezado!=false){
                    foreach($encabezado as $enc){
                        $tabla_presentacion .= '<tr>
                            <td style="width:100%;padding:2px;">'.$enc->notas.'</td>
                        </tr>';
                    }
                    $tabla_presentacion.='</table>';
                    $html_code.= $tabla_presentacion;
                }


                $html_code .='<br><table style="width:100%;"><tr>
                                        <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                        <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                    </tr>';
                if($list_producto!=false){
                    foreach($list_producto as $pro){
                        $html_code .='<tr>
                            <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                            </tr>';
                    }
                }

                $html_code .='</table>';

                return($html_code);
            }
        }
        
        
        function enviar_correo_orden_venta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                if($de!=""){
                    $this->load->model('global_model');
                    $tabla = $this->send_email_orden_venta($trannum);
                    //$this->load->library('My_PHPMailer');
                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;
                    $this->load->library('My_PHPMailer');
                    $mail = new PHPMailer();
                    $mail->IsSMTP(); // establecemos que utilizaremos SMTP
                    $mail->SMTPAuth   = true; // habilitamos la autenticación SMTP
                    $mail->SMTPSecure = "tls";
                    $mail->Host       = "smtp.gmail.com";      // establecemos GMail como nuestro servidor SMTP
                    $mail->Port       = 587;                   // establecemos el puerto SMTP en el servidor de GMail
                    $mail->Username   = "versanetsasv@gmail.com";  // la cuenta de correo GMail
                    $mail->Password   = "Egga#94662";            // password de la cuenta GMail
                    $mail->IsHTML(true);
                    $mail->SetFrom($de, $nombre_comercial);  //Quien envía el correo
                    $mail->addAddress($de);
                    $mail->addAddress($de);
                    $mail->Subject = $asunto;  //Asunto del mensaje
                    $mail->Body = $body;
                    $destino = $para;
                    $arreglo_para = explode(",", $para);
                    $cant = count($arreglo_para);
                    for($m = 0; $m<$cant; $m++){
                        $mail->AddAddress($arreglo_para[$m]);
                    }
                    $mail->CharSet = 'UTF-8';
                    
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);      
                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Cotización');
                    $pdf->SetSubject('Cotización');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    $pdf->SetAutoPageBreak(TRUE,10);
                    $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                    $pdf->SetHeaderMargin(0,0,0,0);
                    $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                    $this->load->model('pedclientes_model');
                    $this->load->model("global_model");
                    $this->load->model("ventas_model");
                    $this->load->model('producto_model');
                    $this->load->model('fabrica_model');
                    $this->load->model('compras_model');
                    $function = $this->uri->segment(3);
                    $nombre_doc="";
                    $dataPedido = $this->ventas_model->detalleOrdenVenta2($trannum);
                    $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                    $name = $this->pedclientes_model->getnameImg();
                    $fecha = new DateTime();

                    $footer =  '<br><br><br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                                <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                                <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                        </table>';

                    $pdf->setHtmlFooter($footer);
                    $pdf->setPrintFooter(true);

                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>COTIZACIÓN</td>
                        </tr></table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Cliente&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["clientename"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">N°&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Vendedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["workername"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["fecha"]),'d/m/Y').'</td>

                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Lugar de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["lugar_entrega"].'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.date_format(date_create($dataPedido["dev_date"]),'d/m/Y').'</td>
                        </tr>

                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Tipo de Documento&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:35%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["tipodoc"].'</td>
                            <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Forma de Pago&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:30%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$dataPedido["formaPago"].'</td>
                        </tr>
                    </table>';

                    $pdf->setHtmlHeader($header);
                    $pdf->setPrintFooter(true);
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    $pdf->setFontSubsetting(true);
                    $pdf->setPageOrientation('Portrait');
                    $pdf->SetFont('Helvetica', '', 7, '', true);
                    $pdf->addPage('P', 'LETTER');
                    $estructura ='';
                    $tabla_presentacion = '<table style="width:100%;border: 0.3px solid #6E6E6E;padding:10px;">';
                    $encabezado = $this->ventas_model->getAnexosHijos($trannum);
                    if($encabezado!=false){
                        foreach($encabezado as $enc){
                            $tabla_presentacion .= '<tr>
                                <td style="width:100%;padding:10px;">'.$enc->notas.'</td>
                            </tr>';
                        }
                        $tabla_presentacion.='</table>';
                        $estructura.= $tabla_presentacion;
                    }


                    $estructura .='<br><br><table><tr>
                                            <th style="font-size:12px; font-weight:bold; text-align:left; width:85%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">&nbsp;&nbsp;Nombre del producto</th>
                                            <th style="font-size:12px; font-weight:bold; text-align:center; width:15%; border: 0.3px solid #6E6E6E; background-color:#B6D4F3;">Precio</th>
                                        </tr>';
                    if($list_producto!=false){
                        foreach($list_producto as $pro){
                            $estructura .='<tr>
                                <td style="font-size:12px; text-align:left; width:85%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$pro->descrip.'</td>
                                <td style="font-size:12px; text-align:right; width:15%; border: 0.3px solid #6E6E6E;">$'.number_format(round($pro->precioneto, 2),2).'&nbsp;&nbsp;</td>
                                </tr>';
                        }
                    }

                    $estructura .='</table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "cotizacion_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo.".pdf";
                    $pdf->Output($fullpath,'F');
                    //$this->email->message($body);
                    if($nombre_archivo!=''){
                        $mail->AddAttachment($fullpath, $name = $nombre_archivo.".pdf",  $encoding = 'base64', $type = 'application/pdf');
                    }

                    if(!$mail->Send()) {
                        unlink($fullpath);
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    } else {
                        unlink($fullpath);
                        $notas_correo = "Correo enviado de: ". $de . " a: ". $para;
                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",
                        );
                        echo json_encode($array_result);
                    }
                    }else{
                    $array_result = array(
                        "mensaje" =>"El empleado no tiene correo",
                        "type" =>"warning", 
                    );
                    echo json_encode($array_result);
                }
            }
        }      
        
    }
?>