<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
        
        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LEGAL', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 0, 0, 0);
                $pdf->SetAutoPageBreak(FALSE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LEGAL' );
				$this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$numeroRecibo = $info->numero;
					$fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
					$cliente = $info->idcps.'-'.$info->nameCliente;
					$nrc = $info->nrc;
					$direccion = $info->direccion;
				}
                
				$productos = $this->invtran_model->getDataTran100k($trannum);
				
				$estructura = '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';
				
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;
				
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
                //SEGUNDA COPIA
                $estructura.= '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';
				
                
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
				$productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;
				
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
                //TERCERA COPIA
				$estructura .= '
					<table style="margin:0px;">
						<tbody>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:5px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:3px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:10%;"></td>
								<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
								<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
							</tr>
							<tr>
								<td style="font-size:10px; text-align:left; width:100%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
								<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
								<td style="font-size:12px; text-align:left; width:7%;"></td>
								<td style="font-size:12px; text-align:left; width:30%;"></td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:3%;"></td>
								<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
								<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left; width:100%;"></td>
							</tr>
						</tbody>
					</table>';
				
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
				$productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
									<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Código</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:44%;">Descripción del Producto</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">UM</td>
									<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
									<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
									<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td>
								</tr>';
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;
				
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->idproducto.'</td>';
						$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:44%;">'.$pro->descrip.'</td>';
						$estructura .= '<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.$pro->um.'</td>';
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Factura.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function print_etiquetas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 16, 0);
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
                $cant = 0;
                
				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $productos = $this->compras_model->getProductosCompra($trannum);
                $marcas = $this->compras_model->getMarcasCompra($trannum);
                
                $estructura = '<table style="width:100%;">';
                $num_rows=0;
                $alto = 10.5;
                foreach($marcas as $mar){
                    $primera = true;
                    foreach($productos as $pro){
                        
                        if($mar->marca==$pro->marca){
                            $actual=0;
                            $cant_etiquetas= $pro->cantidad;
                            if($primera == true){
                                $primera=false;
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }
                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }
                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                            }
                            
                            do{
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;margin:0px;width:25%;">
                                            <table style="padding:0px;margin:0px;">
                                            <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                    <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                </td>
                                            </tr>
                                            </table>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }
                                        
                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }
                                        
                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                                $actual++;
                            }while($cant_etiquetas!=$actual);
                        }
                    }    
                    
                    if($cant==0){
                        if($num_rows==20){
                            $estructura .= '
                            <tr style="padding:0px;margin:0px;" nobr="true">
                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                            </td>';
                            $num_rows=0;
                        }else{
                            if($num_rows>10){
                                $alto=9.7;
                            }else{
                                $alto=10.5;
                            }
                            if($num_rows==0){
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }else{
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }
                        }
                        $cant++;
                    }else if($cant==1){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==2){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==3){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td></tr>';
                        $cant=0;
                        $num_rows++;
                    }
                }
                
                if($cant!=0){
                    while($cant<=3){
                        $estructura .= '<td style="text-align:left;width:25%;"></td>';
                        $cant++;
                    }
                    $estructura .= '</tr>';
                }
                
                $estructura .= '</table>';
                //echo $estructura;
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //$pdf->writeHTMLCell(0, 0, '', '', $estructura, 0, 1, 0, true, '', true);
                
                $nombre_archivo = utf8_decode("Factura.pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            }
        }
        
		function valueinv($sucursal, $tipopro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        
         function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 40/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 8 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.',',');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.',',');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:7px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$ven->hora.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2, '.', ',').'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2, '.', ',').'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		function ventaTicketFinal($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;
                                
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
                                
                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }
                                
								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
		
		function ventaTicketPrueba($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = '192.168.1.78';
								var devid = 'local_printer';
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;
                                
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
                                
                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }
                                
								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
		
		function reporteCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteX($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2, '.', ''));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2, '.', '')) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2, '.', '')."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2, '.', '')."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2, '.', '')."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2, '.', '')."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2, '.', '')."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				$nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							ticketObj.addPulse();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZFacturaz($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2, '.', ''));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2, '.', '')) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2, '.', '')."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
				}
				
				$this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2, '.', '')."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2, '.', '')."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2, '.', '')."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2, '.', '')."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2, '.', '')."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
					ticketObj.addPulse();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function imprimirApertura($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
					<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
					<script src='".base_url()."js/epos-print-5.0.0.js'></script>
					<script src='".base_url()."js/barcode.js'></script>

					<script type='text/javascript'>
						//var datosprinter = data.datos_print.split('/');
						var ipaddr = '".$datospr[0]."';
						var devid = '".$datospr[1]."';
						var timeout = '60000';
						var grayscale = false;
						var layout = false;
						
						var fecha = new Date();
						var anio = fecha.getFullYear();
						var mes = fecha.getMonth() + 1;
						var dia = fecha.getDate();
						
						var hours = fecha.getHours();
						var minutes = fecha.getMinutes();
						var seconds = fecha.getSeconds();
						var ampm = hours >= 12 ? 'PM' : 'AM';
						
						hours = hours % 12;
						hours = hours ? hours : 12; // the hour '0' should be '12'
						minutes = minutes < 10 ? '0'+minutes : minutes;
						var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
						
						var ticketObj = new epson.ePOSBuilder();
						if(layout){
							ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
						}
						
						ticketObj.addTextLang('es').addTextSmooth(true);
						ticketObj.addFeedLine(1);
						ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
						ticketObj.addTextSize(1, 2);
						ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
						ticketObj.addTextSize(1, 1);
						ticketObj.addFeed();
						ticketObj.addText('".$namecaja."');
						ticketObj.addFeed();
						ticketObj.addText('".$namecentro."');
						ticketObj.addFeed();
						ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
						ticketObj.addFeed();
						ticketObj.addText('Giro: ".$GIRO."');						
						ticketObj.addFeed();
						ticketObj.addText('IVA D.L. N° 296');
						ticketObj.addFeed().addFeed();
						ticketObj.addTextSize(1, 2).addText('APERTURA DE CAJA').addFeed();
						ticketObj.addText('".$fechaCorte." ' + strTime).addTextSize(1, 1);
						ticketObj.addFeed().addFeed();
						ticketObj.addText('CAJERO: ".$this->session->userdata('userLog')."').addFeed();
						ticketObj.addText('FONDO: $".number_format($fondocaja, 2, '.', '')."').addFeed().addFeed();
						ticketObj.addText('SE APERTURO CAJA').addFeed();
						ticketObj.addFeedLine(4);
						
						ticketObj.addCut();
						ticketObj.addPulse();
						
						var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
						var epos = new epson.ePOSPrint(url);
						epos.send(ticketObj.toString());
						
						setTimeout(function(){ window.close();}, 1500);
					</script>";
				
				echo $script;
			}
					
		}
		
		function impresionCorteXPruebas($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.55';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
									$totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format($money->valor, 2, '.', ''));
										}else{
											$moneyvalor = abs(number_format($money->valor, 2, '.', '')) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format($valpagG[$tip->cajclase], 2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum += round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2), 2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->fechahora);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
									$totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format($money->valor, 2, '.', ''));
										}else{
											$moneyvalor = abs(number_format($money->valor, 2, '.', '')) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2, '.', '')."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format($valpagG[$tip->cajclase], 2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum += round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2), 2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2), 2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2), 2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->fechahora);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteZPruebas($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.55';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2, '.', '')."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2, '.', '')."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2, '.', '')."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2, '.', '')."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2, '.', '')."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->fechahora);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2, '.', '')."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2, '.', '')."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2, '.', '')."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2, '.', '')."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2, '.', '')."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2, '.', '')."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2, '.', ',')."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2, '.', '')."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2, '.', '')."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2, '.', '')."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2, '.', '')."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2, '.', '');
					$valorCaja = number_format(round($info->valorusr, 2),2, '.', '');
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2, '.', '')."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2, '.', '')."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2, '.', '')."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2, '.', '')."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2, '.', '')."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2, '.', '')."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2, '.', '')."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2, '.', '')."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2, '.', '')."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2, '.', '')."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2, '.', '')."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->fechahora);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
        function print_etiquetas2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                // Load library
                
                $this->load->library('fpdf');
                
                # Contenido HTML del documento que queremos generar en PDF.
                $this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $cant = 0;
                
                $productos = $this->compras_model->getProductosCompra($trannum);
                $marcas = $this->compras_model->getMarcasCompra($trannum);
                
                
                $pdf = new fpdf('P','mm','A4');
                
                // Títulos de las columnas
                // Carga de datos
                $pdf->SetFont('Arial','B',11);
                $pdf->SetMargins(10, 10, 10);
                $pdf->AddPage();
                $pdf->SetAutoPageBreak(true, 10);
                $pdf->setXY(10,10);
                $y = $pdf->getY();
                $cant=0;
                foreach($marcas as $mar){
                    $primera = true;
                    foreach($productos as $pro){
                        if($mar->marca==$pro->marca){
                            $actual=0;
                            $cant_etiquetas= $pro->cantidad;
                            if($primera == true){
                                $primera=false;
                                if($cant==0){
                                    $pdf->setXY(10,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==1){
                                    $pdf->setXY(56,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==2){
                                    $pdf->setXY(102,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant++;
                                }else if($cant==3){
                                    $pdf->setXY(148,$y);
                                    $pdf->MultiCell(45,10,"Inicio $mar->descrip ",1,'C', 0);
                                    $cant=0;
                                    $y +=10;
                                }
                            }
                            
                            
                            do{
                                
                                if($cant==0){
                                    $pdf->setXY(10,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==1){
                                    $pdf->setXY(56,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==2){
                                    $pdf->setXY(102,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant++;
                                }else if($cant==3){
                                    $pdf->setXY(148,$y);
                                    $pdf->MultiCell(45,10,"[".$pro->idproducto."] ".$pro->modelo,1,'C', 0);
                                    $cant=0;
                                    $y +=10;
                                }
                                $actual++;
                            }while($cant_etiquetas!=$actual);
                            
                            
                            if($cant==0){
                                $pdf->setXY(10,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==1){
                                $pdf->setXY(56,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==2){
                                $pdf->setXY(102,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant++;
                            }else if($cant==3){
                                $pdf->setXY(148,$y);
                                $pdf->MultiCell(45,10,"Fin $mar->descrip ",1,'C', 0);
                                $cant=0;
                                $y +=10;
                            }

                            
                            
                        }
                    }
                }
                
                $pdf->Output();
                
            }
        }
		
		function printDevolucion($trannum){
			date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;
                                
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText('DEVOLUCIÓN' + ' N° ' + data.numdocumento).addFeed();
								ticketObj.addTextStyle(false, false, 'bold').addText(data.nameCliente).addTextStyle(false, false, false);
								ticketObj.addFeed().addTextSize(1, 1);
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '       -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '      -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '     -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '    -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '   -' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '  -' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '   ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '      -' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     -' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '    -' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '   -' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '      -' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '     -' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '    -' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '   -' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}
								
								totalSumas = parseFloat(totalSumas) * -1;
								
								if(totalExento != 0){
									totalExento = parseFloat(totalExento) * -1;
								}
								
								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);
								if(grantotal != 0){
									grantotal = parseFloat(grantotal) * -1;
								}
								
								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}
								
								
								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}
								
								total = parseFloat(total) * -1;
								
								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}
								
								
								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								if(totalDesc != 0){
									ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								}
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}
									
									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '       -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '      -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '     -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '    -' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								total = parseFloat(total) * -1;
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}
								
								if(totalVuelto != 0){
									ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								}
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
                                
                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }
                                
								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
        
        
        
        function detalle_salidas($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Salida de Mercadería');
                $pdf->SetSubject('Salida de Mercadería');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 40, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetalleSalida($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:18px; text-align;center;" >
                                        <td style="font-size:18px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:16px; text-align;center;" >
                                        <td style="font-size:16px; text-align;center;"><label><strong>'.strtoupper($this->session->userdata('appName')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:14px; text-align;center;" >
                                        <td style="font-size:14px; text-align;center;"><label>'.strtoupper($data->tipoSalida).'  N°: '.$data->trannum.'</label></td>
                                    </tr>
                                    <tr style="font-size:14px; text-align;center;" >
                                        <td style="font-size:14px; text-align;center;"><label>ORIGEN  '.$data->centrocd.'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>FECHA: '.$date_cierre.'</strong></td>
                                    </tr>
                                </table></center>';
                }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Salida_Mercaderia".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
	}
?>