<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct() {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
		}
        
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
            # devolvemos el array de valores
            return $info;
        }
        
        function factura_pdf_nuevo($numero){
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/

            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                            /*if(isset($imagen) and $imagen!=""){
                                $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                            }*/

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function orden_pedido($trannum){
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(5, 5, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );
            
            $this->load->model('pedclientes_model');
            $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
                
            $sucursal = strtoupper($dataPedido['pedidoSuc']);
            $pedido = $dataPedido['trannum'];
            $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
            $cli_name = $dataPedido['descrip'];
            $cli_phone = $dataPedido['cli_phone'];
            $cli_email = $dataPedido['cli_email'];
            $notas = $dataPedido['notas'];
            $dev_date = ucwords($dataPedido['fechaPedido']);
            $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
            if($dataPedido['dev_place'] == 1){
                $lugar = $dataPedido['nameSucursal'];
            }else{
                $lugar = $dataPedido['dev_direc'];    
            }
            $dev_contact = $dataPedido['dev_contact'];
            $dev_phone =$dataPedido['dev_phone'];
            $valPedido = $dataPedido['val_pro'];
            $valEnvio = $dataPedido['val_envio'];
            $valVenta = $dataPedido['val_tot'];
            $valAnti = $dataPedido['val_anti'];
            
            $tamano = strlen($trannum);
            $codbar = "";
                
            if($tamano==1){
                $codbar = "00000".$pedido;
            }elseif($tamano==2){
                $codbar = "0000".$pedido;
            }elseif($tamano==3){
                $codbar = "000".$pedido;
            }elseif($tamano==4){
                $codbar = "00".$pedido;
            }elseif($tamano==5){
                $codbar = "0".$pedido;
            }elseif($tamano==6){
                $codbar = $pedido;
            }
            
            $estructura = '<br><br><table style="width:100%;">
                                <tr>
                                    <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td></td>
                                    <td style="font-size:12px; text-align:right;">ORDEN DE PEDIDO<br>'.strtoupper($this->session->userdata('appName')).'<br><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                </tr>
                            </table><br><br>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Nombre de Cliente:</td>
                                    <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:30%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                </tr>
                            </table>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;">'.$cli_name.'</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Teléfono: <strong>'.$cli_phone.'</strong>&nbsp;&nbsp;Correo: <strong>'.$cli_email.'</strong></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Sucursal</td>
                                    <td style="font-size:10px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$sucursal.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:15%; border: 1px solid #6E6E6E; color:#0B486B;">'.$trannum.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                            </table>';
            
             $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_date.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:90%; border: 1px solid #6E6E6E;" colspan="3">'.$lugar.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Contacto</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_contact.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Teléfono</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_phone.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                    <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                </tr>';
            foreach($list_producto as $key){
                $subtotal = $key->cantidad * $key->precioneto;
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                    <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                    <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                    <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:9px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Sub-total</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valPedido.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Envio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valEnvio.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Suma</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Anticipo</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valAnti.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-bottom: 1px solid #6E6E6E; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; border-bottom: 1px solid #6E6E6E; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; border-bottom: 1px solid #6E6E6E; font-weight: bold; width:10%;">Pendiente</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">$'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                                </tr>';
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas.'</td>
                                </tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                            </table><br><br><br>';
                $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';
            
            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ticket_pedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P', $pagelayout);

                $this->load->model('pedclientes_model');
                $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                
                $sucursal = strtoupper($dataPedido['pedidoSuc']);
                $pedido = $dataPedido['trannum'];
                $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
                $cli_name = $dataPedido['descrip'];
                $cli_phone = $dataPedido['cli_phone'];
                $cli_email = $dataPedido['cli_email'];
                $dev_date = ucwords($dataPedido['fechaPedido']);
                $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
                if($dataPedido['dev_place'] == 1){
                    $lugar = $dataPedido['nameSucursal'];
                }else{
                    $lugar = $dataPedido['dev_direc'];    
                }
                $dev_contact = $dataPedido['dev_contact'];
                $dev_phone =$dataPedido['dev_phone'];
                $dev_phone =$dataPedido['dev_phone'];
                $valPedido = $dataPedido['val_pro'];
                $valEnvio = $dataPedido['val_envio'];
                $valVenta = $dataPedido['val_tot'];
                $valAnti = $dataPedido['val_anti'];

                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE '.strtoupper($this->session->userdata('appName')).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';
                        
                        $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pedido</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 24px; width:50%; font-weight: bold;">Producto</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Cant</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Precio</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 24px; width:18%; font-weight: bold;">Sub-total</td>
                            </tr>';
                        
                        foreach($list_producto as $key){
                            $subtotal = $key->cantidad * $key->precioneto;
                            $estructura .= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 20px; width:50%;">'.$key->descrip.'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">'.round($key->cantidad).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                
                $estructura .= '</table>';
                
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PEDIDO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valPedido, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valEnvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valVenta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valAnti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                            </tr>
                        </table>';
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_pedido_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                    
            }
        
        }
        
        function ticket_nuevo($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

                if(is_array($products) && $products!=false){
                    $sucursal = strtoupper($products['descrip']);
                    $pedido = $products['numero'];
                    $cli_name = $products['cli_name'];
                    $cli_phone = $products['cli_phone'];
                    $date = date_format(date_create($products['date']),'d/m/Y');
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_refund = $products['val_refund'];
                    $tpastel = $products['val_pastel'];
                    $taccesorios = $products['val_acc'];
                    $tbases = $products['val_bases'];
                    $tenvio = $products['val_envio'];

                    $cli_email = $products['cli_email'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $imagen = $products['pastel_fotos'];
                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $dev_contact = $products['dev_contact'];
                    $dev_phone = $products['dev_phone'];

                    $lugar = "";
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3) {
                        $lugar = "Recoger en Producción";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];

                    $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                }else{
                    redirect('pedidos_clientes/pasteles_al_gusto/');
                }

        
                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE PASTELES</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date2.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';

                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                        
                     $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pastel</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Tortas:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cktortas.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Porciones:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$ckslices.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Referencia:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$catreference.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Dedicatoria:</td>
                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';
                    
                    $i = 1;
                    foreach($arrayPasteles as $key => $value){

                        $estructura .= '<table style="width:100%;">
                                            <tr>
                                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Torta '.$i.' </td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Posición:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_position'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Forma:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_shape'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Relleno:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_filling'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Sabor:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_flavor'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Baño:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_bath'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Cobertura:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_covering'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Color:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_color'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px;font-weight: bold; width:30%;">Notas:</td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.ucwords($value['notas']).'</td>
                                            </tr>
                                        </table>';
                        $i++;
                    }
                }

                if($accesorios!=false){

                    $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>ACCESORIOS </td>
                            </tr>';
        
                    foreach($accesorios as $key => $value){
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                       </tr>';
                    }

                    $estructura .= '</table>';
                }

                if($bases!=false){

                    $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>BASES </td>
                                </tr>';
        
                    foreach ($bases as $key => $value) {
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                        </tr>';
                    }
                    
                    $estructura .= '</table>';
                }

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline;"><br><br>OBSERVACIONES </td>
                            </tr>
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-size: 28px;">'.$dev_notes.'</td>
                            </tr></table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PASTEL $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tpastel, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ACCESORIOS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($taccesorios, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">BASES $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tbases, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tenvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">REEMBOLSABLE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function ordenes_pdf($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }

                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    /*if(isset($imagen) and $imagen!=""){
                        $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                    }*/
                    $estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function lista_pdf_nuevo_todo($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS');
                $pdf->SetSubject('LISTADO DE PEDIDOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(1, 2, 1);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 2);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', 'LETTER' );
                
                $fechai = $fecha;
                $fechaf = $fecha;
                if($fechai=="" || $fechaf=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
        
                $sucursales = $this->produccion_model->getPedidosClientes_by_Sucursal(1,$fechai,$fechaf,$estado,1);
                $tdomicilio = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,2);
                $tproduccion = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,3);
                $pedidos_sucursal = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,1);
                $pedidos_domicilio = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,2);
                $pedidos_produccion = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,3);

                $estructura = '';

                $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px;">'.$titulo.'</td>
                                </tr>
                            </table><br><br><br>';

                if($pedidos_sucursal!=false || $pedidos_domicilio!=false || $pedidos_produccion!=false){

                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:18%;">Cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Referencia</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:51%;">Detalles</td>
                                </tr>
                                <tr><td colspan="6"><hr></td></tr>
                            </table>';
                    
                    if(is_array($sucursales) && $sucursales!=false){                
                        foreach ($sucursales as $key => $value) {
                            $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">'.$value['devdirec2'].' ('.$value['totalpedidos'].')</td>
                                </tr>';
                            
                            foreach ($pedidos_sucursal as $key2 => $value2) {
                                
                                if($value['dev_direc']==$value2['dev_direc']){
                                    $cktortas = $value2['ck_tortas'];
                                    $ckslices = $value2['porciones'];
                                    
                                    if($value['dev_direc']==$value2['dev_direc']){
                                        $estructura.= '<tr>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                                        $i=0;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }

                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                                        $i2 = 1;

                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }
                                        
                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb) {
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                $i3++;  
                                            }
                                        }
                                        $estructura.= '</td>
                                            </tr>
                                            <tr><td colspan="6"><hr></td></tr>'; 
                                    }
                                }
                            }
                            $estructura.= '</table>';
                        }
                    }
                    /****************************/
                    if(is_array($pedidos_domicilio) && $pedidos_domicilio!=false){                
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';

                        foreach ($pedidos_domicilio as $key2 => $value2) {
                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                            
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                            
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep){
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                           }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea){
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                
                                foreach ($arrayBases as $keyb => $valueb){
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                    
                        }

                        $estructura.= '</table>';
            
                    }
                    /****************************/
                    
                    /****************************/
                    if(is_array($pedidos_produccion) && $pedidos_produccion!=false){                
                     
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">PRODUCCIÓN ('.$tproduccion.')</td>
                                </tr>';
                        
                        foreach ($pedidos_produccion as $key2 => $value2) {

                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                   
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).','. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }
                            
                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }
                            
                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                        }
                    
                        $estructura.= '</table>';
            
                    }
                  
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
                $nombre_archivo = utf8_decode("listado_pedidos.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function reporte_por_hora($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetSubject('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $fechai = $fecha;
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');

                $horas = $this->produccion_model->get_horas_por_pedido($fechai,$estado);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS POR HORA</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';

                $estructura2.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">Porciones</td>
                                </tr>
                            </table>';                            
                
                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );


                if($horas!=false){
                    if(is_array($horas) && $horas!=false){                
                        foreach ($horas as $key_horas => $value_horas){
                            $estructura.= '<table style="width:100%;">
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_horas['hora'].' ('.$value_horas['npedidosporhora'].')</td>
                                            </tr>';

                            $sucursales = $this->produccion_model->get_sucursales_por_hora_por_pedido($fechai,$estado,$value_horas['dev_time'],1);

                            if(is_array($sucursales) and $sucursales!=false){
                                foreach ($sucursales as $key_sucursales => $value_sucursales) {
                                    $estructura.= '<tr>
                                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                                   </tr>';

                                    $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],1,$value_sucursales['dev_direc']);

                                    if(is_array($pedido) and $pedido!=false){
                                        foreach ($pedido as $key_pedido => $value_pedido) {
                                            $estructura.= '<tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                           </tr>
                                                           <tr>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                           </tr>
                                                           <tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                            $i=1;
                                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                                //$i = count($arrayPasteles);
                                                foreach ($arrayPasteles as $keyp => $valuep) {
                                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                    $i++;  
                                                }
                                            }

                                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                            $i2 = 1;

                                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                                $estructura.= '<b>ACCESORIOS:</b> ';
                                                foreach ($arrayAccesorios as $keya => $valuea) {
                                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                    $i2++;  
                                                }
                                            }

                                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                            $i3 = 1;
                                            
                                            if(is_array($arrayBases) and $arrayBases!=false){
                                                //$i3 = count($arrayBases);
                                                $estructura.= '<b>Bases:</b> ';
                                                foreach ($arrayBases as $keyb => $valueb) {
                                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                    $i3++;  
                                                }
                                            }
                                            $estructura.='</td>
                                            </tr>';
                                        }
                                    }
                                }
                            }

                            $tdomicilio = $this->produccion_model->getCount_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2);

                            if($tdomicilio!=false){
                                $estructura.= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';
                                
                                $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2,'');

                                if(is_array($pedido) and $pedido!=false){
                                    foreach ($pedido as $key_pedido => $value_pedido) {
                                        $estructura.= '<tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                       </tr>
                                                       <tr>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                       </tr>
                                                       <tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                            <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                        $i=1;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            //$i = count($arrayPasteles);
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }
                                        
                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                        $i2 = 1;
                                        
                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }

                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb){
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']);
                                                $i3++;  
                                            }
                                       }

                                        $estructura.='</td>
                                        </tr>';
                                    }
                                }
                            }
                            
                            $estructura.= '</table>';
                        }
                    }
           
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("listado_pedidos_por_hora.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_de_despacho($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE DE DESPACHO');
                $pdf->SetSubject('REPORTE DE DESPACHO');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $fechai = $fecha;
                
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
                
                $sucursales = $this->produccion_model->get_sucursales_reporte_de_despacho($fechai,$estado,1);
                $domicilio = $this->produccion_model->get_total_pedidos_por_dev_place($fechai,$estado,2);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE DE DESPACHO</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';
                     
                $estructura2.= '<table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Hora</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Porciones</td>
                    </tr>
                </table>';                            

                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

            
                if(is_array($sucursales) && $sucursales!=false){    
                    foreach ($sucursales as $key_sucursales => $value_sucursales){
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                </tr>';
                 
                        $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,1,$value_sucursales['dev_direc']);
                 
                        if(is_array($pedidos) and $pedidos!=false){
                            foreach($pedidos as $key_pedido => $value_pedido){
                                $estructura.= '<tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                               </tr>
                                               <tr>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                               </tr>
                                               <tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                    <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                $i=1;
                                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                    //$i = count($arrayPasteles);
                                    foreach ($arrayPasteles as $keyp => $valuep){

                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';

                                      $i++;  
                                    }
                                }

                                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                $i2 = 1;
                                
                                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                    //$i2 = count($arrayAccesorios);
                                    $estructura.= '<b>ACCESORIOS:</b> ';
                                    foreach ($arrayAccesorios as $keya => $valuea){
                                        $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                        $i2++;  
                                    }
                                }

                                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                $i3 = 1;

                                if(is_array($arrayBases) and $arrayBases!=false){
                                    //$i3 = count($arrayBases);
                                    $estructura.= '<b>Bases:</b> ';
                                    foreach ($arrayBases as $keyb => $valueb){
                                        $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                        $i3++;  
                                    }
                                }

                                $estructura.='</td>
                                </tr>';
                            }
                        }
                
                        $estructura.= '</table>';
                    }
                }
                
                if($domicilio!=0){
                       
                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>DOMICILIO ('.$domicilio.')</td>
                                </tr>';
                    
                    $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,2,"");
                 
                    if(is_array($pedidos) and $pedidos!=false){
                        foreach ($pedidos as $key_pedido => $value_pedido){
                            $estructura.= ' <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;"><b>DIRECCIÓN:</b> '.trim($value_pedido['dev_direc']).', <b>PREGUNTAR POR:</b> '.trim($value_pedido['dev_contact']).', <b>TELÉFONO:</b> '.trim($value_pedido['dev_phone']).'
                                                </td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                            $i=1;
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                //$i2 = count($arrayAccesorios);
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }

                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                //$i3 = count($arrayBases);
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.='</td>
                            </tr>';
                        }
                    }
                    $estructura.= '</table>';
                }
                
           
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_producto_sucursal($fecha, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE CONTROL PRODUCCION');
                $pdf->SetSubject('REPORTE CONTROL PRODUCCION');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $header = '     <table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE CONTROL PRODUCCIÓN</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA <strong>'.date_format(date_create($fecha), 'd/m/Y').'</strong></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    </tr>
                                </table><br><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $this->load->model('tpedido_model');
                
                $salas_venta = $this->tpedido_model->getNameSalasdeVenta();
                                                
                $lst_productos = explode("_", $productos);
                $tot = count($lst_productos);
                $total_ = $tot - 1;
                if($total_ >= 12){
                    $tamano = 90 / 12;    
                }else{
                    $tamano = 90 / $total_;    
                }
                
                $pdf->addPage('L', 'LETTER');
                $estructura = ' <table style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th style="background-color:#F0F0F0; color:#FFFFFF; width:10%; height:25px; font-size:14px; text-align:center; vertical-align:middle; border-style:solid; border-width: 1px 1px 1px 1px;"></th>';
                    for($j=0; $j<$total_; $j++){
                        $name = $this->tpedido_model->getNameProducto($lst_productos[$j]);
                        $estructura .= '    <th style="width:'.$tamano.'%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.$name.'</th>';            
                    }                        
                //$estructura .= '            <th style="width:10%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>TOTAL</th>';
                $estructura .= '        </tr>
                                    </thead>';
                
                foreach($salas_venta as $sv){
                    $sum_ = 0;
                    $estructura .=' <tbody>
                                        <tr>
                                            <td style="text-align:left; background-color:#F0F0F0; color:#000000; width:10%; height:35px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>'.$sv->descrip.'</strong></td>';
                        for($j=0; $j<$total_; $j++){
                            $cantidad = $this->tpedido_model->getCantProducto($lst_productos[$j], $fecha, $sv->idcentro);
                            if($cantidad == "0" || $cantidad == ""){
                                $cantidad = "";    
                            }else{
                                $cantidad = round($cantidad);
                            }
                            $estructura .= '<td style="width:'.$tamano.'%; height:35px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>'.$cantidad.'</td>';            
                            $sum_ += $cantidad;
                        }                       
                    $estructura .= '    </tr>';
                }
                $estructura .= '        <tr>
                                            <td style="text-align:center; background-color:#F0F0F0; color:#000000; width:10%; height:30px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>TOTAL</strong></td>';
                for($j=0; $j<$total_; $j++){
                    $sum_total = $this->tpedido_model->getTotalProducto($lst_productos[$j], $fecha);
                    $estructura .= '    <td style="width:'.$tamano.'%; height:30px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#A80000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.round($sum_total).'</td>';
                }
                $estructura .= '        </tr>';
                $estructura .= '    <tbody>    
                                </table>';
                
                $estructura .= '<style>
                                    .sucursales{
                                        color:#000000; 
                                        font-size:11px; 
                                    }
                                </style>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $name = $this->variable_model->getIconCuenta();
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
            
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 55, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('variable_model');
                $name = $this->variable_model->getIconCuenta();

                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                   $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteDetallePro($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
            
                $this->load->model('pjc_model');
                
                $tipo = $this->pjc_model->getTipopjc($trannum);
                $tiposd = $this->pjc_model->getTiposd();
                $informacion = $this->pjc_model->getDetalleProyecto($trannum);
                $datospro = $this->pjc_model->datosDetalle($trannum);
                
                foreach($informacion as $data){
					foreach($tipo as $tip){
						$date_vence = date_format(date_create($data->fecvence),'d/m/Y');
                    
						$titul = '<center><table style="width:100%; text-align:center;" >
									<tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                  		<td style="font-size:12px; text-align;center;"><label><strong>'.strtr(strtoupper($tip->estado),"àèìòùáéíóúçñäëïöü","ÀÈÌÒÙÁÉÍÓÚÇÑÄËÏÖÜ").'</strong></label></td>
                                    </tr>
                                </table></center>';
					}
                    
					$titul .= '
					<div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;">
						<br>
						<label style="font-size:15px;" ><strong> N°'.$data->trannum.'</strong></label>
					</div>
					<table style="border: solid 1px black;">
						<tbody>
							<tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Cliente:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Fecha Estimada de Instalación:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->cliente).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.$date_vence.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proyecto:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Diseñador:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->proyecto).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->dise).'</td>
							</tr>
                            <tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Dirección:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%"  >Observaciones:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->direccion).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->notas).'</td>
							</tr>
						</tbody>
					</table><br><br>';
                }
				
				$titulo =' <table> ';
                foreach($tiposd as $tipd){
                	$titulo2 ='
                    <table>
                    	<tr>
                       		<td style="background-color:#E8E8E8; text-align:left; font-size:12px; " colspan="3"><strong>'.$tipd->descripcion.'</strong></td>
                    	</tr>
					</table>';   
					
					$cant=0;
					foreach($datospro as $pro){
                     	$imagend= base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/".$pro->archivo; 
						$titulo2 .='<table  style=" border: solid 1px white; margin-top:30px;">';
						
						if($pro->pjc_tipod == $tipd->idrnum){   
                       		$titulo2 .='
							<tr>
								<td style="margin:10px;" rowspan="3"><img src="'.$imagend.'" width="230px" height="105px"></td>
								<td style="font-size:12px; text-align:center; " colspan="2"><strong>'.$pro->descrip .'</strong></td>
							</tr>
							<tr>
								<td style="height:80px; font-size:12px;" rowspan="2" colspan="2">'.$pro->notas .'</td>
							</tr>';
                     		
							$cant++;             
                       }
					} 
                	
                    if($cant>0){
						$titulo.=$titulo2;
					}
				}

				$titulo .=' </table> ';
               
				$pdf->writeHTML($titul, true, false, true, false, '');
				$pdf->writeHTML($titulo, true, false, true, false, '');
				$nombre_archivo = utf8_decode("Detalle_Proyecto_".$trannum.".pdf");
				$pdf->Output($nombre_archivo, 'I');
			}
		}
        
		function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);


                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'n');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 6:
                        $mes_name = "Julio";
                        break;
                    case 6:
                        $mes_name = "Agosto";
                        break;
                    case 6:
                        $mes_name = "Septiembre";
                        break;
                    case 6:
                        $mes_name = "Octubre";
                        break;
                    case 6:
                        $mes_name = "Noviembre";
                        break;
                    case 6:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name.", ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        $subtotal = $key->cantidad * $key->precioneto; 
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }

                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $subtotal = $key->cantidad * $key->precioneto; 
                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Proveedor</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Cliente</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px;"><br>Es indispensable presentar esta orden de compra al entregar el producto en nuestra bodega.<br><br></td>
                                    </tr>
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR PAGAR A PROVEEDORES</label></center>';
               	
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
					<tbody style="padding:0px; margin:0px;">
						<tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
				</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='
				<table  style="width:100%;  border-collapse: collapse;">
					<tr>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
					</tr>';
                
				$grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR COBRAR A CLIENTES</label></center>';
               	
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
				$pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR COBRAR A CLIENTES<br>'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Reporte de Inventario Valorizado</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function ficha_tecnica($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Ficha Técnica');
                $pdf->SetSubject('Reporte de Ficha Técnica');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT, 0);
                //$pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('producto_model');
                $prod_dat = $this->producto_model->callRegistro($idproducto);
                  
                $this->load->model('fabrica_model');
                $materiales = $this->fabrica_model->verFichasMateriales($idproducto);
                $sumamateriales = $this->fabrica_model->sumMateriales($idproducto);
                $obras = $this->fabrica_model->verFichasObras($idproducto);
                $sumaobras = $this->fabrica_model->sumObras($idproducto);
                
                foreach($sumamateriales as $key){
                    foreach($sumaobras as $key2){
                        
                        
                        $total = ( ($key->subtotal) + ($key2->subtotal) );
                           
                        
                    }
                    
                    
                }
                
                
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Ficha Técnica</label><br><label style="text-align:center;  font-size:20px; font-weight:bold;">N° '.$idproducto.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);


                $pdf->AddPage();


                $titulo='';
                   
                    
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style=" width:100%;">';
           
                
               
                foreach($prod_dat as $key){    
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style=" border-bottom: solid 2px black;  font-size:26px; color:#21618C; text-align:left;" ><strong>'.$key->descrip.'</strong></th>
                                    
                                </tr>
                                
                                </thead>';  
                                
               
                    $titulo .= '  <tbody>
                                <tr>
                                    <br>
                                    <td></td>
                                    <td width="41%" colspan="2"><img style="width:650px; height:550px; margin-left:25px;  " src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$key->imagen.'"></td>
                                    <td></td>
                                    <td>
                                    <table style=" width:160%;">
                                        <thead>
                                            <tr>
                                                <th style=" background-color:#004379; color:white; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black;    font-size:14px; text-align:center;" width="100%"><strong>ESPECIFICACIONES</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black;  background-color:#F4F6F6; color:#413D3D; font-weight: bold; " >Colección</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->marca.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;  background-color:#F4F6F6; color:#413D3D; " >Modelo</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;  " >'.$key->modelo.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Peso(Onzas)</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->ftpeso.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Medidas</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->ftmedidas.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Tiempo de Producción(Minutos)</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->fttime.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Costo Unitario</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:right; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($total, 2).'</td>
                                            </tr>
                                    </table>
                                    </td>  
                                    <td></td>
                                   
                                </tr>
                                <tr>
                                <td  colspan="5" style=" font-size:13px; text-align:left; font-weight:bold; " >Caracteristicas:</td>
                                <td></td>
                                 </tr>
                                    <tr>
                                    <td width="100%"  colspan="5" style=" font-size:13px; text-align:justify;  " >'.$key->ftspecs.'</td>
                                    <td></td>
                                    </tr>
                                    
                                </tbody>';
                  
                }
                
                $titulo .= ' </table><br>';
                
                
                
                
                
                
                
                    
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style="border: solid 0.5px black; width:100%;">';
                
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="5" style=" background-color:#004379; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; color:white;    font-size:14px; text-align:left;" width="100%"><strong>MATERIAS PRIMAS</strong></th>
                                  
                                </tr>
                                </thead>';  
                
                $titulo .= '  <tbody>
                                <tr>
                                    <td width="46%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Material</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >U/M</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Cantidad</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Costo Unitario</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Sub Total</td>
                                    
                                                
                                </tr>';
                foreach($materiales as $key){
                    $titulo .= ' 
                                    <tr>
                                    <td style="font-size:12px;  text-align:left; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->titulo.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->unidad.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->costo, 5).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->subtotal, 2).'</td>
                                    
                                    </tr>';          
                }   
                
                foreach($sumamateriales as $key){
                    $titulo .= ' 
                                 <tr>
                                    <td colspan="2"  style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Total Materias Primas</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " ></td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($key->subtotal, 2).'</td>
                                          
                                                                                   
                                </tr>';    
                }
                                
                $titulo .= '<tbody></table><br><br>';
                
                
                
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style="border: solid 0.5px black; width:100%;">';
                
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="5" style=" background-color:#004379; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; color:white;   font-size:14px; text-align:left;" width="100%"><strong>MANO DE OBRA</strong></th>
                                  
                                </tr>
                                </thead>';  
                
                $titulo .= '  <tbody>
                                <tr>
                                    <td width="46%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black; border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Trabajo o Proceso </td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >U/M</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Cantidad</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Costo Unitario</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Sub Total</td>
                                                
                                </tr>';
                                
                foreach($obras as $key){
                                    $titulo .= '  
                                 <tr>
                                    <td style="font-size:12px;  text-align:left; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->titulo.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->unidad.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->costo, 5).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->subtotal, 2).'</td>
                               </tr>';          
                                 }
                                foreach($sumaobras as $key){

                                 $titulo .= ' 
                                 <tr>
                                    <td colspan="2"  style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Total Mano de Obra</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " ></td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($key->subtotal, 2).'</td>
                                                                                   
                                </tr>';
                
                                }
                
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                 
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Ficha_Tecnica.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
            
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$funcion = $this->uri->segment(3);
				$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                $fecha = new DateTime();
                
				$footer =  '<br><br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tbody style="padding:0px; margin:0px;">
                        	<tr style="padding:0px; margin:0px;">
								<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
								<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
								<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        	</tr>
                    	</tbody>
					</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br>
					<center>
						<label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label>
						<br>
						<label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label>
						<br>
					</center>
					<br>
                	<table style="padding:0px; width:100%; margin-bottom:150%;">
						<tbody>
							<tr>
								<th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
								<td width="10%"  style="border-bottom: solid 3px black;"></td>
								<th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
								<td width="5%" style="border-bottom: solid 3px black;"></td>
								<th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                			</tr>
                		</tbody>
                	</table>';
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo='';
				foreach($nombres as $grupo){
					$titulo .= '
						<table style=" width:100%;">
							<thead>
								<tr>
									<th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
								</tr>
                            </thead>
							<tbody>';
					
					foreach($variables as $sub){  
						if($grupo->nombre == $sub->nombre){
							if($sub->tipo_valor == 1){
								$tipo = "N";
								$valor = $sub->valor_num;
							}else if($sub->tipo_valor == 2){
								$tipo = "T";
								$valor = $sub->valor_txt;
							}else if($sub->tipo_valor == 3){
								$tipo = "F";
								$valor = $sub->valor_fecha;
							}else if($sub->tipo_valor == 4){
                               	$tipo = "L";
								$valor = $sub->valor_logico;
							}else if($sub->tipo_valor == 5){
								$tipo = "M";
								$valor = $sub->valor_num;
							}
                			
							$titulo .= '  
								<tr>
                                   <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
								   <td width="10%"></td>
								   <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
								   <td width="5%"></td>
								   <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
								</tr>';
 	                          
							if($sub->valor_memo != ""){
								$titulo .= '
								<tr>
									<td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
							}
                       }
					}
					$titulo .= '<tbody></table><br><br>';
				}
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$funcion = $this->uri->segment(3);
               	$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
				$this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                $apps = $this->apps_model->verApps();
                
                $fecha = new DateTime();
                
				$footer =  '<br><br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tbody style="padding:0px; margin:0px;">
                        	<tr style="padding:0px; margin:0px;">
                            	<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
								<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
								<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        	</tr>
                    	</tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br>
					<center>
						<label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label>
						<br>
						<label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label>
						<br>
					</center>
					<br>
					<table style="padding:0px; width:100%; margin-bottom:150%;">
                		<tbody>
                			<tr>
                				<td width="3%" style="border-bottom: solid 3px black;"></td>
                    			<td width="3%" style="border-bottom: solid 3px black;"></td>
								<td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
								<td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
								<td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
								<td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
							</tr>
						</tbody>
                	</table>';
				
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo = '';
                $titulo .= '
					<table style=" width:100%;">
						<tbody>';
                
                foreach($menus as $key){
					$titulo .= '
							<tr>
								<td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                             </tr>';
                    
					foreach($apps as $key2){   
						if(trim($key2->menuname) == trim($key->descripcion)){
                        	if($key2->menutype == 1){
                            	$titulo .= '
								<tr>
									<td width="3%"></td>
									<td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
								</tr>';
                            	
								foreach($apps as $key3){
									if($key2->idapp == $key3->idapphd){
										
										$titulo .= '
										<tr>
											<td width="3%" ></td>
											<td width="3%" ></td>
											<td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
											<td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
											<td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
											<td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
										</tr>';
                                        
										if($key3->notas != ""){
											$titulo .= '
											<tr>
												<td width="1.8%"></td>
												<td width="7%"></td>
												<td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
												<td colspan="2"></td>
											</tr>';
										}
									}
                             	}  
							}else{
								$titulo .= '
								<tr>
									<td width="3%" ></td>
									<td width="3%" ></td>
									<td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
									<td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
									<td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
									<td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
								</tr> ';
                                
								if($key2->notas != ""){
									$titulo .= '
									<tr>
										<td width="1.8%"></td>
										<td width="7%"></td>
										<td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
										<td colspan="2"></td>
									</tr>';
								}
							}
						}
					}
                    
                    $titulo .= '
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr> ';
				}
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
          
        function reporte_transacciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 33, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('transacciones_model');
               // $nombres = $this->transacciones_model->verNombres();
                $pagos = $this->transacciones_model->verPagos();
                $pagosco = $this->transacciones_model->getPagosCO();
                $pagosvn = $this->transacciones_model->getPagosVN();
                $pagosin = $this->transacciones_model->getPagosIN();
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="5%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >ID</td>
                    <td width="28.4%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Operación en Inventarios</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Operación en Caja</td>
                    <td width="28%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Pagos</td>
                </tr>
                </tbody>
                </table> ';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                
               
                $titulo='';
                $titulo .= '<table style="padding:0px; width:100%; margin-bottom:150%;">';
                $titulo .= '<tbody>';
                
                
                /*foreach($menus as $key){*/
                
                $titulo .= '<tr>
                                <td width="0.9%" style=""></td>  
                                <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">COMPRAS</td>
                            </tr>';
                $titulo .= '<tr><td colspan="6"></td></tr>';
                
                $cadena="";
                $cant=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "CO"){ 
                        
                        if($key->inopera == 1){ 
                              $oventaco = "Suma"; 
                           }else if($key->inopera == 0){
                               $oventaco = "Nada";
                           }else if($key->inopera == -1){
                               $oventaco = "Resta";
                           }
                        
                        
                        if($key->caopera == 1){
                              $oventaca = "Suma";
                           }else if($key->caopera == 0){
                               $oventaca = "Nada";
                           }else if($key->caopera == -1){
                               $oventaca = "Resta";
                           }
                        
                        
                        $arrayPag = explode(",", $key->pagos);
                        $totRig = count($arrayPag);
                        $totReal = $totRig;
                        
                        
                        for($i=0; $i<$totReal; $i++){
                            
                            foreach($pagosco as $co){
                                if($arrayPag[$i] == $co->cajclase){
                                    if($cant==0){
                                     
                                     $cadena = $co->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena .= ", ".$co->descrip;
                                    }   
                            
                                }
                            }
                            
                            $cant++;
                        }
                        
                        
                  
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px; text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventaco.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventaca.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena.'</td>
                            </tr>';
                        
                        if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    }
                    
                    $cadena="";
                    $cant=0;
                    
                }
                
                $titulo .= '<tr><td colspan="6"></td></tr>';  
                $titulo .= '<tr>
                                <td width="0.9%" style=""></td> 
                                <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">VENTAS</td>
                            </tr>';
                $titulo .= '<tr><td colspan="6"></td></tr>'; 
                $cadena2="";
                $cant2=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "VN"){
                        
                        if($key->inopera == 1){
                              $oventavn = "Suma";
                           }else if($key->inopera == 0){
                               $oventavn = "Nada";
                           }else if($key->inopera == -1){
                               $oventavn = "Resta";
                           }
                        
                        if($key->caopera == 1){
                              $oventavnc = "Suma";
                           }else if($key->caopera == 0){
                               $oventavnc = "Nada";
                           }else if($key->caopera == -1){
                               $oventavnc = "Resta";
                           }
                        
                        
                        $arrayPag2 = explode(",", $key->pagos);
                        $totRig2 = count($arrayPag2);
                        $totReal2 = $totRig2;
                        
                        
                        for($i=0; $i<$totReal2; $i++){
                            
                            foreach($pagosvn as $vn){
                                if($arrayPag2[$i] == $vn->cajclase){
                                    if($cant2==0){
                                     
                                        $cadena2 = $vn->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena2 .= ", ".$vn->descrip;
                                    }   
                            
                                }
                            }
                            
                            $cant2++;
                        }
                        
                  
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px;  text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventavn.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventavnc.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena2.'</td>
                            </tr>';
                        
                        if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    
                    }
                    
                    $cadena2="";
                    $cant2=0;
                    
                }
                
                $titulo .= '<tr><td colspan="6"></td></tr>';  
                
                
                $titulo .= '<tr>
                               <td width="0.9%" style=""></td>
                               <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">INVENTARIOS</td>
                            </tr>';
                
                 $titulo .= '<tr><td colspan="6"></td></tr>'; 
                $cadena1="";
                $cant1=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "IN"){
                        
                        if($key->inopera == 1){
                              $oventain = "Suma";
                           }else if($key->inopera == 0){
                               $oventain = "Nada";
                           }else if($key->inopera == -1){
                               $oventain = "Resta";
                           }
                        
                        if($key->caopera == 1){
                              $oventacin = "Suma";
                           }else if($key->caopera == 0){
                               $oventacin = "Nada";
                           }else if($key->caopera == -1){
                               $oventacin = "Resta";
                           }
                        
                        
                        $arrayPag1 = explode(",", $key->pagos);
                        $totRig1 = count($arrayPag1);
                        $totReal1 = $totRig1;
                        
                        
                        for($i=0; $i<$totReal1; $i++){
                            
                            foreach($pagosin as $in){
                                if($arrayPag1[$i] == $in->cajclase){
                                    if($cant1==0){
                                     
                                     $cadena1 = $in->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena1 .= ", ".$in->descrip;
                                    }   
                            
                                }
                            }
                            
                            $cant1++;
                        }
                        
                  
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px; text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventain.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventacin.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena1.'</td>
                            </tr>';
                    
                    }
                    
                    if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    
                    $cadena1="";
                    $cant1=0;
                    
                }
                
                $titulo .= '</tbody></table><br><br>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Transacciones_inventarios.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_usuarios($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 33, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                
                
                $this->load->model('user_model');
                
                $usuarios = $this->user_model->verUsuarios($tipo);
                                                                  
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="2%" style="border-bottom: solid 3px black;"></td>
                    <td width="3.5%" style=" border-bottom: solid 3px black;  font-size:12px; text-align:center;  font-weight: bold;" >ID</td>
                    <td width="29.5%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre Completo</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Usuario</td>
                    <td width="13%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Ingreso</td>
                    <td width="13%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Vence</td>
                    <td width="22%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Sucursal</td>
                </tr>
                </tbody>
                </table>';
                
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                if($tipo == 1){
                    $titulo .= '<tr>
                                <td width="0.9%" style=""></td> 
                                <td width="100%" colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">ACTIVOS</td>
                            </tr>';
                    $titulo .= '<tr><td colspan="7"></td></tr>';
                    
                    foreach($usuarios as $key){
                    
                    $titulo .= '<tr>
                                <td width="2%" style=""></td>
                                <td width="3.5%" style="   font-size:11px; text-align:center; " >'.$key->id.'</td>
                                <td width="29.5%" style="font-size:11px;  text-align:left; " >'.$key->nombre.'</td>
                                <td width="18%" style="font-size:11px;  text-align:left; " >'.$key->usuario.'</td>
                                <td width="13%" style="font-size:11px;   text-align:center;" >'.date("d/m/Y",strtotime($key->ingreso)).'</td>
                                <td width="13%" style="font-size:11px;   text-align:center; " >'.date("d/m/Y",strtotime($key->vence)).'</td>
                                <td width="22%" style="font-size:11px;   text-align:left;" >'.$key->sucursal.'</td>
                            </tr>';
                    }
                    
                }else if($tipo == 0){
                    
                    $titulo .= '<tr>
                              <td width="0.9%" style=""></td> 
                              <td width="100%"  colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">INACTIVOS</td>
                            </tr>';
                    $titulo .= '<tr><td colspan="7"></td></tr>';
                    
                    foreach($usuarios as $key){
                    
                    $titulo .= '<tr>
                                <td width="2%" ></td>
                                <td width="3.5%" style="font-size:11px; text-align:center; " >'.$key->id.'</td>
                                <td width="29.5%" style="font-size:11px;  text-align:left; " >'.$key->nombre.'</td>
                                <td width="18%" style="font-size:11px;   text-align:left; " >'.$key->usuario.'</td>
                                <td width="13%" style="font-size:11px;   text-align:center;" >'.date("d/m/Y",strtotime($key->ingreso)).'</td>
                                <td width="13%" style="font-size:11px;   text-align:center; " >'.date("d/m/Y",strtotime($key->vence)).'</td>
                                <td width="22%" style="font-size:11px;   text-align:left; " >'.$key->sucursal.'</td>
                            </tr>';
                    }
                }
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Transacciones_FormasPago.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_formatos(){
             if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                
                
                 $this->load->model('formas_model');
                
                 $formas = $this->formas_model->viewFormas();
                 $names = $this->formas_model->viewName();
                                                                   
                 $fecha = new DateTime();
                 $footer =  '<br><br><br><br><br><br>
                 <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                 $pdf->setHtmlFooter($footer);
                 $pdf->setPrintFooter(true);
                  
                 $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                 <table style="padding:0px; width:100%; margin-bottom:150%;">
                 <tbody>
                 <tr>
                 <td width="5%" style="border-bottom: solid 3px black;"></td>
                 <td width="38%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Descripción</td>
                 <td width="38%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre del Formulario</td>
                 <td width="20%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Contraseña</td>
                </tr>
                </tbody>
                </table>';
                
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                 $pdf->setHtmlHeader($header);
                 $pdf->setPrintHeader(true);
                   


                 $pdf->AddPage();
                
                 $titulo='';
                 
                 $titulo .= '<table style=" width:100%;">';
                 $titulo .= '<tbody>';
                 
                 foreach($names as $key2){
                     
                     $titulo .= '
                     <tr>
                     <td  width="100%" colspan="4" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" >'.$key2->appname.'</td>
                     </tr>';
                     $titulo .= '<tr>
                     <td colspan="4"  style="font-size:12px; text-align:left; " ></td>
                     </tr>';
                 
                     foreach($formas as $key){
                     
                         if($key->appname == $key2->appname){
                    
                             $titulo .= '
                             <tr>
                             <td width="5%" style=""></td>
                             <td width="38%" style="font-size:12px; text-align:left;" >'.$key->descrip.'</td>
                             <td width="38%" style="font-size:12px; text-align:left;" >'.$key->formname.'</td>';
                              if($key->gvarpwd != ""){
                                  $titulo .= ' <td width="20%" style="font-size:12px; text-align:center;"><img style="width:15px;  margin-left:25px; height:15px;" src="'.base_url().'img/Adicionar.png"></td>';
                              }else{
                                  $titulo .= ' <td width="20%" style="font-size:12px; text-align:center;"></td>';
                              }
                             $titulo .= '</tr>';
                         }
                     }
                     $titulo .= '<tr>
                     <td  style="font-size:12px; text-align:left; " ></td>
                     <td  style="font-size:12px; text-align:left; " ></td>
                     </tr>';
                     
                 }
                 
                 
                 
                 $titulo .= '</tbody></table><br><br>';
                 
                 
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                 $nombre_archivo = utf8_decode("Transacciones_FormasPago.pdf");
                 $pdf->Output($nombre_archivo, 'I');
            }
            
            
            
        }
        
        function inv_valorizado2($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
               
                $html = $this->output->get_output();
		
                // Load library
                $this->load->library('dompdf_gen');
                
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
               
             
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;

                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                            </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        foreach($lineas_list as $lin){
                            $titulo_depto .='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_depto .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_depto.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                     
                                }
                            }
                            $titulo_depto .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo .=$titulo_depto;
                            }else{
                                $titulo_depto='';
                            }
                        }
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                            </tr></table>';
                        if($sum_dep>0){
                             $titulo .=$titulo_depto;
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                                <tr>
                                    <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                                </tr></table>';
                            $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                            $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                            foreach($lineas_list as $lin){
                                $titulo_depto .='<table  style="width:100%;  border-collapse: collapse;">
                                <tr>
                                    <th style="width:5%;"></th>
                                    <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                                </tr></table>';
                                $titulo_depto .='<table  style="width:100%; border-collapse: collapse;">
                                <tr>
                                    <th style="width:5%; text-align:left;"></th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                                </tr>';
                                $sum_linea =0;
                                foreach($lista_productos as $product){
                                    if($product->idcatalogo==$lin->idcatalogo){
                                        //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                        $sum_linea+=($product->costounitario*$product->cantidad);
                                        $sum_dep +=($product->costounitario*$product->cantidad);
                                        $sum_total +=($product->costounitario*$product->cantidad);
                                        $titulo_depto.='<tr>
                                            <td style="width:5%; text-align:left;"></td>
                                            <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                            <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                            <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                            <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                            <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                            <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                            <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                        </tr>';

                                    }
                                }
                                $titulo_depto .='<table style="margin-top:5px;"><tr>
                                    <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                    <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                                </tr></table>';
                                if($sum_linea>0){
                                    $titulo .=$titulo_depto;
                                }else{
                                    $titulo_depto='';
                                }
                            }
                            $titulo_depto .='<table style="margin-top:5px;"><tr>
                                    <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                                    <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                                </tr></table>';
                            if($sum_dep>0){
                                 $titulo .=$titulo_depto;
                            }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                // Convert to PDF
                $this->dompdf->load_html($titulo);
                $this->dompdf->render();
                $this->dompdf->stream("Documento.pdf");
                
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Listado de Departamentos y Líneas</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                        if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                        }
                       
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo && $lin->cant!=0){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">CUENTAS POR COBRAR</label><br><label style="text-align:center; font-size:13px;">CARTERA POR VENDEDOR<br>'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td colspan="5" style="width:100%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:40%; text-align:center;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:20%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:40%; text-align:center;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:90%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:90%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                            </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function ventasTicket($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        		
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);
				//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
				// se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage( 'P',$pagelayout);

                $this->load->model('ventas_model');
                //$products = $this->mantenimiento_model->getDataCake_for_ticket($trannum);

				$estructura = '<table style="width:100%;">
					<tr>
						<td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
					</tr>
					<tr>
						<td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PRUEBA DE TICKET N°'.$trannum.'</td>
					</tr>
				</table>';
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("ticket_venta_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'F');

            }
        
        }
		
        //EXCEL RECEPCION DE TRASLADOS
        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function recepcionDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Recepcion_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
            
        }
        
        function orden_servicio($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Servicio');
                $pdf->SetSubject('Orden de Servicio');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(10,10,10,10);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $this->load->model('pjc_model');
                $info = $this->pjc_model->getDetalleProyecto($trannum);
                $productos = $this->pjc_model->datosDetalle($trannum);
                $agenda = $this->pjc_model->datosActividad($trannum);
                $materiales = $this->pjc_model->getMaterialesProyecto($trannum);
                $mano = $this->pjc_model->getManosProyecto($trannum);
                
                $fecha = new DateTime();
                
				$footer =  '<br><br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tbody style="padding:0px; margin:0px;">
                        	<tr style="padding:0px; margin:0px;">
                            	<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
								<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
								<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        	</tr>
                    	</tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->setPrintHeader(false);

                $pdf->addPage( 'P', 'LETTER' );
                
                
                $estructura = '<br><br><table style="width:100%;">
                        <tr>
                            <td rowspan="2" style="width:35%;"><img style="width:200px; height:100px;min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:25%;"></td>
                            <td style="width:40%;font-size:25px; background-color:#E8E8E8;color:black;">'.strtoupper($nombreFormato).'</td>
                        </tr>
                        <tr>
                            <td style="width:25%;"></td>
                            <td style="width:40%;font-size:25px; color:black;"><br><br>N° '.$trannum.'</td>
                            </tr>
                        </table><br><br>';
                
                foreach($info as $in){
                    

                    $estructura .= '<table style="width:100%">
                        <tr style="width:100%">
                            <td style="border: 1px solid black; padding:5px; width:25%; font-size:12px;text-align:left;">Fecha de Orden<br><b>'.date_format(date_create($in->fecha), 'd/m/Y').'</b></td>
                            <td style="border: 1px solid black; padding:5px; width:25%; font-size:12px;text-align:left;">Fecha de Servicio/Instalación<br><b>'.date_format(date_create($in->fecvence), 'd/m/Y').'</b></td>
                            <td style="border: 1px solid black; padding:5px; width:25%; font-size:12px;text-align:left;">Supervisor<br><b>'.$in->supervisor.'</b></td>
                            <td style="border: 1px solid black; padding:5px; width:25%; font-size:12px;text-align:left;">Estado de Orden<br><b>'.$in->tipo.'</b></td>
                        </tr>
                        <tr style="width:100%">
                            <td colspan="2" style="border: 1px solid black; padding:5px; font-size:12px;text-align:left;">Facturar a<br><b>'.$in->cliente.'</b></td>
                            <td colspan="2" style="border: 1px solid black; padding:5px; font-size:12px;text-align:left;">Contacto/Telefono<br><b>'.$in->dise.' / '.$in->telefono.'</b></td>
                        </tr>
                        <tr style="width:100%">
                            <td colspan="4" style="border: 1px solid black; padding:5px; font-size:12px;text-align:left;">Dirección del lugar<br><b>'.$in->direccion.'</b></td>
                        </tr>

                    </table>';
                }
                
                
                $estructura .= '<br><br><table style="width:100%">
                    <tr style="width:100%">
                        <td coslpan="2" style="border: 1px solid black; padding:5px; width:100%; font-size:14px; background-color:#E8E8E8;" >Producto/Servicio</td>
                    </tr>';
                
                foreach($productos as $pro){
                    $estructura.='<tr style="width:100%">
                        <td coslpan="2" style="border-right: 1px solid black; border-left: 1px solid black; padding:5px; width:100%; font-size:5px;"></td>
                        </tr>';
                    if($pro->archivo != "" && $pro->archivo!=null){
                        $estructura.='<tr>
                                <td style="border-left: 1px solid black;width:20%; padding:10px;"><img style="margin:5px;" width="75px" height="75px" src="'.base_url().'doc_cuentas/'.$this->session->userdata('dirDocuments').'/'.$pro->archivo.'"></td>
                                <td style="border-right: 1px solid black;width:80%;font-size:12px;text-align:left;">'.$pro->descrip.'<br>'.$pro->notas.'</td>
                            </tr>';
                    }else{
                       $estructura.='<tr>
                            <td style="border-left: 1px solid black;width:20%; padding:10px;"><img style="margin:5px;" width="75px" height="75px" src="'.base_url().'img/sinImagen.png"></td>
                            <td style="border-right: 1px solid black;width:80%;font-size:12px;text-align:left;">'.$pro->descrip.'<br>'.$pro->notas.'</td>
                            </tr>';
                    }
                    $estructura.='<tr style="width:100%">
                        <td coslpan="2" style="border-right: 1px solid black; border-left: 1px solid black; padding:5px; width:100%; font-size:5px;"></td>
                        </tr>';
                    
                    $estructura.='<tr>
                        <td coslpan="2" style="width:100%; border: 1px solid black; background-color:#E8E8E8; font-size:12px; text-align: left;">Actividades</td>
                    </tr><tr><td style="width:100%;">';
                     $estructura.='<table style="width:100%; padding:0px;margin:0px;"><tr>
                                <th  style="width:10%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Fecha</th>
                                <th  style="width:10%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Hora</th>
                                <th  style="width:35%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Encargado</th>
                                <th  style="width:20%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Actividad</th>
                                <th  style="width:15%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Notas</th>
                                <th  style="width:10%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Estado</th>
                            </tr>';
                    if($agenda!=false){
                        foreach($agenda as $agen){
                                if(round($agen->aplicaid) == round($pro->idrec)){
                                    $estructura.='<tr>
                                                <td style="width:10%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:center;">'.date_format(date_create($agen->fecha), 'd/m/Y').'</td>
                                                <td style="width:10%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:center;">'.$agen->normal.'</td>
                                                <td style="width:35%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.$agen->encargado.'</td>
                                                <td style="width:20%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.$agen->detalle.'</td>
                                                <td style="width:15%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.$agen->notas.'</td>
                                                <td style="width:10%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:center;">'.$agen->estado.'</td></tr>';
                                }
                        }
                    }
                    $estructura.='</table></td></tr>';
                    
                    
                    $estructura.='<tr><td colspan="2"><br></td></tr><tr>
                        <td coslpan="2" style="width:100%; border: 1px solid black; background-color:#E8E8E8; font-size:12px; text-align: left;">Materiales</td>
                    </tr><tr><td style="width:100%;">';
                     $estructura.='<table style="width:100%; padding:0px;margin:0px;"><tr>
                                <th  style="width:40%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Descripción del Material</th>
                                <th  style="width:15%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Cant. Estimada</th>
                                <th  style="width:15%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Cant. Entregada</th>
                                <th  style="width:15%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Cant. Devuelta</th>
                                <th  style="width:15%;border: 1px solid black;font-size:11px; text-align:center;font-weight:bold;">Cant. Utilizada</th>
                            </tr>';
                    if($materiales!=false){
                        foreach($materiales as $mat){
                                if(round($mat->aplicaid) == round($pro->idrec)){
                                    $estructura.='<tr>
                                    <td style="width:40%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:center;">'.$mat->notas.'</td>
                                    <td style="width:15%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:center;">'. round($mat->cantidad_presupuesto).'</td>
                                    <td style="width:15%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.round($mat->cantidad_entregada).'</td>
                                    <td style="width:15%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.round($mat->cantidad_devuelta).'</td>
                                    <td style="width:15%;border-bottom: 1px solid black;border-right: 1px solid black;border-left: 1px solid black;font-size:11px; text-align:left;"> '.round($mat->cantidad_entregada-$mat->cantidad_devuelta).'</td></tr>';
                                }
                        }
                    }
                    $estructura.='</table></td></tr>';
                      
                    $estructura.='<tr><td colspan="2"><br></td></tr><tr >
                        <td coslpan="2" style="width:100%; border: 1px solid black; background-color:#E8E8E8; font-size:12px; text-align: left;">Mano de Obra</td>
                    </tr><tr style="border: 1px solid black;"><td style="width:100%;">';
                     $estructura.='<table style="width:100%; padding:0px;margin:0px;"><tr>
                                <th  style="width:80%;border: 1px solid black; font-size:11px; text-align:center;font-weight:bold;">Descripción</th>
                                <th  style="width:20%;border: 1px solid black; font-size:11px; text-align:center;font-weight:bold;">Cantidad </th>
                            </tr>';
                    if($mano!=false){
                        foreach($mano as $man){
                                if(round($man->aplicaid) == round($pro->idrec)){
                                    $estructura.='<tr>
                                    <td style="width:80%;border: 1px solid black;font-size:11px; text-align:center;">'.$man->notas.'</td>
                                    <td style="width:20%;border: 1px solid black;font-size:11px; text-align:center;">'. round($man->cantidad).'</td></tr>';
                                }
                        }
                    }
                    $estructura.='</table></td></tr>';
                    
                }
                $estructura .= '<tr><td colspan="2"><br></td></tr>
                <tr><td coslpan="2" style="border: 1px solid black; font-size:12px; text-align: left;">Notas:  '.$in->notas.'</td></tr></table>';
                
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("ordenServicio.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        //EXCEL AJUSTE DE INVENTARIOS
        function ajustesExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Ajuste de Inventarios") // Titulo
                ->setSubject("Ajuste de Inventarios") //Asunto
                ->setDescription("Ajuste de Inventarios") //Descripción
                ->setKeywords("Ajuste de Inventarios") //Etiquetas
                ->setCategory("Ajuste de Inventarios"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Ajuste_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function ajustesDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Ajuste_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Ajuste_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Ajuste_'.$trannum.'.txt');
                exit;
            }
            
        }
        
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}
		
		function unidad_centimos($numero){
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;

			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('Landscape', 'mm', 'LETTER', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P','LETTER');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">'.$info->descrip.' N° '.$info->serie.'-'.$info->numero.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">ORDEN N° '.$info->trannum.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;">CLIENTE: '.strtoupper($info->nameCliente).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:5%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">FECHA: '.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:12px; width:100%;"><br></td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;"> '.$pro->idproducto.' '.strtoupper($pro->descrip).' - <strong>'.strtoupper($pro->vendename).'</strong></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:70%;"rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:1%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 16px; width:10%;" rowspan="2">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
                
                foreach($informacion as $info){
					$estructura .= '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">'.$info->descrip.' N° '.$info->serie.'-'.$info->numero.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">ORDEN N° '.$info->trannum.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;">CLIENTE: '.strtoupper($info->nameCliente).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:5%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">FECHA: '.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:12px; width:100%;"><br></td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;"> '.$pro->idproducto.' '.strtoupper($pro->descrip).' - <strong>'.strtoupper($pro->vendename).'</strong></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:70%;"rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:1%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 16px; width:10%;" rowspan="2">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				/*$js = 'print(true);';
				$pdf->IncludeJS($js);*/
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 23%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 23%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
		function reporteCorteZAntiguo($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					//var ipaddr = datosprinter[0];
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
		$script .= "var numCantidad = ".$numInicial.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

					if(numTotal == 1){
						var newString = '          ".$numInicial."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numInicial."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numInicial."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numInicial."';
					}else if(numTotal == 5){
					    var newString = '      ".$numInicial."';
					}else if(numTotal == 6){
						var newString = '     ".$numInicial."';
					}else if(numTotal == 7){
						var newString = '    ".$numInicial."';
					}else if(numTotal == 8){
						var newString = '   ".$numInicial."';
					}else if(numTotal == 9){
						var newString = '  ".$numInicial."';
					}";
		
		$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
		$script .= "var numCantidad = ".$numFinal.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numFinal."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numFinal."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numFinal."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numFinal."';
					}else if(numTotal == 5){
					    var newString = '      ".$numFinal."';
					}else if(numTotal == 6){
						var newString = '     ".$numFinal."';
					}else if(numTotal == 7){
						var newString = '    ".$numFinal."';
					}else if(numTotal == 8){
						var newString = '   ".$numFinal."';
					}else if(numTotal == 9){
						var newString = '  ".$numFinal."';
					}";
						
		$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
		
		$script .= "var numCantidad = ".$numdoc.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdoc."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdoc."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdoc."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdoc."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdoc."';
					}else if(numTotal == 6){
						var newString = '     ".$numdoc."';
					}else if(numTotal == 7){
						var newString = '    ".$numdoc."';
					}else if(numTotal == 8){
						var newString = '   ".$numdoc."';
					}else if(numTotal == 9){
						var newString = '  ".$numdoc."';
					}";
						
		$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotalex, 2),2)."';
					}";
						
		$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotalgr, 2),2)."';
					}";
						
		$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotaliv, 2),2)."';
					}";
		$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotal, 2),2)."';
					}";
		
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
						
						$totalglobal = $totalglobal+$subtotal;
						$totalexglobal = $totalexglobal + $subtotalex;
						$totalgrglobal = $totalgrglobal + $subtotalgr;
						$totalivglobal = $totalivglobal + $subtotaliv;
                    	
					}
				
		$script .= "ticketObj.addText('    Totales:').addFeed();";
				
		$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
		$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
		$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
		$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";
		$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
		$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
		$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
		
		$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
					$total_ing_sum=0;
					$l=0;
					foreach($tipospagos as $tip){
						$l++;
					}
					$p=0;
					foreach($tipospagos as $tip){
						$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
									var totalString = numCantidad.toString();
									while(totalString.length < 23){
										totalString = ' ' + totalString;
									}
									
									var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
									var valorString = numPrecio.toString();
									var numTotal = valorString.length;

									if(numTotal == 1){
										var newString = '         $' + numPrecio;
									}else if(numTotal == 2){
										var newString = '        $' + numPrecio;
									}else if(numTotal == 3){
										var newString = '       $' + numPrecio;
									}else if(numTotal == 4){
										var newString = '      $' + numPrecio;
									}else if(numTotal == 5){
										var newString = '     $' + numPrecio;
									}else if(numTotal == 6){
										var newString = '    $' + numPrecio;
									}else if(numTotal == 7){
										var newString = '   $' + numPrecio;
									}else if(numTotal == 8){
										var newString = '  $' + numPrecio;
									}else if(numTotal == 9){
										var newString = ' $' + numPrecio;
									}";
						if($p == $l - 1){
							$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
						}else{
							$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
						}
						$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
						$p++;
					}
				
		$script .= "var numCantidad = ".number_format(round($total_ing_sum, 2),2).";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
		$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('Firma Cajera/o').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					// append paper cutting
					ticketObj.addCut();
								
					// create print object
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					// register callback function
					epos.onreceive = function (res){
					// close print dialog
					//$('#print').dialog('close');
					// print failure
					if (!res.success) {
					// show error message
					//$('#receive').dialog('open');
					}
					}

					// register callback function
					epos.onerror = function (err) {
					// close print dialog
					//$('#print').dialog('close');
					// show error message
					//$('#error').dialog('open');
					}
					// send
					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = ".number_format(round($total_ing_sum, 2),2).";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZPruebas($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.15';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = ".number_format(round($total_ing_sum, 2),2).";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function valueinv($sucursal){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                /*
                
                <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label></td>
                                    </tr>
                */
                
                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                <tr><td style="font-size:10px;"></td></tr>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border: 1px solidblack;">
                                <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                                <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 2),6).'</td>
                                <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round(($pro->cantidad * $pro->preciotran), 2),2).'&nbsp;&nbsp;</td></tr>';
                }
                
                 $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
    }
?>