<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct() {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
            //$this->load->model('pdfs_model');
        }
        
        function recepcionDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Recepcion_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
        }
        
        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
            # devolvemos el array de valores
            return $info;
        }
        
        function factura_pdf_nuevo($numero){
           
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/

            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                            /*if(isset($imagen) and $imagen!=""){
                                $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                            }*/

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function orden_pedido($trannum){
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(5, 5, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );
            
            $this->load->model('pedclientes_model');
            $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
                
            $sucursal = strtoupper($dataPedido['pedidoSuc']);
            $pedido = $dataPedido['trannum'];
            $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
            $cli_name = $dataPedido['descrip'];
            $cli_phone = $dataPedido['cli_phone'];
            $cli_email = $dataPedido['cli_email'];
            $notas = $dataPedido['notas'];
            $dev_date = ucwords($dataPedido['fechaPedido']);
            $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
            if($dataPedido['dev_place'] == 1){
                $lugar = $dataPedido['nameSucursal'];
            }else{
                $lugar = $dataPedido['dev_direc'];    
            }
            $dev_contact = $dataPedido['dev_contact'];
            $dev_phone =$dataPedido['dev_phone'];
            $valPedido = $dataPedido['val_pro'];
            $valEnvio = $dataPedido['val_envio'];
            $valVenta = $dataPedido['val_tot'];
            $valAnti = $dataPedido['val_anti'];
            
            $tamano = strlen($trannum);
            $codbar = "";
                
            if($tamano==1){
                $codbar = "00000".$pedido;
            }elseif($tamano==2){
                $codbar = "0000".$pedido;
            }elseif($tamano==3){
                $codbar = "000".$pedido;
            }elseif($tamano==4){
                $codbar = "00".$pedido;
            }elseif($tamano==5){
                $codbar = "0".$pedido;
            }elseif($tamano==6){
                $codbar = $pedido;
            }
            
            $estructura = '<br><br><table style="width:100%;">
                                <tr>
                                    <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td></td>
                                    <td style="font-size:12px; text-align:right;">ORDEN DE PEDIDO<br>'.strtoupper($this->session->userdata('appName')).'<br><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                </tr>
                            </table><br><br>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Nombre de Cliente:</td>
                                    <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:30%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                </tr>
                            </table>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;">'.$cli_name.'</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Teléfono: <strong>'.$cli_phone.'</strong>&nbsp;&nbsp;Correo: <strong>'.$cli_email.'</strong></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Sucursal</td>
                                    <td style="font-size:10px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$sucursal.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:15%; border: 1px solid #6E6E6E; color:#0B486B;">'.$trannum.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                            </table>';
            
             $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_date.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:90%; border: 1px solid #6E6E6E;" colspan="3">'.$lugar.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Contacto</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_contact.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Teléfono</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_phone.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                    <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                </tr>';
            foreach($list_producto as $key){
                $subtotal = $key->cantidad * $key->precioneto;
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                    <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                    <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                    <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:9px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Sub-total</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valPedido.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Envio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valEnvio.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Suma</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Anticipo</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valAnti.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-bottom: 1px solid #6E6E6E; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; border-bottom: 1px solid #6E6E6E; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; border-bottom: 1px solid #6E6E6E; font-weight: bold; width:10%;">Pendiente</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">$'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                                </tr>';
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas.'</td>
                                </tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                            </table><br><br><br>';
                $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';
            
            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ticket_pedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P', $pagelayout);

                $this->load->model('pedclientes_model');
                $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                
                $sucursal = strtoupper($dataPedido['pedidoSuc']);
                $pedido = $dataPedido['trannum'];
                $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
                $cli_name = $dataPedido['descrip'];
                $cli_phone = $dataPedido['cli_phone'];
                $cli_email = $dataPedido['cli_email'];
                $dev_date = ucwords($dataPedido['fechaPedido']);
                $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
                if($dataPedido['dev_place'] == 1){
                    $lugar = $dataPedido['nameSucursal'];
                }else{
                    $lugar = $dataPedido['dev_direc'];    
                }
                $dev_contact = $dataPedido['dev_contact'];
                $dev_phone =$dataPedido['dev_phone'];
                $dev_phone =$dataPedido['dev_phone'];
                $valPedido = $dataPedido['val_pro'];
                $valEnvio = $dataPedido['val_envio'];
                $valVenta = $dataPedido['val_tot'];
                $valAnti = $dataPedido['val_anti'];

                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE '.strtoupper($this->session->userdata('appName')).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';
                        
                        $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pedido</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 24px; width:50%; font-weight: bold;">Producto</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Cant</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Precio</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 24px; width:18%; font-weight: bold;">Sub-total</td>
                            </tr>';
                        
                        foreach($list_producto as $key){
                            $subtotal = $key->cantidad * $key->precioneto;
                            $estructura .= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 20px; width:50%;">'.$key->descrip.'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">'.round($key->cantidad).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                
                $estructura .= '</table>';
                
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PEDIDO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valPedido, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valEnvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valVenta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valAnti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                            </tr>
                        </table>';
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_pedido_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                    
            }
        
        }
        
        function ticket_nuevo($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage( 'P',$pagelayout);

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

                if(is_array($products) && $products!=false){
                    $sucursal = strtoupper($products['descrip']);
                    $pedido = $products['numero'];
                    $cli_name = $products['cli_name'];
                    $cli_phone = $products['cli_phone'];
                    $date = date_format(date_create($products['date']),'d/m/Y');
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_refund = $products['val_refund'];
                    $tpastel = $products['val_pastel'];
                    $taccesorios = $products['val_acc'];
                    $tbases = $products['val_bases'];
                    $tenvio = $products['val_envio'];

                    $cli_email = $products['cli_email'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $imagen = $products['pastel_fotos'];
                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $dev_contact = $products['dev_contact'];
                    $dev_phone = $products['dev_phone'];

                    $lugar = "";
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3) {
                        $lugar = "Recoger en Producción";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];

                    $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                }else{
                    redirect('pedidos_clientes/pasteles_al_gusto/');
                }

        
                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE PASTELES</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date2.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';

                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                        
                     $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pastel</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Tortas:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cktortas.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Porciones:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$ckslices.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Referencia:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$catreference.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Dedicatoria:</td>
                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';
                    
                    $i = 1;
                    foreach($arrayPasteles as $key => $value){

                        $estructura .= '<table style="width:100%;">
                                            <tr>
                                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Torta '.$i.' </td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Posición:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_position'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Forma:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_shape'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Relleno:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_filling'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Sabor:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_flavor'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Baño:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_bath'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Cobertura:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_covering'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Color:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_color'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px;font-weight: bold; width:30%;">Notas:</td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.ucwords($value['notas']).'</td>
                                            </tr>
                                        </table>';
                        $i++;
                    }
                }

                if($accesorios!=false){

                    $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>ACCESORIOS </td>
                            </tr>';
        
                    foreach($accesorios as $key => $value){
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                       </tr>';
                    }

                    $estructura .= '</table>';
                }

                if($bases!=false){

                    $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>BASES </td>
                                </tr>';
        
                    foreach ($bases as $key => $value) {
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                        </tr>';
                    }
                    
                    $estructura .= '</table>';
                }

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline;"><br><br>OBSERVACIONES </td>
                            </tr>
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-size: 28px;">'.$dev_notes.'</td>
                            </tr></table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PASTEL $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tpastel, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ACCESORIOS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($taccesorios, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">BASES $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tbases, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tenvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">REEMBOLSABLE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function ordenes_pdf($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }

                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    /*if(isset($imagen) and $imagen!=""){
                        $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                    }*/
                    $estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function lista_pdf_nuevo_todo($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS');
                $pdf->SetSubject('LISTADO DE PEDIDOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(1, 2, 1);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 2);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', 'LETTER' );
                
                $fechai = $fecha;
                $fechaf = $fecha;
                if($fechai=="" || $fechaf=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
        
                $sucursales = $this->produccion_model->getPedidosClientes_by_Sucursal(1,$fechai,$fechaf,$estado,1);
                $tdomicilio = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,2);
                $tproduccion = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,3);
                $pedidos_sucursal = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,1);
                $pedidos_domicilio = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,2);
                $pedidos_produccion = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,3);

                $estructura = '';

                $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px;">'.$titulo.'</td>
                                </tr>
                            </table><br><br><br>';

                if($pedidos_sucursal!=false || $pedidos_domicilio!=false || $pedidos_produccion!=false){

                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:18%;">Cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Referencia</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:51%;">Detalles</td>
                                </tr>
                                <tr><td colspan="6"><hr></td></tr>
                            </table>';
                    
                    if(is_array($sucursales) && $sucursales!=false){                
                        foreach ($sucursales as $key => $value) {
                            $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">'.$value['devdirec2'].' ('.$value['totalpedidos'].')</td>
                                </tr>';
                            
                            foreach ($pedidos_sucursal as $key2 => $value2) {
                                
                                if($value['dev_direc']==$value2['dev_direc']){
                                    $cktortas = $value2['ck_tortas'];
                                    $ckslices = $value2['porciones'];
                                    
                                    if($value['dev_direc']==$value2['dev_direc']){
                                        $estructura.= '<tr>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                                        $i=0;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }

                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                                        $i2 = 1;

                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }
                                        
                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb) {
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                $i3++;  
                                            }
                                        }
                                        $estructura.= '</td>
                                            </tr>
                                            <tr><td colspan="6"><hr></td></tr>'; 
                                    }
                                }
                            }
                            $estructura.= '</table>';
                        }
                    }
                    /****************************/
                    if(is_array($pedidos_domicilio) && $pedidos_domicilio!=false){                
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';

                        foreach ($pedidos_domicilio as $key2 => $value2) {
                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                            
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                            
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep){
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                           }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea){
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                
                                foreach ($arrayBases as $keyb => $valueb){
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                    
                        }

                        $estructura.= '</table>';
            
                    }
                    /****************************/
                    
                    /****************************/
                    if(is_array($pedidos_produccion) && $pedidos_produccion!=false){                
                     
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">PRODUCCIÓN ('.$tproduccion.')</td>
                                </tr>';
                        
                        foreach ($pedidos_produccion as $key2 => $value2) {

                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                   
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).','. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }
                            
                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }
                            
                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                        }
                    
                        $estructura.= '</table>';
            
                    }
                  
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
                $nombre_archivo = utf8_decode("listado_pedidos.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function reporte_por_hora($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetSubject('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $fechai = $fecha;
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');

                $horas = $this->produccion_model->get_horas_por_pedido($fechai,$estado);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS POR HORA</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';

                $estructura2.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">Porciones</td>
                                </tr>
                            </table>';                            
                
                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );


                if($horas!=false){
                    if(is_array($horas) && $horas!=false){                
                        foreach ($horas as $key_horas => $value_horas){
                            $estructura.= '<table style="width:100%;">
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_horas['hora'].' ('.$value_horas['npedidosporhora'].')</td>
                                            </tr>';

                            $sucursales = $this->produccion_model->get_sucursales_por_hora_por_pedido($fechai,$estado,$value_horas['dev_time'],1);

                            if(is_array($sucursales) and $sucursales!=false){
                                foreach ($sucursales as $key_sucursales => $value_sucursales) {
                                    $estructura.= '<tr>
                                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                                   </tr>';

                                    $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],1,$value_sucursales['dev_direc']);

                                    if(is_array($pedido) and $pedido!=false){
                                        foreach ($pedido as $key_pedido => $value_pedido) {
                                            $estructura.= '<tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                           </tr>
                                                           <tr>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                           </tr>
                                                           <tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                            $i=1;
                                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                                //$i = count($arrayPasteles);
                                                foreach ($arrayPasteles as $keyp => $valuep) {
                                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                    $i++;  
                                                }
                                            }

                                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                            $i2 = 1;

                                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                                $estructura.= '<b>ACCESORIOS:</b> ';
                                                foreach ($arrayAccesorios as $keya => $valuea) {
                                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                    $i2++;  
                                                }
                                            }

                                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                            $i3 = 1;
                                            
                                            if(is_array($arrayBases) and $arrayBases!=false){
                                                //$i3 = count($arrayBases);
                                                $estructura.= '<b>Bases:</b> ';
                                                foreach ($arrayBases as $keyb => $valueb) {
                                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                    $i3++;  
                                                }
                                            }
                                            $estructura.='</td>
                                            </tr>';
                                        }
                                    }
                                }
                            }

                            $tdomicilio = $this->produccion_model->getCount_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2);

                            if($tdomicilio!=false){
                                $estructura.= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';
                                
                                $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2,'');

                                if(is_array($pedido) and $pedido!=false){
                                    foreach ($pedido as $key_pedido => $value_pedido) {
                                        $estructura.= '<tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                       </tr>
                                                       <tr>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                       </tr>
                                                       <tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                            <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                        $i=1;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            //$i = count($arrayPasteles);
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }
                                        
                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                        $i2 = 1;
                                        
                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }

                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb){
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']);
                                                $i3++;  
                                            }
                                       }

                                        $estructura.='</td>
                                        </tr>';
                                    }
                                }
                            }
                            
                            $estructura.= '</table>';
                        }
                    }
           
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("listado_pedidos_por_hora.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_de_despacho($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE DE DESPACHO');
                $pdf->SetSubject('REPORTE DE DESPACHO');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $fechai = $fecha;
                
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
                
                $sucursales = $this->produccion_model->get_sucursales_reporte_de_despacho($fechai,$estado,1);
                $domicilio = $this->produccion_model->get_total_pedidos_por_dev_place($fechai,$estado,2);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE DE DESPACHO</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';
                     
                $estructura2.= '<table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Hora</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Porciones</td>
                    </tr>
                </table>';                            

                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

            
                if(is_array($sucursales) && $sucursales!=false){    
                    foreach ($sucursales as $key_sucursales => $value_sucursales){
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                </tr>';
                 
                        $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,1,$value_sucursales['dev_direc']);
                 
                        if(is_array($pedidos) and $pedidos!=false){
                            foreach($pedidos as $key_pedido => $value_pedido){
                                $estructura.= '<tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                               </tr>
                                               <tr>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                               </tr>
                                               <tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                    <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                $i=1;
                                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                    //$i = count($arrayPasteles);
                                    foreach ($arrayPasteles as $keyp => $valuep){

                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';

                                      $i++;  
                                    }
                                }

                                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                $i2 = 1;
                                
                                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                    //$i2 = count($arrayAccesorios);
                                    $estructura.= '<b>ACCESORIOS:</b> ';
                                    foreach ($arrayAccesorios as $keya => $valuea){
                                        $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                        $i2++;  
                                    }
                                }

                                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                $i3 = 1;

                                if(is_array($arrayBases) and $arrayBases!=false){
                                    //$i3 = count($arrayBases);
                                    $estructura.= '<b>Bases:</b> ';
                                    foreach ($arrayBases as $keyb => $valueb){
                                        $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                        $i3++;  
                                    }
                                }

                                $estructura.='</td>
                                </tr>';
                            }
                        }
                
                        $estructura.= '</table>';
                    }
                }
                
                if($domicilio!=0){
                       
                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>DOMICILIO ('.$domicilio.')</td>
                                </tr>';
                    
                    $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,2,"");
                 
                    if(is_array($pedidos) and $pedidos!=false){
                        foreach ($pedidos as $key_pedido => $value_pedido){
                            $estructura.= ' <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;"><b>DIRECCIÓN:</b> '.trim($value_pedido['dev_direc']).', <b>PREGUNTAR POR:</b> '.trim($value_pedido['dev_contact']).', <b>TELÉFONO:</b> '.trim($value_pedido['dev_phone']).'
                                                </td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                            $i=1;
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                //$i2 = count($arrayAccesorios);
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }

                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                //$i3 = count($arrayBases);
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.='</td>
                            </tr>';
                        }
                    }
                    $estructura.= '</table>';
                }
                
           
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_producto_sucursal($fecha, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE CONTROL PRODUCCION');
                $pdf->SetSubject('REPORTE CONTROL PRODUCCION');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $header = '     <table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE CONTROL PRODUCCIÓN</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA <strong>'.date_format(date_create($fecha), 'd/m/Y').'</strong></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    </tr>
                                </table><br><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $this->load->model('tpedido_model');
                
                $salas_venta = $this->tpedido_model->getNameSalasdeVenta();
                                                
                $lst_productos = explode("_", $productos);
                $tot = count($lst_productos);
                $total_ = $tot - 1;
                if($total_ >= 12){
                    $tamano = 90 / 12;    
                }else{
                    $tamano = 90 / $total_;    
                }
                
                $pdf->addPage('L', 'LETTER');
                $estructura = ' <table style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th style="background-color:#F0F0F0; color:#FFFFFF; width:10%; height:25px; font-size:14px; text-align:center; vertical-align:middle; border-style:solid; border-width: 1px 1px 1px 1px;"></th>';
                    for($j=0; $j<$total_; $j++){
                        $name = $this->tpedido_model->getNameProducto($lst_productos[$j]);
                        $estructura .= '    <th style="width:'.$tamano.'%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.$name.'</th>';            
                    }                        
                //$estructura .= '            <th style="width:10%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>TOTAL</th>';
                $estructura .= '        </tr>
                                    </thead>';
                
                foreach($salas_venta as $sv){
                    $sum_ = 0;
                    $estructura .=' <tbody>
                                        <tr>
                                            <td style="text-align:left; background-color:#F0F0F0; color:#000000; width:10%; height:35px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>'.$sv->descrip.'</strong></td>';
                        for($j=0; $j<$total_; $j++){
                            $cantidad = $this->tpedido_model->getCantProducto($lst_productos[$j], $fecha, $sv->idcentro);
                            if($cantidad == "0" || $cantidad == ""){
                                $cantidad = "";    
                            }else{
                                $cantidad = round($cantidad);
                            }
                            $estructura .= '<td style="width:'.$tamano.'%; height:35px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>'.$cantidad.'</td>';            
                            $sum_ += $cantidad;
                        }                       
                    $estructura .= '    </tr>';
                }
                $estructura .= '        <tr>
                                            <td style="text-align:center; background-color:#F0F0F0; color:#000000; width:10%; height:30px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>TOTAL</strong></td>';
                for($j=0; $j<$total_; $j++){
                    $sum_total = $this->tpedido_model->getTotalProducto($lst_productos[$j], $fecha);
                    $estructura .= '    <td style="width:'.$tamano.'%; height:30px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#A80000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.round($sum_total).'</td>';
                }
                $estructura .= '        </tr>';
                $estructura .= '    <tbody>    
                                </table>';
                
                $estructura .= '<style>
                                    .sucursales{
                                        color:#000000; 
                                        font-size:11px; 
                                    }
                                </style>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:175px; height:80px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:20%;"></td>
									<td style="font-size:15px; text-align:center;width:80%;">'.strtoupper($nombreFormato).'</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
                    
                $header .= '
                <table style="width:100%;">
                    <tr>
                        <td style="font-size:10px;"></td>
                    </tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#003366; color:white; width:37.5%; font-weight: bold;" > Origen</td>
						<td style="font-size:12px; text-align:left; background-color:#003366; color:white; width:37.5%; font-weight: bold;" > Destino</td>
						<td style="font-size:12px; text-align:center; background-color:#003366; color:white; width:25%; font-weight: bold;" colspan="2"> Datos de Orden</td>
					</tr>
				</table>';
                $header .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 0.5px solid #6E6E6E;border-top: 0.5px solid #6E6E6E;" rowspan="2">'.$data->centrocd.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 0.5px solid #6E6E6E;border-top: 0.5px solid #6E6E6E;" rowspan="2">'.$data->idcentrod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;background-color:#003366; color:white;"> N°:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 0.5px solid #6E6E6E;"> '.$data->trannum.'</td>
					</tr>
                    <tr>
						<td style="font-size:11px; text-align:right;width:10%;background-color:#003366; color:white;"> Fecha:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 0.5px solid #6E6E6E;"> '.$date_emision.'</td>
					</tr>
                    <tr>
                        <td style="font-size:11px; text-align:left;width:37.5%;border-left: 0.5px solid #6E6E6E;border-bottom: 0.5px solid #6E6E6E;"> '.$data->encargadoinv.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 0.5px solid #6E6E6E;border-bottom: 0.5px solid #6E6E6E;"> '.$data->encargadod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%; background-color:#003366; color:white;"> Estado:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 0.5px solid #6E6E6E;"> '.$estado.'</td>
					</tr>
                    </table>';
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#69a6c7;">
                                        <th style="background-color:#003366; color:white;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#69a6c7;">
                                        <th style="background-color:#003366; color:white; border-left: 0.5px solid #6E6E6E;  width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#003366; color:white;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#003366; color:white;  width:10%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#003366; color:white;  width:35%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#003366; color:white;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                                        <th style="background-color:#003366; color:white;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#003366; color:white;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#003366; color:white;  width:9%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                        <th style="background-color:#003366; color:white; border-right: 0.5px solid #6E6E6E; width:1%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#003366; color:white;">
                                        <th style="background-color:#003366; color:white;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  1px solid #6E6E6E; ">
                                <td style="width:5%; border-left: 0.5px solid #6E6E6E;  text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:9%; text-align:center; font-size:10px;  border-bottom:solid 0.5px black;"></td>
                                <td style="width:1%;border-right: 0.5px solid #6E6E6E;  text-align:center; font-size:10px;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='
                    <tr><td style="font-size:5px; width:100%;border-left:0.5px solid #6E6E6E;border-right:0.5px solid #6E6E6E;"></td></tr>
                    
                    <tr style="border:0.5px solid #6E6E6E; font-size:12px;">
                        <td style="width:5%;border-top:0.5px solid #6E6E6E;border-bottom:0.5px solid #6E6E6E;border-left:0.5px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="width:75%;border-top:0.5px solid #6E6E6E;border-bottom:0.5px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%;border-top:0.5px solid #6E6E6E;border-bottom:0.5px solid #6E6E6E;text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(number_format(round($totalcant, 2),2)).'</strong></td>
                        <td style="width:10%;border-top:0.5px solid #6E6E6E;border-bottom:0.5px solid #6E6E6E;border-right:1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                     $titulo .= '
                      <table>
                    <tr>
				        <td style="width:100%;"><br><br></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:center;background-color:#003366; color:white; width:33.3%;bold;">Entregado por</td>
						<td style="font-size:12px; text-align:center;background-color:#003366; color:white; width:33.3%;bold;">Recibido por</td>
						<td style="font-size:12px; text-align:center;background-color:#003366; color:white; width:33.3%;bold;">Fecha y hora</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 0.5px solid #6E6E6E;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 0.5px solid #6E6E6E;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 0.5px solid #6E6E6E;"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombre_doc);
                $pdf->SetSubject($nombre_doc);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 40, PDF_MARGIN_RIGHT, 0); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
				
				foreach($informacion as $inf){
					$header = '
						<center>
							<table style="width:100%; text-align:center;">
								<tr style="font-size:12px; text-align;center;">
									<td style="font-size:12px; text-align;center; width:20%;" rowspan="3"><br><img src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/LogoLulaMena.jpg"/></td>
									<td style="font-size:12px; text-align;center; width:60%;"><br><br><br><label><strong>ENTREGA A TIENDA</strong></label></td>
									<td style="font-size:18px; text-align;center; width:20%;" rowspan="3"><br><br><label><strong>N°</strong><br><strong style="font-size:16px;">'.$inf->trannum.'</strong></label></td>
								</tr>
								<tr style="font-size:12px; text-align;center;">
									<td style="font-size:12px; text-align;center;">Comunidad: '.$inf->descrip.'</td>
								</tr>
								<tr style="font-size:12px; text-align;center;" >
									<td style="font-size:12px; text-align;center;">Fecha de Entrega: '.$inf->fecformat.'</td>
								</tr>
							</table>
						</center>';
				}
                
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
				$pdf->setPrintFooter(false);

                $pdf->addPage( 'P', 'LETTER' );
                
				$titulo='
					<table style="border: solid 1px black;">
						<thead>
							<tr>
								<th style="border-left: solid 1px black; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-size:12px; text-align:center;" width="20%"><strong>IMAGEN</strong></th>
								<th style="border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-size:12px; text-align:center;" width="35%"><strong>DESCRIPCION</strong></th>
								<th style="border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-size:12px; text-align:center;" width="20%"><strong>CODIGO TIENDA</strong></th>
								<th style="border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-size:12px; text-align:center;" width="15%"><strong>CANTIDAD</strong></th>
								<th style="border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-size:12px; text-align:center;" width="10%"><strong>PRECIO</strong></th>
							</tr>
						</thead>
						<tbody>';
				$i=0; $sumCantidad=0;
				foreach($productos as $pro){
					if($pro->imagen != ""){
						$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}
					}else{
						$srcImagen = base_url()."img/sinImagen.png";
					}
					$titulo.='
							<tr>
								<td style="width:20%; text-align:center; vertical-align:middle; font-size:12px; border-right: solid 1px #C2CBCE; border-bottom: solid 1px #C2CBCE;"><br><br><img src="'.$srcImagen.'" width="110px" height="65px"></td>
                                <td style="width:35%; vertical-align:middle; padding:0px; font-size:12px; border-right: solid 1px #C2CBCE; border-bottom: solid 1px #C2CBCE;"><br><br>'.trim($pro->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:12px; border-right: solid 1px #C2CBCE; border-bottom: solid 1px #C2CBCE;"><br><br><br>'.$pro->idproducto.'</td>
                                <td style="width:15%; text-align:center; vertical-align:middle; padding:0px; font-size:12px; border-right: solid 1px #C2CBCE; border-bottom: solid 1px #C2CBCE;"><br><br><br>'.number_format($pro->cantidad).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:12px; border-bottom: solid 1px #C2CBCE;"><br><br><br>$'.number_format($pro->precioventa, 2, '.', '').'</td>
							</tr>';
					$i++; $sumCantidad = $sumCantidad + $pro->cantidad;
                }
				
				$titulo.='
					<tr>
						<td style="width:20%; text-align:center; vertical-align:middle; font-size:16px; border-right: solid 1px #000000; border-bottom: solid 1px #000000; border-top: solid 1px #000000;"><strong>'.$i.'</strong></td>
						<td style="width:35%; vertical-align:middle; padding:0px; font-size:16px; border-right: solid 1px #000000; border-bottom: solid 1px #000000; border-top: solid 1px #000000;"></td>
						<td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:16px; border-right: solid 1px #000000; border-bottom: solid 1px #000000; border-top: solid 1px #000000;"></td>
						<td style="width:15%; text-align:center; vertical-align:middle; padding:0px; font-size:16px; border-right: solid 1px #000000; border-bottom: solid 1px #000000; border-top: solid 1px #000000;"><strong>'.number_format($sumCantidad).'</strong></td>
						<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:16px; border-bottom: solid 1px #000000; border-top: solid 1px #000000;"></td>
					</tr>';
				
				$titulo.='                 
						</tbody>
					</table>';
				
				$titulo .='<br><br><br><br><br><br>
					<table>
						<tbody>
							<tr>
								<td style="width:5%; font-size:12px; text-align:center;"></td>
								<td style="width:40%; font-size:12px; text-align:center; border-bottom: solid 1px black;"></td>
								<td style="width:10%; font-size:12px; text-align:center;"></td>
                                <td style="width:40%; font-size:12px; text-align:center; border-bottom: solid 1px black;"></td>
                                <td style="width:5%; font-size:12px; text-align:center;"></td>
							</tr>
							<tr>
								<td style="width:50%; font-size:12px; text-align:center;"><strong>Nombre de quien entrega el pedido:</strong></td>
                                <td style="width:50%; font-size:12px; text-align:center;"><strong>Nombre de quien recibe el pedido:</strong></td>
							</tr>
						</tbody>
					</table>';
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode($nombre_doc."_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);


                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'n');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name.", ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        $subtotal = $key->cantidad * $key->precioneto; 
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }

                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $subtotal = $key->cantidad * $key->precioneto; 
                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Proveedor</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Cliente</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px;"><br>Es indispensable presentar esta orden de compra al entregar el producto en nuestra bodega.<br><br></td>
                                    </tr>
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
       
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                 $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                       // if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                       // }
                       
                        foreach($lineas_list as $lin){
                            //&& $lin->cant!=0
                            if($lin->idnivel1==$dep->idcatalogo){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    
                     
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                
          
                
                
                }
                    

                
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                
                $apps = $this->apps_model->verApps();
                
               // $this->load->model('variable_model');
              //  $nombres = $this->variable_model->verNombres();
              //  $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                            
                            
                            
                            if($key2->menutype == 1){
                            
                            $titulo .= '<tr>
                                            <td width="3%"></td>
                                            <td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
                                        </tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
            $numero=trim($numero);
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
            $numero=trim($numero);
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
            $numero=trim($numero);
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
            $numero=trim($numero);
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
            $numero=trim($numero);
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;
            $numero=trim($numero);
			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(0, 10, 0,0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:50%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:50%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:11%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:89%;">'.$info->nameCliente.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:11%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:89%; padding-top:10px;">'.$info->direccion.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:11%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:89%; padding-top:10px;">'.$info->nrc.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br></td>
					</tr>';
                
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 38);
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:34%;">  '.$pro->idproducto.' '.$nombrepro.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$vnGravada.'</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:34%;">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				$js = 'print(true);';

				// set javascript
				$pdf->IncludeJS($js);
				
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
                
        function valueinv($sucursal, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 23%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							//$date2 = date_format(date_create($ven->fecact),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 23%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
        function comprasReport($provee, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Compras');
                $pdf->SetSubject('Reporte de Compras');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Reporte de Compras</label><br><label style="text-align:center; font-size:13px;">Periodo del '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $tipopro = $this->session->userdata('tipoprod');
				$idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('compras_model');
                $this->load->model('auxi_model');
                
                $titulo='<table>
                <thead>
                <tr>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Línea</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cod.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Modelo</td>
                        <td style="width:35%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Descripción</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">UM</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Lote</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cant.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Costo Unitario</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Sub Total</td>
                    </tr>
                </thead><tbody>';
                
                
                $lst_provee = explode("-", $provee);
                $tot = count($lst_provee);
                $total_ = $tot;
                $titulo2='';
                for($j=0; $j<$total_; $j++){
                    $name_provee = $this->auxi_model->getNameAuxi($lst_provee[$j]);
                    $titulo2='<tr><th colspan="9"><br></th></tr><tr><th colspan="9" style="font-size:15px; color: #0B486B;">'.$name_provee.'</th></tr>';
                    $ordenes = $this->compras_model->getListadoOrdenesReport("CO", $tipopro, $idcentro, $fechaini, $fechafin, $lst_provee[$j]);
                    $or=0;
                    foreach($ordenes as $or){
                        $or++;
                        $titulo2.= '<tr>
                        <td style="width:1%;  border-top:1px solid #343838; border-bottom:1px solid #343838; "></td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">Fecha: '.$or->fecha1.'</td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">Cierre: '.$or->fecha2.'</td>
                        <td style="width:39%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">N°: '.$or->serie.$or->numero.'</td></tr>';
                        if($or->notas!="" && $or->notas!=null){
                        $titulo2.= '<tr>
                            <td style="width:1%;"></td>
                            <td colspan="8" style="width:99%;font-size:12px; text-align:left; color:gray; ">&nbsp;&nbsp;&nbsp;&nbsp;'.$or->notas.'</td></tr>';
                        }
                        $exentas=0;
                        $gravadas=0;
                        $iva=0;
                        $total_iva=0;
                        $detalle_orden = $this->compras_model->getDetalleByEstatusCompraLocal($or->trannum, $or->estatus);
                        foreach($detalle_orden as $detail){
                            $subtotal = $detail->cantidad * $detail->preciotran;
                            $titulo2 .= '
                            <tr>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->itemline.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->idproducto.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->modelo.'</td>
                                <td style="width:35%; font-size:9px; text-align:left; font-color: black;">'.$detail->descrip.'</td>
                                <td style="width:10%; font-size:9px; text-align:center; font-color: black;">'.$detail->um.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->lote.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.number_format(round($detail->cantidad, 0),0).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">$'.number_format(round($detail->preciotran, 4),4).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">$'.number_format(round($subtotal, 2),2).'</td>
                            </tr>';
                            if($detail->tax1==0){
                                $exentas = $exentas+$subtotal;
                            }else if($detail->tax1==13){
                                $subtotal_coniva = $subtotal;
                                $subtotal_siniva = $subtotal*(($detail->tax1/100));
                                $gravadas = $gravadas+$subtotal_coniva;
                                $iva = $subtotal_siniva;
                                $total_iva = $total_iva + $iva;
                            }
                        }
                        
                        
                        $subtotal = $exentas+$gravadas+$total_iva;
                        
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Exentas:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($exentas, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Gravadas:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($gravadas, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">IVA:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Total:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($subtotal, 2),2).'</td>
                        </tr>';
                        
                    }
                    if($or!="0"){
                        $titulo.= $titulo2;
                    }
                    
                }         
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
		function ventaTicket($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				$this->load->library('Pdf');
                //$width = 210;
                $width = 85;
                $height = 10000;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket de Venta');
                $pdf->SetSubject('Ticket de Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 0, 5, 0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
				$this->load->model('caja_model');
				$this->load->model('global_model');
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
				}
				
				$infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);
				foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}
				
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				//$header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 18px; width:100%;">'.trim($RazonSocial).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">'.strtoupper($namecaja).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">'.strtoupper($namecentro).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">NRC: '.$NRF.' NIT: '.$NIT.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Giro: '.$GIRO.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">IVA D.L. N° 296</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Autorizado según resolución</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">N°: '.$numres.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Del: '.date_format(date_create($fecres), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;">Tiraje: '.$desder.' - '.$hastar.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$numTicket = str_pad($info->numero, 9, "0", STR_PAD_LEFT);
				$numTram = str_pad($info->trannum, 10, "0", STR_PAD_LEFT);
				$estructura .= '<table style="width:100%;">
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%; border-bottom: 1px solid #000;">'.strtoupper($info->descrip).' N° '.$info->numero.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>';
                
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
				$vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
				$cantidades = 0; $totalSumas = 0;
                foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
						$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								
						$vnExenta = "";
						$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','') . " G";
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}
					
					$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
					$proname = substr($pro->descrip, 0, 25);
					
					if($pro->descuento != 0){
						$totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . " G";
						$absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalSumas = $totalSumas + $absTotal;
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;">'.$pro->idproducto.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">'.$proname.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.abs($pro->cantidad).' @</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">'.number_format(round($pro->preciotran, 4), 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$totalmuldes.'</td>
						</tr>';
						
						$descuento = $pro->descuento / 100;
						$cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
						$totdsc = $cantdes * abs($pro->cantidad);
						$totalDesc = $totalDesc + $cantdes;
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">-'.number_format($pro->descuento, 2 ,'.','').'%</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">-'.number_format($cantdes, 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">-'.number_format($totdsc, 2 ,'.','').' G</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
					}else{
						if(strlen($vnExenta) != 0){
							$absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}else{
							$absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;">'.$pro->idproducto.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">'.$proname.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.abs($pro->cantidad).' @</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">'.number_format(round($pro->preciotran, 4), 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
					}
					$numProd++;
					$cantidades = $cantidades + abs($pro->cantidad);
				}
				
				$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">(G) = Gravadas     (E) = Exentas</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:6px; width:100%; border-bottom: 1px solid #000;"></td>
					</tr>';
				
				$grantotal = $totalIVA + $totalGravado;
				$estructura .= '
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">L/U:</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.$numProd.'/'.$cantidades.'</td> 
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">SUMAS:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalSumas, 2 ,'.','').'</td>
					</tr>';
				if($totalDesc != 0){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">- DESCUENTO:</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalDesc, 2 ,'.','').'</td>
						</tr>';
				}
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">TOTAL GRAVADO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($grantotal, 2 ,'.','').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">TOTAL EXENTO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalExento, 2 ,'.','').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; width:66%;">TOTAL:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; width:25%; border-bottom: 1px solid #000;">'.number_format($total, 2 ,'.','').'</td>
					</tr>';
				
				$detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
				
				$totalPagado = 0;
				foreach($detailPagos as $dtpagos){
					$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">'.strtoupper($dtpagos->namePago).':</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format(abs($dtpagos->valor), 2 ,'.','').'</td>
					</tr>';
					$totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
				}
				
				$totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">VUELTO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalVuelto, 2 ,'.','').'</td>
					</tr>';
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">ATENDIDO POR:</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.strtoupper($info->nameVendedor).'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.$date->format('d/m/Y').'   '.$date->format('H:i:s').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">GRACIAS POR SU COMPRA</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>';
				
				$estructura .= '</table>';
                
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				// force print dialog
				$js = 'print(true);';
				
				// set javascript
				$pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function ventaTicketPrueba($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				$this->load->library('Pdf');
                //$width = 210;
                $width = 85;
                $height = 10000;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket de Venta');
                $pdf->SetSubject('Ticket de Venta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 0, 5, 0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('sucursal_model');
				$this->load->model('caja_model');
				$this->load->model('global_model');
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcentro = $info->idcentro;
					$idcaja = $info->idcaja;
				}
				
				$infoRes = $this->ventas_model->getDatosResolucion($info->idclase, $info->idcentro, $info->idcaja);
				foreach($infoRes as $infres){
					$numres = $infres->resolucion;
					$fecres = $infres->fresolucion;
					$desder = $infres->serie.$infres->desde;
					$hastar = $infres->serie.$infres->hasta;
				}
				
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				//$header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 18px; width:100%;">'.trim($RazonSocial).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">'.strtoupper($namecaja).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">'.strtoupper($namecentro).'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">NRC: '.$NRF.' NIT: '.$NIT.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Giro: '.$GIRO.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">IVA D.L. N° 296</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Autorizado según resolución</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">N°: '.$numres.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">Del: '.date_format(date_create($fecres), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;">Tiraje: '.$desder.' - '.$hastar.'</td>
						</tr>
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$numTicket = str_pad($info->numero, 9, "0", STR_PAD_LEFT);
				$numTram = str_pad($info->trannum, 10, "0", STR_PAD_LEFT);
				$estructura .= '<table style="width:100%;">
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%; border-bottom: 1px solid #000;">'.strtoupper($info->descrip).' N° '.$info->numero.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>';
                
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; 
				$vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalDesc = 0;
				$cantidades = 0; $totalSumas = 0;
                foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
						$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								
						$vnExenta = "";
						$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','') . " G";
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','') . " E";
						$vnGravada = "";
					}
					
					$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
					$proname = substr($pro->descrip, 0, 25);
					
					if($pro->descuento != 0){
						$totalmuldes = number_format(round($pro->preciotran, 4), 4 ,'.','') * abs($pro->cantidad) . " G";
						$absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$totalSumas = $totalSumas + $absTotal;
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;">'.$pro->idproducto.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">'.$proname.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.abs($pro->cantidad).' @</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">'.number_format(round($pro->preciotran, 4), 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$totalmuldes.'</td>
						</tr>';
						
						$descuento = $pro->descuento / 100;
						$cantdes = number_format(round($pro->preciotran, 2), 6 ,'.','') * $descuento;
						$totdsc = $cantdes * abs($pro->cantidad);
						$totalDesc = $totalDesc + $cantdes;
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">-'.number_format($pro->descuento, 2 ,'.','').'%</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">-'.number_format($cantdes, 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">-'.number_format($totdsc, 2 ,'.','').' G</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
					}else{
						if(strlen($vnExenta) != 0){
							$absTotal = number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}else{
							$absTotal = number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$totalSumas = $totalSumas + $absTotal;
						}
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;">'.$pro->idproducto.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:87%;">'.$proname.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:30%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.abs($pro->cantidad).' @</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:25%;">'.number_format(round($pro->preciotran, 4), 4 ,'.','').' =</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:22%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
					}
					$numProd++;
					$cantidades = $cantidades + abs($pro->cantidad);
				}
				
				$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">(G) = Gravadas     (E) = Exentas</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:6px; width:100%; border-bottom: 1px solid #000;"></td>
					</tr>';
				
				$grantotal = $totalIVA + $totalGravado;
				$estructura .= '
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">L/U:</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.$numProd.'/'.$cantidades.'</td> 
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">SUMAS:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalSumas, 2 ,'.','').'</td>
					</tr>';
				if($totalDesc != 0){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">- DESCUENTO:</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalDesc, 2 ,'.','').'</td>
						</tr>';
				}
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">TOTAL GRAVADO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($grantotal, 2 ,'.','').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">TOTAL EXENTO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalExento, 2 ,'.','').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; width:66%;">TOTAL:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; width:25%; border-bottom: 1px solid #000;">'.number_format($total, 2 ,'.','').'</td>
					</tr>';
				
				$detailPagos = $this->ventas_model->getDetailPagosFactura($trannum);
				
				$totalPagado = 0;
				foreach($detailPagos as $dtpagos){
					$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">'.strtoupper($dtpagos->namePago).':</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format(abs($dtpagos->valor), 2 ,'.','').'</td>
					</tr>';
					$totalPagado = $totalPagado + number_format(abs($dtpagos->valor), 2 ,'.','');
				}
				
				$totalVuelto = number_format($total, 2 ,'.','') - number_format($totalPagado, 2 ,'.','');
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:66%;">VUELTO:</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:6%;">$</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:25%;">'.number_format($totalVuelto, 2 ,'.','').'</td>
					</tr>';
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;">ATENDIDO POR:</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.strtoupper($info->nameVendedor).'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">'.$date->format('d/m/Y').'   '.$date->format('H:i:s').'</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;">GRACIAS POR SU COMPRA</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; color:#FFF; font-size: 25px; width:100%;">ENTER<br></td>
					</tr>';
				
				$estructura .= '</table>';
                
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				// force print dialog
				
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function creditoFiscal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Credito Fiscal');
                $pdf->SetSubject('Credito Fiscal');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(0, 10, 0,0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
				
				$giro = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$nrf = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcps = $info->idcps;
				}
				
				$infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
				foreach($infoGzips as $infg){
					$departamento = trim($infg->depto);
					$municipio = trim($infg->municipio);
				}
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:12%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:37%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:11%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 15px; width:39%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:15%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:85%; padding-top:10px;">'.$info->direccion.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:15%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:20%;">'.$municipio.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:18%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:47%;">'.$departamento.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:49%;">'.$info->giro.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:4%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:32%; padding-top:10px;">'.$info->nrc.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:49%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:4%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:32%; padding-top:10px;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br></td>
					</tr>';
                
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							//$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						}else if($pro->tax1 != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tax1== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tax1 == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
						$nombrepro = substr($pro->descrip, 0, 38);
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:3%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:32%;">  '.$pro->idproducto.' '.$nombrepro.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.number_format(round($pro->precioneto, 4), 4 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
						</tr>';
				}
				$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>';
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 4), 4 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$totalGravIva = $totalGravado + $totalIVA;
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%; height:25px;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:35%;">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($totalGravado, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:53%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"> 13%</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($totalIVA, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($totalGravIva, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:63%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("CreditoFiscal".$trannum.".pdf");
				// force print dialog
				//$js = 'print(true);';

				// set javascript
				//$pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
			}
        
        }
        
        function ficha_tecnica($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ficha Técnica');
                $pdf->SetSubject('Ficha Técnica');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5,5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

                $this->load->model('mantenimiento_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $prod_dat = $this->producto_model->infoProduct($idproducto);
                $materia_prima = $this->fabrica_model->verFichasMateriales($idproducto);
                $mano_obra = $this->fabrica_model->verFichasObras($idproducto);
                
                $function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                

                //$pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                  foreach($prod_dat as $dat){
                      
                      if($dat->imagen!=""){
                          $imagen = "img_cuentas/".$this->session->userdata('diraccount')."/".$dat->imagen; 
                      }else{
                          $imagen = "img/sinImagen.png"; 
                      }
                 
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<table style="width:100%;">
                                        <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 16px;">'.$nombre_doc.'<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<table style="width:100%; border-collapse: separate; border: 1px solid black;">
                                <tr>
                                    <td colspan="6" style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 15px; width: 75%;">DATOS DE CONTACTO</td>
                                    <td rowspan="12" style="border: 1px solid black; border-spacing: 50px; border-collapse: separate; width: 25%; padding:20px;">
                                        <br><br>
                                        <img src="'.base_url().$imagen.'" id="viewImg" style="height:275px; width:250px;margin-top:10px;">
                                    </td> 
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-weight:bold; font-size: 12px;">Artesano:</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;">'.$dat->proveedor.'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-weight:bold; font-size: 12px;">Datos del producto</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-size: 11px;">Producto</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;">'.$dat->descrip.'</td>
                                </tr>
                                <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:left; font-size: 11px;">Codigo</td>
                                    <td colspan="4" style="border: 1px solid black;  font-weight:bold; text-align:center; font-size: 12px;">'.$dat->idproducto.'</td>
                                </tr>
                                <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:left; font-size: 11px;">Peso</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;">'.$dat->ftpeso.'</td>
                                </tr>
                                <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:left; font-size: 11px;">Características</td>
                                    <td  colspan="4"  style="border: 1px solid black; text-align:left; font-size: 12px;">'.$dat->ftspecs.'</td>
                                </tr>
                                 <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:left; font-weight:bold; font-size: 12px;">Datos de producción</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-size: 11px;">Capacidad productiva Mensual</td>
                                    <td colspan="2" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                    <td colspan="2" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-size: 11px;">Tiempo de Producción</td>
                                    <td colspan="2" style="border: 1px solid black; text-align:center; font-size: 12px;">'.$dat->fttime.'</td>
                                    <td colspan="2" style="border: 1px solid black; text-align:center; font-size: 12px;">Minutos</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-size: 11px;">Artesanos Disponibles</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="border: 1px solid black; text-align:left; font-size: 11px;">Herramientas Necesarias</td>
                                    <td colspan="4" style="border: 1px solid black; text-align:center; font-size: 12px;"></td>
                                </tr>
                            </table>';
                  }
                
                
                $estructura .= '<br><br><table style="width:100%; border-collapse: separate; border: 1px solid black;">
                                <tr>
                                    <td colspan="8" style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 15px; width: 100%;">MATERIAS PRIMA</td>
                                </tr>
                                <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Producto</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Código</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Proveedor</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Uni. Medida</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Cantidad</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Costo Unit.</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Total</td>
                                </tr>';
                $costo_total_mp =0;
                foreach($materia_prima as $mat){
                    $costo_total_mp += $mat->subtotal;
                    $estructura .='<tr>
                        <td colspan="2"  style="border: 1px solid black; text-align:center; font-size: 11px;">'.$mat->titulo.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.$mat->idproducto.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.$mat->proveedor.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.$mat->unidad.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.round($mat->cantidad).'</td>
                        <td style="border: 1px solid black; text-align:right; font-size: 11px;">$'.number_format(round($mat->costo, 4),4).'</td>
                        <td style="border: 1px solid black; text-align:right; font-size: 11px;">$'.number_format(round($mat->subtotal, 4),4).'</td>
                    </tr>';
                }
                $estructura .='<tr>
                        <td colspan="7" style="border: 1px solid black; text-align:center; font-weight:bold;   font-size: 12px;">COSTO TOTAL DE MATERIA PRIMA</td>
                        <td style="border: 1px solid black; text-align:right; font-weight:bold;  font-size: 12px;">$'.number_format(round($costo_total_mp, 4),4).'</td>
                    </tr>';
                
                $estructura.='</table>';
                
                
                $estructura .= '<br><br><table style="width:100%; border-collapse: separate; border: 1px solid black;">
                                <tr>
                                    <td colspan="7" style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 15px; width: 100%;">MANO DE OBRA</td>
                                </tr>
                                <tr>
                                    <td colspan="2"  style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Trabajo o Proceso</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Proveedor</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Uni. Medida</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Cantidad</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Costo Unit.</td>
                                    <td style="border: 1px solid black; text-align:center; font-weight:bold; font-size: 12px;">Costo Total</td>
                                </tr>';
                $costo_total_mo =0;
                foreach($mano_obra as $ma_o){
                    $costo_total_mo += $ma_o->subtotal;
                    $estructura .='<tr>
                        <td colspan="2" style="border: 1px solid black; text-align:center; font-size: 11px;">'.$ma_o->titulo.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.$ma_o->proveedor.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.$ma_o->unidad.'</td>
                        <td style="border: 1px solid black; text-align:center; font-size: 11px;">'.round($ma_o->cantidad).'</td>
                        <td style="border: 1px solid black; text-align:right; font-size: 11px;">$'.number_format(round($ma_o->costo, 4),4).'</td>
                        <td style="border: 1px solid black; text-align:right; font-size: 11px;">$'.number_format(round($ma_o->subtotal, 4),4).'</td>
                    </tr>';
                }
                $estructura .='<tr>
                        <td colspan="6" style="border: 1px solid black; text-align:center; font-weight:bold;   font-size: 12px;">COSTO TOTAL DE MANO DE OBRA </td>
                        <td style="border: 1px solid black; text-align:right; font-weight:bold;  font-size: 12px;">$'.number_format(round($costo_total_mo, 4),4).'</td>
                    </tr>';
                
                $estructura.='</table>';
                
                $estructura .= '<br><br><table style="width:100%; margin-left:50%; float:right; border-collapse: separate;">
                                <tr>
                                    <td colspan="4" style="border:none;" ></td> 
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">Materia Prima</td>
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">$'.number_format(round($costo_total_mp, 4),4).'</td>
                                </tr>
                                <tr>
                                    <td colspan="4" style="border:none;" ></td> 
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">Mano de Obra</td>
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">$'.number_format(round($costo_total_mo, 4),4).'</td>
                                </tr>
                                <tr>
                                    <td colspan="4" style="border:none;" ></td> 
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">Total</td>
                                    <td style="border: 1px solid black; text-align:right; font-weight:bold; font-size: 13px;">$'.number_format(round($costo_total_mp+$costo_total_mo, 4),4).'</td>
                                </tr></table>';
                                
                

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("ficha_tecnica.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        
        function reporteOrdenFabrica($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Fabricación');
                $pdf->SetSubject('Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                
                $info = $this->fabrica_model->getDatosOrden($trannum);
                $productos = $this->fabrica_model->getDataFab_100p($trannum);
                
                $function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                foreach($info as $in){
                    
                    $header = '<table style="width:100%;">
                                <tr>
                                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td style="width:70%;font-size:22px; text-align:right;"><br>ORDEN DE FABRICACIÓN<br>'.$in->centername.'</td>
                                </tr>
                            </table>';
                    
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    $header .= '<br><table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;"><strong>Proveedor:</strong></td>
                            <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:45%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                        </tr>
                        </table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">Fecha</td>
                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->solicita.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">N° de orden</td>
                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E; color:#0B486B;">'.$in->trannum.'</td>
                        </tr>
                    </table>';
                }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                $total_mp=0;                            
                $total_mo=0;                            
                
                $pdf->addPage('P', 'LETTER');
                
                $estructura='';
                foreach($productos as $pro){
                    
                    if($pro->imagen != ""){
						$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}
					}else{
						$srcImagen = base_url()."img/sinImagen.png";
					}
                    
                    $estructura .= '<br><br><table style="width:100%;">
                        <tr>
                            <td style="color:gray; font-size:10px; text-align:center;width:10%;">Cant.</td>
                            <td style="color:gray; font-size:10px; text-align:left; width:90%;">Descripción</td>
                        </tr>
                        <tr>
                            <td style="color:#0B486B; font-size:12px; text-align:center; font-weight:bold;width:10%;">'.round($pro->cantidad).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; width:90%;font-weight:bold;">'.$pro->idproducto.' - '.strtoupper($pro->descrip).'</td>
                        </tr>';
                    $sum_mp=0;
                    $sum_mo=0;
                    
                    $estructura_interna="";
                    
                    $materiales = $this->fabrica_model->verFichasMateriales($pro->idproducto);
                    if($materiales!="" && $materiales!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Materia Prima</td>
                        </tr>';
                        foreach($materiales as $mat){
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->id.'</td>
                                <td style="font-size:10px; text-align:left; width:70%;">'.$mat->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$mat->cantidad).'</td>
                            </tr>';
                            //$sum_mp +=number_format(round($mat->subtotal * $pro->cantidad, 4),4);
                           // $total_mp +=$sum_mp; 
                        }
                    }
                    
                    
                    $m_obra = $this->fabrica_model->verFichasObras($pro->idproducto);
                    if($m_obra!="" && $m_obra!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Mano de Obra</td>
                        </tr>';
                        foreach($m_obra as $m_ob){
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$m_ob->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$m_ob->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round($m_ob->subtotal, 4),4).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round(($m_ob->subtotal * $pro->cantidad), 4),4).'</td>
                            </tr>';
                            $sum_mo +=number_format(round($m_ob->subtotal * $pro->cantidad, 4),4);
                        }
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; width:100%;text-align:right;font-weight:bold;border-top:0.5px solid #999;">Subtotal Mano de Obra $'.number_format(round($sum_mo, 4),4).' </td>
                        </tr>';
                        $total_mo +=$sum_mo; 
                    }
                    $estructura .= '
                        <tr>
                        <td style="color:#0B486B; font-size:12px; text-align:center; font-weight:bold;width:20%;"><img style="width:125px;height:125px;" src="'.$srcImagen.'"></td>
                        <td style="width:80%;">
                            <table>
                                '.$estructura_interna.'
                            </table>
                        </td>
                    </tr>';
                    
                    $estructura .= ' </table>';
                    $estructura .='<table><tr><td rowspan="3" style="font-size:12px; text-align:left;width:100%;border:0.5px solid #999;padding:2px;"><b> Notas: </b>'.$pro->notas.'</td></tr><tr><td></td></tr><tr><td></td></tr></table>';
          
                }
                $estructura .= '<br><br>
                        <table>
                            <tr>
                            <td style="font-size:14px; text-align:right; font-weight:bold;width:85%;"><br>Total Mano de Obra </td>
                            <td style="font-size:14px; text-align:right; font-weight:bold;width:15%;border-top:1px solid black;"><br>$ '.number_format(round($total_mo, 4),4).'</td>
                            </tr>
                        </table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        } 
        
        function reporteFabricacion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Fabricación');
                $pdf->SetSubject('Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                
                $info = $this->fabrica_model->getDatosOrden($trannum);
                $productos = $this->fabrica_model->getDataFab_100p($trannum);
                
                $function = $this->uri->segment(3);
                //$nombre_doc = $this->global_model->getFormatosNombre($function);
                $nombre_doc="";
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                foreach($info as $in){
                    
                    switch($in->estatus){
                        case 0:
                            $estado_orden="En Elaboración";
                            break;
                        case 1: 
                            $estado_orden="En Proceso";
                            break;
                        case 2:
                            $estado_orden="Recibido";
                            break;
                        case 9:
                            $estado_orden="Anulado";
                            break;
                        default:
                            $estado_orden="-";
                            break;
                            
                    }
                    
                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>ORDEN DE FABRICACIÓN<br><span style="font-size:14px; text-align:right;">Estado: '.$estado_orden.'</span></td>
                        </tr>
                    </table>';
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    if($in->fecact!="0000-00-00"){
                        $date_cierre = date_format(date_create($in->fecact),'d/m/Y');
                    }else{
                        $date_cierre = "-";
                    }
                    
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Proveedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">N° de orden&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$in->trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Solicitado por&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->solicita.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date.'</td>
                            
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Bodega de Ingreso&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->centername.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date_cierre.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:70%;border: 0.3px solid #6E6E6E;" colspan="3"></td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Cantidad&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.round($in->cant).'</td>
                        </tr>
                    </table>';
                }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                $total_mp=0;                            
                $total_mo=0;                            
                
                $pdf->addPage('P', 'LETTER');
                
                $estructura='';
                foreach($productos as $pro){
                    
                    if($pro->imagen != ""){
						//$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}
					}else{
						$srcImagen = base_url()."img/sinImagen.png";
					}
                    
                    $estructura .= '<br><br><table style="width:100%;">';
                    $sum_mp=0;
                    $sum_mo=0;
                    
                    $estructura_interna='<tr>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Código</td>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Cantidad</td>
                            <td style="color:gray; font-size:10px; text-align:left; width:80%;">Descripción</td>
                        </tr>
                        <tr> 
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->idproducto).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->cantidad).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; width:80%;font-weight:bold;">'.strtoupper($pro->descrip).'</td>
                        </tr>';
                    
                    $materiales = $this->fabrica_model->verFichasMateriales($pro->idproducto);
                    if($materiales!="" && $materiales!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Materia Prima</td>
                        </tr>';
                        foreach($materiales as $mat){
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$mat->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$mat->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                            </tr>';
                        }
                    }
                    
                    $m_obra = $this->fabrica_model->verFichasObras($pro->idproducto);
                    if($m_obra!="" && $m_obra!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Mano de Obra</td>
                        </tr>';
                        foreach($m_obra as $m_ob){
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$m_ob->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$m_ob->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round($m_ob->subtotal, 4),4).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round(($m_ob->subtotal * $pro->cantidad), 4),4).'</td>
                            </tr>';
                            $sum_mo +=number_format(round($m_ob->subtotal * $pro->cantidad, 4),4);
                        }
                        $estructura_interna .='<tr nobr="true">
                            <td style="font-size:12px; width:90%;text-align:right;font-weight:bold;">Subtotal Mano de Obra</td>
                            <td style="font-size:11px; width:10%;text-align:right;font-weight:bold;border-top:0.3px solid black;">$'.number_format(round($sum_mo, 4),4).' </td>
                        </tr>';
                        $total_mo +=$sum_mo; 
                    }
                    $estructura .= '
                        <tr nobr="true" style="min-height:160px;">
                        <td nobr="true" style="min-height:160px; font-size:12px; text-align:center; font-weight:bold;width:20%;vertical-align:middle;"><br><br><img style="width:125px;height:150px;" src="'.$srcImagen.'"></td>
                        <td style="width:80%;min-height:160px;">
                            <table nobr="true">
                                '.$estructura_interna.'
                                <tr><td rowspan="3" style="font-size:12px; text-align:left;width:100%;border:0.2px solid #999;padding:2px;"><b> Notas: </b>'.$pro->notas.'</td></tr><tr><td></td></tr><tr><td></td></tr>
                            </table>
                        </td>
                    </tr>';
                    
                    $estructura .= '</table><br>';
                }
                $estructura .= '<br><br>
                        <table>
                            <tr>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:85%;"><br>Total Mano de Obra </td>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:5%;"><br>$</td>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:10%;border-top:1px solid black;"><br> '.number_format(round($total_mo, 4),4).'</td>
                            </tr>
                        </table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function materialesFab($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Materiales Orden de Fabricación');
                $pdf->SetSubject('Materiales Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 45, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('invtran_model');
                
                $info = $this->fabrica_model->getDatosOrden($trannum);
                     
                $productos = $this->fabrica_model->cantMaterialesOrden($trannum);

                $function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                foreach($info as $in){
                    
                    $header = '<table style="width:100%;">
                                <tr>
                                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td style="width:70%;font-size:22px; text-align:right;"><br>'.$nombre_doc.'<br>'.$in->centername.'</td>
                                </tr>
                            </table>';
                    
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    $header .= '<br><table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;"><strong>Proveedor:</strong></td>
                            <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:45%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                        </tr>
                        </table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">Fecha</td>
                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->solicita.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">N° de orden</td>
                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E; color:#0B486B;">'.$in->trannum.'</td>
                        </tr>
                    </table>';
                }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
               

                $total_mp=0;                            
                $total_mo=0;                            
                
                
                $pdf->addPage('P', 'LETTER');
                
                $par =false;
                
                $estructura='<table style="width:100%; ">
                <thead>
                    <tr style="border:1px solid black;background-color:gray; color:white;">
                        <th style="font-size:12px; text-align:center;width:10%;">Código</th>
                        <th style="font-size:12px; text-align:left; width:50%;">Descripción</th>
                        <th style="font-size:12px; text-align:center; width:10%;">U/M</th>
                        <th style="font-size:12px; text-align:center; width:10%;">Existencia Actual</th>
                        <th style="font-size:12px; text-align:center; width:10%;">Cantidad Requerida</th>
                        <th style="font-size:12px; text-align:center; width:10%;">A comprar</th>
                    </tr></thead><tbody>';
                foreach($productos as $pro){
                    $actual = $this->invtran_model->getDataStockProducto($pro->idproducto,7);
                    $cant_actual =0;
                    if($actual!=false){
                        foreach($actual as $act){
                            $cant_actual= $act->cantidad;
                        }
                    }
                    
                    $cant_necesaria = $cant_actual-$pro->suma;
                    if($cant_necesaria<=0){
                        $cant_necesaria=round($cant_necesaria*-1);
                    }else{
                        $cant_necesaria='';
                    }
                    
                    if($par==false){
                        $par=true;
                        $estructura .= '
                            <tr nobr="true">
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center;width:10%;">'.$pro->idproducto.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:left; width:50%;">'.$pro->product.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.$pro->um.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.round($cant_actual).'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.round($pro->suma).'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.$cant_necesaria.'</td>
                            </tr>';
                    }else{
                        $par=false;
                        $estructura .= '
                            <tr nobr="true">
                                <td style="font-size:12px; text-align:center;width:10%;">'.$pro->idproducto.'</td>
                                <td style="font-size:12px; text-align:left; width:50%;">'.$pro->product.'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.$pro->um.'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.round($cant_actual).'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.round($pro->suma).'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.$cant_necesaria.'</td>
                            </tr>';
                    }
                    
                }
                $estructura.='</tbody></table>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function listado_productos($tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                ini_set('memory_limit','1032M');
                ini_set('max_allowed_packet', '1032M'); 
                $objPHPExcel = new PHPExcel();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                    ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                    ->setTitle("Listado de Productos") // Titulo
                    ->setSubject("Listado de Productos") //Asunto
                    ->setDescription("Listado de Productos") //Descripción
                    ->setKeywords("Listado de Productos") //Etiquetas
                    ->setCategory("Listado de Productos"); //Categorias
                $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
                $objPHPExcel->setActiveSheetIndex(0);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);;
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);


                $this->load->model("producto_model");
                $productos = $this->producto_model->getProductos_Tipo($tipo);
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 2; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Imagen')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Codigo')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Descripción')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Unidad de Medida')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Costo Unitario')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Linea')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                
                foreach($productos as $pro){
                    $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                    $indiceNumero++; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                    if($pro->imagen != ""){
                        $gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
                            $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(75);
                            $objDrawing = new PHPExcel_Worksheet_Drawing();
                            $objDrawing->setName($pro->descrip);
                            $objDrawing->setDescription($pro->descrip);
                            $logo = $gdImage; // Provide path to your logo file
                            $objDrawing->setPath($logo);  //setOffsetY has no effect
                            $objDrawing->setCoordinates($celdas[$indiceLetra].$indiceNumero);
                            $objDrawing->setHeight(75);
                            $objDrawing->setWidth(75);
                            $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                            $indiceLetra++;

                        }else{
                            $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(75);
                            $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, "");
                            $indiceLetra++;
                        }
                    }else{
                        $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(75);
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, "");
                        $indiceLetra++;
                    }
                        
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $pro->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $pro->descrip);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $pro->um);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $pro->costounitario);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $pro->linea);
                    $indiceLetra++;
                    
                }
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="ListadoProductos.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                $objWriter->save('php://output');
                exit;
            }
        }

        function book01($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<br><br><br><table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:21%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Tipo de Operación</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Del Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Al Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:50%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">No Sujetas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Exentas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Gravadas Locales</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:10.5px;">Exportaciones</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Totales</th>
                </tr></thead>
                <tbody></tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    $exento=0;
                    $gravado=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan+$vn->valtax1;
                    }
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_total+= $exento+$gravado;
                    $dia = date_format(date_create($vn->fecha),'d');

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$dia.'</td>
                        <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($vn->tipodoc).'</td>
                        <td style="width:12%;text-align:right; font-size:9px;">'.$vn->primero.'</td>
                        <td style="width:12%;text-align:right; font-size:9px;">'.$vn->ultimo.'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento+$gravado, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;"></td>
                        <td style="width:21%;text-align:left; font-size:9px;"></td>
                        <td style="width:12%;text-align:center; font-size:9px;"></td>
                        <td style="width:12%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="9"><br><br><br></td></tr>';
                
                 $estructura.='<tr>
                    <td colspan="3" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>
                    <td colspan="6"></td>
                 </tr>';
                
                $estructura.='</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book02($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                    <tr><td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('descrip').'</td><td colspan="2" style="text-align:right;font-size:14px;width:60%;">N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label></td></tr>
                    
                    
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Lanscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<br><br><table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:32%; font-weight:bold; text-align:center; font-size:12px;" colspan="4">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $ventas = $this->iva_model->getVentas($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan+$vn->valtax1;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    $sum_total+= $exento+$gravado;

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento+$gravado, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                 $estructura.='<tr>
                    <td colspan="3" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>
                    <td colspan="6"></td>
                 </tr>';
                
                $estructura.='</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book01t($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<br><br><br><table style="border-collapse: separate;border-spacing: 10px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $sum_ivae=0;
                $sum_ivag=0;
                $sum_dev_exento =0;
                $sum_dev_gravado =0;
                $ventas = $this->iva_model->getVentasReporteT($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    if($vn->exento==1){
                        if($vn->inopera==-1){
                            $sum_exento+=$vn->valventan;
                            $sum_ivae+=$vn->valtax1;
                        }else{
                            $sum_dev_exento+=$vn->valventan;
                        }
                    }else{
                        if($vn->inopera==-1){
                            $sum_gravado+=$vn->valventan;
                            $sum_ivag+=$vn->valtax1;
                        }else{
                            $sum_dev_gravado+=$vn->valventan;
                        }
                        
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado+$sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento+$sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.='<hr style="width:100%;"><br><hr style="width:100%;">';
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_ivag+$sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento+$sum_ivag+$sum_ivae, 2),2).'</td>
                </tr>';
                
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        } 
        
        function book02t($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Contribuyentes');
                $pdf->SetSubject('Libro de Ventas Contribuyentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                $pdf->setPrintHeader(false);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Landscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<br><br><br><table style="border-collapse: separate;border-spacing: 10px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>';
                
                $ventas = $this->iva_model->getVentasReporteCT($fechaini, $fechafin, $idcentro, $formatos);
                
                $cf_sum_exento=0;
                $cf_sum_gravado=0;
                $cf_sum_total=0;
                $cf_sum_ivae=0;
                $cf_sum_ivag=0;
                $cf_sum_dev_g=0;
                $cf_sum_dev_e=0;
                
                $c_sum_exento=0;
                $c_sum_gravado=0;
                $c_sum_total=0;
                $c_sum_ivae=0;
                $c_sum_ivag=0;
                $c_sum_dev_g=0;
                $c_sum_dev_e=0;
                
                foreach($ventas as $vn){
                    if($vn->ivabook==1){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $cf_sum_exento+=$vn->valventan;
                                $cf_sum_ivae+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            if($vn->inopera==-1){
                                $cf_sum_gravado+=$vn->valventan;
                                $cf_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }else if($vn->ivabook==2){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $c_sum_exento+=$vn->valventan;
                                $c_sum_ivae+=$vn->valtax1;
                            }else{
                                $c_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            
                            if($vn->inopera==-1){
                                $c_sum_gravado+=$vn->valventan;
                                $c_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$c_sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>';
                
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g+$cf_sum_ivag, 2),2).'</td>


                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
               $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>';
                
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($cf_sum_dev_g+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento-$cf_sum_dev_g-$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$cf_sum_gravado+$c_sum_exento+$cf_sum_exento+$cf_sum_dev_g+$cf_sum_dev_e+$c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function print_etiquetas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Etiquetas');
                $pdf->SetSubject('Etiquetas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 16, 0);
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
                $cant = 0;
                
				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $productos = $this->compras_model->getProductosCompraOrderByName($trannum);
                $cantidades  = $this->session->userdata('cantidades'); 
                $cant_selected = explode(",", $cantidades,-1);  
                $estructura = '<table style="width:100%;">';
                $num_rows=0;
                $alto = 10.5;
                foreach($productos as $pro){
                    $actual=0;
                    foreach($cant_selected as $cl){
                        $datos_pro = explode("*", $cl);
                        if($datos_pro[0]==$pro->idproducto){
                            if($datos_pro[1]>0){
                                $cant_etiquetas=$datos_pro[1];
                                $cant_et=0;
                                do{
                                    $cant_et++;
                                    if($cant==0){
                                        if($num_rows==20){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;margin:0px;width:25%;">
                                            <table style="padding:0px;margin:0px;">
                                            <tr>
                                            <td style="width:50%;padding:0px;margin:0px;">
                                            <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                            </td>
                                            <td style="width:50%;padding:0px;margin:0px;">
                                            <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                            <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                            </td>
                                            </tr>
                                            </table>
                                            </td>';
                                            $num_rows=0;
                                        }else{
                                            if($num_rows>10){
                                                $alto=9.7;
                                            }else{
                                                $alto=10.5;
                                            }
                                            
                                            if($num_rows==0){
                                                $estructura .= '
                                                <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                </td>
                                                </tr>
                                                </table>
                                                </td>';
                                            }else{
                                                $estructura .= '
                                                <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                                <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                </td>
                                                </tr>
                                                </table>
                                                </td>';
                                            }
                                            
                                        }
                                        $cant++;
                                    }else if($cant==1){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td>';
                                        $cant++;
                                    }else if($cant==2){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td>';
                                        $cant++;
                                    }else if($cant==3){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;padding:0px;">&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td></tr>';
                                        $cant=0;
                                        $num_rows++;
                                    }
                                    $actual++;
                                }while($cant_etiquetas!=$cant_et);    
                            }        
                        }
                    }
                }    
                if($cant!=0){
                    while($cant<=3){
                        $estructura .= '<td style="text-align:left;width:25%;"></td>';
                        $cant++;
                    }
                    $estructura .= '</tr>';
                }
                $estructura .= '</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Etiquetas.pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            }
        }
        
        function print_etiquetas_all($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Etiquetas');
                $pdf->SetSubject('Etiquetas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 16, 0);
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
                $cant = 0;
                
				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $productos = $this->compras_model->getProductosCompra($trannum);
                $marcas = $this->compras_model->getMarcasCompra($trannum);
                
                $estructura = '<table style="width:100%;">';
                $num_rows=0;
                $alto = 10.5;
                foreach($marcas as $mar){
                    $primera = true;
                    foreach($productos as $pro){
                        
                        if($mar->marca==$pro->marca){
                            $actual=0;
                            $cant_etiquetas= $pro->cantidad;
                            if($primera == true){
                                $primera=false;
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }
                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                            </td>';
                                        }
                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                        <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Inicio<br> '.trim($mar->descrip).'</label>
                                    </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                            }
                            
                            do{
                                if($cant==0){
                                    if($num_rows==20){
                                        $estructura .= '
                                        <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;margin:0px;width:25%;">
                                            <table style="padding:0px;margin:0px;">
                                            <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                    <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                    <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                </td>
                                            </tr>
                                            </table>
                                        </td>';
                                        $num_rows=0;
                                    }else{
                                        if($num_rows>10){
                                            $alto=9.7;
                                        }else{
                                            $alto=10.5;
                                        }
                                        
                                        if($num_rows==0){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }else{
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                        }
                                        
                                    }
                                    $cant++;
                                }else if($cant==1){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==2){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>';
                                    $cant++;
                                }else if($cant==3){
                                    $estructura .= '
                                    <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                    </td>
                                                    <td style="width:50%;padding:0px;margin:0px;">
                                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">&nbsp;&nbsp;&nbsp;&nbsp;'.$pro->idproducto.'</label>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td></tr>';
                                    $cant=0;
                                    $num_rows++;
                                }
                                $actual++;
                            }while($cant_etiquetas!=$actual);
                        }
                    }    
                    
                    if($cant==0){
                        if($num_rows==20){
                            $estructura .= '
                            <tr style="padding:0px;margin:0px;" nobr="true">
                            <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                            </td>';
                            $num_rows=0;
                        }else{
                            if($num_rows>10){
                                $alto=9.7;
                            }else{
                                $alto=10.5;
                            }
                            if($num_rows==0){
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }else{
                                $estructura .= '
                                <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                <tr style="padding:0px;margin:0px;" nobr="true">
                                <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                                    <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                                </td>';
                            }
                        }
                        $cant++;
                    }else if($cant==1){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==2){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td>';
                        $cant++;
                    }else if($cant==3){
                        $estructura .= '
                        <td style="padding:0px;vertical-align:middle;text-align:center;width:25%;">
                            <label style="text-align:center;font-size:10px;float:center; font-weight:bold;">Fin<br> '.trim($mar->descrip).'</label>
                        </td></tr>';
                        $cant=0;
                        $num_rows++;
                    }
                }
                
                if($cant!=0){
                    while($cant<=3){
                        $estructura .= '<td style="text-align:left;width:25%;"></td>';
                        $cant++;
                    }
                    $estructura .= '</tr>';
                }
                
                $estructura .= '</table>';
                //echo $estructura;
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //$pdf->writeHTMLCell(0, 0, '', '', $estructura, 0, 1, 0, true, '', true);
                
                $nombre_archivo = utf8_decode("Etiquetas.pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            }
        }
        
        function ordenFab($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Fabricación');
                $pdf->SetSubject('Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('compras_model');
                $info = $this->compras_model->detalleOrdenCompra($trannum);
                $function = $this->uri->segment(3);
                //$nombre_doc = $this->global_model->getFormatosNombre($function);
                $nombre_doc="";
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                
                foreach($info as $in){
                    
                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>ORDEN DE FABRICACIÓN<br><span style="font-size:14px; text-align:right;">Estado: '.$in->estado.'</span></td>
                        </tr>
                    </table>';
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    if($in->dev_date!="0000-00-00"){
                        $date_cierre = date_format(date_create($in->dev_date),'d/m/Y');
                    }else{
                        $date_cierre = "-";
                    }
                    
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Proveedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">N° de orden&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$in->trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Solicitado por&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->workername.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date.'</td>
                            
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Bodega de Ingreso&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->lugar_entrega.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date_cierre.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:70%;border: 0.3px solid #6E6E6E;" colspan="3"></td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Cantidad&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;</td>
                        </tr>
                    </table>';
                    $productos = $this->compras_model->getDatosOrden100k($trannum, $in->dev_place);
            
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                $total_mp=0;                            
                $total_mo=0;                            
                
                $pdf->addPage('P', 'LETTER');
                
                $estructura='';
                foreach($productos as $pro){
                    
                    if($pro->imagen != ""){
						//$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}
					}else{
						$srcImagen = base_url()."img/sinImagen.png";
					}
                    
                    $estructura .= '<br><br><table style="width:100%;">';
                    $sum_mp=0;
                    $sum_mo=0;
                    
                    $estructura_interna='<tr>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Código</td>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Cantidad</td>
                            <td style="color:gray; font-size:10px; text-align:left; width:80%;">Descripción</td>
                        </tr>
                        <tr> 
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->idproducto).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->cantidad).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; width:80%;font-weight:bold;">'.strtoupper($pro->descrip).'</td>
                        </tr>';
                    $cant_ficha=0;
                    $materiales = $this->fabrica_model->verFichasMateriales($pro->idproducto);
                    if($materiales!="" && $materiales!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Materia Prima</td>
                        </tr>';
                        foreach($materiales as $mat){
                            $cant_ficha++;
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$mat->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$mat->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                            </tr>';
                        }
                    }
                    
                    $m_obra = $this->fabrica_model->verFichasObras($pro->idproducto);
                    if($m_obra!="" && $m_obra!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Mano de Obra</td>
                        </tr>';
                        foreach($m_obra as $m_ob){
                            $cant_ficha++;
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$m_ob->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$m_ob->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round($m_ob->subtotal, 4),4).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round(($m_ob->subtotal * $pro->cantidad), 4),4).'</td>
                            </tr>';
                            $sum_mo +=number_format(round($m_ob->subtotal * $pro->cantidad, 4),4);
                        }
                        $estructura_interna .='<tr nobr="true">
                            <td style="font-size:12px; width:90%;text-align:right;font-weight:bold;">Subtotal </td>
                            <td style="font-size:11px; width:10%;text-align:right;font-weight:bold;border-top:0.3px solid black;">$'.number_format(round($sum_mo, 4),4).' </td>
                        </tr>';
                        $estructura_interna .='<tr nobr="true">
                            <td style="font-size:12px; width:90%;text-align:right;font-weight:bold;">10% de Renta</td>
                            <td style="font-size:11px; width:10%;text-align:right;font-weight:bold;border-top:0.3px solid black;">$'.number_format(round($sum_mo*0.10,2),4).' </td>
                        </tr>';
                        $estructura_interna .='<tr nobr="true">
                            <td style="font-size:12px; width:90%;text-align:right;font-weight:bold;">Subtotal Mano de Obra</td>
                            <td style="font-size:11px; width:10%;text-align:right;font-weight:bold;border-top:0.3px solid black;">$'.number_format(round($sum_mo-round($sum_mo*0.10,2), 4),4).' </td>
                        </tr>';
                        $total_mo +=$sum_mo; 
                    }
                    if($cant_ficha==0){
                        $estructura_interna.='<tr nobr="true">
                            <td style="font-size:13px; width:100%;text-align:center;font-weight:bold;">Producto no tiene ficha técnica asignada!</td>
                        </tr>';
                    }
                    
                    $estructura .= '
                        <tr style="min-height:180px;">
                        <td nobr="true" style="min-height:180px; font-size:12px; text-align:center; font-weight:bold;width:20%;vertical-align:middle;"><br><br><img style="width:125px;height:180px;" src="'.$srcImagen.'"></td>
                        <td nobr="true" style="width:80%;min-height:180px;">
                            <table nobr="true">
                                '.$estructura_interna.'
                                <tr><td rowspan="3" style="font-size:12px; text-align:left;width:100%;border:0.2px solid #999;padding:2px;"><b> Notas: </b>'.$pro->modNotas.'</td></tr><tr><td></td></tr><tr><td></td></tr>
                            </table>
                        </td>
                    </tr>';
                    
                    $estructura .= '</table><br>';
                }
                
                $renta = $total_mo*0.10;
                
                $estructura .= '<br><br>
                        <table>
                            <tr>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:85%;"><br>Subtotal</td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:5%;"><br>$</td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:10%;"><br> '.number_format(round($total_mo, 4),4).'</td>
                            </tr>
                            <tr>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:85%;"><br>10% Renta </td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:5%;"><br>$</td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:10%;"><br> -'.number_format(round($renta, 4),4).'</td>
                            </tr>
                            <tr>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:85%;"><br>Total Mano de Obra </td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:5%;"><br>$</td>
                                <td style="font-size:12px; text-align:right; font-weight:bold;width:10%;border-top:1px solid black;"><br> '.number_format(round($total_mo-$renta, 4),4).'</td>
                            </tr>
                        </table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function materialFab($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit','1032M');
                ini_set('max_allowed_packet', '1032M'); 

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Materiales Orden de Fabricación');
                $pdf->SetSubject('Materiales Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 45, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('invtran_model');
                
                $this->load->model('compras_model');
                $info = $this->compras_model->detalleOrdenCompra($trannum);
                
				$function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                foreach($info as $in){
                    
                    $header = '<table style="width:100%;">
                                <tr>
                                    <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td style="width:70%;font-size:22px; text-align:right;"><br>'.$nombre_doc.'<br>'.$in->lugar_entrega.'</td>
                                </tr>
                            </table>';
                    
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    $header .= '<br><table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;"><strong>Proveedor:</strong></td>
                            <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:45%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                        </tr>
                        </table>';
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">Fecha</td>
                            <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:55%;">'.$in->workername.'</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:20%; border: 1px solid #6E6E6E;">N° de orden</td>
                            <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E; color:#0B486B;">'.$in->trannum.'</td>
                        </tr>
                    </table>';
                    $productos = $this->fabrica_model->cantMaterialesOrdenConsolidado($trannum, $in->dev_place);
                }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
               

                $total_mp=0;                            
                $total_mo=0;                            
                
                
                $pdf->addPage('P', 'LETTER');
                
                $par =false;
                
                $estructura='<table style="width:100%; ">
                <thead>
                    <tr style="border:1px solid black;background-color:gray; color:white;">
                        <th style="font-size:12px; text-align:center;width:10%;">Código</th>
                        <th style="font-size:12px; text-align:left; width:50%;">Descripción</th>
                        <th style="font-size:12px; text-align:center; width:10%;">U/M</th>
                        <th style="font-size:12px; text-align:center; width:10%;">Existencia Actual</th>
                        <th style="font-size:12px; text-align:center; width:10%;">Cantidad Requerida</th>
                        <th style="font-size:12px; text-align:center; width:10%;">A comprar</th>
                    </tr></thead><tbody>';
                foreach($productos as $pro){
                    $actual = $this->invtran_model->getDataStockProducto($pro->idproducto,7);
                    $cant_actual =0;
                    if($actual!=false){
                        foreach($actual as $act){
                            $cant_actual= $act->cantidad;
                        }
                    }
                    
                    $cant_necesaria = $cant_actual-$pro->cantidad;
                    if($cant_necesaria<=0){
                        $cant_necesaria=round($cant_necesaria*-1);
                    }else{
                        $cant_necesaria='';
                    }
                    
                    if($par==false){
                        $par=true;
                        $estructura .= '
                            <tr nobr="true">
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center;width:10%;">'.$pro->idproducto.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:left; width:50%;">'.$pro->descrip.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.$pro->um.'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.round($cant_actual).'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.round($pro->cantidad).'</td>
                                <td style="background-color:#D5E8F1;font-size:12px; text-align:center; width:10%;">'.$cant_necesaria.'</td>
                            </tr>';
                    }else{
                        $par=false;
                        $estructura .= '
                            <tr nobr="true">
                                <td style="font-size:12px; text-align:center;width:10%;">'.$pro->idproducto.'</td>
                                <td style="font-size:12px; text-align:left; width:50%;">'.$pro->descrip.'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.$pro->um.'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.round($cant_actual).'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.round($pro->cantidad).'</td>
                                <td style="font-size:12px; text-align:center; width:10%;">'.$cant_necesaria.'</td>
                            </tr>';
                    }
                    
                }
                $estructura.='</tbody></table>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function ordenes_word(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                define('CHARSET','UTF-8');
                header('Content-type: text/html; charset='.CHARSET);
                
                require_once APPPATH.'libraries/PHPWord.php';
                $PHPWord = new PHPWord();
                
                // New portrait section
                $section = $PHPWord->createSection();
                
                $PHPWord->addFontStyle('rStyle', array('bold'=>true, 'italic'=>false, 'size'=>16));
                $PHPWord->addParagraphStyle('pStyle', array('align'=>'center', 'spaceAfter'=>100));
                $texto = "ORDENES DE FABRICACION";
                $section->addText(htmlentities($texto), 'rStyle', 'pStyle');
                
                $grupo = $this->uri->segment(4);
                $fechaini = $this->uri->segment(5);
                $fechafin = $this->uri->segment(6);
                $this->load->model('fabrica_model');
                $info = $this->fabrica_model->getOrdenesList($grupo,$fechaini,$fechafin);
                
                // Define table style arrays
                $styleTable = array('borderSize'=>6, 'borderColor'=>'006699', 'cellMargin'=>80,'size'=>12);
                $styleFirstRow = array('valign'=>'center','bold'=>true,'borderBottomSize'=>18, 'borderBottomColor'=>'black', 'bgColor'=>'66BBFF');

                // Define cell style arrays
                $styleCell = array('valign'=>'center');
                $styleCellBTLR = array('valign'=>'center', 'alignment'=>'center','textAlignment'=>'center');

                $stylecelda1 = array('valign'=>'center','textAlignment'=>'center','alignment'=>'center');

                
                // Add table style
                $PHPWord->addTableStyle('myOwnTableStyle', $styleTable, $styleFirstRow);

                // Add table
                $table = $section->addTable('myOwnTableStyle');


                $table->addRow();
                $table->addCell(3000)->addText("Comunidad");
                $table->addCell(1500)->addText("Fecha");
                $table->addCell(1000)->addText("Num. de Orden");
                $table->addCell(1000)->addText("Valor Mano de Obra");
                $table->addCell(3000)->addText("Producto");
                $total =0;
                foreach($info as $in){
                    $productos = $this->fabrica_model->getDataFab_100p($in->trannum);
                    foreach($productos as $prod){
                        $sum_mo=0;
                        $m_obra = $this->fabrica_model->verFichasObras($prod->idproducto);
                        foreach($m_obra as $m_ob){
                             $sum_mo +=number_format(round($m_ob->subtotal * $prod->cantidad, 4),4);
                        }
                        $total+=$sum_mo;
                        $table->addRow();

                        $table->addCell(3000)->addText($in->centername);
                        $table->addCell(1500)->addText(date_format(date_create($in->fecha), 'd/m/Y'),$stylecelda1);
                        $table->addCell(1000)->addText($in->trannum);
                        $table->addCell(1000)->addText("$".$sum_mo);
                        $table->addCell(3000)->addText($prod->descrip);    
                    }
                }
               
                $objWriter = PHPWord_IOFactory::createWriter($PHPWord, 'Word2007');
                $filename = 'Ordenes.docx';
                $objWriter->save($filename);
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename='.$filename);
                header('Content-Transfer-Encoding: binary');
                header('Expires: 0');
                header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                header('Pragma: public');
                header('Content-Length: ' . filesize($filename));
                flush();
                readfile($filename);
                unlink($filename); // deletes the temporary file
                exit;
                
                
                
            }
        }   
        
        function ordenes_fab(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
                ini_set('memory_limit','1032M');
                ini_set('max_allowed_packet', '1032M'); 
                $objPHPExcel = new PHPExcel();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                    ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                    ->setTitle("Ordenes de Fabricación") // Titulo
                    ->setSubject("Ordenes de Fabricación") //Asunto
                    ->setDescription("Ordenes de Fabricación") //Descripción
                    ->setKeywords("Ordenes de Fabricación") //Etiquetas
                    ->setCategory("Ordenes de Fabricación"); //Categorias
                $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
                $objPHPExcel->setActiveSheetIndex(0);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
                $grupo = $this->uri->segment(4);
                $fechaini = $this->uri->segment(5);
                $fechafin = $this->uri->segment(6);
                $this->load->model('fabrica_model');
                $info = $this->fabrica_model->getOrdenesList($grupo,$fechaini,$fechafin);
                
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 2; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Comunidad')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Fecha')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Num. de Orden')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Valor Mano de Obra')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, 'Producto')->getStyle($celdas[$indiceLetra].$indiceNumero)->getFont()->setBold(true);;
                $indiceLetra++;
                foreach($info as $in){
                    $productos = $this->fabrica_model->getDataFab_100p($in->trannum);
                    foreach($productos as $prod){
                        $sum_mo=0;
                        $m_obra = $this->fabrica_model->verFichasObras($prod->idproducto);
                        foreach($m_obra as $m_ob){
                             $sum_mo +=number_format(round($m_ob->subtotal * $prod->cantidad, 4),4);
                        }
                        $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                        $indiceNumero++; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $in->centername);
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, date_format(date_create($in->fecha), 'd/m/Y'));
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $in->trannum);
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, number_format($sum_mo, 2, '.', ''));
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero, $prod->descrip);
                        $indiceLetra++;
                    }
                }
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="OrdenesFabricacion.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                $objWriter->save('php://output');
                exit;
            }
        }
        
        function ordenFabPArtes($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Fabricación');
                $pdf->SetSubject('Orden de Fabricación');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, 5 );
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT, 50);
                $this->load->model('pedclientes_model');
                $this->load->model("global_model");
                $this->load->model('producto_model');
                $this->load->model('fabrica_model');
                $this->load->model('compras_model');
                $info = $this->compras_model->detalleOrdenCompra($trannum);
                $function = $this->uri->segment(3);
                //$nombre_doc = $this->global_model->getFormatosNombre($function);
                $nombre_doc="";
                
                $name = $this->pedclientes_model->getnameImg();
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                
                foreach($info as $in){
                    
                    $header = '<table style="width:100%;">
                        <tr>
                            <td style="width:30%;"><img style="height:80px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                            <td style="width:70%;font-size:22px; text-align:right;"><br><br>ORDEN DE FABRICACIÓN<br><span style="font-size:14px; text-align:right;">Estado: '.$in->estado.'</span></td>
                        </tr>
                    </table>';
                    $date = date_format(date_create($in->fecha),'d/m/Y');
                    if($in->dev_date!="0000-00-00"){
                        $date_cierre = date_format(date_create($in->dev_date),'d/m/Y');
                    }else{
                        $date_cierre = "-";
                    }
                    
                    $header .= '<table style="width:100%;">
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Proveedor&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->proveedor.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">N° de orden&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;color:#0B486B;">&nbsp;&nbsp;'.$in->trannum.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Solicitado por&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->workername.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date.'</td>
                            
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:right; width:20%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Bodega de Ingreso&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:50%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$in->lugar_entrega.'</td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Fecha de Entrega&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;'.$date_cierre.'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:70%;border: 0.3px solid #6E6E6E;" colspan="3"></td>
                            <td style="font-size:12px; text-align:right; width:17.5%; border: 0.3px solid #6E6E6E; background-color:#E8E8E8;">Cantidad&nbsp;&nbsp;</td>
                            <td style="font-size:12px; text-align:left; font-weight: bold; width:12.5%; border: 0.3px solid #6E6E6E;">&nbsp;&nbsp;</td>
                        </tr>
                    </table>';
                    $productos = $this->compras_model->getDatosOrden100k($trannum, $in->dev_place);
            
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintFooter(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                $total_mp=0;                            
                $total_mo=0;                            
                
                $pdf->addPage('P', 'LETTER');
                $cant = 0;
                $estructura='';
                foreach($productos as $pro){
                    $cant++;
                    if($cant>40){
                        
                    
                    
                    if($pro->imagen != ""){
						//$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
                        if(file_exists($gdImage)){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}
					}else{
						$srcImagen = base_url()."img/sinImagen.png";
					}
                    
                    $estructura .= '<br><br><table style="width:100%;">';
                    $sum_mp=0;
                    $sum_mo=0;
                    
                    $estructura_interna='<tr>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Código</td>
                            <td style="color:gray; font-size:10px; text-align:left;width:10%;">Cantidad</td>
                            <td style="color:gray; font-size:10px; text-align:left; width:80%;">Descripción</td>
                        </tr>
                        <tr> 
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->idproducto).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; font-weight:bold;width:10%;">'.round($pro->cantidad).'</td>
                            <td style="color:#0B486B; font-size:12px; text-align:left; width:80%;font-weight:bold;">'.strtoupper($pro->descrip).'</td>
                        </tr>';
                    $cant_ficha=0;
                    $materiales = $this->fabrica_model->verFichasMateriales($pro->idproducto);
                    if($materiales!="" && $materiales!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Materia Prima</td>
                        </tr>';
                        foreach($materiales as $mat){
                            $cant_ficha++;
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$mat->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$mat->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$mat->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                                <td style="font-size:10px; text-align:right; width:10%;"></td>
                            </tr>';
                        }
                    }
                    
                    $m_obra = $this->fabrica_model->verFichasObras($pro->idproducto);
                    if($m_obra!="" && $m_obra!=null ){
                        $estructura_interna .='<tr>
                            <td style="font-size:12px; text-align:left; width:100%;font-weight:bold;">Mano de Obra</td>
                        </tr>';
                        foreach($m_obra as $m_ob){
                            $cant_ficha++;
                            $estructura_interna .= '<tr>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->id.'</td>
                                <td style="font-size:10px; text-align:left; width:50%;">'.$m_ob->titulo.'</td>
                                <td style="font-size:10px; text-align:left; width:10%;">'.$m_ob->unidad.'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">'.round($pro->cantidad*$m_ob->cantidad).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round($m_ob->subtotal, 4),4).'</td>
                                <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(round(($m_ob->subtotal * $pro->cantidad), 4),4).'</td>
                            </tr>';
                            $sum_mo +=number_format(round($m_ob->subtotal * $pro->cantidad, 4),4);
                        }
                        $estructura_interna .='<tr nobr="true">
                            <td style="font-size:12px; width:90%;text-align:right;font-weight:bold;">Subtotal Mano de Obra</td>
                            <td style="font-size:11px; width:10%;text-align:right;font-weight:bold;border-top:0.3px solid black;">$'.number_format(round($sum_mo, 4),4).' </td>
                        </tr>';
                        $total_mo +=$sum_mo; 
                    }
                    if($cant_ficha==0){
                        $estructura_interna.='<tr nobr="true">
                            <td style="font-size:13px; width:100%;text-align:center;font-weight:bold;">Producto no tiene ficha técnica asignada!</td>
                        </tr>';
                    }
                    
                    $estructura .= '
                        <tr nobr="true" style="min-height:160px;">
                        <td nobr="true" style="min-height:160px; font-size:12px; text-align:center; font-weight:bold;width:20%;vertical-align:middle;"><br><br><img style="width:125px;height:150px;" src="'.$srcImagen.'"></td>
                        <td style="width:80%;min-height:160px;">
                            <table nobr="true">
                                '.$estructura_interna.'
                                <tr><td rowspan="3" style="font-size:12px; text-align:left;width:100%;border:0.2px solid #999;padding:2px;"><b> Notas: </b>'.$pro->notas.'</td></tr><tr><td></td></tr><tr><td></td></tr>
                            </table>
                        </td>
                    </tr>';
                    
                    $estructura .= '</table><br>';
                }
                }
                $estructura .= '<br><br>
                        <table>
                            <tr>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:85%;"><br>Total Mano de Obra </td>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:5%;"><br>$</td>
                            <td style="font-size:12px; text-align:right; font-weight:bold;width:10%;border-top:1px solid black;"><br> '.number_format(round($total_mo, 4),4).'</td>
                            </tr>
                        </table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("OrdenFabricacion.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function cuadre_existencias($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('CUADRE DE EXISTENCIAS');
                $pdf->SetSubject('CUADRE DE EXISTENCIAS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporte($trannum);
                
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$center_name.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                <thead>
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Precio</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';
                     
                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;
                
                $sum_invsistema_noinventariado=0;
                $uni_invsistema_noinventariado=0;
                $cantinvsistema_noinventariado=0;
                
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste++;
                        }
                    }     
                }   
                if($cantsinajuste>0){
                    $titulo.=$sinajuste;
                }
                
                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad > 0){
                            $sum_ajusteafavor+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteafavor.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteafavor++;
                        }
                    }
                }   
                if($cantajusteafavor>0){
                    $titulo.=$ajusteafavor;
                }
               
                
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra++;
                        }
                    }
                   
                }   
                if($cantajusteencontra>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                
                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
                
                   
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                    
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra2 = 0;
                $sum_ajusteencontra2 = 0;
                $uni_ajusteencontra2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra2++;
                        }
                    }
                   
                }   
                if($cantajusteencontra2>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                    
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                $cantsinajuste2= 0;
                $sum_sinajuste2 = 0;
                $uni_sinajuste2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->precioventa*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste2++;
                        }
                    }     
                }   
                if($cantsinajuste2>0){
                    $titulo.=$sinajuste;
                }
                
                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;
                
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;
                
                $titulo.='</tbody>
                </table>
                <table>
                    <tr><td colspan="4"><br><br><br></td></tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:40%;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;width:30%;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:11px;width:10%;">Precio</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Productos</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Sistema</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">$'.number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$uni_invsistema.'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteencontra.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteencontra2.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_ajusteafavor.'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteafavor.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">$'.number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:center; font-weight:bold;width:10%;">'.($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor).'</td>
                        <td style="text-align:center; font-weight:bold;width:10%;"></td>
                    </tr>
                    <tr><td colspan="5"><br></td></tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_sinajuste2.'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste2.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$uni_sinajuste.'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste.'</td>
                    </tr>
                    </table>
                ';
                
                    
                $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("CuadreExistencias.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
    }

?>