<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
		}
        
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
			$info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
            return $info;
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $name = $this->variable_model->getIconCuenta();
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
				$pdf->writeHTML($titulo, true, false, true, false, '');
                    
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
            
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 55, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('variable_model');
                $name = $this->variable_model->getIconCuenta();
				
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                   $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
				
				$pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteDetallePro($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->AddPage();
                
                $this->load->model('pjc_model');
                
                $tipo = $this->pjc_model->getTipopjc($trannum);
                $tiposd = $this->pjc_model->getTiposd();
                $informacion = $this->pjc_model->getDetalleProyecto($trannum);
                $datospro = $this->pjc_model->datosDetalle($trannum);
                
                foreach($informacion as $data){
					foreach($tipo as $tip){
						$date_vence = date_format(date_create($data->fecvence),'d/m/Y');
                    
						$titul = '<center><table style="width:100%; text-align:center;" >
									<tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                  		<td style="font-size:12px; text-align;center;"><label><strong>'.strtr(strtoupper($tip->estado),"àèìòùáéíóúçñäëïöü","ÀÈÌÒÙÁÉÍÓÚÇÑÄËÏÖÜ").'</strong></label></td>
                                    </tr>
                                </table></center>';
					}
                    
					$titul .= '
					<div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;">
						<br>
						<label style="font-size:15px;" ><strong> N°'.$data->trannum.'</strong></label>
					</div>
					<table style="border: solid 1px black;">
						<tbody>
							<tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Cliente:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Fecha Estimada de Instalación:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->cliente).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.$date_vence.'</td>
							</tr>
							<tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proyecto:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Diseñador:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->proyecto).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->dise).'</td>
							</tr>
                            <tr>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Dirección:</td>
								<td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%"  >Observaciones:</td>
							</tr>
							<tr>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->direccion).'</td>
								<td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->notas).'</td>
							</tr>
						</tbody>
					</table><br><br>';
                }
				
				$titulo =' <table> ';
                foreach($tiposd as $tipd){
                	$titulo2 ='
                    <table>
                    	<tr>
                       		<td style="background-color:#E8E8E8; text-align:left; font-size:12px; " colspan="3"><strong>'.$tipd->descripcion.'</strong></td>
                    	</tr>
					</table>';   
					
					$cant=0;
					foreach($datospro as $pro){
                     	$imagend= base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/".$pro->archivo; 
						$titulo2 .='<table  style=" border: solid 1px white; margin-top:30px;">';
						
						if($pro->pjc_tipod == $tipd->idrnum){   
                       		$titulo2 .='
							<tr>
								<td style="margin:10px;" rowspan="3"><img src="'.$imagend.'" width="230px" height="105px"></td>
								<td style="font-size:12px; text-align:center; " colspan="2"><strong>'.$pro->descrip .'</strong></td>
							</tr>
							<tr>
								<td style="height:80px; font-size:12px;" rowspan="2" colspan="2">'.$pro->notas .'</td>
							</tr>';
                     		
							$cant++;             
                       }
					} 
                	
                    if($cant>0){
						$titulo.=$titulo2;
					}
				}

				$titulo .=' </table> ';
               
				$pdf->writeHTML($titul, true, false, true, false, '');
				$pdf->writeHTML($titulo, true, false, true, false, '');
				$nombre_archivo = utf8_decode("Detalle_Proyecto_".$trannum.".pdf");
				$pdf->Output($nombre_archivo, 'I');
			}
		}
        
		function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, 5);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				
				$pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);


                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'n');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 6:
                        $mes_name = "Julio";
                        break;
                    case 6:
                        $mes_name = "Agosto";
                        break;
                    case 6:
                        $mes_name = "Septiembre";
                        break;
                    case 6:
                        $mes_name = "Octubre";
                        break;
                    case 6:
                        $mes_name = "Noviembre";
                        break;
                    case 6:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name.", ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        $subtotal = $key->cantidad * $key->precioneto; 
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }

                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $subtotal = $key->cantidad * $key->precioneto; 
                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Proveedor</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Cliente</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px;"><br>Es indispensable presentar esta orden de compra al entregar el producto en nuestra bodega.<br><br></td>
                                    </tr>
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR PAGAR A PROVEEDORES</label></center>';
               	
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
					<tbody style="padding:0px; margin:0px;">
						<tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
				</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='
				<table  style="width:100%;  border-collapse: collapse;">
					<tr>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
						<th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
					</tr>';
                
				$grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR COBRAR A CLIENTES</label></center>';
               	
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
				$pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">ANÁLISIS DE ANTIGUEDAD</label><br><label style="text-align:center; font-size:13px;">CUENTAS POR COBRAR A CLIENTES<br>'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function inv_valorizado($depto, $suc_list){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Reporte de Inventario Valorizado</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function ficha_tecnica($idproducto){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Ficha Técnica');
                $pdf->SetSubject('Reporte de Ficha Técnica');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT, 0);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('producto_model');
                $prod_dat = $this->producto_model->callRegistro($idproducto);
                  
                $this->load->model('fabrica_model');
                $materiales = $this->fabrica_model->verFichasMateriales($idproducto);
                $sumamateriales = $this->fabrica_model->sumMateriales($idproducto);
                $obras = $this->fabrica_model->verFichasObras($idproducto);
                $sumaobras = $this->fabrica_model->sumObras($idproducto);
                
                foreach($sumamateriales as $key){
					foreach($sumaobras as $key2){
                    	$total = (($key->subtotal) + ($key2->subtotal));
					}
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Ficha Técnica</label><br><label style="text-align:center;  font-size:20px; font-weight:bold;">N° '.$idproducto.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);


                $pdf->AddPage();


                $titulo='';
                   
                    
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style=" width:100%;">';
           
                
               
                foreach($prod_dat as $key){    
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style=" border-bottom: solid 2px black;  font-size:26px; color:#21618C; text-align:left;" ><strong>'.$key->descrip.'</strong></th>
                                    
                                </tr>
                                
                                </thead>';  
                                
               
                    $titulo .= '  <tbody>
                                <tr>
                                    <br>
                                    <td></td>
                                    <td width="41%" colspan="2"><img style="width:650px; height:550px; margin-left:25px;  " src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$key->imagen.'"></td>
                                    <td></td>
                                    <td>
                                    <table style=" width:160%;">
                                        <thead>
                                            <tr>
                                                <th style=" background-color:#004379; color:white; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black;    font-size:14px; text-align:center;" width="100%"><strong>ESPECIFICACIONES</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black;  background-color:#F4F6F6; color:#413D3D; font-weight: bold; " >Colección</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->marca.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;  background-color:#F4F6F6; color:#413D3D; " >Modelo</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;  " >'.$key->modelo.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Peso(Onzas)</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->ftpeso.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Medidas</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->ftmedidas.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Tiempo de Producción(Minutos)</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.$key->fttime.'</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:left; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; background-color:#F4F6F6; color:#413D3D; " >Costo Unitario</td>
                                            </tr>
                                            <tr>
                                                <td  style="font-size:13px;   text-align:right; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($total, 2).'</td>
                                            </tr>
                                    </table>
                                    </td>  
                                    <td></td>
                                   
                                </tr>
                                <tr>
                                <td  colspan="5" style=" font-size:13px; text-align:left; font-weight:bold; " >Caracteristicas:</td>
                                <td></td>
                                 </tr>
                                    <tr>
                                    <td width="100%"  colspan="5" style=" font-size:13px; text-align:justify;  " >'.$key->ftspecs.'</td>
                                    <td></td>
                                    </tr>
                                    
                                </tbody>';
                  
                }
                
                $titulo .= ' </table><br>';
                
                
                
                
                
                
                
                    
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style="border: solid 0.5px black; width:100%;">';
                
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="5" style=" background-color:#004379; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; color:white;    font-size:14px; text-align:left;" width="100%"><strong>MATERIAS PRIMAS</strong></th>
                                  
                                </tr>
                                </thead>';  
                
                $titulo .= '  <tbody>
                                <tr>
                                    <td width="46%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;  border-left: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Material</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;  border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >U/M</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Cantidad</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Costo Unitario</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black;   border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Sub Total</td>
                                    
                                                
                                </tr>';
                foreach($materiales as $key){
                    $titulo .= ' 
                                    <tr>
                                    <td style="font-size:12px;  text-align:left; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->titulo.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->unidad.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->costo, 5).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->subtotal, 2).'</td>
                                    
                                    </tr>';          
                }   
                
                foreach($sumamateriales as $key){
                    $titulo .= ' 
                                 <tr>
                                    <td colspan="2"  style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Total Materias Primas</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " ></td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($key->subtotal, 2).'</td>
                                          
                                                                                   
                                </tr>';    
                }
                                
                $titulo .= '<tbody></table><br><br>';
                
                
                
                $titulo .= '
                <div  class="col-xs-12 col-sm-12 col-md-12" style="text-align:right;" >
                <br>
                </div>
                <table style="border: solid 0.5px black; width:100%;">';
                
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="5" style=" background-color:#004379; border-right: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; color:white;   font-size:14px; text-align:left;" width="100%"><strong>MANO DE OBRA</strong></th>
                                  
                                </tr>
                                </thead>';  
                
                $titulo .= '  <tbody>
                                <tr>
                                    <td width="46%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black; border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Trabajo o Proceso </td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >U/M</td>
                                    <td width="13%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Cantidad</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Costo Unitario</td>
                                    <td width="14%" style="font-size:12px; background-color:#F4F6F6; text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Sub Total</td>
                                                
                                </tr>';
                                
                foreach($obras as $key){
                                    $titulo .= '  
                                 <tr>
                                    <td style="font-size:12px;  text-align:left; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->titulo.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.$key->unidad.'</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->costo, 5).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; " >$'.number_format($key->subtotal, 2).'</td>
                               </tr>';          
                                 }
                                foreach($sumaobras as $key){

                                 $titulo .= ' 
                                 <tr>
                                    <td colspan="2"  style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold;" >Total Mano de Obra</td>
                                    <td style="font-size:12px;  text-align:center; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >'.number_format($key->cantidad).'</td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " ></td>
                                    <td style="font-size:12px;  text-align:right; border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black; font-weight: bold; " >$'.number_format($key->subtotal, 2).'</td>
                                                                                   
                                </tr>';
                
                                }
                
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                 
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Ficha_Tecnica.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
            
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$funcion = $this->uri->segment(3);
				$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                $fecha = new DateTime();
                
				$footer =  '<br><br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tbody style="padding:0px; margin:0px;">
                        	<tr style="padding:0px; margin:0px;">
								<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
								<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
								<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        	</tr>
                    	</tbody>
					</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br>
					<center>
						<label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label>
						<br>
						<label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label>
						<br>
					</center>
					<br>
                	<table style="padding:0px; width:100%; margin-bottom:150%;">
						<tbody>
							<tr>
								<th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
								<td width="10%"  style="border-bottom: solid 3px black;"></td>
								<th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
								<td width="5%" style="border-bottom: solid 3px black;"></td>
								<th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                			</tr>
                		</tbody>
                	</table>';
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo='';
				foreach($nombres as $grupo){
					$titulo .= '
						<table style=" width:100%;">
							<thead>
								<tr>
									<th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
								</tr>
                            </thead>
							<tbody>';
					
					foreach($variables as $sub){  
						if($grupo->nombre == $sub->nombre){
							if($sub->tipo_valor == 1){
								$tipo = "N";
								$valor = $sub->valor_num;
							}else if($sub->tipo_valor == 2){
								$tipo = "T";
								$valor = $sub->valor_txt;
							}else if($sub->tipo_valor == 3){
								$tipo = "F";
								$valor = $sub->valor_fecha;
							}else if($sub->tipo_valor == 4){
                               	$tipo = "L";
								$valor = $sub->valor_logico;
							}else if($sub->tipo_valor == 5){
								$tipo = "M";
								$valor = $sub->valor_num;
							}
                			
							$titulo .= '  
								<tr>
                                   <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
								   <td width="10%"></td>
								   <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
								   <td width="5%"></td>
								   <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
								</tr>';
 	                          
							if($sub->valor_memo != ""){
								$titulo .= '
								<tr>
									<td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
							}
                       }
					}
					$titulo .= '<tbody></table><br><br>';
				}
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$funcion = $this->uri->segment(3);
               	$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
				$this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                $apps = $this->apps_model->verApps();
                
                $fecha = new DateTime();
                
				$footer =  '<br><br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tbody style="padding:0px; margin:0px;">
                        	<tr style="padding:0px; margin:0px;">
                            	<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
								<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
								<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        	</tr>
                    	</tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br>
					<center>
						<label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label>
						<br>
						<label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label>
						<br>
					</center>
					<br>
					<table style="padding:0px; width:100%; margin-bottom:150%;">
                		<tbody>
                			<tr>
                				<td width="3%" style="border-bottom: solid 3px black;"></td>
                    			<td width="3%" style="border-bottom: solid 3px black;"></td>
								<td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
								<td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
								<td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
								<td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
							</tr>
						</tbody>
                	</table>';
				
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo = '';
                $titulo .= '
					<table style=" width:100%;">
						<tbody>';
                
                foreach($menus as $key){
					$titulo .= '
							<tr>
								<td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                             </tr>';
                    
					foreach($apps as $key2){   
						if(trim($key2->menuname) == trim($key->descripcion)){
                        	if($key2->menutype == 1){
                            	$titulo .= '
								<tr>
									<td width="3%"></td>
									<td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
								</tr>';
                            	
								foreach($apps as $key3){
									if($key2->idapp == $key3->idapphd){
										
										$titulo .= '
										<tr>
											<td width="3%" ></td>
											<td width="3%" ></td>
											<td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
											<td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
											<td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
											<td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
										</tr>';
                                        
										if($key3->notas != ""){
											$titulo .= '
											<tr>
												<td width="1.8%"></td>
												<td width="7%"></td>
												<td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
												<td colspan="2"></td>
											</tr>';
										}
									}
                             	}  
							}else{
								$titulo .= '
								<tr>
									<td width="3%" ></td>
									<td width="3%" ></td>
									<td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
									<td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
									<td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
									<td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
								</tr> ';
                                
								if($key2->notas != ""){
									$titulo .= '
									<tr>
										<td width="1.8%"></td>
										<td width="7%"></td>
										<td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
										<td colspan="2"></td>
									</tr>';
								}
							}
						}
					}
                    
                    $titulo .= '
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr> ';
				}
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
          
        function reporte_transacciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$funcion = $this->uri->segment(3);
               	
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				$pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 33, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
				$this->load->model('transacciones_model');
				$pagos = $this->transacciones_model->verPagos();
                $pagosco = $this->transacciones_model->getPagosCO();
                $pagosvn = $this->transacciones_model->getPagosVN();
                $pagosin = $this->transacciones_model->getPagosIN();
                
				$fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="5%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >ID</td>
                    <td width="28.4%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Operación en Inventarios</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Operación en Caja</td>
                    <td width="28%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Pagos</td>
                </tr>
                </tbody>
                </table> ';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style="padding:0px; width:100%; margin-bottom:150%;">';
                $titulo .= '<tbody>';
                
                $titulo .= '<tr>
                                <td width="0.9%" style=""></td>  
                                <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">COMPRAS</td>
                            </tr>';
                $titulo .= '<tr><td colspan="6"></td></tr>';
                
                $cadena="";
                $cant=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "CO"){ 
                        
                        if($key->inopera == 1){ 
                              $oventaco = "Suma"; 
                           }else if($key->inopera == 0){
                               $oventaco = "Nada";
                           }else if($key->inopera == -1){
                               $oventaco = "Resta";
                           }
                        
                        
                        if($key->caopera == 1){
                              $oventaca = "Suma";
                           }else if($key->caopera == 0){
                               $oventaca = "Nada";
                           }else if($key->caopera == -1){
                               $oventaca = "Resta";
                           }
                        
                        
                        $arrayPag = explode(",", $key->pagos);
                        $totRig = count($arrayPag);
                        $totReal = $totRig;
                        
                        
                        for($i=0; $i<$totReal; $i++){
                            
                            foreach($pagosco as $co){
                                if($arrayPag[$i] == $co->cajclase){
                                    if($cant==0){
                                     
                                     $cadena = $co->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena .= ", ".$co->descrip;
                                    }   
                            
                                }
                            }
                            
                            $cant++;
                        }
                        
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px; text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventaco.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventaca.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena.'</td>
                            </tr>';
                        
                        if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    }
                    
                    $cadena="";
                    $cant=0;
                    
                }
                
                $titulo .= '<tr><td colspan="6"></td></tr>';  
                $titulo .= '<tr>
                                <td width="0.9%" style=""></td> 
                                <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">VENTAS</td>
                            </tr>';
                $titulo .= '<tr><td colspan="6"></td></tr>'; 
                $cadena2="";
                $cant2=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "VN"){
                        
                        if($key->inopera == 1){
                              $oventavn = "Suma";
                           }else if($key->inopera == 0){
                               $oventavn = "Nada";
                           }else if($key->inopera == -1){
                               $oventavn = "Resta";
                           }
                        
                        if($key->caopera == 1){
                              $oventavnc = "Suma";
                           }else if($key->caopera == 0){
                               $oventavnc = "Nada";
                           }else if($key->caopera == -1){
                               $oventavnc = "Resta";
                           }
                        
                        
                        $arrayPag2 = explode(",", $key->pagos);
                        $totRig2 = count($arrayPag2);
                        $totReal2 = $totRig2;
                        
                        
                        for($i=0; $i<$totReal2; $i++){
                            
                            foreach($pagosvn as $vn){
                                if($arrayPag2[$i] == $vn->cajclase){
                                    if($cant2==0){
                                     
                                        $cadena2 = $vn->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena2 .= ", ".$vn->descrip;
                                    }   
                            
                                }
                            }
                            
                            
                            
                            $cant2++;
                            
                            
                           
                            
                        }
                        
                  
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px;  text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventavn.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventavnc.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena2.'</td>
                            </tr>';
                        
                        if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    
                    }
                    
                    $cadena2="";
                    $cant2=0;
                    
                }
                
                $titulo .= '<tr><td colspan="6"></td></tr>';  
                
                
                $titulo .= '<tr>
                               <td width="0.9%" style=""></td>
                               <td width="100%" colspan="5" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">INVENTARIOS</td>
                            </tr>';
                
                 $titulo .= '<tr><td colspan="6"></td></tr>'; 
                $cadena1="";
                $cant1=0;
                foreach($pagos as $key){
                    
                    if($key->agrupa == "IN"){
                        
                        if($key->inopera == 1){
                              $oventain = "Suma";
                           }else if($key->inopera == 0){
                               $oventain = "Nada";
                           }else if($key->inopera == -1){
                               $oventain = "Resta";
                           }
                        
                        if($key->caopera == 1){
                              $oventacin = "Suma";
                           }else if($key->caopera == 0){
                               $oventacin = "Nada";
                           }else if($key->caopera == -1){
                               $oventacin = "Resta";
                           }
                        
                        
                        $arrayPag1 = explode(",", $key->pagos);
                        $totRig1 = count($arrayPag1);
                        $totReal1 = $totRig1;
                        
                        
                        for($i=0; $i<$totReal1; $i++){
                            
                            foreach($pagosin as $in){
                                if($arrayPag1[$i] == $in->cajclase){
                                    if($cant1==0){
                                     
                                     $cadena1 = $in->descrip;
                                     
                                     
                                
                                    }else{
                                     
                                        $cadena1 .= ", ".$in->descrip;
                                    }   
                            
                                }
                            }
                            
                            $cant1++;
                        }
                        
                  
                  $titulo .= '<tr>
                                <td width="3%" style=""></td>
                                <td width="5%" style=" font-size:12px;  text-align:left;" >'.$key->invclase.'</td>
                                <td width="28.5%" style="font-size:12px; text-align:left;  " >'.$key->descrip.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventain.'</td>
                                <td width="18%" style="font-size:12px;  text-align:center;  " >'.$oventacin.'</td>
                                <td width="28%" style="font-size:12px;  text-align:left;  " >'.$cadena1.'</td>
                            </tr>';
                    
                    }
                    
                    if($key->notas = " "){
                     
                        }else{       
                            $titulo .= '<tr>
                                         <td width="3%" style=""></td>
                                         <td width="15%" style=" font-size:12px;  text-align:left;" ></td>
                                         <td colspan="4" style=" font-size:11px;  text-align:left;" >'.$key->notas.'</td>
                                       </tr>';
                    
                        }
                    
                    $cadena1="";
                    $cant1=0;
                    
                }
                
                
                
                
                   
                $titulo .= '</tbody></table><br><br>';
                
                
          
                    

                
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Transacciones_inventarios.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_usuarios($tipo){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                $funcion = $this->uri->segment(3);
				$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
				$pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 33, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $this->load->model('user_model');
                $usuarios = $this->user_model->verUsuarios($tipo);
                                                                  
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="2%" style="border-bottom: solid 3px black;"></td>
                    <td width="3.5%" style=" border-bottom: solid 3px black;  font-size:12px; text-align:center;  font-weight: bold;" >ID</td>
                    <td width="29.5%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre Completo</td>
                    <td width="18%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Usuario</td>
                    <td width="13%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Ingreso</td>
                    <td width="13%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Vence</td>
                    <td width="22%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Sucursal</td>
                </tr>
                </tbody>
                </table>';
               	 
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo='';
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                if($tipo == 1){
                    $titulo .= '<tr>
                                <td width="0.9%" style=""></td> 
                                <td width="100%" colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">ACTIVOS</td>
                            </tr>';
                    $titulo .= '<tr><td colspan="7"></td></tr>';
                    
                    foreach($usuarios as $key){
                    
                    $titulo .= '<tr>
                                <td width="2%" style=""></td>
                                <td width="3.5%" style="   font-size:11px; text-align:center; " >'.$key->id.'</td>
                                <td width="29.5%" style="font-size:11px;  text-align:left; " >'.$key->nombre.'</td>
                                <td width="18%" style="font-size:11px;  text-align:left; " >'.$key->usuario.'</td>
                                <td width="13%" style="font-size:11px;   text-align:center;" >'.date("d/m/Y",strtotime($key->ingreso)).'</td>
                                <td width="13%" style="font-size:11px;   text-align:center; " >'.date("d/m/Y",strtotime($key->vence)).'</td>
                                <td width="22%" style="font-size:11px;   text-align:left;" >'.$key->sucursal.'</td>
                            </tr>';
                    }
                }else if($tipo == 0){
                    $titulo .= '<tr>
                              <td width="0.9%" style=""></td> 
                              <td width="100%"  colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">INACTIVOS</td>
                            </tr>';
                    $titulo .= '<tr><td colspan="7"></td></tr>';
                    
                    foreach($usuarios as $key){
                    
                    $titulo .= '<tr>
                                <td width="2%" ></td>
                                <td width="3.5%" style="font-size:11px; text-align:center; " >'.$key->id.'</td>
                                <td width="29.5%" style="font-size:11px;  text-align:left; " >'.$key->nombre.'</td>
                                <td width="18%" style="font-size:11px;   text-align:left; " >'.$key->usuario.'</td>
                                <td width="13%" style="font-size:11px;   text-align:center;" >'.date("d/m/Y",strtotime($key->ingreso)).'</td>
                                <td width="13%" style="font-size:11px;   text-align:center; " >'.date("d/m/Y",strtotime($key->vence)).'</td>
                                <td width="22%" style="font-size:11px;   text-align:left; " >'.$key->sucursal.'</td>
                            </tr>';
                    }
                }
                
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Transacciones_FormasPago.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_formatos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                	$funcion = $this->uri->segment(3);
               	$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
				 
				$this->load->model('formas_model');
                
				$formas = $this->formas_model->viewFormas();
				$names = $this->formas_model->viewName();
                                                                   
				$fecha = new DateTime();
				$footer =  '<br><br><br><br><br><br>
                 <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                 $pdf->setHtmlFooter($footer);
                 $pdf->setPrintFooter(true);
                  
                 $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                 <table style="padding:0px; width:100%; margin-bottom:150%;">
                 <tbody>
                 <tr>
                 <td width="5%" style="border-bottom: solid 3px black;"></td>
                 <td width="38%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Descripción</td>
                 <td width="38%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre del Formulario</td>
                 <td width="20%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Contraseña</td>
                </tr>
                </tbody>
                </table>';
				
				$pdf->setHtmlHeader($header);
				$pdf->setPrintHeader(true);
                   


                 $pdf->AddPage();
                
                 $titulo='';
                 
                 $titulo .= '<table style=" width:100%;">';
                 $titulo .= '<tbody>';
                 
                 foreach($names as $key2){
                     
                     $titulo .= '
                     <tr>
                     <td  width="100%" colspan="4" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" >'.$key2->appname.'</td>
                     </tr>';
                     $titulo .= '<tr>
                     <td colspan="4"  style="font-size:12px; text-align:left; " ></td>
                     </tr>';
                 
                     foreach($formas as $key){
                     
                         if($key->appname == $key2->appname){
                    
                             $titulo .= '
                             <tr>
                             <td width="5%" style=""></td>
                             <td width="38%" style="font-size:12px; text-align:left;" >'.$key->descrip.'</td>
                             <td width="38%" style="font-size:12px; text-align:left;" >'.$key->formname.'</td>';
                              if($key->gvarpwd != ""){
                                  $titulo .= ' <td width="20%" style="font-size:12px; text-align:center;"><img style="width:15px;  margin-left:25px; height:15px;" src="'.base_url().'img/Adicionar.png"></td>';
                              }else{
                                  $titulo .= ' <td width="20%" style="font-size:12px; text-align:center;"></td>';
                              }
                             $titulo .= '</tr>';
                         }
                     }
                     $titulo .= '<tr>
                     <td  style="font-size:12px; text-align:left; " ></td>
                     <td  style="font-size:12px; text-align:left; " ></td>
                     </tr>';
                     
                 }
                 
                 
                 
                 $titulo .= '</tbody></table><br><br>';
                 
                 
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                 $nombre_archivo = utf8_decode("Transacciones_FormasPago.pdf");
                 $pdf->Output($nombre_archivo, 'I');
            }
            
            
            
        }
        
        function inv_valorizado2($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
               
                $html = $this->output->get_output();
		
                // Load library
                $this->load->library('dompdf_gen');
                
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
               
             
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;

                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                            </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        foreach($lineas_list as $lin){
                            $titulo_depto .='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_depto .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_depto.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                     
                                }
                            }
                            $titulo_depto .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo .=$titulo_depto;
                            }else{
                                $titulo_depto='';
                            }
                        }
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                            </tr></table>';
                        if($sum_dep>0){
                             $titulo .=$titulo_depto;
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                                <tr>
                                    <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                                </tr></table>';
                            $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                            $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                            foreach($lineas_list as $lin){
                                $titulo_depto .='<table  style="width:100%;  border-collapse: collapse;">
                                <tr>
                                    <th style="width:5%;"></th>
                                    <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                                </tr></table>';
                                $titulo_depto .='<table  style="width:100%; border-collapse: collapse;">
                                <tr>
                                    <th style="width:5%; text-align:left;"></th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                    <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                                </tr>';
                                $sum_linea =0;
                                foreach($lista_productos as $product){
                                    if($product->idcatalogo==$lin->idcatalogo){
                                        //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                        $sum_linea+=($product->costounitario*$product->cantidad);
                                        $sum_dep +=($product->costounitario*$product->cantidad);
                                        $sum_total +=($product->costounitario*$product->cantidad);
                                        $titulo_depto.='<tr>
                                            <td style="width:5%; text-align:left;"></td>
                                            <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                            <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                            <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                            <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                            <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                            <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                            <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                        </tr>';

                                    }
                                }
                                $titulo_depto .='<table style="margin-top:5px;"><tr>
                                    <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                    <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                                </tr></table>';
                                if($sum_linea>0){
                                    $titulo .=$titulo_depto;
                                }else{
                                    $titulo_depto='';
                                }
                            }
                            $titulo_depto .='<table style="margin-top:5px;"><tr>
                                    <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                                    <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                                </tr></table>';
                            if($sum_dep>0){
                                 $titulo .=$titulo_depto;
                            }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                
                
                
                
                
                
                
                // Convert to PDF
                $this->dompdf->load_html($titulo);
                $this->dompdf->render();
                $this->dompdf->stream("Documento.pdf");
                
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">Listado de Departamentos y Líneas</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                        if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                        }
                       
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo && $lin->cant!=0){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">CUENTAS POR COBRAR</label><br><label style="text-align:center; font-size:13px;">CARTERA POR VENDEDOR<br>'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td colspan="5" style="width:100%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:40%; text-align:center;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:20%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:40%; text-align:center;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:90%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:90%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                            </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function ventasTicket($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        		
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);
				//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
				// se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage( 'P',$pagelayout);

                $this->load->model('ventas_model');
                //$products = $this->mantenimiento_model->getDataCake_for_ticket($trannum);

				$estructura = '<table style="width:100%;">
					<tr>
						<td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
					</tr>
					<tr>
						<td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PRUEBA DE TICKET N°'.$trannum.'</td>
					</tr>
				</table>';
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("ticket_venta_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'F');

            }
        
        }
		
        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function recepcionDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Recepcion_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
            
        }
        
        function ajustesExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Ajuste de Inventarios") // Titulo
                ->setSubject("Ajuste de Inventarios") //Asunto
                ->setDescription("Ajuste de Inventarios") //Descripción
                ->setKeywords("Ajuste de Inventarios") //Etiquetas
                ->setCategory("Ajuste de Inventarios"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Ajuste_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function ajustesDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Ajuste_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Ajuste_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Ajuste_'.$trannum.'.txt');
                exit;
            }
            
        }
        
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}
		
		function unidad_centimos($numero){
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;

			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('Landscape', 'mm', 'LETTER', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P','LETTER');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">'.$info->descrip.' N° '.$info->serie.'-'.$info->numero.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">ORDEN N° '.$info->trannum.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;">CLIENTE: '.strtoupper($info->nameCliente).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:5%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">FECHA: '.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:12px; width:100%;"><br></td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;"> '.$pro->idproducto.' '.strtoupper($pro->descrip).' - <strong>'.strtoupper($pro->vendename).'</strong></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:70%;"rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:1%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 16px; width:10%;" rowspan="2">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
                
                foreach($informacion as $info){
					$estructura .= '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">'.$info->descrip.' N° '.$info->serie.'-'.$info->numero.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">ORDEN N° '.$info->trannum.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;">CLIENTE: '.strtoupper($info->nameCliente).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:5%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 13px; width:95%;">FECHA: '.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:12px; width:100%;"><br></td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;"> '.$pro->idproducto.' '.strtoupper($pro->descrip).' - <strong>'.strtoupper($pro->vendename).'</strong></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:70%;"rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:1%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 16px; width:10%;" rowspan="2">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				$js = 'print(true);';
				$pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		/*function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 8 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$ven->hora.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}*/
         function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 8 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.',',');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.',',');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:7px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$ven->hora.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2, '.', ',').'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2, '.', ',').'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2, '.', ',').'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
		function reporteCorteZAntiguo($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					//var ipaddr = datosprinter[0];
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
		$script .= "var numCantidad = ".$numInicial.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

					if(numTotal == 1){
						var newString = '          ".$numInicial."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numInicial."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numInicial."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numInicial."';
					}else if(numTotal == 5){
					    var newString = '      ".$numInicial."';
					}else if(numTotal == 6){
						var newString = '     ".$numInicial."';
					}else if(numTotal == 7){
						var newString = '    ".$numInicial."';
					}else if(numTotal == 8){
						var newString = '   ".$numInicial."';
					}else if(numTotal == 9){
						var newString = '  ".$numInicial."';
					}";
		
		$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
		$script .= "var numCantidad = ".$numFinal.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numFinal."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numFinal."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numFinal."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numFinal."';
					}else if(numTotal == 5){
					    var newString = '      ".$numFinal."';
					}else if(numTotal == 6){
						var newString = '     ".$numFinal."';
					}else if(numTotal == 7){
						var newString = '    ".$numFinal."';
					}else if(numTotal == 8){
						var newString = '   ".$numFinal."';
					}else if(numTotal == 9){
						var newString = '  ".$numFinal."';
					}";
						
		$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
		
		$script .= "var numCantidad = ".$numdoc.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdoc."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdoc."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdoc."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdoc."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdoc."';
					}else if(numTotal == 6){
						var newString = '     ".$numdoc."';
					}else if(numTotal == 7){
						var newString = '    ".$numdoc."';
					}else if(numTotal == 8){
						var newString = '   ".$numdoc."';
					}else if(numTotal == 9){
						var newString = '  ".$numdoc."';
					}";
						
		$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotalex, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotalex, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotalex, 2),2)."';
					}";
						
		$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotalgr, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotalgr, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotalgr, 2),2)."';
					}";
						
		$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotaliv, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotaliv, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotaliv, 2),2)."';
					}";
		$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($subtotal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($subtotal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($subtotal, 2),2)."';
					}";
		
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
						
						$totalglobal = $totalglobal+$subtotal;
						$totalexglobal = $totalexglobal + $subtotalex;
						$totalgrglobal = $totalgrglobal + $subtotalgr;
						$totalivglobal = $totalivglobal + $subtotaliv;
                    	
					}
				
		$script .= "ticketObj.addText('    Totales:').addFeed();";
				
		$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
		$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($totalexglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
		$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
		$script .= "var numCantidad = parseFloat(".number_format(round($totalgrglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";
		$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
		$script .= "var numCantidad = parseFloat(".number_format(round($totalivglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
		$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
		$script .= "var numCantidad = parseFloat(".number_format(round($totalglobal, 2),2).").toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
		
		$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
					$total_ing_sum=0;
					$l=0;
					foreach($tipospagos as $tip){
						$l++;
					}
					$p=0;
					foreach($tipospagos as $tip){
						$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
									var totalString = numCantidad.toString();
									while(totalString.length < 23){
										totalString = ' ' + totalString;
									}
									
									var numPrecio = parseFloat(".number_format(round($valpagG[$tip->cajclase], 2),2).").toFixed(2);
									var valorString = numPrecio.toString();
									var numTotal = valorString.length;

									if(numTotal == 1){
										var newString = '         $' + numPrecio;
									}else if(numTotal == 2){
										var newString = '        $' + numPrecio;
									}else if(numTotal == 3){
										var newString = '       $' + numPrecio;
									}else if(numTotal == 4){
										var newString = '      $' + numPrecio;
									}else if(numTotal == 5){
										var newString = '     $' + numPrecio;
									}else if(numTotal == 6){
										var newString = '    $' + numPrecio;
									}else if(numTotal == 7){
										var newString = '   $' + numPrecio;
									}else if(numTotal == 8){
										var newString = '  $' + numPrecio;
									}else if(numTotal == 9){
										var newString = ' $' + numPrecio;
									}";
						if($p == $l - 1){
							$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
						}else{
							$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
						}
						$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
						$p++;
					}
				
		$script .= "var numCantidad = ".number_format(round($total_ing_sum, 2),2).";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
		$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
		$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('Firma Cajera/o').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					// append paper cutting
					ticketObj.addCut();
								
					// create print object
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					// register callback function
					epos.onreceive = function (res){
					// close print dialog
					//$('#print').dialog('close');
					// print failure
					if (!res.success) {
					// show error message
					//$('#receive').dialog('open');
					}
					}

					// register callback function
					epos.onerror = function (err) {
					// close print dialog
					//$('#print').dialog('close');
					// show error message
					//$('#error').dialog('open');
					}
					// send
					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZ($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZPruebas($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.44';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z DEL ".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, false, 'bold').addText(' DETALLE DE TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
					$subtotal=0;
					$totalglobal=0;
					$totalexglobal=0;
					$totalgrglobal=0;
					$totalivglobal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$numdoc = 0;
					$numdocg = 0;
				
					foreach($documentos as $docs){
						$numdoc = 0;
						$subtotal=0;
						$subtotalex = 0;
						$subtotalgr = 0;
						$subtotaliv = 0;
						$t = 0;
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
							
						foreach($facturas as $ven){
							if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
								$valtot = $ven->valventan + $ven->valtax1;
								$subtotal= $subtotal+$valtot;
								if($t == 0){
									$numInicial = $ven->numero;
								}
								$total = 0;
								$totalGravado = 0;
								$totalExento = 0;
								$totalIVA = 0;
								$invexento = $ven->exento;
								$productos = $this->invtran_model->getDataTran100k($ven->trannum);

								foreach($productos as $pro){
									if($pro->tipotax != 0 && $invexento == 0){
										$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
										$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
										$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax != 0 && $invexento == 1){
										$total = $total + (($pro->precioneto * abs($pro->cantidad)));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax== 0 && $invexento == 0){
										$total = $total + (($pro->precioneto) * abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}else if($pro->tipotax == 0 && $invexento == 1){
										$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
										$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
									}
								}

								$subtotalex = $subtotalex + $totalExento;
								$subtotalgr = $subtotalgr + $totalGravado;
								$subtotaliv = $subtotaliv + $totalIVA;

								foreach($tipospagos as $tip){
									$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
									foreach($pagos as $money){
										if($tip->cajclase == $money->cajclase){
											$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
											$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
										}
									}
								}
								$numdoc++;
								$numdocg++;
								$numFinal = $ven->numero;
								$t++;
							}else{
								foreach($tipospagos as $tip){
									$valpag[$tip->cajclase] = 0;
								}
							}
						}
		
				$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

				$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

				$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

				$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($subtotal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

								$totalglobal = $totalglobal+$subtotal;
								$totalexglobal = $totalexglobal + $subtotalex;
								$totalgrglobal = $totalgrglobal + $subtotalgr;
								$totalivglobal = $totalivglobal + $subtotaliv;

							}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' RESUMEN DE INGRESOS:').addTextStyle(false, false, false).addFeed();";
							$total_ing_sum=0;
							$l=0;
							foreach($tipospagos as $tip){
								$l++;
							}
							$p=0;
							foreach($tipospagos as $tip){
								$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
											var totalString = numCantidad.toString();
											while(totalString.length < 23){
												totalString = ' ' + totalString;
											}

											var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
											var valorString = numPrecio.toString();
											var numTotal = valorString.length;

											if(numTotal == 1){
												var newString = '         $' + numPrecio;
											}else if(numTotal == 2){
												var newString = '        $' + numPrecio;
											}else if(numTotal == 3){
												var newString = '       $' + numPrecio;
											}else if(numTotal == 4){
												var newString = '      $' + numPrecio;
											}else if(numTotal == 5){
												var newString = '     $' + numPrecio;
											}else if(numTotal == 6){
												var newString = '    $' + numPrecio;
											}else if(numTotal == 7){
												var newString = '   $' + numPrecio;
											}else if(numTotal == 8){
												var newString = '  $' + numPrecio;
											}else if(numTotal == 9){
												var newString = ' $' + numPrecio;
											}";
								if($p == $l - 1){
									$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
								}else{
									$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
								}
								$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
								$p++;
							}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentas($fechaactual, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentas($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentas($fechaactual, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedores($fechaactual, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('Firma Cajera/o').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							// append paper cutting
							ticketObj.addCut();

							// create print object
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							// register callback function
							epos.onreceive = function (res){
							// close print dialog
							//$('#print').dialog('close');
							// print failure
							if (!res.success) {
							// show error message
							//$('#receive').dialog('open');
							}
							}

							// register callback function
							epos.onerror = function (err) {
							// close print dialog
							//$('#print').dialog('close');
							// show error message
							//$('#error').dialog('open');
							}
							// send
							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function valueinv($sucursal, $tipopro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='
                <table>
                    <thead>
                        <tr><td style="font-size:10px;"></td></tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                            <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                        </tr>
                    </thead>
                <tbody>';
                $sum_lines = 0;
                $sum_cant = 0;
                $sum_subtotal = 0;
                foreach($productos as $pro){
                    $sum_lines++;
                    $sum_cant+= $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
                    $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                    <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                    <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                    <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td></tr>';
                }
                
                 
                
                $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>';
                
                $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
                    <td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
                    <td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
                    <td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td></tr>';
               
                $titulo.='</tbody>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function ventaTicket($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
						
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText('REIMPRESIÓN ' + data.tipodocumento + ' N° ' + data.numdocumento).addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
								//ticketObj.addPulse();

								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
		
        function ventaTicketFinalUpdate($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;
                                
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addLogo(34, 34);
								ticketObj.addFeedLine(1);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje: ' + data.desder + ' - ' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								ticketObj.addText('                 VUELTO: $' + strTotalExent +'').addFeed();

								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}

								ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								ticketObj.addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
                                
                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }
                                
								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
        
		function ventaTicketFinal($trannum){
            date_default_timezone_set('America/El_Salvador');
            $date = new DateTime();
			
            echo "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
						var datos = {trannum: ".$trannum."}
						$.ajax({
							type:'POST',
							url: '".base_url()."compras/imprimirTicketEposFinal',
							dataType: 'json',
							data: datos,
							success: function(data){
							    window.blur();
								var datosprinter = data.datos_print.split('/');
								var ipaddr = datosprinter[0];
								var devid = datosprinter[1];
								var timeout = '60000';
								var grayscale = false;
								var layout = false;
                                var efectivopago = data.efectivo;
                                
								// create print data builder object
								var ticketObj = new epson.ePOSBuilder();
								// paper layout
								if(layout){
									ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
								}
								// initialize (ank mode, smoothing)
								ticketObj.addTextLang('es').addTextSmooth(true);
								ticketObj.addFeedLine(1);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addLogo(34, 34);
								ticketObj.addFeedLine(1);
								ticketObj.addTextSize(1, 2);
								ticketObj.addTextStyle(false, false, 'bold').addText(data.razonsocial).addTextStyle(false, false, false);
								ticketObj.addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText(data.namecaja);
								ticketObj.addFeed();
								ticketObj.addText(data.namecentro);
								ticketObj.addFeed();
								ticketObj.addText('NRC: ' + data.nrf + ' NIT: ' + data.nit);
								ticketObj.addFeed();
								ticketObj.addText('Giro: ' + data.giro);						
								ticketObj.addFeed();
								ticketObj.addText('IVA D.L. N° 296');
								ticketObj.addFeed();
								ticketObj.addText('Autorizado según resolución');
								ticketObj.addFeed();
								ticketObj.addText('N° ' + data.numres);						
								ticketObj.addFeed();
								ticketObj.addText('Del ' + data.fecres);					
								ticketObj.addFeed();
								ticketObj.addText('Tiraje:' + data.desder + '-' + data.hastar);
								ticketObj.addFeed().addFeed();
								ticketObj.addTextSize(1, 2).addText(data.tipodocumento + ' N° ' + data.numdocumento).addTextSize(1, 1);
								ticketObj.addFeed();
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);

								var total = 0; var totalGravado = 0; var totalExento = 0;
								var totalIVA = 0; var invexento = data.invexento; 
								var vnExenta = 0; var vnGravada = 0; var totalDesc = 0;
								var cantidades = 0; var numProd = 0; var totalSumas = 0;

								for(var idx in data.productos){
									var reg = data.productos[idx];

									if(reg['tipotax'] != 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad'])));
										totalIVA = parseFloat(totalIVA) + ((parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100)) * parseFloat(Math.abs(reg['cantidad'])));
										totalGravado = parseFloat(totalGravado) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '';
										vnGravada = '' + parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' G';
									}else if(reg['tipotax'] != 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 0){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}else if(reg['tipotax'] == 0 && invexento == 1){
										total = parseFloat(total) + ((parseFloat(reg['precioneto'])) * parseFloat(Math.abs(reg['cantidad'])));
										totalExento = parseFloat(totalExento) + parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']));

										vnExenta = '' + parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2) + ' E';
										vnGravada = '';
									}

									var preciouni = parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100));
									var proname = reg['descrip'].substring(0, 33);

									var absCantidad = Math.abs(reg['cantidad']);
									var canString = absCantidad.toString();
									var numCantidad = canString.length;

									var absPrecio = parseFloat(reg['preciotran']).toFixed(4);
									var preString = absPrecio.toString();
									var numPrecio = preString.length;

									if(reg['descuento'] != 0){
										var totalmuldes = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);

										var absTotal = parseFloat(parseFloat(reg['preciotran']).toFixed(4) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
										var totalString = absTotal.toString();
										var numTotal = totalString.length;

										var absDesc = parseFloat(reg['descuento']).toFixed(2);
										var descString = absDesc.toString();
										var numDesc = descString.length;

										totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(numTotal == 4){
											var strTotal = '       ' + totalmuldes;
										}else if(numTotal == 5){
											var strTotal = '      ' + totalmuldes;
										}else if(numTotal == 6){
											var strTotal = '     ' + totalmuldes;
										}else if(numTotal == 7){
											var strTotal = '    ' + totalmuldes;
										}

										if(numDesc == 4){
											var strDescuento = '     -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 5){
											var strDescuento = '    -' + parseFloat(reg['descuento']).toFixed(2);
										}else if(numDesc == 6){
											var strDescuento = '   -' + parseFloat(reg['descuento']).toFixed(2);
										}

										//Linea Producto
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strTotal + '').addFeed();

										var descuento = parseFloat(reg['descuento']) / 100;
										var cantdes = parseFloat(reg['preciotran']).toFixed(6) * parseFloat(descuento);
										var totdsc = parseFloat(cantdes).toFixed(4) * Math.abs(reg['cantidad']);

										totalDesc = parseFloat(totalDesc) + (Math.round(totdsc * 100) / 100);

										var absCantDes = parseFloat(cantdes).toFixed(4);
										var canDesString = absCantDes.toString();
										var numCantDes = canDesString.length;

										var absTotalDes = parseFloat(totdsc).toFixed(2);
										var totDesString = absTotalDes.toString();
										var numTotalDes = totDesString.length;

										if(numCantDes == 6){
											var strCantDes = '      -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 7){
											var strCantDes = '     -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 8){
											var strCantDes = '    -' + parseFloat(cantdes).toFixed(4);
										}else if(numCantDes == 9){
											var strCantDes = '   -' + parseFloat(cantdes).toFixed(4);
										}

										if(numTotalDes == 4){
											var strTotalDes = '      ';
										}else if(numTotalDes == 5){
											var strTotalDes = '     ';
										}else if(numTotalDes == 6){
											var strTotalDes = '    ';
										}else if(numTotalDes == 7){
											var strTotalDes = '   ';
										}

										//Linea Descuento
										ticketObj.addText(strDescuento + '%' + strCantDes + ' = ' + strTotalDes).addTextStyle(false, true, false).addText('-' + parseFloat(Math.round(totdsc * 100) / 100).toFixed(2) + '').addFeed();
										ticketObj.addTextStyle(false, false, false);

										if(vnExenta.length != 0){

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '                                  ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '                                 ' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '                                ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '                               ' + vnExenta;
											}

											ticketObj.addText(strExentas + '').addFeed();
										}else{
											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '                                  ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '                                 ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '                                ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '                               ' + vnGravada;
											}
											ticketObj.addText(strGravadas + '').addFeed();  
										}
									}else{
										ticketObj.addText('  ' + reg['idproducto'] + ' '+proname+'').addFeed();
										
										if(reg['tipo'] == 4){
											var vendename = reg['vendename'].substring(0, 25);
											ticketObj.addText('  Atendido por ' + vendename + '').addFeed();
										}
										
										if(numCantidad == 1){
											var strCantidad = '        ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 2){
											var strCantidad = '       ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 3){
											var strCantidad = '      ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 4){
											var strCantidad = '     ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 5){
											var strCantidad = '    ' + Math.abs(reg['cantidad']);
										}else if(numCantidad == 6){
											var strCantidad = '   ' + Math.abs(reg['cantidad']);
										}

										if(numPrecio == 6){
											var strPrecio = '       ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 7){
											var strPrecio = '      ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 8){
											var strPrecio = '     ' + parseFloat(reg['preciotran']).toFixed(4);
										}else if(numPrecio == 9){
											var strPrecio = '    ' + parseFloat(reg['preciotran']).toFixed(4);
										}

										if(vnExenta.length != 0){
											var absTotal = parseFloat(parseFloat(reg['precioneto']) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnExenta.length;
											if(numTotalFinal == 6){
												var strExentas = '       ' + vnExenta;
											}else if(numTotalFinal == 7){
												var strExentas = '     	' + vnExenta;
											}else if(numTotalFinal == 8){
												var strExentas = '     ' + vnExenta;
											}else if(numTotalFinal == 9){
												var strExentas = '    ' + vnExenta;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strExentas + '').addFeed();
										}else{
											var absTotal = parseFloat((parseFloat(reg['precioneto']) + (parseFloat(reg['precioneto']) * (parseFloat(reg['tipotax']) / 100))) * parseFloat(Math.abs(reg['cantidad']))).toFixed(2);
											totalSumas = parseFloat(totalSumas) + parseFloat(absTotal);

											var numTotalFinal = vnGravada.length;
											if(numTotalFinal == 6){
												var strGravadas = '       ' + vnGravada;
											}else if(numTotalFinal == 7){
												var strGravadas = '      ' + vnGravada;
											}else if(numTotalFinal == 8){
												var strGravadas = '     ' + vnGravada;
											}else if(numTotalFinal == 9){
												var strGravadas = '    ' + vnGravada;
											}

											ticketObj.addText(strCantidad + ' @' + strPrecio + ' = ' + strGravadas + '').addFeed();
										}
									}
									numProd++;
									cantidades = parseFloat(cantidades) + parseFloat(Math.abs(reg['cantidad']));
								}

								var grantotal = parseFloat(totalIVA) + parseFloat(totalGravado);

								var absTotalDesc = parseFloat(totalDesc).toFixed(2);
								var totalDescString = absTotalDesc.toString();
								var numTotalDesc = totalDescString.length;

								if(numTotalDesc == 4){
									var strTotalDesc = '        ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 5){
									var strTotalDesc = '       ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 6){
									var strTotalDesc = '      ' + parseFloat(totalDesc).toFixed(2);
								}else if(numTotalDesc == 7){
									var strTotalDesc = '     ' + parseFloat(totalDesc).toFixed(2);
								}

								var absGraTotal = parseFloat(grantotal).toFixed(2);
								var gTotalString = absGraTotal.toString();
								var numGranTotal = gTotalString.length;

								if(numGranTotal == 4){
									var strGranTotal = '        ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 5){
									var strGranTotal = '       ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 6){
									var strGranTotal = '      ' + parseFloat(grantotal).toFixed(2);
								}else if(numGranTotal == 7){
									var strGranTotal = '     ' + parseFloat(grantotal).toFixed(2);
								}

								var absTotalExen = parseFloat(totalExento).toFixed(2);
								var totExenString = absTotalExen.toString();
								var numTotExent = totExenString.length;

								if(numTotExent == 4){
									var strTotalExent = '        ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 5){
									var strTotalExent = '       ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 6){
									var strTotalExent = '      ' + parseFloat(totalExento).toFixed(2);
								}else if(numTotExent == 7){
									var strTotalExent = '     ' + parseFloat(totalExento).toFixed(2);
								}

								var absTotalFin = parseFloat(total).toFixed(2);
								var totFinalString = absTotalFin.toString();
								var numTotFinal = totFinalString.length;

								if(numTotFinal == 4){
									var strTotFinal = '        ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 5){
									var strTotFinal = '       ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 6){
									var strTotFinal = '      ' + parseFloat(total).toFixed(2);
								}else if(numTotFinal == 7){
									var strTotFinal = '     ' + parseFloat(total).toFixed(2);
								}

								var absTotalSumas = parseFloat(totalSumas).toFixed(2);
								var totSumasString = absTotalSumas.toString();
								var numTotSumas = totSumasString.length;

								if(numTotSumas == 4){
									var strSumas = '        ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 5){
									var strSumas = '       ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 6){
									var strSumas = '      ' + parseFloat(totalSumas).toFixed(2);
								}else if(numTotSumas == 7){
									var strSumas = '     ' + parseFloat(totalSumas).toFixed(2);
								}

								var txtLU = numProd+'/'+cantidades;
								while(txtLU.length < 12){
									txtLU = ' ' + txtLU;
								}

								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('  (G) = Gravadas (E) = Exentas').addFeed();
								ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addFeed();
								ticketObj.addFeedUnit(16);
								ticketObj.addTextSize(1, 1);
								ticketObj.addText('        LINEAS/UNIDADES:  ' + txtLU + '').addFeed();
								ticketObj.addText('                  SUMAS: $' + strSumas + '').addFeed();
								if(parseFloat(absTotalDesc).toFixed(2) != 0){
									ticketObj.addText('            -DESCUENTOS: $' + strTotalDesc +'').addFeed();
								}
								ticketObj.addText('          TOTAL GRAVADO: $' + strGranTotal +'').addFeed();
								ticketObj.addText('           TOTAL EXENTO: $' + strTotalExent +'').addFeed();
								
								ticketObj.addTextStyle(false, false, true).addText('                  TOTAL: $').addTextStyle(false, true, true).addText(strTotFinal +'').addFeed().addTextStyle(false, false, false);

								var totalPagado = 0;
								for(var jdx in data.detallePagos){
									var deg = data.detallePagos[jdx];

									while(deg['namePago'].length < 23){
										deg['namePago'] = ' ' + deg['namePago'];
									}

									var absTotalFin = parseFloat(Math.abs(deg['valor'])).toFixed(2);
									var totFinalString = absTotalFin.toString();
									var numTotFinal = totFinalString.length;

									if(numTotFinal == 4){
										var strTotFinal = '        ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 5){
										var strTotFinal = '       ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 6){
										var strTotFinal = '      ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}else if(numTotFinal == 7){
										var strTotFinal = '     ' + parseFloat(Math.abs(deg['valor'])).toFixed(2);
									}
									
									var cancelado = Math.abs(deg['valor']);
									totalPagado = parseFloat(totalPagado) + parseFloat(cancelado);

									ticketObj.addText(deg['namePago'].toUpperCase() + ': $' + strTotFinal + '').addFeed();

								}
								
								var totalVuelto = parseFloat(total).toFixed(2) - parseFloat(totalPagado).toFixed(2);
								var absTotalVuelto = parseFloat(totalVuelto).toFixed(2);
								var totVueltoString = absTotalVuelto.toString();

								while(totVueltoString.length < 12){
									totVueltoString = ' ' + totVueltoString;
								}
								if(parseFloat(totalVuelto).toFixed(2) != 0){
									ticketObj.addText('                 VUELTO: $' + totVueltoString +'').addFeed();
								}
								ticketObj.addFeed();
								ticketObj.addText('_________________________________________').addFeed();
								ticketObj.addTextSize(1, 1);

								var fecha = new Date();
								var anio = fecha.getFullYear();
								var mes = fecha.getMonth() + 1;
								var dia = fecha.getDate();

								var hours = fecha.getHours();
								var minutes = fecha.getMinutes();
								var seconds = fecha.getSeconds();
								var ampm = hours >= 12 ? 'PM' : 'AM';

								hours = hours % 12;
								hours = hours ? hours : 12; // the hour '0' should be '12'
								minutes = minutes < 10 ? '0'+minutes : minutes;
								var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
								ticketObj.addFeed();
								ticketObj.addTextStyle(false, true, true).addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ESTIMADO CLIENTE:').addFeed();
								ticketObj.addTextStyle(false, false, false).addTextAlign(ticketObj.ALIGN_LEFT);
								ticketObj.addText('Para servirle  mejor  exija  y  revise  su');
								ticketObj.addText('tiquete. Si  difiere de su  consumo  favor');
								ticketObj.addText('notificar a ').addTextStyle(false, false, true).addText('themoustachesv@gmail.com').addTextStyle(false, false, false).addText('  y su');
								ticketObj.addText('cuenta será gratis.').addTextStyle(false, false, true).addFeed().addText('Atte. La Gerencia.');
								ticketObj.addTextStyle(false, false, false);
								ticketObj.addFeed();
								ticketObj.addText('_________________________________________').addFeed().addFeed();
								ticketObj.addTextStyle(false, false, false);
								ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
								ticketObj.addText('ATENDIDO POR').addFeed();
								ticketObj.addText(data.namevendedor.toUpperCase() + '').addFeed();
								ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
								ticketObj.addText('GRACIAS POR SU COMPRA').addFeed();

								ticketObj.addFeedLine(5);
								// append paper cutting
								ticketObj.addCut();
                                
                                if(efectivopago == 1){
                                    ticketObj.addPulse();
                                }
                                
								// create print object
								var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
								var epos = new epson.ePOSPrint(url);

								// register callback function
								epos.onreceive = function (res){
									// close print dialog
									//$('#print').dialog('close');
									// print failure
									if (!res.success) {
										// show error message
										//$('#receive').dialog('open');
									}
								}

								// register callback function
								epos.onerror = function (err) {
									// close print dialog
									//$('#print').dialog('close');
									// show error message
									//$('#error').dialog('open');
								}
								// send
								epos.send(ticketObj.toString());
								setTimeout(function(){ window.close(); }, 1000);
							}
						});
				</script>
				";
		}
		
		function book01($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<br><br><br><table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:21%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Tipo de Operación</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Del Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Al Número</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:50%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">No Sujetas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Exentas</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Gravadas Locales</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:10.5px;">Exportaciones</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:11px;">Totales</th>
                </tr></thead>
                <tbody></tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    $exento=0;
                    $gravado=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan+$vn->valtax1;
                    }else{
                        $gravado = $vn->valventan+$vn->valtax1;
                    }
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_total+= $vn->valventan+$vn->valtax1;
                    $dia = date_format(date_create($vn->fecha),'d');

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$dia.'</td>
                        <td style="width:21%;text-align:left; font-size:9px;">'.strtoupper($vn->tipodoc).'</td>
                        <td style="width:12%;text-align:right; font-size:9px;">'.$vn->primero.'</td>
                        <td style="width:12%;text-align:right; font-size:9px;">'.$vn->ultimo.'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.number_format(round($vn->valventan+$vn->valtax1, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;"></td>
                        <td style="width:21%;text-align:left; font-size:9px;"></td>
                        <td style="width:12%;text-align:center; font-size:9px;"></td>
                        <td style="width:12%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="9"><br><br><br></td></tr>';
                
                 $estructura.='<tr>
                    <td colspan="3" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>
                    <td colspan="6"></td>
                 </tr>';
                
                $estructura.='</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book02($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                    <tr><td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('descrip').'</td><td colspan="2" style="text-align:right;font-size:14px;width:60%;">N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label></td></tr>
                    
                    
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Lanscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<br><br><table>';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:32%; font-weight:bold; text-align:center; font-size:12px;" colspan="4">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $ventas = $this->iva_model->getVentas($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    $sum_total+= $vn->valventan+$vn->valtax1;

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$vn->namecliente.'</td>
                        <td style="width:10%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.number_format(round($vn->valventan+$vn->valtax1, 2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 2),2).'</td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                 $estructura.='<tr>
                    <td colspan="3" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:12px;">'.$nombre_contador.'</td>
                    <td colspan="6"></td>
                 </tr><tr>
                    <td colspan="3" style="text-align:center;font-size:11px;">Contador</td>
                    <td colspan="6"></td>
                 </tr>';
                
                $estructura.='</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function book01t($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('P', 'LETTER');
                $estructura = '<br><br><br><table style="border-collapse: separate;border-spacing: 10px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $sum_exento=0;
                $sum_gravado=0;
                $sum_total=0;
                $sum_ivae=0;
                $sum_ivag=0;
                $sum_dev_exento =0;
                $sum_dev_gravado =0;
                $ventas = $this->iva_model->getVentasReporteT($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    if($vn->exento==1){
                        if($vn->inopera==-1){
                            $sum_exento+=$vn->valventan;
                            $sum_ivae+=$vn->valtax1;
                        }else{
                            $sum_dev_exento+=$vn->valventan;
                        }
                    }else{
                        if($vn->inopera==-1){
                            $sum_gravado+=$vn->valventan;
                            $sum_ivag+=$vn->valtax1;
                        }else{
                            $sum_dev_gravado+=$vn->valventan;
                        }
                        
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado+$sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento+$sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                $estructura.='<hr style="width:100%;"><br><hr style="width:100%;">';
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_ivag+$sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento+$sum_ivag+$sum_ivae, 2),2).'</td>
                </tr>';
                
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        } 
        
        function book02t($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'A4', true, 'UTF-8', false);  

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Contribuyentes');
                $pdf->SetSubject('Libro de Ventas Contribuyentes');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
              
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM );
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%"></th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                
                
                
                $header = '
                <table>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td style="text-align:right;font-size:15px;width:40%;">N.I.T.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td><td style="width:20%;"></td><td style="text-align:left;font-size:15px;width:40%;">N.R.C.:    <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"></td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:16px; ">CALCULO DE DEBITO FISCAL</td></tr>
               </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Landscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $this->load->model('global_model');
                
                $pdf->addPage('L', 'LETTER');
                $estructura = '<br><br><br><table style="border-collapse: separate;border-spacing: 10px;">';
                $estructura .= '<thead>
                    <tr>
                        <th style="width: 35%;" ></th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                        <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>';
                
                $ventas = $this->iva_model->getVentasReporteCT($fechaini, $fechafin, $idcentro, $formatos);
                
                $cf_sum_exento=0;
                $cf_sum_gravado=0;
                $cf_sum_total=0;
                $cf_sum_ivae=0;
                $cf_sum_ivag=0;
                $cf_sum_dev_g=0;
                $cf_sum_dev_e=0;
                
                $c_sum_exento=0;
                $c_sum_gravado=0;
                $c_sum_total=0;
                $c_sum_ivae=0;
                $c_sum_ivag=0;
                $c_sum_dev_g=0;
                $c_sum_dev_e=0;
                
                foreach($ventas as $vn){
                    if($vn->ivabook==1){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $cf_sum_exento+=$vn->valventan;
                                $cf_sum_ivae+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            if($vn->inopera==-1){
                                $cf_sum_gravado+=$vn->valventan;
                                $cf_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }else if($vn->ivabook==2){
                        if($vn->exento==1){
                            if($vn->inopera==-1){
                                $c_sum_exento+=$vn->valventan;
                                $c_sum_ivae+=$vn->valtax1;
                            }else{
                                $c_sum_dev_e+=$vn->valventan;
                            }
                        }else{
                            
                            if($vn->inopera==-1){
                                $c_sum_gravado+=$vn->valventan;
                                $c_sum_ivag+=$vn->valtax1;
                            }else{
                                $cf_sum_dev_g+=$vn->valventan;
                            }
                        }
                    }
                }
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_gravado+$c_sum_ivag, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($c_sum_exento+$c_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
                $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>';
                
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_g, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivag, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_gravado+$cf_sum_dev_g+$cf_sum_ivag, 2),2).'</td>


                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($cf_sum_exento+$cf_sum_dev_e+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                $estructura.=' <tr>
                    <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                
               $estructura.='<tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>';
                
                
                $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($cf_sum_dev_g+$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$c_sum_exento+$cf_sum_gravado+$cf_sum_exento-$cf_sum_dev_g-$cf_sum_dev_e, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($c_sum_gravado+$cf_sum_gravado+$c_sum_exento+$cf_sum_exento+$cf_sum_dev_g+$cf_sum_dev_e+$c_sum_ivag+$c_sum_ivae+$cf_sum_ivag+$cf_sum_ivae, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.=' <tr style="border-top: 1px double black;">
                    <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                    <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round(0, 2),2).'</td>
                </tr>';
                 $estructura.='
                 <tr><td colspan="6"><br><br><br><br></td></tr>
                 <tr>
                    <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                    <td colspan="4"></td>
                 </tr><tr>
                    <td colspan="2" style="text-align:center;font-size:12px;">'.$nombre_contador.'<br>Contador</td>
                    <td colspan="4"></td>
                 </tr>';
                $estructura.='</table>';

                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function creditoFiscal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
			}else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Credito Fiscal');
                $pdf->SetSubject('Credito Fiscal');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
				
                $pdf->SetAutoPageBreak(TRUE, 0);
				$pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P',$pagelayout);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
				
				$giro = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$nrf = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcps = $info->idcps;
				}
				
				$infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
				foreach($infoGzips as $infg){
					$departamento = trim($infg->depto);
					$municipio = trim($infg->municipio);
				}
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:12%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:37%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:2%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 15px; width:39%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:12%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:37%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:11%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 15px; width:39%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:12.5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:85%; padding-top:10px;">SAN SALVADOR'.$info->direccion.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 0px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:15%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:20%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:14%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:47%;">'.$departamento.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:7.3%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:19%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:2%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:16.5%;">'.$info->nrc.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:32%; padding-top:10px;">'.$info->giro.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 9px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:49%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:4%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:32%; padding-top:10px;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 3px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 16px; width:100%;"><br><br></td>
					</tr>';
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0;
				$vnGravada = 0; $numProd = 0;
				
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						
						}else if($pro->tax1 != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tax1== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tax1 == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
						$nombrepro = substr($pro->descrip, 0, 38);
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;">  '.$pro->idproducto.' '.$nombrepro.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.number_format(round($pro->precioneto, 4), 4 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
				}
				
				//for($i=$numProd; $i<$maxlines; $i++){
				for($i=$numProd; $i<20; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"><br></td>
						</tr>';
				}
				$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 25px; width:100%;"></td>
					</tr>';
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 4), 4 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$totalGravIva = $totalGravado + $totalIVA;
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:11%;"></td>
						<td rowspan="13" style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:26%;"><br>'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:12%;">$'.number_format(round($totalGravado, 4), 4 ,'.','').'</td>
					</tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 4px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 4px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"> 13%</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($totalIVA, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 5px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($totalGravIva, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 5px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 5px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 5px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 5px; width:12%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:11%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:12%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("CreditoFiscal".$trannum.".pdf");
				// force print dialog
				//$js = 'print(true);';

				// set javascript
				//$pdf->IncludeJS($js);
                $pdf->Output($nombre_archivo, 'I');
			}
        
        }
        
        function print_etiquetas($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Etiquetas');
                $pdf->SetSubject('Etiquetas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 16, 0);
                $pdf->SetAutoPageBreak(TRUE,10);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
                $cant = 0;
                
				$this->load->model('global_model'); $this->load->model('compras_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
                $productos = $this->compras_model->getProductosCompraOrderByName($trannum);
                $cantidades  = $this->session->userdata('cantidades'); 
                $cant_selected = explode(",", $cantidades,-1);  
                $estructura = '<table style="width:100%;">';
                $num_rows=0;
                $alto = 10.5;
                foreach($productos as $pro){
                    $actual=0;
                    foreach($cant_selected as $cl){
                        $datos_pro = explode("*", $cl);
                        if($datos_pro[0]==$pro->idproducto){
                            if($datos_pro[1]>0){
                                $cant_etiquetas=$datos_pro[1];
                                $cant_et=0;
                                do{
                                    $cant_et++;
                                    if($cant==0){
                                        if($num_rows==20){
                                            $estructura .= '
                                            <tr style="padding:0px;margin:0px;" nobr="true">
                                            <td style="padding:0px;margin:0px;width:25%;">
                                            <table style="padding:0px;margin:0px;">
                                            <tr>
                                            <td style="width:50%;padding:0px;margin:0px;">
                                            <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                            </td>
                                            <td style="width:50%;padding:0px;margin:0px;">
                                            <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                            <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                            </td>
                                            </tr>
                                            </table>
                                            </td>';
                                            $num_rows=0;
                                        }else{
                                            if($num_rows>10){
                                                $alto=9.7;
                                            }else{
                                                $alto=10.5;
                                            }
                                            
                                            if($num_rows==0){
                                                $estructura .= '
                                                <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                </td>
                                                </tr>
                                                </table>
                                                </td>';
                                            }else{
                                                $estructura .= '
                                                <tr style="padding:0px;margin:0px;"><td colspan="4" style="font-size:'.$alto.'px;padding:0px;vertical-align:middle;text-align:center;"><br></td></tr>
                                                <tr style="padding:0px;margin:0px;" nobr="true">
                                                <td style="padding:0px;margin:0px;width:25%;">
                                                <table style="padding:0px;margin:0px;">
                                                <tr>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                                </td>
                                                <td style="width:50%;padding:0px;margin:0px;">
                                                <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                                <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                                </td>
                                                </tr>
                                                </table>
                                                </td>';
                                            }
                                            
                                        }
                                        $cant++;
                                    }else if($cant==1){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td>';
                                        $cant++;
                                    }else if($cant==2){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td>';
                                        $cant++;
                                    }else if($cant==3){
                                        $estructura .= '
                                        <td style="padding:0px;margin:0px;width:25%;">
                                        <table style="padding:0px;margin:0px;">
                                        <tr>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <img style="float:left;text-align:left;" src="'.base_url().'application/controllers/barcode.php?text='.$pro->idproducto.'&size=30&width=80&orientation=horizontal&codetype=code128">
                                        </td>
                                        <td style="width:50%;padding:0px;margin:0px;">
                                        <label style="text-align:right;font-size:12px;float:right; font-weight:bold;padding:0px;color:#CC0000;">$'.number_format($pro->precioventa, 2, '.', '').'</label>
                                        <br><label style="text-align:left;font-size:9px;float:left; padding:0px;">['.$pro->idproducto.'] '.trim($pro->modelo).'</label>
                                        </td>
                                        </tr>
                                        </table>
                                        </td></tr>';
                                        $cant=0;
                                        $num_rows++;
                                    }
                                    $actual++;
                                }while($cant_etiquetas!=$cant_et);    
                            }        
                        }
                    }
                }    
                if($cant!=0){
                    while($cant<=3){
                        $estructura .= '<td style="text-align:left;width:25%;"></td>';
                        $cant++;
                    }
                    $estructura .= '</tr>';
                }
                $estructura .= '</table>';
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Etiquetas.pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            }
        }
		
		function reporteCorteX($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				$nuevo_numerox = $this->ventas_model->updateNumeroCorteX($idcaja);
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							ticketObj.addPulse();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function reporteCorteZFacturaz($fechaactual,$idcentro,$idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$numero_x = $caja->numx;
					$numero_z = $caja->numz;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentasZ($numero_z, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentasZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
				}
				
				$this->ventas_model->updateCierreDeCaja($idcentro, $idcaja);
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
					ticketObj.addPulse();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function imprimirApertura($fechaactual, $idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
				$this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
					$fondocaja = $caja->cajafondo;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
					<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
					<script src='".base_url()."js/epos-print-5.0.0.js'></script>
					<script src='".base_url()."js/barcode.js'></script>

					<script type='text/javascript'>
						//var datosprinter = data.datos_print.split('/');
						var ipaddr = '".$datospr[0]."';
						var devid = '".$datospr[1]."';
						var timeout = '60000';
						var grayscale = false;
						var layout = false;
						
						var fecha = new Date();
						var anio = fecha.getFullYear();
						var mes = fecha.getMonth() + 1;
						var dia = fecha.getDate();
						
						var hours = fecha.getHours();
						var minutes = fecha.getMinutes();
						var seconds = fecha.getSeconds();
						var ampm = hours >= 12 ? 'PM' : 'AM';
						
						hours = hours % 12;
						hours = hours ? hours : 12; // the hour '0' should be '12'
						minutes = minutes < 10 ? '0'+minutes : minutes;
						var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
						
						var ticketObj = new epson.ePOSBuilder();
						if(layout){
							ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
						}
						
						ticketObj.addTextLang('es').addTextSmooth(true);
						ticketObj.addFeedLine(1);
						ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
						ticketObj.addTextSize(1, 2);
						ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
						ticketObj.addTextSize(1, 1);
						ticketObj.addFeed();
						ticketObj.addText('".$namecaja."');
						ticketObj.addFeed();
						ticketObj.addText('".$namecentro."');
						ticketObj.addFeed();
						ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
						ticketObj.addFeed();
						ticketObj.addText('Giro: ".$GIRO."');						
						ticketObj.addFeed();
						ticketObj.addText('IVA D.L. N° 296');
						ticketObj.addFeed().addFeed();
						ticketObj.addTextSize(1, 2).addText('APERTURA DE CAJA').addFeed();
						ticketObj.addText('".$fechaCorte." ' + strTime).addTextSize(1, 1);
						ticketObj.addFeed().addFeed();
						ticketObj.addText('CAJERO: ".$this->session->userdata('userLog')."').addFeed();
						ticketObj.addText('FONDO: $".number_format($fondocaja, 2, '.', '')."').addFeed().addFeed();
						ticketObj.addText('SE APERTURO CAJA').addFeed();
						ticketObj.addFeedLine(4);
						
						ticketObj.addCut();
						ticketObj.addPulse();
						
						var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
						var epos = new epson.ePOSPrint(url);
						epos.send(ticketObj.toString());
						
						setTimeout(function(){ window.close();}, 1500);
					</script>";
				
				echo $script;
			}
					
		}
		
		function impresionCorteXPruebas($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX2('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.55';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
									$totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
									$totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->fechahora);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteX($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				
				$documentos = $this->ventas_model->getTiposDocumentosVentasX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteX('VN', $idcentro, $idcaja, $fechaactual, $numero_x, $numero_z);
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					var ticketObj = new epson.ePOSBuilder();
								
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE X N° ".$numero_x."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth() + 1;
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0; $numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0; $subtotal=0;
					$subtotalex = 0; $subtotalgr = 0;
					$subtotaliv = 0; $t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0; $totalGravado = 0; $totalExento = 0;
							$totalIVA = 0; $invexento = $ven->exento;
							
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++; $numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
		
					$script .= "var numCantidad = ".$numInicial.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numInicial."';
							}else if(numTotal == 2){
								var newString = '         ".$numInicial."';
							}else if(numTotal == 3){
								var newString = '        ".$numInicial."';
							}else if(numTotal == 4){
								var newString = '       ".$numInicial."';
							}else if(numTotal == 5){
								var newString = '      ".$numInicial."';
							}else if(numTotal == 6){
								var newString = '     ".$numInicial."';
							}else if(numTotal == 7){
								var newString = '    ".$numInicial."';
							}else if(numTotal == 8){
								var newString = '   ".$numInicial."';
							}else if(numTotal == 9){
								var newString = '  ".$numInicial."';
							}";

					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numFinal.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numFinal."';
							}else if(numTotal == 2){
								var newString = '         ".$numFinal."';
							}else if(numTotal == 3){
								var newString = '        ".$numFinal."';
							}else if(numTotal == 4){
								var newString = '       ".$numFinal."';
							}else if(numTotal == 5){
								var newString = '      ".$numFinal."';
							}else if(numTotal == 6){
								var newString = '     ".$numFinal."';
							}else if(numTotal == 7){
								var newString = '    ".$numFinal."';
							}else if(numTotal == 8){
								var newString = '   ".$numFinal."';
							}else if(numTotal == 9){
								var newString = '  ".$numFinal."';
							}";

					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";

					$script .= "var numCantidad = ".$numdoc.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdoc."';
							}else if(numTotal == 2){
								var newString = '         ".$numdoc."';
							}else if(numTotal == 3){
								var newString = '        ".$numdoc."';
							}else if(numTotal == 4){
								var newString = '       ".$numdoc."';
							}else if(numTotal == 5){
								var newString = '      ".$numdoc."';
							}else if(numTotal == 6){
								var newString = '     ".$numdoc."';
							}else if(numTotal == 7){
								var newString = '    ".$numdoc."';
							}else if(numTotal == 8){
								var newString = '   ".$numdoc."';
							}else if(numTotal == 9){
								var newString = '  ".$numdoc."';
							}";

					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalex, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalex, 2),2)."';
							}";

					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotalgr, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotalgr, 2),2)."';
							}";

					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotaliv, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotaliv, 2),2)."';
							}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($subtotal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($subtotal, 2),2)."';
							}";

					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			

					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
				}

				$script .= "ticketObj.addText('    Totales:').addFeed();";

				$script .= "var numCantidad = ".$numdocg.";
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '          ".$numdocg."';
							}else if(numTotal == 2){
								var newString = '         ".$numdocg."';
							}else if(numTotal == 3){
								var newString = '        ".$numdocg."';
							}else if(numTotal == 4){
								var newString = '       ".$numdocg."';
							}else if(numTotal == 5){
								var newString = '      ".$numdocg."';
							}else if(numTotal == 6){
								var newString = '     ".$numdocg."';
							}else if(numTotal == 7){
								var newString = '    ".$numdocg."';
							}else if(numTotal == 8){
								var newString = '   ".$numdocg."';
							}else if(numTotal == 9){
								var newString = '  ".$numdocg."';
							}";

				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalexglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalexglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
							}";
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";

				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalivglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalivglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";

				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($totalglobal, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($totalglobal, 2),2)."';
							}";

				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";

				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				$total_ing_sum=0;
				$l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}

				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
							var totalString = numCantidad.toString();
							var numTotal = totalString.length;

							if(numTotal == 1){
								var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 2){
								var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 3){
								var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 4){
								var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 5){
								var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 6){
								var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 7){
								var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 8){
								var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
							}else if(numTotal == 9){
								var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
							}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteXZ($idcentro, $idcaja, $numero_x, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
					$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
					$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteX($idcentro, $idcaja, $numero_x, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
							ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
							ticketObj.addFeedLine(2);
							ticketObj.addText('F.________________________________________').addFeed();
							ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
							ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addText('_________________________________________').addFeed();
							ticketObj.addFeedLine(2);
							
							ticketObj.addCut();
							
							var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
							var epos = new epson.ePOSPrint(url);

							epos.send(ticketObj.toString());
							setTimeout(function(){ window.close();}, 1500);
						</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteZPruebas($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
                
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ2('VN', $idcentro, $idcaja, $fechaactual, $numero_z);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '192.168.1.55';
					var devid = 'local_printer';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentasZ($numero_z, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentasZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
		
		function impresionCorteZ($fechaactual, $idcentro, $idcaja, $numero_x, $numero_z){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->model('ventas_model');
                $this->load->model('global_model');
				$this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRF = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				
				$namecentro = $this->sucursal_model->getNameCentro($idcentro);
				$datoscaja = $this->caja_model->getNameCaja($idcaja);
				
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
				
				$datosprint = $this->ventas_model->getDatosPrinter($idcaja);
				$datospr = explode("/", $datosprint);
				$documentos = $this->ventas_model->tipos_doc_ventas_cortez('VN', $idcentro, $idcaja, $fechaactual);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradasCorteZ('VN', $idcentro, $idcaja, $fechaactual);
				
				$fechaCorte = date_format(date_create($fechaactual), 'd/m/Y');
				
				$cnt = 0;
				$valpag = array();
				
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
				
				$script = "
				<script src='".base_url()."js/js_devexpress/jquery-3.1.0.min.js'></script>
				<script src='".base_url()."js/epos-print-5.0.0.js'></script>
				<script src='".base_url()."js/barcode.js'></script>
				
				<script type='text/javascript'>
					//var datosprinter = data.datos_print.split('/');
					var ipaddr = '".$datospr[0]."';
					var devid = '".$datospr[1]."';
					var timeout = '60000';
					var grayscale = false;
					var layout = false;
						
					// create print data builder object
					var ticketObj = new epson.ePOSBuilder();
								
					// paper layout
					if(layout){
						ticketObj.addLayout(ticketObj.LAYOUT_RECEIPT, 580);
					}
					// initialize (ank mode, smoothing)
					ticketObj.addTextLang('es').addTextSmooth(true);
					ticketObj.addFeedLine(1);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addTextSize(1, 2);
					ticketObj.addTextStyle(false, false, 'bold').addText('".$RazonSocial."').addTextStyle(false, false, false);
					ticketObj.addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('".$namecaja."');
					ticketObj.addFeed();
					ticketObj.addText('".$namecentro."');
					ticketObj.addFeed();
					ticketObj.addText('NRC: ".$NRF." NIT: ".$NIT."');
					ticketObj.addFeed();
					ticketObj.addText('Giro: ".$GIRO."');						
					ticketObj.addFeed();
					ticketObj.addText('IVA D.L. N° 296');
					ticketObj.addFeed().addFeed();
					ticketObj.addTextSize(1, 2).addText('CORTE Z N° ".$numero_z."').addFeed();
					ticketObj.addText('".$fechaCorte."').addTextSize(1, 1);
					ticketObj.addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addTextAlign(ticketObj.ALIGN_LEFT);
								
					var fecha = new Date();
					var anio = fecha.getFullYear();
					var mes = fecha.getMonth();
					var dia = fecha.getDate();

					var hours = fecha.getHours();
					var minutes = fecha.getMinutes();
					var seconds = fecha.getSeconds();
					var ampm = hours >= 12 ? 'PM' : 'AM';

					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'
					minutes = minutes < 10 ? '0'+minutes : minutes;
					var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
								
					ticketObj.addTextStyle(false, true, 'bold').addText(' TRANSACCIONES:').addTextStyle(false, false, false).addFeed();";
					
				$subtotal=0; $totalglobal=0; $totalexglobal=0;
				$totalgrglobal=0; $totalivglobal=0; $subtotalex = 0;
				$subtotalgr = 0; $subtotaliv = 0; $numdoc = 0;
				$numdocg = 0;
				
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
					$t = 0;
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('    ".$docs->descrip."').addTextStyle(false, false, false).addFeed();";
					
					foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							if($t == 0){
								$numInicial = $ven->numero;
							}
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentas($ven->trannum);
								foreach($pagos as $money){
									if($tip->cajclase == $money->cajclase){
										if($money->valor <= 0){
											$moneyvalor = abs(number_format(round($money->valor, 2),2));
										}else{
											$moneyvalor = abs(number_format(round($money->valor, 2),2)) * -1;
										}
										
										$valpag[$tip->cajclase] = $valpag[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
										$valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + ($moneyvalor - abs($money->vuelto));
									}
								}
							}
							$numdoc++;
							$numdocg++;
							$numFinal = $ven->numero;
							$t++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$script .= "var numCantidad = ".$numInicial.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numInicial."';
						}else if(numTotal == 2){
							var newString = '         ".$numInicial."';
						}else if(numTotal == 3){
							var newString = '        ".$numInicial."';
						}else if(numTotal == 4){
							var newString = '       ".$numInicial."';
						}else if(numTotal == 5){
							var newString = '      ".$numInicial."';
						}else if(numTotal == 6){
							var newString = '     ".$numInicial."';
						}else if(numTotal == 7){
							var newString = '    ".$numInicial."';
						}else if(numTotal == 8){
							var newString = '   ".$numInicial."';
						}else if(numTotal == 9){
							var newString = '  ".$numInicial."';
						}";
						
					$script .= "ticketObj.addText('                    Del:' + newString).addFeed();";
		
					$script .= "var numCantidad = ".$numFinal.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numFinal."';
						}else if(numTotal == 2){
							var newString = '         ".$numFinal."';
						}else if(numTotal == 3){
							var newString = '        ".$numFinal."';
						}else if(numTotal == 4){
							var newString = '       ".$numFinal."';
						}else if(numTotal == 5){
							var newString = '      ".$numFinal."';
						}else if(numTotal == 6){
							var newString = '     ".$numFinal."';
						}else if(numTotal == 7){
							var newString = '    ".$numFinal."';
						}else if(numTotal == 8){
							var newString = '   ".$numFinal."';
						}else if(numTotal == 9){
							var newString = '  ".$numFinal."';
						}";
					
					$script .= "ticketObj.addText('                     Al:' + newString).addFeed();";
					
					$script .= "var numCantidad = ".$numdoc.";
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '          ".$numdoc."';
						}else if(numTotal == 2){
							var newString = '         ".$numdoc."';
						}else if(numTotal == 3){
							var newString = '        ".$numdoc."';
						}else if(numTotal == 4){
							var newString = '       ".$numdoc."';
						}else if(numTotal == 5){
							var newString = '      ".$numdoc."';
						}else if(numTotal == 6){
							var newString = '     ".$numdoc."';
						}else if(numTotal == 7){
							var newString = '    ".$numdoc."';
						}else if(numTotal == 8){
							var newString = '   ".$numdoc."';
						}else if(numTotal == 9){
							var newString = '  ".$numdoc."';
						}";
					
					$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalex, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalex, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalex, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotalgr, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotalgr, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotalgr, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
					
					$script .= "var numCantidad = parseFloat('".number_format(round($subtotaliv, 2),2)."').toFixed(2);
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotaliv, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotaliv, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					
					$script .= "var numCantidad = '".number_format(round($subtotal, 2),2)."';
						var totalString = numCantidad.toString();
						var numTotal = totalString.length;
						
						if(numTotal == 1){
							var newString = '         $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 2){
							var newString = '        $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 3){
							var newString = '       $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 4){
							var newString = '      $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 5){
							var newString = '     $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 6){
							var newString = '    $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 7){
							var newString = '   $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 8){
							var newString = '  $".number_format(round($subtotal, 2),2)."';
						}else if(numTotal == 9){
							var newString = ' $".number_format(round($subtotal, 2),2)."';
						}";
					
					$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed();";			
					
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
	
				}
				
				$script .= "ticketObj.addText('    Totales:').addFeed();";
				
				$script .= "var numCantidad = ".$numdocg.";
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '          ".$numdocg."';
					}else if(numTotal == 2){
					 	var newString = '         ".$numdocg."';
					}else if(numTotal == 3){
					 	var newString = '        ".$numdocg."';
					}else if(numTotal == 4){
					 	var newString = '       ".$numdocg."';
					}else if(numTotal == 5){
					    var newString = '      ".$numdocg."';
					}else if(numTotal == 6){
						var newString = '     ".$numdocg."';
					}else if(numTotal == 7){
						var newString = '    ".$numdocg."';
					}else if(numTotal == 8){
						var newString = '   ".$numdocg."';
					}else if(numTotal == 9){
						var newString = '  ".$numdocg."';
					}";
				
				$script .= "ticketObj.addText('            Operaciones:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalexglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalexglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalexglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('         Ventas Exentas:' + newString).addFeed();";
				
				$script .= "var numCantidad = parseFloat('".number_format(round($totalgrglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalgrglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalgrglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('        Ventas Gravadas:' + newString).addFeed();";
		
				$script .= "var numCantidad = parseFloat('".number_format(round($totalivglobal, 2),2)."').toFixed(2);
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalivglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalivglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                    IVA:').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
				
				$script .= "var numCantidad = '".number_format(round($totalglobal, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($totalglobal, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($totalglobal, 2),2)."';
					}";
				
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' INGRESOS:').addTextStyle(false, false, false).addFeed();";
				
				$total_ing_sum=0; $l=0;
				foreach($tipospagos as $tip){
					$l++;
				}
				$p=0;
				
				foreach($tipospagos as $tip){
					$script .= "var numCantidad = '".substr($tip->descrip, 0, 20)."';
								var totalString = numCantidad.toString();
								while(totalString.length < 23){
									totalString = ' ' + totalString;
								}
								
								var numPrecio = parseFloat('".number_format(round($valpagG[$tip->cajclase], 2),2)."').toFixed(2);
								var valorString = numPrecio.toString();
								var numTotal = valorString.length;
								
								if(numTotal == 1){
									var newString = '         $' + numPrecio;
								}else if(numTotal == 2){
									var newString = '        $' + numPrecio;
								}else if(numTotal == 3){
									var newString = '       $' + numPrecio;
								}else if(numTotal == 4){
									var newString = '      $' + numPrecio;
								}else if(numTotal == 5){
									var newString = '     $' + numPrecio;
								}else if(numTotal == 6){
									var newString = '    $' + numPrecio;
								}else if(numTotal == 7){
									var newString = '   $' + numPrecio;
								}else if(numTotal == 8){
									var newString = '  $' + numPrecio;
								}else if(numTotal == 9){
									var newString = ' $' + numPrecio;
								}";
					
					if($p == $l - 1){
						$script .= "ticketObj.addText(totalString + ':').addTextStyle(false, true, false).addText(newString).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addText(totalString + ':' + newString).addFeed();";
					}
					
					$total_ing_sum+=round($valpagG[$tip->cajclase], 2);
					$p++;
				}
				
				$script .= "var numCantidad = '".number_format(round($total_ing_sum, 2),2)."';
					var totalString = numCantidad.toString();
					var numTotal = totalString.length;

   					if(numTotal == 1){
					 	var newString = '         $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 2){
					 	var newString = '        $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 3){
					 	var newString = '       $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 4){
					 	var newString = '      $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 5){
					    var newString = '     $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 6){
						var newString = '    $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 7){
						var newString = '   $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 8){
						var newString = '  $".number_format(round($total_ing_sum, 2),2)."';
					}else if(numTotal == 9){
						var newString = ' $".number_format(round($total_ing_sum, 2),2)."';
					}";
		
				$script .= "ticketObj.addText('                  Sumas:').addTextStyle(false, false, true).addText(newString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' VENTAS POR DEPARTAMENTO:').addTextStyle(false, false, false).addFeed();";
				
				$datosResumen = $this->ventas_model->getListadoResumenVentasZ($numero_z, $idcentro, $idcaja);
				$datosLineas = $this->ventas_model->getListadoLineasResumenVentasZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosLineas as $inLin){
					$j=0; $totalLinea=0;
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalLinea = $totalLinea + number_format(round($inRes->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inLin->descrip, 0, 20)." (".$inLin->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalLinea,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inLin->descrip, 0, 30)." (".$inLin->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($datosResumen as $inRes){
						if($inLin->idcatalogo == $inRes->idcatalogo){
							$totalFinal = $totalFinal + number_format(round($inRes->Promedio, 2),2);
							$prePromedio = $inRes->Promedio / $inRes->total;
							
							$multiTotal = number_format(round($inRes->Promedio, 2),2) * $inRes->total;
							$script .= "var numCantidad = '".substr($inRes->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inRes->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inRes->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ATENCION AL CLIENTE:').addTextStyle(false, false, false).addFeed();";
				
				$datosVendedores = $this->ventas_model->getListadoVendedoresVentasZ($numero_z, $idcentro, $idcaja);
				$produVendedores = $this->ventas_model->getListadoProductosVendedoresZ($numero_z, $idcentro, $idcaja);
				
				$totalFinal=0;
				foreach($datosVendedores as $inVen){
					$j=0; $totalVendedor=0;
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalVendedor = $totalVendedor + number_format(round($inPro->Promedio, 2),2);
							$j++;
						}
					}
					
					if($j != 1){
						$script .= "var numCantidad = '".substr($inVen->descrip, 0, 20)." (".$inVen->total.")';
									var totalString = numCantidad.toString();
									while(totalString.length < 30){
										totalString = totalString + ' ';
									}
										
									var numCantidad2 = '$".number_format($totalVendedor,2)."';
									var totalString2 = numCantidad2.toString();
									while(totalString2.length < 9){
										totalString2 = ' ' + totalString2;
									}";
						
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ' + totalString + '' + totalString2).addTextStyle(false, false, false).addFeed();";
					}else{
						$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('  ".substr($inVen->descrip, 0, 30)." (".$inVen->total.")').addTextStyle(false, false, false).addFeed();";
					}
					
					foreach($produVendedores as $inPro){
						if($inVen->idauxi == $inPro->idworker){
							$totalFinal = $totalFinal + number_format(round($inPro->Promedio, 2),2);
							$prePromedio = $inPro->Promedio / $inPro->total;
							
							$multiTotal = number_format(round($inPro->Promedio, 2),2) * $inPro->total;
							$script .= "var numCantidad = '".substr($inPro->descrip, 0, 15)."';
										var totalString = numCantidad.toString();
										while(totalString.length < 15){
											totalString = totalString + ' ';
										}
										var numCantidad2 = '(".$inPro->total.")';
										var totalString2 = numCantidad2.toString();
										while(totalString2.length < 6){
											totalString2 = ' ' + totalString2;
										}
										
										var numCantidad3 = '$".number_format(round($prePromedio, 2),2)."';
										var totalString3 = numCantidad3.toString();
										while(totalString3.length < 8){
											totalString3 = ' ' + totalString3;
										}
										
										var numCantidad4 = '$".number_format(round($inPro->Promedio, 2),2)."';
										var totalString4 = numCantidad4.toString();
										while(totalString4.length < 9){
											totalString4 = ' ' + totalString4;
										}";
							
							$script .= "ticketObj.addText('   ' + totalString + '' + totalString2 + '' + totalString3 + '' + totalString4).addFeed();";
						}
					}
					$script .= "ticketObj.addFeed();";
				}
				
				$script .= "var numCantidad = 'Sumas: $".number_format($totalFinal,2)."';
							var totalString = numCantidad.toString();
							while(totalString.length < 41){
								totalString = ' ' + totalString;
							}";
				
				$script .= "ticketObj.addTextStyle(false, false, 'bold').addText(totalString).addTextStyle(false, false, false).addFeed().addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' CUADRE DE CAJA:').addTextStyle(false, false, false).addFeed();";
				
				$infoCuadre = $this->ventas_model->getInformacionCorteFinalZ($idcentro, $idcaja, $numero_z);
				
				$totalSistema = 0;
				$totalCaja = 0;
				
				foreach($infoCuadre as $info){
					$script .= "var numCantidad = '".substr($info->formapago, 0, 25)."';
								var totalString = numCantidad.toString();";
					
					$script .= "var numCantidad2 = '".number_format(round($info->valorsys, 2),2)."';
							var totalString2 = numCantidad2.toString();
							var numTotal2 = totalString2.length;

							if(numTotal2 == 1){
								var newString2 = '         $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 2){
								var newString2 = '        $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 3){
								var newString2 = '       $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 4){
								var newString2 = '      $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 5){
								var newString2 = '     $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 6){
								var newString2 = '    $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 7){
								var newString2 = '   $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 8){
								var newString2 = '  $".number_format(round($info->valorsys, 2),2)."';
							}else if(numTotal2 == 9){
								var newString2 = ' $".number_format(round($info->valorsys, 2),2)."';
							}";
					
					
					$script .= "var numCantidad3 = '".number_format(round($info->valorusr, 2),2)."';
							var totalString3 = numCantidad3.toString();
							var numTotal3 = totalString3.length;

							if(numTotal3 == 1){
								var newString3 = '         $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 2){
								var newString3 = '        $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 3){
								var newString3 = '       $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 4){
								var newString3 = '      $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 5){
								var newString3 = '     $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 6){
								var newString3 = '    $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 7){
								var newString3 = '   $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 8){
								var newString3 = '  $".number_format(round($info->valorusr, 2),2)."';
							}else if(numTotal3 == 9){
								var newString3 = ' $".number_format(round($info->valorusr, 2),2)."';
							}";
					
					$valorSistema = number_format(round($info->valorsys, 2),2);
					$valorCaja = number_format(round($info->valorusr, 2),2);
					
					$totalSistema = $totalSistema + $valorSistema;
					$totalCaja = $totalCaja + $valorCaja;
					
					
					if($valorSistema == 0){
						$diferencia = $valorCaja;
					}else{
						$diferencia = $valorCaja - $valorSistema;
					}
					
					$script .= "var numCantidad4 = '".number_format(round($diferencia, 2),2)."';
							var totalString4 = numCantidad4.toString();
							var numTotal4 = totalString4.length;
							
							
							if(numTotal4 == 1){
								var newString4 = '         $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 2){
								var newString4 = '        $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 3){
								var newString4 = '       $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 4){
								var newString4 = '      $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 5){
								var newString4 = '     $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 6){
								var newString4 = '    $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 7){
								var newString4 = '   $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 8){
								var newString4 = '  $".number_format(round($diferencia, 2),2)."';
							}else if(numTotal4 == 9){
								var newString4 = ' $".number_format(round($diferencia, 2),2)."';
							}";
					
					$script .= "var countSys = '(".$info->countsys.")';
								var stringCount = countSys.toString();
								while(stringCount.length < 5){
									stringCount = ' ' + stringCount;
								}";
					
					$script .= "var countUser = '(".$info->countuser.")';
								var stringCountUser = countUser.toString();
								while(stringCountUser.length < 5){
									stringCountUser = ' ' + stringCountUser;
								}";
					
					if($valorSistema != 0 || $valorCaja != 0){
						$script .= "ticketObj.addTextStyle(false, false, true).addText('   ' + totalString).addTextStyle(false, false, false).addFeed();";
						$script .= "ticketObj.addText('     Sistema:').addText(newString2 + ' ' + stringCount).addFeed();";
						$script .= "ticketObj.addText('        Caja:').addText(newString3 + ' ' + stringCountUser).addTextStyle(false, false, true).addText(newString4).addTextStyle(false, false, false).addFeed().addFeed();";
					}
					
				}
				
				$script .= "var numTotSistema = '".number_format(round($totalSistema, 2),2)."';
							var countString = numTotSistema.toString();
							var numSistema = countString.length;
							
							if(numSistema == 1){
								var valorSistema = '         $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 2){
								var valorSistema = '        $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 3){
								var valorSistema = '       $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 4){
								var valorSistema = '      $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 5){
								var valorSistema = '     $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 6){
								var valorSistema = '    $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 7){
								var valorSistema = '   $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 8){
								var valorSistema = '  $".number_format(round($totalSistema, 2),2)."';
							}else if(numSistema == 9){
								var valorSistema = ' $".number_format(round($totalSistema, 2),2)."';
							}";
				
				$script .= "var numTotCaja = '".number_format(round($totalCaja, 2),2)."';
							var countString = numTotCaja.toString();
							var numCaja = countString.length;
							
							if(numCaja == 1){
								var valorCaja = '         $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 2){
								var valorCaja = '        $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 3){
								var valorCaja = '       $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 4){
								var valorCaja = '      $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 5){
								var valorCaja = '     $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 6){
								var valorCaja = '    $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 7){
								var valorCaja = '   $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 8){
								var valorCaja = '  $".number_format(round($totalCaja, 2),2)."';
							}else if(numCaja == 9){
								var valorCaja = ' $".number_format(round($totalCaja, 2),2)."';
							}";
				
				$totalDiferencia = $totalCaja - $totalSistema;
				
				$script .= "var numTotDif = '".number_format(round($totalDiferencia, 2),2)."';
							var countString = numTotDif.toString();
							var numDif = countString.length;
							
							if(numDif == 1){
								var valorTotDif = '         $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 2){
								var valorTotDif = '        $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 3){
								var valorTotDif = '       $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 4){
								var valorTotDif = '      $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 5){
								var valorTotDif = '     $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 6){
								var valorTotDif = '    $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 7){
								var valorTotDif = '   $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 8){
								var valorTotDif = '  $".number_format(round($totalDiferencia, 2),2)."';
							}else if(numDif == 9){
								var valorTotDif = ' $".number_format(round($totalDiferencia, 2),2)."';
							}";
				
				
				$script .= "ticketObj.addTextStyle(false, false, true).addText('   Resumen:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('                Sistema:').addText(valorSistema).addFeed();";
				$script .= "ticketObj.addText('                   Caja:').addTextStyle(false, true, false).addText(valorCaja).addTextStyle(false, false, false).addFeed();";
				
				if($totalDiferencia > 0){
					$script .= "ticketObj.addText('               Sobrante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia < 0){
					$script .= "ticketObj.addText('               Faltante:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}else if($totalDiferencia == 0){
					$script .= "ticketObj.addText('             Diferencia:').addTextStyle(false, false, true).addText(valorTotDif).addFeed().addFeed();";
				}
				
				$script .= "ticketObj.addTextStyle(false, true, 'bold').addText(' ACTIVIDAD EN CAJA:').addTextStyle(false, false, false).addFeed();";
				$script .= "ticketObj.addText('   Apertura de Gaveta:').addFeed();";
				
				$informacion = $this->ventas_model->getActividadGavetaCorteZ($idcentro, $idcaja, $numero_z);
				
				foreach($informacion as $info){
					$fechahora = explode(" ", $info->ingresa);
					$hora = explode(":", $fechahora[1]);
					
					
					$script .= "var hours = ".$hora['0'].";
								var minutes = ".$hora['1'].";
								var seconds = ".$hora['2'].";
								var ampm = hours >= 12 ? 'PM' : 'AM';
								
								hours = hours % 12;
								hours = hours ? hours : 12;
								minutes = minutes < 10 ? '0'+minutes : minutes;
								
								var counthours = hours;
								var stringhours = counthours.toString();
								while(stringhours.length < 2){
									stringhours = ' ' + stringhours;
								}
								
								var countmin = minutes;
								var stringmin = countmin.toString();
								while(stringmin.length < 2){
									stringmin = ' ' + stringmin;
								}
								
								var countsec = seconds;
								var stringsec = countsec.toString();
								while(stringsec.length < 2){
									stringsec = ' ' + stringsec;
								}
								
								var hora_apertura = stringhours + ':' + stringmin + ':' + stringsec + ' ' + ampm;";
					
					$script .= "ticketObj.addTextStyle(false, false, 'bold').addText('   ' + hora_apertura).addTextStyle(false, false, false).addText(' ".substr($info->nameuser, 0, 25)."').addFeed();";
				}
				
				$script .= "ticketObj.addFeed();";
				
				$script .= "ticketObj.addTextStyle(false, false, false);
					ticketObj.addTextAlign(ticketObj.ALIGN_CENTER);
					ticketObj.addFeedLine(2);
					ticketObj.addText('F.________________________________________').addFeed();
					ticketObj.addText('".trim($this->session->userdata('userLog'))."').addFeed();
					ticketObj.addText(dia + '/' + mes + '/' + anio +'  ' + strTime + '').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addText('_________________________________________').addFeed();
					ticketObj.addFeedLine(2);
					
					ticketObj.addCut();
								
					var url = 'http://' + ipaddr + '/cgi-bin/epos/service.cgi?devid=' + devid + '&timeout=' + timeout;
					var epos = new epson.ePOSPrint(url);

					epos.send(ticketObj.toString());
					setTimeout(function(){ window.close();}, 1500);
				</script>";
				
				echo $script;
			}
		}
        
        function comp_inv($tipopro,$idcentro,$aniomes){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comprobación de Inventario');
                $pdf->SetSubject('Comprobación de Inventario');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
				
                $fecha = explode("_", $aniomes);
                $anio = $fecha[0];
                $mes = $fecha[1];
                $mes_letras = "";
                switch(round($mes)){
                        case 1:
                            $mes_letras  = "Enero";
                            break;
                        case 2:
                            $mes_letras  = "Febrero";
                            break;
                        case 3:
                            $mes_letras  = "Marzo";
                            break;
                        case 4:
                            $mes_letras  = "Abril";
                            break;
                        case 5:
                            $mes_letras  = "Mayo";
                            break;
                        case 6:
                            $mes_letras  = "Junio";
                            break;
                        case 7:
                            $mes_letras  = "Julio";
                            break;
                        case 8:
                            $mes_letras  = "Agosto";
                            break;
                        case 9:
                            $mes_letras  = "Septiembre";
                            break;
                        case 10:
                            $mes_letras  = "Octubre";
                            break;
                        case 11:
                            $mes_letras  = "Noviembre";
                            break;
                        case 12:
                            $mes_letras  = "Diciembre";
                            break;
                        default:
                            $mes_letras  = "-";
                            break;
                    }
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).'<br>'.strtoupper($mes_letras).'/'.$anio.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
                $titulo ='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Código</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:left; font-weight: bold;">Descripción</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">UM</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Saldo Inicial</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Compras</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Ajustes +/-</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Inventario Disponible</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Venta</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:center; font-weight: bold;">Inventario Final</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:right; font-weight: bold;">Costo Unitario</th>
                    <th style="border-bottom: 1px solid black;font-size:10px; text-align:right; font-weight: bold;">Costo Total</th>';
                $titulo .='</tr>
                </thead>
                <tbody>';
                $info = $this->invtran_model->getComprobacionInv($tipopro,$idcentro,$anio,$mes);
                $categorias = $this->invtran_model->getCategoriasInv($tipopro,$idcentro,$anio,$mes);
                $lineas = $this->invtran_model->getLineasInv($tipopro,$idcentro,$anio,$mes);
                $tot_saldo_lineas = 0;
                $tot_compras_lineas = 0;
                $tot_ajustes_lineas = 0;
                $tot_invdisponible_lineas = 0;
                $tot_venta_lineas = 0;
                $tot_invfinal_lineas = 0;
                $tot_costouni_lineas = 0;
                $tot_costotot_lineas = 0;
                    
                foreach($categorias as $cat){
                    $sum_saldo_lineas = 0;
                    $sum_compras_lineas = 0;
                    $sum_ajustes_lineas = 0;
                    $sum_invdisponible_lineas = 0;
                    $sum_venta_lineas = 0;
                    $sum_invfinal_lineas = 0;
                    $sum_costouni_lineas = 0;
                    $sum_costotot_lineas = 0;
                    $titulo .='
                    <tr>
                    <td colspan="11" style="border-bottom: 1px solid #0B2E59;font-size:12px; text-align:left; font-weight: bold;color:#0B2E59;"><br><br>'.$cat->departamento.'</td>
                    </tr>';
                    foreach($lineas as $lin){
                        $saldo_lineas = 0;
                        $compras_lineas = 0;
                        $ajustes_lineas = 0;
                        $invdisponible_lineas = 0;
                        $venta_lineas = 0;
                        $invfinal_lineas = 0;
                        $costouni_lineas = 0;
                        $costotot_lineas = 0;
                        if($lin->iddepartamento==$cat->iddepartamento){
                            $titulo .='
                            <tr>
                                <td colspan="11" style="border-bottom: 1px solid #0B2E59;font-size:12px; text-align:left; font-weight: normal;color:#0B2E59;"><br>&nbsp;&nbsp;&nbsp;'.$lin->linea.'</td>
                            </tr>';   
                            foreach($info as $in){
                                if($in->idlinea==$lin->idlinea){
                                    $inv_disponible = $in->saldoinicial+$in->compras+$in->ajustes;
                                    $inv_actual = $in->saldoinicial+$in->compras+$in->ajustes+$in->ventas;
                                    $costo_total = $in->costosaldoinicial + $in->costocompras + $in->costoajustes + $in->costoventas;
                                    if($inv_actual!=0){
                                        $costo_unitario = $costo_total / $inv_actual;
                                    }else{
                                        $costo_unitario=0;
                                    }
                                    $titulo .='
                                    <tr>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.$in->idproducto.'</td>
                                    <td style="font-size:10px; text-align:left; font-weight: normal;">'.$in->producto.'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.$in->um.'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->saldoinicial).'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->compras).'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($in->ajustes).'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($inv_disponible).'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round(abs($in->ventas)).'</td>
                                    <td style="font-size:10px; text-align:center; font-weight: normal;">'.round($inv_actual).'</td>
                                    <td style="font-size:10px; text-align:right; font-weight: normal;">$'.number_format($costo_unitario, 2, '.', '').'</td>
                                    <td style="font-size:10px; text-align:right; font-weight: normal;">$'.number_format($costo_total, 2, '.', '').'</td></tr>';     
                                    $saldo_lineas+=round($in->saldoinicial);
                                    $compras_lineas+=round($in->compras);
                                    $ajustes_lineas+=round($in->ajustes);
                                    $invdisponible_lineas+=round($inv_disponible);
                                    $venta_lineas+=round(abs($in->ventas));
                                    $invfinal_lineas+=round($inv_actual);
                                    $costouni_lineas+=$costo_unitario;
                                    $costotot_lineas+=$costo_total;
                                    
                                    $sum_saldo_lineas+=round($in->saldoinicial);
                                    $sum_compras_lineas+=round($in->compras);
                                    $sum_ajustes_lineas+=round($in->ajustes);
                                    $sum_invdisponible_lineas+=round($inv_disponible);
                                    $sum_venta_lineas+=round(abs($in->ventas));
                                    $sum_invfinal_lineas+=round($inv_actual);
                                    $sum_costouni_lineas+=$costo_unitario;
                                    $sum_costotot_lineas+=$costo_total;
                                    
                                    $tot_saldo_lineas+=round($in->saldoinicial);
                                    $tot_compras_lineas+=round($in->compras);
                                    $tot_ajustes_lineas+=round($in->ajustes);
                                    $tot_invdisponible_lineas+=round($inv_disponible);
                                    $tot_venta_lineas+=round(abs($in->ventas));
                                    $tot_invfinal_lineas+=round($inv_actual);
                                    $tot_costouni_lineas+=$costo_unitario;
                                    $tot_costotot_lineas+=$costo_total;
                                }
                            }
                            $titulo .='
                                    <tr>
                                    <td colspan="3" style="font-size:10px; text-align:right; font-weight: bold;">Sub Total '.$lin->linea.'&nbsp;&nbsp;&nbsp;</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($saldo_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($compras_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($ajustes_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($invdisponible_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($venta_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:center; font-weight: bold;">'.round($invfinal_lineas).'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:right; font-weight: bold;">$'.number_format($costouni_lineas, 2, '.', '').'</td>
                                    <td style="border-top: 1px solid #0B2E59;font-size:10px; text-align:right; font-weight: bold;">$'.number_format($costotot_lineas, 2, '.', '').'</td></tr>';     
                        }
                    }
                    $titulo .='
                    <tr>
                    <td colspan="3" style="font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">Sub Total '.$cat->departamento.'&nbsp;&nbsp;&nbsp;</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_saldo_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_compras_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_ajustes_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_invdisponible_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_venta_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;color:#0B2E59;">'.round($sum_invfinal_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">$'.number_format($sum_costouni_lineas, 2, '.', '').'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;color:#0B2E59;">$'.number_format($sum_costotot_lineas, 2, '.', '').'</td></tr>'; 
             
                
                }   
                $titulo .='
                    <tr><td colspan="11"></td></tr>
                    <tr>
                    <td colspan="3" style="border-top: 1px solid black;font-size:12px; text-align:right; font-weight: bold;">TOTALES &nbsp;&nbsp;&nbsp;</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_saldo_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_compras_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_ajustes_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_invdisponible_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_venta_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:center; font-weight: bold;">'.round($tot_invfinal_lineas).'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;">$'.number_format($tot_costouni_lineas, 2, '.', '').'</td>
                    <td style="border-top: 1px solid #0B2E59;font-size:12px; text-align:right; font-weight: bold;">$'.number_format($tot_costotot_lineas, 2, '.', '').'</td></tr>'; 
             
                $titulo.='</tbody></table>';
                        
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Comprobacion_Inventario.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
    }
?>