<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
        
        function __construct(){
            if(session_status() == PHP_SESSION_NONE){
				session_start();
            }
            parent::__construct();
        }
        
        public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
			return $info;
        }
        
        function reporte_producto_sucursal($fecha, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE CONTROL PRODUCCION');
                $pdf->SetSubject('REPORTE CONTROL PRODUCCION');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $header = '     <table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE CONTROL PRODUCCIÓN</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA <strong>'.date_format(date_create($fecha), 'd/m/Y').'</strong></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    </tr>
                                </table><br><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $this->load->model('tpedido_model');
                
                $salas_venta = $this->tpedido_model->getNameSalasdeVenta();
                                                
                $lst_productos = explode("_", $productos);
                $tot = count($lst_productos);
                $total_ = $tot - 1;
                if($total_ >= 12){
                    $tamano = 90 / 12;    
                }else{
                    $tamano = 90 / $total_;    
                }
                
                $pdf->addPage('L', 'LETTER');
                $estructura = ' <table style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th style="background-color:#F0F0F0; color:#FFFFFF; width:10%; height:25px; font-size:14px; text-align:center; vertical-align:middle; border-style:solid; border-width: 1px 1px 1px 1px;"></th>';
                    for($j=0; $j<$total_; $j++){
                        $name = $this->tpedido_model->getNameProducto($lst_productos[$j]);
                        $estructura .= '    <th style="width:'.$tamano.'%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.$name.'</th>';            
                    }                        
                //$estructura .= '            <th style="width:10%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>TOTAL</th>';
                $estructura .= '        </tr>
                                    </thead>';
                
                foreach($salas_venta as $sv){
                    $sum_ = 0;
                    $estructura .=' <tbody>
                                        <tr>
                                            <td style="text-align:left; background-color:#F0F0F0; color:#000000; width:10%; height:35px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>'.$sv->descrip.'</strong></td>';
                        for($j=0; $j<$total_; $j++){
                            $cantidad = $this->tpedido_model->getCantProducto($lst_productos[$j], $fecha, $sv->idcentro);
                            if($cantidad == "0" || $cantidad == ""){
                                $cantidad = "";    
                            }else{
                                $cantidad = round($cantidad);
                            }
                            $estructura .= '<td style="width:'.$tamano.'%; height:35px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>'.$cantidad.'</td>';            
                            $sum_ += $cantidad;
                        }                       
                    $estructura .= '    </tr>';
                }
                $estructura .= '        <tr>
                                            <td style="text-align:center; background-color:#F0F0F0; color:#000000; width:10%; height:30px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>TOTAL</strong></td>';
                for($j=0; $j<$total_; $j++){
                    $sum_total = $this->tpedido_model->getTotalProducto($lst_productos[$j], $fecha);
                    $estructura .= '    <td style="width:'.$tamano.'%; height:30px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#A80000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.round($sum_total).'</td>';
                }
                $estructura .= '        </tr>';
                $estructura .= '    <tbody>    
                                </table>';
                
                $estructura .= '<style>
                                    .sucursales{
                                        color:#000000; 
                                        font-size:11px; 
                                    }
                                </style>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k_modelo($idtrannum);
                $name = $this->variable_model->getIconCuenta();
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Precio</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    $subtotal=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'&nbsp;</td>
                                <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round(abs($key->cantidad)*$key->precioventa, 2),2).'&nbsp;</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                        $subtotal+=round(abs($key->cantidad)*$key->precioventa, 2);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:right; vertical-align:middle; font-size:12px;"><strong>$'.number_format($subtotal,2).'</strong></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 55, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('variable_model');
                $name = $this->variable_model->getIconCuenta();

                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                   $header = '<table style="width:100%;">
                                    <tr>
                                    <td style="width:50%;text-align:left;">
                                        <img style="width:150px; height:70px; text-align:left;float:left;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'">
                                    </td>
                                    
                                    <td style="width:50%;">
                                        <table style="width:100%; text-align:right;">
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                            </tr>
                                            <tr style="font-size:12px; text-align;right;" >
                                                <td style="font-size:12px; text-align;right;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                            </tr>
                                        </table>
                                    </td>
                                    </tr>
                                </table>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:35%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:15%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                
              
                
                
                 $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>RECIBIDA</strong></label></td>
                                    </tr>
                                </table></center><br><br>';
                
                foreach($informacion as $inf){
                
                $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$idrec.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha Ingreso: '.date_format(date_create($inf->fecha), 'd/m/Y').' </strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Referencia Interna:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->descrip.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->referencia.'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Numero de Documento:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Solicitado Por:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->serie.''.$inf->numero.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->solicita.'</td>
                                    </tr>
                                    
                                </tbody>
                    </table><br><br>
                     ';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->preciotran.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">$'.($pro->cantidad * $pro->preciotran ).'</td></tr>';
                           
                    
                }
                
                 $titulo.='
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
         
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);


                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'n');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 6:
                        $mes_name = "Julio";
                        break;
                    case 6:
                        $mes_name = "Agosto";
                        break;
                    case 6:
                        $mes_name = "Septiembre";
                        break;
                    case 6:
                        $mes_name = "Octubre";
                        break;
                    case 6:
                        $mes_name = "Noviembre";
                        break;
                    case 6:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name.", ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        $subtotal = $key->cantidad * $key->precioneto; 
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }

                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $subtotal = $key->cantidad * $key->precioneto; 
                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Proveedor</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Cliente</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px;"><br>Es indispensable presentar esta orden de compra al entregar el producto en nuestra bodega.<br><br></td>
                                    </tr>
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar2();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->vendedorAsignado==$gr->idworker && $i->saldo!=0){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_vendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                //foreach($grupos as $gr){
                    //$titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        //$i->grupo==$gr->grupo and 
                        if(($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                //}
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                       // if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                       // }
                       
                        foreach($lineas_list as $lin){
                            //&& $lin->cant!=0
                            if($lin->idnivel1==$dep->idcatalogo){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporzona($zona, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Zona');
                $pdf->SetSubject('Cartera por Zona');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $zona = str_replace("_", " ", $zona);
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;font-weight:bold;">'.$zona.'<br>Periodo del '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $clientes = $this->arap_model->getClientes_ar_zona($zona);
                $info = $this->arap_model->getCuentas_ar_zona_fechas($zona, $fechaini, $fechafin);
                $total_clientes=0;
                
                foreach($clientes as $client){
                    $departamento="";
                    $municipio="";
                    $infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($client->ID);
                    foreach($infoGzips as $infg){
                        $departamento = trim($infg->depto);
                        $municipio = trim($infg->municipio);
                    }

                    $subtitulo ='
                            <tr>
                                <td colspan="3" style="width:100%;"><br><br><h1  style="width:100%;text-align:left; font-size:12px;font-weight:bold; color: #031634;">'.$client->Name.', &nbsp;&nbsp;&nbsp;<span  style="text-align:right; font-size:10px;color: #031634;">Teléfono:'.$client->telefono.'</span><br><span  style="text-align:left; font-size:10px;color: #031634;font-style:normal;">Dirección: '.$client->direccion.', '.$municipio.', '.$departamento.'</span></h1></td>
                            </tr>
                            <tr>
                                <th style="width:1%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; color:#6E6E6E; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; color:#6E6E6E; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:29%; color:#6E6E6E; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:29%; color:#6E6E6E; text-align:left;font-size:11px;">Vendedor</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; color:#6E6E6E; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:1%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $subtitulo .='<tr>
                                <td style="width:1%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:29%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:29%; text-align:left;font-size:10px;">'.$inf->vendedorName.'</td>
                                <td style="width:15%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:1%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                    $subtitulo .='
                            <tr>
                                <th colspan="5" style=" width:89%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:1%; text-align:left;font-size:10px;"></td>
                            </tr>';
                    if(round($sum)!=0){
                        $titulo .=$subtitulo;
                    }
                }
                
                $titulo .='<tr><th colspan="7"><br></th></tr>
                            <tr>
                                <th colspan="5" style=" width:89%; text-align:right;font-size:13px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:13px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:1%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporzona.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    
                     
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                
          
                
                
                }
                    

                
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                
                $apps = $this->apps_model->verApps();
                
               // $this->load->model('variable_model');
              //  $nombres = $this->variable_model->verNombres();
              //  $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                            
                            
                            
                            if($key2->menutype == 1){
                            
                            $titulo .= '<tr>
                                            <td width="3%"></td>
                                            <td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
                                        </tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteVentasVendedor($tipo, $anio, $vende){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                ini_set('memory_limit', -1);
                ini_set('max_allowed_packet', -1);
                ini_set('max_execution_time', -1);
                
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 3, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
              
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('ventas_model');
                
                
                //$mes = $this->ventas_model->getMesesDetalleV($anio);
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
               
                $header  = '<center><table style="width:100%; text-align:center;" >
                                <tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:20px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                </tr>
                                <tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:15px; text-align;center;"><label>'.strtr($nombreFormato, "àèìòùáéíóúçñäëïöü","ÀÈÌÒÙÁÉÍÓÚÇÑÄËÏÖÜ").'</label><label>  '.$anio.'</label></td>
                                </tr>';
                if($tipo == 0){
                    $header  .= '<tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:12px; text-align;center;"><label><strong>Categoria de Productos</strong></label></td>
                                </tr>';
                }else{
                    $header  .='<tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:12px; text-align;center;"><label><strong>Clientes</strong></label></td>
                                </tr>';
                }   
                $header  .= '</table></center>
                <table style="padding-top:5px; width:100%;">
                <tbody>
                <tr>
                <td width="20.5%" style="font-size:10px; font-weight: bold;"></td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Ene</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Feb</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Mar</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Abr</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">May</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Jun</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Jul</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Ago</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Sep</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Oct</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Nov</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">Dic</td>';
                $header  .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">TOTAL</td>';
                $header  .= '</tr>
                </tbody>
                </table>';
                    
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->AddPage();
                if($tipo == 0){
                    $categoria = $this->ventas_model->getVendedoresDetalleVC($anio);
                    $valorVC = $this->ventas_model->getValorVentaC($anio);
                    if($vende == 0){
                        $vendedor = $this->ventas_model->getVendedoresDetalleVende($anio);
                        $titulo='';
                        $titulo .= '<table style=" width:100%;">';
                        $titulo .= '<tbody>';
                        foreach($vendedor as $key){
                            $titulo .= '<tr>
                                            <td colspan="6" style="font-size:12px; font-weight: bold; text-align:left;">'.trim($key->vendedor).'</td>
                                        </tr>';
                            foreach($categoria as $key2){   
                                if(trim($key2->vendedor) == trim($key->vendedor)){
                                    $titulo .= '<tr>
                                                    <td width="1%"></td>
                                                    <td width="20%" style="font-size:11px; color: black; text-align:left;">'.trim($key2->categoria).'</td>';
                                    for($i=1;$i<=12;$i++){
                                        $valorVenta = 0;
                                        $valorVentaCategoria = 0;
                                        foreach($valorVC as $key4){
                                                if(trim($key4->vendedor) == trim($key->vendedor)){
                                                    if(trim($key4->categoria) == trim($key2->categoria)){
                                                        $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                        if($key4->mes == $i){
                                                            $valorVenta = $valorVenta + $key4->valorventa;
                                                        }
                                                    }
                                                }
                                        }
                                        if($valorVenta == 0){
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                        }else{
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                        }
                                    }
                                    $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                                    $titulo .= '</tr>';
                                }
                            }
                            
                            $titulo .= '<tr>
                                    <td width="1%"></td>
                                    <td width="20%" style="font-size:11px; font-weight: bold; text-align:left;">SUB-TOTAL</td>';
                                    for($i=1;$i<=12;$i++){
                                           $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVC as $key4){
                                                     if(trim($key4->vendedor) == trim($key->vendedor)){
                                                         if($key4->mes == $i){
                                                    
                                                         $valorVenta = $valorVenta + $key4->valorventa;
                                                         }
                                                         $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                     }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                        }
                            $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                            $titulo .= '</tr>';
                        }   
                        $titulo .= '<tr>
                                    <td width="1%"></td>
                                    <td width="20%" style="font-size:11px; font-weight: bold; text-align:left;">TOTAL</td>';
                                    for($i=1;$i<=12;$i++){
                                           $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVC as $key4){
                                                     if($key4->mes == $i){
                                                         $valorVenta = $valorVenta + $key4->valorventa;
                                                     }
                                                $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                        }
                        $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                        $titulo .= '</tr>';
                        $titulo .= '</tbody></table><br><br>';
                    }
                    else{
                        $vendedor = $this->ventas_model->getVendedoresDetalleVende($anio);
                        $titulo='';
                        $titulo .= '<table style=" width:100%;">';
                        $titulo .= '<tbody>';

                        foreach($vendedor as $key){
                            if($key->id == $vende){
                            
                                $titulo .= '<tr>
                                                <td colspan="6" style="font-size:12px; font-weight: bold; text-align:left;">'.trim($key->vendedor).'</td>
                                            </tr>';
                                foreach($categoria as $key2){   
                                    if(trim($key2->vendedor) == trim($key->vendedor)){

                                        $titulo .= '<tr>
                                                        <td width="1%"></td>
                                                        <td width="20%" style="font-size:11px; color: black; text-align:left;">'.trim($key2->categoria).'</td>';
                                       
                                        for($i=1;$i<=12;$i++){
                                            $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVC as $key4){
                                                    if(trim($key4->vendedor) == trim($key->vendedor)){
                                                        if(trim($key4->categoria) == trim($key2->categoria)){
                                                            $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                            if($key4->mes == $i){
                                                                $valorVenta = $valorVenta + $key4->valorventa;
                                                            }
                                                        }
                                                    }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                        }
                                        /*
                                        
                                        foreach($mes as $key5){
                                            $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVC as $key4){
                                                    if(trim($key4->vendedor) == trim($key->vendedor)){
                                                        if(trim($key4->categoria) == trim($key2->categoria)){
                                                            $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                            if($key4->mes == $key5->mes){
                                                                $valorVenta = $valorVenta + $key4->valorventa;
                                                            }
                                                        }
                                                    }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                                
                                        }*/
                                        $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                                        $titulo .= '</tr>';
                                    }
                                }
                                $titulo .= '<tr>
                                    <td width="1%"></td>
                                    <td width="20%" style="font-size:11px; font-weight: bold; text-align:left;">TOTAL</td>';
                                      for($i=1;$i<=12;$i++){
                                           $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVC as $key4){
                                                 if($key4->id == $vende){
                                                     if($key4->mes == $i){
                                                         $valorVenta = $valorVenta + $key4->valorventa;
                                                     }
                                                     $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                 }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                                
                                        }
                                 $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';   
                                 $titulo .= '</tr>';
                            }
                        }   
                        $titulo .= '</tbody></table><br><br>';
                    }
                }
                else{
                    
                    if($vende == 0){
                        $vendedor = $this->ventas_model->getVendedoresDetalleV($anio);
                        $valorVCLL = $this->ventas_model->getValorVentaCL($anio);
                        $titulo='';
                        $titulo .= '<table style=" width:100%;">';
                        $titulo .= '<tbody>';

                        foreach($vendedor as $key){
                            $cliente = $this->ventas_model->getVendedoresDetalleCL($anio, $key->id);
                            $titulo .= '<tr>
                                            <td colspan="6" style="font-size:12px; font-weight: bold; text-align:left;">'.trim($key->vendedor).'</td>
                                        </tr>';
                            foreach($cliente as $key2){   
                                if($key2->idv == $key->id){
                                    
                                    // $valorVCL = $this->ventas_model->getValorVentaCLL($anio, $key->id, $key2->cliente);
                                    $titulo .= '<tr>
                                                <td width="3%">'.$key2->cliente.'</td>
                                                <td width="18.9%" style="font-size:8px; color: black; text-align:left;">'.trim($key2->categoria).'</td>';
                                  
                    
                                    for($i=1; $i<=12;$i++){
                                        $valorVCL = $this->ventas_model->getValorVentaCLL($anio, $key->id, $key2->cliente, $i);
                                        if($valorVCL != false){
                                            foreach($valorVCL as $key4){
                                                    $titulo .= '<td width="6%" style="font-size:10px; text-align:right;">$'.number_format(($key4->total), 2).'</td>';
                                            }
                                        }else{
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                        }
                                    }
                                    $titulo .= '</tr>';
                                }
                            }
                        $titulo .= '<tr>
                                    <td width="3%"></td>
                                    <td width="18.5%" style="font-size:11px; font-weight: bold; text-align:left;">SUB-TOTAL</td>';
                                    for($i=1;$i<=12;$i++){
                                           $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVCLL as $key4){
                                                     if($key4->idv == $key->id){
                                                         if($key4->mes == $i){
                                                    
                                                         $valorVenta = $valorVenta + $key4->valorventa;
                                                         }
                                                         $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                     }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            } else{
                                               $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                                
                                        }
                            $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                          
                            $titulo .= '</tr>';
                        }   
                        
                         $titulo .= '<tr>
                                    <td width="3%"></td>
                                    <td width="18.5%" style="font-size:11px; font-weight: bold; text-align:left;">TOTAL</td>';
                                    for($i=1;$i<=12;$i++){
                                        $valorVenta = 0;
                                        $valorVentaCategoria = 0;
                                        
                                        foreach($valorVCLL as $key4){
                                            if($key4->mes == $i){
                                                $valorVenta = $valorVenta + $key4->valorventa;
                                            }
                                            $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                        }
                                        if($valorVenta == 0){
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                        }else{
                                            $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                        }
                                                
                                    }
                        $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                                    
                        $titulo .= '</tr>';

                        $titulo .= '</tbody></table><br><br>';

                    }
                    else{
                        $vendedor = $this->ventas_model->getVendedoresDetalleVende($anio);
                        $cliente = $this->ventas_model->getVendedoresDetalleC($anio);
                        $valorVCL = $this->ventas_model->getValorVentaCL($anio);
                        
                        $titulo='';
                        $titulo .= '<table style=" width:100%;">';
                        $titulo .= '<tbody>';
                        foreach($vendedor as $key){
                            if($key->id == $vende){
                            
                                $titulo .= '<tr>
                                                <td colspan="6" style="font-size:12px; font-weight: bold; text-align:left;">'.trim($key->vendedor).'</td>
                                            </tr>';
                                foreach($cliente as $key2){   
                                    if($key2->idv == $key->id){

                                        $titulo .= '<tr>
                                                        <td width="3%">'.$key2->cliente.'</td>
                                                        <td width="18.5%" style="font-size:8px; color: black; text-align:left;">'.trim($key2->categoria).'</td>';
                                        for($i=1;$i<=12;$i++){
                                        $valorVenta = 0;
                                        $valorVentaCategoria = 0;
                                        
                                        foreach($valorVCL as $key4){
                                           
                                            if($key4->idv == $key->id){
                                                if($key4->idc == $key2->cliente){
                                                    $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                    if($key4->mes == $i){
                                                        $valorVenta = $valorVenta + $key4->valorventa;
                                                    }
                                                }
                                            }
                                        }
                                        if($valorVenta == 0){
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                        }else{
                                            $titulo .= '<td width="6%" style="font-size:10px; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                        }
                                    }

                                         $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                                         $titulo .= '</tr>';


                                    }
                                }
                                
                                $titulo .= '<tr>
                                    <td width="2%"></td>
                                    <td width="19.5%" style="font-size:11px; font-weight: bold; text-align:left;">TOTAL</td>';
                                    for($i=1;$i<=12;$i++){
                                           $valorVenta = 0;
                                            $valorVentaCategoria = 0;
                                            foreach($valorVCL as $key4){
                                                 if($key4->idv == $vende){
                                                     if($key4->mes == $i){
                                                    
                                                         $valorVenta = $valorVenta + $key4->valorventa;
                                                     }
                                                     $valorVentaCategoria = $valorVentaCategoria + $key4->valorventa;
                                                 }
                                            }
                                            if($valorVenta == 0){
                                                $titulo .= '<td width="6%" style="font-size:10px; text-align:right;"></td>';
                                            }else{
                                                $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVenta), 2).'</td>';
                                            }
                                                
                                        
                                        }
                                $titulo .= '<td width="6%" style="font-size:10px; font-weight: bold; text-align:right;">$'.number_format(($valorVentaCategoria), 2).'</td>';
                                $titulo .= '</tr>';
                            }
                        }   
                        $titulo .= '</tbody></table><br><br>';
                    }
                    
                }
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasVendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteClientesVendedor($anio, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                   
                ini_set('memory_limit', -1);
                ini_set('max_allowed_packet', -1);
                ini_set('max_execution_time', -1);
                
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombreFormato);
                $pdf->SetSubject($nombreFormato);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 3, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
              
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('cliente_model');
                
                if($estado == 1){
                    $vendedores = $this->cliente_model->viewVendedores($anio);
                    $totalc = $this->cliente_model->totalCliente($anio);
                }else if($estado == 2){
                    $vendedores = $this->cliente_model->viewVendedoresI($anio);
                    $totalc = $this->cliente_model->totalClienteI($anio);
                }else{
                    $vendedores = $this->cliente_model->viewVendedoresT($anio);
                    $totalc = $this->cliente_model->totalClienteT($anio);
                }
                
                
                //$mes = $this->ventas_model->getMesesDetalleV($anio);
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
               
                $header  = '<center><table style="width:100%; text-align:center;" >
                                <tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:20px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                </tr>
                                <tr style="font-size:12px; text-align;center;" >
                                    <td style="font-size:15px; text-align;center;"><label>'.strtr($nombreFormato, "àèìòùáéíóúçñäëïöü","ÀÈÌÒÙÁÉÍÓÚÇÑÄËÏÖÜ").'</label><label>  '.$anio.'</label></td>
                                </tr>';
                 
                $header  .= '</table></center>
                <table style="padding-top:15px; width:100%;">
                <tbody>
                <tr>
                <td width="23%" style="font-size:10px; font-weight: bold;"></td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Ene</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Feb</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Mar</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Abr</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">May</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Jun</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Jul</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Ago</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Sep</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Oct</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Nov</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">Dic</td>';
                $header  .= '<td width="5.5%" style="font-size:10px; font-weight: bold; text-align:right;">SUMAS</td>';
                $header  .= '<td width="5%" style="font-size:10px; font-weight: bold; text-align:right;">%</td>';
                $header  .= '</tr>
                </tbody>
                </table>';
                    
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->AddPage();
                    
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                foreach($vendedores as $key){
                    $titulo .= '<tr>
                    <td width="24.1%" style="font-size:10px; font-weight: bold;  text-align:left;">'.trim($key->vendedor).'</td>';
                                    
                    $valorTotal = 0;             
                    for($i=1; $i<=12;$i++){
                        
                        if($estado == 1){
                            $valor = $this->cliente_model->viewTotalVendedores($key->id, $i, $anio);
                        }else if($estado == 2){
                            $valor = $this->cliente_model->viewTotalVendedoresI($key->id, $i, $anio);
                        }else{
                            $valor = $this->cliente_model->viewTotalVendedoresT($key->id, $i, $anio);
                        }
                        foreach($valor as $key4){
                            $valorTotal= $valorTotal + $key4->total;
                            if($key4->total != 0){
                                $titulo .= '<td width="5.5%" style="font-size:10px;  text-align:right;">'.$key4->total.'</td>';
                            }else{
                                $titulo .= '<td width="5.5%" style="font-size:10px;  text-align:right;"></td>';
                            }
                        }
                       
                    }
                    
                    $porcentaje = (($valorTotal / $totalc) * 100);
                    
                    $titulo  .= '<td width="5.2%" style="font-size:10px; font-weight: bold; text-align:right;">'.$valorTotal.'</td>';
                    $titulo  .= '<td width="5.2%" style="font-size:10px; font-weight: bold; text-align:right;">'.number_format(($porcentaje), 1).'</td>';
                    
                    $titulo .= '</tr>';
                }
                
                $titulo .= '<tr>
                                <td width="24.1%" style="font-size:10px; font-weight: bold; border-bottom: solid 3px black; text-align:left;"></td>';
                                 for($i=1; $i<=12;$i++){
                                      $titulo .= '<td width="5.5%" style="font-size:10px;  border-bottom: solid 3px black; text-align:right;"></td>';
                                 }
                $titulo .= '<td width="5.5%" style="font-size:10px;  border-bottom: solid 3px black; text-align:right;"></td>';
                $titulo .= '<td width="4.6%" style="font-size:10px;  border-bottom: solid 3px black; text-align:right;"></td>';
                $titulo .= '</tr>';
                
                $titulo .= '<tr>
                    <td width="24.1%" style="font-size:10px; font-weight: bold; text-align:right;">SUMAS</td>';
                                    
                    $valorTotales = 0;             
                    for($i=1; $i<=12;$i++){
                        if($estado == 1){
                            $valores = $this->cliente_model->viewTotalVendedoresMes($i, $anio);
                        }else if($estado == 2){
                            $valores = $this->cliente_model->viewTotalVendedoresMesI($i, $anio);
                        }else{
                            $valores = $this->cliente_model->viewTotalVendedoresMesT($i, $anio);
                        }
                        foreach($valores as $key4){
                            $valorTotales= $valorTotales + $key4->total;
                            if($key4->total != 0){
                                $titulo .= '<td width="5.5%" style="font-size:10px;  font-weight: bold; text-align:right;">'.$key4->total.'</td>';
                            }else{
                                $titulo .= '<td width="5.5%" style="font-size:10px;  font-weight: bold; text-align:right;"></td>';
                            }
                        }
                       
                    }
                    
                    $titulo  .= '<td width="5.2%" style="font-size:10px; font-weight: bold; text-align:right;">'.$valorTotales.'</td>';
                    $titulo  .= '<td width="5.2%" style="font-size:10px; font-weight: bold; text-align:right;">100%</td>';
                    
                    $titulo .= '</tr>';
                
                $titulo .= '</tbody></table><br><br>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("ClientesVendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
             
         }
        
        function recepcionExcel($trannum, $tipo){
            
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function recepcionDoc($trannum, $tipo){
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Recepcion_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
            
        }
        
        function ajustesExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Ajuste de Inventarios") // Titulo
                ->setSubject("Ajuste de Inventarios") //Asunto
                ->setDescription("Ajuste de Inventarios") //Descripción
                ->setKeywords("Ajuste de Inventarios") //Etiquetas
                ->setCategory("Ajuste de Inventarios"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,($value->cantrp- $value->cantidad));
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Ajuste_'.$trannum.'.xls"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
        function ajustesDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataAjuste100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantrp- $value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Ajuste_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Ajuste_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Ajuste_'.$trannum.'.txt');
                exit;
            }
            
        }
        
        function valueinv($sucursal, $tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
          
        function clientesporvendedor($idvendedor, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Clientes por Vendedor');
                $pdf->SetSubject('Reporte de Clientes por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('cliente_model');
                $vendedor_info = $this->cliente_model->callRegistro2($idvendedor);
                $Departamentos_clientes = $this->cliente_model->getDepartamentos_clientes($idvendedor, $estado);
                $Municipios_clientes = $this->cliente_model->getMunicipios_clientes($idvendedor, $estado);
                $Datos_clientes = $this->cliente_model->getDatos_clientes($idvendedor, $estado);
                foreach($vendedor_info as $ven){
                    $nameVendedor = $ven->descrip;
                }
                $this->load->model('invtran_model');
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Listado de Clientes por Vendedor</label><br><label style="text-align:center; font-size:13px;">'.$nameVendedor.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                 
                $titulo='<table>
                <thead>
                    <tr>
                        <th style="width: 10%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: center;">Num.</th>
                        <th style="width: 40%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: left;">Nombre del Cliente</th>
                        <th style="width: 20%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: center;">Teléfono</th>
                        <th style="width: 20%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: center;">Correo</th>
                        <th style="width: 5%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: right;">Límite</th>
                        <th style="width: 5%; font-size:12px; font-weight:bold; background-color: #E8E8E8; border-bottom:1px solid black; text-align: right;">Días</th>
                    </tr>
                </thead>';
                
                $titulo.='<tbody>';
                $total_clientes=0;
                foreach($Departamentos_clientes as $depto){
                    $total_clientes= $total_clientes+ $depto->cantidad;
                    $titulo.='<tr><th colspan="6" style="width:100%;"><br></th></tr>';
                    $titulo.='<tr><td colspan="6" style="width: 100%; font-size:13px; color: #0B486B; text-align: left;">'.$depto->depto.' ('.$depto->cantidad.')</td></tr>';
                    foreach($Municipios_clientes as $mun){
                        if($mun->depto==$depto->depto){
                            $titulo.='<tr><td colspan="6" style="width: 100%; font-size:12px; color: #81A8B8; text-align: left;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$mun->municipio.'</td></tr>';
                        }
                        foreach($Datos_clientes as $cli){
                            if($cli->depto==$depto->depto && $cli->municipio==$mun->municipio){
                                $titulo.='<tr>
                                    <td style="width: 10%; font-size:10px; text-align: center;">'.$cli->idauxi.'</td>
                                    <td style="width: 40%; font-size:10px; text-align: left;">'.$cli->clienteName.'</td>
                                    <td style="width: 20%; font-size:10px; text-align: center;">'.$cli->telefono.'</td>
                                    <td style="width: 20%; font-size:10px; text-align: center;">'.$cli->correo.'</td>
                                    <td style="width: 5%; font-size:10px; text-align: right;">$'.$cli->limite.'</td>
                                    <td style="width: 5%; font-size:10px; text-align: right;">'.$cli->dias.'</td>
                                </tr>';
                                $titulo.='<tr>
                                    <td style="width: 10%; font-size:10px; text-align: center;"></td>
                                    <td colspan="5" style="width: 90%; font-size:9px; text-align: left;">'.$cli->direccion.'</td>
                                </tr>';
                            }
                        }
                    }
                    $titulo.='<tr><th colspan="6" style="width:100%;border-bottom: 1px solid #E8E8E8;"><br></th></tr>';
                }
                 $titulo.='<tr><th colspan="6" style="width:100%;"><br></th></tr> <tr><td colspan="6" style="width: 100%; font-size:12px; color: #0B486B; text-align: LEFT;"> TOTAL DE CLIENTES:   '.$total_clientes.'</td></tr>';
                $titulo.='</tbody></table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Clientes_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function comprasReport($provee, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Compras');
                $pdf->SetSubject('Reporte de Compras');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Reporte de Compras</label><br><label style="text-align:center; font-size:13px;">Periodo del '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $tipopro = $this->session->userdata('tipoprod');
				$idcentro = $this->session->userdata('idcentrouser');
                $this->load->model('compras_model');
                $this->load->model('auxi_model');
                
                $titulo='<table>
                <thead>
                <tr>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Línea</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cod.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Modelo</td>
                        <td style="width:35%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Descripción</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">UM</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Lote</td>
                        <td style="width:5%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:center; font-color: black;">Cant.</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Costo Unitario</td>
                        <td style="width:10%; border-bottom:1px solid #C2CBCE; font-size:10px; text-align:right; font-color: black;">Sub Total</td>
                    </tr>
                </thead><tbody>';
                
                
                $lst_provee = explode("-", $provee);
                $tot = count($lst_provee);
                $total_ = $tot;
                $titulo2='';
                for($j=0; $j<$total_; $j++){
                    $name_provee = $this->auxi_model->getNameAuxi($lst_provee[$j]);
                    $titulo2='<tr><th colspan="9"><br></th></tr><tr><th colspan="9" style="font-size:15px; color: #0B486B;">'.$name_provee.'</th></tr>';
                    $ordenes = $this->compras_model->getListadoOrdenesReport("CO", $tipopro, $idcentro, $fechaini, $fechafin, $lst_provee[$j]);
                    $or=0;
                    foreach($ordenes as $or){
                        $or++;
                        $titulo2.= '<tr>
                        <td style="width:1%;  border-top:1px solid #343838; border-bottom:1px solid #343838; "></td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">Fecha: '.$or->fecha1.'</td>
                        <td style="width:30%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">Cierre: '.$or->fecha2.'</td>
                        <td style="width:39%; border-top:1px solid #343838; border-bottom:1px solid #343838; font-size:12px; text-align:left;">N°: '.$or->serie.$or->numero.'</td></tr>';
                        if($or->notas!="" && $or->notas!=null){
                        $titulo2.= '<tr>
                            <td style="width:1%;"></td>
                            <td colspan="8" style="width:99%;font-size:12px; text-align:left; color:gray; ">&nbsp;&nbsp;&nbsp;&nbsp;'.$or->notas.'</td></tr>';
                        }
                        $exentas=0;
                        $gravadas=0;
                        $iva=0;
                        $total_iva=0;
                        $detalle_orden = $this->compras_model->getDetalleByEstatusCompraLocal($or->trannum, $or->estatus);
                        foreach($detalle_orden as $detail){
                            $subtotal = $detail->cantidad * $detail->preciotran;
                            $titulo2 .= '
                            <tr>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->itemline.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.$detail->idproducto.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->modelo.'</td>
                                <td style="width:35%; font-size:9px; text-align:left; font-color: black;">'.$detail->descrip.'</td>
                                <td style="width:10%; font-size:9px; text-align:center; font-color: black;">'.$detail->um.'</td>
                                <td style="width:10%; font-size:9px; text-align:left; font-color: black;">'.$detail->lote.'</td>
                                <td style="width:5%; font-size:9px; text-align:center; font-color: black;">'.number_format(round($detail->cantidad, 0),0).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">$'.number_format(round($detail->preciotran, 4),4).'</td>
                                <td style="width:10%; font-size:9px; text-align:right; font-color: black;">$'.number_format(round($subtotal, 2),2).'</td>
                            </tr>';
                            if($detail->tax1==0){
                                $exentas = $exentas+$subtotal;
                            }else if($detail->tax1==13){
                                $subtotal_coniva = $subtotal;
                                $subtotal_siniva = $subtotal*(($detail->tax1/100));
                                $gravadas = $gravadas+$subtotal_coniva;
                                $iva = $subtotal_siniva;
                                $total_iva = $total_iva + $iva;
                            }
                        }
                        
                        
                        $subtotal = $exentas+$gravadas+$total_iva;
                        
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Exentas:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($exentas, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Gravadas:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($gravadas, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">IVA:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        </tr>';
                        $titulo2 .='<tr>
                            <td style="width:90%; text-align:right; font-size:11px;font-weight:bold;">Total:</td>
                            <td style="width:10%; text-align:right; font-size:11px;font-weight:bold;">$'.number_format(round($subtotal, 2),2).'</td>
                        </tr>';
                        
                    }
                    if($or!="0"){
                        $titulo.= $titulo2;
                    }
                    
                }         
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 23%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 30/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 23%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
        function cuadre_existencias($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('CUADRE DE EXISTENCIAS');
                $pdf->SetSubject('CUADRE DE EXISTENCIAS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporte($trannum);
                
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$center_name.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                <thead>
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Precio</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';
                     
                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;
                
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                foreach($detalle as $key){
                        
                    if($key->cantrp-$key->cantidad == 0){
                        $sum_sinajuste+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                        $uni_sinajuste+=($key->cantrp-$key->cantidad);
                        $sum_invsistema +=round($key->precioventa*($key->cantidad), 2);
                        $uni_invsistema +=round($key->cantidad);
                        $cantinvsistema ++;
                        $sinajuste.='<tr style="border:  solid 1px black; ">
                        <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                        <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                        <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                        $cantsinajuste++;
                    }
                }   
                if($cantsinajuste>0){
                    $titulo.=$sinajuste;
                }
                
                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                foreach($detalle as $key){
                        
                    if($key->cantrp-$key->cantidad > 0){
                        $sum_ajusteafavor+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                        $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                        
                        $sum_invsistema +=round($key->precioventa*($key->cantidad), 2);
                        $uni_invsistema +=round($key->cantidad);
                        $cantinvsistema ++;
                        $ajusteafavor.='<tr style="border:  solid 1px black; ">
                        <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                        <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                        <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                        $cantajusteafavor++;
                    }
                }   
                if($cantajusteafavor>0){
                    $titulo.=$ajusteafavor;
                }
               
                
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                foreach($detalle as $key){
                        
                    if($key->cantrp-$key->cantidad < 0){
                        $sum_ajusteencontra+=round($key->precioventa*($key->cantrp-$key->cantidad), 2);
                        $uni_ajusteencontra+=($key->cantrp-$key->cantidad);
                        
                        $sum_invsistema +=round($key->precioventa*($key->cantidad), 2);
                        $uni_invsistema +=round($key->cantidad);
                        $cantinvsistema ++;
                        $ajusteencontra.='<tr style="border:  solid 1px black; ">
                        <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                        <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                        <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                        <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa, 2),2).'</td>
                        <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->precioventa*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                        $cantajusteencontra++;
                    }
                   
                }   
                if($cantajusteencontra>0){
                    $titulo.=$ajusteencontra;
                }
                
                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
                
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra;
                
                $titulo.='
                <tr><td colspan="8"><br><br><br><br></td></tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">RESUMEN</td>
                    <td style="text-align:center; font-weight:bold;font-size:11px;">Precio</td>
                    <td style="text-align:center; font-weight:bold;font-size:11px;">Unidades</td>
                    <td style="text-align:center; font-weight:bold;font-size:11px;">Productos</td>
                </tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Inventario Sistema</td>
                    <td style="text-align:right;">$'.number_format(round($sum_invsistema, 2),2).'</td>
                    <td style="text-align:center;">'.$uni_invsistema.'</td>
                    <td style="text-align:center;">'.$cantinvsistema.'</td>
                </tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Sin Ajuste</td>
                    <td style="text-align:right;">$'.number_format(round($sum_sinajuste, 2),2).'</td>
                    <td style="text-align:center;">'.$uni_sinajuste.'</td>
                    <td style="text-align:center;">'.$cantsinajuste.'</td>
                </tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Ajuste a Favor</td>
                    <td style="text-align:right;">$'.number_format(round($sum_ajusteafavor, 2),2).'</td>
                    <td style="text-align:center;">'.$uni_ajusteafavor.'</td>
                    <td style="text-align:center;">'.$cantajusteafavor.'</td>
                </tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Ajuste en Contra</td>
                    <td style="text-align:right;">$'.number_format(round($sum_ajusteencontra, 2),2).'</td>
                    <td style="text-align:center;">'.$uni_ajusteencontra.'</td>
                    <td style="text-align:center;">'.$cantajusteencontra.'</td>
                </tr>
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Ajuste Neto</td>
                    <td style="border-top:1px solid gray;text-align:right; font-weight:bold;">$'.number_format(round($sum_ajusteneto, 2),2).'</td>
                    <td style="border-top:1px solid gray;text-align:center; font-weight:bold;">'.$sumuni.'</td>
                    <td style="text-align:center; font-weight:bold;"></td>
                </tr>
                <tr><td colspan="8"><br></td></tr>
                
                <tr>
                    <td colspan="5" style="text-align:right;font-weight:bold;font-size:11px;">Inventario Ajustado</td>
                    <td style="border-top:1px solid gray;text-align:right; font-weight:bold;">$'.number_format(round(($sum_invsistema+$sum_ajusteneto), 2),2).'</td>
                    <td style="border-top:1px solid gray;text-align:center; font-weight:bold;">'.($uni_invsistema+$sumuni).'</td>
                    <td style="text-align:center; font-weight:bold;"></td>
                </tr>
                
                ';
                
                
                
                
                
                $titulo.='</tbody>
                </table>';
                    
                $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("CuadreExistencias.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);
			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}

		function convertir_a_letras($numero){
			$numero = trim($numero);
			global $importe_parcial;
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 45, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(FALSE,PDF_MARGIN_TOP, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                
                $pdf->addPage('P', 'LETTER');
				
				$estructura = '';
				$this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:58%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:34%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:100%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:90%;">'.$info->direccion.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:90%;">'.$info->nrc.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br></td>
					</tr>';
                
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 30);
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:13%;">'.abs($pro->cantidad).'</td>
								<td style="text-align: left; vertical-align:middle; font-weight: normal; font-size: 12px; width:44%;">['.$pro->idproducto.'] '.$nombrepro.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:9%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:11%;">'.$vnGravada.'</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:10px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:8px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:46%;">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:16%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, false, true, false, '');
            	$nombre_archivo = utf8_decode("FacturaConsumidorFinal$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function creditoFiscal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Credito Fiscal');
                $pdf->SetSubject('Credito Fiscal');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 48, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(FALSE,PDF_MARGIN_TOP, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                
                $pdf->addPage('P', 'LETTER');
				
				$estructura = '';
				$this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
				
				$giro = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$nit = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$nrf = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				foreach($informacion as $info){
					$idcps = $info->idcps;
				}
				
				$infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($idcps);
				foreach($infoGzips as $infg){
					$departamento = trim($infg->depto);
					$municipio = trim($infg->municipio);
				}
				
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:18%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:49%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:34%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:100%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:57%;">'.$info->direccion.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:34%;">'.$info->nrc.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:48%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:34%;">'.$info->giro.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"><br></td>
					</tr>';
                
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tax1 != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
						}else if($pro->tax1 != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
						}else if($pro->tax1== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
						}else if($pro->tax1 == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 30);
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:13%;">'.abs($pro->cantidad).'</td>
								<td style="text-align: left; vertical-align:middle; font-weight: normal; font-size: 12px; width:44%;">['.$pro->idproducto.'] '.$nombrepro.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:9%;">'.number_format(round($pro->precioneto, 4), 4 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:11%;">'.$vnGravada.'</td>
							</tr>
							<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
							</tr>';
					}
					$numProd++;
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"><br></td>
						</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 4), 4 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$totalGravIva = $totalGravado + $totalIVA;
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:6px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:11%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:46%;">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:16%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;">$'.number_format(round($totalGravado, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:73%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:10%;">13%</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;">$'.number_format(round($totalIVA, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;">$'.number_format(round($totalGravIva, 4), 4 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size:5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"><br></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 13px; width:83%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 13px; width:13%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, false, true, false, '');
            	$nombre_archivo = utf8_decode("CreditoFiscal$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function facturaComercial($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Comercial');
                $pdf->SetSubject('Factura Comercial');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(5, 5, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(FALSE,PDF_MARGIN_TOP, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->setPrintHeader(false);
				
                $pdf->addPage('P', 'LETTER');
				
				$this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $formapago = $this->ventas_model->getFormaDePagoTrannum($trannum);
				
				if($formapago == ''){
					$formapago = $this->ventas_model->getFormaDePagoCreditoTrannum($trannum);
				}
				
				$estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="width:30%;" rowspan="4"><img src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/LogoFaciniNC.png"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:40%;" rowspan="5">CENTRO COMERCIAL FERIA ROSA LOCAL 201-I<br>SAN SALVADOR, EL SALVADOR<br>TEL: 2207-2582, 2266-0075<br>info@facini.net<br>www.facini.net</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:8px; width:30%;">SUCURSAL CENTRO 1<br>GALERIAS CENTRAL NIVEL 2 - 57 S.S.<br>TEL: 2564-8581</td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:8px; width:30%;">SUCURSAL CENTRO 2<br>AV. RUBEN DARIO ENTRE 3ª y 5ª AV. SUR, LOCAL 120<br>TEL: 2566-2516</td>
						</tr>
						<tr>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:4px; width:30%;"><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:30%;">SUCURSAL SAN MIGUEL<br>C.C. PLAZA ROOSEVELT 1 - 6<br>TEL: 2694-1299</td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:8px; width:30%;">SUCURSAL CENTRO 3<br>GALERIAS CENTRAL NIVEL 1 LOCAL - 11<br>TEL: 2222-9843</td>
						</tr>
					</table>';
				
				foreach($informacion as $info){
					$estructura .= '
						<table style="width:100%; border:1px solid black;">
							<tr>
								<td style="border-right:1px solid black; text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:75%;"><br></td>
								<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:25%;"><br></td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Nombre del Cliente:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$info->idcliente.' '.$info->nameCliente.'</td>
								<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:25%;" rowspan="5"><strong>NOTA DE ENVIO</strong><br>N°<br><strong style="font-size:14px;">'.$info->numero.'</strong><br>FECHA<br>'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Dirección:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$info->direccion.'</td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Teléfono:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$info->telefono.'</td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Forma de Pago:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$formapago.'</td>
							</tr>
							<tr>
								<td style="text-align:right; vertical-align:middle; font-weight:bold; font-size:12px; width:20%;">Vendedor:</td>
								<td style="border-right:1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:55%;">'.$info->idvendedor.' '.$info->nameVendedor.'</td>
							</tr>
							<tr>
								<td style="border-right:1px solid black; text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:75%;"><br></td>
								<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:5px; width:25%;"><br></td>
							</tr>
						</table>';
				}
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="background-color:#CCCCCC; color:#101F78; border-left:1px solid black; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CANTIDAD</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>CODIGO</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:25%;"><strong>DESCRIPCION DEL PRODUCTO</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;"><strong>PRECIO LISTA</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;"><strong>% DESCUENTO</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;"><strong>PRECIO UNITARIO</strong></td>
						<td style="background-color:#CCCCCC; color:#101F78; border-right:1px solid black; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;"><strong>SUB TOTAL</strong></td>
					</tr>';
				
				$productos = $this->invtran_model->getDataTran100k($trannum);
				
				$total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0;
				
				foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
						$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "";
						$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}
						
					$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
					$nombrepro = substr($pro->descrip, 0, 25);
						
					$estructura .= '
						<tr>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.abs($pro->cantidad).'</td>
							<td style="color:#000; text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$pro->modelo.'</td>
							<td style="color:#000; text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:25%;">'.$nombrepro.'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;">'.number_format(round($pro->precioventa, 2), 2 ,'.','').'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;">'.number_format($pro->descuento, 2 ,'.','').'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:15%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
							<td style="color:#000; text-align:right; vertical-align:middle; font-weight:normal; font-size:11px; width:10%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>';
				}
				
				$estructura .= '</table>';
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$footer =  '<br><br><br><br><br>
                	<table style="padding:0px; margin:0px;">
                    	<tr style="padding:0px; margin:0px; background-color:#CCCCCC;">
							<th style="font-size:13px; text-align:left; width:80%"><strong>SON: '.strtoupper($TotalLetras).'/DOLARES</strong></th>
                            <th style="font-size:13px; text-align:right; width: 10%"><strong>TOTAL:</strong></th>
                            <th style="font-size:13px; text-align:right; width: 10%"><strong>$'.number_format(round($total, 2), 2 ,'.',',').'</strong></th>
                        </tr>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
				
				$pdf->writeHTML($estructura, true, false, true, false, '');
            	$nombre_archivo = utf8_decode("FacturaComercial$trannum.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function consolidado_ventas_cobros($fechaini, $fechafin,$tipo){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('CONSOLIDADO DE VENTAS Y COBROS');
                $pdf->SetSubject('CONSOLIDADO DE VENTAS Y COBROS');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                if($tipo==1){
                    $tipo_reporte="RESUMIDO";
                }else{
                    $tipo_reporte="DETALLADO";
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim(strtoupper ($nombre_doc)).' '.$tipo_reporte.'</label><br><label style="text-align:center; font-size:13px;">PERIODO DEL '.date_format(date_create($fechaini), 'd/m/Y').' AL '.date_format(date_create($fechafin), 'd/m/Y').'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                    <thead>
                        <tr style="vertical-align:middle; font-size:12px; height:20px;background-color:#E8E8E8;">
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:15%; text-align:left; vertical-align:middle; font-weight: bold; font-size:12px;">Zona</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:12px;">Cant de Facturas</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:15%; text-align:right; vertical-align:middle; font-weight: bold; font-size:12px;">Venta Neta</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:15%; text-align:right; vertical-align:middle; font-weight: bold; font-size:12px;">Devoluciones</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:12px;">Total</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:12px;">Cobrado</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:12px;">%</th>
                            <th style="background-color:#E8E8E8; padding: 25px; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:12px;">Por Cobrar</th>
                        </tr>
                    </thead>
                <tbody>';
            
                $zonas = $this->arap_model->getZonasPeriodo($fechaini,$fechafin);
              
                $sum_facturas = 0;
                $sum_ventaneta = 0;
                $sum_devolucion = 0;
                $sum_total = 0;
                $sum_cobrado = 0;
                $sum_porcobrar = 0;
               
                if($tipo==1){
                    foreach($zonas as $zn){
                        $zona = $zn->zona;
                        $info_zona = $this->arap_model->getDatosVentasyCobros($zona,$fechaini,$fechafin);
                        $total_fact=0;
                        $ventaneta=0;
                        $devolucion=0;

                        foreach($info_zona as $in){
                            $total_fact+= $in->num_facturas;
                            $devolucion += $in->devoluciones;
                            $ventaneta += $in->ventaneta;
                        }
                        $cobrado = $this->arap_model->getCobradoZona($zona,$fechaini,$fechafin);
                        $total = $ventaneta+$devolucion;
                        $porcobrar = abs($total)-abs($cobrado);
                        $porcentaje = (abs($cobrado)/abs($total))*100;

                        $sum_facturas = $sum_facturas + $total_fact;
                        $sum_ventaneta = $sum_ventaneta + $ventaneta;
                        $sum_devolucion = $sum_devolucion + $devolucion;
                        $sum_total = $sum_total + $total;
                        $sum_cobrado = $sum_cobrado + $cobrado;
                        $sum_porcobrar = $sum_porcobrar + $porcobrar;
                        $titulo.='<tr>
                                <td style="padding: 15px; width:15%; text-align:left; vertical-align:middle; font-size:10px;">'.$zona.'</td>
                                <td style="padding: 15px; width:15%; text-align:center; vertical-align:middle; font-size:10px;">'.$total_fact.'</td>
                                <td style="padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round($ventaneta, 2),2).'</td>
                                <td style="padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round($devolucion, 2),2).'</td>
                                <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round($total, 2),2).'</td>
                                <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round(abs($cobrado), 2),2).'</td>
                                <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;">'.number_format(round(abs($porcentaje), 2),2)."%".'</td>
                                <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round(abs($porcobrar), 2),2).'</td>

                        </tr>';
                    }
                }else{
                    foreach($zonas as $zn){
                        $zona = $zn->zona;
                        $info_zona = $this->arap_model->getDatosVentasyCobros($zona,$fechaini,$fechafin);
                        $total_fact=0;
                        $ventaneta=0;
                        $devolucion=0;

                        foreach($info_zona as $in){
                            $total_fact+= $in->num_facturas;
                            $devolucion += $in->devoluciones;
                            $ventaneta += $in->ventaneta;
                        }
                        $cobrado = $this->arap_model->getCobradoZona($zona,$fechaini,$fechafin);
                        $total = $ventaneta+$devolucion;
                        $porcobrar = abs($total)-abs($cobrado);
                        $porcentaje = (abs($cobrado)/abs($total))*100;

                        $sum_facturas = $sum_facturas + $total_fact;
                        $sum_ventaneta = $sum_ventaneta + $ventaneta;
                        $sum_devolucion = $sum_devolucion + $devolucion;
                        $sum_total = $sum_total + $total;
                        $sum_cobrado = $sum_cobrado + $cobrado;
                        $sum_porcobrar = $sum_porcobrar + $porcobrar;
                        $titulo.='<tr>
                            <td style="padding: 15px; width:15%; text-align:left; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">'.$zona.'</td>
                            <td style="padding: 15px; width:15%; text-align:center; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">'.$total_fact.'</td>
                            <td style="padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">$'.number_format(round($ventaneta, 2),2).'</td>
                            <td style="padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">$'.number_format(round($devolucion, 2),2).'</td>
                            <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">$'.number_format(round($total, 2),2).'</td>
                            <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">$'.number_format(round(abs($cobrado), 2),2).'</td>
                            <td style="padding: 15px; width:10%; text-align:center; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">'.number_format(round(abs($porcentaje), 2),2)."%".'</td>
                            <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:10px;font-weight:bold;border-bottom:solid 1px #0B486B; color:#0B486B;">$'.number_format(round(abs($porcobrar), 2),2).'</td>
                        </tr>';
                        $detalle = $this->arap_model->detailTranZona($zona,$fechaini,$fechafin);
                        $cant_detalle=0;
                        foreach($detalle as $det){
                            if($cant_detalle==0){
                                $titulo.='<tr>
                                    <th style="padding: 15px; width:20%; text-align:left; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Tipo de Documento</th>
                                    <th style="padding: 15px; width:5%; text-align:center; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Numero</th>
                                    <th style="padding: 15px; width:15%; text-align:center; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Fecha</th>
                                    <th style="padding: 15px; width:25%; text-align:left; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Cliente</th>
                                    <th style="padding: 15px; width:25%; text-align:left; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Vendedor</th>
                                    <th style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:9px;color:#81A8B8;border-bottom: solid 1px #81A8B8;">Valor</th>
                                </tr>';
                                $cant_detalle++;
                            }
                            $titulo.='<tr>
                                <td style="padding: 15px; width:20%; text-align:left; vertical-align:middle; font-size:9px;">'.$det->tipoDoc.'</td>
                                <td style="padding: 15px; width:5%; text-align:center; vertical-align:middle; font-size:9px;">'.$det->numero.'</td>
                                <td style="padding: 15px; width:15%; text-align:center; vertical-align:middle; font-size:9px;">'.date_format(date_create($det->fecha), 'd/m/Y').'</td>
                                <td style="padding: 15px; width:25%; text-align:left; vertical-align:middle; font-size:9px;">'.ucwords(strtolower($det->cliente)).'</td>
                                <td style="padding: 15px; width:25%; text-align:left; vertical-align:middle; font-size:9px;">'.ucwords(strtolower($det->nameVendedor)).'</td>
                                <td style="padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:9px;">$'.number_format(round(abs($det->valor), 2),2).'</td>
                            </tr>';
                        }
                    }
                }
                
                $titulo.='<tr>
                    <td style="background-color:#E8E8E8;padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">TOTALES</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:15%; text-align:center; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">'.$sum_facturas.'</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">$'.number_format(round($sum_ventaneta, 2),2).'</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:15%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">$'.number_format(round($sum_devolucion, 2),2).'</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">$'.number_format(round($sum_total, 2),2).'</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">$'.number_format(round(abs($sum_cobrado), 2),2).'</td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;"></td>
                    <td style="background-color:#E8E8E8;padding: 15px; width:10%; text-align:right; vertical-align:middle; font-size:11px;font-weight:bold;border-top:solid 1.5px black;">$'.number_format(round(abs($sum_porcobrar), 2),2).'</td>
                </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                $nombre_archivo = utf8_decode("Consolidado_Ventas_Cobros.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
		function comprobanteCanjeDeProductos($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
			}else{
				$fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Comproban de Canje');
                $pdf->SetSubject('Comproban de Canje');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(10, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
				$this->load->model('ventas_model');
				$this->load->model('pedclientes_model');
				
				$nameLogo = $this->pedclientes_model->getnameImg();
				$header = '
				<table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%"><img style="width:200px; height:70px; min-width: 25%; float:left; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameLogo.'"></th>
                            <th style="font-size:10px; text-align:center; width: 40%"><br><br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">COMPROBANTE DE CANJE</label></center></th>
                            <th style="font-size:10px; text-align:right; width: 30%"></th>
                        </tr>
                    </tbody>
				</table>';
				$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               	
                $footer =  '<br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:left; width: 18%;">ENTREGADO POR</th>
                            <th style="font-size:12px; text-align:center; width: 30%; border-bottom:1px solid #000;"></th>
                            <th style="font-size:12px; text-align:center; width: 4%;"></th>
                            <th style="font-size:12px; text-align:left; width: 16%;">RECIBIDO POR</th>
                            <th style="font-size:12px; text-align:right; width: 30%; border-bottom:1px solid #000;"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:center; width: 100%;"></th>
                        </tr>
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:12px; text-align:left; width: 18%;">APLICADO POR</th>
                            <th style="font-size:12px; text-align:center; width: 30%; border-bottom:1px solid #000;"></th>
                            <th style="font-size:12px; text-align:center; width: 4%;"></th>
                            <th style="font-size:12px; text-align:left; width: 18%;"></th>
                            <th style="font-size:12px; text-align:right; width: 28%;"></th>
                        </tr>
                    </tbody>
				</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               	
				$numero_factura = "";
				$fecha_factura = "";
				$informacion = $this->ventas_model->getInformacionDetalleCanje($trannum);
				
				foreach($informacion as $info){
					
					if($info->cli_email != ""){
						$codigosCargosAbonos = explode(",", $info->cli_email);
						$idrec_cargo = $codigosCargosAbonos[0];
						
						$info_factura = $this->ventas_model->getInformacionTrannumCargoAbono($idrec_cargo);
						
						$numero_factura = $info_factura['trannum'];
						$fecha_factura = date_format(date_create($info_factura['fecha']), 'd/m/Y');
					}
					
					$titulo = '
					<table>
						<tbody>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; text-align: left; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"> </td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Fecha:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.date_format(date_create($info->fecha), 'd/m/Y').'</strong></td>
								<td style="width: 20%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Zona:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->zonaCliente.'</strong></td>
								<td style="width: 10%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Número:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 10%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.$info->trannum.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"> </td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 10%; font-size:3px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Nombre:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 85%; font-size:12px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->nameCliente.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;"></td>
								<td style="width: 50%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Factura:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"> <strong>'.$numero_factura.'</strong></td>
								<td style="width: 20%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000;">Fecha de Factura:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 50%; font-size:12px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000;"> &nbsp;&nbsp;&nbsp;<strong>'.$fecha_factura.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 15%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 20%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 50%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:12px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;">Observaciones:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 85%; font-size:12px; text-align: left; background-color:#ECF0F1;  border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;<strong>'.$info->notas.'</strong></td>
							</tr>
							<tr>
								<td style="width: 15%; font-size:3px; text-align: right; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
								<td style="width: 85%; font-size:3px; text-align: left; background-color:#ECF0F1; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
							</tr>
						</tbody>
					</table>';
				}
				
				$idcentro = $info->idcentro;
				$datos_canjeados = $this->ventas_model->getListadoProductosCanjeados($trannum);
				$datos_entregados = $this->ventas_model->getListadoProductosEntregados($trannum, $idcentro);
				
				$titulo .= '<br><br><br>
				<table>
					<tbody>
						<tr>
							<td style="width: 100%; font-size:5px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:12px; text-align: center; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"><strong>ENTRADA</strong></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:5px;background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">DESCRIPCIÓN</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">CANTIDAD</td>
							<td style="width: 15%; font-size:12px; text-align:  right; background-color:#ECF0F1; border-right:1px solid #000;">PRECIO&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';
				
				$total_cant_entradas = 0;
				$total_prec_entradas = 0;
				
				foreach($datos_canjeados as $info_can){
					$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: left; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$info_can->descrip.'</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">'.abs($info_can->cantidad).'</td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;">$'.number_format($info_can->precioneto, 2, '.', ',').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';
					
					$total_cant_entradas =  $total_cant_entradas + abs($info_can->cantidad);
					$total_prec_entradas =  $total_prec_entradas + $info_can->precioneto;
				}
				
				$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; border-right:1px solid #000;"><strong>TOTAL</strong></td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"><strong>'.$total_cant_entradas.'</strong></td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;"><strong>$'.number_format($total_prec_entradas, 2, '.', ',').'</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
					</tbody>
				</table>';
				
				$titulo .= '<br><br><br>
				<table>
					<tbody>
						<tr>
							<td style="width: 100%; font-size:5px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:12px; text-align: center; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000;"><strong>SALIDA</strong></td>
						</tr>
						<tr>
							<td style="width: 100%; font-size:5px;background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; border-bottom:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">DESCRIPCIÓN</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">CANTIDAD</td>
							<td style="width: 15%; font-size:12px; text-align:  right; background-color:#ECF0F1; border-right:1px solid #000;">PRECIO&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';
				
				$total_cant_salidas = 0;
				$total_prec_salidas = 0;
				
				foreach($datos_entregados as $info_ent){
					$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: left; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$info_ent->descrip.'</td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;">'.abs($info_ent->cantidad).'</td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;">$'.number_format($info_ent->precioneto, 2, '.', ',').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>';
					
					$total_cant_salidas =  $total_cant_salidas + abs($info_ent->cantidad);
					$total_prec_salidas =  $total_prec_salidas + $info_ent->precioneto;
				}
				
				$titulo .= '
						<tr>
							<td style="width: 70%; font-size:3px; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; background-color:#ECF0F1; border-top:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:12px; text-align: center; border-right:1px solid #000;"><strong>TOTAL</strong></td>
							<td style="width: 15%; font-size:12px; text-align: center; background-color:#ECF0F1; border-right:1px solid #000;"><strong>'.$total_cant_salidas.'</strong></td>
							<td style="width: 15%; font-size:12px; text-align: right; background-color:#ECF0F1; border-right:1px solid #000;"><strong>$'.number_format($total_prec_salidas, 2, '.', ',').'</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="width: 70%; font-size:3px; text-align: center; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							<td style="width: 15%; font-size:3px; text-align: center; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
						</tr>
					</tbody>
				</table>';
				
				if($info->cli_email != ""){
					$codigosCargosAbonos = explode(",", $info->cli_email);
					$idrec_cargo = $codigosCargosAbonos[0];
					$idrec_abono = $codigosCargosAbonos[1];
					
					$valor_cargo = ""; $valor_abono = "";
					$forma_cargo = ""; $forma_abono = "";
					$notas_cargo = ""; $notas_abono = "";
					
					if($idrec_cargo != ""){
						$info_cargo = $this->ventas_model->getInformacionCargoCanje($idrec_cargo);
						
						$valor_cargo = number_format(abs($info_cargo['valor']), 2, '.', ',');
						$forma_cargo = $info_cargo['forma_pago'];
						$notas_cargo = $info_cargo['notas'];
					}
					if($idrec_abono != ""){
						$info_abono = $this->ventas_model->getInformacionAbonoCanje($idrec_abono);
						
						$valor_abono = number_format(abs($info_abono['valor']), 2, '.', ',');
						$forma_abono = $info_abono['forma_pago'];
						$notas_abono = $info_abono['notas'];
					}
					
					$titulo .= '<br><br><br>
					<table>
						<tbody>
							<tr>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-top:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 49%; font-size:12px; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; text-align:center;"><strong>DETALLE CARGO</strong></td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 49%; font-size:12px; background-color:#8C1723; color:#FFF; border-left:1px solid #000; border-right:1px solid #000; text-align:center;"><strong>DETALLE ABONO</strong></td>
							</tr>
							<tr>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 49%; font-size:3px; background-color:#8C1723; color:#FFF; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Valor:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;$'.$valor_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Valor:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;$'.$valor_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Forma de Pago:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$forma_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Forma de Pago:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$forma_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-right:1px solid #000;"></td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Notas:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$notas_cargo.'</td>
								<td style="width:  2%; font-size:12px;"></td>
								<td style="width: 19%; font-size:12px; background-color:#ECF0F1; border-left:1px solid #000; border-right:1px solid #000; text-align:right;">Notas:&nbsp;&nbsp;&nbsp;</td>
								<td style="width: 30%; font-size:12px; background-color:#ECF0F1; border-right:1px solid #000;">&nbsp;&nbsp;&nbsp;'.$notas_abono.'</td>
							</tr>
							<tr>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width:  2%; font-size:3px;"></td>
								<td style="width: 19%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-left:1px solid #000; border-right:1px solid #000;"></td>
								<td style="width: 30%; font-size:3px; background-color:#ECF0F1; border-bottom:1px solid #000; border-right:1px solid #000;"></td>
							</tr>
						</tbody>
					</table>';
				}
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Comprobante_Canje.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function analisis_tantiguedad(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '99999M');
                ini_set('max_allowed_packet', '99999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                        <thead>
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:right;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:right;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:right;">Disponible</th>
                            </tr></thead>';
                //$grupos = $this->arap_model->grupos_report();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $sum_subtotal=0;
                $sub_cadena = "";
                $info = $this->arap_model->clientes_report();
                
                $vendedor_actual = 0;
                foreach($info as $i){
                    if($vendedor_actual!=$i->idworker){
                        $sum_vendedor = $subtot_dias1+ $subtot_dias2+ $subtot_dias3+ $subtot_dias4+ $subtot_dias5;
                        $sub_cadena .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;font-weight:bold;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="font-weight:bold;border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_vendedor, 2),2).'</th></tr>';
                        $sum_tot_dias1+= $subtot_dias1;
                        $sum_tot_dias2+= $subtot_dias2;
                        $sum_tot_dias3+= $subtot_dias3;
                        $sum_tot_dias4+= $subtot_dias4;
                        $sum_tot_dias5+= $subtot_dias5;
                        if(round($sum_vendedor,2)>0){
                            $titulo.=$sub_cadena;
                        }
                        $subtot_dias1=0;
                        $subtot_dias2=0;
                        $subtot_dias3=0;
                        $subtot_dias4=0;
                        $subtot_dias5=0;
                        $sub_cadena = '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($i->vendedor).'<br></th></tr>';
                        $sum_cliente=0;
                        $sum_vendedor = 0;
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_120+ $sum_121;
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $dispo = $i->limite-$sum_cliente;
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        $subtot_dias1+= $sum_1_30;
                        $subtot_dias2+= $sum_31_60;
                        $subtot_dias3+= $sum_61_90;
                        $subtot_dias4+= $sum_91_120;
                        $subtot_dias5+= $sum_121; 
                        $vendedor_actual = $i->idworker;
                    }else{
                        $sum_1_30 = $i->sum_1_30;
                        $sum_31_60 = $i->sum_31_60;
                        $sum_61_90 = $i->sum_61_90;
                        $sum_91_120 = $i->sum_91_120;
                        $sum_121 = $i->sum_121;
                        $sum_cliente = $sum_1_30+ $sum_31_60+ $sum_61_90+ $sum_91_120+ $sum_121;
                        if(round($sum_cliente,2) >0){
                            $sub_cadena .= '<tr><td style="width:8%;">'.$i->nrc.'</td><td style="width:32%;" colspan="2">'.trim($i->cliente).'</td>';
                            $dispo = $i->limite-$sum_cliente;
                            if(round($sum_1_30, 2)>0){
                                $cadena1 = number_format(round($sum_1_30, 2),2);
                            }else{
                                $cadena1 = "";
                            }
                            if(round($sum_31_60, 2)>0){
                                $cadena2 = number_format(round($sum_31_60, 2),2);
                            }else{
                                $cadena2 = "";
                            }
                            if(round($sum_61_90, 2)>0){
                                $cadena3 = number_format(round($sum_61_90, 2),2);
                            }else{
                                $cadena3 = "";
                            }
                            if(round($sum_91_120, 2)>0){
                                $cadena4 = number_format(round($sum_91_120, 2),2);
                            }else{
                                $cadena4 = "";
                            }
                            if(round($sum_121, 2)>0){
                                $cadena5 = number_format(round($sum_121, 2),2);
                            }else{
                                $cadena5 = "";
                            }
                            $sub_cadena .='<td style="text-align:right;width:7%;">'.$cadena1.'</td><td style="text-align:right;width:7%;">'.$cadena2.'</td><td style="text-align:right;width:7%;">'.$cadena3.'</td><td style="text-align:right;width:7%;">'.$cadena4.'</td><td style="text-align:right;width:7%;">'.$cadena5.'</td><td style="text-align:right;width:8%;">'.number_format(round($sum_cliente, 2),2).'</td><td style="text-align:right;width:8%;">'.number_format(round($i->limite, 2),2).'</td><td style="text-align:right;width:9%;">'.number_format(round($dispo, 2),2).'</td></tr>';  
                        }
                        $subtot_dias1+= $sum_1_30;
                        $subtot_dias2+= $sum_31_60;
                        $subtot_dias3+= $sum_61_90;
                        $subtot_dias4+= $sum_91_120;
                        $subtot_dias5+= $sum_121; 
                        $vendedor_actual = $i->idworker;
                    }
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                if($gran_total==0){
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(0,2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }else{
                    $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                    $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';
                }
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                //foreach($grupos as $gr){
                    //$titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        //$i->grupo==$gr->grupo and 
                        if(($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                if(round($sum_prov,2)>0){
                                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                    $dispo = $last_limit-$sum_prov;
                                    $porcen=0;
                                    if($sum_total_porcent>0){
                                        $tot_client = $sum_prov/$sum_total_porcent;
                                    }else{
                                        $tot_client=0;
                                    }
                                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($tot_client)*100), 2),2).'</td></tr>';
                                }
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                if(round($gran_total,2)>0){
                    $percent_d1 = $sum_tot_dias1/$gran_total;
                    $percent_d2 = $sum_tot_dias2/$gran_total;
                    $percent_d3 = $sum_tot_dias3/$gran_total;
                    $percent_d4 = $sum_tot_dias4/$gran_total;
                    $percent_d5 = $sum_tot_dias5/$gran_total;
                }else{
                    $percent_d1=0;
                    $percent_d2=0;
                    $percent_d3=0;
                    $percent_d4=0;
                    $percent_d5=0;
                }
                
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($percent_d1)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($percent_d2)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($percent_d3)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($percent_d4)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($percent_d5)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
         function recuento_fisico($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Recuento Fisico');
                $pdf->SetSubject('Recuento Fisico');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporteOrdDescrip($trannum);
                
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.' N° '.$trannum.'<br>'.$center_name.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                <thead>
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Costo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';
                     
                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;
                
                $sum_invsistema_noinventariado=0;
                $uni_invsistema_noinventariado=0;
                $cantinvsistema_noinventariado=0;
                
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2), 2).'</td></tr>';
                            $cantsinajuste++;
                        }
                    }     
                }   
                if($cantsinajuste>0){
                    $titulo.=$sinajuste;
                }
                
                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad > 0){
                            $sum_ajusteafavor+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteafavor.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteafavor++;
                        }
                    }
                }   
                if($cantajusteafavor>0){
                    $titulo.=$ajusteafavor;
                }
               
                
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra++;
                        }
                    }
                   
                }   
                if($cantajusteencontra>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                
                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
                
                   
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                    
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra2 = 0;
                $sum_ajusteencontra2 = 0;
                $uni_ajusteencontra2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra2++;
                        }
                    }
                   
                }   
                if($cantajusteencontra2>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                    
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                $cantsinajuste2= 0;
                $sum_sinajuste2 = 0;
                $uni_sinajuste2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste2++;
                        }
                    }     
                }   
                if($cantsinajuste2>0){
                    $titulo.=$sinajuste;
                }
                
                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;
                
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;
                
                $titulo.='</tbody>
                </table>
                <table>
                    <tr><td colspan="4"><br><br><br></td></tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:40%;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;width:30%;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:11px;width:10%;">Costo</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Productos</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Sistema</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">$'.number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">'.number_format(round($uni_invsistema, 2),2).'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteafavor,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteafavor.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">$'.number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">'.number_format(round(($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor),2),2).'</td>
                        <td style="text-align:center; font-weight:bold;width:10%;"></td>
                    </tr>
                    <tr><td colspan="5"><br></td></tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste2.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste.'</td>
                    </tr>
                    </table>
                ';
                
                    
                $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recuento_Fisico.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
	}
?>