<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
		}
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}
		
		function unidad_centimos($numero){
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;

			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('Landscape', 'mm', 'LETTER', true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P','LETTER');
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
                $fomaPago = $this->ventas_model->getFormaDePagoTrannum($trannum);
				
				foreach($informacion as $info){
					
					$infoGzips = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($infoGzips as $infg){
						$departamento = trim($infg->depto);
						$municipio = trim($infg->municipio);
					}
					
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:60%;"><strong>SR.(ES):</strong> '.strtoupper($info->nameCliente).'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:95%;"><strong>DIRECCION:</strong> '.$info->direccion.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:60%;"><strong>DEPARTAMENTO:</strong> '.$departamento.' <strong>MUNICIPIO:</strong> '.$municipio.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-size: 11px; width:5%;"></td>
							<td style="text-align:center; vertical-align:middle; font-size: 11px; width:18%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 10px; width:19%;">'.strtoupper($info->nameVendedor).'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 11px; width:18%;">'.$fomaPago.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px; height:400px;">
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">CANTIDAD</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">DESCRIPCIÓN</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">PRECIO UNIT.</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:11%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">VTA. EXENTA</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:12%; background-color:#000; color:#FFF;">VTA. AFECTADAS</td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$descripcion = strtoupper($pro->descrip).' '.strtoupper($pro->notas);
						$totalLeng = strlen($descripcion);	
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;">'.$descripcion.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:11%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:12%;">'.$vnGravada.'</td>
							</tr>';
						
					}
					if($totalLeng > 48){
						$numProd = $numProd + 2;
					}else{
						$numProd++;
					}
				}
				
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:60%; background-color:#000; border-right:solid 1px #FFF; color:#FFF; border-left:solid 1px #000;">Observaciones</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:28%; background-color:#000; color:#FFF; border-right:solid 1px #000;">Total</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:60%; border-right:solid 1px #000; border-left:solid 1px #000; border-bottom: solid 1px #000;">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:28%; border-right:solid 1px #000; border-bottom: solid 1px #000;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 15px; width:100%;"></td>
                    </tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.strtoupper($info->nameVendedor).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:28%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.$info->duivendedor.'</td>
                    </tr>';
				
				$estructura .= '</table>';
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
                
                foreach($informacion as $info){
					$estructura .= '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:60%;"><strong>SR.(ES):</strong> '.strtoupper($info->nameCliente).'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:95%;"><strong>DIRECCION:</strong> '.$info->direccion.'</td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-size: 10px; width:60%;"><strong>DEPARTAMENTO:</strong> '.$departamento.' <strong>MUNICIPIO:</strong> '.$municipio.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:45%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
                        <tr>
							<td style="text-align:left; vertical-align:middle; font-size: 11px; width:5%;"></td>
							<td style="text-align:center; vertical-align:middle; font-size: 11px; width:18%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 10px; width:19%;">'.strtoupper($info->nameVendedor).'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 11px; width:18%;">'.$fomaPago.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px; height:400px;">
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">CANTIDAD</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">DESCRIPCIÓN</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">PRECIO UNIT.</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:11%; background-color:#000; border-right:solid 1px #FFF; color:#FFF;">VTA. EXENTA</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:12%; background-color:#000; color:#FFF;">VTA. AFECTADAS</td>
					</tr>';
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$descripcion = strtoupper($pro->descrip).' '.strtoupper($pro->notas);
						$totalLeng = strlen($descripcion);	
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.abs($pro->cantidad).'</td>
								<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:45%;">'.$descripcion.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:11%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 12px; width:12%;">'.$vnGravada.'</td>
							</tr>';
					}
					
					if($totalLeng > 48){
						$numProd = $numProd + 2;
					}else{
						$numProd++;
					}
				}
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>';
				}
				
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:60%; background-color:#000; border-right:solid 1px #FFF; color:#FFF; border-left:solid 1px #000;">Observaciones</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:28%; background-color:#000; color:#FFF; border-right:solid 1px #000;">Total</td>
					</tr>
					<tr style="width:100%; padding:0px;">
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:60%; border-right:solid 1px #000; border-left:solid 1px #000; border-bottom: solid 1px #000;">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:28%; border-right:solid 1px #000; border-bottom: solid 1px #000;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 15px; width:100%;"></td>
                    </tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.strtoupper($info->nameVendedor).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:28%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;">'.$info->duivendedor.'</td>
                    </tr>';
				
				$estructura .= '</table>';
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
                    </tr>
                    <tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
				    </tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				/*$js = 'print(true);';
				$pdf->IncludeJS($js);*/
                $pdf->Output($nombre_archivo, 'I');
			}
		}
	}
?>