<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller {
        
        function __construct() {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
            //$this->load->model('pdfs_model');
        }
        
		public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            # definimos unos valores por defecto para el navegador y el sistema operativo
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            # buscamos el navegador con su sistema operativo
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            # obtenemos el sistema operativo
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
            # devolvemos el array de valores
            return $info;
        }
        
        function factura_pdf_nuevo($numero){
           
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );

            $this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
                redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            /*$img = file_get_contents('http://example.com/wp-content/themes/example/map_image_leasing.php/?city=Calgary&suit_type=&min_area=&max_area=');
                $pdf->Image('@' . $img, 55, 19, '', '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);*/

            /*
            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => true,
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255),
                'text' => true,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            $pdf->write1DBarcode('RIGHT', 'C128A', '', '', '', 15, 0.4, $style, 'N');*/

            $estructura = '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                <td></td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                            </tr>
                          </table>';


            $estructura .= '<br><br><table style="width:100%;">
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                            /*if(isset($imagen) and $imagen!=""){
                                $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                            }*/

                                
            $estructura .='     </td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                            </tr>
                            <tr style="border-collapse:separate; border-spacing:12px;">
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                        <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                    </tr>';
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
                            <tr>
                                <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                            </tr>
                            <tr>
                                <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                            </tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases </td>
                                    <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                </tr>';

                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
                        
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';

            }    

            $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


            $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                            </tr>
                        </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function orden_pedido($trannum){
            
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(5, 5, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );
            
            $this->load->model('pedclientes_model');
            $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
                
            $sucursal = strtoupper($dataPedido['pedidoSuc']);
            $pedido = $dataPedido['trannum'];
            $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
            $cli_name = $dataPedido['descrip'];
            $cli_phone = $dataPedido['cli_phone'];
            $cli_email = $dataPedido['cli_email'];
            $notas = $dataPedido['notas'];
            $dev_date = ucwords($dataPedido['fechaPedido']);
            $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
            if($dataPedido['dev_place'] == 1){
                $lugar = $dataPedido['nameSucursal'];
            }else{
                $lugar = $dataPedido['dev_direc'];    
            }
            $dev_contact = $dataPedido['dev_contact'];
            $dev_phone =$dataPedido['dev_phone'];
            $valPedido = $dataPedido['val_pro'];
            $valEnvio = $dataPedido['val_envio'];
            $valVenta = $dataPedido['val_tot'];
            $valAnti = $dataPedido['val_anti'];
            
            $tamano = strlen($trannum);
            $codbar = "";
                
            if($tamano==1){
                $codbar = "00000".$pedido;
            }elseif($tamano==2){
                $codbar = "0000".$pedido;
            }elseif($tamano==3){
                $codbar = "000".$pedido;
            }elseif($tamano==4){
                $codbar = "00".$pedido;
            }elseif($tamano==5){
                $codbar = "0".$pedido;
            }elseif($tamano==6){
                $codbar = $pedido;
            }
            
            $estructura = '<br><br><table style="width:100%;">
                                <tr>
                                    <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td></td>
                                    <td style="font-size:12px; text-align:right;">ORDEN DE PEDIDO<br>'.strtoupper($this->session->userdata('appName')).'<br><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                </tr>
                            </table><br><br>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Nombre de Cliente:</td>
                                    <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:30%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                </tr>
                            </table>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;">'.$cli_name.'</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Teléfono: <strong>'.$cli_phone.'</strong>&nbsp;&nbsp;Correo: <strong>'.$cli_email.'</strong></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Sucursal</td>
                                    <td style="font-size:10px; text-align:right; width:15%; border: 1px solid #6E6E6E;">'.$sucursal.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:15%; border: 1px solid #6E6E6E; color:#0B486B;">'.$trannum.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                            </table>';
            
             $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_date.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:90%; border: 1px solid #6E6E6E;" colspan="3">'.$lugar.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Contacto</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_contact.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Teléfono</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #6E6E6E;">'.$dev_phone.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                    <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                </tr>';
            foreach($list_producto as $key){
                $subtotal = $key->cantidad * $key->precioneto;
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                    <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                    <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                    <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:9px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Sub-total</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valPedido.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Envio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valEnvio.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Suma</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valVenta.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Anticipo</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.$valAnti.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-bottom: 1px solid #6E6E6E; border-left: 1px solid #6E6E6E;"></td>
                                    <td style="font-size:12px; text-align:left; border-bottom: 1px solid #6E6E6E; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; border-bottom: 1px solid #6E6E6E; font-weight: bold; width:10%;">Pendiente</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-bottom: 1px solid #6E6E6E; border-right: 1px solid #6E6E6E;">$'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                                </tr>';
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas.'</td>
                                </tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                            </table><br><br><br>';
                $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';
            
            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ticket_pedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P', $pagelayout);

                $this->load->model('pedclientes_model');
                $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                
                $sucursal = strtoupper($dataPedido['pedidoSuc']);
                $pedido = $dataPedido['trannum'];
                $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
                $cli_name = $dataPedido['descrip'];
                $cli_phone = $dataPedido['cli_phone'];
                $cli_email = $dataPedido['cli_email'];
                $dev_date = ucwords($dataPedido['fechaPedido']);
                $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
                if($dataPedido['dev_place'] == 1){
                    $lugar = $dataPedido['nameSucursal'];
                }else{
                    $lugar = $dataPedido['dev_direc'];    
                }
                $dev_contact = $dataPedido['dev_contact'];
                $dev_phone =$dataPedido['dev_phone'];
                $dev_phone =$dataPedido['dev_phone'];
                $valPedido = $dataPedido['val_pro'];
                $valEnvio = $dataPedido['val_envio'];
                $valVenta = $dataPedido['val_tot'];
                $valAnti = $dataPedido['val_anti'];

                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE '.strtoupper($this->session->userdata('appName')).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';
                        
                        $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pedido</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 24px; width:50%; font-weight: bold;">Producto</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Cant</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Precio</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 24px; width:18%; font-weight: bold;">Sub-total</td>
                            </tr>';
                        
                        foreach($list_producto as $key){
                            $subtotal = $key->cantidad * $key->precioneto;
                            $estructura .= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 20px; width:50%;">'.$key->descrip.'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">'.round($key->cantidad).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                
                $estructura .= '</table>';
                
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PEDIDO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valPedido, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valEnvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valVenta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valAnti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                            </tr>
                        </table>';
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_pedido_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                    
            }
        
        }
        
        function ticket_nuevo($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage( 'P',$pagelayout);

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

                if(is_array($products) && $products!=false){
                    $sucursal = strtoupper($products['descrip']);
                    $pedido = $products['numero'];
                    $cli_name = $products['cli_name'];
                    $cli_phone = $products['cli_phone'];
                    $date = date_format(date_create($products['date']),'d/m/Y');
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_refund = $products['val_refund'];
                    $tpastel = $products['val_pastel'];
                    $taccesorios = $products['val_acc'];
                    $tbases = $products['val_bases'];
                    $tenvio = $products['val_envio'];

                    $cli_email = $products['cli_email'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $imagen = $products['pastel_fotos'];
                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $dev_contact = $products['dev_contact'];
                    $dev_phone = $products['dev_phone'];

                    $lugar = "";
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3) {
                        $lugar = "Recoger en Producción";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];

                    $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                }else{
                    redirect('pedidos_clientes/pasteles_al_gusto/');
                }

        
                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE PASTELES</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date2.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';

                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                        
                     $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pastel</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Tortas:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cktortas.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Porciones:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$ckslices.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Referencia:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$catreference.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Dedicatoria:</td>
                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';
                    
                    $i = 1;
                    foreach($arrayPasteles as $key => $value){

                        $estructura .= '<table style="width:100%;">
                                            <tr>
                                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Torta '.$i.' </td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Posición:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_position'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Forma:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_shape'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Relleno:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_filling'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Sabor:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_flavor'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Baño:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_bath'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Cobertura:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_covering'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Color:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_color'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px;font-weight: bold; width:30%;">Notas:</td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.ucwords($value['notas']).'</td>
                                            </tr>
                                        </table>';
                        $i++;
                    }
                }

                if($accesorios!=false){

                    $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>ACCESORIOS </td>
                            </tr>';
        
                    foreach($accesorios as $key => $value){
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                       </tr>';
                    }

                    $estructura .= '</table>';
                }

                if($bases!=false){

                    $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>BASES </td>
                                </tr>';
        
                    foreach ($bases as $key => $value) {
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                        </tr>';
                    }
                    
                    $estructura .= '</table>';
                }

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline;"><br><br>OBSERVACIONES </td>
                            </tr>
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-size: 28px;">'.$dev_notes.'</td>
                            </tr></table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PASTEL $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tpastel, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ACCESORIOS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($taccesorios, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">BASES $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tbases, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tenvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">REEMBOLSABLE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function ordenes_pdf($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }

                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    /*if(isset($imagen) and $imagen!=""){
                        $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                    }*/
                    $estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#6E6E6E;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #6E6E6E;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #6E6E6E; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #6E6E6E; width:94.5%;"><label style="color:#6E6E6E;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #6E6E6E;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #6E6E6E;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #6E6E6E;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #6E6E6E;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #6E6E6E;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #6E6E6E;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #6E6E6E;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #6E6E6E; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #6E6E6E; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function lista_pdf_nuevo_todo($fecha, $estado){

            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS');
                $pdf->SetSubject('LISTADO DE PEDIDOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(1, 2, 1);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 2);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', 'LETTER' );
                
                $fechai = $fecha;
                $fechaf = $fecha;
                if($fechai=="" || $fechaf=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
        
                $sucursales = $this->produccion_model->getPedidosClientes_by_Sucursal(1,$fechai,$fechaf,$estado,1);
                $tdomicilio = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,2);
                $tproduccion = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,3);
                $pedidos_sucursal = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,1);
                $pedidos_domicilio = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,2);
                $pedidos_produccion = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,3);

                $estructura = '';

                $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px;">'.$titulo.'</td>
                                </tr>
                            </table><br><br><br>';

                if($pedidos_sucursal!=false || $pedidos_domicilio!=false || $pedidos_produccion!=false){

                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:18%;">Cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Referencia</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:51%;">Detalles</td>
                                </tr>
                                <tr><td colspan="6"><hr></td></tr>
                            </table>';
                    
                    if(is_array($sucursales) && $sucursales!=false){                
                        foreach ($sucursales as $key => $value) {
                            $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">'.$value['devdirec2'].' ('.$value['totalpedidos'].')</td>
                                </tr>';
                            
                            foreach ($pedidos_sucursal as $key2 => $value2) {
                                
                                if($value['dev_direc']==$value2['dev_direc']){
                                    $cktortas = $value2['ck_tortas'];
                                    $ckslices = $value2['porciones'];
                                    
                                    if($value['dev_direc']==$value2['dev_direc']){
                                        $estructura.= '<tr>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                                        $i=0;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }

                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                                        $i2 = 1;

                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }
                                        
                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb) {
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                $i3++;  
                                            }
                                        }
                                        $estructura.= '</td>
                                            </tr>
                                            <tr><td colspan="6"><hr></td></tr>'; 
                                    }
                                }
                            }
                            $estructura.= '</table>';
                        }
                    }
                    /****************************/
                    if(is_array($pedidos_domicilio) && $pedidos_domicilio!=false){                
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';

                        foreach ($pedidos_domicilio as $key2 => $value2) {
                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                            
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                            
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep){
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                           }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea){
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                
                                foreach ($arrayBases as $keyb => $valueb){
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                    
                        }

                        $estructura.= '</table>';
            
                    }
                    /****************************/
                    
                    /****************************/
                    if(is_array($pedidos_produccion) && $pedidos_produccion!=false){                
                     
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">PRODUCCIÓN ('.$tproduccion.')</td>
                                </tr>';
                        
                        foreach ($pedidos_produccion as $key2 => $value2) {

                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                   
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).','. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }
                            
                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }
                            
                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                        }
                    
                        $estructura.= '</table>';
            
                    }
                  
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
                $nombre_archivo = utf8_decode("listado_pedidos.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function reporte_por_hora($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetSubject('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $fechai = $fecha;
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');

                $horas = $this->produccion_model->get_horas_por_pedido($fechai,$estado);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS POR HORA</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';

                $estructura2.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">Porciones</td>
                                </tr>
                            </table>';                            
                
                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );


                if($horas!=false){
                    if(is_array($horas) && $horas!=false){                
                        foreach ($horas as $key_horas => $value_horas){
                            $estructura.= '<table style="width:100%;">
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_horas['hora'].' ('.$value_horas['npedidosporhora'].')</td>
                                            </tr>';

                            $sucursales = $this->produccion_model->get_sucursales_por_hora_por_pedido($fechai,$estado,$value_horas['dev_time'],1);

                            if(is_array($sucursales) and $sucursales!=false){
                                foreach ($sucursales as $key_sucursales => $value_sucursales) {
                                    $estructura.= '<tr>
                                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                                   </tr>';

                                    $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],1,$value_sucursales['dev_direc']);

                                    if(is_array($pedido) and $pedido!=false){
                                        foreach ($pedido as $key_pedido => $value_pedido) {
                                            $estructura.= '<tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                           </tr>
                                                           <tr>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                           </tr>
                                                           <tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                            $i=1;
                                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                                //$i = count($arrayPasteles);
                                                foreach ($arrayPasteles as $keyp => $valuep) {
                                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                    $i++;  
                                                }
                                            }

                                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                            $i2 = 1;

                                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                                $estructura.= '<b>ACCESORIOS:</b> ';
                                                foreach ($arrayAccesorios as $keya => $valuea) {
                                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                    $i2++;  
                                                }
                                            }

                                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                            $i3 = 1;
                                            
                                            if(is_array($arrayBases) and $arrayBases!=false){
                                                //$i3 = count($arrayBases);
                                                $estructura.= '<b>Bases:</b> ';
                                                foreach ($arrayBases as $keyb => $valueb) {
                                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                    $i3++;  
                                                }
                                            }
                                            $estructura.='</td>
                                            </tr>';
                                        }
                                    }
                                }
                            }

                            $tdomicilio = $this->produccion_model->getCount_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2);

                            if($tdomicilio!=false){
                                $estructura.= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';
                                
                                $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2,'');

                                if(is_array($pedido) and $pedido!=false){
                                    foreach ($pedido as $key_pedido => $value_pedido) {
                                        $estructura.= '<tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                       </tr>
                                                       <tr>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                       </tr>
                                                       <tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                            <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                        $i=1;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            //$i = count($arrayPasteles);
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }
                                        
                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                        $i2 = 1;
                                        
                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }

                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb){
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']);
                                                $i3++;  
                                            }
                                       }

                                        $estructura.='</td>
                                        </tr>';
                                    }
                                }
                            }
                            
                            $estructura.= '</table>';
                        }
                    }
           
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("listado_pedidos_por_hora.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_de_despacho($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE DE DESPACHO');
                $pdf->SetSubject('REPORTE DE DESPACHO');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $fechai = $fecha;
                
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
                
                $sucursales = $this->produccion_model->get_sucursales_reporte_de_despacho($fechai,$estado,1);
                $domicilio = $this->produccion_model->get_total_pedidos_por_dev_place($fechai,$estado,2);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE DE DESPACHO</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';
                     
                $estructura2.= '<table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Hora</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Porciones</td>
                    </tr>
                </table>';                            

                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

            
                if(is_array($sucursales) && $sucursales!=false){    
                    foreach ($sucursales as $key_sucursales => $value_sucursales){
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                </tr>';
                 
                        $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,1,$value_sucursales['dev_direc']);
                 
                        if(is_array($pedidos) and $pedidos!=false){
                            foreach($pedidos as $key_pedido => $value_pedido){
                                $estructura.= '<tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                               </tr>
                                               <tr>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                               </tr>
                                               <tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                    <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                $i=1;
                                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                    //$i = count($arrayPasteles);
                                    foreach ($arrayPasteles as $keyp => $valuep){

                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';

                                      $i++;  
                                    }
                                }

                                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                $i2 = 1;
                                
                                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                    //$i2 = count($arrayAccesorios);
                                    $estructura.= '<b>ACCESORIOS:</b> ';
                                    foreach ($arrayAccesorios as $keya => $valuea){
                                        $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                        $i2++;  
                                    }
                                }

                                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                $i3 = 1;

                                if(is_array($arrayBases) and $arrayBases!=false){
                                    //$i3 = count($arrayBases);
                                    $estructura.= '<b>Bases:</b> ';
                                    foreach ($arrayBases as $keyb => $valueb){
                                        $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                        $i3++;  
                                    }
                                }

                                $estructura.='</td>
                                </tr>';
                            }
                        }
                
                        $estructura.= '</table>';
                    }
                }
                
                if($domicilio!=0){
                       
                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>DOMICILIO ('.$domicilio.')</td>
                                </tr>';
                    
                    $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,2,"");
                 
                    if(is_array($pedidos) and $pedidos!=false){
                        foreach ($pedidos as $key_pedido => $value_pedido){
                            $estructura.= ' <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;"><b>DIRECCIÓN:</b> '.trim($value_pedido['dev_direc']).', <b>PREGUNTAR POR:</b> '.trim($value_pedido['dev_contact']).', <b>TELÉFONO:</b> '.trim($value_pedido['dev_phone']).'
                                                </td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                            $i=1;
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                //$i2 = count($arrayAccesorios);
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }

                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                //$i3 = count($arrayBases);
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.='</td>
                            </tr>';
                        }
                    }
                    $estructura.= '</table>';
                }
                
           
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_producto_sucursal($fecha, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE CONTROL PRODUCCION');
                $pdf->SetSubject('REPORTE CONTROL PRODUCCION');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $header = '     <table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE CONTROL PRODUCCIÓN</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA <strong>'.date_format(date_create($fecha), 'd/m/Y').'</strong></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    </tr>
                                </table><br><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $this->load->model('tpedido_model');
                
                $salas_venta = $this->tpedido_model->getNameSalasdeVenta();
                                                
                $lst_productos = explode("_", $productos);
                $tot = count($lst_productos);
                $total_ = $tot - 1;
                if($total_ >= 12){
                    $tamano = 90 / 12;    
                }else{
                    $tamano = 90 / $total_;    
                }
                
                $pdf->addPage('L', 'LETTER');
                $estructura = ' <table style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th style="background-color:#F0F0F0; color:#FFFFFF; width:10%; height:25px; font-size:14px; text-align:center; vertical-align:middle; border-style:solid; border-width: 1px 1px 1px 1px;"></th>';
                    for($j=0; $j<$total_; $j++){
                        $name = $this->tpedido_model->getNameProducto($lst_productos[$j]);
                        $estructura .= '    <th style="width:'.$tamano.'%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.$name.'</th>';            
                    }                        
                //$estructura .= '            <th style="width:10%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>TOTAL</th>';
                $estructura .= '        </tr>
                                    </thead>';
                
                foreach($salas_venta as $sv){
                    $sum_ = 0;
                    $estructura .=' <tbody>
                                        <tr>
                                            <td style="text-align:left; background-color:#F0F0F0; color:#000000; width:10%; height:35px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>'.$sv->descrip.'</strong></td>';
                        for($j=0; $j<$total_; $j++){
                            $cantidad = $this->tpedido_model->getCantProducto($lst_productos[$j], $fecha, $sv->idcentro);
                            if($cantidad == "0" || $cantidad == ""){
                                $cantidad = "";    
                            }else{
                                $cantidad = round($cantidad);
                            }
                            $estructura .= '<td style="width:'.$tamano.'%; height:35px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>'.$cantidad.'</td>';            
                            $sum_ += $cantidad;
                        }                       
                    $estructura .= '    </tr>';
                }
                $estructura .= '        <tr>
                                            <td style="text-align:center; background-color:#F0F0F0; color:#000000; width:10%; height:30px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>TOTAL</strong></td>';
                for($j=0; $j<$total_; $j++){
                    $sum_total = $this->tpedido_model->getTotalProducto($lst_productos[$j], $fecha);
                    $estructura .= '    <td style="width:'.$tamano.'%; height:30px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#A80000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.round($sum_total).'</td>';
                }
                $estructura .= '        </tr>';
                $estructura .= '    <tbody>    
                                </table>';
                
                $estructura .= '<style>
                                    .sucursales{
                                        color:#000000; 
                                        font-size:11px; 
                                    }
                                </style>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_emision.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteComprasLocales($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('COMPRAS LOCALES');
                $pdf->SetSubject('COMPRAS LOCALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                
              
                
                
                 $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>RECIBIDA</strong></label></td>
                                    </tr>
                                </table></center><br><br>';
                
                foreach($informacion as $inf){
                
                $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$idrec.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#E8E8E8; font-size:12px; text-align:right;" width="50%"><strong>Fecha Ingreso: '.date_format(date_create($inf->fecha), 'd/m/Y').' </strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Referencia Interna:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->descrip.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->referencia.'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Numero de Documento:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Solicitado Por:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->serie.''.$inf->numero.'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.$inf->solicita.'</td>
                                    </tr>
                                    
                                </tbody>
                    </table><br><br>
                     ';
                    
                
               }
                
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                 $pdf->addPage( 'P', 'LETTER' );
                
                
                
                $titulo='
                  
                <table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:37%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                        <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                                      </tr>
                                </thead>
                    <tbody>';
                
                foreach($productos as $pro){
                    
                   
                    $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                                <td style="width:37%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                                <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->preciotran.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">$'.($pro->cantidad * $pro->preciotran ).'</td></tr>';
                           
                    
                }
                
                 $titulo.='
                    </tbody>
                    </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Detalle_ComprasLocales_".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                
            
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
         
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);


                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'n');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 6:
                        $mes_name = "Julio";
                        break;
                    case 6:
                        $mes_name = "Agosto";
                        break;
                    case 6:
                        $mes_name = "Septiembre";
                        break;
                    case 6:
                        $mes_name = "Octubre";
                        break;
                    case 6:
                        $mes_name = "Noviembre";
                        break;
                    case 6:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name.", ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        $subtotal = $key->cantidad * $key->precioneto; 
                        if($key->tipotax==0){
                            $subtotal = $key->cantidad * $key->precioneto; 
                            $exento = $exento + $subtotal;
                        }else if($key->tipotax==13){
                            $gravado += $subtotal;      
                            $iva =  $iva + ($subtotal * ($key->tipotax/100));
                        }
                        $sub_total = $exento + $gravado + $iva;
                    }
                }

                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:40%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$formaPago.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #6E6E6E;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>
                                </table>';

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #6E6E6E;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #6E6E6E;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #6E6E6E;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #6E6E6E;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #6E6E6E;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #6E6E6E;">Cant.</td>
                                        <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #6E6E6E;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        $subtotal = $key->cantidad * $key->precioneto; 
                                        $estructura .= '<tr>
                                                            <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                                            <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 4, '.', '').'</td>
                                                            <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($subtotal, 4, '.', '').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #6E6E6E;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($exento, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($gravado, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;">$'.number_format($iva, 4, '.', '').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #6E6E6E;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; ">$'.number_format($sub_total, 2, '.', '').'</td>
                                    </tr>';
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="4">Observaciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #6E6E6E;" colspan="4" rowspan="5">'.$notas_orden.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Proveedor</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#6E6E6E;"><br>Firma de Cliente</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px;"><br>Es indispensable presentar esta orden de compra al entregar el producto en nuestra bodega.<br><br></td>
                                    </tr>
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #6E6E6E;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #6E6E6E;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                 $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #6E6E6E; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #6E6E6E;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #6E6E6E; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #6E6E6E; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #6E6E6E;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #6E6E6E;">
                    <th style="border-bottom: 1px solid #6E6E6E; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                        if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                        }
                       
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo && $lin->cant!=0){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #6E6E6E; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #6E6E6E; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                
                
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    
                     
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                
          
                
                
                }
                    

                
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               
                $funcion = $this->uri->segment(3);
               
               
                
                $this->load->model('global_model');
                
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                                                                        
                
                
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                
                $apps = $this->apps_model->verApps();
                
               // $this->load->model('variable_model');
              //  $nombres = $this->variable_model->verNombres();
              //  $variables = $this->variable_model->verVariables();
                

                
                
                 
               
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                            
                            
                            
                            if($key2->menutype == 1){
                            
                            $titulo .= '<tr>
                                            <td width="3%"></td>
                                            <td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
                                        </tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function asistencia_curso($idcurso, $inicio, $fin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                $fecha_actual = date("Y-m-d");
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'cm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Asistencias');
                $pdf->SetSubject('Asistencias');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_RIGHT, 40, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
               
                $this->load->model('acs_model');
                $info_curso = $this->acs_model->getInfoCurso($idcurso);

                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">Reporte de Asistencias</label><br><label style="text-align:center; font-size:13px;">Periodo del '.date_format(date_create($inicio),'d/m/Y').' al '.date_format(date_create($fin),'d/m/Y').'</label></center>';
                foreach($info_curso as $inf){
                $header.= '<br><br><table style="width:100%; border:#CCCCCC solid 0.1px;">
                            <tbody>
                            <tr style="border-top:#CCCCCC solid 0.1px; border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px; padding-right:1px; padding-left:1px;">
                                <th style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;color:#999999; text-align:center;">Campus</th>
                                <th style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;color:#999999; text-align:center;">Carrera</th>
                                <th style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;color:#999999; text-align:center;">Días</th>
                                <th style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;color:#999999; text-align:center;">Horario</th>
                                <th style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;color:#999999; text-align:center;">Instructor</th>
                            
                            </tr>
                            <tr style="border-top:#CCCCCC solid 0.1px; border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px; padding-right:1px; padding-left:1px;">
                                <td style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;text-align:center;">'.$inf->campus.'</td>
                                <td style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;text-align:center;">'.$inf->carrera.'</td>
                                <td style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;text-align:center;">'.$inf->dias.'</td>
                                <td style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;text-align:center;">'.$inf->horario.'</td>
                                <td style=" border-right:#CCCCCC solid 0.1px;border-left:#CCCCCC solid 0.1px;text-align:center;">'.$inf->worker.'</td>
                            </tr>
                            </tbody>
                            </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'L', 'LETTER' );
                
                $students = $this->acs_model->getAlumnosInscritos($idcurso);
                $datos_curso = $this->acs_model->getDataRegistro($idcurso);
                foreach($datos_curso as $dat){
                    $dias = $dat->dias;
                }
                $cant=0;
                $lunes=0;
                $martes=0;
                $miercoles=0;
                $jueves=0;
                $viernes=0;
                $sabado=0;
                $domingo=0;
            
                $dias = strtolower($dias);
                $cant_lunes = substr_count($dias, 'lunes');
                if($cant_lunes>0){
                    $lunes++; 
                }
                $cant_martes = substr_count($dias, 'martes');
                if($cant_martes>0){
                    $martes++; 
                }
                $cant_miercoles = substr_count($dias, 'miercoles');
                if($cant_miercoles>0){
                    $miercoles++; 
                }
                $cant_miercoles = substr_count($dias, 'miércoles');
                if($cant_miercoles>0){
                    $miercoles++; 
                }
                $cant_jueves = substr_count($dias, 'jueves');
                if($cant_jueves>0){
                    $jueves++; 
                }
                $cant_viernes = substr_count($dias, 'viernes');
                if($cant_viernes>0){
                   $viernes++; 
                }
                $cant_sabado = substr_count($dias, 'sabado');
                if($cant_sabado>0){
                   $sabado++; 
                }
                $cant_sabado = substr_count($dias, 'sábado');
                if($cant_sabado>0){
                   $sabado++; 
                }
                $cant_domingo = substr_count($dias, 'domingo');
                if($cant_domingo>0){
                   $domingo++; 
                }
            
                $fecha_fin_format = date($fin);
                if($fecha_fin_format>$fecha_actual){
                    $fin = $fecha_actual;
                }
                $cant_meses=0;
                $cant=0;
                $list_fechas = '';
                $list_dias = '';
                $dias_mes = 0;
                $mes_anterior = 0;
                $cont=0;
                for($i=$inicio;$i<=$fin; $i = date("Y-m-d", strtotime($i ."+ 1 days"))){
                    $cont++;
                    $myDateTime = DateTime::createFromFormat('Y-m-d', $i);
                    $formattedweddingdate = $myDateTime->format('d-m');
                    $num_mes = $myDateTime->format('m');
                    $numerodia=date("w", strtotime($i));
                    
                    if($numerodia==0 && $domingo>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                        
                    }
                    if($numerodia==1 && $lunes>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                    if($numerodia==2 && $martes>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                    if($numerodia==3 && $miercoles>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                    if($numerodia==4 && $jueves>0){
                       $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                    if($numerodia==5 && $viernes>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                    if($numerodia==6 && $sabado>0){
                        $cant++;
                        if($cont==1){
                            $mes_anterior = $num_mes;
                            $list_fechas.= $num_mes.',';
                            $dias_mes++;
                        }else{
                            if($mes_anterior==$num_mes){
                                $dias_mes++;
                            }else{
                                $list_fechas.=$num_mes.',';
                                $list_dias .= $dias_mes.',';
                                $mes_anterior = $num_mes;
                                $dias_mes=1;
                                $cant_meses++;
                            }
                        }
                    }
                }
                if($cant_meses>0){
                    $list_dias .= $dias_mes.',';
                }
                
                $width=60/$cant;
                $titulo='<table style="width:100%;  border-collapse: collapse;">
                <thead><tr style="width:100%; border-collapse:separate; border-spacing:12px;"><th style="width:30%;"></th>';
                    
                $fechas_list = explode(',', $list_fechas);
                $dias_pormes = explode(',', $list_dias);
                $total = count($fechas_list);
                $total = $total-1;
                for($i=0; $i<$total; $i++){
                    if($dias_pormes[$i]==0){
                        $u = $i+1;
                    }else{
                        $u = $i;
                    }
                    switch($fechas_list[$i]){
                        case 1:
                            $ancho = $dias_pormes[$u]*$width;
                            $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Enero</th>';
                            break;
                        case 2:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Febrero</th>';
                            break;
                        case 3:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Marzo</th>';
                            break;
                        case 4:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Abril</th>';
                            break;
                        case 5:
                            $ancho = $dias_pormes[$u]*$width;
                            $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E;background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Mayo</th>';
                            break;
                        case 6:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E;background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Junio</th>';
                            break;
                        case 7:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E;background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Julio</th>';
                            break;
                        case 8:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Agosto</th>';
                            break;
                        case 9:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Septiembre</th>';
                            break;
                        case 10:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Octubre</th>';
                            break;
                        case 11:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Noviembre</th>';
                            break;
                        case 12:
                            $ancho = $dias_pormes[$u]*$width;
                             $titulo.='<th style="width: '.$ancho.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;" colspan="'.$dias_pormes[$i].'">Diciembre</th>';
                            break;
                    }
                }
                $titulo.='<th style="width:30%;"></th></tr>';
                
                $titulo.='<tr style="width:100%; border-collapse:separate; border-spacing:12px;">
                <th  style="width:30%;border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:left;vertical-align:middle;">Nombre de estudiante</th>';
                // '.$list_fechas.' - '.$list_dias.'
                $where_fechas='';
                $diaanterior=0;
                for($i=$inicio;$i<=$fin; $i = date("Y-m-d", strtotime($i ."+ 1 days"))){
                    $myDateTime = DateTime::createFromFormat('Y-m-d', $i);
                    $formattedweddingdate = $myDateTime->format('d-m');
                    $solo_dia = $myDateTime->format('d');
                    $numerodia=date("w", strtotime($i));
                    
                    if($numerodia==0 && $domingo>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                        
                    }
                    if($numerodia==1 && $lunes>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                    if($numerodia==2 && $martes>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                    if($numerodia==3 && $miercoles>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                    if($numerodia==4 && $jueves>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                    if($numerodia==5 && $viernes>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                    if($numerodia==6 && $sabado>0){
                        if($diaanterior>$solo_dia){
                            $titulo.='<th style="width: '.$width.'%; border-left: 1px solid #6E6E6E;border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }else{
                            $titulo.='<th style="width: '.$width.'%; border-bottom:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">'.$solo_dia.'</th>';
                        }
                        $where_fechas.=$i.',';
                        $diaanterior=$solo_dia;
                    }
                }
                $titulo.='<th style="width: 10%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;">Totales</th>';
                        
                $titulo.='</tr></thead>';
                $info_att = $this->acs_model->getallattendance($idcurso,$where_fechas);
                $titulo.='<tbody>';
                if(is_array($info_att) and $info_att!=false){
                    foreach($info_att as $key => $value){
                        $titulo.='<tr style="border-bottom:1px solid #E8E8E8; width:100%;border-collapse:separate; border-spacing:12px;">
                        <td style="width:30%; border-bottom:1px solid #E8E8E8; font-size:10px; text-align:left;vertical-align:middle;">'.$value["studentName"].'</td>';
                        $fechas_list = explode(',', $where_fechas);
                        $total = count($fechas_list);
                        $total = $total-1;
                        $presentes=0;
                        $ausentes=0;
                        $permiso=0;
                        for($i=0; $i<$total; $i++){
                            $valor = $value['att'.$i];
                            if($valor==0){
                                //ausente
                                $ausentes++;
                                $src=base_url().'img/att_uncheck.png';
                                $titulo.='<td style="width: '.$width.'%; border-bottom:1px solid #E8E8E8; font-size:10px; text-align:center;"><img style="padding-top:2px;padding-bottom:2px;width: 20px; height: 20px;" src="'.$src.'"></td>';

                            }else if($valor==1){
                                //presente
                                $presentes++;
                                $src=base_url().'img/att_check.png';
                                $titulo.='<td style="width: '.$width.'%; border-bottom:1px solid #E8E8E8; font-size:10px; text-align:center;"><img style="padding-top:2px;padding-bottom:2px;width: 20px; height: 20px;" src="'.$src.'"></td>';

                            }else if($valor==2){
                                //permiso
                                $permiso++;
                                $src=base_url().'img/att_perm.png';
                                $titulo.='<td style="width: '.$width.'%; border-bottom:1px solid #E8E8E8; font-size:10px; text-align:center;"><img style="padding-top:2px;padding-bottom:2px;width: 15px; height: 15px;" src="'.$src.'"></td>';
                            }else{
                                $src=base_url().'img/att_no.png';
                                $titulo.='<td style="width: '.$width.'%; border-bottom:1px solid #E8E8E8; font-size:10px; text-align:center;"></td>';
                            }
                        }
                        $titulo.='<td style="width:10%; border-bottom:1px solid #E8E8E8; font-size:12px;  text-align:center;color:#413D3D;">'.$presentes."-".$ausentes."-".$permiso.'</td></tr>';
                    }
                }
                
                $titulo.='<tr><th style="width:30%;color: #031634; font-size:12px; text-align:right;vertical-align:middle; font-size:12px; ">Totales</th>';
                
                $info_totales = $this->acs_model->gettotalAtt($idcurso,$inicio,$fin);   
                $total_general = $this->acs_model->getFullTotal($idcurso,$inicio,$fin);   
                if($total_general==""){
                    $total_general= '0-0-0 ';
                }
                $fechas_list = explode(',', $where_fechas);
                $total = count($fechas_list);
                $total = $total-1;
                for($i=0; $i<$total; $i++){
                    $found=false;
                    foreach($info_totales as $tot){
                        if($tot->fecha==$fechas_list[$i]){
                            $titulo.='<th style="width: '.$width.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;">'.$tot->cantidad.'</th>';
                            $found=true;
                        }
                    }
                    if($found==false){
                        $titulo.='<th style="width: '.$width.'%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px;  font-size:12px;  text-align:center;vertical-align:middle;">0-0-0</th>';
                    }
                
                }
                
                $titulo.='<th style="width:10%; border:1px solid #6E6E6E; background-color:#E8E8E8;  color: #031634; font-size:12px; text-align:center;vertical-align:middle;">'.$total_general.'</th></tr>';
                $titulo.='</tbody></table>';
                
                $src2=base_url().'img/att_uncheck.png';
                $src1=base_url().'img/att_check.png';
                $src3=base_url().'img/att_perm.png';

                
                $titulo.='<br><br><table style="width:20%; border: 1px solid #6E6E6E;">
                <tr><td style="width:60%;text-align:right;">Presentes</td><td  style="width:40%; text-align:left;"><img style="padding-top:2px;padding-bottom:2px;width: 20px; height: 20px;" src="'.$src1.'"> </td></tr>
                <tr><td style="width:60%;text-align:right;">Ausentes</td><td  style="width:40%; text-align:left;"><img style="padding-top:2px;padding-bottom:2px;width: 20px; height: 20px;" src="'.$src2.'"> </td></tr>
                <tr><td style="width:60%;text-align:right;">Permiso</td><td  style="width:40%; text-align:left;"><img style="padding-top:2px;padding-bottom:2px;width: 15px; height: 15px;" src="'.$src3.'"> </td></tr>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');    
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Asistencia_curso".$idcurso.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			switch ($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "90";
					else if ($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "80";
					else if ($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "70";
					else if ($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "60";
					else if ($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "50";
					else if ($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "40";
					else if ($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "30";
					else if ($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "20";
					else if ($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "10";
					else if ($numero == 11)
						return "11";
					else if ($numero == 12)
						return "12";
					else if ($numero == 13)
						return "13";
					else if ($numero == 14)
						return "14";
					else if ($numero == 15)
						return "15";
					else if ($numero == 16)
						return "16";
					else if ($numero == 17)
						return "17";
					else if ($numero == 18)
						return "18";
					else if ($numero == 19)
						return "19";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}

		function convertir_a_letras($numero){
			global $importe_parcial;

			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
        
        function facturaConsumidorFinal($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				//$this->load->library('Pdf');
                $width = 21.50;  
                $height = 14;
                $pagelayout = array($width, $height); 
                //$pdf = new Pdf('Portrait', 'cm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);
				
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(0, 10, 0,0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
				
				$pdf->addPage('P', 'LETTER' );
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('acs_model');
                $informacion = $this->ventas_model->getDatosFactura($trannum);
				
				// 5 <br> Adicionales para impresora Panasonic
				foreach($informacion as $info){
					$estructura = '<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:95%;"><br><br><br><br><br><br><br><br><br></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:59%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:41%;">N° '.$info->numero.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:8%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:92%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:91%;">'.$info->idcps.'-'.$info->nameCliente.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:91%;">'.$info->direccion.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:63%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:37%;">'.$info->nrc.'</td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
					</table>';
					
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				/*
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
					</tr>';*/
                
				
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 14px; width:3.5%;"></td>
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 14px; width:4.5%;">'.abs($pro->cantidad).'</td>';
						
						if($pro->tipo == 1){
							if($pro->barcode == null || $pro->barcode == "" || $pro->barcode == 0){
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:53%;">'.$pro->descrip.', '.$pro->notas.'</td>';
							}else{
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:53%;">'.$pro->descrip.', Pago de cuota '.$pro->barcode.'/12</td>';
							}
						}else{
							$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:53%;">'.$pro->descrip.'</td>';
						}
						
						$estructura .= '<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:8.5%;"></td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:7.5%;">'.$vnExenta.'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">'.$vnGravada.'</td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
						</tr>';
				}
				
				$estructura .= '</table>';
				
				$totalGravado = $total - $totalExento;
				
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
				}
						
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
				}
					
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:7%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:54%;">'.strtoupper($TotalLetras).'/100 US DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:17.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:7.5%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">'.$totalGravado.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:86%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">'.$totalGravado.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:86%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:86%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 14px; width:9%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');
				$nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				$js = 'print(true);';

				// set javascript
				//$pdf->IncludeJS($js);
				
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
		
		function VentasPorPeriodo($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 8%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6.5%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 23%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 32.5/$cnt;
				$porcentaje2 = 50/$cnt;
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    foreach($tipospagos as $tip){
                        $valpag[$tip->cajclase] = 0;
                    }
                    
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->tipoDoc.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc){
                         
                            $valtax_product = 0;
                            
                            
                            if($ven->exento == 0){
                                $valtax_product = $ven->valtax1;
                            }else{
                                $valtax=0;
                            }
                            
                            $valtot=$ven->valventan + $valtax_product;
							
                            $subtotal= $subtotal+$valtot;
                            
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
                                    //DEVOLUCION
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA - (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        //VENTA 
                                        $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                        $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                        $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax != 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                         $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax== 0 && $invexento == 0){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                        $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}else if($pro->tipotax == 0 && $invexento == 1){
                                    if($ven->inopera==1){
                                        $total = $total - (($pro->precioneto) * Math.abs($pro->cantidad));
                                        $totalExento = $totalExento - $pro->precioneto * abs($pro->cantidad);
                                    }else{
                                        $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									   $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                                    }
									
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:left; font-weight: normal; width: 8%">'.$ven->numeroserie.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 6.5%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 23%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtax_product, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($ven->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$-'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                            $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';

                                        }
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}
					}
                    $titulo .= '<tr>
						<th style="font-size:9px; text-align:left; font-weight: bold; width:10%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:35%;">Subtotal: $'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:35%; font-weight: bold;">Total: $'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
                $titulo .= '</tr></tbody></table>';
                $titulo .= '<br><br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                 $titulo .='<br><br><br><table>
                                <thead>
                                <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                    <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                    <tr style="border-bottom: 1px solid black;">
                                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';

                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
                    }
                    $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';

                    $titulo.='<tr style="border-bottom: 1px solid black;">
                                    <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                    $total_ing_sum=0;
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                    }

                    $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function ReporteVentasFacturas($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo Recibos');
                $pdf->SetSubject('Ventas Por Periodo Recibos');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(3, 30, 3, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
				
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	$resumen_tipos='';
				//$tipospagos = $this->ventas_model->getFormasPagoVN('VN');
				$documentos = $this->ventas_model->tipos_doc_ventas_facturas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentosAll = $this->ventas_model->tipos_doc_ventas2('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				
				$cnt = 0;
				$valpag = array();
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($this->session->userdata('appName')).'</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecentro).' (Del '.date_format(date_create($fechaini), 'd/m/Y').' al '.date_format(date_create($fechafin), 'd/m/Y').')</label><br><label style="text-align:center; font-size:15px;">'.strtoupper($namecaja).'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 10%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 30%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: 7.5%">Total</th>';
				$porcentaje = 25/$cnt;
				$porcentaje2 = 75/($cnt+1);
				foreach($tipospagos as $tip){
					$titulo .= '<th style="border-bottom: 1px solid black;font-size:8px; text-align:right; font-weight: bold; width: '.$porcentaje.'%">'.$tip->descrip.'</th>';
				}
                
				$colspan = 7 + $cnt;
				$titulo .='</tr>
                    </thead>
					<tbody>';
				
				$subtotal=0;
                $totalglobal=0;
                $totalexglobal=0;
                $totalgrglobal=0;
                $totalivglobal=0;
				$subtotalex = 0;
				$subtotalgr = 0;
				$subtotaliv = 0;
				$numdoc = 0;
				$numdocg = 0;
				foreach($documentos as $docs){
					$numdoc = 0;
					$subtotal=0;
					$subtotalex = 0;
					$subtotalgr = 0;
					$subtotaliv = 0;
                    $titulo .= '<tr><th colspan="'.$colspan.'"><br></th></tr><tr><th colspan="'.$colspan.'" style="font-size:12px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.$docs->descrip.'</th></tr>';
                    foreach($facturas as $ven){
						if($docs->tipoDoc == $ven->tipodoc && $docs->serie == $ven->serie){
							$valtot = $ven->valventan + $ven->valtax1;
							$subtotal= $subtotal+$valtot;
							$date = date_format(date_create($ven->fecha),'d/m/Y');
							
							$total = 0;
							$totalGravado = 0;
							$totalExento = 0;
							$totalIVA = 0;
							$invexento = $ven->exento;
							$productos = $this->invtran_model->getDataTran100k2($ven->trannum);
							
							foreach($productos as $pro){
								if($pro->tipotax != 0 && $invexento == 0){
									$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
									$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
									$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax != 0 && $invexento == 1){
									$total = $total + (($pro->precioneto * abs($pro->cantidad)));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax== 0 && $invexento == 0){
									$total = $total + (($pro->precioneto) * abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}else if($pro->tipotax == 0 && $invexento == 1){
									$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
									$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
								}
							}
							
							$subtotalex = $subtotalex + $totalExento;
							$subtotalgr = $subtotalgr + $totalGravado;
							$subtotaliv = $subtotaliv + $totalIVA;
							
							if($totalExento == 0){
								$totalExento = "";
							}else{
								$totalExento = "$".number_format(round($totalExento, 2), 2 ,'.','');
							}
							
							if($totalGravado == 0){
								$totalGravado = "";
							}else{
								$totalGravado = "$".number_format(round($totalGravado, 2), 2 ,'.','');
							}
							
							$namecliente = substr($ven->namecliente, 0, 37);
							$titulo .= '
								<tr>
									<td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$ven->numero.'</td>
                                    <td style="font-size:8px; text-align:center; font-weight: normal; width: 10%">'.$date.'</td>
                                    <td style="font-size:8px; text-align:left; font-weight: normal; width: 30%">'.$namecliente.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalExento.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">'.$totalGravado.'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($ven->valtax1, 2),2).'</td>
                                    <td style="font-size:8px; text-align:right; font-weight: normal; width: 7.5%">$'.number_format(round($valtot, 2),2).'</td>';
							foreach($tipospagos as $tip){
								$pagos = $this->ventas_model->getDatosPagosVentasPago($ven->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                        $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs(number_format(round($money->valor, 2),2)) - abs($money->vuelto));
                                        $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%">$'.number_format(round(abs($money->valor) - abs($money->vuelto), 2),2).'</td>';
                                    }
                                }else{
                                    $titulo .= '<td style="font-size:8px; text-align:right; font-weight: normal; width: '.$porcentaje.'%"></td>';
                                }
								
							}
							$titulo .='</tr>';
							$numdoc++;
							$numdocg++;
						}else{
							foreach($tipospagos as $tip){
								$valpag[$tip->cajclase] = 0;
							}
						}
					}
					
					$titulo .= '<tr>
						<th style="font-size:9px; text-align:center; font-weight: bold; width:5%;">('.$numdoc.')</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:40%;">Subtotal</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalex, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotalgr, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotaliv, 2),2).'</th>
						<th style="font-size:8px; text-align:right; font-weight: bold; width:7.5%;">$'.number_format(round($subtotal, 2),2).'</th>';
                    
                    
                     $resumen_tipos.='<tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: normal; width:25%;">'.$docs->tipoDoc.'&nbsp;&nbsp;</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: normal; width:15%;">'.$numdoc.'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: normal; width:15%;">$'.number_format(round($subtotalex, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: normal; width:15%;">$'.number_format(round($subtotalgr, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: normal; width:15%;">$'.number_format(round($subtotaliv, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: normal; width:15%;">$'.number_format(round($subtotal, 2),2).'</th>
                                </tr>';
                    
					foreach($tipospagos as $tip){
						$titulo .= '<th style="font-size:8px; text-align:right; font-weight: bold;  width:'.$porcentaje.'%">$'.number_format(round($valpag[$tip->cajclase], 2),2).'</th>';
					}
					$titulo .= '</tr>';
					$totalglobal = $totalglobal+$subtotal;
					$totalexglobal = $totalexglobal + $subtotalex;
					$totalgrglobal = $totalgrglobal + $subtotalgr;
					$totalivglobal = $totalivglobal + $subtotaliv;
                    
                }
				
				$titulo .= '
					<tr>
						<th colspan="'.$colspan.'"><br></th>
					</tr>
					<tr>
						<th style="font-size:9px; text-align:center; border-top: 1px solid black; width:5%; font-weight: bold;">('.$numdocg.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:40%; font-weight: bold;">Total: </th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalexglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalgrglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalivglobal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7.5%; font-weight: bold;">$'.number_format(round($totalglobal, 2),2).'</th>';
				foreach($tipospagos as $tip){
					$titulo .= '<th style="font-size:9px; text-align:right; font-weight: bold; border-top: 1px solid black;  width:'.$porcentaje.'%">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</th>';
				}
				$titulo .= '</tr></tbody></table><br><br><br><br>';
                
                
                $titulo .='<table>
                            <thead>
                            <tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                                <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                <tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Transacción</th>
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                                </thead><tbody>';

                $titulo.=$resumen_tipos;
                  
                $titulo.='<tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">'.$numdocg.'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalexglobal, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalgrglobal, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalivglobal, 2),2).'</th>
                                <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;background-color:#C2CBCE;">$'.number_format(round($totalglobal, 2),2).'</th>
                                </tr>';
                
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><br><table>
                            <thead>
                            <tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                                <th style="font-size:8px; text-align:right; font-weight: bold; width:80%"></th></tr>
                                <tr style="border-bottom: 1px solid black;">
                                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';
                
                foreach($tipospagos as $tip){
					$titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE; width: '.$porcentaje2.'%">'.$tip->descrip.'</th>';
				}
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:'.$porcentaje2.'%;background-color:#C2CBCE;">Sumas</th></tr></thead><tbody>';
                
                $titulo.='<tr style="border-bottom: 1px solid black;">
                                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
				$total_ing_sum=0;
                foreach($tipospagos as $tip){
					$titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
				    $total_ing_sum+=round($valpagG[$tip->cajclase], 2);
                }
                
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;  width:'.$porcentaje2.'%; ">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';
                
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function reciboDeIngreso($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$width = 21.50;  
                $height = 14;
                $pagelayout = array($width, $height); 
                //$pdf = new Pdf('Portrait', 'cm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);
				
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Recibo de Ingreso');
                $pdf->SetSubject('Recibo de Ingreso');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(0, 2, 0,0);
				
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
				
				$pdf->addPage('P', 'LETTER' );
				$this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NombreComercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$numeroRecibo = $info->numero;
					$fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
					$cliente = $info->idcps.'-'.$info->nameCliente;
				}
                
				$productos = $this->acs_model->getDataVenta100k($trannum);
                
				$concepto = ''; $total = 0; $totalGravado = 0;
                $totalExento = 0; $totalIVA = 0; $invexento = $info->exento;
				$vnExenta = 0; $vnGravada = 0; $numProd = 0;
				
                foreach($productos as $pro){
					if($pro->tipotax != 0 && $invexento == 0){
						$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
						$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
						$vnExenta = "";
						$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
					}else if($pro->tipotax != 0 && $invexento == 1){
						$total = $total + (($pro->precioneto * abs($pro->cantidad)));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax== 0 && $invexento == 0){
						$total = $total + (($pro->precioneto) * abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}else if($pro->tipotax == 0 && $invexento == 1){
						$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
						$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
						
						$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
						$vnGravada = "";
					}
						
					if($pro->tipo == 1){
						if($pro->barcode == null || $pro->barcode == "" || $pro->barcode == 0){
							$concepto .= $pro->descrip.' '.$pro->notas.', ';
						}else{
							$concepto .= $pro->descrip.' Pago de cuota '.$pro->barcode.'/12, ';
						}
					}else{
						$concepto .= $pro->descrip.', ';
					}
                }
				
				$concepto = substr($concepto, 0, -2);
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$pzFecha = explode('/', $fechaRecibo);
				
				if($pzFecha[1] == 1){
					$mesf = "Enero";
				}else if($pzFecha[1] == 2){
					$mesf = "Febrero";
				}else if($pzFecha[1] == 3){
					$mesf = "Marzo";
				}else if($pzFecha[1] == 4){
					$mesf = "Abril";
				}else if($pzFecha[1] == 5){
					$mesf = "Mayo";
				}else if($pzFecha[1] == 6){
					$mesf = "Junio";
				}else if($pzFecha[1] == 7){
					$mesf = "Julio";
				}else if($pzFecha[1] == 8){
					$mesf = "Agosto";
				}else if($pzFecha[1] == 9){
					$mesf = "Septiembre";
				}else if($pzFecha[1] == 10){
					$mesf = "Octubre";
				}else if($pzFecha[1] == 11){
					$mesf = "Noviembre";
				}else if($pzFecha[1] == 12){
					$mesf = "Diciembre";
				}
				
				$estructura = '
				<table style="border-bottom: 1px dashed black; margin:0px;">
					<tbody>
						<tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:10%;" rowspan="3"><img src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/LogoLeBouquet.jpeg" width="100px" height="100px"/></td>
							<td style="font-size:14px; text-align:right; width:87%; color:red;">Recibo N° '.$numeroRecibo.'</td>
							<td style="font-size:14px; text-align:right; width:3%; color:red;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:50%;">'.$NombreComercial.'</td>
							<td style="font-size:18px; text-align:right; width:37%;"><strong>Por: $'.$numero.'</strong></td>
							<td style="font-size:16px; text-align:right; width:3%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:90%;">'.$RazonSocial.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Recibí de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$cliente.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Cantidad de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.strtoupper($TotalLetras).'/100 US DOLARES</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>En Concepto de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$concepto.'</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:97%;">En San Salvador  '.$pzFecha[0].' de '.$mesf.' del '.$pzFecha[2].'.</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
							<td style="font-size:14px; text-align:center; width:40%; border-bottom: 1px solid black;"></td>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:center; width:100%;">Nombre y firma de quien recibe</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
					</tbody>
				</table>';
				
				$estructura .= '
				<table style="border-bottom: 1px dashed black;  margin:0px;">
					<tbody>
						<tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:10%;" rowspan="3"><img src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/LogoLeBouquet.jpeg" width="100px" height="100px"/></td>
							<td style="font-size:14px; text-align:right; width:87%; color:red;">Recibo N° '.$numeroRecibo.'</td>
							<td style="font-size:14px; text-align:right; width:3%; color:red;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:50%;">'.$NombreComercial.'</td>
							<td style="font-size:18px; text-align:right; width:37%;"><strong>Por: $'.$numero.'</strong></td>
							<td style="font-size:16px; text-align:right; width:3%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:90%;">'.$RazonSocial.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Recibí de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$cliente.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Cantidad de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.strtoupper($TotalLetras).'/100 US DOLARES</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>En Concepto de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$concepto.'</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:97%;">En San Salvador  '.$pzFecha[0].' de '.$mesf.' del '.$pzFecha[2].'.</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
							<td style="font-size:14px; text-align:center; width:40%; border-bottom: 1px solid black;"></td>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:center; width:100%;">Nombre y firma de quien recibe</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
					</tbody>
				</table>';
				
				$estructura .= '
				<table style="margin:0px;">
					<tbody>
						<tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:10%;" rowspan="3"><img src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/LogoLeBouquet.jpeg" width="100px" height="100px"/></td>
							<td style="font-size:14px; text-align:right; width:87%; color:red;">Recibo N° '.$numeroRecibo.'</td>
							<td style="font-size:14px; text-align:right; width:3%; color:red;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:50%;">'.$NombreComercial.'</td>
							<td style="font-size:18px; text-align:right; width:37%;"><strong>Por: $'.$numero.'</strong></td>
							<td style="font-size:16px; text-align:right; width:3%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:90%;">'.$RazonSocial.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Recibí de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$cliente.'</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>Cantidad de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.strtoupper($TotalLetras).'/100 US DOLARES</td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:17%;"><strong>En Concepto de:</strong></td>
							<td style="font-size:14px; text-align:left; width:80%;">'.$concepto.'</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:3%;"></td>
							<td style="font-size:14px; text-align:left; width:97%;">En San Salvador  '.$pzFecha[0].' de '.$mesf.' del '.$pzFecha[2].'.</td>
						</tr>
						<tr>
							<td style="font-size:18px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
							<td style="font-size:14px; text-align:center; width:40%; border-bottom: 1px solid black;"></td>
							<td style="font-size:14px; text-align:left; width:30%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:center; width:100%;">Nombre y firma de quien recibe</td>
						</tr>
					</tbody>
				</table>';
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("ReciboDeIngreso.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function facturaConsumidorFinal2($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetHeaderMargin(0,0,0,0);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 0, 0, 0);
                $pdf->SetAutoPageBreak(FALSE);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				$pdf->addPage('P', 'LETTER' );
				$this->load->model('global_model'); $this->load->model('ventas_model');
				$this->load->model('invtran_model'); $this->load->model('acs_model');
				
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					$numeroRecibo = $info->numero;
					$fechaRecibo = date_format(date_create($info->fecha), 'd/m/Y');
					$cliente = $info->idcps.'-'.$info->nameCliente;
					$nrc = $info->nrc;
					$direccion = $info->direccion;
				}
                
				$productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura = '
				<table style="margin:0px;">
					<tbody>
                        
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:10%;" rowspan="3"></td>
							<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
							<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
							<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
                            <td style="font-size:12px; text-align:left; width:7%;"><strong>DUI:</strong></td>
							<td style="font-size:12px; text-align:left; width:30%;">'.$nrc.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Dirección:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$direccion.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
							<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
						</tr>
					</tbody>
				</table>';
				
                
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $numCuotas = $this->acs_model->numCuotas($info->idcps);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:64%;">Descripción del Servicio o Producto</td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
								<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
                                <td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td></tr>';
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						if($pro->tipo == 1){
							if($pro->barcode == null || $pro->barcode == "" || $pro->barcode == 0){
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', '.$pro->notas.'</td>';
							}else{
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', Pago de cuota '.$pro->barcode.'/'.$numCuotas.'</td>';
							}
						}else{
							$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.'</td>';
						}
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
                
                //segunda copia
                
                $estructura.= '
				<table style="margin:0px;">
					<tbody>
                    
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:10%;" rowspan="3"></td>
							<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
							<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
							<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
                            <td style="font-size:12px; text-align:left; width:7%;"><strong>DUI:</strong></td>
							<td style="font-size:12px; text-align:left; width:30%;">'.$nrc.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Dirección:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$direccion.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
							<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
						</tr>
					</tbody>
				</table>';
				
                
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:64%;">Descripción del Servicio o Producto</td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
								<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
                                <td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td></tr>';
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						if($pro->tipo == 1){
							if($pro->barcode == null || $pro->barcode == "" || $pro->barcode == 0){
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', '.$pro->notas.'</td>';
							}else{
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', Pago de cuota '.$pro->barcode.'/'.$numCuotas.'</td>';
							}
						}else{
							$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.'</td>';
						}
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
                //tercera copia
                
                $estructura .= '
				<table style="margin:0px;">
					<tbody>
                        <tr>
                            <td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                       
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:10%;" rowspan="3"></td>
							<td style="font-size:12px; text-align:right; width:80%; color:red;">'.$numeroRecibo.'</td>
							<td style="font-size:12px; text-align:right; width:10%; color:red;"></td>
						</tr>
                         <tr>
                            <td style="font-size:10px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
                        <tr>
							<td style="font-size:3px; text-align:left; width:100%;"></td>
						</tr>
						<tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Cliente:</strong></td>
							<td style="font-size:12px; text-align:left; width:50%;">'.$cliente.'</td>
                            <td style="font-size:12px; text-align:left; width:7%;"><strong>DUI:</strong></td>
							<td style="font-size:12px; text-align:left; width:30%;">'.$nrc.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
                            <td style="font-size:12px; text-align:left; width:10%;"><strong>Dirección:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$direccion.'</td>
						</tr>
                        <tr>
                            <td style="font-size:12px; text-align:left; width:3%;"></td>
							<td style="font-size:12px; text-align:left; width:10%;"><strong>Fecha:</strong></td>
							<td style="font-size:12px; text-align:left; width:87%;">'.$fechaRecibo.'</td>
						</tr>
					</tbody>
				</table>';
				
                
                $maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->acs_model->getDataVenta100k($trannum);
                
				$estructura .= '<table style="width:100%; padding:0px;">';
				$estructura .= '<tr style="width:100%; padding:0px; border-bottom: 1px solid gray;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:64%;">Descripción del Servicio o Producto</td>
								<td style="border-bottom: 1px solid gray;text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Cant.</td>
								<td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Precio uni.</td>
                                <td style="border-bottom: 1px solid gray;text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:10%;">Subtotal</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; width:3%;"></td></tr>';
				$total = 0;
                $totalGravado = 0;
                $totalExento = 0;
                $totalIVA = 0;
                $invexento = $info->exento;
				$vnExenta = 0;
				$vnGravada = 0;
				$numProd = 0;
                foreach($productos as $pro){
					if($numProd < $maxlines){
						if($pro->tipotax != 0 && $invexento == 0){

							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							//$vnGravada = (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
						}else if($pro->tipotax != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}else if($pro->tipotax == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
							
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$estructura .= '<tr style="width:100%; padding:0px;">
								<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>';
						
						if($pro->tipo == 1){
							if($pro->barcode == null || $pro->barcode == "" || $pro->barcode == 0){
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', '.$pro->notas.'</td>';
							}else{
								$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.', Pago de cuota '.$pro->barcode.'/'.$numCuotas.'</td>';
							}
						}else{
							$estructura .= '<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:64%;">'.$pro->descrip.'</td>';
						}
						
						$estructura .= '
                                <td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">'.abs($pro->cantidad).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:10%;">$'.number_format(round($vnGravada+$vnExenta, 2), 2 ,'.','').'</td>
								<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 11px; width:3%;"></td>
							</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<$maxlines; $i++){
					$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
						</tr>';
				}
                
                $numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
                
                $estructura .= '
						<tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" text-align:left; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;" rowspan="2"></td>
							<td style=" border: 1px solid black; text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:34%;padding:2px;" rowspan="2"><b>  Son: </b> '.strtoupper($TotalLetras).'/100 US DOLARES</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Exentas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Ventas Gravadas</td>
							<td style=" background-color: #E8E8E8; border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">Total</td>
							<td style=" text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:3%;"></td>
						</tr>
                        <tr style="width:100%; padding:0px; border-bottom: 1px solid black;  border-top: 1px solid black;">
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalExento, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($totalGravado+$totalIVA, 2), 2 ,'.','').'</td>
							<td style=" border: 1px solid black; text-align:center; vertical-align:middle; font-weight:bold; font-size:11px; width:20%;">$'.number_format(round($total, 2), 2 ,'.','').'</td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:11px; width:3%;"></td>
						</tr>';
				$estructura .= '</table>';
                
				
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Factura.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
		
		function printEstadoDeCuenta($idauxi){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Estado de Cuenta');
                $pdf->SetSubject('Estado de Cuenta');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
				
                $this->load->model('acs_model');
				
				$header = '<center>
					<table style="width:100%; text-align:center;">
						<tr style="font-size:18px; text-align;center;" >
							<td style="font-size:18px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
						</tr>
						<tr style="font-size:18px; text-align;center;" >
							<td style="font-size:18px; text-align;center;"><label>ESTADO DE CUENTA</label></td>
						</tr>
					</table>
				</center><br><br>';
                
				$informacion = $this->acs_model->getInformacionAlumnoByCodigo($idauxi);
				
				foreach($informacion as $info){
                	$header .= '
						<table style="border: solid 1px black; padding:5px;">
							<thead>
								<tr>
									<th style="padding-top:5px;padding-bottom:5px; font-size:12px; text-align:left;" width="60%"><strong>Alumno: </strong>'.$info->descrip.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px; font-size:12px; text-align:left;" width="40%"><strong>Teléfono: </strong>'.$info->telefono.'</th>
                                </tr>
							</thead>
							<tbody>
								<tr style="padding-top:0px;padding-bottom:0px;margin-bottom:0px;">
									<td style="font-size:12px; text-align:left;" width="20%"><strong>Sucursal: </strong></td>
									<td style="font-size:12px; text-align:left;" width="40%"><strong>Curso: </strong></td>
									<td style="font-size:12px; text-align:left;" width="20%"><strong>Salón: </strong></td>
									<td style="font-size:12px; text-align:left;" width="20%"><strong>Horario: </strong></td>
                                </tr>
								<tr style="padding-top:0px;padding-bottom:0px;margin-top:0px;">
									<td style="font-size:12px; text-align:left;" width="20%">'.$info->nameSucursal.'</td>
									<td style="font-size:12px; text-align:left;" width="40%">'.$info->nameCurso.'</td>
									<td style="font-size:12px; text-align:left;" width="20%">'.$info->salon.'</td>
									<td style="font-size:12px; text-align:left;" width="20%">'.$info->horario.'</td>
                                </tr>
                    		</tbody>
						</table><br><br>';
				}
				
				$pdf->setHtmlHeader($header);
				$pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                
				$titulo ='
					<h3 style="padding-bottom:0px; width:100%;">DETALLE DE DOCUMENTOS</h3>
					<table>
						<thead>
							<tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:30px; background-color:#E8E8E8;">
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° Cuota</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Fecha de Vencimiento</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:25%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Observaciones</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Estado</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° de Factura</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Fecha de Pago</th>
								<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
							</tr>
						</thead>
						<tbody>';
				
				$pagos = $this->acs_model->getInformacionPagosAlumno($idauxi);
				$totalPagado = 0; $totalPendiente = 0;
				foreach($pagos as $pago){
					
					if($pago->barcode != null){
						$barcode = $pago->barcode;
						$fechas = explode(', ', $pago->notas);
						$fechaini = date(trim($fechas[1]));
						$fechafin = date(trim($fechas[2]));
						$fechaven = date(trim($fechas[0]));

						$fechaini = date_format(date_create($fechaini), 'd/m/Y');
						$fechafin = date_format(date_create($fechafin), 'd/m/Y');
						$fechaven = date_format(date_create($fechaven), 'd/m/Y');
					}else{
						$vocales = array("a", "e", "i", "o", "u", "A", "E", "I", "O", "U");
						$consona = array("b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "ñ", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z");
						$consonM = array("B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "Ñ", "P", "Q", "R", "S", "T", "V", "W", "X", "Y", "Z", " ");
						$Texto1 = str_replace($vocales, "", $pago->notas);
						$Texto2 = str_replace($consona, "", $Texto1);
						$Texto3 = str_replace($consonM, "", $Texto2);
						$barcode = str_replace("/12", "", $Texto3);
						
						$fechaini = '';
						$fechafin = '';
						$fechaven = '';
					}
					
					$fechapag = '';
					
					if($pago->estatus == 1){
						$totalPagado = $totalPagado + $pago->precioneto;
						$estado = 'Cancelado';
						$fechapag = date_format(date_create($pago->fecact), 'd/m/Y');
					}else if($pago->estatus == 9){
						$estado = 'Anulada';
					}else if($pago->estatus == 999){
						$totalPendiente = $totalPendiente + $pago->precioneto;
						$estado = 'Pendiente';
					}
					
					$titulo .='
							<tr>
								<td style="width:5%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;">'.$barcode.'</td>
                                <td style="width:15%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;">'.$fechaven.'</td>
                                <td style="width:25%; text-align:left; vertical-align:middle; padding:5px; font-size:11px;">'.$pago->descrip.'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;">'.$estado.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;">'.$pago->numero.'</td>
                                <td style="width:15%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;">'.$fechapag.'</td>
                                <td style="width:10%; text-align:right; vertical-align:middle; padding:5px; font-size:11px;">$'.number_format($pago->precioneto, 2, '.', '').'</td>
							</tr>';
                }
                
				$titulo .='
						</tbody>
					</table>';
                
				$titulo .='<br><br><br><br>
					<table>
						<tbody>
							<tr>
								<td style="width:40%; text-align:center; vertical-align:middle; padding:5px; font-size:11px;"></td>
                                <td style="width:30%; text-align:right; vertical-align:middle; padding:5px; font-size:11px;"><strong>Total Pagado:</strong> $'.number_format($totalPagado, 2, '.', ',').'</td>
                                <td style="width:30%; text-align:right; vertical-align:middle; padding:5px; font-size:11px;"><strong>Total Pendiente:</strong> $'.number_format($totalPendiente, 2, '.', ',').'</td>
							</tr>
						</tbody>
					</table>';
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                $nombre_archivo = utf8_decode("Estado de Cuenta.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
        
		function cc_control($idcentro, $fecha, $orden){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Control de Cobros');
                $pdf->SetSubject('Control de Cobros');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $this->load->model("acs_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                switch($orden){
                    case 1:
                        $information = $this->acs_model->getControlCobros1($idcentro, $fecha);
                        break;
                    case 2:
                        $information = $this->acs_model->getControlCobros2($idcentro, $fecha);
                        break;
                    case 3:
                        $information = $this->acs_model->getControlCobros3($idcentro, $fecha);
                        break;
                    default:
                        $information = $this->acs_model->getControlCobros1($idcentro, $fecha);
                        break;
                }
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'<br>'.$namecentro.'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.' hasta el '.date_format(date_create($fecha),'d/m/Y').'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fechaf = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fechaf->format('d/m/Y').' - '.$fechaf->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $estructura = '<table style="width:100%;">
                    <thead>
                        <tr style="width:100%;">
                            <th style="width:5%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>ID</th>
                            <th style="width:21%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>Nombre</th>
                            <th style="width:10%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>Teléfono</th>
                            <th style="width:10%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>Curso</th>
                            <th style="width:10%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>Instructor</th>
                            <th style="width:10%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;"><br>Horario</th>
                            <th style="width:10%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;">Fecha de Vencimiento</th>
                            <th style="width:7%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;">N° de Cuota</th>
                            <th style="width:9%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;">Valor Penditente</th>
                            <th style="width:8%;text-align:center; vertical-align:middle; font-weight: bold; font-size: 11px; background-color: #C2CBCE; color:black; border:1px solid black;">Días Vencidos</th>
                        </tr>
                    </thead><tbody>';
                
                
                foreach ($information as $info){
                    date_default_timezone_set('America/El_Salvador');
                    $fecha_actual = date("Y-m-d");
                    $datetime1 = date_create($info->fechaPago);
                    $datetime2 = date_create($fecha_actual);
    
                    $interval = date_diff($datetime1, $datetime2);
                
                    if($datetime2>$datetime1){
                        $diferencia = $interval->format("%a");
                    }else{
                        $diferencia = $interval->format("%a") * -1;
                    }
                 
                    
                    
                    $estructura .='<tr>
                            <td style="width:5%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->studentID.'</td>
                            <td style="width:21%;text-align:left; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->studentName.'</td>
                            <td style="width:10%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->telefono.'</td>
                            <td style="width:10%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->curso.'</td>
                            <td style="width:10%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->instructor.'</td>
                            <td style="width:10%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->horario.'</td>
                            <td style="width:10%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.date_format(date_create($info->fechaPago),'d/m/Y').'</td>
                            <td style="width:7%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$info->numCuota.'</td>
                            <td style="width:9%;text-align:right; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">$'.number_format($info->precioneto, 2).'</td>
                            <td style="width:8%;text-align:center; vertical-align:middle;font-size: 10px; color:black; border:1px solid black;">'.$diferencia.'</td>
                        
                    </tr>';
                }
                
                 $estructura .='</tbody></table>';
				
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("Factura.pdf");
                $pdf->Output($nombre_archivo, 'I');
			}
		}
    }
?>