<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
		
        function __construct(){
            if (session_status() == PHP_SESSION_NONE){
                session_start();
            }
            parent::__construct();
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
            $numero=trim($numero);
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
            $numero=trim($numero);
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
            $numero=trim($numero);
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
            $numero=trim($numero);
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
            $numero=trim($numero);
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;
            $numero=trim($numero);
			$importe_parcial = $numero;

			if ($numero < 1000000000)
			{
				if ($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if ($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if ($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if ($numero >= 0.01 && $numero <= 0.99)
				{
					if ($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
        //Modificada 20180410 Oscar Avelar.
		function facturaConsumidorFinalAV($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
				$pdf->SetAutoPageBreak(TRUE, 0);
				
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', $pagelayout);
				
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					
					$departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($departamentoMunicipio as $info_dm){
						$departamento = trim($info_dm->depto);
						$municipio = trim($info_dm->municipio);
					}
					
					$partesFechaFactura = explode(" ", date_format(date_create($info->fecha), 'd m Y'));
					
					$estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:6%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:52%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->telefono.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 11px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:6%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:63%;">'.$info->direccion.'</td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:6%;">'.$partesFechaFactura[0].'</td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.$partesFechaFactura[1].'</td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 12px; width:5%;">'.substr($partesFechaFactura[2], 2).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:4%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 7px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 20px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '
				<table style="width:100%; padding:0px;">';
                
				$total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                foreach($productos as $pro){
					if($numProd < 7){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 25);
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;">'.abs($pro->cantidad).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:50%;">'.$nombrepro.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9.6%;">'.$vnExenta.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$vnGravada.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<7; $i++){
					$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
					</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
				<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:12%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:45%;" rowspan="14">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:18.3%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:43%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:24%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:43%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:24%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:11.2%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:43%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:24%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:11.2%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:43%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:24%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:11.2%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:43%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:24%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:11.2%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
				</table>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				
				$js = 'print(true);';
				$pdf->IncludeJS($js);
				$pdf->Output($nombre_archivo, 'I');
			}
		}
		
        //Modificada 20180410 Oscar Avelar.
		function creditoFiscalAV($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Credito Fiscal');
                $pdf->SetSubject('Credito Fiscal');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
				$pdf->SetAutoPageBreak(TRUE, 0);
				
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P',$pagelayout);
				
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					
					$departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($departamentoMunicipio as $info_dm){
						$departamento = trim($info_dm->depto);
						$municipio = trim($info_dm->municipio);
					}
					
					$fechaCredito = date_format(date_create($info->fecha), 'd/m/Y');
					
					$estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:50%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:12%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$fechaCredito.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:13%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:47%;">'.$info->direccion.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:19%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->nrc.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:14%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:57%;">'.$municipio.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:18%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:53%;">'.$departamento.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->giro.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 19px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 20px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '
				<table style="width:100%; padding:0px;">';
                
				$total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalProGravada = 0; $totalProExenta = 0;
				
                foreach($productos as $pro){
					if($numProd < 9){
						if($pro->tax1 != 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							//$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$totalProGravada = number_format($pro->precioneto, 4, '.', '');
							$totalProExenta = "";
						}else if($pro->tax1 != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}else if($pro->tax1== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}else if($pro->tax1 == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
						$nombrepro = substr($pro->descrip, 0, 25);
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.abs($pro->cantidad).'</td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:3%;"></td>
                            <td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:52%;">'.$nombrepro.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$totalProGravada.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;">'.$totalProExenta.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$vnExenta.''.$vnGravada.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<9; $i++){
					$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
					</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
				}
				
				$totalGravIva = $totalGravado + $totalIVA;
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
				<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:45%;" rowspan="14">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:20%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$totalGravado.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($totalIVA, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:19%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
				</table>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("credito_fiscal_".$trannum.".pdf");
				
				$js = 'print(true);';
				$pdf->IncludeJS($js);
				
				$pdf->Output($nombre_archivo, 'I');
			}
		}
		
        //Modificada 20180410 Oscar Avelar.
		function facturaConsumidorFinalWA($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura Consumidor Final');
                $pdf->SetSubject('Factura Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
				$pdf->SetAutoPageBreak(TRUE, 0);
				
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', $pagelayout);
				
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					
					$departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($departamentoMunicipio as $info_dm){
						$departamento = trim($info_dm->depto);
						$municipio = trim($info_dm->municipio);
					}
					
					$estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:6%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:6%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.date_format(date_create($info->fecha), 'd/m/Y').'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 6px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:22%;">'.$info->direccion.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:3%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:4%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 20px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '
				<table style="width:100%; padding:0px;">';
                
				$total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0;
                foreach($productos as $pro){
					if($numProd < 11){
						if($pro->tipotax != 0 && $invexento == 0){
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
						}else if($pro->tipotax != 0 && $invexento == 1){
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax== 0 && $invexento == 0){
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}else if($pro->tipotax == 0 && $invexento == 1){
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100));
						$nombrepro = substr($pro->descrip, 0, 22);
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:2%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.abs($pro->cantidad).'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:23%;">'.$nombrepro.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.number_format(round($preciouni, 2), 2 ,'.','').'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:4%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.$vnExenta.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.$vnGravada.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<11; $i++){
					$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
					</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
				}
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
				<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:21%;" rowspan="14"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 2px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:10%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:13%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:5%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
				</table>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("factura_consumidor_final".$trannum.".pdf");
				/*
				$js = 'print(true);';
				$pdf->IncludeJS($js);
				*/
				$pdf->Output($nombre_archivo, 'I');
			}
		}
		
        //Modificada 20180410 Oscar Avelar.
		function creditoFiscalWA($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				$this->load->library('Pdf');
                $width = 250;  
                $height = 200;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
				
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Credito Fiscal');
                $pdf->SetSubject('Credito Fiscal');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
				$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(0, 10, 0,0);
				
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->SetAutoPageBreak(TRUE, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
				$pdf->SetAutoPageBreak(TRUE, 0);
				
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P',$pagelayout);
				
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                
				$informacion = $this->ventas_model->getDatosFactura($trannum);
				
				foreach($informacion as $info){
					
					$departamentoMunicipio = $this->global_model->getDatosDeptoMuniIdauxi($info->idcps);
					foreach($departamentoMunicipio as $info_dm){
						$departamento = trim($info_dm->depto);
						$municipio = trim($info_dm->municipio);
					}
					
					$fechaCredito = date_format(date_create($info->fecha), 'd/m/Y');
					
					$estructura = '
					<table style="width:100%; padding-top:0px;">
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 14px; width:100%;"><br><br><br><br><br><br></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:8%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:35%;">'.$info->nameCliente.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:9.5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$fechaCredito.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:33%;">'.$info->direccion.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:15%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->nrc.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:10%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:33%;">'.$municipio.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:9%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->nit.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr style="margin-top:0px;">
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:12%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:31%;">'.$departamento.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:9.5%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:25%;">'.$info->giro.'</td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 12px; width:7%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 19px; width:100%;"></td>
						</tr>
						<tr>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 20px; width:100%;"></td>
						</tr>
					</table>';
				}
                
				$maxlines = $this->ventas_model->getMaxLinesDoc($info->idclase);
                $productos = $this->invtran_model->getDataTran100k($trannum);
                
				$estructura .= '
				<table style="width:100%; padding:0px;">';
                
				$total = 0; $totalGravado = 0; $totalExento = 0; $totalIVA = 0;
                $invexento = $info->exento; $vnExenta = 0; $vnGravada = 0; $numProd = 0; $totalProGravada = 0; $totalProExenta = 0;
				
                foreach($productos as $pro){
					if($numProd < 14){
						if($pro->tax1 != 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100))) * abs($pro->cantidad));
							$totalIVA = $totalIVA + (($pro->precioneto * ($pro->tax1 / 100)) * abs($pro->cantidad));
							$totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
							
							$vnExenta = "";
							//$vnGravada = "" . number_format(round(($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad), 2), 2 ,'.','');
							$vnGravada = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$totalProGravada = number_format($pro->precioneto, 4, '.', '');
							$totalProExenta = "";
						}else if($pro->tax1 != 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto * abs($pro->cantidad)));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}else if($pro->tax1== 0 && $invexento == 0){
							
							$total = $total + (($pro->precioneto) * abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}else if($pro->tax1 == 0 && $invexento == 1){
							
							$total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
							$totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);

							$vnExenta = "" . number_format(round($pro->precioneto * abs($pro->cantidad), 4), 4 ,'.','');
							$vnGravada = "";
							$totalProExenta = number_format($pro->precioneto, 4, '.', '');
							$totalProGravada = "";
						}
						
						$preciouni = $pro->precioneto + ($pro->precioneto * ($pro->tax1 / 100));
						$nombrepro = substr($pro->descrip, 0, 25);
						
						$estructura .= '
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:4%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:7%;">'.abs($pro->cantidad).'</td>
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 10px; width:1%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:34%;">'.$nombrepro.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;">'.number_format(round($pro->precioneto, 4), 4 ,'.','').'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;">'.$vnExenta.'</td>
							<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.$vnGravada.'</td>
						</tr>
						<tr style="width:100%; padding:0px;">
							<td style="text-align:center; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
						</tr>';
					}
					$numProd++;
                }
				
				for($i=$numProd; $i<14; $i++){
					$estructura .= '
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 8px; width:100%;"></td>
					</tr>';
				}
				
				$estructura .= '</table>';
                
				if($totalExento == 0){
					$totalExento = "";
				}else{
					$totalExento = number_format(round($totalExento, 2), 2 ,'.','');
				}
				
				if($totalGravado == 0){
					$totalGravado = "";
				}else{
					$totalGravado = number_format(round($totalGravado, 2), 2 ,'.','');
				}
				
				$totalGravIva = $totalGravado + $totalIVA;
				
				$numero = number_format(round($total, 2), 2 ,'.','');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura .= '
				<table style="width:100%; padding:0px;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:37%;" rowspan="14">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;">'.$totalExento.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.$totalGravado.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.number_format(round($totalIVA, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.number_format(round($totalGravIva, 2), 2 ,'.','').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.$totalExento.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 5px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:7.5%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight: normal; font-size: 10px; width:6.5%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:6%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight: normal; font-size: 10px; width:9%;">'.number_format(round($total, 2), 2 ,'.','').'</td>
					</tr>
				</table>';
				
				$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("credito_fiscal_".$trannum.".pdf");
				/*
				$js = 'print(true);';
				$pdf->IncludeJS($js);
				*/
				$pdf->Output($nombre_archivo, 'I');
			}
		}
        
        function reporteCompraLocal($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Compra Local');
                $pdf->SetSubject('Compra Local');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='
                <table>
                    <thead>
                        <tr><td style="font-size:10px;"></td></tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#F4CE4D;">
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:16%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:11%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                            <th style="background-color:#F4CE4D; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                        </tr>
                    </thead>
                <tbody>';
                $sum_lines = 0;
                $sum_cant = 0;
                $sum_subtotal = 0;
                foreach($productos as $pro){
                    $sum_lines++;
                    $sum_cant+= $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
                    $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                    <td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                    <td style="width:16%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                    <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                    <td style="width:11%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td></tr>';
                }
                
                 
                
                $titulo.='<tr> <td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td></tr>';
                
                $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
                    <td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
                    <td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
                    <td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
                    <td style="width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td></tr>';
               
                $titulo.='</tbody>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_Compra".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:20%;"></td>
									<td style="font-size:15px; text-align:center;width:80%;">'.strtoupper($nombreFormato).'</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
                    
                $header .= '
                <table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:37.5%; font-weight: bold; border: 1px solid #6E6E6E;" > Origen</td>
						<td style="font-size:12px; text-align:left; background-color:#F4CE4D; width:37.5%; font-weight: bold; border: 1px solid #6E6E6E;" > Destino</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:25%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2"> Datos de Orden</td>
					</tr>
				</table>';
                $header .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-top: 1px solid #6E6E6E;" rowspan="2">'.$data->centrocd.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-top: 1px solid #6E6E6E;" rowspan="2">'.$data->idcentrod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;"> N°:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$data->trannum.'</td>
					</tr>
                    <tr>
						<td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;"> Fecha:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$date_emision.'</td>
					</tr>
                    <tr>
                        <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"> '.$data->encargadoinv.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;"> '.$data->encargadod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #6E6E6E; background-color:#F4CE4D;"> Estado:  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #6E6E6E;"> '.$estado.'</td>
					</tr>
                    </table>';
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#E8E8E8;">
                                        <th style="background-color:#F4CE4D;border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#F4CE4D;">
                                        <th style="background-color:#F4CE4D;border-left: 1px solid #6E6E6E;  width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#F4CE4D; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#F4CE4D; width:10%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                                        <th style="background-color:#F4CE4D; width:35%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#F4CE4D; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                                        <th style="background-color:#F4CE4D; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#F4CE4D; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#F4CE4D; width:9%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                        <th style="background-color:#F4CE4D;border-right: 1px solid #6E6E6E; width:1%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#F4CE4D;">
                                        <th style="background-color:#F4CE4D;border-left: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E;  border-right: 1px solid #6E6E6E;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  1px solid #6E6E6E; ">
                                <td style="width:5%; border-left: 1px solid #6E6E6E;  text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:9%; text-align:center; font-size:10px;  border-bottom:solid 1px black;"></td>
                                <td style="width:1%;border-right: 1px solid #6E6E6E;  text-align:center; font-size:10px;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='
                    <tr><td style="font-size:5px; width:100%;border-left:1px solid #6E6E6E;border-right:1px solid #6E6E6E;"></td></tr>
                    
                    <tr style="border:1px solid #6E6E6E; font-size:12px;">
                        <td style="width:5%;border-top:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-left:1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="width:75%;border-top:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%;border-top:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(number_format(round($totalcant, 2),2)).'</strong></td>
                        <td style="width:10%;border-top:1px solid #6E6E6E;border-bottom:1px solid #6E6E6E;border-right:1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                     $titulo .= '
                      <table>
                    <tr>
				        <td style="width:100%;"><br><br></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%;bold; border: 1px solid #6E6E6E;">Entregado por</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%;bold; border: 1px solid #6E6E6E;">Recibido por</td>
						<td style="font-size:12px; text-align:center; background-color:#F4CE4D; width:33.3%;bold; border: 1px solid #6E6E6E;">Fecha y hora</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #6E6E6E;"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
	}
?>