<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
		
        function __construct() {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            parent::__construct();
        }
        
        function recepcionDoc($trannum, $tipo){
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            
            $return = '';
            
            if($tipo==0){
                //$return .="Código Interno, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->idproducto.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==1){
                //$return .="Modelo, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->modelo.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==2){
                //$return .="Código XPOS, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->xpos.",".round($value->cantidad)." \r\n";
                }
            }elseif($tipo==3){
                //$return .="Código de Barra, Cantidad \r\n";
                foreach ($detalle as $value) {
                    $return .=$value->barcode.",".round($value->cantidad)." \r\n";
                }
            }
            
            
            //save file
            $handle = fopen('Recepcion_'.$trannum.'.txt','w+');
            fwrite($handle,$return);
            fclose($handle);
            
            $fichero = "Recepcion_".$trannum.".txt";
            
            if (file_exists($fichero)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($fichero));
                readfile($fichero);
                unlink('Recepcion_'.$trannum.'.txt');
                exit;
            }
        }
        
        function recepcionExcel($trannum, $tipo){
            require_once APPPATH . 'libraries/Classes/PHPExcel.php';
            require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';
            ini_set('memory_limit','800M');
            ini_set('max_allowed_packet', '500M'); 
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                ->setTitle("Recepcion de traslados") // Titulo
                ->setSubject("Recepcion de traslados") //Asunto
                ->setDescription("Recepcion de traslados") //Descripción
                ->setKeywords("Recepcion de traslados") //Etiquetas
                ->setCategory("Recepcion de traslados"); //Categorias
            $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
            $objPHPExcel->setActiveSheetIndex(0);
            
            
            $this->load->model("invtran_model");
            $detalle = $this->invtran_model->getDataTran100k($trannum);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            if($tipo==0){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código Interno');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->idproducto);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==1){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Modelo');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->modelo);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==2){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código XPOS');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->xpos);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }elseif($tipo==3){
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Código de Barra');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Cantidad');
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 4; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                foreach ($detalle as $value) {
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->barcode);
                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$value->cantidad);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                }
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Recepcion_'.$trannum.'.xlsx"');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        } 
        
		public function detect(){
            $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
            $os=array("WIN","MAC","LINUX");
            
            $info['browser'] = "OTHER";
            $info['os'] = "OTHER";
            
            foreach($browser as $parent){
                $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                $f = $s + strlen($parent);
                $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                $version = preg_replace('/[^0-9,.]/','',$version);
                
                if($s){
                    $info['browser'] = $parent;
                    $info['version'] = $version;
                }
            }
            
            foreach($os as $val){
                if(strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
                    $info['os'] = $val;
            }
            
            return $info;
        }
        
        function factura_pdf_nuevo($numero){
			$this->load->library('Pdf');
            
			$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			$pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );
			$this->load->model('mantenimiento_model');
            $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

            if(is_array($products) && $products!=false){
                $sucursal = strtoupper($products['descrip']);
                $pedido = $products['numero'];
                $cli_name = $products['cli_name'];
                $cli_phone = $products['cli_phone'];
                $date = date_format(date_create($products['date']),'d/m/Y');
                $dev_date2 = ucwords($products['dev_date2']);
                $dev_time = date("g:i a", strtotime($products['dev_time']));
                $tfecha = ucwords($products['tfecha']);
                $val_venta = $products['val_venta'];
                $val_anti = $products['val_anti'];
                $val_refund = $products['val_refund'];
                $tpastel = $products['val_pastel'];
                $taccesorios = $products['val_acc'];
                $tbases = $products['val_bases'];
                $tenvio = $products['val_envio'];

                $cli_email = $products['cli_email'];
                $dev_place = $products['dev_place'];
                $notas_obser = $products['notas'];
                $dev_notes = $products['dev_notes'];

                $imagen = $products['pastel_fotos'];
                $catreference = $products['catreference'];
                $dedicamsg = $products['dedicamsg'];
                
                $dev_contact = $products['dev_contact'];
                $dev_phone = $products['dev_phone'];

                $lugar = "";
                $tlugar = "";
                if($dev_place==1){
                    $lugar = $products['dev_direc'];
                    $tlugar = $products['dev_direc'];
                }elseif($dev_place==2){
                    $lugar = $products['dev_direc'];
                    $tlugar = "DOMICILIO";
                }elseif ($dev_place==3) {
                    $lugar = "Recoger en Producción";
                }

                $cktortas = $products['ck_tortas'];
                $ckslices = $products['porciones'];

                $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                $tamano = strlen($pedido);
                $codbar = "";
                
                if($tamano==1){
                    $codbar = "00000".$pedido;
                }elseif($tamano==2){
                    $codbar = "0000".$pedido;
                }elseif($tamano==3){
                    $codbar = "000".$pedido;
                }elseif($tamano==4){
                    $codbar = "00".$pedido;
                }elseif($tamano==5){
                    $codbar = "0".$pedido;
                }elseif($tamano==6){
                    $codbar = $pedido;
                }
            }else{
				redirect('pedidos_clientes/pasteles_al_gusto/');
            }

            $estructura = '
			<table style="width:100%;">
				<tr>
					<td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
					<td></td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
				</tr>
				<tr>
					<td></td>
					<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
					<td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
				</tr>
				<tr>
					<td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
				</tr>
			</table>';
			
            $estructura .= '<br><br>
			<table style="width:100%;">
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;"></td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Orden N°</td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Fecha</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Sucursal</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Nombre del cliente</td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Telefono</td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Correo</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Fecha de entrega</td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Hora</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Lugar de entrega</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Contacto</td>
					<td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Telefono</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
					<td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Tipo de documento de venta</td>
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Número de Tortas</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Número de Porciones</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
					<td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Diseño</td>
					<td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Dedicatoria</td>
				</tr>
				<tr style="border-collapse:separate; border-spacing:12px;">
					<td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
					<td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
					</tr>
			</table>';

            if($arrayPasteles!=false){
                $i=1;
                $estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #3E4147;;">Tortas </td>
						<td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Posición</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Forma</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Sabor</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Baño</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Relleno</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Cobertura</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Color</td>
					</tr>';
				
                foreach($arrayPasteles as $key => $value){
                    $estructura .= '
					<tr>
						<td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:5.5%;"><br><b>'.$i.'</b></td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_shape'].'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_flavor'].'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_bath'].'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_filling'].'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_covering'].'</td>
						<td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_color'].'</td>
					</tr>
					<tr>
						<td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #3E4147; width:94.5%;"><label style="color:#3E4147;">Detalle:</label> '.ucwords($value['notas']).'</td>
					</tr>';
                    $i++;
                }
                $estructura .= '</table>';
            }

            if($arrayAccesorios!=false){
                $i=0;
                $i = count($arrayAccesorios);
                $estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Accesorios </td>
						<td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #3E4147;">Descripción</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Cantidad</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Precio $</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Subtotal $</td>
					</tr>';

                $i2=1;
                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                    $i = count($arrayAccesorios);
                    foreach($arrayAccesorios as $key => $value){
                            
                        $estructura.= ' <tr>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #3E4147;">'.$i2.'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #3E4147;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.strtoupper($value['qty']).'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.$value['price'].'</td>
                                            <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                        </tr>';
                          $i2++;  
                    }
                }
            
                $estructura .= '</table>';
            }  

            if($arrayBases!=false){
                $i=0;
                $i = count($arrayBases);
                $estructura .= '<br><br>
				<table style="width:100%;">
					<tr>
						<td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Bases </td>
						<td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #3E4147;">Descripción</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Cantidad</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Precio $</td>
						<td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Subtotal $</td>
					</tr>';
				
                $i2=1;
                if(is_array($arrayBases) and $arrayBases!=false){
                    $i = count($arrayBases);
                    foreach($arrayBases as $key => $value){
						$estructura.= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #3E4147;">'.$i2.'</td>
							<td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #3E4147;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.strtoupper($value['qty']).'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.$value['price'].'</td>
							<td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
						</tr>';
						$i2++;  
					}
				}
           		
                $estructura .= '</table>';
			}    

            $estructura .= '<br><br>
			<table style="width:100%;">
				<tr>
					<td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #3E4147; width:50%;">Observaciones: '.$notas_obser.'</td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
				</tr>
				<tr>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
				</tr>
				<tr>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
				</tr>
				<tr>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
					<td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
				</tr>
			</table>';
			
            $estructura .= '
			<table style="width:100%; border-collapse: separate; border-spacing:25px;">
				<tr>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de cliente</td>
					<td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de gestor de pedido</td>
				</tr>
				<tr>
					<td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
				</tr>
			</table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
            $pdf->Output($nombre_archivo, 'I');
		}
        
        function orden_pedido($trannum){
            $this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Factura');
            $pdf->SetSubject('Factura');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(5, 5, 5);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 
            // Añadir una página
            // Este método tiene varias opciones, consulta la documentación para más información.
            // set auto page breaks
            //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            //$pdf->SetAutoPageBreak(TRUE, 1);

            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER' );
            
            $this->load->model('pedclientes_model');
            $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
            $list_producto = $this->pedclientes_model->getDataProduct($trannum);
            $name = $this->pedclientes_model->getnameImg();
                
            $sucursal = strtoupper($dataPedido['pedidoSuc']);
            $pedido = $dataPedido['trannum'];
            $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
            $cli_name = $dataPedido['descrip'];
            $cli_phone = $dataPedido['cli_phone'];
            $cli_email = $dataPedido['cli_email'];
            $notas = $dataPedido['notas'];
            $dev_date = ucwords($dataPedido['fechaPedido']);
            $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
            if($dataPedido['dev_place'] == 1){
                $lugar = $dataPedido['nameSucursal'];
            }else{
                $lugar = $dataPedido['dev_direc'];    
            }
            $dev_contact = $dataPedido['dev_contact'];
            $dev_phone =$dataPedido['dev_phone'];
            $valPedido = $dataPedido['val_pro'];
            $valEnvio = $dataPedido['val_envio'];
            $valVenta = $dataPedido['val_tot'];
            $valAnti = $dataPedido['val_anti'];
            
            $tamano = strlen($trannum);
            $codbar = "";
                
            if($tamano==1){
                $codbar = "00000".$pedido;
            }elseif($tamano==2){
                $codbar = "0000".$pedido;
            }elseif($tamano==3){
                $codbar = "000".$pedido;
            }elseif($tamano==4){
                $codbar = "00".$pedido;
            }elseif($tamano==5){
                $codbar = "0".$pedido;
            }elseif($tamano==6){
                $codbar = $pedido;
            }
            
            $estructura = '<br><br><table style="width:100%;">
                                <tr>
                                    <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                    <td></td>
                                    <td style="font-size:12px; text-align:right;">ORDEN DE PEDIDO<br>'.strtoupper($this->session->userdata('appName')).'<br><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                </tr>
                            </table><br><br>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Nombre de Cliente:</td>
                                    <td style="font-size:12px; text-align:center; background-color:#E8E8E8; width:30%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                </tr>
                            </table>';
            
            $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;">'.$cli_name.'</td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Fecha</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #3E4147;">'.$date.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;">Teléfono: <strong>'.$cli_phone.'</strong>&nbsp;&nbsp;Correo: <strong>'.$cli_email.'</strong></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Sucursal</td>
                                    <td style="font-size:10px; text-align:right; width:15%; border: 1px solid #3E4147;">'.$sucursal.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">N° de orden</td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:15%; border: 1px solid #3E4147; color:#0B486B;">'.$trannum.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:70%;"></td>
                                    <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                    <td style="font-size:12px; text-align:right; width:15%; border: 1px solid #3E4147;">$'.$valVenta.'</td>
                                </tr>
                            </table>';
            
             $estructura .= '<br><br><table style="width:100%;">
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalles de entrega</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Fecha</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #3E4147;">'.$dev_date.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Hora</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #3E4147;">'.$dev_time.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Lugar</td>
                                    <td style="font-size:12px; text-align:left; width:90%; border: 1px solid #3E4147;" colspan="3">'.$lugar.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Contacto</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #3E4147;">'.$dev_contact.'</td>
                                    <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Teléfono</td>
                                    <td style="font-size:12px; text-align:left; width:40%; border: 1px solid #3E4147;">'.$dev_phone.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalle del Pedido</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:10%; font-weight: bold; border-left: 1px solid #3E4147;">Cant.</td>
                                    <td style="font-size:12px; text-align:left; width:40%; font-weight: bold;">Descripción del Producto</td>
                                    <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Notas</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #3E4147;">Sub-total</td>
                                </tr>';
            foreach($list_producto as $key){
                $subtotal = $key->cantidad * $key->precioneto;
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #3E4147;">'.round($key->cantidad).'</td>
                                    <td style="font-size:12px; text-align:left; width:40%;">'.$key->descrip.'</td>
                                    <td style="font-size:9px; text-align:left; width:30%;">'.$key->notas.'</td>
                                    <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:9px; text-align:left; width:70%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #3E4147;"></td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Sub-total</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.$valPedido.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Envio</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.$valEnvio.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Suma</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.$valVenta.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:12px; text-align:left; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; font-weight: bold; width:10%;">Anticipo</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.$valAnti.'</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:center; width:40%; border-bottom: 1px solid #3E4147; border-left: 1px solid #3E4147;"></td>
                                    <td style="font-size:12px; text-align:left; border-bottom: 1px solid #3E4147; width:40%;"></td>
                                    <td style="font-size:12px; text-align:right; border-bottom: 1px solid #3E4147; font-weight: bold; width:10%;">Pendiente</td>
                                    <td style="font-size:12px; text-align:right; width:10%; border-bottom: 1px solid #3E4147; border-right: 1px solid #3E4147;">$'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                                </tr>';
                $estructura .= '<tr>
                                    <td style="font-size:12px; text-align:left; background-color:#E8E8E8; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Observaciones</td>
                                </tr>
                                <tr>
                                    <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #3E4147;" colspan="4" rowspan="5">'.$notas.'</td>
                                </tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                                <tr><td></td></tr>
                            </table><br><br><br>';
                $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';
            
            $pdf->writeHTML($estructura, true, 0, false, false, 0);

            $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
            $pdf->Output($nombre_archivo, 'I');

        }
        
        function ticket_pedido($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 10, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P', $pagelayout);

                $this->load->model('pedclientes_model');
                $dataPedido = $this->pedclientes_model->getDataPedidoArray($trannum, 1);
                $list_producto = $this->pedclientes_model->getDataProduct($trannum);
                
                $sucursal = strtoupper($dataPedido['pedidoSuc']);
                $pedido = $dataPedido['trannum'];
                $date = date_format(date_create($dataPedido['fecha']),'d/m/Y');
                $cli_name = $dataPedido['descrip'];
                $cli_phone = $dataPedido['cli_phone'];
                $cli_email = $dataPedido['cli_email'];
                $dev_date = ucwords($dataPedido['fechaPedido']);
                $dev_time = date("g:i a", strtotime($dataPedido['dev_time']));
                if($dataPedido['dev_place'] == 1){
                    $lugar = $dataPedido['nameSucursal'];
                }else{
                    $lugar = $dataPedido['dev_direc'];    
                }
                $dev_contact = $dataPedido['dev_contact'];
                $dev_phone =$dataPedido['dev_phone'];
                $dev_phone =$dataPedido['dev_phone'];
                $valPedido = $dataPedido['val_pro'];
                $valEnvio = $dataPedido['val_envio'];
                $valVenta = $dataPedido['val_tot'];
                $valAnti = $dataPedido['val_anti'];

                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE '.strtoupper($this->session->userdata('appName')).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';
                        
                        $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pedido</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 24px; width:50%; font-weight: bold;">Producto</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Cant</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 24px; width:16%; font-weight: bold;">Precio</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 24px; width:18%; font-weight: bold;">Sub-total</td>
                            </tr>';
                        
                        foreach($list_producto as $key){
                            $subtotal = $key->cantidad * $key->precioneto;
                            $estructura .= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 20px; width:50%;">'.$key->descrip.'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">'.round($key->cantidad).'</td>
                                <td style="text-align:center; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($key->precioneto, 2, '.', '').'</td>
                                <td style="text-align:right; vertical-align:middle; font-size: 20px; width:16%;">$'.number_format($subtotal, 2, '.', '').'</td>
                                </tr>';
                        }
                
                $estructura .= '</table>';
                
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PEDIDO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valPedido, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valEnvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valVenta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($valAnti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($valVenta-$valAnti), 2),2).'</td>
                            </tr>
                        </table>';
                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td><br><br><br><br><br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_pedido_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
                    
            }
        
        }
        
        function ticket_nuevo($numero){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $width = 210;  
                $height = 1100;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Landscape', 'mm', $pagelayout, true, 'UTF-8', false);
                //$pdf = new Pdf('Landscape', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(5, 1, 17);

                $browser = array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
                $os = array("WIN","MAC","LINUX");
     
                # definimos unos valores por defecto para el navegador y el sistema operativo
                $info['browser'] = "OTHER";
                $info['os'] = "OTHER";
                $valnav = "OTHER";
                # buscamos el navegador con su sistema operativo
                foreach($browser as $parent){

                    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
                    $f = $s + strlen($parent);
                    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
                    $version = preg_replace('/[^0-9,.]/','',$version);

                    if($s){
                        $info['browser'] = $parent;
                        $info['version'] = $version;
                        $valnav = $parent;
                    }
                }

                if(strcmp ($valnav , 'CHROME' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 32, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(0, 1, 10);
                }
                if(strcmp ($valnav , 'MOZILLA' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                if(strcmp ($valnav , 'FIREFOX' ) == 0){
                    //$pdf->SetMargins(PDF_MARGIN_LEFT, 46, PDF_MARGIN_RIGHT);
                    $pdf->SetMargins(5, 1, 17);
                }
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetAutoPageBreak(TRUE, 0);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra
 
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 8, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                $pdf->SetAutoPageBreak(TRUE, 0);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                //$pdf->addPage( 'P', 'LETTER' );
                $pdf->addPage('P',$pagelayout);

                $this->load->model('mantenimiento_model');
                $products = $this->mantenimiento_model->getDataCake_for_ticket($numero);

                if(is_array($products) && $products!=false){
                    $sucursal = strtoupper($products['descrip']);
                    $pedido = $products['numero'];
                    $cli_name = $products['cli_name'];
                    $cli_phone = $products['cli_phone'];
                    $date = date_format(date_create($products['date']),'d/m/Y');
                    $dev_date2 = ucwords($products['dev_date2']);
                    $dev_time = date("g:i a", strtotime($products['dev_time']));
                    $val_venta = $products['val_venta'];
                    $val_anti = $products['val_anti'];
                    $val_refund = $products['val_refund'];
                    $tpastel = $products['val_pastel'];
                    $taccesorios = $products['val_acc'];
                    $tbases = $products['val_bases'];
                    $tenvio = $products['val_envio'];

                    $cli_email = $products['cli_email'];
                    $dev_place = $products['dev_place'];
                    $notas_obser = $products['notas'];
                    $dev_notes = $products['dev_notes'];

                    $imagen = $products['pastel_fotos'];
                    $catreference = $products['catreference'];
                    $dedicamsg = $products['dedicamsg'];

                    $dev_contact = $products['dev_contact'];
                    $dev_phone = $products['dev_phone'];

                    $lugar = "";
                    if($dev_place==1){
                        $lugar = $products['dev_direc'];
                    }elseif($dev_place==2){
                        $lugar = $products['dev_direc'];
                    }elseif ($dev_place==3) {
                        $lugar = "Recoger en Producción";
                    }

                    $cktortas = $products['ck_tortas'];
                    $ckslices = $products['porciones'];

                    $arrayPasteles = $this->mantenimiento_model->getPasteles($numero,1);
                    $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,2);
                    $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($numero,3);
           
                }else{
                    redirect('pedidos_clientes/pasteles_al_gusto/');
                }

        
                $estructura = '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 54px; width:100%;">'.$this->session->userdata('descrip').'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">'.$sucursal.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:100%;">PEDIDO DE PASTELES</td>
                            </tr>
                            <tr>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;"><br>Pedido No.: '.$pedido.'</td>
                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 30px; width:50%;">Fecha: '.$date.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DEL CLIENTE</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Nombre:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_name.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_phone.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Correo:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cli_email.'</td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; text-decoration: underline; width:100%;"><br><br>DATOS DE ENTREGA</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Fecha:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_date2.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Hora:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_time.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Lugar:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$lugar.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Contacto:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_contact.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Telefono:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$dev_phone.'</td>
                            </tr>
                        </table>';

                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                        
                     $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Datos del Pastel</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Tortas:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$cktortas.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Porciones:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$ckslices.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:30%; font-weight: bold;">Referencia:</td>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$catreference.'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Dedicatoria:</td>
                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.$dedicamsg.'</td>
                            </tr>
                        </table>';
                    
                    $i = 1;
                    foreach($arrayPasteles as $key => $value){

                        $estructura .= '<table style="width:100%;">
                                            <tr>
                                                <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>Torta '.$i.' </td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Posición:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_position'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Forma:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_shape'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Relleno:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_filling'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Sabor:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_flavor'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Baño:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_bath'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Cobertura:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_covering'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; font-weight: bold; width:30%;">Color:</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px; width:70%;">'.$value['tx_color'].'</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-size: 28px;font-weight: bold; width:30%;">Notas:</td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 28px; width:70%;">'.ucwords($value['notas']).'</td>
                                            </tr>
                                        </table>';
                        $i++;
                    }
                }

                if($accesorios!=false){

                    $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>ACCESORIOS </td>
                            </tr>';
        
                    foreach($accesorios as $key => $value){
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                       </tr>';
                    }

                    $estructura .= '</table>';
                }

                if($bases!=false){

                    $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline; width:100%;"><br><br>BASES </td>
                                </tr>';
        
                    foreach ($bases as $key => $value) {
                        $vtotal = 0;
                        $vtotal = ($value['qty']*$value['price']);
                        $estructura .= '<tr>
                                            <th style="text-align:left; vertical-align:middle; font-size: 28px; width:7%;">'.$value['qty'].'</th>
                                            <th style="text-align:justify; vertical-align:middle; font-size: 28px; width:59%;">'.$value['descrip'].'<br>'.$value['notas'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.$value['price'].'</th>
                                            <th style="text-align:right; vertical-align:middle; font-size: 28px; width:17%;">$'.number_format(round($vtotal, 2),2).'</th>
                                        </tr>';
                    }
                    
                    $estructura .= '</table>';
                }

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; text-decoration: underline;"><br><br>OBSERVACIONES </td>
                            </tr>
                            <tr>
                                <td colspan="4" style="text-align:left; vertical-align:middle; font-size: 28px;">'.$dev_notes.'</td>
                            </tr></table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td colspan="2"><br><br><hr><br></td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">PASTEL $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tpastel, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ACCESORIOS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($taccesorios, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">BASES $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tbases, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ENVIO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($tenvio, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SUMAS $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">ANTICIPO $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">SALDO PENDIENTE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;">REEMBOLSABLE $:</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 28px;">'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';

                $estructura .= '<table style="width:100%;">
                            <tr>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px; width:35%;"><br><br><br><br>Firma:<br><br><br><br></td>
                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 28px;"><br><br><br><br><hr><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 28px;"><br><br>Gracias por Preferirnos.<br><br><br><br></td>
                            </tr>
                        </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                //number_format(round($cantidad, 2),2)
                //$pdf->writeHTML($tabla.$estructura, true, 0, false, false, 0);
                //$pdf->writeHTML($estilos.$invoice, true, false, true, false, '');

                $nombre_archivo = utf8_decode("ticket_".$numero.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function ordenes_pdf($fecha, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Factura');
                $pdf->SetSubject('Factura');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 5, 8);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                //$pdf->setPageOrientation('Landscape');
        
                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
 
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

            
                if($fecha=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $this->load->model('mantenimiento_model');

                $pedidos = $this->mantenimiento_model->get_id_ordenes(1,$fecha,$estado);
                $estructura = '';
        
                foreach ($pedidos as $key => $value){

                    $pdf->addPage('P', 'LETTER');
                    $products = $this->mantenimiento_model->getDataCake_for_ticket($value['numero']);

                    if(is_array($products) && $products!=false){
               
                        $sucursal = strtoupper($products['descrip']);
                        $pedido = $products['numero'];
                        $cli_name = $products['cli_name'];
                        $cli_phone = $products['cli_phone'];
                        $date = date_format(date_create($products['date']),'d/m/Y');
                        $dev_date2 = ucwords($products['dev_date2']);
                        $dev_time = date("g:i a", strtotime($products['dev_time']));
                        $tfecha = ucwords($products['tfecha']);
                        $val_venta = $products['val_venta'];
                        $val_anti = $products['val_anti'];
                        $val_refund = $products['val_refund'];
                        $tpastel = $products['val_pastel'];
                        $taccesorios = $products['val_acc'];
                        $tbases = $products['val_bases'];
                        $tenvio = $products['val_envio'];

                        $cli_email = $products['cli_email'];
                        $dev_place = $products['dev_place'];
                        $notas_obser = $products['notas'];
                        $dev_notes = $products['dev_notes'];

                        $imagen = $products['pastel_fotos'];
                        $catreference = $products['catreference'];
                        $dedicamsg = $products['dedicamsg'];

                        $dev_contact = $products['dev_contact'];
                        $dev_phone = $products['dev_phone'];

                        $lugar = "";
                        $tlugar = "";
                        
                        if($dev_place==1){
                            $lugar = $products['dev_direc'];
                            $tlugar = $products['dev_direc'];
                        }elseif($dev_place==2){
                            $lugar = $products['dev_direc'];
                            $tlugar = "DOMICILIO";
                        }elseif ($dev_place==3){
                            $lugar = "Recoger en Producción";
                        }

                        $cktortas = $products['ck_tortas'];
                        $ckslices = $products['porciones'];
                        
                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value['numero'],1);
                        $accesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],2);
                        $bases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value['numero'],3);

                        $tamano= strlen($pedido);
                        $codbar = "";
                        
                        if($tamano==1){
                            $codbar = "00000".$pedido;
                        }elseif($tamano==2){
                            $codbar = "0000".$pedido;
                        }elseif($tamano==3){
                            $codbar = "000".$pedido;
                        }elseif($tamano==4){
                            $codbar = "00".$pedido;
                        }elseif($tamano==5){
                            $codbar = "0".$pedido;
                        }elseif($tamano==6){
                            $codbar = $pedido;
                        }

                    }else{
                        redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                    }

                    $estructura = '<table style="width:100%;">
                                    <tr>
                                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tfecha.'</td>
                                        <td></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 14px; color:gray;">'.$tlugar.'</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                        <td style="text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$codbar.'&size=30&orientation=horizontal&codetype=code39"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">PEDIDO DE PASTELES<br></td>
                                    </tr>
                                 </table>';



                    $estructura .= '<br><br><table style="width:100%;">
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td rowspan="12" style="text-align:left; vertical-align:middle; font-size: 10px; width:30%;">';

                    /*if(isset($imagen) and $imagen!=""){
                        $estructura .= '<img style="min-width: 25%; max-height: 300px;" src="data:image/png;base64,'.base64_encode($imagen).'">';
                    }*/
                    $estructura .='</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Orden N°</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Fecha</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Sucursal</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$pedido.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$date.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$sucursal.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Nombre del cliente</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Telefono</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Correo</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_name.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_phone.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$cli_email.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Fecha de entrega</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Hora</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Lugar de entrega</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_date2.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$dev_time.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$lugar.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Contacto</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Telefono</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_contact.'</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_phone.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Tipo de documento de venta</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147; width:10%;">Número de Tortas</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Número de Porciones</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$dev_notes.'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000; width:10%;">'.$cktortas.'</td>
                                        <td colspan="2" style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$ckslices.'</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Diseño</td>
                                        <td colspan="3" style="text-align:left; vertical-align:middle; font-size: 8px; color:#3E4147;">Dedicatoria</td>
                                    </tr>
                                    <tr style="border-collapse:separate; border-spacing:12px;">
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; color:#000000;">'.$catreference.'</td>
                                        <td colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; color:#000000;">'.$dedicamsg.'</td>
                                    </tr>
                               </table>';

                    if($arrayPasteles!=false){
                        $i=1;
                        $estructura .= '<br><br><table style="width:100%;">
                                            <tr>
                                                <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #3E4147;;">Tortas </td>
                                                <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:94.5%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5.5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Posición</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Forma</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Sabor</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Baño</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Relleno</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Cobertura</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:13.5%; background-color:#F79F81; border: 1px solid #3E4147;">Color</td>
                                            </tr>';
                        foreach($arrayPasteles as $key => $value){
                            $estructura .= '
                                    <tr>
                                        <td rowspan="2" style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:5.5%;"><br><b>'.$i.'</b></td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.strtoupper($value['posiciones']).'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_shape'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_flavor'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_bath'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_filling'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_covering'].'</td>
                                        <td style="text-align:center; vertical-align:middle; font-size: 8px; border: 1px solid #3E4147; width:13.5%;">'.$value['tx_color'].'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" style="text-align:left; vertical-align:middle; font-size: 12px; border: 1px solid #3E4147; width:94.5%;"><label style="color:#3E4147;">Detalle:</label> '.ucwords($value['notas']).'</td>
                                    </tr>';
                            $i++;
                        }
                        $estructura .= '</table>';
                    }

                    if($accesorios!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="3" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Accesorios </td>
                                            <td colspan="5" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:90%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #3E4147;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Subtotal $</td>
                                        </tr>';

                        $i = 1;

                        foreach ($accesorios as $key => $value){
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #3E4147;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #3E4147;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    if($bases!=false){

                        $estructura .= '<br><br><table style="width:100%;">
                                        <tr>
                                            <td colspan="2" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:15%; background-color:#F79F81; border: 1px solid #3E4147;">Bases</td>
                                            <td colspan="6" style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 8px; width:85%;"></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:5%; background-color:#F79F81; border: 1px solid #3E4147;">N°</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:65%; background-color:#F79F81; border: 1px solid #3E4147;">Descripción</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Cantidad</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Precio $</td>
                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 8px; width:10%; background-color:#F79F81; border: 1px solid #3E4147;">Subtotal $</td>
                                        </tr>';
                        $i = 1;

                        foreach ($bases as $key => $value) {
                            $vtotal = 0;
                            $vtotal = ($value['qty']*$value['price']);
                            $estructura .= '<tr>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:5%; border: 1px solid #3E4147;">'.$i.'</td>
                                                <td style="text-align:left; vertical-align:middle; font-size: 12px; width:65%; border: 1px solid #3E4147;">'. strtoupper($value['descrip']).', '. strtoupper($value['notas']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.strtoupper($value['qty']).'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.$value['price'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-size: 12px; width:10%; border: 1px solid #3E4147;">'.number_format(round($value['qty']*$value['price'], 2),2).'</td>
                                            </tr>';
                            $i++;
                        }

                        $estructura .= '</table>';
                    }

                    $estructura .= '<br><br><table style="width:100%;">
                            <tr>
                                <td rowspan="4" colspan="3" style="text-align:justify; vertical-align:middle; font-size: 10px; border: 1px solid #3E4147; width:50%;">Observaciones: '.$notas_obser.'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Valor del Pastel: $'.number_format(round($tpastel, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Total Orden: $'.number_format(round($val_venta, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Accesorios: $'.number_format(round($taccesorios, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Anticipo: $'.number_format(round($val_anti, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Bases: $'.number_format(round($tbases, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Saldo Pendiente: $'.number_format(round(($val_venta-$val_anti), 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Envio: $'.number_format(round($tenvio, 2),2).'</td>
                                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px; border: 1px solid #3E4147; width:25%; background-color:#BDBDBD;">Deposito Reembolsable: $'.number_format(round($val_refund, 2),2).'</td>
                            </tr>
                        </table>';


                    $estructura .= '<table style="width:100%; border-collapse: separate; border-spacing:  25px;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:50%;"><br><hr style="color:#3E4147;"><br>Firma de gestor de pedido</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-size: 10px;"><br>Gracias por Preferirnos.<br><br></td>
                                </tr>
                            </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                }
                
                $nombre_archivo = utf8_decode("ticket_todos.pdf");
                $pdf->Output($nombre_archivo, 'I');
        
            }

        }
        
        function lista_pdf_nuevo_todo($fecha, $estado){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS');
                $pdf->SetSubject('LISTADO DE PEDIDOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(1, 2, 1);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 2);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage('P', 'LETTER' );
                
                $fechai = $fecha;
                $fechaf = $fecha;
                if($fechai=="" || $fechaf=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
        
                $sucursales = $this->produccion_model->getPedidosClientes_by_Sucursal(1,$fechai,$fechaf,$estado,1);
                $tdomicilio = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,2);
                $tproduccion = $this->produccion_model->getCount_Pedidos_by_Devplace(1,$fechai,$fechaf,$estado,3);
                $pedidos_sucursal = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,1);
                $pedidos_domicilio = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,2);
                $pedidos_produccion = $this->produccion_model->getPedidosClientes_Produccion_Busqueda_Devplace(1,$fechai,$fechaf,$estado,3);

                $estructura = '';

                $estructura .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 19px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS</td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px;">'.$titulo.'</td>
                                </tr>
                            </table><br><br><br>';

                if($pedidos_sucursal!=false || $pedidos_domicilio!=false || $pedidos_produccion!=false){

                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Entrega</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:18%;">Cliente</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:10%;">Referencia</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:51%;">Detalles</td>
                                </tr>
                                <tr><td colspan="6"><hr></td></tr>
                            </table>';
                    
                    if(is_array($sucursales) && $sucursales!=false){                
                        foreach ($sucursales as $key => $value) {
                            $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">'.$value['devdirec2'].' ('.$value['totalpedidos'].')</td>
                                </tr>';
                            
                            foreach ($pedidos_sucursal as $key2 => $value2) {
                                
                                if($value['dev_direc']==$value2['dev_direc']){
                                    $cktortas = $value2['ck_tortas'];
                                    $ckslices = $value2['porciones'];
                                    
                                    if($value['dev_direc']==$value2['dev_direc']){
                                        $estructura.= '<tr>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                                        $i=0;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }

                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                                        $i2 = 1;

                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }
                                        
                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb) {
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                $i3++;  
                                            }
                                        }
                                        $estructura.= '</td>
                                            </tr>
                                            <tr><td colspan="6"><hr></td></tr>'; 
                                    }
                                }
                            }
                            $estructura.= '</table>';
                        }
                    }
                    /****************************/
                    if(is_array($pedidos_domicilio) && $pedidos_domicilio!=false){                
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';

                        foreach ($pedidos_domicilio as $key2 => $value2) {
                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                            
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                            
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep){
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                           }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea){
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                
                                foreach ($arrayBases as $keyb => $valueb){
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                    
                        }

                        $estructura.= '</table>';
            
                    }
                    /****************************/
                    
                    /****************************/
                    if(is_array($pedidos_produccion) && $pedidos_produccion!=false){                
                     
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6">PRODUCCIÓN ('.$tproduccion.')</td>
                                </tr>';
                        
                        foreach ($pedidos_produccion as $key2 => $value2) {

                            $cktortas = $value2['ck_tortas'];
                            $ckslices = $value2['porciones'];
                            
                            $estructura.= '<tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:5%;">'.$value2['numero'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechapedidor'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:8%;">'.$value2['fechaentregar'].'<br>'.$value2['dev_time2'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:18%;">'.$value2['cli_name'].'<br>'.$value2['dev_direc'].'<br>'.$value2['cli_phone'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:10%;">'.$value2['catreference'].'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:51%">';
                   
                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value2['numero'],1);
                            $i=0;
                   
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTAS:</b> '.$cktortas.', <b>PORCIONES:</b> '.strtoupper($ckslices).'<br>';  
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).','. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }
                            
                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }
                            
                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value2['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }
                            
                            $estructura.= '</td>
                                        </tr>
                                        <tr><td colspan="6"><hr></td></tr>'; 
                        }
                    
                        $estructura.= '</table>';
            
                    }
                  
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                
                $nombre_archivo = utf8_decode("listado_pedidos.pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        
        }
        
        function reporte_por_hora($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{

                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetSubject('LISTADO DE PEDIDOS POR HORA');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');
                
                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);
                
                $fechai = $fecha;
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }
                
                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');

                $horas = $this->produccion_model->get_horas_por_pedido($fechai,$estado);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">LISTADO DE PEDIDOS POR HORA</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';

                $estructura2.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">Porciones</td>
                                </tr>
                            </table>';                            
                
                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );


                if($horas!=false){
                    if(is_array($horas) && $horas!=false){                
                        foreach ($horas as $key_horas => $value_horas){
                            $estructura.= '<table style="width:100%;">
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_horas['hora'].' ('.$value_horas['npedidosporhora'].')</td>
                                            </tr>';

                            $sucursales = $this->produccion_model->get_sucursales_por_hora_por_pedido($fechai,$estado,$value_horas['dev_time'],1);

                            if(is_array($sucursales) and $sucursales!=false){
                                foreach ($sucursales as $key_sucursales => $value_sucursales) {
                                    $estructura.= '<tr>
                                                        <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                                   </tr>';

                                    $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],1,$value_sucursales['dev_direc']);

                                    if(is_array($pedido) and $pedido!=false){
                                        foreach ($pedido as $key_pedido => $value_pedido) {
                                            $estructura.= '<tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                           </tr>
                                                           <tr>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                           </tr>
                                                           <tr> 
                                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                            $i=1;
                                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                                //$i = count($arrayPasteles);
                                                foreach ($arrayPasteles as $keyp => $valuep) {
                                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                    $i++;  
                                                }
                                            }

                                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                            $i2 = 1;

                                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                                $estructura.= '<b>ACCESORIOS:</b> ';
                                                foreach ($arrayAccesorios as $keya => $valuea) {
                                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                    $i2++;  
                                                }
                                            }

                                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                            $i3 = 1;
                                            
                                            if(is_array($arrayBases) and $arrayBases!=false){
                                                //$i3 = count($arrayBases);
                                                $estructura.= '<b>Bases:</b> ';
                                                foreach ($arrayBases as $keyb => $valueb) {
                                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                                    $i3++;  
                                                }
                                            }
                                            $estructura.='</td>
                                            </tr>';
                                        }
                                    }
                                }
                            }

                            $tdomicilio = $this->produccion_model->getCount_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2);

                            if($tdomicilio!=false){
                                $estructura.= '<tr>
                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;" colspan="6"><br><br>DOMICILIO ('.$tdomicilio.')</td>
                                </tr>';
                                
                                $pedido = $this->produccion_model->get_pedidos_por_devplace_por_hora($fechai,$estado,$value_horas['dev_time'],2,'');

                                if(is_array($pedido) and $pedido!=false){
                                    foreach ($pedido as $key_pedido => $value_pedido) {
                                        $estructura.= '<tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                                       </tr>
                                                       <tr>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:22%;">'.strtoupper($value_pedido['porciones']).'</td>
                                                       </tr>
                                                       <tr> 
                                                            <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                            <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                        $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                        $i=1;
                                        if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                            //$i = count($arrayPasteles);
                                            foreach ($arrayPasteles as $keyp => $valuep) {
                                                $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                                $i++;  
                                            }
                                        }
                                        
                                        $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                        $i2 = 1;
                                        
                                        if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                            //$i2 = count($arrayAccesorios);
                                            $estructura.= '<b>ACCESORIOS:</b> ';
                                            foreach ($arrayAccesorios as $keya => $valuea) {
                                                $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                                $i2++;  
                                            }
                                        }

                                        $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                        $i3 = 1;
                                        
                                        if(is_array($arrayBases) and $arrayBases!=false){
                                            //$i3 = count($arrayBases);
                                            $estructura.= '<b>Bases:</b> ';
                                            foreach ($arrayBases as $keyb => $valueb){
                                                $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']);
                                                $i3++;  
                                            }
                                       }

                                        $estructura.='</td>
                                        </tr>';
                                    }
                                }
                            }
                            
                            $estructura.= '</table>';
                        }
                    }
           
                }
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("listado_pedidos_por_hora.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_de_despacho($fecha, $estado){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE DE DESPACHO');
                $pdf->SetSubject('REPORTE DE DESPACHO');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra

                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $fechai = $fecha;
                
                if($fechai=="" || $estado==""){
                    redirect('ppasteles/vercontrolproduccion'.$this->session->userdata('iddApp'));
                }

                $titulo = "";
                
                if($estado==0){
                    $titulo = "EN PROCESO";
                }elseif($estado==1){
                    $titulo = "CONFIRMADOS";
                }elseif($estado==2){
                    $titulo = "AGENDADOS";
                }elseif($estado==3){
                    $titulo = "EN PRODUCCIÓN";
                }elseif($estado==4){
                    $titulo = "EN RUTA";
                }elseif($estado==8){
                    $titulo = "ENTREGADOS";
                }else{
                    $titulo = "";
                }
                
                $this->load->model('produccion_model');
                $this->load->model('mantenimiento_model');
                
                $sucursales = $this->produccion_model->get_sucursales_reporte_de_despacho($fechai,$estado,1);
                $domicilio = $this->produccion_model->get_total_pedidos_por_dev_place($fechai,$estado,2);
                $totalPedidos = $this->produccion_model->getTotal_pedidos_por_hora($fechai,$estado);
                $estructura = '';
                $estructura2 = '';
                $estructura2 .= '<table style="width:100%;">
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE DE DESPACHO</td>
                                </tr>
                                <tr>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA '.date_format(date_create($fechai),'d/m/Y').'</td>
                                    <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;">Total de Pedidos: '.$totalPedidos.', Página '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages().'</td>
                                </tr>
                            </table><br><br>';
                     
                $estructura2.= '<table style="width:100%;">
                    <tr>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">N°</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">F. Pedido</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Hora</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">Nombre del Cliente</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Telefono</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Valor $</td>
                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">Tortas</td>
                        <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">Porciones</td>
                    </tr>
                </table>';                            

                $pdf->setHtmlHeader($estructura2);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );

            
                if(is_array($sucursales) && $sucursales!=false){    
                    foreach ($sucursales as $key_sucursales => $value_sucursales){
                        $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>'.$value_sucursales['devdirec2'].' ('.$value_sucursales['totalpedidos'].')</td>
                                </tr>';
                 
                        $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,1,$value_sucursales['dev_direc']);
                 
                        if(is_array($pedidos) and $pedidos!=false){
                            foreach($pedidos as $key_pedido => $value_pedido){
                                $estructura.= '<tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                               </tr>
                                               <tr>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                    <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                               </tr>
                                               <tr> 
                                                    <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                    <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                                $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                                $i=1;
                                if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                    //$i = count($arrayPasteles);
                                    foreach ($arrayPasteles as $keyp => $valuep){

                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';

                                      $i++;  
                                    }
                                }

                                $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                                $i2 = 1;
                                
                                if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                    //$i2 = count($arrayAccesorios);
                                    $estructura.= '<b>ACCESORIOS:</b> ';
                                    foreach ($arrayAccesorios as $keya => $valuea){
                                        $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                        $i2++;  
                                    }
                                }

                                $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                                $i3 = 1;

                                if(is_array($arrayBases) and $arrayBases!=false){
                                    //$i3 = count($arrayBases);
                                    $estructura.= '<b>Bases:</b> ';
                                    foreach ($arrayBases as $keyb => $valueb){
                                        $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                        $i3++;  
                                    }
                                }

                                $estructura.='</td>
                                </tr>';
                            }
                        }
                
                        $estructura.= '</table>';
                    }
                }
                
                if($domicilio!=0){
                       
                    $estructura.= '<table style="width:100%;">
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; width:100%;" colspan="6"><hr>DOMICILIO ('.$domicilio.')</td>
                                </tr>';
                    
                    $pedidos = $this->produccion_model->get_pedidos_por_devplace_reporte_de_despacho($fechai,$estado,2,"");
                 
                    if(is_array($pedidos) and $pedidos!=false){
                        foreach ($pedidos as $key_pedido => $value_pedido){
                            $estructura.= ' <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:100%;"></td>
                                            </tr>
                                            <tr>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:2%;"></td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:5%;">'.$value_pedido['numero'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['date2'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['hour'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:25%;">'.$value_pedido['cli_name'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['cli_phone'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['val_venta'].'</td>
                                                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 10px; width:8%;">'.$value_pedido['ck_tortas'].'</td>
                                                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 10px; width:14%;">'.strtoupper($value_pedido['porciones']).'</td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;"><b>DIRECCIÓN:</b> '.trim($value_pedido['dev_direc']).', <b>PREGUNTAR POR:</b> '.trim($value_pedido['dev_contact']).', <b>TELÉFONO:</b> '.trim($value_pedido['dev_phone']).'
                                                </td>
                                            </tr>
                                            <tr> 
                                                <td style="text-align:left; vertical-align:middle; font-size: 10px; width:15%;"></td>
                                                <td style="text-align:justify; vertical-align:middle; font-size: 10px; width:85%;">';

                            $arrayPasteles = $this->mantenimiento_model->getPasteles($value_pedido['numero'],1);
                            $i=1;
                            if(is_array($arrayPasteles) and $arrayPasteles!=false){
                                foreach ($arrayPasteles as $keyp => $valuep) {
                                    $estructura.= '<b>TORTA '.$i.':</b> '. strtoupper($valuep['posiciones']).', '. strtoupper($valuep['tx_shape']).', '. strtoupper($valuep['tx_flavor']).', '. strtoupper($valuep['tx_bath']).', '. strtoupper($valuep['tx_filling']).', '. strtoupper($valuep['tx_covering']).', '. strtoupper($valuep['tx_color']).'<br>'. strtoupper($valuep['notas']).'<br>';
                                    $i++;  
                                }
                            }

                            $arrayAccesorios = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],2);
                            $i2 = 1;

                            if(is_array($arrayAccesorios) and $arrayAccesorios!=false){
                                //$i2 = count($arrayAccesorios);
                                $estructura.= '<b>ACCESORIOS:</b> ';
                                foreach ($arrayAccesorios as $keya => $valuea) {
                                    $estructura.= '<b>('.$i2.'):</b> '. strtoupper($valuea['qty']).', '. strtoupper($valuea['descrip']).', '. strtoupper($valuea['notas']).'. ';
                                    $i2++;  
                                }
                            }

                            $arrayBases = $this->mantenimiento_model->getAccesoriosPedidoPastel($value_pedido['numero'],3);
                            $i3 = 1;
                            
                            if(is_array($arrayBases) and $arrayBases!=false){
                                //$i3 = count($arrayBases);
                                $estructura.= '<b>Bases:</b> ';
                                foreach ($arrayBases as $keyb => $valueb) {
                                    $estructura.= '<b>('.$i3.'):</b> '. strtoupper($valueb['qty']).', '. strtoupper($valueb['descrip']).', '. strtoupper($valueb['notas']).'. ';
                                    $i3++;  
                                }
                            }

                            $estructura.='</td>
                            </tr>';
                        }
                    }
                    $estructura.= '</table>';
                }
                
           
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_producto_sucursal($fecha, $productos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
                
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('REPORTE CONTROL PRODUCCION');
                $pdf->SetSubject('REPORTE CONTROL PRODUCCION');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(3, 30, 8);
                $pdf->SetFooterMargin(15);
                $pdf->SetAutoPageBreak(TRUE, 15);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('L');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
                $header = '     <table style="width:100%;">
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 15px;">'.$this->session->userdata('descrip').'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">REPORTE CONTROL PRODUCCIÓN</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                        <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px;">FECHA DE ENTREGA <strong>'.date_format(date_create($fecha), 'd/m/Y').'</strong></td>
                                        <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 10px;"></td>
                                    </tr>
                                </table><br><br>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setPrintFooter(false);
                
                $this->load->model('tpedido_model');
                
                $salas_venta = $this->tpedido_model->getNameSalasdeVenta();
                                                
                $lst_productos = explode("_", $productos);
                $tot = count($lst_productos);
                $total_ = $tot - 1;
                if($total_ >= 12){
                    $tamano = 90 / 12;    
                }else{
                    $tamano = 90 / $total_;    
                }
                
                $pdf->addPage('L', 'LETTER');
                $estructura = ' <table style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th style="background-color:#F0F0F0; color:#FFFFFF; width:10%; height:25px; font-size:14px; text-align:center; vertical-align:middle; border-style:solid; border-width: 1px 1px 1px 1px;"></th>';
                    for($j=0; $j<$total_; $j++){
                        $name = $this->tpedido_model->getNameProducto($lst_productos[$j]);
                        $estructura .= '    <th style="width:'.$tamano.'%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.$name.'</th>';            
                    }                        
                //$estructura .= '            <th style="width:10%; height:25px; font-size:8px; vertical-align:middle; text-align:center; background-color:#F0F0F0; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>TOTAL</th>';
                $estructura .= '        </tr>
                                    </thead>';
                
                foreach($salas_venta as $sv){
                    $sum_ = 0;
                    $estructura .=' <tbody>
                                        <tr>
                                            <td style="text-align:left; background-color:#F0F0F0; color:#000000; width:10%; height:35px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>'.$sv->descrip.'</strong></td>';
                        for($j=0; $j<$total_; $j++){
                            $cantidad = $this->tpedido_model->getCantProducto($lst_productos[$j], $fecha, $sv->idcentro);
                            if($cantidad == "0" || $cantidad == ""){
                                $cantidad = "";    
                            }else{
                                $cantidad = round($cantidad);
                            }
                            $estructura .= '<td style="width:'.$tamano.'%; height:35px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#000000; border-style:solid; border-width: 1px 1px 1px 1px;"><br/><br/>'.$cantidad.'</td>';            
                            $sum_ += $cantidad;
                        }                       
                    $estructura .= '    </tr>';
                }
                $estructura .= '        <tr>
                                            <td style="text-align:center; background-color:#F0F0F0; color:#000000; width:10%; height:30px; font-size:8px; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br><strong>TOTAL</strong></td>';
                for($j=0; $j<$total_; $j++){
                    $sum_total = $this->tpedido_model->getTotalProducto($lst_productos[$j], $fecha);
                    $estructura .= '    <td style="width:'.$tamano.'%; height:30px; font-size:9px; vertical-align:middle; text-align:center; background-color:#FFFFFF; color:#A80000; border-style:solid; border-width: 1px 1px 1px 1px;"><br><br>'.round($sum_total).'</td>';
                }
                $estructura .= '        </tr>';
                $estructura .= '    <tbody>    
                                </table>';
                
                $estructura .= '<style>
                                    .sucursales{
                                        color:#000000; 
                                        font-size:11px; 
                                    }
                                </style>';
                
                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("reporte_de_despacho.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('RECEPCION DE TRASLADOS');
                $pdf->SetSubject('RECEPCION DE TRASLADOS');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $header = '<center><table style="width:100%; text-align:center;">
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;" ><label><strong>'.strtoupper($this->session->userdata('descrip')).'</strong></label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label>'.strtoupper($this->session->userdata('appName')).'</label></td>
                                    </tr>
                                    <tr style="font-size:12px; text-align;center;" >
                                        <td style="font-size:12px; text-align;center;"><label><strong>'.strtoupper($estado).'</strong></label></td>
                                    </tr>
                                </table></center>';

                    $header .= '<table style="border: solid 1px black;">
                                <thead>
                                <tr>
                                    <th style="padding-top:5px;padding-bottom:5px;border-left: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#CC333F; color:white; font-size:12px; text-align:left;" width="50%"><strong>N°: </strong>'.$data->trannum.'</th>
                                    <th style="padding-top:5px;padding-bottom:5px;border-right: solid 1px black; border-top: solid 1px black; border-bottom: solid 1px black;background-color:#CC333F; color:white; font-size:12px; text-align:right;" width="50%"><strong>Fecha: </strong>'.$date_cierre.'</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Origen:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Destino:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->idcentrod).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->centrocd).'</td>
                                    </tr>
                                     <tr>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                        <td style="font-size:12px; text-align:left;  font-weight: bold;" width="50%">Encargado:</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadoinv).'</td>
                                        <td style="font-size:12px;  text-align:left;" width="50%">'.strtoupper($data->encargadod).'</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="font-size:12px;  text-align:left; font-weight: bold;" width="100%">REFERENCIA: '.$data->tranref.'</td>
                                    </tr>
                                </tbody>
                    </table><br><br>';
                    
                }
                
                
                 $footer = '<table>
                            <tr  style="border: solid 1px black;" >
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Entregado por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Recibido por</td>
                                <td style=" border: solid 1px black;text-align:center;"><br><br><br><br><br>Fecha y Hora</td>
                            </tr>
                            </table>';
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#CC333F;">
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:40%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:20%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                                        <th style="background-color:#CC333F; color:white; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:40%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:20%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:5%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.$totalcant.'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recepcion_Traslado_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function orden_print($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Orden de Compra');
                $pdf->SetSubject('Orden de Compra');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 5, 5);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE, 5);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                //---------------------------------------------------------
                //establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                //$pdf->setPageOrientation('Portrait');
                $pdf->setPageOrientation('P');

                // Establecer el tipo de letra
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);

                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // set auto page breaks
                //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                //$pdf->SetAutoPageBreak(TRUE, 1);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                $pdf->addPage( 'P', 'LETTER' );

                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                $nit_pro = $det['pro_nit'];
                $nrc_pro = $det['pro_nrc'];
                if($nit_pro==""){
                    $nit_pro="N/A";
                }
                if($nrc_pro==""){
                    $nrc_pro="N/A";
                }
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                
                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#CC333F; color:white; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">N° de orden</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #3E4147;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Forma de Pago</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Días</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F; color:white;  width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Fecha</td>
                                        <td style="font-size:12px; text-align:left; width:45%; border: 1px solid #3E4147;">'.$fecha_entrega.'</td>
                                        <td style="font-size:12px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Hora</td>
                                        <td style="font-size:12px; text-align:left; width:30%; border: 1px solid #3E4147;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Lugar</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Solicitado por:</td>
                                        <td style="font-size:12px; text-align:left; width:85%; border: 1px solid #3E4147;">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F;  color:white; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:8%; font-weight: bold; border-left: 1px solid #3E4147;">Cant.</td>
                                        <td style="font-size:12px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:12px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:12px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:12px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:12px; text-align:right; width:10%; font-weight: bold; border-right: 1px solid #3E4147;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%; border-left: 1px solid #3E4147;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um_orden.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:center; width:10%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:9px; text-align:left; width:70%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #3E4147;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; width:60%; border-left: 1px solid #3E4147;"></td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:30%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F; color:white; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #3E4147;" colspan="4" rowspan="5">'.$notas_cond.'</td>
                                    </tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                    <tr><td></td></tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #3E4147;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);

                $nombre_archivo = utf8_decode("orden_".$trannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');

            }
        }
        
        function send_email($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $trannum = $this->input->post('trannum');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                
                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#CC333F; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #3E4147;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #3E4147;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #3E4147;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #3E4147;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #3E4147;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #3E4147;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                echo json_encode($estructura);
            }
        }
        
        function send_email2($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                
                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#CC333F; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #3E4147;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #3E4147;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #3E4147;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', ',');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #3E4147;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #3E4147;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';
                return($estructura);
            }
        }
        
        function enviar_correo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $trannum = $this->input->post('trannum');
                $de = $this->input->post('de');
                $para = $this->input->post('para');
                $cc = $this->input->post('cc');
                $asunto = $this->input->post('asunto');
                $mensaje = $this->input->post('mensaje');
                if($de!=""){
                    
                    $this->load->model('global_model');
                    $razon_social = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                    $nombre_comercial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 2);
                    $tabla = $this->send_email2($trannum);
                    //$this->load->library('My_PHPMailer');
                    
                    //$this->email->subject($asunto);
                    //$this->email->set_mailtype("html");
                    $body ="<h1>".$nombre_comercial."</h1>";
                    $body .= "<h3>".$mensaje."</h3>";
                    $body .=$tabla;
                    
                    
                    
                    $this->load->library('My_PHPMailer');
                    $mail = new PHPMailer();
                    $mail->IsSMTP(); // establecemos que utilizaremos SMTP
                    $mail->SMTPAuth   = true; // habilitamos la autenticación SMTP
                    $mail->SMTPSecure = "tls";
                    $mail->Host       = "smtp.gmail.com";      // establecemos GMail como nuestro servidor SMTP
                    $mail->Port       = 587;                   // establecemos el puerto SMTP en el servidor de GMail
                    $mail->Username   = "versanetsasv@gmail.com";  // la cuenta de correo GMail
                    $mail->Password   = "Egga#94662";            // password de la cuenta GMail
                    $mail->IsHTML(true);
                    $mail->SetFrom($de, $nombre_comercial);  //Quien envía el correo
                    $mail->addAddress($de);
                    $mail->Subject = $asunto;  //Asunto del mensaje
                    $mail->Body = $body;
                    $destino = $para;
                    //$arreglo_para = explode(",", $para);
                    // $cant = count($arreglo_para);
                    //for($m = 0; $m<$cant; $m++){
                    $mail->AddAddress($para);
                    if($cc!=""){
                        $mail->AddAddress($para);

                    }else{
                        $mail->AddAddress($cc);
                    }
                    $mail->CharSet = 'UTF-8';
                    
                    $this->load->library('Pdf');
                    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

                    $pdf->SetCreator(PDF_CREATOR);
                    $pdf->SetAuthor('Versanet Sistemas');
                    $pdf->SetTitle('Orden de Compra');
                    $pdf->SetSubject('Orden de Compra');
                    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                    $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                    $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                    // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetMargins(5, 5, 5);
                    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                    // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                    $pdf->SetAutoPageBreak(TRUE, 5);
                    //relación utilizada para ajustar la conversión de los píxeles
                    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                    //---------------------------------------------------------
                    //establecer el modo de fuente por defecto
                    $pdf->setFontSubsetting(true);
                    //$pdf->setPageOrientation('Portrait');
                    $pdf->setPageOrientation('P');

                    // Establecer el tipo de letra
                    //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                    // Helvetica para reducir el tamaño del archivo.
                    $pdf->SetFont('Helvetica', '', 7, '', true);

                    // Añadir una página
                    // Este método tiene varias opciones, consulta la documentación para más información.
                    // set auto page breaks
                    //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                    //$pdf->SetAutoPageBreak(TRUE, 1);

                    $pdf->setPrintHeader(false);
                    $pdf->setPrintFooter(false);
                    $pdf->addPage( 'P', 'LETTER' );

                   $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $this->load->model('variable_model');
                $name = $this->pedclientes_model->getnameImg();
                $list_productos = $this->compras_model->getDetail_products($trannum);
                $det = $this->compras_model->detalleOrdenCompra2($trannum);
                $vars = $this->variable_model->getTextVar("po_notas");
                
                $notas_cond = $vars['valor_memo'];
                $proveedor = $det['proveedor'];
                $cliente = $det['workername'];
                $formaPago = $det['formaPago'];
                $orden = $det['trannum'];
                $cli_phone = $det['trannum'];
                $cli_email = $det['trannum'];
                $valVenta = $det['trannum'];
                $direccion = $det['direccion'];
                $tel_pro = $det['tel_pro'];
                $notas_orden = $det['notas'];
                $caj_clase = $det['cajclase'];
                $provee_dias = $det['provee_dias'];
                $provee_tipo = $det['provee_tipo'];
                 
                if($tel_pro==""){
                    $tel_pro="N/A";
                }
                if($direccion==""){
                    $direccion="N/A";
                }
                $muni_dep = trim($det['municipio'])." ".trim($det['depto']);
                if($muni_dep==""){
                    $muni_dep="N/A";
                }
                $notas = "";
                $date = date_format(date_create($det['fecha']),'d/m/Y');
                $dia = date_format(date_create($det['fecha_entrega2']),'d');
                $dia_n = date_format(date_create($det['fecha_entrega2']),'w');
                $mes = date_format(date_create($det['fecha_entrega2']),'m');
                $anio = date_format(date_create($det['fecha_entrega2']),'Y');
                
                switch($dia_n){
                    case 0:
                        $dia_semana = "Domingo";
                        break;
                    case 1:
                        $dia_semana = "Lunes";
                        break;
                    case 2:
                        $dia_semana = "Martes";
                        break;
                    case 3:
                        $dia_semana = "Miércoles";
                        break;
                    case 4:
                        $dia_semana = "Jueves";
                        break;
                    case 5:
                        $dia_semana = "Viernes";
                        break;
                    case 6:
                        $dia_semana = "Sábado";
                        break;
                    default:
                        $dia_semana="";
                        break;
                }
                  
                switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $fecha_entrega = $dia_semana. " ". $dia ." de ".$mes_name." de ".$anio;
                
                
                $dev_time = date("g:i a", strtotime($det['dev_time']));
                $dev_place = $det['lugar_entrega'];    
                $telefono = $det['telefono'];    
               
                $inv_notas = $det['inv_notas'];
                if($inv_notas!=""){
                    $dev_place .= ",".$inv_notas;
                }
                

                $exento = 0;
                $gravado = 0;
                $iva = 0;
                $sub_total = 0;


                if(is_array($list_productos) and $list_productos!=false){
                    foreach($list_productos as $key){
                        
                        if($key->tipotax==0){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $exento = number_format($exento, 6, '.', '') + number_format($subtotal, 6, '.', '');
                        }else if($key->tipotax==13){
                            $subtotal = number_format($key->cantidad, 6, '.', '') * number_format($key->precioneto, 6, '.', ''); 
                            $gravado = number_format($gravado, 6, '.', '') + number_format($subtotal, 6, '.', '');      
                            $iva =  $iva + (number_format($subtotal, 6, '.', '') * ($key->tipotax/100));
                        }
                        $sub_total = number_format($exento, 6, '.', '') + number_format($gravado, 6, '.', '') + number_format($iva, 6, '.', '');
                    }
                }

                if($provee_tipo!=3){
                    if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$en_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
                    }else{
                        $en_total = number_format($sub_total, 2, '.', '');
                    }
                }else{
                    $en_total = number_format($sub_total, 2, '.', '');
                }
                
                
                $estructura = '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px; min-width: 25%; max-height: 200px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">ORDEN DE COMPRA</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:60%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#CC333F; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                $estructura .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left;font-weight: bold;  width:60%;">'.$proveedor.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">N° de orden</td>
                                        <td style="font-size:10px; text-align:right; font-weight: bold; width:25%; border: 1px solid #3E4147;color:#0B486B;">'.$orden.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; fwidth:60%;">'.$direccion.'</td>  
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Fecha.</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$date.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">'.$muni_dep.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Forma de Pago</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$formaPago.'</td>
                                    </tr>';
                
                if($caj_clase==12){
                    $estructura .= '<tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Días</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$provee_dias.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;"></td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }else{
                    $estructura .= '
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:60%;">Teléfono: '.$tel_pro.'</td>
                                        <td style="font-size:10px; text-align:left; font-weight: bold; width:15%; border: 1px solid #3E4147;">Total</td>
                                        <td style="font-size:10px; text-align:right; width:25%; border: 1px solid #3E4147;">$'.number_format($en_total, 2, '.', ',').'</td>
                                    </tr>
                                </table>';
                }
                
                 

                 $estructura .= '<br><br><table style="width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalles de entrega</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Fecha</td>
                                        <td style="font-size:10px; text-align:left; width:45%; border: 1px solid #3E4147;">'.$fecha_entrega.'</td>
                                        <td style="font-size:10px; text-align:left; width:10%; font-weight: bold; border: 1px solid #3E4147;">Hora</td>
                                        <td style="font-size:10px; text-align:left; width:30%; border: 1px solid #3E4147;">'.$dev_time.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Lugar</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$dev_place.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; width:15%; font-weight: bold; border: 1px solid #3E4147;">Solicitado por:</td>
                                        <td style="font-size:10px; text-align:left; width:85%; border: 1px solid #3E4147;" colspan="3">'.$cliente.'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:10px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;" colspan="4">Detalle del Pedido</td>
                                    </tr>
                                    </table>
                                    <table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:10px; text-align:center; width:8%; font-weight: bold;">Cant.</td>
                                        <td style="font-size:10px; text-align:center; width:12%; font-weight: bold;">Código</td>
                                        <td style="font-size:10px; text-align:left; width:30%; font-weight: bold;">Descripción del Producto</td>
                                        <td style="font-size:10px; text-align:center; width:10%; font-weight: bold;">UM</td>
                                        <td style="font-size:10px; text-align:left; width:20%; font-weight: bold;">Notas</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Precio</td>
                                        <td style="font-size:10px; text-align:right; width:10%; font-weight: bold;">Sub-total</td>
                                    </tr>';
                                if(is_array($list_productos) and $list_productos!=false){
                                    foreach($list_productos as $key){
                                        //<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format(($key->cantidad * $key->precioneto), 4, '.', '').'</td>

                                        $estructura .= '<tr>
                                                            <td style="font-size:10px; text-align:center; width:8%;">'.round($key->cantidad).'</td>
                                                            <td style="font-size:10px; text-align:center; width:12%;">'.round($key->idproducto).'</td>
                                                            <td style="font-size:10px; text-align:left; width:30%;">'.$key->descrip.'</td>
                                                            <td style="font-size:10px; text-align:center; width:10%;">'.$key->um.'</td>
                                                            <td style="font-size:9px; text-align:left; width:20%;">'.$key->notas.'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format($key->precioneto, 6, '.', ',').'</td>
                                                            <td style="font-size:10px; text-align:right; width:10%;">$'.number_format(($key->cantidad * $key->precioneto), 6, '.', ',').'</td>
                                                        </tr>';
                                                }
                                }

                $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:center; width:90%;"></td>
                                        <td style="font-size:12px; text-align:center; width:10%; border-right: 1px solid #3E4147;"></td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Exento</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($exento, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total Gravado</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($gravado, 2, '.', ',').'</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">IVA</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">$'.number_format($iva, 2, '.', ',').'</td>
                                    </tr>';
                
                    if($provee_tipo!=3){
						if($gravado > 100){
							$percepcion = number_format($gravado, 2, '.', '') * 0.01;
							$sub_total = number_format($sub_total, 2, '.', '') - number_format($percepcion, 2, '.', '');
							$estructura .= '
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Retención 1%</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;">- $'.number_format($percepcion, 2, '.', ',').'</td>
										</tr>
										<tr>
											<td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
											<td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
										</tr>';
						}else{
							$estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
						}
                    }else{
                        $estructura .= '<tr>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:90%;">Total</td>
                                        <td style="font-size:12px; text-align:right; width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; ">$'.number_format($sub_total, 2, '.', ',').'</td>
                                    </tr>';
                    }
                
                
                    
                    $estructura .= '</table><table style="border: 1px solid #3E4147;;width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; background-color:#CC333F; width:100%; font-weight: bold; border: 1px solid #3E4147;">Condiciones</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:100%; border: 1px solid #3E4147;">'.$notas_cond.'</td>
                                    </tr>
                                </table><br><br><br>';
                    $estructura .= '<table style="width:100%;">
                                    <tr><td><br><br><br></td></tr>
                                    <tr>
                                        <td style="width:35%;"></td>
                                        <td style="width:30%;text-align:center; vertical-align:middle; font-size: 10px; border-top: 1px solid #3E4147;">Autorizado por</td>
                                        <td style="width:35%;"></td>
                                    </tr>
                                    
                                </table>';

                    $pdf->writeHTML($estructura, true, 0, false, false, 0);
                    $path = base_url()."doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                    $nombre_archivo = "orden_".$trannum;
                    $fullpath = $_SERVER['DOCUMENT_ROOT']."/".$nombre_archivo.".pdf";
                    $pdf->Output($fullpath,'F');
                    //$this->email->message($body);
                    if($nombre_archivo!=''){
                        $mail->AddAttachment($fullpath, $name = $nombre_archivo.".pdf",  $encoding = 'base64', $type = 'application/pdf');
                    }

                    if(!$mail->Send()) {
                        unlink($fullpath);
                        $array_result = array(
                            "mensaje" =>"Correo no enviado",
                            "type" =>"warning",

                        );
                        echo json_encode($array_result);
                    } else {
                        unlink($fullpath);
                        $notas_correo = "Correo enviado de: ". $de . " a: ". $para . ','.$cc;
                        $array_result = array(
                            "mensaje" =>"Correo enviado",
                            "type" =>"success",
                        );
                        $sent_suc = $this->compras_model->insertOrders_100a($trannum,3,$notas_correo);
                        echo json_encode($array_result);
                    }
                }else{
                    $array_result = array(
                        "mensaje" =>"El empleado no tiene correo",
                        "type" =>"warning",     
                    );
                    echo json_encode($array_result);
                }
            }
        }        
        
        function analisis_antiguedad_ap(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">Saldo Total</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ap();
                $info = $this->arap_model->getProveedores_ap();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="9" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo  && $i->saldo!=0){
                            
                            if($cant==0){
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee= $i->provee;
                                $last_nrc= $i->nrc;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2">'.$last_provee.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th colspan="2" ></th><th style="font-size:11px; text-align:right; border-top: 1px solid #3E4147;">SUBTOTAL</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #3E4147;"><th colspan="2"></th><th style="font-size:11px; text-align:right; border-top: 1px double #3E4147;">TOTALES</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_tantiguedad_ar(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 5, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('global_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label></center>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #3E4147; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #3E4147; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #3E4147; width:8%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #3E4147; width:8%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #3E4147; width:9%; text-align:center;">Disponible</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar();
                $info = $this->arap_model->getListClientes_ar();
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11"></th></tr><tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->workername).'<br></th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $last_direccion= "";
                    $last_telefono= "";
                    $last_depto= "";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->workername==$gr->workername and ($i->saldo!=0)){
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                 $cant++;
                            }else{
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td></tr>';
                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                    $cant=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #3E4147;"><th></th><th colspan="2" style="font-size:11px; text-align:right; font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function analisis_antiguedad_ar($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Análisis de Antiguedad');
                $pdf->SetSubject('Análisis de Antiguedad');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(5, PDF_MARGIN_TOP, 10, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(5, PDF_MARGIN_TOP, 5, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $this->load->model('global_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="border-bottom: 1px solid #3E4147; width:8%; text-align:left;">Código</th>
                                <th style="border-bottom: 1px solid #3E4147; width:17%; text-align:left;">Nombre</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">1-30</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">31-60</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">61-90</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">91-120</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">121+</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Saldo Total</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Límite</th>
                                <th style="border-bottom: 1px solid #3E4147; width:8%; text-align:center;">Disponible</th>
                                <th style="border-bottom: 1px solid #3E4147; width:5%; text-align:right;">%</th>
                            </tr>';
                $grupos = $this->arap_model->getGrupos_ar_vende($idvendedor);
                $info = $this->arap_model->getListClientes_ar_vende($idvendedor);
                $sum_tot_dias1=0;
                $sum_tot_dias2=0;
                $sum_tot_dias3=0;
                $sum_tot_dias4=0;
                $sum_tot_dias5=0;
                $subtot_dias1=0;
                $subtot_dias2=0;
                $subtot_dias3=0;
                $subtot_dias4=0;
                $subtot_dias5=0;
                $last_provee="";
                $last_nrc= "";
                $last_direccion= "";
                $last_telefono= "";
                $last_depto= "";
                $sum_total_porcent=0;
                foreach($info as $i){
                    $sum_total_porcent +=$i->saldo;
                }
                
                foreach($grupos as $gr){
                    $titulo .= '<tr><th colspan="11" style="font-size:11px; font-weight:bold;">'.strtoupper($gr->grupo).'</th></tr>';
                    $tot_dias1=0;
                    $tot_dias2=0;
                    $tot_dias3=0;
                    $tot_dias4=0;
                    $tot_dias5=0;
                    $last_provee="";
                    $last_nrc="";
                    $cant=0;
                    $sum_subtotal=0;
                    foreach($info as $i){
                        if($i->grupo==$gr->grupo and ($i->saldo!=0)){
                            
                            if($cant==0){
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }
                            
                            if($last_provee==trim($i->provee)){
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                                $last_provee=trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_limit = $i->limite;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                            }else{
                                
                                $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                                $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                                $dispo = $last_limit-$sum_prov;
                                $porcen=0;
                                $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td><td style="text-align:right;">'.number_format(round($last_limit, 2),2).'</td><td style="text-align:right;">'.number_format(round($dispo, 2),2).'</td><td style="text-align:right;">'.number_format(round((($sum_prov/$sum_total_porcent)*100), 2),2).'</td></tr>';

                                $subtot_dias1+= $tot_dias1;
                                $subtot_dias2+= $tot_dias2;
                                $subtot_dias3+= $tot_dias3;
                                $subtot_dias4+= $tot_dias4;
                                $subtot_dias5+= $tot_dias5;
                                $last_provee= trim($i->provee);
                                $last_nrc= $i->nrc;
                                $last_direccion= $i->direccion;
                                $last_telefono= $i->telefono;
                                $last_depto= $i->depto;
                                $tot_dias1=0;
                                $tot_dias2=0;
                                $tot_dias3=0;
                                $tot_dias4=0;
                                $tot_dias5=0;
                                if($i->dias >=1 && $i->dias<=30){
                                    $tot_dias1 += $i->saldo;
                                }else if($i->dias >=31 && $i->dias<=60){
                                    $tot_dias2 += $i->saldo;
                                }else if($i->dias >=61 && $i->dias<=90){
                                    $tot_dias3 += $i->saldo;
                                }else if($i->dias >=91 && $i->dias<=120){
                                    $tot_dias4 += $i->saldo;
                                }else if($i->dias >=121){
                                    $tot_dias5 += $i->saldo;
                                }
                            }
                            $cant++;
                        }
                    }
                    $titulo .= '<tr><td>'.$last_nrc.'</td><td colspan="2"><b>'.$last_provee.'</b><br>'.$last_direccion.$last_depto.'<br>'.$last_telefono.'</td>';
                    $sum_prov = $tot_dias1+ $tot_dias2+ $tot_dias3+ $tot_dias4+ $tot_dias5;
                    $subtot_dias1+= $tot_dias1;
                    $subtot_dias2+= $tot_dias2;
                    $subtot_dias3+= $tot_dias3;
                    $subtot_dias4+= $tot_dias4;
                    $subtot_dias5+= $tot_dias5;
                    $sum_subtotal= $subtot_dias1+$subtot_dias2+$subtot_dias3+$subtot_dias4+$subtot_dias5;
                    $titulo .='<td style="text-align:right;">'.number_format(round($tot_dias1, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias2, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias3, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias4, 2),2).'</td><td style="text-align:right;">'.number_format(round($tot_dias5, 2),2).'</td><td style="text-align:right;">'.number_format(round($sum_prov, 2),2).'</td></tr>';
                    $titulo .= '<tr><th></th><th colspan="2" style="font-size:11px; text-align:right;font-weight:bold;">SUBTOTAL</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias1, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias2, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias3, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias4, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($subtot_dias5, 2),2).'</th><th  style="border-top: 1px solid #3E4147; text-align:right;">'.number_format(round($sum_subtotal, 2),2).'</th></tr>';
                    $sum_tot_dias1+= $subtot_dias1;
                    $sum_tot_dias2+= $subtot_dias2;
                    $sum_tot_dias3+= $subtot_dias3;
                    $sum_tot_dias4+= $subtot_dias4;
                    $sum_tot_dias5+= $subtot_dias5;
                    $subtot_dias1=0;
                    $subtot_dias2=0;
                    $subtot_dias3=0;
                    $subtot_dias4=0;
                    $subtot_dias5=0;
                }
                $gran_total= $sum_tot_dias1+$sum_tot_dias2+$sum_tot_dias3+$sum_tot_dias4+$sum_tot_dias5;
                $titulo .= '<tr style="border-top: 1px double #3E4147;"><th colspan="2"></th><th style="font-size:11px; text-align:right;font-weight:bold;">TOTALES</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias1, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias2, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias3, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias4, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($sum_tot_dias5, 2),2).'</th><th  style="border-top: 1px double #3E4147; text-align:right;">'.number_format(round($gran_total, 2),2).'</th></tr>';
                $titulo .= '<tr><th colspan="3" style="font-size:11px; text-align:right;"></th><th  style="text-align:right; color: #031634;">'.number_format(round((($sum_tot_dias1/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias2/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias3/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias4/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;">'.number_format(round((($sum_tot_dias5/$gran_total)*100), 2),2).'%</th><th  style="text-align:right;color: #031634;"></th></tr>';

                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Analisis_Antiguedad.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
        function inv_valorizado($depto, $suc_list){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $suc = $this->sucursal_model->viewSucursalActiva();
                
                if($suc_list==0){
                    $names="Totales";
                }else{
                    $arraySuc = explode("-", $suc_list);
                    $totRig = count($arraySuc);
                    $totReal = $totRig-1;
                    $names = "";
                    for($i=0; $i<$totReal; $i++){
                        $rest = substr($arraySuc[$i], -1);
                        if($rest!="_"){
                            foreach($suc as $sucur){
                                if($sucur->idcentro==$arraySuc[$i]){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }else{
                            $id = substr($arraySuc[$i],0,-1);
                            foreach($suc as $sucur){
                                if($sucur->tipo==$id){
                                    $names .= $sucur->descrip.",";
                                }
                            }
                        }
                    }
                    $names =  substr($names, 0, -1);
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label><br><label style="text-align:center; font-size:12px;">'.$names.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos();
                $titulo='';
                if($depto=="0"){
                    //Mostrar kardex de todos los departamentos
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #3E4147; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #3E4147; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #3E4147; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #3E4147; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                                <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                                <td style="border-top: 1px solid #3E4147;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                            </tr></table>';
                    
                }else{
                    //Llenar tabla de departamento por parametro
                    
                    
                    $sum_total=0;
                    foreach($departamentos_list as $dep){
                        if($dep->idcatalogo==$depto){
                            $sum_dep=0;

                            $titulo_depto ='<table  style="width:100%;  border-collapse: collapse;">
                        <tr>
                            <th style="width:100%; text-align:left; font-size:15px; font-weight:bold;color: #031634;">'.$dep->departamento.'</th>
                        </tr></table>';
                        $lineas_list = $this->sucursal_model->get_lineas_kardex($dep->idcatalogo);
                        $lista_productos = $this->sucursal_model->get_Existencias_report($dep->idcatalogo, $suc_list);
                        $titulo_linea='';
                        foreach($lineas_list as $lin){
                            $titulo_linea ='<table  style="width:100%;  border-collapse: collapse;">
                            <tr>
                                <th style="width:5%;"></th>
                                <th style="width:95%; text-align:left; font-size:13px; font-weight:bold;">'.$lin->linea.'</th>
                            </tr></table>';
                            $titulo_linea .='<table  style="width:100%; border-collapse: collapse;">
                            <tr>
                                <th style="width:5%; text-align:left;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">Código</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;">Modelo</th>
                                <th style="border-bottom: 1px solid #3E4147; width:34%; text-align:center;">Descripción</th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">UM</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Cantidad</th>
                                <th style="border-bottom: 1px solid #3E4147; width:7%; text-align:center;">Costo Unitario</th>
                                <th style="border-bottom: 1px solid #3E4147; width:12%; text-align:center;">Sub total</th>
                            </tr>';
                            $sum_linea =0;
                            foreach($lista_productos as $product){
                                if($product->idcatalogo==$lin->idcatalogo){
                                    //$titulo.='<tr><td>'.$product->cantidad.'</td></tr>';
                                    $sum_linea+=($product->costounitario*$product->cantidad);
                                    $sum_dep +=($product->costounitario*$product->cantidad);
                                    $sum_total +=($product->costounitario*$product->cantidad);
                                    $titulo_linea.='<tr>
                                        <td style="width:5%; text-align:left;"></td>
                                        <td style="width:10%; text-align:center;">'.$product->id.'</td>
                                        <td style="width:15%; text-align:center;">'.$product->modelo.'</td>
                                        <td style="width:34%; text-align:left;">'.$product->producto.'</td>
                                        <td style="width:10%; text-align:center;">'.$product->um.'</td>
                                        <td style="width:7%; text-align:right;">'.number_format(round($product->cantidad, 2),2).'</td>
                                        <td style="width:7%; text-align:right;">$'.number_format(round($product->costounitario, 2),2).'</td>
                                        <td style="width:12%; text-align:right;">$'.number_format(round($product->costounitario*$product->cantidad, 2),2).'</td>
                                    </tr>';
                                }
                            }
                            $titulo_linea .='<table style="margin-top:5px;"><tr>
                                <td  style="text-align:right;font-size:11px; width:90%;"><br>Sub Total '.$lin->linea.'</td>
                                <td style="border-top: 1px solid #3E4147; font-size:10px;text-align:right; width:10%;"><br>$'.number_format(round($sum_linea, 2),2).'</td>
                            </tr></table>';
                            if($sum_linea>0){
                                $titulo_depto .= $titulo_linea;
                            }else{
                                $titulo_linea='';
                            }
                        }
                        
                        $titulo_depto .='<table style="margin-top:5px;"><tr>
                            <td style="text-align:right;font-size:11px; width:90%;font-weight:bold;"><br>Sub Total '.$dep->departamento.'</td>
                            <td style="border-top: 1px solid #3E4147; font-size:10px;text-align:right; width:10%; font-weight:bold;"><br>$'.number_format(round($sum_dep, 2),2).'</td>
                        </tr></table>';
                        if($sum_dep>0){
                            $titulo .= $titulo_depto;
                        }else{
                            $titulo_depto='';
                        }
                        }
                    }
                    $titulo .='<table style="margin-top:5px;"><tr>
                        <td style="text-align:right; font-weight:bold;font-size:11px; width:90%;"><br>Total</td>
                        <td style="border-top: 1px solid #3E4147;  font-weight:bold;font-size:11px; text-align:right; width:10%;"><br>$'.number_format(round($sum_total, 2),2).'</td>
                    </tr></table>';
                }
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function departamentos_lineas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                
                $departamentos_list = $this->producto_model->viewDepartamentos_products();
                $lineas_list = $this->catalog_model->list_lineas_productos();

                $titulo='';
                    //Mostrar kardex de todos los departamentos
                $titulo .='<table  style="width:100%;  border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #3E4147;">
                    <th style="border-bottom: 1px solid #3E4147; width:45%; text-align:center;">Departamento/Línea</th>
                    <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;">Referencia</th>
                    <th style="border-bottom: 1px solid #3E4147; width:35%; text-align:center;">Centro de Producción o Distribución</th>
                    <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:right;">Productos</th>
                </tr>';
                    foreach($departamentos_list as $dep){
                        $sum_dep=0;
                        foreach($lineas_list as $lin){
                            if($lin->idnivel1==$dep->idcatalogo){
                                $sum_dep +=$lin->cant;
                            }
                        }
                       // if($sum_dep!=0){
                            $titulo .='<tr>
                                <th style="width:45%; text-align:left; font-size:13px; padding-left:25px; font-weight:bold;color: #031634;"><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$dep->departamento.'</th>
                                <th style="width:10%; text-align:center; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$dep->idcatalogo.'</th>
                                <th style="width:35%; text-align:left; font-size:13px; font-weight:bold;color: #031634;"><br><br></th>
                                <th style="width:10%; text-align:right; font-size:13px; font-weight:bold;color: #031634;"><br><br>'.$sum_dep.'</th>
                            </tr>';
                       // }
                       
                        foreach($lineas_list as $lin){
                            //&& $lin->cant!=0
                            if($lin->idnivel1==$dep->idcatalogo){
                                $titulo .='
                                    <tr>
                                        <td style="width:45%; text-align:right;  font-size:11px;">'.$lin->subdepartamento.'</td>
                                        <td style="width:10%; text-align:center;  font-size:11px;">'.$lin->idcatalogo.'</td>
                                        <td style="width:35%; text-align:center;  font-size:11px;">'.$lin->centro.'</td>
                                        <td style="width:10%; text-align:right;  font-size:11px;">'.$lin->cant.'</td>
                                    </tr>';
                            }
                        }
                    }
                    $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("departamentos_lineas.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function carteraporvendedor($idvendedor){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cartera por Vendedor');
                $pdf->SetSubject('Cartera por Vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('arap_model');
                $this->load->model('auxi_model');
                $name = $this->auxi_model->getNameAuxi($idvendedor);
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
               
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.trim($this->session->userdata('descrip')).'</label><br><label style="text-align:center; font-size:15px;">'.trim($nombre_doc).'</label><br><label style="text-align:center; font-size:13px;">'.$name.'</label></center>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo ='<table  style="width:100%;  border-collapse: collapse;">';
                $info = $this->arap_model->getCuentas_ar_cartera($idvendedor);
                $clientes = $this->arap_model->getClientes_ar_cartera($idvendedor);
                $total_clientes=0;
                foreach($clientes as $client){
                    $titulo .='
                            <tr>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                                <td colspan="3" style="width:80%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br>'.$client->Name.'</td>
                                <td style="width:10%; text-align:left; font-size:12px;font-weight:bold; color: #031634;"><br><br></td>
                            </tr>
                            <tr>
                                <th style="width:10%; text-align:left;font-size:11px;"></th>
                                <th style="border-bottom: 1px solid #3E4147; width:10%; text-align:center;font-size:11px;">N°</th>
                                <th style="border-bottom: 1px solid #3E4147; width:15%; text-align:center;font-size:11px;">Fecha</th>
                                <th style="border-bottom: 1px solid #3E4147; width:35%; text-align:left;font-size:11px;">Tipo</th>
                                <th style="border-bottom: 1px solid #3E4147; width:20%; text-align:right;font-size:11px;">Saldo</th>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>

                            </tr>';
                    
                    $sum=0;
                    foreach($info as $inf){
                        if($inf->idauxi==$client->ID && $inf->saldo!=0){
                            $sum += $inf->saldo;
                            $total_clientes+=$inf->saldo;
                            $titulo .='<tr>
                                <td style="width:10%; text-align:left;font-size:10px;"></td>
                                <td style="width:10%; text-align:center;font-size:10px;">'.$inf->numero.'</td>
                                <td style="width:15%; text-align:center;font-size:10px;">'.$inf->fecha.'</td>
                                <td style="width:35%; text-align:left;font-size:10px;">'.$inf->tipoDoc.'</td>
                                <td style="width:20%; text-align:right;font-size:10px;">$'.number_format($inf->saldo,2).'</td>
                                <th style="width:15%; text-align:left;font-size:11px;"></th>
                            </tr>';
                        }
                    }
                     $titulo .='
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Sub-Total</th>
                                <th style="border-top: 1px solid #3E4147; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($sum,2).'</th>
                                <td style="width:20%; text-align:left;font-size:10px;"></td>
                            </tr>';
                }
                $titulo .='<tr><th colspan="5"><br></th></tr>
                            <tr>
                                <th colspan="4" style=" width:80%; text-align:right;font-size:11px; font-weight:bold;">Total</th>
                                <th style="border-top: 1px solid #3E4147; width:10%; text-align:right;font-size:11px; font-weight:bold;">$'.number_format($total_clientes,2).'</th>
                                <td style="width:15%; text-align:left;font-size:10px;"></td>
                           </tr>';
                
                $titulo .= '</table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("carteraporvendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function cuadre_vendedor($idvendedor, $fechai, $fechaf){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Cuadre por vendedor');
                $pdf->SetSubject('Cuadre por vendedor');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
               // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                /*
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                */
                
                
                
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
                $fechai = str_replace("-", "/", $fechai);
                $fechaf = str_replace("-", "/", $fechaf);
                $fecha1 = new Datetime($fechai);
                $fecha2 = new Datetime($fechaf);
                $this->load->model('ventas_model');
                $this->load->model('empleado_model');
                $docs = $this->ventas_model->tipos_doc($idvendedor, $fechai, $fechaf);
                $ventas = $this->ventas_model->ventas_diarias($idvendedor, $fechai, $fechaf);
                $abonos = $this->ventas_model->abonos_diarios($idvendedor, $fechai, $fechaf);
                $empleado = $this->empleado_model->viewEmple();
                $name="";
                foreach($empleado as $em){
                    if($em->idauxi==$idvendedor){
                        $name = $em->descrip;
                    }
                }
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$name.'( Del '.$fecha1->format('d/m/Y').' al '.$fecha2->format('d/m/Y').')</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
               
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
               
                $titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 15%">N° de Factura</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Referencia</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:center;  font-weight: bold; width: 15%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:left;  font-weight: bold; width: 40%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:10px; text-align:right;  font-weight: bold; width: 15%">Valor</th>
                        </tr>
                        <tr>
                        <th colspan="5"><br></th>
                        </tr>
                    </thead>
                <tbody>';
                
                $subtotal=0;
                $total=0;
                foreach($docs as $docs){
                    $subtotal=0;
                    $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;"><br>'.$docs->tipoDoc.'</th></tr>';
                    foreach($ventas as $ven){
                         if($docs->tipoDoc==$ven->tipoDoc){
                             $subtotal= $subtotal+$ven->saldo;
                             $date = date_format(date_create($ven->fecha),'d/m/Y');
                             $titulo .= '
                                 <tr>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$ven->numero.'</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">-</td>
                                    <td style="font-size:10px; text-align:center;  font-weight: normal; width: 15%">'.$date.'</td>
                                    <td style="font-size:10px; text-align:left;  font-weight: normal; width: 40%">'.$ven->cliente.'</td>
                                    <td style="font-size:10px; text-align:right;  font-weight: normal; width: 15%">$'.number_format(round($ven->saldo, 2),2).'</td>
                                </tr>';
                         }
                    }              
                    $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';

                    $total =$total+$subtotal;
                    
                }
                $titulo .= '<tr><th colspan="5" style="font-size:12px; text-align:left;  font-weight: bold; margin-top:10px; margin-bottom:10px;">ABONOS</th></tr>';
                $subtotal=0;
                foreach($abonos as $abo){
                    $date = date_format(date_create($abo->fecha),'d/m/Y');
                    $subtotal= $subtotal+$abo->saldo;
                    $titulo .= '
                        <tr>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->numero.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$abo->referencia.'</td>
                            <td style="font-size:10px; text-align:center; font-weight: normal; width: 15%">'.$date.'</td>
                            <td style="font-size:10px; text-align:left; font-weight: normal; width: 40%">'.$abo->cliente.'</td>
                            <td style="font-size:10px; text-align:right; font-weight: normal; width: 15%">$'.number_format(round($abo->saldo, 2),2).'</td>
                        </tr>';
                }
                $titulo .= '<tr><th colspan="5" style="font-size:10px; text-align:right;  font-weight: bold;">Subtotal: $'.number_format(round($subtotal, 2),2).'</th></tr>';
                $total =$total+$subtotal;
                $titulo .= '<tr><th colspan="5"><br></th></tr><tr><th  colspan="4"></th><th style="font-size:12px; text-align:right;  border-top: 1px solid black;  font-weight: bold;">Total: $'.number_format(round($total, 2),2).'</th></tr>';

                $titulo .= '</tbody></table>';
               
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Cuadre_Vendedor.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_variables(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
				/*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
				$this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Variables Sistema');
                $pdf->SetSubject('Reporte de Variables Sistema');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 28, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                
               	$funcion = $this->uri->segment(3);
				$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->model('variable_model');
                $nombres = $this->variable_model->verNombres();
                $variables = $this->variable_model->verVariables();
				
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
               
                <th colspan="2" width="30%" style=" border-bottom: solid 3px black; font-size:12px;   text-align:left;  font-weight: bold;" >Descripción</th>
                <td width="10%"  style="border-bottom: solid 3px black;"></td>
                <th width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Filtro</th>
                <td width="5%" style="border-bottom: solid 3px black;"></td>
                <th width="24%" style="font-size:12px; border-bottom: solid 3px black;  text-align:right;  font-weight: bold;" >Valor</th>
                </tr>
                </tbody>
                </table>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                


                $pdf->AddPage();
                
                $titulo='';
                
                   
                
                foreach($nombres as $grupo){
                  
                    
                
                
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '  <thead>
                                <tr>
                                    <th colspan="6" style="font-size:17px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;" width="100%">'.$grupo->nombre.'</th>
                                  
                                </tr>
                                
                                </thead>';  
                
                $titulo .= '  <tbody>';
                    foreach($variables as $sub){  
                    
                       if($grupo->nombre == $sub->nombre){
                           
                           if($sub->tipo_valor == 1){
                              $tipo = "N";
                              $valor = $sub->valor_num;
                           }else if($sub->tipo_valor == 2){
                               $tipo = "T";
                               $valor = $sub->valor_txt;
                           }else if($sub->tipo_valor == 3){
                               $tipo = "F";
                               $valor = $sub->valor_fecha;
                           }else if($sub->tipo_valor == 4){
                               $tipo = "L";
                               $valor = $sub->valor_logico;
                           }else if($sub->tipo_valor == 5){
                               $tipo = "M";
                               $valor = $sub->valor_num;
                           }
                
                           $titulo .= '  
                                <tr>
                                   
                                    <td colspan="2" width="30%" style="font-size:11px; font-weight:bold;   text-align:left;" >'.$sub->descripcion.'('.$tipo.')</td>
                                    <td width="10%"></td>
                                    <td width="30%" style="font-size:11px;  text-align:center;" >'.$sub->filtro.'</td>
                                    <td width="5%"></td>
                                    <td width="24%" style="font-size:11px;  text-align:right;" >'.$valor.'</td>
                                </tr> ';
                           
                           if($sub->valor_memo == ""){ 
                            
                           }else{
                               
                                $titulo .= '<tr>
                                    <td width="5%"></td>
                                    <td colspan="2" width="45%" style="font-size:11px;   text-align:left;" >'.$sub->valor_memo.'</td>
                                    <td  width="30%" ></td>
                                    <td  width="5%" ></td>
                                    <td width="35%"  ></td>
                                </tr>';
                               
                               
                           }
                           
                                
                       }}
                    
                     
                
                 $titulo .= '<tbody></table><br><br>';
                
                
                
          
                
                
                }
                    

                
                
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Variables_Sistema.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporte_aplicaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                /*$this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);*/
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Listado de Aplicaciones');
                $pdf->SetSubject('Reporte de Listado de Aplicaciones');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                // $pdf->setFooterData(0);
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                //$pdf->SetMargins(PDF_MARGIN_LEFT, 30, PDF_MARGIN_RIGHT); // set the margins 
                //$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
               //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                
                //$pdf->SetAutoPageBreak(TRUE, 75);
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
                 
                // Este método tiene varias opciones, consulta la documentación para más información.
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, 29, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM );
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
				
                $funcion = $this->uri->segment(3);
               	$this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                                                                  
                $this->load->model('apps_model');
                $menus = $this->apps_model->viewMenu();
                $apps = $this->apps_model->verApps();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br></center><br>
                <table style="padding:0px; width:100%; margin-bottom:150%;">
                <tbody>
                <tr>
                	<td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="3%" style="border-bottom: solid 3px black;"></td>
                    <td width="35%" style=" border-bottom: solid 3px black; font-size:12px; text-align:left;  font-weight: bold;" >Descripción</td>
                    <td width="30%" style="font-size:12px; border-bottom: solid 3px black;  text-align:left;  font-weight: bold;" >Nombre de la Aplicación</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Opciones</td>
                    <td width="15%" style="font-size:12px; border-bottom: solid 3px black;  text-align:center;  font-weight: bold;" >Orden de Menú</td>
                </tr>
                </tbody>
                </table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->AddPage();
                
                $titulo='';
                $titulo .= '<table style=" width:100%;">';
                $titulo .= '<tbody>';
                
                foreach($menus as $key){
                    $titulo .= '<tr>
                                    <td colspan="6" style="font-size:14px; color: #031634; border-bottom: solid 3px #031634; font-weight: bold; text-align:left;">'.trim($key->descripcion).'</td>
                                </tr>';
                    foreach($apps as $key2){   
                        if(trim($key2->menuname) == trim($key->descripcion)){
                			
                            if($key2->menutype == 1){
								$titulo .= '<tr>
												<td width="3%"></td>
												<td colspan="5" style="font-size:12px; color: black; font-weight: bold; text-align:left;">'.trim($key2->descrip).'</td>
											</tr>';
                            
                           
                          
                                
                             foreach($apps as $key3){
                                    if($key2->idapp == $key3->idapphd){
                                        
                 $titulo .= '<tr>
                
                                    <td width="3%" ></td>
                                    <td width="3%" ></td>
                                    <td width="35%" style=" font-size:12px; text-align:left; " >'.trim($key3->descrip).'</td>
                                    <td width="30%" style="font-size:12px;   text-align:left; " >'.$key3->appname.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center;" >'.$key3->appoptions.'</td>
                                    <td width="15%" style="font-size:12px;   text-align:center; " >'.$key3->menuorder.'</td>
                                    </tr>
                                    ';
                                        
                                        
                                        if($key3->notas == ""){
                                    
                                    
                                        }else{
                                
                                           $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2" style=" font-size:11px; text-align:left; " >'.$key3->notas.'</td>
                                                            <td colspan="2"></td>
                                                        </tr>';
                                        }
                                        
                                        
                                        
                                        
                                        
                                        
                                    }
                             }  
                               
                                
                    
                          }else{
                                $titulo .= '<tr>
                                            <td width="3%" ></td>
                                            <td width="3%" ></td>
                                            <td width="35%" style="  font-size:12px; text-align:left; " >'.$key2->descrip.'</td>
                                            <td width="30%" style="font-size:12px;  text-align:left; " >'.$key2->appname.'</td>
                                            <td width="15%" style="font-size:12px;  text-align:center; " >'.$key2->appoptions.'</td>
                                            <td width="15%" style="font-size:12px;   text-align:center; " >'.$key2->menuorder.'</td>
                                    </tr> ';
                                
                                if($key2->notas == ""){
                                    
                                    
                                }else{
                                        $titulo .= '<tr>
                                                            <td width="1.8%"></td>
                                                            <td width="7%"></td>
                                                            <td colspan="2"style=" font-size:11px; text-align:left; " >'.$key2->notas.'</td>
                                                            <td colspan="2"></td>
                                                    </tr>';
                                }
                                
                                
                                
                                
                               
                                
                            }
                        }
                    }
                    
                    $titulo .= '<tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                    </tr> ';
                     
                 }
                   
                $titulo .= '</tbody></table><br><br>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Listado_Aplicaciones.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = "";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch ($numero){
				case 9:{
					$num_letra = "nueve centavos";
					break;
				}
				case 8:{
					$num_letra = "ocho centavos";
					break;
				}
				case 7:{
					$num_letra = "siete centavos";
					break;
				}
				case 6:{
					$num_letra = "seis centavos";
					break;
				}
				case 5:{
					$num_letra = "cinco centavos";
					break;
				}
				case 4:{
					$num_letra = "cuatro centavos";
					break;
				}
				case 3:{
					$num_letra = "tres centavos";
					break;
				}
				case 2:{
					$num_letra = "dos centavos";
					break;
				}
				case 1:{
					$num_letra = "un centavo";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			
			if ($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if ($numero == 90)
						return "noventa centavos";
					else if ($numero == 91)
						return "noventa y un centavos";
					else
						return "noventa y ".$this->unidad_centimos($numero - 90);
				}
				if ($numero >= 80 && $numero <= 89){
					if ($numero == 80)
						return "ochenta centavos";
					else if ($numero == 81)
						return "ochenta y un centavos";
					else
						return "ochenta y ".$this->unidad_centimos($numero - 80);
				}
				if ($numero >= 70 && $numero <= 79){
					if ($numero == 70)
						return "setenta centavos";
					else if ($numero == 71)
						return "setenta y un centavos";
					else
						return "setenta y ".$this->unidad_centimos($numero - 70);
				}
				if ($numero >= 60 && $numero <= 69){
					if ($numero == 60)
						return "sesenta centavos";
					else if ($numero == 61)
						return "sesenta y un centavos";
					else
						return "sesenta y ".$this->unidad_centimos($numero - 60);
				}
				if ($numero >= 50 && $numero <= 59){
					if ($numero == 50)
						return "cincuenta centavos";
					else if ($numero == 51)
						return "cincuenta y un centavos";
					else
						return "cincuenta y ".$this->unidad_centimos($numero - 50);
				}
				if ($numero >= 40 && $numero <= 49)
				{
					if ($numero == 40)
						return "cuarenta centavos";
					else if ($numero == 41)
						return "cuarenta y un centavos";
					else
						return "cuarenta y ".$this->unidad_centimos($numero - 40);
				}
				if ($numero >= 30 && $numero <= 39)
				{
					if ($numero == 30)
						return "treinta centavos";
					else if ($numero == 91)
						return "treinta y un centavos";
					else
						return "treinta y ".$this->unidad_centimos($numero - 30);
				}
				if ($numero >= 20 && $numero <= 29)
				{
					if ($numero == 20)
						return "veinte centavos";
					else if ($numero == 21)
						return "veintiun centavos";
					else
						return "veinti".$this->unidad_centimos($numero - 20);
				}
				if ($numero >= 10 && $numero <= 19)
				{
					if ($numero == 10)
						return "diez centavos";
					else if ($numero == 11)
						return "once centavos";
					else if ($numero == 12)
						return "doce centavos";
					else if ($numero == 13)
						return "trece centavos";
					else if ($numero == 14)
						return "catorce centavos";
					else if ($numero == 15)
						return "quince centavos";
					else if ($numero == 16)
						return "dieciseis centavos";
					else if ($numero == 17)
						return "diecisiete centavos";
					else if ($numero == 18)
						return "dieciocho centavos";
					else if ($numero == 19)
						return "diecinueve centavos";
				}
			}
			else
				return $this->unidad_centimos($numero);
		}

		function unidad($numero){
			$numero = trim($numero);
			
			switch ($numero)
			{
				case 9:
				{
					$num = "nueve";
					break;
				}
				case 8:
				{
					$num = "ocho";
					break;
				}
				case 7:
				{
					$num = "siete";
					break;
				}
				case 6:
				{
					$num = "seis";
					break;
				}
				case 5:
				{
					$num = "cinco";
					break;
				}
				case 4:
				{
					$num = "cuatro";
					break;
				}
				case 3:
				{
					$num = "tres";
					break;
				}
				case 2:
				{
					$num = "dos";
					break;
				}
				case 1:
				{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);
			
			if ($numero >= 90 && $numero <= 99)
			{
				$num_letra = "noventa ";

				if ($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}
			else if ($numero >= 80 && $numero <= 89)
			{
				$num_letra = "ochenta ";

				if ($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}
			else if ($numero >= 70 && $numero <= 79)
			{
					$num_letra = "setenta ";

				if ($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}
			else if ($numero >= 60 && $numero <= 69)
			{
				$num_letra = "sesenta ";

				if ($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}
			else if ($numero >= 50 && $numero <= 59)
			{
				$num_letra = "cincuenta ";

				if ($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}
			else if ($numero >= 40 && $numero <= 49)
			{
				$num_letra = "cuarenta ";

				if ($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}
			else if ($numero >= 30 && $numero <= 39)
			{
				$num_letra = "treinta ";

				if ($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}
			else if ($numero >= 20 && $numero <= 29)
			{
				if ($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}
			else if ($numero >= 10 && $numero <= 19)
			{
				switch ($numero)
				{
					case 10:
					{
						$num_letra = "diez ";
						break;
					}
					case 11:
					{
						$num_letra = "once ";
						break;
					}
					case 12:
					{
						$num_letra = "doce ";
						break;
					}
					case 13:
					{
						$num_letra = "trece ";
						break;
					}
					case 14:
					{
						$num_letra = "catorce ";
						break;
					}
					case 15:
					{
						$num_letra = "quince ";
						break;
					}
					case 16:
					{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:
					{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:
					{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:
					{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}
			else
				$num_letra = $this->unidad($numero);

			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			
			if ($numero >= 100)
			{
				if ($numero >= 900 & $numero <= 999)
				{
					$num_letra = "novecientos ";

					if ($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}
				else if ($numero >= 800 && $numero <= 899)
				{
					$num_letra = "ochocientos ";

					if ($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}
				else if ($numero >= 700 && $numero <= 799)
				{
					$num_letra = "setecientos ";

					if ($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}
				else if ($numero >= 600 && $numero <= 699)
				{
					$num_letra = "seiscientos ";

					if ($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}
				else if ($numero >= 500 && $numero <= 599)
				{
					$num_letra = "quinientos ";

					if ($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}
				else if ($numero >= 400 && $numero <= 499)
				{
					$num_letra = "cuatrocientos ";

					if ($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}
				else if ($numero >= 300 && $numero <= 399)
				{
					$num_letra = "trescientos ";

					if ($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}
				else if ($numero >= 200 && $numero <= 299)
				{
					$num_letra = "doscientos ";

					if ($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}
				else if ($numero >= 100 && $numero <= 199)
				{
					if ($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}
			else
				$num_letra = $this->decena($numero);

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if ($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if ($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			$num_letra = $this->centena($parcial).$this->centimos();

			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if ($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if ($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;

			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial > 0)
			{
				if ($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}

		function millon(){
			global $importe_parcial;

			$parcial = 0; $car = 0;

			while (substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);

			if ($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if ($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if ($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);

			if ($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";

			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			$numero = trim($numero);
			global $importe_parcial;
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}
		
		function comprobanteRetencion($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante de Retención');
            $pdf->SetSubject('Comprobante de Retención');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
            $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
            $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
            // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetMargins(3, 5, 8);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            // se pueden modificar en el archivo tcpdf_config.php de libraries/config
            $pdf->SetAutoPageBreak(TRUE, 5);
            //relación utilizada para ajustar la conversión de los píxeles
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            //---------------------------------------------------------
            //establecer el modo de fuente por defecto
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Portrait');
            $pdf->setPageOrientation('P');
        
            // Establecer el tipo de letra
            //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
            // Helvetica para reducir el tamaño del archivo.
            $pdf->SetFont('Helvetica', '', 7, '', true);
 			
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			foreach($datos as $info){
				//$totalVenta = $info->valcosto + $info->valtax1+$info->valtax5;
				$totalVenta = $info->valcosto;
				
				$numero = number_format(abs($info->valtax5), 2, '.', ',');
				$TotalLetras = $this->convertir_a_letras($numero);
				
				$estructura = '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
				</table>';
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
				</table>';
				
				$estructura .= '
				<table style="width:100%;">
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:33%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:67%;">'.date_format(date_create($info->fecact), 'd/m/Y').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:51%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:10px; width:49%;">'.$info->descrip.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:34%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->direccion.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:36%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:14%;">'.trim($info->departamento).'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;">'.$info->nit.'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:8%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:20%;">'.$info->nrc.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:32%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:68%;">'.$info->giro.'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:27%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:10%;">'.date_format(date_create($info->fecvence), 'd/m/Y').'</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;">Retención 1% en CCF#: '.$info->serie.''.$info->numero.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:14px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:8px; width:100%;"></td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:50%;" rowspan="2">'.strtoupper($TotalLetras).'/DOLARES</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format($totalVenta, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:30%;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:7%;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:11%;">$'.number_format(abs($info->valtax5), 2, '.', ',').'</td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante de Retención.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}
		
        function comprobanteQuedan($trannum){
			$this->load->library('Pdf');
            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
			
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Comprobante Quedan');
            $pdf->SetSubject('Comprobante Quedan');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
        	$pdf->SetMargins(5, 5, 5);
            $pdf->SetAutoPageBreak(TRUE, 5);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('P');
        	$pdf->SetFont('Helvetica', '', 7, '', true);
 			$pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->addPage( 'P', 'LETTER');
			
			$this->load->model('compras_model');
			$this->load->model('pedclientes_model');
			$this->load->model('variable_model');
			
			$nameImagen = $this->pedclientes_model->getnameImg();
			$datos = $this->compras_model->getInformacionRecepcionCompra($trannum);
			
			$infoProductos = $this->compras_model->getProductosTotalizadores($trannum);
			$provee_tipo = $this->compras_model->getTipoProveedorCompra($trannum);
            if($provee_tipo == null){
                $provee_tipo=0;
            }
			$empper = $this->compras_model->getEmpDatoFiltro('g_empdatos', 10);  
			$direccion_emp = $this->variable_model->getInfoVar('g_empdatos', 6);  
			$municipio_dep_emp = $this->variable_model->getInfoVar('g_empdatos', 4);  
			$telefono_emp = $this->variable_model->getInfoVar('g_empdatos', 9);  
			$correo_emp = $this->variable_model->getInfoVar('g_empdatos', 11);  
			
			$percepcion = 0;
			$totExento = 0; $totGravado = 0; $totsinIva = 0;
			$totSumas = 0; $iva = 0;
			foreach($infoProductos as $infoProd){
				if(number_format($infoProd->tax1) == 0){
					$totExento = $totExento + ($infoProd->cantidad * $infoProd->preciotran);
                    $totExento = round($totExento,2);
                    
				}
                
				if(number_format($infoProd->tax1) != 0){
					$totGravado = $totGravado + (($infoProd->cantidad) * ($infoProd->preciotran  * (1 + ($infoProd->tax1 / 100))));
                    $totGravado = $totGravado;
					$totsinIva = $totsinIva + ($infoProd->cantidad * $infoProd->preciotran);
                    $totsinIva = $totsinIva;
				}
			}
			
			$totIva = $totGravado - $totsinIva;
			$totSumas = $totsinIva + $totExento;
			$totSumas = $totSumas;
			$percepcion = 0; $permitePercepcion = 0;
			
			if($provee_tipo != 3 && $empper == 1){
				$permiteRetencion = 1;
				if($totsinIva > 100){
					$percepcion = $totsinIva * 0.01;
					$percepcion = number_format(round($percepcion,2), 2 , '.', ',');
				}
			}
			
			$totalFinal = $totSumas + $totIva - $percepcion;
			$estructura="";
            $forma_pago=0;
			foreach($datos as $info){
                
                $forma_pago= $info->numx;
                
                $fecha_pago_ref= $info->referencia;
                
                if($fecha_pago_ref!=""){
                    $fecha_pago_ref = date_format(date_create($info->referencia), 'd/m/Y');
                }else{
                    $fecha_pago_ref = "N/A";
                }
                
                if($forma_pago==11 || $forma_pago==15){
                    $tipo_comprobante = "COMPROBANTE DE PAGO";
                }else{
                    $tipo_comprobante = "QUEDAN";
                }
                
                if($info->fecact!="0000-00-00"){
                    $dia = date_format(date_create($info->fecact),'d');
                    $mes = date_format(date_create($info->fecact),'m');
                    $anio = date_format(date_create($info->fecact),'Y');
                    switch($mes){
                    case 1:
                        $mes_name = "Enero";
                        break;
                    case 2:
                        $mes_name = "Febrero";
                        break;
                    case 3:
                        $mes_name = "Marzo";
                        break;
                    case 4:
                        $mes_name = "Abril";
                        break;
                    case 5:
                        $mes_name = "Mayo";
                        break;
                    case 6:
                        $mes_name = "Junio";
                        break;
                    case 7:
                        $mes_name = "Julio";
                        break;
                    case 8:
                        $mes_name = "Agosto";
                        break;
                    case 9:
                        $mes_name = "Septiembre";
                        break;
                    case 10:
                        $mes_name = "Octubre";
                        break;
                    case 11:
                        $mes_name = "Noviembre";
                        break;
                    case 12:
                        $mes_name = "Diciembre";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                    $fecha_quedan = strtoupper($mes_name) . " " . $dia . ", " . $anio;
                }else{
                    $fecha_quedan = "SIN CERRAR";
                }
                
                $estructura .= '<br><br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";

                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                if($info->fecvence!="0000-00-00"){
                    $fecha_quedan_mostrar = date_format(date_create($info->fecvence), 'd/m/Y');
                }else{
                    $fecha_quedan_mostrar = "-";
                }
                $cadena_texto = "";
                if($forma_pago==11 || $forma_pago==15){
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong>.<br>';
                }else{
                    $cadena_texto = 'CCF N° <strong>'.$info->serie.''.$info->numero.'</strong> con fecha de emisión del <strong>'.$fecha_quedan_mostrar.'</strong> para su<br>revisión y posterior pago el día <strong>'.$fecha_pago_ref.'</strong>.';
                }
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F;color:white; width:60%; font-weight: bold; border: 1px solid #3E4147;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F;color:white; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #3E4147;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #3E4147;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #3E4147;border-bottom: 1px solid #3E4147;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #3E4147;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #3E4147;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">$'.number_format($totalFinal, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F; color:white; width:80%; font-weight: bold; border: 1px solid #3E4147;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F; color:white; width:20%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #3E4147;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #3E4147;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>';
				
				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #3E4147; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totalFinal, 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #3E4147;border-bottom:1px solid #3E4147;border-left:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #3E4147;border-bottom:1px solid #3E4147;border-left:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F;color:white; width:60%; font-weight: bold; border: 1px solid #3E4147;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F;color:white; width:38%; font-weight: bold; border: 1px solid #3E4147;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #3E4147;height:50px;" rowspan="4">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #3E4147;height:50px;" rowspan="4"><br><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"><br><br></td>
					</tr>
				</table>';
                
                $estructura .= '<table style="width:100%;">
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="width:100%; border-bottom:0.5px dashed #3E4147;font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                <tr><td style="font-size:12px;"></td></tr>
                </table>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
							
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; "><strong>'.trim($this->session->userdata('descrip')).'</strong></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion_emp.', '.$municipio_dep_emp.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; ">Teléfono:'.$telefono_emp.'<br>Correo: '.$correo_emp.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">';
                
                if($forma_pago==11 || $forma_pago==15){
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:5%;"></td>
									<td style="font-size:15px; text-align:right;width:95%;">COMPROBANTE DE PAGO</td>
								</tr>';
                    $frase_quedan = "";
                }else{
                    $estructura .= '<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:25%;"></td>
									<td style="font-size:25px; text-align:center;width:75%;">QUEDAN</td>
								</tr>';
                    $frase_quedan = "Quedan en nuestro poder:";
                }
                $estructura .= '
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$trannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
								<tr style="margin-top:-20px;padding:0px;">
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:20%;"></td>
									<td style="margin-top:-20px;padding:0px;font-size:12px; text-align:center;width:80%;">'.$trannum.'</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>';
                
				$estructura .= '
				<table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F;color:white; width:60%; font-weight: bold; border: 1px solid #3E4147;">Datos del Proveedor</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F;color:white; width:40%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #3E4147;" rowspan="2"><strong>'.$info->descrip.'</strong></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Proveedor:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$info->idauxi.'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Fecha:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$fecha_quedan.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:60%; border-left: 1px solid #3E4147;" rowspan="2">'.$info->direccion.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Orden N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.number_format($info->tranref, 0, '', '').'</td>
					</tr>
					<tr>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Recepción N°:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">'.$info->trannum.'</td>
					</tr>
					<tr>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:15%; border-left: 1px solid #3E4147;border-bottom: 1px solid #3E4147;"><strong>Tel: </strong> '.$info->telefono.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:25%; border-bottom: 1px solid #3E4147;"><strong>NIT: </strong> '.$info->nit.'</td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:10px; width:20%; border-bottom: 1px solid #3E4147;"><strong>NRC: </strong> '.$info->nrc.'</td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:15%; border: 1px solid #3E4147;"><strong>Monto:</strong></td>
						<td style="text-align: left; vertical-align:middle; font-weight:normal; font-size:12px; width:25%; border: 1px solid #3E4147;">$'.number_format($totalFinal, 2, '.', ',').'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F;color:white;  width:80%; font-weight: bold; border: 1px solid #3E4147;">Concepto</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F;color:white;  width:20%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Valor</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:78%; border-right:1px solid #3E4147;">'.$frase_quedan.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:75%; border-right:1px solid #3E4147;">'.$cadena_texto.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:80%; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:3px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Gravadas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totsinIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Compras Exentas</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totExento, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">IVA 13%</td>
						<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totIva, 2, '.', ',').'</strong></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>';
				
				if($percepcion != 0){
					$estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;">Retencion 1%</td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"><strong>-$'.number_format($percepcion, 2, '.', ',').'</strong></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
						</tr>';
				}else{
                    $estructura .= '
						<tr>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:70%;"></td>
							<td style="text-align:left; vertical-align:middle; font-weight:normal; font-size:12px; width:5%; border-right:1px solid #3E4147;"></td>
							<td style="text-align:right; vertical-align:middle; font-weight:normal; font-size:12px; width:18%;"></td>
							<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
						</tr>';
                }
				
				$estructura .= '
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:80%; border-bottom:1px solid #3E4147; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 5px; width:20%; border-bottom:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:80%; border-left:1px solid #3E4147; border-right:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size: 3px; width:20%; border-right:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:5%; border-left:1px solid #3E4147;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:70%;"><strong>Total a Pagar</strong></td>
						<td style="text-align:left; font-weight:normal; font-size:12px; width:5%;border-right:1px solid #3E4147;"></td>
						<td style="text-align:right; font-weight:normal; font-size:12px; width:18%;"><strong>$'.number_format($totalFinal, 2, '.', ',').'</strong></td>
						<td style="text-align:center; font-weight:normal; font-size:12px; width:2%; border-right:1px solid #3E4147;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:80%;border-right:1px solid #3E4147;border-bottom:1px solid #3E4147;border-left:1px solid #3E4147;"></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:20%;border-right:1px solid #3E4147;border-bottom:1px solid #3E4147;border-left:1px solid #3E4147;"></td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:5px; width:100%;"></td>
					</tr>
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F;color:white;  width:60%; font-weight: bold; border: 1px solid #3E4147;">Observaciones</td>
						<td style="font-size:12px; text-align:center; width:2%; font-weight: bold;"></td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F;color:white;  width:38%; font-weight: bold; border: 1px solid #3E4147;">Elaborado por</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:60%; border:1px solid #3E4147;height:50px;" rowspan="3">'.$info->notas.'</td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:12px; width:2%; "></td>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:9px; width:38%; border:1px solid #3E4147;height:50px;" rowspan="3"><br><br><br><br>'.strtoupper($info->elaborado).'</td>
					</tr>
					<tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
                    <tr>
						<td style="text-align:center; vertical-align:middle; font-weight:normal; font-size:1px; width:2%;"></td>
					</tr>
				</table>';
			}
			
			$pdf->writeHTML($estructura, true, 0, false, false, 0);
			$nombreArchivo = utf8_decode("Comprobante Quedan.pdf");
            $pdf->Output($nombreArchivo, 'I');
		}
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('TRASLADOS A SUCURSALES');
                $pdf->SetSubject('TRASLADOS A SUCURSALES');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 60, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                            
                    }
                }
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                
				$header = '<br><br>
				<table style="width:100%;">
					<tr>
						<td style="padding:0px;margin:0px;width:33.3%;" rowspan="2">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</td>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<td style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</td>
								</tr>
							</table>
						</td>
						<td style="padding:0px;margin:0px;width:33.3%;"><img style="text-align:center; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td style="padding:0px;margin:0px;width:33.3%;">
							<table style="padding:0px;margin:0px;">
								<tr>
									<td style="font-size:15px;"></td>
								</tr>
								<tr style="margin:0px;padding:0px;">
									<td style="font-size:10px; text-align:center;width:20%;"></td>
									<td style="font-size:15px; text-align:center;width:80%;">'.strtoupper($nombreFormato).'</td>
								</tr>
								<tr style="margin:0px;padding:-5px;">
									<td style="margin:0px;padding:0px;font-size:15px;width:40%;"></td>
									<td style="margin:0px;padding:0px;font-size:15px;width:60%;"><center><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></center></td>
								</tr>
							</table>
						</td>
                    </tr>
				</table>';
                    
                $header .= '
                <table style="width:100%;">
                    <tr>
						<td style="font-size:12px; text-align:left; background-color:#CC333F; color:white; width:37.5%; font-weight: bold; border: 1px solid #3E4147;" > Origen</td>
						<td style="font-size:12px; text-align:left; background-color:#CC333F; color:white; width:37.5%; font-weight: bold; border: 1px solid #3E4147;" > Destino</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F; color:white; width:25%; font-weight: bold; border: 1px solid #3E4147;" colspan="2"> Datos de Orden</td>
					</tr>
				</table>';
                $header .= '
				<table style="width:100%;">
					<tr>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #3E4147;border-top: 1px solid #3E4147;" rowspan="2">'.$data->centrocd.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #3E4147;border-top: 1px solid #3E4147;" rowspan="2">'.$data->idcentrod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #3E4147; background-color:#CC333F;color:white;font-weight:bold;"> N°  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #3E4147;"> '.$data->trannum.'</td>
					</tr>
                    <tr>
						<td style="font-size:11px; text-align:right;width:10%;border: 1px solid #3E4147; background-color:#CC333F;color:white;font-weight:bold;"> Fecha  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #3E4147;"> '.$date_emision.'</td>
					</tr>
                    <tr>
                        <td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #3E4147;border-bottom: 1px solid #3E4147;"> '.$data->encargadoinv.'</td>
						<td style="font-size:11px; text-align:left;width:37.5%;border-left: 1px solid #3E4147;border-bottom: 1px solid #3E4147;"> '.$data->encargadod.' </td>
                        <td style="font-size:11px; text-align:right;width:10%;border: 1px solid #3E4147; background-color:#CC333F;color:white;font-weight:bold;"> Estado  </td>
                        <td style="font-size:11px; text-align:left;width:15%;border: 1px solid #3E4147;"> '.$estado.'</td>
					</tr>
                    </table>';
                }
                
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $titulo='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#E8E8E8;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147; border-top: 1px solid #3E4147;  border-right: 1px solid #3E4147;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#CC333F;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147;  width:5%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Línea</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Código</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:left; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Modelo</th>
                                        <th style="background-color:#CC333F; width:35%; text-align:left; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Descripción</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">UM</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Lote</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;">Cantidad</th>
                                        <th style="background-color:#CC333F; width:9%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;"></th>
                                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147; width:1%; text-align:center; vertical-align:middle; font-weight: bold;color:white;font-size:10px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#CC333F;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147; border-bottom: 1px solid #3E4147;  border-right: 1px solid #3E4147;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $titulo.='<tr style="border:  1px solid #3E4147; ">
                                <td style="width:5%; border-left: 1px solid #3E4147;  text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:9%; text-align:center; font-size:10px;  border-bottom:solid 1px black;"></td>
                                <td style="width:1%;border-right: 1px solid #3E4147;  text-align:center; font-size:10px;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                    }
                    $titulo.='
                    <tr><td style="font-size:5px; width:100%;border-left:1px solid #3E4147;border-right:1px solid #3E4147;"></td></tr>
                    
                    <tr style="border:1px solid #3E4147; font-size:12px;">
                        <td style="width:5%;border-top:1px solid #3E4147;border-bottom:1px solid #3E4147;border-left:1px solid #3E4147;text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="3" style="width:75%;border-top:1px solid #3E4147;border-bottom:1px solid #3E4147;text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%;border-top:1px solid #3E4147;border-bottom:1px solid #3E4147;text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(number_format(round($totalcant, 2),2)).'</strong></td>
                        <td style="width:10%;border-top:1px solid #3E4147;border-bottom:1px solid #3E4147;border-right:1px solid #3E4147;text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr>
                    </tbody>
                    </table>';
                     $titulo .= '
                      <table>
                    <tr>
				        <td style="width:100%;"><br><br></td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:center; background-color:#CC333F; width:33.3%;bold; border: 1px solid #3E4147;color:white;">Entregado por</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F; width:33.3%;bold; border: 1px solid #3E4147;color:white;">Recibido por</td>
						<td style="font-size:12px; text-align:center; background-color:#CC333F; width:33.3%;bold; border: 1px solid #3E4147;color:white;">Fecha y hora</td>
					</tr>
					<tr>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #3E4147;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #3E4147;"><br><br><br></td>
						<td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid #3E4147;"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                 $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Traslados_Sucursal_".$idtrannum.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function lista_ordenes2($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Listado de Ordenes de compra Recibidas');
                $pdf->SetSubject('Listado de Ordenes de compra Recibidas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $idcentro = $this->session->userdata('idcentrouser');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $nombreSucursal = $this->sucursal_model->getNameCentro($idcentro);
               
                
                    
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:18px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">'.$nombreSucursal.'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br><label style="text-align:center; font-size:14px;">Periodo del: '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                    
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
              
                $estructura='<table>
                                <thead>
                                    <tr style="vertical-align:middle; background-color:#E8E8E8;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147; border-top: 1px solid #3E4147;  border-right: 1px solid #3E4147;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#CC333F;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Estado</th>
                                        <th style="background-color:#CC333F; width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Recepción N°</th>
                                        <th style="background-color:#CC333F; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Orden <br> N°</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Fecha de Recepción</th>
                                        <th style="background-color:#CC333F; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° <br> Documento</th>
                                        <th style="background-color:#CC333F; width:0.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                        <th style="background-color:#CC333F; width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Proveedor</th>
                                        <th style="background-color:#CC333F; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">L/U</th>
                                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
                                    </tr>
                                    <tr style="vertical-align:middle; background-color:#CC333F;">
                                        <th style="background-color:#CC333F;border-left: 1px solid #3E4147; border-bottom: 1px solid #3E4147;  border-right: 1px solid #3E4147;width:100%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                                    </tr>
                                    
                                    
                                </thead>
                    <tbody>';
                
                $listOrdenes = $this->compras_model->getListaRecepcionesIngresadasFechas($idcentro, $fechaini, $fechafin);
                $suma=0;
                
                
                $tot_gravadas=0;
                $tot_exentas=0;
                $tot_iva=0;
                $tot_retencion=0;
                
                foreach($listOrdenes as $info){
                    $valorcosto = $info->valcosto + $info->valtax1 + $info->valtax5;
                    $recibidos = $this->compras_model->getDetalleProductosRecibidos($info->trannum);
                    
                    if(round($info->valtax1,2)==0){
                        $tot_exentas+= $info->valcosto;
                    }else{
                        $tot_gravadas += $info->valcosto;
                        $tot_iva += $info->valtax1;
                    }
                    $tot_retencion+=$info->valtax5;
                    
                    $k=0;
                    $unidades = 0;
                    foreach($recibidos as $rec){
                        $unidades = $unidades + $rec->cantidad;
                        $k++;
                    }
                    $esta = "";
                    if($info->estado_recepcion==1){
                        $esta = "Cerrado";
                    }else{
                        $esta = "En Proceso";
                    }
                    $suma += round($valorcosto,2);
                    $estructura.='<tr style="vertical-align:middle; border: 1px solid #3E4147;">
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$esta.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:7%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->trannum.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:6%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->ordtrannum.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->fecact.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:15%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->serie.$info->numero.'</td>
                        <td style="border-top: 0.5px solid #3E4147; border-bottom: 0.5px solid #3E4147; padding:5px; width:0.5%; text-align:center; vertical-align:middle; font-size:10px;"></td>
                        <td style="border-top: 0.5px solid #3E4147; border-bottom: 0.5px solid #3E4147; padding:5px; width:33.5%; text-align:left; vertical-align:middle; font-size:10px;">'.$info->proveedor.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$k."/".$unidades.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:8%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round($valorcosto,2),2).'</td>
                    </tr>';
                }
                $estructura.='<tr style="vertical-align:middle; border: 1px solid #3E4147;">
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:92%; text-align:right; font-weight:bold; vertical-align:middle; font-size:10px;">TOTAL </td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:8%; text-align:right; font-weight:bold; vertical-align:middle; font-size:10px;">$'.number_format(round($suma,2),2).'</td>
                    </tr>';
                $estructura.='</tbody></table>';
                
                
                 $estructura.='<table><tr><td><br><br><br></td></tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="background-color:#CC333F;width:30%;border: 1px solid #3E4147; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">Resumen</td>
                        </tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="width:20%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">Compras Gravadas </td>
                            <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_gravadas,2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="width:20%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">Compras Exentas </td>
                            <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_exentas,2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="width:20%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">IVA </td>
                            <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_iva,2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="width:20%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">Retención -1% </td>
                            <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_retencion,2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:70%;"></td>
                            <td style="width:20%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">Total Compras </td>
                            <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_gravadas+$tot_exentas+$tot_iva+$tot_retencion,2),2).'</td>
                        </tr>
                 </table>';
                
                
                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                     
                $nombre_archivo = utf8_decode("Listado_Ordenes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function lista_ordenes($fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Listado de Ordenes de compra Recibidas');
                $pdf->SetSubject('Listado de Ordenes de compra Recibidas');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $this->load->model('pedclientes_model');
                $this->load->model('compras_model');
                $name = $this->pedclientes_model->getnameImg();
                $formas_pago = $this->compras_model->formasPago();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $this->load->model('sucursal_model');
                $idcentro = $this->session->userdata('idcentrouser');
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $nombreSucursal = $this->sucursal_model->getNameCentro($idcentro);
                   
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:18px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">'.$nombreSucursal.'</label><br><label style="text-align:center; font-size:15px;">'.$nombreFormato.'</label><br><label style="text-align:center; font-size:14px;">Periodo del: '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y').'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                    
                $estructura ='
                <style>
                    .fondo{
                        background: white url("'.base_url().'"img_cuentas/"'.$this->session->userdata('diraccount').'"/"'.$name.'") no-repeat center center;
                    }
                </style>';
                $cant_formaspago = 0;
                foreach($formas_pago as $fp){
                    $cant_formaspago++;
                }
                $width = 18.5/$cant_formaspago;
                $estructura='<table>
                <thead>
                    <tr style="vertical-align:middle; background-color:#CC333F;">
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        $col_act = 0;
                        foreach($formas_pago as $fp){
                            $col_act++;
                            $estructura.='<th style="background-color:#CC333F;border-top: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        }
                        $estructura.='
                        </tr>
                
                    <tr style="vertical-align:middle; background-color:#CC333F;">
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Estado</th>
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° Recepción</th>
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° <br>Orden</th>
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Fecha de Recepción</th>
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">N° <br> Documento</th>
                        <th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Proveedor</th>';
                $col_act = 0;
                foreach($formas_pago as $fp){
                    $col_act++;
                    $estructura.='<th style="background-color:#CC333F;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.$fp->descrip.'</th>';
                }
                $estructura.='
                </tr>
                 <tr style="vertical-align:middle; background-color:#CC333F;">
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>
                        <th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147;  width:33.5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        $col_act = 0;
                        foreach($formas_pago as $fp){
                            $col_act++;
                            $estructura.='<th style="background-color:#CC333F;border-bottom: 1px solid #3E4147;border-right: 1px solid #3E4147;border-left: 1px solid #3E4147; width:'.$width.'%; text-align:center; vertical-align:middle; font-weight: bold; font-size:5px;"></th>';
                        }
                        $estructura.='
                        </tr>
                </thead>
                <tbody>';
                
                $listOrdenes = $this->compras_model->getListaRecepcionesIngresadasFechas($idcentro, $fechaini, $fechafin);
                $suma=0;
                
                
                $tot_gravadas=0;
                $tot_exentas=0;
                $tot_iva=0;
                $tot_retencion=0;
            
                $array_gravadas = [];
                $array_exentas = [];
                $array_iva = [];
                $array_retencion = [];
                $cont_array=0;
                $array_cant =[];
                foreach($formas_pago as $fp){
                    $array_gravadas[$cont_array] = 0;
                    $array_exentas[$cont_array] = 0;
                    $array_iva[$cont_array] = 0;
                    $array_retencion[$cont_array] = 0;    
                    $array_cant[$cont_array] = 0;
                    $cont_array++;
                }
                     
                    
                
                foreach($listOrdenes as $info){
                    $valorcosto = $info->valcosto + $info->valtax1 + $info->valtax5;
                    $recibidos = $this->compras_model->getDetalleProductosRecibidos($info->trannum);
                    
                    $cont_array=0;
                    foreach($formas_pago as $fp){
                        if($info->cajclase == $fp->cajclase){
                            if(round($info->valtax1,2)==0){
                                $array_exentas[$cont_array]+= $info->valcosto;
                            }else{
                                $array_gravadas[$cont_array] += $info->valcosto;
                                $array_iva[$cont_array] += $info->valtax1;
                            }
                            $array_retencion[$cont_array]+=$info->valtax5;
                            $array_cant[$cont_array]++;
                         }
                        $cont_array++;
                    }
                    
                    if(round($info->valtax1,2)==0){
                        $tot_exentas+= $info->valcosto;
                    }else{
                        $tot_gravadas += $info->valcosto;
                        $tot_iva += $info->valtax1;
                    }
                    $tot_retencion+=$info->valtax5;
                    
                    $k=0;
                    $unidades = 0;
                    foreach($recibidos as $rec){
                        $unidades = $unidades + $rec->cantidad;
                        $k++;
                    }
                    $esta = "";
                    if($info->estado_recepcion==1){
                        $esta = "Cerrado";
                    }else{
                        $esta = "En Proceso";
                    }
                    $suma += round($valorcosto,2);
                    $estructura.='<tr style="vertical-align:middle; border: 1px solid #3E4147;">
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$esta.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:7%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->trannum.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:6%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->ordtrannum.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->fecact.'</td>
                        <td style="border: 0.5px solid #3E4147; padding:5px; width:15%; text-align:center; vertical-align:middle; font-size:10px;">'.$info->serie.$info->numero.'</td>
                        <td style="border-top: 0.5px solid #3E4147; border-bottom: 0.5px solid #3E4147; padding:5px; width:0.5%; text-align:center; vertical-align:middle; font-size:10px;"></td>
                        <td style="border-top: 0.5px solid #3E4147; border-bottom: 0.5px solid #3E4147; padding:5px; width:33%; text-align:left; vertical-align:middle; font-size:10px;">'.$info->proveedor.'</td>';
                    $col_act = 0;
                    foreach($formas_pago as $fp){
                        $col_act++;
                        if($info->cajclase == $fp->cajclase){
                            $estructura.=' <td style="border: 0.5px solid #3E4147;padding:5px; width:'.$width.'%; text-align:right; vertical-align:middle; font-size:10px;">$'.number_format(round($valorcosto,2),2).'&nbsp;</td>';
                        }else{
                            $estructura.=' <td style="border: 0.5px solid #3E4147;padding:5px; width:'.$width.'%; text-align:right; vertical-align:middle; font-size:10px;"></td>';
                        }
                    }
                    
                    $estructura.='</tr>';
                }
                $estructura.='</tbody></table>';
                $estructura.='<table><tr><td><br><br><br></td></tr>
                        <tr>
                            <td style="width:50%;"></td>
                            <td style="background-color:#CC333F;width:20%;border: 1px solid #3E4147; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">Resumen</td>';
                
                $width_totals =20/$cant_formaspago;
                foreach($formas_pago as $fp){
                    $estructura.='<td style="background-color:#CC333F;width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">'.$fp->descrip.'</td>';
                }
                        
                        
                $estructura.='<td style="background-color:#CC333F;width:10%;border: 1px solid #3E4147; text-align:center; vertical-align:middle; font-weight: bold;font-size:12px; ">Totales</td>

                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Compras Gravadas </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_gravadas[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-size:11px; ">$'.number_format(round($array_gravadas[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Compras Exentas </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_exentas[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-size:11px; ">$'.number_format(round($array_exentas[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> IVA </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_iva[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-size:11px; ">$'.number_format(round($array_iva[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.=' 
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Retención -1% </td>';
                $inc_array =0;
                $suma_fila = 0;
                foreach($formas_pago as $fp){
                    $suma_fila += round($array_retencion[$inc_array],2);
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-size:11px; ">$'.number_format(round($array_retencion[$inc_array],2),2).'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($suma_fila,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Total Compras </td>';
                $inc_array =0;
                foreach($formas_pago as $fp){
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format( (round($array_gravadas[$inc_array],2) + round($array_exentas[$inc_array],2) + round($array_iva[$inc_array],2) + round($array_retencion[$inc_array],2))  ,2).'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">$'.number_format(round($tot_gravadas+$tot_exentas+$tot_iva+$tot_retencion,2),2).'</td>
                </tr>
                <tr>
                    <td style="width:50%;"></td>
                    <td style="width:20%;border: 1px solid #3E4147; text-align:left; vertical-align:middle; font-weight: bold;font-size:11px; "> Número de Compras </td>';
                $inc_array =0;
                $sum_compras = 0;
                foreach($formas_pago as $fp){
                    $sum_compras +=$array_cant[$inc_array];
                    $estructura.='<td style="width:'.$width_totals.'%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$array_cant[$inc_array].'</td>';
                    $inc_array++;
                }
                $estructura.='
                <td style="width:10%;border: 1px solid #3E4147; text-align:right; vertical-align:middle; font-weight: bold;font-size:11px; ">'.$sum_compras.'</td>
                </tr>
                </table>';
                
                $pdf->writeHTML($estructura, true, false, true, false, '');
                     
                $nombre_archivo = utf8_decode("Listado_Ordenes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteCompraLocal($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                 
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Compra Local');
                $pdf->SetSubject('Compra Local');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                // Añadir una página
               // $pdf->AddPage();
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                $this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br>
                    <table style="padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                        </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                 $header = '<table style="width:100%; text-align:center;">
                                    <tr><td colspan="3" style="font-size:5px;"><br></td></tr>
                                    <tr>
                                        <td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
                                        <td></td>
                                        <td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
                                    </tr>
                                </table>';
                
                foreach($informacion as $inf){
                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;"></td>
                                        <td style="font-size:12px; text-align:center; background-color:#CC333F;color:white;width:50%; font-weight: bold; border: 1px solid #3E4147;" colspan="2">Detalles</td>
                                    </tr>
                                </table>';

                    $header .= '<table style="width:100%;">
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #3E4147;">&nbsp;No.</td>
                                        <td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #3E4147;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #3E4147;">&nbsp;Referencia: </td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$inf->referencia.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #3E4147;">&nbsp;Número de Documento:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
                                        <td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #3E4147;">&nbsp;Fecha:</td>
                                        <td style="font-size:12px; text-align:right; width:25%; border: 1px solid #3E4147;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr><td style="font-size:10px;"><br></td></tr>
                                </table>';
                }
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='
                <table>
                    <thead>
                        <tr><td style="font-size:10px;"></td></tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#CC333F;">
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:16%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:11%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                            <th style="background-color:#CC333F;color:white;padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                        </tr>
                    </thead>
                <tbody>';
                $sum_lines = 0;
                $sum_cant = 0;
                $sum_subtotal = 0;
                foreach($productos as $pro){
                    $sum_lines++;
                    $sum_cant+= $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
                    $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #3E4147; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
                    <td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
                    <td style="width:16%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
                    <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
                    <td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
                    <td style="width:11%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>
                    <td style="width:10%; border-right: 1px solid #3E4147;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td></tr>';
                }
                
                 
                
                $titulo.='<tr> <td style="border-top: 1px solid #3E4147;" colspan="8"><br></td></tr>';
                
                $titulo.='<tr style="border: 1px solidblack;">
                    <td style="width:5%; border-left: 1px solid #3E4147; border-top: 1px solid #3E4147;border-bottom: 1px solid #3E4147;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
                    <td colspan="4" style="border-top: 1px solid #3E4147;border-bottom: 1px solid #3E4147;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
                    <td style="width:8%; border-top: 1px solid #3E4147;border-bottom: 1px solid #3E4147; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
                    <td style="width:10%; border-top: 1px solid #3E4147;border-bottom: 1px solid #3E4147; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
                    <td style="width:10%; border-right: 1px solid #3E4147;  border-top: 1px solid #3E4147; border-bottom: 1px solid #3E4147; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td></tr>';
               
                $titulo.='</tbody>
                </table>';
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_Compra".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function cuadre_existencias($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Recuento Fisico');
                $pdf->SetSubject('Recuento Fisico');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporteOrdDescrip($trannum);
                
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.' N° '.$trannum.'<br>'.$center_name.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>
                <thead>
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Costo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';
                     
                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;
                
                $sum_invsistema_noinventariado=0;
                $uni_invsistema_noinventariado=0;
                $cantinvsistema_noinventariado=0;
                
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2), 2).'</td></tr>';
                            $cantsinajuste++;
                        }
                    }     
                }   
                if($cantsinajuste>0){
                    $titulo.=$sinajuste;
                }
                
                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad > 0){
                            $sum_ajusteafavor+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteafavor.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteafavor++;
                        }
                    }
                }   
                if($cantajusteafavor>0){
                    $titulo.=$ajusteafavor;
                }
               
                
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                foreach($detalle as $key){
                    if($key->modNotas!=999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra++;
                        }
                    }
                   
                }   
                if($cantajusteencontra>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                
                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
                
                   
                $titulo.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                    
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra2 = 0;
                $sum_ajusteencontra2 = 0;
                $uni_ajusteencontra2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra2++;
                        }
                    }
                   
                }   
                if($cantajusteencontra2>0){
                    $titulo.=$ajusteencontra;
                }
                
                
                    
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                $cantsinajuste2= 0;
                $sum_sinajuste2 = 0;
                $uni_sinajuste2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste2++;
                        }
                    }     
                }   
                if($cantsinajuste2>0){
                    $titulo.=$sinajuste;
                }
                
                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;
                
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;
                
                $titulo.='</tbody>
                </table>
                <table>
                    <tr><td colspan="4"><br><br><br></td></tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:40%;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;width:30%;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:11px;width:10%;">Costo</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Productos</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Sistema</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">$'.number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">'.number_format(round($uni_invsistema, 2),2).'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteafavor,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteafavor.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">$'.number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">'.number_format(round(($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor),2),2).'</td>
                        <td style="text-align:center; font-weight:bold;width:10%;"></td>
                    </tr>
                    <tr><td colspan="5"><br></td></tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste2.'</td>
                    </tr>

                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;width:10%;">$'.number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste.'</td>
                    </tr>
                    </table>
                ';
                
                    
                $pdf->writeHTML($titulo, true, false, true, false, '');
                    
                 
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Recuento_Fisico.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function compras_por_linea($sucursal, $tipo, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $this->load->model("producto_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $tipo_producto = $this->producto_model->getDescripTipo($tipo);
                
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombre_doc);
                $pdf->SetSubject($nombre_doc);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('variable_model');
                $center_name= "";
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$tipo_producto.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>';
                $titulo.='<thead>
                        <tr>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:50%;">Departamento/Línea</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Numero de Compras</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Unidades Compradas</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Costo</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Participación</td>
                        </tr></thead>
                        ';
                $this->load->model('invtran_model');
                
                $total_compras = 0;
                $total_und = 0;
                $total_costo = 0;
                $informacion = $this->invtran_model->getComprasDepto($sucursal, $tipo, $fechaini, $fechafin);
                if($informacion!=false){
                    $sum_total = 0;
                    foreach($informacion as $inf){
                        $sum_total += $inf->costoTotal;
                    }
                    //departamento
                    foreach($informacion as $inf){
                        $sum_uni = 0;
                        if($sum_total>0){
                            $part = $inf->costoTotal / $sum_total;
                        }else{
                            $part = 0;
                        }
                        $subtitulo = "";
                        $informacion_lineas = $this->invtran_model->getComprasLineas($sucursal,$inf->iddepartamento, $tipo, $fechaini, $fechafin);
                        if($informacion_lineas!=false){
                            $sum_total_lineas = 0;
                            foreach($informacion_lineas as $inf_linea){
                                $sum_total_lineas += $inf_linea->costoTotal;
                            }
                            //Catalogo
                            foreach($informacion_lineas as $inf_linea){
                                if($sum_total_lineas>0){
                                    $part_lin = $inf_linea->costoTotal / $sum_total_lineas;
                                }else{
                                    $part_lin = 0;
                                }
                                $subtitulo.='
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:50%;">            '.$inf_linea->linea.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.$inf_linea->cantidadTotal.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.number_format(round($inf_linea->unidadesTotal, 0),0).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">$'.number_format(round($inf_linea->costoTotal, 2),2).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">'.round((($part_lin)* 100),2).'% </td>
                                </tr>
                                ';
                                $sum_uni += round($inf_linea->unidadesTotal, 0);
                            }
                        }
                        
                        $titulo.='
                         <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-bottom: 1px solid #0B486B;">'.$inf->departamento.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.$inf->cantidadTotal.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.number_format(round($sum_uni, 0),0).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">$'.number_format(round($inf->costoTotal, 2),2).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">'.round((($part)* 100),2).'% </td>
                        </tr>
                        ';
                        $total_compras +=$inf->cantidadTotal;
                        $total_und +=round($sum_uni, 0);
                        $total_costo +=round($inf->costoTotal, 2);
                        $titulo.=$subtitulo;
                    }
                }
                $titulo.='
                <tr>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                </tr>
                <tr>
                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-top: 1px solid #0B486B;">TOTALES:</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_compras, 0),0).'</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_und, 0),0).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;">$'.number_format(round($total_costo, 2),2).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;"></td>
                </tr>
                ';
                
                $titulo.='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Compras_Por_Linea.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function compras_por_proveedor($tipo, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $this->load->model("producto_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $tipo_producto = $this->producto_model->getDescripTipo($tipo);
                
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle($nombre_doc);
                $pdf->SetSubject($nombre_doc);
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config_alt.php de libraries/config
                //$pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 128), array(0, 64, 128));
                
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                // datos por defecto de cabecera, se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetMargins(PDF_MARGIN_LEFT, 25, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                //$pdf->SetMargins(PDF_MARGIN_TOP, PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                // se pueden modificar en el archivo tcpdf_config.php de libraries/config
                $pdf->SetAutoPageBreak(TRUE,15);
                //relación utilizada para ajustar la conversión de los píxeles
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                // ---------------------------------------------------------
                // establecer el modo de fuente por defecto
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                //$pdf->setPageOrientation('Portrait');
                //Si tienes que imprimir carácteres ASCII estándar, puede utilizar las fuentes básicas como
                // Helvetica para reducir el tamaño del archivo.
                $pdf->SetFont('Helvetica', '', 7, '', true);
                // Añadir una página
                // Este método tiene varias opciones, consulta la documentación para más información.
                
                
                $this->load->model('invtran_model');
                $this->load->model('variable_model');
                $center_name= "";
                
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:15px;">'.$nombre_doc.'<br>'.$tipo_producto.'</label></center>';

                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage( 'P', 'LETTER' );
                $titulo='<table>';
                $titulo.='<thead>
                        <tr>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Proveedor</td>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:20%;">Transacción</td>
                            <td style="text-align:left; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Número de Documento</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Lineas</td>
                            <td style="text-align:center; vertical-align:middle;color:#413D3D;font-size: 10px; width:10%;">Unidades Compradas</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Costo</td>
                            <td style="text-align:right; vertical-align:middle;color:#413D3D;font-size: 10px; width:15%;">Participación</td>
                        </tr></thead>
                        ';
                $this->load->model('invtran_model');
                
                $total_compras = 0;
                $total_und = 0;
                $total_costo = 0;
                $informacion = $this->invtran_model->getComprasProveedorDistinct($tipo, $fechaini, $fechafin);
                if($informacion!=false){
                    $sum_total = 0;
                    foreach($informacion as $inf){
                        $sum_total += $inf->costoTotal;
                    }
                    //departamento
                    foreach($informacion as $inf){
                        $sum_uni = 0;
                        if($inf->costoTotal>0){
                            $part = $inf->costoTotal / $sum_total;
                        }else{
                            $part = 0;
                        }
                        $subtitulo = "";
                        $informacion_provee = $this->invtran_model->getComprasProvee($inf->idproveedor, $tipo, $fechaini, $fechafin);
                        if($informacion_provee!=false){
                            $sum_total_provee = $inf->costoTotal;
                            foreach($informacion_provee as $inf_provee){
                                if($sum_total_provee>0){
                                    $part_pro = $inf_provee->costoTotal / $sum_total_provee;
                                }else{
                                    $part_pro = 0;
                                }
                                $subtitulo.='
                                <tr>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:15%;">'.$inf_provee->fecha.'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:20%;">'.$inf_provee->transaccion.'</td>
                                    <td style="text-align:left; vertical-align:middle; font-size: 11px; width:15%;">'.$inf_provee->serie.$inf_provee->numero.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.$inf_provee->cantidadTotal.'</td>
                                    <td style="text-align:center; vertical-align:middle; font-size: 11px; width:10%;">'.number_format(round($inf_provee->unidadesTotal, 0),0).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">$'.number_format(round($inf_provee->costoTotal, 2),2).'</td>
                                    <td style="text-align:right; vertical-align:middle; font-size: 11px; width:15%;">'.round((($part_pro)* 100),2).'% </td>
                                </tr>
                                ';
                                $sum_uni += round($inf_provee->unidadesTotal, 0);
                            }
                        }
                        
                        $titulo.='
                         <tr>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-bottom: 1px solid #0B486B;">'.$inf->proveedor.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.$inf->cantidadTotal.'</td>
                            <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-bottom: 1px solid #0B486B;">'.number_format(round($inf->unidadesTotal, 0),0).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">$'.number_format(round($inf->costoTotal, 2),2).'</td>
                            <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-bottom: 1px solid #0B486B;">'.round((($part)* 100),2).'% </td>
                        </tr>
                        ';
                        $total_compras +=$inf->cantidadTotal;
                        $total_und +=round($inf->unidadesTotal, 0);
                        $total_costo +=round($inf->costoTotal, 2);
                        $titulo.=$subtitulo;
                        
                    }
                }
                $titulo.='
                <tr>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:100%;"></td>
                </tr>
                <tr>
                <td style="text-align:left; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:50%;border-top: 1px solid #0B486B;">TOTALES:</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_compras, 0),0).'</td>
                <td style="text-align:center; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:10%;border-top: 1px solid #0B486B;">'.number_format(round($total_und, 0),0).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;">$'.number_format(round($total_costo, 2),2).'</td>
                <td style="text-align:right; vertical-align:middle; font-weight: bold; font-size: 12px; color:#0B486B; width:15%;border-top: 1px solid #0B486B;"></td>
                </tr>
                ';
                
                $titulo.='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                
                //$pdf->writeHTMLCell(0, 0, '', '', $htmlbody, 0, 0, false, "L", true);
                $nombre_archivo = utf8_decode("Compras_Por_Linea.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        
        
    }
?>