<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class Reports extends CI_Controller{
        
        function __construct(){
            parent::__construct();
            
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }
            
            $CI =& get_instance();
            $this->db_b = $CI->load->database('user_db', TRUE);
    
            $this->load->dbutil($this->db_b);
            if(!$this->dbutil->database_exists($this->session->userdata('nameDB'))){
                echo 'Incorrect database information provided';
            }
        
		}

        private function validatePermiso() {
            if ($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')) redirect('CerrarSesion');
            else return true;
        }
        
        function eliminarTildes($cadena){
            $cadena = str_replace(
                array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
                array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
                $cadena
            );
            
            $cadena = str_replace(
                array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
                array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
                $cadena
            );
            
            $cadena = str_replace(
                array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
                array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
                array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
                array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
                $cadena
            );
            
            $cadena = str_replace(
                array('ñ', 'Ñ', 'ç', 'Ç'),
                array('n', 'N', 'c', 'C'),
                $cadena
            );
            
            return $cadena;
        }
		
		function centimos(){
			global $importe_parcial;
			
			$importe_parcial = number_format($importe_parcial, 2, ".", "") * 100;
			if($importe_parcial > 0){
				$num_letra = " con ".$this->decena_centimos($importe_parcial);
			}else{
				$num_letra = " 00";
			}
			return $num_letra;
		}

		function unidad_centimos($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num_letra = "9";
					break;
				}
				case 8:{
					$num_letra = "8";
					break;
				}
				case 7:{
					$num_letra = "7";
					break;
				}
				case 6:{
					$num_letra = "6";
					break;
				}
				case 5:{
					$num_letra = "5";
					break;
				}
				case 4:{
					$num_letra = "4";
					break;
				}
				case 3:{
					$num_letra = "3";
					break;
				}
				case 2:{
					$num_letra = "2";
					break;
				}
				case 1:{
					$num_letra = "1";
					break;
				}
			}
			return $num_letra;
		}

		function decena_centimos($numero){
			$numero = trim($numero);
			if($numero >= 10){
				if($numero >= 90 && $numero <= 99){
					if($numero == 90)
						return "90";
					else if($numero == 91)
						return "91";
					else
						return "9".$this->unidad_centimos($numero - 90);
				}
				if($numero >= 80 && $numero <= 89){
					if($numero == 80)
						return "80";
					else if($numero == 81)
						return "81";
					else
						return "8".$this->unidad_centimos($numero - 80);
				}
				if($numero >= 70 && $numero <= 79){
					if($numero == 70)
						return "70";
					else if($numero == 71)
						return "71";
					else
						return "7".$this->unidad_centimos($numero - 70);
				}
				if($numero >= 60 && $numero <= 69){
					if($numero == 60)
						return "60";
					else if($numero == 61)
						return "61";
					else
						return "6".$this->unidad_centimos($numero - 60);
				}
				if($numero >= 50 && $numero <= 59){
					if($numero == 50)
						return "50";
					else if($numero == 51)
						return "51";
					else
						return "5".$this->unidad_centimos($numero - 50);
				}
				if($numero >= 40 && $numero <= 49){
					if($numero == 40)
						return "40";
					else if($numero == 41)
						return "41";
					else
						return "4".$this->unidad_centimos($numero - 40);
				}
				if($numero >= 30 && $numero <= 39){
					if($numero == 30)
						return "30";
					else if($numero == 91)
						return "31";
					else
						return "3".$this->unidad_centimos($numero - 30);
				}
				if($numero >= 20 && $numero <= 29){
					if($numero == 20)
						return "20";
					else if($numero == 21)
						return "21";
					else
						return "2".$this->unidad_centimos($numero - 20);
				}
				if($numero >= 10 && $numero <= 19){
					if($numero == 10)
						return "10";
					else if($numero == 11)
						return "11";
					else if($numero == 12)
						return "12";
					else if($numero == 13)
						return "13";
					else if($numero == 14)
						return "14";
					else if($numero == 15)
						return "15";
					else if($numero == 16)
						return "16";
					else if($numero == 17)
						return "17";
					else if($numero == 18)
						return "18";
					else if($numero == 19)
						return "19";
				}
			}else{
				return $this->unidad_centimos($numero);
			}
		}

		function unidad($numero){
			$numero = trim($numero);
			switch($numero){
				case 9:{
					$num = "nueve";
					break;
				}
				case 8:{
					$num = "ocho";
					break;
				}
				case 7:{
					$num = "siete";
					break;
				}
				case 6:{
					$num = "seis";
					break;
				}
				case 5:{
					$num = "cinco";
					break;
				}
				case 4:{
					$num = "cuatro";
					break;
				}
				case 3:{
					$num = "tres";
					break;
				}
				case 2:{
					$num = "dos";
					break;
				}
				case 1:{
					$num = "uno";
					break;
				}
			}
			return $num;
		}

		function decena($numero){
			$numero = trim($numero);

			if($numero >= 90 && $numero <= 99){
				$num_letra = "noventa ";
				
				if($numero > 90)
					$num_letra = $num_letra."y ".$this->unidad($numero - 90);
			}else if($numero >= 80 && $numero <= 89){
				$num_letra = "ochenta ";
				
				if($numero > 80)
					$num_letra = $num_letra."y ".$this->unidad($numero - 80);
			}else if($numero >= 70 && $numero <= 79){
					$num_letra = "setenta ";

				if($numero > 70)
					$num_letra = $num_letra."y ".$this->unidad($numero - 70);
			}else if($numero >= 60 && $numero <= 69){
				$num_letra = "sesenta ";

				if($numero > 60)
					$num_letra = $num_letra."y ".$this->unidad($numero - 60);
			}else if($numero >= 50 && $numero <= 59){
				$num_letra = "cincuenta ";

				if($numero > 50)
					$num_letra = $num_letra."y ".$this->unidad($numero - 50);
			}else if($numero >= 40 && $numero <= 49){
				$num_letra = "cuarenta ";

				if($numero > 40)
					$num_letra = $num_letra."y ".$this->unidad($numero - 40);
			}else if($numero >= 30 && $numero <= 39){
				$num_letra = "treinta ";

				if($numero > 30)
					$num_letra = $num_letra."y ".$this->unidad($numero - 30);
			}else if($numero >= 20 && $numero <= 29){
				if($numero == 20)
					$num_letra = "veinte ";
				else
					$num_letra = "veinti".$this->unidad($numero - 20);
			}else if($numero >= 10 && $numero <= 19){
				switch($numero){
					case 10:{
						$num_letra = "diez ";
						break;
					}
					case 11:{
						$num_letra = "once ";
						break;
					}
					case 12:{
						$num_letra = "doce ";
						break;
					}
					case 13:{
						$num_letra = "trece ";
						break;
					}
					case 14:{
						$num_letra = "catorce ";
						break;
					}
					case 15:{
						$num_letra = "quince ";
						break;
					}
					case 16:{
						$num_letra = "dieciseis ";
						break;
					}
					case 17:{
						$num_letra = "diecisiete ";
						break;
					}
					case 18:{
						$num_letra = "dieciocho ";
						break;
					}
					case 19:{
						$num_letra = "diecinueve ";
						break;
					}
				}
			}else{
				$num_letra = $this->unidad($numero);
			}
			
			return $num_letra;
		}

		function centena($numero){
			$numero = trim($numero);
			if($numero >= 100){
				if ($numero >= 900 & $numero <= 999){
					$num_letra = "novecientos ";

					if($numero > 900)
						$num_letra = $num_letra.$this->decena($numero - 900);
				}else if($numero >= 800 && $numero <= 899){
					$num_letra = "ochocientos ";

					if($numero > 800)
						$num_letra = $num_letra.$this->decena($numero - 800);
				}else if($numero >= 700 && $numero <= 799){
					$num_letra = "setecientos ";

					if($numero > 700)
						$num_letra = $num_letra.$this->decena($numero - 700);
				}else if($numero >= 600 && $numero <= 699){
					$num_letra = "seiscientos ";

					if($numero > 600)
						$num_letra = $num_letra.$this->decena($numero - 600);
				}else if($numero >= 500 && $numero <= 599){
					$num_letra = "quinientos ";

					if($numero > 500)
						$num_letra = $num_letra.$this->decena($numero - 500);
				}else if($numero >= 400 && $numero <= 499){
					$num_letra = "cuatrocientos ";

					if($numero > 400)
						$num_letra = $num_letra.$this->decena($numero - 400);
				}else if($numero >= 300 && $numero <= 399){
					$num_letra = "trescientos ";

					if($numero > 300)
						$num_letra = $num_letra.$this->decena($numero - 300);
				}else if($numero >= 200 && $numero <= 299){
					$num_letra = "doscientos ";

					if($numero > 200)
						$num_letra = $num_letra.$this->decena($numero - 200);
				}else if($numero >= 100 && $numero <= 199){
					if($numero == 100)
						$num_letra = "cien ";
					else
						$num_letra = "ciento ".$this->decena($numero - 100);
				}
			}else{
				$num_letra = $this->decena($numero);
			}

			return $num_letra;
		}

		function cien(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1 && $importe_parcial <= 9.99)
				$car = 1;
			else if($importe_parcial >= 10 && $importe_parcial <= 99.99)
				$car = 2;
			else if($importe_parcial >= 100 && $importe_parcial <= 999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			$num_letra = $this->centena($parcial).$this->centimos();
			
			return $num_letra;
		}

		function cien_mil(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000 && $importe_parcial <= 9999.99)
				$car = 1;
			else if($importe_parcial >= 10000 && $importe_parcial <= 99999.99)
				$car = 2;
			else if($importe_parcial >= 100000 && $importe_parcial <= 999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial > 0){
				if($parcial == 1)
					$num_letra = "mil ";
				else
					$num_letra = $this->centena($parcial)." mil ";
			}

			return $num_letra;
		}
		
		function millon(){
			global $importe_parcial;
			
			$parcial = 0; $car = 0;
			
			while(substr($importe_parcial, 0, 1) == 0)
				$importe_parcial = substr($importe_parcial, 1, strlen($importe_parcial) - 1);
			
			if($importe_parcial >= 1000000 && $importe_parcial <= 9999999.99)
				$car = 1;
			else if($importe_parcial >= 10000000 && $importe_parcial <= 99999999.99)
				$car = 2;
			else if($importe_parcial >= 100000000 && $importe_parcial <= 999999999.99)
				$car = 3;
			
			$parcial = substr($importe_parcial, 0, $car);
			$importe_parcial = substr($importe_parcial, $car);
			
			if($parcial == 1)
				$num_letras = "un millón ";
			else
				$num_letras = $this->centena($parcial)." millones ";
			
			return $num_letras;
		}
		
		function convertir_a_letras($numero){
			global $importe_parcial;
			
			$numero = trim($numero);
			
			$importe_parcial = $numero;
			
			if($numero < 1000000000){
				if($numero >= 1000000 && $numero <= 999999999.99)
					$num_letras = $this->millon().$this->cien_mil().$this->cien();
				else if($numero >= 1000 && $numero <= 999999.99)
					$num_letras = $this->cien_mil().$this->cien();
				else if($numero >= 1 && $numero <= 999.99)
					$num_letras = $this->cien();
				else if($numero >= 0.01 && $numero <= 0.99){
					if($numero == 0.01)
						$num_letras = "un céntimo";
					else
						$num_letras = $this->convertir_a_letras(($numero * 100)."/100")." centavos";
				}
			}
			return $num_letras;
		}

        #   VALOR EN LETRAS
			function valorEnLetras($x){ 
				$I7 = " ";
				$I9 = " ";
				if ($x<0) { $signo = "menos ";} 
				else      { $signo = "";} 
				$x = abs ($x); 
				$C1 = $x; 

				$G6 = floor($x/(1000000));  // 7 y mas 

				$E7 = floor($x/(100000)); 
				$G7 = $E7-$G6*10;   // 6 

				$E8 = floor($x/1000); 
				$G8 = $E8-$E7*100;   // 5 y 4 

				$E9 = floor($x/100); 
				$G9 = $E9-$E8*10;  //  3 

				$E10 = floor($x); 
				$G10 = $E10-$E9*100;  // 2 y 1 


				$G11 = round(($x-$E10)*100,0);  // Decimales 
				////////////////////// 

				$H6 = $this->unidades($G6); 

				if($G7==1 AND $G8==0) { $H7 = "Cien "; } 
				else {    $H7 = $this->decenas($G7); } 

				$H8 = $this->unidades($G8); 

				if($G9==1 AND $G10==0) { $H9 = "Cien "; } 
				else {    $H9 = $this->decenas($G9); } 

				$H10 = $this->unidades($G10); 

				if($G11 < 10) { $H11 = "0".$G11; } 
				else { $H11 = $G11; } 

				///////////////////////////// 
					if($G6==0) { $I6=" "; } 
				elseif($G6==1) { $I6="Millón "; } 
						else { $I6="Millones "; } 

				if ($G8==0 AND $G7==0) { $I8=" "; } 
						else { $I8="Mil "; } 

				$I10 = ""; 
				$I11 = "/100 US DOLARES ";

				$C3 = $signo.$H6.$I6.$H7.$I7.$H8.$I8.$H9.$I9.$H10.$I10.$H11.$I11; 

				return $C3; //Retornar el resultado 
			}
			function unidades($u){ 
				if ($u==0)  {$ru = " ";} 
				elseif ($u==1)  {$ru = "Un ";} 
				elseif ($u==2)  {$ru = "Dos ";} 
				elseif ($u==3)  {$ru = "Tres ";} 
				elseif ($u==4)  {$ru = "Cuatro ";} 
				elseif ($u==5)  {$ru = "Cinco ";} 
				elseif ($u==6)  {$ru = "Seis ";} 
				elseif ($u==7)  {$ru = "Siete ";} 
				elseif ($u==8)  {$ru = "Ocho ";} 
				elseif ($u==9)  {$ru = "Nueve ";} 
				elseif ($u==10) {$ru = "Diez ";} 

				elseif ($u==11) {$ru = "Once ";} 
				elseif ($u==12) {$ru = "Doce ";} 
				elseif ($u==13) {$ru = "Trece ";} 
				elseif ($u==14) {$ru = "Catorce ";} 
				elseif ($u==15) {$ru = "Quince ";} 
				elseif ($u==16) {$ru = "Dieciseis ";} 
				elseif ($u==17) {$ru = "Decisiete ";} 
				elseif ($u==18) {$ru = "Dieciocho ";} 
				elseif ($u==19) {$ru = "Diecinueve ";} 
				elseif ($u==20) {$ru = "Veinte ";} 

				elseif ($u==21) {$ru = "Veintiun ";} 
				elseif ($u==22) {$ru = "Veintidos ";} 
				elseif ($u==23) {$ru = "Veintitres ";} 
				elseif ($u==24) {$ru = "Veinticuatro ";} 
				elseif ($u==25) {$ru = "Veinticinco ";} 
				elseif ($u==26) {$ru = "Veintiseis ";} 
				elseif ($u==27) {$ru = "Veintisiente ";} 
				elseif ($u==28) {$ru = "Veintiocho ";} 
				elseif ($u==29) {$ru = "Veintinueve ";} 
				elseif ($u==30) {$ru = "Treinta ";} 

				elseif ($u==31) {$ru = "Treinta y un ";} 
				elseif ($u==32) {$ru = "Treinta y dos ";} 
				elseif ($u==33) {$ru = "Treinta y tres ";} 
				elseif ($u==34) {$ru = "Treinta y cuatro ";} 
				elseif ($u==35) {$ru = "Treinta y cinco ";} 
				elseif ($u==36) {$ru = "Treinta y seis ";} 
				elseif ($u==37) {$ru = "Treinta y siete ";} 
				elseif ($u==38) {$ru = "Treinta y ocho  ";} 
				elseif ($u==39) {$ru = "Treinta y nueve ";} 
				elseif ($u==40) {$ru = "Cuarenta ";} 

				elseif ($u==41) {$ru = "Cuarenta y un ";} 
				elseif ($u==42) {$ru = "Cuarenta y dos ";} 
				elseif ($u==43) {$ru = "Cuarenta y tres ";} 
				elseif ($u==44) {$ru = "Cuarenta y cuatro ";} 
				elseif ($u==45) {$ru = "Cuarenta y cinco ";} 
				elseif ($u==46) {$ru = "Cuarenta y seis ";} 
				elseif ($u==47) {$ru = "Cuarenta y siete ";} 
				elseif ($u==48) {$ru = "Cuarenta y ocho  ";} 
				elseif ($u==49) {$ru = "Cuarenta y nueve ";} 
				elseif ($u==50) {$ru = "Cincuenta ";} 

				elseif ($u==51) {$ru = "Cincuenta y un ";} 
				elseif ($u==52) {$ru = "Cincuenta y dos ";} 
				elseif ($u==53) {$ru = "Cincuenta y tres ";} 
				elseif ($u==54) {$ru = "Cincuenta y cuatro ";} 
				elseif ($u==55) {$ru = "Cincuenta y cinco ";} 
				elseif ($u==56) {$ru = "Cincuenta y seis ";} 
				elseif ($u==57) {$ru = "Cincuenta y siete ";} 
				elseif ($u==58) {$ru = "Cincuenta y ocho  ";} 
				elseif ($u==59) {$ru = "Cincuenta y nueve ";} 
				elseif ($u==60) {$ru = "Sesenta ";} 

				elseif ($u==61) {$ru = "Sesenta y un ";} 
				elseif ($u==62) {$ru = "Sesenta y dos ";} 
				elseif ($u==63) {$ru = "Sesenta y tres ";} 
				elseif ($u==64) {$ru = "Sesenta y cuatro ";} 
				elseif ($u==65) {$ru = "Sesenta y cinco ";} 
				elseif ($u==66) {$ru = "Sesenta y seis ";} 
				elseif ($u==67) {$ru = "Sesenta y siete ";} 
				elseif ($u==68) {$ru = "Sesenta y ocho  ";} 
				elseif ($u==69) {$ru = "Sesenta y nueve ";} 
				elseif ($u==70) {$ru = "Setenta ";} 

				elseif ($u==71) {$ru = "Setenta y un ";} 
				elseif ($u==72) {$ru = "Setenta y dos ";} 
				elseif ($u==73) {$ru = "Setenta y tres ";} 
				elseif ($u==74) {$ru = "Setenta y cuatro ";} 
				elseif ($u==75) {$ru = "Setenta y cinco ";} 
				elseif ($u==76) {$ru = "Setenta y seis ";} 
				elseif ($u==77) {$ru = "Setenta y siete ";} 
				elseif ($u==78) {$ru = "Setenta y ocho  ";} 
				elseif ($u==79) {$ru = "Setenta y nueve ";} 
				elseif ($u==80) {$ru = "Ochenta ";} 

				elseif ($u==81) {$ru = "Ochenta y un ";} 
				elseif ($u==82) {$ru = "Ochenta y dos ";} 
				elseif ($u==83) {$ru = "Ochenta y tres ";} 
				elseif ($u==84) {$ru = "Ochenta y cuatro ";} 
				elseif ($u==85) {$ru = "Ochenta y cinco ";} 
				elseif ($u==86) {$ru = "Ochenta y seis ";} 
				elseif ($u==87) {$ru = "Ochenta y siete ";} 
				elseif ($u==88) {$ru = "Ochenta y ocho  ";} 
				elseif ($u==89) {$ru = "Ochenta y nueve ";} 
				elseif ($u==90) {$ru = "Noventa ";} 

				elseif ($u==91) {$ru = "Noventa y un ";} 
				elseif ($u==92) {$ru = "Noventa y dos ";} 
				elseif ($u==93) {$ru = "Noventa y tres ";} 
				elseif ($u==94) {$ru = "Noventa y cuatro ";} 
				elseif ($u==95) {$ru = "Noventa y cinco ";} 
				elseif ($u==96) {$ru = "Noventa y seis ";} 
				elseif ($u==97) {$ru = "Noventa y siete ";} 
				elseif ($u==98) {$ru = "Noventa y ocho  ";} 
				else            {$ru = "Noventa y nueve ";} 
				return $ru; //Retornar el resultado 
			}
			function decenas($d){ 
				if ($d==0)  {$rd = "";} 
				elseif ($d==1)  {$rd = "Ciento ";} 
				elseif ($d==2)  {$rd = "Doscientos ";} 
				elseif ($d==3)  {$rd = "Trescientos ";} 
				elseif ($d==4)  {$rd = "Cuatrocientos ";} 
				elseif ($d==5)  {$rd = "Quinientos ";} 
				elseif ($d==6)  {$rd = "Seiscientos ";} 
				elseif ($d==7)  {$rd = "Setecientos ";} 
				elseif ($d==8)  {$rd = "Ochocientos ";} 
				else            {$rd = "Novecientos ";} 
				return $rd; //Retornar el resultado 
			}
		#-

        function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
        
        function reporteVentasDiariasUpdate($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				foreach($tipospagos as $tip){
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 20%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 15%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 15%">Forma de Pago</th></tr>
                            </thead>';
                $titulo .='<tbody>';
                $totalGeneral = 0;
                $totalExento = 0;
                $totalGravado = 0;
                $totalIva = 0;
                $totalDocs = 0;
                foreach($documentos as $docs){
                    
					$numdoc = 0;
					$subtotal=0;
					$subtotalexento = 0;
					$subtotalgravado = 0;
					$subtotaliva = 0;
                    $titulo .= '<tr><th colspan="10"><br></th></tr><tr><th colspan="10" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++;
                            $totalDocs++;
                            $exento = 0;
                            $gravado = 0;
                            $iva = 0;
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                $gravado = ($fact->valtax1 / 0.13);
                                $exento = $fact->valventan-$gravado;
                            }
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($fact->namecliente, 0, 28);
                            $nameVendedor = substr($fact->namevendedor, 0, 28);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            
                            if($cadena_pago==0){
                                $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        $cadena_pago .= $money->descrip.",";
                                    }
                                    $cadena_pago = substr($cadena_pago, 0, -1);
                                }
                                $cadena_pago = substr($cadena_pago, 0, 25);
                            }else{
                                $cadena_pago = substr($cadena_pago, 0, 25);
                            }
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:left; font-weight: normal; width: 10%">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 20%">'.$nameCliente.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 15%">'.$nameVendedor.'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">$'.number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">$'.number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">$'.number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">$'.number_format(round($gravado+$iva+$exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 15%">'.$cadena_pago.'</td></tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:46%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">$'.number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">$'.number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">$'.number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">$'.number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:15%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '</tbody></table>';
                $titulo .= '<br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalExento, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalGravado, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalIva, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">$'.number_format(round($totalGeneral, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><table>
                <thead>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:25%;background-color:gray; color:white;">INGRESOS</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        $cant_fp++;
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      

                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                $total_ing_sum=0;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">$'.number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">$'.number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                        $total_ing_sum+=$valpagG[$tip->cajclase];
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">$'.number_format(round($total_ing_sum, 2),2).'</td></tr></tbody></table>';

                
               
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
        function reporteVentasDiariasAnterior($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				
                foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipoDocumentosVentas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				
                $cnt = 0;
				foreach($tipospagos as $tip){
					$valpag_retencion[$tip->cajclase] = 0;
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                
                $pdf->addPage('P', 'LETTER');
				$titulo ='
                <table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 13%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Retención</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 12%">Forma de Pago</th></tr>
                    </thead>
                    <tbody>';
                
                $totalGeneral = 0; $totalExento = 0;
                $totalGravado = 0; $totalRetencion = 0;
                $totalIva = 0; $totalDocs = 0; $total_remesar = 0;
                
                foreach($documentos as $docs){
                    $numdoc = 0; $subtotal=0; $subtotalexento = 0;
					$subtotalgravado = 0; $subtotalretencion = 0; $subtotaliva = 0;
                    
                    $titulo .= '<tr><th colspan="11"><br></th></tr><tr><th colspan="11" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++; $totalDocs++;
                            $exento = 0; $gravado = 0; $iva = 0; $retencion = 0;
                            
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                if($fact->tipoCliente == 3 && abs($fact->valventan) >= 100){
                                    if($fact->valventan >= 100){
										$retencion = ($fact->valventan*0.01)*-1;
									}else{
										$retencion = ($fact->valventan*0.01);
									}
                                    $gravado = $fact->valventan;
                                }else{
                                    $gravado = ($fact->valtax1 / 0.13);
                                    $exento = $fact->valventan-$gravado;
                                }
                            }
                            
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva+$retencion;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotalretencion += $retencion;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($this->eliminarTildes($fact->namecliente), 0, 22);
                            $nameVendedor = substr($this->eliminarTildes($fact->namevendedor), 0, 20);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                            
                            if($pagos!=false){
                                if($cadena_pago!=""){
                                    $cadena_pago.=',';
                                }
                                foreach($pagos as $money){
                                    $cadena_pago .= $money->descrip.",";
                                }
                                $cadena_pago = substr($cadena_pago, 0, -1);
                            }
                            $cadena_pago = substr($cadena_pago, 0, 25);
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
										if($money->formaPag=="Efectivo" ||$money->formaPag=="Cheques"){
											if($fact->inopera==1){
												$total_remesar -= (abs($money->valor) - abs($money->vuelto));
											}else{
												$total_remesar += (abs($money->valor) - abs($money->vuelto));
											}
										}
										
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:left; font-weight: normal; width: 10%">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$nameCliente.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 13%">'.$nameVendedor.'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado+$iva+$exento+$retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 12%">'.$cadena_pago.'</td></tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:42%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalretencion, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:12%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalRetencion += $subtotalretencion;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '
                    </tbody>
                </table>
                <br><br>
                <table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">RESUMEN</th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Retención</th>
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                    </thead>
                    <tbody>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:10%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).'</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).'</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalIva, 2),2).'</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalRetencion, 2),2).'</th>
                            <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGeneral, 2),2).'</th>
                        </tr>
                    </tbody>
                </table>
                <br><br>
                <table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">INGRESOS</th>
                        <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                        <tr style="border-bottom: 1px solid black;">
                        <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo_Retencion('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $cant_fp++;
                        }
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                        }
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      
                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                
                $total_ing_sum=0;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                           $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                                $total_ing_sum+=$valpagG[$tip->cajclase];
                        }
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_ing_sum, 2),2).'</td></tr>
				</tbody></table>
                <br><br>
                <table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                        <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:20%;background-color:gray; color:white;">REMESA</th>
                        <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                    </thead>
				    <tbody>
                        <tr style="border-bottom: 1px solid black;">
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:20%;background-color:#C2CBCE;">Efectivo + Cheques&nbsp;&nbsp;</td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Fecha&nbsp;&nbsp;</td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;background-color:#C2CBCE;">Hora&nbsp;&nbsp;</td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;background-color:#C2CBCE;">Cuenta&nbsp;&nbsp;</td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Valor Remesado&nbsp;&nbsp;</td>
                        </tr>
                        <tr style="border-bottom: 1px solid black;">
                            <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:20%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;"></td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;"></td>
                            <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                        </tr>
                        <tr style="border-bottom: 1px solid black;">
                            <td style="border: 1px solid black;font-size:10px; text-align:left; font-weight: bold; width:100%;">&nbsp;Observaciones:<br><br></td>
                        </tr>
                        <tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
                        <tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
                        <tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
                        <tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
                        <tr style="border-top: 1px solid black;"><td style="border-top: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:30%;">Elaborado por</td></tr>
                    </tbody>
                </table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function reporteVentasDiarias($idcentro, $idcaja, $fechaini, $fechafin){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('login/cerrar_sesion');
            }else{
                ini_set('memory_limit','800M');
				ini_set('max_allowed_packet', '500M'); 
                
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ventas Por Periodo');
                $pdf->SetSubject('Ventas Por Periodo');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->SetMargins(4, 40, 4, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(0, 0, 0, 0);
                $this->load->model('ventas_model');
                $this->load->model('sucursal_model');
                $this->load->model('invtran_model');
                $this->load->model('caja_model');
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');

                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $this->load->model('pedclientes_model');
                $nameImagen = $this->pedclientes_model->getnameImg();

                
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $datoscaja = $this->caja_model->getNameCaja($idcaja);
				foreach($datoscaja as $caja){
					$namecaja = $caja->descrip;
					$numcaja = $caja->resolucion;
				}
               	
				$tipospagos = $this->ventas_model->getTiposDocsFacturasCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$documentos = $this->ventas_model->tipos_doc_ventas_gt('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$facturas = $this->ventas_model->getDatosFacturacionesCerradas('VN', $idcentro, $idcaja, $fechaini, $fechafin);
				$cnt = 0;
				foreach($tipospagos as $tip){
					$valpag_retencion[$tip->cajclase] = 0;
					$valpag[$tip->cajclase] = 0;
					$valpagG[$tip->cajclase] = 0;
					$cnt++;
				}
                $header = '
				<table style="width:100%;">
					<tr>
                        <td style="padding:0px;margin:0px;width:30%;"><img style="text-align:center; width:210px; height:95px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        <td style="padding:0px;margin:0px;width:70%;padding:0px;margin:0px;">
                            <label style="font-size:18px;font-weight:bold;text-align:right; margin:0px;padding:0px;"><br>'.trim($this->session->userdata('descrip')).'</label>
                            <br><label style="text-align:right; font-size:15px;margin:0px;padding:0px;">'.strtoupper($nombreFormato).'<br>'.strtoupper($namecentro).' - '.strtoupper($namecaja).'<br> PERIODO: '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'</label>        
                        </td>
                    </tr>
				</table>';
               
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $fecha = new DateTime();
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage('P', 'LETTER' );
				$titulo ='<table>
                    <thead>
                        <tr style="border-bottom: 1px solid black;">
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 10%">N°</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 6%">Fecha</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 5%">Hora</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 18%">Nombre de Cliente</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:left; font-weight: bold; width: 13%">Nombre de Vendedor</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Exento</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Gravado</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">IVA</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 7%">Retención</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 8%">Total</th>
                            <th style="border-bottom: 1px solid black;font-size:8px; text-align:center; font-weight: bold; width: 12%">Forma de Pago</th></tr>
                            </thead>';
                $titulo .='<tbody>';
                $totalGeneral = 0;
                $totalExento = 0;
                $totalGravado = 0;
                $totalRetencion = 0;
                $totalIva = 0;
                $totalDocs = 0;
				$total_remesar = 0;
                foreach($documentos as $docs){
                    
					$numdoc = 0;
					$subtotal=0;
					$subtotalexento = 0;
					$subtotalgravado = 0;
					$subtotalretencion = 0;
					$subtotaliva = 0;
                    $titulo .= '<tr><th colspan="11"><br></th></tr><tr><th colspan="11" style="font-size:11px; text-align:left; font-weight: bold; margin-top:10px; margin-bottom:10px;">'.strtoupper($docs->tipoDoc).'</th></tr>';
                    foreach($facturas as $fact){
                        if($docs->tipoDoc == $fact->tipodoc){
                            $numdoc++;
                            $totalDocs++;
                            $exento = 0;
                            $gravado = 0;
                            $iva = 0;
                            $retencion = 0;
                            if($fact->exento==1){
                                $exento = $fact->valventan;
                            }else{
                                if($fact->tipoCliente == 3 && abs($fact->valventan) >= 100){
                                    if($fact->valventan >= 100){
										$retencion = ($fact->valventan*0.01)*-1;
									}else{
										$retencion = ($fact->valventan*0.01);
									}
                                    $gravado = $fact->valventan;
                                }else{
                                    $gravado = ($fact->valtax1 / 0.13);
                                    $exento = $fact->valventan-$gravado;
                                }
                            }
                            $iva = $fact->valtax1;
                            $subtotal += $gravado+$exento+$iva+$retencion;
                            $subtotalexento += $exento;
                            $subtotalgravado += $gravado;
                            $subtotalretencion += $retencion;
                            $subtotaliva += $iva;
                            $date = date_format(date_create($fact->fecha),'d/m/Y');
                            $nameCliente = substr($fact->namecliente, 0, 22);
                            $nameVendedor = substr($fact->namevendedor, 0, 20);
                            $cadena_pago = "";
                            $cadena_pago = $this->ventas_model->getFormaDePagoCreditoTrannum($fact->trannum);
                            $pagos = $this->ventas_model->getPagosDoc($fact->trannum);
                            
                            if($pagos!=false){
                                if($cadena_pago!=""){
                                    $cadena_pago.=',';
                                }
                                foreach($pagos as $money){
                                    $cadena_pago .= $money->descrip.",";
                                }
                                $cadena_pago = substr($cadena_pago, 0, -1);
                            }
                            $cadena_pago = substr($cadena_pago, 0, 25);
                           
							
                            
                            foreach($tipospagos as $tip){
                                $pagos = $this->ventas_model->getDatosPagosVentasPago($fact->trannum,$tip->cajclase);
                                if($pagos!=false){
                                    foreach($pagos as $money){
										
										if($money->formaPag=="Efectivo" ||$money->formaPag=="Cheques"){
											if($fact->inopera==1){
												$total_remesar -= (abs($money->valor) - abs($money->vuelto));
											}else{
												$total_remesar += (abs($money->valor) - abs($money->vuelto));
											}
										}
										
                                        if($fact->inopera==1){
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] - (abs($money->valor) - abs($money->vuelto));
                                        }else{
                                            $valpag[$tip->cajclase] = $valpag[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                            $valpagG[$tip->cajclase] = $valpagG[$tip->cajclase] + (abs($money->valor) - abs($money->vuelto));
                                        }
                                    }
                                }
							}
                            
                            $errors = array("Ñ", "ñ");
                            $nameCliente = str_replace($errors, "N", $nameCliente);
                            $nameVendedor = str_replace($errors, "N", $nameVendedor);
                            
                            $titulo .= '
                            <tr>
                                <td style="font-size:7px; text-align:left; font-weight: normal; width: 10%">'.$fact->numeroserie.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 6%">'.$date.'</td>
                                <td style="font-size:8px; text-align:center; font-weight: normal; width: 5%">'.$fact->hora.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 18%">'.$nameCliente.'</td>
                                <td style="font-size:8px; text-align:left; font-weight: normal; width: 13%">'.$nameVendedor.'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($exento, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($iva, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 7%">'.$this->session->userdata("simboloMoneda").number_format(round($retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 8%">'.$this->session->userdata("simboloMoneda").number_format(round($gravado+$iva+$exento+$retencion, 2),2, '.', ',').'</td>
                                <td style="font-size:8px; text-align:right; font-weight: normal; width: 12%">'.$cadena_pago.'</td></tr>';
                        }
                    }

                    $titulo .= '
					<tr>
						<th style="font-size:9px; text-align:left; border-top: 1px solid black; width:10%; font-weight: bold;">('.$numdoc.')</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:42%; font-weight: bold;">Sub-Total '.($docs->tipoDoc).':</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalexento, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalgravado, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotaliva, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:7%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotalretencion, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:8%; font-weight: bold;">'.$this->session->userdata("simboloMoneda").number_format(round($subtotal, 2),2).'</th>
						<th style="font-size:9px; text-align:right; border-top: 1px solid black; width:12%; font-weight: bold;"></th></tr>';
                    $numdoc=0;  
                    $totalGeneral += $subtotal;
                    $totalExento += $subtotalexento;
                    $totalGravado += $subtotalgravado;
                    $totalRetencion += $subtotalretencion;
                    $totalIva += $subtotaliva;
                }
                
                $titulo .= '</tbody></table>';
                $titulo .= '<br><br>';
            
                $titulo .='<table>
                <thead>
                    <tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">RESUMEN</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">No. Operaciones</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Exentas</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Ventas Gravadas </th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">IVA</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Retención</th>
                    <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Sumas</th></tr>
                </thead><tbody>';
                $titulo.='<tr style="border-bottom: 1px solid black;">
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:10%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;">'.$totalDocs.'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalExento, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGravado, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalIva, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalRetencion, 2),2).'</th>
                    <th style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:15%;">'.$this->session->userdata("simboloMoneda").number_format(round($totalGeneral, 2),2).'</th>
                </tr>';
                $titulo .= '</tbody></table>';
                
                $titulo .='<br><br><table>
                <thead>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">INGRESOS</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
                <tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; width:25%;background-color:#C2CBCE;">Tipo de Ingreso</th>';            
              
                $pagos_credito = $this->ventas_model->getFormaDePagoCreditoPeriodo_Retencion('VN', $idcentro, $idcaja, $fechaini, $fechafin);
                $cant_fp = 1;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $tip){
                        $cant_fp++;
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $cant_fp++;
                        }
                    }
                }
                
                $per = 75/$cant_fp;
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$pag->descrip.'</th>';

                    }
                }
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                            $titulo .= '<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold; background-color:#C2CBCE;width:'.$per.'%;">'.$tip->descrip.'</th>';
                        }
                    }
                }
                
                $titulo.='<th style="border: 1px solid black;font-size:11px; text-align:center; font-weight: bold;background-color:#C2CBCE;width:'.$per.'%;">Sumas</th></tr></thead><tbody>';      

                $titulo.='<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:25%;background-color:#C2CBCE;">TOTAL&nbsp;&nbsp;</td>';
                $total_ing_sum=0;
                
                if($pagos_credito!=false){
                    foreach($pagos_credito as $pag){
                        $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($pag->valor, 2),2).'</td>';
                        $total_ing_sum+=round($pag->valor, 2);
                    }
                }
                
                if($tipospagos!=false){
                    foreach($tipospagos as $tip){
                        if($tip->xpos!=0.01){
                           $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($valpagG[$tip->cajclase], 2),2).'</td>';
                                $total_ing_sum+=$valpagG[$tip->cajclase];
                        }
                    }
                }
                    
                $titulo .= '<td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold;width:'.$per.'%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_ing_sum, 2),2).'</td></tr>
				
				</tbody></table>';
				
				
				$titulo .='<br><br><table>
                <thead>
				<tr style="border-bottom: 1px solid black;">
                <th style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:20%;background-color:gray; color:white;">REMESA</th>
                <th style="font-size:8px; text-align:right; font-weight: bold;"></th></tr>
				</thead>
				<tbody>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:20%;background-color:#C2CBCE;">Efectivo + Cheques&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Fecha&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;background-color:#C2CBCE;">Hora&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;background-color:#C2CBCE;">Cuenta&nbsp;&nbsp;</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;background-color:#C2CBCE;">Valor Remesado&nbsp;&nbsp;</td>
				</tr>
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:right; font-weight: bold; width:20%;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:10%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:40%;"></td>
                <td style="border: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:15%;"></td>
				</tr>
				
				<tr style="border-bottom: 1px solid black;">
                <td style="border: 1px solid black;font-size:10px; text-align:left; font-weight: bold; width:100%;">&nbsp;Observaciones:<br><br></td>

				</tr>
				
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-bottom: 1px solid black;"><td style="font-size:10px; text-align:left; font-weight: bold; width:100%;"><br></td></tr>
				<tr style="border-top: 1px solid black;"><td style="border-top: 1px solid black;font-size:10px; text-align:center; font-weight: bold; width:30%;">Elaborado por</td></tr>
				</tbody></table>';
				

				/*
				
				<tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">Total a Remesar</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
                <td style="border: 1px solid black;font-size:12px; text-align:center; font-weight: bold; width:10%;background-color:gray; color:white;">'.$this->session->userdata("simboloMoneda").number_format(round($total_remesar, 2),2).'</td>
                <td style="font-size:8px; text-align:right; font-weight: bold;width:90%;"></td>
				</tr>
				*/
				
					
                
               
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("VentasPorPeriodo.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
        
        function reporteCompraLocal($idrec){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
           		$this->load->library('Pdf');
                
				$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Compra Local');
                $pdf->SetSubject('Compra Local');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, 50, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM); // set the margins 
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP, PDF_MARGIN_BOTTOM);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                
				$this->load->model('compras_model');
                $this->load->model('pedclientes_model');
                
                $informacion  = $this->compras_model->getInformacion($idrec); 
                $productos = $this->compras_model->getProductos($idrec); 
                $name = $this->pedclientes_model->getnameImg();
                
                $fecha = new DateTime();
                $footer =  '<br><br><br><br>
				<table style="padding:0px; margin:0px;">
					<tbody style="padding:0px; margin:0px;">
						<tr style="padding:0px; margin:0px;">
							<th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
							<th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
							<th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
						</tr>
					</tbody>
				</table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
				
				$header = '
				<table style="width:100%; text-align:center;">
					<tr>
						<td colspan="3" style="font-size:5px;"><br></td>
					</tr>
					<tr>
						<td style=""><img style="width:200px; height:70px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></td>
						<td></td>
						<td style="font-size:25px; text-align:center;">COMPRA LOCAL</td>
					</tr>
				</table>';
                
                foreach($informacion as $inf){
					$header .= '
					<table style="width:100%;">
						<tr>
							<td style="font-size:12px; text-align:left; width:50%;"></td>
							<td style="font-size:12px; text-align:center; background-color:#69a6c7; width:50%; font-weight: bold; border: 1px solid #6E6E6E;" colspan="2">Detalles</td>
						</tr>
					</table>';
					
                    $header .= '
					<table style="width:100%;">
						<tr>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Proveedor:</td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;No.</td>
							<td style="font-size:12px; text-align:right; font-weight: bold; width:25%; border: 1px solid #6E6E6E;color:#0B486B;">'.$idrec.'&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:50%;">'.$inf->descrip.'</td>  
							<td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Referencia: </td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->referencia.'&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:50%;">Solicitado por: </td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Número de Documento:</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.$inf->serie.''.$inf->numero.'&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="font-size:12px; text-align:left; width:50%;">'.$inf->solicita.'</td>
							<td style="font-size:12px; text-align:left; font-weight: bold; width:25%; border: 1px solid #6E6E6E;">&nbsp;Fecha:</td>
							<td style="font-size:12px; text-align:right; width:25%; border: 1px solid #6E6E6E;">'.date_format(date_create($inf->fecha), 'd/m/Y').'&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td style="font-size:10px;"><br></td>
						</tr>
					</table>';
                }
                $pdf->setHtmlHeader($header);
				$pdf->setPrintHeader(true);
                
				$pdf->addPage('P', 'LETTER');
				$titulo = '
                <table>
                    <thead>
                        <tr>
							<td style="font-size:10px;"></td>
						</tr>
                        <tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#69a6c7;">
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Unidad de Medida</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:16%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ubicación</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:11%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                            <th style="background-color:#69a6c7; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                        </tr>
                    </thead>
                <tbody>';
				
				$sum_lines = 0; $sum_cant = 0; $sum_subtotal = 0;
                foreach($productos as $pro){
					$sum_lines++;
                    $sum_cant += $pro->cantidad;
                    $sum_subtotal+=($pro->cantidad * $pro->preciotran);
					
                    $titulo .= '
						<tr style="border: 1px solidblack;">
							<td style="width:5%; border-left: 1px solid #6E6E6E; text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$pro->idrec.'</strong></td>
							<td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.trim($pro->descrip).'</strong></td>
							<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->um.'</td>
							<td style="width:16%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->location.'</td>
							<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$pro->batch.'</td>
							<td style="width:8%; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;">'.round($pro->cantidad, 0).'</td>
							<td style="width:11%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($pro->preciotran, 6),6).'</td>
							<td style="width:10%; border-right: 1px solid #6E6E6E;text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(($pro->cantidad * $pro->preciotran),2).'&nbsp;&nbsp;</td>
						</tr>';
                }
                
                $titulo .= '
						<tr>
							<td style="border-top: 1px solid #6E6E6E;" colspan="8"><br></td>
						</tr>';
                
                $titulo .= '
						<tr style="border: 1px solidblack;">
							<td style="width:5%; border-left: 1px solid #6E6E6E; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;text-align:center; vertical-align:middle; font-size:10px;"><strong>'.$sum_lines.'</strong></td>
							<td colspan="4" style="border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E;width:67%;  vertical-align:middle; padding:0px; font-size:10px;"><strong> </strong></td>
							<td style="width:8%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:center;  vertical-align:middle; padding:0px; font-size:10px;"><strong>'.round($sum_cant, 0).'</strong></td>
							<td style="width:10%; border-top: 1px solid #6E6E6E;border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"></td>
							<td style="width:10%; border-right: 1px solid #6E6E6E;  border-top: 1px solid #6E6E6E; border-bottom: 1px solid #6E6E6E; text-align:right; vertical-align:middle; padding:0px; font-size:10px;"><strong>$'.number_format(($sum_subtotal),2).'&nbsp;&nbsp;</strong></td>
						</tr>';
               
				$titulo .= '
					</tbody>
                </table>';
				
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Detalle_Compra".$idrec.".pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
        
        function agrupacion_productos($tipopro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                
                $this->load->model('sucursal_model');
                $this->load->model('producto_model');
                $this->load->model('catalog_model');
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                $nombre_doc = $this->global_model->getFormatosNombre($function);
                $tipoproduct = $this->producto_model->getDescripTipo($tipopro);
                $titulo = '<html lang="es"><meta charset="utf-8">
                <style>
                    @media print {
                        @page { margin: 0; }
                        body { margin: 0.5cm; }
                    }
                </style>
                <tbody>
                <center>
                <label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label>
                <br><label style="text-align:center; font-size:16px;font-weight:bold;">'.$nombre_doc.'</label>
                <br><label style="text-align:center; font-size:15px;">'.$tipoproduct.'</label></center>';
                
                $titulo .= '<hr style="border-color:#031634;background-color:#031634;color:#031634;height:2px;"></hr><br>';
                $departamentos_list = $this->catalog_model->getDepartamentosTipo($tipopro);
                $row_cant = 0;
                $row1 = '';
                $row2 = '';
                $row3 = '';
                foreach($departamentos_list as $dep){
                    if($row_cant>=0 && $row_cant<=55){
                        if($row_cant==0){
                            $row1 .='<tr><td style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;">'.$dep->descrip.' ('.$dep->cantidad.')</td></tr>';
                            $row_cant++;
                        }else{
                            $row1 .='<tr><td style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</td></tr>';
                            $row_cant+=2;
                        }
                        
                    }
                    else if($row_cant>=56 && $row_cant<=105){
                        $row2 .='<tr><td style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</td></tr>';
                        $row_cant+=2;
                    }
                    else if($row_cant>=106){
                        $row3 .='<tr><td style="width:100%; text-align:left; font-size:12px; font-weight:bold;color: #031634;"><br>'.$dep->descrip.' ('.$dep->cantidad.')</td></tr>';
                        $row_cant+=2;
                        if($row_cant==155){
                            $titulo .='<table style="width:100%;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';
                            $row1 = '';
                            $row2 = '';
                            $row3 = '';
                            $row_cant = 0;
                        }
                    }
                    $lineas_list = $this->catalog_model->getLineasTipo($dep->idcatalogo);
                    foreach($lineas_list as $lin){
                        if($lin->idnivel1==$dep->idcatalogo){
                            if($row_cant>=0 && $row_cant<=55){
                                $row1 .='<tr>
                                        <td style="width:100%; text-align:left;  font-size:11px;margin:0;padding-left:10px;padding-right:0px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                        </tr>';
                                $row_cant++;
                            }
                            else if($row_cant>=56 && $row_cant<=105){
                                $row2 .='<tr>
                                        <td style="width:100%; text-align:left;  font-size:11px;margin:0;padding-left:10px;padding-right:0px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                        </tr>';
                                $row_cant++;
                            }
                            else if($row_cant>=106){
                                $row3 .='<tr>
                                        <td style="width:100%; text-align:left;  font-size:11px;margin:0;padding-left:10px;padding-right:0px;">'.$lin->descrip.' <strong>('.$lin->cantidad.')</strong></td>
                                    </tr>';
                                $row_cant++;
                                if($row_cant==155){
                                    $titulo .='<table  style="width:100%;border:1px solid black;"><tr><td style="width:33.33%;"><table>'.$row1.'</table></td><td style="width:33.33%;"><table>'.$row2.'</table></td><td style="width:33.33%;"><table>'.$row3.'</table></td></tr></table>';
                                    $row1 = '';
                                    $row2 = '';
                                    $row3 = '';
                                    $row_cant = 0;
                                }
                            }
                        }
                    }
                }
                 $titulo .='<table  style="width:100%;">
                <tr style="width:100%;">
                    <th style="width:33.33%;padding-top:0px;vertical-align:top;"><table style="width:100%;margin-top:0px;"><tbody>'.$row1.'</tbody></table></th>
                    <th style="width:33.33%;padding-top:0px;vertical-align:top;"><table style="width:100%;margin-top:0px;"><tbody>'.$row2.'</tbody></table></th>
                    <th style="width:33.33%;padding-top:0px;vertical-align:top;"><table style="width:100%;margin-top:0px;"><tbody>'.$row3.'</tbody></table></th>
                </tr>
                </table>';
                $titulo .='</tbody></html>';
                $titulo .="<script type='text/javascript'>window.print();</script>";
                echo $titulo;
               
            }
        }
        
        function reporteTraslados($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 5px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <tbody>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
                }
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    $estructura .= '<br><br>
				<table style="width:100%;">
                <thead>
                                        <tr><th style="font-size:25px;"></th></tr>

					<tr>
						<th style="padding:0px;margin:0px;width:33.3%;" colspan="5">
							<table style="padding:0px;margin:0px;">
								<tr>
									<th style="font-size:15px;"></th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:12px; text-align:left; "><b>'.strtoupper($nombreFormato).' </b></th>
								</tr>
							</table>
						</th>
						<th style="padding:0px;margin:0px;width:33.3%;"  colspan="2"><center><img style="text-align:center; width:170px; height:80px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></center></th>
						<th style="padding:0px;margin:0px;width:33.3%;text-align:right;" colspan="2"><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b">
                        </th>
                    </tr>
                    <tr>
						<th colspan="3" class="background_color" style="font-size:12px; text-align:left; width:37.5%; font-weight: bold; border: 1px solid black;" > Origen</th>
						<th colspan="3" class="background_color" style="font-size:12px; text-align:left; width:37.5%; font-weight: bold; border: 1px solid black;" > Destino</th>
						<th class="background_color" style="font-size:12px; text-align:center; width:25%; font-weight: bold; border: 1px solid black;" colspan="2"> Datos de Orden</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
						<th colspan="3" rowspan="3" style="border:1px solid black;font-size:11px; text-align:left;width:37.5%;">'.$data->centrocd.' <br> '.$data->encargadoinv.'</th>
						<th colspan="3" rowspan="3" style="border:1px solid black;font-size:11px; text-align:left;width:37.5%;">'.$data->idcentrod.' <br> '.$data->encargadod.'</th>
                        <th class="background_color" style="font-size:11px; text-align:right;width:5%;border: 1px solid black; "> N°:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;"> '.$data->trannum.'</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
						<th class="background_color" style="border:1px solid black;width:5%;font-size:11px; text-align:right;border: 1px solid black; "> Fecha:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;"> '.$date_emision.'</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
                        <th class="background_color" style="font-size:11px; text-align:right;width:5%;border: 1px solid black;"> Estado:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;"> '.$estado.'</th>
					</tr>';
                }
                
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura.='
                    <tr style="vertical-align:middle;width:100%;">
                        <th class="background_color" style="width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                        <th class="background_color" style="width:35%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
                        <th class="background_color" style="width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                    </tr>
                    </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    foreach($detalle as $key){
                        $estructura.='<tr style="border:  1px solid #6E6E6E; ">
                                <td style="width:5%;text-align:center; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->modelo.'</td>
                                <td style="width:35%; text-align:left; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->um.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:10%; text-align:center; font-size:10px;">'.abs(number_format(round($key->cantidad, 2),2)).'</td>
                                <td style="width:10%; text-align:center; font-size:10px;  border-bottom:solid 1px black;"></td>
                                </tr>';
                        $totalitems++;
                        $totalcant+= (abs($key->cantidad) * 1);
                    }
                    $estructura.='
                    <tr style="border:1px solid #6E6E6E; font-size:12px;">
                        <td style="width:5%; text-align:center; vertical-align:middle; font-size:12px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="5" style="width:75%; text-align:center; vertical-align:middle; font-size:12px;"></td>
                        <td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:12px;"><strong>'.abs(round($totalcant, 2)).'</strong></td>
                    </tr>
                    </tbody>
                    </table>';
                     $estructura .= '
                      <table style="width:100%;">
                      <tr>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Entregado por</td>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Recibido por</td>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Fecha y hora</td>
					   </tr>
					   <tr>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                    
                }   
                $estructura.= "</tbody></html>";
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
            }
        }
        
        function cuadre_existencias($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
                $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin:0; padding: 15px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                $this->load->model('pedclientes_model');
                $name = $this->pedclientes_model->getnameImg();
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('variable_model');
                $info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporteOrdDescrip($trannum);
                
                
                $function = $this->uri->segment(3);
                $this->load->model("global_model");
                //$nombre_doc = $this->global_model->getFormatosNombre($function);
                $nombre_doc = "";
                $center_name= "";
                foreach($info_ajuste as $aj){
                    $center_name = $aj->centerName;
                }
                
                $estructura .= '<br><br>
				<table style="width:100%;">
                <thead style="width:100%;">
                    <tr><th colspan="8"><br><br></th></tr>
					<tr>
						<th colspan ="3" style="padding:0px;margin:0px;width:50%;text-align:left"><img style="text-align:left; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></th>
						<th colspan ="5" style="padding:0px;margin:0px;width:50%;text-align:right;font-size:15px;">'.$this->session->userdata('descrip').'<br>'.$nombre_doc.' N° '.$trannum.'<br>'.$center_name.'</th>
                    </tr>';
                
                $estructura .='
                <tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:36%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Costo</th>
                <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
                </tr>
                </thead>
                <tbody>';
                     
                $sum_invsistema=0;
                $uni_invsistema=0;
                $cantinvsistema=0;
                
                $sum_invsistema_noinventariado=0;
                $uni_invsistema_noinventariado=0;
                $cantinvsistema_noinventariado=0;
                
                $estructura.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td><td colspan="2"> </td></tr>';
                
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                $cantsinajuste= 0;
                $sum_sinajuste = 0;
                $uni_sinajuste=0;
                
                $cantajusteafavor = 0;
                $sum_ajusteafavor=0;
                $uni_ajusteafavor=0;
                $ajusteafavor='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';

                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0;
                $sum_ajusteencontra = 0;
                $uni_ajusteencontra=0;
                
                foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2), 2).'</td></tr>';
                            $cantsinajuste++;
                        }else if($key->cantrp-$key->cantidad > 0){
                            $sum_ajusteafavor+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteafavor.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteafavor++;
                        }else if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra++;
                        }
                    }     
                }   
                if($cantsinajuste>0){
                    $estructura.=$sinajuste;
                }
                if($cantajusteafavor>0){
                    $estructura.=$ajusteafavor;
                }
                if($cantajusteencontra>0){
                    $estructura.=$ajusteencontra;
                }
                $sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
                $estructura.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';
                $ajusteencontra='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra2 = 0;
                $sum_ajusteencontra2 = 0;
                $uni_ajusteencontra2=0;
                $sinajuste='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                $cantsinajuste2= 0;
                $sum_sinajuste2 = 0;
                $uni_sinajuste2=0;
                foreach($detalle as $key){
                    if($key->modNotas==999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $ajusteencontra.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantajusteencontra2++;
                        }else if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            $sinajuste.='<tr style="border:  solid 1px black; ">
                            <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                            <td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
                            <td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
                            <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
                            <td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td></tr>';
                            $cantsinajuste2++;
                        }
                    }
                }   
                if($cantajusteencontra2>0){
                    $estructura.=$ajusteencontra;
                }
                if($cantsinajuste2>0){
                    $estructura.=$sinajuste;
                }
                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;
                $estructura.='</tbody>
                </table>
                <table>
                    <tr><td colspan="4"><br><br><br></td></tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:40%;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;width:30%;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:11px;width:10%;">Costo</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;width:10%;">Productos</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Sistema</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:right;width:10%;font-weight:bold;">'.number_format(round($uni_invsistema, 2),2).'</td>
                        <td style="text-align:center;width:10%;font-weight:bold;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteencontra2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_ajusteafavor,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantajusteafavor.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:30%;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;width:10%;">'.number_format(round(($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor),2),2).'</td>
                        <td style="text-align:center; font-weight:bold;width:10%;"></td>
                    </tr>
                    <tr><td colspan="5"><br></td></tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste2,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;width:40%;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;width:30%;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;width:10%;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:right;width:10%;">'.number_format(round($uni_sinajuste,2),2).'</td>
                        <td style="text-align:center;width:10%;">'.$cantsinajuste.'</td>
                    </tr>
                    </table>';
                
                $estructura.= "</body></html>";
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
                
            }
        }
        
        function reporteRecepcion($idtrannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 10px;margin-bottom: 10px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                $this->load->model('invtran_model');
                $this->load->model('global_model');
                $this->load->model('pedclientes_model');
                $informacion = $this->invtran_model->getDetallePedido($idtrannum);
                $catalogo = $this->global_model->getCatalogoPrincipal();
                $detalle = $this->invtran_model->getDataTran100k($idtrannum);
                $this->load->model('variable_model');
                $funcion = $this->uri->segment(3);
				$nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
                }
                foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                    
                    $estructura .= '
				<table style="width:100%;">
                <thead>
					<tr>
						<th style="padding:0px;margin:0px;width:33.3%;" colspan="3">
							<table style="padding:0px;margin:0px;">
								<tr>
									<th style="font-size:15px;"></th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</th>
								</tr>
								<tr style="padding:0px; margin:0px;">
									<th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</th>
								</tr>
							</table>
						</th>
						<th style="padding:0px;margin:0px;width:33.3%;"  colspan="4"><img style="text-align:left; width:200px; height:90px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></th>
						<th style="padding:0px;margin:0px;width:33.3%;"  colspan="2">
                            <table><tr>
                                <td style="font-size:14px; text-align:right;width:100%;">'.strtoupper($nombreFormato).'</td>
				                </tr><tr>
                                <td style="margin:0px;padding:0px;font-size:15px;width:100%;text-align:right;"><img src="'.base_url().'application/controllers/barcode.php?text='.$idtrannum.'&size=40&width=120&orientation=horizontal&codetype=code128b"></th>
				                </tr>
                            </table>
                        </th>
                    </tr>
                    <tr>
						<th colspan="3" class="background_color" style="font-size:12px; text-align:left; width:37.5%; font-weight: bold; border: 1px solid black;" > Origen</th>
						<th colspan="4" class="background_color" style="font-size:12px; text-align:left; width:37.5%; font-weight: bold; border: 1px solid black;" > Destino</th>
						<th class="background_color" style="font-size:12px; text-align:center; width:25%; font-weight: bold; border: 1px solid black;" colspan="2"> Datos de Orden</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
						<th colspan="3" rowspan="3" style="border:1px solid black;font-size:11px; text-align:left;width:37.5%;">'.$data->idcentrod.' <br> '.$data->encargadoinv.'</th>
						<th colspan="4" rowspan="3" style="border:1px solid black;font-size:11px; text-align:left;width:37.5%;">'.$data->centrocd.' <br> '.$data->encargadod.'</th>
                        <th class="background_color" style="font-size:11px; text-align:right;width:5%;border: 1px solid black; "> N°:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;"> '.$data->trannum.'</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
						<th class="background_color" style="border:1px solid black;width:5%;font-size:11px; text-align:right;border: 1px solid black; "> Fecha:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;">'.$date_cierre.'</th>
					</tr>
                    <tr style="border:1px solid black;width:100%;">
                        <th class="background_color" style="font-size:11px; text-align:right;width:5%;border: 1px solid black;"> Estado:  </th>
                        <th style="font-size:11px; text-align:left;width:20%;border: 1px solid black;"> '.strtoupper($estado).'</th>
					</tr>';
                }
                
                
                 foreach($informacion as $data){
                    $date_emision = date_format(date_create($data->fecha),'d/m/Y');
                    $date_cierre = date_format(date_create($data->fecact),'d/m/Y');
                    switch($data->estatus){
                        case 0:
                            $estado= "En proceso";
                            break;
                        case 1: 
                            $estado="Enviado";
                            break;
                        case 2:
                            $estado="Recibido";
                            break;
                        case 9: 
                            $estado="Anulado";
                            break;
                        default:
                            $estado="";
                            break;
                    }
                     $estructura.='<tr style="vertical-align:middle; font-size:12px; border: solid 1px black; height:20px;background-color:#E8E8E8;">
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-left: solid 1px black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Línea</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:12%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:12%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Lote</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cant</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:8%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Total</th>
                                    <th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; border-right: solid 1px black; width:7%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;"></th>
                                </tr>
                                </thead>
                    <tbody>';
                    $totalitems=0;
                    $totalcant=0;
                    $total_costo = 0;
                    foreach($detalle as $key){
                        $estructura.='<tr style="border:  solid 1px black; ">
                                <td style="width:5%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->itemline.'</td>
                                <td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
                                <td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
                                <td style="width:12%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->um.'</td>
                                <td style="width:12%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.$key->lote.'</td>
                                <td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.abs(number_format(round($key->cantidad, 2))).'</td>
                                <td style="width:8%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario, 2),2, '.', ',').'</td>
                                <td style="width:8%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">$'.number_format(round($key->costounitario*abs($key->cantidad), 2),2, '.', ',').' </td>
                                <td style="width:7%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;  border-bottom:solid 1px black;"></td></tr>';
                        $totalitems++;
                        $totalcant+= abs($key->cantidad);
                        $total_costo+= abs(round($key->costounitario, 2))*abs(round($key->cantidad, 2));
                    }
                    $estructura.='<tr><td></td></tr>
                    <tr style="text-align:left; vertical-align:middle; font-size:12px;">
                        <td style="text-align:center; vertical-align:middle; font-size:11px;"><strong>'.$totalitems.'</strong></td>
                        <td colspan="4" style="text-align:center; vertical-align:middle; font-size:11px;"></td>
                        <td style="text-align:center; vertical-align:middle; padding:0px; font-size:11px;"><strong>'.$totalcant.'</strong></td>
                        <td colspan="2" style="text-align:right; vertical-align:middle; padding:0px; font-size:11px;"><strong>$'.number_format(round($total_costo, 2),2, '.', ',').'</strong></td>
                        <td style="text-align:center; vertical-align:middle; font-size:12px;"></td>
                    </tr></tbody></table>';
                }   
                 $estructura .= '
                      <table style="width:100%;">
                      <tr>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Entregado por</td>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Recibido por</td>
                            <td class="background_color" style="font-size:12px; text-align:center; width:33.3%;bold; border: 1px solid black;">Fecha y hora</td>
					   </tr>
					   <tr>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
                            <td style="font-size:12px; text-align:left; width:33.3%; border: 1px solid black;"><br><br><br></td>
					</tr>
				</table><br><br><br>';
                
                
                
                $estructura.= "</body></html>";
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
            }
        }
        
		function recuento_fisico($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
                 $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 5px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('variable_model');$this->load->model('pedclientes_model');
                
				$info_ajuste = $this->invtran_model->getInformacionAjuste($trannum);
                $detalle = $this->invtran_model->getDataAjuste100kreporteOrdDescrip($trannum);
                
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
                }
                foreach($info_ajuste as $aj){
					$center_name = $aj->centerName;
                    $fechaAjuste = date_format(date_create($aj->fecha),'d/m/Y');
                }
				$estructura .= '
				<table style="width: 100%;">
                	<thead style="width: 100%;">
                        <tr><th style="font-size:25px;"></th></tr>
                        <tr>
                            <th style="padding:0px;margin:0px;" colspan="5">
                                <table style="padding:0px;margin:0px;">
                                    <tr>
                                        <th style="font-size:15px;"></th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="font-size:12px; text-align:left; font-weight: bold;" colspan="8">'.strtoupper($nombreFormato).' N° '.$trannum.'&nbsp;&nbsp; Fecha: '.$fechaAjuste.'</th>
                                    </tr>
                                </table>
                            </th>
                            <th style="padding:0px;margin:0px;"  colspan="3"><br><img style="text-align:right; width:180px; height:80px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></th>
                        </tr>
						<tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Físico</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajuste</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Costo</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">Subtotal</th>
						</tr>
                	</thead>
					<tbody>';
                
				$sum_invsistema=0; $uni_invsistema=0; $cantinvsistema=0;
                $sum_invsistema_noinventariado=0; $uni_invsistema_noinventariado=0; $cantinvsistema_noinventariado=0;
                
                $estructura .= '<tr><td colspan="8" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS INVENTARIADOS</td></tr>';
                $estructura.='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE</td></tr>';
                
				$cantsinajuste= 0; $sum_sinajuste = 0; $uni_sinajuste=0;
                
				foreach($detalle as $key){
					if($key->modNotas!=999999){
						if($key->cantrp-$key->cantidad == 0){
							$sum_sinajuste+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            
							$estructura .= '
							<tr style="border:  solid 1px black; ">
								<td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
								<td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
								<td style="width:30%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
								<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
								<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
								<td style="width:10%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2), 2).'</td>
							</tr>';
                            $cantsinajuste++;
                        }
                    }     
                }
				
                
                $estructura.='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE A FAVOR</td></tr>';
                $cantajusteafavor = 0; $sum_ajusteafavor=0; $uni_ajusteafavor=0;
				
                foreach($detalle as $key){
					if($key->modNotas!=999999){
						if($key->cantrp-$key->cantidad > 0){
							$sum_ajusteafavor+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteafavor+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
							
                            $estructura .= '
							<tr style="border: solid 1px black;">
								<td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
								<td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
								<td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td>
							</tr>';
                            $cantajusteafavor++;
                        }
                    }
                }
               	
                $estructura.= '<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
                $cantajusteencontra = 0; $sum_ajusteencontra = 0; $uni_ajusteencontra=0;
                
				foreach($detalle as $key){
                    if($key->modNotas!=999999){
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
							
                            $estructura .= '
							<tr style="border:  solid 1px black; ">
								<td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
								<td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
								<td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td>
							</tr>';
                            $cantajusteencontra++;
                        }
                    }
                }
                 
				$sumcant= $cantsinajuste+$cantajusteafavor+$cantajusteencontra;
                $sumuni= $uni_sinajuste+$uni_ajusteafavor+$uni_ajusteencontra;
              	
                $estructura.='<tr><td colspan="2"> </td><td colspan="4" style="font-size:15px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;text-align:center;"><br><br>PRODUCTOS NO INVENTARIADOS</td><td colspan="2"> </td></tr>';
                $estructura.='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>AJUSTE EN CONTRA</td></tr>';
				
                $cantajusteencontra2 = 0; $sum_ajusteencontra2 = 0; $uni_ajusteencontra2=0;
                
				foreach($detalle as $key){
					if($key->modNotas==999999){    
                        if($key->cantrp-$key->cantidad < 0){
                            $sum_ajusteencontra2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_ajusteencontra2+=($key->cantrp-$key->cantidad);

                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
                            $cantinvsistema ++;
                            
							$estructura .= '
							<tr style="border: solid 1px black;">
								<td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
								<td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
								<td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2),2).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2),2).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td>
							</tr>';
							$cantajusteencontra2++;
						}
                    }
                }
                 
                $estructura.='<tr><td colspan="8" style="font-size:12px; border-bottom:1px solid #0B486B;color:#0B486B;font-weight:bold;"><br><br>SIN AJUSTE (IGNORADOS)</td></tr>';
                
				$cantsinajuste2= 0; $sum_sinajuste2 = 0; $uni_sinajuste2=0;
               
                foreach($detalle as $key){
                    if($key->modNotas==999999){
                        if($key->cantrp-$key->cantidad == 0){
                            $sum_sinajuste2+=round($key->costounitario*($key->cantrp-$key->cantidad), 2);
                            $uni_sinajuste2+=($key->cantrp-$key->cantidad);
                            $sum_invsistema +=round($key->costounitario*abs($key->cantidad), 2);
                            $uni_invsistema +=round(abs($key->cantidad));
							$cantinvsistema ++;
                            
							$estructura .= '
							<tr style="border: solid 1px black;">
								<td style="width:10%; text-align:center; vertical-align:middle; font-size:10px;">'.$key->idproducto.'</td>
								<td style="width:10%; text-align:left; vertical-align:middle; padding:0px; font-size:10px;">'.$key->modelo.'</td>
								<td style="width:36%;  vertical-align:middle; padding:0px; font-size:10px;">'.trim($key->descrip).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantidad, 2)).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp, 2)).'</td>
								<td style="width:8%; text-align:center; vertical-align:middle; padding:0px; font-size:10px;">'.number_format(round($key->cantrp-$key->cantidad, 2)).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario, 4),4).'</td>
								<td style="width:10%; text-align:right; vertical-align:middle; padding:0px; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($key->costounitario*($key->cantrp-$key->cantidad), 2),2).'</td>
							</tr>';
                            $cantsinajuste2++;
                        }
                    }
                }
				
                $sumcant2= $cantsinajuste2+$cantajusteencontra2;
                $sumuni2= $uni_sinajuste2+$uni_ajusteencontra2;
                $sum_ajusteneto = $sum_sinajuste+$sum_ajusteafavor+$sum_ajusteencontra+$sum_sinajuste2+$sum_ajusteencontra2;
                
                $estructura .= '
					</tbody>
                </table>
                <table>
					<tr>
						<td colspan="8"><br><br><br></td>
					</tr>
                    <tr>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:11px;"></td>
                        <td style="text-align:right; font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right; font-weight:normal;color:gray;font-size:13px;">Costo</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:13px;">Unidades</td>
                        <td style="text-align:center; font-weight:normal;color:gray;font-size:13px;">Productos</td>
                    </tr>
					<tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:13px;">Inventario Sistema</td>
                        <td style="text-align:right;font-weight:bold;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_invsistema, 2),2).'</td>
                        <td style="text-align:right;font-weight:bold;font-size:11px;">'.number_format(round($uni_invsistema, 2),2).'</td>
                        <td style="text-align:center;font-weight:bold;font-size:11px;">'.$cantinvsistema.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:13px;">Ajuste en Contra (Inventariados)</td>
                        <td style="text-align:right;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteencontra, 2),2).'</td>
                        <td style="text-align:right;font-size:11px;">'.number_format(round($uni_ajusteencontra,2),2).'</td>
                        <td style="text-align:center;font-size:11px;">'.$cantajusteencontra.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:13px;">Ajuste en Contra (No Inventariados)</td>
                        <td style="text-align:right;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteencontra2, 2),2).'</td>
                        <td style="text-align:right;font-size:11px;">'.number_format(round($uni_ajusteencontra2,2),2).'</td>
                        <td style="text-align:center;width%;font-size:11px;">'.$cantajusteencontra2.'</td>
                    </tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:13px;">Ajuste a Favor</td>
                        <td style="text-align:right;width:10%;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_ajusteafavor, 2),2).'</td>
                        <td style="text-align:right;font-size:11px;">'.number_format(round($uni_ajusteafavor,2),2).'</td>
                        <td style="text-align:center;font-size:11px;">'.$cantajusteafavor.'</td>
                    </tr>
					<tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:left;font-weight:bold;font-size:13px;">Inventario Final Ajustado</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round(($sum_invsistema+$sum_ajusteencontra+$sum_ajusteencontra2+$sum_ajusteafavor), 2),2).'</td>
                        <td style="border-top:1px solid gray;text-align:right; font-weight:bold;font-size:11px;">'.number_format(round(($uni_invsistema+$uni_ajusteencontra+$uni_ajusteencontra2+$uni_ajusteafavor),2),2).'</td>
                        <td style="text-align:center; font-weight:bold;font-size:11px;"></td>
                    </tr>
                    <tr>
						<td colspan="8"><br></td>
					</tr>
                    <tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;">Sin Ajuste (No Inventariados)</td>
                        <td style="text-align:right;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_sinajuste2, 2),2).'</td>
                        <td style="text-align:right;font-size:11px;">'.number_format(round($uni_sinajuste2,2),2).'</td>
                        <td style="text-align:center;font-size:11px;">'.$cantsinajuste2.'</td>
                    </tr>
					<tr>
                        <td style="text-align:left;font-weight:bold;font-size:11px;"></td>
                        <td style="text-align:right;font-weight:normal;font-size:11px;">Sin Ajuste (Inventariados)</td>
                        <td style="text-align:right;font-size:11px;">'.$this->session->userdata("simboloMoneda").number_format(round($sum_sinajuste, 2),2).'</td>
                        <td style="text-align:right;font-size:11px;">'.number_format(round($uni_sinajuste,2),2).'</td>
                        <td style="text-align:center;font-size:11px;">'.$cantsinajuste.'</td>
                    </tr>
				</table>';
                
                $estructura.= "</body></html>";
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
                
            }
        }
        
        function comprobacion_inventario($tipopro, $idcentro, $fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
            }else{
                 $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 10px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                
                
                $this->load->model('invtran_model'); $this->load->model('global_model');
                $this->load->model('variable_model');$this->load->model('pedclientes_model');
                $this->load->model('producto_model');$this->load->model('sucursal_model');
                $info = $this->invtran_model->getComInvDate($tipopro,$idcentro,$fechaini,$fechafin);
                
                $tipoproduct = $this->producto_model->getDescripTipo($tipopro);
                $namecentro = $this->sucursal_model->getNameCentro($idcentro);
                $funcion = $this->uri->segment(3);
                $this->load->model('global_model');
                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
                }
                
				$estructura .= '
				<table style="width: 100%;" cellspacing="0">
                	<thead style="width: 100%;">
                        <tr><th style="font-size:25px;"></th></tr>
                        <tr>
                            <th style="padding:0px;margin:0px;" colspan="4">
                                <table style="padding:0px;margin:0px;">
                                    <tr>
                                        <th style="font-size:15px;"></th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</th>
                                    </tr>
                                </table>
                            </th>
                            <th style="padding:0px;margin:0px;"  colspan="6"><br><img style="text-align:right; width:180px; height:80px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></th>
                            <th style="padding:0px; margin:0px; font-size:10.5px; text-align:right;" colspan="10">
                            '.strtoupper($nombreFormato).'
                            <br>Sucursal: '.$namecentro.'
                            <br>Tipo de Producto: '.$tipoproduct.'
                            <br>Periodo:  '.date_format(date_create($fechaini), 'd/m/Y').' - '.date_format(date_create($fechafin), 'd/m/Y').'
                            </th>
                       </tr>
						<tr style="vertical-align:middle; font-size:12px;" class="background_color">
                            <th rowspan="2" style="border:0.5px solid black; width:3%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Código</th>
							<th rowspan="2" style="border:0.5px solid black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">Descripción del Producto</th>
							<th rowspan="2" style="border:0.5px solid black; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Marca</th>
							<th rowspan="2" style="border:0.5px solid black; width:6%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Modelo</th>
							<th rowspan="2" style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">UM</th>
							<th colspan="2" style="border:0.5px solid black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Saldo Inicial</th>
							<th colspan="2" style="border:0.5px solid black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Compras</th>
							<th colspan="2" style="border:0.5px solid black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ajustes/Envios</th>
							<th colspan="2" style="border:0.5px solid black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Ventas</th>
							<th colspan="3" style="border:0.5px solid black; width:15%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Inventario Final</th>
						</tr>
						<tr style="vertical-align:middle; font-size:12px;" class="background_color">
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Valor</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Cantidad</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Unitario</th>
							<th style="border:0.5px solid black; width:5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">Costo Total</th>
						</tr>
                	</thead>
					<tbody>';
                
                $suma_cant_inicial = 0;
                $suma_costo_inicial = 0;
                $suma_cant_compras = 0;
                $suma_costo_compras = 0;
                $suma_cant_ajustes = 0;
                $suma_costo_ajustes = 0;
                $suma_cant_ventas = 0;
                $suma_costo_ventas = 0;
                $cant_inv_final =0;
                $costotal_inv_final =0;
                
                foreach($info as $in){
                    $inv_disponible = 0;
                    $inv_actual = 0;
                    $costo_total = 0;
                    $inv_disponible = $in->saldoinicial+$in->compras+$in->ajustes;
                    $inv_actual = $in->saldoinicial+$in->compras+$in->ajustes+$in->ventas;
                    $costo_total = $in->ini_costoco + $in->ini_costoajvn + $in->costocompras + $in->costoajustes + $in->costoventas;
                    if($inv_actual!=0){
                        $costo_unitario = $costo_total / $inv_actual;
                    }else{
                        $costo_unitario=0;
                    }
                    $costo_unitario_batch = $this->invtran_model->getBatchProducto($in->idproducto);
                     
                    $cadena_costo_compra = "";
                    $cadena_costo_ajuste = "";
                    $cadena_costo_venta= "";
                    if($in->costocompras!=0){
                        $cadena_costo_compra = $this->session->userdata("simboloMoneda").number_format(round($in->costocompras, 2),2, '.', ',');
                    }
                    if($in->costoajustes!=0){
                        $cadena_costo_ajuste = $this->session->userdata("simboloMoneda").number_format(round($in->costoajustes, 2),2, '.', ',');
                    }
                    if($in->costoventas!=0){
                        $cadena_costo_venta = $this->session->userdata("simboloMoneda").number_format(round($in->costoventas, 2),2, '.', ',');
                    }
                    $cadena_costo_total = "";
                    $cadena_costo_unitario = "";
                    
                    if($inv_actual!=0){
                        $cadena_costo_total = $this->session->userdata("simboloMoneda").number_format(round($costo_total, 2),2, '.', ',');
                        $cadena_costo_unitario = $this->session->userdata("simboloMoneda").number_format(round($costo_total/$inv_actual, 2),2, '.', ',');
                    }
                    
                    if($inv_disponible  != 0 || $inv_actual != 0 || $in->compras != 0 || $in->ajustes  != 0 || $in->venta != 0 ){
                        $estructura .= '
                        <tr>
                            <td style="border-left:0.5px solid gray;  border-bottom:0.5px solid gray; width: 3%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.$in->idproducto.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 30%;text-align:left; vertical-align:middle; font-weight: normal; font-size:10px;">'.substr($in->producto, 0, 45).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 6%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.substr($in->marca, 0, 10).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 6%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.substr($in->modelo, 0, 10).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.$in->um.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round($in->saldoinicial, 2).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($in->ini_costoco + $in->ini_costoajvn, 2),2, '.', ',').'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.round($in->compras, 2).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: normal; font-size:10px;">'.$cadena_costo_compra.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.round($in->ajustes, 2).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: normal; font-size:10px;">'.$cadena_costo_ajuste.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: normal; font-size:10px;">'.round(abs($in->venta), 2).'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: normal; font-size:10px;">'.$cadena_costo_venta.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.$inv_actual.'</td>
                            <td style="border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$cadena_costo_unitario.'</td>
                            <td style="border-right:0.5px solid gray; border-bottom:0.5px solid gray; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$cadena_costo_total.'</td>
                        </tr>';    
                    }
                    $suma_cant_inicial +=  round($in->saldoinicial, 2);
                    $suma_costo_inicial +=  round($in->ini_costoco + $in->ini_costoajvn, 2);
                    $suma_cant_compras +=  round($in->compras, 2);
                    $suma_costo_compras +=  round($in->costocompras,2);
                    $suma_cant_ajustes +=  round($in->ajustes, 2);
                    $suma_costo_ajustes +=  round($in->costoajustes,2);
                    $suma_cant_ventas +=  round(abs($in->venta), 2);
                    $suma_costo_ventas +=  round($in->costoventas,2);
                    $cant_inv_final += $inv_actual;
                    $costotal_inv_final += round($costo_total, 2);
                }
                
                $estructura .= '
                        <tr>
                            <td style="border-left:0.5px solid black;  border-top:0.5px solid black;border-bottom:0.5px solid black; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;"colspan="5">TOTALES:   </td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round($suma_cant_inicial, 2).'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format(round($suma_costo_inicial, 2),2, '.', ',').'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round($suma_cant_compras, 2).'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($suma_costo_compras,2,'.',',').'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round($suma_cant_ajustes, 2).'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($suma_costo_ajustes,2,'.',',').'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round(abs($suma_cant_ventas), 2).'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($suma_costo_ventas,2,'.',',').'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">'.round($cant_inv_final,2).'</td>
                            <td style="border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;"></td>
                            <td style="border-right:0.5px solid black; border-top:0.5px solid black;border-bottom:0.5px solid black; width: 5%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">'.$this->session->userdata("simboloMoneda").number_format($costotal_inv_final,2,'.',',').'</td>
                        </tr>';  
                
                $estructura.= "</body></table></html>";
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
                
            }
        }
        
        function valueinv($sucursal, $tipopro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                $fecha = new DateTime();
                $this->load->library('Pdf');
                $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Reporte de Inventario Valorizado');
                $pdf->SetSubject('Reporte de Inventario Valorizado');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,PDF_MARGIN_TOP);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('P');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                 
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $this->load->model('sucursal_model');
                $nameSucursal = $this->sucursal_model->getNameCentro($sucursal);
                $this->load->model('invtran_model');
                $departamentos = $this->invtran_model->getInvValorizado_Dept($sucursal,$tipopro);
                $dataLineas = $this->invtran_model->getInvValorizado_Lineas($sucursal,$tipopro);
                $header = '<br><center><label style="text-align:center; font-weight:bold; font-size:20px;">'.$this->session->userdata('descrip').'</label><br><label style="text-align:center; font-size:16px;">Inventario Valorizado al '.$fecha->format('d/m/Y').'</label><br><label style="text-align:center; font-size:13px;">'.$nameSucursal.'</label></center>';
               
                //$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                //$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
               
                $footer =  '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:left; width: 30%">'.$fecha->format('d/m/Y').' - '.$fecha->format('h:i a').'</th>
                            <th style="font-size:10px; text-align:center; width: 40%">'.$this->session->userdata('userLog').'</th>
                            <th style="font-size:10px; text-align:right; width: 30%">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                    </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->addPage( 'P', 'LETTER' );
                $total_costo=0;
                $total_venta=0;
                $total_cantidades=0;
                $sum_margen=0;
                $cant_dep=0;
                $titulo='<table><thead><tr style="" >
                        <th style="width:45%; font-size:13px; border-bottom:1px solid #999; ">Departamento/Línea</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:center;">Productos</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Costo</th>
                        <th style="width:15%; font-size:13px; border-bottom:1px solid #999; text-align:right">Venta Neto</th>
                        <th style="width:10%; font-size:13px; border-bottom:1px solid #999; text-align:right">Margen s/costo</th>
                </tr></thead><tbody>';
                
                foreach($departamentos as $dep){
                    $total_costo = $total_costo+$dep->costo;
                    $total_venta = $total_venta+$dep->venta;
                    $total_cantidades = $total_cantidades+$dep->unidades;
                    $margen = (($dep->venta-$dep->costo)/$dep->venta)*100;
                    $sum_margen = $sum_margen+$margen;
                    $cant_dep++;
                    $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:45%;  font-size:12px; font-weight:bold;">'.$dep->descrip.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold;text-align:center;">'.$dep->unidades.'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->costo, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:15%;  font-size:12px; font-weight:bold; text-align:right;">$'.number_format(round($dep->venta, 2),2).'</td>
                        <td style="border-bottom:0.5px solid #F6F6F6; width:10%;  font-size:12px; font-weight:bold; text-align:right;">'.number_format(round($margen, 2),2).'%</td>
                   </tr>';
                    foreach($dataLineas as $line){

                        if($line->idnivel1==$dep->idcatalogo){
                            $margen_linea = (($line->venta-$line->costo)/$line->venta)*100;
                            $titulo.='<tr>
                            <td style="width:45%;  font-size:11px;">&nbsp;&nbsp;&nbsp;                                  '.$line->linea.'</td>
                            <td style="width:15%;  font-size:11px; text-align:center;">'.$line->unidades.'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->costo, 2),2).'</td>
                            <td style="width:15%;  font-size:11px;text-align:right;">$'.number_format(round($line->venta, 2),2).'</td>
                            <td style="width:10%; font-size:11px;text-align:right;">'.number_format(round($margen_linea, 2),2).'%</td>
                            </tr>';
                        }
                    }
                }
                $prom_margen=$sum_margen/$cant_dep;
                $titulo.='<tr><td></td><td></td><td></td><td></td></tr>
                        <tr>
                        <td style="width:45%;  font-size:12px; text-align:right; font-weight:bold;">TOTALES</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px; text-align:center; font-weight:bold;">'.$total_cantidades.'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_costo, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:15%;  font-size:11px;text-align:right; font-weight:bold;">$'.number_format(round($total_venta, 2),2).'</td>
                        <td style="border-top:1px solid #999; width:10%;  font-size:11px;text-align:right; font-weight:bold;">'.number_format(round($prom_margen, 2),2).'% <br> Prom.</td>
                   </tr>';
                
                $titulo.='</tbody></table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("Inventario_Valorizado.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }
     
        function envios($idcentro,$fechaini, $fechafin){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');$this->load->model('invtran_model');
                $this->load->model('variable_model');$this->load->model('sucursal_model');
                $funcion = $this->uri->segment(3);
                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                $nombreSucursal = $this->sucursal_model->getNameCentro($idcentro);
                $centros = $this->invtran_model->getCentrosEnviados($idcentro,$fechaini,$fechafin);
                
                
                $this->db->query('SET SQL_BIG_SELECTS=1'); 
                ini_set('memory_limit', '9999M');
                ini_set('max_allowed_packet', '9999M');
                ini_set('max_execution_time', 0);
                set_time_limit(0);
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';   
                $objPHPExcel = new PHPExcel();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas") // Nombre del autor
                    ->setLastModifiedBy("Versanet Sistemas") //Ultimo usuario que lo modificó
                    ->setTitle("Traslados a Sucursales") // Titulo
                    ->setSubject("Traslados a Sucursales") //Asunto
                    ->setDescription("Traslados a Sucursales") //Descripción
                    ->setKeywords("Traslados a Sucursales") //Etiquetas
                    ->setCategory("Traslados a Sucursales"); //Categorias
                $objPHPExcel->setActiveSheetIndex(0);
            
                $celdas = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U'); 
                
                
                $titulos = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => '15234A'),
                        'size'  => 13,
                        'name'  => 'Verdana'
                    )
                );
                $subtitulos = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font'  => array(
                        'bold'  => false,
                        'bold'  => false,
                        'color' => array('rgb' => '7F90A2'),
                        'size'  => 11,
                        'name'  => 'Verdana'
                    )
                );
                
                 $style_totals = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                    ),
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => '000000'),
                        'size'  => 12,
                        'name'  => 'Verdana'
                    )
                );
                
                 $style_totals_center = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => '000000'),
                        'size'  => 12,
                        'name'  => 'Verdana'
                    )
                );
                $style_totals_second = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                    ),
                    'font'  => array(
                        'bold'  => false,
                        'color' => array('rgb' => '000000'),
                        'size'  => 10,
                        'name'  => 'Verdana'
                    )
                );
                $style_num = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    )
                );

                $style_caja = array(
                     'borders' => array(
                         'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK,'color' => array('argb' => '327CCB'),),
                     ),
                     'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => '766f6e'),
                        'size'  => 13,
                        'name'  => 'Verdana'
                    )
                );

                $style_tipo = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    ),
                     'borders' => array(
                         'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK,'color' => array('rgb' => '327CCB'),),
                     ),
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => '0B486B'),
                        'size'  => 13,
                        'name'  => 'Verdana'
                    )
                );

                $style_numbers = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
                    )
                );

                
                
                $objPHPExcel->getActiveSheet()->setCellValue('B2', $this->session->userdata('descrip'));
                $objPHPExcel->getActiveSheet()->getStyle('B2',$this->session->userdata('descrip'))->applyFromArray($titulos);
                $objPHPExcel->getActiveSheet()->mergeCells('B2:G2'); 

                $objPHPExcel->getActiveSheet()->setCellValue('B3', $nombreFormato);
                $objPHPExcel->getActiveSheet()->getStyle('B3',$nombreFormato)->applyFromArray($titulos);
                $objPHPExcel->getActiveSheet()->mergeCells('B3:D3'); 

                $objPHPExcel->getActiveSheet()->setCellValue('E3', $nombreSucursal);
                $objPHPExcel->getActiveSheet()->getStyle('E3',$nombreSucursal)->applyFromArray($titulos);
                $objPHPExcel->getActiveSheet()->mergeCells('E3:G3'); 

                $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Periodo del: '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y'));
                $objPHPExcel->getActiveSheet()->getStyle('B4','Periodo del: '.date_format(date_create($fechaini),'d/m/Y').' al '.date_format(date_create($fechafin),'d/m/Y'))->applyFromArray($titulos);
                $objPHPExcel->getActiveSheet()->mergeCells('B4:G4'); 


                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(70);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);

                $objPHPExcel->getActiveSheet()->SetCellValue('B6', 'Código');
                $objPHPExcel->getActiveSheet()->getStyle('B6',$nombreFormato)->applyFromArray($subtitulos);
                $objPHPExcel->getActiveSheet()->SetCellValue('C6', 'Descripción del Producto');
                $objPHPExcel->getActiveSheet()->getStyle('C6',$nombreFormato)->applyFromArray($subtitulos);
                $objPHPExcel->getActiveSheet()->SetCellValue('D6', 'UM');
                $objPHPExcel->getActiveSheet()->getStyle('D6',$nombreFormato)->applyFromArray($subtitulos);
                $objPHPExcel->getActiveSheet()->SetCellValue('E6', 'Unidades');
                $objPHPExcel->getActiveSheet()->getStyle('E6',$nombreFormato)->applyFromArray($subtitulos);
                $objPHPExcel->getActiveSheet()->SetCellValue('F6', 'Subtotal Costo');
                $objPHPExcel->getActiveSheet()->getStyle('F6',$nombreFormato)->applyFromArray($subtitulos);
                $objPHPExcel->getActiveSheet()->SetCellValue('G6', 'Num. de Envios');
                $objPHPExcel->getActiveSheet()->getStyle('G6',$nombreFormato)->applyFromArray($subtitulos);
                $indiceLetra = 1; //ES LA C A-> 0, B-> 1, C-> 2;
                $indiceNumero = 7; // ES EL NUMERO 4, COMENZARÉ A IMPRIMIR DESDE EL C4
                
                $sum_unidades_tot = 0;
                $sum_costo_tot = 0;
                $sum_envios_tot = 0;
                
                
                foreach($centros as $center){
                    
                    $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, $center->descrip);
                    $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero.':G'.$indiceNumero,$center->descrip)->applyFromArray($style_caja);
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':G'.$indiceNumero); 
                    
                    $indiceNumero++;
                    $indiceNumero++;
                    $indiceLetra = 1;
                    
                    $sum_unidades = 0;
                    $sum_costo = 0;
                    $sum_envios = 0;
                    $info = $this->invtran_model->getProductosEnviados($idcentro,$center->idcentrod,$fechaini,$fechafin);
                    foreach($info as $data){
                        $sum_unidades += abs(round($data->unidades,2));
                        $sum_costo += abs(round($data->costototal,2));
                        $sum_envios += round($data->num_envios,2);
                                
                        $sum_unidades_tot += abs(round($data->unidades,2));
                        $sum_costo_tot += abs(round($data->costototal,2));
                        
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$data->idproducto);
                        $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,$data->idproducto)->applyFromArray($style_num);

                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,trim($data->descrip));
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$data->um);
                        $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,$data->um)->applyFromArray($style_num);
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format(abs($data->unidades), 2, '.', ','));
                        $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($data->unidades), 2, '.', ','))->applyFromArray($style_num);
                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format(abs($data->costototal), 2, '.', ','));
                        $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($data->costototal), 2, '.', ','))->applyFromArray($style_numbers);

                        $indiceLetra++;
                        $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,$data->num_envios);
                        $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,$data->num_envios)->applyFromArray($style_num);

                        $indiceLetra = 1;
                        $indiceNumero ++ ;
                    } 
                    
                    $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, 'SUB-TOTAL '.$center->descrip);
                    $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero.':D'.$indiceNumero,'SUB-TOTAL '.$center->descrip)->applyFromArray($style_totals);
                    $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':D'.$indiceNumero); 
                    
                    $indiceLetra=4;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format($sum_unidades, 2, '.', ','));
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($sum_unidades), 2, '.', ','))->applyFromArray($style_totals_center);

                    $indiceLetra++;
                    $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format($sum_costo, 2, '.', ','));
                    $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($sum_costo), 2, '.', ','))->applyFromArray($style_totals);
                    $indiceLetra = 1;
                    $indiceNumero ++ ;
                    $indiceNumero ++ ;
                }
                $objPHPExcel->getActiveSheet()->setCellValue('B'.$indiceNumero, 'TOTAL ');
                $objPHPExcel->getActiveSheet()->getStyle('B'.$indiceNumero.':D'.$indiceNumero,'TOTAL ')->applyFromArray($style_totals);
                $objPHPExcel->getActiveSheet()->mergeCells('B'.$indiceNumero.':D'.$indiceNumero); 
                        
                $indiceLetra=4;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format($sum_unidades_tot, 2, '.', ','));
                $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($sum_unidades_tot), 2, '.', ','))->applyFromArray($style_totals_center);     
                
                $indiceLetra++;
                $objPHPExcel->getActiveSheet()->SetCellValue($celdas[$indiceLetra].$indiceNumero,number_format($sum_costo_tot, 2, '.', ','));
                $objPHPExcel->getActiveSheet()->getStyle($celdas[$indiceLetra].$indiceNumero,number_format(abs($sum_costo_tot), 2, '.', ','))->applyFromArray($style_totals);
                $indiceLetra = 1;
                $indiceNumero ++ ;
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Traslados.xlsx"');
                header('Cache-Control: max-age=0');
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                $objWriter->save('php://output');
                exit; 
            }
        }
		
        function catalogo_productos($iddep,$idlinea){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('global_model');
                $this->load->model('producto_model');
                $funcion = $this->uri->segment(3);
                $funcion = "central_reports_".$funcion;     
                $nombreFormato = $this->global_model->getFormatosNombre($funcion);
                
				$estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 5px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body>';
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');
                

                $this->load->model('pedclientes_model');
				$this->load->model('global_model');
                $this->load->model('variable_model');
                
                
                $name = $this->pedclientes_model->getnameImg();
                $info_empresa = $this->variable_model->getVariablesNombre("g_empdatos");
                foreach($info_empresa as $emp){
                    switch(round($emp->valor_num)){
                        case 1:
                            $razon = $emp->valor_memo;
                            break;
                        case 3:
                            $nrc = $emp->valor_memo;
                            break;
                        case 4:
                            $nit = $emp->valor_memo;
                            break;
                        case 5:
                            $giro = $emp->valor_memo;
                            break;
                        case 6: 
                            $direccion = $emp->valor_memo;
                            break;
                        case 7:
                            $depto_municipio = $emp->valor_memo;
                            break;
                    }
                }
				$estructura .= '
				<table style="width: 100%;">
                	<thead style="width: 100%;">
                        <tr><th style="font-size:25px;"></th></tr>
                        <tr>
                            <th style="padding:0px;margin:0px;" colspan="5">
                                <table style="padding:0px;margin:0px;">
                                    <tr>
                                        <th style="font-size:15px;"></th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; font-weight: bold; ">'.$razon.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;">'.$direccion.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left;"><b>NIT:</b>'.$nit.' <b>NRC:</b>'.$nrc.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="padding:0px; margin:0px; font-size:10.5px; text-align:left; "><b>GIRO:</b>'.$giro.'</th>
                                    </tr>
                                    <tr style="padding:0px; margin:0px;">
                                        <th style="font-size:12px; text-align:left; font-weight: bold;" colspan="8">'.strtoupper($nombreFormato).'</th>
                                    </tr>
                                </table>
                            </th>
                            <th style="padding:0px;margin:0px;"  colspan="3"><br><img style="text-align:right; width:180px; height:80px;margin-top:-20px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$name.'"></th>
                        </tr>
						<tr style="vertical-align:middle; font-size:12px; border: solid 1px :#0B486B; height:20px;background-color:#E8E8E8;">
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">CODIGO</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">IMAGEN</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:30%; text-align:left; vertical-align:middle; font-weight: bold; font-size:10px;">DESCRIPCION DEL PRODUCTO</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">LINEA</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">MODELO</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">CATEGORIA</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:center; vertical-align:middle; font-weight: bold; font-size:10px;">PRECIO</th>
							<th style="background-color:#E8E8E8; padding: 5px; border-top: solid 1px black; border-bottom: solid 1px black; width:10%; text-align:right; vertical-align:middle; font-weight: bold; font-size:10px;">SALDO</th>
						</tr>
                	</thead>
					<tbody>';
				if($iddep!=99999){
					if($idlinea!=99999){
						$productos = $this->producto_model->viewProductos_Lineas($idlinea);
					}else{
						$productos = $this->producto_model->viewProductos_Depto($iddep);
					}
				}else{
					$productos = $this->producto_model->viewProductos_all();
				}
				
				if($productos!=false){
					foreach($productos as $pro){
							
						if($pro->imagen != ""){
							$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
							$gdImage = FCPATH.'img_cuentas/'.$this->session->userdata('diraccount')."/".$pro->imagen;
							if(file_exists($gdImage)){
								$srcImagen = base_url()."img_cuentas/".$this->session->userdata('diraccount')."/".$pro->imagen;
							}else{
								$srcImagen = base_url()."img/sinImagen.png";
							}
						}else{
							$srcImagen = base_url()."img/sinImagen.png";
						}

						
						$estructura.='<tr>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:left;">'.$pro->id.'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:center;"><img src="'.$srcImagen.'" width="80px" height="40px" style="margin:2px;"></td>
							<td nowrap style="width:30%; font-size:11px; border:1px solid #999; text-align:left;">'.$pro->producto.'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:center">'.$pro->linea.'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:center">'.$pro->modelo.'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:center">'.$pro->departamento.'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:right">'.$this->session->userdata("simboloMoneda").number_format(round($pro->precioventa, 2),2, '.', ',').'</td>
							<td nowrap style="width:10%; font-size:11px; border:1px solid #999; text-align:center">'.number_format(round($pro->saldo, 2),2, '.', ',').'</td>
						</tr>';
					}
				}
				
				
				
                $estructura.='</tbody></table></body></table>';
				
                $estructura .="<script type='text/javascript'>window.print();</script>";
                echo $estructura;
				
            }
        }

        function ordenPedidoDetailPedidos($trannum){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $this->load->model('new_pedidoclientes_model');
                $this->configuracion_model->initGvarsText('pas_wpdf','Ancho pre-ticket (LM,TM,RM)','0,10,18','(LM,TM,RM) tamaño carta = 0,10,18 tamaño ticket alineado a la izquierda = 0,10,115 tamaño ticket centrado = 57.5,10,57.5');
                
                $getAnchoPreTicket = $this->new_pedidoclientes_model->getAnchoPreTicket();
                if($getAnchoPreTicket!=""){
                    $margenes = explode(",",$getAnchoPreTicket['valor_txt']);
                    $LM=$margenes[0];
                    $TM=$margenes[1];
                    $RM=$margenes[2];
                }else{
                    $LM=0;
                    $TM=0;
                    $RM=0;
                }
                
                $this->load->library('Pdf');
                $width = 105;  
                $height = 150;
                $pagelayout = array($width, $height); 
                $pdf = new Pdf('Portait', 'mm', "letter", true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Ticket');
                $pdf->SetSubject('Ticket');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->SetHeaderData('', PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . '', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
                $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins($LM, $TM, $RM);
                $pdf->SetHeaderMargin(0);
                $pdf->SetFooterMargin(0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Portrait');
                $pdf->SetFont('Helvetica', '', 10, '', true);
                $pdf->SetAutoPageBreak(true, 20);
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);
                
                $this->load->model('pedclientes_model');
                $this->load->model('new_pedidoclientes_model');
                $this->load->model('empleado_model');

                $nameImagen = $this->pedclientes_model->getnameImg();
                $informacionCliente = $this->new_pedidoclientes_model->getInfoCierrePedido($trannum); 
                $documento = $this->new_pedidoclientes_model->getDocumento($informacionCliente['idclase']);
                $formaPago = $this->new_pedidoclientes_model->getFormaPago($informacionCliente['cajclase']); 
                $atendidoPor = $this->new_pedidoclientes_model->getAtendidoPor($informacionCliente['idworker']);
                $productos = $this->new_pedidoclientes_model->getDetailProductsPopUp($trannum);
                $servicios = $this->new_pedidoclientes_model->getDetailServiciosPopUp($trannum);
                $informacionEntrega = $this->new_pedidoclientes_model->getInfoDatosEntregaDetallePedido($trannum);
                $zip_info = $this->empleado_model->getDeptoMunicipio($informacionCliente['idzip']);
                $depto_municipio = trim($zip_info['municipio']).', '.trim($zip_info['depto']);
                $background_color = $this->session->userdata('FHBackground');
                $color = $this->session->userdata('FHFontColor');  
                
                if($informacionCliente['dev_place'] == 1){
                    $sucursal=$this->new_pedidoclientes_model->getSucursal($informacionCliente['dev_place']);
                    $direccion=$sucursal['descrip'];
                }else{
                    $direccion=$informacionCliente['dev_direc'];
                }

                $estado = '';
                switch ($informacionCliente['estado']) {
                    case 0:
                        $estado = 'En digitacion';
                        break;
                    case 1:
                        $estado = 'Confirmados';
                        break;
                    case 2:
                        $estado = 'Preparacion';
                        break;
                    case 3:
                        $estado = 'Por facturar';
                        break;
                    case 4:
                        $estado = 'Despacho';
                        break;
                    case 5:
                        $estado = 'Entregados';
                        break;
                    case 6:
                        $estado = 'Reclamos';
                        break;
                    case 9:
                        $estado = 'Anulados';
                        break;
                    
                    default:
                        $estado = 'Sin estado';
                        break;
                }

                $titulo = '
                    <table style="width:100%;">
                        <tr>
                            <td style="padding:0px;margin:0px;width:100%;text-align:center;"><img style="text-align:center; width:210px; height:95px;" src="'.base_url().'img_cuentas/'.$this->session->userdata('diraccount').'/'.$nameImagen.'"></td>
                        </tr>
                        <tr>
                            <td style="padding:0px;margin:0px;width:4%;font-size:20px;"></td>
                            <td style="width:101.2%;text-align:center;"><h3>Pedido No.'.$trannum.'</h3></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101.2%;font-size:10px;text-align:center;">Estado: <strong>'.$estado.'</strong></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101.2%;font-size:10px;text-align:center;">Fecha pedido: <strong>'.$informacionCliente['fecha_creacion'].'</strong></td>
                        </tr>
                        '; 
                
                $titulo .='
                    <tr>
                        <td style="width:100%;"></td>
                    </tr>
                    <tr>
                        <td style="width:4%;"></td>
                        <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>Datos del Cliente</h3></td>
                    </tr>
                ';

                $titulo .='
                    <tr>
                        <td style="width:100%;font-size:5px;"></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Nombre:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$informacionCliente['descrip'].'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Origen del pedido:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$informacionCliente['origenPedido'].'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Telefono:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$informacionCliente['cli_phone'].'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Tipo de documento:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$documento['descrip'].'</strong></td>
                    </tr>
                    
                '; 

                $titulo .='
                        <tr>
                            <td style="width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>Datos de Entrega</h3></td>
                        </tr>
                ';

                $titulo .='
                    <tr>
                        <td style="width:100%;font-size:5px;"></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Fecha de entrega:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$informacionCliente['fecha'].'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Hora de entrega:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$informacionCliente['hora'].'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Lugar de entrega:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$direccion.'</strong></td>
                    </tr>
                    <tr>
                        <td style="padding:0px;margin:0px;width:4%;font-size:10px; text-align:left;"></td>
                        <td style="padding:0px;margin:0px;width:30%;font-size:10px; text-align:right;">Depto/Mpio:</td>
                        <td style="padding:0px;margin:0px;width:1%;font-size:10px; text-align:right;"></td>
                        <td style="padding:0px;margin:0px;width:70%;font-size:10px; text-align:left;"><strong>'.$depto_municipio.'</strong></td>
                    </tr>
                    </table>
                '; 
                //$pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(false);
                //$pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(false);
                
                $pdf->addPage( 'P',"letter");
                $titulo .="<table>";
                $titulo .='
                    <tr>
                        <td style="width:100%;"></td>
                    </tr>
                    <tr>
                        <td style="width:4%;"></td>
                        <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>Productos</h3></td>
                    </tr>
                ';
                $sub_total = 0;
                $precio_descuento = 0;
                foreach($productos as $prod){
                    if($prod->modelo!=""){
                        $descripcionPro=$prod->descrip." / ".$prod->modelo;
                    }else{
                        $descripcionPro=$prod->descrip;
                    }
                    $rutaImagen= "img_cuentas/".$this->session->userdata('diraccount')."/".$prod->imagen;
                    $descuento=($prod->precio*($prod->descuento/100));
                    $precio_descuento=$prod->precio-$descuento;
                    $sub_total=($prod->o_qty*$precio_descuento);
                    $titulo .='
                        <tr>
                            <td style="font-size:5px; width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:40%;text-align: center;"rowspan="6" height="30px"><br><img src="'.base_url().$rutaImagen.'"style:"margin-top:20px;" width="100px" height="100px"></td>
                            <td style="width:61%; font-size:12px;text-align:left;color:#3358FF"><b>'.strtoupper($descripcionPro).'</b></td>
                        </tr>
                        <tr>
                            <td style="width:44%;font-size:10px;"></td>
                            <td style="width:30.5%;font-size:10px;text-align:left;">Codigo: <strong>'.$prod->idproducto.'</strong></td>
                        </tr>
                        <tr>
                            <td style="width:44%;font-size:10px;"></td>
                            <td style="width:30.5%;font-size:10px;text-align:left;">Cantidad: <strong>'.round(number_format($prod->o_qty,2, '.', ','), 2).'</strong></td>
                            <td style="width:30.5%;font-size:10px;text-align:right;">Precio Unitario: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($prod->precio, 2),2, '.', ',').'</strong></td>
                        </tr>
                    ';
                    if($prod->descuento!=0){
                        $titulo .='
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:30.5%;font-size:10px;text-align:left;">Desc('.round(number_format($prod->descuento,2, '.', ','), 2).'%): <strong>'.$this->session->userdata('simboloMoneda')."-".number_format($descuento,2, '.', ',').'</strong></td>
                                <td style="width:30.5%;font-size:10px;text-align:right;">Precio Neto: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($precio_descuento,2),3, '.', ',').'</strong> &nbsp;</td>
                            </tr>
                        ';
                    }
                    $titulo .='
                        <tr>
                            <td style="width:44%;font-size:10px;"></td>
                            <td style="width:61%;font-size:12px;text-align:right;">Sub-Total: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($sub_total, 2),2, '.', ',').'</strong></td>
                        </tr>
                    ';
                    if($prod->notas != ""){
                        $titulo .='
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:61%;font-size:10px;text-align:left;" rowspan="2">Notas: <strong>'.$prod->notas.'</strong></td>
                            </tr>
                            <tr>
                                <td style="width:100%;font-size:10px;"></td>
                            </tr>
                        ';
                    }else{
                        $titulo .='
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:61%;font-size:10px;text-align:left;"></td>
                            </tr>
                            <tr>
                                <td style="width:100%;font-size:10px;"></td>
                            </tr>
                        ';
                    }
                }

                $titulo .="</table>";
                if($servicios){
                    $titulo .="<table>";
                    $titulo .='
                        <tr>
                            <td style="width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>Servicios</h3></td>
                        </tr>
                    ';
                    foreach($servicios as $serv){
                        if($serv->modelo!=""){
                        $descripcionPro=$serv->descrip." / ".$serv->modelo;
                        }else{
                            $descripcionPro=$serv->descrip;
                        }
                        $rutaImagen= "img_cuentas/".$this->session->userdata('diraccount')."/".$serv->imagen;
                        $descuento=($serv->precio*($serv->descuento/100));
                        $precio_descuento=$serv->precio-$descuento;
                        $sub_total=($serv->o_qty*$precio_descuento);
                        $titulo .='
                            <tr>
                                <td style="font-size:5px; width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="width:4%;"></td>
                                <td style="width:40%;text-align: center;"rowspan="6" height="30px"><br><img src="'.base_url().$rutaImagen.'"style:"margin-top:20px;" width="100px" height="100px"></td>
                                <td style="width:61%; font-size:12px;text-align:left;color:#3358FF"><b>'.strtoupper($descripcionPro).'</b></td>
                            </tr>
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:30.5%;font-size:10px;text-align:left;">Codigo: <strong>'.$serv->idproducto.'</strong></td>
                            </tr>
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:30.5%;font-size:10px;text-align:left;">Cantidad: <strong>'.round(number_format($serv->o_qty,2, '.', ','), 2).'</strong></td>
                                <td style="width:30.5%;font-size:10px;text-align:right;">Precio Unitario: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($serv->precio, 2),2, '.', ',').'</strong></td>
                            </tr>
                        ';
                        if($serv->descuento!=0){
                            $titulo .='
                                <tr>
                                    <td style="width:44%;font-size:10px;"></td>
                                    <td style="width:30.5%;font-size:10px;text-align:left;">Desc('.round(number_format($serv->descuento,2, '.', ','), 2).'%): <strong>'.$this->session->userdata('simboloMoneda')."-".number_format($descuento,2, '.', ',').'</strong></td>
                                    <td style="width:30.5%;font-size:10px;text-align:right;">Precio Neto: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($precio_descuento,2),3, '.', ',').'</strong> &nbsp;</td>
                                </tr>
                            ';
                        }
                        $titulo .='
                            <tr>
                                <td style="width:44%;font-size:10px;"></td>
                                <td style="width:61%;font-size:12px;text-align:right;">Sub-Total: <strong>'.$this->session->userdata('simboloMoneda').number_format(round($sub_total, 2),2, '.', ',').'</strong></td>
                            </tr>
                        ';
                        if($serv->notas != ""){
                            $titulo .='
                                <tr>
                                    <td style="width:44%;font-size:10px;"></td>
                                    <td style="width:61%;font-size:10px;text-align:left;" rowspan="2">Notas: <strong>'.$serv->notas.'</strong></td>
                                </tr>
                                <tr>
                                    <td style="width:100%;font-size:10px;"></td>
                                </tr>
                            ';
                        }else{
                            $titulo .='
                                <tr>
                                    <td style="width:44%;font-size:10px;"></td>
                                    <td style="width:61%;font-size:10px;text-align:left;"></td>
                                </tr>
                                <tr>
                                    <td style="width:100%;font-size:10px;"></td>
                                </tr>
                            ';
                        }
                    }
                    $titulo .="</table>";
                }

                if($informacionCliente['notas']!=""){
                    $titulo .='
                        <table>
                            <tr>
                                <td style="width:100%;"></td>
                            </tr>
                            <tr>
                                <td style="width:4%;"></td>
                                <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>Observaciones</h3></td>
                            </tr>
                            <tr>
                                <td style="width:100%;font-size:5px;"></td>
                            </tr>
                            <tr>
                                <td style="width:4%;"></td>
                                <td style="width:101%;font-size:10px;text-align:left;"><strong>'.$informacionCliente['notas'].'</strong> &nbsp;</td>
                            </tr>
                        </table>
                    '; 
                }

                $totalProductos= $this->new_pedidoclientes_model->getTotalOrdenProductos($trannum);
                $totalServicios= $this->new_pedidoclientes_model->getTotalOrdenServicios($trannum);
                $total= $this->new_pedidoclientes_model->getTotalOrden($trannum);

                $titulo .='<table>';
                        $titulo .='
                        <tr>
                            <td style="width:100%;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101%;text-align:center;background-color:'.$background_color.';color:'.$color.';"><h3>TOTALES</h3></td>
                        </tr>
                        <tr>
                            <td style="width:100%;font-size:5px;text-align:right;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:50.5%;font-size:10px;text-align:right;">FORMA DE PAGO: &nbsp;</td>
                            <td style="width:50%;font-size:10px;text-align:right;"><strong>'.$formaPago['descrip'].'</strong> &nbsp;</td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:50.5%;font-size:10px;text-align:right;">TOTAL PRODUCTOS:</td>
                            <td style="width:50%;font-size:10px;text-align:right;"><strong>'.$this->session->userdata('simboloMoneda').number_format(round($totalProductos['total'], 2),2, '.', ',').'</strong> &nbsp;</td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:50.5%;font-size:10px;text-align:right;">TOTAL SERVICIOS:</td>
                            <td style="width:50%;font-size:10px;text-align:right;"><strong>'.$this->session->userdata('simboloMoneda').number_format(round($totalServicios['total'], 2),2, '.', ',').'</strong> &nbsp;</td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:50.5%;font-size:10px;text-align:right;">TOTAL:</td>
                            <td style="width:50%;font-size:10px;text-align:right;"><strong>'.$this->session->userdata('simboloMoneda').number_format(round($total['total'], 2),2, '.', ',').'</strong>&nbsp;</td>
                        </tr>
                        <tr>
                            <td style="width:100%;font-size:10px;text-align:center;"></td>
                        </tr>
                        <tr>
                            <td style="width:4%;"></td>
                            <td style="width:101%;font-size:10px;text-align:center;">ATENDIDO POR: <strong>'.strtoupper($atendidoPor['descrip']).'</strong></td>
                        </tr>
                    ';
                $titulo .='</table>';
                
                $pdf->writeHTML($titulo, true, false, true, false, '');
                $nombre_archivo = utf8_decode("PedidosClientes.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        function exportProductosTXT(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $archivoTxt = fopen("ListadoProductos.txt",'w+');

                $this->load->model('producto_model');
                $infoProductos = $this->producto_model->getListadoProductosTxt();

                foreach($infoProductos as $info){
                    $Multiprecios = '';
                    $multiprecios = $this->producto_model->getRegistrosMultiGoB($info->idproducto, 1);
                    if (count($multiprecios) > 0) {
                        $Multiprecios = array_map(function($o) { 

                            if($this->session->userdata('idaccount')== '2100661' && ($o['descripcion'] == 'E' || $o['descripcion'] == 'e')){
                                return $o['descripcion'].' '.$this->codificarPrecioFacini(number_format($o['precio'], 2, '.', '')); 

                            }else{
                                return $o['descripcion'].' '.number_format($o['precio'], 2, '.', '');
                            }

                        }, $multiprecios);
                        $Multiprecios = implode("|", $Multiprecios);
                    }
                    
                    $contenidoTxt = ''.$info->idproducto.','.str_replace(',', '', $info->descrip).','.$info->modelo.','.number_format($info->precioventa, 2, '.', '').','.$info->marca.','.$info->xpos.','.$Multiprecios;
                    fwrite($archivoTxt, $contenidoTxt);
                    fwrite($archivoTxt, "\r\n");
                }
                
                fclose($archivoTxt);

                $nameFile = "ListadoProductos.txt";
                
                if(file_exists($nameFile)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($nameFile).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($nameFile));
                    readfile($nameFile);
                    unlink('ListadoProductos.txt');
                    exit;
                }
            }
        }

        //CODIFICAR PRECIO FACINI
        function codificarPrecioFacini($precio){
            $numeros = array('1','2','3','4','5','6','7','8','9','0');
            $letras  = array('V','O','L','K','S','W','A','G','E','N');
            
            return(str_replace($numeros, $letras, $precio));

            //var_dump($caracteres);
            //var_dump($llave);
        }
		
        function exportLibroCompras($fechaini, $fechafin, $idcentro, $idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$idaccount = $this->session->userdata('idaccount');
                $dteDocums = ( $idaccount == '1492935' || $idaccount == '3317013' || $idaccount = '2358362' ) ? 1 : 0;
                
				$archivoTxt = fopen("ListadoIvaCompras.txt",'w+');

                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $informacion = $this->iva_model->getComprasContribuyentes($fechaini, $fechafin, $idcentro, str_replace("_", ",", $idclases));
				
				if($informacion != false){
					foreach($informacion as $info){
						$exento=0; $gravado=0;

						if($info->exento==1){
							$exento = $info->valcosto;
						}else{
							$gravado = $info->valcosto;
						}
					
						#$contenidoTxt = '03;'.$info->idcenxpos.';'.$info->idcajxpos.';0001;'.str_replace(';', '', $info->serie).';'.$info->nrc.';'.str_replace(';', '', $info->namecliente).';'.$info->fecha.';'.$info->fecha.';'.$info->referencia.';'.$exento.';0;0;'.$gravado.';0;0;'.$info->valtax1.';'.$info->valtax5.';0;0;0;'.$info->nit.';'.str_replace(';', '', $info->direccion).';'.str_replace(';', '', $info->municipio).';'.str_replace(';', '', $info->departamento).';'.str_replace(';', '', $info->giro);
						$contenidoTxt = '03;'.trim($info->idcenxpos).';;'.trim($info->idclaxpos).';'.trim(str_replace(';', '', $info->serie)).';'.$info->numero.';'.trim(ltrim($info->nrc, '0')).';'.trim(str_replace(';', '', $info->namecliente)).';'.$info->fecha.';'.$info->fecha.';'.trim($info->referencia).';'.$exento.';0;0;'.$gravado.';0;0;'.$info->valtax1.';'.$info->valtax5.';0;0;0;'.trim($info->nit).';'.trim(str_replace(';', '', $info->direccion)).';'.trim(str_replace(';', '', $info->municipio)).';'.trim(str_replace(';', '', $info->departamento)).';'.trim(str_replace(';', '', $info->giro));
                        if ( $dteDocums == 1 ) {
                            $this->load->model('dte_model');
                            $infoDte = $this->dte_model->validateExistDocumentDte($info->trannum);
                            if ($infoDte) {
                                $contenidoTxt .= ';'.trim(str_replace(';', '', $infoDte->cgeneracion)).';'.trim(str_replace(';', '', $infoDte->srecepcion)).';'.trim(str_replace(';', '', $info->ovnumero));
                            } else $contenidoTxt .= ';;;'.trim(str_replace(';', '', $info->ovnumero));
                        } else $contenidoTxt .= ';;;'.trim(str_replace(';', '', $info->ovnumero));

						fwrite($archivoTxt, $contenidoTxt);
						fwrite($archivoTxt, "\r\n");
					}
				}

				fclose($archivoTxt);

                $nameFile = "ListadoIvaCompras.txt";
                
                if(file_exists($nameFile)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($nameFile).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($nameFile));
                    readfile($nameFile);
                    unlink('ListadoIvaCompras.txt');
                    exit;
                }
			}
        }
        
        function exportLibroVentasCF($fechaini, $fechafin, $idcentro, $idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$idaccount = $this->session->userdata('idaccount');
                $dteDocums = ( $idaccount == '1492935' || $idaccount == '3317013' || $idaccount = '2358362' ) ? 1 : 0;

				$archivoTxt = fopen("LibroIvaVentasConsumidorFinal.txt",'w+');

                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $informacion = $this->iva_model->getVentasCGoIva($fechaini, $fechafin, $idcentro, str_replace("_", ",", $idclases));
				
				if ( $informacion != false ) {
					foreach ( $informacion as $info ) {
						$total = 0; $totalGravado = 0; $totalExento = 0;
                        $totalIVA = 0; $invexento = $info->exento;
                        
                        $productos = $this->invtran_model->getDataTran100kGoIva($info->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }
					
						#$contenidoTxt = '03;'.$info->idcenxpos.';'.$info->idcajxpos.';0001;'.str_replace(';', '', $info->serie).';'.$info->nrc.';'.str_replace(';', '', $info->namecliente).';'.$info->fecha.';'.$info->fecha.';'.$info->referencia.';'.$exento.';0;0;'.$gravado.';0;0;'.$info->valtax1.';'.$info->valtax5.';0;0;0;'.$info->nit.';'.str_replace(';', '', $info->direccion).';'.str_replace(';', '', $info->municipio).';'.str_replace(';', '', $info->departamento).';'.str_replace(';', '', $info->giro);
						$contenidoTxt = '01;'.trim($info->idcenxpos).';'.$info->idcajxpos.';'.trim($info->idclaxpos).';'.trim(str_replace(';', '', $info->serie)).';'.$info->numero.';'.trim(ltrim($info->nrc, '0')).';'.trim(str_replace(';', '', $info->namecliente)).';'.$info->fecha.';'.$info->fecha.';'.$info->numz.';'.$totalExento.';0;0;'.$totalGravado.';0;0;'.$totalIVA.';0;0;0;0;'.trim($info->nit).';'.trim(str_replace(';', '', $info->direccion)).';'.trim(str_replace(';', '', $info->municipio)).';'.trim(str_replace(';', '', $info->departamento)).';'.trim(str_replace(';', '', $info->giro));
						if ( $dteDocums == 1 ) {
                            $this->load->model('dte_model');
                            $infoDte = $this->dte_model->validateExistDocumentDte($info->trannum);
                            if ($infoDte) {
                                $contenidoTxt .= ';'.trim(str_replace(';', '', $infoDte->cgeneracion)).';'.trim(str_replace(';', '', $infoDte->srecepcion));
                            } else $contenidoTxt .= ';;';
                        } else $contenidoTxt .= ';;';

                        fwrite($archivoTxt, $contenidoTxt);
						fwrite($archivoTxt, "\r\n");
					}
				}

				fclose($archivoTxt);

                $nameFile = "LibroIvaVentasConsumidorFinal.txt";
                
                if(file_exists($nameFile)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($nameFile).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($nameFile));
                    readfile($nameFile);
                    unlink('LibroIvaVentasConsumidorFinal.txt');
                    exit;
                }
			}
        }
        
        function exportLibroVentasCCF($fechaini, $fechafin, $idcentro, $idclases){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
				$idaccount = $this->session->userdata('idaccount');
                $dteDocums = ( $idaccount == '1492935' || $idaccount == '3317013' || $idaccount = '2358362' ) ? 1 : 0;

				$archivoTxt = fopen("LibroIvaVentasContribuyentes.txt",'w+');

				$this->load->model('iva_model');
				$this->load->model('invtran_model');
                $informacion = $this->iva_model->getVentasContribuyentes($fechaini, $fechafin, $idcentro, str_replace("_", ",", $idclases));
				
				if($informacion != false){
					foreach($informacion as $info){
						$total = 0; $totalGravado = 0; $totalExento = 0;
                        $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                        
                        $productos = $this->invtran_model->getDataTran100kGoIva($info->trannum);
                        
                        foreach($productos as $pro){
                            if($pro->tipotax != 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                                $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                                $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax != 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax== 0 && $invexento == 0){
                                $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }else if($pro->tipotax == 0 && $invexento == 1){
                                $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                                $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                            }
                        }

                        if(($info->idtipo == 3) && ($totalGravado >= 100)){
                            $reten = $totalGravado * 0.01;
                            $retencion = number_format(round($reten, 4), 2);
                            $total = $total - $reten;
                        }
					
						#$contenidoTxt = '03;'.$info->idcenxpos.';'.$info->idcajxpos.';0001;'.str_replace(';', '', $info->serie).';'.$info->nrc.';'.str_replace(';', '', $info->namecliente).';'.$info->fecha.';'.$info->fecha.';'.$info->referencia.';'.$exento.';0;0;'.$gravado.';0;0;'.$info->valtax1.';'.$info->valtax5.';0;0;0;'.$info->nit.';'.str_replace(';', '', $info->direccion).';'.str_replace(';', '', $info->municipio).';'.str_replace(';', '', $info->departamento).';'.str_replace(';', '', $info->giro);
						$contenidoTxt = '02;'.trim($info->idcenxpos).';'.$info->idcajxpos.';'.trim($info->idclaxpos).';'.trim(str_replace(';', '', $info->serie)).';'.$info->numero.';'.trim(ltrim($info->nrc, '0')).';'.trim(str_replace(';', '', $info->namecliente)).';'.$info->fecha.';'.$info->fecha.';'.$info->numz.';'.$totalExento.';0;0;'.$totalGravado.';0;0;'.$totalIVA.';'.$retencion.';0;0;0;'.trim($info->nit).';'.trim(str_replace(';', '', $info->direccion)).';'.trim(str_replace(';', '', $info->municipio)).';'.trim(str_replace(';', '', $info->departamento)).';'.trim(str_replace(';', '', $info->giro));
						if ( $dteDocums == 1 ) {
                            $this->load->model('dte_model');
                            $infoDte = $this->dte_model->validateExistDocumentDte($info->trannum);
                            if ($infoDte) {
                                $contenidoTxt .= ';'.trim(str_replace(';', '', $infoDte->cgeneracion)).';'.trim(str_replace(';', '', $infoDte->srecepcion));
                            } else $contenidoTxt .= ';;';
                        } else $contenidoTxt .= ';;';

                        fwrite($archivoTxt, $contenidoTxt);
						fwrite($archivoTxt, "\r\n");
					}
				}

				fclose($archivoTxt);

                $nameFile = "LibroIvaVentasContribuyentes.txt";
                
                if(file_exists($nameFile)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($nameFile).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($nameFile));
                    readfile($nameFile);
                    unlink('LibroIvaVentasContribuyentes.txt');
                    exit;
                }
			}
		}
        
        /*
        function exportLibroVentasExcelFV7($fechaini, $fechafin, $idcentro, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                require_once APPPATH . 'libraries/Classes/PHPExcel.php';
                require_once APPPATH . 'libraries/Classes/PHPExcel/Reader/Excel2007.php';

                $objPHPExcel = new PHPExcel();
                $objPHPExcel->getProperties()->setCreator("Versanet Sistemas")
                    ->setLastModifiedBy("Versanet Sistemas")
                    ->setTitle("Libro Ventas Contribuyentes FV-7")
                    ->setSubject("Libro Ventas Contribuyentes FV-7")
                    ->setDescription("Libro Ventas Contribuyentes FV-7")
                    ->setKeywords("Libro Ventas Contribuyentes FV-7")
                    ->setCategory("Libro Ventas Contribuyentes FV-7");

                $tituloReporte = "Libro Ventas Contribuyentes FV-7";
                
                $this->load->model('iva_model');
                $informacion = $this->iva_model->getVentasFV7Contribuyentes($fechaini, $fechafin, $idcentro, $idclases);

                $idxNum=1;
                foreach($informacion as $info){
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A'.$idxNum, $info->fecha);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B'.$idxNum, $info->idclase);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('C'.$idxNum, $info->tipodoc);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('D'.$idxNum, $info->resolucion);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('E'.$idxNum, $info->serie);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$idxNum, $info->numero);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$idxNum, $info->numero);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$idxNum, $info->nit);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$idxNum, $info->razonsocial);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('J'.$idxNum, $info->exentas);
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('K'.$idxNum, number_format(0, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('L'.$idxNum, number_format($info->gravado, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('M'.$idxNum, number_format($info->iva, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('N'.$idxNum, number_format(0, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('O'.$idxNum, number_format(0, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('P'.$idxNum, number_format($info->total, 2, '.', ''));
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue('Q'.$idxNum, 1);
                    
                    $idxNum++;
                }

                for($idx='A'; $idx<='Q'; $idx++){
                    $objPHPExcel->setActiveSheetIndex(0)->getColumnDimension($idx)->setAutoSize(TRUE);
                }

                $objPHPExcel->getActiveSheet()->setTitle('Libro Ventas Contribuyentes FV-7');
                $objPHPExcel->setActiveSheetIndex(0);
                
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment;filename="Libro Ventas Contribuyentes FV-7.xlsx"');
                header('Cache-Control: max-age=0');
                
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                $objWriter->save('php://output');
                exit;
            }
        }
        */
        
        function exportLibroVentasContribuyentesF07($fechaini, $fechafin, $idcentro, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $information = $this->iva_model->getVentasContribuyentes($fechaini, $fechafin, $idcentro, $idclases);

                $archivoTxt = fopen("LibroVentasContribuyentes.csv",'w+');
                
                foreach($information as $info){
                    $total = 0; $totalGravado = 0; $totalExento = 0;
                    $totalIVA = 0; $invexento = $info->exento; $retencion = 0;
                    $productos = $this->invtran_model->getDataTran100k($info->trannum);
                    
                    // $datosExtra = explode(',', $info->doc_clase);

                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }
                    }

                    if(($info->idtipo == 3) && ($totalGravado >= 100)){
                        $reten = $totalGravado * 0.01;
                        $retencion = number_format(round($reten, 4), 2);
                        $total = $total - $reten;
                    }
                    
                    $array = array(
                        date_format(date_create($info->fecha), 'd/m/Y'),
                        '1',
                        str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                        str_replace('-', '', $info->resolucion),
                        $info->serie,
                        $info->numero,
                        $info->numero,
                        str_replace('-', '', $info->nit),
                        $info->namecliente,
                        number_format($totalExento, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($totalGravado, 2, '.', ''),
                        number_format($totalIVA, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($total, 2, '.', ''),
                        ($info->nit == '') ? str_replace('-', '', $info->dui) : '',
                        // $datosExtra[0],
                        // $datosExtra[1],
                        '1'
                    );

                    //$contenidoHeader = date_format(date_create($info->fecha)).';01;'.$info->xpos.';'.str_replace('-', '', $info->resolucion).';'.$info->serie.';'.$info->numero.';'.$info->numero.';'.str_replace('-', '', $info->nit).';'.$info->namecliente.';'.number_format($totalExento, 2, '.', '').';'.number_format(0, 2, '.', '').';'.number_format($totalGravado, 2, '.', '').';'.$number;
                    $contenidoHeader = implode(';', $array);
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }

                fclose($archivoTxt);

                $docTxt = "LibroVentasContribuyentes.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function exportLibroVentasConsumidorF07($fechaini, $fechafin, $idcentro, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $information = $this->iva_model->getVentasC($fechaini, $fechafin, $idcentro, $idclases);
                
                $archivoTxt = fopen("LibroVentasConsumidorFinal.csv",'w+');

                $idCajaxpos = "";
                $numeroInicial = 0; $numeroFinal = 0; $serieDocumentos = ""; $numResolucion = "";
                $total = 0; $totalGravado = 0; $totalExento = 0; $valFecha = ""; $valIvabook = "";
                $totalIVA = 0; $i = 0;

                foreach($information as $info){
                    $invexento = $info->exento;

                    $datosExtra = explode(',', $info->doc_clase);
                    
                    if( $i == 0 ) $numeroInicial = $info->numero; 
                    
                    if($serieDocumentos != $info->serie && $i != 0){
                        $array = array(
                            date_format(date_create($valFecha), 'd/m/Y'),
                            '1',
                            str_pad($valIvabook, 2, '0', STR_PAD_LEFT),
                            str_replace('-', '', $numResolucion),
                            $serieDocumentos,
                            $numeroInicial,
                            $numeroFinal,
                            $numeroInicial,
                            $numeroFinal,
                            ($valIvabook == 10) ? $idCajaxpos : '',
                            number_format($totalExento, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($totalGravado + $totalIVA, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($total, 2, '.', ''),
                            $datosExtra[0],
                            $datosExtra[1],
                            '2'
                        );
    
                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $total = 0; $totalGravado = 0; $totalExento = 0;
                        $totalIVA = 0; $i = 0;
                    }

                    if( $i == 0 ) $numeroInicial = $info->numero;

                    $productos = $this->invtran_model->getDataTran100k($info->trannum);
                    
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * ($pro->cantidad * -1));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * ($pro->cantidad * -1));
                            $totalGravado = $totalGravado + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * ($pro->cantidad * -1)));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * ($pro->cantidad * -1));
                            $totalExento = $totalExento + $pro->precioneto * ($pro->cantidad * -1);
                        }
                    }
                    
                    $i++;
                    $numeroFinal     = $info->numero;
                    $serieDocumentos = $info->serie;
                    $numResolucion   = $info->resolucion;
                    $valFecha        = $info->fecha;
                    $valIvabook      = $info->ivabook;
                    $idCajaxpos      = $info->idcajxpos;
                }

                $array = array(
                    date_format(date_create($info->fecha), 'd/m/Y'),
                    '1',
                    str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                    str_replace('-', '', $info->resolucion),
                    $serieDocumentos,
                    $numeroInicial,
                    $numeroFinal,
                    $numeroInicial,
                    $numeroFinal,
                    ($info->ivabook == 10) ? $info->idcajxpos : '',
                    number_format($totalExento, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format($totalGravado + $totalIVA, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format($total, 2, '.', ''),
                    '2'
                );

                $contenidoHeader = implode(';', $array);
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                fclose($archivoTxt);

                $docTxt = "LibroVentasConsumidorFinal.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function exportLibroVentasConsumidorRetencionF07($fechaini, $fechafin, $idcentro, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('invtran_model');
                $information = $this->iva_model->getVentasC($fechaini, $fechafin, $idcentro, $idclases);
                
                $archivoTxt = fopen("LibroVentasConsumidorFinal.csv",'w+');

                $numeroInicial = 0; $numeroFinal = 0; $serieDocumentos = "";
                $total = 0; $totalGravado = 0; $totalExento = 0;
                $totalIVA = 0; $i = 0;

                foreach($information as $info){
                    $invexento = $info->exento;
                    
                    if( $i == 0 ) $numeroInicial = $info->numero; 
                    
                    if($serieDocumentos != $info->serie && $i != 0){
                        $array = array(
                            date_format(date_create($info->fecha), 'd/m/Y'),
                            '1',
                            str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                            str_replace('-', '', $info->resolucion),
                            $serieDocumentos,
                            $numeroInicial,
                            $numeroFinal,
                            $numeroInicial,
                            $numeroFinal,
                            $info->equipo,
                            number_format($totalExento, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($totalGravado + $totalIVA, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($total, 2, '.', ''),
                            '2'
                        );
    
                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");

                        $total = 0; $totalGravado = 0; $totalExento = 0;
                        $totalIVA = 0; $i = 0;
                    }

                    $productos = $this->invtran_model->getDataTran100k($info->trannum);
                    
                    foreach($productos as $pro){
                        if($pro->tipotax != 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto + ($pro->precioneto * ($pro->tipotax / 100))) * abs($pro->cantidad));
                            $totalIVA = $totalIVA + (($pro->precioneto * ($pro->tipotax / 100)) * abs($pro->cantidad));
                            $totalGravado = $totalGravado + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax != 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto * abs($pro->cantidad)));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax== 0 && $invexento == 0){
                            $total = $total + (($pro->precioneto) * abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }else if($pro->tipotax == 0 && $invexento == 1){
                            $total = $total + (($pro->precioneto) * Math.abs($pro->cantidad));
                            $totalExento = $totalExento + $pro->precioneto * abs($pro->cantidad);
                        }
                    }
                    
                    $i++;
                    $numeroFinal     = $info->numero;
                    $serieDocumentos = $info->serie;
                }

                $array = array(
                    date_format(date_create($info->fecha), 'd/m/Y'),
                    '1',
                    str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                    str_replace('-', '', $info->resolucion),
                    $serieDocumentos,
                    $numeroInicial,
                    $numeroFinal,
                    $numeroInicial,
                    $numeroFinal,
                    $info->equipo,
                    number_format($totalExento, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format($totalGravado + $totalIVA, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format(0, 2, '.', ''),
                    number_format($total, 2, '.', ''),
                    '2'
                );

                $contenidoHeader = implode(';', $array);
                fwrite($archivoTxt, $contenidoHeader);
                fwrite($archivoTxt, "\r\n");

                fclose($archivoTxt);

                $docTxt = "LibroVentasConsumidorFinal.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function exportLibroComprasF07($fechaini, $fechafin, $idcentro, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                $information = $this->iva_model->getComprasContribuyentes($fechaini, $fechafin, $idcentro, $idclases);
                
                $archivoTxt = fopen("LibroIVACompras.csv", 'w+');

                foreach($information as $info){
                    $exento=0; $gravado=0;

                    if($info->exento==1){
                        $exento = $info->valcosto;
                    }else{
                        $gravado = $info->valcosto;
                    }
                    $iva=$info->valtax1;

                    $docAct = array(
                        $this->iva_model->getValorGvarDefault('iva_tipoo'),
                        $this->iva_model->getValorGvarDefault('iva_clas'),
                        $this->iva_model->getValorGvarDefault('iva_sect'),
                        $this->iva_model->getValorGvarDefault('iva_tipoc')
                    );

                    $infoDTE = $this->dte_model->validateExistDocumentDte($info->trannum);

                    if ( !$infoDTE ) {
                        $numeroDocumento = $info->numero;
                    } else {
                        $numeroDocumento = str_replace('-', '', $infoDTE->cgeneracion);
                    }
                    
                    $array = array(
                        date_format(date_create($info->fecha), 'd/m/Y'),
                        '1',
                        str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                        $numeroDocumento,
                        str_replace('-', '', $info->nit),
                        $info->namecliente,
                        number_format($exento, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($gravado, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($iva, 2, '.', ''),
                        number_format($exento+$gravado+$iva, 2, '.', ''),
                        // str_replace('-', '', $info->dui),
                        ($info->nit == '') ? str_replace('-', '', $info->dui) : '',
                        $docAct[0],
                        $docAct[1],
                        $docAct[2],
                        $docAct[3],
                        '3'
                    );

                    $contenidoHeader = implode(';', $array);
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVACompras.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        /*--------------------------------------IVA CENTRAL DOCUMENTOS--------------------------------------*/
        function documentCSVContribuyentes($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);

                $archivoTxt = fopen("LibroVentasContribuyentes.csv",'w+');
                
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {          
                        if ( strpos($info->doc_serie, 'DTE') === false ) {
                            $docResolucion   = str_replace('-', '', $info->doc_res);
                            $serieDocumento  = $info->doc_serie;
                            $numeroDocumento = $info->doc_numero;
                            $numeroInterno   = $info->doc_numero;
                            $documentClase   = $info->doc_clase;
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);

                            if (!$infoDTE) {
                                $trannum = $this->iva_model->getTrannumDocumentImport($info->doc_serie, $info->doc_numero, $info->idcentro, $info->idcaja);
                                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);
                            }

                            if ($infoDTE) {
                                $docResolucion   = str_replace('-', '', $infoDTE->ncontrol);
                                $serieDocumento  = str_replace('-', '', $infoDTE->srecepcion);
                                $numeroDocumento = str_replace('-', '', $infoDTE->cgeneracion);
                                $numeroInterno   = '';
                                $documentClase   = 4;
                            } else continue;
                        }

                        $infoExt = explode(',', $info->docClase);

                        if (abs($info->valor3) != 0) {
                            $tipoOperacion = 3;
                        }else {
                            if (abs($info->valor1) != 0 && abs($info->valor2) == 0) {
                                $tipoOperacion = 1;
                            } else if (abs($info->valor1) != 0 && abs($info->valor2) != 0) {
                                $tipoOperacion = 4;
                            } else if (abs($info->valor1) == 0 && abs($info->valor2) != 0) {
                                $tipoOperacion = 2;
                            } else {
                                $tipoOperacion = 1;
                            }
                        }

                        $infoComplete = (str_replace('-', '', $info->nrc) == '' ) ? str_replace('-', '', $info->nit) : str_replace('-', '', $info->nrc);

                        $array = array(
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            $documentClase,
                            str_pad($info->doc_tipo, 2, '0', STR_PAD_LEFT),
                            $docResolucion,
                            $serieDocumento,
                            $numeroDocumento,
                            $numeroInterno,
                            (str_replace('-', '', $info->nrc) == '' ) ? str_replace('-', '', $info->nit) : str_replace('-', '', $info->nrc),
                            $info->namecliente,
                            number_format(abs($info->valor2), 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(abs($info->valor1), 2, '.', ''),
                            number_format(abs($info->valor0), 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format((abs($info->valor0)+abs($info->valor1)+abs($info->valor2)+abs($info->valor3)+$info->valor4+abs($info->valor5)), 2, '.', ''),
                            ($infoComplete == '') ? str_replace('-', '', $info->dui) : '',
                            $tipoOperacion,
                            $infoExt[1],
                            '1',
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroVentasContribuyentes.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function documentCSVConsumidorFinalGeneral($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '400');
                
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroVentasConsumidorFinal.csv",'w+');

                if ($data->num_rows() > 0) {
                    $totalValor2   = 0; $totalValor3 = 0; $totalValor01 = 0;
                    $totalValor510 = 0; $totalValor9 = 0; $totalValor13 = 0;
                    $totalGeneral  = 0; $numeroInicialInt = 0; $numeroFinalInt = 0;
                    $numeroInicial = 0; $numeroFinal = 0; $valFecha = "";
                    $serieDocumentos = ""; $numResolucion = ""; $i = 0; $valDocTipo = "";
                    $serieDocumentoD = ""; $tipoOperacion = 0; $tipoIngreso = 0;
                    $esTicket = 0;

                    foreach ($data->result() as $info) {
                        //$esTicket = (int) $info->esticket;

                        if ( strpos($info->doc_serie, 'DTE') === false ) {
                            $docResolucion   = str_replace('-', '', $info->doc_res);
                            $docSerie        = $info->doc_serie;
                            $docSerieDiff    = $info->doc_serie;
                            $numeroDocumento = $info->doc_numero;
                            $documentClase   = $info->doc_clase;

                            $numDocs = explode('|', $info->doc_numero);
                            if ( count($numDocs) > 1 ) { 
                                $numeroInicial = $numDocs[0]; $numeroFinal = $numDocs[1]; 
                            } else { 
                                $numeroInicialInt = $numeroDocumento;
                                $numeroFinalInt   = $numeroDocumento; 
                                $numeroInicial    = $numeroDocumento;
                                $numeroFinal      = $numeroDocumento; 
                            }
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);

                            if (!$infoDTE) {
                                $trannum = $this->iva_model->getTrannumDocumentImport($info->doc_serie, $info->doc_numero, $info->idcentro, $info->idcaja);
                                $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                if ($infoDTE) {
                                    $docResolucion   = 'N/A';
                                    $docSerie        = 'N/A';
                                    $docSerieDiff    = 'N/A';
                                    $numeroDocumento = $infoDTE->cgeneracion;
                                    $documentClase   = 4;

                                    $numeroInicialInt = 'N/A';
                                    $numeroFinalInt   = 'N/A';
                                    $numeroInicial    = $numeroDocumento;
                                    $numeroFinal      = $numeroDocumento;
                                } else continue;
                            }
                        }

                        if ( $i == 0 ) {
                            $numInicialInt = $numeroInicialInt;
                            $numInicial = $numeroInicial;
                        }
                    
                        if (($serieDocumentoD != $docSerieDiff && $i != 0) || ($valFecha != $info->doc_fecha && $i != 0) || ($numResolucion != $docResolucion && $i != 0)) {
                            $infoExt = explode(',', $info->docClase);
                            //var_dump($infoExt);

                            if ($totalValor3 != 0) {
                                $tipoOperacion = 3;
                            }else {
                                if ($totalValor01 != 0 && $totalValor2 == 0) {
                                    $tipoOperacion = 1;
                                } else if ($totalValor01 != 0 && $totalValor2 != 0) {
                                    $tipoOperacion = 4;
                                } else if ($totalValor01 == 0 && $totalValor2 != 0) {
                                    $tipoOperacion = 2;
                                } else {
                                    $tipoOperacion = 1;
                                }
                            }

                            $array = array(
                                date_format(date_create($valFecha), 'd/m/Y'),
                                $documentClase,
                                str_pad($valDocTipo, 2, '0', STR_PAD_LEFT),
                                trim(str_replace('-', '', $numResolucion)),
                                trim($serieDocumentos),
                                $numInicialInt,
                                $numFinalInt,
                                $numInicial,
                                $numFinal,
                                ($valDocTipo == 10) ? $info->xpos : '',
                                number_format($totalValor2, 2, '.', ''),
                                number_format(0, 2, '.', ''),
                                number_format($totalValor3, 2, '.', ''),
                                number_format($totalValor01, 2, '.', ''),
                                number_format($totalValor510, 2, '.', ''),
                                number_format(0, 2, '.', ''),
                                number_format($totalValor9, 2, '.', ''),
                                number_format($totalValor13, 2, '.', ''),
                                number_format(0, 2, '.', ''),
                                number_format($totalGeneral, 2, '.', ''),
                                $tipoOperacion,
                                ($esTicket != 1) ? $infoExt[1] : 3,
                                '2'
                            );

                            $contenidoHeader = implode(';', $array);
                            fwrite($archivoTxt, $contenidoHeader);
                            fwrite($archivoTxt, "\r\n");

                            $totalValor2   = 0; $totalValor3 = 0; $totalValor01 = 0;
                            $totalValor510 = 0; $totalValor9 = 0; $totalValor13 = 0;
                            $totalGeneral  = 0; $i = 0;
                        }

                        if ( $i == 0 ) {
                            $numInicialInt = $numeroInicialInt;
                            $numInicial = $numeroInicial;
                        }

                        $totalValor2   = $totalValor2 + $info->valor2;
                        $totalValor3   = $totalValor3 + $info->valor3;
                        $totalValor01  = $totalValor01 + ($info->valor0+$info->valor1);
                        $totalValor510 = $totalValor510 + ($info->valor5+$info->valor10);
                        $totalValor9   = $totalValor9 + $info->valor9;
                        $totalValor13  = $totalValor13 + $info->valor13;
                        $totalGeneral  = $totalGeneral + ($info->valor0+$info->valor1+$info->valor2+$info->valor3+$info->valor4+$info->valor5+$info->valor10);

                        $i++;
                        $numFinal        = $numeroFinal;
                        $numFinalInt     = $numeroFinalInt;
                        $serieDocumentos = $docSerie;
                        $serieDocumentoD = $docSerieDiff;
                        $numResolucion   = $docResolucion;
                        $valFecha        = $info->doc_fecha;
                        $valDocTipo      = $info->doc_tipo;
                    }

                    $infoExt = explode(',', $info->docClase);

                    if ($totalValor3 != 0) {
                        $tipoOperacion = 3;
                    }else {
                        if ($totalValor01 != 0 && $totalValor2 == 0) {
                            $tipoOperacion = 1;
                        } else if ($totalValor01 != 0 && $totalValor2 != 0) {
                            $tipoOperacion = 4;
                        } else if ($totalValor01 == 0 && $totalValor2 != 0) {
                            $tipoOperacion = 2;
                        }
                    }

                    $array = array(
                        date_format(date_create($valFecha), 'd/m/Y'),
                        $documentClase,
                        str_pad($valDocTipo, 2, '0', STR_PAD_LEFT),
                        trim(str_replace('-', '', $numResolucion)),
                        trim($serieDocumentos),
                        $numInicialInt,
                        $numFinalInt,
                        $numInicial,
                        $numFinal,
                        ($valDocTipo == 10) ? $info->xpos : '',
                        number_format($totalValor2, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($totalValor3, 2, '.', ''),
                        number_format($totalValor01, 2, '.', ''),
                        number_format($totalValor510, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($totalValor9, 2, '.', ''),
                        number_format($totalValor13, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($totalGeneral, 2, '.', ''),
                        $tipoOperacion,
                        ($esTicket != 1) ? $infoExt[1] : 3,
                        '2'
                    );

                    $contenidoHeader = implode(';', $array);
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }

                fclose($archivoTxt);

                $docTxt = "LibroVentasConsumidorFinal.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function documentCSVConsumidorFinal($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            } else {
                // Evitar cualquier salida antes de los encabezados
                if (ob_get_level()) {
                    ob_end_clean();
                }

                ini_set('memory_limit', '4096M');
                ini_set('max_execution_time', '700');
                
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                
                $rFechas = $this->obtenerRangoFechas($idmes);

                $fechaIni = $rFechas['inicio'];
                $fechaFin = $rFechas['fin'];

                $fechaSum = new DateTime($fechaIni);
                $fechaSum = $fechaSum->modify("+5 days");
                $fechaSum = $fechaSum->format("Y-m-d");
                
                $filename = 'LibroVentasConsumidorFinal.csv';
                $file = fopen('php://output', 'w'); // Abrir el archivo en modo escritura

                // Enviar encabezados HTTP para la descarga
                header('Content-Type: text/csv; charset=UTF-8');
                header('Content-Disposition: attachment; filename="' . $filename . '"');
                header('Pragma: no-cache');
                header('Expires: 0');
                
                // Evitar que se generen espacios o salidas innecesarias antes de los encabezados
                // if (ob_get_level()) {
                //     ob_clean(); // Limpiar cualquier salida anterior en el buffer si está activo
                // }
                flush();    // Asegurarse de que el buffer esté limpio

                // Activar flush implícito
                // ob_implicit_flush(true);
                
                while ($fechaSum <= $fechaFin) {
                    $data = $this->iva_model->getdocumentosToCSVbyBatch($idlibro, $idyear, $idmes, $idclases, $fechaIni, $fechaSum);

                    if ($data->num_rows() == 0 && $fechaSum >= $fechaFin) {
                        break;
                    }

                    if ($data->num_rows() > 0) {
                        $totalValor2   = 0; $totalValor3 = 0; $totalValor01 = 0;
                        $totalValor510 = 0; $totalValor9 = 0; $totalValor13 = 0;
                        $totalGeneral  = 0; $numeroInicialInt = 0; $numeroFinalInt = 0;
                        $numeroInicial = 0; $numeroFinal = 0; $valFecha = "";
                        $serieDocumentos = ""; $numResolucion = ""; $i = 0; $valDocTipo = "";
                        $serieDocumentoD = ""; $tipoOperacion = 0; $tipoIngreso = 0;
                        $esTicket = 0;

                        foreach ($data->result() as $info) {
                            $esTicket = (int) $info->esticket;

                            if (strpos($info->doc_serie, 'DTE') === false) {
                                $docResolucion   = str_replace('-', '', $info->doc_res);
                                $docSerie        = $info->doc_serie;
                                $docSerieDiff    = $info->doc_serie;
                                $numeroDocumento = $info->doc_numero;
                                $documentClase   = $info->doc_clase;

                                $numDocs = explode('|', $info->doc_numero);
                                if (count($numDocs) > 1) {
                                    $numeroInicial = $numDocs[0]; $numeroFinal = $numDocs[1];
                                } else {
                                    $numeroInicialInt = $numeroDocumento;
                                    $numeroFinalInt   = $numeroDocumento;
                                    $numeroInicial    = $numeroDocumento;
                                    $numeroFinal      = $numeroDocumento;
                                }
                            } else {
                                $infoDTE = $this->dte_model->validateExistDocumentDteCSV($info->idrec, 1, $idyear);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($info->doc_serie, $info->doc_numero, $info->idcentro, $info->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDteCSV($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $docResolucion   = 'N/A';
                                        $docSerie        = 'N/A';
                                        $docSerieDiff    = $info->doc_tipo.'N/A';
                                        $numeroDocumento = $infoDTE->cgeneracion;
                                        $documentClase   = 4;

                                        $numeroInicialInt = 'N/A';
                                        $numeroFinalInt   = 'N/A';
                                        $numeroInicial    = $numeroDocumento;
                                        $numeroFinal      = $numeroDocumento;
                                    } else continue;
                                }
                            }

                            if ($i == 0) {
                                $numInicialInt = $numeroInicialInt;
                                $numInicial = $numeroInicial;
                            }

                            if (($serieDocumentoD != $docSerieDiff && $i != 0) || ($valFecha != $info->doc_fecha && $i != 0) || ($numResolucion != $docResolucion && $i != 0)) {
                                $infoExt = explode(',', $info->docClase);

                                if ($totalValor3 != 0) {
                                    $tipoOperacion = 3;
                                } else {
                                    if ($totalValor01 != 0 && $totalValor2 == 0) {
                                        $tipoOperacion = 1;
                                    } else if ($totalValor01 != 0 && $totalValor2 != 0) {
                                        $tipoOperacion = 4;
                                    } else if ($totalValor01 == 0 && $totalValor2 != 0) {
                                        $tipoOperacion = 2;
                                    } else {
                                        $tipoOperacion = 1;
                                    }
                                }

                                $array = array(
                                    date_format(date_create($valFecha), 'd/m/Y'),
                                    $documentClase,
                                    str_pad($valDocTipo, 2, '0', STR_PAD_LEFT),
                                    trim(str_replace('-', '', $numResolucion)),
                                    trim($serieDocumentos),
                                    $numInicialInt,
                                    $numFinalInt,
                                    $numInicial,
                                    $numFinal,
                                    ($valDocTipo == 10) ? $info->xpos : '',
                                    number_format($totalValor2, 2, '.', ''),
                                    number_format(0, 2, '.', ''),
                                    number_format($totalValor3, 2, '.', ''),
                                    number_format($totalValor01, 2, '.', ''),
                                    number_format($totalValor510, 2, '.', ''),
                                    number_format(0, 2, '.', ''),
                                    number_format($totalValor9, 2, '.', ''),
                                    number_format($totalValor13, 2, '.', ''),
                                    number_format(0, 2, '.', ''),
                                    number_format($totalGeneral, 2, '.', ''),
                                    $tipoOperacion,
                                    ($esTicket != 1) ? (!isset($infoExt[1])) ? '' : $infoExt[1] : 3,
                                    '2'
                                );

                                // print_r($array);

                                // Agregar los datos al archivo CSV
                                // $csv->insertOne($array);
                                fputcsv($file, $array, ';'); // Escribir la fila

                                // Limpiar el buffer de salida para enviar los datos al navegador en fragmentos
                                flush(); // Enviar los datos al navegador

                                // Resetear los valores para el siguiente grupo
                                $totalValor2   = 0; $totalValor3 = 0; $totalValor01 = 0;
                                $totalValor510 = 0; $totalValor9 = 0; $totalValor13 = 0;
                                $totalGeneral  = 0; $i = 0;
                            }

                            if ($i == 0) {
                                $numInicialInt = $numeroInicialInt;
                                $numInicial = $numeroInicial;
                            }

                            // Acumular los valores
                            $totalValor2   = $totalValor2 + $info->valor2;
                            $totalValor3   = $totalValor3 + $info->valor3;
                            $totalValor01  = $totalValor01 + ($info->valor0 + $info->valor1);
                            $totalValor510 = $totalValor510 + ($info->valor5 + $info->valor10);
                            $totalValor9   = $totalValor9 + $info->valor9;
                            $totalValor13  = $totalValor13 + $info->valor13;
                            $totalGeneral  = $totalGeneral + ($info->valor0 + $info->valor1 + $info->valor2 + $info->valor3 + $info->valor4 + $info->valor5 + $info->valor10);

                            $i++;
                            $numFinal        = $numeroFinal;
                            $numFinalInt     = $numeroFinalInt;
                            $serieDocumentos = $docSerie;
                            $serieDocumentoD = $docSerieDiff;
                            $numResolucion   = $docResolucion;
                            $valFecha        = $info->doc_fecha;
                            $valDocTipo      = $info->doc_tipo;
                        }

                        // Insertar la última línea
                        $infoExt = explode(',', $info->docClase);

                        if ($totalValor3 != 0) {
                            $tipoOperacion = 3;
                        } else {
                            if ($totalValor01 != 0 && $totalValor2 == 0) {
                                $tipoOperacion = 1;
                            } else if ($totalValor01 != 0 && $totalValor2 != 0) {
                                $tipoOperacion = 4;
                            } else if ($totalValor01 == 0 && $totalValor2 != 0) {
                                $tipoOperacion = 2;
                            }
                        }

                        $array = array(
                            date_format(date_create($valFecha), 'd/m/Y'),
                            $documentClase,
                            str_pad($valDocTipo, 2, '0', STR_PAD_LEFT),
                            trim(str_replace('-', '', $numResolucion)),
                            trim($serieDocumentos),
                            $numInicialInt,
                            $numFinalInt,
                            $numInicial,
                            $numFinal,
                            ($valDocTipo == 10) ? $info->xpos : '',
                            number_format($totalValor2, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($totalValor3, 2, '.', ''),
                            number_format($totalValor01, 2, '.', ''),
                            number_format($totalValor510, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($totalValor9, 2, '.', ''),
                            number_format($totalValor13, 2, '.', ''),
                            number_format(0, 2, '.', ''),
                            number_format($totalGeneral, 2, '.', ''),
                            $tipoOperacion,
                            ($esTicket != 1) ? (!isset($infoExt[1])) ? '' : $infoExt[1] : 3,
                            '2'
                        );

                        // print_r($array);

                        // $csv->insertOne($array);
                        fputcsv($file, $array, ';'); // Escribir la fila

                        // Limpiar el buffer de salida para enviar los datos al navegador en fragmentos
                        flush(); // Enviar los datos al navegador
                    }

                    $fechaIni = new DateTime($fechaSum);
                    $fechaIni = $fechaIni->modify("+1 days");
                    $fechaIni = $fechaIni->format("Y-m-d");

                    $fechaSum = new DateTime($fechaSum);
                    $fechaSum = $fechaSum->modify("+5 days");
                    $fechaSum = $fechaSum->format("Y-m-d");

                    if ($fechaSum > $fechaFin) {
                        $fechaSum = new DateTime($fechaFin);
                        $fechaSum = $fechaSum->format("Y-m-d");
                    }
                }

                // Guardar el archivo CSV y hacer la descarga
                //$docTxt = "LibroVentasConsumidorFinal.csv";
                //$csv->output($docTxt);
                fclose($file); // Cerrar el archivo al final
                exit;
            }
        }

        //Obtener FechaInicial Final
        function obtenerRangoFechas($idanomes) {
            $year = substr($idanomes, 0, 4);  // Extrae el año
            $month = substr($idanomes, 4, 2); // Extrae el mes
        
            // Primera fecha del mes
            $fechaInicio = "$year-$month-01";
        
            // Última fecha del mes
            $fechaFin = date("Y-m-t", strtotime($fechaInicio)); // "t" da el último día del mes
        
            return [
                'inicio' => $fechaInicio,
                'fin' => $fechaFin
            ];
        }
        
        function documentCSVConsumidorRetencion($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $information = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroVentasConsumidorFinalRetencion.csv",'w+');

                foreach($information as $info){
                    $array = array(
                        date_format(date_create($info->fecha), 'd/m/Y'),
                        '1',
                        str_pad($info->ivabook, 2, '0', STR_PAD_LEFT),
                        str_replace('-', '', $info->resolucion),
                        $serieDocumentos,
                        $numeroInicial,
                        $numeroFinal,
                        $numeroInicial,
                        $numeroFinal,
                        $info->equipo,
                        number_format($totalExento, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($totalGravado + $totalIVA, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format(0, 2, '.', ''),
                        number_format($total, 2, '.', ''),
                        '2'
                    );

                    $contenidoHeader = implode(';', $array);
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");
                }

                fclose($archivoTxt);

                $docTxt = "LibroVentasConsumidorFinalRetencion.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function documentCSVCompras($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVACompras.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        if ( $info->docClase != '' && $info->docClase != 'false' ) {
                            $docAct = explode(',', $info->docClase);
                        } else {
                            $docAct = array(
                                $this->iva_model->getValorGvarDefault('iva_tipoo'),
                                $this->iva_model->getValorGvarDefault('iva_clas'),
                                $this->iva_model->getValorGvarDefault('iva_sect'),
                                $this->iva_model->getValorGvarDefault('iva_tipoc')
                            );
                        }

                        if ( $info->docTipo == 0 ) {
                            $numeroDocumento = $info->doc_numero;
                            $documentClase = $info->doc_clase;
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            $numeroDocumento = str_replace('-', '', $infoDTE->cgeneracion);
                            $documentClase = 4;
                        }

                        $array = array(
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            $documentClase,
                            str_pad($info->doc_tipo, 2, '0', STR_PAD_LEFT),
                            $numeroDocumento,
                            str_replace('-', '', $info->nit),
                            trim($info->namecliente),
                            number_format(abs($info->valor2), 2, '.', ''),
                            number_format(abs($info->valor11), 2, '.', ''),
                            number_format(abs($info->valor6), 2, '.', ''),
                            number_format(abs($info->valor1), 2, '.', ''),
                            number_format(abs($info->valor10), 2, '.', ''),
                            number_format(abs($info->valor5), 2, '.', ''),
                            number_format(abs($info->valor9), 2, '.', ''),
                            number_format(abs($info->valor0), 2, '.', ''),
                            number_format((abs($info->valor0)+abs($info->valor1)+abs($info->valor2)+abs($info->valor3)+$info->valor4+abs($info->valor5)+abs($info->valor6)+abs($info->valor9)+abs($info->valor10)+abs($info->valor11)), 2, '.', ''),
                            str_replace('-', '', $info->dui),
                            $docAct[0],
                            $docAct[1],
                            $docAct[2],
                            $docAct[3],
                            '3'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVACompras.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function documentComprasGoIva($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			} else {
                $idaccount = $this->session->userdata('idaccount');
                $dteDocums = ( $idaccount == '1492935' || $idaccount == '3317013' ) ? 1 : 0;
                $idclases  = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $data = $this->iva_model->getdocumentosToTxt($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVAComprasGoIva.txt", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        #$contenidoTxt = '03;'.$info->idcenxpos.';'.$info->idcajxpos.';0001;'.str_replace(';', '', $info->serie).';'.$info->nrc.';'.str_replace(';', '', $info->namecliente).';'.$info->fecha.';'.$info->fecha.';'.$info->referencia.';'.$exento.';0;0;'.$gravado.';0;0;'.$info->valtax1.';'.$info->valtax5.';0;0;0;'.$info->nit.';'.str_replace(';', '', $info->direccion).';'.str_replace(';', '', $info->municipio).';'.str_replace(';', '', $info->departamento).';'.str_replace(';', '', $info->giro);
                        $contenidoTxt = '03;'.trim($info->idcenxpos).';;'.trim($info->idclaxpos).';'.trim(str_replace(';', '', $info->doc_serie)).';'.$info->doc_numero.';'.trim(ltrim($info->nrc, '0')).';'.trim(str_replace(';', '', $info->namecliente)).';'.$info->doc_fecha.';'.$info->doc_fecha.';;'.$info->valor2.';0;0;'.$info->valor1.';0;0;'.$info->valor0.';'.$info->valor4.';0;0;0;'.trim($info->nit).';'.trim(str_replace(';', '', $info->direccion)).';'.trim(str_replace(';', '', $info->municipio)).';'.trim(str_replace(';', '', $info->departamento)).';'.trim(str_replace(';', '', $info->giro));
                        
                        if ( $dteDocums == 1 ) {
                            $this->load->model('dte_model');
                            $infoDte = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            if ($infoDte) {
                                $contenidoTxt .= ';'.trim(str_replace(';', '', $infoDte->cgeneracion)).';'.trim(str_replace(';', '', $infoDte->srecepcion));
                            } else $contenidoTxt .= ';;';
                        } else $contenidoTxt .= ';;';

                        fwrite($archivoTxt, $contenidoTxt);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVAComprasGoIva.txt";
                if (file_exists($docTxt)) {
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function documentCSVComprasExcluidos($idlibro, $idyear, $idmes, $idclases) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVAComprasExcluidos.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        if ( $info->docClase != '' && $info->docClase != 'false' ) {
                            $docAct = explode(',', $info->docClase);
                        } else {
                            $docAct = array(
                                $this->iva_model->getValorGvarDefault('iva_tipoo'),
                                $this->iva_model->getValorGvarDefault('iva_clas'),
                                $this->iva_model->getValorGvarDefault('iva_sect'),
                                $this->iva_model->getValorGvarDefault('iva_tipoc')
                            );
                        }

                        if ($info->nit == '') {
                            if ($info->dui == '') {
                                if ($info->nrc == '') {
                                    $tipoDocumento = 0;
                                } else $tipoDocumento = 3;
                            } else $tipoDocumento = 2;
                        } else $tipoDocumento = 1;

                        switch ($tipoDocumento) {
                            case 0:
                                $tipoDocumento = 0;
                                $txtDocumento  = 'NO DEFINIDO';
                                break;
                            case 1:
                                $tipoDocumento = 1;
                                $txtDocumento  = str_replace('-', '', $info->nit);
                                break;
                            case 2:
                                $tipoDocumento = 2;
                                $txtDocumento  = str_replace('-', '', $info->dui);
                                break;
                            case 3:
                                $tipoDocumento = 3;
                                $txtDocumento  = str_replace('-', '', $info->nrc);
                                break;
                            default:
                                break;
                        }

                        if ( strpos($info->doc_serie, 'DTE') === false ) {
                            $numeroDocumento   = $info->doc_numero;
                            $serieDocumento = $info->doc_serie;
                        } else {
                            $this->load->model('dte_model');
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            if ($infoDTE != false) {
                                $numeroDocumento = str_replace('-', '', $infoDTE->ncontrol);
                                $serieDocumento  = $infoDTE->srecepcion;
                            } else {
                                $numeroDocumento = '';
                                $serieDocumento  = '';
                            }
                        }

                        $array = array(
                            $tipoDocumento,
                            $txtDocumento,
                            trim($info->namecliente),
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            $serieDocumento,
                            $numeroDocumento,
                            number_format(abs($info->valor1), 2, '.', ''),
                            number_format(abs($info->valor8), 2, '.', ''),
                            $docAct[0],
                            $docAct[1],
                            $docAct[2],
                            $docAct[3],
                            '5'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVAComprasExcluidos.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function documentCSVPercepcion($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('dte_model');
                $this->load->model('iva_model');
                $data = $this->iva_model->getdocumentosToCSVPercepcion($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVAComprasPercepcion.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {

                        if ( $info->docTipo == 0 ) {
                            $numeroDocumento = $info->doc_numero;
                            $serieDocumento = $info->doc_serie;
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            $numeroDocumento = str_replace('-', '', $infoDTE->cgeneracion);
                            $serieDocumento = $infoDTE->srecepcion;
                        }
                        
                        $array = array(
                            str_replace('-', '', $info->nit),
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            str_pad($info->doc_tipo, 2, '0', STR_PAD_LEFT),
                            $serieDocumento,
                            $numeroDocumento,
                            number_format(abs($info->valor1), 2, '.', ''),
                            number_format(abs($info->valor4), 2, '.', ''),
                            str_replace('-', '', ($info->nit == '') ? $info->dui : ''),
                            '8'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVAComprasPercepcion.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function documentCSVRetencion($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVAContribuyentesRetencion.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        
                        if ( $info->docTipo == 0 ) {
                            $numResolucion  = $info->doc_res;
                            $numDocumento   = $info->doc_numero;
                            $serieDocumento = $info->doc_serie;
                        } else {
                            $this->load->model('dte_model');
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            $numResolucion  = str_replace('-', '', $infoDTE->ncontrol);
                            $numDocumento   = str_replace('-', '', $infoDTE->cgeneracion);
                            $serieDocumento = $infoDTE->srecepcion;
                        }

                        $array = array(
                            str_replace('-', '', $info->nit),
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            str_pad($info->doc_tipo, 2, '0', STR_PAD_LEFT),
                            $serieDocumento,
                            $numDocumento,
                            number_format(abs($info->valor12), 2, '.', ''),
                            number_format(abs($info->valor4), 2, '.', ''),
                            ($info->nit == '') ? str_replace('-', '', $info->dui) : '',
                            '7'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVAContribuyentesRetencion.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }
        
        function documentCSVRetencion13($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $data = $this->iva_model->getdocumentosToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVAContribuyentesRetencion13.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        if ( strpos($info->doc_serie, 'DTE') === false ) {
                            $numResolucion  = $info->doc_res;
                            $numDocumento   = $info->doc_numero;
                            $serieDocumento = $info->doc_serie;
                        } else {
                            $this->load->model('dte_model');
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            $numResolucion  = str_replace('-', '', $infoDTE->ncontrol);
                            $numDocumento   = str_replace('-', '', $infoDTE->cgeneracion);
                            $serieDocumento = $infoDTE->srecepcion;
                        }

                        $array = array(
                            str_replace('-', '', $info->nit),
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            str_pad('07', 2, '0', STR_PAD_LEFT),
                            $serieDocumento,
                            $numResolucion,
                            $numDocumento,
                            number_format(abs($info->valor1), 2, '.', ''),
                            number_format(abs($info->valor8), 2, '.', ''),
                            ($info->nit == '') ? str_replace('-', '', $info->dui) : '',
                            '12'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVAContribuyentesRetencion13.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function documentCSVDCL($idlibro, $idyear, $idmes, $idclases){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $idclases = str_replace('_', ',', $idclases);

                $this->load->model('iva_model');
                $this->load->model('dte_model');
                $data = $this->iva_model->getdocumentosDCLToCSV($idlibro, $idyear, $idmes, $idclases);
                
                $archivoTxt = fopen("LibroIVADCL.csv", 'w+');

                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $info) {
                        if ( $info->docTipo == 0 ) {
                            $serieDocumento  = $info->doc_serie;
                            $numeroDocumento = $info->doc_numero;
                        } else {
                            $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $idyear);
                            $serieDocumento  = str_replace('-', '', $infoDTE->srecepcion) ;
                            $numeroDocumento = str_replace('-', '', $infoDTE->cgeneracion);
                        }

                        $array = array(
                            str_replace('-', '', $info->nit),
                            date_format(date_create($info->doc_fecha), 'd/m/Y'),
                            $serieDocumento,
                            $numeroDocumento,
                            number_format($info->valor1, 2, '.', ''),
                            number_format($info->valor7, 2, '.', ''),
                            str_replace('-', '', $info->dui),
                            '6'
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }
                }

                fclose($archivoTxt);

                $docTxt = "LibroIVADCL.csv";
                if(file_exists($docTxt)){
                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename="'.basename($docTxt).'"');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($docTxt));
                    readfile($docTxt);
                    
                    unlink($docTxt);
                    exit;
                }
            }
        }

        function documentPDFDCL($idlibro, $idyear, $idmes, $filtro){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
				redirect('CerrarSesion');
			}else{
                $this->load->model('global_model');
                $this->load->model('iva_model');

                $nombreFormato = 'DOCUMENTOS CONTABLES DE LIQUIDACIÓN';
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
                $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
                $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
                $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
                $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
                $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
                $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
                $fechaini = $idmes.'01';
                 /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $filtro); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */

                $mes            = date_format(date_create($fechaini),'n');
                $anio           = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                    break;
                }
    
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de DCL');
                $pdf->SetSubject('Libro de DCL');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setPageOrientation('L');
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Landscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                date_default_timezone_set('America/El_Salvador');

                $fecha = new DateTime();
                if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                    $fechaFooter = "";
                }else{
                    $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
                }

                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $data = $this->iva_model->getdocumentosDCL($idlibro, $idyear, $idmes);

                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 5%; text-align: center;">No.</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 10%; text-align: center;">FECHA DE EMISIÓN</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 10%; text-align: center;">NÚMERO DE DOCUMENTO</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 10%; text-align: center;">N.I.T.<br>N.R.C.</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 45%; text-align: center;">NOMBRE DEL CONTRIBUYENTE</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 10%; text-align: center;">MONTO SUJETO A RETENCIÓN</td>
                            <td style="border:1px solid black;font-size:11px;text-align:center; width: 10%; text-align: center;">IMPUESTO RETENIDO</td>
                        </tr>');
                if ($data->num_rows() > 0) {
                    $datosArray = $data->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;

                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'namecliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'namecliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'namecliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    $totalRetencion = 0; $totalImpuesto = 0;
                    foreach ($datosArray as $key => $dato){
                        //$this->highlight_array($dato);
                        $estructura .= '
                        <tr>
                            <td style="font-size:9px;text-align:center; width: 5%; text-align: center;">'.($key+1).'</td>
                            <td style="font-size:9px;text-align:center; width: 10%; text-align: center;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                            <td style="font-size:9px;text-align:center; width: 10%; text-align: center;">'.$dato->doc_numero.'</td>
                            <td style="font-size:9px;text-align:center; width: 10%; text-align: center;">'.trim($dato->nit).'</td>
                            <td style="font-size:9px;text-align:center; width: 45%; text-align: left;">'.trim($dato->namecliente).'</td>
                            <td style="font-size:9px;text-align:center; width: 10%; text-align: rigth;">'.number_format(round($dato->valor1, 2),2).'</td>
                            <td style="font-size:9px;text-align:center; width: 10%; text-align: rigth;">'.number_format(round($dato->valor7, 2),2).'</td>
                        </tr>';
                        $totalRetencion += $dato->valor1;
                        $totalImpuesto += $dato->valor7;
                    }

                    $estructura .= '
                    <tr style="line-height: 2mm"><td></td></tr>
                    <tr>
                        <td style="width:80%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($totalRetencion, 2),2).'</td>
                        <td style="width:10%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($totalImpuesto, 2),2).'</td>
                    </tr>
                    <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                    <tr>
                        <td style="width:20%; border-top:1px solid black; text-align:center; font-size: 11px;">'.$nameContador.'<br>Contador</td>
                    </tr>';


                }
                $estructura .= '</table>';

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $pdf->lastPage();
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
        }

        #   REPORTE DE LIBROS
        function impresionLibroIVA($idano, $idlibro, $idanomes, $tipo = 0, $filtro) {
            if($this->validatePermiso()) {
                ini_set('memory_limit','800M');
                ini_set('max_allowed_packet', '500M');

                $extra = [
                    'ida' => (int)$idano,'idam' => (int)$idanomes, 'idl' => (int)$idlibro, "filtro" => $filtro
                ];
                switch ((int)$idlibro) {
                    case 1:#    VENTAS CONSUMIDOR FINAL
                        $extra['t'] = (int)$tipo;
                        $this->libroConsumidorFinal($extra);
                        //$this->libroConsumidorFinalNew($extra);
                    break;
                    case 2:#    IVA CONTRIBUYENTES
                        $extra['t'] = (int)$tipo;
                        $this->libroVentasContribuyentes($extra);
                        //$this->libroVentasContribuyentesNew($extra);
                    break;
                    case 3:#    COMPRAS
                        if($tipo == 0){
                            $this->libroCompras($extra);
                        }else{
                            $this->libroComprasConsolidado($extra);
                        }
                    break;
                    case 4:
                    break;
                }
            }
        }
       
        private function libroConsumidorFinalOld($extra) {
            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas Consumidor Final');
            $pdf->SetSubject('Libro de Ventas Consumidor Final');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');

            $fecha = new DateTime();
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $tipo = $extra['t'];
            $idlibro = $extra['idl'];

            $fechaini = $ida.'-'.$idmes.'-01';
            $this->load->model('iva_model');
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('variable_model');

            $nombreFormato  = "LIBRO DE VENTAS CONSUMIDOR FINAL";//$this->global_model->getFormatosNombre($this->uri->segment(3));
            $NRC            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $direccion      = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $nameContador   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }
            

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);

            //<tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">'.$direccion.'</td></tr>
                    <tr>
                        <td style="text-align:right; font-size:15px; width:40%;">N.I.T.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td>
                        <td style="width:20%;"></td>
                        <td style="text-align: left; font-size:15px; width:40%;">N.R.C.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td>
                    </tr>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);

            if ($tipo == 0) {
                $orientacion = $this->global_model->getValorNumVariable("iva_orientacion_l1");
                if($orientacion == 0){
                    $pdf->addPage('L', 'LETTER');

                }else{
                    $pdf->addPage('P', 'LETTER');

                }
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */

                // <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Tipo de Operación</th>

                $estructura = trim('
                    <table>
                        <thead>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width: 5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:20%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Código de Generación Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:20%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Código de Genereción Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Número de Control Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Número de Control Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:25%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>
                            </tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 9px;" ><br>No Sujetas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 9px;" ><br>Exentas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 9px;" ><br>Gravadas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 9px;" >Exportaciones</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 9px;" ><br>Totales</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                ');
                $total_exento = 0; $total_gravado = 0; $total_nsujeta = 0; $total_exportg = 0;
                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $extra = '';
                #   PROCESOS
                if ($this->dev_model->multiIvaCentral(1, $ida)) {
                    $datos = $this->dev_model->multiIvaCentral(2, [
                        'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam
                    ]);
                    if ($datos->num_rows() > 0) {
                        $datosArray = $datos->result();
                        /*  INICIO FILTRO */
                        switch ($filtro) {
                            case 1: // orden de digitacion
                                $idrec = array_column($datosArray , 'idrec');
                                array_multisort($idrec, $orden, $datosArray );
                                break;

                            case 2: // fecha de digitacion
                                $fecha = array_column($datosArray , 'fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                            case 3: // fecha del documento
                                $fecha = array_column($datosArray , 'doc_fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                        }
                        /*  FIN FILTRO  */

                        foreach ($datosArray as $key => $dato) {
                            //$this->highlight_array($dato);
                            $dia = date_format(date_create($dato->doc_fecha),'d');
                            $num = explode("|", $dato->doc_numero);
                            if (count($num) > 1) {
                                $num1 = $num[0];
                                $num2 = $num[1];
                            } else {
                                $datoNumeradores = $this->dev_model->multiIvaCentral(2.2, [
                                    'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam, 'fecha' => $dato->doc_fecha,
                                    'serie' => $dato->doc_serie
                                ]);
                                $datoNums = explode("|", $datoNumeradores);
                                $infNum1 = explode(":", $datoNums[0]);
                                $infNum2 = explode(":", $datoNums[1]);
                                $num1 = $infNum1[1];
                                $num2 = $infNum2[1];

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum1[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum1[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionIni = $infoDTE->cgeneracion;
                                        $numeControlIni = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionIni = $dato->doc_serie.$num1;
                                        $numeControlIni = $dato->doc_serie.$num1;
                                    }
                                } else {
                                    $cGeneracionIni = $dato->doc_serie.$num1;
                                    $numeControlIni = $dato->doc_serie.$num1;
                                }
                                
                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum2[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum2[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionFin = $infoDTE->cgeneracion;
                                        $numeControlFin = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionFin = $dato->doc_serie.$num2;
                                        $numeControlFin = $dato->doc_serie.$num2;
                                    }
                                } else {
                                    $cGeneracionFin = $dato->doc_serie.$num2;
                                    $numeControlFin = $dato->doc_serie.$num2;
                                }
                            }

                            $gravado_bruto += $dato->valor1;
                            $gravado_iva += $dato->valor0;
                            $exento_bruto += $dato->valor2;
                            $nsujeta_bruto += $dato->valor3;
                            $exportg_bruto += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);

                            $dato->valor1 = $dato->valor1 + $dato->valor0;

                            //<td style="border:0.1px solid #333333; width:10%;text-align:center; font-size:8px;">'.strtoupper($dato->tipodoc).'</td>
                            $estructura .= trim('
                                <tr>
                                    <td style="width: 5%;text-align:center; font-size:9px;">'.$dia.'</td>
                                    <td style="width:20%;text-align:center; font-size:8px;">'.$cGeneracionIni.'</td>
                                    <td style="width:20%;text-align:center; font-size:8px;">'.$cGeneracionFin.'</td>
                                    <td style="width:15%;text-align:center; font-size:8px;">'.$numeControlIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:8px;">'.$numeControlFin.'</td>
                                    <td style="width: 5%;text-align:right; font-size:9px;">'.number_format(round($dato->valor3, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:9px;">'.number_format(round($dato->valor2, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:9px;">'.number_format(round($dato->valor1, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:9px;">'.number_format(round(($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:9px;">'.number_format(round(($dato->valor2 + $dato->valor1 + $dato->valor5 + $dato->valor10 + $dato->valor13), 2),2).'</td>
                                </tr>
                            ');

                            $total_exento += $dato->valor2;
                            $total_gravado += $dato->valor1;
                            $total_nsujeta += $dato->valor3;
                            $total_exportg += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                        }
                    }
                    $extra = ($datos->num_rows() >= 23 && $datos->num_rows() <= 43) ? '<br pagebreak="true"/>' : '';
                }
                #   TOTALES
                $total = $total_exento + $total_gravado + $total_nsujeta + $total_exportg;

                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;

                $bruto_total = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $dev_total = $gravado_dev  + $exento_dev + $exportg_dev + $nsujeta_dev;
                $neto_total = $gravado_neto  + $exento_neto + $exportg_neto + $nsujeta_neto;
                $iva_total = $gravado_iva  + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = $gravado_total  + $exento_total + $exportg_total + $nsujeta_total;
                $estructura .= trim('
                        <tr>
                            <td style="width: 5%;text-align:center; font-size:9px;"></td>
                            <td style="width:20%;text-align:center; font-size:8px;"></td>
                            <td style="width:20%;text-align:center; font-size:8px;"></td>
                            <td style="width:15%;text-align:center; font-size:8px;"></td>
                            <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total, 2),2).'</td>
                        </tr>
                        <tr><td style="font-size: 12px;"></td></tr>
                    </table>
                    '.$extra.'
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                           
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            } else {
                $pdf->addPage('L', 'LETTER');

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $percibido_bruto = 0;
                $retencion_bruto = 0;
                #   PROCESOS
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10 + $dato->valor6);
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                #   TOTALES
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;

                $total_bruto = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $total_dev = $gravado_dev + $exento_dev + $exportg_dev + $nsujeta_dev;
                $total_iva = $gravado_iva + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = ($total_neto = $total_bruto - $total_dev) + $total_iva;

                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroConsumidorFinalOld2($extra) {
            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas Consumidor Final');
            $pdf->SetSubject('Libro de Ventas Consumidor Final');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');

            $fecha = new DateTime();
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $tipo = $extra['t'];
            $idlibro = $extra['idl'];

            $fechaini = $ida.'-'.$idmes.'-01';
            $this->load->model('iva_model');
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('variable_model');
            $this->load->model('sucursal_model');

            $nombreFormato  = "LIBRO DE VENTAS CONSUMIDOR FINAL";//$this->global_model->getFormatosNombre($this->uri->segment(3));
            $NRC            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $direccion      = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $nameContador   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }
            

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);

            //<tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">'.$direccion.'</td></tr>
                    <tr>
                        <td style="text-align:right; font-size:15px; width:40%;">N.I.T.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td>
                        <td style="width:20%;"></td>
                        <td style="text-align: left; font-size:15px; width:40%;">N.R.C.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td>
                    </tr>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);

            if ($tipo == 0) {
                $orientacion = $this->global_model->getValorNumVariable("iva_orientacion_l1");
                if($orientacion == 0){
                    $pdf->addPage('L', 'LETTER');

                }else{
                    $pdf->addPage('P', 'LETTER');

                }
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */

                // <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Tipo de Operación</th>

                $estructura = trim('
                    <table>
                        <thead>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width: 5%; font-weight:bold; text-align:center; font-size:10px;" rowspan="2"><br><br>Día</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Generación Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Genereción Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:35%; font-weight:bold; text-align:center; font-size:11px;" colspan="5">VENTAS</th>
                            </tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>No Sujetas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Exentas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Gravadas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" >Exportaciones</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Totales</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Monto Sujeto a Retención</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Retención 1%</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                ');
                $total_exento = 0; $total_gravado = 0; $total_nsujeta = 0; $total_exportg = 0;
                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0; $total_retencion = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0; $total_msujeto_retencion = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0; $idCentroAct = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0; $idCentroAnt = 0;
                $extra = '';
                #   PROCESOS
                if ($this->dev_model->multiIvaCentral(1, $ida)) {
                    $datos = $this->dev_model->multiIvaCentral(2, [
                        'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam
                    ]);
                    if ($datos->num_rows() > 0) {
                        $datosArray = $datos->result();
                        /*  INICIO FILTRO */
                        switch ($filtro) {
                            case 1: // orden de digitacion
                                $idrec = array_column($datosArray , 'idrec');
                                array_multisort($idrec, $orden, $datosArray );
                                break;

                            case 2: // fecha de digitacion
                                $fecha = array_column($datosArray , 'fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                            case 3: // fecha del documento
                                $fecha = array_column($datosArray , 'doc_fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                        }
                        /*  FIN FILTRO  */

                        foreach ($datosArray as $key => $dato) {
                            //$this->highlight_array($dato);
                            $dia = date_format(date_create($dato->doc_fecha),'d');
                            $num = explode("|", $dato->doc_numero);
                            if (count($num) > 1) {
                                $num1 = $num[0];
                                $num2 = $num[1];
                            } else {
                                $datoNumeradores = $this->dev_model->multiIvaCentral(2.2, [
                                    'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam, 'fecha' => $dato->doc_fecha,
                                    'serie' => $dato->doc_serie
                                ]);
                                $datoNums = explode("|", $datoNumeradores);
                                $infNum1 = explode(":", $datoNums[0]);
                                $infNum2 = explode(":", $datoNums[1]);
                                $num1 = $infNum1[1];
                                $num2 = $infNum2[1];

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum1[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum1[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionIni = $infoDTE->cgeneracion;
                                        $numeControlIni = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionIni = $dato->doc_serie.$num1;
                                        $numeControlIni = $dato->doc_serie.$num1;
                                    }
                                } else {
                                    $cGeneracionIni = $dato->doc_serie.$num1;
                                    $numeControlIni = $dato->doc_serie.$num1;
                                }
                                
                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum2[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum2[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionFin = $infoDTE->cgeneracion;
                                        $numeControlFin = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionFin = $dato->doc_serie.$num2;
                                        $numeControlFin = $dato->doc_serie.$num2;
                                    }
                                } else {
                                    $cGeneracionFin = $dato->doc_serie.$num2;
                                    $numeControlFin = $dato->doc_serie.$num2;
                                }
                            }

                            $gravado_bruto += $dato->valor1;
                            $gravado_iva += $dato->valor0;
                            $exento_bruto += $dato->valor2;
                            $nsujeta_bruto += $dato->valor3;
                            $exportg_bruto += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);

                            $dato->valor1 = $dato->valor1 + $dato->valor0;
                            $idcentroAnt = $dato->idcentro;

                            $nameCentro = $this->sucursal_model->getNameCentro($dato->idcentro);
                            if ($idcentroAnt != $idCentroAct) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 100%;text-align:left; font-size:8px; font-weight: bold; border-top: 0.1px solid #000;">'.$nameCentro.'</td>
                                    </tr>
                                ');
                            }

                            //<td style="border:0.1px solid #333333; width:10%;text-align:center; font-size:8px;">'.strtoupper($dato->tipodoc).'</td>
                            $estructura .= trim('
                                <tr>
                                    <td style="width: 5%;text-align:center; font-size:7px;">'.date_format(date_create($dato->doc_fecha), 'd/m/y').'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionFin.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlFin.'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor3, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor2, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor1, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor2 + $dato->valor1 + $dato->valor5 + $dato->valor10 + $dato->valor13), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->monto_sujeto_retencion, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor4, 2),2).'</td>
                                </tr>
                            ');

                            $total_exento += $dato->valor2;
                            $total_gravado += $dato->valor1;
                            $total_nsujeta += $dato->valor3;
                            $total_exportg += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                            $total_retencion += $dato->valor4;
                            $total_msujeto_retencion += $dato->monto_sujeto_retencion;

                            $idCentroAct = $dato->idcentro;
                        }
                    }
                    $extra = ($datos->num_rows() >= 23 && $datos->num_rows() <= 43) ? '<br pagebreak="true"/>' : '';
                }
                #   TOTALES
                $total = $total_exento + $total_gravado + $total_nsujeta + $total_exportg;

                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;

                $bruto_total = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $dev_total = $gravado_dev  + $exento_dev + $exportg_dev + $nsujeta_dev;
                $neto_total = $gravado_neto  + $exento_neto + $exportg_neto + $nsujeta_neto;
                $iva_total = $gravado_iva  + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = $gravado_total  + $exento_total + $exportg_total + $nsujeta_total;
                $estructura .= trim('
                        <tr>
                            <td style="width: 5%;text-align:center; font-size:9px;"></td>
                            <td style="width:15%;text-align:center; font-size:8px;"></td>
                            <td style="width:15%;text-align:center; font-size:8px;"></td>
                            <td style="width:15%;text-align:center; font-size:8px;"></td>
                            <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion, 2),2).'</td>
                            <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        </tr>
                        <tr><td style="font-size: 12px;"></td></tr>
                    </table>
                    '.$extra.'
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                           
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            } else {
                $pdf->addPage('L', 'LETTER');

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $percibido_bruto = 0;
                $retencion_bruto = 0;
                #   PROCESOS
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10 + $dato->valor6);
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                #   TOTALES
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;

                $total_bruto = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $total_dev = $gravado_dev + $exento_dev + $exportg_dev + $nsujeta_dev;
                $total_iva = $gravado_iva + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = ($total_neto = $total_bruto - $total_dev) + $total_iva;

                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroConsumidorFinalOld3($extra) {
            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas Consumidor Final');
            $pdf->SetSubject('Libro de Ventas Consumidor Final');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');

            $fecha = new DateTime();
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $tipo = $extra['t'];
            $idlibro = $extra['idl'];

            $fechaini = $ida.'-'.$idmes.'-01';
            $this->load->model('iva_model');
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('variable_model');
            $this->load->model('sucursal_model');

            $nombreFormato  = "LIBRO DE VENTAS CONSUMIDOR FINAL";//$this->global_model->getFormatosNombre($this->uri->segment(3));
            $NRC            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $direccion      = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $nameContador   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }
            

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);

            //<tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">'.$direccion.'</td></tr>
                    <tr>
                        <td style="text-align:right; font-size:15px; width:40%;">N.I.T.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td>
                        <td style="width:20%;"></td>
                        <td style="text-align: left; font-size:15px; width:40%;">N.R.C.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td>
                    </tr>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);

            if ($tipo == 0) {
                $orientacion = $this->global_model->getValorNumVariable("iva_orientacion_l1");
                if($orientacion == 0){
                    $pdf->addPage('L', 'LETTER');

                }else{
                    $pdf->addPage('P', 'LETTER');

                }
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */

                // <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Tipo de Operación</th>

                $estructura = trim('
                    <table>
                        <thead>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width: 5%; font-weight:bold; text-align:center; font-size:10px;" rowspan="2"><br><br>Día</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Generación Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Genereción Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:35%; font-weight:bold; text-align:center; font-size:11px;" colspan="5">VENTAS</th>
                            </tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>No Sujetas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Exentas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Gravadas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" >Exportaciones</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Totales</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Monto Sujeto a Retención</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Retención 1%</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                ');
                $total_exento = 0; $total_gravado = 0; $total_nsujeta = 0; $total_exportg = 0;
                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0; $total_retencion = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0; $total_msujeto_retencion = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0; $idCentroAct = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0; $idCentroAnt = 0;
                $total_exento_suc = 0; $total_gravado_suc = 0; $total_nsujeta_suc = 0; 
                $total_exportg_suc = 0; $total_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0;
                $extra = '';
                #   PROCESOS
                if ($this->dev_model->multiIvaCentral(1, $ida)) {
                    $datos = $this->dev_model->multiIvaCentral(2, [
                        'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam
                    ]);
                    if ($datos->num_rows() > 0) {
                        $datosArray = $datos->result();
                        /*  INICIO FILTRO */
                        switch ($filtro) {
                            case 1: // orden de digitacion
                                $idrec = array_column($datosArray , 'idrec');
                                array_multisort($idrec, $orden, $datosArray );
                                break;

                            case 2: // fecha de digitacion
                                $fecha = array_column($datosArray , 'fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                            case 3: // fecha del documento
                                $fecha = array_column($datosArray , 'doc_fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                        }
                        /*  FIN FILTRO  */

                        foreach ($datosArray as $key => $dato) {
                            //$this->highlight_array($dato);
                            $dia = date_format(date_create($dato->doc_fecha),'d');
                            $num = explode("|", $dato->doc_numero);
                            if (count($num) > 1) {
                                $num1 = $num[0];
                                $num2 = $num[1];

                                $cGeneracionIni = $dato->doc_serie.$num1;
                                $numeControlIni = $dato->doc_serie.$num1;

                                $cGeneracionFin = $dato->doc_serie.$num2;
                                $numeControlFin = $dato->doc_serie.$num2;
                            } else {
                                $datoNumeradores = $this->dev_model->multiIvaCentral(2.2, [
                                    'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam, 'fecha' => $dato->doc_fecha,
                                    'serie' => $dato->doc_serie
                                ]);
                                $datoNums = explode("|", $datoNumeradores);
                                $infNum1 = explode(":", $datoNums[0]);
                                $infNum2 = explode(":", $datoNums[1]);
                                $num1 = $infNum1[1];
                                $num2 = $infNum2[1];

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum1[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum1[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionIni = $infoDTE->cgeneracion;
                                        $numeControlIni = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionIni = $dato->doc_serie.$num1;
                                        $numeControlIni = $dato->doc_serie.$num1;
                                    }
                                } else {
                                    $cGeneracionIni = $dato->doc_serie.$num1;
                                    $numeControlIni = $dato->doc_serie.$num1;
                                }

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum2[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum2[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionFin = $infoDTE->cgeneracion;
                                        $numeControlFin = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionFin = $dato->doc_serie.$num2;
                                        $numeControlFin = $dato->doc_serie.$num2;
                                    }
                                } else {
                                    $cGeneracionFin = $dato->doc_serie.$num2;
                                    $numeControlFin = $dato->doc_serie.$num2;
                                }
                            }

                            $gravado_bruto += $dato->valor1;
                            $gravado_iva += $dato->valor0;
                            $exento_bruto += $dato->valor2;
                            $nsujeta_bruto += $dato->valor3;
                            $exportg_bruto += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);

                            $dato->valor1 = $dato->valor1 + $dato->valor0;
                            $idcentroAnt = $dato->idcentro;

                            if ($idcentroAnt != $idCentroAct && $idCentroAct != 0) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 5%;text-align:center; font-size:9px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    </tr>
                                    <tr><td style="font-size: 12px;"></td></tr>
                                ');

                                $total_exento_suc = 0; $total_gravado_suc = 0; $total_nsujeta_suc = 0; $total_exportg_suc = 0; $total_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0;

                                $total_exento_suc = $total_exento_suc + $dato->valor2;
                                $total_gravado_suc = $total_gravado_suc + $dato->valor1;
                                $total_nsujeta_suc = $total_nsujeta_suc + $dato->valor3;
                                $total_exportg_suc = $total_exportg_suc + ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                                $total_retencion_suc += $dato->valor4;
                                $total_msujeto_retencion_suc += $dato->monto_sujeto_retencion;
                                $total_suc = ($total_nsujeta_suc + $total_exento_suc + $total_gravado_suc + $total_exportg_suc);
                            } else {
                                $total_exento_suc = $total_exento_suc + $dato->valor2;
                                $total_gravado_suc = $total_gravado_suc + $dato->valor1;
                                $total_nsujeta_suc = $total_nsujeta_suc + $dato->valor3;
                                $total_exportg_suc = $total_exportg_suc + ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                                $total_retencion_suc += $dato->valor4;
                                $total_msujeto_retencion_suc += $dato->monto_sujeto_retencion;
                                $total_suc = ($total_nsujeta_suc + $total_exento_suc + $total_gravado_suc + $total_exportg_suc);
                            }

                            $nameCentro = $this->sucursal_model->getNameCentro($dato->idcentro);
                            if ($idcentroAnt != $idCentroAct) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 100%;text-align:left; font-size:8px; font-weight: bold; border-top: 0.1px solid #000;">'.$nameCentro.'</td>
                                    </tr>
                                ');
                            }

                            //<td style="border:0.1px solid #333333; width:10%;text-align:center; font-size:8px;">'.strtoupper($dato->tipodoc).'</td>
                            $estructura .= trim('
                                <tr>
                                    <td style="width: 5%;text-align:center; font-size:7px;">'.date_format(date_create($dato->doc_fecha), 'd/m/y').'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionFin.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlFin.'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor3, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor2, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor1, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor2 + $dato->valor1 + $dato->valor5 + $dato->valor10 + $dato->valor13), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->monto_sujeto_retencion, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor4, 2),2).'</td>
                                </tr>
                            ');

                            if ($key == array_key_last($datosArray)) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 5%;text-align:center; font-size:9px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    </tr>
                                    <tr><td style="font-size: 12px;"></td></tr>
                                ');
                            }

                            $total_exento += $dato->valor2;
                            $total_gravado += $dato->valor1;
                            $total_nsujeta += $dato->valor3;
                            $total_exportg += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                            $total_retencion += $dato->valor4;
                            $total_msujeto_retencion += $dato->monto_sujeto_retencion;

                            $idCentroAct = $dato->idcentro;
                        }
                    }
                    $extra = ($datos->num_rows() >= 23 && $datos->num_rows() <= 43) ? '<br pagebreak="true"/>' : '';
                }
                #   TOTALES
                $total = $total_exento + $total_gravado + $total_nsujeta + $total_exportg;

                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;

                $bruto_total = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $dev_total = $gravado_dev  + $exento_dev + $exportg_dev + $nsujeta_dev;
                $neto_total = $gravado_neto  + $exento_neto + $exportg_neto + $nsujeta_neto;
                $iva_total = $gravado_iva  + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = $gravado_total  + $exento_total + $exportg_total + $nsujeta_total;
                
                $estructura .= trim('</table>'.$extra.'
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                           
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            } else {
                $pdf->addPage('L', 'LETTER');

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $percibido_bruto = 0;
                $retencion_bruto = 0;
                #   PROCESOS
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10 + $dato->valor6);
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                #   TOTALES
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;

                $total_bruto = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $total_dev = $gravado_dev + $exento_dev + $exportg_dev + $nsujeta_dev;
                $total_iva = $gravado_iva + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = ($total_neto = $total_bruto - $total_dev) + $total_iva;

                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroConsumidorFinal($extra) {
            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas Consumidor Final');
            $pdf->SetSubject('Libro de Ventas Consumidor Final');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');

            $fecha = new DateTime();
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $tipo = $extra['t'];
            $idlibro = $extra['idl'];

            $fechaini = $ida.'-'.$idmes.'-01';
            $this->load->model('iva_model');
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('global_model');
            $this->load->model('variable_model');
            $this->load->model('sucursal_model');

            $nombreFormato  = "LIBRO DE VENTAS CONSUMIDOR FINAL";//$this->global_model->getFormatosNombre($this->uri->segment(3));
            $NRC            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $direccion      = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $nameContador   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }
            

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);

            //<tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">'.$direccion.'</td></tr>
                    <tr>
                        <td style="text-align:right; font-size:15px; width:40%;">N.I.T.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td>
                        <td style="width:20%;"></td>
                        <td style="text-align: left; font-size:15px; width:40%;">N.R.C.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td>
                    </tr>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);

            if ($tipo == 0) {
                $orientacion = $this->global_model->getValorNumVariable("iva_orientacion_l1");
                if($orientacion == 0){
                    $pdf->addPage('L', 'LETTER');

                }else{
                    $pdf->addPage('P', 'LETTER');

                }
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */

                // <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size: 9px;" rowspan="2"><br><br>Tipo de Operación</th>

                $estructura = trim('
                    <table>
                        <thead>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width: 5%; font-weight:bold; text-align:center; font-size:10px;" rowspan="2"><br><br>Día</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Generación Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Código de Genereción Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Inicial</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:15%; font-weight:bold; text-align:center; font-size: 8px;" rowspan="2"><br><br>Número de Control Final</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:35%; font-weight:bold; text-align:center; font-size:11px;" colspan="5">VENTAS</th>
                            </tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>No Sujetas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Exentas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Gravadas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" >Exportaciones</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Totales</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Monto Sujeto a Retención</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size: 8px;" ><br>Retención 1%</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                ');
                $total_exento = 0; $total_gravado = 0; $total_nsujeta = 0; $total_exportg = 0;
                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0; $total_retencion = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0; $total_msujeto_retencion = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0; $idCentroAct = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0; $idCentroAnt = 0;
                $total_exento_suc = 0; $total_gravado_suc = 0; $total_nsujeta_suc = 0; 
                $total_exportg_suc = 0; $total_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0;
                $extra = '';
                #   PROCESOS
                if ($this->dev_model->multiIvaCentral(1, $ida)) {
                    $datos = $this->dev_model->multiIvaCentral(2, [
                        'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam
                    ]);
                    if ($datos->num_rows() > 0) {
                        $datosArray = $datos->result();
                        /*  INICIO FILTRO */
                        switch ($filtro) {
                            case 1: // orden de digitacion
                                $idrec = array_column($datosArray , 'idrec');
                                array_multisort($idrec, $orden, $datosArray );
                                break;

                            case 2: // fecha de digitacion
                                $fecha = array_column($datosArray , 'fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                            case 3: // fecha del documento
                                $fecha = array_column($datosArray , 'doc_fecha');
                                array_multisort($fecha, $orden, $datosArray );                                
                                break;
                        }
                        /*  FIN FILTRO  */

                        foreach ($datosArray as $key => $dato) {
                            //$this->highlight_array($dato);
                            $dia = date_format(date_create($dato->doc_fecha),'d');
                            $num = explode("|", $dato->doc_numero);
                            if (count($num) > 1) {
                                $num1 = $num[0];
                                $num2 = $num[1];

                                $cGeneracionIni = $dato->doc_serie.$num1;
                                $numeControlIni = $dato->doc_serie.$num1;

                                $cGeneracionFin = $dato->doc_serie.$num2;
                                $numeControlFin = $dato->doc_serie.$num2;
                            } else {
                                $datoNumeradores = $this->dev_model->multiIvaCentral(2.2, [
                                    'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam, 'fecha' => $dato->doc_fecha,
                                    'serie' => $dato->doc_serie
                                ]);
                                $datoNums = explode("|", $datoNumeradores);
                                $infNum1 = explode(":", $datoNums[0]);
                                $infNum2 = explode(":", $datoNums[1]);
                                $num1 = $infNum1[1];
                                $num2 = $infNum2[1];

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum1[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum1[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionIni = $infoDTE->cgeneracion;
                                        $numeControlIni = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionIni = $dato->doc_serie.$num1;
                                        $numeControlIni = $dato->doc_serie.$num1;
                                    }
                                } else {
                                    $cGeneracionIni = $dato->doc_serie.$num1;
                                    $numeControlIni = $dato->doc_serie.$num1;
                                }

                                $infoDTE = $this->dte_model->validateExistDocumentDte($infNum2[0], 1, $ida);

                                if (!$infoDTE) {
                                    $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum2[1], $dato->idcentro, $dato->idcaja);
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                                    if ($infoDTE) {
                                        $cGeneracionFin = $infoDTE->cgeneracion;
                                        $numeControlFin = $infoDTE->ncontrol;
                                    } else {
                                        $cGeneracionFin = $dato->doc_serie.$num2;
                                        $numeControlFin = $dato->doc_serie.$num2;
                                    }
                                } else {
                                    $cGeneracionFin = $dato->doc_serie.$num2;
                                    $numeControlFin = $dato->doc_serie.$num2;
                                }
                            }

                            $gravado_bruto += $dato->valor1;
                            $gravado_iva += $dato->valor0;
                            $exento_bruto += $dato->valor2;
                            $nsujeta_bruto += $dato->valor3;
                            $exportg_bruto += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);

                            $dato->valor1 = $dato->valor1 + $dato->valor0;
                            $idcentroAnt = $dato->idcentro;

                            if ($idcentroAnt != $idCentroAct && $idCentroAct != 0) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 5%;text-align:center; font-size:9px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    </tr>
                                    <tr><td style="font-size: 12px;"></td></tr>
                                ');

                                $total_exento_suc = 0; $total_gravado_suc = 0; $total_nsujeta_suc = 0; $total_exportg_suc = 0; $total_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0;

                                $total_exento_suc = $total_exento_suc + $dato->valor2;
                                $total_gravado_suc = $total_gravado_suc + $dato->valor1;
                                $total_nsujeta_suc = $total_nsujeta_suc + $dato->valor3;
                                $total_exportg_suc = $total_exportg_suc + ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                                $total_retencion_suc += $dato->valor4;
                                $total_msujeto_retencion_suc += $dato->monto_sujeto_retencion;
                                $total_suc = ($total_nsujeta_suc + $total_exento_suc + $total_gravado_suc + $total_exportg_suc);
                            } else {
                                $total_exento_suc = $total_exento_suc + $dato->valor2;
                                $total_gravado_suc = $total_gravado_suc + $dato->valor1;
                                $total_nsujeta_suc = $total_nsujeta_suc + $dato->valor3;
                                $total_exportg_suc = $total_exportg_suc + ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                                $total_retencion_suc += $dato->valor4;
                                $total_msujeto_retencion_suc += $dato->monto_sujeto_retencion;
                                $total_suc = ($total_nsujeta_suc + $total_exento_suc + $total_gravado_suc + $total_exportg_suc);
                            }

                            $nameCentro = $this->sucursal_model->getNameCentro($dato->idcentro);
                            if ($idcentroAnt != $idCentroAct) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 100%;text-align:left; font-size:8px; font-weight: bold; border-top: 0.1px solid #000;">'.$nameCentro.'</td>
                                    </tr>
                                ');
                            }

                            //<td style="border:0.1px solid #333333; width:10%;text-align:center; font-size:8px;">'.strtoupper($dato->tipodoc).'</td>
                            $estructura .= trim('
                                <tr>
                                    <td style="width: 5%;text-align:center; font-size:7px;">'.date_format(date_create($dato->doc_fecha), 'd/m/y').'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$cGeneracionFin.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlIni.'</td>
                                    <td style="width:15%;text-align:center; font-size:7px;">'.$numeControlFin.'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor3, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor2, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor1, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round(($dato->valor2 + $dato->valor1 + $dato->valor5 + $dato->valor10 + $dato->valor13), 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->monto_sujeto_retencion, 2),2).'</td>
                                    <td style="width: 5%;text-align:right; font-size:7px;">'.number_format(round($dato->valor4, 2),2).'</td>
                                </tr>
                            ');

                            if ($key == array_key_last($datosArray)) {
                                $estructura .= trim('
                                    <tr>
                                        <td style="width: 5%;text-align:center; font-size:9px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:center; font-size:8px;"></td>
                                        <td style="width:15%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">TOTALES</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_exportg_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                        <td style="width: 5%;text-align:right; font-size:8px; border-top: 2px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    </tr>
                                    <tr><td style="font-size: 12px;"></td></tr>
                                ');
                            }

                            $total_exento += $dato->valor2;
                            $total_gravado += $dato->valor1;
                            $total_nsujeta += $dato->valor3;
                            $total_exportg += ($dato->valor5 + $dato->valor10 + $dato->valor13 + $dato->valor6);
                            $total_retencion += $dato->valor4;
                            $total_msujeto_retencion += $dato->monto_sujeto_retencion;

                            $idCentroAct = $dato->idcentro;
                        }
                    }
                    $extra = ($datos->num_rows() >= 23 && $datos->num_rows() <= 43) ? '<br pagebreak="true"/>' : '';
                }
                #   TOTALES
                $total = $total_exento + $total_gravado + $total_nsujeta + $total_exportg;

                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;

                $bruto_total = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $dev_total = $gravado_dev  + $exento_dev + $exportg_dev + $nsujeta_dev;
                $neto_total = $gravado_neto  + $exento_neto + $exportg_neto + $nsujeta_neto;
                $iva_total = $gravado_iva  + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = $gravado_total  + $exento_total + $exportg_total + $nsujeta_total;
                
                $estructura .= trim('</table>'.$extra.'
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid black;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                           
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTAL RETENCIÓN</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_retencion, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            } else {
                $pdf->addPage('L', 'LETTER');

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $percibido_bruto = 0; $total_retencion = 0;
                $retencion_bruto = 0;
                #   PROCESOS
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10 + $dato->valor6);
                        $nsujeta_bruto += $dato->valor3;
                        $total_retencion += $dato->valor4;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                #   TOTALES
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;

                $total_bruto = $gravado_bruto + $exento_bruto + $exportg_bruto + $nsujeta_bruto;
                $total_dev = $gravado_dev + $exento_dev + $exportg_dev + $nsujeta_dev;
                $total_iva = $gravado_iva + $exento_iva + $exportg_iva + $nsujeta_iva;
                $total_total = ($total_neto = $total_bruto - $total_dev) + $total_iva;

                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                            <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                        </tr>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                            </tr>
                            <tr>
                                <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                            </tr>
                            <hr style="width:100%;"><br><hr style="width:100%;">
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_bruto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_dev, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_neto, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_iva, 2),2).'</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_total, 2),2).'</td>
                            </tr>
                            <tr style="border-top: 1px double black;">
                                <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES RETENCIÓN</td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;"></td>
                                <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total_retencion, 2),2).'</td>
                            </tr>
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesOld($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    foreach ($datosArray as $key => $dato) {
                        $total_exento += $dato->valor2;
                        $total_nsujeta += $dato->valor3;
                        $total_gravado += $dato->valor1;
                        $total_iva += $dato->valor0;

                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $total = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_retencion += $dato->valor4;
                            $retencion = $dato->valor4;
                            $total = $dato->valor0 + $dato->valor1 + $dato->valor2 + $dato->valor3 + $dato->valor4;
                        
                        }else{
                            $total = $dato->valor0 + $dato->valor1 + $dato->valor2 + $dato->valor3;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:9px;">'.strtoupper($dato->doc_serie.$dato->doc_numero).'</td>
                                <td style="width:6%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:24%;text-align:left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:7%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );  
                        
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos.trim('
                    <tr>
                        <td colspan="6" style="width:45%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:7%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ');
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$this->session->userdata('nameCentroUser').'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:24%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:48.2%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                         //ES DOC DE RETENCION
                         if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;  
                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                        }else{
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                        }

                        $gravado_iva += $dato->valor0;
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto + $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto + $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesOldV2($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $total = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            
                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento -= $exento;
                            $total_nsujeta -= $nsujeto;
                            $total_gravado -= $gravado;
                            $total_iva -= $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:9px;">'.strtoupper($dato->doc_serie.$dato->doc_numero).'</td>
                                <td style="width:6%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:24%;text-align:left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:7%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );  
                        
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos.trim('
                    <tr>
                        <td colspan="6" style="width:45%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:7%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ');
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:24%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:48.2%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva -= $dato->valor0;

                        }else{
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }


                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesOld3($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $this->load->model('dte_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $total = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            
                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $infoDTE = $this->dte_model->validateExistDocumentDte($dato->idrec, 1, $ida);

                        if (!$infoDTE) {
                            $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $dato->doc_numero, $dato->idcentro, $dato->idcaja);
                            $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                            if ($infoDTE) {
                                $numeroDocumento = $infoDTE->cgeneracion;
                            }
                        } else {
                            $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:9px;">'.$numeroDocumento.'</td>
                                <td style="width:6%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:24%;text-align:left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:7%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );  
                        
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos.trim('
                    <tr>
                        <td colspan="6" style="width:45%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:7%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ');
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:24%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:48.2%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }else{
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;
                        }
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesOld4($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $this->load->model('dte_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $total = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            
                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $infoDTE = $this->dte_model->validateExistDocumentDte($dato->idrec, 1, $ida);

                        if (!$infoDTE) {
                            $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $dato->doc_numero, $dato->idcentro, $dato->idcaja);
                            $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                            if ($infoDTE) {
                                $numeroDocumento = $infoDTE->cgeneracion;
                            } else {
                                $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                            }
                        } else {
                            $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:9px;">'.$numeroDocumento.'</td>
                                <td style="width:6%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:24%;text-align:left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:7%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );  
                        
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos.trim('
                    <tr>
                        <td colspan="6" style="width:45%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:7%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ');
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:24%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:48.2%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:7.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);
                //var_dump($datos);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //var_dump($dato->valor2);
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }else{
                            $exento_bruto += $dato->valor2;
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;
                        }
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesNew($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $this->load->model('dte_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $data           = $this->iva_model->getdocumentosToCSV1($idlibro, $ida, $idam);
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            //var_dump($data);
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $exportaciones = ($dato->valor5 + $dato->valor6);  
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $total = 0;
                        $total_exportaciones = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            $total_exportaciones += $exportaciones;

                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            $total_exportaciones += $exportaciones;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            $total_exportaciones += $exportaciones;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        //R

                        $numeroInicial = '';
                            $numeroFinal   = '';
                            foreach($data->result() as $info){
                                if ( strpos($info->doc_serie, 'DTE') === false ){
                                    $docResolucion   = str_replace('-', '', $info->doc_res);
                                    $docSerie        = $info->doc_serie;
                                    $docSerieDiff    = $info->doc_serie;
                                    $numeroDocumento = $info->doc_numero;
                                    $documentClase   = $info->doc_clase;
        
                                    $numDocs = explode('|', $info->doc_numero);                                                                

                                    if ( count($numDocs) > 1 ) { 
                                        $numeroInicial = $numDocs[0]; $numeroFinal = $numDocs[1]; 
                                        
                                    } else {   
                                        $numeroInicialInt = $numeroDocumento;
                                        $numeroFinalInt   = $numeroDocumento; 
                                        $numeroInicial    = $numeroDocumento;
                                        $numeroFinal      = $numeroDocumento; 
                                    }
                                } else {
                                    $infoDTE = $this->dte_model->validateExistDocumentDte($info->idrec, 1, $ida);
                                    
                                    
                                    if (!$infoDTE) {
                                        $trannum = $this->iva_model->getTrannumDocumentImport($info->doc_serie, $info->doc_numero, $info->idcentro, $info->idcaja);
                                        $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);
        
                                        if ($infoDTE) {
                                            $docResolucion   = 'N/A';
                                            $docSerie        = 'N/A';
                                            $docSerieDiff    = $info->doc_serie;
                                            $numeroDocumento = $infoDTE->cgeneracion;
                                            $documentClase   = 4;
        
                                            $numeroInicialInt = 'N/A';
                                            $numeroFinalInt   = 'N/A';
                                            $numeroInicial    = $numeroDocumento;
                                            $numeroFinal      = $numeroDocumento;
                                            
                                        } else continue;
                                        
                                    }
                                    
                                }
                                                   
                            }


                        $creditos .= trim(/*'
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:9px;">'.strtoupper($dato->doc_serie.$dato->doc_numero).'</td>
                                <td style="width:6%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:24%;text-align:left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:5%;text-align:right; font-size:9px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:7%;text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'*/

                            '
                            <tr>
                                <td style="width:3%;text-align:center; font-size:9px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:14%;text-align:center; font-size:9px;">'.$infoDTE->cgeneracion.'</td>
                                <td style="width:6%;text-align:center; font-size:9px;"></td>
                                <td style="width:14.8%;text-align:right; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                                
                                <td style="width:6%;text-align:center; font-size:9px;">'.trim($dato->nrc).'</td>
                                <td style="width:6%;text-align:right; font-size:9px;">'.number_format(round($exportaciones, 2),2).'</td>
                                <td style="width:6%; text-align:right; font-size:9px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:7%; text-align:right; font-size:9px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:4%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:5.8%;text-align:right; font-size:9px;">'.number_format($total, 2).'</td>
                            </tr>'

                        );  
                        
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion + $total_exportaciones;
                $totalesr = $creditos.trim(/*'
                    <tr>
                        <td colspan="6" style="width:45%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:5%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:7%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                '*/
                    '
                    <tr>
                        <td colspan="6" style="width:50.8%;text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:6.8%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exportaciones, 2),2).'</td>
                        <td style="width:6%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:7%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:4%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:5.8%; text-align:right; font-size:10px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ' );
                
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15.8%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 14.2%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:10px;" >No<br>Corr.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:10px;" >Fecha</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:14%; font-weight:bold; text-align:center; font-family: serif; font-size:10px; line-height: 20px;" >Codigo de Generacion</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:10px;" >Form<br>Unico</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:14.8%; font-weight:bold; text-align:center; font-family: serif; font-size:10px;">Cliente</th>
                                
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:10px; line-height: 15px;" >NRC</th>
                            
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10px; line-height: 15px;">Exportaciones</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:10px; ">Ventas<br>Gravadas</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-size:10px; line-height: 15px;">Debito<br>Fiscal</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:10px; line-height: 15px;">Venta a Cuenta<br> de Terceros</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10px;">Debito Fiscal a<br> Cuenta de<br>Terceros</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:4.8%; font-weight:bold; text-align:center; font-size:10px;">Impuesto <br>percibido</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:10px;">Retencion</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.8%; font-weight:bold; text-align:center; font-size:10px;">Ventas<br>Totales</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);

                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }else{
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;
                        }
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentesOld5($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];
            
        

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $this->load->model('dte_model');
            $this->load->model('sucursal_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0; $total_msujeto_retencion = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    $idCentroAct = 0;
                    $idCentroAnt = 0;

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $msujeto_retencion = ($dato->valor4 != 0) ? $dato->valor1 : 0;
                        $total = 0;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            
                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;
                            $total_msujeto_retencion += $msujeto_retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $infoDTE = $this->dte_model->validateExistDocumentDte($dato->idrec, 1, $ida);

                        if (!$infoDTE) {
                            $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $dato->doc_numero, $dato->idcentro, $dato->idcaja);
                            $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                            if ($infoDTE) {
                                $numeroDocumento = $infoDTE->cgeneracion;
                            } else {
                                $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                            }
                        } else {
                            $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                        }

                        $idcentroAnt = $dato->idcentro;
                        $nameCentro = $this->sucursal_model->getNameCentro($dato->idcentro);
                        if ($idcentroAnt != $idCentroAct) {
                            $creditos .= trim('
                                <tr>
                                    <td style="width: 100%;text-align:left; font-size:8px; font-weight: bold; border-top: 0.1px solid #000;">'.$nameCentro.'</td>
                                </tr>
                            ');
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:8px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:8px;">'.$numeroDocumento.'</td>
                                <td style="width:6%;text-align:center; font-size:8px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:23%;text-align:left; font-size:8px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:8px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:4.4%;text-align:right; font-size:8px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:4.4%;text-align:right; font-size:8px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:6.4%;text-align:right; font-size:8px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:8px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round($msujeto_retencion, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:8px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );

                        $idCentroAct = $dato->idcentro;
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos.trim('
                    <tr>
                        <td colspan="6" style="width:44%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento, 2),2).'</td>
                        <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta, 2),2).'</td>
                        <td style="width:6.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado, 2),2).'</td>
                        <td style="width:6%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva, 2),2).'</td>
                        <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion, 2),2).'</td>
                        <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    </tr>
                    <tr><td colspan="10"><br><br><br></td></tr>
                ');
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:8px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:23%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:49.2%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:8px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:4.4%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:4.4%; font-weight:bold; text-align:center; font-size:6.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.4%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.2%; font-weight:bold; text-align:center; font-size:6.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.2%; font-weight:bold; text-align:center; font-size:6.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px;">MONTO SUJETO A RETENCIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);
                //var_dump($datos);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //var_dump($dato->valor2);
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }else{
                            $exento_bruto += $dato->valor2;
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;
                        }
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroVentasContribuyentes($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];
            $tipo = $extra['t'];

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $this->load->model('dte_model');
            $this->load->model('sucursal_model');
            $nombreFormato = 'LIBRO DE VENTAS A CONTRIBUYENTES';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Ventas a Contribuyentes');
            $pdf->SetSubject('Libro de Ventas a Contribuyentes');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            $pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            if ($tipo == 0) {
                /*  INICIO FILTROS  */
                $arrayFiltro = explode("-", $extra['filtro']); 
                $filtro = $arrayFiltro[0];
                if($arrayFiltro[1] == 1){
                    $orden = SORT_ASC;
                }
                if($arrayFiltro[1] == 2){
                    $orden = SORT_DESC;
                }
                /*  FIN FILTROS  */
                $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $pdf->setPrintHeader(false);
                $pdf->addPage('L', 'LETTER');
                $total_exento = 0; $total_nsujeta= 0; $total_gravado = 0;  $total_iva = 0; $total_retencion = 0; $total_total = 0; $total_msujeto_retencion = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                $creditos = '';
                if ($datos->num_rows() > 0) {

                    $datosArray = $datos->result();
                    /*  INICIO FILTRO */
                    switch ($filtro) {
                        case 1: // orden de digitacion
                            $idrec = array_column($datosArray , 'idrec');
                            array_multisort($idrec, $orden, $datosArray );
                            break;
                        case 2: // fecha de digitacion
                            $fecha = array_column($datosArray , 'fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 3: // fecha del documento
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $cliente = array_column($datosArray , 'cliente');
                            array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                            break;
                        case 4: // nombre del contribuyente
                            $cliente = array_column($datosArray , 'cliente');
                            $fecha = array_column($datosArray , 'doc_fecha');
                            array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                            break;
                        case 5: // nombre del contribuyente
                            $fecha = array_column($datosArray , 'doc_fecha');
                            $documento = array_column($datosArray , 'numDocumento');
                            array_multisort($fecha, SORT_ASC, $documento, $orden, $datosArray );                                
                            break;
                    }
                    /*  FIN FILTRO  */

                    $idCentroAct = 0;
                    $idCentroAnt = 0;
                    $total_exento_suc = 0; $total_nsujeta_suc = 0; $total_gravado_suc = 0; $total_iva_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0; $total_total_suc = 0;

                    foreach ($datosArray as $key => $dato) {
                       
                        $exento = $dato->valor2;
                        $nsujeto = $dato->valor3;
                        $gravado = $dato->valor1;
                        $iva = $dato->valor0;
                        $retencion = 0;
                        $msujeto_retencion = ($dato->valor4 != 0) ? $dato->valor1 : 0;
                        $total = 0;
                        $idcentroAnt = $dato->idcentro;

                        //ES DOCUMENTO DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;
                            
                            $retencion = $dato->valor4;
                            $total_retencion += $retencion;
                            $total_msujeto_retencion += $msujeto_retencion;

                            $total = $iva + $gravado + $nsujeto + $exento + $retencion;
                        
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;

                        }else{
                            $total_exento += $exento;
                            $total_nsujeta += $nsujeto;
                            $total_gravado += $gravado;
                            $total_iva += $iva;

                            $total = $iva + $gravado + $nsujeto + $exento;
                        }

                        if($total == 0){
                            $dato->cliente = $dato->cliente." [ANULADO]";
                        }

                        $infoDTE = $this->dte_model->validateExistDocumentDte($dato->idrec, 1, $ida);

                        if (!$infoDTE) {
                            $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $dato->doc_numero, $dato->idcentro, $dato->idcaja);
                            $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                            if ($infoDTE) {
                                $numeroDocumento = $infoDTE->cgeneracion;
                            } else {
                                $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                            }
                        } else {
                            $numeroDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                        }

                        $nameCentro = $this->sucursal_model->getNameCentro($dato->idcentro);

                        if ($idcentroAnt != $idCentroAct && $idCentroAct != 0) {
                            $creditos .= trim('
                                <tr>
                                    <td colspan="6" style="width:44%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                                    <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                    <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                    <td style="width:6.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                    <td style="width:6%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva_suc, 2),2).'</td>
                                    <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    <td style="width:6.8%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total_suc, 2),2).'</td>
                                </tr>
                                <tr><td colspan="10"><br><br></td></tr>
                            ');

                            $total_exento_suc = 0; $total_nsujeta_suc = 0; $total_gravado_suc = 0; $total_iva_suc = 0; $total_retencion_suc = 0; $total_msujeto_retencion_suc = 0; $total_total_suc = 0;

                            $total_exento_suc += $dato->valor2;
                            $total_nsujeta_suc += $dato->valor3;
                            $total_gravado_suc += $dato->valor1;
                            $total_iva_suc += $dato->valor0;
                            $total_retencion_suc += $dato->valor4;
                            $total_msujeto_retencion_suc += ($dato->valor4 != 0) ? $dato->valor1 : 0;
                            $total_total_suc = $total_exento_suc + $total_nsujeta_suc + $total_gravado_suc + $total_iva_suc + $total_retencion_suc;
                        } else {
                            $total_exento_suc += $dato->valor2;
                            $total_nsujeta_suc += $dato->valor3;
                            $total_gravado_suc += $dato->valor1;
                            $total_iva_suc += $dato->valor0;
                            $total_retencion_suc += $dato->valor4;
                            $total_msujeto_retencion_suc += ($dato->valor4 != 0) ? $dato->valor1 : 0;
                            $total_total_suc = $total_exento_suc + $total_nsujeta_suc + $total_gravado_suc + $total_iva_suc + $total_retencion_suc;
                        }

                        if ($idcentroAnt != $idCentroAct) {
                            $creditos .= trim('
                                <tr>
                                    <td style="width: 100%;text-align:left; font-size:8px; font-weight: bold; border-top: 0.1px solid #000;">'.$nameCentro.'</td>
                                </tr>
                            ');
                        }

                        $creditos .= trim('
                            <tr>
                                <td style="width:3%;text-align:center; font-size:8px;">'.($key + 1).'</td>
                                <td style="width:7%;text-align:left; font-size:8px;">'.$numeroDocumento.'</td>
                                <td style="width:6%;text-align:center; font-size:8px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                                <td style="width:23%;text-align:left; font-size:8px;">'.strtoupper(trim($dato->cliente)).'</td>
                                <td style="width:5%;text-align:right; font-size:8px;">'.trim($dato->nrc).'</td>
                                
                                <td style="width:4.4%;text-align:right; font-size:8px;">'.number_format(round($exento, 2),2).'</td>
                                <td style="width:4.4%;text-align:right; font-size:8px;">'.number_format(round($nsujeto, 2),2).'</td>
                                <td style="width:6.4%;text-align:right; font-size:8px;">'.number_format(round($gravado, 2),2).'</td>
                                <td style="width:6%;text-align:right; font-size:8px;">'.number_format(round($iva, 2),2).'</td>
                                <td style="width:6.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:6.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round(0, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round($msujeto_retencion, 2),2).'</td>
                                <td style="width:5.2%;text-align:right; font-size:8px;">'.number_format(round($retencion, 2),2).'</td>

                                <td style="width:6.8%;text-align:right; font-size:8px;">'.number_format($total, 2).'</td>
                            </tr>'
                        );

                        if ($key == array_key_last($datosArray)) {
                            $creditos .= trim('
                                <tr>
                                    <td colspan="6" style="width:44%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">TOTALES</td>
                                    <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_exento_suc, 2),2).'</td>
                                    <td style="width:4.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_nsujeta_suc, 2),2).'</td>
                                    <td style="width:6.4%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_gravado_suc, 2),2).'</td>
                                    <td style="width:6%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_iva_suc, 2),2).'</td>
                                    <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:6.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_msujeto_retencion_suc, 2),2).'</td>
                                    <td style="width:5.2%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_retencion_suc, 2),2).'</td>
                                    <td style="width:6.8%;text-align:right; font-size:9px;border-top:1px solid #333333;font-weight:bold;">$'.number_format(round($total_total_suc, 2),2).'</td>
                                </tr>
                                <tr><td colspan="10"><br></td></tr>
                            ');
                        }

                        $idCentroAct = $dato->idcentro;
                    }
                }
                $total_total = $total_exento + $total_nsujeta + $total_gravado + $total_iva + $total_retencion;
                $totalesr = $creditos;
                $total_total = $total_exento + $total_nsujeta + $total_gravado + ($total_iva = abs($total_iva)) + ($total_retencion);
                $final = trim('
                    <table style="width:100%; font-family: serif;">
                        <tr>
                            <td style="width: 25%; font-size:12px; font-weight:bold;">RESUMEN DE OPERACIONES:</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >EXENTAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >GRAVADAS</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >DEBITO FISCAL</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >RETENCIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; font-weight:bold;" >TOTAL</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:12px; text-align:left;">Ventas a Contribuyentes:</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 25%; font-size:14px; text-align:left; font-weight:bold;border-top:1px solid black;">TOTAL DE OPERACIONES</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_iva, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_retencion, 2),2).'</td>
                            <td style="width: 15%; font-size:12px; text-align:right; border-top:1px solid black;" >$'.number_format(round($total_total, 2),2).'</td>
                        </tr>
                        <tr><td style="width: 100%; font-size: 24px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </table>
                ');
                $nameCentro = '';

                if($this->session->userdata('idaccount') != 279579){
                    $nameCentro = $this->session->userdata('nameCentroUser');
                }

                $estructura = trim('
                    <table style="width: 100%; font-family: serif; padding: 0;">
                        <thead>
                            <tr><td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">'.$RazonSocial.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NIT.: '.$NIT.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px;">NRC.: '.$NRC.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                            <tr><td style="width:100%; text-align:left; font-size:15px; font-weight: bold;">'.$nameCentro.'</td></tr>
                            <tr>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:3%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>N°</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2">NUM. CORRELATIVO PRE-IMPRESO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6%; font-weight:bold; text-align:center; font-family: serif; font-size:8px; line-height: 20px;" rowspan="2">F. EMISIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:23%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" rowspan="2"><br><br>N.R.C.</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:49.2%; font-weight:bold; text-align:center; font-family: serif; font-size:8px;" colspan="8">VENTAS INTERNAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle;  width:6.8%; font-weight:bold; text-align:center; font-family: serif; font-size:8px; line-height: 15px;" rowspan="2">VENTAS TOTALES</th>
                            </tr>
                            <tr>
                                <th style="width:0.0001%;"></th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:4.4%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">EXENTAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:4.4%; font-weight:bold; text-align:center; font-size:6.5px; ">NO<br>SUJETAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.4%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">GRAVADAS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">DEB. FISCAL</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.2%; font-weight:bold; text-align:center; font-size:6.5px;">VTA. A CTA. DE TERCEROS</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:6.2%; font-weight:bold; text-align:center; font-size:6.5px;">DEB. F. A CTA. DE TERCEROS </th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px;">IVA PERCIBIDO</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px;">MONTO SUJETO A RETENCIÓN</th>
                                <th style="border:0.1px solid #333333; vertical-align:middle; width:5.2%; font-weight:bold; text-align:center; font-size:6.5px; line-height: 23px;">RETENCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            '.$totalesr.'
                        </tbody>
                    </table>
                    '.$final.'
                ');//*/
            } else {
                $footer = trim('
                    <br><br><br><br><br><br>
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tbody style="padding:0px; margin:0px;">
                            <tr style="padding:0px; margin:0px;">
                                <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                                <th style="font-size:10px; text-align:center; width:40%;"></th>
                                <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                            </tr>
                        </tbody>
                    </table>
                ');

                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);
                $header = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                        <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"><br><br></td></tr>
                        <tr>
                            <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                            <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </td>
                        </tr>
                    </table>
                ');

                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                $pdf->addPage('L', 'LETTER');

                $bruto_total = 0; $dev_total = 0; $neto_total = 0; $iva_total = 0; $total = 0;
                $percibido_bruto = 0; $percibido_dev = 0; $percibido_iva = 0;
                $retencion_bruto = 0; $retencion_dev = 0; $retencion_iva = 0;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
                //$this->highlight_array($dato);
                //var_dump($datos);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //var_dump($dato->valor2);
                         //ES DOC DE RETENCION
                        if($dato->doc_clase == "1" && $dato->doc_tipo == "7"){
                            if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                            else $retencion_bruto += $dato->valor4;
                            $gravado_iva += $dato->valor0;

                        //ES NOTA DE CREDITO                      
                        }elseif($dato->doc_clase == "1" && $dato->doc_tipo == "5"){
                            $gravado_dev += $dato->valor1;
                            $exento_dev += $dato->valor2;
                            $nsujeta_dev += $dato->valor3;
                            $gravado_iva += $dato->valor0;

                        }else{
                            $exento_bruto += $dato->valor2;
                            $gravado_bruto += $dato->valor1;
                            $nsujeta_bruto += $dato->valor3;
                            $gravado_iva += $dato->valor0;
                        }
                    }
                }

                $gravado_total = ($gravado_neto = $gravado_bruto + $gravado_dev) + $gravado_iva + $retencion_bruto + $percibido_bruto;
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $contribuyentes = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');

                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total;

                $gravado_bruto = 0; $gravado_dev = 0; $gravado_iva = 0;
                $exento_bruto = 0; $exento_dev = 0; $exento_iva = 0;
                $exportg_bruto = 0; $exportg_dev = 0; $exportg_iva = 0;
                $exporte_bruto = 0; $exporte_dev = 0; $exporte_iva = 0;
                $nsujeta_bruto = 0; $nsujeta_dev = 0; $nsujeta_iva = 0;
                $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => 1, 'idam' => $idam]);
                if ($datos->num_rows() > 0) {
                    foreach ($datos->result() as $key => $dato) {
                        //$this->highlight_array($dato);
                        $gravado_bruto += $dato->valor1;
                        $gravado_iva += $dato->valor0;
                        $exento_bruto += $dato->valor2;
                        $exportg_bruto += ($dato->valor5 + $dato->valor13 + $dato->valor10);
                        $exporte_bruto += $dato->valor6;
                        $nsujeta_bruto += $dato->valor3;

                        if ($dato->valor4 > 0) $percibido_bruto += $dato->valor4;
                        else $retencion_bruto += $dato->valor4;
                    }
                }
                $gravado_total = ($gravado_neto = $gravado_bruto - $gravado_dev) + $gravado_iva; 
                $exento_total = ($exento_neto = $exento_bruto - $exento_dev) + $exento_iva;
                $exportg_total = ($exportg_neto = $exportg_bruto - $exportg_dev) + $exportg_iva;
                $exporte_total = ($exporte_neto = $exporte_bruto - $exporte_dev) + $exporte_iva;
                $nsujeta_total = ($nsujeta_neto = $nsujeta_bruto - $nsujeta_dev) + $nsujeta_iva;
                $consumidor_final = trim('
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($gravado_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exento_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES GRAVADAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exportg_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">EXPORTACIONES EXENTAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($exporte_total, 2),2).'</td>
                    </tr>
                    <tr>
                        <td style="width: 35%;font-size:11px;text-align:right;">VENTAS NO SUJETAS</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;">'.number_format(round($nsujeta_total, 2),2).'</td>
                    </tr>
                ');
                $bruto_total += $gravado_bruto + $exento_bruto + $nsujeta_bruto + $exportg_bruto + $exporte_bruto;
                $dev_total += $gravado_dev + $exento_dev + $nsujeta_dev + $exportg_dev + $exporte_dev;
                $neto_total += $gravado_neto + $exento_neto + $nsujeta_neto + $exportg_neto + $exporte_neto;
                $iva_total += $gravado_iva + $exento_iva + $nsujeta_iva + $exportg_iva + $exporte_iva;
                $total += $gravado_total + $exento_total + $nsujeta_total + $exportg_total + $exporte_total;

                $percibido_total = ($percibido_neto = $percibido_bruto - $percibido_dev) + $percibido_iva;
                $retencion_total = ($retencion_neto = $retencion_bruto - $retencion_dev) + $retencion_iva;

                $totales = trim('
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">TOTALES</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($bruto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($dev_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($neto_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($iva_total, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO PERCIBIDO</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($percibido_total, 2),2).'</td>
                    </tr>
                    <tr style="border-top: 1px double black;">
                        <td style="width: 35%;font-size:11px;text-align:right;font-weight:bold;">IMPUESTO RETENIDO 1%</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_bruto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_dev, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_neto, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_iva, 2),2).'</td>
                        <td style="width: 13%;font-size:11px;text-align:right;font-weight:bold;">'.number_format(round($retencion_total, 2),2).'</td>
                    </tr>
                ');
                $estructura = trim('
                    <table style="width:100%; padding:0px; margin:0px;">
                        <thead>
                            <tr>
                                <th style="width: 35%;" ></th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>BRUTO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEVOLU-<br>CIONES</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VALOR<br>NETO</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >DEBITO<br>FISCAL</th>
                                <th style="border:1px solid balck;width: 13%;font-size:12px;text-align:center;" >VENTA<br>TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td style="font-size: 5px;"></td></tr>
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONTRIBUYENTES</td></tr>
                            '.$contribuyentes.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">CONSUMIDOR FINAL</td></tr>
                            '.$consumidor_final.'
                            <tr><td style="border-bottom:1px double black; width:100%; text-align:left;font-size:15px;" colspan="6">TOTALES</td></tr>
                            '.$totales.'
                            <tr><td colspan="6"><br><br><br><br></td></tr>
                            <tr>
                               <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                               <td colspan="4"></td>
                            </tr><tr>
                               <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                               <td colspan="4"></td>
                            </tr>
                        </tbody>
                    </table>
                ');
            }
            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroComprasOld1($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            //  INICIO FILTROS  
            $arrayFiltro = explode("-", $extra['filtro']); 
            $filtro = $arrayFiltro[0];
            if($arrayFiltro[1] == 1){
                $orden = SORT_ASC;
            }
            if($arrayFiltro[1] == 2){
                $orden = SORT_DESC;
            }
            //  FIN FILTROS  
            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE COMPRAS';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras');
            $pdf->SetSubject('Libro de Compras');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $pdf->setPrintHeader(false);
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; 
            $total_nosujeto = 0;
            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $compras = '';

            if ($datos->num_rows() > 0) {
                $datosArray = $datos->result();
                //  INICIO FILTRO 
                switch ($filtro) {
                    case 1: // orden de digitacion
                        $idrec = array_column($datosArray , 'idrec');
                        array_multisort($idrec, $orden, $datosArray );
                        break;

                    case 2: // fecha de digitacion
                        $fecha = array_column($datosArray , 'fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 3: // fecha del documento
                        $fecha = array_column($datosArray , 'doc_fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 4: // nombre del contribuyente
                        $cliente = array_column($datosArray , 'cliente');
                        $fecha = array_column($datosArray , 'doc_fecha');
                        array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                        break;
                }
                //  FIN FILTRO  
                foreach ($datosArray as $key => $dato) {
                    $exentainterna = $dato->valor2 + $dato->valor14 + $dato->valor15;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    $gravadainterna = 0;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;

                    $total = 0;
                    $sujetoexcluido = 0;
                    $impuestopercibido = $dato->valor4;
                    $nosujeto = $dato->valor3;
                    $total_exentainterna += $exentainterna;
                    $total_exentainternacion += $exentainternacion;

                    $total_gravadainternacion += $gravadainternacion;
                    $total_creditofiscal += $creditofiscal;

                    $total_percepcion += $impuestopercibido;
                    $total_nosujeto = $nosujeto;
                    //N°    num doc     fecha       cliente     nrc     exenta/interna     exenta/internacion       gravada/interna     gravada/internacion     gravada/credito     total       sujeto ex   0   0   percepcion

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="14"){
                        $sujetoexcluido = $dato->valor1;
                        $total_sujetoexcluido += $sujetoexcluido;
                        $total = 0;
                    }else{
                        $gravadainterna = $dato->valor1;
                        $total_gravadainterna += $gravadainterna;
                        $total = $exentainterna + $exentainternacion + $creditofiscal + $gravadainterna +  $gravadainternacion + $impuestopercibido;
                    }

                    if($total + $sujetoexcluido == 0){
                        $dato->cliente = $dato->cliente." [ANULADO]";
                    }

                    $nombreCliente = substr(trim($dato->cliente),0,45);
                    $compras .= trim('
                        <tr>
                            <td style="width:  3%; text-align:center; font-size:7px;">'.($key + 1).'</td>
                            <td style="width: 7%; text-align:  left; font-size:7px;">'.strtoupper($dato->doc_serie.$dato->doc_numero).'</td>
                            <td style="width:  5%; text-align:center; font-size:7px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                            <td style="width: 20%; text-align:  left; font-size:7px;">'.strtoupper($nombreCliente).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.trim($dato->nrc).'</td>

                            <td style="width:  6%; text-align: right; font-size:7px;">'.number_format(round($exentainterna, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:7px;">'.number_format(round($exentainternacion, 2),2).'</td>

                            <td style="width:  6%; text-align: right; font-size:7px;">'.number_format(round($gravadainterna, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:7px;">'.number_format(round($gravadainternacion, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($creditofiscal, 2),2).'</td>

                            <td style="width:  6%; text-align: right; font-size:7px;">'.number_format(round($total, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($sujetoexcluido, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($nosujeto, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round(0, 2),2).'</td>

                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($impuestopercibido, 2),2).'</td>
                        </tr>
                    ');
                }
            }
            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  6%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_nosujeto, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>

                </tr>
            ');
            $estructura = trim('
                <table style="width:100%;  padding: 0">
                    <thead>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;"><br><br></th></tr>
                        <tr>
                            <th style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</th>
                            <th colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </th>
                        </tr>
                        <tr><th sytle="width: 100%; font-size: 3px;"></th></tr>
                        <tr>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 3%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>N°</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2">NUM- CORRELATIVO PRE-IMPRESO</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>F. EMISIÓN</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:20%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>N.R.C.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:12%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" colspan="2">COMPRAS EXENTAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:17%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" colspan="4">COMPRAS GRAVADAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2">TOTAL COMPRAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>COMPRAS A SUJ. EXCL.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 12px;" rowspan="2"><br>COMPRAS NO SUJETAS.</th>

                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 12px;" rowspan="2">MONTO SUJETO A RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>IMP. RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>IMP. PER. DE GRANDES</th>
                        </tr>
                        <tr>
                            <th style="width:0.0001%;"></th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px; font-family: serif;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">IMPORT. INTERNA.</th>

                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px; font-family: serif;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">IMPORT. INTERNA.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">CREDITO FISCAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        '.$totalesr.'
                    </tbody>
                    <tfoot>
                        <tr><td style="width: 100%; font-size: 15px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </tfoot>
                </table>
            ');

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroCompras($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            //  INICIO FILTROS  
            $arrayFiltro = explode("-", $extra['filtro']); 
            $filtro = $arrayFiltro[0];
            if($arrayFiltro[1] == 1){
                $orden = SORT_ASC;
            }
            if($arrayFiltro[1] == 2){
                $orden = SORT_DESC;
            }
            //  FIN FILTROS  
            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('dte_model');
            $this->load->model('iva_model');
            $nombreFormato = 'LIBRO DE COMPRAS';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras');
            $pdf->SetSubject('Libro de Compras');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $pdf->setPrintHeader(false);
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; 
            $total_nosujeto = 0; $total_fovial = 0; $total_cotrans = 0;
            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $compras = '';

            if ($datos->num_rows() > 0) {
                $datosArray = $datos->result();
                //  INICIO FILTRO 
                switch ($filtro) {
                    case 1: // orden de digitacion
                        $idrec = array_column($datosArray , 'idrec');
                        array_multisort($idrec, $orden, $datosArray );
                        break;

                    case 2: // fecha de digitacion
                        $fecha = array_column($datosArray , 'fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 3: // fecha del documento
                        $fecha = array_column($datosArray , 'doc_fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 4: // nombre del contribuyente
                        $cliente = array_column($datosArray , 'cliente');
                        $fecha = array_column($datosArray , 'doc_fecha');
                        array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                        break;
                }
                //  FIN FILTRO  
                foreach ($datosArray as $key => $dato) {
                    $exentainterna = $dato->valor2 + $dato->valor14 + $dato->valor15;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    $gravadainterna = 0;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;
                    $fovial = $dato->valor15;
                    $cotrans = $dato->valor14;

                    $total = 0;
                    $sujetoexcluido = 0;
                    $impuestopercibido = $dato->valor4;
                    $nosujeto = $dato->valor3;
                    $total_exentainterna += $exentainterna;
                    $total_exentainternacion += $exentainternacion;

                    $total_gravadainternacion += $gravadainternacion;
                    $total_creditofiscal += $creditofiscal;

                    $total_percepcion += $impuestopercibido;
                    $total_nosujeto = $nosujeto;
                    $total_fovial += $fovial;
                    $total_cotrans += $cotrans;
                    //N°    num doc     fecha       cliente     nrc     exenta/interna     exenta/internacion       gravada/interna     gravada/internacion     gravada/credito     total       sujeto ex   0   0   percepcion

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="14"){
                        $sujetoexcluido = $dato->valor1;
                        $total_sujetoexcluido += $sujetoexcluido;
                        $total = 0;
                    }else{
                        $gravadainterna = $dato->valor1;
                        $total_gravadainterna += $gravadainterna;
                        $total = $exentainterna + $exentainternacion + $creditofiscal + $gravadainterna +  $gravadainternacion + $impuestopercibido;
                    }

                    if($total + $sujetoexcluido == 0){
                        $dato->cliente = $dato->cliente." [ANULADO]";
                    }

                    $datoNumeradores = $this->dev_model->multiIvaCentral(2.2, [
                        'tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam, 'fecha' => $dato->doc_fecha,
                        'serie' => $dato->doc_serie
                    ]);
                    $datoNums = explode("|", $datoNumeradores);
                    $infNum1 = explode(":", $datoNums[0]);
                    $infNum2 = explode(":", $datoNums[1]);


                    $infoDTE = $this->dte_model->validateExistDocumentDte($dato->idrec, 1, $ida);

                    if ($infoDTE) {
                        $nDocumento = $infoDTE->cgeneracion;
                    } else {
                        $trannum = $this->iva_model->getTrannumDocumentImport($dato->doc_serie, $infNum1[1], $dato->idcentro, $dato->idcaja);
                        $infoDTE = $this->dte_model->validateExistDocumentDte($trannum, 0, 0, 1);

                        if ($infoDTE) {
                            $nDocumento = $infoDTE->cgeneracion;
                        } else {
                            $nDocumento = strtoupper($dato->doc_serie.$dato->doc_numero);
                        }
                    }

                    $nombreCliente = substr(trim($dato->cliente),0,45);
                    $compras .= trim('
                        <tr>
                            <td style="width:  3%; text-align:center; font-size:7px;">'.($key + 1).'</td>
                            <td style="width: 7%; text-align:  left; font-size:7px;">'.$nDocumento.'</td>
                            <td style="width:  5%; text-align:center; font-size:7px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                            <td style="width: 20%; text-align:  left; font-size:7px;">'.strtoupper($nombreCliente).'</td>
                            <td style="width:  4%; text-align: right; font-size:7px;">'.trim($dato->nrc).'</td>

                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($exentainterna, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($exentainternacion, 2),2).'</td>

                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($gravadainterna, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($gravadainternacion, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($creditofiscal, 2),2).'</td>

                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($total, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($sujetoexcluido, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($nosujeto, 2),2).'</td>
                            <td style="width:  4%; text-align: right; font-size:7px;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:  4%; text-align: right; font-size:7px;">'.number_format(round(0, 2),2).'</td>
                            
                            

                            <td style="width:  5%; text-align: right; font-size:7px;">'.number_format(round($impuestopercibido, 2),2).'</td>
                            <td style="width:  4%; text-align: right; font-size:7px;">'.number_format(round($fovial, 2),2).'</td>
                            <td style="width:  4%; text-align: right; font-size:7px;">'.number_format(round($cotrans, 2),2).'</td>
                        </tr>
                    ');
                }
            }
            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_nosujeto, 2),2).'</td>
                    <td style="width:  4%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  4%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>
                    <td style="width:  4%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_fovial, 2),2).'</td>
                    <td style="width:  4%; text-align:right; font-size:7.5px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_cotrans, 2),2).'</td>

                </tr>
            ');
            $estructura = trim('
                <table style="width:100%;  padding: 0">
                    <thead>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;"><br><br></th></tr>
                        <tr>
                            <th style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</th>
                            <th colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </th>
                        </tr>
                        <tr><th sytle="width: 100%; font-size: 3px;"></th></tr>
                        <tr>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 3%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>N°</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>COD. GENERACIÓN</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>F. EMISIÓN</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:20%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 4%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>N.R.C.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" colspan="2">COMPRAS EXENTAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:15%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" colspan="4">COMPRAS GRAVADAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2">TOTAL COMPRAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>COMPRAS A SUJ. EXCL.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 12px;" rowspan="2"><br>COMPRAS NO SUJETAS.</th>

                            <th style="border:0.1px solid #333; vertical-align:middle; width: 4%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 12px;" rowspan="2">MONTO SUJETO A RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 4%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px;" rowspan="2"><br><br>IMP. RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>IMP. PER. DE GRANDES</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 4%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>FOVIAL</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 4%; font-weight:bold; text-align:center; font-family: serif; font-size:7.5px; line-height: 17px;" rowspan="2"><br>COTRANS</th>                            
                        </tr>
                        <tr>
                            <th style="width:0.0001%;"></th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px; font-family: serif;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">IMPORT. INTERNA.</th>

                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px; font-family: serif;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">IMPORT. INTERNA.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px; font-family: serif;">CREDITO FISCAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        '.$totalesr.'
                    </tbody>
                    <tfoot>
                        <tr><td style="width: 100%; font-size: 15px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </tfoot>
                </table>
            ');

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        /*
        private function libroCompras($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            //  INICIO FILTROS  
            $arrayFiltro = explode("-", $extra['filtro']); 
            $filtro = $arrayFiltro[0];
            if($arrayFiltro[1] == 1){
                $orden = SORT_ASC;
            }
            if($arrayFiltro[1] == 2){
                $orden = SORT_DESC;
            }
            //  FIN FILTROS  
            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE COMPRAS';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras');
            $pdf->SetSubject('Libro de Compras');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 5, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $pdf->setPrintHeader(false);
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; 

            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $compras = '';

            if ($datos->num_rows() > 0) {
                $datosArray = $datos->result();
                //  INICIO FILTRO 
                switch ($filtro) {
                    case 1: // orden de digitacion
                        $idrec = array_column($datosArray , 'idrec');
                        array_multisort($idrec, $orden, $datosArray );
                        break;

                    case 2: // fecha de digitacion
                        $fecha = array_column($datosArray , 'fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 3: // fecha del documento
                        $fecha = array_column($datosArray , 'doc_fecha');
                        $cliente = array_column($datosArray , 'cliente');
                        array_multisort($fecha, $orden, $cliente, SORT_ASC, $datosArray );                                
                        break;
                    case 4: // nombre del contribuyente
                        $cliente = array_column($datosArray , 'cliente');
                        $fecha = array_column($datosArray , 'doc_fecha');
                        array_multisort($cliente, $orden, $fecha, SORT_ASC, $datosArray );                                
                        break;
                }
                //  FIN FILTRO  
                foreach ($datosArray as $key => $dato) {
                    $exentainterna = $dato->valor2;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    $gravadainterna = 0;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;

                    $total = 0;
                    $sujetoexcluido = 0;
                    $impuestopercibido = $dato->valor4;

                    $total_exentainterna += $exentainterna;
                    $total_exentainternacion += $exentainternacion;

                    $total_gravadainternacion += $gravadainternacion;
                    $total_creditofiscal += $creditofiscal;

                    $total_percepcion += $impuestopercibido;

                    //N°    num doc     fecha       cliente     nrc     exenta/interna     exenta/internacion       gravada/interna     gravada/internacion     gravada/credito     total       sujeto ex   0   0   percepcion

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="0"){
                        $sujetoexcluido = $dato->valor1;
                        $total_sujetoexcluido += $sujetoexcluido;
                        $total = 0;
                    }else{
                        $gravadainterna = $dato->valor1;
                        $total_gravadainterna += $gravadainterna;
                        $total = $exentainterna + $exentainternacion + $creditofiscal + $gravadainterna +  $gravadainternacion + $impuestopercibido;
                    }

                    if($total + $sujetoexcluido == 0){
                        $dato->cliente = $dato->cliente." [ANULADO]";
                    }
                    $compras .= trim('
                        <tr>
                            <td style="width:  3%; text-align:center; font-size:9px;">'.($key + 1).'</td>
                            <td style="width: 7%; text-align:  left; font-size:9px;">'.strtoupper($dato->doc_serie.$dato->doc_numero).'</td>
                            <td style="width:  6%; text-align:center; font-size:9px;">'.date_format(date_create($dato->doc_fecha),'d/m/Y').'</td>
                            <td style="width: 20%; text-align:  left; font-size:9px;">'.strtoupper(trim($dato->cliente)).'</td>
                            <td style="width:  5%; text-align: right; font-size:9px;">'.trim($dato->nrc).'</td>

                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($exentainterna, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($exentainternacion, 2),2).'</td>

                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($gravadainterna, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($gravadainternacion, 2),2).'</td>
                            <td style="width:  5%; text-align: right; font-size:9px;">'.number_format(round($creditofiscal, 2),2).'</td>

                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($total, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($sujetoexcluido, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round(0, 2),2).'</td>

                            <td style="width:  6%; text-align: right; font-size:9px;">'.number_format(round($impuestopercibido, 2),2).'</td>
                        </tr>
                    ');
                }
            }
            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>

                </tr>
            ');
            $estructura = trim('
                <table style="width:100%;  padding: 0">
                    <thead>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</th></tr>
                        <tr><th colspan="3" style="text-align:center;font-size:15px; font-weight:bold;"><br><br></th></tr>
                        <tr>
                            <th style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</th>
                            <th colspan="2" style="text-align:right;font-size:14px;width:60%;">
                                N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                            </th>
                        </tr>
                        <tr><th sytle="width: 100%; font-size: 3px;"></th></tr>
                        <tr>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 3%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N°</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:7%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">NUM- CORRELATIVO PRE-IMPRESO</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>F. EMISIÓN</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:20%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 5%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>N.R.C.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:12%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="2">COMPRAS EXENTAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:17%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" colspan="4">COMPRAS GRAVADAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 17px;" rowspan="2">TOTAL COMPRAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 17px;" rowspan="2"><br>COMPRAS A SUJ. EXCL.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2">MONTO SUJETO A RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px;" rowspan="2"><br><br>IMP. RET.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width: 6%; font-weight:bold; text-align:center; font-family: serif; font-size:9px; line-height: 17px;" rowspan="2"><br>IMP. PER. DE GRANDES</th>
                        </tr>
                        <tr>
                            <th style="width:0.0001%;"></th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px;">IMPORT. INTERNA.</th>

                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 23px;">INTERNAS</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:6%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px;">IMPORT. INTERNA.</th>
                            <th style="border:0.1px solid #333; vertical-align:middle; width:5%; font-weight:bold; text-align:center; font-size:7.5px; line-height: 15px;">CREDITO FISCAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        '.$totalesr.'
                    </tbody>
                    <tfoot>
                        <tr><td style="width: 100%; font-size: 15px;"></td></tr>
                        <tr>
                            <td style="width:25%; border-top:1px solid black; text-align:center; font-size: 14px;">'.$nameContador.'<br>Contador</td>
                        </tr>
                    </tfoot>
                </table>
            ');

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }
        */

        private function libroComprasConsolidadoOld1($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE COMPRAS CONSOLIDADO';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras Consolidado');
            $pdf->SetSubject('Libro de Compras Consolidado');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"></td></tr>
                    <tr>
                        <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                        <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                            N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                        </td>
                    </tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);            
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_devoluciongravada = 0; $total_devolucionexenta = 0;
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; 

            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $compras = '';

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $key => $dato) {
                    //$this->highlight_array($dato);
                    //
                    $exentainterna = $dato->valor2 + $dato->valor14 + $dato->valor15 ;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    //
                    $gravadainterna = $dato->valor1;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;

                    //
                    $sujetoexcluido = $dato->valor1;

                    //
                    $devoluciongravada = $dato->valor1;
                    $devolucionexenta = $dato->valor2  + $dato->valor14 + $dato->valor15;

                    //
                    $impuestopercibido = $dato->valor4;

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="14"){
                        $total_sujetoexcluido += $sujetoexcluido;
                    }else if($dato->doc_clase == "1" && $dato->doc_tipo =="5"){
                        $total_devoluciongravada += $devoluciongravada;
                        $total_creditofiscal += $creditofiscal;
                        $total_devolucionexenta += $devolucionexenta;
                        
                        $total_percepcion += $impuestopercibido;
                    }else{
                        $total_exentainterna += $exentainterna;
                        $total_exentainternacion += $exentainternacion;

                        $total_gravadainterna += $gravadainterna;
                        $total_gravadainternacion += $gravadainternacion;
                        $total_creditofiscal += $creditofiscal;

                        $total_percepcion += $impuestopercibido;
                    }
                }
            }
            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>
                </tr>
            ');
            $estructura = '
                <table style="width:100%; padding:0px; margin:0px;">
                    <thead>
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS EXENTAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS GRAVADAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >TOTALES</th>
                        
                        </tr>
                    </thead>
            ';

            $total_locales = $total_exentainterna + $total_gravadainterna;
            $estructura .= '
                    <tbody>
                        <tr><td style="font-size: 5px;"></td></tr>
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">LOCALES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_locales, 2),2).'</td>
                        </tr>
            ';

            $total_internacion = $total_exentainternacion + $total_gravadainternacion;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">INTERNACIÓN/IMPORTACIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_internacion, 2),2).'</td>
                        </tr>
            ';

            $total_devolucion = $total_devolucionexenta + $total_devoluciongravada;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">DEVOLUCIONES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucionexenta, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devoluciongravada, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucion, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';
            
            $total_exento = $total_exentainterna + $total_exentainternacion + $total_devolucionexenta;
            $total_gravado = $total_gravadainterna + $total_gravadainternacion + $total_devoluciongravada;
            $total_neto = $total_exento + $total_gravado;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">VALOR NETO</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_neto, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">CRÉDITO FISCAL</td>
                            <td style="width: 15%;font-size:11px;text-align:right;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">TOTAL MONTO SUJETO A RETENCIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO RETENIDO A TERCEROS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO PERCIBIDO DE GRANDES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_percepcion, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">COMPRAS A SUJETOS EXCLUIDOS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">ANTICIPO A CUENTA</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
            ';
                            
            $estructura .= '
                        <tr><td colspan="6"><br><br><br><br></td></tr>
                        <tr>
                            <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                            <td colspan="4"></td>
                        </tr><tr>
                            <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                            <td colspan="4"></td>
                        </tr>
                    </tbody>
                </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroComprasConsolidadoOld2($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $nombreFormato = 'LIBRO DE COMPRAS CONSOLIDADO';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras Consolidado');
            $pdf->SetSubject('Libro de Compras Consolidado');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"></td></tr>
                    <tr>
                        <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                        <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                            N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                        </td>
                    </tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);            
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_devoluciongravada = 0; $total_devolucionexenta = 0;
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; $total_retencion2 = 0; $total_retencion1 = 0;
            $retencion_iva_13 = 0; $total_fovial = 0; $total_cotrans = 0;

            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $compras = '';

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $key => $dato) {
                    //$this->highlight_array($dato);
                    //
                    $exentainterna = $dato->valor2 + $dato->valor14 + $dato->valor15 ;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    //
                    $gravadainterna = $dato->valor1;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;

                    //
                    $sujetoexcluido = $dato->valor1;

                    //
                    $devoluciongravada = $dato->valor1;
                    $devolucionexenta = $dato->valor2  + $dato->valor14 + $dato->valor15;

                    //
                    $impuestopercibido = $dato->valor4;
                    //
                    $total_retencion2 += $dato->valor7;

                    $total_retencion1 += $dato->valor4;

                    $retencion_iva_13 += $dato->valor8;

                    $total_fovial += $dato->valor15;

                    $total_cotrans += $dato->valor14;

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="14"){
                        $total_sujetoexcluido += $sujetoexcluido;
                    }else if($dato->doc_clase == "1" && $dato->doc_tipo =="5"){
                        $total_devoluciongravada += $devoluciongravada;
                        $total_creditofiscal += $creditofiscal;
                        $total_devolucionexenta += $devolucionexenta;
                        
                        $total_percepcion += $impuestopercibido;
                    }else{
                        $total_exentainterna += $exentainterna;
                        $total_exentainternacion += $exentainternacion;

                        $total_gravadainterna += $gravadainterna;
                        $total_gravadainternacion += $gravadainternacion;
                        $total_creditofiscal += $creditofiscal;

                        $total_percepcion += $impuestopercibido;
                    }
                }
            }
            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>
                </tr>
            ');
            $estructura = '
                <table style="width:100%; padding:0px; margin:0px;">
                    <thead>
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS EXENTAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS GRAVADAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >TOTALES</th>
                        
                        </tr>
                    </thead>
            ';

            $total_locales = $total_exentainterna + $total_gravadainterna;
            $estructura .= '
                    <tbody>
                        <tr><td style="font-size: 5px;"></td></tr>
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">LOCALES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_locales, 2),2).'</td>
                        </tr>
            ';

            $total_internacion = $total_exentainternacion + $total_gravadainternacion;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">INTERNACIÓN/IMPORTACIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_internacion, 2),2).'</td>
                        </tr>
            ';

            $total_devolucion = $total_devolucionexenta + $total_devoluciongravada;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">DEVOLUCIONES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucionexenta, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devoluciongravada, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucion, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';
            
            $total_exento = $total_exentainterna + $total_exentainternacion + $total_devolucionexenta;
            $total_gravado = $total_gravadainterna + $total_gravadainternacion + $total_devoluciongravada;
            $total_neto = $total_exento + $total_gravado;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">VALOR NETO</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_neto, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">CRÉDITO FISCAL</td>
                            <td style="width: 15%;font-size:11px;text-align:right;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">TOTAL MONTO SUJETO A RETENCIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO RETENIDO A TERCEROS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO PERCIBIDO DE GRANDES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_percepcion, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">COMPRAS A SUJETOS EXCLUIDOS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">ANTICIPO A CUENTA</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION 2%</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_retencion2, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION 1% COMPRA</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_retencion1, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION IVA 13%</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($retencion_iva_13, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">FOVIAL</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_fovial, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">COTRANS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_cotrans, 2),2).'</td>
                        </tr>
            ';
                            
            $estructura .= '
                        <tr><td colspan="6"><br><br><br><br></td></tr>
                        <tr>
                            <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                            <td colspan="4"></td>
                        </tr><tr>
                            <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                            <td colspan="4"></td>
                        </tr>
                    </tbody>
                </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        private function libroComprasConsolidado($extra)
        {
            $ida = $extra['ida'];
            $idam = $extra['idam'];
            $idmes = substr($idam, (strlen($idam) - 2), 2);
            $idlibro = $extra['idl'];

            $this->load->model('global_model');
            $this->load->model('dev_model');
            $this->load->model('iva_model');
            $nombreFormato = 'LIBRO DE COMPRAS CONSOLIDADO';
            $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
            $NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
            $NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
            $GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
            $direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
            $depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
            $telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
            $nameContador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
            ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
            $fechaini = $ida.'-'.$idmes.'-01';
            $mes            = date_format(date_create($fechaini),'n');
            $anio           = date_format(date_create($fechaini),'Y');
            switch($mes){
                case 1:
                    $mes_name = "ENERO";
                    break;
                case 2:
                    $mes_name = "FEBRERO";
                    break;
                case 3:
                    $mes_name = "MARZO";
                    break;
                case 4:
                    $mes_name = "ABRIL";
                    break;
                case 5:
                    $mes_name = "MAYO";
                    break;
                case 6:
                    $mes_name = "JUNIO";
                    break;
                case 7:
                    $mes_name = "JULIO";
                    break;
                case 8:
                    $mes_name = "AGOSTO";
                    break;
                case 9:
                    $mes_name = "SEPTIEMBRE";
                    break;
                case 10:
                    $mes_name = "OCTUBRE";
                    break;
                case 11:
                    $mes_name = "NOVIEMBRE";
                    break;
                case 12:
                    $mes_name = "DICIEMBRE";
                    break;
                default:
                    $mes_name="";
                break;
            }

            $this->load->library('Pdf');
            $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Versanet Sistemas');
            $pdf->SetTitle('Libro de Compras Consolidado');
            $pdf->SetSubject('Libro de Compras Consolidado');
            $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
            $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setPageOrientation('L');
            $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
            $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
            $pdf->SetMargins(5, 35, 5, PDF_MARGIN_BOTTOM);//5-30
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $pdf->setFontSubsetting(true);
            //$pdf->setPageOrientation('Landscape');
            $pdf->SetFont('Helvetica', '', 7, '', true);
            date_default_timezone_set('America/El_Salvador');
            $fecha = new DateTime();

            if($this->global_model->getValorNumVariable("iva_horafooter") == 1){
                $fechaFooter = "";
            }else{
                $fechaFooter = $fecha->format('d/m/Y').' - '.$fecha->format('H:i a');
            }

            $footer = trim('
                <br><br><br><br><br><br>
                <table style="width:100%; padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fechaFooter.'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>
            ');
            $pdf->setHtmlFooter($footer);
            $pdf->setPrintFooter(true);
            $header = trim('
                <table style="width:100%; padding:0px; margin:0px;">
                    <tr><th colspan="3" style="text-align:center;font-size:18px; font-weight:bold;">'.$RazonSocial.'</th></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    <tr><td colspan="3"  style="text-align:center;font-size:15px; font-weight:bold;"></td></tr>
                    <tr>
                        <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;">'.$this->session->userdata('nameCentroUser').'</td>
                        <td colspan="2" style="text-align:right;font-size:14px;width:60%;">
                            N.I.T.:    <label style="font-size:14px;text-decoration:underline;">'.$NIT.'</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N.R.C.:    <label style="font-size:14px;text-decoration:underline;">'.$NRC.'</label>
                        </td>
                    </tr>
                </table>
            ');
            $pdf->setHtmlHeader($header);
            $pdf->setPrintHeader(true);            
            $pdf->addPage('L', 'LETTER');

            $total_exentainterna = 0; $total_exentainternacion = 0;
            $total_gravadainterna = 0;  $total_gravadainternacion = 0; $total_creditofiscal = 0; 
            $total_devoluciongravada = 0; $total_devolucionexenta = 0;
            $total_total = 0; $total_sujetoexcluido = 0; $total_percepcion = 0; $total_retencion2 = 0; $total_retencion1 = 0;
            $retencion_iva_13 = 0; $total_fovial = 0; $total_cotrans = 0; $totalRetencion = 0; $totalImpuesto = 0;

            $datos = $this->dev_model->multiIvaCentral(4, ['tabla' => $ida, 'idlibro' => $idlibro, 'idam' => $idam]);
            $dataDCL = $this->iva_model->getdocumentosDCL('4', $ida, $idam);
            $compras = '';

            if ($datos->num_rows() > 0) {
                foreach ($datos->result() as $key => $dato) {
                    //$this->highlight_array($dato);
                    //
                    $exentainterna = $dato->valor2 + $dato->valor14 + $dato->valor15 ;
                    $exentainternacion = $dato->valor6 + $dato->valor11;

                    //
                    $gravadainterna = $dato->valor1;
                    $gravadainternacion = $dato->valor5 + $dato->valor10;
                    $creditofiscal = $dato->valor0;

                    //
                    $sujetoexcluido = $dato->valor1;

                    //
                    $devoluciongravada = $dato->valor1;
                    $devolucionexenta = $dato->valor2  + $dato->valor14 + $dato->valor15;

                    //
                    $impuestopercibido = $dato->valor4;
                    //
                    $total_retencion2 += $dato->valor7;
                    
                    $total_retencion1 += $dato->valor4;

                    $retencion_iva_13 += $dato->valor8;

                    $total_fovial += $dato->valor15;

                    $total_cotrans += $dato->valor14;

                    //ES DOCUMENTO DE SUJETO EXCLUIDO
                    if($dato->doc_clase == "0" && $dato->doc_tipo =="14"){
                        $total_sujetoexcluido += $sujetoexcluido;
                    }else if($dato->doc_clase == "1" && $dato->doc_tipo =="5"){
                        $total_devoluciongravada += $devoluciongravada;
                        $total_creditofiscal += $creditofiscal;
                        $total_devolucionexenta += $devolucionexenta;
                        
                        $total_percepcion += $impuestopercibido;
                    }else{
                        $total_exentainterna += $exentainterna;
                        $total_exentainternacion += $exentainternacion;

                        $total_gravadainterna += $gravadainterna;
                        $total_gravadainternacion += $gravadainternacion;
                        $total_creditofiscal += $creditofiscal;

                        $total_percepcion += $impuestopercibido;
                    }
                }
            }

            if ($dataDCL->num_rows() > 0) {
                $datosArray = $dataDCL->result();
                    foreach ($datosArray as $key => $dato){
                        $totalRetencion += $dato->valor1;
                        $totalImpuesto += $dato->valor7;
                    }
            }

            $total_total = $total_exentainterna + $total_exentainternacion + $total_gravadainterna + $total_gravadainternacion +  $total_creditofiscal + $total_percepcion;
            $totalesr = $compras.trim('
                <tr>
                    <td style="text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;" colspan="5">TOTALES</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                    <td style="width:  5%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_total, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                    <td style="width:  6%; text-align:right; font-size:10px; border-top:1px solid #333; font-weight:bold;">$'.number_format(round($total_percepcion, 2),2).'</td>
                </tr>
            ');
            $estructura = '
                <table style="width:100%; padding:0px; margin:0px;">
                    <thead>
                        <tr>
                            <th style="width: 35%;" ></th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS EXENTAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >COMPRAS GRAVADAS</th>
                            <th style="border:1px solid balck;width: 15%; font-size:12px; text-align:center; line-height: 20px" >TOTALES</th>
                        
                        </tr>
                    </thead>
            ';

            $total_locales = $total_exentainterna + $total_gravadainterna;
            $estructura .= '
                    <tbody>
                        <tr><td style="font-size: 5px;"></td></tr>
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">LOCALES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainterna, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_locales, 2),2).'</td>
                        </tr>
            ';

            $total_internacion = $total_exentainternacion + $total_gravadainternacion;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">INTERNACIÓN/IMPORTACIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exentainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravadainternacion, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_internacion, 2),2).'</td>
                        </tr>
            ';

            $total_devolucion = $total_devolucionexenta + $total_devoluciongravada;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">DEVOLUCIONES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucionexenta, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devoluciongravada, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_devolucion, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';
            
            $total_exento = $total_exentainterna + $total_exentainternacion + $total_devolucionexenta;
            $total_gravado = $total_gravadainterna + $total_gravadainternacion + $total_devoluciongravada;
            $total_neto = $total_exento + $total_gravado;
            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">VALOR NETO</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_exento, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_gravado, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_neto, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; font-weight: bold">CRÉDITO FISCAL</td>
                            <td style="width: 15%;font-size:11px;text-align:right;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_creditofiscal, 2),2).'</td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="width: 10%;font-size:12px;text-align:right;"></td>
                            <td style="width: 25%;font-size:12px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                            <td style="width: 15%;font-size:11px;text-align:right; border-top: 1px solid black;"></td>
                        </tr>
            ';

            $estructura .= '
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">TOTAL MONTO SUJETO A RETENCIÓN</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO RETENIDO A TERCEROS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">IMPUESTO PERCIBIDO DE GRANDES</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_percepcion, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">COMPRAS A SUJETOS EXCLUIDOS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_sujetoexcluido, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">ANTICIPO A CUENTA</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION 2%</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($totalImpuesto, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION 1% COMPRA</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_retencion1, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">RETENCION IVA 13%</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($retencion_iva_13, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">FOVIAL</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_fovial, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="font-size:12px;text-align:right; font-weight: bold" colspan="4">COTRANS</td>
                            <td style="width: 15%;font-size:11px;text-align:right;">$'.number_format(round($total_cotrans, 2),2).'</td>
                        </tr>
            ';
                            
            $estructura .= '
                        <tr><td colspan="6"><br><br><br><br></td></tr>
                        <tr>
                            <td colspan="2" style="border-bottom:1px solid #333333;"></td>
                            <td colspan="4"></td>
                        </tr><tr>
                            <td colspan="2" style="text-align:center;font-size:12px;">'.$nameContador.'<br>Contador</td>
                            <td colspan="4"></td>
                        </tr>
                    </tbody>
                </table>';

            $pdf->writeHTML($estructura, true, 0, false, false, 0);
            $pdf->lastPage();
            $nombre_archivo = utf8_decode("$nombreFormato.pdf");
            $pdf->Output($nombre_archivo, 'I');
        }

        #-

        function libroIVAConsumidorFinal($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->library('Pdf');
                $pdf = new Pdf('L', 'mm', 'letter', true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Versanet Sistemas');
                $pdf->SetTitle('Libro de Ventas Consumidor Final');
                $pdf->SetSubject('Libro de Ventas Consumidor Final');
                $pdf->SetKeywords('TCPDF, PDF, example, test, guide');
                $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->setPageOrientation('L');
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
                $pdf->SetAutoPageBreak(TRUE,32, PDF_MARGIN_BOTTOM);
                $pdf->SetMargins(5, 30, 5, PDF_MARGIN_BOTTOM);
                $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
                $pdf->SetFooterMargin(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, 0);
                $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
                $pdf->setFontSubsetting(true);
                $pdf->setPageOrientation('Landscape');
                $pdf->SetFont('Helvetica', '', 7, '', true);
                $pdf->addPage('L', 'LETTER');

                $fecha = new DateTime();

                $this->load->model('iva_model');
                $this->load->model('global_model');
                
                $nombreFormato  = $this->global_model->getFormatosNombre($this->uri->segment(3));
                $NRC            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT            = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$direccion      = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$nameContador   = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                $mes            = date_format(date_create($fechaini),'n');
                $anio           = date_format(date_create($fechaini),'Y');

                ( $nameContador == '' ) ? $nameContador = 'NO ASIGNADO' : $nameContador = $nameContador;
                
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $footer = '<br><br><br><br><br><br>
                <table style="padding:0px; margin:0px;">
                    <tbody style="padding:0px; margin:0px;">
                        <tr style="padding:0px; margin:0px;">
                            <th style="font-size:10px; text-align:  left; width:30%;">'.$fecha->format('d/m/Y').' - '.$fecha->format('H:i a').'</th>
                            <th style="font-size:10px; text-align:center; width:40%;"></th>
                            <th style="font-size:10px; text-align: right; width:30%;">Página '.$pdf->getAliasNumPage().' de '.$pdf->getAliasNbPages().'</th>
                        </tr>
                    </tbody>
                </table>';
                $pdf->setHtmlFooter($footer);
                $pdf->setPrintFooter(true);

                $header = '
                <table>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$this->session->userdata('descrip').'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">'.$direccion.'</td></tr>
                    <tr>
                        <td style="text-align:right; font-size:15px; width:40%;">N.I.T.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NIT.'</label></td>
                        <td style="width:20%;"></td>
                        <td style="text-align: left; font-size:15px; width:40%;">N.R.C.: <label style="font-size:15px; font-weight:bold; text-decoration:underline;">'.$NRC.'</label></td>
                    </tr>
                    <tr><td colspan="3" style="text-align:center; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td></tr>
                    <tr><td colspan="3" style="text-align:center; font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                </table>';
                $pdf->setHtmlHeader($header);
                $pdf->setPrintHeader(true);
                
                $estructura = '<br><br><br>
                <table>
                    <thead>
                        <tr>
                            <th style="border:0.1px solid #333333; vertical-align:middle;  width: 5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Día</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle;  width:21%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Tipo de Operación</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Del Número</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle;  width:12%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>Al Número</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle;  width:50%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS</th>
                        </tr>
                        <tr>
                            <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:  11px;">No Sujetas</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:  11px;">Exentas</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:  11px;">Gravadas Locales</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:10.5px;">Exportaciones</th>
                            <th style="border:0.1px solid #333333; vertical-align:middle; width:10%; font-weight:bold; text-align:center; font-size:  11px;">Totales</th>
                        </tr>
                    </thead>
                </table>';

                /*$sum_exento = 0; $sum_exportacion = 0; $sum_gravado = 0; $sum_total = 0;
                $fecha_ini = 0; $idclase_ini = 0; $cant_docs = 0; $numserie_ini = ''; $numserie_ante = ''; $tipo_doc_ant = '';

                $ventas = $this->iva_model->getVentasReporteLulaMena($fechaini, $fechafin, $idcentro, $formatos);
                
                foreach($ventas as $vn){
                    $exento = 0; $exportacion = 0; $gravado = 0;
                    $dia = date_format(date_create($vn->fecha), 'd');
                    
                    if ( $vn->exento == 1 ) {
						( $vn->idclase == 11 ) ? $exportacion = $vn->valventan : $exento = $vn->valventan;
                    } else $gravado = $vn->valventan + $vn->valtax1;
                    
                    $sum_exento      += $exento;
                    $sum_gravado     += $gravado;
                    $sum_exportacion += $exportacion;
                    $sum_total       += $exento + $gravado + $exportacion;
                    
                    if ( $cant_docs == 0 ) {
                        $fecha_ini      = $dia;
                        $idclase_ini    = $vn->idclase;
                        $numserie_ini   = $vn->numeroserie;
                        $numserie_ante  = $vn->numeroserie;
                        $tipo_doc_ant   = $vn->tipodoc;
                        
                        $exento_sum_idclase      = 0;
                        $exportacion_sum_idclase = 0;
                        $gravado_sum_idclase     = 0;
                        $exento_sum_idclase      += $exento;
                        $exportacion_sum_idclase += $exportacion;
                        $gravado_sum_idclase     += $gravado;
                    }else{
                        if ( $fecha_ini != $dia || $idclase_ini != $vn->idclase ) {
                            $estructura .= '
                            <table>
                                <tbody>
                                    <tr>
                                        <td style="width: 5%; text-align:center; font-size:9px;">'.$fecha_ini.'</td>
                                        <td style="width:21%; text-align:  left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>
                                        <td style="width:12%; text-align: right; font-size:9px;">'.$numserie_ini.'</td>
                                        <td style="width:12%; text-align: right; font-size:9px;">'.$numserie_ante.'</td>
                                        <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                                        <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>
                                        <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>
                                        <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exportacion_sum_idclase, 2),2).'</td>
                                        <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase+$exportacion_sum_idclase, 2),2).'</td>
                                    </tr>
                                </tbody>
                            </table>';

                            $fecha_ini     = $dia;
                            $idclase_ini   = $vn->idclase;
                            $numserie_ini  = $vn->numeroserie;
                            $numserie_ante = $vn->numeroserie;
                            $tipo_doc_ant  = $vn->tipodoc;
                            $cant_docs==0;
                            $exento_sum_idclase      = 0;
                            $gravado_sum_idclase     = 0;
                            $exportacion_sum_idclase = 0;
                            $exportacion_sum_idclase += $exportacion;
                            $exento_sum_idclase      += $exento;
                            $gravado_sum_idclase     += $gravado;
                        }else{
                            $exento_sum_idclase      += $exento;
                            $gravado_sum_idclase     += $gravado;
                            $exportacion_sum_idclase += $exportacion;
                            $tipo_doc_ant  = $vn->tipodoc;
                            $numserie_ante = $vn->numeroserie;
                        }
                    }
                    $cant_docs++;
                }

                $estructura.='
                <table>
                    <tbody>
                        <tr>
                            <td style="width: 5%; text-align:center; font-size:9px;">'.$fecha_ini.'</td>
                            <td style="width:21%; text-align:  left; font-size:9px;">'.strtoupper($tipo_doc_ant).'</td>
                            <td style="width:12%; text-align: right; font-size:9px;">'.$numserie_ini.'</td>
                            <td style="width:12%; text-align: right; font-size:9px;">'.$numserie_ante.'</td>
                            <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exento_sum_idclase, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($gravado_sum_idclase, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exportacion_sum_idclase, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:9px;">'.number_format(round($exento_sum_idclase+$gravado_sum_idclase+$exportacion_sum_idclase, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width: 5%; text-align:center; font-size:9px;"></td>
                            <td style="width:21%; text-align:  left; font-size:9px;"></td>
                            <td style="width:12%; text-align:center; font-size:9px;"></td>
                            <td style="width:12%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                            <td style="width:10%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;"></td>
                            <td style="width:10%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exportacion, 2),2).'</td>
                            <td style="width:10%; text-align: right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 2),2).'</td>
                        </tr>
                        <tr>
                            <td colspan="9"><br><br><br></td>
                        </tr>
                        <tr>
                            <th style="width:35%;"></th>
                            <th style="border:1px solid balck; width:13%; font-size:12px; text-align:center;">VALOR<br>BRUTO</th>
                            <th style="border:1px solid balck; width:13%; font-size:12px; text-align:center;">DEVOLU-<br>CIONES</th>
                            <th style="border:1px solid balck; width:13%; font-size:12px; text-align:center;">VALOR<br>NETO</th>
                            <th style="border:1px solid balck; width:13%; font-size:12px; text-align:center;">DEBITO<br>FISCAL</th>
                            <th style="border:1px solid balck; width:13%; font-size:12px; text-align:center;">VENTA<br>TOTAL</th>
                        </tr>
                    <tbody>
                </table>';

                $sum_exento = 0; $sum_exportacion = 0; $sum_gravado = 0; $sum_total = 0; $sum_ivae = 0; $sum_ivag = 0;
                $sum_dev_exento = 0; $sum_dev_gravado = 0; $sum_dev_exportacion = 0;

                $ventas = $this->iva_model->getVentasReporteTLulaMena($fechaini, $fechafin, $idcentro, $formatos);
                foreach($ventas as $vn){
                    if ( $vn->exento == 1 ) {
                        if ( $vn->inopera == -1 ) {
							if ( $vn->idclase == 11 ) {
								$sum_exportacion += $vn->valventan;	
							} else {
								$sum_exento += $vn->valventan;
								$sum_ivae   += $vn->valtax1;
							}
                        } else ( $vn->idclase == 11 ) ? $sum_dev_exportacion += $vn->valventan : $sum_dev_exento += $vn->valventan;
                    } else {
                        if ( $vn->inopera == -1 ) {
							$sum_gravado += $vn->valventan;
							$sum_ivag    += $vn->valtax1;
                        } else $sum_dev_gravado += $vn->valventan;
                    }
                }

                $estructura.='
                <table>
                    <tbody>
                        <tr>
                            <td style="width:35%; font-size:11px; text-align:right;">VENTAS INTERNAS GRAVADAS</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_gravado, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_dev_gravado, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_ivag, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_gravado+$sum_dev_gravado+$sum_ivag, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:35%; font-size:11px; text-align:right;">VENTAS EXENTAS</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exento, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_dev_exento, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_ivae, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exento+$sum_dev_exento+$sum_ivae, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:35%; font-size:11px; text-align:right;">EXPORTACIONES</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exportacion, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exportacion, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round($sum_exportacion, 2),2).'</td>
                        </tr>
                        <tr>
                            <td style="width:35%; font-size:11px; text-align:right;">VENTAS NO SUJETAS</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right;">'.number_format(round(0, 2),2).'</td>
                        </tr>
                        <hr style="width:100%;"><br><hr style="width:100%;">
                        <tr style="border-top: 1px double black;">
                            <td style="width:35%; font-size:11px; text-align:right; font-weight:bold;">TOTALES</td>
                            <td style="width:13%; font-size:11px; text-align:right; font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_exportacion, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right; font-weight:bold;">'.number_format(round($sum_dev_gravado+$sum_dev_exento, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right; font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento+$sum_exportacion, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right; font-weight:bold;">'.number_format(round($sum_ivag+$sum_ivae, 2),2).'</td>
                            <td style="width:13%; font-size:11px; text-align:right; font-weight:bold;">'.number_format(round($sum_gravado+$sum_exento+$sum_dev_gravado+$sum_dev_exento+$sum_ivag+$sum_ivae+$sum_exportacion, 2),2).'</td>
                        </tr>
                        <tr>
                            <td colspan="3" style="border-bottom:1px solid #333333;"></td>
                            <td colspan="6"></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align:center; font-size:12px;">'.$nameContador.'</td>
                            <td colspan="6"></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align:center; font-size:11px;">Contador</td>
                            <td colspan="6"></td>
                        </tr>
                    </tbody>
                </table>';//*/

                $pdf->writeHTML($estructura, true, 0, false, false, 0);
                $nombre_archivo = utf8_decode("$nombreFormato.pdf");
                $pdf->Output($nombre_archivo, 'I');
            }
		}
		
		function libroIVAContribuyentes($fechaini, $fechafin, $idcentro, $formatos){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                
                $fecha = new DateTime();
                $this->load->model('global_model');
                $this->load->model('iva_model');
                $function = $this->uri->segment(3);
                $nombreFormato = $this->global_model->getFormatosNombre($function);
                $RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$direccion = $this->global_model->getDatosGeneralesEmp('g_empdatos', 6);
				$depto = $this->global_model->getDatosGeneralesEmp('g_empdatos', 7);
				$telefono = $this->global_model->getDatosGeneralesEmp('g_empdatos', 9);
                
                $nombre_contador = $this->global_model->getDatosGeneralesEmp('g_empdatos', 12);
                if($nombre_contador==""){
                    $nombre_contador="NO ASIGNADO";
                }
                $mes = date_format(date_create($fechaini),'n');
                $anio = date_format(date_create($fechaini),'Y');
                switch($mes){
                    case 1:
                        $mes_name = "ENERO";
                        break;
                    case 2:
                        $mes_name = "FEBRERO";
                        break;
                    case 3:
                        $mes_name = "MARZO";
                        break;
                    case 4:
                        $mes_name = "ABRIL";
                        break;
                    case 5:
                        $mes_name = "MAYO";
                        break;
                    case 6:
                        $mes_name = "JUNIO";
                        break;
                    case 7:
                        $mes_name = "JULIO";
                        break;
                    case 8:
                        $mes_name = "AGOSTO";
                        break;
                    case 9:
                        $mes_name = "SEPTIEMBRE";
                        break;
                    case 10:
                        $mes_name = "OCTUBRE";
                        break;
                    case 11:
                        $mes_name = "NOVIEMBRE";
                        break;
                    case 12:
                        $mes_name = "DICIEMBRE";
                        break;
                    default:
                        $mes_name="";
                        break;
                }
                
                $estructura = '<html lang="es"><meta charset="utf-8">
                <style type="text/css">
                    @media print {
                        @page { margin-top: 5px;margin-bottom: 5px;margin-right: 10px;margin-left: 10px; }
                    }
                    .background_color{
                        background: '.$this->session->userdata("FHBackground").';
                        color: '.$this->session->userdata('FHFontColor').';
                    }
                </style>
                <body style="padding:50px;">';
                
                $estructura .= '
                <table>
                    <tr>
                        <td style="width:100%; text-align:left; font-size:18px; font-weight:bold;">'.$nombreFormato.'</td>
                    </tr>
                    <tr>
                        <td style="width:25%;text-align:left;font-size:15px;">'.$RazonSocial.'</td>
                    </tr>
                    <tr>
                        <td style="width:50%;text-align:left;font-size:15px;">NIT.: '.$NIT.'</td>
                    </tr>
                    <tr>
                        <td style="width:50%;text-align:left;font-size:15px;">NRC.: '.$NRC.'</td>
                    </tr>
                    <tr>
                        <td style="width:100%;text-align:left;font-size:15px; font-weight:bold;">MES DE '.$mes_name.' DE '.$anio.'</td></tr>
                    </tr>
                    <tr>
                        <td style="width:40%;text-align:left;font-size:15px; font-weight:bold;border-rigth:1px solid black">'.$this->session->userdata('nameCentroUser').'</td>
                    </tr>
                    
                </table>';
                $this->load->model('global_model');
                $estructura .= '<table style="padding-bottom:20px">';
                $estructura .= '<thead><tr>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:5%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N°</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:10%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">NUMERO CORRELATIVO PRE-IMPRESO</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:7%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">FECHA DE EMISIÓN</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:28%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>NOMBRE DEL CONTRIBUYENTE</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2"><br><br>N.R.C.</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:34%; font-weight:bold; text-align:center; font-size:12px;" colspan="5">VENTAS INTERNAS</th>
                <th style="border:0.1px solid #333333; vertical-align:middle;  width:8%; font-weight:bold; text-align:center; font-size:11px;" rowspan="2">VENTAS TOTALES</th>
                </tr>
                <tr>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">EXENTAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">NO SUJETAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:11px;">GRAVADAS</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">DEBITO FISCAL</th>
                    <th style="border:0.1px solid #333333; vertical-align:middle; width:6.8%; font-weight:bold; text-align:center; font-size:10.5px;">RETENCIÓN</th>
                </tr></thead>
                <tbody></tbody>';
                
                $sum_exento=0;
                $sum_gravado=0;
                $sum_iva=0;
                $sum_total=0;
                $sum_retencion=0;
                $total=0;
                $ventas = $this->iva_model->getVentasReporte($fechaini, $fechafin, $idcentro, $formatos);
                $i=0;
                foreach($ventas as $vn){
                    $i++;    
                    $exento=0;
                    $gravado=0;
                    $iva=0;
                    $retencion=0;
                    if($vn->exento==1){
                        $exento = $vn->valventan;
                    }else{
                        $gravado = $vn->valventan;
                    }
                    $iva = $vn->valtax1;
                    $sum_exento+=$exento;
                    $sum_gravado+=$gravado;
                    $sum_iva+=$iva;
                    
                    
                    if(($vn->idtipo==3) && ($gravado>=100)){
                        $reten = $gravado * 0.01;
                        $retencion = '-'.number_format(round($reten, 4),2);
                        $total= $exento+$gravado+$iva-$reten;
                        $sum_total+= $exento+$gravado+$iva-$reten;
                        $sum_retencion+= $reten;
                    }else{
                        $retencion = 0;
                        $total=$exento+$gravado+$iva;
                        $sum_total+= $exento+$gravado+$iva;
                    }
                        
                    if($retencion == 0){
                        $retencion = "0.00";
                    }else{
                        $retencion = "".number_format(round($retencion, 2), 2 ,'.','');
                    }
                    
                    if($vn->estatus==9){
                        $nombreCliente = $vn->namecliente.' / ANULADO';
                    }else{
                        $nombreCliente = $vn->namecliente;
                    }

                    $estructura.='<tr>
                        <td style="width:5%;text-align:center; font-size:9px;">'.$i.'</td>
                        <td style="width:10%;text-align:left; font-size:9px;">'.strtoupper($vn->numeroserie).'</td>
                        <td style="width:7%;text-align:center; font-size:9px;">'.date_format(date_create($vn->fecha),'d/m/Y').'</td>
                        <td style="width:28%;text-align:left; font-size:9px;">'.$nombreCliente.'</td>
                        <td style="width:8%;text-align:right; font-size:9px;">'.$vn->nrc.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($exento, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($gravado, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($iva, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.$retencion.'</td>
                        <td style="width:6.8%;text-align:right; font-size:9px;">'.number_format(round($total, 4),2).'</td>
                    </tr>';
                }
                $estructura.='<tr>
                        <td colspan="4" style="width:50%;text-align:center; font-size:9px;"></td>
                        <td style="width:8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">TOTALES</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_exento, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round(0, 2),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_gravado, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_iva, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$-'.number_format(round($sum_retencion, 4),2).'</td>
                        <td style="width:6.8%;text-align:right; font-size:10px;border-top:2px solid #333333;font-weight:bold;">$'.number_format(round($sum_total, 4),2).'</td>
                    </tr><tr><td colspan="10"><br><br><br></td></tr>';
                
                $estructura.='</table>';
                /*$pdf->writeHTML($estructura, true, 0, false, false, 0);
                $pdf->addPage('L', 'LET