<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
    class Xordenes extends CI_Controller{
        
        function __construct(){
            parent::__construct();

            // if ($this->uri->segment(1) == 'Generacion_De_Ordenes') {
            //     redirect('CerrarSesion');
            // }
        }
        
		function generacionOrdenesDeVentas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model'); $this->load->model('cliente_model');
				
				date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
				$fechaactual = $date->format('Y-m-d');
				$iduser = $this->session->userdata('iduser');
                
                $this->data['defven']       = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['documentos']   = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores']   = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente']   = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['encargado']    = $this->ventas_model->getEncargadoCentroFacturacion($iduser);
                $this->data['fechaactual']  = $fechaactual;
				$this->data['pos_secure']   = $this->global_model->getValorNumVariable('pos_secure');
                $this->data['gzip_depto']   = $this->cliente_model->viewDepto();
                $this->data['gzip_munic']   = $this->cliente_model->viewMunicipio();
                $this->data['so_chgstat']   = $this->global_model->getValorTextoVariable('so_chgstat');
                $this->data['dte_conf']     = $this->cliente_model->validMantenimientoDTE();
				$this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
				$this->data['txt_referencia'] = $this->global_model->getValorNotasVariable('pos_referencia');
				
				$this->load->view('mantenimiento_ordenes_facturas', $this->data);
            }
        }
				       
        function detallefacturazion($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                                
                $direccion = $this->uri->segment(1);

                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach ($informacionFactura as $info) {
                    $idclase = $info->idclase;
                    $tipoCliente = $info->idtipo;
                }
                
                $this->data['tipoCliente'] = $tipoCliente;
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $this->data['nameFormaPago'] = $this->ventas_model->getFormaDePagoOrdenes($trannum);
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable('pos_chgpre0'.$idcentro);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable('pos_maxglodiscount');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable('pos_cajafast0'.$idcaja);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                $this->data['clave_precios'] = $this->global_model->getValorTextoVariable('pos_passprecio0'.$idcentro);
                $this->data['pos_grprecio'] = $this->global_model->getValorNumVariable('pos_grprecio');
                $numDecimales  = $this->global_model->getDatosGeneralesEmp('g_empdatos', 17);

                $this->data['numdecimales']  = ( $numDecimales == '' ) ? 2 : (int) $numDecimales;
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detallefacturaz_ordenes', $this->data);
            }
        }

        function getListadoOrdenesGeneradas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $idvendedor = $this->input->post('idvendedor');
                $fecha = $this->input->post('fecha');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $informacion = $this->xordenes_model->getListadoOrdenesGeneradas('VN', $idcentro, $idvendedor, $fecha);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "numeroserie" => $info->numero,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus,
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getFormasDePagoTransaccion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getFormasDePagoTransaccion($idclase);

                $i=0;
                $array = array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->descrip != "RETENCION 1%"){
                            $array[$i] = array(
                                "id" => $info->cajclase,
                                "descrip" => $info->descrip
                            );

                            $i++;
                        }
                    }
                }else{
                    $array = false;
                }
                
                echo json_encode($array);
            }
        }

        function insertOrdenDeVenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $documento = $this->input->post('documento');
                $vendedor = $this->input->post('vendedor');
                $cliente = $this->input->post('cliente');
                $idcentro = $this->input->post('idcentro');
                $idcentrod = $this->input->post('idcentrod');
                $descrip = $this->input->post('descrip');
                $pago = $this->input->post('pago');
                $referencia = $this->input->post('referencia');
                
                $this->load->model('global_model'); $this->load->model('ventas_model');
                $this->load->model('xordenes_model');

                if($cliente == 999999){
                    $nombrevar = 'pos_grupocli0'.$idcentrod;
                    $grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
                
                    if($grupoCliente == "0"){
                        $cliente = $this->ventas_model->insertNuevoClienteVN($descrip);
                    }else{
                        $cliente = $this->ventas_model->insertNuevoClienteVNGrupo($descrip, $grupoCliente);
                    }
                }
                
                $array = $this->xordenes_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $pago, $referencia);
                echo json_encode($array);
            }
        }

        function insertVentaCotizacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $documento = $this->input->post('documento');
                $vendedor = $this->input->post('vendedor');
                $cliente = $this->input->post('cliente');
                $idcentro = $this->input->post('idcentro');
                $idcaja  = $this->input->post('idcaja');
                $idcentrod = $this->input->post('idcentrod');
                $descrip = $this->input->post('descrip');
                //$dataSource = $this->input->post('dataSource');
                $estado = $this->input->post('estado');
                $trannumCotizacion = $this->input->post('trannum');
                $idcentroUser = $this->session->userdata('idcentrouser');
                
                $this->load->model('ventas_model');
                $this->load->model('xordenes_model');
                                
                //$trannum = $this->ventas_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $pago);
                $trannum = $this->ventas_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $idcaja, '', $trannumCotizacion);
                $this->xordenes_model->updateEstadoCotizacion($trannumCotizacion, $estado);
                $totLineas = $this->xordenes_model->totalLineasDocumento($documento);
                $docExento = $this->ventas_model->validateDocumentoExento($trannumCotizacion);

                $informacion = $this->xordenes_model->getListadoProductosDeCotizaciones($trannumCotizacion, $cliente, $vendedor, $idcentro);
                
                $i=0;
                $dataSource=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->cantidadord <= $info->saldo){
                            $cantidad = $info->cantidadord;
                        }else{
                            $cantidad = $info->saldo;
                        }
                        
                        $dataSource[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "idbatch" => $info->idbatch,
                            "idbin" => $info->idbin,
                            "um" => $info->um,
                            "tipotax" => $info->tipotax,
                            "uniconv" => 1,
                            "linea" => $info->linea,
                            "barcode" => $info->barcode,
                            "preciosd" => $info->precioneto,
                            "cantrp" => $info->cantrp,
                            "descuento" => number_format($info->cantrp)."%",
                            "precioventa" => ($info->precioneto - ($info->precioneto * ($info->cantrp/100))),
                            "cantidadord" => $info->cantidadord,
                            "saldo" => $info->saldo,
                            "cantidad" => $cantidad
                        );
                        $i++;
                    }
                }
                    
                $modevn = 0;
                $itemError = 0;
                $numItems=1;
                for($i=0; $i<count($dataSource); $i++){
                    if($numItems <= $totLineas){
                        $cantidad = $dataSource[$i]['cantidad'];
                        $saldo = $dataSource[$i]['saldo'];

                        if($saldo == ""){
                            $saldo = 0;
                        }

                        if ( $this->session->userdata('idaccount') == 1100831 ) {
                            $productoInsert = 1;
                            $cantidad = $dataSource[$i]['cantidadord'];
                        } else {
                            if ( $cantidad != 0 ) {
                                if ( $cantidad <= $saldo ) {
                                    $productoInsert = 1;
                                } else {
                                    $itemError = 1;
                                    $productoInsert = 0;
                                }   
                            } else {
                                $productoInsert = 0;
                            }
                        }

                        
                        $idbatch = $dataSource[$i]['idbatch'];
                        $idbin = $dataSource[$i]['idbin'];
                        $idproducto = $dataSource[$i]['idproducto'];
                        $barcode = $dataSource[$i]['barcode'];
                        $precio = $dataSource[$i]['preciosd'];
                        $descuento = $dataSource[$i]['cantrp'];
                        $um = $dataSource[$i]['um'];
                        if($docExento == 1){
                            $tipotax = 0;
                        }else{
                            $tipotax = $dataSource[$i]['tipotax'];
                        }
                        $notasPro = "";
                        $uniconv = $dataSource[$i]['uniconv'];
                        
                        if($productoInsert == 1){
                            $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$vendedor,$notasPro,$tipotax,$vendedor,$modevn,$barcode);
                            $numItems++;
                        }
                    }
                }
                
                echo json_encode($trannum);
            }
        }

        function insertOrdenDeVentaCotizacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $documento = $this->input->post('documento');
                $vendedor = $this->input->post('vendedor');
                $cliente = $this->input->post('cliente');
                $idcentro = $this->input->post('idcentro');
                $idcentrod = $this->input->post('idcentrod');
                $descrip = $this->input->post('descrip');
                $pago = $this->input->post('pago');
                $dataSource = $this->input->post('dataSource');
                $estado = $this->input->post('estado');
                $trannumCotizacion = $this->input->post('trannum');
                
                $this->load->model('ventas_model');
                $this->load->model('xordenes_model');
                                
                $trannum = $this->xordenes_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $pago);
                $this->xordenes_model->updateEstadoCotizacion($trannumCotizacion, $estado);
                $totLineas = $this->xordenes_model->totalLineasDocumento($documento);
                $docExento = $this->ventas_model->validateDocumentoExento($trannumCotizacion);
                    
                $modevn = 0;
                $itemError = 0;
                $numItems=1;
                for($i=0; $i<count($dataSource); $i++){
                    if($numItems <= $totLineas){
                        $cantidad = $dataSource[$i]['cantidad'];
                        $saldo = $dataSource[$i]['saldo'];

                        if($saldo == ""){
                            $saldo = 0;
                        }

                        $productoInsert = 1;
                        if($cantidad != 0){
                            if($cantidad <= $saldo){
                                $productoInsert = 1;
                            }else{
                                $itemError = 1;
                                $productoInsert = 0;
                            }   
                        }else{
                            $productoInsert = 0;
                        }

                        $cantidad = $dataSource[$i]['cantidad'];
                        $idbatch = $dataSource[$i]['idbatch'];
                        $idbin = $dataSource[$i]['idbin'];
                        $idproducto = $dataSource[$i]['idproducto'];
                        $barcode = $dataSource[$i]['barcode'];
                        $precio = $dataSource[$i]['preciosd'];
                        $descuento = $dataSource[$i]['cantrp'];
                        $um = $dataSource[$i]['um'];
                        if($docExento == 1){
                            $tipotax = 0;
                        }else{
                            $tipotax = $dataSource[$i]['tipotax'];
                        }
                        $notasPro = "";
                        $uniconv = $dataSource[$i]['uniconv'];
                        
                        if($productoInsert == 1){
                            $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$vendedor,$notasPro,$tipotax,$vendedor,$modevn,$barcode);
                            $numItems++;
                        }
                    }
                }
                
                echo json_encode($trannum);
            }
        }

        function insertordenDeVentaCreditoFiscal(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('xordenes_model');

                $buscar     = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                
                $fecha      = $this->input->post('fecha');
                $notas      = trim($this->input->post('notas'));
                $notas      = str_replace($buscar, $reemplazar, $notas);
                $documento  = $this->input->post('documento');
                $vendedor   = $this->input->post('vendedor');
                $cliente    = $this->input->post('cliente');
                $idcentro   = $this->input->post('idcentro');
                $idcentrod  = $this->input->post('idcentrod');
                $descrip    = $this->input->post('descrip');
                $pago       = $this->input->post('pago');
                $nrc        = $this->input->post('nrc');
                $nit        = $this->input->post('nit');
                $correo     = $this->input->post('correo');
                $tipoCont   = $this->input->post('tipoContribuyente');
                $giro       = $this->input->post('giro');
                $telefono   = $this->input->post('telefono');
                $direccion  = $this->input->post('direccion');
                $direccion  = str_replace($buscar, $reemplazar, $direccion);
                $idzip      = $this->input->post('idzip');
                $referencia = $this->input->post('referencia');
                $dteGiro    = $this->input->post('dteGiro');
                
                if ($cliente == 999999) {
                    $cliente = $this->xordenes_model->insertNuevoClienteVN($descrip, $nrc, $nit, $tipoCont, $giro, $direccion, $idzip, $correo, $dteGiro, $telefono);
                } else {
                    $this->xordenes_model->updateClienteVN($cliente, $descrip, $nrc, $nit, $tipoCont, $giro, $direccion, $idzip, $correo, $dteGiro, $telefono);
                }
                
                $array = $this->xordenes_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $pago, $referencia);
                echo json_encode($array);
            }
        }

        function insertordenDeVentaConsumidorFinal() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('xordenes_model');

                $buscar     = array(chr(13).chr(10), "\r\n", "\n", "\r");
                $reemplazar = array("", "", "", "");
                
                $fecha      = $this->input->post('fecha');
                $notas      = trim($this->input->post('notas'));
                $notas      = str_replace($buscar, $reemplazar, $notas);
                $documento  = $this->input->post('documento');
                $vendedor   = $this->input->post('vendedor');
                $cliente    = $this->input->post('cliente');
                $idcentro   = $this->input->post('idcentro');
                $idcentrod  = $this->input->post('idcentrod');
                $descrip    = $this->input->post('descrip');
                $pago       = $this->input->post('pago');
                $dui        = $this->input->post('dui');
                $telefono   = $this->input->post('telefono');
                $correo     = $this->input->post('correo');
                $direccion  = $this->input->post('direccion');
                $direccion  = str_replace($buscar, $reemplazar, $direccion);
                $idzip      = $this->input->post('idzip');
                $referencia = $this->input->post('referencia');
                
                if ($cliente == 999999) {
                    $cliente = $this->xordenes_model->insertNuevoClienteVNCF($descrip, $dui, $telefono, $correo, $direccion, $idzip);
                } else {
                    $this->xordenes_model->updateClienteVNCF($cliente, $descrip, $dui, $telefono, $correo, $direccion, $idzip);
                }
                
                $array = $this->xordenes_model->insertarFacturacion($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcentrod, $pago, $referencia);
                echo json_encode($array);
            }
        }

        function enviarFacturacionCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $numcompra = $this->input->post('numcompra');

                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->enviarFacturacionCaja($trannum, $numcompra);
                
                echo json_encode($array);
            }
        }

        function modificarFacturacionCaja(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');

                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->modificarFacturacionCaja($trannum);
                
                echo json_encode($array);
            }
        }
        //Versión funcionando hasta 11/06/2019
        function mantenimientoFacturacionCaja_descontinuada($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $this->load->model('configuracion_model');
                $appName = $this->configuracion_model->getAppName($idApp);
                $opcionmenu = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);

                $this->load->model('ventas_model'); $this->load->model('global_model');
                $this->load->model('invtran_model');
                
                date_default_timezone_set('America/El_Salvador');
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                                
                $direccion = $controlador;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $direccion2 = $controlador.'/pprint';
                $this->data['pprintfo'] = $this->global_model->getFormatosImpresionGrid($direccion2);
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $this->data['newcliente'] = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['fechaactual'] = $fechaactual;
                
                $idcentro = $this->session->userdata('idcentrouser');
                $nombrevar = 'pos_rprint0'.$idcentro;
                $this->data['pos_rprint'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_sendfacelectroni'] = $this->global_model->getValorNumVariable('pos_sendfacelectroni');
                $this->data['pos_tregalo'] = $this->global_model->getValorNumVariable('pos_tregalo');
                $this->data['pos_multiprint'] = $this->global_model->getValorNumVariable('pos_multiprint');
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $this->load->view('mantenimiento_facturazdevoluziones_caja', $this->data);
                
                $showpprint = array(
                    "show_pprint" => 0
                );
                $this->session->set_userdata($showpprint);
            }
        }
        //Versión cambio de popup adicionar
        function mantenimientoFacturacionCaja($idApp) {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                date_default_timezone_set('America/El_Salvador');
                
                $date = new DateTime();
                $fechaactual = $date->format('Y-m-d');
                
                $this->load->model('ventas_model');
                $this->load->model('global_model');
                $this->load->model('invtran_model');
                $this->load->model('configuracion_model');
                
                $appName     = $this->configuracion_model->getAppName($idApp);
                $opcionmenu  = $this->configuracion_model->getProCentro($idApp);
                $controlador = $this->uri->segment(1);
                $funcion     = $this->uri->segment(2);
                
                $resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                    'opcionmenu' => $opcionmenu,
                    'controlador_vn' =>$controlador,
                    'funcion_vn' =>$funcion,
                );
                $this->session->set_userdata($resultAppName);
                
                $iduser   = $this->session->userdata('iduser');
                $idcaja   = $this->session->userdata('idcajauser');
                $idcentro = $this->session->userdata('idcentrouser');
                                
                $this->data['defven']         = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['formatos']       = $this->global_model->getFormatosImpresionGrid($controlador);
                $this->data['pprintfo']       = $this->global_model->getFormatosImpresionGrid($controlador.'/pprint');
                $this->data['encargado']      = $this->ventas_model->getEncargadoCentroFacturacion($iduser);
                $this->data['pos_oprig']      = $this->global_model->getValorNumVariable('pos_oprig0'.$idcaja); 
                $this->data['documentos']     = $this->ventas_model->tipoDocSumaCaja();
                $this->data['vendedores']     = $this->ventas_model->getVendedoresActivos();
                $this->data['pos_rprint']     = $this->global_model->getValorNumVariable('pos_rprint0'.$idcentro);
                $this->data['newcliente']     = $this->invtran_model->getFiltroBuscaProd('pos_newcli');
                $this->data['pos_secure']     = $this->global_model->getValorNumVariable('pos_secure');
                $this->data['fechaactual']    = $fechaactual;
                $this->data['pos_tregalo']    = $this->global_model->getValorNumVariable('pos_tregalo');
                $this->data['pos_frecuente']  = $this->global_model->getValorTextoVariable('pos_frecuente');
                $this->data['pos_referencia'] = $this->global_model->getValorNumVariable('pos_referencia');
                $this->data['pos_multiprint'] = $this->global_model->getValorNumVariable('pos_multiprint');
                $this->data['pos_sendfacelectroni'] = $this->global_model->getValorNumVariable('pos_sendfacelectroni');
                
                $this->load->view('mantenimiento_facturazdevoluziones_cajap', $this->data);
                
                $showpprint = array(
                    "show_pprint" => 0
                );
                $this->session->set_userdata($showpprint);
            }
        }

        function validateOrdenVenta() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum  = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');

                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->validateOrdenVenta($trannum, $idcentro);

                echo json_encode($array);
            }
        }

        function modificarOrdenVenta() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $referencia = $this->input->post('referencia');

                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->modificarOrdenVenta($trannum, $referencia);

                echo json_encode($array);
            }
        }

        function getListadoOrdenesEnviadas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $informacion = $this->xordenes_model->getListadoOrdenesEnviadas('VN', $idcentro, 8);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "idcentro" => $info->idcentro,
                        "formapago" => $info->formapago,
                        "valventan" => number_format($totalVenta, 2, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getListadoOrdenesPendientes(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $informacion = $this->xordenes_model->getListadoOrdenesEnviadas('VN', $idcentro, 0);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "idcentro" => $info->idcentro,
                        "formapago" => $info->formapago,
                        "valventan" => number_format($totalVenta, 2, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getDatosFacturasVentasDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini
                );
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesDia('VN', $idcentro, $idcaja, $fechaini, $numx, $numz);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->estatus == 1 || $info->estatus == 9 || $info->estatus == 0){
                        if($info->exento == 0){
                            $valtax1 = $info->valtax1;
                        }else{
                            $valtax1 = 0;
                        }
                        
                        $totalVenta = $info->valventan + $valtax1;
                        
                        $array[$i] = array(
                            "trannum" => $info->trannum,
                            "fecha" => $info->fecha,
                            "tipodoc" => $info->tipodoc,
                            "numeroserie" => $info->numero,
                            "namecliente" => $info->namecliente,
                            "namevendedor" => $info->namevendedor,
                            "valventan" => number_format($totalVenta, 2, '.', ''),
                            "estatus" => $info->estatus
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function regresarFacturacionDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $trannum = $this->input->post('trannum');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $this->xordenes_model->regresarFacturacionDocumento($trannum);
                $informacion = $this->xordenes_model->getListadoOrdenesEnviadas('VN', $idcentro, 8);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "idcentro" => $info->idcentro,
                        "formapago" => $info->formapago,
                        "valventan" => number_format($totalVenta, 2, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function eliminarDocumentoFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $trannum = $this->input->post('trannum');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $this->xordenes_model->eliminarDocumentoFacturacion($trannum);
                $informacion = $this->xordenes_model->getListadoOrdenesEnviadas('VN', $idcentro, 8);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "idcentro" => $info->idcentro,
                        "formapago" => $info->formapago,
                        "valventan" => number_format($totalVenta, 2, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function anularDocumentoFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $trannum = $this->input->post('trannum');

                $this->load->model('xordenes_model'); $this->load->model('invtran_model');
                $this->xordenes_model->anularDocumentoFacturacion($trannum);
                $informacion = $this->xordenes_model->getListadoOrdenesEnviadas('VN', $idcentro, 0);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $datos = $this->invtran_model->getDataVentaTran100k($info->trannum, $idcentro);
                    $totalVenta = 0;
                    foreach($datos as $data){
                        $totalVenta = $totalVenta + (($data->precioneto + ($data->precioneto * ($data->tax1 / 100))) * abs($data->cantidad));
                    }

                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "tipodoc" => $info->tipodoc,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "idcentro" => $info->idcentro,
                        "formapago" => $info->formapago,
                        "valventan" => number_format($totalVenta, 2, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function confirmarFacturacionDocumento(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcaja = $this->input->post('idcaja');

                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->confirmarFacturacionDocumento($trannum, $idcaja);

                echo json_encode($array);
            }
        }

        function detallefacturazioncaja($trannum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Detalle '.$this->session->userdata('appName').' N°'.$trannum
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('ventas_model');
                $this->load->model('invtran_model');
                $this->load->model('cliente_model');
                $this->load->model('global_model');
                
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                    $idcaja = $this->session->userdata('idcajaTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                    $idcaja = $this->session->userdata('idcajauser');
                }
                
                $controlador = $this->uri->segment(1);
                $funcion = $this->uri->segment(2);
                $direccion = $controlador.'/'.$funcion;
                $this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
                $this->data['documentos'] = $this->ventas_model->tipoDocSumaCaja();
                $this->data['defven'] = $this->global_model->getDefaultIdClaseVN('pos_idclase');
                $this->data['vendedores'] = $this->ventas_model->getVendedoresActivos();
                $informacionFactura = $this->ventas_model->getDatosFactura($trannum);
                $this->data['informacion'] = $informacionFactura;
                
                foreach($informacionFactura as $info){
                    $idclase = $info->idclase;
                }
                
                $this->data['maxlines'] = $this->ventas_model->getMaxLinesDoc($idclase);
                $this->data['cantidad'] = $this->invtran_model->getCantidad100k($trannum);
                $this->data['unidades'] = $this->invtran_model->getUnidades100k($trannum);
                $nombrevar = 'pos_chgpre0'.$idcentro;
                $this->data['pdescuento'] = $this->global_model->getValorNumVariable($nombrevar);
                $this->data['pos_maxglodiscount'] = $this->global_model->getValorNumVariable('pos_maxglodiscount');
                $this->data['pos_aplmaxdiscount'] = $this->global_model->getValorNumVariable('pos_aplmaxdiscount');
                $this->data['pos_emailreq'] = $this->global_model->getValorNumVariable('pos_emailreq');
                $this->data['clavedescuentos'] = $this->global_model->getValorNotasVariable_Pa('pos_maxglodiscount');
                $this->data['actividades'] = $this->cliente_model->verActividades();
                $this->data['gzip_depto'] = $this->cliente_model->viewDepto();
                $this->data['gzip_munic'] = $this->cliente_model->viewMunicipio();
                $this->data['defidzip'] = $this->global_model->getValorNumVariable('gv_zip');
                $this->data['pos_vendemode'] = $this->global_model->getValorNumVariable('pos_vendemode');
                $this->data['pos_precios'] = $this->global_model->getValorNumVariable('pos_precios');
                $this->data['send_print'] = $this->global_model->getValorNumVariable('pos_sendprint0'.$idcaja);
                $name_var = 'pos_easy0'.$idcaja;
                $this->data['pos_easy'] = $this->global_model->getValorNumVariable($name_var);
                $name_var2 = 'pos_cajafast0'.$idcaja;
                $this->data['pos_cajafast'] = $this->global_model->getValorNumVariable($name_var2);
                $this->data['pos_secure'] = $this->global_model->getValorNumVariable('pos_secure');
                
                $tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');
                if($tipoBusca == 1){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Interno"
                    );
                }elseif($tipoBusca == 2){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Modelo"
                    );
                }elseif($tipoBusca == 3){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código de Barra"
                    );
                }elseif($tipoBusca == 4){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Código Xpos"
                    );
                }elseif($tipoBusca == 5){
                    $array = array(
                        "gv_prodsearch" => $tipoBusca,
                        "gv_prodtext" => "Descripción"
                    );
                }
                $this->session->set_userdata($array);
                
                $this->load->view('mantenimiento_detallefacturaz_caja', $this->data);
            }
        }

        function getPendientesImpresionVentasByTipo(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcentro = $this->input->post('idcentro');
                $tipodoc  = $this->input->post('tipodoc');
                $fechaini = $this->input->post('fechaini');
				$fechafin = $this->input->post('fechafin');

                $controlador = $this->session->userdata('controlador_vn');
                $url = $controlador.'/pprint';
                $idcaja = $this->session->userdata('idcajauser');
                
                $estado = 0;
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturacionesPendientesPrintByTipo('VN', $idcentro, $idcaja, $tipodoc, $fechaini, $fechafin, $estado);
                
                $urlPrint = "";
                if ($tipodoc != 0) {
                    $urlPrint = $this->ventas_model->getFormatoPrintDef($tipodoc, $url);
                }
                
                $i=0;
                $detalle = array();
                
                foreach($datos as $info){
                    $detalle[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "idclase" => $info->invclase,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numeroserie,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "count" => $info->prncount,
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                $array = array(
                    "datos" => $detalle,
                    "url_print" => $urlPrint
                );
                
                echo json_encode($array);
            }
        }

        function getFormatoPrintClase(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idclase = $this->input->post('idclase');
                $controlador = $this->session->userdata('controlador_vn');

                $url = $controlador.'/pprint';
                $this->load->model('ventas_model');
                $array = $this->ventas_model->getFormatoPrintDef($idclase,$url);
                echo json_encode($array);
            }
        }

        function getExistenciasGeneralesComplete(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoPro = $this->input->post('tipoPro');
                $categoria = $this->input->post('categoria');
                $sucursales = $this->input->post('sucursales');
                
                $this->load->model('sucursal_model');
                $productos = $this->sucursal_model->get_Existencias_Kardex_Suc($tipoPro, $categoria, $sucursales);
                
                $array = array();
                foreach($productos as $pro){
                    $array[] = array(
                        "linea" => $pro->linea,
                        "departamento" => $pro->departamento,
                        "id" => $pro->id,
                        "producto" => $pro->producto,
                        "marca" => $pro->marca,
                        "xpos" => $pro->xpos,
                        "modelo" => $pro->modelo,
                        "um" => $pro->um,
                        "imagen" => $pro->imagen,
                        "precioventa" => $pro->precioventa,
                        "barcode" => $pro->barcode,
                        "costounitario" => $pro->costounitario,
                        "cantidad" => round($pro->cantidad,2),
                        "idnivel1" => $pro->idnivel1
                    );
                }
                
                $result = array('datos' => $array);
                echo json_encode($result);
            }
        }

        function getDetalleExistenciaFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $tipoproducto = $this->input->post('tipoproducto');
                $idcentro = $this->input->post('idcentro');
                
                $this->load->model('sucursal_model');
                $productos = $this->sucursal_model->getDetalleExistenciaFacturacion($tipoproducto, $idcentro);
                
                $i=0;
                $array = array();
                if($productos){
                    foreach($productos as $pro){
                        $totalCajas = 0;
                        if($pro->tipo != 4){
                            if($pro->upp != 0){
                                $totalCajas = $pro->cantidad / $pro->upp;
                                if($totalCajas % 1 == 0){
                                    $totalCajas = number_format($totalCajas);
                                }else{
                                    $totalCajas = number_format($totalCajas, 2, '.', '');
                                }
                            }
                        }
    
                        $array[$i] = array(
                            "id" => $pro->id,
                            "linea" => $pro->linea,
                            "departamento" => $pro->departamento,
                            "producto" => $pro->producto,
                            "marca" => $pro->marca,
                            "xpos" => $pro->xpos,
                            "modelo" => $pro->modelo,
                            "um" => $pro->um,
                            "upp" => $pro->upp,
                            "imagen" => $pro->imagen,
                            "precioventa" => $pro->precioventa * 1,
                            "barcode" => $pro->barcode,
                            "cantidad" => round($pro->cantidad, 2),
                            "cajas" => $totalCajas
                        );
                        $i++;
                    }
                }
               
                
                echo json_encode($array);
            }
        }

        function getDetalleExistenciasProducto(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getDetalleExistenciasProducto($idproducto);
                
                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $totalCajas = 0;
                    if($info->tipo != 4){
                        if($info->upp != 0){
                            $totalCajas = $info->cantidad / $info->upp;
                            if($totalCajas % 1 == 0){
                                $totalCajas = number_format($totalCajas);
                            }else{
                                $totalCajas = number_format($totalCajas, 2, '.', '');
                            }
                        }
                    }

                    $array[$i] = array(
                        "namesucursal" => $info->centro,
                        "cantidad" => $info->cantidad,
                        "upp" => $info->upp,
                        "cajas" => $totalCajas
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getDetalleMultiplesPrecios(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idproducto = $this->input->post('idproducto');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getDetalleMultiplesPrecios($idproducto);

                $i=0;
                $array = array();
                foreach($informacion as $info){
                    $array[$i] = array(
                        "descrip" => $info->descrip,
                        "precioventa" => number_format($info->precioventa, 5, '.', '')
                    );

                    $i++;
                }

                echo json_encode($array);
            }
        }

        function getDetalleInformacionCliente(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idusuario = $this->input->post('idusuario');
                
                $this->load->model('xordenes_model');
                $array = $this->xordenes_model->getDetalleInformacionCliente($idusuario);
                echo json_encode($array);
            }
        }

        function getListadoDeCotizaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idcliente = $this->input->post('idcliente');
                $idvendedor = $this->input->post('idvendedor');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoDeCotizaciones($idcliente, $idvendedor);
                
                $i=0;
                $infoArray=array();
                if($informacion != false){
                    
                    $infoArray[0] = array(
                        "id" => 0,
                        "descrip" => "TODAS"
                    );
                    
                    $i=1;
                    foreach($informacion as $info){
                        $infoArray[$i] = array(
                            "id" => $info->id,
                            "descrip" => $info->descrip
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $infoArray,
                    "cantidad" => $i
                );
                
                echo json_encode($array);
            }
        }

        function getListadoDeCotizacionesFacturacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $estados = $this->input->post('estados');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoDeCotizacionesFacturacion($estados);
                
                $i=0;
                $infoArray=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->dev_contact == ""){
                            $nameContacto = $info->nameCliente;
                        }else{
                            $nameContacto = $info->dev_contact;
                        }
                        
                        $infoArray[$i] = array(
                            "id" => $info->id,
                            "descrip" => $info->descrip,
                            "fecha" => $info->fecha,
                            "fecha_insert" => $info->fecha_insert,
                            "idcps" => $info->idcps,
                            "idworker" => $info->idworker,
                            "idcentro" => $info->idcentro,
                            "dev_place" => $info->dev_place,
                            "idclase" => $info->cli_notify,
                            "cajclase" => $info->cajclase,
                            "nameCliente" => $info->nameCliente,
                            "nameContacto" => $nameContacto,
                            "nameVendedor" => $info->nameVendedor,
                            "nameDocumento" => $info->nameDocumento,
                            "namePago" => $info->namePago,
                            "total" => $info->val_pro
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $infoArray
                );
                
                echo json_encode($array);
            }
        }

        function getListadoDeCotizacionesVendedor(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $estados = $this->input->post('estados');
                $idvendedor = $this->input->post('idvendedor');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoDeCotizacionesVendedor($idvendedor, $estados);
                
                $i=0;
                $infoArray=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->dev_contact == ""){
                            $nameContacto = $info->nameCliente;
                        }else{
                            $nameContacto = $info->dev_contact;
                        }
                        
                        $infoArray[$i] = array(
                            "id" => $info->id,
                            "descrip" => $info->descrip,
                            "fecha" => $info->fecha,
                            "fecha_insert" => $info->fecha_insert,
                            "idcps" => $info->idcps,
                            "idworker" => $info->idworker,
                            "idcentro" => $info->idcentro,
                            "idclase" => $info->cli_notify,
                            "cajclase" => $info->cajclase,
                            "nameCliente" => $info->nameCliente,
                            "nameContacto" => $nameContacto,
                            "nameVendedor" => $info->nameVendedor,
                            "nameDocumento" => $info->nameDocumento,
                            "namePago" => $info->namePago,
                            "total" => $info->val_pro
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $infoArray
                );
                
                echo json_encode($array);
            }
        }

        function getListadoProductosDeCotizaciones(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('cotizacion');
                $idcliente = $this->input->post('idcliente');
                $idvendedor = $this->input->post('idvendedor');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoProductosDeCotizaciones($trannum, $idcliente, $idvendedor, $idcentro);
                
                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->cantidadord <= $info->saldo){
                            $cantidad = $info->cantidadord;
                        }else{
                            $cantidad = $info->saldo;
                        }
                        
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "idbatch" => $info->idbatch,
                            "idbin" => $info->idbin,
                            "um" => $info->um,
                            "tipotax" => $info->tipotax,
                            "uniconv" => 1,
                            "linea" => $info->linea,
                            "barcode" => $info->barcode,
                            "preciosd" => $info->precioneto,
                            "cantrp" => $info->cantrp,
                            "descuento" => number_format($info->cantrp)."%",
                            "precioventa" => ($info->precioneto - ($info->precioneto * ($info->cantrp/100))),
                            "cantidadord" => $info->cantidadord,
                            "saldo" => $info->saldo,
                            "cantidad" => $cantidad
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function agregarProductoFacturacionCotizacion(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $dataSource = $this->input->post('dataSource');
                $idcatalogo = $this->input->post('idcatalogo');
                $trannum = $this->input->post('trannum');
                $pro_vende = $this->input->post('pro_vende');
                $modevn = $this->input->post('modevn');
                $filtrodatos = $this->input->post('filtrodatos');
                $descuento = 0; $notas = "";
                $idworker = $this->input->post('idworker');
                $idclase = $this->input->post('idclase');
                $opcion = $this->session->userdata('opcionmenu');
                if($opcion == 1){
                    $idcentro = $this->session->userdata('idcentroTemp');
                }else{
                    $idcentro = $this->session->userdata('idcentrouser');
                }
                
                $this->load->model('ventas_model'); $this->load->model('invtran_model');
                
                $itemError = 0;
                for($i=0; $i<count($dataSource); $i++){
                    $cantidad = $dataSource[$i]['cantidad'];
                    $saldo = $dataSource[$i]['saldo'];
                    
                    if($saldo == ""){
                        $saldo = 0;
                    }
                    
                    $productoInsert = 1;
                    if($cantidad != 0){
                        if($cantidad <= $saldo){
                            $productoInsert = 1;
                        }else{
                            $itemError = 1;
                            $productoInsert = 0;
                        }   
                    }else{
                        $productoInsert = 0;
                    }
                    
                    $cantidad = $dataSource[$i]['cantidad'];
                    $idbatch = $dataSource[$i]['idbatch'];
                    $idbin = $dataSource[$i]['idbin'];
                    $idproducto = $dataSource[$i]['idproducto'];
                    $precio = $dataSource[$i]['precioventa'];
                    $um = $dataSource[$i]['um'];
                    $tipotax = $dataSource[$i]['tipotax'];
                    $uniconv = $dataSource[$i]['uniconv'];
                    
                    if($productoInsert == 1){
                        $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$idworker,$notas,$tipotax,$pro_vende,$modevn,'');
                    }
                }
                                
                if($filtrodatos == 1){
                    $detalle = $this->invtran_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 2){
                    $detalle = $this->ventas_model->getInventarioByMarcas($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 3){
                    $detalle = $this->ventas_model->getInventarioByModelos($trannum, $idcatalogo, $idcentro);
                }else if($filtrodatos == 4){
                    $inventariomore = $this->ventas_model->getListadoProductosServiciosMasVendidos($idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "upp" => $info->upp,
                            "um" => $info->um,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    } 
                    
                    $inventariomore = $this->ventas_model->getListadoProductosMasVendidos($idcentro);
                    foreach($inventariomore as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "upp" => $info->upp,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }else if($filtrodatos == 5){
                    $servicios = $this->ventas_model->getInventarioByServicios($trannum, $idcentro);
                    
                    $i=0;
                    $items = array();
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "upp" => $serv->upp,
                            "um" => $serv->um,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $datos = $this->invtran_model->getDataVentaTran100k($trannum, $idcentro);
                
                if($filtrodatos == 1){
                    $servicios = $this->ventas_model->getListadoProductosServicios($trannum,$idcentro,$idcatalogo);
                }
                
                if($filtrodatos != 4 && $filtrodatos != 5){
                    $i=0;
                    $items = array();
                    foreach($detalle as $info){
                        $items[$i] = array(
                            "nameproducto" => $info->descrip,
                            "marca" => $info->marca,
                            "modelo" => $info->modelo,
                            "upc" => $info->barcode,
                            "notas" => $info->notas,
                            "idproducto" => $info->idproducto,
                            "tipo" => $info->tipo,
                            "um" => $info->um,
                            "upp" => $info->upp,
                            "imagen" => $info->imagen,
                            "cantidad" => $info->cantidad,
                            "precio" => $info->costounitario,
                            "idbin" => $info->idbin,
                            "idbatch" => $info->idbatch,
                            "precioventa" => $info->precioventa,
                            "idcatalogo" => $info->idcatalogo,
                            "tipotax" => $info->tipotax
                        );
                        $i++;
                    }
                }
                
                if($filtrodatos == 1){
                    foreach($servicios as $serv){
                        $items[$i] = array(
                            "nameproducto" => $serv->descrip,
                            "marca" => $serv->marca,
                            "modelo" => $serv->modelo,
                            "upc" => $serv->barcode,
                            "notas" => $serv->notas,
                            "idproducto" => $serv->idproducto,
                            "tipo" => $serv->tipo,
                            "um" => $serv->um,
                            "upp" => $serv->upp,
                            "imagen" => $serv->imagen,
                            "cantidad" => $serv->cantidad,
                            "precio" => $serv->costounitario,
                            "idbin" => $serv->idbin,
                            "idbatch" => $serv->idbatch,
                            "precioventa" => $serv->precioventa,
                            "idcatalogo" => $serv->idcatalogo,
                            "tipotax" => $serv->tipotax
                        );
                        $i++;
                    }
                }
                
                $total = 0; $cantidad = 0; $unidades = 0;
                foreach($datos as $data){
                    $total = $total + $data->precioneto * abs($data->cantidad);
                    $cantidad = $cantidad + abs($data->cantidad);
                    $unidades++;
                }
                
                $array = array(
                    "items" => $items,
                    "datos" => $datos,
                    "cantidad" => $unidades,
                    "unidades" => $cantidad,
                    "count" => $i,
                    "error" => $itemError,
                    "total" => $total
                );
                
                echo json_encode($array);
            }
        }

        function getListadoDePedidosVentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $estados = $this->input->post('estados');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoDePedidosVentas($idcentro, $estados);
                
                $i=0;
                $infoArray=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->dev_contact == ""){
                            $nameContacto = $info->nameCliente;
                        }else{
                            $nameContacto = $info->dev_contact;
                        }
                        
                        $infoArray[$i] = array(
                            "id" => $info->id,
                            "descrip" => $info->descrip,
                            "fecha" => $info->fecha,
                            "fecha_insert" => $info->fecha_insert,
                            "idcps" => $info->idcps,
                            "idworker" => $info->idworker,
                            "idcentro" => $info->idcentro,
                            "idclase" => $info->idclase,
                            "cajclase" => $info->cajclase,
                            "nameCliente" => $info->nameCliente,
                            "nameContacto" => $nameContacto,
                            "nameVendedor" => $info->nameVendedor,
                            "nameDocumento" => $info->nameDocumento,
                            "namePago" => $info->namePago,
                            "total" => $info->val_pro + $info->val_otros
                        );
                        $i++;
                    }
                }
                
                $array = array(
                    "datos" => $infoArray
                );
                
                echo json_encode($array);
            }
        }

        function getListadoProductosDePedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $trannum = $this->input->post('trannum');
                $idcentro = $this->session->userdata('idcentrouser');
                
                $this->load->model('xordenes_model');
                $informacion = $this->xordenes_model->getListadoProductosDePedido($trannum, $idcentro);
                
                $i=0;
                $array=array();
                if($informacion != false){
                    foreach($informacion as $info){
                        if($info->cantidadord <= $info->saldo){
                            $cantidad = $info->cantidadord;
                        }else{
                            $cantidad = $info->saldo;
                        }
                        
                        $array[$i] = array(
                            "idproducto" => $info->idproducto,
                            "descrip" => $info->descrip,
                            "modelo" => $info->modelo,
                            "marca" => $info->marca,
                            "idbatch" => $info->idbatch,
                            "idbin" => $info->idbin,
                            "um" => $info->um,
                            "tipotax" => $info->tipotax,
                            "uniconv" => 1,
                            "linea" => $info->linea,
                            "barcode" => $info->barcode,
                            "preciosd" => $info->precio,
                            "cantrp" => $info->descuento,
                            "descuento" => number_format($info->descuento)."%",
                            "precioventa" => ($info->precio - ($info->precio * ($info->descuento/100))),
                            "cantidadord" => $info->cantidadord,
                            "saldo" => $info->saldo,
                            "cantidad" => $cantidad
                        );
                        $i++;
                    }
                }
                
                echo json_encode($array);
            }
        }

        function insertOrdenDeVentaPedido(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fecha = $this->input->post('fecha');
                $notas = trim($this->input->post('notas'));
                $documento = $this->input->post('documento');
                $vendedor = $this->input->post('vendedor');
                $cliente = $this->input->post('cliente');
                $idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                $idcentrod = $this->input->post('idcentrod');
                $descrip = $this->input->post('descrip');
                $pago = $this->input->post('pago');
                $dataSource = $this->input->post('dataSource');
                $estado = $this->input->post('estado');
                $trannumPedido = $this->input->post('trannum');
                
                $this->load->model('ventas_model');
                $this->load->model('xordenes_model');
                                
                $trannum = $this->xordenes_model->insertarFacturacionPedido($fecha, $notas, $documento, $vendedor, $cliente, $idcentro, $idcaja, $numx, $numz, $idcentrod, $pago, $trannumPedido);
                $this->xordenes_model->updateEstadoPedido($trannumPedido, $estado);
                $totLineas = $this->xordenes_model->totalLineasDocumento($documento);
                $docExento = $this->xordenes_model->validateDocumentoExentoPedido($trannumPedido);
                    
                $modevn = 0; $itemError = 0; $numItems=1;
                for($i=0; $i<count($dataSource); $i++){
                    if($numItems <= $totLineas){
                        $cantidad = $dataSource[$i]['cantidad'];
                        $saldo = $dataSource[$i]['saldo'];

                        if($saldo == ""){
                            $saldo = 0;
                        }

                        $productoInsert = 1;
                        if($cantidad != 0){
                            if($cantidad <= $saldo){
                                $productoInsert = 1;
                            }else{
                                $itemError = 1;
                                $productoInsert = 0;
                            }   
                        }else{
                            $productoInsert = 0;
                        }

                        $cantidad = $dataSource[$i]['cantidad'];
                        $idbatch = $dataSource[$i]['idbatch'];
                        $idbin = $dataSource[$i]['idbin'];
                        $idproducto = $dataSource[$i]['idproducto'];
                        $precio = $dataSource[$i]['preciosd'];
                        $descuento = $dataSource[$i]['cantrp'];
                        $barcode = $dataSource[$i]['barcode'];
                        $um = $dataSource[$i]['um'];
                        if($docExento == 1){
                            $tipotax = 0;
                        }else{
                            $tipotax = $dataSource[$i]['tipotax'];
                        }
                        $notasPro = "";
                        $uniconv = $dataSource[$i]['uniconv'];
                        
                        if($productoInsert == 1){
                            $this->ventas_model->insertarProductoVentaUM($idproducto,$uniconv,$cantidad,$trannum,$descuento,$precio,$idbin,$idbatch,$um,$vendedor,$notasPro,$tipotax,$vendedor,$modevn,$barcode);
                            $numItems++;
                        }
                    }
                }
                
                echo json_encode($trannum);
            }
        }

        function validateCambioPrecioOrden(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $idproducto  = $this->input->post('idproducto');
                $precioventa = $this->input->post('precioventa');
                
                $this->load->model('xordenes_model');
                $costounitario = $this->xordenes_model->getCostounitarioProducto($idproducto);
                $costounitario = ($costounitario * 0.25) + $costounitario;
                
                $validate = ($precioventa <= $costounitario) ? false : true;

                echo json_encode($validate);
            }
        }

        function getDatosFacturasVentasCajaDia(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB')){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
				$idcentro = $this->input->post('idcentro');
                $idcaja = $this->input->post('idcaja');
                $numx = $this->input->post('numx');
                $numz = $this->input->post('numz');
                
                $datosTemp = array(
                    'idcentroTemp' => $idcentro,
                    'idcajaTemp' => $idcaja,
                    'fechaini' => $fechaini
				);
                $this->session->set_userdata($datosTemp);
                
                $this->load->model('ventas_model');
                $datos = $this->ventas_model->getDatosFacturasVentasCajaDia('VN', $idcentro, $idcaja, $fechaini, $numx, $numz);
                
                $i=0;
                $array = array();
                
                foreach($datos as $info){
                    if($info->exento == 0){
                        $valtax1 = $info->valtax1;
                    }else{
                        $valtax1 = 0;
                    }
                    
                    $totalVenta = $info->valventan + $valtax1;
                    
                    $array[$i] = array(
                        "trannum" => $info->trannum,
                        "fecha" => $info->fecha,
                        "hora" => $info->hora,
                        "tipodoc" => $info->tipodoc,
                        "numeroserie" => $info->numero,
                        "namecliente" => $info->namecliente,
                        "namevendedor" => $info->namevendedor,
                        "referencia" => $info->referencia,
                        "valventan" => number_format($totalVenta, 2, '.', ''),
                        "estatus" => $info->estatus
                    );
                    $i++;
                }
                
                echo json_encode($array);
            }
        }
    }
?>