<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Xcaja extends CI_Controller{
			
		function __construct(){
			parent::__construct();
		}
		function highlight_array($array, $name = 'var') {
            highlight_string("<?php\n\$$name =\n" . var_export($array, true) . ";\n?>");
        }
		function index(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$this->load->model('invtran_model');
				$tipoBusca = $this->invtran_model->getFiltroBuscaProd('gv_prodsearch');

				if($tipoBusca == 1){
					$array = array(
						"gv_prodsearch" => $tipoBusca,
						"gv_prodtext" => "Código Interno"
					);
				}elseif($tipoBusca == 2){
					$array = array(
						"gv_prodsearch" => $tipoBusca,
						"gv_prodtext" => "Modelo"
					);
				}elseif($tipoBusca == 3){
					$array = array(
						"gv_prodsearch" => $tipoBusca,
						"gv_prodtext" => "Código de Barra"
					);
				}elseif($tipoBusca == 4){
					$array = array(
						"gv_prodsearch" => $tipoBusca,
						"gv_prodtext" => "Código Xpos"
					);
				}elseif($tipoBusca == 5){
					$array = array(
						"gv_prodsearch" => $tipoBusca,
						"gv_prodtext" => "Descripción"
					);
				}

				$this->session->set_userdata($array);

				$this->load->view('xcaja_touch');
			}
		}

		function integracion($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
					'iddApp' => $idApp,
					'appName' => $appName,
					'namePage' => $appName
				);
				$this->session->set_userdata($resultAppName);
				$this->load->view('mantenimiento_integracion');
			}
		}

		function integracion2022($idApp){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
					'iddApp' => $idApp,
					'appName' => $appName,
					'namePage' => $appName
				);
				$this->session->set_userdata($resultAppName);
				$this->load->view('mantenimiento_integracion2022');
			}
		}
		
		function generarArchivoIntegracion(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();

				$idcentro = $this->input->post('idcentro');

				$this->load->model('xcaja_model');
				$this->load->model('global_model');
				
				$RazonSocial = $this->global_model->getDatosGeneralesEmp('g_empdatos', 1);
				$NRC 		 = $this->global_model->getDatosGeneralesEmp('g_empdatos', 3);
				$NIT 		 = $this->global_model->getDatosGeneralesEmp('g_empdatos', 4);
				$GIRO 		 = $this->global_model->getDatosGeneralesEmp('g_empdatos', 5);
				$productos 	 = $this->xcaja_model->getProductosToArchive($idcentro);
				$inv_def 	 = $this->xcaja_model->getInvdefToArchive();
				$clientes 	 = $this->xcaja_model->getCtauxiToArchive();
				$ctcajas	 = $this->xcaja_model->getCajasToArchive($idcentro);
				$vendedores  = $this->xcaja_model->getVendedoresToArchive();
				$caj_def 	 = $this->xcaja_model->getCajdefToArchive();
				$gzips	 	 = $this->xcaja_model->getGZipsToArchive();
				$gnums	  	 = $this->xcaja_model->getGnumsToArchive($idcentro);
				$infotaxes   = $this->xcaja_model->getImpuestosToArchive();
				$valor_taxes = "";
				$multi_pre	 = "";
				$multi_bar	 = "";

				$archivo = fopen("doc_cuentas/".$this->session->userdata('dirDocuments')."/mdiario".str_pad($idcentro, 4, "0", STR_PAD_LEFT).".txt", "w");
				
				
				foreach($infotaxes as $info){
					$valor_taxes .= $info->valor_num.":";
				}

				#00
				foreach($ctcajas as $info){
					$infoDireccion 	= explode("|", $info->direccion);
					$descrip 		= str_replace("|", "", $info->descrip);

					fwrite($archivo, "00|".$info->idcaja."|".$info->idcentro."|".$info->xpos."|".strtoupper(trim($descrip))."|".$info->numx."|".$info->numy."|".$info->numz."|".$info->cajaopen."|".$info->cajafecha."|".$info->cajafondo."|".$info->resolucion."|".$info->fresolucion."|".$RazonSocial."|".trim($infoDireccion[0])."|".trim($infoDireccion[1])."|".$GIRO."|".$NRC."|".$NIT."|".substr($valor_taxes, 0, -1)."\r\n");
				}

				#01
				foreach($inv_def as $info){
					$descrip = str_replace("|", "", $info->descrip);
					fwrite($archivo, "01|".$info->invclase."|".strtoupper(trim($descrip))."|||".intval($info->inopera)."|".intval($info->caopera)."|".$info->agrupa."|".intval($info->askregiva)."|".intval($info->exento)."||".intval($info->maxpagos)."|".intval($info->maxlines)."|".intval($info->adddisline)."|".str_replace(",", ":", $info->pagos)."|".$info->numgrupo."|".intval($info->esticket)."||\r\n");
				}

				#02
				foreach($gnums as $info){
					fwrite($archivo, "02|".$info->idrnum."|".$info->numgrupo."|".$info->idcentro."|".$info->idcaja."|".$info->serie."|".$info->desde."|".$info->hasta."|".$info->actual."|".$info->resolucion."|".$info->fresolucion."|".$info->reserva."|".$info->bfecha."|".$info->efecha."\r\n");
				}

				#03
				foreach($vendedores as $info){
					$descrip = str_replace("|", "", $info->descrip);
					fwrite($archivo, "03|".$info->idauxi."|01|".strtoupper(trim($descrip))."||\r\n");
				}

				#03
				foreach($caj_def as $info){
					$descrip = str_replace("|", "", $info->descrip);
					fwrite($archivo, "03|".$info->cajclase."|02|".strtoupper(trim($descrip))."|".intval($info->vueltos).":".intval($info->alcuadre).":".intval($info->minval).":".intval($info->maxval).":".intval($info->cajamaxval).":".intval($info->creditchk).":".intval($info->creditdays).":".intval($info->askauto).":".intval($info->dm).":".intval($info->tasa).":".$info->xpos."\r\n");
				}

				#03
				foreach($gzips as $info){
					fwrite($archivo, "03|".$info->idzip."|03|".strtoupper(trim($info->municipio)).",".strtoupper(trim($info->depto))."||\r\n");
				}

				#04
				foreach($clientes as $info){
					$saldodis = 0;
					if($info->idauxidef == 2){
						$saldodis = $this->xcaja_model->getSaldoDisponibleCliente($info->idauxi);
					}

					$descrip = str_replace("|", "", $info->descrip);
					fwrite($archivo, "04|".$info->idauxi."|".strtoupper(trim($descrip))."|".$info->idauxidef."|".$info->telefono."|".$info->correo."|".trim($info->direccion)."|".$info->idzip."|".$info->nrc."|".$info->nit."|".trim($info->giro)."|".$info->grupo."|".$saldodis."|".$info->dias."|".$info->idtipo."|\r\n");
				}
				
				#10
				foreach($productos as $info){
					$infomulti = $this->xcaja_model->getInformacionMultiPreBar($info->idproducto);

					$multi_pre .= "11|".$info->idproducto."|1|".$info->um."|1|".number_format($info->precioventa, 2, '.', '')."|".$info->descuento."\r\n";
					$multi_bar .= ($info->barcode == "") ? "" : "12|".$info->idproducto."|".$info->barcode."\r\n";

					if($infomulti != false){
						$numitems=2;
						foreach($infomulti as $inf_multi){
							if($inf_multi->idgvar == 1){
								$multi_pre .= "11|".$info->idproducto."|".$numitems."|".strtoupper(trim($inf_multi->descrip))."|".number_format($inf_multi->uniconv, 2, '.', '')."|".number_format($inf_multi->precioventa, 2, '.', '')."|".$info->descuento."\r\n";
								$numitems++;
							}else if($inf_multi->idgvar == 2){
								$multi_bar .= "12|".$info->idproducto."|".$inf_multi->descrip."\r\n";
							}
						}
					}
					
					$descrip = str_replace("|", "", $info->descrip);
					fwrite($archivo, "10|".$info->idproducto."|".$info->tipo."|".strtoupper(trim($descrip))."|".trim($info->marca)."|".trim($info->modelo)."|".$info->idbatch."|".$info->idbin."|".$info->tipotax."|".$info->costounitario."|".trim($info->departamento)."|".trim($info->linea)."|".$date->format('Y-m-d')."|".number_format($info->saldo, 2, '.', '')."|||\r\n");
				}

				fwrite($archivo, $multi_pre);
				fwrite($archivo, $multi_bar);
				fclose($archivo);
				
				echo json_encode($productos);
			}
		}

		function generarArchivoIntegracion2022($idcentro, $idcaja){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$this->load->helper('download');

				date_default_timezone_set('America/El_Salvador');
				$date = new DateTime();

				//$idcentro = $this->input->post('idcentro');

				$this->load->model('xcaja_model');
				$this->load->model('global_model');
				
				$productos 	 = $this->xcaja_model->getProductosToArchive($idcentro);				
				

				$csv = "";
				$csvProductos = "";
				$csvPrices = "";
				$csvSearch1 = "";
				$csvSearch2 = "";
				$csvSearch3 = "";
				$csvKit = "";

				#01
				foreach($productos as $pro){
					$csvProductos .= "01|";
					$csvProductos .= trim($pro->idproducto)."|";
					$csvProductos .= trim($pro->descrip)."|";
					$csvProductos .= trim($pro->tipo)."|";
					$csvProductos .= trim($pro->marca)."|";
					$csvProductos .= trim($pro->departamento)."|";
					$csvProductos .= trim($pro->linea)."|";
					$csvProductos .= trim($pro->idbatch)."|";
					$csvProductos .= trim($pro->idbin)."\r\n";

					#02
					$prodprices  = $this->xcaja_model->getPromultiToArchive($pro->idproducto);
					foreach($prodprices as $price){
						$csvPrices .= "02|";
						$csvPrices .= trim($price->idproducto)."|";
						$csvPrices .= trim($price->idgvar)."|";
						$csvPrices .= trim($price->descrip)."|";
						$csvPrices .= trim($price->descrip)."|";
						$csvPrices .= trim($price->costounitario)."|";
						$csvPrices .= trim($price->precioventa)."|";
						$csvPrices .= trim($price->uniconv)."|";
						$csvPrices .= trim($price->notas)."|";
						$csvPrices .= trim($price->tipotax)."|";
						$csvPrices .= trim($price->profecini)."|";
						$csvPrices .= trim($price->profecfin)."|";
						$csvPrices .= trim($price->lowrange)."|";
						$csvPrices .= trim($price->highrange)."|";
						$csvPrices .= trim($price->askpwd)."\r\n";
					}

					$prodprices2  = $this->xcaja_model->getPromulti2ToArchive($pro->idproducto);
					foreach($prodprices2 as $price){
						$csvPrices .= "02|";
						$csvPrices .= trim($price->idproducto)."|";
						$csvPrices .= 'P'."|";
						$csvPrices .= trim($price->um)."|";
						$csvPrices .= trim($price->um)."|";
						$csvPrices .= trim($price->costounitario)."|";
						$csvPrices .= trim($price->precioventa)."|";
						$csvPrices .= '1'."|";
						$csvPrices .= trim($price->notas)."|";
						$csvPrices .= trim($price->tipotax)."|";
						$csvPrices .= ''."|";
						$csvPrices .= ''."|";
						$csvPrices .= ''."|";
						$csvPrices .= ''."|";
						$csvPrices .= ''."\r\n";
					}

					#03
					$prodseach1  = $this->xcaja_model->getProdSearchToArchive($pro->idproducto);
					foreach($prodseach1 as $prod1){
						$csvSearch1 .= "03|";
						$csvSearch1 .= trim($prod1->descrip)."|";					
						$csvSearch1 .= trim($prod1->idproducto)."|";
						$csvSearch1 .= trim($prod1->idgvar)."\r\n";
					}

					$prodseach2  = $this->xcaja_model->getProdSearch2ToArchive($pro->idproducto);
					foreach($prodseach2 as $prod2){
						$csvSearch2 .= "03|";
						$csvSearch2 .= trim($prod2->modelo)."|";					
						$csvSearch2 .= trim($prod2->idproducto)."|";
						$csvSearch2 .= 'M'."\r\n";
					}

					$prodseach3  = $this->xcaja_model->getProdSearch3ToArchive($pro->idproducto);
					foreach($prodseach3 as $prod3){
						$csvSearch3 .= "03|";
						$csvSearch3 .= trim($prod3->xpos)."|";					
						$csvSearch3 .= trim($prod3->idproducto)."|";
						$csvSearch3 .= 'X'."\r\n";
					}

					#04
					$prodkits    = $this->xcaja_model->getProKitToArchive($pro->idproducto);
					foreach($prodkits as $kit){
						$csvKit .= "04|";
						$csvKit .= trim($kit->idproducto)."|";
						$csvKit .= trim($kit->descrip)."|";
						$csvKit .= trim($kit->um)."|";					
						$csvKit .= trim($kit->uniconv)."\r\n";
					}
				}

				$csv = $csvProductos . $csvPrices . $csvSearch1 . $csvSearch2 . $csvSearch3 . $csvKit;

				#10
				$clientes 	 = $this->xcaja_model->getClienteToArchive();
				foreach($clientes as $cli){
					$csv .= "10|";
					$csv .= trim($cli->idauxi)."|";
					$csv .= trim($cli->descrip)."|";
					$csv .= ""."|";
					$csv .= trim($cli->idtipo)."|";
					$csv .= trim($cli->limite)."|";
					$csv .= trim($cli->dias)."|";
					$csv .= trim($cli->nrc)."|";
					$csv .= trim($cli->dui)."|";
					$csv .= trim($cli->nit)."|";
					$csv .= trim($cli->giro)."|";
					$csv .= trim($cli->direccion)."|";
					$csv .= trim($cli->pais)."|";
					$csv .= trim($cli->municipio)."|";
					$csv .= trim($cli->depto)."|";
					$csv .= trim($cli->telefono)."\r\n";
				}

				#11
				$empleados   = $this->xcaja_model->getEmpleadoToArchive();
				foreach($empleados as $emp){
					$csv .= "11|";
					$csv .= trim($emp->idauxi)."|";				
					$csv .= trim($emp->descrip)."\r\n";
				}

				#12
				$users       = $this->xcaja_model->getUserToArchive($idcentro);
				foreach($users as $us){
					$csv .= "12|";
					$csv .= trim($us->descrip)."|";		
					$csv .= trim($us->username)."|";				
					$csv .= trim($us->idcps)."|";				
					$csv .= trim($us->idcaja)."|";				
					$csv .= trim($us->duedate)."|";				
					$csv .= ""."\r\n";
				}		
				
				#13
				$correlativos = $this->xcaja_model->getCorrelativosToArchive($idcaja);
				foreach($correlativos as $cor){
					$csv .= "13|";
					$csv .= trim($cor->numgrupo)."|";		
					$csv .= trim($cor->serie)."|";				
					$csv .= trim($cor->desde)."|";				
					$csv .= trim($cor->hasta)."|";				
					$csv .= trim($cor->actual)."|";	
					$csv .= trim($cor->resolucion)."|";				
					$csv .= trim($cor->fresolucion)."|";				
					$csv .= trim($cor->reserva)."|";				
					$csv .= trim($cor->bfecha)."|";	
					$csv .= trim($cor->efecha)."|";							
					$csv .= trim($cor->estatus)."\r\n";				
				}	
				
				#14
				$doctypes = $this->xcaja_model->getDoctypesToArchive();
				foreach($doctypes as $doc){
					$csv .= "14|";
					$csv .= trim($doc->invclase)."|";		
					$csv .= trim($doc->descrip)."|";				
					$csv .= trim($doc->inopera)."|";				
					$csv .= trim($doc->caopera)."|";				
					$csv .= trim($doc->agrupa)."|";	
					$csv .= trim($doc->askregiva)."|";				
					$csv .= trim($doc->exento)."|";				
					$csv .= trim($doc->esticket)."|";				
					$csv .= trim($doc->pagos)."|";	
					$csv .= trim($doc->maxlines)."|";				
					$csv .= trim($doc->adddisline)."|";										
					$csv .= trim($doc->numgrupo)."\r\n";				
				}

				#15
				$payments = $this->xcaja_model->getPaymentsToArchive();
				foreach($payments as $pay){
					$csv .= "15|";
					$csv .= trim($pay->cajclase)."|";		
					$csv .= trim($pay->descrip)."|";				
					$csv .= trim($pay->vueltos)."|";																	
					$csv .= trim($pay->creditchk)."\r\n";				
				}

				$name = 'master'.str_pad($idcentro, 4, "0", STR_PAD_LEFT).'.txt';
				force_download($name, $csv);

				//echo "<pre>".$csv."</pre>";
			}
		}
		
		function descargarArchivo($idcentro){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$nameArchivo = "doc_cuentas/".$this->session->userdata('dirDocuments')."/mdiario".str_pad($idcentro, 4, "0", STR_PAD_LEFT).".txt";
				$baseArchivo = basename($nameArchivo);
				
				header("Content-Type: application/octet-stream");
				header("Content-Length:".filesize($nameArchivo));
				header("Content-Disposition: attachment; filename=".$baseArchivo."");
				
				readfile($nameArchivo);
			}
		}

		function getListadoLineasProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$idcentro = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model'); 
				$informacion = $this->xcaja_model->getListadoLineasProductos($idcentro, 1);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"descrip" => strtoupper(trim($info->descrip))
					);
					$i++;
				}
				
				echo json_encode($array);
			}
		}
		
		function getListadoLineasCategorias(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				#$idcatalogo = $this->input->post('idcatalogo');
				$idcentro   = $this->session->userdata('idcentrouser');
				
				$this->load->model('xcaja_model'); 
				$informacion = $this->xcaja_model->getListadoLineasCategorias($idcentro, 1);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"idcatalogo" => $info->idcatalogo,
						"descrip" 	 => strtoupper(trim($info->descrip))
					);
					$i++;
				}
				
				echo json_encode($array);
			}
		}
		
		function getListadoCategoriasProductos(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$idcentro = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model'); 
				$informacion = $this->xcaja_model->getListadoCategoriasProductos($idcentro, 1);
				
				$i=0;
				$array = array();
				foreach($informacion as $info){
					$array[$i] = array(
						"idcatalogo" => $info->idcatalogo,
						"descrip" 	 => strtoupper(trim($info->descrip))
					);
					$i++;
				}
				
				echo json_encode($array);
			}
		}

		function getInventarioByCatalog(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$trannum 	= $this->input->post('trannum');
				$idcatalogo = $this->input->post('idcatalogo');
				$idcentro 	= $this->session->userdata('idcentrouser');
				
				$this->load->model('xcaja_model');
				$productos = $this->xcaja_model->getInventarioByCatalog($trannum, $idcatalogo, $idcentro, 1);
				//$productos = $this->xcaja_model->getInventarioByLinea($trannum, $idcatalogo, $idcentro, 1);
				//$servicios = $this->xcaja_model->getInventarioByCatalogServicios($trannum, $idcentro, $idcatalogo);
				
				$i=0;
				$datos = array();
				if($productos != false){
					foreach($productos as $info){
						$datos[$i] = array(
							"descrip" 		=> $info->descrip,
							"marca" 		=> $info->marca,
							"modelo" 		=> $info->modelo,
							"upc" 			=> $info->barcode,
							"idproducto" 	=> $info->idproducto,
							"tipo" 			=> $info->tipo,
							"um" 			=> $info->um,
							"imagen" 		=> $info->imagen,
							"cantidad" 		=> $info->cantidad,
							"costounitario" => $info->costounitario,
							"idbin" 		=> $info->idbin,
							"idbatch" 		=> $info->idbatch,
							"precioventa" 	=> $info->precioventa,
							"tipotax" 		=> $info->tipotax,
							"existe" 		=> $info->existe
						);
						$i++;
					}
				}

				/*
				if($servicios != false){
					foreach($servicios as $serv){
						$datos[$i] = array(
							"nameproducto" => $serv->descrip,
							"marca" => $serv->marca,
							"modelo" => $serv->modelo,
							"upc" => $serv->barcode,
							"idproducto" => $serv->idproducto,
							"tipo" => $serv->tipo,
							"um" => $serv->um,
							"imagen" => $serv->imagen,
							"cantidad" => $serv->cantidad,
							"costounitario" => $serv->costounitario,
							"idbin" => $serv->idbin,
							"idbatch" => $serv->idbatch,
							"precioventa" => $serv->precioventa,
							"tipotax" => $serv->tipotax
						);
						$i++;
					}
				}
				*/
				
				$array = array(
					"datos" => $datos
				);
				echo json_encode($array);
			}
		}

		function getDocumentosVentas(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$numx = $this->input->post('numx');
				$numz = $this->input->post('numz');
				$fecha = $this->input->post('fecha');
				$idcentro = $this->session->userdata('idcentrouser');
				$idcaja = $this->session->userdata('idcajauser');

				$this->load->model('xcaja_model');
				$infoOrdenes = $this->xcaja_model->getOrdenesPendientes($idcentro, $idcaja, $numx, $numz, $fecha);
				$infoDocumentos = $this->xcaja_model->getDocumentosVentas();

				$array = array(
					'infoOrdenes' => $infoOrdenes,
					'infoDocumentos' => $infoDocumentos,
				);

				echo json_encode($array);
			}
		}

		function generarNuevaVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$numx = $this->input->post('numx');
				$numz = $this->input->post('numz');
				$fecha = $this->input->post('fecha');
				$idclase = $this->input->post('idclase');
				$idworker = $this->session->userdata('idEmpleadoUser');
				$idcentro = $this->session->userdata('idcentrouser');
				$idcaja = $this->session->userdata('idcajauser');
				
				$this->load->model('xcaja_model');
				$this->load->model('global_model');
				
				$nombrevar = 'pos_cliente0'.$idcentro;
				$idcps = $this->global_model->getValorNumVariable($nombrevar);
				$array = $this->xcaja_model->generarNuevaVenta($idcentro, $idcaja, $idclase, $numx, $numz, $fecha, $idcps, $idworker);

				echo json_encode($array);

				/*
				$this->load->model('global_model');
				$this->load->model('ventas_model');
				
				if($cliente == 999999){
					$nombrevar = 'pos_grupocli0'.$idcentrod;
					$grupoCliente = $this->global_model->getValorTextoVariable($nombrevar);
				
					if($grupoCliente == "0"){
						$cliente = $this->ventas_model->insertNuevoClienteVN($descrip);
					}else{
						$cliente = $this->ventas_model->insertNuevoClienteVNGrupo($descrip, $grupoCliente);
					}
				}
				*/
			}
		}

		function getInformacionVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$trannum = $this->input->post('trannum');

				$this->load->model('xcaja_model');
				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}

		function insertarProductoVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$um            = $this->input->post('um');
				$idbin         = $this->input->post('idbin');
				$precio        = $this->input->post('precio');
				$idbatch       = $this->input->post('idbatch');
				$trannum       = $this->input->post('trannum');
				$tipotax       = $this->input->post('tipotax');
				$idclase       = $this->input->post('idclase');
				$cantidad      = $this->input->post('cantidad');
				$descuento     = $this->input->post('descuento');
				$idcatalogo    = $this->input->post('idcatalogo');
				$idproducto    = $this->input->post('idproducto');
				$costounitario = $this->input->post('costounitario');
				$idcentro      = $this->session->userdata('idcentrouser');
				$idworker      = $this->session->userdata('idEmpleadoUser');

				$this->load->model('xcaja_model');
				$idrec = $this->xcaja_model->getProductoVenta($trannum, $idproducto);

				if($idrec == false){
					$this->xcaja_model->insertarProductoVenta($idproducto, $cantidad, $trannum, $idclase, $precio, $costounitario, $descuento, $idbin, $idbatch, $um, $idcentro, $idworker, $tipotax);
				}else{
					$this->xcaja_model->modificarCantidadVenta($idrec, $idproducto, $idcentro, $cantidad);
				}

				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}

		function modificarProductoVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$trannum    = $this->input->post('trannum');
				$cantidad   = $this->input->post('cantidad');
				$idproducto = $this->input->post('idproducto');
				$idcentro   = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model');
				$idrec = $this->xcaja_model->getProductoVenta($trannum, $idproducto);
				$this->xcaja_model->modificarCantidadVenta($idrec, $idproducto, $idcentro, $cantidad);
				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}

		function eliminarProductoVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$idrec      = $this->input->post('idrec');
				$trannum    = $this->input->post('trannum');
				$cantidad   = $this->input->post('cantidad');
				$idproducto = $this->input->post('idproducto');
				$idcentro   = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model');
				$this->xcaja_model->eliminarProductoVenta($idrec, $idproducto, $idcentro, $cantidad);
				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}

		function modificarCantidadVenta(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$idrec      = $this->input->post('idrec');
				$trannum    = $this->input->post('trannum');
				$cantidad   = $this->input->post('cantidad');
				$idproducto = $this->input->post('idproducto');
				$idcentro   = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model');
				$this->xcaja_model->modificarCantidadVenta($idrec, $idproducto, $idcentro, $cantidad);
				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}

		function setNuevaCantidad(){
			if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
			}else{
				$idrec      = $this->input->post('idrec');
				$trannum    = $this->input->post('trannum');
				$cantidad   = $this->input->post('cantidad');
				$idproducto = $this->input->post('idproducto');
				$idcentro   = $this->session->userdata('idcentrouser');

				$this->load->model('xcaja_model');
				$this->xcaja_model->setNuevaCantidad($idrec, $idproducto, $idcentro, $cantidad);
				$array = $this->xcaja_model->getInformacionVenta($trannum);

				echo json_encode($array);
			}
		}
	}
?>