<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

    class Versa_crm extends CI_Controller{
        
        function __construct(){
            parent::__construct();
        }
        
        function mantenimiento_cuentas($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
				redirect('CerrarSesion');
            }else{
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);

				$this->data['direccion'] = $controlador.'/'.$funcion;  
				$this->load->model('global_model');
				$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				
				$this->load->view('mantenimiento_cuentas', $this->data);
			}
		}

        function getCuentasCSV() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $this->load->model('versacrm_model');
                $informacion = $this->versacrm_model->getCuentasCSV();

                if ($informacion != false){
                    $archivoTxt = fopen("ClientesNotion.csv",'w+');
                    
                    $array = array(
                        'Cliente',
                        'Nombre Comercial',
                        'NRC',
                        'Dirección',
                        'Teléfono',
                        'Servidor'
                    );

                    $contenidoHeader = implode(';', $array);
                    fwrite($archivoTxt, $contenidoHeader);
                    fwrite($archivoTxt, "\r\n");

                    foreach($informacion as $info){
                        $array = array(
                            $info->descrip,
                            $info->ncomercial,
                            $info->nrc,
                            $info->direccion,
                            $info->telefono,
                            $info->servidor
                        );

                        $contenidoHeader = implode(';', $array);
                        fwrite($archivoTxt, $contenidoHeader);
                        fwrite($archivoTxt, "\r\n");
                    }

                    fclose($archivoTxt);

                    $fileCSV = "ClientesNotion.csv";
                    if(file_exists($fileCSV)){
                        header('Content-Description: File Transfer');
                        header('Content-Type: application/octet-stream');
                        header('Content-Disposition: attachment; filename="'.basename($fileCSV).'"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($fileCSV));
                        readfile($fileCSV);
                        
                        unlink($fileCSV);
                        exit;
                    }
                }
            }
        }
           
        function getCuentas(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $this->load->model('versacrm_model');
                $informacion = $this->versacrm_model->getCuentas();

                $array = array();
                foreach( $informacion as $info ) { 
                    $array[] = array(
                        'idrnum'      => $info->idrnum,
                        'idaccount'   => $info->idaccount,
                        'descrip'     => $info->descrip,
                        'ncomercial'  => $info->ncomercial,
                        'server_name' => $info->server_name,
                        'nrc'         => $info->nrc,
                        'numcontrato' => $this->versacrm_model->getInformacionContrato($info->idcontrato),
                        'direccion'   => $info->direccion,
                        'telefono'    => $info->telefono,
                        'fechain'     => $info->fechain,
                        'fechavence'  => $info->fechavence,
                        'estadoT'     => $info->estadoT
                    );
                }

                echo json_encode($array);
            }
        }

        function getClientesSinCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $this->load->model('versacrm_model');$this->load->model('cliente_model');
                $cuentas = $this->versacrm_model->getCuentas();
                $clientes = $this->cliente_model->viewClienteActivo();
                
                $array_clientes = array();
                $i=0;
                if($clientes!=false){
                    foreach($clientes as $client){
                        $encontro = 0;
                         foreach($cuentas as $count){
                             if(trim($client->nrc)==trim($count->nrc)){
                                 $encontro++;
                             }
                         }
                        if($encontro==0){
                            $array_clientes[$i] = array(
                                "idauxi" => $client->idauxi,
                                "descrip" => $client->descrip,
                                "nrc" => $client->nrc,
                                "direccion" => $client->direccion,
                            );
                            $i++;
                        }
                    }
                }
                
                echo json_encode($array_clientes);
            }
        }

        function getDatasourcesForms() {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $this->load->model('cliente_model');
                $this->load->model('versacrm_model');
                
                $infoServers  = $this->versacrm_model->getNamesServers();
                $infoClientes = $this->cliente_model->viewClienteActivo();
                
                $clientes = array();
                if ( $infoClientes != false ) {
                    foreach ( $infoClientes as $infoC ) {
                        $clientes[] = array(
                            "id"      => $infoC->idauxi,
                            "descrip" => $infoC->descrip,
                        );
                    }
                }
                
                $servers = array();
                if ( $infoServers != false ) {
                    foreach ( $infoServers as $infoS ) {
                        $servers[] = array(
                            "id"      => $infoS->server_name,
                            "descrip" => $infoS->server_name,
                        );
                    }
                }
                
                echo json_encode(array(
                    'clientes' => $clientes,
                    'servers'  => $servers,
                ));
            }
        }

        function getListadoServidores () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $nameServer = $this->input->post('nameserver');

                $this->load->model('versacrm_model');
                $infoServers  = $this->versacrm_model->getListadoServidores($nameServer);
                
                $array = array();
                if ( $infoServers != false ) {
                    foreach ( $infoServers as $infoS ) {
                        $array[] = array(
                            "id"      => $infoS->dbp1,
                            "descrip" => $infoS->dbp1,
                        );
                    }
                }
                
                echo json_encode($array);
            }
        }

        function getListadoContratos () {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
                $idcps = $this->input->post('idcps');

                $this->load->model('versacrm_model');
                $infoContratos  = $this->versacrm_model->getListadoContratos($idcps);
                
                $array = array();
                if ( $infoContratos != false ) {
                    foreach ( $infoContratos as $infoC ) {
                        $array[] = array(
                            "id"      => $infoC->trannum,
                            "descrip" => 'Nº ' . $infoC->trannum . ' | ' . $infoC->descrip,
                        );
                    }
                }
                
                echo json_encode($array);
            }
        }
        
        function adicionarCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => "Adicionar Cuenta"
                );
                $this->session->set_userdata($resultAppName);
                $this->load->model('empleado_model');$this->load->model('versacrm_model');
                $this->data['gzips'] = $this->empleado_model->getZips();
                $this->data['servidores'] = $this->versacrm_model->getServidores();

                $this->load->view('new_cuenta', $this->data);
            }
        }
        
        function adicionarCuentaCliente($idauxi){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('login/cerrar_sesion');
            }else{
                $resultAppName = array(
                    'namePage' => "Adicionar Cuenta"
                );
				$this->session->set_userdata($resultAppName);
                $this->load->model('empleado_model');$this->load->model('cliente_model');
                $this->load->model('versacrm_model');
                $this->data['gzips'] = $this->empleado_model->getZips();
                $this->data['info'] = $this->cliente_model->callRegistro2($idauxi);
                $this->data['servidores'] = $this->versacrm_model->getServidores();
                
                $this->load->view('new_cuenta_client', $this->data);
            }
        }
        
        function updateCuenta($idrnum){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('login/cerrar_sesion');
            }else{
                $estado_cliente = array(
                    'namePage' => "Modificar Cuenta N°".$idrnum
                );
                $this->load->model('empleado_model');
                $this->load->model('versacrm_model');
                
                $this->data['gzips'] = $this->empleado_model->getZips();
                $this->data['registro'] = $this->versacrm_model->infoCuenta($idrnum);
                $this->data['servidores'] = $this->versacrm_model->getServidores();
                $this->load->view('form_update_cuenta', $this->data);
            }
        }
        
        function insertCuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $num_cuenta = $_POST["num_cuenta"];
                $name_empresa = $_POST["name_empresa"];
                $name_comercial = $_POST["name_comercial"];
                $num_registro = $_POST["num_registro"];
                $direccion = $_POST["direccion"];
                $departament = $_POST["departament"];
                $fec_ingresa = $_POST["fec_ingresa"];
                $fec_vence = $_POST["fec_vence"];
                $telefono = $_POST["telefono"];
                $correo = $_POST["correo"];
                $name_server  = $_POST["name_server"];
                $num_servidor = $_POST["num_servidor"];
                $name_bdd = $_POST["name_bdd"];
                $usuario = $_POST["usuario"];
                $contrasena = $_POST["contrasena"];
                $notas = $_POST["notas"];
                $estado = $_POST["estado"];

                $inputEcommerce = $_POST["inputEcommerce"];

                if(isset($_FILES["inputLogoEcommerce"])){
                    $infoFile = $_FILES["inputLogoEcommerce"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    $nameImagen = "";

                    if($nameDocument != ""){
                        $nameDocument = str_replace(" ", "_", $nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputFileImg')){
                            $nameImagen = $nameDocument;
                        }
                    }
                }

                $this->load->model('versacrm_model');

                $informacion = $this->versacrm_model->insertCuenta($num_cuenta, $name_empresa, $name_comercial, $num_registro, $direccion, $departament, $fec_ingresa, $fec_vence, $telefono, $correo, $name_server, $num_servidor, $name_bdd, $usuario, $contrasena, $notas, $estado, $inputEcommerce, $nameImagen);
                echo json_encode($informacion);
            }
        }
        
        function update_cuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                $idrnum = $_POST["idrnum"];
                $num_cuenta = $_POST["num_cuenta"];
                $name_empresa = $_POST["name_empresa"];
                $name_comercial = $_POST["name_comercial"];
                $num_registro = $_POST["num_registro"];
                $direccion = $_POST["direccion"];
                $departament = $_POST["departament"];
                $fec_ingresa = $_POST["fec_ingresa"];
                $fec_vence = $_POST["fec_vence"];
                $telefono = $_POST["telefono"];
                $correo = $_POST["correo"];
                $name_server = $_POST["name_server"];
                $num_servidor = $_POST["num_servidor"];
                $name_bdd = $_POST["name_bdd"];
                $usuario = $_POST["usuario"];
                $contrasena = $_POST["contrasena"];
                $notas = $_POST["notas"];
                $estado = $_POST["estado"];
                $inputEcommerce = $_POST["inputEcommerce"];
                $idcps = $_POST["inputCodeCliente"];
                $maxsuc = $_POST["inputLimitSuc"];
                $maxcajas = $_POST["inputLimitCajas"];
                $maxusuarios = $_POST["inputLimitUsuarios"];
                $idcontrato = $_POST["inputContrato"];
                $moneda = $_POST["inputMoneda"];

                if(isset($_FILES["inputLogoEcommerce"])){
                    $infoFile = $_FILES["inputLogoEcommerce"];
                    $nameDocument = $infoFile["name"];
                    $documentTemp = $infoFile['tmp_name'];
                    $nameImagen = "";

                    if($nameDocument != ""){
                        $nameDocument = str_replace(" ", "_", $nameDocument);
                        
                        $config['upload_path'] = "doc_cuentas/".$this->session->userdata('dirDocuments')."/";
                        $config['file_name'] = $nameDocument;
                        $config['over_write'] = "TRUE";
                        $config['allowed_types'] = "*";
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        
                        if($this->upload->do_upload('inputFileImg')){
                            $nameImagen = $nameDocument;
                        }
                    }
                }

                $this->load->model('versacrm_model');
                $informacion = $this->versacrm_model->updateCuenta($idrnum,$num_cuenta, $name_empresa, $name_comercial, $num_registro, $direccion, $departament, $fec_ingresa, $fec_vence, $telefono, $correo, $name_server, $num_servidor, $name_bdd, $usuario, $contrasena, $notas, $estado, $inputEcommerce, $nameImagen, $idcps, $maxsuc, $maxcajas, $maxusuarios, $idcontrato, $moneda);
                
                echo json_encode($informacion);
            }
        }
        
        function update_datecuenta(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('login/cerrar_sesion');
            }else{
                
                $idcuentas = $this->input->post("cuentas");
                $date = $this->input->post("date");
                $this->load->model('versacrm_model');
                $this->versacrm_model->update_datecuenta($idcuentas,$date);
                $informacion = $this->versacrm_model->getCuentas();
                echo json_encode($informacion);
            }
        }
           
        function mantenimiento_aplicaciones_crm($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);

				$this->data['direccion'] = $controlador.'/'.$funcion;  
				$this->load->model('global_model');
				$this->load->model('versacrm_model');
				$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['menuName'] = $this->versacrm_model->getMenuHeaders();
				
				$this->load->view('mantenimiento_aplicaciones_crm', $this->data);
			}
		}
        
        function getMenus(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $this->load->model("versacrm_model");
                $encabezados = $this->versacrm_model->viewMenu();
                $cuerpo = $this->versacrm_model->viewApps();
                $i=0;
                $array = array();
                if($encabezados!=false)
                {
                    foreach($encabezados as $dat){
                        foreach($cuerpo as $det){
                            if($dat->descripcion ==$det->menuname){
                                if($det->menutype != 1){
                                    $appname = $det->appname;
                                }else{
                                    $appname = "";
                                }
                                $array[$i] = array(
                                    "idapp" => $det->idapp,
                                    "menutype" => $det->menutype,
                                    "menuname" => $dat->descripcion,
                                    "menuorder" => $det->menuorder,
                                    "descrip" => $det->descrip,
                                    "appname" => $appname,
                                    "appoptions" => $det->appoptions
                                );
                                $i++;
                                
                                foreach($cuerpo as $det2){
                                    if($det2->idapphd == $det->idapp){
                                        $array[$i] = array(
                                            "idapp" => $det2->idapp,
                                            "menutype" => $det2->menutype,
                                            "menuname" => $dat->descripcion,
                                            "menuorder" => $det2->menuorder,
                                            "descrip" => $det2->descrip,
                                            "appname" => $det2->appname,
                                            "appoptions" => $det2->appoptions
                                        );
                                        $i++;
                                    }
                                }
                            }
                        }
                    }
                }
                echo json_encode($array);
            }
        }
        
        function menu_selected(){
            $id_header = $this->input->post('id_header');
            $filter = array( 'idmenu_principal_crm' => $id_header );
            $this->session->set_userdata($filter);
            echo json_encode($this->session->userdata('idmenu_principal_crm'));
        }
        
        function newApp($id, $tipo_app){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$resultAppName = array(
					'namePage' => 'Adicionar Aplicaciones'
				);
				$this->session->set_userdata($resultAppName);
				
                if($tipo_app == 0){
                    $this->load->model('versacrm_model');
                    $data['menuAppName'] = $this->versacrm_model->menuAppName($id);
                    $data['optionApp'] = 0;
                    $this->load->view('new_aplicacion_crm', $data);
                }elseif($tipo_app == 1){
                    $this->load->model('versacrm_model');
                    $data['menuAppName'] = $this->versacrm_model->menuAppName($id);
                    $data['optionApp'] = 1;
                    $this->load->view('new_aplicacion_crm', $data);
                }elseif($tipo_app == 2){
                    $this->load->model('versacrm_model');
                    $data['menuAppName'] = $this->versacrm_model->menuHeadAppName($id);
                    $data['optionApp'] = 2;
                    $this->load->view('new_aplicacion_crm', $data);
                }
            }
        }
        
        function registrarApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])  || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $saveNext = $this->input->post("saveNext");
                    if($saveNext=="true"){
                        $filter = array( 'add_ciclica_app' => "1" );
                        $this->session->set_userdata($filter);
                    }else{
                        $filter = array( 'add_ciclica_app' => "" );
                        $this->session->set_userdata($filter);
                    }
                        
                    $tipoM = $this->input->post('tipoM');
                    $idAppH = $this->input->post('idAppH');
                    $idMenu = $this->input->post("idMenu");
                    $descrip = $this->input->post("descrip");
                    $appname = $this->input->post("appname");
                    $menuname = $this->input->post("menuname");
                    $opciones = $this->input->post("opciones");
                    $menuorder = $this->input->post("menuorder");
                    $img = $this->input->post("imgen");
                    $notas = $this->input->post("notas");
                    $esta = $this->input->post("estado");
                    $option = $this->input->post("saveNext");
                    $whodidit = $this->session->userdata('iduser');
                    $raya = $this->input->post("raya");
                    if($esta == "true"){
                        $estado = 1;
                    }else{
                        $estado = 0;
                    }
                    $this->load->model("versacrm_model");
                    $nameimagen = $this->versacrm_model->insertApp($idMenu, $descrip, $appname, $menuname, $opciones, $menuorder, $img, $notas, $estado, $option, $whodidit, $raya, $tipoM, $idAppH,$saveNext);
                    $imgSplit = explode(".", $nameimagen);
                    $archivo = 'imagen';
                    $config['upload_path'] =  "img_cuentas/".$this->session->userdata('diraccount')."/";
                    $config['file_name'] = $imgSplit[0];
                    $config['over_write'] = "TRUE";
                    $config['allowed_types'] = "gif|jpg|jpeg|png";
                    $this->load->library('upload', $config);
                    $this->upload->do_upload($archivo); 
                    if($saveNext=="true"){
                        redirect('Adicionar_Aplicacion/'.$idMenu.'/'.$tipoM);
                    }else{
                        redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                    }
                }else{
                    redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                }
            }
        }
     
        function modificarApp($id, $tipo_app){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $resultAppName = array(
                    'namePage' => 'Actualizar Aplicacion N° '.$id
				);
				$this->session->set_userdata($resultAppName);
                $this->load->model("versacrm_model");
                $this->data['appData'] = $this->versacrm_model->callRegistro($id);
                $this->data['tipo_app'] = $tipo_app;
                $this->data['menuName'] = $this->versacrm_model->getMenuHeaders();
                $this->load->view("form_update_application_crm", $this->data);
            }
        }
        
        function actualizarApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                if($this->input->post()){
                    $tipoM = $this->input->post('tipoM');
                    if($tipoM != 1){
                        $appname = $this->input->post("appname");
                    }else{
                        $appname = "";
                    }
                    $idAppH = $this->input->post('idAppH');
                    $idapp = $this->input->post("idapp");
                    $descrip = $this->input->post("descrip");
                    $menuname = $this->input->post("menuname");
                    $opciones = $this->input->post("opciones");
                    $menuorder = $this->input->post("menuorder");
                    $img = $this->input->post("imgen");
                    $notas = $this->input->post("notas");
                    $estado = $this->input->post("estado");
                    $whodidit = $this->session->userdata('iduser');
                    $raya = $this->input->post("raya");
                    $this->load->model("versacrm_model");
                    $nameimagen = $this->versacrm_model->updateApp($idapp, $descrip, $appname, $menuname, $opciones, $menuorder, $img, $notas, $estado, $whodidit, $raya, $tipoM, $idAppH);
                }else{
                    redirect('Mantenimiento_Apps/'.$this->session->userdata('iddApp'));
                }
            }
        }
        
        function eliminarApp(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
				$idapp = $this->input->post('idapp');
				
                $this->load->model("versacrm_model");
                $array = $this->versacrm_model->deleteApp($idapp);
				echo json_encode($array);
            }
        }
        
        function desarrollo_aplicaciones($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);

				$this->data['direccion'] = $controlador.'/'.$funcion;  
				$this->load->model('global_model');
				$this->load->model('versacrm_model');
				$this->load->model('empleado_model');
				$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['aplicaciones'] = $this->versacrm_model->viewApps();
                $this->data['empleados']  = $this->empleado_model->viewEmpleActivo();
                $this->load->view('mantenimiento_desarrollo_apps_crm', $this->data);
			}
		}
        
        function insertCaso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $app = $this->input->post('app');
                $fecha_caso = $this->input->post('fecha_caso');
                $detalle_caso = $this->input->post('detalle_caso');
                $estado_caso = $this->input->post('estado_caso');
                $worker_caso = $this->input->post('worker_caso');
                $asignado_caso = $this->input->post('asignado_caso');
                $cierre_caso = $this->input->post('cierre_caso');
                $notas_caso = $this->input->post('notas_caso');
                $prioridad = $this->input->post('prioridad');
                $time_caso = $this->input->post('time_caso');
                $prioridad = strtolower($prioridad);
                $priority = "";
                switch($prioridad){
                    case "alta":
                        $priority = 1;
                        break;
                    case "media":
                        $priority = 2;
                        break;
                    case "baja":
                        $priority=3;
                        break;
                    default: 
                        $priority = "";
                        break;
                }
				
                $this->load->model("versacrm_model");
                $this->versacrm_model->insertCaso($app, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso,$priority,$time_caso);
                $data = $this->versacrm_model->getCasosApp($app);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                echo json_encode($array);
            }
        }
        
        function getCasos(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $app = $this->input->post('app');
                $this->load->model("versacrm_model");
                $data = $this->versacrm_model->getCasosApp($app);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                
                echo json_encode($array);
            }
        }
        
        function updateCaso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $app = $this->input->post('app');
                $fecha_caso = $this->input->post('fecha_caso');
                $detalle_caso = $this->input->post('detalle_caso');
                $estado_caso = $this->input->post('estado_caso');
                $worker_caso = $this->input->post('worker_caso');
                $asignado_caso = $this->input->post('asignado_caso');
                $cierre_caso = $this->input->post('cierre_caso');
                $notas_caso = $this->input->post('notas_caso');
                $prioridad = $this->input->post('prioridad');
                $time_caso = $this->input->post('time_caso');
                $prioridad = strtolower($prioridad);
                $priority = "";
                switch($prioridad){
                    case "alta":
                        $priority = 1;
                        break;
                    case "media":
                        $priority = 2;
                        break;
                    case "baja":
                        $priority=3;
                        break;
                    default: 
                        $priority = "";
                        break;
                }
                
                $this->load->model("versacrm_model");
                $this->versacrm_model->updateCaso($idrec, $app, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso, $priority, $time_caso);
                
                $data = $this->versacrm_model->getCasosApp($app);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                echo json_encode($array);
            }
        }
        
        function deleteCaso(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite']) || $this->session->userdata("profile") != 1){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $app = $this->input->post('app');
                $this->load->model("versacrm_model");
                $this->versacrm_model->deleteCaso($idrec);
                
                $data = $this->versacrm_model->getCasosApp($app);
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                echo json_encode($array);
            }
        }
        
        function eco_task($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);

				$this->data['direccion'] = $controlador.'/'.$funcion;  
				$this->load->model('global_model');
				$this->load->model('versacrm_model');
				$this->load->model('empleado_model');
				$direccion = $controlador.'/'.$funcion;
				$this->data['formatos'] = $this->global_model->getFormatosImpresionGrid($direccion);
				$this->data['aplicaciones'] = $this->versacrm_model->viewApps();
                $this->data['empleados']  = $this->empleado_model->viewEmpleActivo();
                $this->data['empleados_task']  = $this->versacrm_model->getColaboradoresTask();
                $this->load->view('mantenimiento_ecotask', $this->data);
			}
		}
        
        function getCasosUser(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $iduser = $this->input->post('iduser');
                $this->load->model("versacrm_model");
                if($iduser!= 99999){
                    $data = $this->versacrm_model->getCasosUser($iduser);
                }else{
                    $data = $this->versacrm_model->getAllCasosUser();
                }
                $array = array();
                $i=0;
                
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        
                        
                        $text_estado = "";
                        switch($dat->estado){
                            case 0: $text_estado = "Ingresado"; break;
                            case 1: $text_estado = "Asignado"; break;
                            case 2: $text_estado = "Terminado"; break;
                            case 9: $text_estado = "Anulado"; break;
                        }
                        
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "text_estado" => $text_estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                
                echo json_encode($array);
            }
        }
        
        function updateCasoUser(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $iduser = $this->input->post('iduser');
                $fecha_caso = $this->input->post('fecha_caso');
                $detalle_caso = $this->input->post('detalle_caso');
                $estado_caso = $this->input->post('estado_caso');
                $worker_caso = $this->input->post('worker_caso');
                $asignado_caso = $this->input->post('asignado_caso');
                $cierre_caso = $this->input->post('cierre_caso');
                $notas_caso = $this->input->post('notas_caso');
                $prioridad = $this->input->post('prioridad');
                $time_caso = $this->input->post('time_caso');
                $prioridad = strtolower($prioridad);
                $priority = "";
                switch($prioridad){
                    case "alta":
                        $priority = 1;
                        break;
                    case "media":
                        $priority = 2;
                        break;
                    case "baja":
                        $priority=3;
                        break;
                    default: 
                        $priority = "";
                        break;
                }
                
                $this->load->model("versacrm_model");
                $this->versacrm_model->updateCasoUser($idrec, $fecha_caso, $detalle_caso, $estado_caso, $worker_caso, $asignado_caso, $cierre_caso, $notas_caso, $priority, $time_caso);
            
                if($iduser!= 99999){
                    $data = $this->versacrm_model->getCasosUser($iduser);
                }else{
                    $data = $this->versacrm_model->getAllCasosUser();
                }
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $text_estado = "";
                        switch($dat->estado){
                            case 0: $text_estado = "Ingresado"; break;
                            case 1: $text_estado = "Asignado"; break;
                            case 2: $text_estado = "Terminado"; break;
                            case 9: $text_estado = "Anulado"; break;
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "estatus" => $dat->estado,
                            "text_estado" => $text_estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                echo json_encode($array);
            }
        }
        
        function deleteCasoUser(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idrec = $this->input->post('idrec');
                $iduser = $this->input->post('iduser');
                $this->load->model("versacrm_model");
                $this->versacrm_model->deleteCaso($idrec);
                if($iduser!= 99999){
                    $data = $this->versacrm_model->getCasosUser($iduser);
                }else{
                    $data = $this->versacrm_model->getAllCasosUser();
                }
                $array = array();
                $i=0;
                if($data!=false){
                    foreach($data as $dat){
                        if($dat->fasigna!="0000-00-00"){
                            $fasigna = $dat->fasigna;
                        }else{
                            $fasigna = "";
                        }
                        if($dat->fdeliver!="0000-00-00"){
                            $fdeliver = $dat->fdeliver;
                        }else{
                            $fdeliver = "";
                        }
                        if($dat->ndeliver!="0000-00-00"){
                            $ndeliver = $dat->ndeliver;
                        }else{
                            $ndeliver = "";
                        }
                        $text_estado = "";
                        switch($dat->estado){
                            case 0: $text_estado = "Ingresado"; break;
                            case 1: $text_estado = "Asignado"; break;
                            case 2: $text_estado = "Terminado"; break;
                            case 9: $text_estado = "Anulado"; break;
                        }
                        $array[$i] = [
                            "idrec" => $dat->idrec,
                            "idapp" => "$dat->idapp", 
                            "fecha" => "$dat->fecha",
                            "detalle" => "$dat->detalle", 
                            "idworker" => "$dat->idworker", 
                            "fasigna" => "$fasigna",
                            "fdeliver" => "$fdeliver",
                            "ndeliver" => "$ndeliver",
                            "estado" => "$dat->estado",
                            "text_estado" => $text_estado,
                            "estatus" => $dat->estado,
                            "ndeliver" => $dat->ndeliver,
                            "horas" => $dat->horas,
                            "prioridad" => $dat->prioridad,
                        ];
                        $i++;
                    }    
                }
                echo json_encode($array);
            }
        }
        
        function retotalizar($idApp){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
				redirect('CerrarSesion');
            }else{
				$controlador = $this->uri->segment(1);
				$funcion = $this->uri->segment(2);
				
				$this->load->model('configuracion_model');
				$appName = $this->configuracion_model->getAppName($idApp);
				$resultAppName = array(
                    'iddApp' => $idApp,
                    'appName' => $appName,
                    'namePage' => $appName,
                );
				$this->session->set_userdata($resultAppName);
                $this->load->view('retotalizar_transacciones');
			}
        }
        
        function update_totaliza(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');

                $this->load->model("gerencia_model");
                $array = $this->gerencia_model->getTransVentasXPeriodo($fechaini, $fechafin, $idcentro, $idcaja);

                echo json_encode($array);
             }
        }
        function corre_totaliza100(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $fechaini = $this->input->post('fechaini');
                $fechafin = $this->input->post('fechafin');
                $idcentro = $this->input->post('idcentro');
                $idcaja   = $this->input->post('idcaja');

                $this->load->model("gerencia_model");
                $cant = $this->gerencia_model->corre_totaliza100($fechaini, $fechafin, $idcentro, $idcaja);
                echo json_encode($cant);
             }
        }
        
        #------------------------------------   CONTROL ANALISIS DE ACCESOS --------------------------------------------------------------
        public function getHCuentas()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->load->model("versacrm_model");
                $fi = $this->input->post('fechai');
                $ff = $this->input->post('fechaf');
                $data = $this->versacrm_model->getHCuentas($fi, $ff);
                $Datos = [];
                if ($data->num_rows() > 0) {
                    foreach ($data->result() as $dato) {
                        $Datos[] = array(
                            'idcuenta' => $dato->idaccount,
                            'cuenta' => $dato->cuenta,
                            'fecha' => $dato->fecha,
                            '0' => (int)$dato->login00,
                            '1' => (int)$dato->login01,
                            '2' => (int)$dato->login02,
                            '3' => (int)$dato->login03,
                            '4' => (int)$dato->login04,
                            '5' => (int)$dato->login05,
                            '6' => (int)$dato->login06,
                            '7' => (int)$dato->login07,
                            '8' => (int)$dato->login08,
                            '9' => (int)$dato->login09,
                            '10' => (int)$dato->login10,
                            '11' => (int)$dato->login11,
                            '12' => (int)$dato->login12,
                            '13' => (int)$dato->login13,
                            '14' => (int)$dato->login14,
                            '15' => (int)$dato->login15,
                            '16' => (int)$dato->login16,
                            '17' => (int)$dato->login17,
                            '18' => (int)$dato->login18,
                            '19' => (int)$dato->login19,
                            '20' => (int)$dato->login20,
                            '21' => (int)$dato->login21,
                            '22' => (int)$dato->login22,
                            '23' => (int)$dato->login23,
                        );
                    }
                }
                $datA[] = array('valido' => true, 'datos' => $Datos);
                echo json_encode($datA);
            }
        }
        #------------------------------------   FIN CONTROL ANALISIS DE ACCESOS ----------------------------------------------------------

        function setResizeImages(){
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            }else{
                $idaccount = $this->input->post('idaccount');
                $info = $this->listarArchivos('img_cuentas/img_'.$idaccount.'/');

                echo json_encode($info);
            }
        }

        function redimensionar_imagen($nombreimg, $rutaimg, $xmax, $ymax){  
            $ext = explode(".", $nombreimg);  
            $ext = $ext[count($ext)-1];  
          
            if($ext == "jpg" || $ext == "jpeg" || $ext == "JPEG" || $ext == "JPG")  
                $imagen = imagecreatefromjpeg($rutaimg);  
            elseif($ext == "png" || $ext == "PNG")  
                $imagen = imagecreatefrompng($rutaimg);  
            elseif($ext == "gif" || $ext == "GIF")  
                $imagen = imagecreatefromgif($rutaimg);  
              
            $x = imagesx($imagen);  
            $y = imagesy($imagen);  
              
            if($x <= $xmax && $y <= $ymax){
                // echo "<center>Esta imagen ya esta optimizada para los maximos que deseas.<center>";
                return $imagen;  
            }
          
            if($x >= $y){
                $nuevax = $xmax;  
                $nuevay = $nuevax * $y / $x;  
            }else{
                $nuevay = $ymax;  
                $nuevax = $x / $y * $nuevay;  
            }
              
            $img2 = imagecreatetruecolor($nuevax, $nuevay);  
            imagecopyresized($img2, $imagen, 0, 0, 0, 0, floor($nuevax), floor($nuevay), $x, $y);

            // echo "<center>La imagen se ha optimizado correctamente.</center>";
            return $img2;   
        }

        function listarArchivos($path){
            // Abrimos la carpeta que nos pasan como parámetro
            $dir = opendir($path);
            // Leo todos los ficheros de la carpeta
            while($elemento = readdir($dir)){
                // Tratamos los elementos . y .. que tienen todas las carpetas
                if($elemento != "." && $elemento != ".."){
                    // Si es una carpeta
                    if(!is_dir($path.$elemento)){
                        $pos = strpos($elemento, 'imgProduct');

                        if($pos !== false){
                            $imagen_optimizada = $this->redimensionar_imagen($elemento, $path.$elemento, 300, 300);
                            imagejpeg($imagen_optimizada, $path.$elemento);
                        }
                    }
                    
                    // if(is_dir($path.$elemento)){
                    //     // Muestro la carpeta
                    //     echo "<p><strong>CARPETA: ". $elemento ."</strong></p><br />";
                    // // Si es un fichero
                    // }else{
                    //     // Muestro el fichero
                    //     echo $elemento."<br/>";
                    // }
                }
            }
        }
        
        function getServidoresCRM()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $this->load->model("versacrm_model");
                $data = $this->versacrm_model->getServidoresCRM();

                $array[] = array('valido' => true, 'datos' => $data);
                echo json_encode($array);
            }
        }

        function getAnalisisDatos()
        {
            if($this->session->userdata('userDB') == "" || $this->session->userdata('passDB') == "" || $this->session->userdata('serverDB') == "" || $this->session->userdata('nameDB') == "" || !$this->session->userdata('userDB') || !$this->session->userdata('passDB') || !$this->session->userdata('serverDB') || !$this->session->userdata('nameDB') || !isset($_SESSION['menuType']) || !isset($_SESSION['menuSite'])){
                redirect('CerrarSesion');
            } else {
                $fi = $this->input->post('fechai');
                $ff = $this->input->post('fechaf');
                $nameServer = $this->input->post('nameServer');
                
                $this->load->model("versacrm_model");
                $data = $this->versacrm_model->getAnalisisDatos($nameServer, $fi, $ff);

                $array[] = array('valido' => true, 'datos' => $data);
                echo json_encode($array);
            }
        }
	}
?>